/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/extensions/v1alpha1"
	"github.com/gardener/gardener/pkg/client/extensions/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ExtensionsV1alpha1Interface interface {
	RESTClient() rest.Interface
	BackupBucketsGetter
	BackupEntriesGetter
	ClustersGetter
	ContainerRuntimesGetter
	ControlPlanesGetter
	ExtensionsGetter
	InfrastructuresGetter
	NetworksGetter
	OperatingSystemConfigsGetter
	WorkersGetter
}

// ExtensionsV1alpha1Client is used to interact with features provided by the extensions.gardener.cloud group.
type ExtensionsV1alpha1Client struct {
	restClient rest.Interface
}

func (c *ExtensionsV1alpha1Client) BackupBuckets() BackupBucketInterface {
	return newBackupBuckets(c)
}

func (c *ExtensionsV1alpha1Client) BackupEntries() BackupEntryInterface {
	return newBackupEntries(c)
}

func (c *ExtensionsV1alpha1Client) Clusters() ClusterInterface {
	return newClusters(c)
}

func (c *ExtensionsV1alpha1Client) ContainerRuntimes(namespace string) ContainerRuntimeInterface {
	return newContainerRuntimes(c, namespace)
}

func (c *ExtensionsV1alpha1Client) ControlPlanes(namespace string) ControlPlaneInterface {
	return newControlPlanes(c, namespace)
}

func (c *ExtensionsV1alpha1Client) Extensions(namespace string) ExtensionInterface {
	return newExtensions(c, namespace)
}

func (c *ExtensionsV1alpha1Client) Infrastructures(namespace string) InfrastructureInterface {
	return newInfrastructures(c, namespace)
}

func (c *ExtensionsV1alpha1Client) Networks(namespace string) NetworkInterface {
	return newNetworks(c, namespace)
}

func (c *ExtensionsV1alpha1Client) OperatingSystemConfigs(namespace string) OperatingSystemConfigInterface {
	return newOperatingSystemConfigs(c, namespace)
}

func (c *ExtensionsV1alpha1Client) Workers(namespace string) WorkerInterface {
	return newWorkers(c, namespace)
}

// NewForConfig creates a new ExtensionsV1alpha1Client for the given config.
func NewForConfig(c *rest.Config) (*ExtensionsV1alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &ExtensionsV1alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new ExtensionsV1alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ExtensionsV1alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ExtensionsV1alpha1Client for the given RESTClient.
func New(c rest.Interface) *ExtensionsV1alpha1Client {
	return &ExtensionsV1alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ExtensionsV1alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
