/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/core/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ShootLister helps list Shoots.
type ShootLister interface {
	// List lists all Shoots in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Shoot, err error)
	// Shoots returns an object that can list and get Shoots.
	Shoots(namespace string) ShootNamespaceLister
	ShootListerExpansion
}

// shootLister implements the ShootLister interface.
type shootLister struct {
	indexer cache.Indexer
}

// NewShootLister returns a new ShootLister.
func NewShootLister(indexer cache.Indexer) ShootLister {
	return &shootLister{indexer: indexer}
}

// List lists all Shoots in the indexer.
func (s *shootLister) List(selector labels.Selector) (ret []*v1alpha1.Shoot, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Shoot))
	})
	return ret, err
}

// Shoots returns an object that can list and get Shoots.
func (s *shootLister) Shoots(namespace string) ShootNamespaceLister {
	return shootNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ShootNamespaceLister helps list and get Shoots.
type ShootNamespaceLister interface {
	// List lists all Shoots in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Shoot, err error)
	// Get retrieves the Shoot from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Shoot, error)
	ShootNamespaceListerExpansion
}

// shootNamespaceLister implements the ShootNamespaceLister
// interface.
type shootNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Shoots in the indexer for a given namespace.
func (s shootNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Shoot, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Shoot))
	})
	return ret, err
}

// Get retrieves the Shoot from the indexer for a given namespace and name.
func (s shootNamespaceLister) Get(name string) (*v1alpha1.Shoot, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("shoot"), name)
	}
	return obj.(*v1alpha1.Shoot), nil
}
