/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/core/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// BackupEntryLister helps list BackupEntries.
type BackupEntryLister interface {
	// List lists all BackupEntries in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.BackupEntry, err error)
	// BackupEntries returns an object that can list and get BackupEntries.
	BackupEntries(namespace string) BackupEntryNamespaceLister
	BackupEntryListerExpansion
}

// backupEntryLister implements the BackupEntryLister interface.
type backupEntryLister struct {
	indexer cache.Indexer
}

// NewBackupEntryLister returns a new BackupEntryLister.
func NewBackupEntryLister(indexer cache.Indexer) BackupEntryLister {
	return &backupEntryLister{indexer: indexer}
}

// List lists all BackupEntries in the indexer.
func (s *backupEntryLister) List(selector labels.Selector) (ret []*v1alpha1.BackupEntry, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.BackupEntry))
	})
	return ret, err
}

// BackupEntries returns an object that can list and get BackupEntries.
func (s *backupEntryLister) BackupEntries(namespace string) BackupEntryNamespaceLister {
	return backupEntryNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// BackupEntryNamespaceLister helps list and get BackupEntries.
type BackupEntryNamespaceLister interface {
	// List lists all BackupEntries in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.BackupEntry, err error)
	// Get retrieves the BackupEntry from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.BackupEntry, error)
	BackupEntryNamespaceListerExpansion
}

// backupEntryNamespaceLister implements the BackupEntryNamespaceLister
// interface.
type backupEntryNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all BackupEntries in the indexer for a given namespace.
func (s backupEntryNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.BackupEntry, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.BackupEntry))
	})
	return ret, err
}

// Get retrieves the BackupEntry from the indexer for a given namespace and name.
func (s backupEntryNamespaceLister) Get(name string) (*v1alpha1.BackupEntry, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("backupentry"), name)
	}
	return obj.(*v1alpha1.BackupEntry), nil
}
