# Contract: `BackupBucket` resource

The Gardener project features a sub-project called [etcd-backup-restore](https://github.com/gardener/etcd-backup-restore) to take periodic backups of etcd backing Shoot clusters. It demands the bucket (or its equivalent in different object store providers) to be created and configured externally with appropriate credentials. The `BackupBucket` resource takes this responsibility in Gardener.

Before introducing the `BackupBucket` extension resource Gardener was using Terraform in order to create and manage these provider-specific resources (e.g., see [here](https://github.com/gardener/gardener/tree/0.27.0/charts/seed-terraformer/charts/aws-backup)).
Now, Gardener commissions an external, provider-specific controller to take over this task. You can also refer to backupInfra proposal documentation to get idea about how the transition was done and understand the resource in broader scope.

## What is the scope of bucket?

A bucket will be provisioned per `Seed`. So, backup of every `Shoot` created on that `Seed` will be stored under different shoot specific prefix under the bucket.
For the backup of the `Shoot` rescheduled on different `Seed` it will continue to use the same bucket.

## What is the lifespan of `BackupBucket`?

The bucket associated with `BackupBucket` will be created at creation of `Seed`. And as per current implementation, it will be deleted on deletion of `Seed` and there isn't any `BackupEntry` resource associated with it.

In the future, we plan to introduce schedule for `BackupBucket` the deletion logic for `BackupBucket` resource, which will reschedule the it on different available `Seed`, on deletion or failure of health check for current associated `seed`. In that case, `BackupBucket` will be deleted only if there isn't any schedulable `Seed` available and there isn't any associated `BackupEntry` resource.

## What needs to be implemented to support a new infrastructure provider?

As part of the seed flow Gardener will create a special CRD in the seed cluster that needs to be reconciled by an extension controller, for example:

```yaml
---
apiVersion: extensions.gardener.cloud/v1alpha1
kind: BackupBucket
metadata:
  name: foo
spec:
  type: azure
  providerConfig:
    <some-optional-provider-specific-backupbucket-configuration>
  region: eu-west-1
  secretRef:
    name: backupprovider
    namespace: shoot--foo--bar
```

The `.spec.secretRef` contains a reference to the provider secret pointing to the account that shall be used to create the needed resources. This provider secret will be configured
by Gardener operator in the `Seed` resource and propagated over there by seed controller.

After your controller has created the required bucket, if required it generates the secret to access the objects in buckets and put reference to it in `status`. This secret is
supposed to be used by Gardener or eventually `BackupEntry` resource and etcd-backup-restore component to backup the etcd.

In order to support a new infrastructure provider you need to write a controller that watches all `BackupBucket`s with `.spec.type=<my-provider-name>`. You can take a look at the below referenced example implementation for the Azure provider.

## References and additional resources

* [`BackupBucket` API Reference](https://gardener.cloud/api-reference/extensions/#extensions.gardener.cloud/v1alpha1.BackupBucket)
* [Exemplary implementation for the Azure provider](https://github.com/gardener/gardener-extension-provider-azure/tree/master/pkg/controller/backupbucket)
* [`BackupEntry` resource documentation](./backupentry.md)
* [Shared bucket proposal](../proposals/02-backupinfra.md)
