/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/external-dns-management/pkg/apis/dns/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// DNSProviderLister helps list DNSProviders.
type DNSProviderLister interface {
	// List lists all DNSProviders in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.DNSProvider, err error)
	// DNSProviders returns an object that can list and get DNSProviders.
	DNSProviders(namespace string) DNSProviderNamespaceLister
	DNSProviderListerExpansion
}

// dNSProviderLister implements the DNSProviderLister interface.
type dNSProviderLister struct {
	indexer cache.Indexer
}

// NewDNSProviderLister returns a new DNSProviderLister.
func NewDNSProviderLister(indexer cache.Indexer) DNSProviderLister {
	return &dNSProviderLister{indexer: indexer}
}

// List lists all DNSProviders in the indexer.
func (s *dNSProviderLister) List(selector labels.Selector) (ret []*v1alpha1.DNSProvider, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.DNSProvider))
	})
	return ret, err
}

// DNSProviders returns an object that can list and get DNSProviders.
func (s *dNSProviderLister) DNSProviders(namespace string) DNSProviderNamespaceLister {
	return dNSProviderNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// DNSProviderNamespaceLister helps list and get DNSProviders.
type DNSProviderNamespaceLister interface {
	// List lists all DNSProviders in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.DNSProvider, err error)
	// Get retrieves the DNSProvider from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.DNSProvider, error)
	DNSProviderNamespaceListerExpansion
}

// dNSProviderNamespaceLister implements the DNSProviderNamespaceLister
// interface.
type dNSProviderNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all DNSProviders in the indexer for a given namespace.
func (s dNSProviderNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.DNSProvider, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.DNSProvider))
	})
	return ret, err
}

// Get retrieves the DNSProvider from the indexer for a given namespace and name.
func (s dNSProviderNamespaceLister) Get(name string) (*v1alpha1.DNSProvider, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("dnsprovider"), name)
	}
	return obj.(*v1alpha1.DNSProvider), nil
}
