package fyne

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

const imgName = "dot.png"

var imgBytes = []byte{137, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 8, 2, 0, 0, 0, 144, 119, 83, 222, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 11, 19, 0, 0, 11, 19, 1, 0, 154, 156, 24, 0, 0, 0, 7, 116, 73, 77, 69, 7, 226, 6, 5, 15, 49, 19, 102, 121, 20, 234, 0, 0, 0, 29, 105, 84, 88, 116, 67, 111, 109, 109, 101, 110, 116, 0, 0, 0, 0, 0, 67, 114, 101, 97, 116, 101, 100, 32, 119, 105, 116, 104, 32, 71, 73, 77, 80, 100, 46, 101, 7, 0, 0, 0, 12, 73, 68, 65, 84, 8, 215, 99, 248, 207, 192, 0, 0, 3, 1, 1, 0, 24, 221, 141, 176, 0, 0, 0, 0, 73, 69, 78, 68, 174, 66, 96, 130}

const imgGo = `&fyne.StaticResource{
	StaticName: "dot.png",
	StaticContent: []byte{
		137, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 8, 2, 0, 0, 0, 144, 119, 83, 222, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 11, 19, 0, 0, 11, 19, 1, 0, 154, 156, 24, 0, 0, 0, 7, 116, 73, 77, 69, 7, 226, 6, 5, 15, 49, 19, 102, 121, 20, 234, 0, 0, 0, 29, 105, 84, 88, 116, 67, 111, 109, 109, 101, 110, 116, 0, 0, 0, 0, 0, 67, 114, 101, 97, 116, 101, 100, 32, 119, 105, 116, 104, 32, 71, 73, 77, 80, 100, 46, 101, 7, 0, 0, 0, 12, 73, 68, 65, 84, 8, 215, 99, 248, 207, 192, 0, 0, 3, 1, 1, 0, 24, 221, 141, 176, 0, 0, 0, 0, 73, 69, 78, 68, 174, 66, 96, 130}}`

func TestToGo(t *testing.T) {
	res := NewStaticResource(imgName, imgBytes)

	assert.Equal(t, imgGo, res.GoString())
}

var result string

func BenchmarkToGo(b *testing.B) {
	var temp string
	b.ReportAllocs()
	for i := 0; i < b.N; i++ {
		res := NewStaticResource(imgName, imgBytes)
		temp = res.GoString()
	}

	result = temp
}
