// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package unicodedata

import "unicode"

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

// Mandatory Break
var BreakBK = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x000b, Hi: 0x000c, Stride: 1},
		{Lo: 0x2028, Hi: 0x2029, Stride: 1},
	},
	LatinOffset: 1,
}

// Carriage Return
var BreakCR = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x000d, Hi: 0x000d, Stride: 1},
	},
	LatinOffset: 1,
}

// Line Feed
var BreakLF = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x000a, Hi: 0x000a, Stride: 1},
	},
	LatinOffset: 1,
}

// Next Line
var BreakNL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0085, Hi: 0x0085, Stride: 1},
	},
	LatinOffset: 1,
}

// Space
var BreakSP = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0020, Hi: 0x0020, Stride: 1},
	},
	LatinOffset: 1,
}

// Numeric
var BreakNU = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0030, Hi: 0x0039, Stride: 1},
		{Lo: 0x0660, Hi: 0x0669, Stride: 1},
		{Lo: 0x066b, Hi: 0x066c, Stride: 1},
		{Lo: 0x06f0, Hi: 0x06f9, Stride: 1},
		{Lo: 0x07c0, Hi: 0x07c9, Stride: 1},
		{Lo: 0x0966, Hi: 0x096f, Stride: 1},
		{Lo: 0x09e6, Hi: 0x09ef, Stride: 1},
		{Lo: 0x0a66, Hi: 0x0a6f, Stride: 1},
		{Lo: 0x0ae6, Hi: 0x0aef, Stride: 1},
		{Lo: 0x0b66, Hi: 0x0b6f, Stride: 1},
		{Lo: 0x0be6, Hi: 0x0bef, Stride: 1},
		{Lo: 0x0c66, Hi: 0x0c6f, Stride: 1},
		{Lo: 0x0ce6, Hi: 0x0cef, Stride: 1},
		{Lo: 0x0d66, Hi: 0x0d6f, Stride: 1},
		{Lo: 0x0de6, Hi: 0x0def, Stride: 1},
		{Lo: 0x0e50, Hi: 0x0e59, Stride: 1},
		{Lo: 0x0ed0, Hi: 0x0ed9, Stride: 1},
		{Lo: 0x0f20, Hi: 0x0f29, Stride: 1},
		{Lo: 0x1040, Hi: 0x1049, Stride: 1},
		{Lo: 0x1090, Hi: 0x1099, Stride: 1},
		{Lo: 0x17e0, Hi: 0x17e9, Stride: 1},
		{Lo: 0x1810, Hi: 0x1819, Stride: 1},
		{Lo: 0x1946, Hi: 0x194f, Stride: 1},
		{Lo: 0x19d0, Hi: 0x19d9, Stride: 1},
		{Lo: 0x1a80, Hi: 0x1a89, Stride: 1},
		{Lo: 0x1a90, Hi: 0x1a99, Stride: 1},
		{Lo: 0x1b50, Hi: 0x1b59, Stride: 1},
		{Lo: 0x1bb0, Hi: 0x1bb9, Stride: 1},
		{Lo: 0x1c40, Hi: 0x1c49, Stride: 1},
		{Lo: 0x1c50, Hi: 0x1c59, Stride: 1},
		{Lo: 0xa620, Hi: 0xa629, Stride: 1},
		{Lo: 0xa8d0, Hi: 0xa8d9, Stride: 1},
		{Lo: 0xa900, Hi: 0xa909, Stride: 1},
		{Lo: 0xa9d0, Hi: 0xa9d9, Stride: 1},
		{Lo: 0xa9f0, Hi: 0xa9f9, Stride: 1},
		{Lo: 0xaa50, Hi: 0xaa59, Stride: 1},
		{Lo: 0xabf0, Hi: 0xabf9, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x104a0, Hi: 0x104a9, Stride: 1},
		{Lo: 0x10d30, Hi: 0x10d39, Stride: 1},
		{Lo: 0x11066, Hi: 0x1106f, Stride: 1},
		{Lo: 0x110f0, Hi: 0x110f9, Stride: 1},
		{Lo: 0x11136, Hi: 0x1113f, Stride: 1},
		{Lo: 0x111d0, Hi: 0x111d9, Stride: 1},
		{Lo: 0x112f0, Hi: 0x112f9, Stride: 1},
		{Lo: 0x11450, Hi: 0x11459, Stride: 1},
		{Lo: 0x114d0, Hi: 0x114d9, Stride: 1},
		{Lo: 0x11650, Hi: 0x11659, Stride: 1},
		{Lo: 0x116c0, Hi: 0x116c9, Stride: 1},
		{Lo: 0x11730, Hi: 0x11739, Stride: 1},
		{Lo: 0x118e0, Hi: 0x118e9, Stride: 1},
		{Lo: 0x11950, Hi: 0x11959, Stride: 1},
		{Lo: 0x11c50, Hi: 0x11c59, Stride: 1},
		{Lo: 0x11d50, Hi: 0x11d59, Stride: 1},
		{Lo: 0x11da0, Hi: 0x11da9, Stride: 1},
		{Lo: 0x16a60, Hi: 0x16a69, Stride: 1},
		{Lo: 0x16b50, Hi: 0x16b59, Stride: 1},
		{Lo: 0x1d7ce, Hi: 0x1d7ff, Stride: 1},
		{Lo: 0x1e140, Hi: 0x1e149, Stride: 1},
		{Lo: 0x1e2f0, Hi: 0x1e2f9, Stride: 1},
		{Lo: 0x1e950, Hi: 0x1e959, Stride: 1},
		{Lo: 0x1fbf0, Hi: 0x1fbf9, Stride: 1},
	},
	LatinOffset: 1,
}

// Alphabetic
var BreakAL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0023, Hi: 0x0026, Stride: 3},
		{Lo: 0x002a, Hi: 0x003c, Stride: 18},
		{Lo: 0x003d, Hi: 0x003e, Stride: 1},
		{Lo: 0x0040, Hi: 0x005a, Stride: 1},
		{Lo: 0x005e, Hi: 0x007a, Stride: 1},
		{Lo: 0x007e, Hi: 0x00a6, Stride: 40},
		{Lo: 0x00a9, Hi: 0x00ac, Stride: 3},
		{Lo: 0x00ae, Hi: 0x00af, Stride: 1},
		{Lo: 0x00b5, Hi: 0x00c0, Stride: 11},
		{Lo: 0x00c1, Hi: 0x00d6, Stride: 1},
		{Lo: 0x00d8, Hi: 0x00f6, Stride: 1},
		{Lo: 0x00f8, Hi: 0x02c6, Stride: 1},
		{Lo: 0x02ce, Hi: 0x02cf, Stride: 1},
		{Lo: 0x02d1, Hi: 0x02d7, Stride: 1},
		{Lo: 0x02dc, Hi: 0x02e0, Stride: 2},
		{Lo: 0x02e1, Hi: 0x02ff, Stride: 1},
		{Lo: 0x0370, Hi: 0x0377, Stride: 1},
		{Lo: 0x037a, Hi: 0x037d, Stride: 1},
		{Lo: 0x037f, Hi: 0x0384, Stride: 5},
		{Lo: 0x0385, Hi: 0x038a, Stride: 1},
		{Lo: 0x038c, Hi: 0x038e, Stride: 2},
		{Lo: 0x038f, Hi: 0x03a1, Stride: 1},
		{Lo: 0x03a3, Hi: 0x0482, Stride: 1},
		{Lo: 0x048a, Hi: 0x052f, Stride: 1},
		{Lo: 0x0531, Hi: 0x0556, Stride: 1},
		{Lo: 0x0559, Hi: 0x0588, Stride: 1},
		{Lo: 0x058d, Hi: 0x058e, Stride: 1},
		{Lo: 0x05c0, Hi: 0x05c3, Stride: 3},
		{Lo: 0x05f3, Hi: 0x05f4, Stride: 1},
		{Lo: 0x0600, Hi: 0x0608, Stride: 1},
		{Lo: 0x060e, Hi: 0x060f, Stride: 1},
		{Lo: 0x0620, Hi: 0x064a, Stride: 1},
		{Lo: 0x066d, Hi: 0x066f, Stride: 1},
		{Lo: 0x0671, Hi: 0x06d3, Stride: 1},
		{Lo: 0x06d5, Hi: 0x06dd, Stride: 8},
		{Lo: 0x06de, Hi: 0x06e5, Stride: 7},
		{Lo: 0x06e6, Hi: 0x06e9, Stride: 3},
		{Lo: 0x06ee, Hi: 0x06ef, Stride: 1},
		{Lo: 0x06fa, Hi: 0x070d, Stride: 1},
		{Lo: 0x070f, Hi: 0x0710, Stride: 1},
		{Lo: 0x0712, Hi: 0x072f, Stride: 1},
		{Lo: 0x074d, Hi: 0x07a5, Stride: 1},
		{Lo: 0x07b1, Hi: 0x07ca, Stride: 25},
		{Lo: 0x07cb, Hi: 0x07ea, Stride: 1},
		{Lo: 0x07f4, Hi: 0x07f7, Stride: 1},
		{Lo: 0x07fa, Hi: 0x0800, Stride: 6},
		{Lo: 0x0801, Hi: 0x0815, Stride: 1},
		{Lo: 0x081a, Hi: 0x0824, Stride: 10},
		{Lo: 0x0828, Hi: 0x0830, Stride: 8},
		{Lo: 0x0831, Hi: 0x083e, Stride: 1},
		{Lo: 0x0840, Hi: 0x0858, Stride: 1},
		{Lo: 0x085e, Hi: 0x0860, Stride: 2},
		{Lo: 0x0861, Hi: 0x086a, Stride: 1},
		{Lo: 0x08a0, Hi: 0x08b4, Stride: 1},
		{Lo: 0x08b6, Hi: 0x08c7, Stride: 1},
		{Lo: 0x08e2, Hi: 0x0904, Stride: 34},
		{Lo: 0x0905, Hi: 0x0939, Stride: 1},
		{Lo: 0x093d, Hi: 0x0950, Stride: 19},
		{Lo: 0x0958, Hi: 0x0961, Stride: 1},
		{Lo: 0x0970, Hi: 0x0980, Stride: 1},
		{Lo: 0x0985, Hi: 0x098c, Stride: 1},
		{Lo: 0x098f, Hi: 0x0990, Stride: 1},
		{Lo: 0x0993, Hi: 0x09a8, Stride: 1},
		{Lo: 0x09aa, Hi: 0x09b0, Stride: 1},
		{Lo: 0x09b2, Hi: 0x09b6, Stride: 4},
		{Lo: 0x09b7, Hi: 0x09b9, Stride: 1},
		{Lo: 0x09bd, Hi: 0x09ce, Stride: 17},
		{Lo: 0x09dc, Hi: 0x09dd, Stride: 1},
		{Lo: 0x09df, Hi: 0x09e1, Stride: 1},
		{Lo: 0x09f0, Hi: 0x09f1, Stride: 1},
		{Lo: 0x09f4, Hi: 0x09f8, Stride: 1},
		{Lo: 0x09fa, Hi: 0x09fc, Stride: 2},
		{Lo: 0x09fd, Hi: 0x0a05, Stride: 8},
		{Lo: 0x0a06, Hi: 0x0a0a, Stride: 1},
		{Lo: 0x0a0f, Hi: 0x0a10, Stride: 1},
		{Lo: 0x0a13, Hi: 0x0a28, Stride: 1},
		{Lo: 0x0a2a, Hi: 0x0a30, Stride: 1},
		{Lo: 0x0a32, Hi: 0x0a33, Stride: 1},
		{Lo: 0x0a35, Hi: 0x0a36, Stride: 1},
		{Lo: 0x0a38, Hi: 0x0a39, Stride: 1},
		{Lo: 0x0a59, Hi: 0x0a5c, Stride: 1},
		{Lo: 0x0a5e, Hi: 0x0a72, Stride: 20},
		{Lo: 0x0a73, Hi: 0x0a74, Stride: 1},
		{Lo: 0x0a76, Hi: 0x0a85, Stride: 15},
		{Lo: 0x0a86, Hi: 0x0a8d, Stride: 1},
		{Lo: 0x0a8f, Hi: 0x0a91, Stride: 1},
		{Lo: 0x0a93, Hi: 0x0aa8, Stride: 1},
		{Lo: 0x0aaa, Hi: 0x0ab0, Stride: 1},
		{Lo: 0x0ab2, Hi: 0x0ab3, Stride: 1},
		{Lo: 0x0ab5, Hi: 0x0ab9, Stride: 1},
		{Lo: 0x0abd, Hi: 0x0ad0, Stride: 19},
		{Lo: 0x0ae0, Hi: 0x0ae1, Stride: 1},
		{Lo: 0x0af0, Hi: 0x0af9, Stride: 9},
		{Lo: 0x0b05, Hi: 0x0b0c, Stride: 1},
		{Lo: 0x0b0f, Hi: 0x0b10, Stride: 1},
		{Lo: 0x0b13, Hi: 0x0b28, Stride: 1},
		{Lo: 0x0b2a, Hi: 0x0b30, Stride: 1},
		{Lo: 0x0b32, Hi: 0x0b33, Stride: 1},
		{Lo: 0x0b35, Hi: 0x0b39, Stride: 1},
		{Lo: 0x0b3d, Hi: 0x0b5c, Stride: 31},
		{Lo: 0x0b5d, Hi: 0x0b5f, Stride: 2},
		{Lo: 0x0b60, Hi: 0x0b61, Stride: 1},
		{Lo: 0x0b70, Hi: 0x0b77, Stride: 1},
		{Lo: 0x0b83, Hi: 0x0b85, Stride: 2},
		{Lo: 0x0b86, Hi: 0x0b8a, Stride: 1},
		{Lo: 0x0b8e, Hi: 0x0b90, Stride: 1},
		{Lo: 0x0b92, Hi: 0x0b95, Stride: 1},
		{Lo: 0x0b99, Hi: 0x0b9a, Stride: 1},
		{Lo: 0x0b9c, Hi: 0x0b9e, Stride: 2},
		{Lo: 0x0b9f, Hi: 0x0ba3, Stride: 4},
		{Lo: 0x0ba4, Hi: 0x0ba8, Stride: 4},
		{Lo: 0x0ba9, Hi: 0x0baa, Stride: 1},
		{Lo: 0x0bae, Hi: 0x0bb9, Stride: 1},
		{Lo: 0x0bd0, Hi: 0x0bf0, Stride: 32},
		{Lo: 0x0bf1, Hi: 0x0bf8, Stride: 1},
		{Lo: 0x0bfa, Hi: 0x0c05, Stride: 11},
		{Lo: 0x0c06, Hi: 0x0c0c, Stride: 1},
		{Lo: 0x0c0e, Hi: 0x0c10, Stride: 1},
		{Lo: 0x0c12, Hi: 0x0c28, Stride: 1},
		{Lo: 0x0c2a, Hi: 0x0c39, Stride: 1},
		{Lo: 0x0c3d, Hi: 0x0c58, Stride: 27},
		{Lo: 0x0c59, Hi: 0x0c5a, Stride: 1},
		{Lo: 0x0c60, Hi: 0x0c61, Stride: 1},
		{Lo: 0x0c78, Hi: 0x0c80, Stride: 1},
		{Lo: 0x0c85, Hi: 0x0c8c, Stride: 1},
		{Lo: 0x0c8e, Hi: 0x0c90, Stride: 1},
		{Lo: 0x0c92, Hi: 0x0ca8, Stride: 1},
		{Lo: 0x0caa, Hi: 0x0cb3, Stride: 1},
		{Lo: 0x0cb5, Hi: 0x0cb9, Stride: 1},
		{Lo: 0x0cbd, Hi: 0x0cde, Stride: 33},
		{Lo: 0x0ce0, Hi: 0x0ce1, Stride: 1},
		{Lo: 0x0cf1, Hi: 0x0cf2, Stride: 1},
		{Lo: 0x0d04, Hi: 0x0d0c, Stride: 1},
		{Lo: 0x0d0e, Hi: 0x0d10, Stride: 1},
		{Lo: 0x0d12, Hi: 0x0d3a, Stride: 1},
		{Lo: 0x0d3d, Hi: 0x0d4e, Stride: 17},
		{Lo: 0x0d4f, Hi: 0x0d54, Stride: 5},
		{Lo: 0x0d55, Hi: 0x0d56, Stride: 1},
		{Lo: 0x0d58, Hi: 0x0d61, Stride: 1},
		{Lo: 0x0d70, Hi: 0x0d78, Stride: 1},
		{Lo: 0x0d7a, Hi: 0x0d7f, Stride: 1},
		{Lo: 0x0d85, Hi: 0x0d96, Stride: 1},
		{Lo: 0x0d9a, Hi: 0x0db1, Stride: 1},
		{Lo: 0x0db3, Hi: 0x0dbb, Stride: 1},
		{Lo: 0x0dbd, Hi: 0x0dc0, Stride: 3},
		{Lo: 0x0dc1, Hi: 0x0dc6, Stride: 1},
		{Lo: 0x0df4, Hi: 0x0e4f, Stride: 91},
		{Lo: 0x0f00, Hi: 0x0f05, Stride: 5},
		{Lo: 0x0f13, Hi: 0x0f15, Stride: 2},
		{Lo: 0x0f16, Hi: 0x0f17, Stride: 1},
		{Lo: 0x0f1a, Hi: 0x0f1f, Stride: 1},
		{Lo: 0x0f2a, Hi: 0x0f33, Stride: 1},
		{Lo: 0x0f36, Hi: 0x0f38, Stride: 2},
		{Lo: 0x0f40, Hi: 0x0f47, Stride: 1},
		{Lo: 0x0f49, Hi: 0x0f6c, Stride: 1},
		{Lo: 0x0f88, Hi: 0x0f8c, Stride: 1},
		{Lo: 0x0fc0, Hi: 0x0fc5, Stride: 1},
		{Lo: 0x0fc7, Hi: 0x0fcc, Stride: 1},
		{Lo: 0x0fce, Hi: 0x0fcf, Stride: 1},
		{Lo: 0x0fd4, Hi: 0x0fd8, Stride: 1},
		{Lo: 0x104c, Hi: 0x104f, Stride: 1},
		{Lo: 0x10a0, Hi: 0x10c5, Stride: 1},
		{Lo: 0x10c7, Hi: 0x10cd, Stride: 6},
		{Lo: 0x10d0, Hi: 0x10ff, Stride: 1},
		{Lo: 0x1200, Hi: 0x1248, Stride: 1},
		{Lo: 0x124a, Hi: 0x124d, Stride: 1},
		{Lo: 0x1250, Hi: 0x1256, Stride: 1},
		{Lo: 0x1258, Hi: 0x125a, Stride: 2},
		{Lo: 0x125b, Hi: 0x125d, Stride: 1},
		{Lo: 0x1260, Hi: 0x1288, Stride: 1},
		{Lo: 0x128a, Hi: 0x128d, Stride: 1},
		{Lo: 0x1290, Hi: 0x12b0, Stride: 1},
		{Lo: 0x12b2, Hi: 0x12b5, Stride: 1},
		{Lo: 0x12b8, Hi: 0x12be, Stride: 1},
		{Lo: 0x12c0, Hi: 0x12c2, Stride: 2},
		{Lo: 0x12c3, Hi: 0x12c5, Stride: 1},
		{Lo: 0x12c8, Hi: 0x12d6, Stride: 1},
		{Lo: 0x12d8, Hi: 0x1310, Stride: 1},
		{Lo: 0x1312, Hi: 0x1315, Stride: 1},
		{Lo: 0x1318, Hi: 0x135a, Stride: 1},
		{Lo: 0x1360, Hi: 0x1362, Stride: 2},
		{Lo: 0x1363, Hi: 0x137c, Stride: 1},
		{Lo: 0x1380, Hi: 0x1399, Stride: 1},
		{Lo: 0x13a0, Hi: 0x13f5, Stride: 1},
		{Lo: 0x13f8, Hi: 0x13fd, Stride: 1},
		{Lo: 0x1401, Hi: 0x167f, Stride: 1},
		{Lo: 0x1681, Hi: 0x169a, Stride: 1},
		{Lo: 0x16a0, Hi: 0x16ea, Stride: 1},
		{Lo: 0x16ee, Hi: 0x16f8, Stride: 1},
		{Lo: 0x1700, Hi: 0x170c, Stride: 1},
		{Lo: 0x170e, Hi: 0x1711, Stride: 1},
		{Lo: 0x1720, Hi: 0x1731, Stride: 1},
		{Lo: 0x1740, Hi: 0x1751, Stride: 1},
		{Lo: 0x1760, Hi: 0x176c, Stride: 1},
		{Lo: 0x176e, Hi: 0x1770, Stride: 1},
		{Lo: 0x17d9, Hi: 0x17f0, Stride: 23},
		{Lo: 0x17f1, Hi: 0x17f9, Stride: 1},
		{Lo: 0x1800, Hi: 0x1801, Stride: 1},
		{Lo: 0x1807, Hi: 0x180a, Stride: 3},
		{Lo: 0x1820, Hi: 0x1878, Stride: 1},
		{Lo: 0x1880, Hi: 0x1884, Stride: 1},
		{Lo: 0x1887, Hi: 0x18a8, Stride: 1},
		{Lo: 0x18aa, Hi: 0x18b0, Stride: 6},
		{Lo: 0x18b1, Hi: 0x18f5, Stride: 1},
		{Lo: 0x1900, Hi: 0x191e, Stride: 1},
		{Lo: 0x1940, Hi: 0x19e0, Stride: 160},
		{Lo: 0x19e1, Hi: 0x1a16, Stride: 1},
		{Lo: 0x1a1e, Hi: 0x1a1f, Stride: 1},
		{Lo: 0x1b05, Hi: 0x1b33, Stride: 1},
		{Lo: 0x1b45, Hi: 0x1b4b, Stride: 1},
		{Lo: 0x1b5c, Hi: 0x1b61, Stride: 5},
		{Lo: 0x1b62, Hi: 0x1b6a, Stride: 1},
		{Lo: 0x1b74, Hi: 0x1b7c, Stride: 1},
		{Lo: 0x1b83, Hi: 0x1ba0, Stride: 1},
		{Lo: 0x1bae, Hi: 0x1baf, Stride: 1},
		{Lo: 0x1bba, Hi: 0x1be5, Stride: 1},
		{Lo: 0x1bfc, Hi: 0x1c23, Stride: 1},
		{Lo: 0x1c4d, Hi: 0x1c4f, Stride: 1},
		{Lo: 0x1c5a, Hi: 0x1c7d, Stride: 1},
		{Lo: 0x1c80, Hi: 0x1c88, Stride: 1},
		{Lo: 0x1c90, Hi: 0x1cba, Stride: 1},
		{Lo: 0x1cbd, Hi: 0x1cc7, Stride: 1},
		{Lo: 0x1cd3, Hi: 0x1ce9, Stride: 22},
		{Lo: 0x1cea, Hi: 0x1cec, Stride: 1},
		{Lo: 0x1cee, Hi: 0x1cf3, Stride: 1},
		{Lo: 0x1cf5, Hi: 0x1cf6, Stride: 1},
		{Lo: 0x1cfa, Hi: 0x1d00, Stride: 6},
		{Lo: 0x1d01, Hi: 0x1dbf, Stride: 1},
		{Lo: 0x1e00, Hi: 0x1f15, Stride: 1},
		{Lo: 0x1f18, Hi: 0x1f1d, Stride: 1},
		{Lo: 0x1f20, Hi: 0x1f45, Stride: 1},
		{Lo: 0x1f48, Hi: 0x1f4d, Stride: 1},
		{Lo: 0x1f50, Hi: 0x1f57, Stride: 1},
		{Lo: 0x1f59, Hi: 0x1f5f, Stride: 2},
		{Lo: 0x1f60, Hi: 0x1f7d, Stride: 1},
		{Lo: 0x1f80, Hi: 0x1fb4, Stride: 1},
		{Lo: 0x1fb6, Hi: 0x1fc4, Stride: 1},
		{Lo: 0x1fc6, Hi: 0x1fd3, Stride: 1},
		{Lo: 0x1fd6, Hi: 0x1fdb, Stride: 1},
		{Lo: 0x1fdd, Hi: 0x1fef, Stride: 1},
		{Lo: 0x1ff2, Hi: 0x1ff4, Stride: 1},
		{Lo: 0x1ff6, Hi: 0x1ffc, Stride: 1},
		{Lo: 0x1ffe, Hi: 0x2017, Stride: 25},
		{Lo: 0x2022, Hi: 0x2023, Stride: 1},
		{Lo: 0x2038, Hi: 0x203e, Stride: 6},
		{Lo: 0x203f, Hi: 0x2043, Stride: 1},
		{Lo: 0x204a, Hi: 0x2055, Stride: 1},
		{Lo: 0x2057, Hi: 0x2061, Stride: 5},
		{Lo: 0x2062, Hi: 0x2064, Stride: 1},
		{Lo: 0x2070, Hi: 0x2071, Stride: 1},
		{Lo: 0x2075, Hi: 0x207c, Stride: 1},
		{Lo: 0x2080, Hi: 0x2085, Stride: 5},
		{Lo: 0x2086, Hi: 0x208c, Stride: 1},
		{Lo: 0x2090, Hi: 0x209c, Stride: 1},
		{Lo: 0x2100, Hi: 0x2102, Stride: 1},
		{Lo: 0x2104, Hi: 0x2106, Stride: 2},
		{Lo: 0x2107, Hi: 0x2108, Stride: 1},
		{Lo: 0x210a, Hi: 0x2112, Stride: 1},
		{Lo: 0x2114, Hi: 0x2115, Stride: 1},
		{Lo: 0x2117, Hi: 0x2120, Stride: 1},
		{Lo: 0x2123, Hi: 0x212a, Stride: 1},
		{Lo: 0x212c, Hi: 0x2153, Stride: 1},
		{Lo: 0x2156, Hi: 0x215a, Stride: 1},
		{Lo: 0x215c, Hi: 0x215d, Stride: 1},
		{Lo: 0x215f, Hi: 0x216c, Stride: 13},
		{Lo: 0x216d, Hi: 0x216f, Stride: 1},
		{Lo: 0x217a, Hi: 0x2188, Stride: 1},
		{Lo: 0x218a, Hi: 0x218b, Stride: 1},
		{Lo: 0x219a, Hi: 0x21d1, Stride: 1},
		{Lo: 0x21d3, Hi: 0x21d5, Stride: 2},
		{Lo: 0x21d6, Hi: 0x21ff, Stride: 1},
		{Lo: 0x2201, Hi: 0x2204, Stride: 3},
		{Lo: 0x2205, Hi: 0x2206, Stride: 1},
		{Lo: 0x2209, Hi: 0x220a, Stride: 1},
		{Lo: 0x220c, Hi: 0x220e, Stride: 1},
		{Lo: 0x2210, Hi: 0x2214, Stride: 4},
		{Lo: 0x2216, Hi: 0x2219, Stride: 1},
		{Lo: 0x221b, Hi: 0x221c, Stride: 1},
		{Lo: 0x2221, Hi: 0x2222, Stride: 1},
		{Lo: 0x2224, Hi: 0x2226, Stride: 2},
		{Lo: 0x222d, Hi: 0x222f, Stride: 2},
		{Lo: 0x2230, Hi: 0x2233, Stride: 1},
		{Lo: 0x2238, Hi: 0x223b, Stride: 1},
		{Lo: 0x223e, Hi: 0x2247, Stride: 1},
		{Lo: 0x2249, Hi: 0x224b, Stride: 1},
		{Lo: 0x224d, Hi: 0x2251, Stride: 1},
		{Lo: 0x2253, Hi: 0x225f, Stride: 1},
		{Lo: 0x2262, Hi: 0x2263, Stride: 1},
		{Lo: 0x2268, Hi: 0x2269, Stride: 1},
		{Lo: 0x226c, Hi: 0x226d, Stride: 1},
		{Lo: 0x2270, Hi: 0x2281, Stride: 1},
		{Lo: 0x2284, Hi: 0x2285, Stride: 1},
		{Lo: 0x2288, Hi: 0x2294, Stride: 1},
		{Lo: 0x2296, Hi: 0x2298, Stride: 1},
		{Lo: 0x229a, Hi: 0x22a4, Stride: 1},
		{Lo: 0x22a6, Hi: 0x22be, Stride: 1},
		{Lo: 0x22c0, Hi: 0x22ee, Stride: 1},
		{Lo: 0x22f0, Hi: 0x2307, Stride: 1},
		{Lo: 0x230c, Hi: 0x2311, Stride: 1},
		{Lo: 0x2313, Hi: 0x2319, Stride: 1},
		{Lo: 0x231c, Hi: 0x2328, Stride: 1},
		{Lo: 0x232b, Hi: 0x23ef, Stride: 1},
		{Lo: 0x23f4, Hi: 0x2426, Stride: 1},
		{Lo: 0x2440, Hi: 0x244a, Stride: 1},
		{Lo: 0x24ff, Hi: 0x254c, Stride: 77},
		{Lo: 0x254d, Hi: 0x254f, Stride: 1},
		{Lo: 0x2575, Hi: 0x257f, Stride: 1},
		{Lo: 0x2590, Hi: 0x2591, Stride: 1},
		{Lo: 0x2596, Hi: 0x259f, Stride: 1},
		{Lo: 0x25a2, Hi: 0x25aa, Stride: 8},
		{Lo: 0x25ab, Hi: 0x25b1, Stride: 1},
		{Lo: 0x25b4, Hi: 0x25b5, Stride: 1},
		{Lo: 0x25b8, Hi: 0x25bb, Stride: 1},
		{Lo: 0x25be, Hi: 0x25bf, Stride: 1},
		{Lo: 0x25c2, Hi: 0x25c5, Stride: 1},
		{Lo: 0x25c9, Hi: 0x25ca, Stride: 1},
		{Lo: 0x25cc, Hi: 0x25cd, Stride: 1},
		{Lo: 0x25d2, Hi: 0x25e1, Stride: 1},
		{Lo: 0x25e6, Hi: 0x25ee, Stride: 1},
		{Lo: 0x25f0, Hi: 0x25ff, Stride: 1},
		{Lo: 0x2604, Hi: 0x2607, Stride: 3},
		{Lo: 0x2608, Hi: 0x260a, Stride: 2},
		{Lo: 0x260b, Hi: 0x260d, Stride: 1},
		{Lo: 0x2610, Hi: 0x2613, Stride: 1},
		{Lo: 0x2619, Hi: 0x2620, Stride: 7},
		{Lo: 0x2621, Hi: 0x2638, Stride: 1},
		{Lo: 0x263c, Hi: 0x263f, Stride: 1},
		{Lo: 0x2641, Hi: 0x2643, Stride: 2},
		{Lo: 0x2644, Hi: 0x265f, Stride: 1},
		{Lo: 0x2662, Hi: 0x2666, Stride: 4},
		{Lo: 0x266b, Hi: 0x266e, Stride: 3},
		{Lo: 0x2670, Hi: 0x267e, Stride: 1},
		{Lo: 0x2680, Hi: 0x269d, Stride: 1},
		{Lo: 0x26a0, Hi: 0x26bc, Stride: 1},
		{Lo: 0x26ce, Hi: 0x26e2, Stride: 20},
		{Lo: 0x26e4, Hi: 0x26e7, Stride: 1},
		{Lo: 0x2705, Hi: 0x2707, Stride: 1},
		{Lo: 0x270e, Hi: 0x2756, Stride: 1},
		{Lo: 0x2758, Hi: 0x275a, Stride: 1},
		{Lo: 0x2761, Hi: 0x2765, Stride: 4},
		{Lo: 0x2766, Hi: 0x2767, Stride: 1},
		{Lo: 0x2794, Hi: 0x27c4, Stride: 1},
		{Lo: 0x27c7, Hi: 0x27e5, Stride: 1},
		{Lo: 0x27f0, Hi: 0x2982, Stride: 1},
		{Lo: 0x2999, Hi: 0x29d7, Stride: 1},
		{Lo: 0x29dc, Hi: 0x29fb, Stride: 1},
		{Lo: 0x29fe, Hi: 0x2b54, Stride: 1},
		{Lo: 0x2b5a, Hi: 0x2b73, Stride: 1},
		{Lo: 0x2b76, Hi: 0x2b95, Stride: 1},
		{Lo: 0x2b97, Hi: 0x2c2e, Stride: 1},
		{Lo: 0x2c30, Hi: 0x2c5e, Stride: 1},
		{Lo: 0x2c60, Hi: 0x2cee, Stride: 1},
		{Lo: 0x2cf2, Hi: 0x2cf3, Stride: 1},
		{Lo: 0x2cfd, Hi: 0x2d00, Stride: 3},
		{Lo: 0x2d01, Hi: 0x2d25, Stride: 1},
		{Lo: 0x2d27, Hi: 0x2d2d, Stride: 6},
		{Lo: 0x2d30, Hi: 0x2d67, Stride: 1},
		{Lo: 0x2d6f, Hi: 0x2d80, Stride: 17},
		{Lo: 0x2d81, Hi: 0x2d96, Stride: 1},
		{Lo: 0x2da0, Hi: 0x2da6, Stride: 1},
		{Lo: 0x2da8, Hi: 0x2dae, Stride: 1},
		{Lo: 0x2db0, Hi: 0x2db6, Stride: 1},
		{Lo: 0x2db8, Hi: 0x2dbe, Stride: 1},
		{Lo: 0x2dc0, Hi: 0x2dc6, Stride: 1},
		{Lo: 0x2dc8, Hi: 0x2dce, Stride: 1},
		{Lo: 0x2dd0, Hi: 0x2dd6, Stride: 1},
		{Lo: 0x2dd8, Hi: 0x2dde, Stride: 1},
		{Lo: 0x2e16, Hi: 0x2e1a, Stride: 4},
		{Lo: 0x2e1b, Hi: 0x2e1e, Stride: 3},
		{Lo: 0x2e1f, Hi: 0x2e2f, Stride: 16},
		{Lo: 0x2e32, Hi: 0x2e35, Stride: 3},
		{Lo: 0x2e36, Hi: 0x2e39, Stride: 1},
		{Lo: 0x2e3f, Hi: 0x2e4b, Stride: 12},
		{Lo: 0x2e4d, Hi: 0x2e50, Stride: 3},
		{Lo: 0x2e51, Hi: 0x2e52, Stride: 1},
		{Lo: 0x4dc0, Hi: 0x4dff, Stride: 1},
		{Lo: 0xa4d0, Hi: 0xa4fd, Stride: 1},
		{Lo: 0xa500, Hi: 0xa60c, Stride: 1},
		{Lo: 0xa610, Hi: 0xa61f, Stride: 1},
		{Lo: 0xa62a, Hi: 0xa62b, Stride: 1},
		{Lo: 0xa640, Hi: 0xa66e, Stride: 1},
		{Lo: 0xa673, Hi: 0xa67e, Stride: 11},
		{Lo: 0xa67f, Hi: 0xa69d, Stride: 1},
		{Lo: 0xa6a0, Hi: 0xa6ef, Stride: 1},
		{Lo: 0xa6f2, Hi: 0xa700, Stride: 14},
		{Lo: 0xa701, Hi: 0xa7bf, Stride: 1},
		{Lo: 0xa7c2, Hi: 0xa7ca, Stride: 1},
		{Lo: 0xa7f5, Hi: 0xa801, Stride: 1},
		{Lo: 0xa803, Hi: 0xa805, Stride: 1},
		{Lo: 0xa807, Hi: 0xa80a, Stride: 1},
		{Lo: 0xa80c, Hi: 0xa822, Stride: 1},
		{Lo: 0xa828, Hi: 0xa82b, Stride: 1},
		{Lo: 0xa830, Hi: 0xa837, Stride: 1},
		{Lo: 0xa839, Hi: 0xa840, Stride: 7},
		{Lo: 0xa841, Hi: 0xa873, Stride: 1},
		{Lo: 0xa882, Hi: 0xa8b3, Stride: 1},
		{Lo: 0xa8f2, Hi: 0xa8fb, Stride: 1},
		{Lo: 0xa8fd, Hi: 0xa8fe, Stride: 1},
		{Lo: 0xa90a, Hi: 0xa925, Stride: 1},
		{Lo: 0xa930, Hi: 0xa946, Stride: 1},
		{Lo: 0xa95f, Hi: 0xa984, Stride: 37},
		{Lo: 0xa985, Hi: 0xa9b2, Stride: 1},
		{Lo: 0xa9c1, Hi: 0xa9c6, Stride: 1},
		{Lo: 0xa9ca, Hi: 0xa9cd, Stride: 1},
		{Lo: 0xa9cf, Hi: 0xa9de, Stride: 15},
		{Lo: 0xa9df, Hi: 0xaa00, Stride: 33},
		{Lo: 0xaa01, Hi: 0xaa28, Stride: 1},
		{Lo: 0xaa40, Hi: 0xaa42, Stride: 1},
		{Lo: 0xaa44, Hi: 0xaa4b, Stride: 1},
		{Lo: 0xaa5c, Hi: 0xaae0, Stride: 132},
		{Lo: 0xaae1, Hi: 0xaaea, Stride: 1},
		{Lo: 0xaaf2, Hi: 0xaaf4, Stride: 1},
		{Lo: 0xab01, Hi: 0xab06, Stride: 1},
		{Lo: 0xab09, Hi: 0xab0e, Stride: 1},
		{Lo: 0xab11, Hi: 0xab16, Stride: 1},
		{Lo: 0xab20, Hi: 0xab26, Stride: 1},
		{Lo: 0xab28, Hi: 0xab2e, Stride: 1},
		{Lo: 0xab30, Hi: 0xab6b, Stride: 1},
		{Lo: 0xab70, Hi: 0xabe2, Stride: 1},
		{Lo: 0xfb00, Hi: 0xfb06, Stride: 1},
		{Lo: 0xfb13, Hi: 0xfb17, Stride: 1},
		{Lo: 0xfb29, Hi: 0xfb50, Stride: 39},
		{Lo: 0xfb51, Hi: 0xfbc1, Stride: 1},
		{Lo: 0xfbd3, Hi: 0xfd3d, Stride: 1},
		{Lo: 0xfd50, Hi: 0xfd8f, Stride: 1},
		{Lo: 0xfd92, Hi: 0xfdc7, Stride: 1},
		{Lo: 0xfdf0, Hi: 0xfdfb, Stride: 1},
		{Lo: 0xfdfd, Hi: 0xfe70, Stride: 115},
		{Lo: 0xfe71, Hi: 0xfe74, Stride: 1},
		{Lo: 0xfe76, Hi: 0xfefc, Stride: 1},
		{Lo: 0xffe8, Hi: 0xffee, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x10000, Hi: 0x1000b, Stride: 1},
		{Lo: 0x1000d, Hi: 0x10026, Stride: 1},
		{Lo: 0x10028, Hi: 0x1003a, Stride: 1},
		{Lo: 0x1003c, Hi: 0x1003d, Stride: 1},
		{Lo: 0x1003f, Hi: 0x1004d, Stride: 1},
		{Lo: 0x10050, Hi: 0x1005d, Stride: 1},
		{Lo: 0x10080, Hi: 0x100fa, Stride: 1},
		{Lo: 0x10107, Hi: 0x10133, Stride: 1},
		{Lo: 0x10137, Hi: 0x1018e, Stride: 1},
		{Lo: 0x10190, Hi: 0x1019c, Stride: 1},
		{Lo: 0x101a0, Hi: 0x101d0, Stride: 48},
		{Lo: 0x101d1, Hi: 0x101fc, Stride: 1},
		{Lo: 0x10280, Hi: 0x1029c, Stride: 1},
		{Lo: 0x102a0, Hi: 0x102d0, Stride: 1},
		{Lo: 0x102e1, Hi: 0x102fb, Stride: 1},
		{Lo: 0x10300, Hi: 0x10323, Stride: 1},
		{Lo: 0x1032d, Hi: 0x1034a, Stride: 1},
		{Lo: 0x10350, Hi: 0x10375, Stride: 1},
		{Lo: 0x10380, Hi: 0x1039d, Stride: 1},
		{Lo: 0x103a0, Hi: 0x103c3, Stride: 1},
		{Lo: 0x103c8, Hi: 0x103cf, Stride: 1},
		{Lo: 0x103d1, Hi: 0x103d5, Stride: 1},
		{Lo: 0x10400, Hi: 0x1049d, Stride: 1},
		{Lo: 0x104b0, Hi: 0x104d3, Stride: 1},
		{Lo: 0x104d8, Hi: 0x104fb, Stride: 1},
		{Lo: 0x10500, Hi: 0x10527, Stride: 1},
		{Lo: 0x10530, Hi: 0x10563, Stride: 1},
		{Lo: 0x1056f, Hi: 0x10600, Stride: 145},
		{Lo: 0x10601, Hi: 0x10736, Stride: 1},
		{Lo: 0x10740, Hi: 0x10755, Stride: 1},
		{Lo: 0x10760, Hi: 0x10767, Stride: 1},
		{Lo: 0x10800, Hi: 0x10805, Stride: 1},
		{Lo: 0x10808, Hi: 0x1080a, Stride: 2},
		{Lo: 0x1080b, Hi: 0x10835, Stride: 1},
		{Lo: 0x10837, Hi: 0x10838, Stride: 1},
		{Lo: 0x1083c, Hi: 0x1083f, Stride: 3},
		{Lo: 0x10840, Hi: 0x10855, Stride: 1},
		{Lo: 0x10858, Hi: 0x1089e, Stride: 1},
		{Lo: 0x108a7, Hi: 0x108af, Stride: 1},
		{Lo: 0x108e0, Hi: 0x108f2, Stride: 1},
		{Lo: 0x108f4, Hi: 0x108f5, Stride: 1},
		{Lo: 0x108fb, Hi: 0x1091b, Stride: 1},
		{Lo: 0x10920, Hi: 0x10939, Stride: 1},
		{Lo: 0x1093f, Hi: 0x10980, Stride: 65},
		{Lo: 0x10981, Hi: 0x109b7, Stride: 1},
		{Lo: 0x109bc, Hi: 0x109cf, Stride: 1},
		{Lo: 0x109d2, Hi: 0x10a00, Stride: 1},
		{Lo: 0x10a10, Hi: 0x10a13, Stride: 1},
		{Lo: 0x10a15, Hi: 0x10a17, Stride: 1},
		{Lo: 0x10a19, Hi: 0x10a35, Stride: 1},
		{Lo: 0x10a40, Hi: 0x10a48, Stride: 1},
		{Lo: 0x10a58, Hi: 0x10a60, Stride: 8},
		{Lo: 0x10a61, Hi: 0x10a9f, Stride: 1},
		{Lo: 0x10ac0, Hi: 0x10ae4, Stride: 1},
		{Lo: 0x10aeb, Hi: 0x10aef, Stride: 1},
		{Lo: 0x10b00, Hi: 0x10b35, Stride: 1},
		{Lo: 0x10b40, Hi: 0x10b55, Stride: 1},
		{Lo: 0x10b58, Hi: 0x10b72, Stride: 1},
		{Lo: 0x10b78, Hi: 0x10b91, Stride: 1},
		{Lo: 0x10b99, Hi: 0x10b9c, Stride: 1},
		{Lo: 0x10ba9, Hi: 0x10baf, Stride: 1},
		{Lo: 0x10c00, Hi: 0x10c48, Stride: 1},
		{Lo: 0x10c80, Hi: 0x10cb2, Stride: 1},
		{Lo: 0x10cc0, Hi: 0x10cf2, Stride: 1},
		{Lo: 0x10cfa, Hi: 0x10d23, Stride: 1},
		{Lo: 0x10e60, Hi: 0x10e7e, Stride: 1},
		{Lo: 0x10e80, Hi: 0x10ea9, Stride: 1},
		{Lo: 0x10eb0, Hi: 0x10eb1, Stride: 1},
		{Lo: 0x10f00, Hi: 0x10f27, Stride: 1},
		{Lo: 0x10f30, Hi: 0x10f45, Stride: 1},
		{Lo: 0x10f51, Hi: 0x10f59, Stride: 1},
		{Lo: 0x10fb0, Hi: 0x10fcb, Stride: 1},
		{Lo: 0x10fe0, Hi: 0x10ff6, Stride: 1},
		{Lo: 0x11003, Hi: 0x11037, Stride: 1},
		{Lo: 0x11049, Hi: 0x1104d, Stride: 1},
		{Lo: 0x11052, Hi: 0x11065, Stride: 1},
		{Lo: 0x11083, Hi: 0x110af, Stride: 1},
		{Lo: 0x110bb, Hi: 0x110bd, Stride: 1},
		{Lo: 0x110cd, Hi: 0x110d0, Stride: 3},
		{Lo: 0x110d1, Hi: 0x110e8, Stride: 1},
		{Lo: 0x11103, Hi: 0x11126, Stride: 1},
		{Lo: 0x11144, Hi: 0x11147, Stride: 3},
		{Lo: 0x11150, Hi: 0x11172, Stride: 1},
		{Lo: 0x11174, Hi: 0x11176, Stride: 2},
		{Lo: 0x11183, Hi: 0x111b2, Stride: 1},
		{Lo: 0x111c1, Hi: 0x111c4, Stride: 1},
		{Lo: 0x111c7, Hi: 0x111cd, Stride: 6},
		{Lo: 0x111da, Hi: 0x111dc, Stride: 2},
		{Lo: 0x111e1, Hi: 0x111f4, Stride: 1},
		{Lo: 0x11200, Hi: 0x11211, Stride: 1},
		{Lo: 0x11213, Hi: 0x1122b, Stride: 1},
		{Lo: 0x1123a, Hi: 0x1123d, Stride: 3},
		{Lo: 0x11280, Hi: 0x11286, Stride: 1},
		{Lo: 0x11288, Hi: 0x1128a, Stride: 2},
		{Lo: 0x1128b, Hi: 0x1128d, Stride: 1},
		{Lo: 0x1128f, Hi: 0x1129d, Stride: 1},
		{Lo: 0x1129f, Hi: 0x112a8, Stride: 1},
		{Lo: 0x112b0, Hi: 0x112de, Stride: 1},
		{Lo: 0x11305, Hi: 0x1130c, Stride: 1},
		{Lo: 0x1130f, Hi: 0x11310, Stride: 1},
		{Lo: 0x11313, Hi: 0x11328, Stride: 1},
		{Lo: 0x1132a, Hi: 0x11330, Stride: 1},
		{Lo: 0x11332, Hi: 0x11333, Stride: 1},
		{Lo: 0x11335, Hi: 0x11339, Stride: 1},
		{Lo: 0x1133d, Hi: 0x11350, Stride: 19},
		{Lo: 0x1135d, Hi: 0x11361, Stride: 1},
		{Lo: 0x11400, Hi: 0x11434, Stride: 1},
		{Lo: 0x11447, Hi: 0x1144a, Stride: 1},
		{Lo: 0x1144f, Hi: 0x1145d, Stride: 14},
		{Lo: 0x1145f, Hi: 0x11461, Stride: 1},
		{Lo: 0x11480, Hi: 0x114af, Stride: 1},
		{Lo: 0x114c4, Hi: 0x114c7, Stride: 1},
		{Lo: 0x11580, Hi: 0x115ae, Stride: 1},
		{Lo: 0x115c6, Hi: 0x115c8, Stride: 1},
		{Lo: 0x115d8, Hi: 0x115db, Stride: 1},
		{Lo: 0x11600, Hi: 0x1162f, Stride: 1},
		{Lo: 0x11643, Hi: 0x11644, Stride: 1},
		{Lo: 0x11680, Hi: 0x116aa, Stride: 1},
		{Lo: 0x116b8, Hi: 0x11800, Stride: 328},
		{Lo: 0x11801, Hi: 0x1182b, Stride: 1},
		{Lo: 0x1183b, Hi: 0x118a0, Stride: 101},
		{Lo: 0x118a1, Hi: 0x118df, Stride: 1},
		{Lo: 0x118ea, Hi: 0x118f2, Stride: 1},
		{Lo: 0x118ff, Hi: 0x11906, Stride: 1},
		{Lo: 0x11909, Hi: 0x1190c, Stride: 3},
		{Lo: 0x1190d, Hi: 0x11913, Stride: 1},
		{Lo: 0x11915, Hi: 0x11916, Stride: 1},
		{Lo: 0x11918, Hi: 0x1192f, Stride: 1},
		{Lo: 0x1193f, Hi: 0x11941, Stride: 2},
		{Lo: 0x119a0, Hi: 0x119a7, Stride: 1},
		{Lo: 0x119aa, Hi: 0x119d0, Stride: 1},
		{Lo: 0x119e1, Hi: 0x119e3, Stride: 2},
		{Lo: 0x11a00, Hi: 0x11a0b, Stride: 11},
		{Lo: 0x11a0c, Hi: 0x11a32, Stride: 1},
		{Lo: 0x11a3a, Hi: 0x11a46, Stride: 6},
		{Lo: 0x11a50, Hi: 0x11a5c, Stride: 12},
		{Lo: 0x11a5d, Hi: 0x11a89, Stride: 1},
		{Lo: 0x11a9d, Hi: 0x11ac0, Stride: 35},
		{Lo: 0x11ac1, Hi: 0x11af8, Stride: 1},
		{Lo: 0x11c00, Hi: 0x11c08, Stride: 1},
		{Lo: 0x11c0a, Hi: 0x11c2e, Stride: 1},
		{Lo: 0x11c40, Hi: 0x11c5a, Stride: 26},
		{Lo: 0x11c5b, Hi: 0x11c6c, Stride: 1},
		{Lo: 0x11c72, Hi: 0x11c8f, Stride: 1},
		{Lo: 0x11d00, Hi: 0x11d06, Stride: 1},
		{Lo: 0x11d08, Hi: 0x11d09, Stride: 1},
		{Lo: 0x11d0b, Hi: 0x11d30, Stride: 1},
		{Lo: 0x11d46, Hi: 0x11d60, Stride: 26},
		{Lo: 0x11d61, Hi: 0x11d65, Stride: 1},
		{Lo: 0x11d67, Hi: 0x11d68, Stride: 1},
		{Lo: 0x11d6a, Hi: 0x11d89, Stride: 1},
		{Lo: 0x11d98, Hi: 0x11ee0, Stride: 328},
		{Lo: 0x11ee1, Hi: 0x11ef2, Stride: 1},
		{Lo: 0x11ef7, Hi: 0x11ef8, Stride: 1},
		{Lo: 0x11fb0, Hi: 0x11fc0, Stride: 16},
		{Lo: 0x11fc1, Hi: 0x11fdc, Stride: 1},
		{Lo: 0x11fe1, Hi: 0x11ff1, Stride: 1},
		{Lo: 0x12000, Hi: 0x12399, Stride: 1},
		{Lo: 0x12400, Hi: 0x1246e, Stride: 1},
		{Lo: 0x12480, Hi: 0x12543, Stride: 1},
		{Lo: 0x13000, Hi: 0x13257, Stride: 1},
		{Lo: 0x1325e, Hi: 0x13281, Stride: 1},
		{Lo: 0x13283, Hi: 0x13285, Stride: 1},
		{Lo: 0x1328a, Hi: 0x13378, Stride: 1},
		{Lo: 0x1337c, Hi: 0x1342e, Stride: 1},
		{Lo: 0x14400, Hi: 0x145cd, Stride: 1},
		{Lo: 0x145d0, Hi: 0x14646, Stride: 1},
		{Lo: 0x16800, Hi: 0x16a38, Stride: 1},
		{Lo: 0x16a40, Hi: 0x16a5e, Stride: 1},
		{Lo: 0x16ad0, Hi: 0x16aed, Stride: 1},
		{Lo: 0x16b00, Hi: 0x16b2f, Stride: 1},
		{Lo: 0x16b3a, Hi: 0x16b43, Stride: 1},
		{Lo: 0x16b45, Hi: 0x16b5b, Stride: 22},
		{Lo: 0x16b5c, Hi: 0x16b61, Stride: 1},
		{Lo: 0x16b63, Hi: 0x16b77, Stride: 1},
		{Lo: 0x16b7d, Hi: 0x16b8f, Stride: 1},
		{Lo: 0x16e40, Hi: 0x16e96, Stride: 1},
		{Lo: 0x16e99, Hi: 0x16e9a, Stride: 1},
		{Lo: 0x16f00, Hi: 0x16f4a, Stride: 1},
		{Lo: 0x16f50, Hi: 0x16f93, Stride: 67},
		{Lo: 0x16f94, Hi: 0x16f9f, Stride: 1},
		{Lo: 0x18b00, Hi: 0x18cd5, Stride: 1},
		{Lo: 0x1bc00, Hi: 0x1bc6a, Stride: 1},
		{Lo: 0x1bc70, Hi: 0x1bc7c, Stride: 1},
		{Lo: 0x1bc80, Hi: 0x1bc88, Stride: 1},
		{Lo: 0x1bc90, Hi: 0x1bc99, Stride: 1},
		{Lo: 0x1bc9c, Hi: 0x1d000, Stride: 4964},
		{Lo: 0x1d001, Hi: 0x1d0f5, Stride: 1},
		{Lo: 0x1d100, Hi: 0x1d126, Stride: 1},
		{Lo: 0x1d129, Hi: 0x1d164, Stride: 1},
		{Lo: 0x1d16a, Hi: 0x1d16c, Stride: 1},
		{Lo: 0x1d183, Hi: 0x1d184, Stride: 1},
		{Lo: 0x1d18c, Hi: 0x1d1a9, Stride: 1},
		{Lo: 0x1d1ae, Hi: 0x1d1e8, Stride: 1},
		{Lo: 0x1d200, Hi: 0x1d241, Stride: 1},
		{Lo: 0x1d245, Hi: 0x1d2e0, Stride: 155},
		{Lo: 0x1d2e1, Hi: 0x1d2f3, Stride: 1},
		{Lo: 0x1d300, Hi: 0x1d356, Stride: 1},
		{Lo: 0x1d360, Hi: 0x1d378, Stride: 1},
		{Lo: 0x1d400, Hi: 0x1d454, Stride: 1},
		{Lo: 0x1d456, Hi: 0x1d49c, Stride: 1},
		{Lo: 0x1d49e, Hi: 0x1d49f, Stride: 1},
		{Lo: 0x1d4a2, Hi: 0x1d4a5, Stride: 3},
		{Lo: 0x1d4a6, Hi: 0x1d4a9, Stride: 3},
		{Lo: 0x1d4aa, Hi: 0x1d4ac, Stride: 1},
		{Lo: 0x1d4ae, Hi: 0x1d4b9, Stride: 1},
		{Lo: 0x1d4bb, Hi: 0x1d4bd, Stride: 2},
		{Lo: 0x1d4be, Hi: 0x1d4c3, Stride: 1},
		{Lo: 0x1d4c5, Hi: 0x1d505, Stride: 1},
		{Lo: 0x1d507, Hi: 0x1d50a, Stride: 1},
		{Lo: 0x1d50d, Hi: 0x1d514, Stride: 1},
		{Lo: 0x1d516, Hi: 0x1d51c, Stride: 1},
		{Lo: 0x1d51e, Hi: 0x1d539, Stride: 1},
		{Lo: 0x1d53b, Hi: 0x1d53e, Stride: 1},
		{Lo: 0x1d540, Hi: 0x1d544, Stride: 1},
		{Lo: 0x1d546, Hi: 0x1d54a, Stride: 4},
		{Lo: 0x1d54b, Hi: 0x1d550, Stride: 1},
		{Lo: 0x1d552, Hi: 0x1d6a5, Stride: 1},
		{Lo: 0x1d6a8, Hi: 0x1d7cb, Stride: 1},
		{Lo: 0x1d800, Hi: 0x1d9ff, Stride: 1},
		{Lo: 0x1da37, Hi: 0x1da3a, Stride: 1},
		{Lo: 0x1da6d, Hi: 0x1da74, Stride: 1},
		{Lo: 0x1da76, Hi: 0x1da83, Stride: 1},
		{Lo: 0x1da85, Hi: 0x1da86, Stride: 1},
		{Lo: 0x1da8b, Hi: 0x1e100, Stride: 1653},
		{Lo: 0x1e101, Hi: 0x1e12c, Stride: 1},
		{Lo: 0x1e137, Hi: 0x1e13d, Stride: 1},
		{Lo: 0x1e14e, Hi: 0x1e14f, Stride: 1},
		{Lo: 0x1e2c0, Hi: 0x1e2eb, Stride: 1},
		{Lo: 0x1e800, Hi: 0x1e8c4, Stride: 1},
		{Lo: 0x1e8c7, Hi: 0x1e8cf, Stride: 1},
		{Lo: 0x1e900, Hi: 0x1e943, Stride: 1},
		{Lo: 0x1e94b, Hi: 0x1ec71, Stride: 806},
		{Lo: 0x1ec72, Hi: 0x1ecab, Stride: 1},
		{Lo: 0x1ecad, Hi: 0x1ecaf, Stride: 1},
		{Lo: 0x1ecb1, Hi: 0x1ecb4, Stride: 1},
		{Lo: 0x1ed01, Hi: 0x1ed3d, Stride: 1},
		{Lo: 0x1ee00, Hi: 0x1ee03, Stride: 1},
		{Lo: 0x1ee05, Hi: 0x1ee1f, Stride: 1},
		{Lo: 0x1ee21, Hi: 0x1ee22, Stride: 1},
		{Lo: 0x1ee24, Hi: 0x1ee27, Stride: 3},
		{Lo: 0x1ee29, Hi: 0x1ee32, Stride: 1},
		{Lo: 0x1ee34, Hi: 0x1ee37, Stride: 1},
		{Lo: 0x1ee39, Hi: 0x1ee3b, Stride: 2},
		{Lo: 0x1ee42, Hi: 0x1ee47, Stride: 5},
		{Lo: 0x1ee49, Hi: 0x1ee4d, Stride: 2},
		{Lo: 0x1ee4e, Hi: 0x1ee4f, Stride: 1},
		{Lo: 0x1ee51, Hi: 0x1ee52, Stride: 1},
		{Lo: 0x1ee54, Hi: 0x1ee57, Stride: 3},
		{Lo: 0x1ee59, Hi: 0x1ee61, Stride: 2},
		{Lo: 0x1ee62, Hi: 0x1ee64, Stride: 2},
		{Lo: 0x1ee67, Hi: 0x1ee6a, Stride: 1},
		{Lo: 0x1ee6c, Hi: 0x1ee72, Stride: 1},
		{Lo: 0x1ee74, Hi: 0x1ee77, Stride: 1},
		{Lo: 0x1ee79, Hi: 0x1ee7c, Stride: 1},
		{Lo: 0x1ee7e, Hi: 0x1ee80, Stride: 2},
		{Lo: 0x1ee81, Hi: 0x1ee89, Stride: 1},
		{Lo: 0x1ee8b, Hi: 0x1ee9b, Stride: 1},
		{Lo: 0x1eea1, Hi: 0x1eea3, Stride: 1},
		{Lo: 0x1eea5, Hi: 0x1eea9, Stride: 1},
		{Lo: 0x1eeab, Hi: 0x1eebb, Stride: 1},
		{Lo: 0x1eef0, Hi: 0x1eef1, Stride: 1},
		{Lo: 0x1f12e, Hi: 0x1f12f, Stride: 1},
		{Lo: 0x1f16a, Hi: 0x1f16c, Stride: 1},
		{Lo: 0x1f39c, Hi: 0x1f39d, Stride: 1},
		{Lo: 0x1f3b5, Hi: 0x1f3b6, Stride: 1},
		{Lo: 0x1f3bc, Hi: 0x1f4a0, Stride: 228},
		{Lo: 0x1f4a2, Hi: 0x1f4a4, Stride: 2},
		{Lo: 0x1f4af, Hi: 0x1f4b1, Stride: 2},
		{Lo: 0x1f4b2, Hi: 0x1f500, Stride: 78},
		{Lo: 0x1f501, Hi: 0x1f506, Stride: 1},
		{Lo: 0x1f517, Hi: 0x1f524, Stride: 1},
		{Lo: 0x1f532, Hi: 0x1f549, Stride: 1},
		{Lo: 0x1f5d4, Hi: 0x1f5db, Stride: 1},
		{Lo: 0x1f5f4, Hi: 0x1f5f9, Stride: 1},
		{Lo: 0x1f650, Hi: 0x1f675, Stride: 1},
		{Lo: 0x1f67c, Hi: 0x1f67f, Stride: 1},
		{Lo: 0x1f700, Hi: 0x1f773, Stride: 1},
		{Lo: 0x1f780, Hi: 0x1f7d4, Stride: 1},
		{Lo: 0x1f800, Hi: 0x1f80b, Stride: 1},
		{Lo: 0x1f810, Hi: 0x1f847, Stride: 1},
		{Lo: 0x1f850, Hi: 0x1f859, Stride: 1},
		{Lo: 0x1f860, Hi: 0x1f887, Stride: 1},
		{Lo: 0x1f890, Hi: 0x1f8ad, Stride: 1},
		{Lo: 0x1f900, Hi: 0x1f90b, Stride: 1},
		{Lo: 0x1fa00, Hi: 0x1fa53, Stride: 1},
		{Lo: 0x1fb00, Hi: 0x1fb92, Stride: 1},
		{Lo: 0x1fb94, Hi: 0x1fbca, Stride: 1},
	},
	LatinOffset: 11,
}

// Infix Numeric Separator
var BreakIS = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x002c, Hi: 0x002e, Stride: 2},
		{Lo: 0x003a, Hi: 0x003b, Stride: 1},
		{Lo: 0x037e, Hi: 0x0589, Stride: 523},
		{Lo: 0x060c, Hi: 0x060d, Stride: 1},
		{Lo: 0x07f8, Hi: 0x2044, Stride: 6220},
		{Lo: 0xfe10, Hi: 0xfe13, Stride: 3},
		{Lo: 0xfe14, Hi: 0xfe14, Stride: 1},
	},
	LatinOffset: 2,
}

// Prefix Numeric
var BreakPR = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0024, Hi: 0x002b, Stride: 7},
		{Lo: 0x005c, Hi: 0x00a3, Stride: 71},
		{Lo: 0x00a4, Hi: 0x00a5, Stride: 1},
		{Lo: 0x00b1, Hi: 0x058f, Stride: 1246},
		{Lo: 0x07fe, Hi: 0x07ff, Stride: 1},
		{Lo: 0x09fb, Hi: 0x0af1, Stride: 246},
		{Lo: 0x0bf9, Hi: 0x0e3f, Stride: 582},
		{Lo: 0x17db, Hi: 0x20a0, Stride: 2245},
		{Lo: 0x20a1, Hi: 0x20a6, Stride: 1},
		{Lo: 0x20a8, Hi: 0x20b5, Stride: 1},
		{Lo: 0x20b7, Hi: 0x20ba, Stride: 1},
		{Lo: 0x20bc, Hi: 0x20bd, Stride: 1},
		{Lo: 0x20bf, Hi: 0x20cf, Stride: 1},
		{Lo: 0x2116, Hi: 0x2212, Stride: 252},
		{Lo: 0x2213, Hi: 0xfe69, Stride: 56406},
		{Lo: 0xff04, Hi: 0xffe1, Stride: 221},
		{Lo: 0xffe5, Hi: 0xffe6, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x1e2ff, Hi: 0x1e2ff, Stride: 1},
	},
	LatinOffset: 3,
}

// Postfix Numeric
var BreakPO = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0025, Hi: 0x00a2, Stride: 125},
		{Lo: 0x00b0, Hi: 0x0609, Stride: 1369},
		{Lo: 0x060a, Hi: 0x060b, Stride: 1},
		{Lo: 0x066a, Hi: 0x09f2, Stride: 904},
		{Lo: 0x09f3, Hi: 0x09f9, Stride: 6},
		{Lo: 0x0d79, Hi: 0x2030, Stride: 4791},
		{Lo: 0x2031, Hi: 0x2037, Stride: 1},
		{Lo: 0x20a7, Hi: 0x20b6, Stride: 15},
		{Lo: 0x20bb, Hi: 0x20be, Stride: 3},
		{Lo: 0x2103, Hi: 0x2109, Stride: 6},
		{Lo: 0xa838, Hi: 0xfdfc, Stride: 21956},
		{Lo: 0xfe6a, Hi: 0xff05, Stride: 155},
		{Lo: 0xffe0, Hi: 0xffe0, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x11fdd, Hi: 0x11fe0, Stride: 1},
		{Lo: 0x1ecac, Hi: 0x1ecb0, Stride: 4},
	},
	LatinOffset: 1,
}

// Open Punctuation
var BreakOP = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0028, Hi: 0x005b, Stride: 51},
		{Lo: 0x007b, Hi: 0x00a1, Stride: 38},
		{Lo: 0x00bf, Hi: 0x0f3a, Stride: 3707},
		{Lo: 0x0f3c, Hi: 0x169b, Stride: 1887},
		{Lo: 0x201a, Hi: 0x201e, Stride: 4},
		{Lo: 0x2045, Hi: 0x207d, Stride: 56},
		{Lo: 0x208d, Hi: 0x2308, Stride: 635},
		{Lo: 0x230a, Hi: 0x2329, Stride: 31},
		{Lo: 0x2768, Hi: 0x2774, Stride: 2},
		{Lo: 0x27c5, Hi: 0x27e6, Stride: 33},
		{Lo: 0x27e8, Hi: 0x27ee, Stride: 2},
		{Lo: 0x2983, Hi: 0x2997, Stride: 2},
		{Lo: 0x29d8, Hi: 0x29da, Stride: 2},
		{Lo: 0x29fc, Hi: 0x2e18, Stride: 1052},
		{Lo: 0x2e22, Hi: 0x2e28, Stride: 2},
		{Lo: 0x2e42, Hi: 0x3008, Stride: 454},
		{Lo: 0x300a, Hi: 0x3010, Stride: 2},
		{Lo: 0x3014, Hi: 0x301a, Stride: 2},
		{Lo: 0x301d, Hi: 0xfd3f, Stride: 52514},
		{Lo: 0xfe17, Hi: 0xfe35, Stride: 30},
		{Lo: 0xfe37, Hi: 0xfe43, Stride: 2},
		{Lo: 0xfe47, Hi: 0xfe59, Stride: 18},
		{Lo: 0xfe5b, Hi: 0xfe5d, Stride: 2},
		{Lo: 0xff08, Hi: 0xff3b, Stride: 51},
		{Lo: 0xff5b, Hi: 0xff5f, Stride: 4},
		{Lo: 0xff62, Hi: 0xff62, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x13258, Hi: 0x1325a, Stride: 1},
		{Lo: 0x13286, Hi: 0x13288, Stride: 2},
		{Lo: 0x13379, Hi: 0x13437, Stride: 190},
		{Lo: 0x145ce, Hi: 0x1e95e, Stride: 41872},
		{Lo: 0x1e95f, Hi: 0x1e95f, Stride: 1},
	},
	LatinOffset: 2,
}

// Close Punctuation
var BreakCL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x007d, Hi: 0x0f3b, Stride: 3774},
		{Lo: 0x0f3d, Hi: 0x169c, Stride: 1887},
		{Lo: 0x2046, Hi: 0x207e, Stride: 56},
		{Lo: 0x208e, Hi: 0x2309, Stride: 635},
		{Lo: 0x230b, Hi: 0x232a, Stride: 31},
		{Lo: 0x2769, Hi: 0x2775, Stride: 2},
		{Lo: 0x27c6, Hi: 0x27e7, Stride: 33},
		{Lo: 0x27e9, Hi: 0x27ef, Stride: 2},
		{Lo: 0x2984, Hi: 0x2998, Stride: 2},
		{Lo: 0x29d9, Hi: 0x29db, Stride: 2},
		{Lo: 0x29fd, Hi: 0x2e23, Stride: 1062},
		{Lo: 0x2e25, Hi: 0x2e29, Stride: 2},
		{Lo: 0x3001, Hi: 0x3002, Stride: 1},
		{Lo: 0x3009, Hi: 0x3011, Stride: 2},
		{Lo: 0x3015, Hi: 0x301b, Stride: 2},
		{Lo: 0x301e, Hi: 0x301f, Stride: 1},
		{Lo: 0xfd3e, Hi: 0xfe11, Stride: 211},
		{Lo: 0xfe12, Hi: 0xfe18, Stride: 6},
		{Lo: 0xfe36, Hi: 0xfe44, Stride: 2},
		{Lo: 0xfe48, Hi: 0xfe50, Stride: 8},
		{Lo: 0xfe52, Hi: 0xfe5a, Stride: 8},
		{Lo: 0xfe5c, Hi: 0xfe5e, Stride: 2},
		{Lo: 0xff09, Hi: 0xff0c, Stride: 3},
		{Lo: 0xff0e, Hi: 0xff3d, Stride: 47},
		{Lo: 0xff5d, Hi: 0xff60, Stride: 3},
		{Lo: 0xff61, Hi: 0xff63, Stride: 2},
		{Lo: 0xff64, Hi: 0xff64, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x1325b, Hi: 0x1325d, Stride: 1},
		{Lo: 0x13282, Hi: 0x13287, Stride: 5},
		{Lo: 0x13289, Hi: 0x1337a, Stride: 241},
		{Lo: 0x1337b, Hi: 0x13438, Stride: 189},
		{Lo: 0x145cf, Hi: 0x145cf, Stride: 1},
	},
}

// Close Parenthesis
var BreakCP = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0029, Hi: 0x005d, Stride: 52},
	},
	LatinOffset: 1,
}

// Quotation
var BreakQU = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0022, Hi: 0x0027, Stride: 5},
		{Lo: 0x00ab, Hi: 0x00bb, Stride: 16},
		{Lo: 0x2018, Hi: 0x2019, Stride: 1},
		{Lo: 0x201b, Hi: 0x201d, Stride: 1},
		{Lo: 0x201f, Hi: 0x2039, Stride: 26},
		{Lo: 0x203a, Hi: 0x275b, Stride: 1825},
		{Lo: 0x275c, Hi: 0x2760, Stride: 1},
		{Lo: 0x2e00, Hi: 0x2e0d, Stride: 1},
		{Lo: 0x2e1c, Hi: 0x2e1d, Stride: 1},
		{Lo: 0x2e20, Hi: 0x2e21, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x1f676, Hi: 0x1f678, Stride: 1},
	},
	LatinOffset: 2,
}

// Hyphen
var BreakHY = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x002d, Hi: 0x002d, Stride: 1},
	},
	LatinOffset: 1,
}

// Surrogate
var BreakSG = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xd800, Hi: 0xdfff, Stride: 1},
	},
}

// Non-breaking ("Glue")
var BreakGL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x00a0, Hi: 0x034f, Stride: 687},
		{Lo: 0x035c, Hi: 0x0362, Stride: 1},
		{Lo: 0x0f08, Hi: 0x0f0c, Stride: 4},
		{Lo: 0x0f12, Hi: 0x0fd9, Stride: 199},
		{Lo: 0x0fda, Hi: 0x180e, Stride: 2100},
		{Lo: 0x2007, Hi: 0x2011, Stride: 10},
		{Lo: 0x202f, Hi: 0x202f, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x13430, Hi: 0x13436, Stride: 1},
		{Lo: 0x16fe4, Hi: 0x16fe4, Stride: 1},
	},
}

// Nonstarter
var BreakNS = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x17d6, Hi: 0x203c, Stride: 2150},
		{Lo: 0x203d, Hi: 0x2047, Stride: 10},
		{Lo: 0x2048, Hi: 0x2049, Stride: 1},
		{Lo: 0x3005, Hi: 0x301c, Stride: 23},
		{Lo: 0x303b, Hi: 0x303c, Stride: 1},
		{Lo: 0x309b, Hi: 0x309e, Stride: 1},
		{Lo: 0x30a0, Hi: 0x30fb, Stride: 91},
		{Lo: 0x30fd, Hi: 0x30fe, Stride: 1},
		{Lo: 0xa015, Hi: 0xfe54, Stride: 24127},
		{Lo: 0xfe55, Hi: 0xff1a, Stride: 197},
		{Lo: 0xff1b, Hi: 0xff65, Stride: 74},
		{Lo: 0xff9e, Hi: 0xff9f, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x16fe0, Hi: 0x16fe3, Stride: 1},
		{Lo: 0x1f679, Hi: 0x1f67b, Stride: 1},
	},
}

// Exclamation/Interrogation
var BreakEX = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0021, Hi: 0x003f, Stride: 30},
		{Lo: 0x05c6, Hi: 0x061b, Stride: 85},
		{Lo: 0x061e, Hi: 0x061f, Stride: 1},
		{Lo: 0x06d4, Hi: 0x07f9, Stride: 293},
		{Lo: 0x0f0d, Hi: 0x0f11, Stride: 1},
		{Lo: 0x0f14, Hi: 0x1802, Stride: 2286},
		{Lo: 0x1803, Hi: 0x1808, Stride: 5},
		{Lo: 0x1809, Hi: 0x1944, Stride: 315},
		{Lo: 0x1945, Hi: 0x2762, Stride: 3613},
		{Lo: 0x2763, Hi: 0x2cf9, Stride: 1430},
		{Lo: 0x2cfe, Hi: 0x2e2e, Stride: 304},
		{Lo: 0xa60e, Hi: 0xa876, Stride: 616},
		{Lo: 0xa877, Hi: 0xfe15, Stride: 21918},
		{Lo: 0xfe16, Hi: 0xfe56, Stride: 64},
		{Lo: 0xfe57, Hi: 0xff01, Stride: 170},
		{Lo: 0xff1f, Hi: 0xff1f, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x115c4, Hi: 0x115c5, Stride: 1},
		{Lo: 0x11c71, Hi: 0x11c71, Stride: 1},
	},
	LatinOffset: 1,
}

// Symbols Allowing Break After
var BreakSY = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x002f, Hi: 0x002f, Stride: 1},
	},
	LatinOffset: 1,
}

// Hebrew Letter
var BreakHL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x05d0, Hi: 0x05ea, Stride: 1},
		{Lo: 0x05ef, Hi: 0x05f2, Stride: 1},
		{Lo: 0xfb1d, Hi: 0xfb1f, Stride: 2},
		{Lo: 0xfb20, Hi: 0xfb28, Stride: 1},
		{Lo: 0xfb2a, Hi: 0xfb36, Stride: 1},
		{Lo: 0xfb38, Hi: 0xfb3c, Stride: 1},
		{Lo: 0xfb3e, Hi: 0xfb40, Stride: 2},
		{Lo: 0xfb41, Hi: 0xfb43, Stride: 2},
		{Lo: 0xfb44, Hi: 0xfb46, Stride: 2},
		{Lo: 0xfb47, Hi: 0xfb4f, Stride: 1},
	},
}

// Ideographic
var BreakID = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x231a, Hi: 0x231b, Stride: 1},
		{Lo: 0x23f0, Hi: 0x23f3, Stride: 1},
		{Lo: 0x2600, Hi: 0x2603, Stride: 1},
		{Lo: 0x2614, Hi: 0x2615, Stride: 1},
		{Lo: 0x2618, Hi: 0x261a, Stride: 2},
		{Lo: 0x261b, Hi: 0x261c, Stride: 1},
		{Lo: 0x261e, Hi: 0x261f, Stride: 1},
		{Lo: 0x2639, Hi: 0x263b, Stride: 1},
		{Lo: 0x2668, Hi: 0x267f, Stride: 23},
		{Lo: 0x26bd, Hi: 0x26c8, Stride: 1},
		{Lo: 0x26cd, Hi: 0x26cf, Stride: 2},
		{Lo: 0x26d0, Hi: 0x26d1, Stride: 1},
		{Lo: 0x26d3, Hi: 0x26d4, Stride: 1},
		{Lo: 0x26d8, Hi: 0x26d9, Stride: 1},
		{Lo: 0x26dc, Hi: 0x26df, Stride: 3},
		{Lo: 0x26e0, Hi: 0x26e1, Stride: 1},
		{Lo: 0x26ea, Hi: 0x26f1, Stride: 7},
		{Lo: 0x26f2, Hi: 0x26f5, Stride: 1},
		{Lo: 0x26f7, Hi: 0x26f8, Stride: 1},
		{Lo: 0x26fa, Hi: 0x26fd, Stride: 3},
		{Lo: 0x26fe, Hi: 0x2704, Stride: 1},
		{Lo: 0x2708, Hi: 0x2709, Stride: 1},
		{Lo: 0x2764, Hi: 0x2e80, Stride: 1820},
		{Lo: 0x2e81, Hi: 0x2e99, Stride: 1},
		{Lo: 0x2e9b, Hi: 0x2ef3, Stride: 1},
		{Lo: 0x2f00, Hi: 0x2fd5, Stride: 1},
		{Lo: 0x2ff0, Hi: 0x2ffb, Stride: 1},
		{Lo: 0x3003, Hi: 0x3004, Stride: 1},
		{Lo: 0x3006, Hi: 0x3007, Stride: 1},
		{Lo: 0x3012, Hi: 0x3013, Stride: 1},
		{Lo: 0x3020, Hi: 0x3029, Stride: 1},
		{Lo: 0x3030, Hi: 0x3034, Stride: 1},
		{Lo: 0x3036, Hi: 0x303a, Stride: 1},
		{Lo: 0x303d, Hi: 0x303f, Stride: 1},
		{Lo: 0x3042, Hi: 0x304a, Stride: 2},
		{Lo: 0x304b, Hi: 0x3062, Stride: 1},
		{Lo: 0x3064, Hi: 0x3082, Stride: 1},
		{Lo: 0x3084, Hi: 0x3088, Stride: 2},
		{Lo: 0x3089, Hi: 0x308d, Stride: 1},
		{Lo: 0x308f, Hi: 0x3094, Stride: 1},
		{Lo: 0x309f, Hi: 0x30a2, Stride: 3},
		{Lo: 0x30a4, Hi: 0x30aa, Stride: 2},
		{Lo: 0x30ab, Hi: 0x30c2, Stride: 1},
		{Lo: 0x30c4, Hi: 0x30e2, Stride: 1},
		{Lo: 0x30e4, Hi: 0x30e8, Stride: 2},
		{Lo: 0x30e9, Hi: 0x30ed, Stride: 1},
		{Lo: 0x30ef, Hi: 0x30f4, Stride: 1},
		{Lo: 0x30f7, Hi: 0x30fa, Stride: 1},
		{Lo: 0x30ff, Hi: 0x3105, Stride: 6},
		{Lo: 0x3106, Hi: 0x312f, Stride: 1},
		{Lo: 0x3131, Hi: 0x318e, Stride: 1},
		{Lo: 0x3190, Hi: 0x31e3, Stride: 1},
		{Lo: 0x3200, Hi: 0x321e, Stride: 1},
		{Lo: 0x3220, Hi: 0x3247, Stride: 1},
		{Lo: 0x3250, Hi: 0x4dbf, Stride: 1},
		{Lo: 0x4e00, Hi: 0xa014, Stride: 1},
		{Lo: 0xa016, Hi: 0xa48c, Stride: 1},
		{Lo: 0xa490, Hi: 0xa4c6, Stride: 1},
		{Lo: 0xf900, Hi: 0xfaff, Stride: 1},
		{Lo: 0xfe30, Hi: 0xfe34, Stride: 1},
		{Lo: 0xfe45, Hi: 0xfe46, Stride: 1},
		{Lo: 0xfe49, Hi: 0xfe4f, Stride: 1},
		{Lo: 0xfe51, Hi: 0xfe5f, Stride: 7},
		{Lo: 0xfe60, Hi: 0xfe66, Stride: 1},
		{Lo: 0xfe68, Hi: 0xfe6b, Stride: 3},
		{Lo: 0xff02, Hi: 0xff03, Stride: 1},
		{Lo: 0xff06, Hi: 0xff07, Stride: 1},
		{Lo: 0xff0a, Hi: 0xff0b, Stride: 1},
		{Lo: 0xff0d, Hi: 0xff0f, Stride: 2},
		{Lo: 0xff10, Hi: 0xff19, Stride: 1},
		{Lo: 0xff1c, Hi: 0xff1e, Stride: 1},
		{Lo: 0xff20, Hi: 0xff3a, Stride: 1},
		{Lo: 0xff3c, Hi: 0xff3e, Stride: 2},
		{Lo: 0xff3f, Hi: 0xff5a, Stride: 1},
		{Lo: 0xff5c, Hi: 0xff5e, Stride: 2},
		{Lo: 0xff66, Hi: 0xff71, Stride: 11},
		{Lo: 0xff72, Hi: 0xff9d, Stride: 1},
		{Lo: 0xffa0, Hi: 0xffbe, Stride: 1},
		{Lo: 0xffc2, Hi: 0xffc7, Stride: 1},
		{Lo: 0xffca, Hi: 0xffcf, Stride: 1},
		{Lo: 0xffd2, Hi: 0xffd7, Stride: 1},
		{Lo: 0xffda, Hi: 0xffdc, Stride: 1},
		{Lo: 0xffe2, Hi: 0xffe4, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x17000, Hi: 0x187f7, Stride: 1},
		{Lo: 0x18800, Hi: 0x18aff, Stride: 1},
		{Lo: 0x18d00, Hi: 0x18d08, Stride: 1},
		{Lo: 0x1b000, Hi: 0x1b11e, Stride: 1},
		{Lo: 0x1b170, Hi: 0x1b2fb, Stride: 1},
		{Lo: 0x1f000, Hi: 0x1f0ff, Stride: 1},
		{Lo: 0x1f10d, Hi: 0x1f10f, Stride: 1},
		{Lo: 0x1f16d, Hi: 0x1f16f, Stride: 1},
		{Lo: 0x1f1ad, Hi: 0x1f1e5, Stride: 1},
		{Lo: 0x1f200, Hi: 0x1f384, Stride: 1},
		{Lo: 0x1f386, Hi: 0x1f39b, Stride: 1},
		{Lo: 0x1f39e, Hi: 0x1f3b4, Stride: 1},
		{Lo: 0x1f3b7, Hi: 0x1f3bb, Stride: 1},
		{Lo: 0x1f3bd, Hi: 0x1f3c1, Stride: 1},
		{Lo: 0x1f3c5, Hi: 0x1f3c6, Stride: 1},
		{Lo: 0x1f3c8, Hi: 0x1f3c9, Stride: 1},
		{Lo: 0x1f3cd, Hi: 0x1f3fa, Stride: 1},
		{Lo: 0x1f400, Hi: 0x1f441, Stride: 1},
		{Lo: 0x1f444, Hi: 0x1f445, Stride: 1},
		{Lo: 0x1f451, Hi: 0x1f465, Stride: 1},
		{Lo: 0x1f479, Hi: 0x1f47b, Stride: 1},
		{Lo: 0x1f47d, Hi: 0x1f480, Stride: 1},
		{Lo: 0x1f484, Hi: 0x1f488, Stride: 4},
		{Lo: 0x1f489, Hi: 0x1f48e, Stride: 1},
		{Lo: 0x1f490, Hi: 0x1f492, Stride: 2},
		{Lo: 0x1f493, Hi: 0x1f49f, Stride: 1},
		{Lo: 0x1f4a1, Hi: 0x1f4a5, Stride: 2},
		{Lo: 0x1f4a6, Hi: 0x1f4a9, Stride: 1},
		{Lo: 0x1f4ab, Hi: 0x1f4ae, Stride: 1},
		{Lo: 0x1f4b0, Hi: 0x1f4b3, Stride: 3},
		{Lo: 0x1f4b4, Hi: 0x1f4ff, Stride: 1},
		{Lo: 0x1f507, Hi: 0x1f516, Stride: 1},
		{Lo: 0x1f525, Hi: 0x1f531, Stride: 1},
		{Lo: 0x1f54a, Hi: 0x1f573, Stride: 1},
		{Lo: 0x1f576, Hi: 0x1f579, Stride: 1},
		{Lo: 0x1f57b, Hi: 0x1f58f, Stride: 1},
		{Lo: 0x1f591, Hi: 0x1f594, Stride: 1},
		{Lo: 0x1f597, Hi: 0x1f5d3, Stride: 1},
		{Lo: 0x1f5dc, Hi: 0x1f5f3, Stride: 1},
		{Lo: 0x1f5fa, Hi: 0x1f644, Stride: 1},
		{Lo: 0x1f648, Hi: 0x1f64a, Stride: 1},
		{Lo: 0x1f680, Hi: 0x1f6a2, Stride: 1},
		{Lo: 0x1f6a4, Hi: 0x1f6b3, Stride: 1},
		{Lo: 0x1f6b7, Hi: 0x1f6bf, Stride: 1},
		{Lo: 0x1f6c1, Hi: 0x1f6cb, Stride: 1},
		{Lo: 0x1f6cd, Hi: 0x1f6ff, Stride: 1},
		{Lo: 0x1f774, Hi: 0x1f77f, Stride: 1},
		{Lo: 0x1f7d5, Hi: 0x1f7ff, Stride: 1},
		{Lo: 0x1f80c, Hi: 0x1f80f, Stride: 1},
		{Lo: 0x1f848, Hi: 0x1f84f, Stride: 1},
		{Lo: 0x1f85a, Hi: 0x1f85f, Stride: 1},
		{Lo: 0x1f888, Hi: 0x1f88f, Stride: 1},
		{Lo: 0x1f8ae, Hi: 0x1f8ff, Stride: 1},
		{Lo: 0x1f90d, Hi: 0x1f90e, Stride: 1},
		{Lo: 0x1f910, Hi: 0x1f917, Stride: 1},
		{Lo: 0x1f920, Hi: 0x1f925, Stride: 1},
		{Lo: 0x1f927, Hi: 0x1f92f, Stride: 1},
		{Lo: 0x1f93a, Hi: 0x1f93b, Stride: 1},
		{Lo: 0x1f93f, Hi: 0x1f976, Stride: 1},
		{Lo: 0x1f978, Hi: 0x1f9b4, Stride: 1},
		{Lo: 0x1f9b7, Hi: 0x1f9ba, Stride: 3},
		{Lo: 0x1f9bc, Hi: 0x1f9cc, Stride: 1},
		{Lo: 0x1f9d0, Hi: 0x1f9de, Stride: 14},
		{Lo: 0x1f9df, Hi: 0x1f9ff, Stride: 1},
		{Lo: 0x1fa54, Hi: 0x1faff, Stride: 1},
		{Lo: 0x1fc00, Hi: 0x1fffd, Stride: 1},
		{Lo: 0x20000, Hi: 0x2fffd, Stride: 1},
		{Lo: 0x30000, Hi: 0x3fffd, Stride: 1},
	},
}

// Inseparable
var BreakIN = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x2024, Hi: 0x2026, Stride: 1},
		{Lo: 0x22ef, Hi: 0xfe19, Stride: 56106},
	},
	R32: []unicode.Range32{
		{Lo: 0x10af6, Hi: 0x10af6, Stride: 1},
	},
}

// Break After
var BreakBA = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0009, Hi: 0x007c, Stride: 115},
		{Lo: 0x00ad, Hi: 0x058a, Stride: 1245},
		{Lo: 0x05be, Hi: 0x0964, Stride: 934},
		{Lo: 0x0965, Hi: 0x0e5a, Stride: 1269},
		{Lo: 0x0e5b, Hi: 0x0f0b, Stride: 176},
		{Lo: 0x0f34, Hi: 0x0f7f, Stride: 75},
		{Lo: 0x0f85, Hi: 0x0fbe, Stride: 57},
		{Lo: 0x0fbf, Hi: 0x0fd2, Stride: 19},
		{Lo: 0x104a, Hi: 0x104b, Stride: 1},
		{Lo: 0x1361, Hi: 0x1400, Stride: 159},
		{Lo: 0x1680, Hi: 0x16eb, Stride: 107},
		{Lo: 0x16ec, Hi: 0x16ed, Stride: 1},
		{Lo: 0x1735, Hi: 0x1736, Stride: 1},
		{Lo: 0x17d4, Hi: 0x17d5, Stride: 1},
		{Lo: 0x17d8, Hi: 0x17da, Stride: 2},
		{Lo: 0x1804, Hi: 0x1805, Stride: 1},
		{Lo: 0x1b5a, Hi: 0x1b5b, Stride: 1},
		{Lo: 0x1b5d, Hi: 0x1b60, Stride: 1},
		{Lo: 0x1c3b, Hi: 0x1c3f, Stride: 1},
		{Lo: 0x1c7e, Hi: 0x1c7f, Stride: 1},
		{Lo: 0x2000, Hi: 0x2006, Stride: 1},
		{Lo: 0x2008, Hi: 0x200a, Stride: 1},
		{Lo: 0x2010, Hi: 0x2012, Stride: 2},
		{Lo: 0x2013, Hi: 0x2027, Stride: 20},
		{Lo: 0x2056, Hi: 0x2058, Stride: 2},
		{Lo: 0x2059, Hi: 0x205b, Stride: 1},
		{Lo: 0x205d, Hi: 0x205f, Stride: 1},
		{Lo: 0x2cfa, Hi: 0x2cfc, Stride: 1},
		{Lo: 0x2cff, Hi: 0x2d70, Stride: 113},
		{Lo: 0x2e0e, Hi: 0x2e15, Stride: 1},
		{Lo: 0x2e17, Hi: 0x2e19, Stride: 2},
		{Lo: 0x2e2a, Hi: 0x2e2d, Stride: 1},
		{Lo: 0x2e30, Hi: 0x2e31, Stride: 1},
		{Lo: 0x2e33, Hi: 0x2e34, Stride: 1},
		{Lo: 0x2e3c, Hi: 0x2e3e, Stride: 1},
		{Lo: 0x2e40, Hi: 0x2e41, Stride: 1},
		{Lo: 0x2e43, Hi: 0x2e4a, Stride: 1},
		{Lo: 0x2e4c, Hi: 0x2e4e, Stride: 2},
		{Lo: 0x2e4f, Hi: 0x3000, Stride: 433},
		{Lo: 0xa4fe, Hi: 0xa4ff, Stride: 1},
		{Lo: 0xa60d, Hi: 0xa60f, Stride: 2},
		{Lo: 0xa6f3, Hi: 0xa6f7, Stride: 1},
		{Lo: 0xa8ce, Hi: 0xa8cf, Stride: 1},
		{Lo: 0xa92e, Hi: 0xa92f, Stride: 1},
		{Lo: 0xa9c7, Hi: 0xa9c9, Stride: 1},
		{Lo: 0xaa5d, Hi: 0xaa5f, Stride: 1},
		{Lo: 0xaaf0, Hi: 0xaaf1, Stride: 1},
		{Lo: 0xabeb, Hi: 0xabeb, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x10100, Hi: 0x10102, Stride: 1},
		{Lo: 0x1039f, Hi: 0x103d0, Stride: 49},
		{Lo: 0x10857, Hi: 0x1091f, Stride: 200},
		{Lo: 0x10a50, Hi: 0x10a57, Stride: 1},
		{Lo: 0x10af0, Hi: 0x10af5, Stride: 1},
		{Lo: 0x10b39, Hi: 0x10b3f, Stride: 1},
		{Lo: 0x10ead, Hi: 0x11047, Stride: 410},
		{Lo: 0x11048, Hi: 0x110be, Stride: 118},
		{Lo: 0x110bf, Hi: 0x110c1, Stride: 1},
		{Lo: 0x11140, Hi: 0x11143, Stride: 1},
		{Lo: 0x111c5, Hi: 0x111c6, Stride: 1},
		{Lo: 0x111c8, Hi: 0x111dd, Stride: 21},
		{Lo: 0x111de, Hi: 0x111df, Stride: 1},
		{Lo: 0x11238, Hi: 0x11239, Stride: 1},
		{Lo: 0x1123b, Hi: 0x1123c, Stride: 1},
		{Lo: 0x112a9, Hi: 0x1144b, Stride: 418},
		{Lo: 0x1144c, Hi: 0x1144e, Stride: 1},
		{Lo: 0x1145a, Hi: 0x1145b, Stride: 1},
		{Lo: 0x115c2, Hi: 0x115c3, Stride: 1},
		{Lo: 0x115c9, Hi: 0x115d7, Stride: 1},
		{Lo: 0x11641, Hi: 0x11642, Stride: 1},
		{Lo: 0x1173c, Hi: 0x1173e, Stride: 1},
		{Lo: 0x11944, Hi: 0x11946, Stride: 1},
		{Lo: 0x11a41, Hi: 0x11a44, Stride: 1},
		{Lo: 0x11a9a, Hi: 0x11a9c, Stride: 1},
		{Lo: 0x11aa1, Hi: 0x11aa2, Stride: 1},
		{Lo: 0x11c41, Hi: 0x11c45, Stride: 1},
		{Lo: 0x11fff, Hi: 0x12470, Stride: 1137},
		{Lo: 0x12471, Hi: 0x12474, Stride: 1},
		{Lo: 0x16a6e, Hi: 0x16a6f, Stride: 1},
		{Lo: 0x16af5, Hi: 0x16b37, Stride: 66},
		{Lo: 0x16b38, Hi: 0x16b39, Stride: 1},
		{Lo: 0x16b44, Hi: 0x16e97, Stride: 851},
		{Lo: 0x16e98, Hi: 0x1bc9f, Stride: 19975},
		{Lo: 0x1da87, Hi: 0x1da8a, Stride: 1},
	},
	LatinOffset: 1,
}

// Break Before
var BreakBB = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x00b4, Hi: 0x02c8, Stride: 532},
		{Lo: 0x02cc, Hi: 0x02df, Stride: 19},
		{Lo: 0x0c77, Hi: 0x0c84, Stride: 13},
		{Lo: 0x0f01, Hi: 0x0f04, Stride: 1},
		{Lo: 0x0f06, Hi: 0x0f07, Stride: 1},
		{Lo: 0x0f09, Hi: 0x0f0a, Stride: 1},
		{Lo: 0x0fd0, Hi: 0x0fd1, Stride: 1},
		{Lo: 0x0fd3, Hi: 0x1806, Stride: 2099},
		{Lo: 0x1ffd, Hi: 0xa874, Stride: 34935},
		{Lo: 0xa875, Hi: 0xa8fc, Stride: 135},
	},
	R32: []unicode.Range32{
		{Lo: 0x11175, Hi: 0x111db, Stride: 102},
		{Lo: 0x115c1, Hi: 0x11660, Stride: 159},
		{Lo: 0x11661, Hi: 0x1166c, Stride: 1},
		{Lo: 0x119e2, Hi: 0x11a3f, Stride: 93},
		{Lo: 0x11a45, Hi: 0x11a9e, Stride: 89},
		{Lo: 0x11a9f, Hi: 0x11aa0, Stride: 1},
		{Lo: 0x11c70, Hi: 0x11c70, Stride: 1},
	},
}

// Break Opportunity Before and After
var BreakB2 = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x2014, Hi: 0x2e3a, Stride: 3622},
		{Lo: 0x2e3b, Hi: 0x2e3b, Stride: 1},
	},
}

// Zero Width Space
var BreakZW = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x200b, Hi: 0x200b, Stride: 1},
	},
}

// Combining Mark
var BreakCM = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0000, Hi: 0x0008, Stride: 1},
		{Lo: 0x000e, Hi: 0x001f, Stride: 1},
		{Lo: 0x007f, Hi: 0x0084, Stride: 1},
		{Lo: 0x0086, Hi: 0x009f, Stride: 1},
		{Lo: 0x0300, Hi: 0x034e, Stride: 1},
		{Lo: 0x0350, Hi: 0x035b, Stride: 1},
		{Lo: 0x0363, Hi: 0x036f, Stride: 1},
		{Lo: 0x0483, Hi: 0x0489, Stride: 1},
		{Lo: 0x0591, Hi: 0x05bd, Stride: 1},
		{Lo: 0x05bf, Hi: 0x05c1, Stride: 2},
		{Lo: 0x05c2, Hi: 0x05c4, Stride: 2},
		{Lo: 0x05c5, Hi: 0x05c7, Stride: 2},
		{Lo: 0x0610, Hi: 0x061a, Stride: 1},
		{Lo: 0x061c, Hi: 0x064b, Stride: 47},
		{Lo: 0x064c, Hi: 0x065f, Stride: 1},
		{Lo: 0x0670, Hi: 0x06d6, Stride: 102},
		{Lo: 0x06d7, Hi: 0x06dc, Stride: 1},
		{Lo: 0x06df, Hi: 0x06e4, Stride: 1},
		{Lo: 0x06e7, Hi: 0x06e8, Stride: 1},
		{Lo: 0x06ea, Hi: 0x06ed, Stride: 1},
		{Lo: 0x0711, Hi: 0x0730, Stride: 31},
		{Lo: 0x0731, Hi: 0x074a, Stride: 1},
		{Lo: 0x07a6, Hi: 0x07b0, Stride: 1},
		{Lo: 0x07eb, Hi: 0x07f3, Stride: 1},
		{Lo: 0x07fd, Hi: 0x0816, Stride: 25},
		{Lo: 0x0817, Hi: 0x0819, Stride: 1},
		{Lo: 0x081b, Hi: 0x0823, Stride: 1},
		{Lo: 0x0825, Hi: 0x0827, Stride: 1},
		{Lo: 0x0829, Hi: 0x082d, Stride: 1},
		{Lo: 0x0859, Hi: 0x085b, Stride: 1},
		{Lo: 0x08d3, Hi: 0x08e1, Stride: 1},
		{Lo: 0x08e3, Hi: 0x0903, Stride: 1},
		{Lo: 0x093a, Hi: 0x093c, Stride: 1},
		{Lo: 0x093e, Hi: 0x094f, Stride: 1},
		{Lo: 0x0951, Hi: 0x0957, Stride: 1},
		{Lo: 0x0962, Hi: 0x0963, Stride: 1},
		{Lo: 0x0981, Hi: 0x0983, Stride: 1},
		{Lo: 0x09bc, Hi: 0x09be, Stride: 2},
		{Lo: 0x09bf, Hi: 0x09c4, Stride: 1},
		{Lo: 0x09c7, Hi: 0x09c8, Stride: 1},
		{Lo: 0x09cb, Hi: 0x09cd, Stride: 1},
		{Lo: 0x09d7, Hi: 0x09e2, Stride: 11},
		{Lo: 0x09e3, Hi: 0x09fe, Stride: 27},
		{Lo: 0x0a01, Hi: 0x0a03, Stride: 1},
		{Lo: 0x0a3c, Hi: 0x0a3e, Stride: 2},
		{Lo: 0x0a3f, Hi: 0x0a42, Stride: 1},
		{Lo: 0x0a47, Hi: 0x0a48, Stride: 1},
		{Lo: 0x0a4b, Hi: 0x0a4d, Stride: 1},
		{Lo: 0x0a51, Hi: 0x0a70, Stride: 31},
		{Lo: 0x0a71, Hi: 0x0a75, Stride: 4},
		{Lo: 0x0a81, Hi: 0x0a83, Stride: 1},
		{Lo: 0x0abc, Hi: 0x0abe, Stride: 2},
		{Lo: 0x0abf, Hi: 0x0ac5, Stride: 1},
		{Lo: 0x0ac7, Hi: 0x0ac9, Stride: 1},
		{Lo: 0x0acb, Hi: 0x0acd, Stride: 1},
		{Lo: 0x0ae2, Hi: 0x0ae3, Stride: 1},
		{Lo: 0x0afa, Hi: 0x0aff, Stride: 1},
		{Lo: 0x0b01, Hi: 0x0b03, Stride: 1},
		{Lo: 0x0b3c, Hi: 0x0b3e, Stride: 2},
		{Lo: 0x0b3f, Hi: 0x0b44, Stride: 1},
		{Lo: 0x0b47, Hi: 0x0b48, Stride: 1},
		{Lo: 0x0b4b, Hi: 0x0b4d, Stride: 1},
		{Lo: 0x0b55, Hi: 0x0b57, Stride: 1},
		{Lo: 0x0b62, Hi: 0x0b63, Stride: 1},
		{Lo: 0x0b82, Hi: 0x0bbe, Stride: 60},
		{Lo: 0x0bbf, Hi: 0x0bc2, Stride: 1},
		{Lo: 0x0bc6, Hi: 0x0bc8, Stride: 1},
		{Lo: 0x0bca, Hi: 0x0bcd, Stride: 1},
		{Lo: 0x0bd7, Hi: 0x0c00, Stride: 41},
		{Lo: 0x0c01, Hi: 0x0c04, Stride: 1},
		{Lo: 0x0c3e, Hi: 0x0c44, Stride: 1},
		{Lo: 0x0c46, Hi: 0x0c48, Stride: 1},
		{Lo: 0x0c4a, Hi: 0x0c4d, Stride: 1},
		{Lo: 0x0c55, Hi: 0x0c56, Stride: 1},
		{Lo: 0x0c62, Hi: 0x0c63, Stride: 1},
		{Lo: 0x0c81, Hi: 0x0c83, Stride: 1},
		{Lo: 0x0cbc, Hi: 0x0cbe, Stride: 2},
		{Lo: 0x0cbf, Hi: 0x0cc4, Stride: 1},
		{Lo: 0x0cc6, Hi: 0x0cc8, Stride: 1},
		{Lo: 0x0cca, Hi: 0x0ccd, Stride: 1},
		{Lo: 0x0cd5, Hi: 0x0cd6, Stride: 1},
		{Lo: 0x0ce2, Hi: 0x0ce3, Stride: 1},
		{Lo: 0x0d00, Hi: 0x0d03, Stride: 1},
		{Lo: 0x0d3b, Hi: 0x0d3c, Stride: 1},
		{Lo: 0x0d3e, Hi: 0x0d44, Stride: 1},
		{Lo: 0x0d46, Hi: 0x0d48, Stride: 1},
		{Lo: 0x0d4a, Hi: 0x0d4d, Stride: 1},
		{Lo: 0x0d57, Hi: 0x0d62, Stride: 11},
		{Lo: 0x0d63, Hi: 0x0d81, Stride: 30},
		{Lo: 0x0d82, Hi: 0x0d83, Stride: 1},
		{Lo: 0x0dca, Hi: 0x0dcf, Stride: 5},
		{Lo: 0x0dd0, Hi: 0x0dd4, Stride: 1},
		{Lo: 0x0dd6, Hi: 0x0dd8, Stride: 2},
		{Lo: 0x0dd9, Hi: 0x0ddf, Stride: 1},
		{Lo: 0x0df2, Hi: 0x0df3, Stride: 1},
		{Lo: 0x0f18, Hi: 0x0f19, Stride: 1},
		{Lo: 0x0f35, Hi: 0x0f39, Stride: 2},
		{Lo: 0x0f3e, Hi: 0x0f3f, Stride: 1},
		{Lo: 0x0f71, Hi: 0x0f7e, Stride: 1},
		{Lo: 0x0f80, Hi: 0x0f84, Stride: 1},
		{Lo: 0x0f86, Hi: 0x0f87, Stride: 1},
		{Lo: 0x0f8d, Hi: 0x0f97, Stride: 1},
		{Lo: 0x0f99, Hi: 0x0fbc, Stride: 1},
		{Lo: 0x0fc6, Hi: 0x135d, Stride: 919},
		{Lo: 0x135e, Hi: 0x135f, Stride: 1},
		{Lo: 0x1712, Hi: 0x1714, Stride: 1},
		{Lo: 0x1732, Hi: 0x1734, Stride: 1},
		{Lo: 0x1752, Hi: 0x1753, Stride: 1},
		{Lo: 0x1772, Hi: 0x1773, Stride: 1},
		{Lo: 0x180b, Hi: 0x180d, Stride: 1},
		{Lo: 0x1885, Hi: 0x1886, Stride: 1},
		{Lo: 0x18a9, Hi: 0x1920, Stride: 119},
		{Lo: 0x1921, Hi: 0x192b, Stride: 1},
		{Lo: 0x1930, Hi: 0x193b, Stride: 1},
		{Lo: 0x1a17, Hi: 0x1a1b, Stride: 1},
		{Lo: 0x1a7f, Hi: 0x1ab0, Stride: 49},
		{Lo: 0x1ab1, Hi: 0x1ac0, Stride: 1},
		{Lo: 0x1b00, Hi: 0x1b04, Stride: 1},
		{Lo: 0x1b34, Hi: 0x1b44, Stride: 1},
		{Lo: 0x1b6b, Hi: 0x1b73, Stride: 1},
		{Lo: 0x1b80, Hi: 0x1b82, Stride: 1},
		{Lo: 0x1ba1, Hi: 0x1bad, Stride: 1},
		{Lo: 0x1be6, Hi: 0x1bf3, Stride: 1},
		{Lo: 0x1c24, Hi: 0x1c37, Stride: 1},
		{Lo: 0x1cd0, Hi: 0x1cd2, Stride: 1},
		{Lo: 0x1cd4, Hi: 0x1ce8, Stride: 1},
		{Lo: 0x1ced, Hi: 0x1cf4, Stride: 7},
		{Lo: 0x1cf7, Hi: 0x1cf9, Stride: 1},
		{Lo: 0x1dc0, Hi: 0x1df9, Stride: 1},
		{Lo: 0x1dfb, Hi: 0x1dff, Stride: 1},
		{Lo: 0x200c, Hi: 0x200e, Stride: 2},
		{Lo: 0x200f, Hi: 0x202a, Stride: 27},
		{Lo: 0x202b, Hi: 0x202e, Stride: 1},
		{Lo: 0x2066, Hi: 0x206f, Stride: 1},
		{Lo: 0x20d0, Hi: 0x20f0, Stride: 1},
		{Lo: 0x2cef, Hi: 0x2cf1, Stride: 1},
		{Lo: 0x2d7f, Hi: 0x2de0, Stride: 97},
		{Lo: 0x2de1, Hi: 0x2dff, Stride: 1},
		{Lo: 0x302a, Hi: 0x302f, Stride: 1},
		{Lo: 0x3035, Hi: 0x3099, Stride: 100},
		{Lo: 0x309a, Hi: 0xa66f, Stride: 30165},
		{Lo: 0xa670, Hi: 0xa672, Stride: 1},
		{Lo: 0xa674, Hi: 0xa67d, Stride: 1},
		{Lo: 0xa69e, Hi: 0xa69f, Stride: 1},
		{Lo: 0xa6f0, Hi: 0xa6f1, Stride: 1},
		{Lo: 0xa802, Hi: 0xa806, Stride: 4},
		{Lo: 0xa80b, Hi: 0xa823, Stride: 24},
		{Lo: 0xa824, Hi: 0xa827, Stride: 1},
		{Lo: 0xa82c, Hi: 0xa880, Stride: 84},
		{Lo: 0xa881, Hi: 0xa8b4, Stride: 51},
		{Lo: 0xa8b5, Hi: 0xa8c5, Stride: 1},
		{Lo: 0xa8e0, Hi: 0xa8f1, Stride: 1},
		{Lo: 0xa8ff, Hi: 0xa926, Stride: 39},
		{Lo: 0xa927, Hi: 0xa92d, Stride: 1},
		{Lo: 0xa947, Hi: 0xa953, Stride: 1},
		{Lo: 0xa980, Hi: 0xa983, Stride: 1},
		{Lo: 0xa9b3, Hi: 0xa9c0, Stride: 1},
		{Lo: 0xaa29, Hi: 0xaa36, Stride: 1},
		{Lo: 0xaa43, Hi: 0xaa4c, Stride: 9},
		{Lo: 0xaa4d, Hi: 0xaaeb, Stride: 158},
		{Lo: 0xaaec, Hi: 0xaaef, Stride: 1},
		{Lo: 0xaaf5, Hi: 0xaaf6, Stride: 1},
		{Lo: 0xabe3, Hi: 0xabea, Stride: 1},
		{Lo: 0xabec, Hi: 0xabed, Stride: 1},
		{Lo: 0xfb1e, Hi: 0xfe00, Stride: 738},
		{Lo: 0xfe01, Hi: 0xfe0f, Stride: 1},
		{Lo: 0xfe20, Hi: 0xfe2f, Stride: 1},
		{Lo: 0xfff9, Hi: 0xfffb, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x101fd, Hi: 0x102e0, Stride: 227},
		{Lo: 0x10376, Hi: 0x1037a, Stride: 1},
		{Lo: 0x10a01, Hi: 0x10a03, Stride: 1},
		{Lo: 0x10a05, Hi: 0x10a06, Stride: 1},
		{Lo: 0x10a0c, Hi: 0x10a0f, Stride: 1},
		{Lo: 0x10a38, Hi: 0x10a3a, Stride: 1},
		{Lo: 0x10a3f, Hi: 0x10ae5, Stride: 166},
		{Lo: 0x10ae6, Hi: 0x10d24, Stride: 574},
		{Lo: 0x10d25, Hi: 0x10d27, Stride: 1},
		{Lo: 0x10eab, Hi: 0x10eac, Stride: 1},
		{Lo: 0x10f46, Hi: 0x10f50, Stride: 1},
		{Lo: 0x11000, Hi: 0x11002, Stride: 1},
		{Lo: 0x11038, Hi: 0x11046, Stride: 1},
		{Lo: 0x1107f, Hi: 0x11082, Stride: 1},
		{Lo: 0x110b0, Hi: 0x110ba, Stride: 1},
		{Lo: 0x11100, Hi: 0x11102, Stride: 1},
		{Lo: 0x11127, Hi: 0x11134, Stride: 1},
		{Lo: 0x11145, Hi: 0x11146, Stride: 1},
		{Lo: 0x11173, Hi: 0x11180, Stride: 13},
		{Lo: 0x11181, Hi: 0x11182, Stride: 1},
		{Lo: 0x111b3, Hi: 0x111c0, Stride: 1},
		{Lo: 0x111c9, Hi: 0x111cc, Stride: 1},
		{Lo: 0x111ce, Hi: 0x111cf, Stride: 1},
		{Lo: 0x1122c, Hi: 0x11237, Stride: 1},
		{Lo: 0x1123e, Hi: 0x112df, Stride: 161},
		{Lo: 0x112e0, Hi: 0x112ea, Stride: 1},
		{Lo: 0x11300, Hi: 0x11303, Stride: 1},
		{Lo: 0x1133b, Hi: 0x1133c, Stride: 1},
		{Lo: 0x1133e, Hi: 0x11344, Stride: 1},
		{Lo: 0x11347, Hi: 0x11348, Stride: 1},
		{Lo: 0x1134b, Hi: 0x1134d, Stride: 1},
		{Lo: 0x11357, Hi: 0x11362, Stride: 11},
		{Lo: 0x11363, Hi: 0x11366, Stride: 3},
		{Lo: 0x11367, Hi: 0x1136c, Stride: 1},
		{Lo: 0x11370, Hi: 0x11374, Stride: 1},
		{Lo: 0x11435, Hi: 0x11446, Stride: 1},
		{Lo: 0x1145e, Hi: 0x114b0, Stride: 82},
		{Lo: 0x114b1, Hi: 0x114c3, Stride: 1},
		{Lo: 0x115af, Hi: 0x115b5, Stride: 1},
		{Lo: 0x115b8, Hi: 0x115c0, Stride: 1},
		{Lo: 0x115dc, Hi: 0x115dd, Stride: 1},
		{Lo: 0x11630, Hi: 0x11640, Stride: 1},
		{Lo: 0x116ab, Hi: 0x116b7, Stride: 1},
		{Lo: 0x1182c, Hi: 0x1183a, Stride: 1},
		{Lo: 0x11930, Hi: 0x11935, Stride: 1},
		{Lo: 0x11937, Hi: 0x11938, Stride: 1},
		{Lo: 0x1193b, Hi: 0x1193e, Stride: 1},
		{Lo: 0x11940, Hi: 0x11942, Stride: 2},
		{Lo: 0x11943, Hi: 0x119d1, Stride: 142},
		{Lo: 0x119d2, Hi: 0x119d7, Stride: 1},
		{Lo: 0x119da, Hi: 0x119e0, Stride: 1},
		{Lo: 0x119e4, Hi: 0x11a01, Stride: 29},
		{Lo: 0x11a02, Hi: 0x11a0a, Stride: 1},
		{Lo: 0x11a33, Hi: 0x11a39, Stride: 1},
		{Lo: 0x11a3b, Hi: 0x11a3e, Stride: 1},
		{Lo: 0x11a47, Hi: 0x11a51, Stride: 10},
		{Lo: 0x11a52, Hi: 0x11a5b, Stride: 1},
		{Lo: 0x11a8a, Hi: 0x11a99, Stride: 1},
		{Lo: 0x11c2f, Hi: 0x11c36, Stride: 1},
		{Lo: 0x11c38, Hi: 0x11c3f, Stride: 1},
		{Lo: 0x11c92, Hi: 0x11ca7, Stride: 1},
		{Lo: 0x11ca9, Hi: 0x11cb6, Stride: 1},
		{Lo: 0x11d31, Hi: 0x11d36, Stride: 1},
		{Lo: 0x11d3a, Hi: 0x11d3c, Stride: 2},
		{Lo: 0x11d3d, Hi: 0x11d3f, Stride: 2},
		{Lo: 0x11d40, Hi: 0x11d45, Stride: 1},
		{Lo: 0x11d47, Hi: 0x11d8a, Stride: 67},
		{Lo: 0x11d8b, Hi: 0x11d8e, Stride: 1},
		{Lo: 0x11d90, Hi: 0x11d91, Stride: 1},
		{Lo: 0x11d93, Hi: 0x11d97, Stride: 1},
		{Lo: 0x11ef3, Hi: 0x11ef6, Stride: 1},
		{Lo: 0x16af0, Hi: 0x16af4, Stride: 1},
		{Lo: 0x16b30, Hi: 0x16b36, Stride: 1},
		{Lo: 0x16f4f, Hi: 0x16f51, Stride: 2},
		{Lo: 0x16f52, Hi: 0x16f87, Stride: 1},
		{Lo: 0x16f8f, Hi: 0x16f92, Stride: 1},
		{Lo: 0x16ff0, Hi: 0x16ff1, Stride: 1},
		{Lo: 0x1bc9d, Hi: 0x1bc9e, Stride: 1},
		{Lo: 0x1bca0, Hi: 0x1bca3, Stride: 1},
		{Lo: 0x1d165, Hi: 0x1d169, Stride: 1},
		{Lo: 0x1d16d, Hi: 0x1d182, Stride: 1},
		{Lo: 0x1d185, Hi: 0x1d18b, Stride: 1},
		{Lo: 0x1d1aa, Hi: 0x1d1ad, Stride: 1},
		{Lo: 0x1d242, Hi: 0x1d244, Stride: 1},
		{Lo: 0x1da00, Hi: 0x1da36, Stride: 1},
		{Lo: 0x1da3b, Hi: 0x1da6c, Stride: 1},
		{Lo: 0x1da75, Hi: 0x1da84, Stride: 15},
		{Lo: 0x1da9b, Hi: 0x1da9f, Stride: 1},
		{Lo: 0x1daa1, Hi: 0x1daaf, Stride: 1},
		{Lo: 0x1e000, Hi: 0x1e006, Stride: 1},
		{Lo: 0x1e008, Hi: 0x1e018, Stride: 1},
		{Lo: 0x1e01b, Hi: 0x1e021, Stride: 1},
		{Lo: 0x1e023, Hi: 0x1e024, Stride: 1},
		{Lo: 0x1e026, Hi: 0x1e02a, Stride: 1},
		{Lo: 0x1e130, Hi: 0x1e136, Stride: 1},
		{Lo: 0x1e2ec, Hi: 0x1e2ef, Stride: 1},
		{Lo: 0x1e8d0, Hi: 0x1e8d6, Stride: 1},
		{Lo: 0x1e944, Hi: 0x1e94a, Stride: 1},
		{Lo: 0xe0001, Hi: 0xe0020, Stride: 31},
		{Lo: 0xe0021, Hi: 0xe007f, Stride: 1},
		{Lo: 0xe0100, Hi: 0xe01ef, Stride: 1},
	},
	LatinOffset: 4,
}

// Emoji Base
var BreakEB = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x261d, Hi: 0x26f9, Stride: 220},
		{Lo: 0x270a, Hi: 0x270d, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x1f385, Hi: 0x1f3c2, Stride: 61},
		{Lo: 0x1f3c3, Hi: 0x1f3c4, Stride: 1},
		{Lo: 0x1f3c7, Hi: 0x1f3ca, Stride: 3},
		{Lo: 0x1f3cb, Hi: 0x1f3cc, Stride: 1},
		{Lo: 0x1f442, Hi: 0x1f443, Stride: 1},
		{Lo: 0x1f446, Hi: 0x1f450, Stride: 1},
		{Lo: 0x1f466, Hi: 0x1f478, Stride: 1},
		{Lo: 0x1f47c, Hi: 0x1f481, Stride: 5},
		{Lo: 0x1f482, Hi: 0x1f483, Stride: 1},
		{Lo: 0x1f485, Hi: 0x1f487, Stride: 1},
		{Lo: 0x1f48f, Hi: 0x1f491, Stride: 2},
		{Lo: 0x1f4aa, Hi: 0x1f574, Stride: 202},
		{Lo: 0x1f575, Hi: 0x1f57a, Stride: 5},
		{Lo: 0x1f590, Hi: 0x1f595, Stride: 5},
		{Lo: 0x1f596, Hi: 0x1f645, Stride: 175},
		{Lo: 0x1f646, Hi: 0x1f647, Stride: 1},
		{Lo: 0x1f64b, Hi: 0x1f64f, Stride: 1},
		{Lo: 0x1f6a3, Hi: 0x1f6b4, Stride: 17},
		{Lo: 0x1f6b5, Hi: 0x1f6b6, Stride: 1},
		{Lo: 0x1f6c0, Hi: 0x1f6cc, Stride: 12},
		{Lo: 0x1f90c, Hi: 0x1f90f, Stride: 3},
		{Lo: 0x1f918, Hi: 0x1f91f, Stride: 1},
		{Lo: 0x1f926, Hi: 0x1f930, Stride: 10},
		{Lo: 0x1f931, Hi: 0x1f939, Stride: 1},
		{Lo: 0x1f93c, Hi: 0x1f93e, Stride: 1},
		{Lo: 0x1f977, Hi: 0x1f9b5, Stride: 62},
		{Lo: 0x1f9b6, Hi: 0x1f9b8, Stride: 2},
		{Lo: 0x1f9b9, Hi: 0x1f9bb, Stride: 2},
		{Lo: 0x1f9cd, Hi: 0x1f9cf, Stride: 1},
		{Lo: 0x1f9d1, Hi: 0x1f9dd, Stride: 1},
	},
}

// Emoji Modifier
var BreakEM = &unicode.RangeTable{
	R32: []unicode.Range32{
		{Lo: 0x1f3fb, Hi: 0x1f3ff, Stride: 1},
	},
}

// Word Joiner
var BreakWJ = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x2060, Hi: 0xfeff, Stride: 56991},
	},
}

// Zero width joiner
var BreakZWJ = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x200d, Hi: 0x200d, Stride: 1},
	},
}

// Hangul LV Syllable
var BreakH2 = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xac00, Hi: 0xd788, Stride: 28},
	},
}

// Hangul LVT Syllable
var BreakH3 = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xac01, Hi: 0xac1b, Stride: 1},
		{Lo: 0xac1d, Hi: 0xac37, Stride: 1},
		{Lo: 0xac39, Hi: 0xac53, Stride: 1},
		{Lo: 0xac55, Hi: 0xac6f, Stride: 1},
		{Lo: 0xac71, Hi: 0xac8b, Stride: 1},
		{Lo: 0xac8d, Hi: 0xaca7, Stride: 1},
		{Lo: 0xaca9, Hi: 0xacc3, Stride: 1},
		{Lo: 0xacc5, Hi: 0xacdf, Stride: 1},
		{Lo: 0xace1, Hi: 0xacfb, Stride: 1},
		{Lo: 0xacfd, Hi: 0xad17, Stride: 1},
		{Lo: 0xad19, Hi: 0xad33, Stride: 1},
		{Lo: 0xad35, Hi: 0xad4f, Stride: 1},
		{Lo: 0xad51, Hi: 0xad6b, Stride: 1},
		{Lo: 0xad6d, Hi: 0xad87, Stride: 1},
		{Lo: 0xad89, Hi: 0xada3, Stride: 1},
		{Lo: 0xada5, Hi: 0xadbf, Stride: 1},
		{Lo: 0xadc1, Hi: 0xaddb, Stride: 1},
		{Lo: 0xaddd, Hi: 0xadf7, Stride: 1},
		{Lo: 0xadf9, Hi: 0xae13, Stride: 1},
		{Lo: 0xae15, Hi: 0xae2f, Stride: 1},
		{Lo: 0xae31, Hi: 0xae4b, Stride: 1},
		{Lo: 0xae4d, Hi: 0xae67, Stride: 1},
		{Lo: 0xae69, Hi: 0xae83, Stride: 1},
		{Lo: 0xae85, Hi: 0xae9f, Stride: 1},
		{Lo: 0xaea1, Hi: 0xaebb, Stride: 1},
		{Lo: 0xaebd, Hi: 0xaed7, Stride: 1},
		{Lo: 0xaed9, Hi: 0xaef3, Stride: 1},
		{Lo: 0xaef5, Hi: 0xaf0f, Stride: 1},
		{Lo: 0xaf11, Hi: 0xaf2b, Stride: 1},
		{Lo: 0xaf2d, Hi: 0xaf47, Stride: 1},
		{Lo: 0xaf49, Hi: 0xaf63, Stride: 1},
		{Lo: 0xaf65, Hi: 0xaf7f, Stride: 1},
		{Lo: 0xaf81, Hi: 0xaf9b, Stride: 1},
		{Lo: 0xaf9d, Hi: 0xafb7, Stride: 1},
		{Lo: 0xafb9, Hi: 0xafd3, Stride: 1},
		{Lo: 0xafd5, Hi: 0xafef, Stride: 1},
		{Lo: 0xaff1, Hi: 0xb00b, Stride: 1},
		{Lo: 0xb00d, Hi: 0xb027, Stride: 1},
		{Lo: 0xb029, Hi: 0xb043, Stride: 1},
		{Lo: 0xb045, Hi: 0xb05f, Stride: 1},
		{Lo: 0xb061, Hi: 0xb07b, Stride: 1},
		{Lo: 0xb07d, Hi: 0xb097, Stride: 1},
		{Lo: 0xb099, Hi: 0xb0b3, Stride: 1},
		{Lo: 0xb0b5, Hi: 0xb0cf, Stride: 1},
		{Lo: 0xb0d1, Hi: 0xb0eb, Stride: 1},
		{Lo: 0xb0ed, Hi: 0xb107, Stride: 1},
		{Lo: 0xb109, Hi: 0xb123, Stride: 1},
		{Lo: 0xb125, Hi: 0xb13f, Stride: 1},
		{Lo: 0xb141, Hi: 0xb15b, Stride: 1},
		{Lo: 0xb15d, Hi: 0xb177, Stride: 1},
		{Lo: 0xb179, Hi: 0xb193, Stride: 1},
		{Lo: 0xb195, Hi: 0xb1af, Stride: 1},
		{Lo: 0xb1b1, Hi: 0xb1cb, Stride: 1},
		{Lo: 0xb1cd, Hi: 0xb1e7, Stride: 1},
		{Lo: 0xb1e9, Hi: 0xb203, Stride: 1},
		{Lo: 0xb205, Hi: 0xb21f, Stride: 1},
		{Lo: 0xb221, Hi: 0xb23b, Stride: 1},
		{Lo: 0xb23d, Hi: 0xb257, Stride: 1},
		{Lo: 0xb259, Hi: 0xb273, Stride: 1},
		{Lo: 0xb275, Hi: 0xb28f, Stride: 1},
		{Lo: 0xb291, Hi: 0xb2ab, Stride: 1},
		{Lo: 0xb2ad, Hi: 0xb2c7, Stride: 1},
		{Lo: 0xb2c9, Hi: 0xb2e3, Stride: 1},
		{Lo: 0xb2e5, Hi: 0xb2ff, Stride: 1},
		{Lo: 0xb301, Hi: 0xb31b, Stride: 1},
		{Lo: 0xb31d, Hi: 0xb337, Stride: 1},
		{Lo: 0xb339, Hi: 0xb353, Stride: 1},
		{Lo: 0xb355, Hi: 0xb36f, Stride: 1},
		{Lo: 0xb371, Hi: 0xb38b, Stride: 1},
		{Lo: 0xb38d, Hi: 0xb3a7, Stride: 1},
		{Lo: 0xb3a9, Hi: 0xb3c3, Stride: 1},
		{Lo: 0xb3c5, Hi: 0xb3df, Stride: 1},
		{Lo: 0xb3e1, Hi: 0xb3fb, Stride: 1},
		{Lo: 0xb3fd, Hi: 0xb417, Stride: 1},
		{Lo: 0xb419, Hi: 0xb433, Stride: 1},
		{Lo: 0xb435, Hi: 0xb44f, Stride: 1},
		{Lo: 0xb451, Hi: 0xb46b, Stride: 1},
		{Lo: 0xb46d, Hi: 0xb487, Stride: 1},
		{Lo: 0xb489, Hi: 0xb4a3, Stride: 1},
		{Lo: 0xb4a5, Hi: 0xb4bf, Stride: 1},
		{Lo: 0xb4c1, Hi: 0xb4db, Stride: 1},
		{Lo: 0xb4dd, Hi: 0xb4f7, Stride: 1},
		{Lo: 0xb4f9, Hi: 0xb513, Stride: 1},
		{Lo: 0xb515, Hi: 0xb52f, Stride: 1},
		{Lo: 0xb531, Hi: 0xb54b, Stride: 1},
		{Lo: 0xb54d, Hi: 0xb567, Stride: 1},
		{Lo: 0xb569, Hi: 0xb583, Stride: 1},
		{Lo: 0xb585, Hi: 0xb59f, Stride: 1},
		{Lo: 0xb5a1, Hi: 0xb5bb, Stride: 1},
		{Lo: 0xb5bd, Hi: 0xb5d7, Stride: 1},
		{Lo: 0xb5d9, Hi: 0xb5f3, Stride: 1},
		{Lo: 0xb5f5, Hi: 0xb60f, Stride: 1},
		{Lo: 0xb611, Hi: 0xb62b, Stride: 1},
		{Lo: 0xb62d, Hi: 0xb647, Stride: 1},
		{Lo: 0xb649, Hi: 0xb663, Stride: 1},
		{Lo: 0xb665, Hi: 0xb67f, Stride: 1},
		{Lo: 0xb681, Hi: 0xb69b, Stride: 1},
		{Lo: 0xb69d, Hi: 0xb6b7, Stride: 1},
		{Lo: 0xb6b9, Hi: 0xb6d3, Stride: 1},
		{Lo: 0xb6d5, Hi: 0xb6ef, Stride: 1},
		{Lo: 0xb6f1, Hi: 0xb70b, Stride: 1},
		{Lo: 0xb70d, Hi: 0xb727, Stride: 1},
		{Lo: 0xb729, Hi: 0xb743, Stride: 1},
		{Lo: 0xb745, Hi: 0xb75f, Stride: 1},
		{Lo: 0xb761, Hi: 0xb77b, Stride: 1},
		{Lo: 0xb77d, Hi: 0xb797, Stride: 1},
		{Lo: 0xb799, Hi: 0xb7b3, Stride: 1},
		{Lo: 0xb7b5, Hi: 0xb7cf, Stride: 1},
		{Lo: 0xb7d1, Hi: 0xb7eb, Stride: 1},
		{Lo: 0xb7ed, Hi: 0xb807, Stride: 1},
		{Lo: 0xb809, Hi: 0xb823, Stride: 1},
		{Lo: 0xb825, Hi: 0xb83f, Stride: 1},
		{Lo: 0xb841, Hi: 0xb85b, Stride: 1},
		{Lo: 0xb85d, Hi: 0xb877, Stride: 1},
		{Lo: 0xb879, Hi: 0xb893, Stride: 1},
		{Lo: 0xb895, Hi: 0xb8af, Stride: 1},
		{Lo: 0xb8b1, Hi: 0xb8cb, Stride: 1},
		{Lo: 0xb8cd, Hi: 0xb8e7, Stride: 1},
		{Lo: 0xb8e9, Hi: 0xb903, Stride: 1},
		{Lo: 0xb905, Hi: 0xb91f, Stride: 1},
		{Lo: 0xb921, Hi: 0xb93b, Stride: 1},
		{Lo: 0xb93d, Hi: 0xb957, Stride: 1},
		{Lo: 0xb959, Hi: 0xb973, Stride: 1},
		{Lo: 0xb975, Hi: 0xb98f, Stride: 1},
		{Lo: 0xb991, Hi: 0xb9ab, Stride: 1},
		{Lo: 0xb9ad, Hi: 0xb9c7, Stride: 1},
		{Lo: 0xb9c9, Hi: 0xb9e3, Stride: 1},
		{Lo: 0xb9e5, Hi: 0xb9ff, Stride: 1},
		{Lo: 0xba01, Hi: 0xba1b, Stride: 1},
		{Lo: 0xba1d, Hi: 0xba37, Stride: 1},
		{Lo: 0xba39, Hi: 0xba53, Stride: 1},
		{Lo: 0xba55, Hi: 0xba6f, Stride: 1},
		{Lo: 0xba71, Hi: 0xba8b, Stride: 1},
		{Lo: 0xba8d, Hi: 0xbaa7, Stride: 1},
		{Lo: 0xbaa9, Hi: 0xbac3, Stride: 1},
		{Lo: 0xbac5, Hi: 0xbadf, Stride: 1},
		{Lo: 0xbae1, Hi: 0xbafb, Stride: 1},
		{Lo: 0xbafd, Hi: 0xbb17, Stride: 1},
		{Lo: 0xbb19, Hi: 0xbb33, Stride: 1},
		{Lo: 0xbb35, Hi: 0xbb4f, Stride: 1},
		{Lo: 0xbb51, Hi: 0xbb6b, Stride: 1},
		{Lo: 0xbb6d, Hi: 0xbb87, Stride: 1},
		{Lo: 0xbb89, Hi: 0xbba3, Stride: 1},
		{Lo: 0xbba5, Hi: 0xbbbf, Stride: 1},
		{Lo: 0xbbc1, Hi: 0xbbdb, Stride: 1},
		{Lo: 0xbbdd, Hi: 0xbbf7, Stride: 1},
		{Lo: 0xbbf9, Hi: 0xbc13, Stride: 1},
		{Lo: 0xbc15, Hi: 0xbc2f, Stride: 1},
		{Lo: 0xbc31, Hi: 0xbc4b, Stride: 1},
		{Lo: 0xbc4d, Hi: 0xbc67, Stride: 1},
		{Lo: 0xbc69, Hi: 0xbc83, Stride: 1},
		{Lo: 0xbc85, Hi: 0xbc9f, Stride: 1},
		{Lo: 0xbca1, Hi: 0xbcbb, Stride: 1},
		{Lo: 0xbcbd, Hi: 0xbcd7, Stride: 1},
		{Lo: 0xbcd9, Hi: 0xbcf3, Stride: 1},
		{Lo: 0xbcf5, Hi: 0xbd0f, Stride: 1},
		{Lo: 0xbd11, Hi: 0xbd2b, Stride: 1},
		{Lo: 0xbd2d, Hi: 0xbd47, Stride: 1},
		{Lo: 0xbd49, Hi: 0xbd63, Stride: 1},
		{Lo: 0xbd65, Hi: 0xbd7f, Stride: 1},
		{Lo: 0xbd81, Hi: 0xbd9b, Stride: 1},
		{Lo: 0xbd9d, Hi: 0xbdb7, Stride: 1},
		{Lo: 0xbdb9, Hi: 0xbdd3, Stride: 1},
		{Lo: 0xbdd5, Hi: 0xbdef, Stride: 1},
		{Lo: 0xbdf1, Hi: 0xbe0b, Stride: 1},
		{Lo: 0xbe0d, Hi: 0xbe27, Stride: 1},
		{Lo: 0xbe29, Hi: 0xbe43, Stride: 1},
		{Lo: 0xbe45, Hi: 0xbe5f, Stride: 1},
		{Lo: 0xbe61, Hi: 0xbe7b, Stride: 1},
		{Lo: 0xbe7d, Hi: 0xbe97, Stride: 1},
		{Lo: 0xbe99, Hi: 0xbeb3, Stride: 1},
		{Lo: 0xbeb5, Hi: 0xbecf, Stride: 1},
		{Lo: 0xbed1, Hi: 0xbeeb, Stride: 1},
		{Lo: 0xbeed, Hi: 0xbf07, Stride: 1},
		{Lo: 0xbf09, Hi: 0xbf23, Stride: 1},
		{Lo: 0xbf25, Hi: 0xbf3f, Stride: 1},
		{Lo: 0xbf41, Hi: 0xbf5b, Stride: 1},
		{Lo: 0xbf5d, Hi: 0xbf77, Stride: 1},
		{Lo: 0xbf79, Hi: 0xbf93, Stride: 1},
		{Lo: 0xbf95, Hi: 0xbfaf, Stride: 1},
		{Lo: 0xbfb1, Hi: 0xbfcb, Stride: 1},
		{Lo: 0xbfcd, Hi: 0xbfe7, Stride: 1},
		{Lo: 0xbfe9, Hi: 0xc003, Stride: 1},
		{Lo: 0xc005, Hi: 0xc01f, Stride: 1},
		{Lo: 0xc021, Hi: 0xc03b, Stride: 1},
		{Lo: 0xc03d, Hi: 0xc057, Stride: 1},
		{Lo: 0xc059, Hi: 0xc073, Stride: 1},
		{Lo: 0xc075, Hi: 0xc08f, Stride: 1},
		{Lo: 0xc091, Hi: 0xc0ab, Stride: 1},
		{Lo: 0xc0ad, Hi: 0xc0c7, Stride: 1},
		{Lo: 0xc0c9, Hi: 0xc0e3, Stride: 1},
		{Lo: 0xc0e5, Hi: 0xc0ff, Stride: 1},
		{Lo: 0xc101, Hi: 0xc11b, Stride: 1},
		{Lo: 0xc11d, Hi: 0xc137, Stride: 1},
		{Lo: 0xc139, Hi: 0xc153, Stride: 1},
		{Lo: 0xc155, Hi: 0xc16f, Stride: 1},
		{Lo: 0xc171, Hi: 0xc18b, Stride: 1},
		{Lo: 0xc18d, Hi: 0xc1a7, Stride: 1},
		{Lo: 0xc1a9, Hi: 0xc1c3, Stride: 1},
		{Lo: 0xc1c5, Hi: 0xc1df, Stride: 1},
		{Lo: 0xc1e1, Hi: 0xc1fb, Stride: 1},
		{Lo: 0xc1fd, Hi: 0xc217, Stride: 1},
		{Lo: 0xc219, Hi: 0xc233, Stride: 1},
		{Lo: 0xc235, Hi: 0xc24f, Stride: 1},
		{Lo: 0xc251, Hi: 0xc26b, Stride: 1},
		{Lo: 0xc26d, Hi: 0xc287, Stride: 1},
		{Lo: 0xc289, Hi: 0xc2a3, Stride: 1},
		{Lo: 0xc2a5, Hi: 0xc2bf, Stride: 1},
		{Lo: 0xc2c1, Hi: 0xc2db, Stride: 1},
		{Lo: 0xc2dd, Hi: 0xc2f7, Stride: 1},
		{Lo: 0xc2f9, Hi: 0xc313, Stride: 1},
		{Lo: 0xc315, Hi: 0xc32f, Stride: 1},
		{Lo: 0xc331, Hi: 0xc34b, Stride: 1},
		{Lo: 0xc34d, Hi: 0xc367, Stride: 1},
		{Lo: 0xc369, Hi: 0xc383, Stride: 1},
		{Lo: 0xc385, Hi: 0xc39f, Stride: 1},
		{Lo: 0xc3a1, Hi: 0xc3bb, Stride: 1},
		{Lo: 0xc3bd, Hi: 0xc3d7, Stride: 1},
		{Lo: 0xc3d9, Hi: 0xc3f3, Stride: 1},
		{Lo: 0xc3f5, Hi: 0xc40f, Stride: 1},
		{Lo: 0xc411, Hi: 0xc42b, Stride: 1},
		{Lo: 0xc42d, Hi: 0xc447, Stride: 1},
		{Lo: 0xc449, Hi: 0xc463, Stride: 1},
		{Lo: 0xc465, Hi: 0xc47f, Stride: 1},
		{Lo: 0xc481, Hi: 0xc49b, Stride: 1},
		{Lo: 0xc49d, Hi: 0xc4b7, Stride: 1},
		{Lo: 0xc4b9, Hi: 0xc4d3, Stride: 1},
		{Lo: 0xc4d5, Hi: 0xc4ef, Stride: 1},
		{Lo: 0xc4f1, Hi: 0xc50b, Stride: 1},
		{Lo: 0xc50d, Hi: 0xc527, Stride: 1},
		{Lo: 0xc529, Hi: 0xc543, Stride: 1},
		{Lo: 0xc545, Hi: 0xc55f, Stride: 1},
		{Lo: 0xc561, Hi: 0xc57b, Stride: 1},
		{Lo: 0xc57d, Hi: 0xc597, Stride: 1},
		{Lo: 0xc599, Hi: 0xc5b3, Stride: 1},
		{Lo: 0xc5b5, Hi: 0xc5cf, Stride: 1},
		{Lo: 0xc5d1, Hi: 0xc5eb, Stride: 1},
		{Lo: 0xc5ed, Hi: 0xc607, Stride: 1},
		{Lo: 0xc609, Hi: 0xc623, Stride: 1},
		{Lo: 0xc625, Hi: 0xc63f, Stride: 1},
		{Lo: 0xc641, Hi: 0xc65b, Stride: 1},
		{Lo: 0xc65d, Hi: 0xc677, Stride: 1},
		{Lo: 0xc679, Hi: 0xc693, Stride: 1},
		{Lo: 0xc695, Hi: 0xc6af, Stride: 1},
		{Lo: 0xc6b1, Hi: 0xc6cb, Stride: 1},
		{Lo: 0xc6cd, Hi: 0xc6e7, Stride: 1},
		{Lo: 0xc6e9, Hi: 0xc703, Stride: 1},
		{Lo: 0xc705, Hi: 0xc71f, Stride: 1},
		{Lo: 0xc721, Hi: 0xc73b, Stride: 1},
		{Lo: 0xc73d, Hi: 0xc757, Stride: 1},
		{Lo: 0xc759, Hi: 0xc773, Stride: 1},
		{Lo: 0xc775, Hi: 0xc78f, Stride: 1},
		{Lo: 0xc791, Hi: 0xc7ab, Stride: 1},
		{Lo: 0xc7ad, Hi: 0xc7c7, Stride: 1},
		{Lo: 0xc7c9, Hi: 0xc7e3, Stride: 1},
		{Lo: 0xc7e5, Hi: 0xc7ff, Stride: 1},
		{Lo: 0xc801, Hi: 0xc81b, Stride: 1},
		{Lo: 0xc81d, Hi: 0xc837, Stride: 1},
		{Lo: 0xc839, Hi: 0xc853, Stride: 1},
		{Lo: 0xc855, Hi: 0xc86f, Stride: 1},
		{Lo: 0xc871, Hi: 0xc88b, Stride: 1},
		{Lo: 0xc88d, Hi: 0xc8a7, Stride: 1},
		{Lo: 0xc8a9, Hi: 0xc8c3, Stride: 1},
		{Lo: 0xc8c5, Hi: 0xc8df, Stride: 1},
		{Lo: 0xc8e1, Hi: 0xc8fb, Stride: 1},
		{Lo: 0xc8fd, Hi: 0xc917, Stride: 1},
		{Lo: 0xc919, Hi: 0xc933, Stride: 1},
		{Lo: 0xc935, Hi: 0xc94f, Stride: 1},
		{Lo: 0xc951, Hi: 0xc96b, Stride: 1},
		{Lo: 0xc96d, Hi: 0xc987, Stride: 1},
		{Lo: 0xc989, Hi: 0xc9a3, Stride: 1},
		{Lo: 0xc9a5, Hi: 0xc9bf, Stride: 1},
		{Lo: 0xc9c1, Hi: 0xc9db, Stride: 1},
		{Lo: 0xc9dd, Hi: 0xc9f7, Stride: 1},
		{Lo: 0xc9f9, Hi: 0xca13, Stride: 1},
		{Lo: 0xca15, Hi: 0xca2f, Stride: 1},
		{Lo: 0xca31, Hi: 0xca4b, Stride: 1},
		{Lo: 0xca4d, Hi: 0xca67, Stride: 1},
		{Lo: 0xca69, Hi: 0xca83, Stride: 1},
		{Lo: 0xca85, Hi: 0xca9f, Stride: 1},
		{Lo: 0xcaa1, Hi: 0xcabb, Stride: 1},
		{Lo: 0xcabd, Hi: 0xcad7, Stride: 1},
		{Lo: 0xcad9, Hi: 0xcaf3, Stride: 1},
		{Lo: 0xcaf5, Hi: 0xcb0f, Stride: 1},
		{Lo: 0xcb11, Hi: 0xcb2b, Stride: 1},
		{Lo: 0xcb2d, Hi: 0xcb47, Stride: 1},
		{Lo: 0xcb49, Hi: 0xcb63, Stride: 1},
		{Lo: 0xcb65, Hi: 0xcb7f, Stride: 1},
		{Lo: 0xcb81, Hi: 0xcb9b, Stride: 1},
		{Lo: 0xcb9d, Hi: 0xcbb7, Stride: 1},
		{Lo: 0xcbb9, Hi: 0xcbd3, Stride: 1},
		{Lo: 0xcbd5, Hi: 0xcbef, Stride: 1},
		{Lo: 0xcbf1, Hi: 0xcc0b, Stride: 1},
		{Lo: 0xcc0d, Hi: 0xcc27, Stride: 1},
		{Lo: 0xcc29, Hi: 0xcc43, Stride: 1},
		{Lo: 0xcc45, Hi: 0xcc5f, Stride: 1},
		{Lo: 0xcc61, Hi: 0xcc7b, Stride: 1},
		{Lo: 0xcc7d, Hi: 0xcc97, Stride: 1},
		{Lo: 0xcc99, Hi: 0xccb3, Stride: 1},
		{Lo: 0xccb5, Hi: 0xcccf, Stride: 1},
		{Lo: 0xccd1, Hi: 0xcceb, Stride: 1},
		{Lo: 0xcced, Hi: 0xcd07, Stride: 1},
		{Lo: 0xcd09, Hi: 0xcd23, Stride: 1},
		{Lo: 0xcd25, Hi: 0xcd3f, Stride: 1},
		{Lo: 0xcd41, Hi: 0xcd5b, Stride: 1},
		{Lo: 0xcd5d, Hi: 0xcd77, Stride: 1},
		{Lo: 0xcd79, Hi: 0xcd93, Stride: 1},
		{Lo: 0xcd95, Hi: 0xcdaf, Stride: 1},
		{Lo: 0xcdb1, Hi: 0xcdcb, Stride: 1},
		{Lo: 0xcdcd, Hi: 0xcde7, Stride: 1},
		{Lo: 0xcde9, Hi: 0xce03, Stride: 1},
		{Lo: 0xce05, Hi: 0xce1f, Stride: 1},
		{Lo: 0xce21, Hi: 0xce3b, Stride: 1},
		{Lo: 0xce3d, Hi: 0xce57, Stride: 1},
		{Lo: 0xce59, Hi: 0xce73, Stride: 1},
		{Lo: 0xce75, Hi: 0xce8f, Stride: 1},
		{Lo: 0xce91, Hi: 0xceab, Stride: 1},
		{Lo: 0xcead, Hi: 0xcec7, Stride: 1},
		{Lo: 0xcec9, Hi: 0xcee3, Stride: 1},
		{Lo: 0xcee5, Hi: 0xceff, Stride: 1},
		{Lo: 0xcf01, Hi: 0xcf1b, Stride: 1},
		{Lo: 0xcf1d, Hi: 0xcf37, Stride: 1},
		{Lo: 0xcf39, Hi: 0xcf53, Stride: 1},
		{Lo: 0xcf55, Hi: 0xcf6f, Stride: 1},
		{Lo: 0xcf71, Hi: 0xcf8b, Stride: 1},
		{Lo: 0xcf8d, Hi: 0xcfa7, Stride: 1},
		{Lo: 0xcfa9, Hi: 0xcfc3, Stride: 1},
		{Lo: 0xcfc5, Hi: 0xcfdf, Stride: 1},
		{Lo: 0xcfe1, Hi: 0xcffb, Stride: 1},
		{Lo: 0xcffd, Hi: 0xd017, Stride: 1},
		{Lo: 0xd019, Hi: 0xd033, Stride: 1},
		{Lo: 0xd035, Hi: 0xd04f, Stride: 1},
		{Lo: 0xd051, Hi: 0xd06b, Stride: 1},
		{Lo: 0xd06d, Hi: 0xd087, Stride: 1},
		{Lo: 0xd089, Hi: 0xd0a3, Stride: 1},
		{Lo: 0xd0a5, Hi: 0xd0bf, Stride: 1},
		{Lo: 0xd0c1, Hi: 0xd0db, Stride: 1},
		{Lo: 0xd0dd, Hi: 0xd0f7, Stride: 1},
		{Lo: 0xd0f9, Hi: 0xd113, Stride: 1},
		{Lo: 0xd115, Hi: 0xd12f, Stride: 1},
		{Lo: 0xd131, Hi: 0xd14b, Stride: 1},
		{Lo: 0xd14d, Hi: 0xd167, Stride: 1},
		{Lo: 0xd169, Hi: 0xd183, Stride: 1},
		{Lo: 0xd185, Hi: 0xd19f, Stride: 1},
		{Lo: 0xd1a1, Hi: 0xd1bb, Stride: 1},
		{Lo: 0xd1bd, Hi: 0xd1d7, Stride: 1},
		{Lo: 0xd1d9, Hi: 0xd1f3, Stride: 1},
		{Lo: 0xd1f5, Hi: 0xd20f, Stride: 1},
		{Lo: 0xd211, Hi: 0xd22b, Stride: 1},
		{Lo: 0xd22d, Hi: 0xd247, Stride: 1},
		{Lo: 0xd249, Hi: 0xd263, Stride: 1},
		{Lo: 0xd265, Hi: 0xd27f, Stride: 1},
		{Lo: 0xd281, Hi: 0xd29b, Stride: 1},
		{Lo: 0xd29d, Hi: 0xd2b7, Stride: 1},
		{Lo: 0xd2b9, Hi: 0xd2d3, Stride: 1},
		{Lo: 0xd2d5, Hi: 0xd2ef, Stride: 1},
		{Lo: 0xd2f1, Hi: 0xd30b, Stride: 1},
		{Lo: 0xd30d, Hi: 0xd327, Stride: 1},
		{Lo: 0xd329, Hi: 0xd343, Stride: 1},
		{Lo: 0xd345, Hi: 0xd35f, Stride: 1},
		{Lo: 0xd361, Hi: 0xd37b, Stride: 1},
		{Lo: 0xd37d, Hi: 0xd397, Stride: 1},
		{Lo: 0xd399, Hi: 0xd3b3, Stride: 1},
		{Lo: 0xd3b5, Hi: 0xd3cf, Stride: 1},
		{Lo: 0xd3d1, Hi: 0xd3eb, Stride: 1},
		{Lo: 0xd3ed, Hi: 0xd407, Stride: 1},
		{Lo: 0xd409, Hi: 0xd423, Stride: 1},
		{Lo: 0xd425, Hi: 0xd43f, Stride: 1},
		{Lo: 0xd441, Hi: 0xd45b, Stride: 1},
		{Lo: 0xd45d, Hi: 0xd477, Stride: 1},
		{Lo: 0xd479, Hi: 0xd493, Stride: 1},
		{Lo: 0xd495, Hi: 0xd4af, Stride: 1},
		{Lo: 0xd4b1, Hi: 0xd4cb, Stride: 1},
		{Lo: 0xd4cd, Hi: 0xd4e7, Stride: 1},
		{Lo: 0xd4e9, Hi: 0xd503, Stride: 1},
		{Lo: 0xd505, Hi: 0xd51f, Stride: 1},
		{Lo: 0xd521, Hi: 0xd53b, Stride: 1},
		{Lo: 0xd53d, Hi: 0xd557, Stride: 1},
		{Lo: 0xd559, Hi: 0xd573, Stride: 1},
		{Lo: 0xd575, Hi: 0xd58f, Stride: 1},
		{Lo: 0xd591, Hi: 0xd5ab, Stride: 1},
		{Lo: 0xd5ad, Hi: 0xd5c7, Stride: 1},
		{Lo: 0xd5c9, Hi: 0xd5e3, Stride: 1},
		{Lo: 0xd5e5, Hi: 0xd5ff, Stride: 1},
		{Lo: 0xd601, Hi: 0xd61b, Stride: 1},
		{Lo: 0xd61d, Hi: 0xd637, Stride: 1},
		{Lo: 0xd639, Hi: 0xd653, Stride: 1},
		{Lo: 0xd655, Hi: 0xd66f, Stride: 1},
		{Lo: 0xd671, Hi: 0xd68b, Stride: 1},
		{Lo: 0xd68d, Hi: 0xd6a7, Stride: 1},
		{Lo: 0xd6a9, Hi: 0xd6c3, Stride: 1},
		{Lo: 0xd6c5, Hi: 0xd6df, Stride: 1},
		{Lo: 0xd6e1, Hi: 0xd6fb, Stride: 1},
		{Lo: 0xd6fd, Hi: 0xd717, Stride: 1},
		{Lo: 0xd719, Hi: 0xd733, Stride: 1},
		{Lo: 0xd735, Hi: 0xd74f, Stride: 1},
		{Lo: 0xd751, Hi: 0xd76b, Stride: 1},
		{Lo: 0xd76d, Hi: 0xd787, Stride: 1},
		{Lo: 0xd789, Hi: 0xd7a3, Stride: 1},
	},
}

// Hangul L Jamo
var BreakJL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x1100, Hi: 0x115f, Stride: 1},
		{Lo: 0xa960, Hi: 0xa97c, Stride: 1},
	},
}

// Hangul V Jamo
var BreakJV = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x1160, Hi: 0x11a7, Stride: 1},
		{Lo: 0xd7b0, Hi: 0xd7c6, Stride: 1},
	},
}

// Hangul T Jamo
var BreakJT = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x11a8, Hi: 0x11ff, Stride: 1},
		{Lo: 0xd7cb, Hi: 0xd7fb, Stride: 1},
	},
}

// Regional Indicator
var BreakRI = &unicode.RangeTable{
	R32: []unicode.Range32{
		{Lo: 0x1f1e6, Hi: 0x1f1ff, Stride: 1},
	},
}

// Contingent Break Opportunity
var BreakCB = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xfffc, Hi: 0xfffc, Stride: 1},
	},
}

// Ambiguous (Alphabetic or Ideographic)
var BreakAI = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x00a7, Hi: 0x00a8, Stride: 1},
		{Lo: 0x00aa, Hi: 0x00b2, Stride: 8},
		{Lo: 0x00b3, Hi: 0x00b6, Stride: 3},
		{Lo: 0x00b7, Hi: 0x00ba, Stride: 1},
		{Lo: 0x00bc, Hi: 0x00be, Stride: 1},
		{Lo: 0x00d7, Hi: 0x00f7, Stride: 32},
		{Lo: 0x02c7, Hi: 0x02c9, Stride: 2},
		{Lo: 0x02ca, Hi: 0x02cb, Stride: 1},
		{Lo: 0x02cd, Hi: 0x02d0, Stride: 3},
		{Lo: 0x02d8, Hi: 0x02db, Stride: 1},
		{Lo: 0x02dd, Hi: 0x2015, Stride: 7480},
		{Lo: 0x2016, Hi: 0x2020, Stride: 10},
		{Lo: 0x2021, Hi: 0x203b, Stride: 26},
		{Lo: 0x2074, Hi: 0x207f, Stride: 11},
		{Lo: 0x2081, Hi: 0x2084, Stride: 1},
		{Lo: 0x2105, Hi: 0x2121, Stride: 14},
		{Lo: 0x2122, Hi: 0x212b, Stride: 9},
		{Lo: 0x2154, Hi: 0x2155, Stride: 1},
		{Lo: 0x215b, Hi: 0x215e, Stride: 3},
		{Lo: 0x2160, Hi: 0x216b, Stride: 1},
		{Lo: 0x2170, Hi: 0x2179, Stride: 1},
		{Lo: 0x2189, Hi: 0x2190, Stride: 7},
		{Lo: 0x2191, Hi: 0x2199, Stride: 1},
		{Lo: 0x21d2, Hi: 0x21d4, Stride: 2},
		{Lo: 0x2200, Hi: 0x2202, Stride: 2},
		{Lo: 0x2203, Hi: 0x2207, Stride: 4},
		{Lo: 0x2208, Hi: 0x220b, Stride: 3},
		{Lo: 0x220f, Hi: 0x2211, Stride: 2},
		{Lo: 0x2215, Hi: 0x221a, Stride: 5},
		{Lo: 0x221d, Hi: 0x2220, Stride: 1},
		{Lo: 0x2223, Hi: 0x2227, Stride: 2},
		{Lo: 0x2228, Hi: 0x222c, Stride: 1},
		{Lo: 0x222e, Hi: 0x2234, Stride: 6},
		{Lo: 0x2235, Hi: 0x2237, Stride: 1},
		{Lo: 0x223c, Hi: 0x223d, Stride: 1},
		{Lo: 0x2248, Hi: 0x224c, Stride: 4},
		{Lo: 0x2252, Hi: 0x2260, Stride: 14},
		{Lo: 0x2261, Hi: 0x2264, Stride: 3},
		{Lo: 0x2265, Hi: 0x2267, Stride: 1},
		{Lo: 0x226a, Hi: 0x226b, Stride: 1},
		{Lo: 0x226e, Hi: 0x226f, Stride: 1},
		{Lo: 0x2282, Hi: 0x2283, Stride: 1},
		{Lo: 0x2286, Hi: 0x2287, Stride: 1},
		{Lo: 0x2295, Hi: 0x2299, Stride: 4},
		{Lo: 0x22a5, Hi: 0x22bf, Stride: 26},
		{Lo: 0x2312, Hi: 0x2460, Stride: 334},
		{Lo: 0x2461, Hi: 0x24fe, Stride: 1},
		{Lo: 0x2500, Hi: 0x254b, Stride: 1},
		{Lo: 0x2550, Hi: 0x2574, Stride: 1},
		{Lo: 0x2580, Hi: 0x258f, Stride: 1},
		{Lo: 0x2592, Hi: 0x2595, Stride: 1},
		{Lo: 0x25a0, Hi: 0x25a1, Stride: 1},
		{Lo: 0x25a3, Hi: 0x25a9, Stride: 1},
		{Lo: 0x25b2, Hi: 0x25b3, Stride: 1},
		{Lo: 0x25b6, Hi: 0x25b7, Stride: 1},
		{Lo: 0x25bc, Hi: 0x25bd, Stride: 1},
		{Lo: 0x25c0, Hi: 0x25c1, Stride: 1},
		{Lo: 0x25c6, Hi: 0x25c8, Stride: 1},
		{Lo: 0x25cb, Hi: 0x25ce, Stride: 3},
		{Lo: 0x25cf, Hi: 0x25d1, Stride: 1},
		{Lo: 0x25e2, Hi: 0x25e5, Stride: 1},
		{Lo: 0x25ef, Hi: 0x2605, Stride: 22},
		{Lo: 0x2606, Hi: 0x2609, Stride: 3},
		{Lo: 0x260e, Hi: 0x260f, Stride: 1},
		{Lo: 0x2616, Hi: 0x2617, Stride: 1},
		{Lo: 0x2640, Hi: 0x2642, Stride: 2},
		{Lo: 0x2660, Hi: 0x2661, Stride: 1},
		{Lo: 0x2663, Hi: 0x2665, Stride: 1},
		{Lo: 0x2667, Hi: 0x2669, Stride: 2},
		{Lo: 0x266a, Hi: 0x266c, Stride: 2},
		{Lo: 0x266d, Hi: 0x266f, Stride: 2},
		{Lo: 0x269e, Hi: 0x269f, Stride: 1},
		{Lo: 0x26c9, Hi: 0x26cc, Stride: 1},
		{Lo: 0x26d2, Hi: 0x26d5, Stride: 3},
		{Lo: 0x26d6, Hi: 0x26d7, Stride: 1},
		{Lo: 0x26da, Hi: 0x26db, Stride: 1},
		{Lo: 0x26dd, Hi: 0x26de, Stride: 1},
		{Lo: 0x26e3, Hi: 0x26e8, Stride: 5},
		{Lo: 0x26e9, Hi: 0x26eb, Stride: 2},
		{Lo: 0x26ec, Hi: 0x26f0, Stride: 1},
		{Lo: 0x26f6, Hi: 0x26fb, Stride: 5},
		{Lo: 0x26fc, Hi: 0x2757, Stride: 91},
		{Lo: 0x2776, Hi: 0x2793, Stride: 1},
		{Lo: 0x2b55, Hi: 0x2b59, Stride: 1},
		{Lo: 0x3248, Hi: 0x324f, Stride: 1},
		{Lo: 0xfffd, Hi: 0xfffd, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x1f100, Hi: 0x1f10c, Stride: 1},
		{Lo: 0x1f110, Hi: 0x1f12d, Stride: 1},
		{Lo: 0x1f130, Hi: 0x1f169, Stride: 1},
		{Lo: 0x1f170, Hi: 0x1f1ac, Stride: 1},
	},
	LatinOffset: 6,
}

// Conditional Japanese Starter
var BreakCJ = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x3041, Hi: 0x3049, Stride: 2},
		{Lo: 0x3063, Hi: 0x3083, Stride: 32},
		{Lo: 0x3085, Hi: 0x3087, Stride: 2},
		{Lo: 0x308e, Hi: 0x3095, Stride: 7},
		{Lo: 0x3096, Hi: 0x30a1, Stride: 11},
		{Lo: 0x30a3, Hi: 0x30a9, Stride: 2},
		{Lo: 0x30c3, Hi: 0x30e3, Stride: 32},
		{Lo: 0x30e5, Hi: 0x30e7, Stride: 2},
		{Lo: 0x30ee, Hi: 0x30f5, Stride: 7},
		{Lo: 0x30f6, Hi: 0x30fc, Stride: 6},
		{Lo: 0x31f0, Hi: 0x31ff, Stride: 1},
		{Lo: 0xff67, Hi: 0xff70, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x1b150, Hi: 0x1b152, Stride: 1},
		{Lo: 0x1b164, Hi: 0x1b167, Stride: 1},
	},
}

// Complex Context Dependent (South East Asian)
var BreakSA = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0e01, Hi: 0x0e3a, Stride: 1},
		{Lo: 0x0e40, Hi: 0x0e4e, Stride: 1},
		{Lo: 0x0e81, Hi: 0x0e82, Stride: 1},
		{Lo: 0x0e84, Hi: 0x0e86, Stride: 2},
		{Lo: 0x0e87, Hi: 0x0e8a, Stride: 1},
		{Lo: 0x0e8c, Hi: 0x0ea3, Stride: 1},
		{Lo: 0x0ea5, Hi: 0x0ea7, Stride: 2},
		{Lo: 0x0ea8, Hi: 0x0ebd, Stride: 1},
		{Lo: 0x0ec0, Hi: 0x0ec4, Stride: 1},
		{Lo: 0x0ec6, Hi: 0x0ec8, Stride: 2},
		{Lo: 0x0ec9, Hi: 0x0ecd, Stride: 1},
		{Lo: 0x0edc, Hi: 0x0edf, Stride: 1},
		{Lo: 0x1000, Hi: 0x103f, Stride: 1},
		{Lo: 0x1050, Hi: 0x108f, Stride: 1},
		{Lo: 0x109a, Hi: 0x109f, Stride: 1},
		{Lo: 0x1780, Hi: 0x17d3, Stride: 1},
		{Lo: 0x17d7, Hi: 0x17dc, Stride: 5},
		{Lo: 0x17dd, Hi: 0x1950, Stride: 371},
		{Lo: 0x1951, Hi: 0x196d, Stride: 1},
		{Lo: 0x1970, Hi: 0x1974, Stride: 1},
		{Lo: 0x1980, Hi: 0x19ab, Stride: 1},
		{Lo: 0x19b0, Hi: 0x19c9, Stride: 1},
		{Lo: 0x19da, Hi: 0x19de, Stride: 4},
		{Lo: 0x19df, Hi: 0x1a20, Stride: 65},
		{Lo: 0x1a21, Hi: 0x1a5e, Stride: 1},
		{Lo: 0x1a60, Hi: 0x1a7c, Stride: 1},
		{Lo: 0x1aa0, Hi: 0x1aad, Stride: 1},
		{Lo: 0xa9e0, Hi: 0xa9ef, Stride: 1},
		{Lo: 0xa9fa, Hi: 0xa9fe, Stride: 1},
		{Lo: 0xaa60, Hi: 0xaac2, Stride: 1},
		{Lo: 0xaadb, Hi: 0xaadf, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x11700, Hi: 0x1171a, Stride: 1},
		{Lo: 0x1171d, Hi: 0x1172b, Stride: 1},
		{Lo: 0x1173a, Hi: 0x1173b, Stride: 1},
		{Lo: 0x1173f, Hi: 0x1173f, Stride: 1},
	},
}

// Unknown
var BreakXX = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xe000, Hi: 0xf8ff, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0xf0000, Hi: 0xffffd, Stride: 1},
		{Lo: 0x100000, Hi: 0x10fffd, Stride: 1},
	},
}

var lineBreaks = [...]*unicode.RangeTable{
	BreakBK,  // BK
	BreakCR,  // CR
	BreakLF,  // LF
	BreakNL,  // NL
	BreakSP,  // SP
	BreakNU,  // NU
	BreakAL,  // AL
	BreakIS,  // IS
	BreakPR,  // PR
	BreakPO,  // PO
	BreakOP,  // OP
	BreakCL,  // CL
	BreakCP,  // CP
	BreakQU,  // QU
	BreakHY,  // HY
	BreakSG,  // SG
	BreakGL,  // GL
	BreakNS,  // NS
	BreakEX,  // EX
	BreakSY,  // SY
	BreakHL,  // HL
	BreakID,  // ID
	BreakIN,  // IN
	BreakBA,  // BA
	BreakBB,  // BB
	BreakB2,  // B2
	BreakZW,  // ZW
	BreakCM,  // CM
	BreakEB,  // EB
	BreakEM,  // EM
	BreakWJ,  // WJ
	BreakZWJ, // ZWJ
	BreakH2,  // H2
	BreakH3,  // H3
	BreakJL,  // JL
	BreakJV,  // JV
	BreakJT,  // JT
	BreakRI,  // RI
	BreakCB,  // CB
	BreakAI,  // AI
	BreakCJ,  // CJ
	BreakSA,  // SA
	BreakXX,  // XX
}
