// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package language

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

const (
	Adlam                  = Script(0x61646c6d)
	Ahom                   = Script(0x61686f6d)
	Anatolian_Hieroglyphs  = Script(0x686c7577)
	Arabic                 = Script(0x61726162)
	Armenian               = Script(0x61726d6e)
	Avestan                = Script(0x61767374)
	Balinese               = Script(0x62616c69)
	Bamum                  = Script(0x62616d75)
	Bassa_Vah              = Script(0x62617373)
	Batak                  = Script(0x6261746b)
	Bengali                = Script(0x62656e67)
	Bhaiksuki              = Script(0x62686b73)
	Bopomofo               = Script(0x626f706f)
	Brahmi                 = Script(0x62726168)
	Braille                = Script(0x62726169)
	Buginese               = Script(0x62756769)
	Buhid                  = Script(0x62756864)
	Canadian_Aboriginal    = Script(0x63616e73)
	Carian                 = Script(0x63617269)
	Caucasian_Albanian     = Script(0x61676862)
	Chakma                 = Script(0x63616b6d)
	Cham                   = Script(0x6368616d)
	Cherokee               = Script(0x63686572)
	Chorasmian             = Script(0x63687273)
	Common                 = Script(0x7a797979)
	Coptic                 = Script(0x636f7074)
	Cuneiform              = Script(0x78737578)
	Cypriot                = Script(0x63707274)
	Cyrillic               = Script(0x6379726c)
	Deseret                = Script(0x64737274)
	Devanagari             = Script(0x64657661)
	Dives_Akuru            = Script(0x6469616b)
	Dogra                  = Script(0x646f6772)
	Duployan               = Script(0x6475706c)
	Egyptian_Hieroglyphs   = Script(0x65677970)
	Elbasan                = Script(0x656c6261)
	Elymaic                = Script(0x656c796d)
	Ethiopic               = Script(0x65746869)
	Georgian               = Script(0x67656f72)
	Glagolitic             = Script(0x676c6167)
	Gothic                 = Script(0x676f7468)
	Grantha                = Script(0x6772616e)
	Greek                  = Script(0x6772656b)
	Gujarati               = Script(0x67756a72)
	Gunjala_Gondi          = Script(0x676f6e67)
	Gurmukhi               = Script(0x67757275)
	Han                    = Script(0x68616e69)
	Hangul                 = Script(0x68616e67)
	Hanifi_Rohingya        = Script(0x726f6867)
	Hanunoo                = Script(0x68616e6f)
	Hatran                 = Script(0x68617472)
	Hebrew                 = Script(0x68656272)
	Hiragana               = Script(0x68697261)
	Imperial_Aramaic       = Script(0x61726d69)
	Inherited              = Script(0x7a696e68)
	Inscriptional_Pahlavi  = Script(0x70686c69)
	Inscriptional_Parthian = Script(0x70727469)
	Javanese               = Script(0x6a617661)
	Kaithi                 = Script(0x6b746869)
	Kannada                = Script(0x6b6e6461)
	Katakana               = Script(0x6b616e61)
	Katakana_Or_Hiragana   = Script(0x68726b74)
	Kayah_Li               = Script(0x6b616c69)
	Kharoshthi             = Script(0x6b686172)
	Khitan_Small_Script    = Script(0x6b697473)
	Khmer                  = Script(0x6b686d72)
	Khojki                 = Script(0x6b686f6a)
	Khudawadi              = Script(0x73696e64)
	Lao                    = Script(0x6c616f6f)
	Latin                  = Script(0x6c61746e)
	Lepcha                 = Script(0x6c657063)
	Limbu                  = Script(0x6c696d62)
	Linear_A               = Script(0x6c696e61)
	Linear_B               = Script(0x6c696e62)
	Lisu                   = Script(0x6c697375)
	Lycian                 = Script(0x6c796369)
	Lydian                 = Script(0x6c796469)
	Mahajani               = Script(0x6d61686a)
	Makasar                = Script(0x6d616b61)
	Malayalam              = Script(0x6d6c796d)
	Mandaic                = Script(0x6d616e64)
	Manichaean             = Script(0x6d616e69)
	Marchen                = Script(0x6d617263)
	Masaram_Gondi          = Script(0x676f6e6d)
	Medefaidrin            = Script(0x6d656466)
	Meetei_Mayek           = Script(0x6d746569)
	Mende_Kikakui          = Script(0x6d656e64)
	Meroitic_Cursive       = Script(0x6d657263)
	Meroitic_Hieroglyphs   = Script(0x6d65726f)
	Miao                   = Script(0x706c7264)
	Modi                   = Script(0x6d6f6469)
	Mongolian              = Script(0x6d6f6e67)
	Mro                    = Script(0x6d726f6f)
	Multani                = Script(0x6d756c74)
	Myanmar                = Script(0x6d796d72)
	Nabataean              = Script(0x6e626174)
	Nandinagari            = Script(0x6e616e64)
	New_Tai_Lue            = Script(0x74616c75)
	Newa                   = Script(0x6e657761)
	Nko                    = Script(0x6e6b6f6f)
	Nushu                  = Script(0x6e736875)
	Nyiakeng_Puachue_Hmong = Script(0x686d6e70)
	Ogham                  = Script(0x6f67616d)
	Ol_Chiki               = Script(0x6f6c636b)
	Old_Hungarian          = Script(0x68756e67)
	Old_Italic             = Script(0x6974616c)
	Old_North_Arabian      = Script(0x6e617262)
	Old_Permic             = Script(0x7065726d)
	Old_Persian            = Script(0x7870656f)
	Old_Sogdian            = Script(0x736f676f)
	Old_South_Arabian      = Script(0x73617262)
	Old_Turkic             = Script(0x6f726b68)
	Oriya                  = Script(0x6f727961)
	Osage                  = Script(0x6f736765)
	Osmanya                = Script(0x6f736d61)
	Pahawh_Hmong           = Script(0x686d6e67)
	Palmyrene              = Script(0x70616c6d)
	Pau_Cin_Hau            = Script(0x70617563)
	Phags_Pa               = Script(0x70686167)
	Phoenician             = Script(0x70686e78)
	Psalter_Pahlavi        = Script(0x70686c70)
	Rejang                 = Script(0x726a6e67)
	Runic                  = Script(0x72756e72)
	Samaritan              = Script(0x73616d72)
	Saurashtra             = Script(0x73617572)
	Sharada                = Script(0x73687264)
	Shavian                = Script(0x73686177)
	Siddham                = Script(0x73696464)
	SignWriting            = Script(0x73676e77)
	Sinhala                = Script(0x73696e68)
	Sogdian                = Script(0x736f6764)
	Sora_Sompeng           = Script(0x736f7261)
	Soyombo                = Script(0x736f796f)
	Sundanese              = Script(0x73756e64)
	Syloti_Nagri           = Script(0x73796c6f)
	Syriac                 = Script(0x73797263)
	Tagalog                = Script(0x74676c67)
	Tagbanwa               = Script(0x74616762)
	Tai_Le                 = Script(0x74616c65)
	Tai_Tham               = Script(0x6c616e61)
	Tai_Viet               = Script(0x74617674)
	Takri                  = Script(0x74616b72)
	Tamil                  = Script(0x74616d6c)
	Tangut                 = Script(0x74616e67)
	Telugu                 = Script(0x74656c75)
	Thaana                 = Script(0x74686161)
	Thai                   = Script(0x74686169)
	Tibetan                = Script(0x74696274)
	Tifinagh               = Script(0x74666e67)
	Tirhuta                = Script(0x74697268)
	Ugaritic               = Script(0x75676172)
	Unknown                = Script(0x7a7a7a7a)
	Vai                    = Script(0x76616969)
	Wancho                 = Script(0x7763686f)
	Warang_Citi            = Script(0x77617261)
	Yezidi                 = Script(0x79657a69)
	Yi                     = Script(0x79696969)
	Zanabazar_Square       = Script(0x7a616e62)
)

var scriptToTag = map[string]Script{
	"Adlam":                  1633971309,
	"Ahom":                   1634234221,
	"Anatolian_Hieroglyphs":  1751938423,
	"Arabic":                 1634885986,
	"Armenian":               1634889070,
	"Avestan":                1635152756,
	"Balinese":               1650551913,
	"Bamum":                  1650552181,
	"Bassa_Vah":              1650553715,
	"Batak":                  1650553963,
	"Bengali":                1650814567,
	"Bhaiksuki":              1651010419,
	"Bopomofo":               1651470447,
	"Brahmi":                 1651663208,
	"Braille":                1651663209,
	"Buginese":               1651861353,
	"Buhid":                  1651861604,
	"Canadian_Aboriginal":    1667329651,
	"Carian":                 1667330665,
	"Caucasian_Albanian":     1634166882,
	"Chakma":                 1667328877,
	"Cham":                   1667785069,
	"Cherokee":               1667786098,
	"Chorasmian":             1667789427,
	"Common":                 2054781305,
	"Coptic":                 1668247668,
	"Cuneiform":              2020832632,
	"Cypriot":                1668313716,
	"Cyrillic":               1668903532,
	"Deseret":                1685287540,
	"Devanagari":             1684371041,
	"Dives_Akuru":            1684627819,
	"Dogra":                  1685022578,
	"Duployan":               1685418092,
	"Egyptian_Hieroglyphs":   1701280112,
	"Elbasan":                1701601889,
	"Elymaic":                1701607789,
	"Ethiopic":               1702127721,
	"Georgian":               1734700914,
	"Glagolitic":             1735156071,
	"Gothic":                 1735357544,
	"Grantha":                1735549294,
	"Greek":                  1735550315,
	"Gujarati":               1735748210,
	"Gunjala_Gondi":          1735356007,
	"Gurmukhi":               1735750261,
	"Han":                    1751215721,
	"Hangul":                 1751215719,
	"Hanifi_Rohingya":        1919903847,
	"Hanunoo":                1751215727,
	"Hatran":                 1751217266,
	"Hebrew":                 1751474802,
	"Hiragana":               1751741025,
	"Imperial_Aramaic":       1634889065,
	"Inherited":              2053729896,
	"Inscriptional_Pahlavi":  1885891689,
	"Inscriptional_Parthian": 1886549097,
	"Javanese":               1784772193,
	"Kaithi":                 1802791017,
	"Kannada":                1802396769,
	"Katakana":               1801547361,
	"Katakana_Or_Hiragana":   1752329076,
	"Kayah_Li":               1801546857,
	"Kharoshthi":             1802002802,
	"Khitan_Small_Script":    1802073203,
	"Khmer":                  1802005874,
	"Khojki":                 1802006378,
	"Khudawadi":              1936289380,
	"Lao":                    1818324847,
	"Latin":                  1818326126,
	"Lepcha":                 1818587235,
	"Limbu":                  1818848610,
	"Linear_A":               1818848865,
	"Linear_B":               1818848866,
	"Lisu":                   1818850165,
	"Lycian":                 1819894633,
	"Lydian":                 1819894889,
	"Mahajani":               1835100266,
	"Makasar":                1835101025,
	"Malayalam":              1835825517,
	"Mandaic":                1835101796,
	"Manichaean":             1835101801,
	"Marchen":                1835102819,
	"Masaram_Gondi":          1735356013,
	"Medefaidrin":            1835361382,
	"Meetei_Mayek":           1836344681,
	"Mende_Kikakui":          1835363940,
	"Meroitic_Cursive":       1835364963,
	"Meroitic_Hieroglyphs":   1835364975,
	"Miao":                   1886155364,
	"Modi":                   1836016745,
	"Mongolian":              1836019303,
	"Mro":                    1836216175,
	"Multani":                1836412020,
	"Myanmar":                1836674418,
	"Nabataean":              1851941236,
	"Nandinagari":            1851879012,
	"New_Tai_Lue":            1952541813,
	"Newa":                   1852143457,
	"Nko":                    1852534639,
	"Nushu":                  1853057141,
	"Nyiakeng_Puachue_Hmong": 1752002160,
	"Ogham":                  1869046125,
	"Ol_Chiki":               1869374315,
	"Old_Hungarian":          1752526439,
	"Old_Italic":             1769234796,
	"Old_North_Arabian":      1851880034,
	"Old_Permic":             1885696621,
	"Old_Persian":            2020631919,
	"Old_Sogdian":            1936680815,
	"Old_South_Arabian":      1935766114,
	"Old_Turkic":             1869769576,
	"Oriya":                  1869773153,
	"Osage":                  1869834085,
	"Osmanya":                1869835617,
	"Pahawh_Hmong":           1752002151,
	"Palmyrene":              1885432941,
	"Pau_Cin_Hau":            1885435235,
	"Phags_Pa":               1885888871,
	"Phoenician":             1885892216,
	"Psalter_Pahlavi":        1885891696,
	"Rejang":                 1919577703,
	"Runic":                  1920298610,
	"Samaritan":              1935764850,
	"Saurashtra":             1935766898,
	"Sharada":                1936224868,
	"Shavian":                1936220535,
	"Siddham":                1936286820,
	"SignWriting":            1936158327,
	"Sinhala":                1936289384,
	"Sogdian":                1936680804,
	"Sora_Sompeng":           1936683617,
	"Soyombo":                1936685423,
	"Sundanese":              1937075812,
	"Syloti_Nagri":           1937337455,
	"Syriac":                 1937338979,
	"Tagalog":                1952935015,
	"Tagbanwa":               1952540514,
	"Tai_Le":                 1952541797,
	"Tai_Tham":               1818324577,
	"Tai_Viet":               1952544372,
	"Takri":                  1952541554,
	"Tamil":                  1952542060,
	"Tangut":                 1952542311,
	"Telugu":                 1952803957,
	"Thaana":                 1952997729,
	"Thai":                   1952997737,
	"Tibetan":                1953063540,
	"Tifinagh":               1952869991,
	"Tirhuta":                1953067624,
	"Ugaritic":               1969709426,
	"Unknown":                2054847098,
	"Vai":                    1986095465,
	"Wancho":                 2003003503,
	"Warang_Citi":            2002874977,
	"Yezidi":                 2036693609,
	"Yi":                     2036951401,
	"Zanabazar_Square":       2053205602,
}

type scriptItem struct {
	start, end rune
	script     Script
}

var scriptRanges = [...]scriptItem{
	{start: 0x0, end: 0x40, script: 0x7a797979},
	{start: 0x41, end: 0x5a, script: 0x6c61746e},
	{start: 0x5b, end: 0x60, script: 0x7a797979},
	{start: 0x61, end: 0x7a, script: 0x6c61746e},
	{start: 0x7b, end: 0xa9, script: 0x7a797979},
	{start: 0xaa, end: 0xaa, script: 0x6c61746e},
	{start: 0xab, end: 0xb9, script: 0x7a797979},
	{start: 0xba, end: 0xba, script: 0x6c61746e},
	{start: 0xbb, end: 0xbf, script: 0x7a797979},
	{start: 0xc0, end: 0xd6, script: 0x6c61746e},
	{start: 0xd7, end: 0xd7, script: 0x7a797979},
	{start: 0xd8, end: 0xf6, script: 0x6c61746e},
	{start: 0xf7, end: 0xf7, script: 0x7a797979},
	{start: 0xf8, end: 0x2b8, script: 0x6c61746e},
	{start: 0x2b9, end: 0x2df, script: 0x7a797979},
	{start: 0x2e0, end: 0x2e4, script: 0x6c61746e},
	{start: 0x2e5, end: 0x2e9, script: 0x7a797979},
	{start: 0x2ea, end: 0x2eb, script: 0x626f706f},
	{start: 0x2ec, end: 0x2ff, script: 0x7a797979},
	{start: 0x300, end: 0x36f, script: 0x7a696e68},
	{start: 0x370, end: 0x373, script: 0x6772656b},
	{start: 0x374, end: 0x374, script: 0x7a797979},
	{start: 0x375, end: 0x377, script: 0x6772656b},
	{start: 0x37a, end: 0x37d, script: 0x6772656b},
	{start: 0x37e, end: 0x37e, script: 0x7a797979},
	{start: 0x37f, end: 0x37f, script: 0x6772656b},
	{start: 0x384, end: 0x384, script: 0x6772656b},
	{start: 0x385, end: 0x385, script: 0x7a797979},
	{start: 0x386, end: 0x386, script: 0x6772656b},
	{start: 0x387, end: 0x387, script: 0x7a797979},
	{start: 0x388, end: 0x38a, script: 0x6772656b},
	{start: 0x38c, end: 0x38c, script: 0x6772656b},
	{start: 0x38e, end: 0x3a1, script: 0x6772656b},
	{start: 0x3a3, end: 0x3e1, script: 0x6772656b},
	{start: 0x3e2, end: 0x3ef, script: 0x636f7074},
	{start: 0x3f0, end: 0x3ff, script: 0x6772656b},
	{start: 0x400, end: 0x484, script: 0x6379726c},
	{start: 0x485, end: 0x486, script: 0x7a696e68},
	{start: 0x487, end: 0x52f, script: 0x6379726c},
	{start: 0x531, end: 0x556, script: 0x61726d6e},
	{start: 0x559, end: 0x58a, script: 0x61726d6e},
	{start: 0x58d, end: 0x58f, script: 0x61726d6e},
	{start: 0x591, end: 0x5c7, script: 0x68656272},
	{start: 0x5d0, end: 0x5ea, script: 0x68656272},
	{start: 0x5ef, end: 0x5f4, script: 0x68656272},
	{start: 0x600, end: 0x604, script: 0x61726162},
	{start: 0x605, end: 0x605, script: 0x7a797979},
	{start: 0x606, end: 0x60b, script: 0x61726162},
	{start: 0x60c, end: 0x60c, script: 0x7a797979},
	{start: 0x60d, end: 0x61a, script: 0x61726162},
	{start: 0x61b, end: 0x61b, script: 0x7a797979},
	{start: 0x61c, end: 0x61c, script: 0x61726162},
	{start: 0x61e, end: 0x61e, script: 0x61726162},
	{start: 0x61f, end: 0x61f, script: 0x7a797979},
	{start: 0x620, end: 0x63f, script: 0x61726162},
	{start: 0x640, end: 0x640, script: 0x7a797979},
	{start: 0x641, end: 0x64a, script: 0x61726162},
	{start: 0x64b, end: 0x655, script: 0x7a696e68},
	{start: 0x656, end: 0x66f, script: 0x61726162},
	{start: 0x670, end: 0x670, script: 0x7a696e68},
	{start: 0x671, end: 0x6dc, script: 0x61726162},
	{start: 0x6dd, end: 0x6dd, script: 0x7a797979},
	{start: 0x6de, end: 0x6ff, script: 0x61726162},
	{start: 0x700, end: 0x70d, script: 0x73797263},
	{start: 0x70f, end: 0x74a, script: 0x73797263},
	{start: 0x74d, end: 0x74f, script: 0x73797263},
	{start: 0x750, end: 0x77f, script: 0x61726162},
	{start: 0x780, end: 0x7b1, script: 0x74686161},
	{start: 0x7c0, end: 0x7fa, script: 0x6e6b6f6f},
	{start: 0x7fd, end: 0x7ff, script: 0x6e6b6f6f},
	{start: 0x800, end: 0x82d, script: 0x73616d72},
	{start: 0x830, end: 0x83e, script: 0x73616d72},
	{start: 0x840, end: 0x85b, script: 0x6d616e64},
	{start: 0x85e, end: 0x85e, script: 0x6d616e64},
	{start: 0x860, end: 0x86a, script: 0x73797263},
	{start: 0x8a0, end: 0x8b4, script: 0x61726162},
	{start: 0x8b6, end: 0x8c7, script: 0x61726162},
	{start: 0x8d3, end: 0x8e1, script: 0x61726162},
	{start: 0x8e2, end: 0x8e2, script: 0x7a797979},
	{start: 0x8e3, end: 0x8ff, script: 0x61726162},
	{start: 0x900, end: 0x950, script: 0x64657661},
	{start: 0x951, end: 0x954, script: 0x7a696e68},
	{start: 0x955, end: 0x963, script: 0x64657661},
	{start: 0x964, end: 0x965, script: 0x7a797979},
	{start: 0x966, end: 0x97f, script: 0x64657661},
	{start: 0x980, end: 0x983, script: 0x62656e67},
	{start: 0x985, end: 0x98c, script: 0x62656e67},
	{start: 0x98f, end: 0x990, script: 0x62656e67},
	{start: 0x993, end: 0x9a8, script: 0x62656e67},
	{start: 0x9aa, end: 0x9b0, script: 0x62656e67},
	{start: 0x9b2, end: 0x9b2, script: 0x62656e67},
	{start: 0x9b6, end: 0x9b9, script: 0x62656e67},
	{start: 0x9bc, end: 0x9c4, script: 0x62656e67},
	{start: 0x9c7, end: 0x9c8, script: 0x62656e67},
	{start: 0x9cb, end: 0x9ce, script: 0x62656e67},
	{start: 0x9d7, end: 0x9d7, script: 0x62656e67},
	{start: 0x9dc, end: 0x9dd, script: 0x62656e67},
	{start: 0x9df, end: 0x9e3, script: 0x62656e67},
	{start: 0x9e6, end: 0x9fe, script: 0x62656e67},
	{start: 0xa01, end: 0xa03, script: 0x67757275},
	{start: 0xa05, end: 0xa0a, script: 0x67757275},
	{start: 0xa0f, end: 0xa10, script: 0x67757275},
	{start: 0xa13, end: 0xa28, script: 0x67757275},
	{start: 0xa2a, end: 0xa30, script: 0x67757275},
	{start: 0xa32, end: 0xa33, script: 0x67757275},
	{start: 0xa35, end: 0xa36, script: 0x67757275},
	{start: 0xa38, end: 0xa39, script: 0x67757275},
	{start: 0xa3c, end: 0xa3c, script: 0x67757275},
	{start: 0xa3e, end: 0xa42, script: 0x67757275},
	{start: 0xa47, end: 0xa48, script: 0x67757275},
	{start: 0xa4b, end: 0xa4d, script: 0x67757275},
	{start: 0xa51, end: 0xa51, script: 0x67757275},
	{start: 0xa59, end: 0xa5c, script: 0x67757275},
	{start: 0xa5e, end: 0xa5e, script: 0x67757275},
	{start: 0xa66, end: 0xa76, script: 0x67757275},
	{start: 0xa81, end: 0xa83, script: 0x67756a72},
	{start: 0xa85, end: 0xa8d, script: 0x67756a72},
	{start: 0xa8f, end: 0xa91, script: 0x67756a72},
	{start: 0xa93, end: 0xaa8, script: 0x67756a72},
	{start: 0xaaa, end: 0xab0, script: 0x67756a72},
	{start: 0xab2, end: 0xab3, script: 0x67756a72},
	{start: 0xab5, end: 0xab9, script: 0x67756a72},
	{start: 0xabc, end: 0xac5, script: 0x67756a72},
	{start: 0xac7, end: 0xac9, script: 0x67756a72},
	{start: 0xacb, end: 0xacd, script: 0x67756a72},
	{start: 0xad0, end: 0xad0, script: 0x67756a72},
	{start: 0xae0, end: 0xae3, script: 0x67756a72},
	{start: 0xae6, end: 0xaf1, script: 0x67756a72},
	{start: 0xaf9, end: 0xaff, script: 0x67756a72},
	{start: 0xb01, end: 0xb03, script: 0x6f727961},
	{start: 0xb05, end: 0xb0c, script: 0x6f727961},
	{start: 0xb0f, end: 0xb10, script: 0x6f727961},
	{start: 0xb13, end: 0xb28, script: 0x6f727961},
	{start: 0xb2a, end: 0xb30, script: 0x6f727961},
	{start: 0xb32, end: 0xb33, script: 0x6f727961},
	{start: 0xb35, end: 0xb39, script: 0x6f727961},
	{start: 0xb3c, end: 0xb44, script: 0x6f727961},
	{start: 0xb47, end: 0xb48, script: 0x6f727961},
	{start: 0xb4b, end: 0xb4d, script: 0x6f727961},
	{start: 0xb55, end: 0xb57, script: 0x6f727961},
	{start: 0xb5c, end: 0xb5d, script: 0x6f727961},
	{start: 0xb5f, end: 0xb63, script: 0x6f727961},
	{start: 0xb66, end: 0xb77, script: 0x6f727961},
	{start: 0xb82, end: 0xb83, script: 0x74616d6c},
	{start: 0xb85, end: 0xb8a, script: 0x74616d6c},
	{start: 0xb8e, end: 0xb90, script: 0x74616d6c},
	{start: 0xb92, end: 0xb95, script: 0x74616d6c},
	{start: 0xb99, end: 0xb9a, script: 0x74616d6c},
	{start: 0xb9c, end: 0xb9c, script: 0x74616d6c},
	{start: 0xb9e, end: 0xb9f, script: 0x74616d6c},
	{start: 0xba3, end: 0xba4, script: 0x74616d6c},
	{start: 0xba8, end: 0xbaa, script: 0x74616d6c},
	{start: 0xbae, end: 0xbb9, script: 0x74616d6c},
	{start: 0xbbe, end: 0xbc2, script: 0x74616d6c},
	{start: 0xbc6, end: 0xbc8, script: 0x74616d6c},
	{start: 0xbca, end: 0xbcd, script: 0x74616d6c},
	{start: 0xbd0, end: 0xbd0, script: 0x74616d6c},
	{start: 0xbd7, end: 0xbd7, script: 0x74616d6c},
	{start: 0xbe6, end: 0xbfa, script: 0x74616d6c},
	{start: 0xc00, end: 0xc0c, script: 0x74656c75},
	{start: 0xc0e, end: 0xc10, script: 0x74656c75},
	{start: 0xc12, end: 0xc28, script: 0x74656c75},
	{start: 0xc2a, end: 0xc39, script: 0x74656c75},
	{start: 0xc3d, end: 0xc44, script: 0x74656c75},
	{start: 0xc46, end: 0xc48, script: 0x74656c75},
	{start: 0xc4a, end: 0xc4d, script: 0x74656c75},
	{start: 0xc55, end: 0xc56, script: 0x74656c75},
	{start: 0xc58, end: 0xc5a, script: 0x74656c75},
	{start: 0xc60, end: 0xc63, script: 0x74656c75},
	{start: 0xc66, end: 0xc6f, script: 0x74656c75},
	{start: 0xc77, end: 0xc7f, script: 0x74656c75},
	{start: 0xc80, end: 0xc8c, script: 0x6b6e6461},
	{start: 0xc8e, end: 0xc90, script: 0x6b6e6461},
	{start: 0xc92, end: 0xca8, script: 0x6b6e6461},
	{start: 0xcaa, end: 0xcb3, script: 0x6b6e6461},
	{start: 0xcb5, end: 0xcb9, script: 0x6b6e6461},
	{start: 0xcbc, end: 0xcc4, script: 0x6b6e6461},
	{start: 0xcc6, end: 0xcc8, script: 0x6b6e6461},
	{start: 0xcca, end: 0xccd, script: 0x6b6e6461},
	{start: 0xcd5, end: 0xcd6, script: 0x6b6e6461},
	{start: 0xcde, end: 0xcde, script: 0x6b6e6461},
	{start: 0xce0, end: 0xce3, script: 0x6b6e6461},
	{start: 0xce6, end: 0xcef, script: 0x6b6e6461},
	{start: 0xcf1, end: 0xcf2, script: 0x6b6e6461},
	{start: 0xd00, end: 0xd0c, script: 0x6d6c796d},
	{start: 0xd0e, end: 0xd10, script: 0x6d6c796d},
	{start: 0xd12, end: 0xd44, script: 0x6d6c796d},
	{start: 0xd46, end: 0xd48, script: 0x6d6c796d},
	{start: 0xd4a, end: 0xd4f, script: 0x6d6c796d},
	{start: 0xd54, end: 0xd63, script: 0x6d6c796d},
	{start: 0xd66, end: 0xd7f, script: 0x6d6c796d},
	{start: 0xd81, end: 0xd83, script: 0x73696e68},
	{start: 0xd85, end: 0xd96, script: 0x73696e68},
	{start: 0xd9a, end: 0xdb1, script: 0x73696e68},
	{start: 0xdb3, end: 0xdbb, script: 0x73696e68},
	{start: 0xdbd, end: 0xdbd, script: 0x73696e68},
	{start: 0xdc0, end: 0xdc6, script: 0x73696e68},
	{start: 0xdca, end: 0xdca, script: 0x73696e68},
	{start: 0xdcf, end: 0xdd4, script: 0x73696e68},
	{start: 0xdd6, end: 0xdd6, script: 0x73696e68},
	{start: 0xdd8, end: 0xddf, script: 0x73696e68},
	{start: 0xde6, end: 0xdef, script: 0x73696e68},
	{start: 0xdf2, end: 0xdf4, script: 0x73696e68},
	{start: 0xe01, end: 0xe3a, script: 0x74686169},
	{start: 0xe3f, end: 0xe3f, script: 0x7a797979},
	{start: 0xe40, end: 0xe5b, script: 0x74686169},
	{start: 0xe81, end: 0xe82, script: 0x6c616f6f},
	{start: 0xe84, end: 0xe84, script: 0x6c616f6f},
	{start: 0xe86, end: 0xe8a, script: 0x6c616f6f},
	{start: 0xe8c, end: 0xea3, script: 0x6c616f6f},
	{start: 0xea5, end: 0xea5, script: 0x6c616f6f},
	{start: 0xea7, end: 0xebd, script: 0x6c616f6f},
	{start: 0xec0, end: 0xec4, script: 0x6c616f6f},
	{start: 0xec6, end: 0xec6, script: 0x6c616f6f},
	{start: 0xec8, end: 0xecd, script: 0x6c616f6f},
	{start: 0xed0, end: 0xed9, script: 0x6c616f6f},
	{start: 0xedc, end: 0xedf, script: 0x6c616f6f},
	{start: 0xf00, end: 0xf47, script: 0x74696274},
	{start: 0xf49, end: 0xf6c, script: 0x74696274},
	{start: 0xf71, end: 0xf97, script: 0x74696274},
	{start: 0xf99, end: 0xfbc, script: 0x74696274},
	{start: 0xfbe, end: 0xfcc, script: 0x74696274},
	{start: 0xfce, end: 0xfd4, script: 0x74696274},
	{start: 0xfd5, end: 0xfd8, script: 0x7a797979},
	{start: 0xfd9, end: 0xfda, script: 0x74696274},
	{start: 0x1000, end: 0x109f, script: 0x6d796d72},
	{start: 0x10a0, end: 0x10c5, script: 0x67656f72},
	{start: 0x10c7, end: 0x10c7, script: 0x67656f72},
	{start: 0x10cd, end: 0x10cd, script: 0x67656f72},
	{start: 0x10d0, end: 0x10fa, script: 0x67656f72},
	{start: 0x10fb, end: 0x10fb, script: 0x7a797979},
	{start: 0x10fc, end: 0x10ff, script: 0x67656f72},
	{start: 0x1100, end: 0x11ff, script: 0x68616e67},
	{start: 0x1200, end: 0x1248, script: 0x65746869},
	{start: 0x124a, end: 0x124d, script: 0x65746869},
	{start: 0x1250, end: 0x1256, script: 0x65746869},
	{start: 0x1258, end: 0x1258, script: 0x65746869},
	{start: 0x125a, end: 0x125d, script: 0x65746869},
	{start: 0x1260, end: 0x1288, script: 0x65746869},
	{start: 0x128a, end: 0x128d, script: 0x65746869},
	{start: 0x1290, end: 0x12b0, script: 0x65746869},
	{start: 0x12b2, end: 0x12b5, script: 0x65746869},
	{start: 0x12b8, end: 0x12be, script: 0x65746869},
	{start: 0x12c0, end: 0x12c0, script: 0x65746869},
	{start: 0x12c2, end: 0x12c5, script: 0x65746869},
	{start: 0x12c8, end: 0x12d6, script: 0x65746869},
	{start: 0x12d8, end: 0x1310, script: 0x65746869},
	{start: 0x1312, end: 0x1315, script: 0x65746869},
	{start: 0x1318, end: 0x135a, script: 0x65746869},
	{start: 0x135d, end: 0x137c, script: 0x65746869},
	{start: 0x1380, end: 0x1399, script: 0x65746869},
	{start: 0x13a0, end: 0x13f5, script: 0x63686572},
	{start: 0x13f8, end: 0x13fd, script: 0x63686572},
	{start: 0x1400, end: 0x167f, script: 0x63616e73},
	{start: 0x1680, end: 0x169c, script: 0x6f67616d},
	{start: 0x16a0, end: 0x16ea, script: 0x72756e72},
	{start: 0x16eb, end: 0x16ed, script: 0x7a797979},
	{start: 0x16ee, end: 0x16f8, script: 0x72756e72},
	{start: 0x1700, end: 0x170c, script: 0x74676c67},
	{start: 0x170e, end: 0x1714, script: 0x74676c67},
	{start: 0x1720, end: 0x1734, script: 0x68616e6f},
	{start: 0x1735, end: 0x1736, script: 0x7a797979},
	{start: 0x1740, end: 0x1753, script: 0x62756864},
	{start: 0x1760, end: 0x176c, script: 0x74616762},
	{start: 0x176e, end: 0x1770, script: 0x74616762},
	{start: 0x1772, end: 0x1773, script: 0x74616762},
	{start: 0x1780, end: 0x17dd, script: 0x6b686d72},
	{start: 0x17e0, end: 0x17e9, script: 0x6b686d72},
	{start: 0x17f0, end: 0x17f9, script: 0x6b686d72},
	{start: 0x1800, end: 0x1801, script: 0x6d6f6e67},
	{start: 0x1802, end: 0x1803, script: 0x7a797979},
	{start: 0x1804, end: 0x1804, script: 0x6d6f6e67},
	{start: 0x1805, end: 0x1805, script: 0x7a797979},
	{start: 0x1806, end: 0x180e, script: 0x6d6f6e67},
	{start: 0x1810, end: 0x1819, script: 0x6d6f6e67},
	{start: 0x1820, end: 0x1878, script: 0x6d6f6e67},
	{start: 0x1880, end: 0x18aa, script: 0x6d6f6e67},
	{start: 0x18b0, end: 0x18f5, script: 0x63616e73},
	{start: 0x1900, end: 0x191e, script: 0x6c696d62},
	{start: 0x1920, end: 0x192b, script: 0x6c696d62},
	{start: 0x1930, end: 0x193b, script: 0x6c696d62},
	{start: 0x1940, end: 0x1940, script: 0x6c696d62},
	{start: 0x1944, end: 0x194f, script: 0x6c696d62},
	{start: 0x1950, end: 0x196d, script: 0x74616c65},
	{start: 0x1970, end: 0x1974, script: 0x74616c65},
	{start: 0x1980, end: 0x19ab, script: 0x74616c75},
	{start: 0x19b0, end: 0x19c9, script: 0x74616c75},
	{start: 0x19d0, end: 0x19da, script: 0x74616c75},
	{start: 0x19de, end: 0x19df, script: 0x74616c75},
	{start: 0x19e0, end: 0x19ff, script: 0x6b686d72},
	{start: 0x1a00, end: 0x1a1b, script: 0x62756769},
	{start: 0x1a1e, end: 0x1a1f, script: 0x62756769},
	{start: 0x1a20, end: 0x1a5e, script: 0x6c616e61},
	{start: 0x1a60, end: 0x1a7c, script: 0x6c616e61},
	{start: 0x1a7f, end: 0x1a89, script: 0x6c616e61},
	{start: 0x1a90, end: 0x1a99, script: 0x6c616e61},
	{start: 0x1aa0, end: 0x1aad, script: 0x6c616e61},
	{start: 0x1ab0, end: 0x1ac0, script: 0x7a696e68},
	{start: 0x1b00, end: 0x1b4b, script: 0x62616c69},
	{start: 0x1b50, end: 0x1b7c, script: 0x62616c69},
	{start: 0x1b80, end: 0x1bbf, script: 0x73756e64},
	{start: 0x1bc0, end: 0x1bf3, script: 0x6261746b},
	{start: 0x1bfc, end: 0x1bff, script: 0x6261746b},
	{start: 0x1c00, end: 0x1c37, script: 0x6c657063},
	{start: 0x1c3b, end: 0x1c49, script: 0x6c657063},
	{start: 0x1c4d, end: 0x1c4f, script: 0x6c657063},
	{start: 0x1c50, end: 0x1c7f, script: 0x6f6c636b},
	{start: 0x1c80, end: 0x1c88, script: 0x6379726c},
	{start: 0x1c90, end: 0x1cba, script: 0x67656f72},
	{start: 0x1cbd, end: 0x1cbf, script: 0x67656f72},
	{start: 0x1cc0, end: 0x1cc7, script: 0x73756e64},
	{start: 0x1cd0, end: 0x1cd2, script: 0x7a696e68},
	{start: 0x1cd3, end: 0x1cd3, script: 0x7a797979},
	{start: 0x1cd4, end: 0x1ce0, script: 0x7a696e68},
	{start: 0x1ce1, end: 0x1ce1, script: 0x7a797979},
	{start: 0x1ce2, end: 0x1ce8, script: 0x7a696e68},
	{start: 0x1ce9, end: 0x1cec, script: 0x7a797979},
	{start: 0x1ced, end: 0x1ced, script: 0x7a696e68},
	{start: 0x1cee, end: 0x1cf3, script: 0x7a797979},
	{start: 0x1cf4, end: 0x1cf4, script: 0x7a696e68},
	{start: 0x1cf5, end: 0x1cf7, script: 0x7a797979},
	{start: 0x1cf8, end: 0x1cf9, script: 0x7a696e68},
	{start: 0x1cfa, end: 0x1cfa, script: 0x7a797979},
	{start: 0x1d00, end: 0x1d25, script: 0x6c61746e},
	{start: 0x1d26, end: 0x1d2a, script: 0x6772656b},
	{start: 0x1d2b, end: 0x1d2b, script: 0x6379726c},
	{start: 0x1d2c, end: 0x1d5c, script: 0x6c61746e},
	{start: 0x1d5d, end: 0x1d61, script: 0x6772656b},
	{start: 0x1d62, end: 0x1d65, script: 0x6c61746e},
	{start: 0x1d66, end: 0x1d6a, script: 0x6772656b},
	{start: 0x1d6b, end: 0x1d77, script: 0x6c61746e},
	{start: 0x1d78, end: 0x1d78, script: 0x6379726c},
	{start: 0x1d79, end: 0x1dbe, script: 0x6c61746e},
	{start: 0x1dbf, end: 0x1dbf, script: 0x6772656b},
	{start: 0x1dc0, end: 0x1df9, script: 0x7a696e68},
	{start: 0x1dfb, end: 0x1dff, script: 0x7a696e68},
	{start: 0x1e00, end: 0x1eff, script: 0x6c61746e},
	{start: 0x1f00, end: 0x1f15, script: 0x6772656b},
	{start: 0x1f18, end: 0x1f1d, script: 0x6772656b},
	{start: 0x1f20, end: 0x1f45, script: 0x6772656b},
	{start: 0x1f48, end: 0x1f4d, script: 0x6772656b},
	{start: 0x1f50, end: 0x1f57, script: 0x6772656b},
	{start: 0x1f59, end: 0x1f59, script: 0x6772656b},
	{start: 0x1f5b, end: 0x1f5b, script: 0x6772656b},
	{start: 0x1f5d, end: 0x1f5d, script: 0x6772656b},
	{start: 0x1f5f, end: 0x1f7d, script: 0x6772656b},
	{start: 0x1f80, end: 0x1fb4, script: 0x6772656b},
	{start: 0x1fb6, end: 0x1fc4, script: 0x6772656b},
	{start: 0x1fc6, end: 0x1fd3, script: 0x6772656b},
	{start: 0x1fd6, end: 0x1fdb, script: 0x6772656b},
	{start: 0x1fdd, end: 0x1fef, script: 0x6772656b},
	{start: 0x1ff2, end: 0x1ff4, script: 0x6772656b},
	{start: 0x1ff6, end: 0x1ffe, script: 0x6772656b},
	{start: 0x2000, end: 0x200b, script: 0x7a797979},
	{start: 0x200c, end: 0x200d, script: 0x7a696e68},
	{start: 0x200e, end: 0x2064, script: 0x7a797979},
	{start: 0x2066, end: 0x2070, script: 0x7a797979},
	{start: 0x2071, end: 0x2071, script: 0x6c61746e},
	{start: 0x2074, end: 0x207e, script: 0x7a797979},
	{start: 0x207f, end: 0x207f, script: 0x6c61746e},
	{start: 0x2080, end: 0x208e, script: 0x7a797979},
	{start: 0x2090, end: 0x209c, script: 0x6c61746e},
	{start: 0x20a0, end: 0x20bf, script: 0x7a797979},
	{start: 0x20d0, end: 0x20f0, script: 0x7a696e68},
	{start: 0x2100, end: 0x2125, script: 0x7a797979},
	{start: 0x2126, end: 0x2126, script: 0x6772656b},
	{start: 0x2127, end: 0x2129, script: 0x7a797979},
	{start: 0x212a, end: 0x212b, script: 0x6c61746e},
	{start: 0x212c, end: 0x2131, script: 0x7a797979},
	{start: 0x2132, end: 0x2132, script: 0x6c61746e},
	{start: 0x2133, end: 0x214d, script: 0x7a797979},
	{start: 0x214e, end: 0x214e, script: 0x6c61746e},
	{start: 0x214f, end: 0x215f, script: 0x7a797979},
	{start: 0x2160, end: 0x2188, script: 0x6c61746e},
	{start: 0x2189, end: 0x218b, script: 0x7a797979},
	{start: 0x2190, end: 0x2426, script: 0x7a797979},
	{start: 0x2440, end: 0x244a, script: 0x7a797979},
	{start: 0x2460, end: 0x27ff, script: 0x7a797979},
	{start: 0x2800, end: 0x28ff, script: 0x62726169},
	{start: 0x2900, end: 0x2b73, script: 0x7a797979},
	{start: 0x2b76, end: 0x2b95, script: 0x7a797979},
	{start: 0x2b97, end: 0x2bff, script: 0x7a797979},
	{start: 0x2c00, end: 0x2c2e, script: 0x676c6167},
	{start: 0x2c30, end: 0x2c5e, script: 0x676c6167},
	{start: 0x2c60, end: 0x2c7f, script: 0x6c61746e},
	{start: 0x2c80, end: 0x2cf3, script: 0x636f7074},
	{start: 0x2cf9, end: 0x2cff, script: 0x636f7074},
	{start: 0x2d00, end: 0x2d25, script: 0x67656f72},
	{start: 0x2d27, end: 0x2d27, script: 0x67656f72},
	{start: 0x2d2d, end: 0x2d2d, script: 0x67656f72},
	{start: 0x2d30, end: 0x2d67, script: 0x74666e67},
	{start: 0x2d6f, end: 0x2d70, script: 0x74666e67},
	{start: 0x2d7f, end: 0x2d7f, script: 0x74666e67},
	{start: 0x2d80, end: 0x2d96, script: 0x65746869},
	{start: 0x2da0, end: 0x2da6, script: 0x65746869},
	{start: 0x2da8, end: 0x2dae, script: 0x65746869},
	{start: 0x2db0, end: 0x2db6, script: 0x65746869},
	{start: 0x2db8, end: 0x2dbe, script: 0x65746869},
	{start: 0x2dc0, end: 0x2dc6, script: 0x65746869},
	{start: 0x2dc8, end: 0x2dce, script: 0x65746869},
	{start: 0x2dd0, end: 0x2dd6, script: 0x65746869},
	{start: 0x2dd8, end: 0x2dde, script: 0x65746869},
	{start: 0x2de0, end: 0x2dff, script: 0x6379726c},
	{start: 0x2e00, end: 0x2e52, script: 0x7a797979},
	{start: 0x2e80, end: 0x2e99, script: 0x68616e69},
	{start: 0x2e9b, end: 0x2ef3, script: 0x68616e69},
	{start: 0x2f00, end: 0x2fd5, script: 0x68616e69},
	{start: 0x2ff0, end: 0x2ffb, script: 0x7a797979},
	{start: 0x3000, end: 0x3004, script: 0x7a797979},
	{start: 0x3005, end: 0x3005, script: 0x68616e69},
	{start: 0x3006, end: 0x3006, script: 0x7a797979},
	{start: 0x3007, end: 0x3007, script: 0x68616e69},
	{start: 0x3008, end: 0x3020, script: 0x7a797979},
	{start: 0x3021, end: 0x3029, script: 0x68616e69},
	{start: 0x302a, end: 0x302d, script: 0x7a696e68},
	{start: 0x302e, end: 0x302f, script: 0x68616e67},
	{start: 0x3030, end: 0x3037, script: 0x7a797979},
	{start: 0x3038, end: 0x303b, script: 0x68616e69},
	{start: 0x303c, end: 0x303f, script: 0x7a797979},
	{start: 0x3041, end: 0x3096, script: 0x68697261},
	{start: 0x3099, end: 0x309a, script: 0x7a696e68},
	{start: 0x309b, end: 0x309c, script: 0x7a797979},
	{start: 0x309d, end: 0x309f, script: 0x68697261},
	{start: 0x30a0, end: 0x30a0, script: 0x7a797979},
	{start: 0x30a1, end: 0x30fa, script: 0x6b616e61},
	{start: 0x30fb, end: 0x30fc, script: 0x7a797979},
	{start: 0x30fd, end: 0x30ff, script: 0x6b616e61},
	{start: 0x3105, end: 0x312f, script: 0x626f706f},
	{start: 0x3131, end: 0x318e, script: 0x68616e67},
	{start: 0x3190, end: 0x319f, script: 0x7a797979},
	{start: 0x31a0, end: 0x31bf, script: 0x626f706f},
	{start: 0x31c0, end: 0x31e3, script: 0x7a797979},
	{start: 0x31f0, end: 0x31ff, script: 0x6b616e61},
	{start: 0x3200, end: 0x321e, script: 0x68616e67},
	{start: 0x3220, end: 0x325f, script: 0x7a797979},
	{start: 0x3260, end: 0x327e, script: 0x68616e67},
	{start: 0x327f, end: 0x32cf, script: 0x7a797979},
	{start: 0x32d0, end: 0x32fe, script: 0x6b616e61},
	{start: 0x32ff, end: 0x32ff, script: 0x7a797979},
	{start: 0x3300, end: 0x3357, script: 0x6b616e61},
	{start: 0x3358, end: 0x33ff, script: 0x7a797979},
	{start: 0x3400, end: 0x4dbf, script: 0x68616e69},
	{start: 0x4dc0, end: 0x4dff, script: 0x7a797979},
	{start: 0x4e00, end: 0x9ffc, script: 0x68616e69},
	{start: 0xa000, end: 0xa48c, script: 0x79696969},
	{start: 0xa490, end: 0xa4c6, script: 0x79696969},
	{start: 0xa4d0, end: 0xa4ff, script: 0x6c697375},
	{start: 0xa500, end: 0xa62b, script: 0x76616969},
	{start: 0xa640, end: 0xa69f, script: 0x6379726c},
	{start: 0xa6a0, end: 0xa6f7, script: 0x62616d75},
	{start: 0xa700, end: 0xa721, script: 0x7a797979},
	{start: 0xa722, end: 0xa787, script: 0x6c61746e},
	{start: 0xa788, end: 0xa78a, script: 0x7a797979},
	{start: 0xa78b, end: 0xa7bf, script: 0x6c61746e},
	{start: 0xa7c2, end: 0xa7ca, script: 0x6c61746e},
	{start: 0xa7f5, end: 0xa7ff, script: 0x6c61746e},
	{start: 0xa800, end: 0xa82c, script: 0x73796c6f},
	{start: 0xa830, end: 0xa839, script: 0x7a797979},
	{start: 0xa840, end: 0xa877, script: 0x70686167},
	{start: 0xa880, end: 0xa8c5, script: 0x73617572},
	{start: 0xa8ce, end: 0xa8d9, script: 0x73617572},
	{start: 0xa8e0, end: 0xa8ff, script: 0x64657661},
	{start: 0xa900, end: 0xa92d, script: 0x6b616c69},
	{start: 0xa92e, end: 0xa92e, script: 0x7a797979},
	{start: 0xa92f, end: 0xa92f, script: 0x6b616c69},
	{start: 0xa930, end: 0xa953, script: 0x726a6e67},
	{start: 0xa95f, end: 0xa95f, script: 0x726a6e67},
	{start: 0xa960, end: 0xa97c, script: 0x68616e67},
	{start: 0xa980, end: 0xa9cd, script: 0x6a617661},
	{start: 0xa9cf, end: 0xa9cf, script: 0x7a797979},
	{start: 0xa9d0, end: 0xa9d9, script: 0x6a617661},
	{start: 0xa9de, end: 0xa9df, script: 0x6a617661},
	{start: 0xa9e0, end: 0xa9fe, script: 0x6d796d72},
	{start: 0xaa00, end: 0xaa36, script: 0x6368616d},
	{start: 0xaa40, end: 0xaa4d, script: 0x6368616d},
	{start: 0xaa50, end: 0xaa59, script: 0x6368616d},
	{start: 0xaa5c, end: 0xaa5f, script: 0x6368616d},
	{start: 0xaa60, end: 0xaa7f, script: 0x6d796d72},
	{start: 0xaa80, end: 0xaac2, script: 0x74617674},
	{start: 0xaadb, end: 0xaadf, script: 0x74617674},
	{start: 0xaae0, end: 0xaaf6, script: 0x6d746569},
	{start: 0xab01, end: 0xab06, script: 0x65746869},
	{start: 0xab09, end: 0xab0e, script: 0x65746869},
	{start: 0xab11, end: 0xab16, script: 0x65746869},
	{start: 0xab20, end: 0xab26, script: 0x65746869},
	{start: 0xab28, end: 0xab2e, script: 0x65746869},
	{start: 0xab30, end: 0xab5a, script: 0x6c61746e},
	{start: 0xab5b, end: 0xab5b, script: 0x7a797979},
	{start: 0xab5c, end: 0xab64, script: 0x6c61746e},
	{start: 0xab65, end: 0xab65, script: 0x6772656b},
	{start: 0xab66, end: 0xab69, script: 0x6c61746e},
	{start: 0xab6a, end: 0xab6b, script: 0x7a797979},
	{start: 0xab70, end: 0xabbf, script: 0x63686572},
	{start: 0xabc0, end: 0xabed, script: 0x6d746569},
	{start: 0xabf0, end: 0xabf9, script: 0x6d746569},
	{start: 0xac00, end: 0xd7a3, script: 0x68616e67},
	{start: 0xd7b0, end: 0xd7c6, script: 0x68616e67},
	{start: 0xd7cb, end: 0xd7fb, script: 0x68616e67},
	{start: 0xf900, end: 0xfa6d, script: 0x68616e69},
	{start: 0xfa70, end: 0xfad9, script: 0x68616e69},
	{start: 0xfb00, end: 0xfb06, script: 0x6c61746e},
	{start: 0xfb13, end: 0xfb17, script: 0x61726d6e},
	{start: 0xfb1d, end: 0xfb36, script: 0x68656272},
	{start: 0xfb38, end: 0xfb3c, script: 0x68656272},
	{start: 0xfb3e, end: 0xfb3e, script: 0x68656272},
	{start: 0xfb40, end: 0xfb41, script: 0x68656272},
	{start: 0xfb43, end: 0xfb44, script: 0x68656272},
	{start: 0xfb46, end: 0xfb4f, script: 0x68656272},
	{start: 0xfb50, end: 0xfbc1, script: 0x61726162},
	{start: 0xfbd3, end: 0xfd3d, script: 0x61726162},
	{start: 0xfd3e, end: 0xfd3f, script: 0x7a797979},
	{start: 0xfd50, end: 0xfd8f, script: 0x61726162},
	{start: 0xfd92, end: 0xfdc7, script: 0x61726162},
	{start: 0xfdf0, end: 0xfdfd, script: 0x61726162},
	{start: 0xfe00, end: 0xfe0f, script: 0x7a696e68},
	{start: 0xfe10, end: 0xfe19, script: 0x7a797979},
	{start: 0xfe20, end: 0xfe2d, script: 0x7a696e68},
	{start: 0xfe2e, end: 0xfe2f, script: 0x6379726c},
	{start: 0xfe30, end: 0xfe52, script: 0x7a797979},
	{start: 0xfe54, end: 0xfe66, script: 0x7a797979},
	{start: 0xfe68, end: 0xfe6b, script: 0x7a797979},
	{start: 0xfe70, end: 0xfe74, script: 0x61726162},
	{start: 0xfe76, end: 0xfefc, script: 0x61726162},
	{start: 0xfeff, end: 0xfeff, script: 0x7a797979},
	{start: 0xff01, end: 0xff20, script: 0x7a797979},
	{start: 0xff21, end: 0xff3a, script: 0x6c61746e},
	{start: 0xff3b, end: 0xff40, script: 0x7a797979},
	{start: 0xff41, end: 0xff5a, script: 0x6c61746e},
	{start: 0xff5b, end: 0xff65, script: 0x7a797979},
	{start: 0xff66, end: 0xff6f, script: 0x6b616e61},
	{start: 0xff70, end: 0xff70, script: 0x7a797979},
	{start: 0xff71, end: 0xff9d, script: 0x6b616e61},
	{start: 0xff9e, end: 0xff9f, script: 0x7a797979},
	{start: 0xffa0, end: 0xffbe, script: 0x68616e67},
	{start: 0xffc2, end: 0xffc7, script: 0x68616e67},
	{start: 0xffca, end: 0xffcf, script: 0x68616e67},
	{start: 0xffd2, end: 0xffd7, script: 0x68616e67},
	{start: 0xffda, end: 0xffdc, script: 0x68616e67},
	{start: 0xffe0, end: 0xffe6, script: 0x7a797979},
	{start: 0xffe8, end: 0xffee, script: 0x7a797979},
	{start: 0xfff9, end: 0xfffd, script: 0x7a797979},
	{start: 0x10000, end: 0x1000b, script: 0x6c696e62},
	{start: 0x1000d, end: 0x10026, script: 0x6c696e62},
	{start: 0x10028, end: 0x1003a, script: 0x6c696e62},
	{start: 0x1003c, end: 0x1003d, script: 0x6c696e62},
	{start: 0x1003f, end: 0x1004d, script: 0x6c696e62},
	{start: 0x10050, end: 0x1005d, script: 0x6c696e62},
	{start: 0x10080, end: 0x100fa, script: 0x6c696e62},
	{start: 0x10100, end: 0x10102, script: 0x7a797979},
	{start: 0x10107, end: 0x10133, script: 0x7a797979},
	{start: 0x10137, end: 0x1013f, script: 0x7a797979},
	{start: 0x10140, end: 0x1018e, script: 0x6772656b},
	{start: 0x10190, end: 0x1019c, script: 0x7a797979},
	{start: 0x101a0, end: 0x101a0, script: 0x6772656b},
	{start: 0x101d0, end: 0x101fc, script: 0x7a797979},
	{start: 0x101fd, end: 0x101fd, script: 0x7a696e68},
	{start: 0x10280, end: 0x1029c, script: 0x6c796369},
	{start: 0x102a0, end: 0x102d0, script: 0x63617269},
	{start: 0x102e0, end: 0x102e0, script: 0x7a696e68},
	{start: 0x102e1, end: 0x102fb, script: 0x7a797979},
	{start: 0x10300, end: 0x10323, script: 0x6974616c},
	{start: 0x1032d, end: 0x1032f, script: 0x6974616c},
	{start: 0x10330, end: 0x1034a, script: 0x676f7468},
	{start: 0x10350, end: 0x1037a, script: 0x7065726d},
	{start: 0x10380, end: 0x1039d, script: 0x75676172},
	{start: 0x1039f, end: 0x1039f, script: 0x75676172},
	{start: 0x103a0, end: 0x103c3, script: 0x7870656f},
	{start: 0x103c8, end: 0x103d5, script: 0x7870656f},
	{start: 0x10400, end: 0x1044f, script: 0x64737274},
	{start: 0x10450, end: 0x1047f, script: 0x73686177},
	{start: 0x10480, end: 0x1049d, script: 0x6f736d61},
	{start: 0x104a0, end: 0x104a9, script: 0x6f736d61},
	{start: 0x104b0, end: 0x104d3, script: 0x6f736765},
	{start: 0x104d8, end: 0x104fb, script: 0x6f736765},
	{start: 0x10500, end: 0x10527, script: 0x656c6261},
	{start: 0x10530, end: 0x10563, script: 0x61676862},
	{start: 0x1056f, end: 0x1056f, script: 0x61676862},
	{start: 0x10600, end: 0x10736, script: 0x6c696e61},
	{start: 0x10740, end: 0x10755, script: 0x6c696e61},
	{start: 0x10760, end: 0x10767, script: 0x6c696e61},
	{start: 0x10800, end: 0x10805, script: 0x63707274},
	{start: 0x10808, end: 0x10808, script: 0x63707274},
	{start: 0x1080a, end: 0x10835, script: 0x63707274},
	{start: 0x10837, end: 0x10838, script: 0x63707274},
	{start: 0x1083c, end: 0x1083c, script: 0x63707274},
	{start: 0x1083f, end: 0x1083f, script: 0x63707274},
	{start: 0x10840, end: 0x10855, script: 0x61726d69},
	{start: 0x10857, end: 0x1085f, script: 0x61726d69},
	{start: 0x10860, end: 0x1087f, script: 0x70616c6d},
	{start: 0x10880, end: 0x1089e, script: 0x6e626174},
	{start: 0x108a7, end: 0x108af, script: 0x6e626174},
	{start: 0x108e0, end: 0x108f2, script: 0x68617472},
	{start: 0x108f4, end: 0x108f5, script: 0x68617472},
	{start: 0x108fb, end: 0x108ff, script: 0x68617472},
	{start: 0x10900, end: 0x1091b, script: 0x70686e78},
	{start: 0x1091f, end: 0x1091f, script: 0x70686e78},
	{start: 0x10920, end: 0x10939, script: 0x6c796469},
	{start: 0x1093f, end: 0x1093f, script: 0x6c796469},
	{start: 0x10980, end: 0x1099f, script: 0x6d65726f},
	{start: 0x109a0, end: 0x109b7, script: 0x6d657263},
	{start: 0x109bc, end: 0x109cf, script: 0x6d657263},
	{start: 0x109d2, end: 0x109ff, script: 0x6d657263},
	{start: 0x10a00, end: 0x10a03, script: 0x6b686172},
	{start: 0x10a05, end: 0x10a06, script: 0x6b686172},
	{start: 0x10a0c, end: 0x10a13, script: 0x6b686172},
	{start: 0x10a15, end: 0x10a17, script: 0x6b686172},
	{start: 0x10a19, end: 0x10a35, script: 0x6b686172},
	{start: 0x10a38, end: 0x10a3a, script: 0x6b686172},
	{start: 0x10a3f, end: 0x10a48, script: 0x6b686172},
	{start: 0x10a50, end: 0x10a58, script: 0x6b686172},
	{start: 0x10a60, end: 0x10a7f, script: 0x73617262},
	{start: 0x10a80, end: 0x10a9f, script: 0x6e617262},
	{start: 0x10ac0, end: 0x10ae6, script: 0x6d616e69},
	{start: 0x10aeb, end: 0x10af6, script: 0x6d616e69},
	{start: 0x10b00, end: 0x10b35, script: 0x61767374},
	{start: 0x10b39, end: 0x10b3f, script: 0x61767374},
	{start: 0x10b40, end: 0x10b55, script: 0x70727469},
	{start: 0x10b58, end: 0x10b5f, script: 0x70727469},
	{start: 0x10b60, end: 0x10b72, script: 0x70686c69},
	{start: 0x10b78, end: 0x10b7f, script: 0x70686c69},
	{start: 0x10b80, end: 0x10b91, script: 0x70686c70},
	{start: 0x10b99, end: 0x10b9c, script: 0x70686c70},
	{start: 0x10ba9, end: 0x10baf, script: 0x70686c70},
	{start: 0x10c00, end: 0x10c48, script: 0x6f726b68},
	{start: 0x10c80, end: 0x10cb2, script: 0x68756e67},
	{start: 0x10cc0, end: 0x10cf2, script: 0x68756e67},
	{start: 0x10cfa, end: 0x10cff, script: 0x68756e67},
	{start: 0x10d00, end: 0x10d27, script: 0x726f6867},
	{start: 0x10d30, end: 0x10d39, script: 0x726f6867},
	{start: 0x10e60, end: 0x10e7e, script: 0x61726162},
	{start: 0x10e80, end: 0x10ea9, script: 0x79657a69},
	{start: 0x10eab, end: 0x10ead, script: 0x79657a69},
	{start: 0x10eb0, end: 0x10eb1, script: 0x79657a69},
	{start: 0x10f00, end: 0x10f27, script: 0x736f676f},
	{start: 0x10f30, end: 0x10f59, script: 0x736f6764},
	{start: 0x10fb0, end: 0x10fcb, script: 0x63687273},
	{start: 0x10fe0, end: 0x10ff6, script: 0x656c796d},
	{start: 0x11000, end: 0x1104d, script: 0x62726168},
	{start: 0x11052, end: 0x1106f, script: 0x62726168},
	{start: 0x1107f, end: 0x1107f, script: 0x62726168},
	{start: 0x11080, end: 0x110c1, script: 0x6b746869},
	{start: 0x110cd, end: 0x110cd, script: 0x6b746869},
	{start: 0x110d0, end: 0x110e8, script: 0x736f7261},
	{start: 0x110f0, end: 0x110f9, script: 0x736f7261},
	{start: 0x11100, end: 0x11134, script: 0x63616b6d},
	{start: 0x11136, end: 0x11147, script: 0x63616b6d},
	{start: 0x11150, end: 0x11176, script: 0x6d61686a},
	{start: 0x11180, end: 0x111df, script: 0x73687264},
	{start: 0x111e1, end: 0x111f4, script: 0x73696e68},
	{start: 0x11200, end: 0x11211, script: 0x6b686f6a},
	{start: 0x11213, end: 0x1123e, script: 0x6b686f6a},
	{start: 0x11280, end: 0x11286, script: 0x6d756c74},
	{start: 0x11288, end: 0x11288, script: 0x6d756c74},
	{start: 0x1128a, end: 0x1128d, script: 0x6d756c74},
	{start: 0x1128f, end: 0x1129d, script: 0x6d756c74},
	{start: 0x1129f, end: 0x112a9, script: 0x6d756c74},
	{start: 0x112b0, end: 0x112ea, script: 0x73696e64},
	{start: 0x112f0, end: 0x112f9, script: 0x73696e64},
	{start: 0x11300, end: 0x11303, script: 0x6772616e},
	{start: 0x11305, end: 0x1130c, script: 0x6772616e},
	{start: 0x1130f, end: 0x11310, script: 0x6772616e},
	{start: 0x11313, end: 0x11328, script: 0x6772616e},
	{start: 0x1132a, end: 0x11330, script: 0x6772616e},
	{start: 0x11332, end: 0x11333, script: 0x6772616e},
	{start: 0x11335, end: 0x11339, script: 0x6772616e},
	{start: 0x1133b, end: 0x1133b, script: 0x7a696e68},
	{start: 0x1133c, end: 0x11344, script: 0x6772616e},
	{start: 0x11347, end: 0x11348, script: 0x6772616e},
	{start: 0x1134b, end: 0x1134d, script: 0x6772616e},
	{start: 0x11350, end: 0x11350, script: 0x6772616e},
	{start: 0x11357, end: 0x11357, script: 0x6772616e},
	{start: 0x1135d, end: 0x11363, script: 0x6772616e},
	{start: 0x11366, end: 0x1136c, script: 0x6772616e},
	{start: 0x11370, end: 0x11374, script: 0x6772616e},
	{start: 0x11400, end: 0x1145b, script: 0x6e657761},
	{start: 0x1145d, end: 0x11461, script: 0x6e657761},
	{start: 0x11480, end: 0x114c7, script: 0x74697268},
	{start: 0x114d0, end: 0x114d9, script: 0x74697268},
	{start: 0x11580, end: 0x115b5, script: 0x73696464},
	{start: 0x115b8, end: 0x115dd, script: 0x73696464},
	{start: 0x11600, end: 0x11644, script: 0x6d6f6469},
	{start: 0x11650, end: 0x11659, script: 0x6d6f6469},
	{start: 0x11660, end: 0x1166c, script: 0x6d6f6e67},
	{start: 0x11680, end: 0x116b8, script: 0x74616b72},
	{start: 0x116c0, end: 0x116c9, script: 0x74616b72},
	{start: 0x11700, end: 0x1171a, script: 0x61686f6d},
	{start: 0x1171d, end: 0x1172b, script: 0x61686f6d},
	{start: 0x11730, end: 0x1173f, script: 0x61686f6d},
	{start: 0x11800, end: 0x1183b, script: 0x646f6772},
	{start: 0x118a0, end: 0x118f2, script: 0x77617261},
	{start: 0x118ff, end: 0x118ff, script: 0x77617261},
	{start: 0x11900, end: 0x11906, script: 0x6469616b},
	{start: 0x11909, end: 0x11909, script: 0x6469616b},
	{start: 0x1190c, end: 0x11913, script: 0x6469616b},
	{start: 0x11915, end: 0x11916, script: 0x6469616b},
	{start: 0x11918, end: 0x11935, script: 0x6469616b},
	{start: 0x11937, end: 0x11938, script: 0x6469616b},
	{start: 0x1193b, end: 0x11946, script: 0x6469616b},
	{start: 0x11950, end: 0x11959, script: 0x6469616b},
	{start: 0x119a0, end: 0x119a7, script: 0x6e616e64},
	{start: 0x119aa, end: 0x119d7, script: 0x6e616e64},
	{start: 0x119da, end: 0x119e4, script: 0x6e616e64},
	{start: 0x11a00, end: 0x11a47, script: 0x7a616e62},
	{start: 0x11a50, end: 0x11aa2, script: 0x736f796f},
	{start: 0x11ac0, end: 0x11af8, script: 0x70617563},
	{start: 0x11c00, end: 0x11c08, script: 0x62686b73},
	{start: 0x11c0a, end: 0x11c36, script: 0x62686b73},
	{start: 0x11c38, end: 0x11c45, script: 0x62686b73},
	{start: 0x11c50, end: 0x11c6c, script: 0x62686b73},
	{start: 0x11c70, end: 0x11c8f, script: 0x6d617263},
	{start: 0x11c92, end: 0x11ca7, script: 0x6d617263},
	{start: 0x11ca9, end: 0x11cb6, script: 0x6d617263},
	{start: 0x11d00, end: 0x11d06, script: 0x676f6e6d},
	{start: 0x11d08, end: 0x11d09, script: 0x676f6e6d},
	{start: 0x11d0b, end: 0x11d36, script: 0x676f6e6d},
	{start: 0x11d3a, end: 0x11d3a, script: 0x676f6e6d},
	{start: 0x11d3c, end: 0x11d3d, script: 0x676f6e6d},
	{start: 0x11d3f, end: 0x11d47, script: 0x676f6e6d},
	{start: 0x11d50, end: 0x11d59, script: 0x676f6e6d},
	{start: 0x11d60, end: 0x11d65, script: 0x676f6e67},
	{start: 0x11d67, end: 0x11d68, script: 0x676f6e67},
	{start: 0x11d6a, end: 0x11d8e, script: 0x676f6e67},
	{start: 0x11d90, end: 0x11d91, script: 0x676f6e67},
	{start: 0x11d93, end: 0x11d98, script: 0x676f6e67},
	{start: 0x11da0, end: 0x11da9, script: 0x676f6e67},
	{start: 0x11ee0, end: 0x11ef8, script: 0x6d616b61},
	{start: 0x11fb0, end: 0x11fb0, script: 0x6c697375},
	{start: 0x11fc0, end: 0x11ff1, script: 0x74616d6c},
	{start: 0x11fff, end: 0x11fff, script: 0x74616d6c},
	{start: 0x12000, end: 0x12399, script: 0x78737578},
	{start: 0x12400, end: 0x1246e, script: 0x78737578},
	{start: 0x12470, end: 0x12474, script: 0x78737578},
	{start: 0x12480, end: 0x12543, script: 0x78737578},
	{start: 0x13000, end: 0x1342e, script: 0x65677970},
	{start: 0x13430, end: 0x13438, script: 0x65677970},
	{start: 0x14400, end: 0x14646, script: 0x686c7577},
	{start: 0x16800, end: 0x16a38, script: 0x62616d75},
	{start: 0x16a40, end: 0x16a5e, script: 0x6d726f6f},
	{start: 0x16a60, end: 0x16a69, script: 0x6d726f6f},
	{start: 0x16a6e, end: 0x16a6f, script: 0x6d726f6f},
	{start: 0x16ad0, end: 0x16aed, script: 0x62617373},
	{start: 0x16af0, end: 0x16af5, script: 0x62617373},
	{start: 0x16b00, end: 0x16b45, script: 0x686d6e67},
	{start: 0x16b50, end: 0x16b59, script: 0x686d6e67},
	{start: 0x16b5b, end: 0x16b61, script: 0x686d6e67},
	{start: 0x16b63, end: 0x16b77, script: 0x686d6e67},
	{start: 0x16b7d, end: 0x16b8f, script: 0x686d6e67},
	{start: 0x16e40, end: 0x16e9a, script: 0x6d656466},
	{start: 0x16f00, end: 0x16f4a, script: 0x706c7264},
	{start: 0x16f4f, end: 0x16f87, script: 0x706c7264},
	{start: 0x16f8f, end: 0x16f9f, script: 0x706c7264},
	{start: 0x16fe0, end: 0x16fe0, script: 0x74616e67},
	{start: 0x16fe1, end: 0x16fe1, script: 0x6e736875},
	{start: 0x16fe2, end: 0x16fe3, script: 0x7a797979},
	{start: 0x16fe4, end: 0x16fe4, script: 0x6b697473},
	{start: 0x16ff0, end: 0x16ff1, script: 0x68616e69},
	{start: 0x17000, end: 0x187f7, script: 0x74616e67},
	{start: 0x18800, end: 0x18aff, script: 0x74616e67},
	{start: 0x18b00, end: 0x18cd5, script: 0x6b697473},
	{start: 0x18d00, end: 0x18d08, script: 0x74616e67},
	{start: 0x1b000, end: 0x1b000, script: 0x6b616e61},
	{start: 0x1b001, end: 0x1b11e, script: 0x68697261},
	{start: 0x1b150, end: 0x1b152, script: 0x68697261},
	{start: 0x1b164, end: 0x1b167, script: 0x6b616e61},
	{start: 0x1b170, end: 0x1b2fb, script: 0x6e736875},
	{start: 0x1bc00, end: 0x1bc6a, script: 0x6475706c},
	{start: 0x1bc70, end: 0x1bc7c, script: 0x6475706c},
	{start: 0x1bc80, end: 0x1bc88, script: 0x6475706c},
	{start: 0x1bc90, end: 0x1bc99, script: 0x6475706c},
	{start: 0x1bc9c, end: 0x1bc9f, script: 0x6475706c},
	{start: 0x1bca0, end: 0x1bca3, script: 0x7a797979},
	{start: 0x1d000, end: 0x1d0f5, script: 0x7a797979},
	{start: 0x1d100, end: 0x1d126, script: 0x7a797979},
	{start: 0x1d129, end: 0x1d166, script: 0x7a797979},
	{start: 0x1d167, end: 0x1d169, script: 0x7a696e68},
	{start: 0x1d16a, end: 0x1d17a, script: 0x7a797979},
	{start: 0x1d17b, end: 0x1d182, script: 0x7a696e68},
	{start: 0x1d183, end: 0x1d184, script: 0x7a797979},
	{start: 0x1d185, end: 0x1d18b, script: 0x7a696e68},
	{start: 0x1d18c, end: 0x1d1a9, script: 0x7a797979},
	{start: 0x1d1aa, end: 0x1d1ad, script: 0x7a696e68},
	{start: 0x1d1ae, end: 0x1d1e8, script: 0x7a797979},
	{start: 0x1d200, end: 0x1d245, script: 0x6772656b},
	{start: 0x1d2e0, end: 0x1d2f3, script: 0x7a797979},
	{start: 0x1d300, end: 0x1d356, script: 0x7a797979},
	{start: 0x1d360, end: 0x1d378, script: 0x7a797979},
	{start: 0x1d400, end: 0x1d454, script: 0x7a797979},
	{start: 0x1d456, end: 0x1d49c, script: 0x7a797979},
	{start: 0x1d49e, end: 0x1d49f, script: 0x7a797979},
	{start: 0x1d4a2, end: 0x1d4a2, script: 0x7a797979},
	{start: 0x1d4a5, end: 0x1d4a6, script: 0x7a797979},
	{start: 0x1d4a9, end: 0x1d4ac, script: 0x7a797979},
	{start: 0x1d4ae, end: 0x1d4b9, script: 0x7a797979},
	{start: 0x1d4bb, end: 0x1d4bb, script: 0x7a797979},
	{start: 0x1d4bd, end: 0x1d4c3, script: 0x7a797979},
	{start: 0x1d4c5, end: 0x1d505, script: 0x7a797979},
	{start: 0x1d507, end: 0x1d50a, script: 0x7a797979},
	{start: 0x1d50d, end: 0x1d514, script: 0x7a797979},
	{start: 0x1d516, end: 0x1d51c, script: 0x7a797979},
	{start: 0x1d51e, end: 0x1d539, script: 0x7a797979},
	{start: 0x1d53b, end: 0x1d53e, script: 0x7a797979},
	{start: 0x1d540, end: 0x1d544, script: 0x7a797979},
	{start: 0x1d546, end: 0x1d546, script: 0x7a797979},
	{start: 0x1d54a, end: 0x1d550, script: 0x7a797979},
	{start: 0x1d552, end: 0x1d6a5, script: 0x7a797979},
	{start: 0x1d6a8, end: 0x1d7cb, script: 0x7a797979},
	{start: 0x1d7ce, end: 0x1d7ff, script: 0x7a797979},
	{start: 0x1d800, end: 0x1da8b, script: 0x73676e77},
	{start: 0x1da9b, end: 0x1da9f, script: 0x73676e77},
	{start: 0x1daa1, end: 0x1daaf, script: 0x73676e77},
	{start: 0x1e000, end: 0x1e006, script: 0x676c6167},
	{start: 0x1e008, end: 0x1e018, script: 0x676c6167},
	{start: 0x1e01b, end: 0x1e021, script: 0x676c6167},
	{start: 0x1e023, end: 0x1e024, script: 0x676c6167},
	{start: 0x1e026, end: 0x1e02a, script: 0x676c6167},
	{start: 0x1e100, end: 0x1e12c, script: 0x686d6e70},
	{start: 0x1e130, end: 0x1e13d, script: 0x686d6e70},
	{start: 0x1e140, end: 0x1e149, script: 0x686d6e70},
	{start: 0x1e14e, end: 0x1e14f, script: 0x686d6e70},
	{start: 0x1e2c0, end: 0x1e2f9, script: 0x7763686f},
	{start: 0x1e2ff, end: 0x1e2ff, script: 0x7763686f},
	{start: 0x1e800, end: 0x1e8c4, script: 0x6d656e64},
	{start: 0x1e8c7, end: 0x1e8d6, script: 0x6d656e64},
	{start: 0x1e900, end: 0x1e94b, script: 0x61646c6d},
	{start: 0x1e950, end: 0x1e959, script: 0x61646c6d},
	{start: 0x1e95e, end: 0x1e95f, script: 0x61646c6d},
	{start: 0x1ec71, end: 0x1ecb4, script: 0x7a797979},
	{start: 0x1ed01, end: 0x1ed3d, script: 0x7a797979},
	{start: 0x1ee00, end: 0x1ee03, script: 0x61726162},
	{start: 0x1ee05, end: 0x1ee1f, script: 0x61726162},
	{start: 0x1ee21, end: 0x1ee22, script: 0x61726162},
	{start: 0x1ee24, end: 0x1ee24, script: 0x61726162},
	{start: 0x1ee27, end: 0x1ee27, script: 0x61726162},
	{start: 0x1ee29, end: 0x1ee32, script: 0x61726162},
	{start: 0x1ee34, end: 0x1ee37, script: 0x61726162},
	{start: 0x1ee39, end: 0x1ee39, script: 0x61726162},
	{start: 0x1ee3b, end: 0x1ee3b, script: 0x61726162},
	{start: 0x1ee42, end: 0x1ee42, script: 0x61726162},
	{start: 0x1ee47, end: 0x1ee47, script: 0x61726162},
	{start: 0x1ee49, end: 0x1ee49, script: 0x61726162},
	{start: 0x1ee4b, end: 0x1ee4b, script: 0x61726162},
	{start: 0x1ee4d, end: 0x1ee4f, script: 0x61726162},
	{start: 0x1ee51, end: 0x1ee52, script: 0x61726162},
	{start: 0x1ee54, end: 0x1ee54, script: 0x61726162},
	{start: 0x1ee57, end: 0x1ee57, script: 0x61726162},
	{start: 0x1ee59, end: 0x1ee59, script: 0x61726162},
	{start: 0x1ee5b, end: 0x1ee5b, script: 0x61726162},
	{start: 0x1ee5d, end: 0x1ee5d, script: 0x61726162},
	{start: 0x1ee5f, end: 0x1ee5f, script: 0x61726162},
	{start: 0x1ee61, end: 0x1ee62, script: 0x61726162},
	{start: 0x1ee64, end: 0x1ee64, script: 0x61726162},
	{start: 0x1ee67, end: 0x1ee6a, script: 0x61726162},
	{start: 0x1ee6c, end: 0x1ee72, script: 0x61726162},
	{start: 0x1ee74, end: 0x1ee77, script: 0x61726162},
	{start: 0x1ee79, end: 0x1ee7c, script: 0x61726162},
	{start: 0x1ee7e, end: 0x1ee7e, script: 0x61726162},
	{start: 0x1ee80, end: 0x1ee89, script: 0x61726162},
	{start: 0x1ee8b, end: 0x1ee9b, script: 0x61726162},
	{start: 0x1eea1, end: 0x1eea3, script: 0x61726162},
	{start: 0x1eea5, end: 0x1eea9, script: 0x61726162},
	{start: 0x1eeab, end: 0x1eebb, script: 0x61726162},
	{start: 0x1eef0, end: 0x1eef1, script: 0x61726162},
	{start: 0x1f000, end: 0x1f02b, script: 0x7a797979},
	{start: 0x1f030, end: 0x1f093, script: 0x7a797979},
	{start: 0x1f0a0, end: 0x1f0ae, script: 0x7a797979},
	{start: 0x1f0b1, end: 0x1f0bf, script: 0x7a797979},
	{start: 0x1f0c1, end: 0x1f0cf, script: 0x7a797979},
	{start: 0x1f0d1, end: 0x1f0f5, script: 0x7a797979},
	{start: 0x1f100, end: 0x1f1ad, script: 0x7a797979},
	{start: 0x1f1e6, end: 0x1f1ff, script: 0x7a797979},
	{start: 0x1f200, end: 0x1f200, script: 0x68697261},
	{start: 0x1f201, end: 0x1f202, script: 0x7a797979},
	{start: 0x1f210, end: 0x1f23b, script: 0x7a797979},
	{start: 0x1f240, end: 0x1f248, script: 0x7a797979},
	{start: 0x1f250, end: 0x1f251, script: 0x7a797979},
	{start: 0x1f260, end: 0x1f265, script: 0x7a797979},
	{start: 0x1f300, end: 0x1f6d7, script: 0x7a797979},
	{start: 0x1f6e0, end: 0x1f6ec, script: 0x7a797979},
	{start: 0x1f6f0, end: 0x1f6fc, script: 0x7a797979},
	{start: 0x1f700, end: 0x1f773, script: 0x7a797979},
	{start: 0x1f780, end: 0x1f7d8, script: 0x7a797979},
	{start: 0x1f7e0, end: 0x1f7eb, script: 0x7a797979},
	{start: 0x1f800, end: 0x1f80b, script: 0x7a797979},
	{start: 0x1f810, end: 0x1f847, script: 0x7a797979},
	{start: 0x1f850, end: 0x1f859, script: 0x7a797979},
	{start: 0x1f860, end: 0x1f887, script: 0x7a797979},
	{start: 0x1f890, end: 0x1f8ad, script: 0x7a797979},
	{start: 0x1f8b0, end: 0x1f8b1, script: 0x7a797979},
	{start: 0x1f900, end: 0x1f978, script: 0x7a797979},
	{start: 0x1f97a, end: 0x1f9cb, script: 0x7a797979},
	{start: 0x1f9cd, end: 0x1fa53, script: 0x7a797979},
	{start: 0x1fa60, end: 0x1fa6d, script: 0x7a797979},
	{start: 0x1fa70, end: 0x1fa74, script: 0x7a797979},
	{start: 0x1fa78, end: 0x1fa7a, script: 0x7a797979},
	{start: 0x1fa80, end: 0x1fa86, script: 0x7a797979},
	{start: 0x1fa90, end: 0x1faa8, script: 0x7a797979},
	{start: 0x1fab0, end: 0x1fab6, script: 0x7a797979},
	{start: 0x1fac0, end: 0x1fac2, script: 0x7a797979},
	{start: 0x1fad0, end: 0x1fad6, script: 0x7a797979},
	{start: 0x1fb00, end: 0x1fb92, script: 0x7a797979},
	{start: 0x1fb94, end: 0x1fbca, script: 0x7a797979},
	{start: 0x1fbf0, end: 0x1fbf9, script: 0x7a797979},
	{start: 0x20000, end: 0x2a6dd, script: 0x68616e69},
	{start: 0x2a700, end: 0x2b734, script: 0x68616e69},
	{start: 0x2b740, end: 0x2b81d, script: 0x68616e69},
	{start: 0x2b820, end: 0x2cea1, script: 0x68616e69},
	{start: 0x2ceb0, end: 0x2ebe0, script: 0x68616e69},
	{start: 0x2f800, end: 0x2fa1d, script: 0x68616e69},
	{start: 0x30000, end: 0x3134a, script: 0x68616e69},
	{start: 0xe0001, end: 0xe0001, script: 0x7a797979},
	{start: 0xe0020, end: 0xe007f, script: 0x7a797979},
	{start: 0xe0100, end: 0xe01ef, script: 0x7a696e68},
}
