// Code generated by go run gen.go; DO NOT EDIT.
//go:build !js
// +build !js

package async

import (
	"sync/atomic"
	"unsafe"

	"fyne.io/fyne/v2"
)

// CanvasObjectQueue implements lock-free FIFO freelist based queue.
//
// Reference: https://dl.acm.org/citation.cfm?doid=248052.248106
type CanvasObjectQueue struct {
	head unsafe.Pointer
	tail unsafe.Pointer
	len  uint64
}

// NewCanvasObjectQueue returns a queue for caching values.
func NewCanvasObjectQueue() *CanvasObjectQueue {
	head := &itemCanvasObject{next: nil, v: nil}
	return &CanvasObjectQueue{
		tail: unsafe.Pointer(head),
		head: unsafe.Pointer(head),
	}
}

type itemCanvasObject struct {
	next unsafe.Pointer
	v    fyne.CanvasObject
}

func loadCanvasObjectItem(p *unsafe.Pointer) *itemCanvasObject {
	return (*itemCanvasObject)(atomic.LoadPointer(p))
}

func casCanvasObjectItem(p *unsafe.Pointer, old, new *itemCanvasObject) bool {
	return atomic.CompareAndSwapPointer(p, unsafe.Pointer(old), unsafe.Pointer(new))
}
