// Code generated by Thrift Compiler (0.16.0). DO NOT EDIT.

package parquet

import (
	"bytes"
	"context"
	"database/sql/driver"
	"errors"
	"fmt"
	thrift "github.com/apache/thrift/lib/go/thrift"
	"time"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

//Types supported by Parquet.  These types are intended to be used in combination
//with the encodings to control the on disk storage format.
//For example INT16 is not included as a type since a good encoding of INT32
//would handle this.
type Type int64

const (
	Type_BOOLEAN              Type = 0
	Type_INT32                Type = 1
	Type_INT64                Type = 2
	Type_INT96                Type = 3
	Type_FLOAT                Type = 4
	Type_DOUBLE               Type = 5
	Type_BYTE_ARRAY           Type = 6
	Type_FIXED_LEN_BYTE_ARRAY Type = 7
)

func (p Type) String() string {
	switch p {
	case Type_BOOLEAN:
		return "BOOLEAN"
	case Type_INT32:
		return "INT32"
	case Type_INT64:
		return "INT64"
	case Type_INT96:
		return "INT96"
	case Type_FLOAT:
		return "FLOAT"
	case Type_DOUBLE:
		return "DOUBLE"
	case Type_BYTE_ARRAY:
		return "BYTE_ARRAY"
	case Type_FIXED_LEN_BYTE_ARRAY:
		return "FIXED_LEN_BYTE_ARRAY"
	}
	return "<UNSET>"
}

func TypeFromString(s string) (Type, error) {
	switch s {
	case "BOOLEAN":
		return Type_BOOLEAN, nil
	case "INT32":
		return Type_INT32, nil
	case "INT64":
		return Type_INT64, nil
	case "INT96":
		return Type_INT96, nil
	case "FLOAT":
		return Type_FLOAT, nil
	case "DOUBLE":
		return Type_DOUBLE, nil
	case "BYTE_ARRAY":
		return Type_BYTE_ARRAY, nil
	case "FIXED_LEN_BYTE_ARRAY":
		return Type_FIXED_LEN_BYTE_ARRAY, nil
	}
	return Type(0), fmt.Errorf("not a valid Type string")
}

func TypePtr(v Type) *Type { return &v }

func (p Type) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *Type) UnmarshalText(text []byte) error {
	q, err := TypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *Type) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = Type(v)
	return nil
}

func (p *Type) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

//DEPRECATED: Common types used by frameworks(e.g. hive, pig) using parquet.
//ConvertedType is superseded by LogicalType.  This enum should not be extended.
//
//See LogicalTypes.md for conversion between ConvertedType and LogicalType.
type ConvertedType int64

const (
	ConvertedType_UTF8             ConvertedType = 0
	ConvertedType_MAP              ConvertedType = 1
	ConvertedType_MAP_KEY_VALUE    ConvertedType = 2
	ConvertedType_LIST             ConvertedType = 3
	ConvertedType_ENUM             ConvertedType = 4
	ConvertedType_DECIMAL          ConvertedType = 5
	ConvertedType_DATE             ConvertedType = 6
	ConvertedType_TIME_MILLIS      ConvertedType = 7
	ConvertedType_TIME_MICROS      ConvertedType = 8
	ConvertedType_TIMESTAMP_MILLIS ConvertedType = 9
	ConvertedType_TIMESTAMP_MICROS ConvertedType = 10
	ConvertedType_UINT_8           ConvertedType = 11
	ConvertedType_UINT_16          ConvertedType = 12
	ConvertedType_UINT_32          ConvertedType = 13
	ConvertedType_UINT_64          ConvertedType = 14
	ConvertedType_INT_8            ConvertedType = 15
	ConvertedType_INT_16           ConvertedType = 16
	ConvertedType_INT_32           ConvertedType = 17
	ConvertedType_INT_64           ConvertedType = 18
	ConvertedType_JSON             ConvertedType = 19
	ConvertedType_BSON             ConvertedType = 20
	ConvertedType_INTERVAL         ConvertedType = 21
)

func (p ConvertedType) String() string {
	switch p {
	case ConvertedType_UTF8:
		return "UTF8"
	case ConvertedType_MAP:
		return "MAP"
	case ConvertedType_MAP_KEY_VALUE:
		return "MAP_KEY_VALUE"
	case ConvertedType_LIST:
		return "LIST"
	case ConvertedType_ENUM:
		return "ENUM"
	case ConvertedType_DECIMAL:
		return "DECIMAL"
	case ConvertedType_DATE:
		return "DATE"
	case ConvertedType_TIME_MILLIS:
		return "TIME_MILLIS"
	case ConvertedType_TIME_MICROS:
		return "TIME_MICROS"
	case ConvertedType_TIMESTAMP_MILLIS:
		return "TIMESTAMP_MILLIS"
	case ConvertedType_TIMESTAMP_MICROS:
		return "TIMESTAMP_MICROS"
	case ConvertedType_UINT_8:
		return "UINT_8"
	case ConvertedType_UINT_16:
		return "UINT_16"
	case ConvertedType_UINT_32:
		return "UINT_32"
	case ConvertedType_UINT_64:
		return "UINT_64"
	case ConvertedType_INT_8:
		return "INT_8"
	case ConvertedType_INT_16:
		return "INT_16"
	case ConvertedType_INT_32:
		return "INT_32"
	case ConvertedType_INT_64:
		return "INT_64"
	case ConvertedType_JSON:
		return "JSON"
	case ConvertedType_BSON:
		return "BSON"
	case ConvertedType_INTERVAL:
		return "INTERVAL"
	}
	return "<UNSET>"
}

func ConvertedTypeFromString(s string) (ConvertedType, error) {
	switch s {
	case "UTF8":
		return ConvertedType_UTF8, nil
	case "MAP":
		return ConvertedType_MAP, nil
	case "MAP_KEY_VALUE":
		return ConvertedType_MAP_KEY_VALUE, nil
	case "LIST":
		return ConvertedType_LIST, nil
	case "ENUM":
		return ConvertedType_ENUM, nil
	case "DECIMAL":
		return ConvertedType_DECIMAL, nil
	case "DATE":
		return ConvertedType_DATE, nil
	case "TIME_MILLIS":
		return ConvertedType_TIME_MILLIS, nil
	case "TIME_MICROS":
		return ConvertedType_TIME_MICROS, nil
	case "TIMESTAMP_MILLIS":
		return ConvertedType_TIMESTAMP_MILLIS, nil
	case "TIMESTAMP_MICROS":
		return ConvertedType_TIMESTAMP_MICROS, nil
	case "UINT_8":
		return ConvertedType_UINT_8, nil
	case "UINT_16":
		return ConvertedType_UINT_16, nil
	case "UINT_32":
		return ConvertedType_UINT_32, nil
	case "UINT_64":
		return ConvertedType_UINT_64, nil
	case "INT_8":
		return ConvertedType_INT_8, nil
	case "INT_16":
		return ConvertedType_INT_16, nil
	case "INT_32":
		return ConvertedType_INT_32, nil
	case "INT_64":
		return ConvertedType_INT_64, nil
	case "JSON":
		return ConvertedType_JSON, nil
	case "BSON":
		return ConvertedType_BSON, nil
	case "INTERVAL":
		return ConvertedType_INTERVAL, nil
	}
	return ConvertedType(0), fmt.Errorf("not a valid ConvertedType string")
}

func ConvertedTypePtr(v ConvertedType) *ConvertedType { return &v }

func (p ConvertedType) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *ConvertedType) UnmarshalText(text []byte) error {
	q, err := ConvertedTypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *ConvertedType) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = ConvertedType(v)
	return nil
}

func (p *ConvertedType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

//Representation of Schemas
type FieldRepetitionType int64

const (
	FieldRepetitionType_REQUIRED FieldRepetitionType = 0
	FieldRepetitionType_OPTIONAL FieldRepetitionType = 1
	FieldRepetitionType_REPEATED FieldRepetitionType = 2
)

func (p FieldRepetitionType) String() string {
	switch p {
	case FieldRepetitionType_REQUIRED:
		return "REQUIRED"
	case FieldRepetitionType_OPTIONAL:
		return "OPTIONAL"
	case FieldRepetitionType_REPEATED:
		return "REPEATED"
	}
	return "<UNSET>"
}

func FieldRepetitionTypeFromString(s string) (FieldRepetitionType, error) {
	switch s {
	case "REQUIRED":
		return FieldRepetitionType_REQUIRED, nil
	case "OPTIONAL":
		return FieldRepetitionType_OPTIONAL, nil
	case "REPEATED":
		return FieldRepetitionType_REPEATED, nil
	}
	return FieldRepetitionType(0), fmt.Errorf("not a valid FieldRepetitionType string")
}

func FieldRepetitionTypePtr(v FieldRepetitionType) *FieldRepetitionType { return &v }

func (p FieldRepetitionType) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *FieldRepetitionType) UnmarshalText(text []byte) error {
	q, err := FieldRepetitionTypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *FieldRepetitionType) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = FieldRepetitionType(v)
	return nil
}

func (p *FieldRepetitionType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

//Encodings supported by Parquet.  Not all encodings are valid for all types.  These
//enums are also used to specify the encoding of definition and repetition levels.
//See the accompanying doc for the details of the more complicated encodings.
type Encoding int64

const (
	Encoding_PLAIN                   Encoding = 0
	Encoding_PLAIN_DICTIONARY        Encoding = 2
	Encoding_RLE                     Encoding = 3
	Encoding_BIT_PACKED              Encoding = 4
	Encoding_DELTA_BINARY_PACKED     Encoding = 5
	Encoding_DELTA_LENGTH_BYTE_ARRAY Encoding = 6
	Encoding_DELTA_BYTE_ARRAY        Encoding = 7
	Encoding_RLE_DICTIONARY          Encoding = 8
	Encoding_BYTE_STREAM_SPLIT       Encoding = 9
)

func (p Encoding) String() string {
	switch p {
	case Encoding_PLAIN:
		return "PLAIN"
	case Encoding_PLAIN_DICTIONARY:
		return "PLAIN_DICTIONARY"
	case Encoding_RLE:
		return "RLE"
	case Encoding_BIT_PACKED:
		return "BIT_PACKED"
	case Encoding_DELTA_BINARY_PACKED:
		return "DELTA_BINARY_PACKED"
	case Encoding_DELTA_LENGTH_BYTE_ARRAY:
		return "DELTA_LENGTH_BYTE_ARRAY"
	case Encoding_DELTA_BYTE_ARRAY:
		return "DELTA_BYTE_ARRAY"
	case Encoding_RLE_DICTIONARY:
		return "RLE_DICTIONARY"
	case Encoding_BYTE_STREAM_SPLIT:
		return "BYTE_STREAM_SPLIT"
	}
	return "<UNSET>"
}

func EncodingFromString(s string) (Encoding, error) {
	switch s {
	case "PLAIN":
		return Encoding_PLAIN, nil
	case "PLAIN_DICTIONARY":
		return Encoding_PLAIN_DICTIONARY, nil
	case "RLE":
		return Encoding_RLE, nil
	case "BIT_PACKED":
		return Encoding_BIT_PACKED, nil
	case "DELTA_BINARY_PACKED":
		return Encoding_DELTA_BINARY_PACKED, nil
	case "DELTA_LENGTH_BYTE_ARRAY":
		return Encoding_DELTA_LENGTH_BYTE_ARRAY, nil
	case "DELTA_BYTE_ARRAY":
		return Encoding_DELTA_BYTE_ARRAY, nil
	case "RLE_DICTIONARY":
		return Encoding_RLE_DICTIONARY, nil
	case "BYTE_STREAM_SPLIT":
		return Encoding_BYTE_STREAM_SPLIT, nil
	}
	return Encoding(0), fmt.Errorf("not a valid Encoding string")
}

func EncodingPtr(v Encoding) *Encoding { return &v }

func (p Encoding) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *Encoding) UnmarshalText(text []byte) error {
	q, err := EncodingFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *Encoding) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = Encoding(v)
	return nil
}

func (p *Encoding) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

//Supported compression algorithms.
//
//Codecs added in format version X.Y can be read by readers based on X.Y and later.
//Codec support may vary between readers based on the format version and
//libraries available at runtime.
//
//See Compression.md for a detailed specification of these algorithms.
type CompressionCodec int64

const (
	CompressionCodec_UNCOMPRESSED CompressionCodec = 0
	CompressionCodec_SNAPPY       CompressionCodec = 1
	CompressionCodec_GZIP         CompressionCodec = 2
	CompressionCodec_LZO          CompressionCodec = 3
	CompressionCodec_BROTLI       CompressionCodec = 4
	CompressionCodec_LZ4          CompressionCodec = 5
	CompressionCodec_ZSTD         CompressionCodec = 6
	CompressionCodec_LZ4_RAW      CompressionCodec = 7
)

func (p CompressionCodec) String() string {
	switch p {
	case CompressionCodec_UNCOMPRESSED:
		return "UNCOMPRESSED"
	case CompressionCodec_SNAPPY:
		return "SNAPPY"
	case CompressionCodec_GZIP:
		return "GZIP"
	case CompressionCodec_LZO:
		return "LZO"
	case CompressionCodec_BROTLI:
		return "BROTLI"
	case CompressionCodec_LZ4:
		return "LZ4"
	case CompressionCodec_ZSTD:
		return "ZSTD"
	case CompressionCodec_LZ4_RAW:
		return "LZ4_RAW"
	}
	return "<UNSET>"
}

func CompressionCodecFromString(s string) (CompressionCodec, error) {
	switch s {
	case "UNCOMPRESSED":
		return CompressionCodec_UNCOMPRESSED, nil
	case "SNAPPY":
		return CompressionCodec_SNAPPY, nil
	case "GZIP":
		return CompressionCodec_GZIP, nil
	case "LZO":
		return CompressionCodec_LZO, nil
	case "BROTLI":
		return CompressionCodec_BROTLI, nil
	case "LZ4":
		return CompressionCodec_LZ4, nil
	case "ZSTD":
		return CompressionCodec_ZSTD, nil
	case "LZ4_RAW":
		return CompressionCodec_LZ4_RAW, nil
	}
	return CompressionCodec(0), fmt.Errorf("not a valid CompressionCodec string")
}

func CompressionCodecPtr(v CompressionCodec) *CompressionCodec { return &v }

func (p CompressionCodec) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *CompressionCodec) UnmarshalText(text []byte) error {
	q, err := CompressionCodecFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *CompressionCodec) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = CompressionCodec(v)
	return nil
}

func (p *CompressionCodec) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PageType int64

const (
	PageType_DATA_PAGE       PageType = 0
	PageType_INDEX_PAGE      PageType = 1
	PageType_DICTIONARY_PAGE PageType = 2
	PageType_DATA_PAGE_V2    PageType = 3
)

func (p PageType) String() string {
	switch p {
	case PageType_DATA_PAGE:
		return "DATA_PAGE"
	case PageType_INDEX_PAGE:
		return "INDEX_PAGE"
	case PageType_DICTIONARY_PAGE:
		return "DICTIONARY_PAGE"
	case PageType_DATA_PAGE_V2:
		return "DATA_PAGE_V2"
	}
	return "<UNSET>"
}

func PageTypeFromString(s string) (PageType, error) {
	switch s {
	case "DATA_PAGE":
		return PageType_DATA_PAGE, nil
	case "INDEX_PAGE":
		return PageType_INDEX_PAGE, nil
	case "DICTIONARY_PAGE":
		return PageType_DICTIONARY_PAGE, nil
	case "DATA_PAGE_V2":
		return PageType_DATA_PAGE_V2, nil
	}
	return PageType(0), fmt.Errorf("not a valid PageType string")
}

func PageTypePtr(v PageType) *PageType { return &v }

func (p PageType) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *PageType) UnmarshalText(text []byte) error {
	q, err := PageTypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *PageType) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = PageType(v)
	return nil
}

func (p *PageType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

//Enum to annotate whether lists of min/max elements inside ColumnIndex
//are ordered and if so, in which direction.
type BoundaryOrder int64

const (
	BoundaryOrder_UNORDERED  BoundaryOrder = 0
	BoundaryOrder_ASCENDING  BoundaryOrder = 1
	BoundaryOrder_DESCENDING BoundaryOrder = 2
)

func (p BoundaryOrder) String() string {
	switch p {
	case BoundaryOrder_UNORDERED:
		return "UNORDERED"
	case BoundaryOrder_ASCENDING:
		return "ASCENDING"
	case BoundaryOrder_DESCENDING:
		return "DESCENDING"
	}
	return "<UNSET>"
}

func BoundaryOrderFromString(s string) (BoundaryOrder, error) {
	switch s {
	case "UNORDERED":
		return BoundaryOrder_UNORDERED, nil
	case "ASCENDING":
		return BoundaryOrder_ASCENDING, nil
	case "DESCENDING":
		return BoundaryOrder_DESCENDING, nil
	}
	return BoundaryOrder(0), fmt.Errorf("not a valid BoundaryOrder string")
}

func BoundaryOrderPtr(v BoundaryOrder) *BoundaryOrder { return &v }

func (p BoundaryOrder) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *BoundaryOrder) UnmarshalText(text []byte) error {
	q, err := BoundaryOrderFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *BoundaryOrder) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = BoundaryOrder(v)
	return nil
}

func (p *BoundaryOrder) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Statistics per row group and per page
// All fields are optional.
//
// Attributes:
//  - Max: DEPRECATED: min and max value of the column. Use min_value and max_value.
//
// Values are encoded using PLAIN encoding, except that variable-length byte
// arrays do not include a length prefix.
//
// These fields encode min and max values determined by signed comparison
// only. New files should use the correct order for a column's logical type
// and store the values in the min_value and max_value fields.
//
// To support older readers, these may be set when the column order is
// signed.
//  - Min
//  - NullCount: count of null value in the column
//  - DistinctCount: count of distinct values occurring
//  - MaxValue: Min and max values for the column, determined by its ColumnOrder.
//
// Values are encoded using PLAIN encoding, except that variable-length byte
// arrays do not include a length prefix.
//  - MinValue
type Statistics struct {
	Max           []byte `thrift:"max,1" db:"max" json:"max,omitempty"`
	Min           []byte `thrift:"min,2" db:"min" json:"min,omitempty"`
	NullCount     *int64 `thrift:"null_count,3" db:"null_count" json:"null_count,omitempty"`
	DistinctCount *int64 `thrift:"distinct_count,4" db:"distinct_count" json:"distinct_count,omitempty"`
	MaxValue      []byte `thrift:"max_value,5" db:"max_value" json:"max_value,omitempty"`
	MinValue      []byte `thrift:"min_value,6" db:"min_value" json:"min_value,omitempty"`
}

func NewStatistics() *Statistics {
	return &Statistics{}
}

var Statistics_Max_DEFAULT []byte

func (p *Statistics) GetMax() []byte {
	return p.Max
}

var Statistics_Min_DEFAULT []byte

func (p *Statistics) GetMin() []byte {
	return p.Min
}

var Statistics_NullCount_DEFAULT int64

func (p *Statistics) GetNullCount() int64 {
	if !p.IsSetNullCount() {
		return Statistics_NullCount_DEFAULT
	}
	return *p.NullCount
}

var Statistics_DistinctCount_DEFAULT int64

func (p *Statistics) GetDistinctCount() int64 {
	if !p.IsSetDistinctCount() {
		return Statistics_DistinctCount_DEFAULT
	}
	return *p.DistinctCount
}

var Statistics_MaxValue_DEFAULT []byte

func (p *Statistics) GetMaxValue() []byte {
	return p.MaxValue
}

var Statistics_MinValue_DEFAULT []byte

func (p *Statistics) GetMinValue() []byte {
	return p.MinValue
}
func (p *Statistics) IsSetMax() bool {
	return p.Max != nil
}

func (p *Statistics) IsSetMin() bool {
	return p.Min != nil
}

func (p *Statistics) IsSetNullCount() bool {
	return p.NullCount != nil
}

func (p *Statistics) IsSetDistinctCount() bool {
	return p.DistinctCount != nil
}

func (p *Statistics) IsSetMaxValue() bool {
	return p.MaxValue != nil
}

func (p *Statistics) IsSetMinValue() bool {
	return p.MinValue != nil
}

func (p *Statistics) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *Statistics) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Max = v
	}
	return nil
}

func (p *Statistics) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Min = v
	}
	return nil
}

func (p *Statistics) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NullCount = &v
	}
	return nil
}

func (p *Statistics) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.DistinctCount = &v
	}
	return nil
}

func (p *Statistics) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.MaxValue = v
	}
	return nil
}

func (p *Statistics) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.MinValue = v
	}
	return nil
}

func (p *Statistics) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "Statistics"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Statistics) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMax() {
		if err := oprot.WriteFieldBegin(ctx, "max", thrift.STRING, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:max: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.Max); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.max (1) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:max: ", p), err)
		}
	}
	return err
}

func (p *Statistics) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMin() {
		if err := oprot.WriteFieldBegin(ctx, "min", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:min: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.Min); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.min (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:min: ", p), err)
		}
	}
	return err
}

func (p *Statistics) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetNullCount() {
		if err := oprot.WriteFieldBegin(ctx, "null_count", thrift.I64, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:null_count: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.NullCount)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.null_count (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:null_count: ", p), err)
		}
	}
	return err
}

func (p *Statistics) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDistinctCount() {
		if err := oprot.WriteFieldBegin(ctx, "distinct_count", thrift.I64, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:distinct_count: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.DistinctCount)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.distinct_count (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:distinct_count: ", p), err)
		}
	}
	return err
}

func (p *Statistics) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMaxValue() {
		if err := oprot.WriteFieldBegin(ctx, "max_value", thrift.STRING, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:max_value: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.MaxValue); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.max_value (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:max_value: ", p), err)
		}
	}
	return err
}

func (p *Statistics) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMinValue() {
		if err := oprot.WriteFieldBegin(ctx, "min_value", thrift.STRING, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:min_value: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.MinValue); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.min_value (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:min_value: ", p), err)
		}
	}
	return err
}

func (p *Statistics) Equals(other *Statistics) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if bytes.Compare(p.Max, other.Max) != 0 {
		return false
	}
	if bytes.Compare(p.Min, other.Min) != 0 {
		return false
	}
	if p.NullCount != other.NullCount {
		if p.NullCount == nil || other.NullCount == nil {
			return false
		}
		if (*p.NullCount) != (*other.NullCount) {
			return false
		}
	}
	if p.DistinctCount != other.DistinctCount {
		if p.DistinctCount == nil || other.DistinctCount == nil {
			return false
		}
		if (*p.DistinctCount) != (*other.DistinctCount) {
			return false
		}
	}
	if bytes.Compare(p.MaxValue, other.MaxValue) != 0 {
		return false
	}
	if bytes.Compare(p.MinValue, other.MinValue) != 0 {
		return false
	}
	return true
}

func (p *Statistics) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Statistics(%+v)", *p)
}

// Empty structs to use as logical type annotations
type StringType struct {
}

func NewStringType() *StringType {
	return &StringType{}
}

func (p *StringType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *StringType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "StringType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *StringType) Equals(other *StringType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *StringType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("StringType(%+v)", *p)
}

type UUIDType struct {
}

func NewUUIDType() *UUIDType {
	return &UUIDType{}
}

func (p *UUIDType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *UUIDType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "UUIDType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *UUIDType) Equals(other *UUIDType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *UUIDType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UUIDType(%+v)", *p)
}

type MapType struct {
}

func NewMapType() *MapType {
	return &MapType{}
}

func (p *MapType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *MapType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "MapType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *MapType) Equals(other *MapType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *MapType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MapType(%+v)", *p)
}

type ListType struct {
}

func NewListType() *ListType {
	return &ListType{}
}

func (p *ListType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ListType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ListType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ListType) Equals(other *ListType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *ListType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ListType(%+v)", *p)
}

type EnumType struct {
}

func NewEnumType() *EnumType {
	return &EnumType{}
}

func (p *EnumType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *EnumType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "EnumType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *EnumType) Equals(other *EnumType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *EnumType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("EnumType(%+v)", *p)
}

type DateType struct {
}

func NewDateType() *DateType {
	return &DateType{}
}

func (p *DateType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *DateType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "DateType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DateType) Equals(other *DateType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *DateType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DateType(%+v)", *p)
}

// Logical type to annotate a column that is always null.
//
// Sometimes when discovering the schema of existing data, values are always
// null and the physical type can't be determined. This annotation signals
// the case where the physical type was guessed from all null values.
type NullType struct {
}

func NewNullType() *NullType {
	return &NullType{}
}

func (p *NullType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NullType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "NullType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NullType) Equals(other *NullType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *NullType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NullType(%+v)", *p)
}

// Decimal logical type annotation
//
// To maintain forward-compatibility in v1, implementations using this logical
// type must also set scale and precision on the annotated SchemaElement.
//
// Allowed for physical types: INT32, INT64, FIXED, and BINARY
//
// Attributes:
//  - Scale
//  - Precision
type DecimalType struct {
	Scale     int32 `thrift:"scale,1,required" db:"scale" json:"scale"`
	Precision int32 `thrift:"precision,2,required" db:"precision" json:"precision"`
}

func NewDecimalType() *DecimalType {
	return &DecimalType{}
}

func (p *DecimalType) GetScale() int32 {
	return p.Scale
}

func (p *DecimalType) GetPrecision() int32 {
	return p.Precision
}
func (p *DecimalType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetScale bool = false
	var issetPrecision bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetScale = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetPrecision = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetScale {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Scale is not set"))
	}
	if !issetPrecision {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Precision is not set"))
	}
	return nil
}

func (p *DecimalType) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Scale = v
	}
	return nil
}

func (p *DecimalType) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Precision = v
	}
	return nil
}

func (p *DecimalType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "DecimalType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DecimalType) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "scale", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:scale: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Scale)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.scale (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:scale: ", p), err)
	}
	return err
}

func (p *DecimalType) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "precision", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:precision: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Precision)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.precision (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:precision: ", p), err)
	}
	return err
}

func (p *DecimalType) Equals(other *DecimalType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Scale != other.Scale {
		return false
	}
	if p.Precision != other.Precision {
		return false
	}
	return true
}

func (p *DecimalType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DecimalType(%+v)", *p)
}

// Time units for logical types
type MilliSeconds struct {
}

func NewMilliSeconds() *MilliSeconds {
	return &MilliSeconds{}
}

func (p *MilliSeconds) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *MilliSeconds) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "MilliSeconds"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *MilliSeconds) Equals(other *MilliSeconds) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *MilliSeconds) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MilliSeconds(%+v)", *p)
}

type MicroSeconds struct {
}

func NewMicroSeconds() *MicroSeconds {
	return &MicroSeconds{}
}

func (p *MicroSeconds) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *MicroSeconds) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "MicroSeconds"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *MicroSeconds) Equals(other *MicroSeconds) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *MicroSeconds) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MicroSeconds(%+v)", *p)
}

type NanoSeconds struct {
}

func NewNanoSeconds() *NanoSeconds {
	return &NanoSeconds{}
}

func (p *NanoSeconds) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NanoSeconds) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "NanoSeconds"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NanoSeconds) Equals(other *NanoSeconds) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *NanoSeconds) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NanoSeconds(%+v)", *p)
}

// Attributes:
//  - MILLIS
//  - MICROS
//  - NANOS
type TimeUnit struct {
	MILLIS *MilliSeconds `thrift:"MILLIS,1" db:"MILLIS" json:"MILLIS,omitempty"`
	MICROS *MicroSeconds `thrift:"MICROS,2" db:"MICROS" json:"MICROS,omitempty"`
	NANOS  *NanoSeconds  `thrift:"NANOS,3" db:"NANOS" json:"NANOS,omitempty"`
}

func NewTimeUnit() *TimeUnit {
	return &TimeUnit{}
}

var TimeUnit_MILLIS_DEFAULT *MilliSeconds

func (p *TimeUnit) GetMILLIS() *MilliSeconds {
	if !p.IsSetMILLIS() {
		return TimeUnit_MILLIS_DEFAULT
	}
	return p.MILLIS
}

var TimeUnit_MICROS_DEFAULT *MicroSeconds

func (p *TimeUnit) GetMICROS() *MicroSeconds {
	if !p.IsSetMICROS() {
		return TimeUnit_MICROS_DEFAULT
	}
	return p.MICROS
}

var TimeUnit_NANOS_DEFAULT *NanoSeconds

func (p *TimeUnit) GetNANOS() *NanoSeconds {
	if !p.IsSetNANOS() {
		return TimeUnit_NANOS_DEFAULT
	}
	return p.NANOS
}
func (p *TimeUnit) CountSetFieldsTimeUnit() int {
	count := 0
	if p.IsSetMILLIS() {
		count++
	}
	if p.IsSetMICROS() {
		count++
	}
	if p.IsSetNANOS() {
		count++
	}
	return count

}

func (p *TimeUnit) IsSetMILLIS() bool {
	return p.MILLIS != nil
}

func (p *TimeUnit) IsSetMICROS() bool {
	return p.MICROS != nil
}

func (p *TimeUnit) IsSetNANOS() bool {
	return p.NANOS != nil
}

func (p *TimeUnit) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TimeUnit) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.MILLIS = &MilliSeconds{}
	if err := p.MILLIS.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.MILLIS), err)
	}
	return nil
}

func (p *TimeUnit) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.MICROS = &MicroSeconds{}
	if err := p.MICROS.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.MICROS), err)
	}
	return nil
}

func (p *TimeUnit) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	p.NANOS = &NanoSeconds{}
	if err := p.NANOS.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NANOS), err)
	}
	return nil
}

func (p *TimeUnit) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsTimeUnit(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "TimeUnit"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TimeUnit) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMILLIS() {
		if err := oprot.WriteFieldBegin(ctx, "MILLIS", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:MILLIS: ", p), err)
		}
		if err := p.MILLIS.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.MILLIS), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:MILLIS: ", p), err)
		}
	}
	return err
}

func (p *TimeUnit) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMICROS() {
		if err := oprot.WriteFieldBegin(ctx, "MICROS", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:MICROS: ", p), err)
		}
		if err := p.MICROS.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.MICROS), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:MICROS: ", p), err)
		}
	}
	return err
}

func (p *TimeUnit) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetNANOS() {
		if err := oprot.WriteFieldBegin(ctx, "NANOS", thrift.STRUCT, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:NANOS: ", p), err)
		}
		if err := p.NANOS.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NANOS), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:NANOS: ", p), err)
		}
	}
	return err
}

func (p *TimeUnit) Equals(other *TimeUnit) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.MILLIS.Equals(other.MILLIS) {
		return false
	}
	if !p.MICROS.Equals(other.MICROS) {
		return false
	}
	if !p.NANOS.Equals(other.NANOS) {
		return false
	}
	return true
}

func (p *TimeUnit) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TimeUnit(%+v)", *p)
}

// Timestamp logical type annotation
//
// Allowed for physical types: INT64
//
// Attributes:
//  - IsAdjustedToUTC
//  - Unit
type TimestampType struct {
	IsAdjustedToUTC bool      `thrift:"isAdjustedToUTC,1,required" db:"isAdjustedToUTC" json:"isAdjustedToUTC"`
	Unit            *TimeUnit `thrift:"unit,2,required" db:"unit" json:"unit"`
}

func NewTimestampType() *TimestampType {
	return &TimestampType{}
}

func (p *TimestampType) GetIsAdjustedToUTC() bool {
	return p.IsAdjustedToUTC
}

var TimestampType_Unit_DEFAULT *TimeUnit

func (p *TimestampType) GetUnit() *TimeUnit {
	if !p.IsSetUnit() {
		return TimestampType_Unit_DEFAULT
	}
	return p.Unit
}
func (p *TimestampType) IsSetUnit() bool {
	return p.Unit != nil
}

func (p *TimestampType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetIsAdjustedToUTC bool = false
	var issetUnit bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetIsAdjustedToUTC = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetUnit = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetIsAdjustedToUTC {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAdjustedToUTC is not set"))
	}
	if !issetUnit {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Unit is not set"))
	}
	return nil
}

func (p *TimestampType) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.IsAdjustedToUTC = v
	}
	return nil
}

func (p *TimestampType) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.Unit = &TimeUnit{}
	if err := p.Unit.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Unit), err)
	}
	return nil
}

func (p *TimestampType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TimestampType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TimestampType) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "isAdjustedToUTC", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:isAdjustedToUTC: ", p), err)
	}
	if err := oprot.WriteBool(ctx, bool(p.IsAdjustedToUTC)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.isAdjustedToUTC (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:isAdjustedToUTC: ", p), err)
	}
	return err
}

func (p *TimestampType) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "unit", thrift.STRUCT, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:unit: ", p), err)
	}
	if err := p.Unit.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Unit), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:unit: ", p), err)
	}
	return err
}

func (p *TimestampType) Equals(other *TimestampType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.IsAdjustedToUTC != other.IsAdjustedToUTC {
		return false
	}
	if !p.Unit.Equals(other.Unit) {
		return false
	}
	return true
}

func (p *TimestampType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TimestampType(%+v)", *p)
}

// Time logical type annotation
//
// Allowed for physical types: INT32 (millis), INT64 (micros, nanos)
//
// Attributes:
//  - IsAdjustedToUTC
//  - Unit
type TimeType struct {
	IsAdjustedToUTC bool      `thrift:"isAdjustedToUTC,1,required" db:"isAdjustedToUTC" json:"isAdjustedToUTC"`
	Unit            *TimeUnit `thrift:"unit,2,required" db:"unit" json:"unit"`
}

func NewTimeType() *TimeType {
	return &TimeType{}
}

func (p *TimeType) GetIsAdjustedToUTC() bool {
	return p.IsAdjustedToUTC
}

var TimeType_Unit_DEFAULT *TimeUnit

func (p *TimeType) GetUnit() *TimeUnit {
	if !p.IsSetUnit() {
		return TimeType_Unit_DEFAULT
	}
	return p.Unit
}
func (p *TimeType) IsSetUnit() bool {
	return p.Unit != nil
}

func (p *TimeType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetIsAdjustedToUTC bool = false
	var issetUnit bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetIsAdjustedToUTC = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetUnit = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetIsAdjustedToUTC {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAdjustedToUTC is not set"))
	}
	if !issetUnit {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Unit is not set"))
	}
	return nil
}

func (p *TimeType) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.IsAdjustedToUTC = v
	}
	return nil
}

func (p *TimeType) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.Unit = &TimeUnit{}
	if err := p.Unit.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Unit), err)
	}
	return nil
}

func (p *TimeType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TimeType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TimeType) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "isAdjustedToUTC", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:isAdjustedToUTC: ", p), err)
	}
	if err := oprot.WriteBool(ctx, bool(p.IsAdjustedToUTC)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.isAdjustedToUTC (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:isAdjustedToUTC: ", p), err)
	}
	return err
}

func (p *TimeType) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "unit", thrift.STRUCT, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:unit: ", p), err)
	}
	if err := p.Unit.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Unit), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:unit: ", p), err)
	}
	return err
}

func (p *TimeType) Equals(other *TimeType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.IsAdjustedToUTC != other.IsAdjustedToUTC {
		return false
	}
	if !p.Unit.Equals(other.Unit) {
		return false
	}
	return true
}

func (p *TimeType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TimeType(%+v)", *p)
}

// Integer logical type annotation
//
// bitWidth must be 8, 16, 32, or 64.
//
// Allowed for physical types: INT32, INT64
//
// Attributes:
//  - BitWidth
//  - IsSigned
type IntType struct {
	BitWidth int8 `thrift:"bitWidth,1,required" db:"bitWidth" json:"bitWidth"`
	IsSigned bool `thrift:"isSigned,2,required" db:"isSigned" json:"isSigned"`
}

func NewIntType() *IntType {
	return &IntType{}
}

func (p *IntType) GetBitWidth() int8 {
	return p.BitWidth
}

func (p *IntType) GetIsSigned() bool {
	return p.IsSigned
}
func (p *IntType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetBitWidth bool = false
	var issetIsSigned bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BYTE {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetBitWidth = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetIsSigned = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetBitWidth {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field BitWidth is not set"))
	}
	if !issetIsSigned {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsSigned is not set"))
	}
	return nil
}

func (p *IntType) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadByte(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := int8(v)
		p.BitWidth = temp
	}
	return nil
}

func (p *IntType) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.IsSigned = v
	}
	return nil
}

func (p *IntType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "IntType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *IntType) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "bitWidth", thrift.BYTE, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:bitWidth: ", p), err)
	}
	if err := oprot.WriteByte(ctx, int8(p.BitWidth)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.bitWidth (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:bitWidth: ", p), err)
	}
	return err
}

func (p *IntType) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "isSigned", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:isSigned: ", p), err)
	}
	if err := oprot.WriteBool(ctx, bool(p.IsSigned)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.isSigned (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:isSigned: ", p), err)
	}
	return err
}

func (p *IntType) Equals(other *IntType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.BitWidth != other.BitWidth {
		return false
	}
	if p.IsSigned != other.IsSigned {
		return false
	}
	return true
}

func (p *IntType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("IntType(%+v)", *p)
}

// Embedded JSON logical type annotation
//
// Allowed for physical types: BINARY
type JsonType struct {
}

func NewJsonType() *JsonType {
	return &JsonType{}
}

func (p *JsonType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *JsonType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "JsonType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *JsonType) Equals(other *JsonType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *JsonType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("JsonType(%+v)", *p)
}

// Embedded BSON logical type annotation
//
// Allowed for physical types: BINARY
type BsonType struct {
}

func NewBsonType() *BsonType {
	return &BsonType{}
}

func (p *BsonType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *BsonType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "BsonType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *BsonType) Equals(other *BsonType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *BsonType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BsonType(%+v)", *p)
}

// LogicalType annotations to replace ConvertedType.
//
// To maintain compatibility, implementations using LogicalType for a
// SchemaElement must also set the corresponding ConvertedType (if any)
// from the following table.
//
// Attributes:
//  - STRING
//  - MAP
//  - LIST
//  - ENUM
//  - DECIMAL
//  - DATE
//  - TIME
//  - TIMESTAMP
//  - INTEGER
//  - UNKNOWN
//  - JSON
//  - BSON
//  - UUID
type LogicalType struct {
	STRING    *StringType    `thrift:"STRING,1" db:"STRING" json:"STRING,omitempty"`
	MAP       *MapType       `thrift:"MAP,2" db:"MAP" json:"MAP,omitempty"`
	LIST      *ListType      `thrift:"LIST,3" db:"LIST" json:"LIST,omitempty"`
	ENUM      *EnumType      `thrift:"ENUM,4" db:"ENUM" json:"ENUM,omitempty"`
	DECIMAL   *DecimalType   `thrift:"DECIMAL,5" db:"DECIMAL" json:"DECIMAL,omitempty"`
	DATE      *DateType      `thrift:"DATE,6" db:"DATE" json:"DATE,omitempty"`
	TIME      *TimeType      `thrift:"TIME,7" db:"TIME" json:"TIME,omitempty"`
	TIMESTAMP *TimestampType `thrift:"TIMESTAMP,8" db:"TIMESTAMP" json:"TIMESTAMP,omitempty"`
	// unused field # 9
	INTEGER *IntType  `thrift:"INTEGER,10" db:"INTEGER" json:"INTEGER,omitempty"`
	UNKNOWN *NullType `thrift:"UNKNOWN,11" db:"UNKNOWN" json:"UNKNOWN,omitempty"`
	JSON    *JsonType `thrift:"JSON,12" db:"JSON" json:"JSON,omitempty"`
	BSON    *BsonType `thrift:"BSON,13" db:"BSON" json:"BSON,omitempty"`
	UUID    *UUIDType `thrift:"UUID,14" db:"UUID" json:"UUID,omitempty"`
}

func NewLogicalType() *LogicalType {
	return &LogicalType{}
}

var LogicalType_STRING_DEFAULT *StringType

func (p *LogicalType) GetSTRING() *StringType {
	if !p.IsSetSTRING() {
		return LogicalType_STRING_DEFAULT
	}
	return p.STRING
}

var LogicalType_MAP_DEFAULT *MapType

func (p *LogicalType) GetMAP() *MapType {
	if !p.IsSetMAP() {
		return LogicalType_MAP_DEFAULT
	}
	return p.MAP
}

var LogicalType_LIST_DEFAULT *ListType

func (p *LogicalType) GetLIST() *ListType {
	if !p.IsSetLIST() {
		return LogicalType_LIST_DEFAULT
	}
	return p.LIST
}

var LogicalType_ENUM_DEFAULT *EnumType

func (p *LogicalType) GetENUM() *EnumType {
	if !p.IsSetENUM() {
		return LogicalType_ENUM_DEFAULT
	}
	return p.ENUM
}

var LogicalType_DECIMAL_DEFAULT *DecimalType

func (p *LogicalType) GetDECIMAL() *DecimalType {
	if !p.IsSetDECIMAL() {
		return LogicalType_DECIMAL_DEFAULT
	}
	return p.DECIMAL
}

var LogicalType_DATE_DEFAULT *DateType

func (p *LogicalType) GetDATE() *DateType {
	if !p.IsSetDATE() {
		return LogicalType_DATE_DEFAULT
	}
	return p.DATE
}

var LogicalType_TIME_DEFAULT *TimeType

func (p *LogicalType) GetTIME() *TimeType {
	if !p.IsSetTIME() {
		return LogicalType_TIME_DEFAULT
	}
	return p.TIME
}

var LogicalType_TIMESTAMP_DEFAULT *TimestampType

func (p *LogicalType) GetTIMESTAMP() *TimestampType {
	if !p.IsSetTIMESTAMP() {
		return LogicalType_TIMESTAMP_DEFAULT
	}
	return p.TIMESTAMP
}

var LogicalType_INTEGER_DEFAULT *IntType

func (p *LogicalType) GetINTEGER() *IntType {
	if !p.IsSetINTEGER() {
		return LogicalType_INTEGER_DEFAULT
	}
	return p.INTEGER
}

var LogicalType_UNKNOWN_DEFAULT *NullType

func (p *LogicalType) GetUNKNOWN() *NullType {
	if !p.IsSetUNKNOWN() {
		return LogicalType_UNKNOWN_DEFAULT
	}
	return p.UNKNOWN
}

var LogicalType_JSON_DEFAULT *JsonType

func (p *LogicalType) GetJSON() *JsonType {
	if !p.IsSetJSON() {
		return LogicalType_JSON_DEFAULT
	}
	return p.JSON
}

var LogicalType_BSON_DEFAULT *BsonType

func (p *LogicalType) GetBSON() *BsonType {
	if !p.IsSetBSON() {
		return LogicalType_BSON_DEFAULT
	}
	return p.BSON
}

var LogicalType_UUID_DEFAULT *UUIDType

func (p *LogicalType) GetUUID() *UUIDType {
	if !p.IsSetUUID() {
		return LogicalType_UUID_DEFAULT
	}
	return p.UUID
}
func (p *LogicalType) CountSetFieldsLogicalType() int {
	count := 0
	if p.IsSetSTRING() {
		count++
	}
	if p.IsSetMAP() {
		count++
	}
	if p.IsSetLIST() {
		count++
	}
	if p.IsSetENUM() {
		count++
	}
	if p.IsSetDECIMAL() {
		count++
	}
	if p.IsSetDATE() {
		count++
	}
	if p.IsSetTIME() {
		count++
	}
	if p.IsSetTIMESTAMP() {
		count++
	}
	if p.IsSetINTEGER() {
		count++
	}
	if p.IsSetUNKNOWN() {
		count++
	}
	if p.IsSetJSON() {
		count++
	}
	if p.IsSetBSON() {
		count++
	}
	if p.IsSetUUID() {
		count++
	}
	return count

}

func (p *LogicalType) IsSetSTRING() bool {
	return p.STRING != nil
}

func (p *LogicalType) IsSetMAP() bool {
	return p.MAP != nil
}

func (p *LogicalType) IsSetLIST() bool {
	return p.LIST != nil
}

func (p *LogicalType) IsSetENUM() bool {
	return p.ENUM != nil
}

func (p *LogicalType) IsSetDECIMAL() bool {
	return p.DECIMAL != nil
}

func (p *LogicalType) IsSetDATE() bool {
	return p.DATE != nil
}

func (p *LogicalType) IsSetTIME() bool {
	return p.TIME != nil
}

func (p *LogicalType) IsSetTIMESTAMP() bool {
	return p.TIMESTAMP != nil
}

func (p *LogicalType) IsSetINTEGER() bool {
	return p.INTEGER != nil
}

func (p *LogicalType) IsSetUNKNOWN() bool {
	return p.UNKNOWN != nil
}

func (p *LogicalType) IsSetJSON() bool {
	return p.JSON != nil
}

func (p *LogicalType) IsSetBSON() bool {
	return p.BSON != nil
}

func (p *LogicalType) IsSetUUID() bool {
	return p.UUID != nil
}

func (p *LogicalType) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 10:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField10(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 11:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField11(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 12:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField12(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 13:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField13(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 14:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField14(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *LogicalType) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.STRING = &StringType{}
	if err := p.STRING.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.STRING), err)
	}
	return nil
}

func (p *LogicalType) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.MAP = &MapType{}
	if err := p.MAP.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.MAP), err)
	}
	return nil
}

func (p *LogicalType) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	p.LIST = &ListType{}
	if err := p.LIST.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.LIST), err)
	}
	return nil
}

func (p *LogicalType) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	p.ENUM = &EnumType{}
	if err := p.ENUM.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.ENUM), err)
	}
	return nil
}

func (p *LogicalType) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	p.DECIMAL = &DecimalType{}
	if err := p.DECIMAL.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.DECIMAL), err)
	}
	return nil
}

func (p *LogicalType) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	p.DATE = &DateType{}
	if err := p.DATE.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.DATE), err)
	}
	return nil
}

func (p *LogicalType) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	p.TIME = &TimeType{}
	if err := p.TIME.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.TIME), err)
	}
	return nil
}

func (p *LogicalType) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	p.TIMESTAMP = &TimestampType{}
	if err := p.TIMESTAMP.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.TIMESTAMP), err)
	}
	return nil
}

func (p *LogicalType) ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
	p.INTEGER = &IntType{}
	if err := p.INTEGER.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.INTEGER), err)
	}
	return nil
}

func (p *LogicalType) ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
	p.UNKNOWN = &NullType{}
	if err := p.UNKNOWN.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.UNKNOWN), err)
	}
	return nil
}

func (p *LogicalType) ReadField12(ctx context.Context, iprot thrift.TProtocol) error {
	p.JSON = &JsonType{}
	if err := p.JSON.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.JSON), err)
	}
	return nil
}

func (p *LogicalType) ReadField13(ctx context.Context, iprot thrift.TProtocol) error {
	p.BSON = &BsonType{}
	if err := p.BSON.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.BSON), err)
	}
	return nil
}

func (p *LogicalType) ReadField14(ctx context.Context, iprot thrift.TProtocol) error {
	p.UUID = &UUIDType{}
	if err := p.UUID.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.UUID), err)
	}
	return nil
}

func (p *LogicalType) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsLogicalType(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "LogicalType"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField10(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField11(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField12(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField13(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField14(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *LogicalType) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSTRING() {
		if err := oprot.WriteFieldBegin(ctx, "STRING", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:STRING: ", p), err)
		}
		if err := p.STRING.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.STRING), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:STRING: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMAP() {
		if err := oprot.WriteFieldBegin(ctx, "MAP", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:MAP: ", p), err)
		}
		if err := p.MAP.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.MAP), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:MAP: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetLIST() {
		if err := oprot.WriteFieldBegin(ctx, "LIST", thrift.STRUCT, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:LIST: ", p), err)
		}
		if err := p.LIST.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.LIST), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:LIST: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetENUM() {
		if err := oprot.WriteFieldBegin(ctx, "ENUM", thrift.STRUCT, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:ENUM: ", p), err)
		}
		if err := p.ENUM.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.ENUM), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:ENUM: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDECIMAL() {
		if err := oprot.WriteFieldBegin(ctx, "DECIMAL", thrift.STRUCT, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:DECIMAL: ", p), err)
		}
		if err := p.DECIMAL.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.DECIMAL), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:DECIMAL: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDATE() {
		if err := oprot.WriteFieldBegin(ctx, "DATE", thrift.STRUCT, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:DATE: ", p), err)
		}
		if err := p.DATE.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.DATE), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:DATE: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTIME() {
		if err := oprot.WriteFieldBegin(ctx, "TIME", thrift.STRUCT, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:TIME: ", p), err)
		}
		if err := p.TIME.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.TIME), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:TIME: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTIMESTAMP() {
		if err := oprot.WriteFieldBegin(ctx, "TIMESTAMP", thrift.STRUCT, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:TIMESTAMP: ", p), err)
		}
		if err := p.TIMESTAMP.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.TIMESTAMP), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:TIMESTAMP: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetINTEGER() {
		if err := oprot.WriteFieldBegin(ctx, "INTEGER", thrift.STRUCT, 10); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:INTEGER: ", p), err)
		}
		if err := p.INTEGER.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.INTEGER), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 10:INTEGER: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetUNKNOWN() {
		if err := oprot.WriteFieldBegin(ctx, "UNKNOWN", thrift.STRUCT, 11); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:UNKNOWN: ", p), err)
		}
		if err := p.UNKNOWN.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.UNKNOWN), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 11:UNKNOWN: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField12(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetJSON() {
		if err := oprot.WriteFieldBegin(ctx, "JSON", thrift.STRUCT, 12); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 12:JSON: ", p), err)
		}
		if err := p.JSON.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.JSON), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 12:JSON: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField13(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetBSON() {
		if err := oprot.WriteFieldBegin(ctx, "BSON", thrift.STRUCT, 13); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 13:BSON: ", p), err)
		}
		if err := p.BSON.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.BSON), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 13:BSON: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) writeField14(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetUUID() {
		if err := oprot.WriteFieldBegin(ctx, "UUID", thrift.STRUCT, 14); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 14:UUID: ", p), err)
		}
		if err := p.UUID.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.UUID), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 14:UUID: ", p), err)
		}
	}
	return err
}

func (p *LogicalType) Equals(other *LogicalType) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.STRING.Equals(other.STRING) {
		return false
	}
	if !p.MAP.Equals(other.MAP) {
		return false
	}
	if !p.LIST.Equals(other.LIST) {
		return false
	}
	if !p.ENUM.Equals(other.ENUM) {
		return false
	}
	if !p.DECIMAL.Equals(other.DECIMAL) {
		return false
	}
	if !p.DATE.Equals(other.DATE) {
		return false
	}
	if !p.TIME.Equals(other.TIME) {
		return false
	}
	if !p.TIMESTAMP.Equals(other.TIMESTAMP) {
		return false
	}
	if !p.INTEGER.Equals(other.INTEGER) {
		return false
	}
	if !p.UNKNOWN.Equals(other.UNKNOWN) {
		return false
	}
	if !p.JSON.Equals(other.JSON) {
		return false
	}
	if !p.BSON.Equals(other.BSON) {
		return false
	}
	if !p.UUID.Equals(other.UUID) {
		return false
	}
	return true
}

func (p *LogicalType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("LogicalType(%+v)", *p)
}

// Represents a element inside a schema definition.
//  - if it is a group (inner node) then type is undefined and num_children is defined
//  - if it is a primitive type (leaf) then type is defined and num_children is undefined
// the nodes are listed in depth first traversal order.
//
// Attributes:
//  - Type: Data type for this field. Not set if the current element is a non-leaf node
//  - TypeLength: If type is FIXED_LEN_BYTE_ARRAY, this is the byte length of the vales.
// Otherwise, if specified, this is the maximum bit length to store any of the values.
// (e.g. a low cardinality INT col could have this set to 3).  Note that this is
// in the schema, and therefore fixed for the entire file.
//  - RepetitionType: repetition of the field. The root of the schema does not have a repetition_type.
// All other nodes must have one
//  - Name: Name of the field in the schema
//  - NumChildren: Nested fields.  Since thrift does not support nested fields,
// the nesting is flattened to a single list by a depth-first traversal.
// The children count is used to construct the nested relationship.
// This field is not set when the element is a primitive type
//  - ConvertedType: DEPRECATED: When the schema is the result of a conversion from another model.
// Used to record the original type to help with cross conversion.
//
// This is superseded by logicalType.
//  - Scale: DEPRECATED: Used when this column contains decimal data.
// See the DECIMAL converted type for more details.
//
// This is superseded by using the DecimalType annotation in logicalType.
//  - Precision
//  - FieldID: When the original schema supports field ids, this will save the
// original field id in the parquet schema
//  - LogicalType: The logical type of this SchemaElement
//
// LogicalType replaces ConvertedType, but ConvertedType is still required
// for some logical types to ensure forward-compatibility in format v1.
type SchemaElement struct {
	Type           *Type                `thrift:"type,1" db:"type" json:"type,omitempty"`
	TypeLength     *int32               `thrift:"type_length,2" db:"type_length" json:"type_length,omitempty"`
	RepetitionType *FieldRepetitionType `thrift:"repetition_type,3" db:"repetition_type" json:"repetition_type,omitempty"`
	Name           string               `thrift:"name,4,required" db:"name" json:"name"`
	NumChildren    *int32               `thrift:"num_children,5" db:"num_children" json:"num_children,omitempty"`
	ConvertedType  *ConvertedType       `thrift:"converted_type,6" db:"converted_type" json:"converted_type,omitempty"`
	Scale          *int32               `thrift:"scale,7" db:"scale" json:"scale,omitempty"`
	Precision      *int32               `thrift:"precision,8" db:"precision" json:"precision,omitempty"`
	FieldID        *int32               `thrift:"field_id,9" db:"field_id" json:"field_id,omitempty"`
	LogicalType    *LogicalType         `thrift:"logicalType,10" db:"logicalType" json:"logicalType,omitempty"`
}

func NewSchemaElement() *SchemaElement {
	return &SchemaElement{}
}

var SchemaElement_Type_DEFAULT Type

func (p *SchemaElement) GetType() Type {
	if !p.IsSetType() {
		return SchemaElement_Type_DEFAULT
	}
	return *p.Type
}

var SchemaElement_TypeLength_DEFAULT int32

func (p *SchemaElement) GetTypeLength() int32 {
	if !p.IsSetTypeLength() {
		return SchemaElement_TypeLength_DEFAULT
	}
	return *p.TypeLength
}

var SchemaElement_RepetitionType_DEFAULT FieldRepetitionType

func (p *SchemaElement) GetRepetitionType() FieldRepetitionType {
	if !p.IsSetRepetitionType() {
		return SchemaElement_RepetitionType_DEFAULT
	}
	return *p.RepetitionType
}

func (p *SchemaElement) GetName() string {
	return p.Name
}

var SchemaElement_NumChildren_DEFAULT int32

func (p *SchemaElement) GetNumChildren() int32 {
	if !p.IsSetNumChildren() {
		return SchemaElement_NumChildren_DEFAULT
	}
	return *p.NumChildren
}

var SchemaElement_ConvertedType_DEFAULT ConvertedType

func (p *SchemaElement) GetConvertedType() ConvertedType {
	if !p.IsSetConvertedType() {
		return SchemaElement_ConvertedType_DEFAULT
	}
	return *p.ConvertedType
}

var SchemaElement_Scale_DEFAULT int32

func (p *SchemaElement) GetScale() int32 {
	if !p.IsSetScale() {
		return SchemaElement_Scale_DEFAULT
	}
	return *p.Scale
}

var SchemaElement_Precision_DEFAULT int32

func (p *SchemaElement) GetPrecision() int32 {
	if !p.IsSetPrecision() {
		return SchemaElement_Precision_DEFAULT
	}
	return *p.Precision
}

var SchemaElement_FieldID_DEFAULT int32

func (p *SchemaElement) GetFieldID() int32 {
	if !p.IsSetFieldID() {
		return SchemaElement_FieldID_DEFAULT
	}
	return *p.FieldID
}

var SchemaElement_LogicalType_DEFAULT *LogicalType

func (p *SchemaElement) GetLogicalType() *LogicalType {
	if !p.IsSetLogicalType() {
		return SchemaElement_LogicalType_DEFAULT
	}
	return p.LogicalType
}
func (p *SchemaElement) IsSetType() bool {
	return p.Type != nil
}

func (p *SchemaElement) IsSetTypeLength() bool {
	return p.TypeLength != nil
}

func (p *SchemaElement) IsSetRepetitionType() bool {
	return p.RepetitionType != nil
}

func (p *SchemaElement) IsSetNumChildren() bool {
	return p.NumChildren != nil
}

func (p *SchemaElement) IsSetConvertedType() bool {
	return p.ConvertedType != nil
}

func (p *SchemaElement) IsSetScale() bool {
	return p.Scale != nil
}

func (p *SchemaElement) IsSetPrecision() bool {
	return p.Precision != nil
}

func (p *SchemaElement) IsSetFieldID() bool {
	return p.FieldID != nil
}

func (p *SchemaElement) IsSetLogicalType() bool {
	return p.LogicalType != nil
}

func (p *SchemaElement) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetName bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetName = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 10:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField10(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetName {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"))
	}
	return nil
}

func (p *SchemaElement) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := Type(v)
		p.Type = &temp
	}
	return nil
}

func (p *SchemaElement) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.TypeLength = &v
	}
	return nil
}

func (p *SchemaElement) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		temp := FieldRepetitionType(v)
		p.RepetitionType = &temp
	}
	return nil
}

func (p *SchemaElement) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Name = v
	}
	return nil
}

func (p *SchemaElement) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.NumChildren = &v
	}
	return nil
}

func (p *SchemaElement) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		temp := ConvertedType(v)
		p.ConvertedType = &temp
	}
	return nil
}

func (p *SchemaElement) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.Scale = &v
	}
	return nil
}

func (p *SchemaElement) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 8: ", err)
	} else {
		p.Precision = &v
	}
	return nil
}

func (p *SchemaElement) ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 9: ", err)
	} else {
		p.FieldID = &v
	}
	return nil
}

func (p *SchemaElement) ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
	p.LogicalType = &LogicalType{}
	if err := p.LogicalType.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.LogicalType), err)
	}
	return nil
}

func (p *SchemaElement) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "SchemaElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField9(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField10(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *SchemaElement) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetType() {
		if err := oprot.WriteFieldBegin(ctx, "type", thrift.I32, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:type: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.Type)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.type (1) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:type: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTypeLength() {
		if err := oprot.WriteFieldBegin(ctx, "type_length", thrift.I32, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:type_length: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.TypeLength)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.type_length (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:type_length: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetRepetitionType() {
		if err := oprot.WriteFieldBegin(ctx, "repetition_type", thrift.I32, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:repetition_type: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.RepetitionType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.repetition_type (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:repetition_type: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:name: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.name (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:name: ", p), err)
	}
	return err
}

func (p *SchemaElement) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetNumChildren() {
		if err := oprot.WriteFieldBegin(ctx, "num_children", thrift.I32, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:num_children: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.NumChildren)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.num_children (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:num_children: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetConvertedType() {
		if err := oprot.WriteFieldBegin(ctx, "converted_type", thrift.I32, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:converted_type: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.ConvertedType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.converted_type (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:converted_type: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetScale() {
		if err := oprot.WriteFieldBegin(ctx, "scale", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:scale: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.Scale)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.scale (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:scale: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetPrecision() {
		if err := oprot.WriteFieldBegin(ctx, "precision", thrift.I32, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:precision: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.Precision)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.precision (8) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:precision: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetFieldID() {
		if err := oprot.WriteFieldBegin(ctx, "field_id", thrift.I32, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:field_id: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.FieldID)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.field_id (9) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:field_id: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetLogicalType() {
		if err := oprot.WriteFieldBegin(ctx, "logicalType", thrift.STRUCT, 10); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:logicalType: ", p), err)
		}
		if err := p.LogicalType.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.LogicalType), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 10:logicalType: ", p), err)
		}
	}
	return err
}

func (p *SchemaElement) Equals(other *SchemaElement) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Type != other.Type {
		if p.Type == nil || other.Type == nil {
			return false
		}
		if (*p.Type) != (*other.Type) {
			return false
		}
	}
	if p.TypeLength != other.TypeLength {
		if p.TypeLength == nil || other.TypeLength == nil {
			return false
		}
		if (*p.TypeLength) != (*other.TypeLength) {
			return false
		}
	}
	if p.RepetitionType != other.RepetitionType {
		if p.RepetitionType == nil || other.RepetitionType == nil {
			return false
		}
		if (*p.RepetitionType) != (*other.RepetitionType) {
			return false
		}
	}
	if p.Name != other.Name {
		return false
	}
	if p.NumChildren != other.NumChildren {
		if p.NumChildren == nil || other.NumChildren == nil {
			return false
		}
		if (*p.NumChildren) != (*other.NumChildren) {
			return false
		}
	}
	if p.ConvertedType != other.ConvertedType {
		if p.ConvertedType == nil || other.ConvertedType == nil {
			return false
		}
		if (*p.ConvertedType) != (*other.ConvertedType) {
			return false
		}
	}
	if p.Scale != other.Scale {
		if p.Scale == nil || other.Scale == nil {
			return false
		}
		if (*p.Scale) != (*other.Scale) {
			return false
		}
	}
	if p.Precision != other.Precision {
		if p.Precision == nil || other.Precision == nil {
			return false
		}
		if (*p.Precision) != (*other.Precision) {
			return false
		}
	}
	if p.FieldID != other.FieldID {
		if p.FieldID == nil || other.FieldID == nil {
			return false
		}
		if (*p.FieldID) != (*other.FieldID) {
			return false
		}
	}
	if !p.LogicalType.Equals(other.LogicalType) {
		return false
	}
	return true
}

func (p *SchemaElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SchemaElement(%+v)", *p)
}

// Data page header
//
// Attributes:
//  - NumValues: Number of values, including NULLs, in this data page. *
//  - Encoding: Encoding used for this data page *
//  - DefinitionLevelEncoding: Encoding used for definition levels *
//  - RepetitionLevelEncoding: Encoding used for repetition levels *
//  - Statistics: Optional statistics for the data in this page*
type DataPageHeader struct {
	NumValues               int32       `thrift:"num_values,1,required" db:"num_values" json:"num_values"`
	Encoding                Encoding    `thrift:"encoding,2,required" db:"encoding" json:"encoding"`
	DefinitionLevelEncoding Encoding    `thrift:"definition_level_encoding,3,required" db:"definition_level_encoding" json:"definition_level_encoding"`
	RepetitionLevelEncoding Encoding    `thrift:"repetition_level_encoding,4,required" db:"repetition_level_encoding" json:"repetition_level_encoding"`
	Statistics              *Statistics `thrift:"statistics,5" db:"statistics" json:"statistics,omitempty"`
}

func NewDataPageHeader() *DataPageHeader {
	return &DataPageHeader{}
}

func (p *DataPageHeader) GetNumValues() int32 {
	return p.NumValues
}

func (p *DataPageHeader) GetEncoding() Encoding {
	return p.Encoding
}

func (p *DataPageHeader) GetDefinitionLevelEncoding() Encoding {
	return p.DefinitionLevelEncoding
}

func (p *DataPageHeader) GetRepetitionLevelEncoding() Encoding {
	return p.RepetitionLevelEncoding
}

var DataPageHeader_Statistics_DEFAULT *Statistics

func (p *DataPageHeader) GetStatistics() *Statistics {
	if !p.IsSetStatistics() {
		return DataPageHeader_Statistics_DEFAULT
	}
	return p.Statistics
}
func (p *DataPageHeader) IsSetStatistics() bool {
	return p.Statistics != nil
}

func (p *DataPageHeader) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNumValues bool = false
	var issetEncoding bool = false
	var issetDefinitionLevelEncoding bool = false
	var issetRepetitionLevelEncoding bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetNumValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetDefinitionLevelEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetRepetitionLevelEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNumValues {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumValues is not set"))
	}
	if !issetEncoding {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"))
	}
	if !issetDefinitionLevelEncoding {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DefinitionLevelEncoding is not set"))
	}
	if !issetRepetitionLevelEncoding {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RepetitionLevelEncoding is not set"))
	}
	return nil
}

func (p *DataPageHeader) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NumValues = v
	}
	return nil
}

func (p *DataPageHeader) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		temp := Encoding(v)
		p.Encoding = temp
	}
	return nil
}

func (p *DataPageHeader) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		temp := Encoding(v)
		p.DefinitionLevelEncoding = temp
	}
	return nil
}

func (p *DataPageHeader) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		temp := Encoding(v)
		p.RepetitionLevelEncoding = temp
	}
	return nil
}

func (p *DataPageHeader) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	p.Statistics = &Statistics{}
	if err := p.Statistics.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Statistics), err)
	}
	return nil
}

func (p *DataPageHeader) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "DataPageHeader"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DataPageHeader) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_values", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:num_values: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.NumValues)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_values (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:num_values: ", p), err)
	}
	return err
}

func (p *DataPageHeader) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:encoding: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encoding (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:encoding: ", p), err)
	}
	return err
}

func (p *DataPageHeader) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "definition_level_encoding", thrift.I32, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:definition_level_encoding: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.DefinitionLevelEncoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.definition_level_encoding (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:definition_level_encoding: ", p), err)
	}
	return err
}

func (p *DataPageHeader) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "repetition_level_encoding", thrift.I32, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:repetition_level_encoding: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.RepetitionLevelEncoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.repetition_level_encoding (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:repetition_level_encoding: ", p), err)
	}
	return err
}

func (p *DataPageHeader) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetStatistics() {
		if err := oprot.WriteFieldBegin(ctx, "statistics", thrift.STRUCT, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:statistics: ", p), err)
		}
		if err := p.Statistics.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Statistics), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:statistics: ", p), err)
		}
	}
	return err
}

func (p *DataPageHeader) Equals(other *DataPageHeader) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.NumValues != other.NumValues {
		return false
	}
	if p.Encoding != other.Encoding {
		return false
	}
	if p.DefinitionLevelEncoding != other.DefinitionLevelEncoding {
		return false
	}
	if p.RepetitionLevelEncoding != other.RepetitionLevelEncoding {
		return false
	}
	if !p.Statistics.Equals(other.Statistics) {
		return false
	}
	return true
}

func (p *DataPageHeader) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DataPageHeader(%+v)", *p)
}

type IndexPageHeader struct {
}

func NewIndexPageHeader() *IndexPageHeader {
	return &IndexPageHeader{}
}

func (p *IndexPageHeader) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *IndexPageHeader) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "IndexPageHeader"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *IndexPageHeader) Equals(other *IndexPageHeader) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *IndexPageHeader) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("IndexPageHeader(%+v)", *p)
}

// Attributes:
//  - NumValues: Number of values in the dictionary *
//  - Encoding: Encoding using this dictionary page *
//  - IsSorted: If true, the entries in the dictionary are sorted in ascending order *
type DictionaryPageHeader struct {
	NumValues int32    `thrift:"num_values,1,required" db:"num_values" json:"num_values"`
	Encoding  Encoding `thrift:"encoding,2,required" db:"encoding" json:"encoding"`
	IsSorted  *bool    `thrift:"is_sorted,3" db:"is_sorted" json:"is_sorted,omitempty"`
}

func NewDictionaryPageHeader() *DictionaryPageHeader {
	return &DictionaryPageHeader{}
}

func (p *DictionaryPageHeader) GetNumValues() int32 {
	return p.NumValues
}

func (p *DictionaryPageHeader) GetEncoding() Encoding {
	return p.Encoding
}

var DictionaryPageHeader_IsSorted_DEFAULT bool

func (p *DictionaryPageHeader) GetIsSorted() bool {
	if !p.IsSetIsSorted() {
		return DictionaryPageHeader_IsSorted_DEFAULT
	}
	return *p.IsSorted
}
func (p *DictionaryPageHeader) IsSetIsSorted() bool {
	return p.IsSorted != nil
}

func (p *DictionaryPageHeader) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNumValues bool = false
	var issetEncoding bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetNumValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNumValues {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumValues is not set"))
	}
	if !issetEncoding {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"))
	}
	return nil
}

func (p *DictionaryPageHeader) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NumValues = v
	}
	return nil
}

func (p *DictionaryPageHeader) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		temp := Encoding(v)
		p.Encoding = temp
	}
	return nil
}

func (p *DictionaryPageHeader) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.IsSorted = &v
	}
	return nil
}

func (p *DictionaryPageHeader) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "DictionaryPageHeader"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DictionaryPageHeader) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_values", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:num_values: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.NumValues)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_values (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:num_values: ", p), err)
	}
	return err
}

func (p *DictionaryPageHeader) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:encoding: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encoding (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:encoding: ", p), err)
	}
	return err
}

func (p *DictionaryPageHeader) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetIsSorted() {
		if err := oprot.WriteFieldBegin(ctx, "is_sorted", thrift.BOOL, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:is_sorted: ", p), err)
		}
		if err := oprot.WriteBool(ctx, bool(*p.IsSorted)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.is_sorted (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:is_sorted: ", p), err)
		}
	}
	return err
}

func (p *DictionaryPageHeader) Equals(other *DictionaryPageHeader) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.NumValues != other.NumValues {
		return false
	}
	if p.Encoding != other.Encoding {
		return false
	}
	if p.IsSorted != other.IsSorted {
		if p.IsSorted == nil || other.IsSorted == nil {
			return false
		}
		if (*p.IsSorted) != (*other.IsSorted) {
			return false
		}
	}
	return true
}

func (p *DictionaryPageHeader) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DictionaryPageHeader(%+v)", *p)
}

// New page format allowing reading levels without decompressing the data
// Repetition and definition levels are uncompressed
// The remaining section containing the data is compressed if is_compressed is true
//
//
// Attributes:
//  - NumValues: Number of values, including NULLs, in this data page. *
//  - NumNulls: Number of NULL values, in this data page.
// Number of non-null = num_values - num_nulls which is also the number of values in the data section *
//  - NumRows: Number of rows in this data page. which means pages change on record boundaries (r = 0) *
//  - Encoding: Encoding used for data in this page *
//  - DefinitionLevelsByteLength: length of the definition levels
//  - RepetitionLevelsByteLength: length of the repetition levels
//  - IsCompressed: whether the values are compressed.
// Which means the section of the page between
// definition_levels_byte_length + repetition_levels_byte_length + 1 and compressed_page_size (included)
// is compressed with the compression_codec.
// If missing it is considered compressed
//  - Statistics: optional statistics for the data in this page *
type DataPageHeaderV2 struct {
	NumValues                  int32       `thrift:"num_values,1,required" db:"num_values" json:"num_values"`
	NumNulls                   int32       `thrift:"num_nulls,2,required" db:"num_nulls" json:"num_nulls"`
	NumRows                    int32       `thrift:"num_rows,3,required" db:"num_rows" json:"num_rows"`
	Encoding                   Encoding    `thrift:"encoding,4,required" db:"encoding" json:"encoding"`
	DefinitionLevelsByteLength int32       `thrift:"definition_levels_byte_length,5,required" db:"definition_levels_byte_length" json:"definition_levels_byte_length"`
	RepetitionLevelsByteLength int32       `thrift:"repetition_levels_byte_length,6,required" db:"repetition_levels_byte_length" json:"repetition_levels_byte_length"`
	IsCompressed               bool        `thrift:"is_compressed,7" db:"is_compressed" json:"is_compressed"`
	Statistics                 *Statistics `thrift:"statistics,8" db:"statistics" json:"statistics,omitempty"`
}

func NewDataPageHeaderV2() *DataPageHeaderV2 {
	return &DataPageHeaderV2{
		IsCompressed: true,
	}
}

func (p *DataPageHeaderV2) GetNumValues() int32 {
	return p.NumValues
}

func (p *DataPageHeaderV2) GetNumNulls() int32 {
	return p.NumNulls
}

func (p *DataPageHeaderV2) GetNumRows() int32 {
	return p.NumRows
}

func (p *DataPageHeaderV2) GetEncoding() Encoding {
	return p.Encoding
}

func (p *DataPageHeaderV2) GetDefinitionLevelsByteLength() int32 {
	return p.DefinitionLevelsByteLength
}

func (p *DataPageHeaderV2) GetRepetitionLevelsByteLength() int32 {
	return p.RepetitionLevelsByteLength
}

var DataPageHeaderV2_IsCompressed_DEFAULT bool = true

func (p *DataPageHeaderV2) GetIsCompressed() bool {
	return p.IsCompressed
}

var DataPageHeaderV2_Statistics_DEFAULT *Statistics

func (p *DataPageHeaderV2) GetStatistics() *Statistics {
	if !p.IsSetStatistics() {
		return DataPageHeaderV2_Statistics_DEFAULT
	}
	return p.Statistics
}
func (p *DataPageHeaderV2) IsSetIsCompressed() bool {
	return p.IsCompressed != DataPageHeaderV2_IsCompressed_DEFAULT
}

func (p *DataPageHeaderV2) IsSetStatistics() bool {
	return p.Statistics != nil
}

func (p *DataPageHeaderV2) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNumValues bool = false
	var issetNumNulls bool = false
	var issetNumRows bool = false
	var issetEncoding bool = false
	var issetDefinitionLevelsByteLength bool = false
	var issetRepetitionLevelsByteLength bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetNumValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetNumNulls = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetNumRows = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetDefinitionLevelsByteLength = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
				issetRepetitionLevelsByteLength = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNumValues {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumValues is not set"))
	}
	if !issetNumNulls {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumNulls is not set"))
	}
	if !issetNumRows {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumRows is not set"))
	}
	if !issetEncoding {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"))
	}
	if !issetDefinitionLevelsByteLength {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DefinitionLevelsByteLength is not set"))
	}
	if !issetRepetitionLevelsByteLength {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RepetitionLevelsByteLength is not set"))
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NumValues = v
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.NumNulls = v
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NumRows = v
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		temp := Encoding(v)
		p.Encoding = temp
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.DefinitionLevelsByteLength = v
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.RepetitionLevelsByteLength = v
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.IsCompressed = v
	}
	return nil
}

func (p *DataPageHeaderV2) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	p.Statistics = &Statistics{}
	if err := p.Statistics.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Statistics), err)
	}
	return nil
}

func (p *DataPageHeaderV2) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "DataPageHeaderV2"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DataPageHeaderV2) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_values", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:num_values: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.NumValues)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_values (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:num_values: ", p), err)
	}
	return err
}

func (p *DataPageHeaderV2) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_nulls", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:num_nulls: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.NumNulls)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_nulls (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:num_nulls: ", p), err)
	}
	return err
}

func (p *DataPageHeaderV2) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_rows", thrift.I32, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:num_rows: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.NumRows)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_rows (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:num_rows: ", p), err)
	}
	return err
}

func (p *DataPageHeaderV2) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encoding: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encoding (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encoding: ", p), err)
	}
	return err
}

func (p *DataPageHeaderV2) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "definition_levels_byte_length", thrift.I32, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:definition_levels_byte_length: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.DefinitionLevelsByteLength)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.definition_levels_byte_length (5) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:definition_levels_byte_length: ", p), err)
	}
	return err
}

func (p *DataPageHeaderV2) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "repetition_levels_byte_length", thrift.I32, 6); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:repetition_levels_byte_length: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.RepetitionLevelsByteLength)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.repetition_levels_byte_length (6) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 6:repetition_levels_byte_length: ", p), err)
	}
	return err
}

func (p *DataPageHeaderV2) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetIsCompressed() {
		if err := oprot.WriteFieldBegin(ctx, "is_compressed", thrift.BOOL, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:is_compressed: ", p), err)
		}
		if err := oprot.WriteBool(ctx, bool(p.IsCompressed)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.is_compressed (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:is_compressed: ", p), err)
		}
	}
	return err
}

func (p *DataPageHeaderV2) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetStatistics() {
		if err := oprot.WriteFieldBegin(ctx, "statistics", thrift.STRUCT, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:statistics: ", p), err)
		}
		if err := p.Statistics.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Statistics), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:statistics: ", p), err)
		}
	}
	return err
}

func (p *DataPageHeaderV2) Equals(other *DataPageHeaderV2) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.NumValues != other.NumValues {
		return false
	}
	if p.NumNulls != other.NumNulls {
		return false
	}
	if p.NumRows != other.NumRows {
		return false
	}
	if p.Encoding != other.Encoding {
		return false
	}
	if p.DefinitionLevelsByteLength != other.DefinitionLevelsByteLength {
		return false
	}
	if p.RepetitionLevelsByteLength != other.RepetitionLevelsByteLength {
		return false
	}
	if p.IsCompressed != other.IsCompressed {
		return false
	}
	if !p.Statistics.Equals(other.Statistics) {
		return false
	}
	return true
}

func (p *DataPageHeaderV2) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DataPageHeaderV2(%+v)", *p)
}

// Block-based algorithm type annotation. *
type SplitBlockAlgorithm struct {
}

func NewSplitBlockAlgorithm() *SplitBlockAlgorithm {
	return &SplitBlockAlgorithm{}
}

func (p *SplitBlockAlgorithm) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *SplitBlockAlgorithm) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "SplitBlockAlgorithm"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *SplitBlockAlgorithm) Equals(other *SplitBlockAlgorithm) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *SplitBlockAlgorithm) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SplitBlockAlgorithm(%+v)", *p)
}

// The algorithm used in Bloom filter. *
//
// Attributes:
//  - BLOCK: Block-based Bloom filter. *
type BloomFilterAlgorithm struct {
	BLOCK *SplitBlockAlgorithm `thrift:"BLOCK,1" db:"BLOCK" json:"BLOCK,omitempty"`
}

func NewBloomFilterAlgorithm() *BloomFilterAlgorithm {
	return &BloomFilterAlgorithm{}
}

var BloomFilterAlgorithm_BLOCK_DEFAULT *SplitBlockAlgorithm

func (p *BloomFilterAlgorithm) GetBLOCK() *SplitBlockAlgorithm {
	if !p.IsSetBLOCK() {
		return BloomFilterAlgorithm_BLOCK_DEFAULT
	}
	return p.BLOCK
}
func (p *BloomFilterAlgorithm) CountSetFieldsBloomFilterAlgorithm() int {
	count := 0
	if p.IsSetBLOCK() {
		count++
	}
	return count

}

func (p *BloomFilterAlgorithm) IsSetBLOCK() bool {
	return p.BLOCK != nil
}

func (p *BloomFilterAlgorithm) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *BloomFilterAlgorithm) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.BLOCK = &SplitBlockAlgorithm{}
	if err := p.BLOCK.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.BLOCK), err)
	}
	return nil
}

func (p *BloomFilterAlgorithm) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsBloomFilterAlgorithm(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "BloomFilterAlgorithm"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *BloomFilterAlgorithm) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetBLOCK() {
		if err := oprot.WriteFieldBegin(ctx, "BLOCK", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:BLOCK: ", p), err)
		}
		if err := p.BLOCK.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.BLOCK), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:BLOCK: ", p), err)
		}
	}
	return err
}

func (p *BloomFilterAlgorithm) Equals(other *BloomFilterAlgorithm) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.BLOCK.Equals(other.BLOCK) {
		return false
	}
	return true
}

func (p *BloomFilterAlgorithm) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BloomFilterAlgorithm(%+v)", *p)
}

// Hash strategy type annotation. xxHash is an extremely fast non-cryptographic hash
// algorithm. It uses 64 bits version of xxHash.
//
type XxHash struct {
}

func NewXxHash() *XxHash {
	return &XxHash{}
}

func (p *XxHash) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *XxHash) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "XxHash"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *XxHash) Equals(other *XxHash) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *XxHash) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("XxHash(%+v)", *p)
}

// The hash function used in Bloom filter. This function takes the hash of a column value
// using plain encoding.
//
//
// Attributes:
//  - XXHASH: xxHash Strategy. *
type BloomFilterHash struct {
	XXHASH *XxHash `thrift:"XXHASH,1" db:"XXHASH" json:"XXHASH,omitempty"`
}

func NewBloomFilterHash() *BloomFilterHash {
	return &BloomFilterHash{}
}

var BloomFilterHash_XXHASH_DEFAULT *XxHash

func (p *BloomFilterHash) GetXXHASH() *XxHash {
	if !p.IsSetXXHASH() {
		return BloomFilterHash_XXHASH_DEFAULT
	}
	return p.XXHASH
}
func (p *BloomFilterHash) CountSetFieldsBloomFilterHash() int {
	count := 0
	if p.IsSetXXHASH() {
		count++
	}
	return count

}

func (p *BloomFilterHash) IsSetXXHASH() bool {
	return p.XXHASH != nil
}

func (p *BloomFilterHash) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *BloomFilterHash) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.XXHASH = &XxHash{}
	if err := p.XXHASH.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.XXHASH), err)
	}
	return nil
}

func (p *BloomFilterHash) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsBloomFilterHash(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "BloomFilterHash"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *BloomFilterHash) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetXXHASH() {
		if err := oprot.WriteFieldBegin(ctx, "XXHASH", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:XXHASH: ", p), err)
		}
		if err := p.XXHASH.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.XXHASH), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:XXHASH: ", p), err)
		}
	}
	return err
}

func (p *BloomFilterHash) Equals(other *BloomFilterHash) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.XXHASH.Equals(other.XXHASH) {
		return false
	}
	return true
}

func (p *BloomFilterHash) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BloomFilterHash(%+v)", *p)
}

// The compression used in the Bloom filter.
//
type Uncompressed struct {
}

func NewUncompressed() *Uncompressed {
	return &Uncompressed{}
}

func (p *Uncompressed) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *Uncompressed) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "Uncompressed"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Uncompressed) Equals(other *Uncompressed) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *Uncompressed) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Uncompressed(%+v)", *p)
}

// Attributes:
//  - UNCOMPRESSED
type BloomFilterCompression struct {
	UNCOMPRESSED *Uncompressed `thrift:"UNCOMPRESSED,1" db:"UNCOMPRESSED" json:"UNCOMPRESSED,omitempty"`
}

func NewBloomFilterCompression() *BloomFilterCompression {
	return &BloomFilterCompression{}
}

var BloomFilterCompression_UNCOMPRESSED_DEFAULT *Uncompressed

func (p *BloomFilterCompression) GetUNCOMPRESSED() *Uncompressed {
	if !p.IsSetUNCOMPRESSED() {
		return BloomFilterCompression_UNCOMPRESSED_DEFAULT
	}
	return p.UNCOMPRESSED
}
func (p *BloomFilterCompression) CountSetFieldsBloomFilterCompression() int {
	count := 0
	if p.IsSetUNCOMPRESSED() {
		count++
	}
	return count

}

func (p *BloomFilterCompression) IsSetUNCOMPRESSED() bool {
	return p.UNCOMPRESSED != nil
}

func (p *BloomFilterCompression) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *BloomFilterCompression) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.UNCOMPRESSED = &Uncompressed{}
	if err := p.UNCOMPRESSED.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.UNCOMPRESSED), err)
	}
	return nil
}

func (p *BloomFilterCompression) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsBloomFilterCompression(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "BloomFilterCompression"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *BloomFilterCompression) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetUNCOMPRESSED() {
		if err := oprot.WriteFieldBegin(ctx, "UNCOMPRESSED", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:UNCOMPRESSED: ", p), err)
		}
		if err := p.UNCOMPRESSED.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.UNCOMPRESSED), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:UNCOMPRESSED: ", p), err)
		}
	}
	return err
}

func (p *BloomFilterCompression) Equals(other *BloomFilterCompression) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.UNCOMPRESSED.Equals(other.UNCOMPRESSED) {
		return false
	}
	return true
}

func (p *BloomFilterCompression) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BloomFilterCompression(%+v)", *p)
}

// Bloom filter header is stored at beginning of Bloom filter data of each column
// and followed by its bitset.
//
//
// Attributes:
//  - NumBytes: The size of bitset in bytes *
//  - Algorithm: The algorithm for setting bits. *
//  - Hash: The hash function used for Bloom filter. *
//  - Compression: The compression used in the Bloom filter *
type BloomFilterHeader struct {
	NumBytes    int32                   `thrift:"numBytes,1,required" db:"numBytes" json:"numBytes"`
	Algorithm   *BloomFilterAlgorithm   `thrift:"algorithm,2,required" db:"algorithm" json:"algorithm"`
	Hash        *BloomFilterHash        `thrift:"hash,3,required" db:"hash" json:"hash"`
	Compression *BloomFilterCompression `thrift:"compression,4,required" db:"compression" json:"compression"`
}

func NewBloomFilterHeader() *BloomFilterHeader {
	return &BloomFilterHeader{}
}

func (p *BloomFilterHeader) GetNumBytes() int32 {
	return p.NumBytes
}

var BloomFilterHeader_Algorithm_DEFAULT *BloomFilterAlgorithm

func (p *BloomFilterHeader) GetAlgorithm() *BloomFilterAlgorithm {
	if !p.IsSetAlgorithm() {
		return BloomFilterHeader_Algorithm_DEFAULT
	}
	return p.Algorithm
}

var BloomFilterHeader_Hash_DEFAULT *BloomFilterHash

func (p *BloomFilterHeader) GetHash() *BloomFilterHash {
	if !p.IsSetHash() {
		return BloomFilterHeader_Hash_DEFAULT
	}
	return p.Hash
}

var BloomFilterHeader_Compression_DEFAULT *BloomFilterCompression

func (p *BloomFilterHeader) GetCompression() *BloomFilterCompression {
	if !p.IsSetCompression() {
		return BloomFilterHeader_Compression_DEFAULT
	}
	return p.Compression
}
func (p *BloomFilterHeader) IsSetAlgorithm() bool {
	return p.Algorithm != nil
}

func (p *BloomFilterHeader) IsSetHash() bool {
	return p.Hash != nil
}

func (p *BloomFilterHeader) IsSetCompression() bool {
	return p.Compression != nil
}

func (p *BloomFilterHeader) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNumBytes bool = false
	var issetAlgorithm bool = false
	var issetHash bool = false
	var issetCompression bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetNumBytes = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetAlgorithm = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetHash = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetCompression = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNumBytes {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumBytes is not set"))
	}
	if !issetAlgorithm {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Algorithm is not set"))
	}
	if !issetHash {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Hash is not set"))
	}
	if !issetCompression {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compression is not set"))
	}
	return nil
}

func (p *BloomFilterHeader) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NumBytes = v
	}
	return nil
}

func (p *BloomFilterHeader) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.Algorithm = &BloomFilterAlgorithm{}
	if err := p.Algorithm.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Algorithm), err)
	}
	return nil
}

func (p *BloomFilterHeader) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	p.Hash = &BloomFilterHash{}
	if err := p.Hash.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Hash), err)
	}
	return nil
}

func (p *BloomFilterHeader) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	p.Compression = &BloomFilterCompression{}
	if err := p.Compression.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Compression), err)
	}
	return nil
}

func (p *BloomFilterHeader) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "BloomFilterHeader"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *BloomFilterHeader) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "numBytes", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:numBytes: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.NumBytes)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.numBytes (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:numBytes: ", p), err)
	}
	return err
}

func (p *BloomFilterHeader) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "algorithm", thrift.STRUCT, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:algorithm: ", p), err)
	}
	if err := p.Algorithm.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Algorithm), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:algorithm: ", p), err)
	}
	return err
}

func (p *BloomFilterHeader) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "hash", thrift.STRUCT, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:hash: ", p), err)
	}
	if err := p.Hash.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Hash), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:hash: ", p), err)
	}
	return err
}

func (p *BloomFilterHeader) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "compression", thrift.STRUCT, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:compression: ", p), err)
	}
	if err := p.Compression.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Compression), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:compression: ", p), err)
	}
	return err
}

func (p *BloomFilterHeader) Equals(other *BloomFilterHeader) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.NumBytes != other.NumBytes {
		return false
	}
	if !p.Algorithm.Equals(other.Algorithm) {
		return false
	}
	if !p.Hash.Equals(other.Hash) {
		return false
	}
	if !p.Compression.Equals(other.Compression) {
		return false
	}
	return true
}

func (p *BloomFilterHeader) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BloomFilterHeader(%+v)", *p)
}

// Attributes:
//  - Type: the type of the page: indicates which of the *_header fields is set *
//  - UncompressedPageSize: Uncompressed page size in bytes (not including this header) *
//  - CompressedPageSize: Compressed (and potentially encrypted) page size in bytes, not including this header *
//  - Crc: The 32bit CRC for the page, to be be calculated as follows:
// - Using the standard CRC32 algorithm
// - On the data only, i.e. this header should not be included. 'Data'
//   hereby refers to the concatenation of the repetition levels, the
//   definition levels and the column value, in this exact order.
// - On the encoded versions of the repetition levels, definition levels and
//   column values
// - On the compressed versions of the repetition levels, definition levels
//   and column values where possible;
//   - For v1 data pages, the repetition levels, definition levels and column
//     values are always compressed together. If a compression scheme is
//     specified, the CRC shall be calculated on the compressed version of
//     this concatenation. If no compression scheme is specified, the CRC
//     shall be calculated on the uncompressed version of this concatenation.
//   - For v2 data pages, the repetition levels and definition levels are
//     handled separately from the data and are never compressed (only
//     encoded). If a compression scheme is specified, the CRC shall be
//     calculated on the concatenation of the uncompressed repetition levels,
//     uncompressed definition levels and the compressed column values.
//     If no compression scheme is specified, the CRC shall be calculated on
//     the uncompressed concatenation.
// - In encrypted columns, CRC is calculated after page encryption; the
//   encryption itself is performed after page compression (if compressed)
// If enabled, this allows for disabling checksumming in HDFS if only a few
// pages need to be read.
//
//  - DataPageHeader
//  - IndexPageHeader
//  - DictionaryPageHeader
//  - DataPageHeaderV2
type PageHeader struct {
	Type                 PageType              `thrift:"type,1,required" db:"type" json:"type"`
	UncompressedPageSize int32                 `thrift:"uncompressed_page_size,2,required" db:"uncompressed_page_size" json:"uncompressed_page_size"`
	CompressedPageSize   int32                 `thrift:"compressed_page_size,3,required" db:"compressed_page_size" json:"compressed_page_size"`
	Crc                  *int32                `thrift:"crc,4" db:"crc" json:"crc,omitempty"`
	DataPageHeader       *DataPageHeader       `thrift:"data_page_header,5" db:"data_page_header" json:"data_page_header,omitempty"`
	IndexPageHeader      *IndexPageHeader      `thrift:"index_page_header,6" db:"index_page_header" json:"index_page_header,omitempty"`
	DictionaryPageHeader *DictionaryPageHeader `thrift:"dictionary_page_header,7" db:"dictionary_page_header" json:"dictionary_page_header,omitempty"`
	DataPageHeaderV2     *DataPageHeaderV2     `thrift:"data_page_header_v2,8" db:"data_page_header_v2" json:"data_page_header_v2,omitempty"`
}

func NewPageHeader() *PageHeader {
	return &PageHeader{}
}

func (p *PageHeader) GetType() PageType {
	return p.Type
}

func (p *PageHeader) GetUncompressedPageSize() int32 {
	return p.UncompressedPageSize
}

func (p *PageHeader) GetCompressedPageSize() int32 {
	return p.CompressedPageSize
}

var PageHeader_Crc_DEFAULT int32

func (p *PageHeader) GetCrc() int32 {
	if !p.IsSetCrc() {
		return PageHeader_Crc_DEFAULT
	}
	return *p.Crc
}

var PageHeader_DataPageHeader_DEFAULT *DataPageHeader

func (p *PageHeader) GetDataPageHeader() *DataPageHeader {
	if !p.IsSetDataPageHeader() {
		return PageHeader_DataPageHeader_DEFAULT
	}
	return p.DataPageHeader
}

var PageHeader_IndexPageHeader_DEFAULT *IndexPageHeader

func (p *PageHeader) GetIndexPageHeader() *IndexPageHeader {
	if !p.IsSetIndexPageHeader() {
		return PageHeader_IndexPageHeader_DEFAULT
	}
	return p.IndexPageHeader
}

var PageHeader_DictionaryPageHeader_DEFAULT *DictionaryPageHeader

func (p *PageHeader) GetDictionaryPageHeader() *DictionaryPageHeader {
	if !p.IsSetDictionaryPageHeader() {
		return PageHeader_DictionaryPageHeader_DEFAULT
	}
	return p.DictionaryPageHeader
}

var PageHeader_DataPageHeaderV2_DEFAULT *DataPageHeaderV2

func (p *PageHeader) GetDataPageHeaderV2() *DataPageHeaderV2 {
	if !p.IsSetDataPageHeaderV2() {
		return PageHeader_DataPageHeaderV2_DEFAULT
	}
	return p.DataPageHeaderV2
}
func (p *PageHeader) IsSetCrc() bool {
	return p.Crc != nil
}

func (p *PageHeader) IsSetDataPageHeader() bool {
	return p.DataPageHeader != nil
}

func (p *PageHeader) IsSetIndexPageHeader() bool {
	return p.IndexPageHeader != nil
}

func (p *PageHeader) IsSetDictionaryPageHeader() bool {
	return p.DictionaryPageHeader != nil
}

func (p *PageHeader) IsSetDataPageHeaderV2() bool {
	return p.DataPageHeaderV2 != nil
}

func (p *PageHeader) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetType bool = false
	var issetUncompressedPageSize bool = false
	var issetCompressedPageSize bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetType = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetUncompressedPageSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetCompressedPageSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetType {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"))
	}
	if !issetUncompressedPageSize {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field UncompressedPageSize is not set"))
	}
	if !issetCompressedPageSize {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CompressedPageSize is not set"))
	}
	return nil
}

func (p *PageHeader) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := PageType(v)
		p.Type = temp
	}
	return nil
}

func (p *PageHeader) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.UncompressedPageSize = v
	}
	return nil
}

func (p *PageHeader) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.CompressedPageSize = v
	}
	return nil
}

func (p *PageHeader) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Crc = &v
	}
	return nil
}

func (p *PageHeader) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	p.DataPageHeader = &DataPageHeader{}
	if err := p.DataPageHeader.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.DataPageHeader), err)
	}
	return nil
}

func (p *PageHeader) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	p.IndexPageHeader = &IndexPageHeader{}
	if err := p.IndexPageHeader.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.IndexPageHeader), err)
	}
	return nil
}

func (p *PageHeader) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	p.DictionaryPageHeader = &DictionaryPageHeader{}
	if err := p.DictionaryPageHeader.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.DictionaryPageHeader), err)
	}
	return nil
}

func (p *PageHeader) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	p.DataPageHeaderV2 = &DataPageHeaderV2{
		IsCompressed: true,
	}
	if err := p.DataPageHeaderV2.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.DataPageHeaderV2), err)
	}
	return nil
}

func (p *PageHeader) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "PageHeader"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *PageHeader) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "type", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:type: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Type)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.type (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:type: ", p), err)
	}
	return err
}

func (p *PageHeader) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "uncompressed_page_size", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:uncompressed_page_size: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.UncompressedPageSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.uncompressed_page_size (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:uncompressed_page_size: ", p), err)
	}
	return err
}

func (p *PageHeader) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "compressed_page_size", thrift.I32, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:compressed_page_size: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.CompressedPageSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.compressed_page_size (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:compressed_page_size: ", p), err)
	}
	return err
}

func (p *PageHeader) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetCrc() {
		if err := oprot.WriteFieldBegin(ctx, "crc", thrift.I32, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:crc: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.Crc)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.crc (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:crc: ", p), err)
		}
	}
	return err
}

func (p *PageHeader) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDataPageHeader() {
		if err := oprot.WriteFieldBegin(ctx, "data_page_header", thrift.STRUCT, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:data_page_header: ", p), err)
		}
		if err := p.DataPageHeader.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.DataPageHeader), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:data_page_header: ", p), err)
		}
	}
	return err
}

func (p *PageHeader) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetIndexPageHeader() {
		if err := oprot.WriteFieldBegin(ctx, "index_page_header", thrift.STRUCT, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:index_page_header: ", p), err)
		}
		if err := p.IndexPageHeader.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.IndexPageHeader), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:index_page_header: ", p), err)
		}
	}
	return err
}

func (p *PageHeader) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDictionaryPageHeader() {
		if err := oprot.WriteFieldBegin(ctx, "dictionary_page_header", thrift.STRUCT, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:dictionary_page_header: ", p), err)
		}
		if err := p.DictionaryPageHeader.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.DictionaryPageHeader), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:dictionary_page_header: ", p), err)
		}
	}
	return err
}

func (p *PageHeader) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDataPageHeaderV2() {
		if err := oprot.WriteFieldBegin(ctx, "data_page_header_v2", thrift.STRUCT, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:data_page_header_v2: ", p), err)
		}
		if err := p.DataPageHeaderV2.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.DataPageHeaderV2), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:data_page_header_v2: ", p), err)
		}
	}
	return err
}

func (p *PageHeader) Equals(other *PageHeader) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Type != other.Type {
		return false
	}
	if p.UncompressedPageSize != other.UncompressedPageSize {
		return false
	}
	if p.CompressedPageSize != other.CompressedPageSize {
		return false
	}
	if p.Crc != other.Crc {
		if p.Crc == nil || other.Crc == nil {
			return false
		}
		if (*p.Crc) != (*other.Crc) {
			return false
		}
	}
	if !p.DataPageHeader.Equals(other.DataPageHeader) {
		return false
	}
	if !p.IndexPageHeader.Equals(other.IndexPageHeader) {
		return false
	}
	if !p.DictionaryPageHeader.Equals(other.DictionaryPageHeader) {
		return false
	}
	if !p.DataPageHeaderV2.Equals(other.DataPageHeaderV2) {
		return false
	}
	return true
}

func (p *PageHeader) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PageHeader(%+v)", *p)
}

// Wrapper struct to store key values
//
// Attributes:
//  - Key
//  - Value
type KeyValue struct {
	Key   string  `thrift:"key,1,required" db:"key" json:"key"`
	Value *string `thrift:"value,2" db:"value" json:"value,omitempty"`
}

func NewKeyValue() *KeyValue {
	return &KeyValue{}
}

func (p *KeyValue) GetKey() string {
	return p.Key
}

var KeyValue_Value_DEFAULT string

func (p *KeyValue) GetValue() string {
	if !p.IsSetValue() {
		return KeyValue_Value_DEFAULT
	}
	return *p.Value
}
func (p *KeyValue) IsSetValue() bool {
	return p.Value != nil
}

func (p *KeyValue) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetKey bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetKey = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetKey {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Key is not set"))
	}
	return nil
}

func (p *KeyValue) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Key = v
	}
	return nil
}

func (p *KeyValue) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Value = &v
	}
	return nil
}

func (p *KeyValue) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "KeyValue"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *KeyValue) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "key", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:key: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Key)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.key (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:key: ", p), err)
	}
	return err
}

func (p *KeyValue) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetValue() {
		if err := oprot.WriteFieldBegin(ctx, "value", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:value: ", p), err)
		}
		if err := oprot.WriteString(ctx, string(*p.Value)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.value (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:value: ", p), err)
		}
	}
	return err
}

func (p *KeyValue) Equals(other *KeyValue) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Key != other.Key {
		return false
	}
	if p.Value != other.Value {
		if p.Value == nil || other.Value == nil {
			return false
		}
		if (*p.Value) != (*other.Value) {
			return false
		}
	}
	return true
}

func (p *KeyValue) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("KeyValue(%+v)", *p)
}

// Wrapper struct to specify sort order
//
// Attributes:
//  - ColumnIdx: The column index (in this row group) *
//  - Descending: If true, indicates this column is sorted in descending order. *
//  - NullsFirst: If true, nulls will come before non-null values, otherwise,
// nulls go at the end.
type SortingColumn struct {
	ColumnIdx  int32 `thrift:"column_idx,1,required" db:"column_idx" json:"column_idx"`
	Descending bool  `thrift:"descending,2,required" db:"descending" json:"descending"`
	NullsFirst bool  `thrift:"nulls_first,3,required" db:"nulls_first" json:"nulls_first"`
}

func NewSortingColumn() *SortingColumn {
	return &SortingColumn{}
}

func (p *SortingColumn) GetColumnIdx() int32 {
	return p.ColumnIdx
}

func (p *SortingColumn) GetDescending() bool {
	return p.Descending
}

func (p *SortingColumn) GetNullsFirst() bool {
	return p.NullsFirst
}
func (p *SortingColumn) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetColumnIdx bool = false
	var issetDescending bool = false
	var issetNullsFirst bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetColumnIdx = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDescending = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetNullsFirst = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetColumnIdx {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ColumnIdx is not set"))
	}
	if !issetDescending {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Descending is not set"))
	}
	if !issetNullsFirst {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NullsFirst is not set"))
	}
	return nil
}

func (p *SortingColumn) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ColumnIdx = v
	}
	return nil
}

func (p *SortingColumn) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Descending = v
	}
	return nil
}

func (p *SortingColumn) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NullsFirst = v
	}
	return nil
}

func (p *SortingColumn) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "SortingColumn"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *SortingColumn) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "column_idx", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:column_idx: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.ColumnIdx)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.column_idx (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:column_idx: ", p), err)
	}
	return err
}

func (p *SortingColumn) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "descending", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:descending: ", p), err)
	}
	if err := oprot.WriteBool(ctx, bool(p.Descending)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.descending (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:descending: ", p), err)
	}
	return err
}

func (p *SortingColumn) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "nulls_first", thrift.BOOL, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nulls_first: ", p), err)
	}
	if err := oprot.WriteBool(ctx, bool(p.NullsFirst)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nulls_first (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nulls_first: ", p), err)
	}
	return err
}

func (p *SortingColumn) Equals(other *SortingColumn) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.ColumnIdx != other.ColumnIdx {
		return false
	}
	if p.Descending != other.Descending {
		return false
	}
	if p.NullsFirst != other.NullsFirst {
		return false
	}
	return true
}

func (p *SortingColumn) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SortingColumn(%+v)", *p)
}

// statistics of a given page type and encoding
//
// Attributes:
//  - PageType: the page type (data/dic/...) *
//  - Encoding: encoding of the page *
//  - Count: number of pages of this type with this encoding *
type PageEncodingStats struct {
	PageType PageType `thrift:"page_type,1,required" db:"page_type" json:"page_type"`
	Encoding Encoding `thrift:"encoding,2,required" db:"encoding" json:"encoding"`
	Count    int32    `thrift:"count,3,required" db:"count" json:"count"`
}

func NewPageEncodingStats() *PageEncodingStats {
	return &PageEncodingStats{}
}

func (p *PageEncodingStats) GetPageType() PageType {
	return p.PageType
}

func (p *PageEncodingStats) GetEncoding() Encoding {
	return p.Encoding
}

func (p *PageEncodingStats) GetCount() int32 {
	return p.Count
}
func (p *PageEncodingStats) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetPageType bool = false
	var issetEncoding bool = false
	var issetCount bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetPageType = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetCount = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetPageType {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PageType is not set"))
	}
	if !issetEncoding {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"))
	}
	if !issetCount {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Count is not set"))
	}
	return nil
}

func (p *PageEncodingStats) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := PageType(v)
		p.PageType = temp
	}
	return nil
}

func (p *PageEncodingStats) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		temp := Encoding(v)
		p.Encoding = temp
	}
	return nil
}

func (p *PageEncodingStats) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.Count = v
	}
	return nil
}

func (p *PageEncodingStats) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "PageEncodingStats"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *PageEncodingStats) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "page_type", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:page_type: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.PageType)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.page_type (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:page_type: ", p), err)
	}
	return err
}

func (p *PageEncodingStats) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:encoding: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encoding (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:encoding: ", p), err)
	}
	return err
}

func (p *PageEncodingStats) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "count", thrift.I32, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:count: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Count)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.count (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:count: ", p), err)
	}
	return err
}

func (p *PageEncodingStats) Equals(other *PageEncodingStats) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.PageType != other.PageType {
		return false
	}
	if p.Encoding != other.Encoding {
		return false
	}
	if p.Count != other.Count {
		return false
	}
	return true
}

func (p *PageEncodingStats) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PageEncodingStats(%+v)", *p)
}

// Description for column metadata
//
// Attributes:
//  - Type: Type of this column *
//  - Encodings: Set of all encodings used for this column. The purpose is to validate
// whether we can decode those pages. *
//  - PathInSchema: Path in schema *
//  - Codec: Compression codec *
//  - NumValues: Number of values in this column *
//  - TotalUncompressedSize: total byte size of all uncompressed pages in this column chunk (including the headers) *
//  - TotalCompressedSize: total byte size of all compressed, and potentially encrypted, pages
// in this column chunk (including the headers) *
//  - KeyValueMetadata: Optional key/value metadata *
//  - DataPageOffset: Byte offset from beginning of file to first data page *
//  - IndexPageOffset: Byte offset from beginning of file to root index page *
//  - DictionaryPageOffset: Byte offset from the beginning of file to first (only) dictionary page *
//  - Statistics: optional statistics for this column chunk
//  - EncodingStats: Set of all encodings used for pages in this column chunk.
// This information can be used to determine if all data pages are
// dictionary encoded for example *
//  - BloomFilterOffset: Byte offset from beginning of file to Bloom filter data. *
type ColumnMetaData struct {
	Type                  Type                 `thrift:"type,1,required" db:"type" json:"type"`
	Encodings             []Encoding           `thrift:"encodings,2,required" db:"encodings" json:"encodings"`
	PathInSchema          []string             `thrift:"path_in_schema,3,required" db:"path_in_schema" json:"path_in_schema"`
	Codec                 CompressionCodec     `thrift:"codec,4,required" db:"codec" json:"codec"`
	NumValues             int64                `thrift:"num_values,5,required" db:"num_values" json:"num_values"`
	TotalUncompressedSize int64                `thrift:"total_uncompressed_size,6,required" db:"total_uncompressed_size" json:"total_uncompressed_size"`
	TotalCompressedSize   int64                `thrift:"total_compressed_size,7,required" db:"total_compressed_size" json:"total_compressed_size"`
	KeyValueMetadata      []*KeyValue          `thrift:"key_value_metadata,8" db:"key_value_metadata" json:"key_value_metadata,omitempty"`
	DataPageOffset        int64                `thrift:"data_page_offset,9,required" db:"data_page_offset" json:"data_page_offset"`
	IndexPageOffset       *int64               `thrift:"index_page_offset,10" db:"index_page_offset" json:"index_page_offset,omitempty"`
	DictionaryPageOffset  *int64               `thrift:"dictionary_page_offset,11" db:"dictionary_page_offset" json:"dictionary_page_offset,omitempty"`
	Statistics            *Statistics          `thrift:"statistics,12" db:"statistics" json:"statistics,omitempty"`
	EncodingStats         []*PageEncodingStats `thrift:"encoding_stats,13" db:"encoding_stats" json:"encoding_stats,omitempty"`
	BloomFilterOffset     *int64               `thrift:"bloom_filter_offset,14" db:"bloom_filter_offset" json:"bloom_filter_offset,omitempty"`
}

func NewColumnMetaData() *ColumnMetaData {
	return &ColumnMetaData{}
}

func (p *ColumnMetaData) GetType() Type {
	return p.Type
}

func (p *ColumnMetaData) GetEncodings() []Encoding {
	return p.Encodings
}

func (p *ColumnMetaData) GetPathInSchema() []string {
	return p.PathInSchema
}

func (p *ColumnMetaData) GetCodec() CompressionCodec {
	return p.Codec
}

func (p *ColumnMetaData) GetNumValues() int64 {
	return p.NumValues
}

func (p *ColumnMetaData) GetTotalUncompressedSize() int64 {
	return p.TotalUncompressedSize
}

func (p *ColumnMetaData) GetTotalCompressedSize() int64 {
	return p.TotalCompressedSize
}

var ColumnMetaData_KeyValueMetadata_DEFAULT []*KeyValue

func (p *ColumnMetaData) GetKeyValueMetadata() []*KeyValue {
	return p.KeyValueMetadata
}

func (p *ColumnMetaData) GetDataPageOffset() int64 {
	return p.DataPageOffset
}

var ColumnMetaData_IndexPageOffset_DEFAULT int64

func (p *ColumnMetaData) GetIndexPageOffset() int64 {
	if !p.IsSetIndexPageOffset() {
		return ColumnMetaData_IndexPageOffset_DEFAULT
	}
	return *p.IndexPageOffset
}

var ColumnMetaData_DictionaryPageOffset_DEFAULT int64

func (p *ColumnMetaData) GetDictionaryPageOffset() int64 {
	if !p.IsSetDictionaryPageOffset() {
		return ColumnMetaData_DictionaryPageOffset_DEFAULT
	}
	return *p.DictionaryPageOffset
}

var ColumnMetaData_Statistics_DEFAULT *Statistics

func (p *ColumnMetaData) GetStatistics() *Statistics {
	if !p.IsSetStatistics() {
		return ColumnMetaData_Statistics_DEFAULT
	}
	return p.Statistics
}

var ColumnMetaData_EncodingStats_DEFAULT []*PageEncodingStats

func (p *ColumnMetaData) GetEncodingStats() []*PageEncodingStats {
	return p.EncodingStats
}

var ColumnMetaData_BloomFilterOffset_DEFAULT int64

func (p *ColumnMetaData) GetBloomFilterOffset() int64 {
	if !p.IsSetBloomFilterOffset() {
		return ColumnMetaData_BloomFilterOffset_DEFAULT
	}
	return *p.BloomFilterOffset
}
func (p *ColumnMetaData) IsSetKeyValueMetadata() bool {
	return p.KeyValueMetadata != nil
}

func (p *ColumnMetaData) IsSetIndexPageOffset() bool {
	return p.IndexPageOffset != nil
}

func (p *ColumnMetaData) IsSetDictionaryPageOffset() bool {
	return p.DictionaryPageOffset != nil
}

func (p *ColumnMetaData) IsSetStatistics() bool {
	return p.Statistics != nil
}

func (p *ColumnMetaData) IsSetEncodingStats() bool {
	return p.EncodingStats != nil
}

func (p *ColumnMetaData) IsSetBloomFilterOffset() bool {
	return p.BloomFilterOffset != nil
}

func (p *ColumnMetaData) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetType bool = false
	var issetEncodings bool = false
	var issetPathInSchema bool = false
	var issetCodec bool = false
	var issetNumValues bool = false
	var issetTotalUncompressedSize bool = false
	var issetTotalCompressedSize bool = false
	var issetDataPageOffset bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetType = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetEncodings = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetPathInSchema = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetCodec = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetNumValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
				issetTotalUncompressedSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
				issetTotalCompressedSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
				issetDataPageOffset = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 10:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField10(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField11(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 12:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField12(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 13:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField13(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 14:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField14(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetType {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"))
	}
	if !issetEncodings {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"))
	}
	if !issetPathInSchema {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PathInSchema is not set"))
	}
	if !issetCodec {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Codec is not set"))
	}
	if !issetNumValues {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumValues is not set"))
	}
	if !issetTotalUncompressedSize {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TotalUncompressedSize is not set"))
	}
	if !issetTotalCompressedSize {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TotalCompressedSize is not set"))
	}
	if !issetDataPageOffset {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataPageOffset is not set"))
	}
	return nil
}

func (p *ColumnMetaData) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := Type(v)
		p.Type = temp
	}
	return nil
}

func (p *ColumnMetaData) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]Encoding, 0, size)
	p.Encodings = tSlice
	for i := 0; i < size; i++ {
		var _elem0 Encoding
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			temp := Encoding(v)
			_elem0 = temp
		}
		p.Encodings = append(p.Encodings, _elem0)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnMetaData) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.PathInSchema = tSlice
	for i := 0; i < size; i++ {
		var _elem1 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem1 = v
		}
		p.PathInSchema = append(p.PathInSchema, _elem1)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnMetaData) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		temp := CompressionCodec(v)
		p.Codec = temp
	}
	return nil
}

func (p *ColumnMetaData) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.NumValues = v
	}
	return nil
}

func (p *ColumnMetaData) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.TotalUncompressedSize = v
	}
	return nil
}

func (p *ColumnMetaData) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.TotalCompressedSize = v
	}
	return nil
}

func (p *ColumnMetaData) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*KeyValue, 0, size)
	p.KeyValueMetadata = tSlice
	for i := 0; i < size; i++ {
		_elem2 := &KeyValue{}
		if err := _elem2.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem2), err)
		}
		p.KeyValueMetadata = append(p.KeyValueMetadata, _elem2)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnMetaData) ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 9: ", err)
	} else {
		p.DataPageOffset = v
	}
	return nil
}

func (p *ColumnMetaData) ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 10: ", err)
	} else {
		p.IndexPageOffset = &v
	}
	return nil
}

func (p *ColumnMetaData) ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 11: ", err)
	} else {
		p.DictionaryPageOffset = &v
	}
	return nil
}

func (p *ColumnMetaData) ReadField12(ctx context.Context, iprot thrift.TProtocol) error {
	p.Statistics = &Statistics{}
	if err := p.Statistics.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Statistics), err)
	}
	return nil
}

func (p *ColumnMetaData) ReadField13(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*PageEncodingStats, 0, size)
	p.EncodingStats = tSlice
	for i := 0; i < size; i++ {
		_elem3 := &PageEncodingStats{}
		if err := _elem3.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem3), err)
		}
		p.EncodingStats = append(p.EncodingStats, _elem3)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnMetaData) ReadField14(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 14: ", err)
	} else {
		p.BloomFilterOffset = &v
	}
	return nil
}

func (p *ColumnMetaData) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ColumnMetaData"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField9(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField10(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField11(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField12(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField13(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField14(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ColumnMetaData) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "type", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:type: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Type)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.type (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:type: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:encodings: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Encodings {
		if err := oprot.WriteI32(ctx, int32(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:encodings: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "path_in_schema", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:path_in_schema: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PathInSchema)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.PathInSchema {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:path_in_schema: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "codec", thrift.I32, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:codec: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Codec)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.codec (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:codec: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_values", thrift.I64, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:num_values: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.NumValues)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_values (5) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:num_values: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "total_uncompressed_size", thrift.I64, 6); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:total_uncompressed_size: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.TotalUncompressedSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.total_uncompressed_size (6) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 6:total_uncompressed_size: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "total_compressed_size", thrift.I64, 7); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:total_compressed_size: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.TotalCompressedSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.total_compressed_size (7) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 7:total_compressed_size: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetKeyValueMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "key_value_metadata", thrift.LIST, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:key_value_metadata: ", p), err)
		}
		if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.KeyValueMetadata)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.KeyValueMetadata {
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:key_value_metadata: ", p), err)
		}
	}
	return err
}

func (p *ColumnMetaData) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "data_page_offset", thrift.I64, 9); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:data_page_offset: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.DataPageOffset)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.data_page_offset (9) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 9:data_page_offset: ", p), err)
	}
	return err
}

func (p *ColumnMetaData) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetIndexPageOffset() {
		if err := oprot.WriteFieldBegin(ctx, "index_page_offset", thrift.I64, 10); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:index_page_offset: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.IndexPageOffset)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.index_page_offset (10) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 10:index_page_offset: ", p), err)
		}
	}
	return err
}

func (p *ColumnMetaData) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDictionaryPageOffset() {
		if err := oprot.WriteFieldBegin(ctx, "dictionary_page_offset", thrift.I64, 11); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:dictionary_page_offset: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.DictionaryPageOffset)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.dictionary_page_offset (11) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 11:dictionary_page_offset: ", p), err)
		}
	}
	return err
}

func (p *ColumnMetaData) writeField12(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetStatistics() {
		if err := oprot.WriteFieldBegin(ctx, "statistics", thrift.STRUCT, 12); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 12:statistics: ", p), err)
		}
		if err := p.Statistics.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Statistics), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 12:statistics: ", p), err)
		}
	}
	return err
}

func (p *ColumnMetaData) writeField13(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetEncodingStats() {
		if err := oprot.WriteFieldBegin(ctx, "encoding_stats", thrift.LIST, 13); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 13:encoding_stats: ", p), err)
		}
		if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.EncodingStats)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.EncodingStats {
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 13:encoding_stats: ", p), err)
		}
	}
	return err
}

func (p *ColumnMetaData) writeField14(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetBloomFilterOffset() {
		if err := oprot.WriteFieldBegin(ctx, "bloom_filter_offset", thrift.I64, 14); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 14:bloom_filter_offset: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.BloomFilterOffset)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.bloom_filter_offset (14) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 14:bloom_filter_offset: ", p), err)
		}
	}
	return err
}

func (p *ColumnMetaData) Equals(other *ColumnMetaData) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Type != other.Type {
		return false
	}
	if len(p.Encodings) != len(other.Encodings) {
		return false
	}
	for i, _tgt := range p.Encodings {
		_src4 := other.Encodings[i]
		if _tgt != _src4 {
			return false
		}
	}
	if len(p.PathInSchema) != len(other.PathInSchema) {
		return false
	}
	for i, _tgt := range p.PathInSchema {
		_src5 := other.PathInSchema[i]
		if _tgt != _src5 {
			return false
		}
	}
	if p.Codec != other.Codec {
		return false
	}
	if p.NumValues != other.NumValues {
		return false
	}
	if p.TotalUncompressedSize != other.TotalUncompressedSize {
		return false
	}
	if p.TotalCompressedSize != other.TotalCompressedSize {
		return false
	}
	if len(p.KeyValueMetadata) != len(other.KeyValueMetadata) {
		return false
	}
	for i, _tgt := range p.KeyValueMetadata {
		_src6 := other.KeyValueMetadata[i]
		if !_tgt.Equals(_src6) {
			return false
		}
	}
	if p.DataPageOffset != other.DataPageOffset {
		return false
	}
	if p.IndexPageOffset != other.IndexPageOffset {
		if p.IndexPageOffset == nil || other.IndexPageOffset == nil {
			return false
		}
		if (*p.IndexPageOffset) != (*other.IndexPageOffset) {
			return false
		}
	}
	if p.DictionaryPageOffset != other.DictionaryPageOffset {
		if p.DictionaryPageOffset == nil || other.DictionaryPageOffset == nil {
			return false
		}
		if (*p.DictionaryPageOffset) != (*other.DictionaryPageOffset) {
			return false
		}
	}
	if !p.Statistics.Equals(other.Statistics) {
		return false
	}
	if len(p.EncodingStats) != len(other.EncodingStats) {
		return false
	}
	for i, _tgt := range p.EncodingStats {
		_src7 := other.EncodingStats[i]
		if !_tgt.Equals(_src7) {
			return false
		}
	}
	if p.BloomFilterOffset != other.BloomFilterOffset {
		if p.BloomFilterOffset == nil || other.BloomFilterOffset == nil {
			return false
		}
		if (*p.BloomFilterOffset) != (*other.BloomFilterOffset) {
			return false
		}
	}
	return true
}

func (p *ColumnMetaData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ColumnMetaData(%+v)", *p)
}

type EncryptionWithFooterKey struct {
}

func NewEncryptionWithFooterKey() *EncryptionWithFooterKey {
	return &EncryptionWithFooterKey{}
}

func (p *EncryptionWithFooterKey) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *EncryptionWithFooterKey) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "EncryptionWithFooterKey"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *EncryptionWithFooterKey) Equals(other *EncryptionWithFooterKey) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *EncryptionWithFooterKey) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("EncryptionWithFooterKey(%+v)", *p)
}

// Attributes:
//  - PathInSchema: Column path in schema *
//  - KeyMetadata: Retrieval metadata of column encryption key *
type EncryptionWithColumnKey struct {
	PathInSchema []string `thrift:"path_in_schema,1,required" db:"path_in_schema" json:"path_in_schema"`
	KeyMetadata  []byte   `thrift:"key_metadata,2" db:"key_metadata" json:"key_metadata,omitempty"`
}

func NewEncryptionWithColumnKey() *EncryptionWithColumnKey {
	return &EncryptionWithColumnKey{}
}

func (p *EncryptionWithColumnKey) GetPathInSchema() []string {
	return p.PathInSchema
}

var EncryptionWithColumnKey_KeyMetadata_DEFAULT []byte

func (p *EncryptionWithColumnKey) GetKeyMetadata() []byte {
	return p.KeyMetadata
}
func (p *EncryptionWithColumnKey) IsSetKeyMetadata() bool {
	return p.KeyMetadata != nil
}

func (p *EncryptionWithColumnKey) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetPathInSchema bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetPathInSchema = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetPathInSchema {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PathInSchema is not set"))
	}
	return nil
}

func (p *EncryptionWithColumnKey) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.PathInSchema = tSlice
	for i := 0; i < size; i++ {
		var _elem8 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem8 = v
		}
		p.PathInSchema = append(p.PathInSchema, _elem8)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *EncryptionWithColumnKey) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.KeyMetadata = v
	}
	return nil
}

func (p *EncryptionWithColumnKey) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "EncryptionWithColumnKey"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *EncryptionWithColumnKey) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "path_in_schema", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path_in_schema: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PathInSchema)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.PathInSchema {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path_in_schema: ", p), err)
	}
	return err
}

func (p *EncryptionWithColumnKey) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetKeyMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "key_metadata", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:key_metadata: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.KeyMetadata); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.key_metadata (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:key_metadata: ", p), err)
		}
	}
	return err
}

func (p *EncryptionWithColumnKey) Equals(other *EncryptionWithColumnKey) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if len(p.PathInSchema) != len(other.PathInSchema) {
		return false
	}
	for i, _tgt := range p.PathInSchema {
		_src9 := other.PathInSchema[i]
		if _tgt != _src9 {
			return false
		}
	}
	if bytes.Compare(p.KeyMetadata, other.KeyMetadata) != 0 {
		return false
	}
	return true
}

func (p *EncryptionWithColumnKey) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("EncryptionWithColumnKey(%+v)", *p)
}

// Attributes:
//  - ENCRYPTION_WITH_FOOTER_KEY
//  - ENCRYPTION_WITH_COLUMN_KEY
type ColumnCryptoMetaData struct {
	ENCRYPTION_WITH_FOOTER_KEY *EncryptionWithFooterKey `thrift:"ENCRYPTION_WITH_FOOTER_KEY,1" db:"ENCRYPTION_WITH_FOOTER_KEY" json:"ENCRYPTION_WITH_FOOTER_KEY,omitempty"`
	ENCRYPTION_WITH_COLUMN_KEY *EncryptionWithColumnKey `thrift:"ENCRYPTION_WITH_COLUMN_KEY,2" db:"ENCRYPTION_WITH_COLUMN_KEY" json:"ENCRYPTION_WITH_COLUMN_KEY,omitempty"`
}

func NewColumnCryptoMetaData() *ColumnCryptoMetaData {
	return &ColumnCryptoMetaData{}
}

var ColumnCryptoMetaData_ENCRYPTION_WITH_FOOTER_KEY_DEFAULT *EncryptionWithFooterKey

func (p *ColumnCryptoMetaData) GetENCRYPTION_WITH_FOOTER_KEY() *EncryptionWithFooterKey {
	if !p.IsSetENCRYPTION_WITH_FOOTER_KEY() {
		return ColumnCryptoMetaData_ENCRYPTION_WITH_FOOTER_KEY_DEFAULT
	}
	return p.ENCRYPTION_WITH_FOOTER_KEY
}

var ColumnCryptoMetaData_ENCRYPTION_WITH_COLUMN_KEY_DEFAULT *EncryptionWithColumnKey

func (p *ColumnCryptoMetaData) GetENCRYPTION_WITH_COLUMN_KEY() *EncryptionWithColumnKey {
	if !p.IsSetENCRYPTION_WITH_COLUMN_KEY() {
		return ColumnCryptoMetaData_ENCRYPTION_WITH_COLUMN_KEY_DEFAULT
	}
	return p.ENCRYPTION_WITH_COLUMN_KEY
}
func (p *ColumnCryptoMetaData) CountSetFieldsColumnCryptoMetaData() int {
	count := 0
	if p.IsSetENCRYPTION_WITH_FOOTER_KEY() {
		count++
	}
	if p.IsSetENCRYPTION_WITH_COLUMN_KEY() {
		count++
	}
	return count

}

func (p *ColumnCryptoMetaData) IsSetENCRYPTION_WITH_FOOTER_KEY() bool {
	return p.ENCRYPTION_WITH_FOOTER_KEY != nil
}

func (p *ColumnCryptoMetaData) IsSetENCRYPTION_WITH_COLUMN_KEY() bool {
	return p.ENCRYPTION_WITH_COLUMN_KEY != nil
}

func (p *ColumnCryptoMetaData) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ColumnCryptoMetaData) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.ENCRYPTION_WITH_FOOTER_KEY = &EncryptionWithFooterKey{}
	if err := p.ENCRYPTION_WITH_FOOTER_KEY.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.ENCRYPTION_WITH_FOOTER_KEY), err)
	}
	return nil
}

func (p *ColumnCryptoMetaData) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.ENCRYPTION_WITH_COLUMN_KEY = &EncryptionWithColumnKey{}
	if err := p.ENCRYPTION_WITH_COLUMN_KEY.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.ENCRYPTION_WITH_COLUMN_KEY), err)
	}
	return nil
}

func (p *ColumnCryptoMetaData) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsColumnCryptoMetaData(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "ColumnCryptoMetaData"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ColumnCryptoMetaData) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetENCRYPTION_WITH_FOOTER_KEY() {
		if err := oprot.WriteFieldBegin(ctx, "ENCRYPTION_WITH_FOOTER_KEY", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:ENCRYPTION_WITH_FOOTER_KEY: ", p), err)
		}
		if err := p.ENCRYPTION_WITH_FOOTER_KEY.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.ENCRYPTION_WITH_FOOTER_KEY), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:ENCRYPTION_WITH_FOOTER_KEY: ", p), err)
		}
	}
	return err
}

func (p *ColumnCryptoMetaData) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetENCRYPTION_WITH_COLUMN_KEY() {
		if err := oprot.WriteFieldBegin(ctx, "ENCRYPTION_WITH_COLUMN_KEY", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:ENCRYPTION_WITH_COLUMN_KEY: ", p), err)
		}
		if err := p.ENCRYPTION_WITH_COLUMN_KEY.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.ENCRYPTION_WITH_COLUMN_KEY), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:ENCRYPTION_WITH_COLUMN_KEY: ", p), err)
		}
	}
	return err
}

func (p *ColumnCryptoMetaData) Equals(other *ColumnCryptoMetaData) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.ENCRYPTION_WITH_FOOTER_KEY.Equals(other.ENCRYPTION_WITH_FOOTER_KEY) {
		return false
	}
	if !p.ENCRYPTION_WITH_COLUMN_KEY.Equals(other.ENCRYPTION_WITH_COLUMN_KEY) {
		return false
	}
	return true
}

func (p *ColumnCryptoMetaData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ColumnCryptoMetaData(%+v)", *p)
}

// Attributes:
//  - FilePath: File where column data is stored.  If not set, assumed to be same file as
// metadata.  This path is relative to the current file.
//
//  - FileOffset: Byte offset in file_path to the ColumnMetaData *
//  - MetaData: Column metadata for this chunk. This is the same content as what is at
// file_path/file_offset.  Having it here has it replicated in the file
// metadata.
//
//  - OffsetIndexOffset: File offset of ColumnChunk's OffsetIndex *
//  - OffsetIndexLength: Size of ColumnChunk's OffsetIndex, in bytes *
//  - ColumnIndexOffset: File offset of ColumnChunk's ColumnIndex *
//  - ColumnIndexLength: Size of ColumnChunk's ColumnIndex, in bytes *
//  - CryptoMetadata: Crypto metadata of encrypted columns *
//  - EncryptedColumnMetadata: Encrypted column metadata for this chunk *
type ColumnChunk struct {
	FilePath                *string               `thrift:"file_path,1" db:"file_path" json:"file_path,omitempty"`
	FileOffset              int64                 `thrift:"file_offset,2,required" db:"file_offset" json:"file_offset"`
	MetaData                *ColumnMetaData       `thrift:"meta_data,3" db:"meta_data" json:"meta_data,omitempty"`
	OffsetIndexOffset       *int64                `thrift:"offset_index_offset,4" db:"offset_index_offset" json:"offset_index_offset,omitempty"`
	OffsetIndexLength       *int32                `thrift:"offset_index_length,5" db:"offset_index_length" json:"offset_index_length,omitempty"`
	ColumnIndexOffset       *int64                `thrift:"column_index_offset,6" db:"column_index_offset" json:"column_index_offset,omitempty"`
	ColumnIndexLength       *int32                `thrift:"column_index_length,7" db:"column_index_length" json:"column_index_length,omitempty"`
	CryptoMetadata          *ColumnCryptoMetaData `thrift:"crypto_metadata,8" db:"crypto_metadata" json:"crypto_metadata,omitempty"`
	EncryptedColumnMetadata []byte                `thrift:"encrypted_column_metadata,9" db:"encrypted_column_metadata" json:"encrypted_column_metadata,omitempty"`
}

func NewColumnChunk() *ColumnChunk {
	return &ColumnChunk{}
}

var ColumnChunk_FilePath_DEFAULT string

func (p *ColumnChunk) GetFilePath() string {
	if !p.IsSetFilePath() {
		return ColumnChunk_FilePath_DEFAULT
	}
	return *p.FilePath
}

func (p *ColumnChunk) GetFileOffset() int64 {
	return p.FileOffset
}

var ColumnChunk_MetaData_DEFAULT *ColumnMetaData

func (p *ColumnChunk) GetMetaData() *ColumnMetaData {
	if !p.IsSetMetaData() {
		return ColumnChunk_MetaData_DEFAULT
	}
	return p.MetaData
}

var ColumnChunk_OffsetIndexOffset_DEFAULT int64

func (p *ColumnChunk) GetOffsetIndexOffset() int64 {
	if !p.IsSetOffsetIndexOffset() {
		return ColumnChunk_OffsetIndexOffset_DEFAULT
	}
	return *p.OffsetIndexOffset
}

var ColumnChunk_OffsetIndexLength_DEFAULT int32

func (p *ColumnChunk) GetOffsetIndexLength() int32 {
	if !p.IsSetOffsetIndexLength() {
		return ColumnChunk_OffsetIndexLength_DEFAULT
	}
	return *p.OffsetIndexLength
}

var ColumnChunk_ColumnIndexOffset_DEFAULT int64

func (p *ColumnChunk) GetColumnIndexOffset() int64 {
	if !p.IsSetColumnIndexOffset() {
		return ColumnChunk_ColumnIndexOffset_DEFAULT
	}
	return *p.ColumnIndexOffset
}

var ColumnChunk_ColumnIndexLength_DEFAULT int32

func (p *ColumnChunk) GetColumnIndexLength() int32 {
	if !p.IsSetColumnIndexLength() {
		return ColumnChunk_ColumnIndexLength_DEFAULT
	}
	return *p.ColumnIndexLength
}

var ColumnChunk_CryptoMetadata_DEFAULT *ColumnCryptoMetaData

func (p *ColumnChunk) GetCryptoMetadata() *ColumnCryptoMetaData {
	if !p.IsSetCryptoMetadata() {
		return ColumnChunk_CryptoMetadata_DEFAULT
	}
	return p.CryptoMetadata
}

var ColumnChunk_EncryptedColumnMetadata_DEFAULT []byte

func (p *ColumnChunk) GetEncryptedColumnMetadata() []byte {
	return p.EncryptedColumnMetadata
}
func (p *ColumnChunk) IsSetFilePath() bool {
	return p.FilePath != nil
}

func (p *ColumnChunk) IsSetMetaData() bool {
	return p.MetaData != nil
}

func (p *ColumnChunk) IsSetOffsetIndexOffset() bool {
	return p.OffsetIndexOffset != nil
}

func (p *ColumnChunk) IsSetOffsetIndexLength() bool {
	return p.OffsetIndexLength != nil
}

func (p *ColumnChunk) IsSetColumnIndexOffset() bool {
	return p.ColumnIndexOffset != nil
}

func (p *ColumnChunk) IsSetColumnIndexLength() bool {
	return p.ColumnIndexLength != nil
}

func (p *ColumnChunk) IsSetCryptoMetadata() bool {
	return p.CryptoMetadata != nil
}

func (p *ColumnChunk) IsSetEncryptedColumnMetadata() bool {
	return p.EncryptedColumnMetadata != nil
}

func (p *ColumnChunk) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetFileOffset bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetFileOffset = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetFileOffset {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FileOffset is not set"))
	}
	return nil
}

func (p *ColumnChunk) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.FilePath = &v
	}
	return nil
}

func (p *ColumnChunk) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.FileOffset = v
	}
	return nil
}

func (p *ColumnChunk) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	p.MetaData = &ColumnMetaData{}
	if err := p.MetaData.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.MetaData), err)
	}
	return nil
}

func (p *ColumnChunk) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.OffsetIndexOffset = &v
	}
	return nil
}

func (p *ColumnChunk) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.OffsetIndexLength = &v
	}
	return nil
}

func (p *ColumnChunk) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.ColumnIndexOffset = &v
	}
	return nil
}

func (p *ColumnChunk) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.ColumnIndexLength = &v
	}
	return nil
}

func (p *ColumnChunk) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	p.CryptoMetadata = &ColumnCryptoMetaData{}
	if err := p.CryptoMetadata.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.CryptoMetadata), err)
	}
	return nil
}

func (p *ColumnChunk) ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 9: ", err)
	} else {
		p.EncryptedColumnMetadata = v
	}
	return nil
}

func (p *ColumnChunk) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ColumnChunk"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField9(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ColumnChunk) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetFilePath() {
		if err := oprot.WriteFieldBegin(ctx, "file_path", thrift.STRING, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:file_path: ", p), err)
		}
		if err := oprot.WriteString(ctx, string(*p.FilePath)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.file_path (1) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:file_path: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "file_offset", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:file_offset: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.FileOffset)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.file_offset (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:file_offset: ", p), err)
	}
	return err
}

func (p *ColumnChunk) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMetaData() {
		if err := oprot.WriteFieldBegin(ctx, "meta_data", thrift.STRUCT, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:meta_data: ", p), err)
		}
		if err := p.MetaData.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.MetaData), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:meta_data: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetOffsetIndexOffset() {
		if err := oprot.WriteFieldBegin(ctx, "offset_index_offset", thrift.I64, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:offset_index_offset: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.OffsetIndexOffset)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.offset_index_offset (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:offset_index_offset: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetOffsetIndexLength() {
		if err := oprot.WriteFieldBegin(ctx, "offset_index_length", thrift.I32, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:offset_index_length: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.OffsetIndexLength)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.offset_index_length (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:offset_index_length: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumnIndexOffset() {
		if err := oprot.WriteFieldBegin(ctx, "column_index_offset", thrift.I64, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:column_index_offset: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.ColumnIndexOffset)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.column_index_offset (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:column_index_offset: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumnIndexLength() {
		if err := oprot.WriteFieldBegin(ctx, "column_index_length", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:column_index_length: ", p), err)
		}
		if err := oprot.WriteI32(ctx, int32(*p.ColumnIndexLength)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.column_index_length (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:column_index_length: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetCryptoMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "crypto_metadata", thrift.STRUCT, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:crypto_metadata: ", p), err)
		}
		if err := p.CryptoMetadata.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.CryptoMetadata), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:crypto_metadata: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetEncryptedColumnMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "encrypted_column_metadata", thrift.STRING, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:encrypted_column_metadata: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.EncryptedColumnMetadata); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.encrypted_column_metadata (9) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:encrypted_column_metadata: ", p), err)
		}
	}
	return err
}

func (p *ColumnChunk) Equals(other *ColumnChunk) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.FilePath != other.FilePath {
		if p.FilePath == nil || other.FilePath == nil {
			return false
		}
		if (*p.FilePath) != (*other.FilePath) {
			return false
		}
	}
	if p.FileOffset != other.FileOffset {
		return false
	}
	if !p.MetaData.Equals(other.MetaData) {
		return false
	}
	if p.OffsetIndexOffset != other.OffsetIndexOffset {
		if p.OffsetIndexOffset == nil || other.OffsetIndexOffset == nil {
			return false
		}
		if (*p.OffsetIndexOffset) != (*other.OffsetIndexOffset) {
			return false
		}
	}
	if p.OffsetIndexLength != other.OffsetIndexLength {
		if p.OffsetIndexLength == nil || other.OffsetIndexLength == nil {
			return false
		}
		if (*p.OffsetIndexLength) != (*other.OffsetIndexLength) {
			return false
		}
	}
	if p.ColumnIndexOffset != other.ColumnIndexOffset {
		if p.ColumnIndexOffset == nil || other.ColumnIndexOffset == nil {
			return false
		}
		if (*p.ColumnIndexOffset) != (*other.ColumnIndexOffset) {
			return false
		}
	}
	if p.ColumnIndexLength != other.ColumnIndexLength {
		if p.ColumnIndexLength == nil || other.ColumnIndexLength == nil {
			return false
		}
		if (*p.ColumnIndexLength) != (*other.ColumnIndexLength) {
			return false
		}
	}
	if !p.CryptoMetadata.Equals(other.CryptoMetadata) {
		return false
	}
	if bytes.Compare(p.EncryptedColumnMetadata, other.EncryptedColumnMetadata) != 0 {
		return false
	}
	return true
}

func (p *ColumnChunk) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ColumnChunk(%+v)", *p)
}

// Attributes:
//  - Columns: Metadata for each column chunk in this row group.
// This list must have the same order as the SchemaElement list in FileMetaData.
//
//  - TotalByteSize: Total byte size of all the uncompressed column data in this row group *
//  - NumRows: Number of rows in this row group *
//  - SortingColumns: If set, specifies a sort ordering of the rows in this RowGroup.
// The sorting columns can be a subset of all the columns.
//  - FileOffset: Byte offset from beginning of file to first page (data or dictionary)
// in this row group *
//  - TotalCompressedSize: Total byte size of all compressed (and potentially encrypted) column data
// in this row group *
//  - Ordinal: Row group ordinal in the file *
type RowGroup struct {
	Columns             []*ColumnChunk   `thrift:"columns,1,required" db:"columns" json:"columns"`
	TotalByteSize       int64            `thrift:"total_byte_size,2,required" db:"total_byte_size" json:"total_byte_size"`
	NumRows             int64            `thrift:"num_rows,3,required" db:"num_rows" json:"num_rows"`
	SortingColumns      []*SortingColumn `thrift:"sorting_columns,4" db:"sorting_columns" json:"sorting_columns,omitempty"`
	FileOffset          *int64           `thrift:"file_offset,5" db:"file_offset" json:"file_offset,omitempty"`
	TotalCompressedSize *int64           `thrift:"total_compressed_size,6" db:"total_compressed_size" json:"total_compressed_size,omitempty"`
	Ordinal             *int16           `thrift:"ordinal,7" db:"ordinal" json:"ordinal,omitempty"`
}

func NewRowGroup() *RowGroup {
	return &RowGroup{}
}

func (p *RowGroup) GetColumns() []*ColumnChunk {
	return p.Columns
}

func (p *RowGroup) GetTotalByteSize() int64 {
	return p.TotalByteSize
}

func (p *RowGroup) GetNumRows() int64 {
	return p.NumRows
}

var RowGroup_SortingColumns_DEFAULT []*SortingColumn

func (p *RowGroup) GetSortingColumns() []*SortingColumn {
	return p.SortingColumns
}

var RowGroup_FileOffset_DEFAULT int64

func (p *RowGroup) GetFileOffset() int64 {
	if !p.IsSetFileOffset() {
		return RowGroup_FileOffset_DEFAULT
	}
	return *p.FileOffset
}

var RowGroup_TotalCompressedSize_DEFAULT int64

func (p *RowGroup) GetTotalCompressedSize() int64 {
	if !p.IsSetTotalCompressedSize() {
		return RowGroup_TotalCompressedSize_DEFAULT
	}
	return *p.TotalCompressedSize
}

var RowGroup_Ordinal_DEFAULT int16

func (p *RowGroup) GetOrdinal() int16 {
	if !p.IsSetOrdinal() {
		return RowGroup_Ordinal_DEFAULT
	}
	return *p.Ordinal
}
func (p *RowGroup) IsSetSortingColumns() bool {
	return p.SortingColumns != nil
}

func (p *RowGroup) IsSetFileOffset() bool {
	return p.FileOffset != nil
}

func (p *RowGroup) IsSetTotalCompressedSize() bool {
	return p.TotalCompressedSize != nil
}

func (p *RowGroup) IsSetOrdinal() bool {
	return p.Ordinal != nil
}

func (p *RowGroup) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetColumns bool = false
	var issetTotalByteSize bool = false
	var issetNumRows bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetColumns = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetTotalByteSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetNumRows = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.I16 {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetColumns {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Columns is not set"))
	}
	if !issetTotalByteSize {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TotalByteSize is not set"))
	}
	if !issetNumRows {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumRows is not set"))
	}
	return nil
}

func (p *RowGroup) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*ColumnChunk, 0, size)
	p.Columns = tSlice
	for i := 0; i < size; i++ {
		_elem10 := &ColumnChunk{}
		if err := _elem10.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem10), err)
		}
		p.Columns = append(p.Columns, _elem10)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *RowGroup) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.TotalByteSize = v
	}
	return nil
}

func (p *RowGroup) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NumRows = v
	}
	return nil
}

func (p *RowGroup) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*SortingColumn, 0, size)
	p.SortingColumns = tSlice
	for i := 0; i < size; i++ {
		_elem11 := &SortingColumn{}
		if err := _elem11.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem11), err)
		}
		p.SortingColumns = append(p.SortingColumns, _elem11)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *RowGroup) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.FileOffset = &v
	}
	return nil
}

func (p *RowGroup) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.TotalCompressedSize = &v
	}
	return nil
}

func (p *RowGroup) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI16(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.Ordinal = &v
	}
	return nil
}

func (p *RowGroup) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "RowGroup"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *RowGroup) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "columns", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:columns: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.Columns)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Columns {
		if err := v.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:columns: ", p), err)
	}
	return err
}

func (p *RowGroup) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "total_byte_size", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:total_byte_size: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.TotalByteSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.total_byte_size (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:total_byte_size: ", p), err)
	}
	return err
}

func (p *RowGroup) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_rows", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:num_rows: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.NumRows)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_rows (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:num_rows: ", p), err)
	}
	return err
}

func (p *RowGroup) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSortingColumns() {
		if err := oprot.WriteFieldBegin(ctx, "sorting_columns", thrift.LIST, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:sorting_columns: ", p), err)
		}
		if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.SortingColumns)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.SortingColumns {
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:sorting_columns: ", p), err)
		}
	}
	return err
}

func (p *RowGroup) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetFileOffset() {
		if err := oprot.WriteFieldBegin(ctx, "file_offset", thrift.I64, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:file_offset: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.FileOffset)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.file_offset (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:file_offset: ", p), err)
		}
	}
	return err
}

func (p *RowGroup) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalCompressedSize() {
		if err := oprot.WriteFieldBegin(ctx, "total_compressed_size", thrift.I64, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:total_compressed_size: ", p), err)
		}
		if err := oprot.WriteI64(ctx, int64(*p.TotalCompressedSize)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.total_compressed_size (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:total_compressed_size: ", p), err)
		}
	}
	return err
}

func (p *RowGroup) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetOrdinal() {
		if err := oprot.WriteFieldBegin(ctx, "ordinal", thrift.I16, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:ordinal: ", p), err)
		}
		if err := oprot.WriteI16(ctx, int16(*p.Ordinal)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.ordinal (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:ordinal: ", p), err)
		}
	}
	return err
}

func (p *RowGroup) Equals(other *RowGroup) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if len(p.Columns) != len(other.Columns) {
		return false
	}
	for i, _tgt := range p.Columns {
		_src12 := other.Columns[i]
		if !_tgt.Equals(_src12) {
			return false
		}
	}
	if p.TotalByteSize != other.TotalByteSize {
		return false
	}
	if p.NumRows != other.NumRows {
		return false
	}
	if len(p.SortingColumns) != len(other.SortingColumns) {
		return false
	}
	for i, _tgt := range p.SortingColumns {
		_src13 := other.SortingColumns[i]
		if !_tgt.Equals(_src13) {
			return false
		}
	}
	if p.FileOffset != other.FileOffset {
		if p.FileOffset == nil || other.FileOffset == nil {
			return false
		}
		if (*p.FileOffset) != (*other.FileOffset) {
			return false
		}
	}
	if p.TotalCompressedSize != other.TotalCompressedSize {
		if p.TotalCompressedSize == nil || other.TotalCompressedSize == nil {
			return false
		}
		if (*p.TotalCompressedSize) != (*other.TotalCompressedSize) {
			return false
		}
	}
	if p.Ordinal != other.Ordinal {
		if p.Ordinal == nil || other.Ordinal == nil {
			return false
		}
		if (*p.Ordinal) != (*other.Ordinal) {
			return false
		}
	}
	return true
}

func (p *RowGroup) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("RowGroup(%+v)", *p)
}

// Empty struct to signal the order defined by the physical or logical type
type TypeDefinedOrder struct {
}

func NewTypeDefinedOrder() *TypeDefinedOrder {
	return &TypeDefinedOrder{}
}

func (p *TypeDefinedOrder) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TypeDefinedOrder) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TypeDefinedOrder"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TypeDefinedOrder) Equals(other *TypeDefinedOrder) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	return true
}

func (p *TypeDefinedOrder) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TypeDefinedOrder(%+v)", *p)
}

// Union to specify the order used for the min_value and max_value fields for a
// column. This union takes the role of an enhanced enum that allows rich
// elements (which will be needed for a collation-based ordering in the future).
//
// Possible values are:
// * TypeDefinedOrder - the column uses the order defined by its logical or
//                      physical type (if there is no logical type).
//
// If the reader does not support the value of this union, min and max stats
// for this column should be ignored.
//
// Attributes:
//  - TYPE_ORDER: The sort orders for logical types are:
//   UTF8 - unsigned byte-wise comparison
//   INT8 - signed comparison
//   INT16 - signed comparison
//   INT32 - signed comparison
//   INT64 - signed comparison
//   UINT8 - unsigned comparison
//   UINT16 - unsigned comparison
//   UINT32 - unsigned comparison
//   UINT64 - unsigned comparison
//   DECIMAL - signed comparison of the represented value
//   DATE - signed comparison
//   TIME_MILLIS - signed comparison
//   TIME_MICROS - signed comparison
//   TIMESTAMP_MILLIS - signed comparison
//   TIMESTAMP_MICROS - signed comparison
//   INTERVAL - unsigned comparison
//   JSON - unsigned byte-wise comparison
//   BSON - unsigned byte-wise comparison
//   ENUM - unsigned byte-wise comparison
//   LIST - undefined
//   MAP - undefined
//
// In the absence of logical types, the sort order is determined by the physical type:
//   BOOLEAN - false, true
//   INT32 - signed comparison
//   INT64 - signed comparison
//   INT96 (only used for legacy timestamps) - undefined
//   FLOAT - signed comparison of the represented value (*)
//   DOUBLE - signed comparison of the represented value (*)
//   BYTE_ARRAY - unsigned byte-wise comparison
//   FIXED_LEN_BYTE_ARRAY - unsigned byte-wise comparison
//
// (*) Because the sorting order is not specified properly for floating
//     point values (relations vs. total ordering) the following
//     compatibility rules should be applied when reading statistics:
//     - If the min is a NaN, it should be ignored.
//     - If the max is a NaN, it should be ignored.
//     - If the min is +0, the row group may contain -0 values as well.
//     - If the max is -0, the row group may contain +0 values as well.
//     - When looking for NaN values, min and max should be ignored.
type ColumnOrder struct {
	TYPE_ORDER *TypeDefinedOrder `thrift:"TYPE_ORDER,1" db:"TYPE_ORDER" json:"TYPE_ORDER,omitempty"`
}

func NewColumnOrder() *ColumnOrder {
	return &ColumnOrder{}
}

var ColumnOrder_TYPE_ORDER_DEFAULT *TypeDefinedOrder

func (p *ColumnOrder) GetTYPE_ORDER() *TypeDefinedOrder {
	if !p.IsSetTYPE_ORDER() {
		return ColumnOrder_TYPE_ORDER_DEFAULT
	}
	return p.TYPE_ORDER
}
func (p *ColumnOrder) CountSetFieldsColumnOrder() int {
	count := 0
	if p.IsSetTYPE_ORDER() {
		count++
	}
	return count

}

func (p *ColumnOrder) IsSetTYPE_ORDER() bool {
	return p.TYPE_ORDER != nil
}

func (p *ColumnOrder) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ColumnOrder) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.TYPE_ORDER = &TypeDefinedOrder{}
	if err := p.TYPE_ORDER.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.TYPE_ORDER), err)
	}
	return nil
}

func (p *ColumnOrder) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsColumnOrder(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "ColumnOrder"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ColumnOrder) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTYPE_ORDER() {
		if err := oprot.WriteFieldBegin(ctx, "TYPE_ORDER", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:TYPE_ORDER: ", p), err)
		}
		if err := p.TYPE_ORDER.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.TYPE_ORDER), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:TYPE_ORDER: ", p), err)
		}
	}
	return err
}

func (p *ColumnOrder) Equals(other *ColumnOrder) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.TYPE_ORDER.Equals(other.TYPE_ORDER) {
		return false
	}
	return true
}

func (p *ColumnOrder) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ColumnOrder(%+v)", *p)
}

// Attributes:
//  - Offset: Offset of the page in the file *
//  - CompressedPageSize: Size of the page, including header. Sum of compressed_page_size and header
// length
//  - FirstRowIndex: Index within the RowGroup of the first row of the page; this means pages
// change on record boundaries (r = 0).
type PageLocation struct {
	Offset             int64 `thrift:"offset,1,required" db:"offset" json:"offset"`
	CompressedPageSize int32 `thrift:"compressed_page_size,2,required" db:"compressed_page_size" json:"compressed_page_size"`
	FirstRowIndex      int64 `thrift:"first_row_index,3,required" db:"first_row_index" json:"first_row_index"`
}

func NewPageLocation() *PageLocation {
	return &PageLocation{}
}

func (p *PageLocation) GetOffset() int64 {
	return p.Offset
}

func (p *PageLocation) GetCompressedPageSize() int32 {
	return p.CompressedPageSize
}

func (p *PageLocation) GetFirstRowIndex() int64 {
	return p.FirstRowIndex
}
func (p *PageLocation) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetOffset bool = false
	var issetCompressedPageSize bool = false
	var issetFirstRowIndex bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetOffset = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetCompressedPageSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetFirstRowIndex = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetOffset {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Offset is not set"))
	}
	if !issetCompressedPageSize {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CompressedPageSize is not set"))
	}
	if !issetFirstRowIndex {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FirstRowIndex is not set"))
	}
	return nil
}

func (p *PageLocation) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Offset = v
	}
	return nil
}

func (p *PageLocation) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.CompressedPageSize = v
	}
	return nil
}

func (p *PageLocation) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.FirstRowIndex = v
	}
	return nil
}

func (p *PageLocation) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "PageLocation"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *PageLocation) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "offset", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:offset: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.Offset)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.offset (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:offset: ", p), err)
	}
	return err
}

func (p *PageLocation) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "compressed_page_size", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:compressed_page_size: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.CompressedPageSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.compressed_page_size (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:compressed_page_size: ", p), err)
	}
	return err
}

func (p *PageLocation) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "first_row_index", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:first_row_index: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.FirstRowIndex)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.first_row_index (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:first_row_index: ", p), err)
	}
	return err
}

func (p *PageLocation) Equals(other *PageLocation) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Offset != other.Offset {
		return false
	}
	if p.CompressedPageSize != other.CompressedPageSize {
		return false
	}
	if p.FirstRowIndex != other.FirstRowIndex {
		return false
	}
	return true
}

func (p *PageLocation) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PageLocation(%+v)", *p)
}

// Attributes:
//  - PageLocations: PageLocations, ordered by increasing PageLocation.offset. It is required
// that page_locations[i].first_row_index < page_locations[i+1].first_row_index.
type OffsetIndex struct {
	PageLocations []*PageLocation `thrift:"page_locations,1,required" db:"page_locations" json:"page_locations"`
}

func NewOffsetIndex() *OffsetIndex {
	return &OffsetIndex{}
}

func (p *OffsetIndex) GetPageLocations() []*PageLocation {
	return p.PageLocations
}
func (p *OffsetIndex) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetPageLocations bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetPageLocations = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetPageLocations {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PageLocations is not set"))
	}
	return nil
}

func (p *OffsetIndex) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*PageLocation, 0, size)
	p.PageLocations = tSlice
	for i := 0; i < size; i++ {
		_elem14 := &PageLocation{}
		if err := _elem14.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem14), err)
		}
		p.PageLocations = append(p.PageLocations, _elem14)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *OffsetIndex) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "OffsetIndex"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *OffsetIndex) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "page_locations", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:page_locations: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.PageLocations)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.PageLocations {
		if err := v.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:page_locations: ", p), err)
	}
	return err
}

func (p *OffsetIndex) Equals(other *OffsetIndex) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if len(p.PageLocations) != len(other.PageLocations) {
		return false
	}
	for i, _tgt := range p.PageLocations {
		_src15 := other.PageLocations[i]
		if !_tgt.Equals(_src15) {
			return false
		}
	}
	return true
}

func (p *OffsetIndex) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("OffsetIndex(%+v)", *p)
}

// Description for ColumnIndex.
// Each <array-field>[i] refers to the page at OffsetIndex.page_locations[i]
//
// Attributes:
//  - NullPages: A list of Boolean values to determine the validity of the corresponding
// min and max values. If true, a page contains only null values, and writers
// have to set the corresponding entries in min_values and max_values to
// byte[0], so that all lists have the same length. If false, the
// corresponding entries in min_values and max_values must be valid.
//  - MinValues: Two lists containing lower and upper bounds for the values of each page.
// These may be the actual minimum and maximum values found on a page, but
// can also be (more compact) values that do not exist on a page. For
// example, instead of storing ""Blart Versenwald III", a writer may set
// min_values[i]="B", max_values[i]="C". Such more compact values must still
// be valid values within the column's logical type. Readers must make sure
// that list entries are populated before using them by inspecting null_pages.
//  - MaxValues
//  - BoundaryOrder: Stores whether both min_values and max_values are orderd and if so, in
// which direction. This allows readers to perform binary searches in both
// lists. Readers cannot assume that max_values[i] <= min_values[i+1], even
// if the lists are ordered.
//  - NullCounts: A list containing the number of null values for each page *
type ColumnIndex struct {
	NullPages     []bool        `thrift:"null_pages,1,required" db:"null_pages" json:"null_pages"`
	MinValues     [][]byte      `thrift:"min_values,2,required" db:"min_values" json:"min_values"`
	MaxValues     [][]byte      `thrift:"max_values,3,required" db:"max_values" json:"max_values"`
	BoundaryOrder BoundaryOrder `thrift:"boundary_order,4,required" db:"boundary_order" json:"boundary_order"`
	NullCounts    []int64       `thrift:"null_counts,5" db:"null_counts" json:"null_counts,omitempty"`
}

func NewColumnIndex() *ColumnIndex {
	return &ColumnIndex{}
}

func (p *ColumnIndex) GetNullPages() []bool {
	return p.NullPages
}

func (p *ColumnIndex) GetMinValues() [][]byte {
	return p.MinValues
}

func (p *ColumnIndex) GetMaxValues() [][]byte {
	return p.MaxValues
}

func (p *ColumnIndex) GetBoundaryOrder() BoundaryOrder {
	return p.BoundaryOrder
}

var ColumnIndex_NullCounts_DEFAULT []int64

func (p *ColumnIndex) GetNullCounts() []int64 {
	return p.NullCounts
}
func (p *ColumnIndex) IsSetNullCounts() bool {
	return p.NullCounts != nil
}

func (p *ColumnIndex) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNullPages bool = false
	var issetMinValues bool = false
	var issetMaxValues bool = false
	var issetBoundaryOrder bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetNullPages = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetMinValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMaxValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetBoundaryOrder = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNullPages {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NullPages is not set"))
	}
	if !issetMinValues {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MinValues is not set"))
	}
	if !issetMaxValues {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MaxValues is not set"))
	}
	if !issetBoundaryOrder {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field BoundaryOrder is not set"))
	}
	return nil
}

func (p *ColumnIndex) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]bool, 0, size)
	p.NullPages = tSlice
	for i := 0; i < size; i++ {
		var _elem16 bool
		if v, err := iprot.ReadBool(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem16 = v
		}
		p.NullPages = append(p.NullPages, _elem16)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnIndex) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.MinValues = tSlice
	for i := 0; i < size; i++ {
		var _elem17 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem17 = v
		}
		p.MinValues = append(p.MinValues, _elem17)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnIndex) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.MaxValues = tSlice
	for i := 0; i < size; i++ {
		var _elem18 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem18 = v
		}
		p.MaxValues = append(p.MaxValues, _elem18)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnIndex) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		temp := BoundaryOrder(v)
		p.BoundaryOrder = temp
	}
	return nil
}

func (p *ColumnIndex) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int64, 0, size)
	p.NullCounts = tSlice
	for i := 0; i < size; i++ {
		var _elem19 int64
		if v, err := iprot.ReadI64(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem19 = v
		}
		p.NullCounts = append(p.NullCounts, _elem19)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ColumnIndex) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ColumnIndex"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ColumnIndex) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "null_pages", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:null_pages: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.BOOL, len(p.NullPages)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.NullPages {
		if err := oprot.WriteBool(ctx, bool(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:null_pages: ", p), err)
	}
	return err
}

func (p *ColumnIndex) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "min_values", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:min_values: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MinValues)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.MinValues {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:min_values: ", p), err)
	}
	return err
}

func (p *ColumnIndex) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "max_values", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:max_values: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MaxValues)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.MaxValues {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:max_values: ", p), err)
	}
	return err
}

func (p *ColumnIndex) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "boundary_order", thrift.I32, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:boundary_order: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.BoundaryOrder)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.boundary_order (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:boundary_order: ", p), err)
	}
	return err
}

func (p *ColumnIndex) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetNullCounts() {
		if err := oprot.WriteFieldBegin(ctx, "null_counts", thrift.LIST, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:null_counts: ", p), err)
		}
		if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.NullCounts)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.NullCounts {
			if err := oprot.WriteI64(ctx, int64(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:null_counts: ", p), err)
		}
	}
	return err
}

func (p *ColumnIndex) Equals(other *ColumnIndex) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if len(p.NullPages) != len(other.NullPages) {
		return false
	}
	for i, _tgt := range p.NullPages {
		_src20 := other.NullPages[i]
		if _tgt != _src20 {
			return false
		}
	}
	if len(p.MinValues) != len(other.MinValues) {
		return false
	}
	for i, _tgt := range p.MinValues {
		_src21 := other.MinValues[i]
		if bytes.Compare(_tgt, _src21) != 0 {
			return false
		}
	}
	if len(p.MaxValues) != len(other.MaxValues) {
		return false
	}
	for i, _tgt := range p.MaxValues {
		_src22 := other.MaxValues[i]
		if bytes.Compare(_tgt, _src22) != 0 {
			return false
		}
	}
	if p.BoundaryOrder != other.BoundaryOrder {
		return false
	}
	if len(p.NullCounts) != len(other.NullCounts) {
		return false
	}
	for i, _tgt := range p.NullCounts {
		_src23 := other.NullCounts[i]
		if _tgt != _src23 {
			return false
		}
	}
	return true
}

func (p *ColumnIndex) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ColumnIndex(%+v)", *p)
}

// Attributes:
//  - AadPrefix: AAD prefix *
//  - AadFileUnique: Unique file identifier part of AAD suffix *
//  - SupplyAadPrefix: In files encrypted with AAD prefix without storing it,
// readers must supply the prefix *
type AesGcmV1 struct {
	AadPrefix       []byte `thrift:"aad_prefix,1" db:"aad_prefix" json:"aad_prefix,omitempty"`
	AadFileUnique   []byte `thrift:"aad_file_unique,2" db:"aad_file_unique" json:"aad_file_unique,omitempty"`
	SupplyAadPrefix *bool  `thrift:"supply_aad_prefix,3" db:"supply_aad_prefix" json:"supply_aad_prefix,omitempty"`
}

func NewAesGcmV1() *AesGcmV1 {
	return &AesGcmV1{}
}

var AesGcmV1_AadPrefix_DEFAULT []byte

func (p *AesGcmV1) GetAadPrefix() []byte {
	return p.AadPrefix
}

var AesGcmV1_AadFileUnique_DEFAULT []byte

func (p *AesGcmV1) GetAadFileUnique() []byte {
	return p.AadFileUnique
}

var AesGcmV1_SupplyAadPrefix_DEFAULT bool

func (p *AesGcmV1) GetSupplyAadPrefix() bool {
	if !p.IsSetSupplyAadPrefix() {
		return AesGcmV1_SupplyAadPrefix_DEFAULT
	}
	return *p.SupplyAadPrefix
}
func (p *AesGcmV1) IsSetAadPrefix() bool {
	return p.AadPrefix != nil
}

func (p *AesGcmV1) IsSetAadFileUnique() bool {
	return p.AadFileUnique != nil
}

func (p *AesGcmV1) IsSetSupplyAadPrefix() bool {
	return p.SupplyAadPrefix != nil
}

func (p *AesGcmV1) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *AesGcmV1) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.AadPrefix = v
	}
	return nil
}

func (p *AesGcmV1) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.AadFileUnique = v
	}
	return nil
}

func (p *AesGcmV1) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.SupplyAadPrefix = &v
	}
	return nil
}

func (p *AesGcmV1) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "AesGcmV1"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AesGcmV1) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAadPrefix() {
		if err := oprot.WriteFieldBegin(ctx, "aad_prefix", thrift.STRING, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:aad_prefix: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.AadPrefix); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.aad_prefix (1) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:aad_prefix: ", p), err)
		}
	}
	return err
}

func (p *AesGcmV1) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAadFileUnique() {
		if err := oprot.WriteFieldBegin(ctx, "aad_file_unique", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:aad_file_unique: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.AadFileUnique); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.aad_file_unique (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:aad_file_unique: ", p), err)
		}
	}
	return err
}

func (p *AesGcmV1) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSupplyAadPrefix() {
		if err := oprot.WriteFieldBegin(ctx, "supply_aad_prefix", thrift.BOOL, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:supply_aad_prefix: ", p), err)
		}
		if err := oprot.WriteBool(ctx, bool(*p.SupplyAadPrefix)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.supply_aad_prefix (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:supply_aad_prefix: ", p), err)
		}
	}
	return err
}

func (p *AesGcmV1) Equals(other *AesGcmV1) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if bytes.Compare(p.AadPrefix, other.AadPrefix) != 0 {
		return false
	}
	if bytes.Compare(p.AadFileUnique, other.AadFileUnique) != 0 {
		return false
	}
	if p.SupplyAadPrefix != other.SupplyAadPrefix {
		if p.SupplyAadPrefix == nil || other.SupplyAadPrefix == nil {
			return false
		}
		if (*p.SupplyAadPrefix) != (*other.SupplyAadPrefix) {
			return false
		}
	}
	return true
}

func (p *AesGcmV1) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AesGcmV1(%+v)", *p)
}

// Attributes:
//  - AadPrefix: AAD prefix *
//  - AadFileUnique: Unique file identifier part of AAD suffix *
//  - SupplyAadPrefix: In files encrypted with AAD prefix without storing it,
// readers must supply the prefix *
type AesGcmCtrV1 struct {
	AadPrefix       []byte `thrift:"aad_prefix,1" db:"aad_prefix" json:"aad_prefix,omitempty"`
	AadFileUnique   []byte `thrift:"aad_file_unique,2" db:"aad_file_unique" json:"aad_file_unique,omitempty"`
	SupplyAadPrefix *bool  `thrift:"supply_aad_prefix,3" db:"supply_aad_prefix" json:"supply_aad_prefix,omitempty"`
}

func NewAesGcmCtrV1() *AesGcmCtrV1 {
	return &AesGcmCtrV1{}
}

var AesGcmCtrV1_AadPrefix_DEFAULT []byte

func (p *AesGcmCtrV1) GetAadPrefix() []byte {
	return p.AadPrefix
}

var AesGcmCtrV1_AadFileUnique_DEFAULT []byte

func (p *AesGcmCtrV1) GetAadFileUnique() []byte {
	return p.AadFileUnique
}

var AesGcmCtrV1_SupplyAadPrefix_DEFAULT bool

func (p *AesGcmCtrV1) GetSupplyAadPrefix() bool {
	if !p.IsSetSupplyAadPrefix() {
		return AesGcmCtrV1_SupplyAadPrefix_DEFAULT
	}
	return *p.SupplyAadPrefix
}
func (p *AesGcmCtrV1) IsSetAadPrefix() bool {
	return p.AadPrefix != nil
}

func (p *AesGcmCtrV1) IsSetAadFileUnique() bool {
	return p.AadFileUnique != nil
}

func (p *AesGcmCtrV1) IsSetSupplyAadPrefix() bool {
	return p.SupplyAadPrefix != nil
}

func (p *AesGcmCtrV1) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *AesGcmCtrV1) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.AadPrefix = v
	}
	return nil
}

func (p *AesGcmCtrV1) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.AadFileUnique = v
	}
	return nil
}

func (p *AesGcmCtrV1) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.SupplyAadPrefix = &v
	}
	return nil
}

func (p *AesGcmCtrV1) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "AesGcmCtrV1"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AesGcmCtrV1) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAadPrefix() {
		if err := oprot.WriteFieldBegin(ctx, "aad_prefix", thrift.STRING, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:aad_prefix: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.AadPrefix); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.aad_prefix (1) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:aad_prefix: ", p), err)
		}
	}
	return err
}

func (p *AesGcmCtrV1) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAadFileUnique() {
		if err := oprot.WriteFieldBegin(ctx, "aad_file_unique", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:aad_file_unique: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.AadFileUnique); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.aad_file_unique (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:aad_file_unique: ", p), err)
		}
	}
	return err
}

func (p *AesGcmCtrV1) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSupplyAadPrefix() {
		if err := oprot.WriteFieldBegin(ctx, "supply_aad_prefix", thrift.BOOL, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:supply_aad_prefix: ", p), err)
		}
		if err := oprot.WriteBool(ctx, bool(*p.SupplyAadPrefix)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.supply_aad_prefix (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:supply_aad_prefix: ", p), err)
		}
	}
	return err
}

func (p *AesGcmCtrV1) Equals(other *AesGcmCtrV1) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if bytes.Compare(p.AadPrefix, other.AadPrefix) != 0 {
		return false
	}
	if bytes.Compare(p.AadFileUnique, other.AadFileUnique) != 0 {
		return false
	}
	if p.SupplyAadPrefix != other.SupplyAadPrefix {
		if p.SupplyAadPrefix == nil || other.SupplyAadPrefix == nil {
			return false
		}
		if (*p.SupplyAadPrefix) != (*other.SupplyAadPrefix) {
			return false
		}
	}
	return true
}

func (p *AesGcmCtrV1) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AesGcmCtrV1(%+v)", *p)
}

// Attributes:
//  - AES_GCM_V1
//  - AES_GCM_CTR_V1
type EncryptionAlgorithm struct {
	AES_GCM_V1     *AesGcmV1    `thrift:"AES_GCM_V1,1" db:"AES_GCM_V1" json:"AES_GCM_V1,omitempty"`
	AES_GCM_CTR_V1 *AesGcmCtrV1 `thrift:"AES_GCM_CTR_V1,2" db:"AES_GCM_CTR_V1" json:"AES_GCM_CTR_V1,omitempty"`
}

func NewEncryptionAlgorithm() *EncryptionAlgorithm {
	return &EncryptionAlgorithm{}
}

var EncryptionAlgorithm_AES_GCM_V1_DEFAULT *AesGcmV1

func (p *EncryptionAlgorithm) GetAES_GCM_V1() *AesGcmV1 {
	if !p.IsSetAES_GCM_V1() {
		return EncryptionAlgorithm_AES_GCM_V1_DEFAULT
	}
	return p.AES_GCM_V1
}

var EncryptionAlgorithm_AES_GCM_CTR_V1_DEFAULT *AesGcmCtrV1

func (p *EncryptionAlgorithm) GetAES_GCM_CTR_V1() *AesGcmCtrV1 {
	if !p.IsSetAES_GCM_CTR_V1() {
		return EncryptionAlgorithm_AES_GCM_CTR_V1_DEFAULT
	}
	return p.AES_GCM_CTR_V1
}
func (p *EncryptionAlgorithm) CountSetFieldsEncryptionAlgorithm() int {
	count := 0
	if p.IsSetAES_GCM_V1() {
		count++
	}
	if p.IsSetAES_GCM_CTR_V1() {
		count++
	}
	return count

}

func (p *EncryptionAlgorithm) IsSetAES_GCM_V1() bool {
	return p.AES_GCM_V1 != nil
}

func (p *EncryptionAlgorithm) IsSetAES_GCM_CTR_V1() bool {
	return p.AES_GCM_CTR_V1 != nil
}

func (p *EncryptionAlgorithm) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *EncryptionAlgorithm) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.AES_GCM_V1 = &AesGcmV1{}
	if err := p.AES_GCM_V1.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.AES_GCM_V1), err)
	}
	return nil
}

func (p *EncryptionAlgorithm) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	p.AES_GCM_CTR_V1 = &AesGcmCtrV1{}
	if err := p.AES_GCM_CTR_V1.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.AES_GCM_CTR_V1), err)
	}
	return nil
}

func (p *EncryptionAlgorithm) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if c := p.CountSetFieldsEncryptionAlgorithm(); c != 1 {
		return fmt.Errorf("%T write union: exactly one field must be set (%d set)", p, c)
	}
	if err := oprot.WriteStructBegin(ctx, "EncryptionAlgorithm"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *EncryptionAlgorithm) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAES_GCM_V1() {
		if err := oprot.WriteFieldBegin(ctx, "AES_GCM_V1", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:AES_GCM_V1: ", p), err)
		}
		if err := p.AES_GCM_V1.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.AES_GCM_V1), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:AES_GCM_V1: ", p), err)
		}
	}
	return err
}

func (p *EncryptionAlgorithm) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAES_GCM_CTR_V1() {
		if err := oprot.WriteFieldBegin(ctx, "AES_GCM_CTR_V1", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:AES_GCM_CTR_V1: ", p), err)
		}
		if err := p.AES_GCM_CTR_V1.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.AES_GCM_CTR_V1), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:AES_GCM_CTR_V1: ", p), err)
		}
	}
	return err
}

func (p *EncryptionAlgorithm) Equals(other *EncryptionAlgorithm) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.AES_GCM_V1.Equals(other.AES_GCM_V1) {
		return false
	}
	if !p.AES_GCM_CTR_V1.Equals(other.AES_GCM_CTR_V1) {
		return false
	}
	return true
}

func (p *EncryptionAlgorithm) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("EncryptionAlgorithm(%+v)", *p)
}

// Description for file metadata
//
// Attributes:
//  - Version: Version of this file *
//  - Schema: Parquet schema for this file.  This schema contains metadata for all the columns.
// The schema is represented as a tree with a single root.  The nodes of the tree
// are flattened to a list by doing a depth-first traversal.
// The column metadata contains the path in the schema for that column which can be
// used to map columns to nodes in the schema.
// The first element is the root *
//  - NumRows: Number of rows in this file *
//  - RowGroups: Row groups in this file *
//  - KeyValueMetadata: Optional key/value metadata *
//  - CreatedBy: String for application that wrote this file.  This should be in the format
// <Application> version <App Version> (build <App Build Hash>).
// e.g. impala version 1.0 (build 6cf94d29b2b7115df4de2c06e2ab4326d721eb55)
//
//  - ColumnOrders: Sort order used for the min_value and max_value fields of each column in
// this file. Sort orders are listed in the order matching the columns in the
// schema. The indexes are not necessary the same though, because only leaf
// nodes of the schema are represented in the list of sort orders.
//
// Without column_orders, the meaning of the min_value and max_value fields is
// undefined. To ensure well-defined behaviour, if min_value and max_value are
// written to a Parquet file, column_orders must be written as well.
//
// The obsolete min and max fields are always sorted by signed comparison
// regardless of column_orders.
//  - EncryptionAlgorithm: Encryption algorithm. This field is set only in encrypted files
// with plaintext footer. Files with encrypted footer store algorithm id
// in FileCryptoMetaData structure.
//  - FooterSigningKeyMetadata: Retrieval metadata of key used for signing the footer.
// Used only in encrypted files with plaintext footer.
type FileMetaData struct {
	Version                  int32                `thrift:"version,1,required" db:"version" json:"version"`
	Schema                   []*SchemaElement     `thrift:"schema,2,required" db:"schema" json:"schema"`
	NumRows                  int64                `thrift:"num_rows,3,required" db:"num_rows" json:"num_rows"`
	RowGroups                []*RowGroup          `thrift:"row_groups,4,required" db:"row_groups" json:"row_groups"`
	KeyValueMetadata         []*KeyValue          `thrift:"key_value_metadata,5" db:"key_value_metadata" json:"key_value_metadata,omitempty"`
	CreatedBy                *string              `thrift:"created_by,6" db:"created_by" json:"created_by,omitempty"`
	ColumnOrders             []*ColumnOrder       `thrift:"column_orders,7" db:"column_orders" json:"column_orders,omitempty"`
	EncryptionAlgorithm      *EncryptionAlgorithm `thrift:"encryption_algorithm,8" db:"encryption_algorithm" json:"encryption_algorithm,omitempty"`
	FooterSigningKeyMetadata []byte               `thrift:"footer_signing_key_metadata,9" db:"footer_signing_key_metadata" json:"footer_signing_key_metadata,omitempty"`
}

func NewFileMetaData() *FileMetaData {
	return &FileMetaData{}
}

func (p *FileMetaData) GetVersion() int32 {
	return p.Version
}

func (p *FileMetaData) GetSchema() []*SchemaElement {
	return p.Schema
}

func (p *FileMetaData) GetNumRows() int64 {
	return p.NumRows
}

func (p *FileMetaData) GetRowGroups() []*RowGroup {
	return p.RowGroups
}

var FileMetaData_KeyValueMetadata_DEFAULT []*KeyValue

func (p *FileMetaData) GetKeyValueMetadata() []*KeyValue {
	return p.KeyValueMetadata
}

var FileMetaData_CreatedBy_DEFAULT string

func (p *FileMetaData) GetCreatedBy() string {
	if !p.IsSetCreatedBy() {
		return FileMetaData_CreatedBy_DEFAULT
	}
	return *p.CreatedBy
}

var FileMetaData_ColumnOrders_DEFAULT []*ColumnOrder

func (p *FileMetaData) GetColumnOrders() []*ColumnOrder {
	return p.ColumnOrders
}

var FileMetaData_EncryptionAlgorithm_DEFAULT *EncryptionAlgorithm

func (p *FileMetaData) GetEncryptionAlgorithm() *EncryptionAlgorithm {
	if !p.IsSetEncryptionAlgorithm() {
		return FileMetaData_EncryptionAlgorithm_DEFAULT
	}
	return p.EncryptionAlgorithm
}

var FileMetaData_FooterSigningKeyMetadata_DEFAULT []byte

func (p *FileMetaData) GetFooterSigningKeyMetadata() []byte {
	return p.FooterSigningKeyMetadata
}
func (p *FileMetaData) IsSetKeyValueMetadata() bool {
	return p.KeyValueMetadata != nil
}

func (p *FileMetaData) IsSetCreatedBy() bool {
	return p.CreatedBy != nil
}

func (p *FileMetaData) IsSetColumnOrders() bool {
	return p.ColumnOrders != nil
}

func (p *FileMetaData) IsSetEncryptionAlgorithm() bool {
	return p.EncryptionAlgorithm != nil
}

func (p *FileMetaData) IsSetFooterSigningKeyMetadata() bool {
	return p.FooterSigningKeyMetadata != nil
}

func (p *FileMetaData) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetVersion bool = false
	var issetSchema bool = false
	var issetNumRows bool = false
	var issetRowGroups bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetVersion = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetSchema = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetNumRows = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetRowGroups = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetVersion {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Version is not set"))
	}
	if !issetSchema {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Schema is not set"))
	}
	if !issetNumRows {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumRows is not set"))
	}
	if !issetRowGroups {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RowGroups is not set"))
	}
	return nil
}

func (p *FileMetaData) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Version = v
	}
	return nil
}

func (p *FileMetaData) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*SchemaElement, 0, size)
	p.Schema = tSlice
	for i := 0; i < size; i++ {
		_elem24 := &SchemaElement{}
		if err := _elem24.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem24), err)
		}
		p.Schema = append(p.Schema, _elem24)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FileMetaData) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NumRows = v
	}
	return nil
}

func (p *FileMetaData) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*RowGroup, 0, size)
	p.RowGroups = tSlice
	for i := 0; i < size; i++ {
		_elem25 := &RowGroup{}
		if err := _elem25.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem25), err)
		}
		p.RowGroups = append(p.RowGroups, _elem25)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FileMetaData) ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*KeyValue, 0, size)
	p.KeyValueMetadata = tSlice
	for i := 0; i < size; i++ {
		_elem26 := &KeyValue{}
		if err := _elem26.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem26), err)
		}
		p.KeyValueMetadata = append(p.KeyValueMetadata, _elem26)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FileMetaData) ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.CreatedBy = &v
	}
	return nil
}

func (p *FileMetaData) ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*ColumnOrder, 0, size)
	p.ColumnOrders = tSlice
	for i := 0; i < size; i++ {
		_elem27 := &ColumnOrder{}
		if err := _elem27.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem27), err)
		}
		p.ColumnOrders = append(p.ColumnOrders, _elem27)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FileMetaData) ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	p.EncryptionAlgorithm = &EncryptionAlgorithm{}
	if err := p.EncryptionAlgorithm.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.EncryptionAlgorithm), err)
	}
	return nil
}

func (p *FileMetaData) ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 9: ", err)
	} else {
		p.FooterSigningKeyMetadata = v
	}
	return nil
}

func (p *FileMetaData) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "FileMetaData"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField5(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField6(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField7(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField8(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField9(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FileMetaData) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "version", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:version: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Version)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.version (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:version: ", p), err)
	}
	return err
}

func (p *FileMetaData) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "schema", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:schema: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.Schema)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Schema {
		if err := v.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:schema: ", p), err)
	}
	return err
}

func (p *FileMetaData) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "num_rows", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:num_rows: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.NumRows)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.num_rows (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:num_rows: ", p), err)
	}
	return err
}

func (p *FileMetaData) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "row_groups", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:row_groups: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.RowGroups)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.RowGroups {
		if err := v.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:row_groups: ", p), err)
	}
	return err
}

func (p *FileMetaData) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetKeyValueMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "key_value_metadata", thrift.LIST, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:key_value_metadata: ", p), err)
		}
		if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.KeyValueMetadata)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.KeyValueMetadata {
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:key_value_metadata: ", p), err)
		}
	}
	return err
}

func (p *FileMetaData) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetCreatedBy() {
		if err := oprot.WriteFieldBegin(ctx, "created_by", thrift.STRING, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:created_by: ", p), err)
		}
		if err := oprot.WriteString(ctx, string(*p.CreatedBy)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.created_by (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:created_by: ", p), err)
		}
	}
	return err
}

func (p *FileMetaData) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumnOrders() {
		if err := oprot.WriteFieldBegin(ctx, "column_orders", thrift.LIST, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:column_orders: ", p), err)
		}
		if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.ColumnOrders)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.ColumnOrders {
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:column_orders: ", p), err)
		}
	}
	return err
}

func (p *FileMetaData) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetEncryptionAlgorithm() {
		if err := oprot.WriteFieldBegin(ctx, "encryption_algorithm", thrift.STRUCT, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:encryption_algorithm: ", p), err)
		}
		if err := p.EncryptionAlgorithm.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.EncryptionAlgorithm), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:encryption_algorithm: ", p), err)
		}
	}
	return err
}

func (p *FileMetaData) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetFooterSigningKeyMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "footer_signing_key_metadata", thrift.STRING, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:footer_signing_key_metadata: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.FooterSigningKeyMetadata); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.footer_signing_key_metadata (9) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:footer_signing_key_metadata: ", p), err)
		}
	}
	return err
}

func (p *FileMetaData) Equals(other *FileMetaData) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Version != other.Version {
		return false
	}
	if len(p.Schema) != len(other.Schema) {
		return false
	}
	for i, _tgt := range p.Schema {
		_src28 := other.Schema[i]
		if !_tgt.Equals(_src28) {
			return false
		}
	}
	if p.NumRows != other.NumRows {
		return false
	}
	if len(p.RowGroups) != len(other.RowGroups) {
		return false
	}
	for i, _tgt := range p.RowGroups {
		_src29 := other.RowGroups[i]
		if !_tgt.Equals(_src29) {
			return false
		}
	}
	if len(p.KeyValueMetadata) != len(other.KeyValueMetadata) {
		return false
	}
	for i, _tgt := range p.KeyValueMetadata {
		_src30 := other.KeyValueMetadata[i]
		if !_tgt.Equals(_src30) {
			return false
		}
	}
	if p.CreatedBy != other.CreatedBy {
		if p.CreatedBy == nil || other.CreatedBy == nil {
			return false
		}
		if (*p.CreatedBy) != (*other.CreatedBy) {
			return false
		}
	}
	if len(p.ColumnOrders) != len(other.ColumnOrders) {
		return false
	}
	for i, _tgt := range p.ColumnOrders {
		_src31 := other.ColumnOrders[i]
		if !_tgt.Equals(_src31) {
			return false
		}
	}
	if !p.EncryptionAlgorithm.Equals(other.EncryptionAlgorithm) {
		return false
	}
	if bytes.Compare(p.FooterSigningKeyMetadata, other.FooterSigningKeyMetadata) != 0 {
		return false
	}
	return true
}

func (p *FileMetaData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FileMetaData(%+v)", *p)
}

// Crypto metadata for files with encrypted footer *
//
// Attributes:
//  - EncryptionAlgorithm: Encryption algorithm. This field is only used for files
// with encrypted footer. Files with plaintext footer store algorithm id
// inside footer (FileMetaData structure).
//  - KeyMetadata: Retrieval metadata of key used for encryption of footer,
// and (possibly) columns *
type FileCryptoMetaData struct {
	EncryptionAlgorithm *EncryptionAlgorithm `thrift:"encryption_algorithm,1,required" db:"encryption_algorithm" json:"encryption_algorithm"`
	KeyMetadata         []byte               `thrift:"key_metadata,2" db:"key_metadata" json:"key_metadata,omitempty"`
}

func NewFileCryptoMetaData() *FileCryptoMetaData {
	return &FileCryptoMetaData{}
}

var FileCryptoMetaData_EncryptionAlgorithm_DEFAULT *EncryptionAlgorithm

func (p *FileCryptoMetaData) GetEncryptionAlgorithm() *EncryptionAlgorithm {
	if !p.IsSetEncryptionAlgorithm() {
		return FileCryptoMetaData_EncryptionAlgorithm_DEFAULT
	}
	return p.EncryptionAlgorithm
}

var FileCryptoMetaData_KeyMetadata_DEFAULT []byte

func (p *FileCryptoMetaData) GetKeyMetadata() []byte {
	return p.KeyMetadata
}
func (p *FileCryptoMetaData) IsSetEncryptionAlgorithm() bool {
	return p.EncryptionAlgorithm != nil
}

func (p *FileCryptoMetaData) IsSetKeyMetadata() bool {
	return p.KeyMetadata != nil
}

func (p *FileCryptoMetaData) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetEncryptionAlgorithm bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetEncryptionAlgorithm = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetEncryptionAlgorithm {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EncryptionAlgorithm is not set"))
	}
	return nil
}

func (p *FileCryptoMetaData) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.EncryptionAlgorithm = &EncryptionAlgorithm{}
	if err := p.EncryptionAlgorithm.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.EncryptionAlgorithm), err)
	}
	return nil
}

func (p *FileCryptoMetaData) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.KeyMetadata = v
	}
	return nil
}

func (p *FileCryptoMetaData) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "FileCryptoMetaData"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FileCryptoMetaData) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encryption_algorithm", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:encryption_algorithm: ", p), err)
	}
	if err := p.EncryptionAlgorithm.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.EncryptionAlgorithm), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:encryption_algorithm: ", p), err)
	}
	return err
}

func (p *FileCryptoMetaData) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetKeyMetadata() {
		if err := oprot.WriteFieldBegin(ctx, "key_metadata", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:key_metadata: ", p), err)
		}
		if err := oprot.WriteBinary(ctx, p.KeyMetadata); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.key_metadata (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:key_metadata: ", p), err)
		}
	}
	return err
}

func (p *FileCryptoMetaData) Equals(other *FileCryptoMetaData) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.EncryptionAlgorithm.Equals(other.EncryptionAlgorithm) {
		return false
	}
	if bytes.Compare(p.KeyMetadata, other.KeyMetadata) != 0 {
		return false
	}
	return true
}

func (p *FileCryptoMetaData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FileCryptoMetaData(%+v)", *p)
}
