// Code generated by github.com/Khan/genqlient, DO NOT EDIT.

package gql

import (
	"context"
	"encoding/json"
	"time"

	"github.com/Khan/genqlient/graphql"
)

type AddOnType string

const (
	// A Logtail log receiver
	AddOnTypeLogtail AddOnType = "logtail"
	// An Upstash Redis database
	AddOnTypeRedis AddOnType = "redis"
	// An Upstash Redis database
	AddOnTypeUpstashRedis AddOnType = "upstash_redis"
)

// AgentGetInstancesApp includes the requested fields of the GraphQL type App.
type AgentGetInstancesApp struct {
	// Organization that owns this app
	Organization AgentGetInstancesAppOrganization `json:"organization"`
	// Unique application ID
	Id string `json:"id"`
	// The unique application name
	Name        string                                        `json:"name"`
	Allocations []AgentGetInstancesAppAllocationsAllocation   `json:"allocations"`
	Machines    AgentGetInstancesAppMachinesMachineConnection `json:"machines"`
}

// GetOrganization returns AgentGetInstancesApp.Organization, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetOrganization() AgentGetInstancesAppOrganization {
	return v.Organization
}

// GetId returns AgentGetInstancesApp.Id, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetId() string { return v.Id }

// GetName returns AgentGetInstancesApp.Name, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetName() string { return v.Name }

// GetAllocations returns AgentGetInstancesApp.Allocations, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetAllocations() []AgentGetInstancesAppAllocationsAllocation {
	return v.Allocations
}

// GetMachines returns AgentGetInstancesApp.Machines, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetMachines() AgentGetInstancesAppMachinesMachineConnection {
	return v.Machines
}

// AgentGetInstancesAppAllocationsAllocation includes the requested fields of the GraphQL type Allocation.
type AgentGetInstancesAppAllocationsAllocation struct {
	// Unique ID for this instance
	Id string `json:"id"`
	// Region this allocation is running in
	Region string `json:"region"`
	// Private IPv6 address for this instance
	PrivateIP string `json:"privateIP"`
}

// GetId returns AgentGetInstancesAppAllocationsAllocation.Id, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppAllocationsAllocation) GetId() string { return v.Id }

// GetRegion returns AgentGetInstancesAppAllocationsAllocation.Region, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppAllocationsAllocation) GetRegion() string { return v.Region }

// GetPrivateIP returns AgentGetInstancesAppAllocationsAllocation.PrivateIP, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppAllocationsAllocation) GetPrivateIP() string { return v.PrivateIP }

// AgentGetInstancesAppMachinesMachineConnection includes the requested fields of the GraphQL type MachineConnection.
// The GraphQL type's documentation follows.
//
// The connection type for Machine.
type AgentGetInstancesAppMachinesMachineConnection struct {
	// A list of nodes.
	Nodes []AgentGetInstancesAppMachinesMachineConnectionNodesMachine `json:"nodes"`
}

// GetNodes returns AgentGetInstancesAppMachinesMachineConnection.Nodes, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnection) GetNodes() []AgentGetInstancesAppMachinesMachineConnectionNodesMachine {
	return v.Nodes
}

// AgentGetInstancesAppMachinesMachineConnectionNodesMachine includes the requested fields of the GraphQL type Machine.
type AgentGetInstancesAppMachinesMachineConnectionNodesMachine struct {
	Id     string                                                                          `json:"id"`
	Region string                                                                          `json:"region"`
	Ips    AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection `json:"ips"`
}

// GetId returns AgentGetInstancesAppMachinesMachineConnectionNodesMachine.Id, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachine) GetId() string { return v.Id }

// GetRegion returns AgentGetInstancesAppMachinesMachineConnectionNodesMachine.Region, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachine) GetRegion() string {
	return v.Region
}

// GetIps returns AgentGetInstancesAppMachinesMachineConnectionNodesMachine.Ips, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachine) GetIps() AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection {
	return v.Ips
}

// AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection includes the requested fields of the GraphQL type MachineIPConnection.
// The GraphQL type's documentation follows.
//
// The connection type for MachineIP.
type AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection struct {
	// A list of nodes.
	Nodes []AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP `json:"nodes"`
}

// GetNodes returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection.Nodes, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection) GetNodes() []AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP {
	return v.Nodes
}

// AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP includes the requested fields of the GraphQL type MachineIP.
type AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP struct {
	Kind   string `json:"kind"`
	Family string `json:"family"`
	Ip     string `json:"ip"`
}

// GetKind returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP.Kind, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP) GetKind() string {
	return v.Kind
}

// GetFamily returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP.Family, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP) GetFamily() string {
	return v.Family
}

// GetIp returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP.Ip, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP) GetIp() string {
	return v.Ip
}

// AgentGetInstancesAppOrganization includes the requested fields of the GraphQL type Organization.
type AgentGetInstancesAppOrganization struct {
	// Unique organization slug
	Slug string `json:"slug"`
}

// GetSlug returns AgentGetInstancesAppOrganization.Slug, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppOrganization) GetSlug() string { return v.Slug }

// AgentGetInstancesResponse is returned by AgentGetInstances on success.
type AgentGetInstancesResponse struct {
	// Find an app by name
	App AgentGetInstancesApp `json:"app"`
}

// GetApp returns AgentGetInstancesResponse.App, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesResponse) GetApp() AgentGetInstancesApp { return v.App }

// AppData includes the GraphQL fields of App requested by the fragment AppData.
type AppData struct {
	// Unique application ID
	Id string `json:"id"`
	// The unique application name
	Name string `json:"name"`
	// Fly platform version
	PlatformVersion PlatformVersionEnum `json:"platformVersion"`
	// Organization that owns this app
	Organization AppDataOrganization `json:"organization"`
}

// GetId returns AppData.Id, and is useful for accessing the field via an interface.
func (v *AppData) GetId() string { return v.Id }

// GetName returns AppData.Name, and is useful for accessing the field via an interface.
func (v *AppData) GetName() string { return v.Name }

// GetPlatformVersion returns AppData.PlatformVersion, and is useful for accessing the field via an interface.
func (v *AppData) GetPlatformVersion() PlatformVersionEnum { return v.PlatformVersion }

// GetOrganization returns AppData.Organization, and is useful for accessing the field via an interface.
func (v *AppData) GetOrganization() AppDataOrganization { return v.Organization }

// AppDataOrganization includes the requested fields of the GraphQL type Organization.
type AppDataOrganization struct {
	Id string `json:"id"`
	// Unique organization slug
	Slug string `json:"slug"`
	// Unmodified unique org slug
	RawSlug  string `json:"rawSlug"`
	PaidPlan bool   `json:"paidPlan"`
}

// GetId returns AppDataOrganization.Id, and is useful for accessing the field via an interface.
func (v *AppDataOrganization) GetId() string { return v.Id }

// GetSlug returns AppDataOrganization.Slug, and is useful for accessing the field via an interface.
func (v *AppDataOrganization) GetSlug() string { return v.Slug }

// GetRawSlug returns AppDataOrganization.RawSlug, and is useful for accessing the field via an interface.
func (v *AppDataOrganization) GetRawSlug() string { return v.RawSlug }

// GetPaidPlan returns AppDataOrganization.PaidPlan, and is useful for accessing the field via an interface.
func (v *AppDataOrganization) GetPaidPlan() bool { return v.PaidPlan }

type BuildFinalImageInput struct {
	// Sha256 id of docker image
	Id string `json:"id"`
	// Size in bytes of the docker image
	SizeBytes int64 `json:"sizeBytes"`
	// Tag used for docker image
	Tag string `json:"tag"`
}

// GetId returns BuildFinalImageInput.Id, and is useful for accessing the field via an interface.
func (v *BuildFinalImageInput) GetId() string { return v.Id }

// GetSizeBytes returns BuildFinalImageInput.SizeBytes, and is useful for accessing the field via an interface.
func (v *BuildFinalImageInput) GetSizeBytes() int64 { return v.SizeBytes }

// GetTag returns BuildFinalImageInput.Tag, and is useful for accessing the field via an interface.
func (v *BuildFinalImageInput) GetTag() string { return v.Tag }

type BuildImageOptsInput struct {
	// Set of build time variables passed to cli
	BuildArgs interface{} `json:"buildArgs"`
	// Fly.toml build.buildpacks setting
	BuildPacks []string `json:"buildPacks"`
	// Fly.toml build.builder setting
	Builder string `json:"builder"`
	// Builtin builder to use
	BuiltIn string `json:"builtIn"`
	// Builtin builder settings
	BuiltInSettings interface{} `json:"builtInSettings"`
	// Path to dockerfile, if one exists
	DockerfilePath string `json:"dockerfilePath"`
	// Unused in cli?
	ExtraBuildArgs interface{} `json:"extraBuildArgs"`
	// Image label to use when tagging and pushing to the fly registry
	ImageLabel string `json:"imageLabel"`
	// Unused in cli?
	ImageRef string `json:"imageRef"`
	// Do not use the build cache when building the image
	NoCache bool `json:"noCache"`
	// Whether publishing to the registry was requested
	Publish bool `json:"publish"`
	// Docker tag used to publish image to registry
	Tag string `json:"tag"`
	// Set the target build stage to build if the Dockerfile has more than one stage
	Target string `json:"target"`
}

// GetBuildArgs returns BuildImageOptsInput.BuildArgs, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuildArgs() interface{} { return v.BuildArgs }

// GetBuildPacks returns BuildImageOptsInput.BuildPacks, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuildPacks() []string { return v.BuildPacks }

// GetBuilder returns BuildImageOptsInput.Builder, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuilder() string { return v.Builder }

// GetBuiltIn returns BuildImageOptsInput.BuiltIn, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuiltIn() string { return v.BuiltIn }

// GetBuiltInSettings returns BuildImageOptsInput.BuiltInSettings, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuiltInSettings() interface{} { return v.BuiltInSettings }

// GetDockerfilePath returns BuildImageOptsInput.DockerfilePath, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetDockerfilePath() string { return v.DockerfilePath }

// GetExtraBuildArgs returns BuildImageOptsInput.ExtraBuildArgs, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetExtraBuildArgs() interface{} { return v.ExtraBuildArgs }

// GetImageLabel returns BuildImageOptsInput.ImageLabel, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetImageLabel() string { return v.ImageLabel }

// GetImageRef returns BuildImageOptsInput.ImageRef, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetImageRef() string { return v.ImageRef }

// GetNoCache returns BuildImageOptsInput.NoCache, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetNoCache() bool { return v.NoCache }

// GetPublish returns BuildImageOptsInput.Publish, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetPublish() bool { return v.Publish }

// GetTag returns BuildImageOptsInput.Tag, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetTag() string { return v.Tag }

// GetTarget returns BuildImageOptsInput.Target, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetTarget() string { return v.Target }

type BuildStrategyAttemptInput struct {
	// Optional error message from strategy
	Error string `json:"error"`
	// Optional note about this strategy or its result
	Note string `json:"note"`
	// Result attempting this strategy
	Result string `json:"result"`
	// Build strategy attempted
	Strategy string `json:"strategy"`
}

// GetError returns BuildStrategyAttemptInput.Error, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetError() string { return v.Error }

// GetNote returns BuildStrategyAttemptInput.Note, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetNote() string { return v.Note }

// GetResult returns BuildStrategyAttemptInput.Result, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetResult() string { return v.Result }

// GetStrategy returns BuildStrategyAttemptInput.Strategy, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetStrategy() string { return v.Strategy }

type BuildTimingsInput struct {
	// Time to build and push the image, measured by flyctl
	BuildAndPushMs int64 `json:"buildAndPushMs"`
	// Time to build the image including create context, measured by flyctl
	BuildMs int64 `json:"buildMs"`
	// Time to initialize client used to connect to either remote or local builder
	BuilderInitMs int64 `json:"builderInitMs"`
	// Time to create the build context tar file, measured by flyctl
	ContextBuildMs int64 `json:"contextBuildMs"`
	// Time for builder to build image after receiving context, measured by flyctl
	ImageBuildMs int64 `json:"imageBuildMs"`
	// Time to push completed image to registry, measured by flyctl
	PushMs int64 `json:"pushMs"`
}

// GetBuildAndPushMs returns BuildTimingsInput.BuildAndPushMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetBuildAndPushMs() int64 { return v.BuildAndPushMs }

// GetBuildMs returns BuildTimingsInput.BuildMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetBuildMs() int64 { return v.BuildMs }

// GetBuilderInitMs returns BuildTimingsInput.BuilderInitMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetBuilderInitMs() int64 { return v.BuilderInitMs }

// GetContextBuildMs returns BuildTimingsInput.ContextBuildMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetContextBuildMs() int64 { return v.ContextBuildMs }

// GetImageBuildMs returns BuildTimingsInput.ImageBuildMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetImageBuildMs() int64 { return v.ImageBuildMs }

// GetPushMs returns BuildTimingsInput.PushMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetPushMs() int64 { return v.PushMs }

type BuilderMetaInput struct {
	// Local or remote builder type
	BuilderType string `json:"builderType"`
	// Whther or not buildkit is enabled on builder
	BuildkitEnabled bool `json:"buildkitEnabled"`
	// Docker version reported by builder
	DockerVersion string `json:"dockerVersion"`
	// Platform reported by the builder
	Platform string `json:"platform"`
	// Remote builder app used
	RemoteAppName string `json:"remoteAppName"`
	// Remote builder machine used
	RemoteMachineId string `json:"remoteMachineId"`
}

// GetBuilderType returns BuilderMetaInput.BuilderType, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetBuilderType() string { return v.BuilderType }

// GetBuildkitEnabled returns BuilderMetaInput.BuildkitEnabled, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetBuildkitEnabled() bool { return v.BuildkitEnabled }

// GetDockerVersion returns BuilderMetaInput.DockerVersion, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetDockerVersion() string { return v.DockerVersion }

// GetPlatform returns BuilderMetaInput.Platform, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetPlatform() string { return v.Platform }

// GetRemoteAppName returns BuilderMetaInput.RemoteAppName, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetRemoteAppName() string { return v.RemoteAppName }

// GetRemoteMachineId returns BuilderMetaInput.RemoteMachineId, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetRemoteMachineId() string { return v.RemoteMachineId }

// CreateAddOnCreateAddOnCreateAddOnPayload includes the requested fields of the GraphQL type CreateAddOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateAddOn
type CreateAddOnCreateAddOnCreateAddOnPayload struct {
	AddOn CreateAddOnCreateAddOnCreateAddOnPayloadAddOn `json:"addOn"`
}

// GetAddOn returns CreateAddOnCreateAddOnCreateAddOnPayload.AddOn, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayload) GetAddOn() CreateAddOnCreateAddOnCreateAddOnPayloadAddOn {
	return v.AddOn
}

// CreateAddOnCreateAddOnCreateAddOnPayloadAddOn includes the requested fields of the GraphQL type AddOn.
type CreateAddOnCreateAddOnCreateAddOnPayloadAddOn struct {
	// The service name according to the provider
	Name string `json:"name"`
	// Public URL for this service
	PublicUrl string `json:"publicUrl"`
	// Single sign-on link to the add-on dashboard
	SsoLink string `json:"ssoLink"`
	// Token for the add-on
	Token string `json:"token"`
}

// GetName returns CreateAddOnCreateAddOnCreateAddOnPayloadAddOn.Name, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayloadAddOn) GetName() string { return v.Name }

// GetPublicUrl returns CreateAddOnCreateAddOnCreateAddOnPayloadAddOn.PublicUrl, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayloadAddOn) GetPublicUrl() string { return v.PublicUrl }

// GetSsoLink returns CreateAddOnCreateAddOnCreateAddOnPayloadAddOn.SsoLink, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayloadAddOn) GetSsoLink() string { return v.SsoLink }

// GetToken returns CreateAddOnCreateAddOnCreateAddOnPayloadAddOn.Token, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayloadAddOn) GetToken() string { return v.Token }

// CreateAddOnResponse is returned by CreateAddOn on success.
type CreateAddOnResponse struct {
	CreateAddOn CreateAddOnCreateAddOnCreateAddOnPayload `json:"createAddOn"`
}

// GetCreateAddOn returns CreateAddOnResponse.CreateAddOn, and is useful for accessing the field via an interface.
func (v *CreateAddOnResponse) GetCreateAddOn() CreateAddOnCreateAddOnCreateAddOnPayload {
	return v.CreateAddOn
}

// CreateAppCreateAppCreateAppPayload includes the requested fields of the GraphQL type CreateAppPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateApp
type CreateAppCreateAppCreateAppPayload struct {
	App CreateAppCreateAppCreateAppPayloadApp `json:"app"`
}

// GetApp returns CreateAppCreateAppCreateAppPayload.App, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayload) GetApp() CreateAppCreateAppCreateAppPayloadApp {
	return v.App
}

// CreateAppCreateAppCreateAppPayloadApp includes the requested fields of the GraphQL type App.
type CreateAppCreateAppCreateAppPayloadApp struct {
	AppData `json:"-"`
	Config  CreateAppCreateAppCreateAppPayloadAppConfig          `json:"config"`
	Regions []CreateAppCreateAppCreateAppPayloadAppRegionsRegion `json:"regions"`
}

// GetConfig returns CreateAppCreateAppCreateAppPayloadApp.Config, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadApp) GetConfig() CreateAppCreateAppCreateAppPayloadAppConfig {
	return v.Config
}

// GetRegions returns CreateAppCreateAppCreateAppPayloadApp.Regions, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadApp) GetRegions() []CreateAppCreateAppCreateAppPayloadAppRegionsRegion {
	return v.Regions
}

// GetId returns CreateAppCreateAppCreateAppPayloadApp.Id, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadApp) GetId() string { return v.AppData.Id }

// GetName returns CreateAppCreateAppCreateAppPayloadApp.Name, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadApp) GetName() string { return v.AppData.Name }

// GetPlatformVersion returns CreateAppCreateAppCreateAppPayloadApp.PlatformVersion, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadApp) GetPlatformVersion() PlatformVersionEnum {
	return v.AppData.PlatformVersion
}

// GetOrganization returns CreateAppCreateAppCreateAppPayloadApp.Organization, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadApp) GetOrganization() AppDataOrganization {
	return v.AppData.Organization
}

func (v *CreateAppCreateAppCreateAppPayloadApp) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*CreateAppCreateAppCreateAppPayloadApp
		graphql.NoUnmarshalJSON
	}
	firstPass.CreateAppCreateAppCreateAppPayloadApp = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.AppData)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalCreateAppCreateAppCreateAppPayloadApp struct {
	Config CreateAppCreateAppCreateAppPayloadAppConfig `json:"config"`

	Regions []CreateAppCreateAppCreateAppPayloadAppRegionsRegion `json:"regions"`

	Id string `json:"id"`

	Name string `json:"name"`

	PlatformVersion PlatformVersionEnum `json:"platformVersion"`

	Organization AppDataOrganization `json:"organization"`
}

func (v *CreateAppCreateAppCreateAppPayloadApp) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *CreateAppCreateAppCreateAppPayloadApp) __premarshalJSON() (*__premarshalCreateAppCreateAppCreateAppPayloadApp, error) {
	var retval __premarshalCreateAppCreateAppCreateAppPayloadApp

	retval.Config = v.Config
	retval.Regions = v.Regions
	retval.Id = v.AppData.Id
	retval.Name = v.AppData.Name
	retval.PlatformVersion = v.AppData.PlatformVersion
	retval.Organization = v.AppData.Organization
	return &retval, nil
}

// CreateAppCreateAppCreateAppPayloadAppConfig includes the requested fields of the GraphQL type AppConfig.
type CreateAppCreateAppCreateAppPayloadAppConfig struct {
	Definition interface{} `json:"definition"`
}

// GetDefinition returns CreateAppCreateAppCreateAppPayloadAppConfig.Definition, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadAppConfig) GetDefinition() interface{} {
	return v.Definition
}

// CreateAppCreateAppCreateAppPayloadAppRegionsRegion includes the requested fields of the GraphQL type Region.
type CreateAppCreateAppCreateAppPayloadAppRegionsRegion struct {
	// The name of this region
	Name string `json:"name"`
	// The IATA airport code for this region
	Code string `json:"code"`
}

// GetName returns CreateAppCreateAppCreateAppPayloadAppRegionsRegion.Name, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadAppRegionsRegion) GetName() string { return v.Name }

// GetCode returns CreateAppCreateAppCreateAppPayloadAppRegionsRegion.Code, and is useful for accessing the field via an interface.
func (v *CreateAppCreateAppCreateAppPayloadAppRegionsRegion) GetCode() string { return v.Code }

// Autogenerated input type of CreateApp
type CreateAppInput struct {
	AppRoleId string `json:"appRoleId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	Heroku           bool   `json:"heroku"`
	Machines         bool   `json:"machines"`
	// The name of the new application. Defaults to a random name.
	Name    string `json:"name"`
	Network string `json:"network"`
	// The node ID of the organization
	OrganizationId  string `json:"organizationId"`
	PreferredRegion string `json:"preferredRegion"`
	// The application runtime
	Runtime RuntimeType `json:"runtime"`
}

// GetAppRoleId returns CreateAppInput.AppRoleId, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetAppRoleId() string { return v.AppRoleId }

// GetClientMutationId returns CreateAppInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetClientMutationId() string { return v.ClientMutationId }

// GetHeroku returns CreateAppInput.Heroku, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetHeroku() bool { return v.Heroku }

// GetMachines returns CreateAppInput.Machines, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetMachines() bool { return v.Machines }

// GetName returns CreateAppInput.Name, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetName() string { return v.Name }

// GetNetwork returns CreateAppInput.Network, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetNetwork() string { return v.Network }

// GetOrganizationId returns CreateAppInput.OrganizationId, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetOrganizationId() string { return v.OrganizationId }

// GetPreferredRegion returns CreateAppInput.PreferredRegion, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetPreferredRegion() string { return v.PreferredRegion }

// GetRuntime returns CreateAppInput.Runtime, and is useful for accessing the field via an interface.
func (v *CreateAppInput) GetRuntime() RuntimeType { return v.Runtime }

// CreateAppResponse is returned by CreateApp on success.
type CreateAppResponse struct {
	CreateApp CreateAppCreateAppCreateAppPayload `json:"createApp"`
}

// GetCreateApp returns CreateAppResponse.CreateApp, and is useful for accessing the field via an interface.
func (v *CreateAppResponse) GetCreateApp() CreateAppCreateAppCreateAppPayload { return v.CreateApp }

// Autogenerated input type of CreateBuild
type CreateBuildInput struct {
	// The name of the app being built
	AppName string `json:"appName"`
	// Whether builder is remote or local
	BuilderType string `json:"builderType"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Options set for building image
	ImageOpts BuildImageOptsInput `json:"imageOpts"`
	// The ID of the machine being built (only set for machine builds)
	MachineId string `json:"machineId"`
	// List of available build strategies that will be attempted
	StrategiesAvailable []string `json:"strategiesAvailable"`
}

// GetAppName returns CreateBuildInput.AppName, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetAppName() string { return v.AppName }

// GetBuilderType returns CreateBuildInput.BuilderType, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetBuilderType() string { return v.BuilderType }

// GetClientMutationId returns CreateBuildInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetClientMutationId() string { return v.ClientMutationId }

// GetImageOpts returns CreateBuildInput.ImageOpts, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetImageOpts() BuildImageOptsInput { return v.ImageOpts }

// GetMachineId returns CreateBuildInput.MachineId, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetMachineId() string { return v.MachineId }

// GetStrategiesAvailable returns CreateBuildInput.StrategiesAvailable, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetStrategiesAvailable() []string { return v.StrategiesAvailable }

// CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayload includes the requested fields of the GraphQL type CreateLimitedAccessTokenPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateLimitedAccessToken
type CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayload struct {
	LimitedAccessToken CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayloadLimitedAccessToken `json:"limitedAccessToken"`
}

// GetLimitedAccessToken returns CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayload.LimitedAccessToken, and is useful for accessing the field via an interface.
func (v *CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayload) GetLimitedAccessToken() CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayloadLimitedAccessToken {
	return v.LimitedAccessToken
}

// CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayloadLimitedAccessToken includes the requested fields of the GraphQL type LimitedAccessToken.
type CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayloadLimitedAccessToken struct {
	TokenHeader string `json:"tokenHeader"`
}

// GetTokenHeader returns CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayloadLimitedAccessToken.TokenHeader, and is useful for accessing the field via an interface.
func (v *CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayloadLimitedAccessToken) GetTokenHeader() string {
	return v.TokenHeader
}

// CreateLimitedAccessTokenResponse is returned by CreateLimitedAccessToken on success.
type CreateLimitedAccessTokenResponse struct {
	CreateLimitedAccessToken CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayload `json:"createLimitedAccessToken"`
}

// GetCreateLimitedAccessToken returns CreateLimitedAccessTokenResponse.CreateLimitedAccessToken, and is useful for accessing the field via an interface.
func (v *CreateLimitedAccessTokenResponse) GetCreateLimitedAccessToken() CreateLimitedAccessTokenCreateLimitedAccessTokenCreateLimitedAccessTokenPayload {
	return v.CreateLimitedAccessToken
}

// Autogenerated input type of CreateRelease
type CreateReleaseInput struct {
	// The ID of the app
	AppId string `json:"appId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// app definition
	Definition interface{} `json:"definition"`
	// The image to deploy
	Image string `json:"image"`
	// nomad or machines
	PlatformVersion string `json:"platformVersion"`
	// The strategy for replacing existing instances. Defaults to canary.
	Strategy DeploymentStrategy `json:"strategy"`
}

// GetAppId returns CreateReleaseInput.AppId, and is useful for accessing the field via an interface.
func (v *CreateReleaseInput) GetAppId() string { return v.AppId }

// GetClientMutationId returns CreateReleaseInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *CreateReleaseInput) GetClientMutationId() string { return v.ClientMutationId }

// GetDefinition returns CreateReleaseInput.Definition, and is useful for accessing the field via an interface.
func (v *CreateReleaseInput) GetDefinition() interface{} { return v.Definition }

// GetImage returns CreateReleaseInput.Image, and is useful for accessing the field via an interface.
func (v *CreateReleaseInput) GetImage() string { return v.Image }

// GetPlatformVersion returns CreateReleaseInput.PlatformVersion, and is useful for accessing the field via an interface.
func (v *CreateReleaseInput) GetPlatformVersion() string { return v.PlatformVersion }

// GetStrategy returns CreateReleaseInput.Strategy, and is useful for accessing the field via an interface.
func (v *CreateReleaseInput) GetStrategy() DeploymentStrategy { return v.Strategy }

// DeleteAddOnDeleteAddOnDeleteAddOnPayload includes the requested fields of the GraphQL type DeleteAddOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of DeleteAddOn
type DeleteAddOnDeleteAddOnDeleteAddOnPayload struct {
	DeletedAddOnName string `json:"deletedAddOnName"`
}

// GetDeletedAddOnName returns DeleteAddOnDeleteAddOnDeleteAddOnPayload.DeletedAddOnName, and is useful for accessing the field via an interface.
func (v *DeleteAddOnDeleteAddOnDeleteAddOnPayload) GetDeletedAddOnName() string {
	return v.DeletedAddOnName
}

// DeleteAddOnResponse is returned by DeleteAddOn on success.
type DeleteAddOnResponse struct {
	DeleteAddOn DeleteAddOnDeleteAddOnDeleteAddOnPayload `json:"deleteAddOn"`
}

// GetDeleteAddOn returns DeleteAddOnResponse.DeleteAddOn, and is useful for accessing the field via an interface.
func (v *DeleteAddOnResponse) GetDeleteAddOn() DeleteAddOnDeleteAddOnDeleteAddOnPayload {
	return v.DeleteAddOn
}

type DeploymentStrategy string

const (
	// Launch all new instances before shutting down previous instances
	DeploymentStrategyBluegreen DeploymentStrategy = "BLUEGREEN"
	// Ensure new instances are healthy before continuing with a rolling deployment
	DeploymentStrategyCanary DeploymentStrategy = "CANARY"
	// Deploy new instances all at once
	DeploymentStrategyImmediate DeploymentStrategy = "IMMEDIATE"
	// Incrementally replace old instances with new ones
	DeploymentStrategyRolling DeploymentStrategy = "ROLLING"
	// Incrementally replace old instances with new ones, 1 by 1
	DeploymentStrategyRollingOne DeploymentStrategy = "ROLLING_ONE"
	// Deploy new instances all at once
	DeploymentStrategySimple DeploymentStrategy = "SIMPLE"
)

// Autogenerated input type of FinishBuild
type FinishBuildInput struct {
	// The name of the app being built
	AppName string `json:"appName"`
	// Build id returned by createBuild() mutation
	BuildId string `json:"buildId"`
	// Metadata about the builder
	BuilderMeta BuilderMetaInput `json:"builderMeta"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Information about the docker image that was built
	FinalImage BuildFinalImageInput `json:"finalImage"`
	// Log or error output
	Logs string `json:"logs"`
	// The ID of the machine being built (only set for machine builds)
	MachineId string `json:"machineId"`
	// Indicate whether build completed or failed
	Status string `json:"status"`
	// Build strategies attempted and their result, should be in order of attempt
	StrategiesAttempted []BuildStrategyAttemptInput `json:"strategiesAttempted"`
	// Timings for different phases of the build
	Timings BuildTimingsInput `json:"timings"`
}

// GetAppName returns FinishBuildInput.AppName, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetAppName() string { return v.AppName }

// GetBuildId returns FinishBuildInput.BuildId, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetBuildId() string { return v.BuildId }

// GetBuilderMeta returns FinishBuildInput.BuilderMeta, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetBuilderMeta() BuilderMetaInput { return v.BuilderMeta }

// GetClientMutationId returns FinishBuildInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetClientMutationId() string { return v.ClientMutationId }

// GetFinalImage returns FinishBuildInput.FinalImage, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetFinalImage() BuildFinalImageInput { return v.FinalImage }

// GetLogs returns FinishBuildInput.Logs, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetLogs() string { return v.Logs }

// GetMachineId returns FinishBuildInput.MachineId, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetMachineId() string { return v.MachineId }

// GetStatus returns FinishBuildInput.Status, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetStatus() string { return v.Status }

// GetStrategiesAttempted returns FinishBuildInput.StrategiesAttempted, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetStrategiesAttempted() []BuildStrategyAttemptInput {
	return v.StrategiesAttempted
}

// GetTimings returns FinishBuildInput.Timings, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetTimings() BuildTimingsInput { return v.Timings }

// FlyctlConfigCurrentReleaseApp includes the requested fields of the GraphQL type App.
type FlyctlConfigCurrentReleaseApp struct {
	// The latest release of this application, without any config processing
	CurrentReleaseUnprocessed FlyctlConfigCurrentReleaseAppCurrentReleaseUnprocessed `json:"currentReleaseUnprocessed"`
}

// GetCurrentReleaseUnprocessed returns FlyctlConfigCurrentReleaseApp.CurrentReleaseUnprocessed, and is useful for accessing the field via an interface.
func (v *FlyctlConfigCurrentReleaseApp) GetCurrentReleaseUnprocessed() FlyctlConfigCurrentReleaseAppCurrentReleaseUnprocessed {
	return v.CurrentReleaseUnprocessed
}

// FlyctlConfigCurrentReleaseAppCurrentReleaseUnprocessed includes the requested fields of the GraphQL type ReleaseUnprocessed.
type FlyctlConfigCurrentReleaseAppCurrentReleaseUnprocessed struct {
	ConfigDefinition interface{} `json:"configDefinition"`
}

// GetConfigDefinition returns FlyctlConfigCurrentReleaseAppCurrentReleaseUnprocessed.ConfigDefinition, and is useful for accessing the field via an interface.
func (v *FlyctlConfigCurrentReleaseAppCurrentReleaseUnprocessed) GetConfigDefinition() interface{} {
	return v.ConfigDefinition
}

// FlyctlConfigCurrentReleaseResponse is returned by FlyctlConfigCurrentRelease on success.
type FlyctlConfigCurrentReleaseResponse struct {
	// Find an app by name
	App FlyctlConfigCurrentReleaseApp `json:"app"`
}

// GetApp returns FlyctlConfigCurrentReleaseResponse.App, and is useful for accessing the field via an interface.
func (v *FlyctlConfigCurrentReleaseResponse) GetApp() FlyctlConfigCurrentReleaseApp { return v.App }

// FlyctlDeployGetLatestImageApp includes the requested fields of the GraphQL type App.
type FlyctlDeployGetLatestImageApp struct {
	// The latest release of this application, without any config processing
	CurrentReleaseUnprocessed FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed `json:"currentReleaseUnprocessed"`
}

// GetCurrentReleaseUnprocessed returns FlyctlDeployGetLatestImageApp.CurrentReleaseUnprocessed, and is useful for accessing the field via an interface.
func (v *FlyctlDeployGetLatestImageApp) GetCurrentReleaseUnprocessed() FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed {
	return v.CurrentReleaseUnprocessed
}

// FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed includes the requested fields of the GraphQL type ReleaseUnprocessed.
type FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed struct {
	// Unique ID
	Id string `json:"id"`
	// The version of the release
	Version int `json:"version"`
	// Docker image URI
	ImageRef string `json:"imageRef"`
}

// GetId returns FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed.Id, and is useful for accessing the field via an interface.
func (v *FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed) GetId() string { return v.Id }

// GetVersion returns FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed.Version, and is useful for accessing the field via an interface.
func (v *FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed) GetVersion() int { return v.Version }

// GetImageRef returns FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed.ImageRef, and is useful for accessing the field via an interface.
func (v *FlyctlDeployGetLatestImageAppCurrentReleaseUnprocessed) GetImageRef() string {
	return v.ImageRef
}

// FlyctlDeployGetLatestImageResponse is returned by FlyctlDeployGetLatestImage on success.
type FlyctlDeployGetLatestImageResponse struct {
	// Find an app by name
	App FlyctlDeployGetLatestImageApp `json:"app"`
}

// GetApp returns FlyctlDeployGetLatestImageResponse.App, and is useful for accessing the field via an interface.
func (v *FlyctlDeployGetLatestImageResponse) GetApp() FlyctlDeployGetLatestImageApp { return v.App }

// GetAddOnAddOn includes the requested fields of the GraphQL type AddOn.
type GetAddOnAddOn struct {
	Id string `json:"id"`
	// The service name according to the provider
	Name string `json:"name"`
	// Public URL for this service
	PublicUrl string `json:"publicUrl"`
	// Private flycast IP address of the add-on
	PrivateIp string `json:"privateIp"`
	// Password for the add-on
	Password string `json:"password"`
	// Token for the add-on
	Token string `json:"token"`
	// Region where the primary instance is deployed
	PrimaryRegion string `json:"primaryRegion"`
	// Regions where replica instances are deployed
	ReadRegions []string `json:"readRegions"`
	// Add-on options
	Options interface{} `json:"options"`
	// Single sign-on link to the add-on dashboard
	SsoLink string `json:"ssoLink"`
	// Organization that owns this service
	Organization GetAddOnAddOnOrganization `json:"organization"`
	// The add-on plan
	AddOnPlan GetAddOnAddOnAddOnPlan `json:"addOnPlan"`
}

// GetId returns GetAddOnAddOn.Id, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetId() string { return v.Id }

// GetName returns GetAddOnAddOn.Name, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetName() string { return v.Name }

// GetPublicUrl returns GetAddOnAddOn.PublicUrl, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPublicUrl() string { return v.PublicUrl }

// GetPrivateIp returns GetAddOnAddOn.PrivateIp, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPrivateIp() string { return v.PrivateIp }

// GetPassword returns GetAddOnAddOn.Password, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPassword() string { return v.Password }

// GetToken returns GetAddOnAddOn.Token, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetToken() string { return v.Token }

// GetPrimaryRegion returns GetAddOnAddOn.PrimaryRegion, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPrimaryRegion() string { return v.PrimaryRegion }

// GetReadRegions returns GetAddOnAddOn.ReadRegions, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetReadRegions() []string { return v.ReadRegions }

// GetOptions returns GetAddOnAddOn.Options, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetOptions() interface{} { return v.Options }

// GetSsoLink returns GetAddOnAddOn.SsoLink, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetSsoLink() string { return v.SsoLink }

// GetOrganization returns GetAddOnAddOn.Organization, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetOrganization() GetAddOnAddOnOrganization { return v.Organization }

// GetAddOnPlan returns GetAddOnAddOn.AddOnPlan, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetAddOnPlan() GetAddOnAddOnAddOnPlan { return v.AddOnPlan }

// GetAddOnAddOnAddOnPlan includes the requested fields of the GraphQL type AddOnPlan.
type GetAddOnAddOnAddOnPlan struct {
	Id          string `json:"id"`
	Name        string `json:"name"`
	DisplayName string `json:"displayName"`
}

// GetId returns GetAddOnAddOnAddOnPlan.Id, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnAddOnPlan) GetId() string { return v.Id }

// GetName returns GetAddOnAddOnAddOnPlan.Name, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnAddOnPlan) GetName() string { return v.Name }

// GetDisplayName returns GetAddOnAddOnAddOnPlan.DisplayName, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnAddOnPlan) GetDisplayName() string { return v.DisplayName }

// GetAddOnAddOnOrganization includes the requested fields of the GraphQL type Organization.
type GetAddOnAddOnOrganization struct {
	// Unique organization slug
	Slug     string `json:"slug"`
	PaidPlan bool   `json:"paidPlan"`
}

// GetSlug returns GetAddOnAddOnOrganization.Slug, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnOrganization) GetSlug() string { return v.Slug }

// GetPaidPlan returns GetAddOnAddOnOrganization.PaidPlan, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnOrganization) GetPaidPlan() bool { return v.PaidPlan }

// GetAddOnProviderAddOnProvider includes the requested fields of the GraphQL type AddOnProvider.
type GetAddOnProviderAddOnProvider struct {
	Id              string                                               `json:"id"`
	Name            string                                               `json:"name"`
	ExcludedRegions []GetAddOnProviderAddOnProviderExcludedRegionsRegion `json:"excludedRegions"`
}

// GetId returns GetAddOnProviderAddOnProvider.Id, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProvider) GetId() string { return v.Id }

// GetName returns GetAddOnProviderAddOnProvider.Name, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProvider) GetName() string { return v.Name }

// GetExcludedRegions returns GetAddOnProviderAddOnProvider.ExcludedRegions, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProvider) GetExcludedRegions() []GetAddOnProviderAddOnProviderExcludedRegionsRegion {
	return v.ExcludedRegions
}

// GetAddOnProviderAddOnProviderExcludedRegionsRegion includes the requested fields of the GraphQL type Region.
type GetAddOnProviderAddOnProviderExcludedRegionsRegion struct {
	// The IATA airport code for this region
	Code string `json:"code"`
}

// GetCode returns GetAddOnProviderAddOnProviderExcludedRegionsRegion.Code, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProviderExcludedRegionsRegion) GetCode() string { return v.Code }

// GetAddOnProviderResponse is returned by GetAddOnProvider on success.
type GetAddOnProviderResponse struct {
	AddOnProvider GetAddOnProviderAddOnProvider `json:"addOnProvider"`
}

// GetAddOnProvider returns GetAddOnProviderResponse.AddOnProvider, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderResponse) GetAddOnProvider() GetAddOnProviderAddOnProvider {
	return v.AddOnProvider
}

// GetAddOnResponse is returned by GetAddOn on success.
type GetAddOnResponse struct {
	// Find an add-on by ID or name
	AddOn GetAddOnAddOn `json:"addOn"`
}

// GetAddOn returns GetAddOnResponse.AddOn, and is useful for accessing the field via an interface.
func (v *GetAddOnResponse) GetAddOn() GetAddOnAddOn { return v.AddOn }

// GetAppApp includes the requested fields of the GraphQL type App.
type GetAppApp struct {
	AppData `json:"-"`
}

// GetId returns GetAppApp.Id, and is useful for accessing the field via an interface.
func (v *GetAppApp) GetId() string { return v.AppData.Id }

// GetName returns GetAppApp.Name, and is useful for accessing the field via an interface.
func (v *GetAppApp) GetName() string { return v.AppData.Name }

// GetPlatformVersion returns GetAppApp.PlatformVersion, and is useful for accessing the field via an interface.
func (v *GetAppApp) GetPlatformVersion() PlatformVersionEnum { return v.AppData.PlatformVersion }

// GetOrganization returns GetAppApp.Organization, and is useful for accessing the field via an interface.
func (v *GetAppApp) GetOrganization() AppDataOrganization { return v.AppData.Organization }

func (v *GetAppApp) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*GetAppApp
		graphql.NoUnmarshalJSON
	}
	firstPass.GetAppApp = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.AppData)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalGetAppApp struct {
	Id string `json:"id"`

	Name string `json:"name"`

	PlatformVersion PlatformVersionEnum `json:"platformVersion"`

	Organization AppDataOrganization `json:"organization"`
}

func (v *GetAppApp) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *GetAppApp) __premarshalJSON() (*__premarshalGetAppApp, error) {
	var retval __premarshalGetAppApp

	retval.Id = v.AppData.Id
	retval.Name = v.AppData.Name
	retval.PlatformVersion = v.AppData.PlatformVersion
	retval.Organization = v.AppData.Organization
	return &retval, nil
}

// GetAppResponse is returned by GetApp on success.
type GetAppResponse struct {
	// Find an app by name
	App GetAppApp `json:"app"`
}

// GetApp returns GetAppResponse.App, and is useful for accessing the field via an interface.
func (v *GetAppResponse) GetApp() GetAppApp { return v.App }

// GetAppsByRoleAppsAppConnection includes the requested fields of the GraphQL type AppConnection.
// The GraphQL type's documentation follows.
//
// The connection type for App.
type GetAppsByRoleAppsAppConnection struct {
	// A list of nodes.
	Nodes []GetAppsByRoleAppsAppConnectionNodesApp `json:"nodes"`
}

// GetNodes returns GetAppsByRoleAppsAppConnection.Nodes, and is useful for accessing the field via an interface.
func (v *GetAppsByRoleAppsAppConnection) GetNodes() []GetAppsByRoleAppsAppConnectionNodesApp {
	return v.Nodes
}

// GetAppsByRoleAppsAppConnectionNodesApp includes the requested fields of the GraphQL type App.
type GetAppsByRoleAppsAppConnectionNodesApp struct {
	AppData `json:"-"`
}

// GetId returns GetAppsByRoleAppsAppConnectionNodesApp.Id, and is useful for accessing the field via an interface.
func (v *GetAppsByRoleAppsAppConnectionNodesApp) GetId() string { return v.AppData.Id }

// GetName returns GetAppsByRoleAppsAppConnectionNodesApp.Name, and is useful for accessing the field via an interface.
func (v *GetAppsByRoleAppsAppConnectionNodesApp) GetName() string { return v.AppData.Name }

// GetPlatformVersion returns GetAppsByRoleAppsAppConnectionNodesApp.PlatformVersion, and is useful for accessing the field via an interface.
func (v *GetAppsByRoleAppsAppConnectionNodesApp) GetPlatformVersion() PlatformVersionEnum {
	return v.AppData.PlatformVersion
}

// GetOrganization returns GetAppsByRoleAppsAppConnectionNodesApp.Organization, and is useful for accessing the field via an interface.
func (v *GetAppsByRoleAppsAppConnectionNodesApp) GetOrganization() AppDataOrganization {
	return v.AppData.Organization
}

func (v *GetAppsByRoleAppsAppConnectionNodesApp) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*GetAppsByRoleAppsAppConnectionNodesApp
		graphql.NoUnmarshalJSON
	}
	firstPass.GetAppsByRoleAppsAppConnectionNodesApp = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.AppData)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalGetAppsByRoleAppsAppConnectionNodesApp struct {
	Id string `json:"id"`

	Name string `json:"name"`

	PlatformVersion PlatformVersionEnum `json:"platformVersion"`

	Organization AppDataOrganization `json:"organization"`
}

func (v *GetAppsByRoleAppsAppConnectionNodesApp) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *GetAppsByRoleAppsAppConnectionNodesApp) __premarshalJSON() (*__premarshalGetAppsByRoleAppsAppConnectionNodesApp, error) {
	var retval __premarshalGetAppsByRoleAppsAppConnectionNodesApp

	retval.Id = v.AppData.Id
	retval.Name = v.AppData.Name
	retval.PlatformVersion = v.AppData.PlatformVersion
	retval.Organization = v.AppData.Organization
	return &retval, nil
}

// GetAppsByRoleResponse is returned by GetAppsByRole on success.
type GetAppsByRoleResponse struct {
	// List apps
	Apps GetAppsByRoleAppsAppConnection `json:"apps"`
}

// GetApps returns GetAppsByRoleResponse.Apps, and is useful for accessing the field via an interface.
func (v *GetAppsByRoleResponse) GetApps() GetAppsByRoleAppsAppConnection { return v.Apps }

// GetNearestRegionNearestRegion includes the requested fields of the GraphQL type Region.
type GetNearestRegionNearestRegion struct {
	// The IATA airport code for this region
	Code string `json:"code"`
	// The name of this region
	Name             string `json:"name"`
	GatewayAvailable bool   `json:"gatewayAvailable"`
}

// GetCode returns GetNearestRegionNearestRegion.Code, and is useful for accessing the field via an interface.
func (v *GetNearestRegionNearestRegion) GetCode() string { return v.Code }

// GetName returns GetNearestRegionNearestRegion.Name, and is useful for accessing the field via an interface.
func (v *GetNearestRegionNearestRegion) GetName() string { return v.Name }

// GetGatewayAvailable returns GetNearestRegionNearestRegion.GatewayAvailable, and is useful for accessing the field via an interface.
func (v *GetNearestRegionNearestRegion) GetGatewayAvailable() bool { return v.GatewayAvailable }

// GetNearestRegionResponse is returned by GetNearestRegion on success.
type GetNearestRegionResponse struct {
	NearestRegion GetNearestRegionNearestRegion `json:"nearestRegion"`
}

// GetNearestRegion returns GetNearestRegionResponse.NearestRegion, and is useful for accessing the field via an interface.
func (v *GetNearestRegionResponse) GetNearestRegion() GetNearestRegionNearestRegion {
	return v.NearestRegion
}

// GetOrganizationOrganization includes the requested fields of the GraphQL type Organization.
type GetOrganizationOrganization struct {
	Id string `json:"id"`
	// Organization name
	Name string `json:"name"`
	// Unique organization slug
	Slug string `json:"slug"`
	// Single sign-on link for the given integration type
	AddOnSsoLink string `json:"addOnSsoLink"`
}

// GetId returns GetOrganizationOrganization.Id, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetId() string { return v.Id }

// GetName returns GetOrganizationOrganization.Name, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetName() string { return v.Name }

// GetSlug returns GetOrganizationOrganization.Slug, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetSlug() string { return v.Slug }

// GetAddOnSsoLink returns GetOrganizationOrganization.AddOnSsoLink, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetAddOnSsoLink() string { return v.AddOnSsoLink }

// GetOrganizationResponse is returned by GetOrganization on success.
type GetOrganizationResponse struct {
	// Find an organization by ID
	Organization GetOrganizationOrganization `json:"organization"`
}

// GetOrganization returns GetOrganizationResponse.Organization, and is useful for accessing the field via an interface.
func (v *GetOrganizationResponse) GetOrganization() GetOrganizationOrganization {
	return v.Organization
}

// ListAddOnPlansAddOnPlansAddOnPlanConnection includes the requested fields of the GraphQL type AddOnPlanConnection.
// The GraphQL type's documentation follows.
//
// The connection type for AddOnPlan.
type ListAddOnPlansAddOnPlansAddOnPlanConnection struct {
	// A list of nodes.
	Nodes []ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan `json:"nodes"`
}

// GetNodes returns ListAddOnPlansAddOnPlansAddOnPlanConnection.Nodes, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnection) GetNodes() []ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan {
	return v.Nodes
}

// ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan includes the requested fields of the GraphQL type AddOnPlan.
type ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan struct {
	Id            string `json:"id"`
	DisplayName   string `json:"displayName"`
	MaxDataSize   string `json:"maxDataSize"`
	PricePerMonth int    `json:"pricePerMonth"`
}

// GetId returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.Id, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetId() string { return v.Id }

// GetDisplayName returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.DisplayName, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetDisplayName() string {
	return v.DisplayName
}

// GetMaxDataSize returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.MaxDataSize, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetMaxDataSize() string {
	return v.MaxDataSize
}

// GetPricePerMonth returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.PricePerMonth, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetPricePerMonth() int {
	return v.PricePerMonth
}

// ListAddOnPlansResponse is returned by ListAddOnPlans on success.
type ListAddOnPlansResponse struct {
	// List add-on service plans
	AddOnPlans ListAddOnPlansAddOnPlansAddOnPlanConnection `json:"addOnPlans"`
}

// GetAddOnPlans returns ListAddOnPlansResponse.AddOnPlans, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansResponse) GetAddOnPlans() ListAddOnPlansAddOnPlansAddOnPlanConnection {
	return v.AddOnPlans
}

// ListAddOnsAddOnsAddOnConnection includes the requested fields of the GraphQL type AddOnConnection.
// The GraphQL type's documentation follows.
//
// The connection type for AddOn.
type ListAddOnsAddOnsAddOnConnection struct {
	// A list of nodes.
	Nodes []ListAddOnsAddOnsAddOnConnectionNodesAddOn `json:"nodes"`
}

// GetNodes returns ListAddOnsAddOnsAddOnConnection.Nodes, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnection) GetNodes() []ListAddOnsAddOnsAddOnConnectionNodesAddOn {
	return v.Nodes
}

// ListAddOnsAddOnsAddOnConnectionNodesAddOn includes the requested fields of the GraphQL type AddOn.
type ListAddOnsAddOnsAddOnConnectionNodesAddOn struct {
	Id string `json:"id"`
	// The service name according to the provider
	Name string `json:"name"`
	// The add-on plan
	AddOnPlan ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan `json:"addOnPlan"`
	// Private flycast IP address of the add-on
	PrivateIp string `json:"privateIp"`
	// Region where the primary instance is deployed
	PrimaryRegion string `json:"primaryRegion"`
	// Regions where replica instances are deployed
	ReadRegions []string `json:"readRegions"`
	// Add-on options
	Options interface{} `json:"options"`
	// Organization that owns this service
	Organization ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization `json:"organization"`
}

// GetId returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Id, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetId() string { return v.Id }

// GetName returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Name, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetName() string { return v.Name }

// GetAddOnPlan returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.AddOnPlan, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetAddOnPlan() ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan {
	return v.AddOnPlan
}

// GetPrivateIp returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.PrivateIp, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetPrivateIp() string { return v.PrivateIp }

// GetPrimaryRegion returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.PrimaryRegion, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetPrimaryRegion() string { return v.PrimaryRegion }

// GetReadRegions returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.ReadRegions, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetReadRegions() []string { return v.ReadRegions }

// GetOptions returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Options, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetOptions() interface{} { return v.Options }

// GetOrganization returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Organization, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetOrganization() ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization {
	return v.Organization
}

// ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan includes the requested fields of the GraphQL type AddOnPlan.
type ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan struct {
	DisplayName string `json:"displayName"`
}

// GetDisplayName returns ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan.DisplayName, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan) GetDisplayName() string {
	return v.DisplayName
}

// ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization includes the requested fields of the GraphQL type Organization.
type ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization struct {
	Id string `json:"id"`
	// Unique organization slug
	Slug string `json:"slug"`
}

// GetId returns ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization.Id, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization) GetId() string { return v.Id }

// GetSlug returns ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization.Slug, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization) GetSlug() string { return v.Slug }

// ListAddOnsResponse is returned by ListAddOns on success.
type ListAddOnsResponse struct {
	// List add-ons associated with an organization
	AddOns ListAddOnsAddOnsAddOnConnection `json:"addOns"`
}

// GetAddOns returns ListAddOnsResponse.AddOns, and is useful for accessing the field via an interface.
func (v *ListAddOnsResponse) GetAddOns() ListAddOnsAddOnsAddOnConnection { return v.AddOns }

// Autogenerated input type of LockApp
type LockAppInput struct {
	// The ID of the app
	AppId string `json:"appId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
}

// GetAppId returns LockAppInput.AppId, and is useful for accessing the field via an interface.
func (v *LockAppInput) GetAppId() string { return v.AppId }

// GetClientMutationId returns LockAppInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *LockAppInput) GetClientMutationId() string { return v.ClientMutationId }

// LockAppLockAppLockAppPayload includes the requested fields of the GraphQL type LockAppPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of LockApp
type LockAppLockAppLockAppPayload struct {
	// Unique lock ID
	LockId string `json:"lockId"`
	// When this lock automatically expires
	Expiration time.Time `json:"expiration"`
}

// GetLockId returns LockAppLockAppLockAppPayload.LockId, and is useful for accessing the field via an interface.
func (v *LockAppLockAppLockAppPayload) GetLockId() string { return v.LockId }

// GetExpiration returns LockAppLockAppLockAppPayload.Expiration, and is useful for accessing the field via an interface.
func (v *LockAppLockAppLockAppPayload) GetExpiration() time.Time { return v.Expiration }

// LockAppResponse is returned by LockApp on success.
type LockAppResponse struct {
	LockApp LockAppLockAppLockAppPayload `json:"lockApp"`
}

// GetLockApp returns LockAppResponse.LockApp, and is useful for accessing the field via an interface.
func (v *LockAppResponse) GetLockApp() LockAppLockAppLockAppPayload { return v.LockApp }

// MachinesCreateReleaseCreateReleaseCreateReleasePayload includes the requested fields of the GraphQL type CreateReleasePayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateRelease
type MachinesCreateReleaseCreateReleaseCreateReleasePayload struct {
	Release MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease `json:"release"`
}

// GetRelease returns MachinesCreateReleaseCreateReleaseCreateReleasePayload.Release, and is useful for accessing the field via an interface.
func (v *MachinesCreateReleaseCreateReleaseCreateReleasePayload) GetRelease() MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease {
	return v.Release
}

// MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease includes the requested fields of the GraphQL type Release.
type MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease struct {
	// Unique ID
	Id string `json:"id"`
	// The version of the release
	Version int `json:"version"`
}

// GetId returns MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease.Id, and is useful for accessing the field via an interface.
func (v *MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease) GetId() string { return v.Id }

// GetVersion returns MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease.Version, and is useful for accessing the field via an interface.
func (v *MachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease) GetVersion() int {
	return v.Version
}

// MachinesCreateReleaseResponse is returned by MachinesCreateRelease on success.
type MachinesCreateReleaseResponse struct {
	CreateRelease MachinesCreateReleaseCreateReleaseCreateReleasePayload `json:"createRelease"`
}

// GetCreateRelease returns MachinesCreateReleaseResponse.CreateRelease, and is useful for accessing the field via an interface.
func (v *MachinesCreateReleaseResponse) GetCreateRelease() MachinesCreateReleaseCreateReleaseCreateReleasePayload {
	return v.CreateRelease
}

// MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayload includes the requested fields of the GraphQL type CreateReleasePayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateRelease
type MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayload struct {
	Release MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease `json:"release"`
}

// GetRelease returns MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayload.Release, and is useful for accessing the field via an interface.
func (v *MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayload) GetRelease() MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease {
	return v.Release
}

// MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease includes the requested fields of the GraphQL type Release.
type MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease struct {
	// Unique ID
	Id string `json:"id"`
	// The version of the release
	Version int `json:"version"`
}

// GetId returns MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease.Id, and is useful for accessing the field via an interface.
func (v *MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease) GetId() string {
	return v.Id
}

// GetVersion returns MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease.Version, and is useful for accessing the field via an interface.
func (v *MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayloadRelease) GetVersion() int {
	return v.Version
}

// MigrateMachinesCreateReleaseResponse is returned by MigrateMachinesCreateRelease on success.
type MigrateMachinesCreateReleaseResponse struct {
	CreateRelease MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayload `json:"createRelease"`
}

// GetCreateRelease returns MigrateMachinesCreateReleaseResponse.CreateRelease, and is useful for accessing the field via an interface.
func (v *MigrateMachinesCreateReleaseResponse) GetCreateRelease() MigrateMachinesCreateReleaseCreateReleaseCreateReleasePayload {
	return v.CreateRelease
}

type PlatformVersionEnum string

const (
	// App in migration between nomad and machines
	PlatformVersionEnumDetached PlatformVersionEnum = "detached"
	// App with only machines
	PlatformVersionEnumMachines PlatformVersionEnum = "machines"
	// Nomad managed application
	PlatformVersionEnumNomad PlatformVersionEnum = "nomad"
)

// ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayload includes the requested fields of the GraphQL type ResetAddOnPasswordPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of ResetAddOnPassword
type ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayload struct {
	AddOn ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayloadAddOn `json:"addOn"`
}

// GetAddOn returns ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayload.AddOn, and is useful for accessing the field via an interface.
func (v *ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayload) GetAddOn() ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayloadAddOn {
	return v.AddOn
}

// ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayloadAddOn includes the requested fields of the GraphQL type AddOn.
type ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayloadAddOn struct {
	// Public URL for this service
	PublicUrl string `json:"publicUrl"`
}

// GetPublicUrl returns ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayloadAddOn.PublicUrl, and is useful for accessing the field via an interface.
func (v *ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayloadAddOn) GetPublicUrl() string {
	return v.PublicUrl
}

// ResetAddOnPasswordResponse is returned by ResetAddOnPassword on success.
type ResetAddOnPasswordResponse struct {
	ResetAddOnPassword ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayload `json:"resetAddOnPassword"`
}

// GetResetAddOnPassword returns ResetAddOnPasswordResponse.ResetAddOnPassword, and is useful for accessing the field via an interface.
func (v *ResetAddOnPasswordResponse) GetResetAddOnPassword() ResetAddOnPasswordResetAddOnPasswordResetAddOnPasswordPayload {
	return v.ResetAddOnPassword
}

// ResolverCreateBuildCreateBuildCreateBuildPayload includes the requested fields of the GraphQL type CreateBuildPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateBuild
type ResolverCreateBuildCreateBuildCreateBuildPayload struct {
	// build id
	Id string `json:"id"`
	// stored build status
	Status string `json:"status"`
}

// GetId returns ResolverCreateBuildCreateBuildCreateBuildPayload.Id, and is useful for accessing the field via an interface.
func (v *ResolverCreateBuildCreateBuildCreateBuildPayload) GetId() string { return v.Id }

// GetStatus returns ResolverCreateBuildCreateBuildCreateBuildPayload.Status, and is useful for accessing the field via an interface.
func (v *ResolverCreateBuildCreateBuildCreateBuildPayload) GetStatus() string { return v.Status }

// ResolverCreateBuildResponse is returned by ResolverCreateBuild on success.
type ResolverCreateBuildResponse struct {
	CreateBuild ResolverCreateBuildCreateBuildCreateBuildPayload `json:"createBuild"`
}

// GetCreateBuild returns ResolverCreateBuildResponse.CreateBuild, and is useful for accessing the field via an interface.
func (v *ResolverCreateBuildResponse) GetCreateBuild() ResolverCreateBuildCreateBuildCreateBuildPayload {
	return v.CreateBuild
}

// ResolverFinishBuildFinishBuildFinishBuildPayload includes the requested fields of the GraphQL type FinishBuildPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of FinishBuild
type ResolverFinishBuildFinishBuildFinishBuildPayload struct {
	// build id
	Id string `json:"id"`
	// stored build status
	Status string `json:"status"`
	// wall clock time for this build
	WallclockTimeMs int `json:"wallclockTimeMs"`
}

// GetId returns ResolverFinishBuildFinishBuildFinishBuildPayload.Id, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildFinishBuildFinishBuildPayload) GetId() string { return v.Id }

// GetStatus returns ResolverFinishBuildFinishBuildFinishBuildPayload.Status, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildFinishBuildFinishBuildPayload) GetStatus() string { return v.Status }

// GetWallclockTimeMs returns ResolverFinishBuildFinishBuildFinishBuildPayload.WallclockTimeMs, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildFinishBuildFinishBuildPayload) GetWallclockTimeMs() int {
	return v.WallclockTimeMs
}

// ResolverFinishBuildResponse is returned by ResolverFinishBuild on success.
type ResolverFinishBuildResponse struct {
	FinishBuild ResolverFinishBuildFinishBuildFinishBuildPayload `json:"finishBuild"`
}

// GetFinishBuild returns ResolverFinishBuildResponse.FinishBuild, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildResponse) GetFinishBuild() ResolverFinishBuildFinishBuildFinishBuildPayload {
	return v.FinishBuild
}

type RuntimeType string

const (
	// Fly Container Runtime
	RuntimeTypeFirecracker RuntimeType = "FIRECRACKER"
	// Fly JavaScript Runtime
	RuntimeTypeNodeproxy RuntimeType = "NODEPROXY"
)

// A secure configuration value
type SecretInput struct {
	// The unqiue key for this secret
	Key string `json:"key"`
	// The value of this secret
	Value string `json:"value"`
}

// GetKey returns SecretInput.Key, and is useful for accessing the field via an interface.
func (v *SecretInput) GetKey() string { return v.Key }

// GetValue returns SecretInput.Value, and is useful for accessing the field via an interface.
func (v *SecretInput) GetValue() string { return v.Value }

// Autogenerated input type of SetAppsv2DefaultOn
type SetAppsv2DefaultOnInput struct {
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Whether or not new apps in this org use Apps V2 by default
	DefaultOn bool `json:"defaultOn"`
	// The organization slug
	OrganizationSlug string `json:"organizationSlug"`
}

// GetClientMutationId returns SetAppsv2DefaultOnInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *SetAppsv2DefaultOnInput) GetClientMutationId() string { return v.ClientMutationId }

// GetDefaultOn returns SetAppsv2DefaultOnInput.DefaultOn, and is useful for accessing the field via an interface.
func (v *SetAppsv2DefaultOnInput) GetDefaultOn() bool { return v.DefaultOn }

// GetOrganizationSlug returns SetAppsv2DefaultOnInput.OrganizationSlug, and is useful for accessing the field via an interface.
func (v *SetAppsv2DefaultOnInput) GetOrganizationSlug() string { return v.OrganizationSlug }

// SetNomadVMCountResponse is returned by SetNomadVMCount on success.
type SetNomadVMCountResponse struct {
	SetVmCount SetNomadVMCountSetVmCountSetVMCountPayload `json:"setVmCount"`
}

// GetSetVmCount returns SetNomadVMCountResponse.SetVmCount, and is useful for accessing the field via an interface.
func (v *SetNomadVMCountResponse) GetSetVmCount() SetNomadVMCountSetVmCountSetVMCountPayload {
	return v.SetVmCount
}

// SetNomadVMCountSetVmCountSetVMCountPayload includes the requested fields of the GraphQL type SetVMCountPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of SetVMCount
type SetNomadVMCountSetVmCountSetVMCountPayload struct {
	TaskGroupCounts []SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount `json:"taskGroupCounts"`
	Warnings        []string                                                                  `json:"warnings"`
}

// GetTaskGroupCounts returns SetNomadVMCountSetVmCountSetVMCountPayload.TaskGroupCounts, and is useful for accessing the field via an interface.
func (v *SetNomadVMCountSetVmCountSetVMCountPayload) GetTaskGroupCounts() []SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount {
	return v.TaskGroupCounts
}

// GetWarnings returns SetNomadVMCountSetVmCountSetVMCountPayload.Warnings, and is useful for accessing the field via an interface.
func (v *SetNomadVMCountSetVmCountSetVMCountPayload) GetWarnings() []string { return v.Warnings }

// SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount includes the requested fields of the GraphQL type TaskGroupCount.
type SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount struct {
	Name  string `json:"name"`
	Count int    `json:"count"`
}

// GetName returns SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount.Name, and is useful for accessing the field via an interface.
func (v *SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount) GetName() string {
	return v.Name
}

// GetCount returns SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount.Count, and is useful for accessing the field via an interface.
func (v *SetNomadVMCountSetVmCountSetVMCountPayloadTaskGroupCountsTaskGroupCount) GetCount() int {
	return v.Count
}

// SetOrgSettingsResponse is returned by SetOrgSettings on success.
type SetOrgSettingsResponse struct {
	SetAppsV2DefaultOn SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayload `json:"setAppsV2DefaultOn"`
}

// GetSetAppsV2DefaultOn returns SetOrgSettingsResponse.SetAppsV2DefaultOn, and is useful for accessing the field via an interface.
func (v *SetOrgSettingsResponse) GetSetAppsV2DefaultOn() SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayload {
	return v.SetAppsV2DefaultOn
}

// SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayload includes the requested fields of the GraphQL type SetAppsv2DefaultOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of SetAppsv2DefaultOn
type SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayload struct {
	Organization SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayloadOrganization `json:"organization"`
}

// GetOrganization returns SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayload.Organization, and is useful for accessing the field via an interface.
func (v *SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayload) GetOrganization() SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayloadOrganization {
	return v.Organization
}

// SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayloadOrganization includes the requested fields of the GraphQL type Organization.
type SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayloadOrganization struct {
	Settings interface{} `json:"settings"`
}

// GetSettings returns SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayloadOrganization.Settings, and is useful for accessing the field via an interface.
func (v *SetOrgSettingsSetAppsV2DefaultOnSetAppsv2DefaultOnPayloadOrganization) GetSettings() interface{} {
	return v.Settings
}

// Autogenerated input type of SetPlatformVersion
type SetPlatformVersionInput struct {
	// The ID of the app
	AppId string `json:"appId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Unique lock ID
	LockId string `json:"lockId"`
	// nomad or machines
	PlatformVersion string `json:"platformVersion"`
}

// GetAppId returns SetPlatformVersionInput.AppId, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionInput) GetAppId() string { return v.AppId }

// GetClientMutationId returns SetPlatformVersionInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionInput) GetClientMutationId() string { return v.ClientMutationId }

// GetLockId returns SetPlatformVersionInput.LockId, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionInput) GetLockId() string { return v.LockId }

// GetPlatformVersion returns SetPlatformVersionInput.PlatformVersion, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionInput) GetPlatformVersion() string { return v.PlatformVersion }

// SetPlatformVersionResponse is returned by SetPlatformVersion on success.
type SetPlatformVersionResponse struct {
	SetPlatformVersion SetPlatformVersionSetPlatformVersionSetPlatformVersionPayload `json:"setPlatformVersion"`
}

// GetSetPlatformVersion returns SetPlatformVersionResponse.SetPlatformVersion, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionResponse) GetSetPlatformVersion() SetPlatformVersionSetPlatformVersionSetPlatformVersionPayload {
	return v.SetPlatformVersion
}

// SetPlatformVersionSetPlatformVersionSetPlatformVersionPayload includes the requested fields of the GraphQL type SetPlatformVersionPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of SetPlatformVersion
type SetPlatformVersionSetPlatformVersionSetPlatformVersionPayload struct {
	App SetPlatformVersionSetPlatformVersionSetPlatformVersionPayloadApp `json:"app"`
}

// GetApp returns SetPlatformVersionSetPlatformVersionSetPlatformVersionPayload.App, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionSetPlatformVersionSetPlatformVersionPayload) GetApp() SetPlatformVersionSetPlatformVersionSetPlatformVersionPayloadApp {
	return v.App
}

// SetPlatformVersionSetPlatformVersionSetPlatformVersionPayloadApp includes the requested fields of the GraphQL type App.
type SetPlatformVersionSetPlatformVersionSetPlatformVersionPayloadApp struct {
	// Unique application ID
	Id string `json:"id"`
}

// GetId returns SetPlatformVersionSetPlatformVersionSetPlatformVersionPayloadApp.Id, and is useful for accessing the field via an interface.
func (v *SetPlatformVersionSetPlatformVersionSetPlatformVersionPayloadApp) GetId() string {
	return v.Id
}

// Autogenerated input type of SetSecrets
type SetSecretsInput struct {
	// The ID of the app
	AppId string `json:"appId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// By default, we set only the secrets you specify. Set this to true to replace all secrets.
	ReplaceAll bool `json:"replaceAll"`
	// Secrets to set
	Secrets []SecretInput `json:"secrets"`
}

// GetAppId returns SetSecretsInput.AppId, and is useful for accessing the field via an interface.
func (v *SetSecretsInput) GetAppId() string { return v.AppId }

// GetClientMutationId returns SetSecretsInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *SetSecretsInput) GetClientMutationId() string { return v.ClientMutationId }

// GetReplaceAll returns SetSecretsInput.ReplaceAll, and is useful for accessing the field via an interface.
func (v *SetSecretsInput) GetReplaceAll() bool { return v.ReplaceAll }

// GetSecrets returns SetSecretsInput.Secrets, and is useful for accessing the field via an interface.
func (v *SetSecretsInput) GetSecrets() []SecretInput { return v.Secrets }

// SetSecretsResponse is returned by SetSecrets on success.
type SetSecretsResponse struct {
	SetSecrets SetSecretsSetSecretsSetSecretsPayload `json:"setSecrets"`
}

// GetSetSecrets returns SetSecretsResponse.SetSecrets, and is useful for accessing the field via an interface.
func (v *SetSecretsResponse) GetSetSecrets() SetSecretsSetSecretsSetSecretsPayload {
	return v.SetSecrets
}

// SetSecretsSetSecretsSetSecretsPayload includes the requested fields of the GraphQL type SetSecretsPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of SetSecrets
type SetSecretsSetSecretsSetSecretsPayload struct {
	Release SetSecretsSetSecretsSetSecretsPayloadRelease `json:"release"`
}

// GetRelease returns SetSecretsSetSecretsSetSecretsPayload.Release, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayload) GetRelease() SetSecretsSetSecretsSetSecretsPayloadRelease {
	return v.Release
}

// SetSecretsSetSecretsSetSecretsPayloadRelease includes the requested fields of the GraphQL type Release.
type SetSecretsSetSecretsSetSecretsPayloadRelease struct {
	// Unique ID
	Id string `json:"id"`
	// The version of the release
	Version int `json:"version"`
	// The reason for the release
	Reason string `json:"reason"`
	// A description of the release
	Description string `json:"description"`
	// The user who created the release
	User         SetSecretsSetSecretsSetSecretsPayloadReleaseUser `json:"user"`
	EvaluationId string                                           `json:"evaluationId"`
	CreatedAt    time.Time                                        `json:"createdAt"`
}

// GetId returns SetSecretsSetSecretsSetSecretsPayloadRelease.Id, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetId() string { return v.Id }

// GetVersion returns SetSecretsSetSecretsSetSecretsPayloadRelease.Version, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetVersion() int { return v.Version }

// GetReason returns SetSecretsSetSecretsSetSecretsPayloadRelease.Reason, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetReason() string { return v.Reason }

// GetDescription returns SetSecretsSetSecretsSetSecretsPayloadRelease.Description, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetDescription() string { return v.Description }

// GetUser returns SetSecretsSetSecretsSetSecretsPayloadRelease.User, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetUser() SetSecretsSetSecretsSetSecretsPayloadReleaseUser {
	return v.User
}

// GetEvaluationId returns SetSecretsSetSecretsSetSecretsPayloadRelease.EvaluationId, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetEvaluationId() string {
	return v.EvaluationId
}

// GetCreatedAt returns SetSecretsSetSecretsSetSecretsPayloadRelease.CreatedAt, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadRelease) GetCreatedAt() time.Time { return v.CreatedAt }

// SetSecretsSetSecretsSetSecretsPayloadReleaseUser includes the requested fields of the GraphQL type User.
type SetSecretsSetSecretsSetSecretsPayloadReleaseUser struct {
	Id string `json:"id"`
	// Email address for user (private)
	Email string `json:"email"`
	// Display / full name for user (private)
	Name string `json:"name"`
}

// GetId returns SetSecretsSetSecretsSetSecretsPayloadReleaseUser.Id, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadReleaseUser) GetId() string { return v.Id }

// GetEmail returns SetSecretsSetSecretsSetSecretsPayloadReleaseUser.Email, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadReleaseUser) GetEmail() string { return v.Email }

// GetName returns SetSecretsSetSecretsSetSecretsPayloadReleaseUser.Name, and is useful for accessing the field via an interface.
func (v *SetSecretsSetSecretsSetSecretsPayloadReleaseUser) GetName() string { return v.Name }

// Autogenerated input type of SetVMCount
type SetVMCountInput struct {
	// The ID of the app
	AppId string `json:"appId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Counts for VM groups
	GroupCounts []VMCountInput `json:"groupCounts"`
	// Unique lock ID
	LockId string `json:"lockId"`
}

// GetAppId returns SetVMCountInput.AppId, and is useful for accessing the field via an interface.
func (v *SetVMCountInput) GetAppId() string { return v.AppId }

// GetClientMutationId returns SetVMCountInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *SetVMCountInput) GetClientMutationId() string { return v.ClientMutationId }

// GetGroupCounts returns SetVMCountInput.GroupCounts, and is useful for accessing the field via an interface.
func (v *SetVMCountInput) GetGroupCounts() []VMCountInput { return v.GroupCounts }

// GetLockId returns SetVMCountInput.LockId, and is useful for accessing the field via an interface.
func (v *SetVMCountInput) GetLockId() string { return v.LockId }

// Autogenerated input type of UnlockApp
type UnlockAppInput struct {
	// The ID of the app
	AppId string `json:"appId"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Unique lock ID
	LockId string `json:"lockId"`
}

// GetAppId returns UnlockAppInput.AppId, and is useful for accessing the field via an interface.
func (v *UnlockAppInput) GetAppId() string { return v.AppId }

// GetClientMutationId returns UnlockAppInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *UnlockAppInput) GetClientMutationId() string { return v.ClientMutationId }

// GetLockId returns UnlockAppInput.LockId, and is useful for accessing the field via an interface.
func (v *UnlockAppInput) GetLockId() string { return v.LockId }

// UnlockAppResponse is returned by UnlockApp on success.
type UnlockAppResponse struct {
	UnlockApp UnlockAppUnlockAppUnlockAppPayload `json:"unlockApp"`
}

// GetUnlockApp returns UnlockAppResponse.UnlockApp, and is useful for accessing the field via an interface.
func (v *UnlockAppResponse) GetUnlockApp() UnlockAppUnlockAppUnlockAppPayload { return v.UnlockApp }

// UnlockAppUnlockAppUnlockAppPayload includes the requested fields of the GraphQL type UnlockAppPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of UnlockApp
type UnlockAppUnlockAppUnlockAppPayload struct {
	App UnlockAppUnlockAppUnlockAppPayloadApp `json:"app"`
}

// GetApp returns UnlockAppUnlockAppUnlockAppPayload.App, and is useful for accessing the field via an interface.
func (v *UnlockAppUnlockAppUnlockAppPayload) GetApp() UnlockAppUnlockAppUnlockAppPayloadApp {
	return v.App
}

// UnlockAppUnlockAppUnlockAppPayloadApp includes the requested fields of the GraphQL type App.
type UnlockAppUnlockAppUnlockAppPayloadApp struct {
	// Unique application ID
	Id string `json:"id"`
}

// GetId returns UnlockAppUnlockAppUnlockAppPayloadApp.Id, and is useful for accessing the field via an interface.
func (v *UnlockAppUnlockAppUnlockAppPayloadApp) GetId() string { return v.Id }

// UpdateAddOnResponse is returned by UpdateAddOn on success.
type UpdateAddOnResponse struct {
	UpdateAddOn UpdateAddOnUpdateAddOnUpdateAddOnPayload `json:"updateAddOn"`
}

// GetUpdateAddOn returns UpdateAddOnResponse.UpdateAddOn, and is useful for accessing the field via an interface.
func (v *UpdateAddOnResponse) GetUpdateAddOn() UpdateAddOnUpdateAddOnUpdateAddOnPayload {
	return v.UpdateAddOn
}

// UpdateAddOnUpdateAddOnUpdateAddOnPayload includes the requested fields of the GraphQL type UpdateAddOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of UpdateAddOn
type UpdateAddOnUpdateAddOnUpdateAddOnPayload struct {
	AddOn UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn `json:"addOn"`
}

// GetAddOn returns UpdateAddOnUpdateAddOnUpdateAddOnPayload.AddOn, and is useful for accessing the field via an interface.
func (v *UpdateAddOnUpdateAddOnUpdateAddOnPayload) GetAddOn() UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn {
	return v.AddOn
}

// UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn includes the requested fields of the GraphQL type AddOn.
type UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn struct {
	Id string `json:"id"`
}

// GetId returns UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn.Id, and is useful for accessing the field via an interface.
func (v *UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn) GetId() string { return v.Id }

type VMCountInput struct {
	// The desired count
	Count int `json:"count"`
	// VM group name
	Group string `json:"group"`
	// Max number of VMs to allow per region
	MaxPerRegion int `json:"maxPerRegion"`
}

// GetCount returns VMCountInput.Count, and is useful for accessing the field via an interface.
func (v *VMCountInput) GetCount() int { return v.Count }

// GetGroup returns VMCountInput.Group, and is useful for accessing the field via an interface.
func (v *VMCountInput) GetGroup() string { return v.Group }

// GetMaxPerRegion returns VMCountInput.MaxPerRegion, and is useful for accessing the field via an interface.
func (v *VMCountInput) GetMaxPerRegion() int { return v.MaxPerRegion }

// __AgentGetInstancesInput is used internally by genqlient
type __AgentGetInstancesInput struct {
	AppName string `json:"appName"`
}

// GetAppName returns __AgentGetInstancesInput.AppName, and is useful for accessing the field via an interface.
func (v *__AgentGetInstancesInput) GetAppName() string { return v.AppName }

// __CreateAddOnInput is used internally by genqlient
type __CreateAddOnInput struct {
	OrganizationId string      `json:"organizationId"`
	PrimaryRegion  string      `json:"primaryRegion"`
	Name           string      `json:"name"`
	PlanId         string      `json:"planId"`
	ReadRegions    []string    `json:"readRegions"`
	AddOnType      AddOnType   `json:"addOnType"`
	Options        interface{} `json:"options"`
}

// GetOrganizationId returns __CreateAddOnInput.OrganizationId, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetOrganizationId() string { return v.OrganizationId }

// GetPrimaryRegion returns __CreateAddOnInput.PrimaryRegion, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetPrimaryRegion() string { return v.PrimaryRegion }

// GetName returns __CreateAddOnInput.Name, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetName() string { return v.Name }

// GetPlanId returns __CreateAddOnInput.PlanId, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetPlanId() string { return v.PlanId }

// GetReadRegions returns __CreateAddOnInput.ReadRegions, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetReadRegions() []string { return v.ReadRegions }

// GetAddOnType returns __CreateAddOnInput.AddOnType, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetAddOnType() AddOnType { return v.AddOnType }

// GetOptions returns __CreateAddOnInput.Options, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetOptions() interface{} { return v.Options }

// __CreateAppInput is used internally by genqlient
type __CreateAppInput struct {
	Input CreateAppInput `json:"input"`
}

// GetInput returns __CreateAppInput.Input, and is useful for accessing the field via an interface.
func (v *__CreateAppInput) GetInput() CreateAppInput { return v.Input }

// __CreateLimitedAccessTokenInput is used internally by genqlient
type __CreateLimitedAccessTokenInput struct {
	Name           string      `json:"name"`
	OrganizationId string      `json:"organizationId"`
	Profile        string      `json:"profile"`
	ProfileParams  interface{} `json:"profileParams"`
	Expiry         string      `json:"expiry"`
}

// GetName returns __CreateLimitedAccessTokenInput.Name, and is useful for accessing the field via an interface.
func (v *__CreateLimitedAccessTokenInput) GetName() string { return v.Name }

// GetOrganizationId returns __CreateLimitedAccessTokenInput.OrganizationId, and is useful for accessing the field via an interface.
func (v *__CreateLimitedAccessTokenInput) GetOrganizationId() string { return v.OrganizationId }

// GetProfile returns __CreateLimitedAccessTokenInput.Profile, and is useful for accessing the field via an interface.
func (v *__CreateLimitedAccessTokenInput) GetProfile() string { return v.Profile }

// GetProfileParams returns __CreateLimitedAccessTokenInput.ProfileParams, and is useful for accessing the field via an interface.
func (v *__CreateLimitedAccessTokenInput) GetProfileParams() interface{} { return v.ProfileParams }

// GetExpiry returns __CreateLimitedAccessTokenInput.Expiry, and is useful for accessing the field via an interface.
func (v *__CreateLimitedAccessTokenInput) GetExpiry() string { return v.Expiry }

// __DeleteAddOnInput is used internally by genqlient
type __DeleteAddOnInput struct {
	Name string `json:"name"`
}

// GetName returns __DeleteAddOnInput.Name, and is useful for accessing the field via an interface.
func (v *__DeleteAddOnInput) GetName() string { return v.Name }

// __FlyctlConfigCurrentReleaseInput is used internally by genqlient
type __FlyctlConfigCurrentReleaseInput struct {
	AppName string `json:"appName"`
}

// GetAppName returns __FlyctlConfigCurrentReleaseInput.AppName, and is useful for accessing the field via an interface.
func (v *__FlyctlConfigCurrentReleaseInput) GetAppName() string { return v.AppName }

// __FlyctlDeployGetLatestImageInput is used internally by genqlient
type __FlyctlDeployGetLatestImageInput struct {
	AppName string `json:"appName"`
}

// GetAppName returns __FlyctlDeployGetLatestImageInput.AppName, and is useful for accessing the field via an interface.
func (v *__FlyctlDeployGetLatestImageInput) GetAppName() string { return v.AppName }

// __GetAddOnInput is used internally by genqlient
type __GetAddOnInput struct {
	Name string `json:"name"`
}

// GetName returns __GetAddOnInput.Name, and is useful for accessing the field via an interface.
func (v *__GetAddOnInput) GetName() string { return v.Name }

// __GetAddOnProviderInput is used internally by genqlient
type __GetAddOnProviderInput struct {
	Name string `json:"name"`
}

// GetName returns __GetAddOnProviderInput.Name, and is useful for accessing the field via an interface.
func (v *__GetAddOnProviderInput) GetName() string { return v.Name }

// __GetAppInput is used internally by genqlient
type __GetAppInput struct {
	Name string `json:"name"`
}

// GetName returns __GetAppInput.Name, and is useful for accessing the field via an interface.
func (v *__GetAppInput) GetName() string { return v.Name }

// __GetAppsByRoleInput is used internally by genqlient
type __GetAppsByRoleInput struct {
	Role           string `json:"role"`
	OrganizationId string `json:"organizationId"`
}

// GetRole returns __GetAppsByRoleInput.Role, and is useful for accessing the field via an interface.
func (v *__GetAppsByRoleInput) GetRole() string { return v.Role }

// GetOrganizationId returns __GetAppsByRoleInput.OrganizationId, and is useful for accessing the field via an interface.
func (v *__GetAppsByRoleInput) GetOrganizationId() string { return v.OrganizationId }

// __GetOrganizationInput is used internally by genqlient
type __GetOrganizationInput struct {
	Slug string `json:"slug"`
}

// GetSlug returns __GetOrganizationInput.Slug, and is useful for accessing the field via an interface.
func (v *__GetOrganizationInput) GetSlug() string { return v.Slug }

// __ListAddOnsInput is used internally by genqlient
type __ListAddOnsInput struct {
	AddOnType AddOnType `json:"addOnType"`
}

// GetAddOnType returns __ListAddOnsInput.AddOnType, and is useful for accessing the field via an interface.
func (v *__ListAddOnsInput) GetAddOnType() AddOnType { return v.AddOnType }

// __LockAppInput is used internally by genqlient
type __LockAppInput struct {
	Input LockAppInput `json:"input"`
}

// GetInput returns __LockAppInput.Input, and is useful for accessing the field via an interface.
func (v *__LockAppInput) GetInput() LockAppInput { return v.Input }

// __MachinesCreateReleaseInput is used internally by genqlient
type __MachinesCreateReleaseInput struct {
	Input CreateReleaseInput `json:"input"`
}

// GetInput returns __MachinesCreateReleaseInput.Input, and is useful for accessing the field via an interface.
func (v *__MachinesCreateReleaseInput) GetInput() CreateReleaseInput { return v.Input }

// __MigrateMachinesCreateReleaseInput is used internally by genqlient
type __MigrateMachinesCreateReleaseInput struct {
	Input CreateReleaseInput `json:"input"`
}

// GetInput returns __MigrateMachinesCreateReleaseInput.Input, and is useful for accessing the field via an interface.
func (v *__MigrateMachinesCreateReleaseInput) GetInput() CreateReleaseInput { return v.Input }

// __ResetAddOnPasswordInput is used internally by genqlient
type __ResetAddOnPasswordInput struct {
	Name string `json:"name"`
}

// GetName returns __ResetAddOnPasswordInput.Name, and is useful for accessing the field via an interface.
func (v *__ResetAddOnPasswordInput) GetName() string { return v.Name }

// __ResolverCreateBuildInput is used internally by genqlient
type __ResolverCreateBuildInput struct {
	Input CreateBuildInput `json:"input"`
}

// GetInput returns __ResolverCreateBuildInput.Input, and is useful for accessing the field via an interface.
func (v *__ResolverCreateBuildInput) GetInput() CreateBuildInput { return v.Input }

// __ResolverFinishBuildInput is used internally by genqlient
type __ResolverFinishBuildInput struct {
	Input FinishBuildInput `json:"input"`
}

// GetInput returns __ResolverFinishBuildInput.Input, and is useful for accessing the field via an interface.
func (v *__ResolverFinishBuildInput) GetInput() FinishBuildInput { return v.Input }

// __SetNomadVMCountInput is used internally by genqlient
type __SetNomadVMCountInput struct {
	Input SetVMCountInput `json:"input"`
}

// GetInput returns __SetNomadVMCountInput.Input, and is useful for accessing the field via an interface.
func (v *__SetNomadVMCountInput) GetInput() SetVMCountInput { return v.Input }

// __SetOrgSettingsInput is used internally by genqlient
type __SetOrgSettingsInput struct {
	Input SetAppsv2DefaultOnInput `json:"input"`
}

// GetInput returns __SetOrgSettingsInput.Input, and is useful for accessing the field via an interface.
func (v *__SetOrgSettingsInput) GetInput() SetAppsv2DefaultOnInput { return v.Input }

// __SetPlatformVersionInput is used internally by genqlient
type __SetPlatformVersionInput struct {
	Input SetPlatformVersionInput `json:"input"`
}

// GetInput returns __SetPlatformVersionInput.Input, and is useful for accessing the field via an interface.
func (v *__SetPlatformVersionInput) GetInput() SetPlatformVersionInput { return v.Input }

// __SetSecretsInput is used internally by genqlient
type __SetSecretsInput struct {
	Input SetSecretsInput `json:"input"`
}

// GetInput returns __SetSecretsInput.Input, and is useful for accessing the field via an interface.
func (v *__SetSecretsInput) GetInput() SetSecretsInput { return v.Input }

// __UnlockAppInput is used internally by genqlient
type __UnlockAppInput struct {
	Input UnlockAppInput `json:"input"`
}

// GetInput returns __UnlockAppInput.Input, and is useful for accessing the field via an interface.
func (v *__UnlockAppInput) GetInput() UnlockAppInput { return v.Input }

// __UpdateAddOnInput is used internally by genqlient
type __UpdateAddOnInput struct {
	AddOnId     string      `json:"addOnId"`
	PlanId      string      `json:"planId"`
	ReadRegions []string    `json:"readRegions"`
	Options     interface{} `json:"options"`
}

// GetAddOnId returns __UpdateAddOnInput.AddOnId, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetAddOnId() string { return v.AddOnId }

// GetPlanId returns __UpdateAddOnInput.PlanId, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetPlanId() string { return v.PlanId }

// GetReadRegions returns __UpdateAddOnInput.ReadRegions, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetReadRegions() []string { return v.ReadRegions }

// GetOptions returns __UpdateAddOnInput.Options, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetOptions() interface{} { return v.Options }

func AgentGetInstances(
	ctx context.Context,
	client graphql.Client,
	appName string,
) (*AgentGetInstancesResponse, error) {
	req := &graphql.Request{
		OpName: "AgentGetInstances",
		Query: `
query AgentGetInstances ($appName: String!) {
	app(name: $appName) {
		organization {
			slug
		}
		id
		name
		allocations(showCompleted: false) {
			id
			region
			privateIP
		}
		machines {
			nodes {
				id
				region
				ips {
					nodes {
						kind
						family
						ip
					}
				}
			}
		}
	}
}
`,
		Variables: &__AgentGetInstancesInput{
			AppName: appName,
		},
	}
	var err error

	var data AgentGetInstancesResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func CreateAddOn(
	ctx context.Context,
	client graphql.Client,
	organizationId string,
	primaryRegion string,
	name string,
	planId string,
	readRegions []string,
	addOnType AddOnType,
	options interface{},
) (*CreateAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "CreateAddOn",
		Query: `
mutation CreateAddOn ($organizationId: ID!, $primaryRegion: String, $name: String, $planId: ID, $readRegions: [String!], $addOnType: AddOnType!, $options: JSON!) {
	createAddOn(input: {organizationId:$organizationId,type:$addOnType,name:$name,planId:$planId,primaryRegion:$primaryRegion,readRegions:$readRegions,options:$options}) {
		addOn {
			name
			publicUrl
			ssoLink
			token
		}
	}
}
`,
		Variables: &__CreateAddOnInput{
			OrganizationId: organizationId,
			PrimaryRegion:  primaryRegion,
			Name:           name,
			PlanId:         planId,
			ReadRegions:    readRegions,
			AddOnType:      addOnType,
			Options:        options,
		},
	}
	var err error

	var data CreateAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func CreateApp(
	ctx context.Context,
	client graphql.Client,
	input CreateAppInput,
) (*CreateAppResponse, error) {
	req := &graphql.Request{
		OpName: "CreateApp",
		Query: `
mutation CreateApp ($input: CreateAppInput!) {
	createApp(input: $input) {
		app {
			... AppData
			config {
				definition
			}
			regions {
				name
				code
			}
		}
	}
}
fragment AppData on App {
	id
	name
	platformVersion
	organization {
		id
		slug
		rawSlug
		paidPlan
	}
}
`,
		Variables: &__CreateAppInput{
			Input: input,
		},
	}
	var err error

	var data CreateAppResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func CreateLimitedAccessToken(
	ctx context.Context,
	client graphql.Client,
	name string,
	organizationId string,
	profile string,
	profileParams interface{},
	expiry string,
) (*CreateLimitedAccessTokenResponse, error) {
	req := &graphql.Request{
		OpName: "CreateLimitedAccessToken",
		Query: `
mutation CreateLimitedAccessToken ($name: String!, $organizationId: ID!, $profile: String!, $profileParams: JSON, $expiry: String!) {
	createLimitedAccessToken(input: {name:$name,organizationId:$organizationId,profile:$profile,profileParams:$profileParams,expiry:$expiry}) {
		limitedAccessToken {
			tokenHeader
		}
	}
}
`,
		Variables: &__CreateLimitedAccessTokenInput{
			Name:           name,
			OrganizationId: organizationId,
			Profile:        profile,
			ProfileParams:  profileParams,
			Expiry:         expiry,
		},
	}
	var err error

	var data CreateLimitedAccessTokenResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func DeleteAddOn(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*DeleteAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "DeleteAddOn",
		Query: `
mutation DeleteAddOn ($name: String) {
	deleteAddOn(input: {name:$name}) {
		deletedAddOnName
	}
}
`,
		Variables: &__DeleteAddOnInput{
			Name: name,
		},
	}
	var err error

	var data DeleteAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func FlyctlConfigCurrentRelease(
	ctx context.Context,
	client graphql.Client,
	appName string,
) (*FlyctlConfigCurrentReleaseResponse, error) {
	req := &graphql.Request{
		OpName: "FlyctlConfigCurrentRelease",
		Query: `
query FlyctlConfigCurrentRelease ($appName: String!) {
	app(name: $appName) {
		currentReleaseUnprocessed {
			configDefinition
		}
	}
}
`,
		Variables: &__FlyctlConfigCurrentReleaseInput{
			AppName: appName,
		},
	}
	var err error

	var data FlyctlConfigCurrentReleaseResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func FlyctlDeployGetLatestImage(
	ctx context.Context,
	client graphql.Client,
	appName string,
) (*FlyctlDeployGetLatestImageResponse, error) {
	req := &graphql.Request{
		OpName: "FlyctlDeployGetLatestImage",
		Query: `
query FlyctlDeployGetLatestImage ($appName: String!) {
	app(name: $appName) {
		currentReleaseUnprocessed {
			id
			version
			imageRef
		}
	}
}
`,
		Variables: &__FlyctlDeployGetLatestImageInput{
			AppName: appName,
		},
	}
	var err error

	var data FlyctlDeployGetLatestImageResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetAddOn(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*GetAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "GetAddOn",
		Query: `
query GetAddOn ($name: String) {
	addOn(name: $name) {
		id
		name
		publicUrl
		privateIp
		password
		token
		primaryRegion
		readRegions
		options
		ssoLink
		organization {
			slug
			paidPlan
		}
		addOnPlan {
			id
			name
			displayName
		}
	}
}
`,
		Variables: &__GetAddOnInput{
			Name: name,
		},
	}
	var err error

	var data GetAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetAddOnProvider(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*GetAddOnProviderResponse, error) {
	req := &graphql.Request{
		OpName: "GetAddOnProvider",
		Query: `
query GetAddOnProvider ($name: String!) {
	addOnProvider(name: $name) {
		id
		name
		excludedRegions {
			code
		}
	}
}
`,
		Variables: &__GetAddOnProviderInput{
			Name: name,
		},
	}
	var err error

	var data GetAddOnProviderResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetApp(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*GetAppResponse, error) {
	req := &graphql.Request{
		OpName: "GetApp",
		Query: `
query GetApp ($name: String!) {
	app(name: $name) {
		... AppData
	}
}
fragment AppData on App {
	id
	name
	platformVersion
	organization {
		id
		slug
		rawSlug
		paidPlan
	}
}
`,
		Variables: &__GetAppInput{
			Name: name,
		},
	}
	var err error

	var data GetAppResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetAppsByRole(
	ctx context.Context,
	client graphql.Client,
	role string,
	organizationId string,
) (*GetAppsByRoleResponse, error) {
	req := &graphql.Request{
		OpName: "GetAppsByRole",
		Query: `
query GetAppsByRole ($role: String!, $organizationId: ID!) {
	apps(role: $role, organizationId: $organizationId) {
		nodes {
			... AppData
		}
	}
}
fragment AppData on App {
	id
	name
	platformVersion
	organization {
		id
		slug
		rawSlug
		paidPlan
	}
}
`,
		Variables: &__GetAppsByRoleInput{
			Role:           role,
			OrganizationId: organizationId,
		},
	}
	var err error

	var data GetAppsByRoleResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetNearestRegion(
	ctx context.Context,
	client graphql.Client,
) (*GetNearestRegionResponse, error) {
	req := &graphql.Request{
		OpName: "GetNearestRegion",
		Query: `
query GetNearestRegion {
	nearestRegion {
		code
		name
		gatewayAvailable
	}
}
`,
	}
	var err error

	var data GetNearestRegionResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetOrganization(
	ctx context.Context,
	client graphql.Client,
	slug string,
) (*GetOrganizationResponse, error) {
	req := &graphql.Request{
		OpName: "GetOrganization",
		Query: `
query GetOrganization ($slug: String!) {
	organization(slug: $slug) {
		id
		name
		slug
		addOnSsoLink
	}
}
`,
		Variables: &__GetOrganizationInput{
			Slug: slug,
		},
	}
	var err error

	var data GetOrganizationResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ListAddOnPlans(
	ctx context.Context,
	client graphql.Client,
) (*ListAddOnPlansResponse, error) {
	req := &graphql.Request{
		OpName: "ListAddOnPlans",
		Query: `
query ListAddOnPlans {
	addOnPlans {
		nodes {
			id
			displayName
			maxDataSize
			pricePerMonth
		}
	}
}
`,
	}
	var err error

	var data ListAddOnPlansResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ListAddOns(
	ctx context.Context,
	client graphql.Client,
	addOnType AddOnType,
) (*ListAddOnsResponse, error) {
	req := &graphql.Request{
		OpName: "ListAddOns",
		Query: `
query ListAddOns ($addOnType: AddOnType) {
	addOns(type: $addOnType) {
		nodes {
			id
			name
			addOnPlan {
				displayName
			}
			privateIp
			primaryRegion
			readRegions
			options
			organization {
				id
				slug
			}
		}
	}
}
`,
		Variables: &__ListAddOnsInput{
			AddOnType: addOnType,
		},
	}
	var err error

	var data ListAddOnsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func LockApp(
	ctx context.Context,
	client graphql.Client,
	input LockAppInput,
) (*LockAppResponse, error) {
	req := &graphql.Request{
		OpName: "LockApp",
		Query: `
mutation LockApp ($input: LockAppInput!) {
	lockApp(input: $input) {
		lockId
		expiration
	}
}
`,
		Variables: &__LockAppInput{
			Input: input,
		},
	}
	var err error

	var data LockAppResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func MachinesCreateRelease(
	ctx context.Context,
	client graphql.Client,
	input CreateReleaseInput,
) (*MachinesCreateReleaseResponse, error) {
	req := &graphql.Request{
		OpName: "MachinesCreateRelease",
		Query: `
mutation MachinesCreateRelease ($input: CreateReleaseInput!) {
	createRelease(input: $input) {
		release {
			id
			version
		}
	}
}
`,
		Variables: &__MachinesCreateReleaseInput{
			Input: input,
		},
	}
	var err error

	var data MachinesCreateReleaseResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func MigrateMachinesCreateRelease(
	ctx context.Context,
	client graphql.Client,
	input CreateReleaseInput,
) (*MigrateMachinesCreateReleaseResponse, error) {
	req := &graphql.Request{
		OpName: "MigrateMachinesCreateRelease",
		Query: `
mutation MigrateMachinesCreateRelease ($input: CreateReleaseInput!) {
	createRelease(input: $input) {
		release {
			id
			version
		}
	}
}
`,
		Variables: &__MigrateMachinesCreateReleaseInput{
			Input: input,
		},
	}
	var err error

	var data MigrateMachinesCreateReleaseResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ResetAddOnPassword(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*ResetAddOnPasswordResponse, error) {
	req := &graphql.Request{
		OpName: "ResetAddOnPassword",
		Query: `
mutation ResetAddOnPassword ($name: String!) {
	resetAddOnPassword(input: {name:$name}) {
		addOn {
			publicUrl
		}
	}
}
`,
		Variables: &__ResetAddOnPasswordInput{
			Name: name,
		},
	}
	var err error

	var data ResetAddOnPasswordResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ResolverCreateBuild(
	ctx context.Context,
	client graphql.Client,
	input CreateBuildInput,
) (*ResolverCreateBuildResponse, error) {
	req := &graphql.Request{
		OpName: "ResolverCreateBuild",
		Query: `
mutation ResolverCreateBuild ($input: CreateBuildInput!) {
	createBuild(input: $input) {
		id
		status
	}
}
`,
		Variables: &__ResolverCreateBuildInput{
			Input: input,
		},
	}
	var err error

	var data ResolverCreateBuildResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ResolverFinishBuild(
	ctx context.Context,
	client graphql.Client,
	input FinishBuildInput,
) (*ResolverFinishBuildResponse, error) {
	req := &graphql.Request{
		OpName: "ResolverFinishBuild",
		Query: `
mutation ResolverFinishBuild ($input: FinishBuildInput!) {
	finishBuild(input: $input) {
		id
		status
		wallclockTimeMs
	}
}
`,
		Variables: &__ResolverFinishBuildInput{
			Input: input,
		},
	}
	var err error

	var data ResolverFinishBuildResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func SetNomadVMCount(
	ctx context.Context,
	client graphql.Client,
	input SetVMCountInput,
) (*SetNomadVMCountResponse, error) {
	req := &graphql.Request{
		OpName: "SetNomadVMCount",
		Query: `
mutation SetNomadVMCount ($input: SetVMCountInput!) {
	setVmCount(input: $input) {
		taskGroupCounts {
			name
			count
		}
		warnings
	}
}
`,
		Variables: &__SetNomadVMCountInput{
			Input: input,
		},
	}
	var err error

	var data SetNomadVMCountResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func SetOrgSettings(
	ctx context.Context,
	client graphql.Client,
	input SetAppsv2DefaultOnInput,
) (*SetOrgSettingsResponse, error) {
	req := &graphql.Request{
		OpName: "SetOrgSettings",
		Query: `
mutation SetOrgSettings ($input: SetAppsv2DefaultOnInput!) {
	setAppsV2DefaultOn(input: $input) {
		organization {
			settings
		}
	}
}
`,
		Variables: &__SetOrgSettingsInput{
			Input: input,
		},
	}
	var err error

	var data SetOrgSettingsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func SetPlatformVersion(
	ctx context.Context,
	client graphql.Client,
	input SetPlatformVersionInput,
) (*SetPlatformVersionResponse, error) {
	req := &graphql.Request{
		OpName: "SetPlatformVersion",
		Query: `
mutation SetPlatformVersion ($input: SetPlatformVersionInput!) {
	setPlatformVersion(input: $input) {
		app {
			id
		}
	}
}
`,
		Variables: &__SetPlatformVersionInput{
			Input: input,
		},
	}
	var err error

	var data SetPlatformVersionResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func SetSecrets(
	ctx context.Context,
	client graphql.Client,
	input SetSecretsInput,
) (*SetSecretsResponse, error) {
	req := &graphql.Request{
		OpName: "SetSecrets",
		Query: `
mutation SetSecrets ($input: SetSecretsInput!) {
	setSecrets(input: $input) {
		release {
			id
			version
			reason
			description
			user {
				id
				email
				name
			}
			evaluationId
			createdAt
		}
	}
}
`,
		Variables: &__SetSecretsInput{
			Input: input,
		},
	}
	var err error

	var data SetSecretsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func UnlockApp(
	ctx context.Context,
	client graphql.Client,
	input UnlockAppInput,
) (*UnlockAppResponse, error) {
	req := &graphql.Request{
		OpName: "UnlockApp",
		Query: `
mutation UnlockApp ($input: UnlockAppInput!) {
	unlockApp(input: $input) {
		app {
			id
		}
	}
}
`,
		Variables: &__UnlockAppInput{
			Input: input,
		},
	}
	var err error

	var data UnlockAppResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func UpdateAddOn(
	ctx context.Context,
	client graphql.Client,
	addOnId string,
	planId string,
	readRegions []string,
	options interface{},
) (*UpdateAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "UpdateAddOn",
		Query: `
mutation UpdateAddOn ($addOnId: ID!, $planId: ID!, $readRegions: [String!]!, $options: JSON!) {
	updateAddOn(input: {addOnId:$addOnId,planId:$planId,readRegions:$readRegions,options:$options}) {
		addOn {
			id
		}
	}
}
`,
		Variables: &__UpdateAddOnInput{
			AddOnId:     addOnId,
			PlanId:      planId,
			ReadRegions: readRegions,
			Options:     options,
		},
	}
	var err error

	var data UpdateAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}
