// Copyright (C) 2024  mieru authors
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.22.3
// source: rpc.proto

package appctlgrpc

import (
	context "context"
	appctlpb "github.com/enfein/mieru/v3/pkg/appctl/appctlpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ClientLifecycleService_GetStatus_FullMethodName           = "/appctl.ClientLifecycleService/GetStatus"
	ClientLifecycleService_Exit_FullMethodName                = "/appctl.ClientLifecycleService/Exit"
	ClientLifecycleService_GetMetrics_FullMethodName          = "/appctl.ClientLifecycleService/GetMetrics"
	ClientLifecycleService_GetSessionInfo_FullMethodName      = "/appctl.ClientLifecycleService/GetSessionInfo"
	ClientLifecycleService_GetThreadDump_FullMethodName       = "/appctl.ClientLifecycleService/GetThreadDump"
	ClientLifecycleService_StartCPUProfile_FullMethodName     = "/appctl.ClientLifecycleService/StartCPUProfile"
	ClientLifecycleService_StopCPUProfile_FullMethodName      = "/appctl.ClientLifecycleService/StopCPUProfile"
	ClientLifecycleService_GetHeapProfile_FullMethodName      = "/appctl.ClientLifecycleService/GetHeapProfile"
	ClientLifecycleService_GetMemoryStatistics_FullMethodName = "/appctl.ClientLifecycleService/GetMemoryStatistics"
)

// ClientLifecycleServiceClient is the client API for ClientLifecycleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ClientLifecycleServiceClient interface {
	// Fetch client application status.
	GetStatus(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.AppStatusMsg, error)
	// Quit client daemon.
	Exit(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Get client metrics.
	GetMetrics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Metrics, error)
	// Get client session information.
	GetSessionInfo(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.SessionInfo, error)
	// Generate a thread dump of client daemon.
	GetThreadDump(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.ThreadDump, error)
	// Start CPU profiling.
	StartCPUProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Stop CPU profiling.
	StopCPUProfile(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Generate a heap profile.
	GetHeapProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Get memory statistics of client daemon.
	GetMemoryStatistics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.MemoryStatistics, error)
}

type clientLifecycleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClientLifecycleServiceClient(cc grpc.ClientConnInterface) ClientLifecycleServiceClient {
	return &clientLifecycleServiceClient{cc}
}

func (c *clientLifecycleServiceClient) GetStatus(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.AppStatusMsg, error) {
	out := new(appctlpb.AppStatusMsg)
	err := c.cc.Invoke(ctx, ClientLifecycleService_GetStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) Exit(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ClientLifecycleService_Exit_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) GetMetrics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Metrics, error) {
	out := new(appctlpb.Metrics)
	err := c.cc.Invoke(ctx, ClientLifecycleService_GetMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) GetSessionInfo(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.SessionInfo, error) {
	out := new(appctlpb.SessionInfo)
	err := c.cc.Invoke(ctx, ClientLifecycleService_GetSessionInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) GetThreadDump(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.ThreadDump, error) {
	out := new(appctlpb.ThreadDump)
	err := c.cc.Invoke(ctx, ClientLifecycleService_GetThreadDump_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) StartCPUProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ClientLifecycleService_StartCPUProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) StopCPUProfile(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ClientLifecycleService_StopCPUProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) GetHeapProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ClientLifecycleService_GetHeapProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientLifecycleServiceClient) GetMemoryStatistics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.MemoryStatistics, error) {
	out := new(appctlpb.MemoryStatistics)
	err := c.cc.Invoke(ctx, ClientLifecycleService_GetMemoryStatistics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClientLifecycleServiceServer is the server API for ClientLifecycleService service.
// All implementations must embed UnimplementedClientLifecycleServiceServer
// for forward compatibility
type ClientLifecycleServiceServer interface {
	// Fetch client application status.
	GetStatus(context.Context, *appctlpb.Empty) (*appctlpb.AppStatusMsg, error)
	// Quit client daemon.
	Exit(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Get client metrics.
	GetMetrics(context.Context, *appctlpb.Empty) (*appctlpb.Metrics, error)
	// Get client session information.
	GetSessionInfo(context.Context, *appctlpb.Empty) (*appctlpb.SessionInfo, error)
	// Generate a thread dump of client daemon.
	GetThreadDump(context.Context, *appctlpb.Empty) (*appctlpb.ThreadDump, error)
	// Start CPU profiling.
	StartCPUProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error)
	// Stop CPU profiling.
	StopCPUProfile(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Generate a heap profile.
	GetHeapProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error)
	// Get memory statistics of client daemon.
	GetMemoryStatistics(context.Context, *appctlpb.Empty) (*appctlpb.MemoryStatistics, error)
	mustEmbedUnimplementedClientLifecycleServiceServer()
}

// UnimplementedClientLifecycleServiceServer must be embedded to have forward compatible implementations.
type UnimplementedClientLifecycleServiceServer struct {
}

func (UnimplementedClientLifecycleServiceServer) GetStatus(context.Context, *appctlpb.Empty) (*appctlpb.AppStatusMsg, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStatus not implemented")
}
func (UnimplementedClientLifecycleServiceServer) Exit(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Exit not implemented")
}
func (UnimplementedClientLifecycleServiceServer) GetMetrics(context.Context, *appctlpb.Empty) (*appctlpb.Metrics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetrics not implemented")
}
func (UnimplementedClientLifecycleServiceServer) GetSessionInfo(context.Context, *appctlpb.Empty) (*appctlpb.SessionInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSessionInfo not implemented")
}
func (UnimplementedClientLifecycleServiceServer) GetThreadDump(context.Context, *appctlpb.Empty) (*appctlpb.ThreadDump, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetThreadDump not implemented")
}
func (UnimplementedClientLifecycleServiceServer) StartCPUProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartCPUProfile not implemented")
}
func (UnimplementedClientLifecycleServiceServer) StopCPUProfile(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopCPUProfile not implemented")
}
func (UnimplementedClientLifecycleServiceServer) GetHeapProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHeapProfile not implemented")
}
func (UnimplementedClientLifecycleServiceServer) GetMemoryStatistics(context.Context, *appctlpb.Empty) (*appctlpb.MemoryStatistics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMemoryStatistics not implemented")
}
func (UnimplementedClientLifecycleServiceServer) mustEmbedUnimplementedClientLifecycleServiceServer() {
}

// UnsafeClientLifecycleServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ClientLifecycleServiceServer will
// result in compilation errors.
type UnsafeClientLifecycleServiceServer interface {
	mustEmbedUnimplementedClientLifecycleServiceServer()
}

func RegisterClientLifecycleServiceServer(s grpc.ServiceRegistrar, srv ClientLifecycleServiceServer) {
	s.RegisterService(&ClientLifecycleService_ServiceDesc, srv)
}

func _ClientLifecycleService_GetStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).GetStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_GetStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).GetStatus(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_Exit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).Exit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_Exit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).Exit(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_GetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).GetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_GetMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).GetMetrics(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_GetSessionInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).GetSessionInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_GetSessionInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).GetSessionInfo(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_GetThreadDump_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).GetThreadDump(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_GetThreadDump_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).GetThreadDump(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_StartCPUProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.ProfileSavePath)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).StartCPUProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_StartCPUProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).StartCPUProfile(ctx, req.(*appctlpb.ProfileSavePath))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_StopCPUProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).StopCPUProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_StopCPUProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).StopCPUProfile(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_GetHeapProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.ProfileSavePath)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).GetHeapProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_GetHeapProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).GetHeapProfile(ctx, req.(*appctlpb.ProfileSavePath))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientLifecycleService_GetMemoryStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientLifecycleServiceServer).GetMemoryStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientLifecycleService_GetMemoryStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientLifecycleServiceServer).GetMemoryStatistics(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

// ClientLifecycleService_ServiceDesc is the grpc.ServiceDesc for ClientLifecycleService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ClientLifecycleService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "appctl.ClientLifecycleService",
	HandlerType: (*ClientLifecycleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetStatus",
			Handler:    _ClientLifecycleService_GetStatus_Handler,
		},
		{
			MethodName: "Exit",
			Handler:    _ClientLifecycleService_Exit_Handler,
		},
		{
			MethodName: "GetMetrics",
			Handler:    _ClientLifecycleService_GetMetrics_Handler,
		},
		{
			MethodName: "GetSessionInfo",
			Handler:    _ClientLifecycleService_GetSessionInfo_Handler,
		},
		{
			MethodName: "GetThreadDump",
			Handler:    _ClientLifecycleService_GetThreadDump_Handler,
		},
		{
			MethodName: "StartCPUProfile",
			Handler:    _ClientLifecycleService_StartCPUProfile_Handler,
		},
		{
			MethodName: "StopCPUProfile",
			Handler:    _ClientLifecycleService_StopCPUProfile_Handler,
		},
		{
			MethodName: "GetHeapProfile",
			Handler:    _ClientLifecycleService_GetHeapProfile_Handler,
		},
		{
			MethodName: "GetMemoryStatistics",
			Handler:    _ClientLifecycleService_GetMemoryStatistics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "rpc.proto",
}

const (
	ServerLifecycleService_GetStatus_FullMethodName           = "/appctl.ServerLifecycleService/GetStatus"
	ServerLifecycleService_Start_FullMethodName               = "/appctl.ServerLifecycleService/Start"
	ServerLifecycleService_Stop_FullMethodName                = "/appctl.ServerLifecycleService/Stop"
	ServerLifecycleService_Reload_FullMethodName              = "/appctl.ServerLifecycleService/Reload"
	ServerLifecycleService_Exit_FullMethodName                = "/appctl.ServerLifecycleService/Exit"
	ServerLifecycleService_GetMetrics_FullMethodName          = "/appctl.ServerLifecycleService/GetMetrics"
	ServerLifecycleService_GetSessionInfo_FullMethodName      = "/appctl.ServerLifecycleService/GetSessionInfo"
	ServerLifecycleService_GetThreadDump_FullMethodName       = "/appctl.ServerLifecycleService/GetThreadDump"
	ServerLifecycleService_StartCPUProfile_FullMethodName     = "/appctl.ServerLifecycleService/StartCPUProfile"
	ServerLifecycleService_StopCPUProfile_FullMethodName      = "/appctl.ServerLifecycleService/StopCPUProfile"
	ServerLifecycleService_GetHeapProfile_FullMethodName      = "/appctl.ServerLifecycleService/GetHeapProfile"
	ServerLifecycleService_GetMemoryStatistics_FullMethodName = "/appctl.ServerLifecycleService/GetMemoryStatistics"
)

// ServerLifecycleServiceClient is the client API for ServerLifecycleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ServerLifecycleServiceClient interface {
	// Fetch server application status.
	GetStatus(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.AppStatusMsg, error)
	// Start proxy in server application.
	Start(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Stop proxy in server application.
	Stop(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Reload server configuration.
	Reload(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Quit server daemon.
	Exit(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Get server metrics.
	GetMetrics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Metrics, error)
	// Get server session information.
	GetSessionInfo(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.SessionInfo, error)
	// Generate a thread dump of server daemon.
	GetThreadDump(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.ThreadDump, error)
	// Start CPU profiling.
	StartCPUProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Stop CPU profiling.
	StopCPUProfile(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Generate a heap profile.
	GetHeapProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error)
	// Get memory statistics of server daemon.
	GetMemoryStatistics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.MemoryStatistics, error)
}

type serverLifecycleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServerLifecycleServiceClient(cc grpc.ClientConnInterface) ServerLifecycleServiceClient {
	return &serverLifecycleServiceClient{cc}
}

func (c *serverLifecycleServiceClient) GetStatus(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.AppStatusMsg, error) {
	out := new(appctlpb.AppStatusMsg)
	err := c.cc.Invoke(ctx, ServerLifecycleService_GetStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) Start(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_Start_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) Stop(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_Stop_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) Reload(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_Reload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) Exit(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_Exit_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) GetMetrics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Metrics, error) {
	out := new(appctlpb.Metrics)
	err := c.cc.Invoke(ctx, ServerLifecycleService_GetMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) GetSessionInfo(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.SessionInfo, error) {
	out := new(appctlpb.SessionInfo)
	err := c.cc.Invoke(ctx, ServerLifecycleService_GetSessionInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) GetThreadDump(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.ThreadDump, error) {
	out := new(appctlpb.ThreadDump)
	err := c.cc.Invoke(ctx, ServerLifecycleService_GetThreadDump_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) StartCPUProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_StartCPUProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) StopCPUProfile(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_StopCPUProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) GetHeapProfile(ctx context.Context, in *appctlpb.ProfileSavePath, opts ...grpc.CallOption) (*appctlpb.Empty, error) {
	out := new(appctlpb.Empty)
	err := c.cc.Invoke(ctx, ServerLifecycleService_GetHeapProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverLifecycleServiceClient) GetMemoryStatistics(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.MemoryStatistics, error) {
	out := new(appctlpb.MemoryStatistics)
	err := c.cc.Invoke(ctx, ServerLifecycleService_GetMemoryStatistics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServerLifecycleServiceServer is the server API for ServerLifecycleService service.
// All implementations must embed UnimplementedServerLifecycleServiceServer
// for forward compatibility
type ServerLifecycleServiceServer interface {
	// Fetch server application status.
	GetStatus(context.Context, *appctlpb.Empty) (*appctlpb.AppStatusMsg, error)
	// Start proxy in server application.
	Start(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Stop proxy in server application.
	Stop(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Reload server configuration.
	Reload(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Quit server daemon.
	Exit(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Get server metrics.
	GetMetrics(context.Context, *appctlpb.Empty) (*appctlpb.Metrics, error)
	// Get server session information.
	GetSessionInfo(context.Context, *appctlpb.Empty) (*appctlpb.SessionInfo, error)
	// Generate a thread dump of server daemon.
	GetThreadDump(context.Context, *appctlpb.Empty) (*appctlpb.ThreadDump, error)
	// Start CPU profiling.
	StartCPUProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error)
	// Stop CPU profiling.
	StopCPUProfile(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error)
	// Generate a heap profile.
	GetHeapProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error)
	// Get memory statistics of server daemon.
	GetMemoryStatistics(context.Context, *appctlpb.Empty) (*appctlpb.MemoryStatistics, error)
	mustEmbedUnimplementedServerLifecycleServiceServer()
}

// UnimplementedServerLifecycleServiceServer must be embedded to have forward compatible implementations.
type UnimplementedServerLifecycleServiceServer struct {
}

func (UnimplementedServerLifecycleServiceServer) GetStatus(context.Context, *appctlpb.Empty) (*appctlpb.AppStatusMsg, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStatus not implemented")
}
func (UnimplementedServerLifecycleServiceServer) Start(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (UnimplementedServerLifecycleServiceServer) Stop(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (UnimplementedServerLifecycleServiceServer) Reload(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Reload not implemented")
}
func (UnimplementedServerLifecycleServiceServer) Exit(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Exit not implemented")
}
func (UnimplementedServerLifecycleServiceServer) GetMetrics(context.Context, *appctlpb.Empty) (*appctlpb.Metrics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetrics not implemented")
}
func (UnimplementedServerLifecycleServiceServer) GetSessionInfo(context.Context, *appctlpb.Empty) (*appctlpb.SessionInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSessionInfo not implemented")
}
func (UnimplementedServerLifecycleServiceServer) GetThreadDump(context.Context, *appctlpb.Empty) (*appctlpb.ThreadDump, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetThreadDump not implemented")
}
func (UnimplementedServerLifecycleServiceServer) StartCPUProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartCPUProfile not implemented")
}
func (UnimplementedServerLifecycleServiceServer) StopCPUProfile(context.Context, *appctlpb.Empty) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopCPUProfile not implemented")
}
func (UnimplementedServerLifecycleServiceServer) GetHeapProfile(context.Context, *appctlpb.ProfileSavePath) (*appctlpb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHeapProfile not implemented")
}
func (UnimplementedServerLifecycleServiceServer) GetMemoryStatistics(context.Context, *appctlpb.Empty) (*appctlpb.MemoryStatistics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMemoryStatistics not implemented")
}
func (UnimplementedServerLifecycleServiceServer) mustEmbedUnimplementedServerLifecycleServiceServer() {
}

// UnsafeServerLifecycleServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServerLifecycleServiceServer will
// result in compilation errors.
type UnsafeServerLifecycleServiceServer interface {
	mustEmbedUnimplementedServerLifecycleServiceServer()
}

func RegisterServerLifecycleServiceServer(s grpc.ServiceRegistrar, srv ServerLifecycleServiceServer) {
	s.RegisterService(&ServerLifecycleService_ServiceDesc, srv)
}

func _ServerLifecycleService_GetStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).GetStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_GetStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).GetStatus(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_Start_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).Start(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_Stop_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).Stop(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_Reload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).Reload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_Reload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).Reload(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_Exit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).Exit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_Exit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).Exit(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_GetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).GetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_GetMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).GetMetrics(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_GetSessionInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).GetSessionInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_GetSessionInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).GetSessionInfo(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_GetThreadDump_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).GetThreadDump(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_GetThreadDump_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).GetThreadDump(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_StartCPUProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.ProfileSavePath)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).StartCPUProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_StartCPUProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).StartCPUProfile(ctx, req.(*appctlpb.ProfileSavePath))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_StopCPUProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).StopCPUProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_StopCPUProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).StopCPUProfile(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_GetHeapProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.ProfileSavePath)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).GetHeapProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_GetHeapProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).GetHeapProfile(ctx, req.(*appctlpb.ProfileSavePath))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerLifecycleService_GetMemoryStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerLifecycleServiceServer).GetMemoryStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerLifecycleService_GetMemoryStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerLifecycleServiceServer).GetMemoryStatistics(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

// ServerLifecycleService_ServiceDesc is the grpc.ServiceDesc for ServerLifecycleService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ServerLifecycleService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "appctl.ServerLifecycleService",
	HandlerType: (*ServerLifecycleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetStatus",
			Handler:    _ServerLifecycleService_GetStatus_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ServerLifecycleService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ServerLifecycleService_Stop_Handler,
		},
		{
			MethodName: "Reload",
			Handler:    _ServerLifecycleService_Reload_Handler,
		},
		{
			MethodName: "Exit",
			Handler:    _ServerLifecycleService_Exit_Handler,
		},
		{
			MethodName: "GetMetrics",
			Handler:    _ServerLifecycleService_GetMetrics_Handler,
		},
		{
			MethodName: "GetSessionInfo",
			Handler:    _ServerLifecycleService_GetSessionInfo_Handler,
		},
		{
			MethodName: "GetThreadDump",
			Handler:    _ServerLifecycleService_GetThreadDump_Handler,
		},
		{
			MethodName: "StartCPUProfile",
			Handler:    _ServerLifecycleService_StartCPUProfile_Handler,
		},
		{
			MethodName: "StopCPUProfile",
			Handler:    _ServerLifecycleService_StopCPUProfile_Handler,
		},
		{
			MethodName: "GetHeapProfile",
			Handler:    _ServerLifecycleService_GetHeapProfile_Handler,
		},
		{
			MethodName: "GetMemoryStatistics",
			Handler:    _ServerLifecycleService_GetMemoryStatistics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "rpc.proto",
}

const (
	ServerConfigService_GetConfig_FullMethodName = "/appctl.ServerConfigService/GetConfig"
	ServerConfigService_SetConfig_FullMethodName = "/appctl.ServerConfigService/SetConfig"
)

// ServerConfigServiceClient is the client API for ServerConfigService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ServerConfigServiceClient interface {
	// Fetch the server config.
	GetConfig(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.ServerConfig, error)
	// Update server config.
	SetConfig(ctx context.Context, in *appctlpb.ServerConfig, opts ...grpc.CallOption) (*appctlpb.ServerConfig, error)
}

type serverConfigServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServerConfigServiceClient(cc grpc.ClientConnInterface) ServerConfigServiceClient {
	return &serverConfigServiceClient{cc}
}

func (c *serverConfigServiceClient) GetConfig(ctx context.Context, in *appctlpb.Empty, opts ...grpc.CallOption) (*appctlpb.ServerConfig, error) {
	out := new(appctlpb.ServerConfig)
	err := c.cc.Invoke(ctx, ServerConfigService_GetConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverConfigServiceClient) SetConfig(ctx context.Context, in *appctlpb.ServerConfig, opts ...grpc.CallOption) (*appctlpb.ServerConfig, error) {
	out := new(appctlpb.ServerConfig)
	err := c.cc.Invoke(ctx, ServerConfigService_SetConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServerConfigServiceServer is the server API for ServerConfigService service.
// All implementations must embed UnimplementedServerConfigServiceServer
// for forward compatibility
type ServerConfigServiceServer interface {
	// Fetch the server config.
	GetConfig(context.Context, *appctlpb.Empty) (*appctlpb.ServerConfig, error)
	// Update server config.
	SetConfig(context.Context, *appctlpb.ServerConfig) (*appctlpb.ServerConfig, error)
	mustEmbedUnimplementedServerConfigServiceServer()
}

// UnimplementedServerConfigServiceServer must be embedded to have forward compatible implementations.
type UnimplementedServerConfigServiceServer struct {
}

func (UnimplementedServerConfigServiceServer) GetConfig(context.Context, *appctlpb.Empty) (*appctlpb.ServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedServerConfigServiceServer) SetConfig(context.Context, *appctlpb.ServerConfig) (*appctlpb.ServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConfig not implemented")
}
func (UnimplementedServerConfigServiceServer) mustEmbedUnimplementedServerConfigServiceServer() {}

// UnsafeServerConfigServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServerConfigServiceServer will
// result in compilation errors.
type UnsafeServerConfigServiceServer interface {
	mustEmbedUnimplementedServerConfigServiceServer()
}

func RegisterServerConfigServiceServer(s grpc.ServiceRegistrar, srv ServerConfigServiceServer) {
	s.RegisterService(&ServerConfigService_ServiceDesc, srv)
}

func _ServerConfigService_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerConfigServiceServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerConfigService_GetConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerConfigServiceServer).GetConfig(ctx, req.(*appctlpb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerConfigService_SetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(appctlpb.ServerConfig)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerConfigServiceServer).SetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerConfigService_SetConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerConfigServiceServer).SetConfig(ctx, req.(*appctlpb.ServerConfig))
	}
	return interceptor(ctx, in, info, handler)
}

// ServerConfigService_ServiceDesc is the grpc.ServiceDesc for ServerConfigService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ServerConfigService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "appctl.ServerConfigService",
	HandlerType: (*ServerConfigServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetConfig",
			Handler:    _ServerConfigService_GetConfig_Handler,
		},
		{
			MethodName: "SetConfig",
			Handler:    _ServerConfigService_SetConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "rpc.proto",
}
