# 翻墙安全指南

这篇文章主要讲解如何安全的使用 mieru 进行翻墙。

## 不使用国产操作系统和国产浏览器

国产浏览器，例如 360 安全浏览器、QQ 浏览器等，会记录和上传浏览器插件和网络代理的使用情况。使用国产操作系统和国产浏览器翻墙等于当着警察的面翻墙。

## 分离国内流量和翻墙流量

用户不应该使用翻墙代理访问国内的网站。这种做法一方面会降低性能，另一方面也有助于 GFW 发现和封锁代理服务器。例如，bilibili 或者 GFW 发现有很多视频播放请求来源于某个云服务提供商的 IP，那么该 IP 可能会被判定为用于翻墙而遭到封禁。

mieru 本身没有提供基于域名规则或 IP 地址位置来判断是否应该翻墙的功能。用户应当使用可以进行相关配置的浏览器插件，例如 [Proxy SwitchyOmega](https://github.com/FelisCatus/SwitchyOmega)，或者使用两个不同的浏览器，一个专门用于访问国内网站，而另一个专门用于翻墙。

## 使用虚拟机或单独的电脑翻墙

另一类针对翻墙软件的攻击发生在用户的电脑上。一些装机量极大的软件，例如 QQ，会扫描电脑上的进程和文件。如果发现用户在运行 shadowsocks 等知名翻墙软件，他们会记录和上报这些行为。

考虑到国内用户很难完全不使用国产软件，我们建议创建一个虚拟机，或者使用单独的电脑进行翻墙。

## 使用 Tor 洋葱路由 / 洋葱浏览器

翻墙软件开发者、调查记者、维权律师、在国外网站上参与政治讨论的人，都是高风险用户。除了上述三点之外，翻墙时请务必使用 [Tor](https://www.torproject.org/) 进行敏感操作。在国内无法直接连接 Tor 网桥，但是 mieru 可以作为 Tor 的前置代理。在 Tor 浏览器中使用前置代理的方法如下图所示（请使用自己电脑上 mieru 监听的端口号）。

![配置 Tor 浏览器](./assets/config_tor_browser.png)

![配置 Tor 浏览器](./assets/config_tor_browser_2.png)

通过这种方式翻墙的网速比较慢，可能无法流畅观看视频。

建议高风险用户阅读[编程随想的博客](https://program-think.blogspot.com/)中关于信息安全的文章，保护好隐私和踪迹，避免被跨省追捕。
