// Code generated by ifacemaker; DO NOT EDIT.

package awsapi

import (
	"context"

	. "github.com/aws/aws-sdk-go-v2/service/outposts"
)

// Outposts provides an interface to the AWS Outposts service.
type Outposts interface {
	// Cancels an order for an Outpost.
	CancelOrder(ctx context.Context, params *CancelOrderInput, optFns ...func(*Options)) (*CancelOrderOutput, error)
	// Creates an order for an Outpost.
	CreateOrder(ctx context.Context, params *CreateOrderInput, optFns ...func(*Options)) (*CreateOrderOutput, error)
	// Creates an Outpost. You can specify AvailabilityZone or AvailabilityZoneId.
	CreateOutpost(ctx context.Context, params *CreateOutpostInput, optFns ...func(*Options)) (*CreateOutpostOutput, error)
	// Creates a site for an Outpost.
	CreateSite(ctx context.Context, params *CreateSiteInput, optFns ...func(*Options)) (*CreateSiteOutput, error)
	// Deletes the Outpost.
	DeleteOutpost(ctx context.Context, params *DeleteOutpostInput, optFns ...func(*Options)) (*DeleteOutpostOutput, error)
	// Deletes the site.
	DeleteSite(ctx context.Context, params *DeleteSiteInput, optFns ...func(*Options)) (*DeleteSiteOutput, error)
	// Gets information about a catalog item.
	GetCatalogItem(ctx context.Context, params *GetCatalogItemInput, optFns ...func(*Options)) (*GetCatalogItemOutput, error)
	// Amazon Web Services uses this action to install Outpost servers. Gets
	// information about a specified connection. Use CloudTrail to monitor this action
	// or Amazon Web Services managed policy for Amazon Web Services Outposts to secure
	// it. For more information, see  Amazon Web Services managed policies for Amazon
	// Web Services Outposts
	// (https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html)
	// and  Logging Amazon Web Services Outposts API calls with Amazon Web Services
	// CloudTrail
	// (https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html)
	// in the Amazon Web Services Outposts User Guide.
	GetConnection(ctx context.Context, params *GetConnectionInput, optFns ...func(*Options)) (*GetConnectionOutput, error)
	// Gets an order.
	GetOrder(ctx context.Context, params *GetOrderInput, optFns ...func(*Options)) (*GetOrderOutput, error)
	// Gets information about the specified Outpost.
	GetOutpost(ctx context.Context, params *GetOutpostInput, optFns ...func(*Options)) (*GetOutpostOutput, error)
	// Gets the instance types for the specified Outpost.
	GetOutpostInstanceTypes(ctx context.Context, params *GetOutpostInstanceTypesInput, optFns ...func(*Options)) (*GetOutpostInstanceTypesOutput, error)
	// Gets information about the specified Outpost site.
	GetSite(ctx context.Context, params *GetSiteInput, optFns ...func(*Options)) (*GetSiteOutput, error)
	// Gets the site address.
	GetSiteAddress(ctx context.Context, params *GetSiteAddressInput, optFns ...func(*Options)) (*GetSiteAddressOutput, error)
	// Lists the hardware assets in an Outpost. If you are using Dedicated Hosts on
	// Amazon Web Services Outposts, you can filter your request by host ID to return a
	// list of hardware assets that allocate resources for Dedicated Hosts.
	ListAssets(ctx context.Context, params *ListAssetsInput, optFns ...func(*Options)) (*ListAssetsOutput, error)
	// Lists the items in the catalog. Add filters to your request to return a more
	// specific list of results. Use filters to match an item class, storage option, or
	// EC2 family. If you specify multiple filters, the filters are joined with an AND,
	// and the request returns only results that match all of the specified filters.
	ListCatalogItems(ctx context.Context, params *ListCatalogItemsInput, optFns ...func(*Options)) (*ListCatalogItemsOutput, error)
	// Lists the Outpost orders for your Amazon Web Services account. You can filter
	// your request by Outpost to return a more specific list of results.
	ListOrders(ctx context.Context, params *ListOrdersInput, optFns ...func(*Options)) (*ListOrdersOutput, error)
	// Lists the Outposts for your Amazon Web Services account. Add filters to your
	// request to return a more specific list of results. Use filters to match an
	// Outpost lifecycle status, Availability Zone (us-east-1a), and AZ ID (use1-az1).
	// If you specify multiple filters, the filters are joined with an AND, and the
	// request returns only results that match all of the specified filters.
	ListOutposts(ctx context.Context, params *ListOutpostsInput, optFns ...func(*Options)) (*ListOutpostsOutput, error)
	// Lists the Outpost sites for your Amazon Web Services account. Add operating
	// address filters to your request to return a more specific list of results. Use
	// filters to match site city, country code, or state/region of the operating
	// address. If you specify multiple filters, the filters are joined with an AND,
	// and the request returns only results that match all of the specified filters.
	ListSites(ctx context.Context, params *ListSitesInput, optFns ...func(*Options)) (*ListSitesOutput, error)
	// Lists the tags for the specified resource.
	ListTagsForResource(ctx context.Context, params *ListTagsForResourceInput, optFns ...func(*Options)) (*ListTagsForResourceOutput, error)
	// Amazon Web Services uses this action to install Outpost servers. Starts the
	// connection required for Outpost server installation. Use CloudTrail to monitor
	// this action or Amazon Web Services managed policy for Amazon Web Services
	// Outposts to secure it. For more information, see  Amazon Web Services managed
	// policies for Amazon Web Services Outposts
	// (https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html)
	// and  Logging Amazon Web Services Outposts API calls with Amazon Web Services
	// CloudTrail
	// (https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html)
	// in the Amazon Web Services Outposts User Guide.
	StartConnection(ctx context.Context, params *StartConnectionInput, optFns ...func(*Options)) (*StartConnectionOutput, error)
	// Adds tags to the specified resource.
	TagResource(ctx context.Context, params *TagResourceInput, optFns ...func(*Options)) (*TagResourceOutput, error)
	// Removes tags from the specified resource.
	UntagResource(ctx context.Context, params *UntagResourceInput, optFns ...func(*Options)) (*UntagResourceOutput, error)
	// Updates an Outpost.
	UpdateOutpost(ctx context.Context, params *UpdateOutpostInput, optFns ...func(*Options)) (*UpdateOutpostOutput, error)
	// Updates the site.
	UpdateSite(ctx context.Context, params *UpdateSiteInput, optFns ...func(*Options)) (*UpdateSiteOutput, error)
	// Updates the site address. To update a site address with an order IN_PROGRESS,
	// you must wait for the order to complete or cancel the order. You can update the
	// operating address before you place an order at the site, or after all Outposts
	// that belong to the site have been deactivated.
	UpdateSiteAddress(ctx context.Context, params *UpdateSiteAddressInput, optFns ...func(*Options)) (*UpdateSiteAddressOutput, error)
	// Update the physical and logistical details for a rack at a site. For more
	// information about hardware requirements for racks, see Network readiness
	// checklist
	// (https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist)
	// in the Amazon Web Services Outposts User Guide. To update a rack at a site with
	// an order of IN_PROGRESS, you must wait for the order to complete or cancel the
	// order.
	UpdateSiteRackPhysicalProperties(ctx context.Context, params *UpdateSiteRackPhysicalPropertiesInput, optFns ...func(*Options)) (*UpdateSiteRackPhysicalPropertiesOutput, error)
}

