provider "aws" {
  region = "us-east-1"
}

terraform {
  required_providers {
    aws = "3.19.0"
  }
}

resource "aws_api_gateway_rest_api" "foo" {
    name        = "foo"
    description = "This is foo API"
}

resource "aws_api_gateway_authorizer" "foo" {
    name                   = "foo"
    rest_api_id            = aws_api_gateway_rest_api.foo.id
    authorizer_uri         = aws_lambda_function.authorizer.invoke_arn
    authorizer_credentials = aws_iam_role.invocation_role.arn
}

resource "aws_api_gateway_authorizer" "bar" {
    name                   = "bar"
    rest_api_id            = aws_api_gateway_rest_api.foo.id
    authorizer_uri         = aws_lambda_function.authorizer.invoke_arn
    authorizer_credentials = aws_iam_role.invocation_role.arn
}

resource "aws_iam_role" "invocation_role" {
    name = "api_gateway_auth_invocation"
    path = "/"

    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "apigateway.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "invocation_policy" {
    name = "default"
    role = aws_iam_role.invocation_role.id

    policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "lambda:InvokeFunction",
      "Effect": "Allow",
      "Resource": "${aws_lambda_function.authorizer.arn}"
    }
  ]
}
EOF
}

resource "aws_iam_role" "lambda" {
    name = "demo-lambda"

    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_lambda_function" "authorizer" {
    filename      = "lambda.zip"
    function_name = "api_gateway_authorizer"
    role          = aws_iam_role.lambda.arn
    handler       = "lambda.handler"
    runtime       = "nodejs12.x"
}
