// Copyright 2019 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.31.1
// source: dolt/services/remotesapi/v1alpha1/chunkstore.proto

package remotesapi

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ChunkStoreService_GetRepoMetadata_FullMethodName         = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetRepoMetadata"
	ChunkStoreService_HasChunks_FullMethodName               = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/HasChunks"
	ChunkStoreService_GetDownloadLocations_FullMethodName    = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetDownloadLocations"
	ChunkStoreService_StreamDownloadLocations_FullMethodName = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/StreamDownloadLocations"
	ChunkStoreService_GetUploadLocations_FullMethodName      = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetUploadLocations"
	ChunkStoreService_Rebase_FullMethodName                  = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Rebase"
	ChunkStoreService_Root_FullMethodName                    = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Root"
	ChunkStoreService_Commit_FullMethodName                  = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Commit"
	ChunkStoreService_ListTableFiles_FullMethodName          = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/ListTableFiles"
	ChunkStoreService_RefreshTableFileUrl_FullMethodName     = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/RefreshTableFileUrl"
	ChunkStoreService_AddTableFiles_FullMethodName           = "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/AddTableFiles"
)

// ChunkStoreServiceClient is the client API for ChunkStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ChunkStoreServiceClient interface {
	GetRepoMetadata(ctx context.Context, in *GetRepoMetadataRequest, opts ...grpc.CallOption) (*GetRepoMetadataResponse, error)
	HasChunks(ctx context.Context, in *HasChunksRequest, opts ...grpc.CallOption) (*HasChunksResponse, error)
	// Get the download locations for a list of chunk hashes.
	// Deprecated. Use StreamDownloadLocations.
	GetDownloadLocations(ctx context.Context, in *GetDownloadLocsRequest, opts ...grpc.CallOption) (*GetDownloadLocsResponse, error)
	// Get the download locations for a list of chunk hashes. Streaming to
	// support large and incrementally available payloads. Results are generated
	// as requests come in.
	StreamDownloadLocations(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[GetDownloadLocsRequest, GetDownloadLocsResponse], error)
	// Get upload locations for a list of table file hashes.
	// NOTE: We upload full table files but download individual chunks.
	GetUploadLocations(ctx context.Context, in *GetUploadLocsRequest, opts ...grpc.CallOption) (*GetUploadLocsResponse, error)
	Rebase(ctx context.Context, in *RebaseRequest, opts ...grpc.CallOption) (*RebaseResponse, error)
	Root(ctx context.Context, in *RootRequest, opts ...grpc.CallOption) (*RootResponse, error)
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	ListTableFiles(ctx context.Context, in *ListTableFilesRequest, opts ...grpc.CallOption) (*ListTableFilesResponse, error)
	RefreshTableFileUrl(ctx context.Context, in *RefreshTableFileUrlRequest, opts ...grpc.CallOption) (*RefreshTableFileUrlResponse, error)
	AddTableFiles(ctx context.Context, in *AddTableFilesRequest, opts ...grpc.CallOption) (*AddTableFilesResponse, error)
}

type chunkStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewChunkStoreServiceClient(cc grpc.ClientConnInterface) ChunkStoreServiceClient {
	return &chunkStoreServiceClient{cc}
}

func (c *chunkStoreServiceClient) GetRepoMetadata(ctx context.Context, in *GetRepoMetadataRequest, opts ...grpc.CallOption) (*GetRepoMetadataResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetRepoMetadataResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_GetRepoMetadata_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) HasChunks(ctx context.Context, in *HasChunksRequest, opts ...grpc.CallOption) (*HasChunksResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HasChunksResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_HasChunks_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) GetDownloadLocations(ctx context.Context, in *GetDownloadLocsRequest, opts ...grpc.CallOption) (*GetDownloadLocsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetDownloadLocsResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_GetDownloadLocations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) StreamDownloadLocations(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[GetDownloadLocsRequest, GetDownloadLocsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ChunkStoreService_ServiceDesc.Streams[0], ChunkStoreService_StreamDownloadLocations_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetDownloadLocsRequest, GetDownloadLocsResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ChunkStoreService_StreamDownloadLocationsClient = grpc.BidiStreamingClient[GetDownloadLocsRequest, GetDownloadLocsResponse]

func (c *chunkStoreServiceClient) GetUploadLocations(ctx context.Context, in *GetUploadLocsRequest, opts ...grpc.CallOption) (*GetUploadLocsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetUploadLocsResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_GetUploadLocations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) Rebase(ctx context.Context, in *RebaseRequest, opts ...grpc.CallOption) (*RebaseResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RebaseResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_Rebase_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) Root(ctx context.Context, in *RootRequest, opts ...grpc.CallOption) (*RootResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RootResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_Root_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_Commit_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) ListTableFiles(ctx context.Context, in *ListTableFilesRequest, opts ...grpc.CallOption) (*ListTableFilesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListTableFilesResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_ListTableFiles_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) RefreshTableFileUrl(ctx context.Context, in *RefreshTableFileUrlRequest, opts ...grpc.CallOption) (*RefreshTableFileUrlResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RefreshTableFileUrlResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_RefreshTableFileUrl_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) AddTableFiles(ctx context.Context, in *AddTableFilesRequest, opts ...grpc.CallOption) (*AddTableFilesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AddTableFilesResponse)
	err := c.cc.Invoke(ctx, ChunkStoreService_AddTableFiles_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ChunkStoreServiceServer is the server API for ChunkStoreService service.
// All implementations must embed UnimplementedChunkStoreServiceServer
// for forward compatibility.
type ChunkStoreServiceServer interface {
	GetRepoMetadata(context.Context, *GetRepoMetadataRequest) (*GetRepoMetadataResponse, error)
	HasChunks(context.Context, *HasChunksRequest) (*HasChunksResponse, error)
	// Get the download locations for a list of chunk hashes.
	// Deprecated. Use StreamDownloadLocations.
	GetDownloadLocations(context.Context, *GetDownloadLocsRequest) (*GetDownloadLocsResponse, error)
	// Get the download locations for a list of chunk hashes. Streaming to
	// support large and incrementally available payloads. Results are generated
	// as requests come in.
	StreamDownloadLocations(grpc.BidiStreamingServer[GetDownloadLocsRequest, GetDownloadLocsResponse]) error
	// Get upload locations for a list of table file hashes.
	// NOTE: We upload full table files but download individual chunks.
	GetUploadLocations(context.Context, *GetUploadLocsRequest) (*GetUploadLocsResponse, error)
	Rebase(context.Context, *RebaseRequest) (*RebaseResponse, error)
	Root(context.Context, *RootRequest) (*RootResponse, error)
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	ListTableFiles(context.Context, *ListTableFilesRequest) (*ListTableFilesResponse, error)
	RefreshTableFileUrl(context.Context, *RefreshTableFileUrlRequest) (*RefreshTableFileUrlResponse, error)
	AddTableFiles(context.Context, *AddTableFilesRequest) (*AddTableFilesResponse, error)
	mustEmbedUnimplementedChunkStoreServiceServer()
}

// UnimplementedChunkStoreServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedChunkStoreServiceServer struct{}

func (UnimplementedChunkStoreServiceServer) GetRepoMetadata(context.Context, *GetRepoMetadataRequest) (*GetRepoMetadataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepoMetadata not implemented")
}
func (UnimplementedChunkStoreServiceServer) HasChunks(context.Context, *HasChunksRequest) (*HasChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HasChunks not implemented")
}
func (UnimplementedChunkStoreServiceServer) GetDownloadLocations(context.Context, *GetDownloadLocsRequest) (*GetDownloadLocsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDownloadLocations not implemented")
}
func (UnimplementedChunkStoreServiceServer) StreamDownloadLocations(grpc.BidiStreamingServer[GetDownloadLocsRequest, GetDownloadLocsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method StreamDownloadLocations not implemented")
}
func (UnimplementedChunkStoreServiceServer) GetUploadLocations(context.Context, *GetUploadLocsRequest) (*GetUploadLocsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUploadLocations not implemented")
}
func (UnimplementedChunkStoreServiceServer) Rebase(context.Context, *RebaseRequest) (*RebaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rebase not implemented")
}
func (UnimplementedChunkStoreServiceServer) Root(context.Context, *RootRequest) (*RootResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Root not implemented")
}
func (UnimplementedChunkStoreServiceServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (UnimplementedChunkStoreServiceServer) ListTableFiles(context.Context, *ListTableFilesRequest) (*ListTableFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTableFiles not implemented")
}
func (UnimplementedChunkStoreServiceServer) RefreshTableFileUrl(context.Context, *RefreshTableFileUrlRequest) (*RefreshTableFileUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshTableFileUrl not implemented")
}
func (UnimplementedChunkStoreServiceServer) AddTableFiles(context.Context, *AddTableFilesRequest) (*AddTableFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTableFiles not implemented")
}
func (UnimplementedChunkStoreServiceServer) mustEmbedUnimplementedChunkStoreServiceServer() {}
func (UnimplementedChunkStoreServiceServer) testEmbeddedByValue()                           {}

// UnsafeChunkStoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ChunkStoreServiceServer will
// result in compilation errors.
type UnsafeChunkStoreServiceServer interface {
	mustEmbedUnimplementedChunkStoreServiceServer()
}

func RegisterChunkStoreServiceServer(s grpc.ServiceRegistrar, srv ChunkStoreServiceServer) {
	// If the following call panics, it indicates UnimplementedChunkStoreServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ChunkStoreService_ServiceDesc, srv)
}

func _ChunkStoreService_GetRepoMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepoMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).GetRepoMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_GetRepoMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).GetRepoMetadata(ctx, req.(*GetRepoMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_HasChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).HasChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_HasChunks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).HasChunks(ctx, req.(*HasChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_GetDownloadLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDownloadLocsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).GetDownloadLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_GetDownloadLocations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).GetDownloadLocations(ctx, req.(*GetDownloadLocsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_StreamDownloadLocations_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ChunkStoreServiceServer).StreamDownloadLocations(&grpc.GenericServerStream[GetDownloadLocsRequest, GetDownloadLocsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ChunkStoreService_StreamDownloadLocationsServer = grpc.BidiStreamingServer[GetDownloadLocsRequest, GetDownloadLocsResponse]

func _ChunkStoreService_GetUploadLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUploadLocsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).GetUploadLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_GetUploadLocations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).GetUploadLocations(ctx, req.(*GetUploadLocsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_Rebase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RebaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).Rebase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_Rebase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).Rebase(ctx, req.(*RebaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_Root_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RootRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).Root(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_Root_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).Root(ctx, req.(*RootRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_Commit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_ListTableFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTableFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).ListTableFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_ListTableFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).ListTableFiles(ctx, req.(*ListTableFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_RefreshTableFileUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshTableFileUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).RefreshTableFileUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_RefreshTableFileUrl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).RefreshTableFileUrl(ctx, req.(*RefreshTableFileUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_AddTableFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTableFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).AddTableFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ChunkStoreService_AddTableFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).AddTableFiles(ctx, req.(*AddTableFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ChunkStoreService_ServiceDesc is the grpc.ServiceDesc for ChunkStoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ChunkStoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "dolt.services.remotesapi.v1alpha1.ChunkStoreService",
	HandlerType: (*ChunkStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRepoMetadata",
			Handler:    _ChunkStoreService_GetRepoMetadata_Handler,
		},
		{
			MethodName: "HasChunks",
			Handler:    _ChunkStoreService_HasChunks_Handler,
		},
		{
			MethodName: "GetDownloadLocations",
			Handler:    _ChunkStoreService_GetDownloadLocations_Handler,
		},
		{
			MethodName: "GetUploadLocations",
			Handler:    _ChunkStoreService_GetUploadLocations_Handler,
		},
		{
			MethodName: "Rebase",
			Handler:    _ChunkStoreService_Rebase_Handler,
		},
		{
			MethodName: "Root",
			Handler:    _ChunkStoreService_Root_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _ChunkStoreService_Commit_Handler,
		},
		{
			MethodName: "ListTableFiles",
			Handler:    _ChunkStoreService_ListTableFiles_Handler,
		},
		{
			MethodName: "RefreshTableFileUrl",
			Handler:    _ChunkStoreService_RefreshTableFileUrl_Handler,
		},
		{
			MethodName: "AddTableFiles",
			Handler:    _ChunkStoreService_AddTableFiles_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamDownloadLocations",
			Handler:       _ChunkStoreService_StreamDownloadLocations_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "dolt/services/remotesapi/v1alpha1/chunkstore.proto",
}
