// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeDecimal15_0(t *testing.T) {
	SkipByDefaultInCI(t)
	tests := []ModifyTypeTest{
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"0")`,
			[]interface{}{float64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"0")`,
			[]interface{}{float64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"0")`,
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"0")`,
			[]interface{}{""},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"0"), (1,"1")`,
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"0"), (1,"1")`,
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"0"), (1,"1")`,
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{"", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-00:00:01", "00:00:00", "00:00:01"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2")`,
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{"-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"-2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{float64(0), float64(1), float64(2), float64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{float64(0), float64(1), float64(2), float64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.0", "1234.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.0", "1234.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.0", "1234.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "1234.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:12:34"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{float64(-1234), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{float64(-1234), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "1234.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "1234.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "1234.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "1234.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{uint64(18446744073709550382), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{"-00:12:34", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:12:34"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"-1234"), (1,"-2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234), int64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234), uint64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{float64(0), float64(1), float64(2), float64(1234), float64(1.23456788103168e+14)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{float64(0), float64(1), float64(2), float64(1234), float64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0.0", "1.0", "2.0", "1234.0", "123456789012345.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0.0", "1.0", "2.0", "1234.0", "123456789012345.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000", "123456789012345.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000", "123456789012345.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "1234.000000000000000000000000000000", "123456789012345.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234), uint64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234), uint64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{"0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2"), (3,"1234"), (4,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{int64(-123456789012345), int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234), int64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYINT UNSIGNED",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SMALLINT UNSIGNED",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMINT UNSIGNED",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"INT UNSIGNED",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIGINT UNSIGNED",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"FLOAT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{float64(-1.23456788103168e+14), float64(-1234), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(1234), float64(1.23456788103168e+14)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DOUBLE",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{float64(-123456789012345), float64(-1234), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(1234), float64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,0)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,0)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,0)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(1,1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345.0", "-1234.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "1234.0", "123456789012345.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345.0", "-1234.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "1234.0", "123456789012345.0"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(15,15)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,15)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345.000000000000000", "-1234.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000", "123456789012345.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,15)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345.000000000000000", "-1234.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "1234.000000000000000", "123456789012345.000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(30,30)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DECIMAL(65,30)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345.000000000000000000000000000000", "-1234.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "1234.000000000000000000000000000000", "123456789012345.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BIT(1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(8)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(16)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(24)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(32)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(48)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BIT(64)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{uint64(18446620616920539271), uint64(18446744073709550382), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(1234), uint64(123456789012345)},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYBLOB",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BLOB",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMBLOB",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGBLOB",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TINYTEXT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"TEXT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"MEDIUMTEXT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"LONGTEXT",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(10)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(100)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"CHAR(255)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(10)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(100)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"BINARY(255)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(10)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(100)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(255)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(1023)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARCHAR(4095)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(10)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(100)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(255)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(1023)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(4095)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"VARBINARY(16383)",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{"-123456789012345", "-1234", "-2", "-1", "0", "1", "2", "1234", "123456789012345"},
			false,
		},
		{
			"DECIMAL(15,0)",
			"YEAR",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATE",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIME",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"TIMESTAMP",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"DATETIME",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('B','C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('A','B','C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"ENUM('C','A','B')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('B','C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('A','B','C')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(15,0)",
			"SET('C','A','B')",
			`(0,"-123456789012345"), (1,"-1234"), (2,"-2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2"), (7,"1234"), (8,"123456789012345")`,
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
