// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeIntUnsigned(t *testing.T) {
	SkipByDefaultInCI(t)
	tests := []ModifyTypeTest{
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0)",
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1)",
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(2001), int64(2002), int64(2015)},
			false,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455), int64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455), int64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08), float64(2.147483648e+09)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455), float64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000", "2147483647.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455), int64(2147483647), int64(4294967295)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"INT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08), float64(2.147483648e+09), float64(4.294967296e+09)},
			false,
		},
		{
			"INT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455), float64(2147483647), float64(4294967295)},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0", "4294967295.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0", "4294967295.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0", "4294967295.0"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000", "4294967295.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000", "4294967295.000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000", "2147483647.000000000000000000000000000000", "4294967295.000000000000000000000000000000"},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"INT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4294967295\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4294967295\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"INT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"INT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
