// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeFloat(t *testing.T) {
	tests := []ModifyTypeTest{
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0")`,
			[]interface{}{float64(0)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0")`,
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{float64(0), float64(0.5)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"00:00:00", "00:00:00.500000"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{float64(-0.5), float64(0), float64(0.5)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000", "0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000", "0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000", "0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-00:00:00.500000", "00:00:00", "00:00:00.500000"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"00:00:00", "00:00:00.500000", "00:00:00.125000"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-00:00:00.125000", "-00:00:00.500000", "00:00:00", "00:00:00.500000", "00:00:00.125000"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(2001)},
			false,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-00:00:01", "-00:00:00.125000", "-00:00:00.500000", "00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "1", "0", "1", "257"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "1", "0", "1", "257"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "1", "0", "1", "257"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01", "00:02:56.750000"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{float64(-256.75), float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-257", "-1", "0", "-1", "0", "1", "0", "1", "257"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-257", "-1", "0", "-1", "0", "1", "0", "1", "257"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-257", "-1", "0", "-1", "0", "1", "0", "1", "257"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.750000000000000000000000000000", "-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{uint64(18446744073709551359), uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-00:02:56.750000", "-00:00:01", "-00:00:00.125000", "-00:00:00.500000", "00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01", "00:02:56.750000"},
			false,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1048575)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{float64(-1048575), float64(-256.75), float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1048575)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.000000000000000000000000000000", "-256.750000000000000000000000000000", "-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{uint64(18446744073708503041), uint64(18446744073709551359), uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575\x00\x00", "-256.75\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1048575), float64(1048575)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00", "1048575\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TINYINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{int64(-1048575), int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"INT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{int64(-1048575), int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"BIGINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{int64(-1048575), int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SMALLINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"MEDIUMINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"INT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIGINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DOUBLE",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{float64(-1048575), float64(-1048575), float64(-256.75), float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1048575), float64(1048575)},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(1,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(15,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0", "-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0", "-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0", "-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(15,15)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(30,15)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.000000000000000", "-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(65,15)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.000000000000000", "-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"FLOAT",
			"DECIMAL(30,30)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DECIMAL(65,30)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.000000000000000000000000000000", "-1048575.000000000000000000000000000000", "-256.750000000000000000000000000000", "-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"FLOAT",
			"BIT(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(8)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(16)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(24)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(32)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(48)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BIT(64)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{uint64(18446744073708503041), uint64(18446744073708503041), uint64(18446744073709551359), uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"FLOAT",
			"TINYBLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMBLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGBLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TINYTEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"TEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"MEDIUMTEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"LONGTEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"CHAR(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"CHAR(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"BINARY(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"BINARY(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575\x00\x00", "-1048575\x00\x00", "-256.75\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00", "1048575\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"BINARY(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARCHAR(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(1023)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARCHAR(4095)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"VARBINARY(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(1023)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(4095)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"VARBINARY(16383)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575"},
			false,
		},
		{
			"FLOAT",
			"YEAR",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATE",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIME",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"TIMESTAMP",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"DATETIME",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('A','B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"ENUM('C','A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('A','B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"FLOAT",
			"SET('C','A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
