/*
Daytona Server API

Daytona Server API

API version: v0.0.0-dev
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package apiclient

import (
	"bytes"
	"encoding/json"
	"fmt"
)

// checks if the ServerConfig type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ServerConfig{}

// ServerConfig struct for ServerConfig
type ServerConfig struct {
	ApiPort                   int32       `json:"apiPort"`
	BinariesPath              string      `json:"binariesPath"`
	BuildImageNamespace       *string     `json:"buildImageNamespace,omitempty"`
	BuilderImage              string      `json:"builderImage"`
	BuilderRegistryServer     string      `json:"builderRegistryServer"`
	DefaultProjectImage       string      `json:"defaultProjectImage"`
	DefaultProjectUser        string      `json:"defaultProjectUser"`
	Frps                      *FRPSConfig `json:"frps,omitempty"`
	HeadscalePort             int32       `json:"headscalePort"`
	Id                        string      `json:"id"`
	LocalBuilderRegistryImage string      `json:"localBuilderRegistryImage"`
	LocalBuilderRegistryPort  int32       `json:"localBuilderRegistryPort"`
	LogFilePath               string      `json:"logFilePath"`
	ProvidersDir              string      `json:"providersDir"`
	RegistryUrl               string      `json:"registryUrl"`
	SamplesIndexUrl           *string     `json:"samplesIndexUrl,omitempty"`
	ServerDownloadUrl         string      `json:"serverDownloadUrl"`
}

type _ServerConfig ServerConfig

// NewServerConfig instantiates a new ServerConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewServerConfig(apiPort int32, binariesPath string, builderImage string, builderRegistryServer string, defaultProjectImage string, defaultProjectUser string, headscalePort int32, id string, localBuilderRegistryImage string, localBuilderRegistryPort int32, logFilePath string, providersDir string, registryUrl string, serverDownloadUrl string) *ServerConfig {
	this := ServerConfig{}
	this.ApiPort = apiPort
	this.BinariesPath = binariesPath
	this.BuilderImage = builderImage
	this.BuilderRegistryServer = builderRegistryServer
	this.DefaultProjectImage = defaultProjectImage
	this.DefaultProjectUser = defaultProjectUser
	this.HeadscalePort = headscalePort
	this.Id = id
	this.LocalBuilderRegistryImage = localBuilderRegistryImage
	this.LocalBuilderRegistryPort = localBuilderRegistryPort
	this.LogFilePath = logFilePath
	this.ProvidersDir = providersDir
	this.RegistryUrl = registryUrl
	this.ServerDownloadUrl = serverDownloadUrl
	return &this
}

// NewServerConfigWithDefaults instantiates a new ServerConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewServerConfigWithDefaults() *ServerConfig {
	this := ServerConfig{}
	return &this
}

// GetApiPort returns the ApiPort field value
func (o *ServerConfig) GetApiPort() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.ApiPort
}

// GetApiPortOk returns a tuple with the ApiPort field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetApiPortOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ApiPort, true
}

// SetApiPort sets field value
func (o *ServerConfig) SetApiPort(v int32) {
	o.ApiPort = v
}

// GetBinariesPath returns the BinariesPath field value
func (o *ServerConfig) GetBinariesPath() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.BinariesPath
}

// GetBinariesPathOk returns a tuple with the BinariesPath field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetBinariesPathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BinariesPath, true
}

// SetBinariesPath sets field value
func (o *ServerConfig) SetBinariesPath(v string) {
	o.BinariesPath = v
}

// GetBuildImageNamespace returns the BuildImageNamespace field value if set, zero value otherwise.
func (o *ServerConfig) GetBuildImageNamespace() string {
	if o == nil || IsNil(o.BuildImageNamespace) {
		var ret string
		return ret
	}
	return *o.BuildImageNamespace
}

// GetBuildImageNamespaceOk returns a tuple with the BuildImageNamespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetBuildImageNamespaceOk() (*string, bool) {
	if o == nil || IsNil(o.BuildImageNamespace) {
		return nil, false
	}
	return o.BuildImageNamespace, true
}

// HasBuildImageNamespace returns a boolean if a field has been set.
func (o *ServerConfig) HasBuildImageNamespace() bool {
	if o != nil && !IsNil(o.BuildImageNamespace) {
		return true
	}

	return false
}

// SetBuildImageNamespace gets a reference to the given string and assigns it to the BuildImageNamespace field.
func (o *ServerConfig) SetBuildImageNamespace(v string) {
	o.BuildImageNamespace = &v
}

// GetBuilderImage returns the BuilderImage field value
func (o *ServerConfig) GetBuilderImage() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.BuilderImage
}

// GetBuilderImageOk returns a tuple with the BuilderImage field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetBuilderImageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BuilderImage, true
}

// SetBuilderImage sets field value
func (o *ServerConfig) SetBuilderImage(v string) {
	o.BuilderImage = v
}

// GetBuilderRegistryServer returns the BuilderRegistryServer field value
func (o *ServerConfig) GetBuilderRegistryServer() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.BuilderRegistryServer
}

// GetBuilderRegistryServerOk returns a tuple with the BuilderRegistryServer field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetBuilderRegistryServerOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BuilderRegistryServer, true
}

// SetBuilderRegistryServer sets field value
func (o *ServerConfig) SetBuilderRegistryServer(v string) {
	o.BuilderRegistryServer = v
}

// GetDefaultProjectImage returns the DefaultProjectImage field value
func (o *ServerConfig) GetDefaultProjectImage() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.DefaultProjectImage
}

// GetDefaultProjectImageOk returns a tuple with the DefaultProjectImage field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetDefaultProjectImageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.DefaultProjectImage, true
}

// SetDefaultProjectImage sets field value
func (o *ServerConfig) SetDefaultProjectImage(v string) {
	o.DefaultProjectImage = v
}

// GetDefaultProjectUser returns the DefaultProjectUser field value
func (o *ServerConfig) GetDefaultProjectUser() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.DefaultProjectUser
}

// GetDefaultProjectUserOk returns a tuple with the DefaultProjectUser field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetDefaultProjectUserOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.DefaultProjectUser, true
}

// SetDefaultProjectUser sets field value
func (o *ServerConfig) SetDefaultProjectUser(v string) {
	o.DefaultProjectUser = v
}

// GetFrps returns the Frps field value if set, zero value otherwise.
func (o *ServerConfig) GetFrps() FRPSConfig {
	if o == nil || IsNil(o.Frps) {
		var ret FRPSConfig
		return ret
	}
	return *o.Frps
}

// GetFrpsOk returns a tuple with the Frps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetFrpsOk() (*FRPSConfig, bool) {
	if o == nil || IsNil(o.Frps) {
		return nil, false
	}
	return o.Frps, true
}

// HasFrps returns a boolean if a field has been set.
func (o *ServerConfig) HasFrps() bool {
	if o != nil && !IsNil(o.Frps) {
		return true
	}

	return false
}

// SetFrps gets a reference to the given FRPSConfig and assigns it to the Frps field.
func (o *ServerConfig) SetFrps(v FRPSConfig) {
	o.Frps = &v
}

// GetHeadscalePort returns the HeadscalePort field value
func (o *ServerConfig) GetHeadscalePort() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.HeadscalePort
}

// GetHeadscalePortOk returns a tuple with the HeadscalePort field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetHeadscalePortOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.HeadscalePort, true
}

// SetHeadscalePort sets field value
func (o *ServerConfig) SetHeadscalePort(v int32) {
	o.HeadscalePort = v
}

// GetId returns the Id field value
func (o *ServerConfig) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *ServerConfig) SetId(v string) {
	o.Id = v
}

// GetLocalBuilderRegistryImage returns the LocalBuilderRegistryImage field value
func (o *ServerConfig) GetLocalBuilderRegistryImage() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LocalBuilderRegistryImage
}

// GetLocalBuilderRegistryImageOk returns a tuple with the LocalBuilderRegistryImage field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetLocalBuilderRegistryImageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LocalBuilderRegistryImage, true
}

// SetLocalBuilderRegistryImage sets field value
func (o *ServerConfig) SetLocalBuilderRegistryImage(v string) {
	o.LocalBuilderRegistryImage = v
}

// GetLocalBuilderRegistryPort returns the LocalBuilderRegistryPort field value
func (o *ServerConfig) GetLocalBuilderRegistryPort() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.LocalBuilderRegistryPort
}

// GetLocalBuilderRegistryPortOk returns a tuple with the LocalBuilderRegistryPort field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetLocalBuilderRegistryPortOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LocalBuilderRegistryPort, true
}

// SetLocalBuilderRegistryPort sets field value
func (o *ServerConfig) SetLocalBuilderRegistryPort(v int32) {
	o.LocalBuilderRegistryPort = v
}

// GetLogFilePath returns the LogFilePath field value
func (o *ServerConfig) GetLogFilePath() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LogFilePath
}

// GetLogFilePathOk returns a tuple with the LogFilePath field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetLogFilePathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LogFilePath, true
}

// SetLogFilePath sets field value
func (o *ServerConfig) SetLogFilePath(v string) {
	o.LogFilePath = v
}

// GetProvidersDir returns the ProvidersDir field value
func (o *ServerConfig) GetProvidersDir() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ProvidersDir
}

// GetProvidersDirOk returns a tuple with the ProvidersDir field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetProvidersDirOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ProvidersDir, true
}

// SetProvidersDir sets field value
func (o *ServerConfig) SetProvidersDir(v string) {
	o.ProvidersDir = v
}

// GetRegistryUrl returns the RegistryUrl field value
func (o *ServerConfig) GetRegistryUrl() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.RegistryUrl
}

// GetRegistryUrlOk returns a tuple with the RegistryUrl field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetRegistryUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RegistryUrl, true
}

// SetRegistryUrl sets field value
func (o *ServerConfig) SetRegistryUrl(v string) {
	o.RegistryUrl = v
}

// GetSamplesIndexUrl returns the SamplesIndexUrl field value if set, zero value otherwise.
func (o *ServerConfig) GetSamplesIndexUrl() string {
	if o == nil || IsNil(o.SamplesIndexUrl) {
		var ret string
		return ret
	}
	return *o.SamplesIndexUrl
}

// GetSamplesIndexUrlOk returns a tuple with the SamplesIndexUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetSamplesIndexUrlOk() (*string, bool) {
	if o == nil || IsNil(o.SamplesIndexUrl) {
		return nil, false
	}
	return o.SamplesIndexUrl, true
}

// HasSamplesIndexUrl returns a boolean if a field has been set.
func (o *ServerConfig) HasSamplesIndexUrl() bool {
	if o != nil && !IsNil(o.SamplesIndexUrl) {
		return true
	}

	return false
}

// SetSamplesIndexUrl gets a reference to the given string and assigns it to the SamplesIndexUrl field.
func (o *ServerConfig) SetSamplesIndexUrl(v string) {
	o.SamplesIndexUrl = &v
}

// GetServerDownloadUrl returns the ServerDownloadUrl field value
func (o *ServerConfig) GetServerDownloadUrl() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ServerDownloadUrl
}

// GetServerDownloadUrlOk returns a tuple with the ServerDownloadUrl field value
// and a boolean to check if the value has been set.
func (o *ServerConfig) GetServerDownloadUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ServerDownloadUrl, true
}

// SetServerDownloadUrl sets field value
func (o *ServerConfig) SetServerDownloadUrl(v string) {
	o.ServerDownloadUrl = v
}

func (o ServerConfig) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ServerConfig) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["apiPort"] = o.ApiPort
	toSerialize["binariesPath"] = o.BinariesPath
	if !IsNil(o.BuildImageNamespace) {
		toSerialize["buildImageNamespace"] = o.BuildImageNamespace
	}
	toSerialize["builderImage"] = o.BuilderImage
	toSerialize["builderRegistryServer"] = o.BuilderRegistryServer
	toSerialize["defaultProjectImage"] = o.DefaultProjectImage
	toSerialize["defaultProjectUser"] = o.DefaultProjectUser
	if !IsNil(o.Frps) {
		toSerialize["frps"] = o.Frps
	}
	toSerialize["headscalePort"] = o.HeadscalePort
	toSerialize["id"] = o.Id
	toSerialize["localBuilderRegistryImage"] = o.LocalBuilderRegistryImage
	toSerialize["localBuilderRegistryPort"] = o.LocalBuilderRegistryPort
	toSerialize["logFilePath"] = o.LogFilePath
	toSerialize["providersDir"] = o.ProvidersDir
	toSerialize["registryUrl"] = o.RegistryUrl
	if !IsNil(o.SamplesIndexUrl) {
		toSerialize["samplesIndexUrl"] = o.SamplesIndexUrl
	}
	toSerialize["serverDownloadUrl"] = o.ServerDownloadUrl
	return toSerialize, nil
}

func (o *ServerConfig) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"apiPort",
		"binariesPath",
		"builderImage",
		"builderRegistryServer",
		"defaultProjectImage",
		"defaultProjectUser",
		"headscalePort",
		"id",
		"localBuilderRegistryImage",
		"localBuilderRegistryPort",
		"logFilePath",
		"providersDir",
		"registryUrl",
		"serverDownloadUrl",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varServerConfig := _ServerConfig{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varServerConfig)

	if err != nil {
		return err
	}

	*o = ServerConfig(varServerConfig)

	return err
}

type NullableServerConfig struct {
	value *ServerConfig
	isSet bool
}

func (v NullableServerConfig) Get() *ServerConfig {
	return v.value
}

func (v *NullableServerConfig) Set(val *ServerConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableServerConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableServerConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableServerConfig(val *ServerConfig) *NullableServerConfig {
	return &NullableServerConfig{value: val, isSet: true}
}

func (v NullableServerConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableServerConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
