/*
Daytona Server API

Daytona Server API

API version: v0.0.0-dev
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package apiclient

import (
	"bytes"
	"encoding/json"
	"fmt"
)

// checks if the ProjectConfig type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ProjectConfig{}

// ProjectConfig struct for ProjectConfig
type ProjectConfig struct {
	BuildConfig   *BuildConfig      `json:"buildConfig,omitempty"`
	Default       bool              `json:"default"`
	EnvVars       map[string]string `json:"envVars"`
	Image         string            `json:"image"`
	Name          string            `json:"name"`
	Prebuilds     []PrebuildConfig  `json:"prebuilds,omitempty"`
	RepositoryUrl string            `json:"repositoryUrl"`
	User          string            `json:"user"`
}

type _ProjectConfig ProjectConfig

// NewProjectConfig instantiates a new ProjectConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewProjectConfig(default_ bool, envVars map[string]string, image string, name string, repositoryUrl string, user string) *ProjectConfig {
	this := ProjectConfig{}
	this.Default = default_
	this.EnvVars = envVars
	this.Image = image
	this.Name = name
	this.RepositoryUrl = repositoryUrl
	this.User = user
	return &this
}

// NewProjectConfigWithDefaults instantiates a new ProjectConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewProjectConfigWithDefaults() *ProjectConfig {
	this := ProjectConfig{}
	return &this
}

// GetBuildConfig returns the BuildConfig field value if set, zero value otherwise.
func (o *ProjectConfig) GetBuildConfig() BuildConfig {
	if o == nil || IsNil(o.BuildConfig) {
		var ret BuildConfig
		return ret
	}
	return *o.BuildConfig
}

// GetBuildConfigOk returns a tuple with the BuildConfig field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetBuildConfigOk() (*BuildConfig, bool) {
	if o == nil || IsNil(o.BuildConfig) {
		return nil, false
	}
	return o.BuildConfig, true
}

// HasBuildConfig returns a boolean if a field has been set.
func (o *ProjectConfig) HasBuildConfig() bool {
	if o != nil && !IsNil(o.BuildConfig) {
		return true
	}

	return false
}

// SetBuildConfig gets a reference to the given BuildConfig and assigns it to the BuildConfig field.
func (o *ProjectConfig) SetBuildConfig(v BuildConfig) {
	o.BuildConfig = &v
}

// GetDefault returns the Default field value
func (o *ProjectConfig) GetDefault() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Default
}

// GetDefaultOk returns a tuple with the Default field value
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetDefaultOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Default, true
}

// SetDefault sets field value
func (o *ProjectConfig) SetDefault(v bool) {
	o.Default = v
}

// GetEnvVars returns the EnvVars field value
func (o *ProjectConfig) GetEnvVars() map[string]string {
	if o == nil {
		var ret map[string]string
		return ret
	}

	return o.EnvVars
}

// GetEnvVarsOk returns a tuple with the EnvVars field value
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetEnvVarsOk() (*map[string]string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EnvVars, true
}

// SetEnvVars sets field value
func (o *ProjectConfig) SetEnvVars(v map[string]string) {
	o.EnvVars = v
}

// GetImage returns the Image field value
func (o *ProjectConfig) GetImage() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Image
}

// GetImageOk returns a tuple with the Image field value
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetImageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Image, true
}

// SetImage sets field value
func (o *ProjectConfig) SetImage(v string) {
	o.Image = v
}

// GetName returns the Name field value
func (o *ProjectConfig) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *ProjectConfig) SetName(v string) {
	o.Name = v
}

// GetPrebuilds returns the Prebuilds field value if set, zero value otherwise.
func (o *ProjectConfig) GetPrebuilds() []PrebuildConfig {
	if o == nil || IsNil(o.Prebuilds) {
		var ret []PrebuildConfig
		return ret
	}
	return o.Prebuilds
}

// GetPrebuildsOk returns a tuple with the Prebuilds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetPrebuildsOk() ([]PrebuildConfig, bool) {
	if o == nil || IsNil(o.Prebuilds) {
		return nil, false
	}
	return o.Prebuilds, true
}

// HasPrebuilds returns a boolean if a field has been set.
func (o *ProjectConfig) HasPrebuilds() bool {
	if o != nil && !IsNil(o.Prebuilds) {
		return true
	}

	return false
}

// SetPrebuilds gets a reference to the given []PrebuildConfig and assigns it to the Prebuilds field.
func (o *ProjectConfig) SetPrebuilds(v []PrebuildConfig) {
	o.Prebuilds = v
}

// GetRepositoryUrl returns the RepositoryUrl field value
func (o *ProjectConfig) GetRepositoryUrl() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.RepositoryUrl
}

// GetRepositoryUrlOk returns a tuple with the RepositoryUrl field value
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetRepositoryUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RepositoryUrl, true
}

// SetRepositoryUrl sets field value
func (o *ProjectConfig) SetRepositoryUrl(v string) {
	o.RepositoryUrl = v
}

// GetUser returns the User field value
func (o *ProjectConfig) GetUser() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.User
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
func (o *ProjectConfig) GetUserOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.User, true
}

// SetUser sets field value
func (o *ProjectConfig) SetUser(v string) {
	o.User = v
}

func (o ProjectConfig) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ProjectConfig) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.BuildConfig) {
		toSerialize["buildConfig"] = o.BuildConfig
	}
	toSerialize["default"] = o.Default
	toSerialize["envVars"] = o.EnvVars
	toSerialize["image"] = o.Image
	toSerialize["name"] = o.Name
	if !IsNil(o.Prebuilds) {
		toSerialize["prebuilds"] = o.Prebuilds
	}
	toSerialize["repositoryUrl"] = o.RepositoryUrl
	toSerialize["user"] = o.User
	return toSerialize, nil
}

func (o *ProjectConfig) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"default",
		"envVars",
		"image",
		"name",
		"repositoryUrl",
		"user",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varProjectConfig := _ProjectConfig{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varProjectConfig)

	if err != nil {
		return err
	}

	*o = ProjectConfig(varProjectConfig)

	return err
}

type NullableProjectConfig struct {
	value *ProjectConfig
	isSet bool
}

func (v NullableProjectConfig) Get() *ProjectConfig {
	return v.value
}

func (v *NullableProjectConfig) Set(val *ProjectConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableProjectConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableProjectConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableProjectConfig(val *ProjectConfig) *NullableProjectConfig {
	return &NullableProjectConfig{value: val, isSet: true}
}

func (v NullableProjectConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableProjectConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
