/*
Daytona Server API

Daytona Server API

API version: v0.0.0-dev
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package apiclient

import (
	"bytes"
	"encoding/json"
	"fmt"
)

// checks if the PrebuildDTO type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PrebuildDTO{}

// PrebuildDTO struct for PrebuildDTO
type PrebuildDTO struct {
	Branch            string   `json:"branch"`
	CommitInterval    *int32   `json:"commitInterval,omitempty"`
	Id                string   `json:"id"`
	ProjectConfigName string   `json:"projectConfigName"`
	Retention         int32    `json:"retention"`
	TriggerFiles      []string `json:"triggerFiles,omitempty"`
}

type _PrebuildDTO PrebuildDTO

// NewPrebuildDTO instantiates a new PrebuildDTO object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPrebuildDTO(branch string, id string, projectConfigName string, retention int32) *PrebuildDTO {
	this := PrebuildDTO{}
	this.Branch = branch
	this.Id = id
	this.ProjectConfigName = projectConfigName
	this.Retention = retention
	return &this
}

// NewPrebuildDTOWithDefaults instantiates a new PrebuildDTO object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPrebuildDTOWithDefaults() *PrebuildDTO {
	this := PrebuildDTO{}
	return &this
}

// GetBranch returns the Branch field value
func (o *PrebuildDTO) GetBranch() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Branch
}

// GetBranchOk returns a tuple with the Branch field value
// and a boolean to check if the value has been set.
func (o *PrebuildDTO) GetBranchOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Branch, true
}

// SetBranch sets field value
func (o *PrebuildDTO) SetBranch(v string) {
	o.Branch = v
}

// GetCommitInterval returns the CommitInterval field value if set, zero value otherwise.
func (o *PrebuildDTO) GetCommitInterval() int32 {
	if o == nil || IsNil(o.CommitInterval) {
		var ret int32
		return ret
	}
	return *o.CommitInterval
}

// GetCommitIntervalOk returns a tuple with the CommitInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PrebuildDTO) GetCommitIntervalOk() (*int32, bool) {
	if o == nil || IsNil(o.CommitInterval) {
		return nil, false
	}
	return o.CommitInterval, true
}

// HasCommitInterval returns a boolean if a field has been set.
func (o *PrebuildDTO) HasCommitInterval() bool {
	if o != nil && !IsNil(o.CommitInterval) {
		return true
	}

	return false
}

// SetCommitInterval gets a reference to the given int32 and assigns it to the CommitInterval field.
func (o *PrebuildDTO) SetCommitInterval(v int32) {
	o.CommitInterval = &v
}

// GetId returns the Id field value
func (o *PrebuildDTO) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *PrebuildDTO) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *PrebuildDTO) SetId(v string) {
	o.Id = v
}

// GetProjectConfigName returns the ProjectConfigName field value
func (o *PrebuildDTO) GetProjectConfigName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ProjectConfigName
}

// GetProjectConfigNameOk returns a tuple with the ProjectConfigName field value
// and a boolean to check if the value has been set.
func (o *PrebuildDTO) GetProjectConfigNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ProjectConfigName, true
}

// SetProjectConfigName sets field value
func (o *PrebuildDTO) SetProjectConfigName(v string) {
	o.ProjectConfigName = v
}

// GetRetention returns the Retention field value
func (o *PrebuildDTO) GetRetention() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Retention
}

// GetRetentionOk returns a tuple with the Retention field value
// and a boolean to check if the value has been set.
func (o *PrebuildDTO) GetRetentionOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Retention, true
}

// SetRetention sets field value
func (o *PrebuildDTO) SetRetention(v int32) {
	o.Retention = v
}

// GetTriggerFiles returns the TriggerFiles field value if set, zero value otherwise.
func (o *PrebuildDTO) GetTriggerFiles() []string {
	if o == nil || IsNil(o.TriggerFiles) {
		var ret []string
		return ret
	}
	return o.TriggerFiles
}

// GetTriggerFilesOk returns a tuple with the TriggerFiles field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PrebuildDTO) GetTriggerFilesOk() ([]string, bool) {
	if o == nil || IsNil(o.TriggerFiles) {
		return nil, false
	}
	return o.TriggerFiles, true
}

// HasTriggerFiles returns a boolean if a field has been set.
func (o *PrebuildDTO) HasTriggerFiles() bool {
	if o != nil && !IsNil(o.TriggerFiles) {
		return true
	}

	return false
}

// SetTriggerFiles gets a reference to the given []string and assigns it to the TriggerFiles field.
func (o *PrebuildDTO) SetTriggerFiles(v []string) {
	o.TriggerFiles = v
}

func (o PrebuildDTO) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PrebuildDTO) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["branch"] = o.Branch
	if !IsNil(o.CommitInterval) {
		toSerialize["commitInterval"] = o.CommitInterval
	}
	toSerialize["id"] = o.Id
	toSerialize["projectConfigName"] = o.ProjectConfigName
	toSerialize["retention"] = o.Retention
	if !IsNil(o.TriggerFiles) {
		toSerialize["triggerFiles"] = o.TriggerFiles
	}
	return toSerialize, nil
}

func (o *PrebuildDTO) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"branch",
		"id",
		"projectConfigName",
		"retention",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varPrebuildDTO := _PrebuildDTO{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varPrebuildDTO)

	if err != nil {
		return err
	}

	*o = PrebuildDTO(varPrebuildDTO)

	return err
}

type NullablePrebuildDTO struct {
	value *PrebuildDTO
	isSet bool
}

func (v NullablePrebuildDTO) Get() *PrebuildDTO {
	return v.value
}

func (v *NullablePrebuildDTO) Set(val *PrebuildDTO) {
	v.value = val
	v.isSet = true
}

func (v NullablePrebuildDTO) IsSet() bool {
	return v.isSet
}

func (v *NullablePrebuildDTO) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePrebuildDTO(val *PrebuildDTO) *NullablePrebuildDTO {
	return &NullablePrebuildDTO{value: val, isSet: true}
}

func (v NullablePrebuildDTO) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePrebuildDTO) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
