/*
Daytona Server API

Daytona Server API

API version: v0.0.0-dev
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package apiclient

import (
	"bytes"
	"encoding/json"
	"fmt"
)

// checks if the Build type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Build{}

// Build struct for Build
type Build struct {
	BuildConfig     *BuildConfig      `json:"buildConfig,omitempty"`
	ContainerConfig ContainerConfig   `json:"containerConfig"`
	CreatedAt       string            `json:"createdAt"`
	EnvVars         map[string]string `json:"envVars"`
	Id              string            `json:"id"`
	Image           *string           `json:"image,omitempty"`
	PrebuildId      string            `json:"prebuildId"`
	Repository      GitRepository     `json:"repository"`
	State           BuildBuildState   `json:"state"`
	UpdatedAt       string            `json:"updatedAt"`
	User            *string           `json:"user,omitempty"`
}

type _Build Build

// NewBuild instantiates a new Build object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBuild(containerConfig ContainerConfig, createdAt string, envVars map[string]string, id string, prebuildId string, repository GitRepository, state BuildBuildState, updatedAt string) *Build {
	this := Build{}
	this.ContainerConfig = containerConfig
	this.CreatedAt = createdAt
	this.EnvVars = envVars
	this.Id = id
	this.PrebuildId = prebuildId
	this.Repository = repository
	this.State = state
	this.UpdatedAt = updatedAt
	return &this
}

// NewBuildWithDefaults instantiates a new Build object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBuildWithDefaults() *Build {
	this := Build{}
	return &this
}

// GetBuildConfig returns the BuildConfig field value if set, zero value otherwise.
func (o *Build) GetBuildConfig() BuildConfig {
	if o == nil || IsNil(o.BuildConfig) {
		var ret BuildConfig
		return ret
	}
	return *o.BuildConfig
}

// GetBuildConfigOk returns a tuple with the BuildConfig field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Build) GetBuildConfigOk() (*BuildConfig, bool) {
	if o == nil || IsNil(o.BuildConfig) {
		return nil, false
	}
	return o.BuildConfig, true
}

// HasBuildConfig returns a boolean if a field has been set.
func (o *Build) HasBuildConfig() bool {
	if o != nil && !IsNil(o.BuildConfig) {
		return true
	}

	return false
}

// SetBuildConfig gets a reference to the given BuildConfig and assigns it to the BuildConfig field.
func (o *Build) SetBuildConfig(v BuildConfig) {
	o.BuildConfig = &v
}

// GetContainerConfig returns the ContainerConfig field value
func (o *Build) GetContainerConfig() ContainerConfig {
	if o == nil {
		var ret ContainerConfig
		return ret
	}

	return o.ContainerConfig
}

// GetContainerConfigOk returns a tuple with the ContainerConfig field value
// and a boolean to check if the value has been set.
func (o *Build) GetContainerConfigOk() (*ContainerConfig, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ContainerConfig, true
}

// SetContainerConfig sets field value
func (o *Build) SetContainerConfig(v ContainerConfig) {
	o.ContainerConfig = v
}

// GetCreatedAt returns the CreatedAt field value
func (o *Build) GetCreatedAt() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value
// and a boolean to check if the value has been set.
func (o *Build) GetCreatedAtOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CreatedAt, true
}

// SetCreatedAt sets field value
func (o *Build) SetCreatedAt(v string) {
	o.CreatedAt = v
}

// GetEnvVars returns the EnvVars field value
func (o *Build) GetEnvVars() map[string]string {
	if o == nil {
		var ret map[string]string
		return ret
	}

	return o.EnvVars
}

// GetEnvVarsOk returns a tuple with the EnvVars field value
// and a boolean to check if the value has been set.
func (o *Build) GetEnvVarsOk() (*map[string]string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EnvVars, true
}

// SetEnvVars sets field value
func (o *Build) SetEnvVars(v map[string]string) {
	o.EnvVars = v
}

// GetId returns the Id field value
func (o *Build) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *Build) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *Build) SetId(v string) {
	o.Id = v
}

// GetImage returns the Image field value if set, zero value otherwise.
func (o *Build) GetImage() string {
	if o == nil || IsNil(o.Image) {
		var ret string
		return ret
	}
	return *o.Image
}

// GetImageOk returns a tuple with the Image field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Build) GetImageOk() (*string, bool) {
	if o == nil || IsNil(o.Image) {
		return nil, false
	}
	return o.Image, true
}

// HasImage returns a boolean if a field has been set.
func (o *Build) HasImage() bool {
	if o != nil && !IsNil(o.Image) {
		return true
	}

	return false
}

// SetImage gets a reference to the given string and assigns it to the Image field.
func (o *Build) SetImage(v string) {
	o.Image = &v
}

// GetPrebuildId returns the PrebuildId field value
func (o *Build) GetPrebuildId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.PrebuildId
}

// GetPrebuildIdOk returns a tuple with the PrebuildId field value
// and a boolean to check if the value has been set.
func (o *Build) GetPrebuildIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PrebuildId, true
}

// SetPrebuildId sets field value
func (o *Build) SetPrebuildId(v string) {
	o.PrebuildId = v
}

// GetRepository returns the Repository field value
func (o *Build) GetRepository() GitRepository {
	if o == nil {
		var ret GitRepository
		return ret
	}

	return o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value
// and a boolean to check if the value has been set.
func (o *Build) GetRepositoryOk() (*GitRepository, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Repository, true
}

// SetRepository sets field value
func (o *Build) SetRepository(v GitRepository) {
	o.Repository = v
}

// GetState returns the State field value
func (o *Build) GetState() BuildBuildState {
	if o == nil {
		var ret BuildBuildState
		return ret
	}

	return o.State
}

// GetStateOk returns a tuple with the State field value
// and a boolean to check if the value has been set.
func (o *Build) GetStateOk() (*BuildBuildState, bool) {
	if o == nil {
		return nil, false
	}
	return &o.State, true
}

// SetState sets field value
func (o *Build) SetState(v BuildBuildState) {
	o.State = v
}

// GetUpdatedAt returns the UpdatedAt field value
func (o *Build) GetUpdatedAt() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.UpdatedAt
}

// GetUpdatedAtOk returns a tuple with the UpdatedAt field value
// and a boolean to check if the value has been set.
func (o *Build) GetUpdatedAtOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.UpdatedAt, true
}

// SetUpdatedAt sets field value
func (o *Build) SetUpdatedAt(v string) {
	o.UpdatedAt = v
}

// GetUser returns the User field value if set, zero value otherwise.
func (o *Build) GetUser() string {
	if o == nil || IsNil(o.User) {
		var ret string
		return ret
	}
	return *o.User
}

// GetUserOk returns a tuple with the User field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Build) GetUserOk() (*string, bool) {
	if o == nil || IsNil(o.User) {
		return nil, false
	}
	return o.User, true
}

// HasUser returns a boolean if a field has been set.
func (o *Build) HasUser() bool {
	if o != nil && !IsNil(o.User) {
		return true
	}

	return false
}

// SetUser gets a reference to the given string and assigns it to the User field.
func (o *Build) SetUser(v string) {
	o.User = &v
}

func (o Build) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Build) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.BuildConfig) {
		toSerialize["buildConfig"] = o.BuildConfig
	}
	toSerialize["containerConfig"] = o.ContainerConfig
	toSerialize["createdAt"] = o.CreatedAt
	toSerialize["envVars"] = o.EnvVars
	toSerialize["id"] = o.Id
	if !IsNil(o.Image) {
		toSerialize["image"] = o.Image
	}
	toSerialize["prebuildId"] = o.PrebuildId
	toSerialize["repository"] = o.Repository
	toSerialize["state"] = o.State
	toSerialize["updatedAt"] = o.UpdatedAt
	if !IsNil(o.User) {
		toSerialize["user"] = o.User
	}
	return toSerialize, nil
}

func (o *Build) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"containerConfig",
		"createdAt",
		"envVars",
		"id",
		"prebuildId",
		"repository",
		"state",
		"updatedAt",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varBuild := _Build{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varBuild)

	if err != nil {
		return err
	}

	*o = Build(varBuild)

	return err
}

type NullableBuild struct {
	value *Build
	isSet bool
}

func (v NullableBuild) Get() *Build {
	return v.value
}

func (v *NullableBuild) Set(val *Build) {
	v.value = val
	v.isSet = true
}

func (v NullableBuild) IsSet() bool {
	return v.isSet
}

func (v *NullableBuild) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBuild(val *Build) *NullableBuild {
	return &NullableBuild{value: val, isSet: true}
}

func (v NullableBuild) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBuild) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
