---
title: Overview
nav_order: 1
layout: page
---

# Overview

Dalfox is a powerful open-source tool designed for automated detection of XSS (Cross-Site Scripting) vulnerabilities. With its advanced testing engine and comprehensive feature set, Dalfox simplifies the process of scanning, analyzing parameters, and verifying vulnerabilities. Whether you are performing quick scans or detailed analyses, Dalfox provides a streamlined experience tailored to the needs of security professionals and researchers.

![Dalfox Screenshot](/images/screen.jpeg)

The name "Dalfox" has a unique origin:
- **Dal ([달](https://en.wiktionary.org/wiki/달))**: The Korean word for "moon."
- **Fox**: An acronym for "Finder Of XSS" 🦊.

Key highlights of Dalfox include:
- **Flexible Scanning Modes**: Supports URL-based scans, file-based inputs, pipelines, and server modes for versatile testing approaches.
- **Comprehensive Analysis**: Detects reflected, stored, and DOM-based XSS vulnerabilities, along with parameter mining and static analysis to ensure thorough coverage.
- **Extensibility**: Offers custom payloads, remote wordlists, and API integrations for highly tailored testing to meet your specific requirements.
- **Performance Optimization**: Features such as payload abstraction, bad character filtering, and parallel encoding substantially improve efficiency and reduce scan times.
- **Detailed Reporting**: Outputs can be formatted as plain text or JSON, with options for in-depth reports to facilitate clear communication of findings.

## Contributors

Dalfox is an open-source project made with ❤️

If you want to contribute to this project, please see [CONTRIBUTING.md](https://github.com/hahwul/dalfox/blob/main/CONTRIBUTING.md) and submit a Pull Request with your contributions.

[![Contributors](https://github.com/hahwul/dalfox/raw/main/CONTRIBUTORS.svg)](https://github.com/hahwul/dalfox/graphs/contributors)