Share your applications, videos, and blog posts with fellow Copilots!

## Blog posts

| Title      | Description                          |
| ----------- | ------------------------------------ |
| [**Automatically deploying your container application with AWS Copilot**](https://aws.amazon.com/blogs/containers/automatically-deploying-your-container-application-with-aws-copilot/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> | Nathan shows how to setup a release pipeline with the CLI that builds, pushes, and deploys an application. Finally, he sets up integration tests for validation before releasing to production. |
| [**Deploying containers with the AWS Copilot CLI**](https://maartenbruntink.nl/blog/2020/08/16/deploying-containers-with-the-aws-copilot-cli-part-1/) by <a href="https://twitter.com/maartenbruntink">@maartenbruntink</a> | Maarten shows to deploy the [sample Docker voting app](https://github.com/dockersamples/example-voting-app) with the AWS Copilot CLI that showcases how to setup your own Redis and Postgres servers. In the [second part](https://maartenbruntink.nl/blog/2020/08/16/deploying-containers-with-the-aws-copilot-cli-part-2), he automates the release process. |
| [**AWS Copilot: an application-first CLI for containers on AWS**](https://aws.amazon.com/blogs/containers/aws-copilot-an-application-first-cli-for-containers-on-aws/) by <a href="https://twitter.com/efekarakus">@efekarakus</a> | Efe walks through the design tenets of the CLI, why they were chosen, how they map to Copilot features, and the vision for how the CLI will evolve in the future.  |
| [**Introducing AWS Copilot**](https://aws.amazon.com/blogs/containers/introducing-aws-copilot/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> | Nathan explains how with the AWS Copilot CLI you can go from idea to implementation much faster, with the confidence that the infrastructure you have deployed has production-ready configuration. |



## Videos

| Title      | Description                          |
| ----------- | ------------------------------------ |
| [**Containers from the Couch series**](https://www.youtube.com/c/ContainersfromtheCouch/search?query=copilot) by <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a>, <a href="https://twitter.com/brentContained">@brentContained</a>, and guests | Join Adam and Brent to learn about all the existing features of AWS Copilot with fun demos. From setting up a three-tier application with autoscaling to creating a continuous delivery pipeline with integration tests. |
| [**AWS What's Next**](https://www.youtube.com/watch?v=vmTJgVDERZU) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> and <a href="https://twitter.com/efekarakus">@efekarakus</a> | Nathan and Efe discusses what makes AWS Copilot unique compared to other infrastructure provisioning tools and then demo an overview of the existing commands. |
| [**Happy Building with AWS Copilot**](https://www.youtube.com/watch?v=drYy_V7X1BU) by <a href="https://twitter.com/kohidave">@kohidave</a> and <a href="https://twitter.com/efekarakus">@efekarakus</a> | Learn about the motivation behind AWS Copilot, and get a demo of a load balanced web service integrated with Amazon DynamoDB. |



## Code samples

| Repository      | Description                          | Key features |
| ----------- | ------------------------------------ | ------------ |
[**github.com/copilot-example-voting-app**](https://github.com/copilot-example-voting-app) | A voting application distributed over three ECS services created with AWS Copilot. | Amazon Aurora PostgreSQL database, service discovery, autoscaling |


## Workshops
| Title      | Description                          |
| ----------- | ------------------------------------ |
[**ECS Workshop**](https://ecsworkshop.com/microservices/) | In this workshop, we deploy a three tier microservices application using the copilot-cli |
