// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

package cli

import (
	"errors"

	"github.com/aws/copilot-cli/cmd/copilot/template"
	"github.com/aws/copilot-cli/internal/pkg/cli/group"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

var errNoAppInWorkspace = errors.New("could not find an application attached to this workspace, please run `app init` first")

// BuildSvcCmd is the top level command for service.
func BuildSvcCmd() *cobra.Command {
	cmd := &cobra.Command{
		Use: "svc",
		Short: `Commands for services.
Services are long-running Amazon ECS services.`,
		Long: `Commands for services.
Services are long-running Amazon ECS services.`,
	}
	// The flags bound by viper are available to all sub-commands through viper.GetString({flagName})
	cmd.PersistentFlags().StringP(appFlag, appFlagShort, "" /* default */, appFlagDescription)
	_ = viper.BindPFlag(appFlag, cmd.PersistentFlags().Lookup(appFlag)) // Ignore err because the flag name is not empty.

	cmd.AddCommand(BuildSvcInitCmd())
	cmd.AddCommand(BuildSvcListCmd())
	cmd.AddCommand(BuildSvcPackageCmd())
	cmd.AddCommand(BuildSvcDeployCmd())
	cmd.AddCommand(BuildSvcDeleteCmd())
	cmd.AddCommand(BuildSvcShowCmd())
	cmd.AddCommand(BuildSvcStatusCmd())
	cmd.AddCommand(BuildSvcLogsCmd())

	cmd.SetUsageTemplate(template.Usage)

	cmd.Annotations = map[string]string{
		"group": group.Develop,
	}
	return cmd
}
