package monday

// ============================================================
// Format rules for "pl_PL" locale: Polish (Poland)
// ============================================================

var longDayNamesPlPL = map[string]string{
	"Sunday":    "Niedziela",
	"Monday":    "Poniedziałek",
	"Tuesday":   "Wtorek",
	"Wednesday": "Środa",
	"Thursday":  "Czwartek",
	"Friday":    "Piątek",
	"Saturday":  "Sobota",
}

// http://sjp.pwn.pl/poradnia/haslo/skracanie-nazw-dni-tygodnia-i-miesiecy;8124.html
var shortDayNamesPlPL = map[string]string{
	"Sun": "Nie",
	"Mon": "Pon",
	"Tue": "Wto",
	"Wed": "Śro",
	"Thu": "Czw",
	"Fri": "Pią",
	"Sat": "Sob",
}

var longMonthNamesPlPL = map[string]string{
	"January":   "Styczeń",
	"February":  "Luty",
	"March":     "Marzec",
	"April":     "Kwiecień",
	"May":       "Maj",
	"June":      "Czerwiec",
	"July":      "Lipiec",
	"August":    "Sierpień",
	"September": "Wrzesień",
	"October":   "Październik",
	"November":  "Listopad",
	"December":  "Grudzień",
}

var shortMonthNamesPlPL = map[string]string{
	"Jan": "Sty",
	"Feb": "Lut",
	"Mar": "Mar",
	"Apr": "Kwi",
	"May": "Maj",
	"Jun": "Cze",
	"Jul": "Lip",
	"Aug": "Sie",
	"Sep": "Wrz",
	"Oct": "Paź",
	"Nov": "Lis",
	"Dec": "Gru",
}
