<h3 align="center">
  <br />
  <img src="https://user-images.githubusercontent.com/168240/39561871-51cda852-4e5d-11e8-926b-7692d43143e8.png" alt="logo" width="400" />
  <br />
  <br />
  <br />
</h3>

# cointop

> Coin tracking for hackers

[![License](http://img.shields.io/badge/license-Apache-blue.svg)](https://raw.githubusercontent.com/miguelmota/cointop/master/LICENSE)
[![Build Status](https://travis-ci.org/miguelmota/cointop.svg?branch=master)](https://travis-ci.org/miguelmota/cointop)
[![Go Report Card](https://goreportcard.com/badge/github.com/miguelmota/cointop?)](https://goreportcard.com/report/github.com/miguelmota/cointop)
[![GoDoc](https://godoc.org/github.com/miguelmota/cointop?status.svg)](https://godoc.org/github.com/miguelmota/cointop)
[![Mentioned in Awesome Terminals](https://awesome.re/mentioned-badge.svg)](https://github.com/k4m4/terminals-are-sexy)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](#contributing)

[`cointop`](https://github.com/miguelmota/cointop) is a fast and lightweight interactive terminal based UI application for tracking and monitoring cryptocurrency coin stats in real-time.

The interface is inspired by [`htop`](https://en.wikipedia.org/wiki/Htop) and shortcut keys are inspired by [`vim`](https://en.wikipedia.org/wiki/Vim_(text_editor)).

<img src="https://user-images.githubusercontent.com/168240/39569578-7ce9f3b6-4e7a-11e8-82a9-8a18b91b1bd5.png" alt="cointop screenshot" width="880" />

## Demo

```bash
ssh cointop.sh
```

In action

<img src="https://user-images.githubusercontent.com/168240/39569570-75b1547c-4e7a-11e8-8eac-552abaa431f0.gif" alt="screencast" width="880" />

## Table of Contents

- [Features](#features)
- [Documentation](#documentation)
- [Install](#install)
- [Update](#update)
- [Getting started](#getting-started)
- [Shortcuts](#shortcuts)
- [Colorschemes](#colorschemes)
- [Config](#config)
- [SSH server](#ssh-server)
- [FAQ](#faq)
- [Contributing](#contributing)
- [Social](#social)
- [Mentioned in](#mentioned-in)
- [Tip Jar](#tip-jar)
- [License](#license)

## Features

- Quick sort shortcuts
- Custom key bindings configuration
- Vim inspired shortcut keys
- Fast pagination
- Charts for coins and global market graphs
- Quick chart date range change
- Fuzzy searching for finding coins
- Currency conversion
- Save and view favorite coins
- Portfolio tracking of holdings
- 256-color support
- Custom colorschemes
- Help menu
- Offline cache
- Supports multiple coin stat APIs
- Auto-refresh
- Works on macOS, Linux, and Windows
- It's very lightweight; can be left running indefinitely

## Documentation

Documentation has been moved to [docs.cointop.sh](https://docs.cointop.sh/)

Some helpful documentation links are provided below.

## Install

See [docs.cointop.sh/install](https://docs.cointop.sh/install)

## Update

See [docs.cointop.sh/update](https://docs.cointop.sh/update)

## Shortcuts

See [docs.cointop.sh/shortcuts](https://docs.cointop.sh/shortcuts)

## Colorschemes

See [docs.cointop.sh/colorschemes](https://docs.cointop.sh/colorschemes)

## Config

See [docs.cointop.sh/config](https://docs.cointop.sh/config)

## SSH Server

See [docs.cointop.sh/ssh](https://docs.cointop.sh/ssh)

## FAQ

See [docs.cointop.sh/faq](https://docs.cointop.sh/faq)

## Contributing

See [docs.cointop.sh/contributing](https://docs.cointop.sh/contributing)

## Social

- Follow on twitter [@cointop](https://twitter.com/cointop)
- Discuss on [Discord](https://discord.gg/pUVGy7ECGg)

## Mentioned in

Cointop has been mentioned in:

- [@Ubuntu Twitter](https://twitter.com/ubuntu/status/985947962311311360?lang=en)
- [Terminals Are Sexy](https://github.com/k4m4/terminals-are-sexy#tools-and-plugins)
- [The Changelog News](https://changelog.com/news/cointop-coin-tracking-for-hackers-rAzZ)

### Tip Jar

[![BTC Tip Jar](https://img.shields.io/badge/BTC-tip-yellow.svg?logo=bitcoin&style=flat)](https://www.blockchain.com/btc/address/3KdMW53vUMLPEC33xhHAUx4EFtvmXQF8Kf) `3KdMW53vUMLPEC33xhHAUx4EFtvmXQF8Kf`

[![ETH Tip Jar](https://img.shields.io/badge/ETH-tip-blue.svg?logo=ethereum&style=flat)](https://etherscan.io/address/0x0072cdd7c3d9963ba69506ECf50e16E963B35bb1) `0x0072cdd7c3d9963ba69506ECf50e16E963B35bb1`

Thank you for tips! 🙏

## License

Released under the [Apache 2.0](./LICENSE) license.
