package flink

import (
	"strings"

	"github.com/spf13/cobra"

	pcmd "github.com/confluentinc/cli/internal/pkg/cmd"
	"github.com/confluentinc/cli/internal/pkg/examples"
	"github.com/confluentinc/cli/internal/pkg/output"
)

type regionOut struct {
	Id    string `human:"ID" serialized:"id"`
	Name  string `human:"Name" serialized:"name"`
	Cloud string `human:"Cloud" serialized:"cloud"`
}

func (c *command) newRegionListCommand() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "list",
		Short: "List Flink regions.",
		Args:  cobra.NoArgs,
		RunE:  c.regionList,
		Example: examples.BuildExampleString(
			examples.Example{
				Text: "List the available Flink AWS regions.",
				Code: "confluent flink region list --cloud aws",
			},
		),
	}

	pcmd.AddCloudFlag(cmd)
	pcmd.AddOutputFlag(cmd)

	return cmd
}

func (c *command) regionList(cmd *cobra.Command, args []string) error {
	cloud, err := cmd.Flags().GetString("cloud")
	if err != nil {
		return err
	}

	regions, err := c.V2Client.ListFlinkRegions(strings.ToUpper(cloud))
	if err != nil {
		return err
	}

	list := output.NewList(cmd)
	for _, region := range regions {
		list.Add(&regionOut{
			Id:    region.GetRegionName(),
			Name:  region.GetDisplayName(),
			Cloud: region.GetCloud(),
		})
	}
	return list.Print()
}
