/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1alpha1"
	scheme "github.com/tektoncd/triggers/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// InterceptorsGetter has a method to return a InterceptorInterface.
// A group's client should implement this interface.
type InterceptorsGetter interface {
	Interceptors(namespace string) InterceptorInterface
}

// InterceptorInterface has methods to work with Interceptor resources.
type InterceptorInterface interface {
	Create(ctx context.Context, interceptor *v1alpha1.Interceptor, opts v1.CreateOptions) (*v1alpha1.Interceptor, error)
	Update(ctx context.Context, interceptor *v1alpha1.Interceptor, opts v1.UpdateOptions) (*v1alpha1.Interceptor, error)
	UpdateStatus(ctx context.Context, interceptor *v1alpha1.Interceptor, opts v1.UpdateOptions) (*v1alpha1.Interceptor, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Interceptor, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.InterceptorList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Interceptor, err error)
	InterceptorExpansion
}

// interceptors implements InterceptorInterface
type interceptors struct {
	client rest.Interface
	ns     string
}

// newInterceptors returns a Interceptors
func newInterceptors(c *TriggersV1alpha1Client, namespace string) *interceptors {
	return &interceptors{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the interceptor, and returns the corresponding interceptor object, and an error if there is any.
func (c *interceptors) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Interceptor, err error) {
	result = &v1alpha1.Interceptor{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("interceptors").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Interceptors that match those selectors.
func (c *interceptors) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.InterceptorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.InterceptorList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("interceptors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested interceptors.
func (c *interceptors) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("interceptors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a interceptor and creates it.  Returns the server's representation of the interceptor, and an error, if there is any.
func (c *interceptors) Create(ctx context.Context, interceptor *v1alpha1.Interceptor, opts v1.CreateOptions) (result *v1alpha1.Interceptor, err error) {
	result = &v1alpha1.Interceptor{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("interceptors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(interceptor).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a interceptor and updates it. Returns the server's representation of the interceptor, and an error, if there is any.
func (c *interceptors) Update(ctx context.Context, interceptor *v1alpha1.Interceptor, opts v1.UpdateOptions) (result *v1alpha1.Interceptor, err error) {
	result = &v1alpha1.Interceptor{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("interceptors").
		Name(interceptor.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(interceptor).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *interceptors) UpdateStatus(ctx context.Context, interceptor *v1alpha1.Interceptor, opts v1.UpdateOptions) (result *v1alpha1.Interceptor, err error) {
	result = &v1alpha1.Interceptor{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("interceptors").
		Name(interceptor.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(interceptor).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the interceptor and deletes it. Returns an error if one occurs.
func (c *interceptors) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("interceptors").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *interceptors) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("interceptors").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched interceptor.
func (c *interceptors) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Interceptor, err error) {
	result = &v1alpha1.Interceptor{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("interceptors").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
