// Copyright 2021 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: proto/v1/intoto_statement.proto

package grafeas_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement
// The serialized InTotoStatement will be stored as Envelope.payload.
// Envelope.payloadType is always "application/vnd.in-toto+json".
type InTotoStatement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always `https://in-toto.io/Statement/v0.1`.
	Type    string     `protobuf:"bytes,1,opt,name=type,json=_type,proto3" json:"type,omitempty"`
	Subject []*Subject `protobuf:"bytes,2,rep,name=subject,proto3" json:"subject,omitempty"`
	// `https://slsa.dev/provenance/v0.1` for SlsaProvenance.
	PredicateType string `protobuf:"bytes,3,opt,name=predicate_type,json=predicateType,proto3" json:"predicate_type,omitempty"`
	// Types that are assignable to Predicate:
	//
	//	*InTotoStatement_Provenance
	//	*InTotoStatement_SlsaProvenance
	//	*InTotoStatement_SlsaProvenanceZeroTwo
	Predicate isInTotoStatement_Predicate `protobuf_oneof:"predicate"`
}

func (x *InTotoStatement) Reset() {
	*x = InTotoStatement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoStatement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoStatement) ProtoMessage() {}

func (x *InTotoStatement) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoStatement.ProtoReflect.Descriptor instead.
func (*InTotoStatement) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{0}
}

func (x *InTotoStatement) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *InTotoStatement) GetSubject() []*Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *InTotoStatement) GetPredicateType() string {
	if x != nil {
		return x.PredicateType
	}
	return ""
}

func (m *InTotoStatement) GetPredicate() isInTotoStatement_Predicate {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (x *InTotoStatement) GetProvenance() *InTotoProvenance {
	if x, ok := x.GetPredicate().(*InTotoStatement_Provenance); ok {
		return x.Provenance
	}
	return nil
}

func (x *InTotoStatement) GetSlsaProvenance() *SlsaProvenance {
	if x, ok := x.GetPredicate().(*InTotoStatement_SlsaProvenance); ok {
		return x.SlsaProvenance
	}
	return nil
}

func (x *InTotoStatement) GetSlsaProvenanceZeroTwo() *SlsaProvenanceZeroTwo {
	if x, ok := x.GetPredicate().(*InTotoStatement_SlsaProvenanceZeroTwo); ok {
		return x.SlsaProvenanceZeroTwo
	}
	return nil
}

type isInTotoStatement_Predicate interface {
	isInTotoStatement_Predicate()
}

type InTotoStatement_Provenance struct {
	Provenance *InTotoProvenance `protobuf:"bytes,4,opt,name=provenance,proto3,oneof"`
}

type InTotoStatement_SlsaProvenance struct {
	SlsaProvenance *SlsaProvenance `protobuf:"bytes,5,opt,name=slsa_provenance,json=slsaProvenance,proto3,oneof"`
}

type InTotoStatement_SlsaProvenanceZeroTwo struct {
	SlsaProvenanceZeroTwo *SlsaProvenanceZeroTwo `protobuf:"bytes,6,opt,name=slsa_provenance_zero_two,json=slsaProvenanceZeroTwo,proto3,oneof"`
}

func (*InTotoStatement_Provenance) isInTotoStatement_Predicate() {}

func (*InTotoStatement_SlsaProvenance) isInTotoStatement_Predicate() {}

func (*InTotoStatement_SlsaProvenanceZeroTwo) isInTotoStatement_Predicate() {}

type Subject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// `"<ALGORITHM>": "<HEX_VALUE>"`
	// Algorithms can be e.g. sha256, sha512
	// See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
	Digest map[string]string `protobuf:"bytes,2,rep,name=digest,proto3" json:"digest,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Subject) Reset() {
	*x = Subject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subject) ProtoMessage() {}

func (x *Subject) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subject.ProtoReflect.Descriptor instead.
func (*Subject) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{1}
}

func (x *Subject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subject) GetDigest() map[string]string {
	if x != nil {
		return x.Digest
	}
	return nil
}

var File_proto_v1_intoto_statement_proto protoreflect.FileDescriptor

var file_proto_v1_intoto_statement_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74,
	0x6f, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x20, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x27, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x74,
	0x77, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x02, 0x0a, 0x0f, 0x49, 0x6e, 0x54,
	0x6f, 0x74, 0x6f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x13, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x2d, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x50,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x73, 0x6c, 0x73, 0x61, 0x5f,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c,
	0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e,
	0x73, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5c,
	0x0a, 0x18, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x74, 0x77, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c,
	0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5a, 0x65, 0x72, 0x6f,
	0x54, 0x77, 0x6f, 0x48, 0x00, 0x52, 0x15, 0x73, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5a, 0x65, 0x72, 0x6f, 0x54, 0x77, 0x6f, 0x42, 0x0b, 0x0a, 0x09,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x07, 0x53, 0x75,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x63, 0x0a,
	0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x14,
	0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x34, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xa2, 0x02, 0x03, 0x47,
	0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_proto_v1_intoto_statement_proto_rawDescOnce sync.Once
	file_proto_v1_intoto_statement_proto_rawDescData = file_proto_v1_intoto_statement_proto_rawDesc
)

func file_proto_v1_intoto_statement_proto_rawDescGZIP() []byte {
	file_proto_v1_intoto_statement_proto_rawDescOnce.Do(func() {
		file_proto_v1_intoto_statement_proto_rawDescData = protoimpl.X.CompressGZIP(file_proto_v1_intoto_statement_proto_rawDescData)
	})
	return file_proto_v1_intoto_statement_proto_rawDescData
}

var file_proto_v1_intoto_statement_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_proto_v1_intoto_statement_proto_goTypes = []interface{}{
	(*InTotoStatement)(nil),       // 0: grafeas.v1.InTotoStatement
	(*Subject)(nil),               // 1: grafeas.v1.Subject
	nil,                           // 2: grafeas.v1.Subject.DigestEntry
	(*InTotoProvenance)(nil),      // 3: grafeas.v1.InTotoProvenance
	(*SlsaProvenance)(nil),        // 4: grafeas.v1.SlsaProvenance
	(*SlsaProvenanceZeroTwo)(nil), // 5: grafeas.v1.SlsaProvenanceZeroTwo
}
var file_proto_v1_intoto_statement_proto_depIdxs = []int32{
	1, // 0: grafeas.v1.InTotoStatement.subject:type_name -> grafeas.v1.Subject
	3, // 1: grafeas.v1.InTotoStatement.provenance:type_name -> grafeas.v1.InTotoProvenance
	4, // 2: grafeas.v1.InTotoStatement.slsa_provenance:type_name -> grafeas.v1.SlsaProvenance
	5, // 3: grafeas.v1.InTotoStatement.slsa_provenance_zero_two:type_name -> grafeas.v1.SlsaProvenanceZeroTwo
	2, // 4: grafeas.v1.Subject.digest:type_name -> grafeas.v1.Subject.DigestEntry
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_proto_v1_intoto_statement_proto_init() }
func file_proto_v1_intoto_statement_proto_init() {
	if File_proto_v1_intoto_statement_proto != nil {
		return
	}
	file_proto_v1_intoto_provenance_proto_init()
	file_proto_v1_slsa_provenance_proto_init()
	file_proto_v1_slsa_provenance_zero_two_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_proto_v1_intoto_statement_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoStatement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_proto_v1_intoto_statement_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*InTotoStatement_Provenance)(nil),
		(*InTotoStatement_SlsaProvenance)(nil),
		(*InTotoStatement_SlsaProvenanceZeroTwo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_proto_v1_intoto_statement_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_proto_v1_intoto_statement_proto_goTypes,
		DependencyIndexes: file_proto_v1_intoto_statement_proto_depIdxs,
		MessageInfos:      file_proto_v1_intoto_statement_proto_msgTypes,
	}.Build()
	File_proto_v1_intoto_statement_proto = out.File
	file_proto_v1_intoto_statement_proto_rawDesc = nil
	file_proto_v1_intoto_statement_proto_goTypes = nil
	file_proto_v1_intoto_statement_proto_depIdxs = nil
}
