/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeVerificationPolicies implements VerificationPolicyInterface
type FakeVerificationPolicies struct {
	Fake *FakeTektonV1alpha1
	ns   string
}

var verificationpoliciesResource = schema.GroupVersionResource{Group: "tekton.dev", Version: "v1alpha1", Resource: "verificationpolicies"}

var verificationpoliciesKind = schema.GroupVersionKind{Group: "tekton.dev", Version: "v1alpha1", Kind: "VerificationPolicy"}

// Get takes name of the verificationPolicy, and returns the corresponding verificationPolicy object, and an error if there is any.
func (c *FakeVerificationPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VerificationPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(verificationpoliciesResource, c.ns, name), &v1alpha1.VerificationPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VerificationPolicy), err
}

// List takes label and field selectors, and returns the list of VerificationPolicies that match those selectors.
func (c *FakeVerificationPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VerificationPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(verificationpoliciesResource, verificationpoliciesKind, c.ns, opts), &v1alpha1.VerificationPolicyList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VerificationPolicyList{ListMeta: obj.(*v1alpha1.VerificationPolicyList).ListMeta}
	for _, item := range obj.(*v1alpha1.VerificationPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested verificationPolicies.
func (c *FakeVerificationPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(verificationpoliciesResource, c.ns, opts))

}

// Create takes the representation of a verificationPolicy and creates it.  Returns the server's representation of the verificationPolicy, and an error, if there is any.
func (c *FakeVerificationPolicies) Create(ctx context.Context, verificationPolicy *v1alpha1.VerificationPolicy, opts v1.CreateOptions) (result *v1alpha1.VerificationPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(verificationpoliciesResource, c.ns, verificationPolicy), &v1alpha1.VerificationPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VerificationPolicy), err
}

// Update takes the representation of a verificationPolicy and updates it. Returns the server's representation of the verificationPolicy, and an error, if there is any.
func (c *FakeVerificationPolicies) Update(ctx context.Context, verificationPolicy *v1alpha1.VerificationPolicy, opts v1.UpdateOptions) (result *v1alpha1.VerificationPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(verificationpoliciesResource, c.ns, verificationPolicy), &v1alpha1.VerificationPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VerificationPolicy), err
}

// Delete takes name of the verificationPolicy and deletes it. Returns an error if one occurs.
func (c *FakeVerificationPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(verificationpoliciesResource, c.ns, name, opts), &v1alpha1.VerificationPolicy{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVerificationPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(verificationpoliciesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.VerificationPolicyList{})
	return err
}

// Patch applies the patch and returns the patched verificationPolicy.
func (c *FakeVerificationPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VerificationPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(verificationpoliciesResource, c.ns, name, pt, data, subresources...), &v1alpha1.VerificationPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VerificationPolicy), err
}
