/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/tektoncd/pipeline/pkg/apis/resolution/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ResolutionRequestLister helps list ResolutionRequests.
// All objects returned here must be treated as read-only.
type ResolutionRequestLister interface {
	// List lists all ResolutionRequests in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.ResolutionRequest, err error)
	// ResolutionRequests returns an object that can list and get ResolutionRequests.
	ResolutionRequests(namespace string) ResolutionRequestNamespaceLister
	ResolutionRequestListerExpansion
}

// resolutionRequestLister implements the ResolutionRequestLister interface.
type resolutionRequestLister struct {
	indexer cache.Indexer
}

// NewResolutionRequestLister returns a new ResolutionRequestLister.
func NewResolutionRequestLister(indexer cache.Indexer) ResolutionRequestLister {
	return &resolutionRequestLister{indexer: indexer}
}

// List lists all ResolutionRequests in the indexer.
func (s *resolutionRequestLister) List(selector labels.Selector) (ret []*v1beta1.ResolutionRequest, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ResolutionRequest))
	})
	return ret, err
}

// ResolutionRequests returns an object that can list and get ResolutionRequests.
func (s *resolutionRequestLister) ResolutionRequests(namespace string) ResolutionRequestNamespaceLister {
	return resolutionRequestNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ResolutionRequestNamespaceLister helps list and get ResolutionRequests.
// All objects returned here must be treated as read-only.
type ResolutionRequestNamespaceLister interface {
	// List lists all ResolutionRequests in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.ResolutionRequest, err error)
	// Get retrieves the ResolutionRequest from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.ResolutionRequest, error)
	ResolutionRequestNamespaceListerExpansion
}

// resolutionRequestNamespaceLister implements the ResolutionRequestNamespaceLister
// interface.
type resolutionRequestNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ResolutionRequests in the indexer for a given namespace.
func (s resolutionRequestNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.ResolutionRequest, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ResolutionRequest))
	})
	return ret, err
}

// Get retrieves the ResolutionRequest from the indexer for a given namespace and name.
func (s resolutionRequestNamespaceLister) Get(name string) (*v1beta1.ResolutionRequest, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("resolutionrequest"), name)
	}
	return obj.(*v1beta1.ResolutionRequest), nil
}
