/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CustomRunLister helps list CustomRuns.
// All objects returned here must be treated as read-only.
type CustomRunLister interface {
	// List lists all CustomRuns in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.CustomRun, err error)
	// CustomRuns returns an object that can list and get CustomRuns.
	CustomRuns(namespace string) CustomRunNamespaceLister
	CustomRunListerExpansion
}

// customRunLister implements the CustomRunLister interface.
type customRunLister struct {
	indexer cache.Indexer
}

// NewCustomRunLister returns a new CustomRunLister.
func NewCustomRunLister(indexer cache.Indexer) CustomRunLister {
	return &customRunLister{indexer: indexer}
}

// List lists all CustomRuns in the indexer.
func (s *customRunLister) List(selector labels.Selector) (ret []*v1beta1.CustomRun, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.CustomRun))
	})
	return ret, err
}

// CustomRuns returns an object that can list and get CustomRuns.
func (s *customRunLister) CustomRuns(namespace string) CustomRunNamespaceLister {
	return customRunNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CustomRunNamespaceLister helps list and get CustomRuns.
// All objects returned here must be treated as read-only.
type CustomRunNamespaceLister interface {
	// List lists all CustomRuns in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.CustomRun, err error)
	// Get retrieves the CustomRun from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.CustomRun, error)
	CustomRunNamespaceListerExpansion
}

// customRunNamespaceLister implements the CustomRunNamespaceLister
// interface.
type customRunNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CustomRuns in the indexer for a given namespace.
func (s customRunNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.CustomRun, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.CustomRun))
	})
	return ret, err
}

// Get retrieves the CustomRun from the indexer for a given namespace and name.
func (s customRunNamespaceLister) Get(name string) (*v1beta1.CustomRun, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("customrun"), name)
	}
	return obj.(*v1beta1.CustomRun), nil
}
