// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RekorVersion rekor version
//
// swagger:model RekorVersion
type RekorVersion struct {

	// builddate
	// Required: true
	Builddate *string `json:"builddate"`

	// commit
	// Required: true
	Commit *string `json:"commit"`

	// treestate
	// Required: true
	Treestate *string `json:"treestate"`

	// version
	// Required: true
	Version *string `json:"version"`
}

// Validate validates this rekor version
func (m *RekorVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBuilddate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCommit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTreestate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RekorVersion) validateBuilddate(formats strfmt.Registry) error {

	if err := validate.Required("builddate", "body", m.Builddate); err != nil {
		return err
	}

	return nil
}

func (m *RekorVersion) validateCommit(formats strfmt.Registry) error {

	if err := validate.Required("commit", "body", m.Commit); err != nil {
		return err
	}

	return nil
}

func (m *RekorVersion) validateTreestate(formats strfmt.Registry) error {

	if err := validate.Required("treestate", "body", m.Treestate); err != nil {
		return err
	}

	return nil
}

func (m *RekorVersion) validateVersion(formats strfmt.Registry) error {

	if err := validate.Required("version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this rekor version based on context it is used
func (m *RekorVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *RekorVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RekorVersion) UnmarshalBinary(b []byte) error {
	var res RekorVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
