/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// EventListenerLister helps list EventListeners.
// All objects returned here must be treated as read-only.
type EventListenerLister interface {
	// List lists all EventListeners in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.EventListener, err error)
	// EventListeners returns an object that can list and get EventListeners.
	EventListeners(namespace string) EventListenerNamespaceLister
	EventListenerListerExpansion
}

// eventListenerLister implements the EventListenerLister interface.
type eventListenerLister struct {
	indexer cache.Indexer
}

// NewEventListenerLister returns a new EventListenerLister.
func NewEventListenerLister(indexer cache.Indexer) EventListenerLister {
	return &eventListenerLister{indexer: indexer}
}

// List lists all EventListeners in the indexer.
func (s *eventListenerLister) List(selector labels.Selector) (ret []*v1beta1.EventListener, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.EventListener))
	})
	return ret, err
}

// EventListeners returns an object that can list and get EventListeners.
func (s *eventListenerLister) EventListeners(namespace string) EventListenerNamespaceLister {
	return eventListenerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// EventListenerNamespaceLister helps list and get EventListeners.
// All objects returned here must be treated as read-only.
type EventListenerNamespaceLister interface {
	// List lists all EventListeners in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.EventListener, err error)
	// Get retrieves the EventListener from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.EventListener, error)
	EventListenerNamespaceListerExpansion
}

// eventListenerNamespaceLister implements the EventListenerNamespaceLister
// interface.
type eventListenerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all EventListeners in the indexer for a given namespace.
func (s eventListenerNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.EventListener, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.EventListener))
	})
	return ret, err
}

// Get retrieves the EventListener from the indexer for a given namespace and name.
func (s eventListenerNamespaceLister) Get(name string) (*v1beta1.EventListener, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("eventlistener"), name)
	}
	return obj.(*v1beta1.EventListener), nil
}
