/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by injection-gen. DO NOT EDIT.

package client

import (
	context "context"
	json "encoding/json"
	errors "errors"
	fmt "fmt"

	admissionregistrationv1 "k8s.io/api/admissionregistration/v1"
	admissionregistrationv1beta1 "k8s.io/api/admissionregistration/v1beta1"
	apiserverinternalv1alpha1 "k8s.io/api/apiserverinternal/v1alpha1"
	apiappsv1 "k8s.io/api/apps/v1"
	apiappsv1beta1 "k8s.io/api/apps/v1beta1"
	appsv1beta2 "k8s.io/api/apps/v1beta2"
	authenticationv1 "k8s.io/api/authentication/v1"
	authenticationv1beta1 "k8s.io/api/authentication/v1beta1"
	authorizationv1 "k8s.io/api/authorization/v1"
	authorizationv1beta1 "k8s.io/api/authorization/v1beta1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	autoscalingv2 "k8s.io/api/autoscaling/v2"
	autoscalingv2beta1 "k8s.io/api/autoscaling/v2beta1"
	autoscalingv2beta2 "k8s.io/api/autoscaling/v2beta2"
	apibatchv1 "k8s.io/api/batch/v1"
	apibatchv1beta1 "k8s.io/api/batch/v1beta1"
	apicertificatesv1 "k8s.io/api/certificates/v1"
	apicertificatesv1beta1 "k8s.io/api/certificates/v1beta1"
	apicoordinationv1 "k8s.io/api/coordination/v1"
	apicoordinationv1beta1 "k8s.io/api/coordination/v1beta1"
	apicorev1 "k8s.io/api/core/v1"
	apidiscoveryv1 "k8s.io/api/discovery/v1"
	apidiscoveryv1beta1 "k8s.io/api/discovery/v1beta1"
	apieventsv1 "k8s.io/api/events/v1"
	apieventsv1beta1 "k8s.io/api/events/v1beta1"
	apiextensionsv1beta1 "k8s.io/api/extensions/v1beta1"
	apiflowcontrolv1alpha1 "k8s.io/api/flowcontrol/v1alpha1"
	apiflowcontrolv1beta1 "k8s.io/api/flowcontrol/v1beta1"
	apiflowcontrolv1beta2 "k8s.io/api/flowcontrol/v1beta2"
	apinetworkingv1 "k8s.io/api/networking/v1"
	apinetworkingv1beta1 "k8s.io/api/networking/v1beta1"
	apinodev1 "k8s.io/api/node/v1"
	apinodev1alpha1 "k8s.io/api/node/v1alpha1"
	apinodev1beta1 "k8s.io/api/node/v1beta1"
	apipolicyv1 "k8s.io/api/policy/v1"
	apipolicyv1beta1 "k8s.io/api/policy/v1beta1"
	apirbacv1 "k8s.io/api/rbac/v1"
	apirbacv1alpha1 "k8s.io/api/rbac/v1alpha1"
	apirbacv1beta1 "k8s.io/api/rbac/v1beta1"
	apischedulingv1 "k8s.io/api/scheduling/v1"
	apischedulingv1alpha1 "k8s.io/api/scheduling/v1alpha1"
	apischedulingv1beta1 "k8s.io/api/scheduling/v1beta1"
	apistoragev1 "k8s.io/api/storage/v1"
	apistoragev1alpha1 "k8s.io/api/storage/v1alpha1"
	apistoragev1beta1 "k8s.io/api/storage/v1beta1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	unstructured "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	v1 "k8s.io/client-go/applyconfigurations/admissionregistration/v1"
	v1beta1 "k8s.io/client-go/applyconfigurations/admissionregistration/v1beta1"
	v1alpha1 "k8s.io/client-go/applyconfigurations/apiserverinternal/v1alpha1"
	appsv1 "k8s.io/client-go/applyconfigurations/apps/v1"
	appsv1beta1 "k8s.io/client-go/applyconfigurations/apps/v1beta1"
	v1beta2 "k8s.io/client-go/applyconfigurations/apps/v1beta2"
	applyconfigurationsautoscalingv1 "k8s.io/client-go/applyconfigurations/autoscaling/v1"
	v2 "k8s.io/client-go/applyconfigurations/autoscaling/v2"
	v2beta1 "k8s.io/client-go/applyconfigurations/autoscaling/v2beta1"
	v2beta2 "k8s.io/client-go/applyconfigurations/autoscaling/v2beta2"
	batchv1 "k8s.io/client-go/applyconfigurations/batch/v1"
	batchv1beta1 "k8s.io/client-go/applyconfigurations/batch/v1beta1"
	certificatesv1 "k8s.io/client-go/applyconfigurations/certificates/v1"
	certificatesv1beta1 "k8s.io/client-go/applyconfigurations/certificates/v1beta1"
	coordinationv1 "k8s.io/client-go/applyconfigurations/coordination/v1"
	coordinationv1beta1 "k8s.io/client-go/applyconfigurations/coordination/v1beta1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	discoveryv1 "k8s.io/client-go/applyconfigurations/discovery/v1"
	discoveryv1beta1 "k8s.io/client-go/applyconfigurations/discovery/v1beta1"
	eventsv1 "k8s.io/client-go/applyconfigurations/events/v1"
	eventsv1beta1 "k8s.io/client-go/applyconfigurations/events/v1beta1"
	extensionsv1beta1 "k8s.io/client-go/applyconfigurations/extensions/v1beta1"
	flowcontrolv1alpha1 "k8s.io/client-go/applyconfigurations/flowcontrol/v1alpha1"
	flowcontrolv1beta1 "k8s.io/client-go/applyconfigurations/flowcontrol/v1beta1"
	flowcontrolv1beta2 "k8s.io/client-go/applyconfigurations/flowcontrol/v1beta2"
	networkingv1 "k8s.io/client-go/applyconfigurations/networking/v1"
	networkingv1beta1 "k8s.io/client-go/applyconfigurations/networking/v1beta1"
	nodev1 "k8s.io/client-go/applyconfigurations/node/v1"
	nodev1alpha1 "k8s.io/client-go/applyconfigurations/node/v1alpha1"
	nodev1beta1 "k8s.io/client-go/applyconfigurations/node/v1beta1"
	policyv1 "k8s.io/client-go/applyconfigurations/policy/v1"
	policyv1beta1 "k8s.io/client-go/applyconfigurations/policy/v1beta1"
	rbacv1 "k8s.io/client-go/applyconfigurations/rbac/v1"
	rbacv1alpha1 "k8s.io/client-go/applyconfigurations/rbac/v1alpha1"
	rbacv1beta1 "k8s.io/client-go/applyconfigurations/rbac/v1beta1"
	schedulingv1 "k8s.io/client-go/applyconfigurations/scheduling/v1"
	schedulingv1alpha1 "k8s.io/client-go/applyconfigurations/scheduling/v1alpha1"
	schedulingv1beta1 "k8s.io/client-go/applyconfigurations/scheduling/v1beta1"
	storagev1 "k8s.io/client-go/applyconfigurations/storage/v1"
	storagev1alpha1 "k8s.io/client-go/applyconfigurations/storage/v1alpha1"
	storagev1beta1 "k8s.io/client-go/applyconfigurations/storage/v1beta1"
	discovery "k8s.io/client-go/discovery"
	dynamic "k8s.io/client-go/dynamic"
	kubernetes "k8s.io/client-go/kubernetes"
	typedadmissionregistrationv1 "k8s.io/client-go/kubernetes/typed/admissionregistration/v1"
	typedadmissionregistrationv1beta1 "k8s.io/client-go/kubernetes/typed/admissionregistration/v1beta1"
	typedinternalv1alpha1 "k8s.io/client-go/kubernetes/typed/apiserverinternal/v1alpha1"
	typedappsv1 "k8s.io/client-go/kubernetes/typed/apps/v1"
	typedappsv1beta1 "k8s.io/client-go/kubernetes/typed/apps/v1beta1"
	typedappsv1beta2 "k8s.io/client-go/kubernetes/typed/apps/v1beta2"
	typedauthenticationv1 "k8s.io/client-go/kubernetes/typed/authentication/v1"
	typedauthenticationv1beta1 "k8s.io/client-go/kubernetes/typed/authentication/v1beta1"
	typedauthorizationv1 "k8s.io/client-go/kubernetes/typed/authorization/v1"
	typedauthorizationv1beta1 "k8s.io/client-go/kubernetes/typed/authorization/v1beta1"
	typedautoscalingv1 "k8s.io/client-go/kubernetes/typed/autoscaling/v1"
	typedautoscalingv2 "k8s.io/client-go/kubernetes/typed/autoscaling/v2"
	typedautoscalingv2beta1 "k8s.io/client-go/kubernetes/typed/autoscaling/v2beta1"
	typedautoscalingv2beta2 "k8s.io/client-go/kubernetes/typed/autoscaling/v2beta2"
	typedbatchv1 "k8s.io/client-go/kubernetes/typed/batch/v1"
	typedbatchv1beta1 "k8s.io/client-go/kubernetes/typed/batch/v1beta1"
	typedcertificatesv1 "k8s.io/client-go/kubernetes/typed/certificates/v1"
	typedcertificatesv1beta1 "k8s.io/client-go/kubernetes/typed/certificates/v1beta1"
	typedcoordinationv1 "k8s.io/client-go/kubernetes/typed/coordination/v1"
	typedcoordinationv1beta1 "k8s.io/client-go/kubernetes/typed/coordination/v1beta1"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
	typeddiscoveryv1 "k8s.io/client-go/kubernetes/typed/discovery/v1"
	typeddiscoveryv1beta1 "k8s.io/client-go/kubernetes/typed/discovery/v1beta1"
	typedeventsv1 "k8s.io/client-go/kubernetes/typed/events/v1"
	typedeventsv1beta1 "k8s.io/client-go/kubernetes/typed/events/v1beta1"
	typedextensionsv1beta1 "k8s.io/client-go/kubernetes/typed/extensions/v1beta1"
	typedflowcontrolv1alpha1 "k8s.io/client-go/kubernetes/typed/flowcontrol/v1alpha1"
	typedflowcontrolv1beta1 "k8s.io/client-go/kubernetes/typed/flowcontrol/v1beta1"
	typedflowcontrolv1beta2 "k8s.io/client-go/kubernetes/typed/flowcontrol/v1beta2"
	typednetworkingv1 "k8s.io/client-go/kubernetes/typed/networking/v1"
	typednetworkingv1beta1 "k8s.io/client-go/kubernetes/typed/networking/v1beta1"
	typednodev1 "k8s.io/client-go/kubernetes/typed/node/v1"
	typednodev1alpha1 "k8s.io/client-go/kubernetes/typed/node/v1alpha1"
	typednodev1beta1 "k8s.io/client-go/kubernetes/typed/node/v1beta1"
	typedpolicyv1 "k8s.io/client-go/kubernetes/typed/policy/v1"
	typedpolicyv1beta1 "k8s.io/client-go/kubernetes/typed/policy/v1beta1"
	typedrbacv1 "k8s.io/client-go/kubernetes/typed/rbac/v1"
	typedrbacv1alpha1 "k8s.io/client-go/kubernetes/typed/rbac/v1alpha1"
	typedrbacv1beta1 "k8s.io/client-go/kubernetes/typed/rbac/v1beta1"
	typedschedulingv1 "k8s.io/client-go/kubernetes/typed/scheduling/v1"
	typedschedulingv1alpha1 "k8s.io/client-go/kubernetes/typed/scheduling/v1alpha1"
	typedschedulingv1beta1 "k8s.io/client-go/kubernetes/typed/scheduling/v1beta1"
	typedstoragev1 "k8s.io/client-go/kubernetes/typed/storage/v1"
	typedstoragev1alpha1 "k8s.io/client-go/kubernetes/typed/storage/v1alpha1"
	typedstoragev1beta1 "k8s.io/client-go/kubernetes/typed/storage/v1beta1"
	rest "k8s.io/client-go/rest"
	injection "knative.dev/pkg/injection"
	dynamicclient "knative.dev/pkg/injection/clients/dynamicclient"
	logging "knative.dev/pkg/logging"
)

func init() {
	injection.Default.RegisterClient(withClientFromConfig)
	injection.Default.RegisterClientFetcher(func(ctx context.Context) interface{} {
		return Get(ctx)
	})
	injection.Dynamic.RegisterDynamicClient(withClientFromDynamic)
}

// Key is used as the key for associating information with a context.Context.
type Key struct{}

func withClientFromConfig(ctx context.Context, cfg *rest.Config) context.Context {
	return context.WithValue(ctx, Key{}, kubernetes.NewForConfigOrDie(cfg))
}

func withClientFromDynamic(ctx context.Context) context.Context {
	return context.WithValue(ctx, Key{}, &wrapClient{dyn: dynamicclient.Get(ctx)})
}

// Get extracts the kubernetes.Interface client from the context.
func Get(ctx context.Context) kubernetes.Interface {
	untyped := ctx.Value(Key{})
	if untyped == nil {
		if injection.GetConfig(ctx) == nil {
			logging.FromContext(ctx).Panic(
				"Unable to fetch k8s.io/client-go/kubernetes.Interface from context. This context is not the application context (which is typically given to constructors via sharedmain).")
		} else {
			logging.FromContext(ctx).Panic(
				"Unable to fetch k8s.io/client-go/kubernetes.Interface from context.")
		}
	}
	return untyped.(kubernetes.Interface)
}

type wrapClient struct {
	dyn dynamic.Interface
}

var _ kubernetes.Interface = (*wrapClient)(nil)

func (w *wrapClient) Discovery() discovery.DiscoveryInterface {
	panic("Discovery called on dynamic client!")
}

func convert(from interface{}, to runtime.Object) error {
	bs, err := json.Marshal(from)
	if err != nil {
		return fmt.Errorf("Marshal() = %w", err)
	}
	if err := json.Unmarshal(bs, to); err != nil {
		return fmt.Errorf("Unmarshal() = %w", err)
	}
	return nil
}

// AdmissionregistrationV1 retrieves the AdmissionregistrationV1Client
func (w *wrapClient) AdmissionregistrationV1() typedadmissionregistrationv1.AdmissionregistrationV1Interface {
	return &wrapAdmissionregistrationV1{
		dyn: w.dyn,
	}
}

type wrapAdmissionregistrationV1 struct {
	dyn dynamic.Interface
}

func (w *wrapAdmissionregistrationV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAdmissionregistrationV1) MutatingWebhookConfigurations() typedadmissionregistrationv1.MutatingWebhookConfigurationInterface {
	return &wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "admissionregistration.k8s.io",
			Version:  "v1",
			Resource: "mutatingwebhookconfigurations",
		}),
	}
}

type wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedadmissionregistrationv1.MutatingWebhookConfigurationInterface = (*wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl)(nil)

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Apply(ctx context.Context, in *v1.MutatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1.MutatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) ApplyStatus(ctx context.Context, in *v1.MutatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1.MutatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Create(ctx context.Context, in *admissionregistrationv1.MutatingWebhookConfiguration, opts metav1.CreateOptions) (*admissionregistrationv1.MutatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1",
		Kind:    "MutatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*admissionregistrationv1.MutatingWebhookConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*admissionregistrationv1.MutatingWebhookConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.MutatingWebhookConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *admissionregistrationv1.MutatingWebhookConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Update(ctx context.Context, in *admissionregistrationv1.MutatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1.MutatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1",
		Kind:    "MutatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) UpdateStatus(ctx context.Context, in *admissionregistrationv1.MutatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1.MutatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1",
		Kind:    "MutatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1MutatingWebhookConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAdmissionregistrationV1) ValidatingWebhookConfigurations() typedadmissionregistrationv1.ValidatingWebhookConfigurationInterface {
	return &wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "admissionregistration.k8s.io",
			Version:  "v1",
			Resource: "validatingwebhookconfigurations",
		}),
	}
}

type wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedadmissionregistrationv1.ValidatingWebhookConfigurationInterface = (*wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl)(nil)

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Apply(ctx context.Context, in *v1.ValidatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1.ValidatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) ApplyStatus(ctx context.Context, in *v1.ValidatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1.ValidatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Create(ctx context.Context, in *admissionregistrationv1.ValidatingWebhookConfiguration, opts metav1.CreateOptions) (*admissionregistrationv1.ValidatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1",
		Kind:    "ValidatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*admissionregistrationv1.ValidatingWebhookConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*admissionregistrationv1.ValidatingWebhookConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.ValidatingWebhookConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *admissionregistrationv1.ValidatingWebhookConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Update(ctx context.Context, in *admissionregistrationv1.ValidatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1.ValidatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1",
		Kind:    "ValidatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) UpdateStatus(ctx context.Context, in *admissionregistrationv1.ValidatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1.ValidatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1",
		Kind:    "ValidatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1ValidatingWebhookConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// AdmissionregistrationV1beta1 retrieves the AdmissionregistrationV1beta1Client
func (w *wrapClient) AdmissionregistrationV1beta1() typedadmissionregistrationv1beta1.AdmissionregistrationV1beta1Interface {
	return &wrapAdmissionregistrationV1beta1{
		dyn: w.dyn,
	}
}

type wrapAdmissionregistrationV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapAdmissionregistrationV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAdmissionregistrationV1beta1) MutatingWebhookConfigurations() typedadmissionregistrationv1beta1.MutatingWebhookConfigurationInterface {
	return &wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "admissionregistration.k8s.io",
			Version:  "v1beta1",
			Resource: "mutatingwebhookconfigurations",
		}),
	}
}

type wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedadmissionregistrationv1beta1.MutatingWebhookConfigurationInterface = (*wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl)(nil)

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Apply(ctx context.Context, in *v1beta1.MutatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1beta1.MutatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) ApplyStatus(ctx context.Context, in *v1beta1.MutatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1beta1.MutatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Create(ctx context.Context, in *admissionregistrationv1beta1.MutatingWebhookConfiguration, opts metav1.CreateOptions) (*admissionregistrationv1beta1.MutatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1beta1",
		Kind:    "MutatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*admissionregistrationv1beta1.MutatingWebhookConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*admissionregistrationv1beta1.MutatingWebhookConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.MutatingWebhookConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *admissionregistrationv1beta1.MutatingWebhookConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Update(ctx context.Context, in *admissionregistrationv1beta1.MutatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1beta1.MutatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1beta1",
		Kind:    "MutatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) UpdateStatus(ctx context.Context, in *admissionregistrationv1beta1.MutatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1beta1.MutatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1beta1",
		Kind:    "MutatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.MutatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1MutatingWebhookConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAdmissionregistrationV1beta1) ValidatingWebhookConfigurations() typedadmissionregistrationv1beta1.ValidatingWebhookConfigurationInterface {
	return &wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "admissionregistration.k8s.io",
			Version:  "v1beta1",
			Resource: "validatingwebhookconfigurations",
		}),
	}
}

type wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedadmissionregistrationv1beta1.ValidatingWebhookConfigurationInterface = (*wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl)(nil)

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Apply(ctx context.Context, in *v1beta1.ValidatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1beta1.ValidatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) ApplyStatus(ctx context.Context, in *v1beta1.ValidatingWebhookConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *admissionregistrationv1beta1.ValidatingWebhookConfiguration, err error) {
	panic("NYI")
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Create(ctx context.Context, in *admissionregistrationv1beta1.ValidatingWebhookConfiguration, opts metav1.CreateOptions) (*admissionregistrationv1beta1.ValidatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1beta1",
		Kind:    "ValidatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*admissionregistrationv1beta1.ValidatingWebhookConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*admissionregistrationv1beta1.ValidatingWebhookConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.ValidatingWebhookConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *admissionregistrationv1beta1.ValidatingWebhookConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Update(ctx context.Context, in *admissionregistrationv1beta1.ValidatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1beta1.ValidatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1beta1",
		Kind:    "ValidatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) UpdateStatus(ctx context.Context, in *admissionregistrationv1beta1.ValidatingWebhookConfiguration, opts metav1.UpdateOptions) (*admissionregistrationv1beta1.ValidatingWebhookConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "admissionregistration.k8s.io",
		Version: "v1beta1",
		Kind:    "ValidatingWebhookConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &admissionregistrationv1beta1.ValidatingWebhookConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAdmissionregistrationV1beta1ValidatingWebhookConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// InternalV1alpha1 retrieves the InternalV1alpha1Client
func (w *wrapClient) InternalV1alpha1() typedinternalv1alpha1.InternalV1alpha1Interface {
	return &wrapInternalV1alpha1{
		dyn: w.dyn,
	}
}

type wrapInternalV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapInternalV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapInternalV1alpha1) StorageVersions() typedinternalv1alpha1.StorageVersionInterface {
	return &wrapInternalV1alpha1StorageVersionImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "internal.apiserver.k8s.io",
			Version:  "v1alpha1",
			Resource: "storageversions",
		}),
	}
}

type wrapInternalV1alpha1StorageVersionImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedinternalv1alpha1.StorageVersionInterface = (*wrapInternalV1alpha1StorageVersionImpl)(nil)

func (w *wrapInternalV1alpha1StorageVersionImpl) Apply(ctx context.Context, in *v1alpha1.StorageVersionApplyConfiguration, opts metav1.ApplyOptions) (result *apiserverinternalv1alpha1.StorageVersion, err error) {
	panic("NYI")
}

func (w *wrapInternalV1alpha1StorageVersionImpl) ApplyStatus(ctx context.Context, in *v1alpha1.StorageVersionApplyConfiguration, opts metav1.ApplyOptions) (result *apiserverinternalv1alpha1.StorageVersion, err error) {
	panic("NYI")
}

func (w *wrapInternalV1alpha1StorageVersionImpl) Create(ctx context.Context, in *apiserverinternalv1alpha1.StorageVersion, opts metav1.CreateOptions) (*apiserverinternalv1alpha1.StorageVersion, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "internal.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "StorageVersion",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiserverinternalv1alpha1.StorageVersion{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapInternalV1alpha1StorageVersionImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapInternalV1alpha1StorageVersionImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapInternalV1alpha1StorageVersionImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiserverinternalv1alpha1.StorageVersion, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiserverinternalv1alpha1.StorageVersion{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapInternalV1alpha1StorageVersionImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiserverinternalv1alpha1.StorageVersionList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiserverinternalv1alpha1.StorageVersionList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapInternalV1alpha1StorageVersionImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiserverinternalv1alpha1.StorageVersion, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiserverinternalv1alpha1.StorageVersion{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapInternalV1alpha1StorageVersionImpl) Update(ctx context.Context, in *apiserverinternalv1alpha1.StorageVersion, opts metav1.UpdateOptions) (*apiserverinternalv1alpha1.StorageVersion, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "internal.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "StorageVersion",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiserverinternalv1alpha1.StorageVersion{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapInternalV1alpha1StorageVersionImpl) UpdateStatus(ctx context.Context, in *apiserverinternalv1alpha1.StorageVersion, opts metav1.UpdateOptions) (*apiserverinternalv1alpha1.StorageVersion, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "internal.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "StorageVersion",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiserverinternalv1alpha1.StorageVersion{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapInternalV1alpha1StorageVersionImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// AppsV1 retrieves the AppsV1Client
func (w *wrapClient) AppsV1() typedappsv1.AppsV1Interface {
	return &wrapAppsV1{
		dyn: w.dyn,
	}
}

type wrapAppsV1 struct {
	dyn dynamic.Interface
}

func (w *wrapAppsV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAppsV1) ControllerRevisions(namespace string) typedappsv1.ControllerRevisionInterface {
	return &wrapAppsV1ControllerRevisionImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1",
			Resource: "controllerrevisions",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1ControllerRevisionImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1.ControllerRevisionInterface = (*wrapAppsV1ControllerRevisionImpl)(nil)

func (w *wrapAppsV1ControllerRevisionImpl) Apply(ctx context.Context, in *appsv1.ControllerRevisionApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.ControllerRevision, err error) {
	panic("NYI")
}

func (w *wrapAppsV1ControllerRevisionImpl) ApplyStatus(ctx context.Context, in *appsv1.ControllerRevisionApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.ControllerRevision, err error) {
	panic("NYI")
}

func (w *wrapAppsV1ControllerRevisionImpl) Create(ctx context.Context, in *apiappsv1.ControllerRevision, opts metav1.CreateOptions) (*apiappsv1.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ControllerRevisionImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1ControllerRevisionImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1ControllerRevisionImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1.ControllerRevision, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ControllerRevisionImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1.ControllerRevisionList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ControllerRevisionList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ControllerRevisionImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1.ControllerRevision, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ControllerRevisionImpl) Update(ctx context.Context, in *apiappsv1.ControllerRevision, opts metav1.UpdateOptions) (*apiappsv1.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ControllerRevisionImpl) UpdateStatus(ctx context.Context, in *apiappsv1.ControllerRevision, opts metav1.UpdateOptions) (*apiappsv1.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ControllerRevisionImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1) DaemonSets(namespace string) typedappsv1.DaemonSetInterface {
	return &wrapAppsV1DaemonSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1",
			Resource: "daemonsets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1DaemonSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1.DaemonSetInterface = (*wrapAppsV1DaemonSetImpl)(nil)

func (w *wrapAppsV1DaemonSetImpl) Apply(ctx context.Context, in *appsv1.DaemonSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.DaemonSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1DaemonSetImpl) ApplyStatus(ctx context.Context, in *appsv1.DaemonSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.DaemonSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1DaemonSetImpl) Create(ctx context.Context, in *apiappsv1.DaemonSet, opts metav1.CreateOptions) (*apiappsv1.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DaemonSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1DaemonSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1DaemonSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1.DaemonSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DaemonSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1.DaemonSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DaemonSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DaemonSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1.DaemonSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DaemonSetImpl) Update(ctx context.Context, in *apiappsv1.DaemonSet, opts metav1.UpdateOptions) (*apiappsv1.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DaemonSetImpl) UpdateStatus(ctx context.Context, in *apiappsv1.DaemonSet, opts metav1.UpdateOptions) (*apiappsv1.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DaemonSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1) Deployments(namespace string) typedappsv1.DeploymentInterface {
	return &wrapAppsV1DeploymentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1",
			Resource: "deployments",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1DeploymentImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1.DeploymentInterface = (*wrapAppsV1DeploymentImpl)(nil)

func (w *wrapAppsV1DeploymentImpl) Apply(ctx context.Context, in *appsv1.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.Deployment, err error) {
	panic("NYI")
}

func (w *wrapAppsV1DeploymentImpl) ApplyStatus(ctx context.Context, in *appsv1.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.Deployment, err error) {
	panic("NYI")
}

func (w *wrapAppsV1DeploymentImpl) Create(ctx context.Context, in *apiappsv1.Deployment, opts metav1.CreateOptions) (*apiappsv1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DeploymentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1DeploymentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1DeploymentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1.Deployment, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DeploymentImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1.DeploymentList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.DeploymentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DeploymentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1.Deployment, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DeploymentImpl) Update(ctx context.Context, in *apiappsv1.Deployment, opts metav1.UpdateOptions) (*apiappsv1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DeploymentImpl) UpdateStatus(ctx context.Context, in *apiappsv1.Deployment, opts metav1.UpdateOptions) (*apiappsv1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1DeploymentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1DeploymentImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1DeploymentImpl) UpdateScale(ctx context.Context, _ string, in *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1DeploymentImpl) ApplyScale(ctx context.Context, name string, in *applyconfigurationsautoscalingv1.ScaleApplyConfiguration, opts metav1.ApplyOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1) ReplicaSets(namespace string) typedappsv1.ReplicaSetInterface {
	return &wrapAppsV1ReplicaSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1",
			Resource: "replicasets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1ReplicaSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1.ReplicaSetInterface = (*wrapAppsV1ReplicaSetImpl)(nil)

func (w *wrapAppsV1ReplicaSetImpl) Apply(ctx context.Context, in *appsv1.ReplicaSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.ReplicaSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1ReplicaSetImpl) ApplyStatus(ctx context.Context, in *appsv1.ReplicaSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.ReplicaSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1ReplicaSetImpl) Create(ctx context.Context, in *apiappsv1.ReplicaSet, opts metav1.CreateOptions) (*apiappsv1.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ReplicaSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1ReplicaSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1ReplicaSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1.ReplicaSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ReplicaSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1.ReplicaSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ReplicaSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ReplicaSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1.ReplicaSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ReplicaSetImpl) Update(ctx context.Context, in *apiappsv1.ReplicaSet, opts metav1.UpdateOptions) (*apiappsv1.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ReplicaSetImpl) UpdateStatus(ctx context.Context, in *apiappsv1.ReplicaSet, opts metav1.UpdateOptions) (*apiappsv1.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1ReplicaSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1ReplicaSetImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1ReplicaSetImpl) UpdateScale(ctx context.Context, _ string, in *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1ReplicaSetImpl) ApplyScale(ctx context.Context, name string, in *applyconfigurationsautoscalingv1.ScaleApplyConfiguration, opts metav1.ApplyOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1) StatefulSets(namespace string) typedappsv1.StatefulSetInterface {
	return &wrapAppsV1StatefulSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1",
			Resource: "statefulsets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1StatefulSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1.StatefulSetInterface = (*wrapAppsV1StatefulSetImpl)(nil)

func (w *wrapAppsV1StatefulSetImpl) Apply(ctx context.Context, in *appsv1.StatefulSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.StatefulSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1StatefulSetImpl) ApplyStatus(ctx context.Context, in *appsv1.StatefulSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1.StatefulSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1StatefulSetImpl) Create(ctx context.Context, in *apiappsv1.StatefulSet, opts metav1.CreateOptions) (*apiappsv1.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1StatefulSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1StatefulSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1StatefulSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1.StatefulSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1StatefulSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1.StatefulSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.StatefulSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1StatefulSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1.StatefulSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1StatefulSetImpl) Update(ctx context.Context, in *apiappsv1.StatefulSet, opts metav1.UpdateOptions) (*apiappsv1.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1StatefulSetImpl) UpdateStatus(ctx context.Context, in *apiappsv1.StatefulSet, opts metav1.UpdateOptions) (*apiappsv1.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1StatefulSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1StatefulSetImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1StatefulSetImpl) UpdateScale(ctx context.Context, _ string, in *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1StatefulSetImpl) ApplyScale(ctx context.Context, name string, in *applyconfigurationsautoscalingv1.ScaleApplyConfiguration, opts metav1.ApplyOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

// AppsV1beta1 retrieves the AppsV1beta1Client
func (w *wrapClient) AppsV1beta1() typedappsv1beta1.AppsV1beta1Interface {
	return &wrapAppsV1beta1{
		dyn: w.dyn,
	}
}

type wrapAppsV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapAppsV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAppsV1beta1) ControllerRevisions(namespace string) typedappsv1beta1.ControllerRevisionInterface {
	return &wrapAppsV1beta1ControllerRevisionImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta1",
			Resource: "controllerrevisions",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta1ControllerRevisionImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta1.ControllerRevisionInterface = (*wrapAppsV1beta1ControllerRevisionImpl)(nil)

func (w *wrapAppsV1beta1ControllerRevisionImpl) Apply(ctx context.Context, in *appsv1beta1.ControllerRevisionApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1beta1.ControllerRevision, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) ApplyStatus(ctx context.Context, in *appsv1beta1.ControllerRevisionApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1beta1.ControllerRevision, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) Create(ctx context.Context, in *apiappsv1beta1.ControllerRevision, opts metav1.CreateOptions) (*apiappsv1beta1.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1beta1.ControllerRevision, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1beta1.ControllerRevisionList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.ControllerRevisionList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1beta1.ControllerRevision, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) Update(ctx context.Context, in *apiappsv1beta1.ControllerRevision, opts metav1.UpdateOptions) (*apiappsv1beta1.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) UpdateStatus(ctx context.Context, in *apiappsv1beta1.ControllerRevision, opts metav1.UpdateOptions) (*apiappsv1beta1.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1ControllerRevisionImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta1) Deployments(namespace string) typedappsv1beta1.DeploymentInterface {
	return &wrapAppsV1beta1DeploymentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta1",
			Resource: "deployments",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta1DeploymentImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta1.DeploymentInterface = (*wrapAppsV1beta1DeploymentImpl)(nil)

func (w *wrapAppsV1beta1DeploymentImpl) Apply(ctx context.Context, in *appsv1beta1.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1beta1.Deployment, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta1DeploymentImpl) ApplyStatus(ctx context.Context, in *appsv1beta1.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1beta1.Deployment, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta1DeploymentImpl) Create(ctx context.Context, in *apiappsv1beta1.Deployment, opts metav1.CreateOptions) (*apiappsv1beta1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1DeploymentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta1DeploymentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta1DeploymentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1beta1.Deployment, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1DeploymentImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1beta1.DeploymentList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.DeploymentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1DeploymentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1beta1.Deployment, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1DeploymentImpl) Update(ctx context.Context, in *apiappsv1beta1.Deployment, opts metav1.UpdateOptions) (*apiappsv1beta1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1DeploymentImpl) UpdateStatus(ctx context.Context, in *apiappsv1beta1.Deployment, opts metav1.UpdateOptions) (*apiappsv1beta1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1DeploymentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta1) StatefulSets(namespace string) typedappsv1beta1.StatefulSetInterface {
	return &wrapAppsV1beta1StatefulSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta1",
			Resource: "statefulsets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta1StatefulSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta1.StatefulSetInterface = (*wrapAppsV1beta1StatefulSetImpl)(nil)

func (w *wrapAppsV1beta1StatefulSetImpl) Apply(ctx context.Context, in *appsv1beta1.StatefulSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1beta1.StatefulSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta1StatefulSetImpl) ApplyStatus(ctx context.Context, in *appsv1beta1.StatefulSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiappsv1beta1.StatefulSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta1StatefulSetImpl) Create(ctx context.Context, in *apiappsv1beta1.StatefulSet, opts metav1.CreateOptions) (*apiappsv1beta1.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1StatefulSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta1StatefulSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta1StatefulSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiappsv1beta1.StatefulSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1StatefulSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiappsv1beta1.StatefulSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.StatefulSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1StatefulSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiappsv1beta1.StatefulSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1StatefulSetImpl) Update(ctx context.Context, in *apiappsv1beta1.StatefulSet, opts metav1.UpdateOptions) (*apiappsv1beta1.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1StatefulSetImpl) UpdateStatus(ctx context.Context, in *apiappsv1beta1.StatefulSet, opts metav1.UpdateOptions) (*apiappsv1beta1.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta1",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiappsv1beta1.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta1StatefulSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// AppsV1beta2 retrieves the AppsV1beta2Client
func (w *wrapClient) AppsV1beta2() typedappsv1beta2.AppsV1beta2Interface {
	return &wrapAppsV1beta2{
		dyn: w.dyn,
	}
}

type wrapAppsV1beta2 struct {
	dyn dynamic.Interface
}

func (w *wrapAppsV1beta2) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAppsV1beta2) ControllerRevisions(namespace string) typedappsv1beta2.ControllerRevisionInterface {
	return &wrapAppsV1beta2ControllerRevisionImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta2",
			Resource: "controllerrevisions",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta2ControllerRevisionImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta2.ControllerRevisionInterface = (*wrapAppsV1beta2ControllerRevisionImpl)(nil)

func (w *wrapAppsV1beta2ControllerRevisionImpl) Apply(ctx context.Context, in *v1beta2.ControllerRevisionApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.ControllerRevision, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) ApplyStatus(ctx context.Context, in *v1beta2.ControllerRevisionApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.ControllerRevision, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) Create(ctx context.Context, in *appsv1beta2.ControllerRevision, opts metav1.CreateOptions) (*appsv1beta2.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1beta2.ControllerRevision, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) List(ctx context.Context, opts metav1.ListOptions) (*appsv1beta2.ControllerRevisionList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ControllerRevisionList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *appsv1beta2.ControllerRevision, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) Update(ctx context.Context, in *appsv1beta2.ControllerRevision, opts metav1.UpdateOptions) (*appsv1beta2.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) UpdateStatus(ctx context.Context, in *appsv1beta2.ControllerRevision, opts metav1.UpdateOptions) (*appsv1beta2.ControllerRevision, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "ControllerRevision",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ControllerRevision{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ControllerRevisionImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta2) DaemonSets(namespace string) typedappsv1beta2.DaemonSetInterface {
	return &wrapAppsV1beta2DaemonSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta2",
			Resource: "daemonsets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta2DaemonSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta2.DaemonSetInterface = (*wrapAppsV1beta2DaemonSetImpl)(nil)

func (w *wrapAppsV1beta2DaemonSetImpl) Apply(ctx context.Context, in *v1beta2.DaemonSetApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.DaemonSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2DaemonSetImpl) ApplyStatus(ctx context.Context, in *v1beta2.DaemonSetApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.DaemonSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2DaemonSetImpl) Create(ctx context.Context, in *appsv1beta2.DaemonSet, opts metav1.CreateOptions) (*appsv1beta2.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DaemonSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta2DaemonSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta2DaemonSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1beta2.DaemonSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DaemonSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*appsv1beta2.DaemonSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DaemonSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DaemonSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *appsv1beta2.DaemonSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DaemonSetImpl) Update(ctx context.Context, in *appsv1beta2.DaemonSet, opts metav1.UpdateOptions) (*appsv1beta2.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DaemonSetImpl) UpdateStatus(ctx context.Context, in *appsv1beta2.DaemonSet, opts metav1.UpdateOptions) (*appsv1beta2.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DaemonSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta2) Deployments(namespace string) typedappsv1beta2.DeploymentInterface {
	return &wrapAppsV1beta2DeploymentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta2",
			Resource: "deployments",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta2DeploymentImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta2.DeploymentInterface = (*wrapAppsV1beta2DeploymentImpl)(nil)

func (w *wrapAppsV1beta2DeploymentImpl) Apply(ctx context.Context, in *v1beta2.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.Deployment, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2DeploymentImpl) ApplyStatus(ctx context.Context, in *v1beta2.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.Deployment, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2DeploymentImpl) Create(ctx context.Context, in *appsv1beta2.Deployment, opts metav1.CreateOptions) (*appsv1beta2.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DeploymentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta2DeploymentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta2DeploymentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1beta2.Deployment, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DeploymentImpl) List(ctx context.Context, opts metav1.ListOptions) (*appsv1beta2.DeploymentList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.DeploymentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DeploymentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *appsv1beta2.Deployment, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DeploymentImpl) Update(ctx context.Context, in *appsv1beta2.Deployment, opts metav1.UpdateOptions) (*appsv1beta2.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DeploymentImpl) UpdateStatus(ctx context.Context, in *appsv1beta2.Deployment, opts metav1.UpdateOptions) (*appsv1beta2.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2DeploymentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta2) ReplicaSets(namespace string) typedappsv1beta2.ReplicaSetInterface {
	return &wrapAppsV1beta2ReplicaSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta2",
			Resource: "replicasets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta2ReplicaSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta2.ReplicaSetInterface = (*wrapAppsV1beta2ReplicaSetImpl)(nil)

func (w *wrapAppsV1beta2ReplicaSetImpl) Apply(ctx context.Context, in *v1beta2.ReplicaSetApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.ReplicaSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2ReplicaSetImpl) ApplyStatus(ctx context.Context, in *v1beta2.ReplicaSetApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.ReplicaSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2ReplicaSetImpl) Create(ctx context.Context, in *appsv1beta2.ReplicaSet, opts metav1.CreateOptions) (*appsv1beta2.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ReplicaSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta2ReplicaSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta2ReplicaSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1beta2.ReplicaSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ReplicaSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*appsv1beta2.ReplicaSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ReplicaSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ReplicaSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *appsv1beta2.ReplicaSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ReplicaSetImpl) Update(ctx context.Context, in *appsv1beta2.ReplicaSet, opts metav1.UpdateOptions) (*appsv1beta2.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ReplicaSetImpl) UpdateStatus(ctx context.Context, in *appsv1beta2.ReplicaSet, opts metav1.UpdateOptions) (*appsv1beta2.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2ReplicaSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta2) StatefulSets(namespace string) typedappsv1beta2.StatefulSetInterface {
	return &wrapAppsV1beta2StatefulSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "apps",
			Version:  "v1beta2",
			Resource: "statefulsets",
		}),

		namespace: namespace,
	}
}

type wrapAppsV1beta2StatefulSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedappsv1beta2.StatefulSetInterface = (*wrapAppsV1beta2StatefulSetImpl)(nil)

func (w *wrapAppsV1beta2StatefulSetImpl) Apply(ctx context.Context, in *v1beta2.StatefulSetApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.StatefulSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2StatefulSetImpl) ApplyStatus(ctx context.Context, in *v1beta2.StatefulSetApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1beta2.StatefulSet, err error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2StatefulSetImpl) Create(ctx context.Context, in *appsv1beta2.StatefulSet, opts metav1.CreateOptions) (*appsv1beta2.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2StatefulSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAppsV1beta2StatefulSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAppsV1beta2StatefulSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1beta2.StatefulSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2StatefulSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*appsv1beta2.StatefulSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.StatefulSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2StatefulSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *appsv1beta2.StatefulSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2StatefulSetImpl) Update(ctx context.Context, in *appsv1beta2.StatefulSet, opts metav1.UpdateOptions) (*appsv1beta2.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2StatefulSetImpl) UpdateStatus(ctx context.Context, in *appsv1beta2.StatefulSet, opts metav1.UpdateOptions) (*appsv1beta2.StatefulSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "apps",
		Version: "v1beta2",
		Kind:    "StatefulSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &appsv1beta2.StatefulSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAppsV1beta2StatefulSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapAppsV1beta2StatefulSetImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1beta2.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2StatefulSetImpl) UpdateScale(ctx context.Context, _ string, in *appsv1beta2.Scale, opts metav1.UpdateOptions) (*appsv1beta2.Scale, error) {
	panic("NYI")
}

func (w *wrapAppsV1beta2StatefulSetImpl) ApplyScale(ctx context.Context, name string, in *v1beta2.ScaleApplyConfiguration, opts metav1.ApplyOptions) (*appsv1beta2.Scale, error) {
	panic("NYI")
}

// AuthenticationV1 retrieves the AuthenticationV1Client
func (w *wrapClient) AuthenticationV1() typedauthenticationv1.AuthenticationV1Interface {
	return &wrapAuthenticationV1{
		dyn: w.dyn,
	}
}

type wrapAuthenticationV1 struct {
	dyn dynamic.Interface
}

func (w *wrapAuthenticationV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAuthenticationV1) TokenReviews() typedauthenticationv1.TokenReviewInterface {
	return &wrapAuthenticationV1TokenReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authentication.k8s.io",
			Version:  "v1",
			Resource: "tokenreviews",
		}),
	}
}

type wrapAuthenticationV1TokenReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthenticationv1.TokenReviewInterface = (*wrapAuthenticationV1TokenReviewImpl)(nil)

func (w *wrapAuthenticationV1TokenReviewImpl) Create(ctx context.Context, in *authenticationv1.TokenReview, opts metav1.CreateOptions) (*authenticationv1.TokenReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authentication.k8s.io",
		Version: "v1",
		Kind:    "TokenReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authenticationv1.TokenReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

// AuthenticationV1beta1 retrieves the AuthenticationV1beta1Client
func (w *wrapClient) AuthenticationV1beta1() typedauthenticationv1beta1.AuthenticationV1beta1Interface {
	return &wrapAuthenticationV1beta1{
		dyn: w.dyn,
	}
}

type wrapAuthenticationV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapAuthenticationV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAuthenticationV1beta1) TokenReviews() typedauthenticationv1beta1.TokenReviewInterface {
	return &wrapAuthenticationV1beta1TokenReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authentication.k8s.io",
			Version:  "v1beta1",
			Resource: "tokenreviews",
		}),
	}
}

type wrapAuthenticationV1beta1TokenReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthenticationv1beta1.TokenReviewInterface = (*wrapAuthenticationV1beta1TokenReviewImpl)(nil)

func (w *wrapAuthenticationV1beta1TokenReviewImpl) Create(ctx context.Context, in *authenticationv1beta1.TokenReview, opts metav1.CreateOptions) (*authenticationv1beta1.TokenReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authentication.k8s.io",
		Version: "v1beta1",
		Kind:    "TokenReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authenticationv1beta1.TokenReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

// AuthorizationV1 retrieves the AuthorizationV1Client
func (w *wrapClient) AuthorizationV1() typedauthorizationv1.AuthorizationV1Interface {
	return &wrapAuthorizationV1{
		dyn: w.dyn,
	}
}

type wrapAuthorizationV1 struct {
	dyn dynamic.Interface
}

func (w *wrapAuthorizationV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAuthorizationV1) LocalSubjectAccessReviews(namespace string) typedauthorizationv1.LocalSubjectAccessReviewInterface {
	return &wrapAuthorizationV1LocalSubjectAccessReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1",
			Resource: "localsubjectaccessreviews",
		}),

		namespace: namespace,
	}
}

type wrapAuthorizationV1LocalSubjectAccessReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedauthorizationv1.LocalSubjectAccessReviewInterface = (*wrapAuthorizationV1LocalSubjectAccessReviewImpl)(nil)

func (w *wrapAuthorizationV1LocalSubjectAccessReviewImpl) Create(ctx context.Context, in *authorizationv1.LocalSubjectAccessReview, opts metav1.CreateOptions) (*authorizationv1.LocalSubjectAccessReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1",
		Kind:    "LocalSubjectAccessReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1.LocalSubjectAccessReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAuthorizationV1) SelfSubjectAccessReviews() typedauthorizationv1.SelfSubjectAccessReviewInterface {
	return &wrapAuthorizationV1SelfSubjectAccessReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1",
			Resource: "selfsubjectaccessreviews",
		}),
	}
}

type wrapAuthorizationV1SelfSubjectAccessReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthorizationv1.SelfSubjectAccessReviewInterface = (*wrapAuthorizationV1SelfSubjectAccessReviewImpl)(nil)

func (w *wrapAuthorizationV1SelfSubjectAccessReviewImpl) Create(ctx context.Context, in *authorizationv1.SelfSubjectAccessReview, opts metav1.CreateOptions) (*authorizationv1.SelfSubjectAccessReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1",
		Kind:    "SelfSubjectAccessReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1.SelfSubjectAccessReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAuthorizationV1) SelfSubjectRulesReviews() typedauthorizationv1.SelfSubjectRulesReviewInterface {
	return &wrapAuthorizationV1SelfSubjectRulesReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1",
			Resource: "selfsubjectrulesreviews",
		}),
	}
}

type wrapAuthorizationV1SelfSubjectRulesReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthorizationv1.SelfSubjectRulesReviewInterface = (*wrapAuthorizationV1SelfSubjectRulesReviewImpl)(nil)

func (w *wrapAuthorizationV1SelfSubjectRulesReviewImpl) Create(ctx context.Context, in *authorizationv1.SelfSubjectRulesReview, opts metav1.CreateOptions) (*authorizationv1.SelfSubjectRulesReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1",
		Kind:    "SelfSubjectRulesReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1.SelfSubjectRulesReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAuthorizationV1) SubjectAccessReviews() typedauthorizationv1.SubjectAccessReviewInterface {
	return &wrapAuthorizationV1SubjectAccessReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1",
			Resource: "subjectaccessreviews",
		}),
	}
}

type wrapAuthorizationV1SubjectAccessReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthorizationv1.SubjectAccessReviewInterface = (*wrapAuthorizationV1SubjectAccessReviewImpl)(nil)

func (w *wrapAuthorizationV1SubjectAccessReviewImpl) Create(ctx context.Context, in *authorizationv1.SubjectAccessReview, opts metav1.CreateOptions) (*authorizationv1.SubjectAccessReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1",
		Kind:    "SubjectAccessReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1.SubjectAccessReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

// AuthorizationV1beta1 retrieves the AuthorizationV1beta1Client
func (w *wrapClient) AuthorizationV1beta1() typedauthorizationv1beta1.AuthorizationV1beta1Interface {
	return &wrapAuthorizationV1beta1{
		dyn: w.dyn,
	}
}

type wrapAuthorizationV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapAuthorizationV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAuthorizationV1beta1) LocalSubjectAccessReviews(namespace string) typedauthorizationv1beta1.LocalSubjectAccessReviewInterface {
	return &wrapAuthorizationV1beta1LocalSubjectAccessReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "localsubjectaccessreviews",
		}),

		namespace: namespace,
	}
}

type wrapAuthorizationV1beta1LocalSubjectAccessReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedauthorizationv1beta1.LocalSubjectAccessReviewInterface = (*wrapAuthorizationV1beta1LocalSubjectAccessReviewImpl)(nil)

func (w *wrapAuthorizationV1beta1LocalSubjectAccessReviewImpl) Create(ctx context.Context, in *authorizationv1beta1.LocalSubjectAccessReview, opts metav1.CreateOptions) (*authorizationv1beta1.LocalSubjectAccessReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "LocalSubjectAccessReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1beta1.LocalSubjectAccessReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAuthorizationV1beta1) SelfSubjectAccessReviews() typedauthorizationv1beta1.SelfSubjectAccessReviewInterface {
	return &wrapAuthorizationV1beta1SelfSubjectAccessReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "selfsubjectaccessreviews",
		}),
	}
}

type wrapAuthorizationV1beta1SelfSubjectAccessReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthorizationv1beta1.SelfSubjectAccessReviewInterface = (*wrapAuthorizationV1beta1SelfSubjectAccessReviewImpl)(nil)

func (w *wrapAuthorizationV1beta1SelfSubjectAccessReviewImpl) Create(ctx context.Context, in *authorizationv1beta1.SelfSubjectAccessReview, opts metav1.CreateOptions) (*authorizationv1beta1.SelfSubjectAccessReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "SelfSubjectAccessReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1beta1.SelfSubjectAccessReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAuthorizationV1beta1) SelfSubjectRulesReviews() typedauthorizationv1beta1.SelfSubjectRulesReviewInterface {
	return &wrapAuthorizationV1beta1SelfSubjectRulesReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "selfsubjectrulesreviews",
		}),
	}
}

type wrapAuthorizationV1beta1SelfSubjectRulesReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthorizationv1beta1.SelfSubjectRulesReviewInterface = (*wrapAuthorizationV1beta1SelfSubjectRulesReviewImpl)(nil)

func (w *wrapAuthorizationV1beta1SelfSubjectRulesReviewImpl) Create(ctx context.Context, in *authorizationv1beta1.SelfSubjectRulesReview, opts metav1.CreateOptions) (*authorizationv1beta1.SelfSubjectRulesReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "SelfSubjectRulesReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1beta1.SelfSubjectRulesReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAuthorizationV1beta1) SubjectAccessReviews() typedauthorizationv1beta1.SubjectAccessReviewInterface {
	return &wrapAuthorizationV1beta1SubjectAccessReviewImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "subjectaccessreviews",
		}),
	}
}

type wrapAuthorizationV1beta1SubjectAccessReviewImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedauthorizationv1beta1.SubjectAccessReviewInterface = (*wrapAuthorizationV1beta1SubjectAccessReviewImpl)(nil)

func (w *wrapAuthorizationV1beta1SubjectAccessReviewImpl) Create(ctx context.Context, in *authorizationv1beta1.SubjectAccessReview, opts metav1.CreateOptions) (*authorizationv1beta1.SubjectAccessReview, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "SubjectAccessReview",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &authorizationv1beta1.SubjectAccessReview{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

// AutoscalingV1 retrieves the AutoscalingV1Client
func (w *wrapClient) AutoscalingV1() typedautoscalingv1.AutoscalingV1Interface {
	return &wrapAutoscalingV1{
		dyn: w.dyn,
	}
}

type wrapAutoscalingV1 struct {
	dyn dynamic.Interface
}

func (w *wrapAutoscalingV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAutoscalingV1) HorizontalPodAutoscalers(namespace string) typedautoscalingv1.HorizontalPodAutoscalerInterface {
	return &wrapAutoscalingV1HorizontalPodAutoscalerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "autoscaling",
			Version:  "v1",
			Resource: "horizontalpodautoscalers",
		}),

		namespace: namespace,
	}
}

type wrapAutoscalingV1HorizontalPodAutoscalerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedautoscalingv1.HorizontalPodAutoscalerInterface = (*wrapAutoscalingV1HorizontalPodAutoscalerImpl)(nil)

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Apply(ctx context.Context, in *applyconfigurationsautoscalingv1.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv1.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) ApplyStatus(ctx context.Context, in *applyconfigurationsautoscalingv1.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv1.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Create(ctx context.Context, in *autoscalingv1.HorizontalPodAutoscaler, opts metav1.CreateOptions) (*autoscalingv1.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v1",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv1.HorizontalPodAutoscaler, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) List(ctx context.Context, opts metav1.ListOptions) (*autoscalingv1.HorizontalPodAutoscalerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv1.HorizontalPodAutoscalerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *autoscalingv1.HorizontalPodAutoscaler, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Update(ctx context.Context, in *autoscalingv1.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv1.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v1",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) UpdateStatus(ctx context.Context, in *autoscalingv1.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv1.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v1",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV1HorizontalPodAutoscalerImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// AutoscalingV2 retrieves the AutoscalingV2Client
func (w *wrapClient) AutoscalingV2() typedautoscalingv2.AutoscalingV2Interface {
	return &wrapAutoscalingV2{
		dyn: w.dyn,
	}
}

type wrapAutoscalingV2 struct {
	dyn dynamic.Interface
}

func (w *wrapAutoscalingV2) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAutoscalingV2) HorizontalPodAutoscalers(namespace string) typedautoscalingv2.HorizontalPodAutoscalerInterface {
	return &wrapAutoscalingV2HorizontalPodAutoscalerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "autoscaling",
			Version:  "v2",
			Resource: "horizontalpodautoscalers",
		}),

		namespace: namespace,
	}
}

type wrapAutoscalingV2HorizontalPodAutoscalerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedautoscalingv2.HorizontalPodAutoscalerInterface = (*wrapAutoscalingV2HorizontalPodAutoscalerImpl)(nil)

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Apply(ctx context.Context, in *v2.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv2.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) ApplyStatus(ctx context.Context, in *v2.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv2.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Create(ctx context.Context, in *autoscalingv2.HorizontalPodAutoscaler, opts metav1.CreateOptions) (*autoscalingv2.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv2.HorizontalPodAutoscaler, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) List(ctx context.Context, opts metav1.ListOptions) (*autoscalingv2.HorizontalPodAutoscalerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2.HorizontalPodAutoscalerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *autoscalingv2.HorizontalPodAutoscaler, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Update(ctx context.Context, in *autoscalingv2.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv2.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) UpdateStatus(ctx context.Context, in *autoscalingv2.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv2.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2HorizontalPodAutoscalerImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// AutoscalingV2beta1 retrieves the AutoscalingV2beta1Client
func (w *wrapClient) AutoscalingV2beta1() typedautoscalingv2beta1.AutoscalingV2beta1Interface {
	return &wrapAutoscalingV2beta1{
		dyn: w.dyn,
	}
}

type wrapAutoscalingV2beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapAutoscalingV2beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAutoscalingV2beta1) HorizontalPodAutoscalers(namespace string) typedautoscalingv2beta1.HorizontalPodAutoscalerInterface {
	return &wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "autoscaling",
			Version:  "v2beta1",
			Resource: "horizontalpodautoscalers",
		}),

		namespace: namespace,
	}
}

type wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedautoscalingv2beta1.HorizontalPodAutoscalerInterface = (*wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl)(nil)

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Apply(ctx context.Context, in *v2beta1.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv2beta1.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) ApplyStatus(ctx context.Context, in *v2beta1.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv2beta1.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Create(ctx context.Context, in *autoscalingv2beta1.HorizontalPodAutoscaler, opts metav1.CreateOptions) (*autoscalingv2beta1.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2beta1",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv2beta1.HorizontalPodAutoscaler, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) List(ctx context.Context, opts metav1.ListOptions) (*autoscalingv2beta1.HorizontalPodAutoscalerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta1.HorizontalPodAutoscalerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *autoscalingv2beta1.HorizontalPodAutoscaler, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Update(ctx context.Context, in *autoscalingv2beta1.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv2beta1.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2beta1",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) UpdateStatus(ctx context.Context, in *autoscalingv2beta1.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv2beta1.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2beta1",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta1.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta1HorizontalPodAutoscalerImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// AutoscalingV2beta2 retrieves the AutoscalingV2beta2Client
func (w *wrapClient) AutoscalingV2beta2() typedautoscalingv2beta2.AutoscalingV2beta2Interface {
	return &wrapAutoscalingV2beta2{
		dyn: w.dyn,
	}
}

type wrapAutoscalingV2beta2 struct {
	dyn dynamic.Interface
}

func (w *wrapAutoscalingV2beta2) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapAutoscalingV2beta2) HorizontalPodAutoscalers(namespace string) typedautoscalingv2beta2.HorizontalPodAutoscalerInterface {
	return &wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "autoscaling",
			Version:  "v2beta2",
			Resource: "horizontalpodautoscalers",
		}),

		namespace: namespace,
	}
}

type wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedautoscalingv2beta2.HorizontalPodAutoscalerInterface = (*wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl)(nil)

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Apply(ctx context.Context, in *v2beta2.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv2beta2.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) ApplyStatus(ctx context.Context, in *v2beta2.HorizontalPodAutoscalerApplyConfiguration, opts metav1.ApplyOptions) (result *autoscalingv2beta2.HorizontalPodAutoscaler, err error) {
	panic("NYI")
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Create(ctx context.Context, in *autoscalingv2beta2.HorizontalPodAutoscaler, opts metav1.CreateOptions) (*autoscalingv2beta2.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2beta2",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv2beta2.HorizontalPodAutoscaler, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) List(ctx context.Context, opts metav1.ListOptions) (*autoscalingv2beta2.HorizontalPodAutoscalerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta2.HorizontalPodAutoscalerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *autoscalingv2beta2.HorizontalPodAutoscaler, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Update(ctx context.Context, in *autoscalingv2beta2.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv2beta2.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2beta2",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) UpdateStatus(ctx context.Context, in *autoscalingv2beta2.HorizontalPodAutoscaler, opts metav1.UpdateOptions) (*autoscalingv2beta2.HorizontalPodAutoscaler, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "autoscaling",
		Version: "v2beta2",
		Kind:    "HorizontalPodAutoscaler",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &autoscalingv2beta2.HorizontalPodAutoscaler{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapAutoscalingV2beta2HorizontalPodAutoscalerImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// BatchV1 retrieves the BatchV1Client
func (w *wrapClient) BatchV1() typedbatchv1.BatchV1Interface {
	return &wrapBatchV1{
		dyn: w.dyn,
	}
}

type wrapBatchV1 struct {
	dyn dynamic.Interface
}

func (w *wrapBatchV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapBatchV1) CronJobs(namespace string) typedbatchv1.CronJobInterface {
	return &wrapBatchV1CronJobImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "batch",
			Version:  "v1",
			Resource: "cronjobs",
		}),

		namespace: namespace,
	}
}

type wrapBatchV1CronJobImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedbatchv1.CronJobInterface = (*wrapBatchV1CronJobImpl)(nil)

func (w *wrapBatchV1CronJobImpl) Apply(ctx context.Context, in *batchv1.CronJobApplyConfiguration, opts metav1.ApplyOptions) (result *apibatchv1.CronJob, err error) {
	panic("NYI")
}

func (w *wrapBatchV1CronJobImpl) ApplyStatus(ctx context.Context, in *batchv1.CronJobApplyConfiguration, opts metav1.ApplyOptions) (result *apibatchv1.CronJob, err error) {
	panic("NYI")
}

func (w *wrapBatchV1CronJobImpl) Create(ctx context.Context, in *apibatchv1.CronJob, opts metav1.CreateOptions) (*apibatchv1.CronJob, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1",
		Kind:    "CronJob",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1CronJobImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapBatchV1CronJobImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapBatchV1CronJobImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apibatchv1.CronJob, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1CronJobImpl) List(ctx context.Context, opts metav1.ListOptions) (*apibatchv1.CronJobList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.CronJobList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1CronJobImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apibatchv1.CronJob, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1CronJobImpl) Update(ctx context.Context, in *apibatchv1.CronJob, opts metav1.UpdateOptions) (*apibatchv1.CronJob, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1",
		Kind:    "CronJob",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1CronJobImpl) UpdateStatus(ctx context.Context, in *apibatchv1.CronJob, opts metav1.UpdateOptions) (*apibatchv1.CronJob, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1",
		Kind:    "CronJob",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1CronJobImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapBatchV1) Jobs(namespace string) typedbatchv1.JobInterface {
	return &wrapBatchV1JobImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "batch",
			Version:  "v1",
			Resource: "jobs",
		}),

		namespace: namespace,
	}
}

type wrapBatchV1JobImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedbatchv1.JobInterface = (*wrapBatchV1JobImpl)(nil)

func (w *wrapBatchV1JobImpl) Apply(ctx context.Context, in *batchv1.JobApplyConfiguration, opts metav1.ApplyOptions) (result *apibatchv1.Job, err error) {
	panic("NYI")
}

func (w *wrapBatchV1JobImpl) ApplyStatus(ctx context.Context, in *batchv1.JobApplyConfiguration, opts metav1.ApplyOptions) (result *apibatchv1.Job, err error) {
	panic("NYI")
}

func (w *wrapBatchV1JobImpl) Create(ctx context.Context, in *apibatchv1.Job, opts metav1.CreateOptions) (*apibatchv1.Job, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1",
		Kind:    "Job",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.Job{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1JobImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapBatchV1JobImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapBatchV1JobImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apibatchv1.Job, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.Job{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1JobImpl) List(ctx context.Context, opts metav1.ListOptions) (*apibatchv1.JobList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.JobList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1JobImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apibatchv1.Job, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.Job{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1JobImpl) Update(ctx context.Context, in *apibatchv1.Job, opts metav1.UpdateOptions) (*apibatchv1.Job, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1",
		Kind:    "Job",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.Job{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1JobImpl) UpdateStatus(ctx context.Context, in *apibatchv1.Job, opts metav1.UpdateOptions) (*apibatchv1.Job, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1",
		Kind:    "Job",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1.Job{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1JobImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// BatchV1beta1 retrieves the BatchV1beta1Client
func (w *wrapClient) BatchV1beta1() typedbatchv1beta1.BatchV1beta1Interface {
	return &wrapBatchV1beta1{
		dyn: w.dyn,
	}
}

type wrapBatchV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapBatchV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapBatchV1beta1) CronJobs(namespace string) typedbatchv1beta1.CronJobInterface {
	return &wrapBatchV1beta1CronJobImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "batch",
			Version:  "v1beta1",
			Resource: "cronjobs",
		}),

		namespace: namespace,
	}
}

type wrapBatchV1beta1CronJobImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedbatchv1beta1.CronJobInterface = (*wrapBatchV1beta1CronJobImpl)(nil)

func (w *wrapBatchV1beta1CronJobImpl) Apply(ctx context.Context, in *batchv1beta1.CronJobApplyConfiguration, opts metav1.ApplyOptions) (result *apibatchv1beta1.CronJob, err error) {
	panic("NYI")
}

func (w *wrapBatchV1beta1CronJobImpl) ApplyStatus(ctx context.Context, in *batchv1beta1.CronJobApplyConfiguration, opts metav1.ApplyOptions) (result *apibatchv1beta1.CronJob, err error) {
	panic("NYI")
}

func (w *wrapBatchV1beta1CronJobImpl) Create(ctx context.Context, in *apibatchv1beta1.CronJob, opts metav1.CreateOptions) (*apibatchv1beta1.CronJob, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1beta1",
		Kind:    "CronJob",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1beta1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1beta1CronJobImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapBatchV1beta1CronJobImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapBatchV1beta1CronJobImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apibatchv1beta1.CronJob, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1beta1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1beta1CronJobImpl) List(ctx context.Context, opts metav1.ListOptions) (*apibatchv1beta1.CronJobList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1beta1.CronJobList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1beta1CronJobImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apibatchv1beta1.CronJob, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1beta1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1beta1CronJobImpl) Update(ctx context.Context, in *apibatchv1beta1.CronJob, opts metav1.UpdateOptions) (*apibatchv1beta1.CronJob, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1beta1",
		Kind:    "CronJob",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1beta1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1beta1CronJobImpl) UpdateStatus(ctx context.Context, in *apibatchv1beta1.CronJob, opts metav1.UpdateOptions) (*apibatchv1beta1.CronJob, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "batch",
		Version: "v1beta1",
		Kind:    "CronJob",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apibatchv1beta1.CronJob{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapBatchV1beta1CronJobImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// CertificatesV1 retrieves the CertificatesV1Client
func (w *wrapClient) CertificatesV1() typedcertificatesv1.CertificatesV1Interface {
	return &wrapCertificatesV1{
		dyn: w.dyn,
	}
}

type wrapCertificatesV1 struct {
	dyn dynamic.Interface
}

func (w *wrapCertificatesV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapCertificatesV1) CertificateSigningRequests() typedcertificatesv1.CertificateSigningRequestInterface {
	return &wrapCertificatesV1CertificateSigningRequestImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "certificates.k8s.io",
			Version:  "v1",
			Resource: "certificatesigningrequests",
		}),
	}
}

type wrapCertificatesV1CertificateSigningRequestImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedcertificatesv1.CertificateSigningRequestInterface = (*wrapCertificatesV1CertificateSigningRequestImpl)(nil)

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Apply(ctx context.Context, in *certificatesv1.CertificateSigningRequestApplyConfiguration, opts metav1.ApplyOptions) (result *apicertificatesv1.CertificateSigningRequest, err error) {
	panic("NYI")
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) ApplyStatus(ctx context.Context, in *certificatesv1.CertificateSigningRequestApplyConfiguration, opts metav1.ApplyOptions) (result *apicertificatesv1.CertificateSigningRequest, err error) {
	panic("NYI")
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Create(ctx context.Context, in *apicertificatesv1.CertificateSigningRequest, opts metav1.CreateOptions) (*apicertificatesv1.CertificateSigningRequest, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "certificates.k8s.io",
		Version: "v1",
		Kind:    "CertificateSigningRequest",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicertificatesv1.CertificateSigningRequest, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicertificatesv1.CertificateSigningRequestList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1.CertificateSigningRequestList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicertificatesv1.CertificateSigningRequest, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Update(ctx context.Context, in *apicertificatesv1.CertificateSigningRequest, opts metav1.UpdateOptions) (*apicertificatesv1.CertificateSigningRequest, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "certificates.k8s.io",
		Version: "v1",
		Kind:    "CertificateSigningRequest",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) UpdateStatus(ctx context.Context, in *apicertificatesv1.CertificateSigningRequest, opts metav1.UpdateOptions) (*apicertificatesv1.CertificateSigningRequest, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "certificates.k8s.io",
		Version: "v1",
		Kind:    "CertificateSigningRequest",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCertificatesV1CertificateSigningRequestImpl) UpdateApproval(ctx context.Context, _ string, in *apicertificatesv1.CertificateSigningRequest, opts metav1.UpdateOptions) (*apicertificatesv1.CertificateSigningRequest, error) {
	panic("NYI")
}

// CertificatesV1beta1 retrieves the CertificatesV1beta1Client
func (w *wrapClient) CertificatesV1beta1() typedcertificatesv1beta1.CertificatesV1beta1Interface {
	return &wrapCertificatesV1beta1{
		dyn: w.dyn,
	}
}

type wrapCertificatesV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapCertificatesV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapCertificatesV1beta1) CertificateSigningRequests() typedcertificatesv1beta1.CertificateSigningRequestInterface {
	return &wrapCertificatesV1beta1CertificateSigningRequestImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "certificates.k8s.io",
			Version:  "v1beta1",
			Resource: "certificatesigningrequests",
		}),
	}
}

type wrapCertificatesV1beta1CertificateSigningRequestImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedcertificatesv1beta1.CertificateSigningRequestInterface = (*wrapCertificatesV1beta1CertificateSigningRequestImpl)(nil)

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Apply(ctx context.Context, in *certificatesv1beta1.CertificateSigningRequestApplyConfiguration, opts metav1.ApplyOptions) (result *apicertificatesv1beta1.CertificateSigningRequest, err error) {
	panic("NYI")
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) ApplyStatus(ctx context.Context, in *certificatesv1beta1.CertificateSigningRequestApplyConfiguration, opts metav1.ApplyOptions) (result *apicertificatesv1beta1.CertificateSigningRequest, err error) {
	panic("NYI")
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Create(ctx context.Context, in *apicertificatesv1beta1.CertificateSigningRequest, opts metav1.CreateOptions) (*apicertificatesv1beta1.CertificateSigningRequest, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "certificates.k8s.io",
		Version: "v1beta1",
		Kind:    "CertificateSigningRequest",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1beta1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicertificatesv1beta1.CertificateSigningRequest, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1beta1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicertificatesv1beta1.CertificateSigningRequestList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1beta1.CertificateSigningRequestList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicertificatesv1beta1.CertificateSigningRequest, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1beta1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Update(ctx context.Context, in *apicertificatesv1beta1.CertificateSigningRequest, opts metav1.UpdateOptions) (*apicertificatesv1beta1.CertificateSigningRequest, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "certificates.k8s.io",
		Version: "v1beta1",
		Kind:    "CertificateSigningRequest",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1beta1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) UpdateStatus(ctx context.Context, in *apicertificatesv1beta1.CertificateSigningRequest, opts metav1.UpdateOptions) (*apicertificatesv1beta1.CertificateSigningRequest, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "certificates.k8s.io",
		Version: "v1beta1",
		Kind:    "CertificateSigningRequest",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicertificatesv1beta1.CertificateSigningRequest{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCertificatesV1beta1CertificateSigningRequestImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// CoordinationV1 retrieves the CoordinationV1Client
func (w *wrapClient) CoordinationV1() typedcoordinationv1.CoordinationV1Interface {
	return &wrapCoordinationV1{
		dyn: w.dyn,
	}
}

type wrapCoordinationV1 struct {
	dyn dynamic.Interface
}

func (w *wrapCoordinationV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapCoordinationV1) Leases(namespace string) typedcoordinationv1.LeaseInterface {
	return &wrapCoordinationV1LeaseImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "coordination.k8s.io",
			Version:  "v1",
			Resource: "leases",
		}),

		namespace: namespace,
	}
}

type wrapCoordinationV1LeaseImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcoordinationv1.LeaseInterface = (*wrapCoordinationV1LeaseImpl)(nil)

func (w *wrapCoordinationV1LeaseImpl) Apply(ctx context.Context, in *coordinationv1.LeaseApplyConfiguration, opts metav1.ApplyOptions) (result *apicoordinationv1.Lease, err error) {
	panic("NYI")
}

func (w *wrapCoordinationV1LeaseImpl) ApplyStatus(ctx context.Context, in *coordinationv1.LeaseApplyConfiguration, opts metav1.ApplyOptions) (result *apicoordinationv1.Lease, err error) {
	panic("NYI")
}

func (w *wrapCoordinationV1LeaseImpl) Create(ctx context.Context, in *apicoordinationv1.Lease, opts metav1.CreateOptions) (*apicoordinationv1.Lease, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "coordination.k8s.io",
		Version: "v1",
		Kind:    "Lease",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1LeaseImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoordinationV1LeaseImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoordinationV1LeaseImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicoordinationv1.Lease, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1LeaseImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicoordinationv1.LeaseList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1.LeaseList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1LeaseImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicoordinationv1.Lease, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1LeaseImpl) Update(ctx context.Context, in *apicoordinationv1.Lease, opts metav1.UpdateOptions) (*apicoordinationv1.Lease, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "coordination.k8s.io",
		Version: "v1",
		Kind:    "Lease",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1LeaseImpl) UpdateStatus(ctx context.Context, in *apicoordinationv1.Lease, opts metav1.UpdateOptions) (*apicoordinationv1.Lease, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "coordination.k8s.io",
		Version: "v1",
		Kind:    "Lease",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1LeaseImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// CoordinationV1beta1 retrieves the CoordinationV1beta1Client
func (w *wrapClient) CoordinationV1beta1() typedcoordinationv1beta1.CoordinationV1beta1Interface {
	return &wrapCoordinationV1beta1{
		dyn: w.dyn,
	}
}

type wrapCoordinationV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapCoordinationV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapCoordinationV1beta1) Leases(namespace string) typedcoordinationv1beta1.LeaseInterface {
	return &wrapCoordinationV1beta1LeaseImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "coordination.k8s.io",
			Version:  "v1beta1",
			Resource: "leases",
		}),

		namespace: namespace,
	}
}

type wrapCoordinationV1beta1LeaseImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcoordinationv1beta1.LeaseInterface = (*wrapCoordinationV1beta1LeaseImpl)(nil)

func (w *wrapCoordinationV1beta1LeaseImpl) Apply(ctx context.Context, in *coordinationv1beta1.LeaseApplyConfiguration, opts metav1.ApplyOptions) (result *apicoordinationv1beta1.Lease, err error) {
	panic("NYI")
}

func (w *wrapCoordinationV1beta1LeaseImpl) ApplyStatus(ctx context.Context, in *coordinationv1beta1.LeaseApplyConfiguration, opts metav1.ApplyOptions) (result *apicoordinationv1beta1.Lease, err error) {
	panic("NYI")
}

func (w *wrapCoordinationV1beta1LeaseImpl) Create(ctx context.Context, in *apicoordinationv1beta1.Lease, opts metav1.CreateOptions) (*apicoordinationv1beta1.Lease, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "coordination.k8s.io",
		Version: "v1beta1",
		Kind:    "Lease",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1beta1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1beta1LeaseImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoordinationV1beta1LeaseImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoordinationV1beta1LeaseImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicoordinationv1beta1.Lease, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1beta1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1beta1LeaseImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicoordinationv1beta1.LeaseList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1beta1.LeaseList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1beta1LeaseImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicoordinationv1beta1.Lease, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1beta1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1beta1LeaseImpl) Update(ctx context.Context, in *apicoordinationv1beta1.Lease, opts metav1.UpdateOptions) (*apicoordinationv1beta1.Lease, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "coordination.k8s.io",
		Version: "v1beta1",
		Kind:    "Lease",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1beta1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1beta1LeaseImpl) UpdateStatus(ctx context.Context, in *apicoordinationv1beta1.Lease, opts metav1.UpdateOptions) (*apicoordinationv1beta1.Lease, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "coordination.k8s.io",
		Version: "v1beta1",
		Kind:    "Lease",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicoordinationv1beta1.Lease{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoordinationV1beta1LeaseImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// CoreV1 retrieves the CoreV1Client
func (w *wrapClient) CoreV1() typedcorev1.CoreV1Interface {
	return &wrapCoreV1{
		dyn: w.dyn,
	}
}

type wrapCoreV1 struct {
	dyn dynamic.Interface
}

func (w *wrapCoreV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapCoreV1) ComponentStatuses() typedcorev1.ComponentStatusInterface {
	return &wrapCoreV1ComponentStatusImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "componentstatuses",
		}),
	}
}

type wrapCoreV1ComponentStatusImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedcorev1.ComponentStatusInterface = (*wrapCoreV1ComponentStatusImpl)(nil)

func (w *wrapCoreV1ComponentStatusImpl) Apply(ctx context.Context, in *corev1.ComponentStatusApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ComponentStatus, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ComponentStatusImpl) ApplyStatus(ctx context.Context, in *corev1.ComponentStatusApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ComponentStatus, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ComponentStatusImpl) Create(ctx context.Context, in *apicorev1.ComponentStatus, opts metav1.CreateOptions) (*apicorev1.ComponentStatus, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ComponentStatus",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ComponentStatus{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ComponentStatusImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapCoreV1ComponentStatusImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1ComponentStatusImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.ComponentStatus, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ComponentStatus{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ComponentStatusImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.ComponentStatusList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ComponentStatusList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ComponentStatusImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.ComponentStatus, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ComponentStatus{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ComponentStatusImpl) Update(ctx context.Context, in *apicorev1.ComponentStatus, opts metav1.UpdateOptions) (*apicorev1.ComponentStatus, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ComponentStatus",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ComponentStatus{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ComponentStatusImpl) UpdateStatus(ctx context.Context, in *apicorev1.ComponentStatus, opts metav1.UpdateOptions) (*apicorev1.ComponentStatus, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ComponentStatus",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ComponentStatus{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ComponentStatusImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) ConfigMaps(namespace string) typedcorev1.ConfigMapInterface {
	return &wrapCoreV1ConfigMapImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "configmaps",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1ConfigMapImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.ConfigMapInterface = (*wrapCoreV1ConfigMapImpl)(nil)

func (w *wrapCoreV1ConfigMapImpl) Apply(ctx context.Context, in *corev1.ConfigMapApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ConfigMap, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ConfigMapImpl) ApplyStatus(ctx context.Context, in *corev1.ConfigMapApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ConfigMap, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ConfigMapImpl) Create(ctx context.Context, in *apicorev1.ConfigMap, opts metav1.CreateOptions) (*apicorev1.ConfigMap, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ConfigMap",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ConfigMap{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ConfigMapImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1ConfigMapImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1ConfigMapImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.ConfigMap, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ConfigMap{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ConfigMapImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.ConfigMapList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ConfigMapList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ConfigMapImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.ConfigMap, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ConfigMap{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ConfigMapImpl) Update(ctx context.Context, in *apicorev1.ConfigMap, opts metav1.UpdateOptions) (*apicorev1.ConfigMap, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ConfigMap",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ConfigMap{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ConfigMapImpl) UpdateStatus(ctx context.Context, in *apicorev1.ConfigMap, opts metav1.UpdateOptions) (*apicorev1.ConfigMap, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ConfigMap",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ConfigMap{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ConfigMapImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Endpoints(namespace string) typedcorev1.EndpointsInterface {
	return &wrapCoreV1EndpointsImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "endpoints",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1EndpointsImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.EndpointsInterface = (*wrapCoreV1EndpointsImpl)(nil)

func (w *wrapCoreV1EndpointsImpl) Apply(ctx context.Context, in *corev1.EndpointsApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Endpoints, err error) {
	panic("NYI")
}

func (w *wrapCoreV1EndpointsImpl) ApplyStatus(ctx context.Context, in *corev1.EndpointsApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Endpoints, err error) {
	panic("NYI")
}

func (w *wrapCoreV1EndpointsImpl) Create(ctx context.Context, in *apicorev1.Endpoints, opts metav1.CreateOptions) (*apicorev1.Endpoints, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Endpoints",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Endpoints{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EndpointsImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1EndpointsImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1EndpointsImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Endpoints, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Endpoints{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EndpointsImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.EndpointsList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.EndpointsList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EndpointsImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Endpoints, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Endpoints{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EndpointsImpl) Update(ctx context.Context, in *apicorev1.Endpoints, opts metav1.UpdateOptions) (*apicorev1.Endpoints, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Endpoints",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Endpoints{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EndpointsImpl) UpdateStatus(ctx context.Context, in *apicorev1.Endpoints, opts metav1.UpdateOptions) (*apicorev1.Endpoints, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Endpoints",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Endpoints{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EndpointsImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Events(namespace string) typedcorev1.EventInterface {
	return &wrapCoreV1EventImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "events",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1EventImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.EventInterface = (*wrapCoreV1EventImpl)(nil)

func (w *wrapCoreV1EventImpl) Apply(ctx context.Context, in *corev1.EventApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Event, err error) {
	panic("NYI")
}

func (w *wrapCoreV1EventImpl) ApplyStatus(ctx context.Context, in *corev1.EventApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Event, err error) {
	panic("NYI")
}

func (w *wrapCoreV1EventImpl) Create(ctx context.Context, in *apicorev1.Event, opts metav1.CreateOptions) (*apicorev1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EventImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1EventImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1EventImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Event, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EventImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.EventList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.EventList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EventImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Event, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EventImpl) Update(ctx context.Context, in *apicorev1.Event, opts metav1.UpdateOptions) (*apicorev1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EventImpl) UpdateStatus(ctx context.Context, in *apicorev1.Event, opts metav1.UpdateOptions) (*apicorev1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1EventImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) LimitRanges(namespace string) typedcorev1.LimitRangeInterface {
	return &wrapCoreV1LimitRangeImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "limitranges",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1LimitRangeImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.LimitRangeInterface = (*wrapCoreV1LimitRangeImpl)(nil)

func (w *wrapCoreV1LimitRangeImpl) Apply(ctx context.Context, in *corev1.LimitRangeApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.LimitRange, err error) {
	panic("NYI")
}

func (w *wrapCoreV1LimitRangeImpl) ApplyStatus(ctx context.Context, in *corev1.LimitRangeApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.LimitRange, err error) {
	panic("NYI")
}

func (w *wrapCoreV1LimitRangeImpl) Create(ctx context.Context, in *apicorev1.LimitRange, opts metav1.CreateOptions) (*apicorev1.LimitRange, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "LimitRange",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.LimitRange{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1LimitRangeImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1LimitRangeImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1LimitRangeImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.LimitRange, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.LimitRange{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1LimitRangeImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.LimitRangeList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.LimitRangeList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1LimitRangeImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.LimitRange, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.LimitRange{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1LimitRangeImpl) Update(ctx context.Context, in *apicorev1.LimitRange, opts metav1.UpdateOptions) (*apicorev1.LimitRange, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "LimitRange",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.LimitRange{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1LimitRangeImpl) UpdateStatus(ctx context.Context, in *apicorev1.LimitRange, opts metav1.UpdateOptions) (*apicorev1.LimitRange, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "LimitRange",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.LimitRange{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1LimitRangeImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Namespaces() typedcorev1.NamespaceInterface {
	return &wrapCoreV1NamespaceImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "namespaces",
		}),
	}
}

type wrapCoreV1NamespaceImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedcorev1.NamespaceInterface = (*wrapCoreV1NamespaceImpl)(nil)

func (w *wrapCoreV1NamespaceImpl) Apply(ctx context.Context, in *corev1.NamespaceApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Namespace, err error) {
	panic("NYI")
}

func (w *wrapCoreV1NamespaceImpl) ApplyStatus(ctx context.Context, in *corev1.NamespaceApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Namespace, err error) {
	panic("NYI")
}

func (w *wrapCoreV1NamespaceImpl) Create(ctx context.Context, in *apicorev1.Namespace, opts metav1.CreateOptions) (*apicorev1.Namespace, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Namespace",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Namespace{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NamespaceImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapCoreV1NamespaceImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Namespace, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Namespace{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NamespaceImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.NamespaceList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.NamespaceList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NamespaceImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Namespace, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Namespace{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NamespaceImpl) Update(ctx context.Context, in *apicorev1.Namespace, opts metav1.UpdateOptions) (*apicorev1.Namespace, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Namespace",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Namespace{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NamespaceImpl) UpdateStatus(ctx context.Context, in *apicorev1.Namespace, opts metav1.UpdateOptions) (*apicorev1.Namespace, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Namespace",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Namespace{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NamespaceImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Nodes() typedcorev1.NodeInterface {
	return &wrapCoreV1NodeImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "nodes",
		}),
	}
}

type wrapCoreV1NodeImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedcorev1.NodeInterface = (*wrapCoreV1NodeImpl)(nil)

func (w *wrapCoreV1NodeImpl) Apply(ctx context.Context, in *corev1.NodeApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Node, err error) {
	panic("NYI")
}

func (w *wrapCoreV1NodeImpl) ApplyStatus(ctx context.Context, in *corev1.NodeApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Node, err error) {
	panic("NYI")
}

func (w *wrapCoreV1NodeImpl) Create(ctx context.Context, in *apicorev1.Node, opts metav1.CreateOptions) (*apicorev1.Node, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Node",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Node{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NodeImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapCoreV1NodeImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1NodeImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Node, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Node{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NodeImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.NodeList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.NodeList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NodeImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Node, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Node{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NodeImpl) Update(ctx context.Context, in *apicorev1.Node, opts metav1.UpdateOptions) (*apicorev1.Node, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Node",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Node{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NodeImpl) UpdateStatus(ctx context.Context, in *apicorev1.Node, opts metav1.UpdateOptions) (*apicorev1.Node, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Node",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Node{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1NodeImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) PersistentVolumes() typedcorev1.PersistentVolumeInterface {
	return &wrapCoreV1PersistentVolumeImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "persistentvolumes",
		}),
	}
}

type wrapCoreV1PersistentVolumeImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedcorev1.PersistentVolumeInterface = (*wrapCoreV1PersistentVolumeImpl)(nil)

func (w *wrapCoreV1PersistentVolumeImpl) Apply(ctx context.Context, in *corev1.PersistentVolumeApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.PersistentVolume, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PersistentVolumeImpl) ApplyStatus(ctx context.Context, in *corev1.PersistentVolumeApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.PersistentVolume, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PersistentVolumeImpl) Create(ctx context.Context, in *apicorev1.PersistentVolume, opts metav1.CreateOptions) (*apicorev1.PersistentVolume, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PersistentVolume",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolume{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapCoreV1PersistentVolumeImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1PersistentVolumeImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.PersistentVolume, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolume{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.PersistentVolumeList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.PersistentVolume, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolume{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeImpl) Update(ctx context.Context, in *apicorev1.PersistentVolume, opts metav1.UpdateOptions) (*apicorev1.PersistentVolume, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PersistentVolume",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolume{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeImpl) UpdateStatus(ctx context.Context, in *apicorev1.PersistentVolume, opts metav1.UpdateOptions) (*apicorev1.PersistentVolume, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PersistentVolume",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolume{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) PersistentVolumeClaims(namespace string) typedcorev1.PersistentVolumeClaimInterface {
	return &wrapCoreV1PersistentVolumeClaimImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "persistentvolumeclaims",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1PersistentVolumeClaimImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.PersistentVolumeClaimInterface = (*wrapCoreV1PersistentVolumeClaimImpl)(nil)

func (w *wrapCoreV1PersistentVolumeClaimImpl) Apply(ctx context.Context, in *corev1.PersistentVolumeClaimApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.PersistentVolumeClaim, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) ApplyStatus(ctx context.Context, in *corev1.PersistentVolumeClaimApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.PersistentVolumeClaim, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) Create(ctx context.Context, in *apicorev1.PersistentVolumeClaim, opts metav1.CreateOptions) (*apicorev1.PersistentVolumeClaim, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PersistentVolumeClaim",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeClaim{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.PersistentVolumeClaim, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeClaim{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.PersistentVolumeClaimList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeClaimList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.PersistentVolumeClaim, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeClaim{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) Update(ctx context.Context, in *apicorev1.PersistentVolumeClaim, opts metav1.UpdateOptions) (*apicorev1.PersistentVolumeClaim, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PersistentVolumeClaim",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeClaim{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) UpdateStatus(ctx context.Context, in *apicorev1.PersistentVolumeClaim, opts metav1.UpdateOptions) (*apicorev1.PersistentVolumeClaim, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PersistentVolumeClaim",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PersistentVolumeClaim{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PersistentVolumeClaimImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Pods(namespace string) typedcorev1.PodInterface {
	return &wrapCoreV1PodImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "pods",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1PodImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.PodInterface = (*wrapCoreV1PodImpl)(nil)

func (w *wrapCoreV1PodImpl) Apply(ctx context.Context, in *corev1.PodApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Pod, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PodImpl) ApplyStatus(ctx context.Context, in *corev1.PodApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Pod, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PodImpl) Create(ctx context.Context, in *apicorev1.Pod, opts metav1.CreateOptions) (*apicorev1.Pod, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Pod",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Pod{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1PodImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1PodImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Pod, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Pod{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.PodList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Pod, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Pod{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodImpl) Update(ctx context.Context, in *apicorev1.Pod, opts metav1.UpdateOptions) (*apicorev1.Pod, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Pod",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Pod{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodImpl) UpdateStatus(ctx context.Context, in *apicorev1.Pod, opts metav1.UpdateOptions) (*apicorev1.Pod, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Pod",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Pod{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1PodImpl) UpdateEphemeralContainers(ctx context.Context, _ string, in *apicorev1.Pod, opts metav1.UpdateOptions) (*apicorev1.Pod, error) {
	panic("NYI")
}

func (w *wrapCoreV1) PodTemplates(namespace string) typedcorev1.PodTemplateInterface {
	return &wrapCoreV1PodTemplateImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "podtemplates",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1PodTemplateImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.PodTemplateInterface = (*wrapCoreV1PodTemplateImpl)(nil)

func (w *wrapCoreV1PodTemplateImpl) Apply(ctx context.Context, in *corev1.PodTemplateApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.PodTemplate, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PodTemplateImpl) ApplyStatus(ctx context.Context, in *corev1.PodTemplateApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.PodTemplate, err error) {
	panic("NYI")
}

func (w *wrapCoreV1PodTemplateImpl) Create(ctx context.Context, in *apicorev1.PodTemplate, opts metav1.CreateOptions) (*apicorev1.PodTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PodTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodTemplateImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1PodTemplateImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1PodTemplateImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.PodTemplate, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodTemplateImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.PodTemplateList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodTemplateList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodTemplateImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.PodTemplate, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodTemplateImpl) Update(ctx context.Context, in *apicorev1.PodTemplate, opts metav1.UpdateOptions) (*apicorev1.PodTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PodTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodTemplateImpl) UpdateStatus(ctx context.Context, in *apicorev1.PodTemplate, opts metav1.UpdateOptions) (*apicorev1.PodTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "PodTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.PodTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1PodTemplateImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) ReplicationControllers(namespace string) typedcorev1.ReplicationControllerInterface {
	return &wrapCoreV1ReplicationControllerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "replicationcontrollers",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1ReplicationControllerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.ReplicationControllerInterface = (*wrapCoreV1ReplicationControllerImpl)(nil)

func (w *wrapCoreV1ReplicationControllerImpl) Apply(ctx context.Context, in *corev1.ReplicationControllerApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ReplicationController, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ReplicationControllerImpl) ApplyStatus(ctx context.Context, in *corev1.ReplicationControllerApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ReplicationController, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ReplicationControllerImpl) Create(ctx context.Context, in *apicorev1.ReplicationController, opts metav1.CreateOptions) (*apicorev1.ReplicationController, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ReplicationController",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ReplicationController{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ReplicationControllerImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1ReplicationControllerImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1ReplicationControllerImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.ReplicationController, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ReplicationController{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ReplicationControllerImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.ReplicationControllerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ReplicationControllerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ReplicationControllerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.ReplicationController, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ReplicationController{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ReplicationControllerImpl) Update(ctx context.Context, in *apicorev1.ReplicationController, opts metav1.UpdateOptions) (*apicorev1.ReplicationController, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ReplicationController",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ReplicationController{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ReplicationControllerImpl) UpdateStatus(ctx context.Context, in *apicorev1.ReplicationController, opts metav1.UpdateOptions) (*apicorev1.ReplicationController, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ReplicationController",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ReplicationController{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ReplicationControllerImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1ReplicationControllerImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapCoreV1ReplicationControllerImpl) UpdateScale(ctx context.Context, _ string, in *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error) {
	panic("NYI")
}

func (w *wrapCoreV1) ResourceQuotas(namespace string) typedcorev1.ResourceQuotaInterface {
	return &wrapCoreV1ResourceQuotaImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "resourcequotas",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1ResourceQuotaImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.ResourceQuotaInterface = (*wrapCoreV1ResourceQuotaImpl)(nil)

func (w *wrapCoreV1ResourceQuotaImpl) Apply(ctx context.Context, in *corev1.ResourceQuotaApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ResourceQuota, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ResourceQuotaImpl) ApplyStatus(ctx context.Context, in *corev1.ResourceQuotaApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ResourceQuota, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ResourceQuotaImpl) Create(ctx context.Context, in *apicorev1.ResourceQuota, opts metav1.CreateOptions) (*apicorev1.ResourceQuota, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ResourceQuota",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ResourceQuota{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ResourceQuotaImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1ResourceQuotaImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1ResourceQuotaImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.ResourceQuota, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ResourceQuota{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ResourceQuotaImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.ResourceQuotaList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ResourceQuotaList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ResourceQuotaImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.ResourceQuota, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ResourceQuota{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ResourceQuotaImpl) Update(ctx context.Context, in *apicorev1.ResourceQuota, opts metav1.UpdateOptions) (*apicorev1.ResourceQuota, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ResourceQuota",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ResourceQuota{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ResourceQuotaImpl) UpdateStatus(ctx context.Context, in *apicorev1.ResourceQuota, opts metav1.UpdateOptions) (*apicorev1.ResourceQuota, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ResourceQuota",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ResourceQuota{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ResourceQuotaImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Secrets(namespace string) typedcorev1.SecretInterface {
	return &wrapCoreV1SecretImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "secrets",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1SecretImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.SecretInterface = (*wrapCoreV1SecretImpl)(nil)

func (w *wrapCoreV1SecretImpl) Apply(ctx context.Context, in *corev1.SecretApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Secret, err error) {
	panic("NYI")
}

func (w *wrapCoreV1SecretImpl) ApplyStatus(ctx context.Context, in *corev1.SecretApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Secret, err error) {
	panic("NYI")
}

func (w *wrapCoreV1SecretImpl) Create(ctx context.Context, in *apicorev1.Secret, opts metav1.CreateOptions) (*apicorev1.Secret, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Secret",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Secret{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1SecretImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1SecretImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1SecretImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Secret, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Secret{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1SecretImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.SecretList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.SecretList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1SecretImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Secret, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Secret{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1SecretImpl) Update(ctx context.Context, in *apicorev1.Secret, opts metav1.UpdateOptions) (*apicorev1.Secret, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Secret",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Secret{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1SecretImpl) UpdateStatus(ctx context.Context, in *apicorev1.Secret, opts metav1.UpdateOptions) (*apicorev1.Secret, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Secret",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Secret{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1SecretImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) Services(namespace string) typedcorev1.ServiceInterface {
	return &wrapCoreV1ServiceImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "services",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1ServiceImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.ServiceInterface = (*wrapCoreV1ServiceImpl)(nil)

func (w *wrapCoreV1ServiceImpl) Apply(ctx context.Context, in *corev1.ServiceApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Service, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ServiceImpl) ApplyStatus(ctx context.Context, in *corev1.ServiceApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.Service, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ServiceImpl) Create(ctx context.Context, in *apicorev1.Service, opts metav1.CreateOptions) (*apicorev1.Service, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Service",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Service{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1ServiceImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.Service, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Service{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.ServiceList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.Service, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Service{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceImpl) Update(ctx context.Context, in *apicorev1.Service, opts metav1.UpdateOptions) (*apicorev1.Service, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Service",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Service{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceImpl) UpdateStatus(ctx context.Context, in *apicorev1.Service, opts metav1.UpdateOptions) (*apicorev1.Service, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "Service",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.Service{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1) ServiceAccounts(namespace string) typedcorev1.ServiceAccountInterface {
	return &wrapCoreV1ServiceAccountImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "",
			Version:  "v1",
			Resource: "serviceaccounts",
		}),

		namespace: namespace,
	}
}

type wrapCoreV1ServiceAccountImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedcorev1.ServiceAccountInterface = (*wrapCoreV1ServiceAccountImpl)(nil)

func (w *wrapCoreV1ServiceAccountImpl) Apply(ctx context.Context, in *corev1.ServiceAccountApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ServiceAccount, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ServiceAccountImpl) ApplyStatus(ctx context.Context, in *corev1.ServiceAccountApplyConfiguration, opts metav1.ApplyOptions) (result *apicorev1.ServiceAccount, err error) {
	panic("NYI")
}

func (w *wrapCoreV1ServiceAccountImpl) Create(ctx context.Context, in *apicorev1.ServiceAccount, opts metav1.CreateOptions) (*apicorev1.ServiceAccount, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ServiceAccount",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceAccount{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceAccountImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapCoreV1ServiceAccountImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapCoreV1ServiceAccountImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apicorev1.ServiceAccount, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceAccount{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceAccountImpl) List(ctx context.Context, opts metav1.ListOptions) (*apicorev1.ServiceAccountList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceAccountList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceAccountImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apicorev1.ServiceAccount, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceAccount{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceAccountImpl) Update(ctx context.Context, in *apicorev1.ServiceAccount, opts metav1.UpdateOptions) (*apicorev1.ServiceAccount, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ServiceAccount",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceAccount{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceAccountImpl) UpdateStatus(ctx context.Context, in *apicorev1.ServiceAccount, opts metav1.UpdateOptions) (*apicorev1.ServiceAccount, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "",
		Version: "v1",
		Kind:    "ServiceAccount",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apicorev1.ServiceAccount{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapCoreV1ServiceAccountImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapCoreV1ServiceAccountImpl) CreateToken(ctx context.Context, _ string, in *authenticationv1.TokenRequest, opts metav1.CreateOptions) (*authenticationv1.TokenRequest, error) {
	panic("NYI")
}

// DiscoveryV1 retrieves the DiscoveryV1Client
func (w *wrapClient) DiscoveryV1() typeddiscoveryv1.DiscoveryV1Interface {
	return &wrapDiscoveryV1{
		dyn: w.dyn,
	}
}

type wrapDiscoveryV1 struct {
	dyn dynamic.Interface
}

func (w *wrapDiscoveryV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapDiscoveryV1) EndpointSlices(namespace string) typeddiscoveryv1.EndpointSliceInterface {
	return &wrapDiscoveryV1EndpointSliceImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "discovery.k8s.io",
			Version:  "v1",
			Resource: "endpointslices",
		}),

		namespace: namespace,
	}
}

type wrapDiscoveryV1EndpointSliceImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typeddiscoveryv1.EndpointSliceInterface = (*wrapDiscoveryV1EndpointSliceImpl)(nil)

func (w *wrapDiscoveryV1EndpointSliceImpl) Apply(ctx context.Context, in *discoveryv1.EndpointSliceApplyConfiguration, opts metav1.ApplyOptions) (result *apidiscoveryv1.EndpointSlice, err error) {
	panic("NYI")
}

func (w *wrapDiscoveryV1EndpointSliceImpl) ApplyStatus(ctx context.Context, in *discoveryv1.EndpointSliceApplyConfiguration, opts metav1.ApplyOptions) (result *apidiscoveryv1.EndpointSlice, err error) {
	panic("NYI")
}

func (w *wrapDiscoveryV1EndpointSliceImpl) Create(ctx context.Context, in *apidiscoveryv1.EndpointSlice, opts metav1.CreateOptions) (*apidiscoveryv1.EndpointSlice, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "discovery.k8s.io",
		Version: "v1",
		Kind:    "EndpointSlice",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1EndpointSliceImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapDiscoveryV1EndpointSliceImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapDiscoveryV1EndpointSliceImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apidiscoveryv1.EndpointSlice, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1EndpointSliceImpl) List(ctx context.Context, opts metav1.ListOptions) (*apidiscoveryv1.EndpointSliceList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1.EndpointSliceList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1EndpointSliceImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apidiscoveryv1.EndpointSlice, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1EndpointSliceImpl) Update(ctx context.Context, in *apidiscoveryv1.EndpointSlice, opts metav1.UpdateOptions) (*apidiscoveryv1.EndpointSlice, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "discovery.k8s.io",
		Version: "v1",
		Kind:    "EndpointSlice",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1EndpointSliceImpl) UpdateStatus(ctx context.Context, in *apidiscoveryv1.EndpointSlice, opts metav1.UpdateOptions) (*apidiscoveryv1.EndpointSlice, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "discovery.k8s.io",
		Version: "v1",
		Kind:    "EndpointSlice",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1EndpointSliceImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// DiscoveryV1beta1 retrieves the DiscoveryV1beta1Client
func (w *wrapClient) DiscoveryV1beta1() typeddiscoveryv1beta1.DiscoveryV1beta1Interface {
	return &wrapDiscoveryV1beta1{
		dyn: w.dyn,
	}
}

type wrapDiscoveryV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapDiscoveryV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapDiscoveryV1beta1) EndpointSlices(namespace string) typeddiscoveryv1beta1.EndpointSliceInterface {
	return &wrapDiscoveryV1beta1EndpointSliceImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "discovery.k8s.io",
			Version:  "v1beta1",
			Resource: "endpointslices",
		}),

		namespace: namespace,
	}
}

type wrapDiscoveryV1beta1EndpointSliceImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typeddiscoveryv1beta1.EndpointSliceInterface = (*wrapDiscoveryV1beta1EndpointSliceImpl)(nil)

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Apply(ctx context.Context, in *discoveryv1beta1.EndpointSliceApplyConfiguration, opts metav1.ApplyOptions) (result *apidiscoveryv1beta1.EndpointSlice, err error) {
	panic("NYI")
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) ApplyStatus(ctx context.Context, in *discoveryv1beta1.EndpointSliceApplyConfiguration, opts metav1.ApplyOptions) (result *apidiscoveryv1beta1.EndpointSlice, err error) {
	panic("NYI")
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Create(ctx context.Context, in *apidiscoveryv1beta1.EndpointSlice, opts metav1.CreateOptions) (*apidiscoveryv1beta1.EndpointSlice, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "discovery.k8s.io",
		Version: "v1beta1",
		Kind:    "EndpointSlice",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1beta1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apidiscoveryv1beta1.EndpointSlice, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1beta1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) List(ctx context.Context, opts metav1.ListOptions) (*apidiscoveryv1beta1.EndpointSliceList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1beta1.EndpointSliceList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apidiscoveryv1beta1.EndpointSlice, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1beta1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Update(ctx context.Context, in *apidiscoveryv1beta1.EndpointSlice, opts metav1.UpdateOptions) (*apidiscoveryv1beta1.EndpointSlice, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "discovery.k8s.io",
		Version: "v1beta1",
		Kind:    "EndpointSlice",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1beta1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) UpdateStatus(ctx context.Context, in *apidiscoveryv1beta1.EndpointSlice, opts metav1.UpdateOptions) (*apidiscoveryv1beta1.EndpointSlice, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "discovery.k8s.io",
		Version: "v1beta1",
		Kind:    "EndpointSlice",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apidiscoveryv1beta1.EndpointSlice{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapDiscoveryV1beta1EndpointSliceImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// EventsV1 retrieves the EventsV1Client
func (w *wrapClient) EventsV1() typedeventsv1.EventsV1Interface {
	return &wrapEventsV1{
		dyn: w.dyn,
	}
}

type wrapEventsV1 struct {
	dyn dynamic.Interface
}

func (w *wrapEventsV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapEventsV1) Events(namespace string) typedeventsv1.EventInterface {
	return &wrapEventsV1EventImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "events.k8s.io",
			Version:  "v1",
			Resource: "events",
		}),

		namespace: namespace,
	}
}

type wrapEventsV1EventImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedeventsv1.EventInterface = (*wrapEventsV1EventImpl)(nil)

func (w *wrapEventsV1EventImpl) Apply(ctx context.Context, in *eventsv1.EventApplyConfiguration, opts metav1.ApplyOptions) (result *apieventsv1.Event, err error) {
	panic("NYI")
}

func (w *wrapEventsV1EventImpl) ApplyStatus(ctx context.Context, in *eventsv1.EventApplyConfiguration, opts metav1.ApplyOptions) (result *apieventsv1.Event, err error) {
	panic("NYI")
}

func (w *wrapEventsV1EventImpl) Create(ctx context.Context, in *apieventsv1.Event, opts metav1.CreateOptions) (*apieventsv1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "events.k8s.io",
		Version: "v1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1EventImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapEventsV1EventImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapEventsV1EventImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apieventsv1.Event, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1EventImpl) List(ctx context.Context, opts metav1.ListOptions) (*apieventsv1.EventList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1.EventList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1EventImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apieventsv1.Event, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1EventImpl) Update(ctx context.Context, in *apieventsv1.Event, opts metav1.UpdateOptions) (*apieventsv1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "events.k8s.io",
		Version: "v1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1EventImpl) UpdateStatus(ctx context.Context, in *apieventsv1.Event, opts metav1.UpdateOptions) (*apieventsv1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "events.k8s.io",
		Version: "v1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1EventImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// EventsV1beta1 retrieves the EventsV1beta1Client
func (w *wrapClient) EventsV1beta1() typedeventsv1beta1.EventsV1beta1Interface {
	return &wrapEventsV1beta1{
		dyn: w.dyn,
	}
}

type wrapEventsV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapEventsV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapEventsV1beta1) Events(namespace string) typedeventsv1beta1.EventInterface {
	return &wrapEventsV1beta1EventImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "events.k8s.io",
			Version:  "v1beta1",
			Resource: "events",
		}),

		namespace: namespace,
	}
}

type wrapEventsV1beta1EventImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedeventsv1beta1.EventInterface = (*wrapEventsV1beta1EventImpl)(nil)

func (w *wrapEventsV1beta1EventImpl) Apply(ctx context.Context, in *eventsv1beta1.EventApplyConfiguration, opts metav1.ApplyOptions) (result *apieventsv1beta1.Event, err error) {
	panic("NYI")
}

func (w *wrapEventsV1beta1EventImpl) ApplyStatus(ctx context.Context, in *eventsv1beta1.EventApplyConfiguration, opts metav1.ApplyOptions) (result *apieventsv1beta1.Event, err error) {
	panic("NYI")
}

func (w *wrapEventsV1beta1EventImpl) Create(ctx context.Context, in *apieventsv1beta1.Event, opts metav1.CreateOptions) (*apieventsv1beta1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "events.k8s.io",
		Version: "v1beta1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1beta1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1beta1EventImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapEventsV1beta1EventImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapEventsV1beta1EventImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apieventsv1beta1.Event, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1beta1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1beta1EventImpl) List(ctx context.Context, opts metav1.ListOptions) (*apieventsv1beta1.EventList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1beta1.EventList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1beta1EventImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apieventsv1beta1.Event, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1beta1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1beta1EventImpl) Update(ctx context.Context, in *apieventsv1beta1.Event, opts metav1.UpdateOptions) (*apieventsv1beta1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "events.k8s.io",
		Version: "v1beta1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1beta1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1beta1EventImpl) UpdateStatus(ctx context.Context, in *apieventsv1beta1.Event, opts metav1.UpdateOptions) (*apieventsv1beta1.Event, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "events.k8s.io",
		Version: "v1beta1",
		Kind:    "Event",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apieventsv1beta1.Event{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapEventsV1beta1EventImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// ExtensionsV1beta1 retrieves the ExtensionsV1beta1Client
func (w *wrapClient) ExtensionsV1beta1() typedextensionsv1beta1.ExtensionsV1beta1Interface {
	return &wrapExtensionsV1beta1{
		dyn: w.dyn,
	}
}

type wrapExtensionsV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapExtensionsV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapExtensionsV1beta1) DaemonSets(namespace string) typedextensionsv1beta1.DaemonSetInterface {
	return &wrapExtensionsV1beta1DaemonSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "extensions",
			Version:  "v1beta1",
			Resource: "daemonsets",
		}),

		namespace: namespace,
	}
}

type wrapExtensionsV1beta1DaemonSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedextensionsv1beta1.DaemonSetInterface = (*wrapExtensionsV1beta1DaemonSetImpl)(nil)

func (w *wrapExtensionsV1beta1DaemonSetImpl) Apply(ctx context.Context, in *extensionsv1beta1.DaemonSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.DaemonSet, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) ApplyStatus(ctx context.Context, in *extensionsv1beta1.DaemonSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.DaemonSet, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) Create(ctx context.Context, in *apiextensionsv1beta1.DaemonSet, opts metav1.CreateOptions) (*apiextensionsv1beta1.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.DaemonSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiextensionsv1beta1.DaemonSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DaemonSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiextensionsv1beta1.DaemonSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) Update(ctx context.Context, in *apiextensionsv1beta1.DaemonSet, opts metav1.UpdateOptions) (*apiextensionsv1beta1.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) UpdateStatus(ctx context.Context, in *apiextensionsv1beta1.DaemonSet, opts metav1.UpdateOptions) (*apiextensionsv1beta1.DaemonSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "DaemonSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DaemonSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DaemonSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapExtensionsV1beta1) Deployments(namespace string) typedextensionsv1beta1.DeploymentInterface {
	return &wrapExtensionsV1beta1DeploymentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "extensions",
			Version:  "v1beta1",
			Resource: "deployments",
		}),

		namespace: namespace,
	}
}

type wrapExtensionsV1beta1DeploymentImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedextensionsv1beta1.DeploymentInterface = (*wrapExtensionsV1beta1DeploymentImpl)(nil)

func (w *wrapExtensionsV1beta1DeploymentImpl) Apply(ctx context.Context, in *extensionsv1beta1.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.Deployment, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1DeploymentImpl) ApplyStatus(ctx context.Context, in *extensionsv1beta1.DeploymentApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.Deployment, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1DeploymentImpl) Create(ctx context.Context, in *apiextensionsv1beta1.Deployment, opts metav1.CreateOptions) (*apiextensionsv1beta1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DeploymentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapExtensionsV1beta1DeploymentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapExtensionsV1beta1DeploymentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.Deployment, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DeploymentImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiextensionsv1beta1.DeploymentList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.DeploymentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DeploymentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiextensionsv1beta1.Deployment, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DeploymentImpl) Update(ctx context.Context, in *apiextensionsv1beta1.Deployment, opts metav1.UpdateOptions) (*apiextensionsv1beta1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DeploymentImpl) UpdateStatus(ctx context.Context, in *apiextensionsv1beta1.Deployment, opts metav1.UpdateOptions) (*apiextensionsv1beta1.Deployment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "Deployment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Deployment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1DeploymentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapExtensionsV1beta1DeploymentImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.Scale, error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1DeploymentImpl) UpdateScale(ctx context.Context, _ string, in *apiextensionsv1beta1.Scale, opts metav1.UpdateOptions) (*apiextensionsv1beta1.Scale, error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1DeploymentImpl) ApplyScale(ctx context.Context, name string, in *extensionsv1beta1.ScaleApplyConfiguration, opts metav1.ApplyOptions) (*apiextensionsv1beta1.Scale, error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1) Ingresses(namespace string) typedextensionsv1beta1.IngressInterface {
	return &wrapExtensionsV1beta1IngressImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "extensions",
			Version:  "v1beta1",
			Resource: "ingresses",
		}),

		namespace: namespace,
	}
}

type wrapExtensionsV1beta1IngressImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedextensionsv1beta1.IngressInterface = (*wrapExtensionsV1beta1IngressImpl)(nil)

func (w *wrapExtensionsV1beta1IngressImpl) Apply(ctx context.Context, in *extensionsv1beta1.IngressApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.Ingress, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1IngressImpl) ApplyStatus(ctx context.Context, in *extensionsv1beta1.IngressApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.Ingress, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1IngressImpl) Create(ctx context.Context, in *apiextensionsv1beta1.Ingress, opts metav1.CreateOptions) (*apiextensionsv1beta1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1IngressImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapExtensionsV1beta1IngressImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapExtensionsV1beta1IngressImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.Ingress, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1IngressImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiextensionsv1beta1.IngressList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.IngressList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1IngressImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiextensionsv1beta1.Ingress, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1IngressImpl) Update(ctx context.Context, in *apiextensionsv1beta1.Ingress, opts metav1.UpdateOptions) (*apiextensionsv1beta1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1IngressImpl) UpdateStatus(ctx context.Context, in *apiextensionsv1beta1.Ingress, opts metav1.UpdateOptions) (*apiextensionsv1beta1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1IngressImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapExtensionsV1beta1) NetworkPolicies(namespace string) typedextensionsv1beta1.NetworkPolicyInterface {
	return &wrapExtensionsV1beta1NetworkPolicyImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "extensions",
			Version:  "v1beta1",
			Resource: "networkpolicies",
		}),

		namespace: namespace,
	}
}

type wrapExtensionsV1beta1NetworkPolicyImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedextensionsv1beta1.NetworkPolicyInterface = (*wrapExtensionsV1beta1NetworkPolicyImpl)(nil)

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Apply(ctx context.Context, in *extensionsv1beta1.NetworkPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.NetworkPolicy, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) ApplyStatus(ctx context.Context, in *extensionsv1beta1.NetworkPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.NetworkPolicy, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Create(ctx context.Context, in *apiextensionsv1beta1.NetworkPolicy, opts metav1.CreateOptions) (*apiextensionsv1beta1.NetworkPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "NetworkPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.NetworkPolicy, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiextensionsv1beta1.NetworkPolicyList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.NetworkPolicyList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiextensionsv1beta1.NetworkPolicy, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Update(ctx context.Context, in *apiextensionsv1beta1.NetworkPolicy, opts metav1.UpdateOptions) (*apiextensionsv1beta1.NetworkPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "NetworkPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) UpdateStatus(ctx context.Context, in *apiextensionsv1beta1.NetworkPolicy, opts metav1.UpdateOptions) (*apiextensionsv1beta1.NetworkPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "NetworkPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1NetworkPolicyImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapExtensionsV1beta1) PodSecurityPolicies() typedextensionsv1beta1.PodSecurityPolicyInterface {
	return &wrapExtensionsV1beta1PodSecurityPolicyImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "extensions",
			Version:  "v1beta1",
			Resource: "podsecuritypolicies",
		}),
	}
}

type wrapExtensionsV1beta1PodSecurityPolicyImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedextensionsv1beta1.PodSecurityPolicyInterface = (*wrapExtensionsV1beta1PodSecurityPolicyImpl)(nil)

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Apply(ctx context.Context, in *extensionsv1beta1.PodSecurityPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.PodSecurityPolicy, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) ApplyStatus(ctx context.Context, in *extensionsv1beta1.PodSecurityPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.PodSecurityPolicy, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Create(ctx context.Context, in *apiextensionsv1beta1.PodSecurityPolicy, opts metav1.CreateOptions) (*apiextensionsv1beta1.PodSecurityPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "PodSecurityPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.PodSecurityPolicy, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiextensionsv1beta1.PodSecurityPolicyList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.PodSecurityPolicyList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiextensionsv1beta1.PodSecurityPolicy, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Update(ctx context.Context, in *apiextensionsv1beta1.PodSecurityPolicy, opts metav1.UpdateOptions) (*apiextensionsv1beta1.PodSecurityPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "PodSecurityPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) UpdateStatus(ctx context.Context, in *apiextensionsv1beta1.PodSecurityPolicy, opts metav1.UpdateOptions) (*apiextensionsv1beta1.PodSecurityPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "PodSecurityPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1PodSecurityPolicyImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapExtensionsV1beta1) ReplicaSets(namespace string) typedextensionsv1beta1.ReplicaSetInterface {
	return &wrapExtensionsV1beta1ReplicaSetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "extensions",
			Version:  "v1beta1",
			Resource: "replicasets",
		}),

		namespace: namespace,
	}
}

type wrapExtensionsV1beta1ReplicaSetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedextensionsv1beta1.ReplicaSetInterface = (*wrapExtensionsV1beta1ReplicaSetImpl)(nil)

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Apply(ctx context.Context, in *extensionsv1beta1.ReplicaSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.ReplicaSet, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) ApplyStatus(ctx context.Context, in *extensionsv1beta1.ReplicaSetApplyConfiguration, opts metav1.ApplyOptions) (result *apiextensionsv1beta1.ReplicaSet, err error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Create(ctx context.Context, in *apiextensionsv1beta1.ReplicaSet, opts metav1.CreateOptions) (*apiextensionsv1beta1.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.ReplicaSet, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiextensionsv1beta1.ReplicaSetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.ReplicaSetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiextensionsv1beta1.ReplicaSet, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Update(ctx context.Context, in *apiextensionsv1beta1.ReplicaSet, opts metav1.UpdateOptions) (*apiextensionsv1beta1.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) UpdateStatus(ctx context.Context, in *apiextensionsv1beta1.ReplicaSet, opts metav1.UpdateOptions) (*apiextensionsv1beta1.ReplicaSet, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "extensions",
		Version: "v1beta1",
		Kind:    "ReplicaSet",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiextensionsv1beta1.ReplicaSet{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) GetScale(ctx context.Context, name string, opts metav1.GetOptions) (*apiextensionsv1beta1.Scale, error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) UpdateScale(ctx context.Context, _ string, in *apiextensionsv1beta1.Scale, opts metav1.UpdateOptions) (*apiextensionsv1beta1.Scale, error) {
	panic("NYI")
}

func (w *wrapExtensionsV1beta1ReplicaSetImpl) ApplyScale(ctx context.Context, name string, in *extensionsv1beta1.ScaleApplyConfiguration, opts metav1.ApplyOptions) (*apiextensionsv1beta1.Scale, error) {
	panic("NYI")
}

// FlowcontrolV1alpha1 retrieves the FlowcontrolV1alpha1Client
func (w *wrapClient) FlowcontrolV1alpha1() typedflowcontrolv1alpha1.FlowcontrolV1alpha1Interface {
	return &wrapFlowcontrolV1alpha1{
		dyn: w.dyn,
	}
}

type wrapFlowcontrolV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapFlowcontrolV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapFlowcontrolV1alpha1) FlowSchemas() typedflowcontrolv1alpha1.FlowSchemaInterface {
	return &wrapFlowcontrolV1alpha1FlowSchemaImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "flowcontrol.apiserver.k8s.io",
			Version:  "v1alpha1",
			Resource: "flowschemas",
		}),
	}
}

type wrapFlowcontrolV1alpha1FlowSchemaImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedflowcontrolv1alpha1.FlowSchemaInterface = (*wrapFlowcontrolV1alpha1FlowSchemaImpl)(nil)

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Apply(ctx context.Context, in *flowcontrolv1alpha1.FlowSchemaApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1alpha1.FlowSchema, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) ApplyStatus(ctx context.Context, in *flowcontrolv1alpha1.FlowSchemaApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1alpha1.FlowSchema, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Create(ctx context.Context, in *apiflowcontrolv1alpha1.FlowSchema, opts metav1.CreateOptions) (*apiflowcontrolv1alpha1.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiflowcontrolv1alpha1.FlowSchema, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiflowcontrolv1alpha1.FlowSchemaList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.FlowSchemaList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiflowcontrolv1alpha1.FlowSchema, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Update(ctx context.Context, in *apiflowcontrolv1alpha1.FlowSchema, opts metav1.UpdateOptions) (*apiflowcontrolv1alpha1.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) UpdateStatus(ctx context.Context, in *apiflowcontrolv1alpha1.FlowSchema, opts metav1.UpdateOptions) (*apiflowcontrolv1alpha1.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1FlowSchemaImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapFlowcontrolV1alpha1) PriorityLevelConfigurations() typedflowcontrolv1alpha1.PriorityLevelConfigurationInterface {
	return &wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "flowcontrol.apiserver.k8s.io",
			Version:  "v1alpha1",
			Resource: "prioritylevelconfigurations",
		}),
	}
}

type wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedflowcontrolv1alpha1.PriorityLevelConfigurationInterface = (*wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl)(nil)

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Apply(ctx context.Context, in *flowcontrolv1alpha1.PriorityLevelConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1alpha1.PriorityLevelConfiguration, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) ApplyStatus(ctx context.Context, in *flowcontrolv1alpha1.PriorityLevelConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1alpha1.PriorityLevelConfiguration, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Create(ctx context.Context, in *apiflowcontrolv1alpha1.PriorityLevelConfiguration, opts metav1.CreateOptions) (*apiflowcontrolv1alpha1.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiflowcontrolv1alpha1.PriorityLevelConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiflowcontrolv1alpha1.PriorityLevelConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.PriorityLevelConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiflowcontrolv1alpha1.PriorityLevelConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Update(ctx context.Context, in *apiflowcontrolv1alpha1.PriorityLevelConfiguration, opts metav1.UpdateOptions) (*apiflowcontrolv1alpha1.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) UpdateStatus(ctx context.Context, in *apiflowcontrolv1alpha1.PriorityLevelConfiguration, opts metav1.UpdateOptions) (*apiflowcontrolv1alpha1.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1alpha1",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1alpha1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1alpha1PriorityLevelConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// FlowcontrolV1beta1 retrieves the FlowcontrolV1beta1Client
func (w *wrapClient) FlowcontrolV1beta1() typedflowcontrolv1beta1.FlowcontrolV1beta1Interface {
	return &wrapFlowcontrolV1beta1{
		dyn: w.dyn,
	}
}

type wrapFlowcontrolV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapFlowcontrolV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapFlowcontrolV1beta1) FlowSchemas() typedflowcontrolv1beta1.FlowSchemaInterface {
	return &wrapFlowcontrolV1beta1FlowSchemaImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "flowcontrol.apiserver.k8s.io",
			Version:  "v1beta1",
			Resource: "flowschemas",
		}),
	}
}

type wrapFlowcontrolV1beta1FlowSchemaImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedflowcontrolv1beta1.FlowSchemaInterface = (*wrapFlowcontrolV1beta1FlowSchemaImpl)(nil)

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Apply(ctx context.Context, in *flowcontrolv1beta1.FlowSchemaApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta1.FlowSchema, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) ApplyStatus(ctx context.Context, in *flowcontrolv1beta1.FlowSchemaApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta1.FlowSchema, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Create(ctx context.Context, in *apiflowcontrolv1beta1.FlowSchema, opts metav1.CreateOptions) (*apiflowcontrolv1beta1.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta1",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiflowcontrolv1beta1.FlowSchema, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiflowcontrolv1beta1.FlowSchemaList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.FlowSchemaList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiflowcontrolv1beta1.FlowSchema, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Update(ctx context.Context, in *apiflowcontrolv1beta1.FlowSchema, opts metav1.UpdateOptions) (*apiflowcontrolv1beta1.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta1",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) UpdateStatus(ctx context.Context, in *apiflowcontrolv1beta1.FlowSchema, opts metav1.UpdateOptions) (*apiflowcontrolv1beta1.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta1",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1FlowSchemaImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapFlowcontrolV1beta1) PriorityLevelConfigurations() typedflowcontrolv1beta1.PriorityLevelConfigurationInterface {
	return &wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "flowcontrol.apiserver.k8s.io",
			Version:  "v1beta1",
			Resource: "prioritylevelconfigurations",
		}),
	}
}

type wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedflowcontrolv1beta1.PriorityLevelConfigurationInterface = (*wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl)(nil)

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Apply(ctx context.Context, in *flowcontrolv1beta1.PriorityLevelConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta1.PriorityLevelConfiguration, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) ApplyStatus(ctx context.Context, in *flowcontrolv1beta1.PriorityLevelConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta1.PriorityLevelConfiguration, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Create(ctx context.Context, in *apiflowcontrolv1beta1.PriorityLevelConfiguration, opts metav1.CreateOptions) (*apiflowcontrolv1beta1.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta1",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiflowcontrolv1beta1.PriorityLevelConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiflowcontrolv1beta1.PriorityLevelConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.PriorityLevelConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiflowcontrolv1beta1.PriorityLevelConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Update(ctx context.Context, in *apiflowcontrolv1beta1.PriorityLevelConfiguration, opts metav1.UpdateOptions) (*apiflowcontrolv1beta1.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta1",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) UpdateStatus(ctx context.Context, in *apiflowcontrolv1beta1.PriorityLevelConfiguration, opts metav1.UpdateOptions) (*apiflowcontrolv1beta1.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta1",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta1.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta1PriorityLevelConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// FlowcontrolV1beta2 retrieves the FlowcontrolV1beta2Client
func (w *wrapClient) FlowcontrolV1beta2() typedflowcontrolv1beta2.FlowcontrolV1beta2Interface {
	return &wrapFlowcontrolV1beta2{
		dyn: w.dyn,
	}
}

type wrapFlowcontrolV1beta2 struct {
	dyn dynamic.Interface
}

func (w *wrapFlowcontrolV1beta2) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapFlowcontrolV1beta2) FlowSchemas() typedflowcontrolv1beta2.FlowSchemaInterface {
	return &wrapFlowcontrolV1beta2FlowSchemaImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "flowcontrol.apiserver.k8s.io",
			Version:  "v1beta2",
			Resource: "flowschemas",
		}),
	}
}

type wrapFlowcontrolV1beta2FlowSchemaImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedflowcontrolv1beta2.FlowSchemaInterface = (*wrapFlowcontrolV1beta2FlowSchemaImpl)(nil)

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Apply(ctx context.Context, in *flowcontrolv1beta2.FlowSchemaApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta2.FlowSchema, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) ApplyStatus(ctx context.Context, in *flowcontrolv1beta2.FlowSchemaApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta2.FlowSchema, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Create(ctx context.Context, in *apiflowcontrolv1beta2.FlowSchema, opts metav1.CreateOptions) (*apiflowcontrolv1beta2.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta2",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiflowcontrolv1beta2.FlowSchema, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiflowcontrolv1beta2.FlowSchemaList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.FlowSchemaList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiflowcontrolv1beta2.FlowSchema, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Update(ctx context.Context, in *apiflowcontrolv1beta2.FlowSchema, opts metav1.UpdateOptions) (*apiflowcontrolv1beta2.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta2",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) UpdateStatus(ctx context.Context, in *apiflowcontrolv1beta2.FlowSchema, opts metav1.UpdateOptions) (*apiflowcontrolv1beta2.FlowSchema, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta2",
		Kind:    "FlowSchema",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.FlowSchema{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2FlowSchemaImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapFlowcontrolV1beta2) PriorityLevelConfigurations() typedflowcontrolv1beta2.PriorityLevelConfigurationInterface {
	return &wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "flowcontrol.apiserver.k8s.io",
			Version:  "v1beta2",
			Resource: "prioritylevelconfigurations",
		}),
	}
}

type wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedflowcontrolv1beta2.PriorityLevelConfigurationInterface = (*wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl)(nil)

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Apply(ctx context.Context, in *flowcontrolv1beta2.PriorityLevelConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta2.PriorityLevelConfiguration, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) ApplyStatus(ctx context.Context, in *flowcontrolv1beta2.PriorityLevelConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *apiflowcontrolv1beta2.PriorityLevelConfiguration, err error) {
	panic("NYI")
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Create(ctx context.Context, in *apiflowcontrolv1beta2.PriorityLevelConfiguration, opts metav1.CreateOptions) (*apiflowcontrolv1beta2.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta2",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiflowcontrolv1beta2.PriorityLevelConfiguration, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) List(ctx context.Context, opts metav1.ListOptions) (*apiflowcontrolv1beta2.PriorityLevelConfigurationList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.PriorityLevelConfigurationList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiflowcontrolv1beta2.PriorityLevelConfiguration, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Update(ctx context.Context, in *apiflowcontrolv1beta2.PriorityLevelConfiguration, opts metav1.UpdateOptions) (*apiflowcontrolv1beta2.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta2",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) UpdateStatus(ctx context.Context, in *apiflowcontrolv1beta2.PriorityLevelConfiguration, opts metav1.UpdateOptions) (*apiflowcontrolv1beta2.PriorityLevelConfiguration, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "flowcontrol.apiserver.k8s.io",
		Version: "v1beta2",
		Kind:    "PriorityLevelConfiguration",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apiflowcontrolv1beta2.PriorityLevelConfiguration{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapFlowcontrolV1beta2PriorityLevelConfigurationImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// NetworkingV1 retrieves the NetworkingV1Client
func (w *wrapClient) NetworkingV1() typednetworkingv1.NetworkingV1Interface {
	return &wrapNetworkingV1{
		dyn: w.dyn,
	}
}

type wrapNetworkingV1 struct {
	dyn dynamic.Interface
}

func (w *wrapNetworkingV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapNetworkingV1) Ingresses(namespace string) typednetworkingv1.IngressInterface {
	return &wrapNetworkingV1IngressImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "networking.k8s.io",
			Version:  "v1",
			Resource: "ingresses",
		}),

		namespace: namespace,
	}
}

type wrapNetworkingV1IngressImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typednetworkingv1.IngressInterface = (*wrapNetworkingV1IngressImpl)(nil)

func (w *wrapNetworkingV1IngressImpl) Apply(ctx context.Context, in *networkingv1.IngressApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1.Ingress, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1IngressImpl) ApplyStatus(ctx context.Context, in *networkingv1.IngressApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1.Ingress, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1IngressImpl) Create(ctx context.Context, in *apinetworkingv1.Ingress, opts metav1.CreateOptions) (*apinetworkingv1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapNetworkingV1IngressImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNetworkingV1IngressImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinetworkingv1.Ingress, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinetworkingv1.IngressList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinetworkingv1.Ingress, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressImpl) Update(ctx context.Context, in *apinetworkingv1.Ingress, opts metav1.UpdateOptions) (*apinetworkingv1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressImpl) UpdateStatus(ctx context.Context, in *apinetworkingv1.Ingress, opts metav1.UpdateOptions) (*apinetworkingv1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapNetworkingV1) IngressClasses() typednetworkingv1.IngressClassInterface {
	return &wrapNetworkingV1IngressClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "networking.k8s.io",
			Version:  "v1",
			Resource: "ingressclasses",
		}),
	}
}

type wrapNetworkingV1IngressClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typednetworkingv1.IngressClassInterface = (*wrapNetworkingV1IngressClassImpl)(nil)

func (w *wrapNetworkingV1IngressClassImpl) Apply(ctx context.Context, in *networkingv1.IngressClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1.IngressClass, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1IngressClassImpl) ApplyStatus(ctx context.Context, in *networkingv1.IngressClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1.IngressClass, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1IngressClassImpl) Create(ctx context.Context, in *apinetworkingv1.IngressClass, opts metav1.CreateOptions) (*apinetworkingv1.IngressClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "IngressClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapNetworkingV1IngressClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNetworkingV1IngressClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinetworkingv1.IngressClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinetworkingv1.IngressClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinetworkingv1.IngressClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressClassImpl) Update(ctx context.Context, in *apinetworkingv1.IngressClass, opts metav1.UpdateOptions) (*apinetworkingv1.IngressClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "IngressClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressClassImpl) UpdateStatus(ctx context.Context, in *apinetworkingv1.IngressClass, opts metav1.UpdateOptions) (*apinetworkingv1.IngressClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "IngressClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1IngressClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapNetworkingV1) NetworkPolicies(namespace string) typednetworkingv1.NetworkPolicyInterface {
	return &wrapNetworkingV1NetworkPolicyImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "networking.k8s.io",
			Version:  "v1",
			Resource: "networkpolicies",
		}),

		namespace: namespace,
	}
}

type wrapNetworkingV1NetworkPolicyImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typednetworkingv1.NetworkPolicyInterface = (*wrapNetworkingV1NetworkPolicyImpl)(nil)

func (w *wrapNetworkingV1NetworkPolicyImpl) Apply(ctx context.Context, in *networkingv1.NetworkPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1.NetworkPolicy, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1NetworkPolicyImpl) ApplyStatus(ctx context.Context, in *networkingv1.NetworkPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1.NetworkPolicy, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1NetworkPolicyImpl) Create(ctx context.Context, in *apinetworkingv1.NetworkPolicy, opts metav1.CreateOptions) (*apinetworkingv1.NetworkPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "NetworkPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1NetworkPolicyImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapNetworkingV1NetworkPolicyImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNetworkingV1NetworkPolicyImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinetworkingv1.NetworkPolicy, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1NetworkPolicyImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinetworkingv1.NetworkPolicyList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.NetworkPolicyList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1NetworkPolicyImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinetworkingv1.NetworkPolicy, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1NetworkPolicyImpl) Update(ctx context.Context, in *apinetworkingv1.NetworkPolicy, opts metav1.UpdateOptions) (*apinetworkingv1.NetworkPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "NetworkPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1NetworkPolicyImpl) UpdateStatus(ctx context.Context, in *apinetworkingv1.NetworkPolicy, opts metav1.UpdateOptions) (*apinetworkingv1.NetworkPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1",
		Kind:    "NetworkPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1.NetworkPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1NetworkPolicyImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// NetworkingV1beta1 retrieves the NetworkingV1beta1Client
func (w *wrapClient) NetworkingV1beta1() typednetworkingv1beta1.NetworkingV1beta1Interface {
	return &wrapNetworkingV1beta1{
		dyn: w.dyn,
	}
}

type wrapNetworkingV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapNetworkingV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapNetworkingV1beta1) Ingresses(namespace string) typednetworkingv1beta1.IngressInterface {
	return &wrapNetworkingV1beta1IngressImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "networking.k8s.io",
			Version:  "v1beta1",
			Resource: "ingresses",
		}),

		namespace: namespace,
	}
}

type wrapNetworkingV1beta1IngressImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typednetworkingv1beta1.IngressInterface = (*wrapNetworkingV1beta1IngressImpl)(nil)

func (w *wrapNetworkingV1beta1IngressImpl) Apply(ctx context.Context, in *networkingv1beta1.IngressApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1beta1.Ingress, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1beta1IngressImpl) ApplyStatus(ctx context.Context, in *networkingv1beta1.IngressApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1beta1.Ingress, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1beta1IngressImpl) Create(ctx context.Context, in *apinetworkingv1beta1.Ingress, opts metav1.CreateOptions) (*apinetworkingv1beta1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1beta1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapNetworkingV1beta1IngressImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNetworkingV1beta1IngressImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinetworkingv1beta1.Ingress, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinetworkingv1beta1.IngressList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinetworkingv1beta1.Ingress, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressImpl) Update(ctx context.Context, in *apinetworkingv1beta1.Ingress, opts metav1.UpdateOptions) (*apinetworkingv1beta1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1beta1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressImpl) UpdateStatus(ctx context.Context, in *apinetworkingv1beta1.Ingress, opts metav1.UpdateOptions) (*apinetworkingv1beta1.Ingress, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1beta1",
		Kind:    "Ingress",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.Ingress{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapNetworkingV1beta1) IngressClasses() typednetworkingv1beta1.IngressClassInterface {
	return &wrapNetworkingV1beta1IngressClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "networking.k8s.io",
			Version:  "v1beta1",
			Resource: "ingressclasses",
		}),
	}
}

type wrapNetworkingV1beta1IngressClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typednetworkingv1beta1.IngressClassInterface = (*wrapNetworkingV1beta1IngressClassImpl)(nil)

func (w *wrapNetworkingV1beta1IngressClassImpl) Apply(ctx context.Context, in *networkingv1beta1.IngressClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1beta1.IngressClass, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1beta1IngressClassImpl) ApplyStatus(ctx context.Context, in *networkingv1beta1.IngressClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinetworkingv1beta1.IngressClass, err error) {
	panic("NYI")
}

func (w *wrapNetworkingV1beta1IngressClassImpl) Create(ctx context.Context, in *apinetworkingv1beta1.IngressClass, opts metav1.CreateOptions) (*apinetworkingv1beta1.IngressClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1beta1",
		Kind:    "IngressClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapNetworkingV1beta1IngressClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNetworkingV1beta1IngressClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinetworkingv1beta1.IngressClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinetworkingv1beta1.IngressClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinetworkingv1beta1.IngressClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressClassImpl) Update(ctx context.Context, in *apinetworkingv1beta1.IngressClass, opts metav1.UpdateOptions) (*apinetworkingv1beta1.IngressClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1beta1",
		Kind:    "IngressClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressClassImpl) UpdateStatus(ctx context.Context, in *apinetworkingv1beta1.IngressClass, opts metav1.UpdateOptions) (*apinetworkingv1beta1.IngressClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "networking.k8s.io",
		Version: "v1beta1",
		Kind:    "IngressClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinetworkingv1beta1.IngressClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNetworkingV1beta1IngressClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// NodeV1 retrieves the NodeV1Client
func (w *wrapClient) NodeV1() typednodev1.NodeV1Interface {
	return &wrapNodeV1{
		dyn: w.dyn,
	}
}

type wrapNodeV1 struct {
	dyn dynamic.Interface
}

func (w *wrapNodeV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapNodeV1) RuntimeClasses() typednodev1.RuntimeClassInterface {
	return &wrapNodeV1RuntimeClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "node.k8s.io",
			Version:  "v1",
			Resource: "runtimeclasses",
		}),
	}
}

type wrapNodeV1RuntimeClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typednodev1.RuntimeClassInterface = (*wrapNodeV1RuntimeClassImpl)(nil)

func (w *wrapNodeV1RuntimeClassImpl) Apply(ctx context.Context, in *nodev1.RuntimeClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinodev1.RuntimeClass, err error) {
	panic("NYI")
}

func (w *wrapNodeV1RuntimeClassImpl) ApplyStatus(ctx context.Context, in *nodev1.RuntimeClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinodev1.RuntimeClass, err error) {
	panic("NYI")
}

func (w *wrapNodeV1RuntimeClassImpl) Create(ctx context.Context, in *apinodev1.RuntimeClass, opts metav1.CreateOptions) (*apinodev1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1RuntimeClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapNodeV1RuntimeClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNodeV1RuntimeClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinodev1.RuntimeClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1RuntimeClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinodev1.RuntimeClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1.RuntimeClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1RuntimeClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinodev1.RuntimeClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1RuntimeClassImpl) Update(ctx context.Context, in *apinodev1.RuntimeClass, opts metav1.UpdateOptions) (*apinodev1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1RuntimeClassImpl) UpdateStatus(ctx context.Context, in *apinodev1.RuntimeClass, opts metav1.UpdateOptions) (*apinodev1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1RuntimeClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// NodeV1alpha1 retrieves the NodeV1alpha1Client
func (w *wrapClient) NodeV1alpha1() typednodev1alpha1.NodeV1alpha1Interface {
	return &wrapNodeV1alpha1{
		dyn: w.dyn,
	}
}

type wrapNodeV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapNodeV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapNodeV1alpha1) RuntimeClasses() typednodev1alpha1.RuntimeClassInterface {
	return &wrapNodeV1alpha1RuntimeClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "node.k8s.io",
			Version:  "v1alpha1",
			Resource: "runtimeclasses",
		}),
	}
}

type wrapNodeV1alpha1RuntimeClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typednodev1alpha1.RuntimeClassInterface = (*wrapNodeV1alpha1RuntimeClassImpl)(nil)

func (w *wrapNodeV1alpha1RuntimeClassImpl) Apply(ctx context.Context, in *nodev1alpha1.RuntimeClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinodev1alpha1.RuntimeClass, err error) {
	panic("NYI")
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) ApplyStatus(ctx context.Context, in *nodev1alpha1.RuntimeClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinodev1alpha1.RuntimeClass, err error) {
	panic("NYI")
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) Create(ctx context.Context, in *apinodev1alpha1.RuntimeClass, opts metav1.CreateOptions) (*apinodev1alpha1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1alpha1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1alpha1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinodev1alpha1.RuntimeClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1alpha1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinodev1alpha1.RuntimeClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1alpha1.RuntimeClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinodev1alpha1.RuntimeClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1alpha1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) Update(ctx context.Context, in *apinodev1alpha1.RuntimeClass, opts metav1.UpdateOptions) (*apinodev1alpha1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1alpha1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1alpha1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) UpdateStatus(ctx context.Context, in *apinodev1alpha1.RuntimeClass, opts metav1.UpdateOptions) (*apinodev1alpha1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1alpha1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1alpha1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1alpha1RuntimeClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// NodeV1beta1 retrieves the NodeV1beta1Client
func (w *wrapClient) NodeV1beta1() typednodev1beta1.NodeV1beta1Interface {
	return &wrapNodeV1beta1{
		dyn: w.dyn,
	}
}

type wrapNodeV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapNodeV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapNodeV1beta1) RuntimeClasses() typednodev1beta1.RuntimeClassInterface {
	return &wrapNodeV1beta1RuntimeClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "node.k8s.io",
			Version:  "v1beta1",
			Resource: "runtimeclasses",
		}),
	}
}

type wrapNodeV1beta1RuntimeClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typednodev1beta1.RuntimeClassInterface = (*wrapNodeV1beta1RuntimeClassImpl)(nil)

func (w *wrapNodeV1beta1RuntimeClassImpl) Apply(ctx context.Context, in *nodev1beta1.RuntimeClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinodev1beta1.RuntimeClass, err error) {
	panic("NYI")
}

func (w *wrapNodeV1beta1RuntimeClassImpl) ApplyStatus(ctx context.Context, in *nodev1beta1.RuntimeClassApplyConfiguration, opts metav1.ApplyOptions) (result *apinodev1beta1.RuntimeClass, err error) {
	panic("NYI")
}

func (w *wrapNodeV1beta1RuntimeClassImpl) Create(ctx context.Context, in *apinodev1beta1.RuntimeClass, opts metav1.CreateOptions) (*apinodev1beta1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1beta1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1beta1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1beta1RuntimeClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapNodeV1beta1RuntimeClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapNodeV1beta1RuntimeClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apinodev1beta1.RuntimeClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1beta1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1beta1RuntimeClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apinodev1beta1.RuntimeClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1beta1.RuntimeClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1beta1RuntimeClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apinodev1beta1.RuntimeClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1beta1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1beta1RuntimeClassImpl) Update(ctx context.Context, in *apinodev1beta1.RuntimeClass, opts metav1.UpdateOptions) (*apinodev1beta1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1beta1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1beta1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1beta1RuntimeClassImpl) UpdateStatus(ctx context.Context, in *apinodev1beta1.RuntimeClass, opts metav1.UpdateOptions) (*apinodev1beta1.RuntimeClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "node.k8s.io",
		Version: "v1beta1",
		Kind:    "RuntimeClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apinodev1beta1.RuntimeClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapNodeV1beta1RuntimeClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// PolicyV1 retrieves the PolicyV1Client
func (w *wrapClient) PolicyV1() typedpolicyv1.PolicyV1Interface {
	return &wrapPolicyV1{
		dyn: w.dyn,
	}
}

type wrapPolicyV1 struct {
	dyn dynamic.Interface
}

func (w *wrapPolicyV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapPolicyV1) Evictions(namespace string) typedpolicyv1.EvictionInterface {
	return &wrapPolicyV1EvictionImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy",
			Version:  "v1",
			Resource: "evictions",
		}),

		namespace: namespace,
	}
}

type wrapPolicyV1EvictionImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedpolicyv1.EvictionInterface = (*wrapPolicyV1EvictionImpl)(nil)

func (w *wrapPolicyV1) PodDisruptionBudgets(namespace string) typedpolicyv1.PodDisruptionBudgetInterface {
	return &wrapPolicyV1PodDisruptionBudgetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy",
			Version:  "v1",
			Resource: "poddisruptionbudgets",
		}),

		namespace: namespace,
	}
}

type wrapPolicyV1PodDisruptionBudgetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedpolicyv1.PodDisruptionBudgetInterface = (*wrapPolicyV1PodDisruptionBudgetImpl)(nil)

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Apply(ctx context.Context, in *policyv1.PodDisruptionBudgetApplyConfiguration, opts metav1.ApplyOptions) (result *apipolicyv1.PodDisruptionBudget, err error) {
	panic("NYI")
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) ApplyStatus(ctx context.Context, in *policyv1.PodDisruptionBudgetApplyConfiguration, opts metav1.ApplyOptions) (result *apipolicyv1.PodDisruptionBudget, err error) {
	panic("NYI")
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Create(ctx context.Context, in *apipolicyv1.PodDisruptionBudget, opts metav1.CreateOptions) (*apipolicyv1.PodDisruptionBudget, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1",
		Kind:    "PodDisruptionBudget",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apipolicyv1.PodDisruptionBudget, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apipolicyv1.PodDisruptionBudgetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1.PodDisruptionBudgetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apipolicyv1.PodDisruptionBudget, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Update(ctx context.Context, in *apipolicyv1.PodDisruptionBudget, opts metav1.UpdateOptions) (*apipolicyv1.PodDisruptionBudget, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1",
		Kind:    "PodDisruptionBudget",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) UpdateStatus(ctx context.Context, in *apipolicyv1.PodDisruptionBudget, opts metav1.UpdateOptions) (*apipolicyv1.PodDisruptionBudget, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1",
		Kind:    "PodDisruptionBudget",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1PodDisruptionBudgetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// PolicyV1beta1 retrieves the PolicyV1beta1Client
func (w *wrapClient) PolicyV1beta1() typedpolicyv1beta1.PolicyV1beta1Interface {
	return &wrapPolicyV1beta1{
		dyn: w.dyn,
	}
}

type wrapPolicyV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapPolicyV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapPolicyV1beta1) Evictions(namespace string) typedpolicyv1beta1.EvictionInterface {
	return &wrapPolicyV1beta1EvictionImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy",
			Version:  "v1beta1",
			Resource: "evictions",
		}),

		namespace: namespace,
	}
}

type wrapPolicyV1beta1EvictionImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedpolicyv1beta1.EvictionInterface = (*wrapPolicyV1beta1EvictionImpl)(nil)

func (w *wrapPolicyV1beta1) PodDisruptionBudgets(namespace string) typedpolicyv1beta1.PodDisruptionBudgetInterface {
	return &wrapPolicyV1beta1PodDisruptionBudgetImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy",
			Version:  "v1beta1",
			Resource: "poddisruptionbudgets",
		}),

		namespace: namespace,
	}
}

type wrapPolicyV1beta1PodDisruptionBudgetImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedpolicyv1beta1.PodDisruptionBudgetInterface = (*wrapPolicyV1beta1PodDisruptionBudgetImpl)(nil)

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Apply(ctx context.Context, in *policyv1beta1.PodDisruptionBudgetApplyConfiguration, opts metav1.ApplyOptions) (result *apipolicyv1beta1.PodDisruptionBudget, err error) {
	panic("NYI")
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) ApplyStatus(ctx context.Context, in *policyv1beta1.PodDisruptionBudgetApplyConfiguration, opts metav1.ApplyOptions) (result *apipolicyv1beta1.PodDisruptionBudget, err error) {
	panic("NYI")
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Create(ctx context.Context, in *apipolicyv1beta1.PodDisruptionBudget, opts metav1.CreateOptions) (*apipolicyv1beta1.PodDisruptionBudget, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1beta1",
		Kind:    "PodDisruptionBudget",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apipolicyv1beta1.PodDisruptionBudget, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) List(ctx context.Context, opts metav1.ListOptions) (*apipolicyv1beta1.PodDisruptionBudgetList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodDisruptionBudgetList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apipolicyv1beta1.PodDisruptionBudget, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Update(ctx context.Context, in *apipolicyv1beta1.PodDisruptionBudget, opts metav1.UpdateOptions) (*apipolicyv1beta1.PodDisruptionBudget, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1beta1",
		Kind:    "PodDisruptionBudget",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) UpdateStatus(ctx context.Context, in *apipolicyv1beta1.PodDisruptionBudget, opts metav1.UpdateOptions) (*apipolicyv1beta1.PodDisruptionBudget, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1beta1",
		Kind:    "PodDisruptionBudget",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodDisruptionBudget{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodDisruptionBudgetImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapPolicyV1beta1) PodSecurityPolicies() typedpolicyv1beta1.PodSecurityPolicyInterface {
	return &wrapPolicyV1beta1PodSecurityPolicyImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy",
			Version:  "v1beta1",
			Resource: "podsecuritypolicies",
		}),
	}
}

type wrapPolicyV1beta1PodSecurityPolicyImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedpolicyv1beta1.PodSecurityPolicyInterface = (*wrapPolicyV1beta1PodSecurityPolicyImpl)(nil)

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Apply(ctx context.Context, in *policyv1beta1.PodSecurityPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apipolicyv1beta1.PodSecurityPolicy, err error) {
	panic("NYI")
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) ApplyStatus(ctx context.Context, in *policyv1beta1.PodSecurityPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apipolicyv1beta1.PodSecurityPolicy, err error) {
	panic("NYI")
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Create(ctx context.Context, in *apipolicyv1beta1.PodSecurityPolicy, opts metav1.CreateOptions) (*apipolicyv1beta1.PodSecurityPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1beta1",
		Kind:    "PodSecurityPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apipolicyv1beta1.PodSecurityPolicy, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) List(ctx context.Context, opts metav1.ListOptions) (*apipolicyv1beta1.PodSecurityPolicyList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodSecurityPolicyList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apipolicyv1beta1.PodSecurityPolicy, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Update(ctx context.Context, in *apipolicyv1beta1.PodSecurityPolicy, opts metav1.UpdateOptions) (*apipolicyv1beta1.PodSecurityPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1beta1",
		Kind:    "PodSecurityPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) UpdateStatus(ctx context.Context, in *apipolicyv1beta1.PodSecurityPolicy, opts metav1.UpdateOptions) (*apipolicyv1beta1.PodSecurityPolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy",
		Version: "v1beta1",
		Kind:    "PodSecurityPolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apipolicyv1beta1.PodSecurityPolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1PodSecurityPolicyImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// RbacV1 retrieves the RbacV1Client
func (w *wrapClient) RbacV1() typedrbacv1.RbacV1Interface {
	return &wrapRbacV1{
		dyn: w.dyn,
	}
}

type wrapRbacV1 struct {
	dyn dynamic.Interface
}

func (w *wrapRbacV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapRbacV1) ClusterRoles() typedrbacv1.ClusterRoleInterface {
	return &wrapRbacV1ClusterRoleImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1",
			Resource: "clusterroles",
		}),
	}
}

type wrapRbacV1ClusterRoleImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedrbacv1.ClusterRoleInterface = (*wrapRbacV1ClusterRoleImpl)(nil)

func (w *wrapRbacV1ClusterRoleImpl) Apply(ctx context.Context, in *rbacv1.ClusterRoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.ClusterRole, err error) {
	panic("NYI")
}

func (w *wrapRbacV1ClusterRoleImpl) ApplyStatus(ctx context.Context, in *rbacv1.ClusterRoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.ClusterRole, err error) {
	panic("NYI")
}

func (w *wrapRbacV1ClusterRoleImpl) Create(ctx context.Context, in *apirbacv1.ClusterRole, opts metav1.CreateOptions) (*apirbacv1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapRbacV1ClusterRoleImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1ClusterRoleImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1.ClusterRole, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1.ClusterRoleList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1.ClusterRole, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleImpl) Update(ctx context.Context, in *apirbacv1.ClusterRole, opts metav1.UpdateOptions) (*apirbacv1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleImpl) UpdateStatus(ctx context.Context, in *apirbacv1.ClusterRole, opts metav1.UpdateOptions) (*apirbacv1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1) ClusterRoleBindings() typedrbacv1.ClusterRoleBindingInterface {
	return &wrapRbacV1ClusterRoleBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1",
			Resource: "clusterrolebindings",
		}),
	}
}

type wrapRbacV1ClusterRoleBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedrbacv1.ClusterRoleBindingInterface = (*wrapRbacV1ClusterRoleBindingImpl)(nil)

func (w *wrapRbacV1ClusterRoleBindingImpl) Apply(ctx context.Context, in *rbacv1.ClusterRoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.ClusterRoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1ClusterRoleBindingImpl) ApplyStatus(ctx context.Context, in *rbacv1.ClusterRoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.ClusterRoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1ClusterRoleBindingImpl) Create(ctx context.Context, in *apirbacv1.ClusterRoleBinding, opts metav1.CreateOptions) (*apirbacv1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleBindingImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapRbacV1ClusterRoleBindingImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1ClusterRoleBindingImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1.ClusterRoleBinding, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleBindingImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1.ClusterRoleBindingList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1.ClusterRoleBinding, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleBindingImpl) Update(ctx context.Context, in *apirbacv1.ClusterRoleBinding, opts metav1.UpdateOptions) (*apirbacv1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleBindingImpl) UpdateStatus(ctx context.Context, in *apirbacv1.ClusterRoleBinding, opts metav1.UpdateOptions) (*apirbacv1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1ClusterRoleBindingImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1) Roles(namespace string) typedrbacv1.RoleInterface {
	return &wrapRbacV1RoleImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1",
			Resource: "roles",
		}),

		namespace: namespace,
	}
}

type wrapRbacV1RoleImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedrbacv1.RoleInterface = (*wrapRbacV1RoleImpl)(nil)

func (w *wrapRbacV1RoleImpl) Apply(ctx context.Context, in *rbacv1.RoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.Role, err error) {
	panic("NYI")
}

func (w *wrapRbacV1RoleImpl) ApplyStatus(ctx context.Context, in *rbacv1.RoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.Role, err error) {
	panic("NYI")
}

func (w *wrapRbacV1RoleImpl) Create(ctx context.Context, in *apirbacv1.Role, opts metav1.CreateOptions) (*apirbacv1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapRbacV1RoleImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1RoleImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1.Role, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1.RoleList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1.Role, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleImpl) Update(ctx context.Context, in *apirbacv1.Role, opts metav1.UpdateOptions) (*apirbacv1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleImpl) UpdateStatus(ctx context.Context, in *apirbacv1.Role, opts metav1.UpdateOptions) (*apirbacv1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1) RoleBindings(namespace string) typedrbacv1.RoleBindingInterface {
	return &wrapRbacV1RoleBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1",
			Resource: "rolebindings",
		}),

		namespace: namespace,
	}
}

type wrapRbacV1RoleBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedrbacv1.RoleBindingInterface = (*wrapRbacV1RoleBindingImpl)(nil)

func (w *wrapRbacV1RoleBindingImpl) Apply(ctx context.Context, in *rbacv1.RoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.RoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1RoleBindingImpl) ApplyStatus(ctx context.Context, in *rbacv1.RoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1.RoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1RoleBindingImpl) Create(ctx context.Context, in *apirbacv1.RoleBinding, opts metav1.CreateOptions) (*apirbacv1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleBindingImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapRbacV1RoleBindingImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1RoleBindingImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1.RoleBinding, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleBindingImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1.RoleBindingList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1.RoleBinding, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleBindingImpl) Update(ctx context.Context, in *apirbacv1.RoleBinding, opts metav1.UpdateOptions) (*apirbacv1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleBindingImpl) UpdateStatus(ctx context.Context, in *apirbacv1.RoleBinding, opts metav1.UpdateOptions) (*apirbacv1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1RoleBindingImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// RbacV1alpha1 retrieves the RbacV1alpha1Client
func (w *wrapClient) RbacV1alpha1() typedrbacv1alpha1.RbacV1alpha1Interface {
	return &wrapRbacV1alpha1{
		dyn: w.dyn,
	}
}

type wrapRbacV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapRbacV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapRbacV1alpha1) ClusterRoles() typedrbacv1alpha1.ClusterRoleInterface {
	return &wrapRbacV1alpha1ClusterRoleImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1alpha1",
			Resource: "clusterroles",
		}),
	}
}

type wrapRbacV1alpha1ClusterRoleImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedrbacv1alpha1.ClusterRoleInterface = (*wrapRbacV1alpha1ClusterRoleImpl)(nil)

func (w *wrapRbacV1alpha1ClusterRoleImpl) Apply(ctx context.Context, in *rbacv1alpha1.ClusterRoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.ClusterRole, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) ApplyStatus(ctx context.Context, in *rbacv1alpha1.ClusterRoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.ClusterRole, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) Create(ctx context.Context, in *apirbacv1alpha1.ClusterRole, opts metav1.CreateOptions) (*apirbacv1alpha1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1alpha1.ClusterRole, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1alpha1.ClusterRoleList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1alpha1.ClusterRole, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) Update(ctx context.Context, in *apirbacv1alpha1.ClusterRole, opts metav1.UpdateOptions) (*apirbacv1alpha1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) UpdateStatus(ctx context.Context, in *apirbacv1alpha1.ClusterRole, opts metav1.UpdateOptions) (*apirbacv1alpha1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1alpha1) ClusterRoleBindings() typedrbacv1alpha1.ClusterRoleBindingInterface {
	return &wrapRbacV1alpha1ClusterRoleBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1alpha1",
			Resource: "clusterrolebindings",
		}),
	}
}

type wrapRbacV1alpha1ClusterRoleBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedrbacv1alpha1.ClusterRoleBindingInterface = (*wrapRbacV1alpha1ClusterRoleBindingImpl)(nil)

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Apply(ctx context.Context, in *rbacv1alpha1.ClusterRoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.ClusterRoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) ApplyStatus(ctx context.Context, in *rbacv1alpha1.ClusterRoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.ClusterRoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Create(ctx context.Context, in *apirbacv1alpha1.ClusterRoleBinding, opts metav1.CreateOptions) (*apirbacv1alpha1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1alpha1.ClusterRoleBinding, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1alpha1.ClusterRoleBindingList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1alpha1.ClusterRoleBinding, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Update(ctx context.Context, in *apirbacv1alpha1.ClusterRoleBinding, opts metav1.UpdateOptions) (*apirbacv1alpha1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) UpdateStatus(ctx context.Context, in *apirbacv1alpha1.ClusterRoleBinding, opts metav1.UpdateOptions) (*apirbacv1alpha1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1ClusterRoleBindingImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1alpha1) Roles(namespace string) typedrbacv1alpha1.RoleInterface {
	return &wrapRbacV1alpha1RoleImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1alpha1",
			Resource: "roles",
		}),

		namespace: namespace,
	}
}

type wrapRbacV1alpha1RoleImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedrbacv1alpha1.RoleInterface = (*wrapRbacV1alpha1RoleImpl)(nil)

func (w *wrapRbacV1alpha1RoleImpl) Apply(ctx context.Context, in *rbacv1alpha1.RoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.Role, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1RoleImpl) ApplyStatus(ctx context.Context, in *rbacv1alpha1.RoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.Role, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1RoleImpl) Create(ctx context.Context, in *apirbacv1alpha1.Role, opts metav1.CreateOptions) (*apirbacv1alpha1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapRbacV1alpha1RoleImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1alpha1RoleImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1alpha1.Role, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1alpha1.RoleList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1alpha1.Role, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleImpl) Update(ctx context.Context, in *apirbacv1alpha1.Role, opts metav1.UpdateOptions) (*apirbacv1alpha1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleImpl) UpdateStatus(ctx context.Context, in *apirbacv1alpha1.Role, opts metav1.UpdateOptions) (*apirbacv1alpha1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1alpha1) RoleBindings(namespace string) typedrbacv1alpha1.RoleBindingInterface {
	return &wrapRbacV1alpha1RoleBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1alpha1",
			Resource: "rolebindings",
		}),

		namespace: namespace,
	}
}

type wrapRbacV1alpha1RoleBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedrbacv1alpha1.RoleBindingInterface = (*wrapRbacV1alpha1RoleBindingImpl)(nil)

func (w *wrapRbacV1alpha1RoleBindingImpl) Apply(ctx context.Context, in *rbacv1alpha1.RoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.RoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1RoleBindingImpl) ApplyStatus(ctx context.Context, in *rbacv1alpha1.RoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1alpha1.RoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1alpha1RoleBindingImpl) Create(ctx context.Context, in *apirbacv1alpha1.RoleBinding, opts metav1.CreateOptions) (*apirbacv1alpha1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleBindingImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapRbacV1alpha1RoleBindingImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1alpha1RoleBindingImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1alpha1.RoleBinding, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleBindingImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1alpha1.RoleBindingList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1alpha1.RoleBinding, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleBindingImpl) Update(ctx context.Context, in *apirbacv1alpha1.RoleBinding, opts metav1.UpdateOptions) (*apirbacv1alpha1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleBindingImpl) UpdateStatus(ctx context.Context, in *apirbacv1alpha1.RoleBinding, opts metav1.UpdateOptions) (*apirbacv1alpha1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1alpha1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1alpha1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1alpha1RoleBindingImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// RbacV1beta1 retrieves the RbacV1beta1Client
func (w *wrapClient) RbacV1beta1() typedrbacv1beta1.RbacV1beta1Interface {
	return &wrapRbacV1beta1{
		dyn: w.dyn,
	}
}

type wrapRbacV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapRbacV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapRbacV1beta1) ClusterRoles() typedrbacv1beta1.ClusterRoleInterface {
	return &wrapRbacV1beta1ClusterRoleImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "clusterroles",
		}),
	}
}

type wrapRbacV1beta1ClusterRoleImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedrbacv1beta1.ClusterRoleInterface = (*wrapRbacV1beta1ClusterRoleImpl)(nil)

func (w *wrapRbacV1beta1ClusterRoleImpl) Apply(ctx context.Context, in *rbacv1beta1.ClusterRoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.ClusterRole, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1ClusterRoleImpl) ApplyStatus(ctx context.Context, in *rbacv1beta1.ClusterRoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.ClusterRole, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1ClusterRoleImpl) Create(ctx context.Context, in *apirbacv1beta1.ClusterRole, opts metav1.CreateOptions) (*apirbacv1beta1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapRbacV1beta1ClusterRoleImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1beta1ClusterRoleImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1beta1.ClusterRole, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1beta1.ClusterRoleList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1beta1.ClusterRole, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleImpl) Update(ctx context.Context, in *apirbacv1beta1.ClusterRole, opts metav1.UpdateOptions) (*apirbacv1beta1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleImpl) UpdateStatus(ctx context.Context, in *apirbacv1beta1.ClusterRole, opts metav1.UpdateOptions) (*apirbacv1beta1.ClusterRole, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "ClusterRole",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRole{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1beta1) ClusterRoleBindings() typedrbacv1beta1.ClusterRoleBindingInterface {
	return &wrapRbacV1beta1ClusterRoleBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "clusterrolebindings",
		}),
	}
}

type wrapRbacV1beta1ClusterRoleBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedrbacv1beta1.ClusterRoleBindingInterface = (*wrapRbacV1beta1ClusterRoleBindingImpl)(nil)

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Apply(ctx context.Context, in *rbacv1beta1.ClusterRoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.ClusterRoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) ApplyStatus(ctx context.Context, in *rbacv1beta1.ClusterRoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.ClusterRoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Create(ctx context.Context, in *apirbacv1beta1.ClusterRoleBinding, opts metav1.CreateOptions) (*apirbacv1beta1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1beta1.ClusterRoleBinding, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1beta1.ClusterRoleBindingList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1beta1.ClusterRoleBinding, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Update(ctx context.Context, in *apirbacv1beta1.ClusterRoleBinding, opts metav1.UpdateOptions) (*apirbacv1beta1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) UpdateStatus(ctx context.Context, in *apirbacv1beta1.ClusterRoleBinding, opts metav1.UpdateOptions) (*apirbacv1beta1.ClusterRoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "ClusterRoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.ClusterRoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1ClusterRoleBindingImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1beta1) Roles(namespace string) typedrbacv1beta1.RoleInterface {
	return &wrapRbacV1beta1RoleImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "roles",
		}),

		namespace: namespace,
	}
}

type wrapRbacV1beta1RoleImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedrbacv1beta1.RoleInterface = (*wrapRbacV1beta1RoleImpl)(nil)

func (w *wrapRbacV1beta1RoleImpl) Apply(ctx context.Context, in *rbacv1beta1.RoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.Role, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1RoleImpl) ApplyStatus(ctx context.Context, in *rbacv1beta1.RoleApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.Role, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1RoleImpl) Create(ctx context.Context, in *apirbacv1beta1.Role, opts metav1.CreateOptions) (*apirbacv1beta1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapRbacV1beta1RoleImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1beta1RoleImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1beta1.Role, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1beta1.RoleList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1beta1.Role, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleImpl) Update(ctx context.Context, in *apirbacv1beta1.Role, opts metav1.UpdateOptions) (*apirbacv1beta1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleImpl) UpdateStatus(ctx context.Context, in *apirbacv1beta1.Role, opts metav1.UpdateOptions) (*apirbacv1beta1.Role, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "Role",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.Role{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapRbacV1beta1) RoleBindings(namespace string) typedrbacv1beta1.RoleBindingInterface {
	return &wrapRbacV1beta1RoleBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "rbac.authorization.k8s.io",
			Version:  "v1beta1",
			Resource: "rolebindings",
		}),

		namespace: namespace,
	}
}

type wrapRbacV1beta1RoleBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedrbacv1beta1.RoleBindingInterface = (*wrapRbacV1beta1RoleBindingImpl)(nil)

func (w *wrapRbacV1beta1RoleBindingImpl) Apply(ctx context.Context, in *rbacv1beta1.RoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.RoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1RoleBindingImpl) ApplyStatus(ctx context.Context, in *rbacv1beta1.RoleBindingApplyConfiguration, opts metav1.ApplyOptions) (result *apirbacv1beta1.RoleBinding, err error) {
	panic("NYI")
}

func (w *wrapRbacV1beta1RoleBindingImpl) Create(ctx context.Context, in *apirbacv1beta1.RoleBinding, opts metav1.CreateOptions) (*apirbacv1beta1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleBindingImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapRbacV1beta1RoleBindingImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapRbacV1beta1RoleBindingImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apirbacv1beta1.RoleBinding, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleBindingImpl) List(ctx context.Context, opts metav1.ListOptions) (*apirbacv1beta1.RoleBindingList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apirbacv1beta1.RoleBinding, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleBindingImpl) Update(ctx context.Context, in *apirbacv1beta1.RoleBinding, opts metav1.UpdateOptions) (*apirbacv1beta1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleBindingImpl) UpdateStatus(ctx context.Context, in *apirbacv1beta1.RoleBinding, opts metav1.UpdateOptions) (*apirbacv1beta1.RoleBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "rbac.authorization.k8s.io",
		Version: "v1beta1",
		Kind:    "RoleBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apirbacv1beta1.RoleBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapRbacV1beta1RoleBindingImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// SchedulingV1 retrieves the SchedulingV1Client
func (w *wrapClient) SchedulingV1() typedschedulingv1.SchedulingV1Interface {
	return &wrapSchedulingV1{
		dyn: w.dyn,
	}
}

type wrapSchedulingV1 struct {
	dyn dynamic.Interface
}

func (w *wrapSchedulingV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapSchedulingV1) PriorityClasses() typedschedulingv1.PriorityClassInterface {
	return &wrapSchedulingV1PriorityClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "scheduling.k8s.io",
			Version:  "v1",
			Resource: "priorityclasses",
		}),
	}
}

type wrapSchedulingV1PriorityClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedschedulingv1.PriorityClassInterface = (*wrapSchedulingV1PriorityClassImpl)(nil)

func (w *wrapSchedulingV1PriorityClassImpl) Apply(ctx context.Context, in *schedulingv1.PriorityClassApplyConfiguration, opts metav1.ApplyOptions) (result *apischedulingv1.PriorityClass, err error) {
	panic("NYI")
}

func (w *wrapSchedulingV1PriorityClassImpl) ApplyStatus(ctx context.Context, in *schedulingv1.PriorityClassApplyConfiguration, opts metav1.ApplyOptions) (result *apischedulingv1.PriorityClass, err error) {
	panic("NYI")
}

func (w *wrapSchedulingV1PriorityClassImpl) Create(ctx context.Context, in *apischedulingv1.PriorityClass, opts metav1.CreateOptions) (*apischedulingv1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1PriorityClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapSchedulingV1PriorityClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapSchedulingV1PriorityClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apischedulingv1.PriorityClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1PriorityClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apischedulingv1.PriorityClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1.PriorityClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1PriorityClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apischedulingv1.PriorityClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1PriorityClassImpl) Update(ctx context.Context, in *apischedulingv1.PriorityClass, opts metav1.UpdateOptions) (*apischedulingv1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1PriorityClassImpl) UpdateStatus(ctx context.Context, in *apischedulingv1.PriorityClass, opts metav1.UpdateOptions) (*apischedulingv1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1PriorityClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// SchedulingV1alpha1 retrieves the SchedulingV1alpha1Client
func (w *wrapClient) SchedulingV1alpha1() typedschedulingv1alpha1.SchedulingV1alpha1Interface {
	return &wrapSchedulingV1alpha1{
		dyn: w.dyn,
	}
}

type wrapSchedulingV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapSchedulingV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapSchedulingV1alpha1) PriorityClasses() typedschedulingv1alpha1.PriorityClassInterface {
	return &wrapSchedulingV1alpha1PriorityClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "scheduling.k8s.io",
			Version:  "v1alpha1",
			Resource: "priorityclasses",
		}),
	}
}

type wrapSchedulingV1alpha1PriorityClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedschedulingv1alpha1.PriorityClassInterface = (*wrapSchedulingV1alpha1PriorityClassImpl)(nil)

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Apply(ctx context.Context, in *schedulingv1alpha1.PriorityClassApplyConfiguration, opts metav1.ApplyOptions) (result *apischedulingv1alpha1.PriorityClass, err error) {
	panic("NYI")
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) ApplyStatus(ctx context.Context, in *schedulingv1alpha1.PriorityClassApplyConfiguration, opts metav1.ApplyOptions) (result *apischedulingv1alpha1.PriorityClass, err error) {
	panic("NYI")
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Create(ctx context.Context, in *apischedulingv1alpha1.PriorityClass, opts metav1.CreateOptions) (*apischedulingv1alpha1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1alpha1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1alpha1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apischedulingv1alpha1.PriorityClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1alpha1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apischedulingv1alpha1.PriorityClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1alpha1.PriorityClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apischedulingv1alpha1.PriorityClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1alpha1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Update(ctx context.Context, in *apischedulingv1alpha1.PriorityClass, opts metav1.UpdateOptions) (*apischedulingv1alpha1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1alpha1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1alpha1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) UpdateStatus(ctx context.Context, in *apischedulingv1alpha1.PriorityClass, opts metav1.UpdateOptions) (*apischedulingv1alpha1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1alpha1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1alpha1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1alpha1PriorityClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// SchedulingV1beta1 retrieves the SchedulingV1beta1Client
func (w *wrapClient) SchedulingV1beta1() typedschedulingv1beta1.SchedulingV1beta1Interface {
	return &wrapSchedulingV1beta1{
		dyn: w.dyn,
	}
}

type wrapSchedulingV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapSchedulingV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapSchedulingV1beta1) PriorityClasses() typedschedulingv1beta1.PriorityClassInterface {
	return &wrapSchedulingV1beta1PriorityClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "scheduling.k8s.io",
			Version:  "v1beta1",
			Resource: "priorityclasses",
		}),
	}
}

type wrapSchedulingV1beta1PriorityClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedschedulingv1beta1.PriorityClassInterface = (*wrapSchedulingV1beta1PriorityClassImpl)(nil)

func (w *wrapSchedulingV1beta1PriorityClassImpl) Apply(ctx context.Context, in *schedulingv1beta1.PriorityClassApplyConfiguration, opts metav1.ApplyOptions) (result *apischedulingv1beta1.PriorityClass, err error) {
	panic("NYI")
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) ApplyStatus(ctx context.Context, in *schedulingv1beta1.PriorityClassApplyConfiguration, opts metav1.ApplyOptions) (result *apischedulingv1beta1.PriorityClass, err error) {
	panic("NYI")
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) Create(ctx context.Context, in *apischedulingv1beta1.PriorityClass, opts metav1.CreateOptions) (*apischedulingv1beta1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1beta1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1beta1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apischedulingv1beta1.PriorityClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1beta1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apischedulingv1beta1.PriorityClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1beta1.PriorityClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apischedulingv1beta1.PriorityClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1beta1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) Update(ctx context.Context, in *apischedulingv1beta1.PriorityClass, opts metav1.UpdateOptions) (*apischedulingv1beta1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1beta1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1beta1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) UpdateStatus(ctx context.Context, in *apischedulingv1beta1.PriorityClass, opts metav1.UpdateOptions) (*apischedulingv1beta1.PriorityClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "scheduling.k8s.io",
		Version: "v1beta1",
		Kind:    "PriorityClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apischedulingv1beta1.PriorityClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapSchedulingV1beta1PriorityClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// StorageV1 retrieves the StorageV1Client
func (w *wrapClient) StorageV1() typedstoragev1.StorageV1Interface {
	return &wrapStorageV1{
		dyn: w.dyn,
	}
}

type wrapStorageV1 struct {
	dyn dynamic.Interface
}

func (w *wrapStorageV1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapStorageV1) CSIDrivers() typedstoragev1.CSIDriverInterface {
	return &wrapStorageV1CSIDriverImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1",
			Resource: "csidrivers",
		}),
	}
}

type wrapStorageV1CSIDriverImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1.CSIDriverInterface = (*wrapStorageV1CSIDriverImpl)(nil)

func (w *wrapStorageV1CSIDriverImpl) Apply(ctx context.Context, in *storagev1.CSIDriverApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.CSIDriver, err error) {
	panic("NYI")
}

func (w *wrapStorageV1CSIDriverImpl) ApplyStatus(ctx context.Context, in *storagev1.CSIDriverApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.CSIDriver, err error) {
	panic("NYI")
}

func (w *wrapStorageV1CSIDriverImpl) Create(ctx context.Context, in *apistoragev1.CSIDriver, opts metav1.CreateOptions) (*apistoragev1.CSIDriver, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "CSIDriver",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSIDriverImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1CSIDriverImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1CSIDriverImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1.CSIDriver, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSIDriverImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1.CSIDriverList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSIDriverList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSIDriverImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1.CSIDriver, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSIDriverImpl) Update(ctx context.Context, in *apistoragev1.CSIDriver, opts metav1.UpdateOptions) (*apistoragev1.CSIDriver, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "CSIDriver",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSIDriverImpl) UpdateStatus(ctx context.Context, in *apistoragev1.CSIDriver, opts metav1.UpdateOptions) (*apistoragev1.CSIDriver, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "CSIDriver",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSIDriverImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1) CSINodes() typedstoragev1.CSINodeInterface {
	return &wrapStorageV1CSINodeImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1",
			Resource: "csinodes",
		}),
	}
}

type wrapStorageV1CSINodeImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1.CSINodeInterface = (*wrapStorageV1CSINodeImpl)(nil)

func (w *wrapStorageV1CSINodeImpl) Apply(ctx context.Context, in *storagev1.CSINodeApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.CSINode, err error) {
	panic("NYI")
}

func (w *wrapStorageV1CSINodeImpl) ApplyStatus(ctx context.Context, in *storagev1.CSINodeApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.CSINode, err error) {
	panic("NYI")
}

func (w *wrapStorageV1CSINodeImpl) Create(ctx context.Context, in *apistoragev1.CSINode, opts metav1.CreateOptions) (*apistoragev1.CSINode, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "CSINode",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSINodeImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1CSINodeImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1CSINodeImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1.CSINode, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSINodeImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1.CSINodeList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSINodeList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSINodeImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1.CSINode, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSINodeImpl) Update(ctx context.Context, in *apistoragev1.CSINode, opts metav1.UpdateOptions) (*apistoragev1.CSINode, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "CSINode",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSINodeImpl) UpdateStatus(ctx context.Context, in *apistoragev1.CSINode, opts metav1.UpdateOptions) (*apistoragev1.CSINode, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "CSINode",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1CSINodeImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1) StorageClasses() typedstoragev1.StorageClassInterface {
	return &wrapStorageV1StorageClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1",
			Resource: "storageclasses",
		}),
	}
}

type wrapStorageV1StorageClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1.StorageClassInterface = (*wrapStorageV1StorageClassImpl)(nil)

func (w *wrapStorageV1StorageClassImpl) Apply(ctx context.Context, in *storagev1.StorageClassApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.StorageClass, err error) {
	panic("NYI")
}

func (w *wrapStorageV1StorageClassImpl) ApplyStatus(ctx context.Context, in *storagev1.StorageClassApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.StorageClass, err error) {
	panic("NYI")
}

func (w *wrapStorageV1StorageClassImpl) Create(ctx context.Context, in *apistoragev1.StorageClass, opts metav1.CreateOptions) (*apistoragev1.StorageClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "StorageClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1StorageClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1StorageClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1StorageClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1.StorageClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1StorageClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1.StorageClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.StorageClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1StorageClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1.StorageClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1StorageClassImpl) Update(ctx context.Context, in *apistoragev1.StorageClass, opts metav1.UpdateOptions) (*apistoragev1.StorageClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "StorageClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1StorageClassImpl) UpdateStatus(ctx context.Context, in *apistoragev1.StorageClass, opts metav1.UpdateOptions) (*apistoragev1.StorageClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "StorageClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1StorageClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1) VolumeAttachments() typedstoragev1.VolumeAttachmentInterface {
	return &wrapStorageV1VolumeAttachmentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1",
			Resource: "volumeattachments",
		}),
	}
}

type wrapStorageV1VolumeAttachmentImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1.VolumeAttachmentInterface = (*wrapStorageV1VolumeAttachmentImpl)(nil)

func (w *wrapStorageV1VolumeAttachmentImpl) Apply(ctx context.Context, in *storagev1.VolumeAttachmentApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.VolumeAttachment, err error) {
	panic("NYI")
}

func (w *wrapStorageV1VolumeAttachmentImpl) ApplyStatus(ctx context.Context, in *storagev1.VolumeAttachmentApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1.VolumeAttachment, err error) {
	panic("NYI")
}

func (w *wrapStorageV1VolumeAttachmentImpl) Create(ctx context.Context, in *apistoragev1.VolumeAttachment, opts metav1.CreateOptions) (*apistoragev1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1VolumeAttachmentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1VolumeAttachmentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1VolumeAttachmentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1.VolumeAttachment, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1VolumeAttachmentImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1.VolumeAttachmentList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.VolumeAttachmentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1VolumeAttachmentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1.VolumeAttachment, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1VolumeAttachmentImpl) Update(ctx context.Context, in *apistoragev1.VolumeAttachment, opts metav1.UpdateOptions) (*apistoragev1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1VolumeAttachmentImpl) UpdateStatus(ctx context.Context, in *apistoragev1.VolumeAttachment, opts metav1.UpdateOptions) (*apistoragev1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1VolumeAttachmentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// StorageV1alpha1 retrieves the StorageV1alpha1Client
func (w *wrapClient) StorageV1alpha1() typedstoragev1alpha1.StorageV1alpha1Interface {
	return &wrapStorageV1alpha1{
		dyn: w.dyn,
	}
}

type wrapStorageV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapStorageV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapStorageV1alpha1) CSIStorageCapacities(namespace string) typedstoragev1alpha1.CSIStorageCapacityInterface {
	return &wrapStorageV1alpha1CSIStorageCapacityImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1alpha1",
			Resource: "csistoragecapacities",
		}),

		namespace: namespace,
	}
}

type wrapStorageV1alpha1CSIStorageCapacityImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedstoragev1alpha1.CSIStorageCapacityInterface = (*wrapStorageV1alpha1CSIStorageCapacityImpl)(nil)

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Apply(ctx context.Context, in *storagev1alpha1.CSIStorageCapacityApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1alpha1.CSIStorageCapacity, err error) {
	panic("NYI")
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) ApplyStatus(ctx context.Context, in *storagev1alpha1.CSIStorageCapacityApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1alpha1.CSIStorageCapacity, err error) {
	panic("NYI")
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Create(ctx context.Context, in *apistoragev1alpha1.CSIStorageCapacity, opts metav1.CreateOptions) (*apistoragev1alpha1.CSIStorageCapacity, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1alpha1",
		Kind:    "CSIStorageCapacity",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1alpha1.CSIStorageCapacity, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1alpha1.CSIStorageCapacityList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.CSIStorageCapacityList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1alpha1.CSIStorageCapacity, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Update(ctx context.Context, in *apistoragev1alpha1.CSIStorageCapacity, opts metav1.UpdateOptions) (*apistoragev1alpha1.CSIStorageCapacity, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1alpha1",
		Kind:    "CSIStorageCapacity",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) UpdateStatus(ctx context.Context, in *apistoragev1alpha1.CSIStorageCapacity, opts metav1.UpdateOptions) (*apistoragev1alpha1.CSIStorageCapacity, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1alpha1",
		Kind:    "CSIStorageCapacity",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1CSIStorageCapacityImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1alpha1) VolumeAttachments() typedstoragev1alpha1.VolumeAttachmentInterface {
	return &wrapStorageV1alpha1VolumeAttachmentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1alpha1",
			Resource: "volumeattachments",
		}),
	}
}

type wrapStorageV1alpha1VolumeAttachmentImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1alpha1.VolumeAttachmentInterface = (*wrapStorageV1alpha1VolumeAttachmentImpl)(nil)

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Apply(ctx context.Context, in *storagev1alpha1.VolumeAttachmentApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1alpha1.VolumeAttachment, err error) {
	panic("NYI")
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) ApplyStatus(ctx context.Context, in *storagev1alpha1.VolumeAttachmentApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1alpha1.VolumeAttachment, err error) {
	panic("NYI")
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Create(ctx context.Context, in *apistoragev1alpha1.VolumeAttachment, opts metav1.CreateOptions) (*apistoragev1alpha1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1alpha1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1alpha1.VolumeAttachment, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1alpha1.VolumeAttachmentList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.VolumeAttachmentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1alpha1.VolumeAttachment, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Update(ctx context.Context, in *apistoragev1alpha1.VolumeAttachment, opts metav1.UpdateOptions) (*apistoragev1alpha1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1alpha1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) UpdateStatus(ctx context.Context, in *apistoragev1alpha1.VolumeAttachment, opts metav1.UpdateOptions) (*apistoragev1alpha1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1alpha1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1alpha1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1alpha1VolumeAttachmentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// StorageV1beta1 retrieves the StorageV1beta1Client
func (w *wrapClient) StorageV1beta1() typedstoragev1beta1.StorageV1beta1Interface {
	return &wrapStorageV1beta1{
		dyn: w.dyn,
	}
}

type wrapStorageV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapStorageV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapStorageV1beta1) CSIDrivers() typedstoragev1beta1.CSIDriverInterface {
	return &wrapStorageV1beta1CSIDriverImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1beta1",
			Resource: "csidrivers",
		}),
	}
}

type wrapStorageV1beta1CSIDriverImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1beta1.CSIDriverInterface = (*wrapStorageV1beta1CSIDriverImpl)(nil)

func (w *wrapStorageV1beta1CSIDriverImpl) Apply(ctx context.Context, in *storagev1beta1.CSIDriverApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.CSIDriver, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1CSIDriverImpl) ApplyStatus(ctx context.Context, in *storagev1beta1.CSIDriverApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.CSIDriver, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1CSIDriverImpl) Create(ctx context.Context, in *apistoragev1beta1.CSIDriver, opts metav1.CreateOptions) (*apistoragev1beta1.CSIDriver, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSIDriver",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIDriverImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1beta1CSIDriverImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1beta1CSIDriverImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1beta1.CSIDriver, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIDriverImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1beta1.CSIDriverList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIDriverList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIDriverImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1beta1.CSIDriver, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIDriverImpl) Update(ctx context.Context, in *apistoragev1beta1.CSIDriver, opts metav1.UpdateOptions) (*apistoragev1beta1.CSIDriver, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSIDriver",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIDriverImpl) UpdateStatus(ctx context.Context, in *apistoragev1beta1.CSIDriver, opts metav1.UpdateOptions) (*apistoragev1beta1.CSIDriver, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSIDriver",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIDriver{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIDriverImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1beta1) CSINodes() typedstoragev1beta1.CSINodeInterface {
	return &wrapStorageV1beta1CSINodeImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1beta1",
			Resource: "csinodes",
		}),
	}
}

type wrapStorageV1beta1CSINodeImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1beta1.CSINodeInterface = (*wrapStorageV1beta1CSINodeImpl)(nil)

func (w *wrapStorageV1beta1CSINodeImpl) Apply(ctx context.Context, in *storagev1beta1.CSINodeApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.CSINode, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1CSINodeImpl) ApplyStatus(ctx context.Context, in *storagev1beta1.CSINodeApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.CSINode, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1CSINodeImpl) Create(ctx context.Context, in *apistoragev1beta1.CSINode, opts metav1.CreateOptions) (*apistoragev1beta1.CSINode, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSINode",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSINodeImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1beta1CSINodeImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1beta1CSINodeImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1beta1.CSINode, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSINodeImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1beta1.CSINodeList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSINodeList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSINodeImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1beta1.CSINode, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSINodeImpl) Update(ctx context.Context, in *apistoragev1beta1.CSINode, opts metav1.UpdateOptions) (*apistoragev1beta1.CSINode, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSINode",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSINodeImpl) UpdateStatus(ctx context.Context, in *apistoragev1beta1.CSINode, opts metav1.UpdateOptions) (*apistoragev1beta1.CSINode, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSINode",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSINode{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSINodeImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1beta1) CSIStorageCapacities(namespace string) typedstoragev1beta1.CSIStorageCapacityInterface {
	return &wrapStorageV1beta1CSIStorageCapacityImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1beta1",
			Resource: "csistoragecapacities",
		}),

		namespace: namespace,
	}
}

type wrapStorageV1beta1CSIStorageCapacityImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedstoragev1beta1.CSIStorageCapacityInterface = (*wrapStorageV1beta1CSIStorageCapacityImpl)(nil)

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Apply(ctx context.Context, in *storagev1beta1.CSIStorageCapacityApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.CSIStorageCapacity, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) ApplyStatus(ctx context.Context, in *storagev1beta1.CSIStorageCapacityApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.CSIStorageCapacity, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Create(ctx context.Context, in *apistoragev1beta1.CSIStorageCapacity, opts metav1.CreateOptions) (*apistoragev1beta1.CSIStorageCapacity, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSIStorageCapacity",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1beta1.CSIStorageCapacity, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1beta1.CSIStorageCapacityList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIStorageCapacityList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1beta1.CSIStorageCapacity, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Update(ctx context.Context, in *apistoragev1beta1.CSIStorageCapacity, opts metav1.UpdateOptions) (*apistoragev1beta1.CSIStorageCapacity, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSIStorageCapacity",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) UpdateStatus(ctx context.Context, in *apistoragev1beta1.CSIStorageCapacity, opts metav1.UpdateOptions) (*apistoragev1beta1.CSIStorageCapacity, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "CSIStorageCapacity",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.CSIStorageCapacity{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1CSIStorageCapacityImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1beta1) StorageClasses() typedstoragev1beta1.StorageClassInterface {
	return &wrapStorageV1beta1StorageClassImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1beta1",
			Resource: "storageclasses",
		}),
	}
}

type wrapStorageV1beta1StorageClassImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1beta1.StorageClassInterface = (*wrapStorageV1beta1StorageClassImpl)(nil)

func (w *wrapStorageV1beta1StorageClassImpl) Apply(ctx context.Context, in *storagev1beta1.StorageClassApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.StorageClass, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1StorageClassImpl) ApplyStatus(ctx context.Context, in *storagev1beta1.StorageClassApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.StorageClass, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1StorageClassImpl) Create(ctx context.Context, in *apistoragev1beta1.StorageClass, opts metav1.CreateOptions) (*apistoragev1beta1.StorageClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "StorageClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1StorageClassImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1beta1StorageClassImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1beta1StorageClassImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1beta1.StorageClass, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1StorageClassImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1beta1.StorageClassList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.StorageClassList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1StorageClassImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1beta1.StorageClass, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1StorageClassImpl) Update(ctx context.Context, in *apistoragev1beta1.StorageClass, opts metav1.UpdateOptions) (*apistoragev1beta1.StorageClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "StorageClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1StorageClassImpl) UpdateStatus(ctx context.Context, in *apistoragev1beta1.StorageClass, opts metav1.UpdateOptions) (*apistoragev1beta1.StorageClass, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "StorageClass",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.StorageClass{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1StorageClassImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapStorageV1beta1) VolumeAttachments() typedstoragev1beta1.VolumeAttachmentInterface {
	return &wrapStorageV1beta1VolumeAttachmentImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "storage.k8s.io",
			Version:  "v1beta1",
			Resource: "volumeattachments",
		}),
	}
}

type wrapStorageV1beta1VolumeAttachmentImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedstoragev1beta1.VolumeAttachmentInterface = (*wrapStorageV1beta1VolumeAttachmentImpl)(nil)

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Apply(ctx context.Context, in *storagev1beta1.VolumeAttachmentApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.VolumeAttachment, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) ApplyStatus(ctx context.Context, in *storagev1beta1.VolumeAttachmentApplyConfiguration, opts metav1.ApplyOptions) (result *apistoragev1beta1.VolumeAttachment, err error) {
	panic("NYI")
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Create(ctx context.Context, in *apistoragev1beta1.VolumeAttachment, opts metav1.CreateOptions) (*apistoragev1beta1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Get(ctx context.Context, name string, opts metav1.GetOptions) (*apistoragev1beta1.VolumeAttachment, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) List(ctx context.Context, opts metav1.ListOptions) (*apistoragev1beta1.VolumeAttachmentList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.VolumeAttachmentList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apistoragev1beta1.VolumeAttachment, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Update(ctx context.Context, in *apistoragev1beta1.VolumeAttachment, opts metav1.UpdateOptions) (*apistoragev1beta1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) UpdateStatus(ctx context.Context, in *apistoragev1beta1.VolumeAttachment, opts metav1.UpdateOptions) (*apistoragev1beta1.VolumeAttachment, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "storage.k8s.io",
		Version: "v1beta1",
		Kind:    "VolumeAttachment",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &apistoragev1beta1.VolumeAttachment{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapStorageV1beta1VolumeAttachmentImpl) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}
