// Copyright 2021 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: spdx.proto

package spdx_go_proto

import (
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of relationship between the source and target SPDX elements
// RelationshipOccurrence represents an SPDX Relationship section:
// https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
type RelationshipType int32

const (
	// Unspecified
	RelationshipType_RELATIONSHIP_TYPE_UNSPECIFIED RelationshipType = 0
	// Is to be used when SPDXRef-DOCUMENT describes SPDXRef-A
	RelationshipType_DESCRIBES RelationshipType = 1
	// Is to be used when SPDXRef-A is described by SPDXREF-Document
	RelationshipType_DESCRIBED_BY RelationshipType = 2
	// Is to be used when SPDXRef-A contains SPDXRef-B
	RelationshipType_CONTAINS RelationshipType = 3
	// Is to be used when SPDXRef-A is contained by SPDXRef-B
	RelationshipType_CONTAINED_BY RelationshipType = 4
	// Is to be used when SPDXRef-A depends on SPDXRef-B
	RelationshipType_DEPENDS_ON RelationshipType = 5
	// Is to be used when SPDXRef-A is dependency of SPDXRef-B
	RelationshipType_DEPENDENCY_OF RelationshipType = 6
	// Is to be used when SPDXRef-A is a manifest file that lists a set of
	// dependencies for SPDXRef-B
	RelationshipType_DEPENDENCY_MANIFEST_OF RelationshipType = 7
	// Is to be used when SPDXRef-A is a build dependency of SPDXRef-B
	RelationshipType_BUILD_DEPENDENCY_OF RelationshipType = 8
	// Is to be used when SPDXRef-A is a development dependency of SPDXRef-B
	RelationshipType_DEV_DEPENDENCY_OF RelationshipType = 9
	// Is to be used when SPDXRef-A is an optional dependency of SPDXRef-B
	RelationshipType_OPTIONAL_DEPENDENCY_OF RelationshipType = 10
	// Is to be used when SPDXRef-A is a to be provided dependency of
	// SPDXRef-B
	RelationshipType_PROVIDED_DEPENDENCY_OF RelationshipType = 11
	// Is to be used when SPDXRef-A is a test dependency of SPDXRef-B
	RelationshipType_TEST_DEPENDENCY_OF RelationshipType = 12
	// Is to be used when SPDXRef-A is a dependency required for the execution
	// of SPDXRef-B
	RelationshipType_RUNTIME_DEPENDENCY_OF RelationshipType = 13
	// Is to be used when SPDXRef-A is an example of SPDXRef-B
	RelationshipType_EXAMPLE_OF RelationshipType = 14
	// Is to be used when SPDXRef-A generates SPDXRef-B
	RelationshipType_GENERATES RelationshipType = 15
	// Is to be used when SPDXRef-A was generated from SPDXRef-B
	RelationshipType_GENERATED_FROM RelationshipType = 16
	// Is to be used when SPDXRef-A is an ancestor (same lineage but
	// pre-dates) SPDXRef-B
	RelationshipType_ANCESTOR_OF RelationshipType = 17
	// Is to be used when SPDXRef-A is a descendant of (same lineage but
	// postdates) SPDXRef-B
	RelationshipType_DESCENDANT_OF RelationshipType = 18
	// Is to be used when SPDXRef-A is a variant of (same lineage but not
	// clear which came first) SPDXRef-B
	RelationshipType_VARIANT_OF RelationshipType = 19
	// Is to be used when distributing SPDXRef-A requires that SPDXRef-B also
	// be distributed
	RelationshipType_DISTRIBUTION_ARTIFACT RelationshipType = 20
	// Is to be used when SPDXRef-A is a patch file for (to be applied to)
	// SPDXRef-B
	RelationshipType_PATCH_FOR RelationshipType = 21
	// Is to be used when SPDXRef-A is a patch file that has been applied to
	// SPDXRef-B
	RelationshipType_PATCH_APPLIED RelationshipType = 22
	// Is to be used when SPDXRef-A is an exact copy of SPDXRef-B
	RelationshipType_COPY_OF RelationshipType = 23
	// Is to be used when SPDXRef-A is a file that was added to SPDXRef-B
	RelationshipType_FILE_ADDED RelationshipType = 24
	// Is to be used when SPDXRef-A is a file that was deleted from SPDXRef-B
	RelationshipType_FILE_DELETED RelationshipType = 25
	// Is to be used when SPDXRef-A is a file that was modified from SPDXRef-B
	RelationshipType_FILE_MODIFIED RelationshipType = 26
	// Is to be used when SPDXRef-A is expanded from the archive SPDXRef-B
	RelationshipType_EXPANDED_FROM_ARCHIVE RelationshipType = 27
	// Is to be used when SPDXRef-A dynamically links to SPDXRef-B
	RelationshipType_DYNAMIC_LINK RelationshipType = 28
	// Is to be used when SPDXRef-A statically links to SPDXRef-B
	RelationshipType_STATIC_LINK RelationshipType = 29
	// Is to be used when SPDXRef-A is a data file used in SPDXRef-B
	RelationshipType_DATA_FILE_OF RelationshipType = 30
	// Is to be used when SPDXRef-A is a test case used in testing SPDXRef-B
	RelationshipType_TEST_CASE_OF RelationshipType = 31
	// Is to be used when SPDXRef-A is used to build SPDXRef-B
	RelationshipType_BUILD_TOOL_OF RelationshipType = 32
	// Is to be used when SPDXRef-A is used as a development tool for
	// SPDXRef-B
	RelationshipType_DEV_TOOL_OF RelationshipType = 33
	// Is to be used when SPDXRef-A is used for testing SPDXRef-B
	RelationshipType_TEST_OF RelationshipType = 34
	// Is to be used when SPDXRef-A is used as a test tool for SPDXRef-B
	RelationshipType_TEST_TOOL_OF RelationshipType = 35
	// Is to be used when SPDXRef-A provides documentation of SPDXRef-B
	RelationshipType_DOCUMENTATION_OF RelationshipType = 36
	// Is to be used when SPDXRef-A is an optional component of SPDXRef-B
	RelationshipType_OPTIONAL_COMPONENT_OF RelationshipType = 37
	// Is to be used when SPDXRef-A is a metafile of SPDXRef-B
	RelationshipType_METAFILE_OF RelationshipType = 38
	// Is to be used when SPDXRef-A is used as a package as part of SPDXRef-B
	RelationshipType_PACKAGE_OF RelationshipType = 39
	// Is to be used when (current) SPDXRef-DOCUMENT amends the SPDX
	// information in SPDXRef-B
	RelationshipType_AMENDS RelationshipType = 40
	// Is to be used when SPDXRef-A is a prerequisite for SPDXRef-B
	RelationshipType_PREREQUISITE_FOR RelationshipType = 41
	// Is to be used when SPDXRef-A has as a prerequisite SPDXRef-B
	RelationshipType_HAS_PREREQUISITE RelationshipType = 42
	// Is to be used for a relationship which has not been defined in the
	// formal SPDX specification. A description of the relationship should be
	// included in the Relationship comments field
	RelationshipType_OTHER RelationshipType = 43
)

// Enum value maps for RelationshipType.
var (
	RelationshipType_name = map[int32]string{
		0:  "RELATIONSHIP_TYPE_UNSPECIFIED",
		1:  "DESCRIBES",
		2:  "DESCRIBED_BY",
		3:  "CONTAINS",
		4:  "CONTAINED_BY",
		5:  "DEPENDS_ON",
		6:  "DEPENDENCY_OF",
		7:  "DEPENDENCY_MANIFEST_OF",
		8:  "BUILD_DEPENDENCY_OF",
		9:  "DEV_DEPENDENCY_OF",
		10: "OPTIONAL_DEPENDENCY_OF",
		11: "PROVIDED_DEPENDENCY_OF",
		12: "TEST_DEPENDENCY_OF",
		13: "RUNTIME_DEPENDENCY_OF",
		14: "EXAMPLE_OF",
		15: "GENERATES",
		16: "GENERATED_FROM",
		17: "ANCESTOR_OF",
		18: "DESCENDANT_OF",
		19: "VARIANT_OF",
		20: "DISTRIBUTION_ARTIFACT",
		21: "PATCH_FOR",
		22: "PATCH_APPLIED",
		23: "COPY_OF",
		24: "FILE_ADDED",
		25: "FILE_DELETED",
		26: "FILE_MODIFIED",
		27: "EXPANDED_FROM_ARCHIVE",
		28: "DYNAMIC_LINK",
		29: "STATIC_LINK",
		30: "DATA_FILE_OF",
		31: "TEST_CASE_OF",
		32: "BUILD_TOOL_OF",
		33: "DEV_TOOL_OF",
		34: "TEST_OF",
		35: "TEST_TOOL_OF",
		36: "DOCUMENTATION_OF",
		37: "OPTIONAL_COMPONENT_OF",
		38: "METAFILE_OF",
		39: "PACKAGE_OF",
		40: "AMENDS",
		41: "PREREQUISITE_FOR",
		42: "HAS_PREREQUISITE",
		43: "OTHER",
	}
	RelationshipType_value = map[string]int32{
		"RELATIONSHIP_TYPE_UNSPECIFIED": 0,
		"DESCRIBES":                     1,
		"DESCRIBED_BY":                  2,
		"CONTAINS":                      3,
		"CONTAINED_BY":                  4,
		"DEPENDS_ON":                    5,
		"DEPENDENCY_OF":                 6,
		"DEPENDENCY_MANIFEST_OF":        7,
		"BUILD_DEPENDENCY_OF":           8,
		"DEV_DEPENDENCY_OF":             9,
		"OPTIONAL_DEPENDENCY_OF":        10,
		"PROVIDED_DEPENDENCY_OF":        11,
		"TEST_DEPENDENCY_OF":            12,
		"RUNTIME_DEPENDENCY_OF":         13,
		"EXAMPLE_OF":                    14,
		"GENERATES":                     15,
		"GENERATED_FROM":                16,
		"ANCESTOR_OF":                   17,
		"DESCENDANT_OF":                 18,
		"VARIANT_OF":                    19,
		"DISTRIBUTION_ARTIFACT":         20,
		"PATCH_FOR":                     21,
		"PATCH_APPLIED":                 22,
		"COPY_OF":                       23,
		"FILE_ADDED":                    24,
		"FILE_DELETED":                  25,
		"FILE_MODIFIED":                 26,
		"EXPANDED_FROM_ARCHIVE":         27,
		"DYNAMIC_LINK":                  28,
		"STATIC_LINK":                   29,
		"DATA_FILE_OF":                  30,
		"TEST_CASE_OF":                  31,
		"BUILD_TOOL_OF":                 32,
		"DEV_TOOL_OF":                   33,
		"TEST_OF":                       34,
		"TEST_TOOL_OF":                  35,
		"DOCUMENTATION_OF":              36,
		"OPTIONAL_COMPONENT_OF":         37,
		"METAFILE_OF":                   38,
		"PACKAGE_OF":                    39,
		"AMENDS":                        40,
		"PREREQUISITE_FOR":              41,
		"HAS_PREREQUISITE":              42,
		"OTHER":                         43,
	}
)

func (x RelationshipType) Enum() *RelationshipType {
	p := new(RelationshipType)
	*p = x
	return p
}

func (x RelationshipType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelationshipType) Descriptor() protoreflect.EnumDescriptor {
	return file_spdx_proto_enumTypes[0].Descriptor()
}

func (RelationshipType) Type() protoreflect.EnumType {
	return &file_spdx_proto_enumTypes[0]
}

func (x RelationshipType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelationshipType.Descriptor instead.
func (RelationshipType) EnumDescriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{0}
}

// File Type is intrinsic to the file, independent of how the file is being
// used
type FileNote_FileType int32

const (
	// Unspecified
	FileNote_FILE_TYPE_UNSPECIFIED FileNote_FileType = 0
	// The file is human readable source code (.c, .html, etc.)
	FileNote_SOURCE FileNote_FileType = 1
	// The file is a compiled object, target image or binary executable (.o, .a,
	// etc.)
	FileNote_BINARY FileNote_FileType = 2
	// The file represents an archive (.tar, .jar, etc.)
	FileNote_ARCHIVE FileNote_FileType = 3
	// The file is associated with a specific application type (MIME type of
	// application/*)
	FileNote_APPLICATION FileNote_FileType = 4
	// The file is associated with an audio file (MIME type of audio/* , e.g.
	// .mp3)
	FileNote_AUDIO FileNote_FileType = 5
	// The file is associated with an picture image file (MIME type of image/*,
	// e.g., .jpg, .gif)
	FileNote_IMAGE FileNote_FileType = 6
	// The file is human readable text file (MIME type of text/*)
	FileNote_TEXT FileNote_FileType = 7
	// The file is associated with a video file type (MIME type of video/*)
	FileNote_VIDEO FileNote_FileType = 8
	// The file serves as documentation
	FileNote_DOCUMENTATION FileNote_FileType = 9
	// The file is an SPDX document
	FileNote_SPDX FileNote_FileType = 10
	// The file doesn't fit into the above categories (generated artifacts, data
	// files, etc.)
	FileNote_OTHER FileNote_FileType = 11
)

// Enum value maps for FileNote_FileType.
var (
	FileNote_FileType_name = map[int32]string{
		0:  "FILE_TYPE_UNSPECIFIED",
		1:  "SOURCE",
		2:  "BINARY",
		3:  "ARCHIVE",
		4:  "APPLICATION",
		5:  "AUDIO",
		6:  "IMAGE",
		7:  "TEXT",
		8:  "VIDEO",
		9:  "DOCUMENTATION",
		10: "SPDX",
		11: "OTHER",
	}
	FileNote_FileType_value = map[string]int32{
		"FILE_TYPE_UNSPECIFIED": 0,
		"SOURCE":                1,
		"BINARY":                2,
		"ARCHIVE":               3,
		"APPLICATION":           4,
		"AUDIO":                 5,
		"IMAGE":                 6,
		"TEXT":                  7,
		"VIDEO":                 8,
		"DOCUMENTATION":         9,
		"SPDX":                  10,
		"OTHER":                 11,
	}
)

func (x FileNote_FileType) Enum() *FileNote_FileType {
	p := new(FileNote_FileType)
	*p = x
	return p
}

func (x FileNote_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileNote_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_spdx_proto_enumTypes[1].Descriptor()
}

func (FileNote_FileType) Type() protoreflect.EnumType {
	return &file_spdx_proto_enumTypes[1]
}

func (x FileNote_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileNote_FileType.Descriptor instead.
func (FileNote_FileType) EnumDescriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{2, 0}
}

// The category of the external reference
type PackageInfoNote_ExternalRef_Category int32

const (
	// Unspecified
	PackageInfoNote_ExternalRef_CATEGORY_UNSPECIFIED PackageInfoNote_ExternalRef_Category = 0
	// Security (e.g. cpe22Type, cpe23Type)
	PackageInfoNote_ExternalRef_SECURITY PackageInfoNote_ExternalRef_Category = 1
	// Package Manager (e.g. maven-central, npm, nuget, bower, purl)
	PackageInfoNote_ExternalRef_PACKAGE_MANAGER PackageInfoNote_ExternalRef_Category = 2
	// Persistent-Id (e.g. swh)
	PackageInfoNote_ExternalRef_PERSISTENT_ID PackageInfoNote_ExternalRef_Category = 3
	// Other
	PackageInfoNote_ExternalRef_OTHER PackageInfoNote_ExternalRef_Category = 4
)

// Enum value maps for PackageInfoNote_ExternalRef_Category.
var (
	PackageInfoNote_ExternalRef_Category_name = map[int32]string{
		0: "CATEGORY_UNSPECIFIED",
		1: "SECURITY",
		2: "PACKAGE_MANAGER",
		3: "PERSISTENT_ID",
		4: "OTHER",
	}
	PackageInfoNote_ExternalRef_Category_value = map[string]int32{
		"CATEGORY_UNSPECIFIED": 0,
		"SECURITY":             1,
		"PACKAGE_MANAGER":      2,
		"PERSISTENT_ID":        3,
		"OTHER":                4,
	}
)

func (x PackageInfoNote_ExternalRef_Category) Enum() *PackageInfoNote_ExternalRef_Category {
	p := new(PackageInfoNote_ExternalRef_Category)
	*p = x
	return p
}

func (x PackageInfoNote_ExternalRef_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PackageInfoNote_ExternalRef_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_spdx_proto_enumTypes[2].Descriptor()
}

func (PackageInfoNote_ExternalRef_Category) Type() protoreflect.EnumType {
	return &file_spdx_proto_enumTypes[2]
}

func (x PackageInfoNote_ExternalRef_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PackageInfoNote_ExternalRef_Category.Descriptor instead.
func (PackageInfoNote_ExternalRef_Category) EnumDescriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{5, 0, 0}
}

// DocumentNote represents an SPDX Document Creation Information section:
// https://spdx.github.io/spdx-spec/2-document-creation-information/
type DocumentNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Provide a reference number that can be used to understand how to parse and
	// interpret the rest of the file
	SpdxVersion string `protobuf:"bytes,1,opt,name=spdx_version,json=spdxVersion,proto3" json:"spdx_version,omitempty"`
	// Compliance with the SPDX specification includes populating the SPDX fields
	// therein with data related to such fields ("SPDX-Metadata")
	DataLicence string `protobuf:"bytes,2,opt,name=data_licence,json=dataLicence,proto3" json:"data_licence,omitempty"`
}

func (x *DocumentNote) Reset() {
	*x = DocumentNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentNote) ProtoMessage() {}

func (x *DocumentNote) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentNote.ProtoReflect.Descriptor instead.
func (*DocumentNote) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{0}
}

func (x *DocumentNote) GetSpdxVersion() string {
	if x != nil {
		return x.SpdxVersion
	}
	return ""
}

func (x *DocumentNote) GetDataLicence() string {
	if x != nil {
		return x.DataLicence
	}
	return ""
}

// DocumentOccurrence represents an SPDX Document Creation Information
// section: https://spdx.github.io/spdx-spec/2-document-creation-information/
type DocumentOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identify the current SPDX document which may be referenced in relationships
	// by other files, packages internally and documents externally
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identify name of this document as designated by creator
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Provide an SPDX document specific namespace as a unique absolute Uniform
	// Resource Identifier (URI) as specified in RFC-3986, with the exception of
	// the ‘#’ delimiter
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Identify any external SPDX documents referenced within this SPDX document
	ExternalDocumentRefs []string `protobuf:"bytes,4,rep,name=external_document_refs,json=externalDocumentRefs,proto3" json:"external_document_refs,omitempty"`
	// A field for creators of the SPDX file to provide the version of
	// the SPDX License List used when the SPDX file was created
	LicenseListVersion string `protobuf:"bytes,5,opt,name=license_list_version,json=licenseListVersion,proto3" json:"license_list_version,omitempty"`
	// Identify who (or what, in the case of a tool) created the SPDX file. If the
	// SPDX file was created by an individual, indicate the person's name
	Creators []string `protobuf:"bytes,6,rep,name=creators,proto3" json:"creators,omitempty"`
	// Identify when the SPDX file was originally created. The date is to be
	// specified according to combined date and time in UTC format as specified in
	// ISO 8601 standard
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// A field for creators of the SPDX file to provide general comments
	// about the creation of the SPDX file or any other relevant comment not
	// included in the other fields
	CreatorComment string `protobuf:"bytes,8,opt,name=creator_comment,json=creatorComment,proto3" json:"creator_comment,omitempty"`
	// A field for creators of the SPDX file content to provide comments
	// to the consumers of the SPDX document
	DocumentComment string `protobuf:"bytes,9,opt,name=document_comment,json=documentComment,proto3" json:"document_comment,omitempty"`
}

func (x *DocumentOccurrence) Reset() {
	*x = DocumentOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentOccurrence) ProtoMessage() {}

func (x *DocumentOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentOccurrence.ProtoReflect.Descriptor instead.
func (*DocumentOccurrence) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{1}
}

func (x *DocumentOccurrence) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DocumentOccurrence) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *DocumentOccurrence) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *DocumentOccurrence) GetExternalDocumentRefs() []string {
	if x != nil {
		return x.ExternalDocumentRefs
	}
	return nil
}

func (x *DocumentOccurrence) GetLicenseListVersion() string {
	if x != nil {
		return x.LicenseListVersion
	}
	return ""
}

func (x *DocumentOccurrence) GetCreators() []string {
	if x != nil {
		return x.Creators
	}
	return nil
}

func (x *DocumentOccurrence) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DocumentOccurrence) GetCreatorComment() string {
	if x != nil {
		return x.CreatorComment
	}
	return ""
}

func (x *DocumentOccurrence) GetDocumentComment() string {
	if x != nil {
		return x.DocumentComment
	}
	return ""
}

// FileNote represents an SPDX File Information
// section: https://spdx.github.io/spdx-spec/4-file-information/
type FileNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identify the full path and filename that corresponds to the file
	// information in this section
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// This field provides information about the type of file identified
	FileType FileNote_FileType `protobuf:"varint,2,opt,name=file_type,json=fileType,proto3,enum=grafeas.v1beta1.spdx.FileNote_FileType" json:"file_type,omitempty"`
	// Provide a unique identifier to match analysis information on each specific
	// file in a package
	Checksum []string `protobuf:"bytes,3,rep,name=checksum,proto3" json:"checksum,omitempty"`
}

func (x *FileNote) Reset() {
	*x = FileNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileNote) ProtoMessage() {}

func (x *FileNote) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileNote.ProtoReflect.Descriptor instead.
func (*FileNote) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{2}
}

func (x *FileNote) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *FileNote) GetFileType() FileNote_FileType {
	if x != nil {
		return x.FileType
	}
	return FileNote_FILE_TYPE_UNSPECIFIED
}

func (x *FileNote) GetChecksum() []string {
	if x != nil {
		return x.Checksum
	}
	return nil
}

// FileOccurrence represents an SPDX File Information
// section: https://spdx.github.io/spdx-spec/4-file-information/
type FileOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identify any element in an SPDX document which may be referenced
	// by other elements
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// This field contains the license the SPDX file creator has concluded as
	// governing the file or alternative values if the governing license cannot be
	// determined
	LicenseConcluded *License `protobuf:"bytes,2,opt,name=license_concluded,json=licenseConcluded,proto3" json:"license_concluded,omitempty"`
	// This field contains the license information actually found in the file, if
	// any
	FilesLicenseInfo []string `protobuf:"bytes,3,rep,name=files_license_info,json=filesLicenseInfo,proto3" json:"files_license_info,omitempty"`
	// Identify the copyright holder of the file, as well as any dates present
	Copyright string `protobuf:"bytes,4,opt,name=copyright,proto3" json:"copyright,omitempty"`
	// This field provides a place for the SPDX file creator to record any general
	// comments about the file
	Comment string `protobuf:"bytes,5,opt,name=comment,proto3" json:"comment,omitempty"`
	// This field provides a place for the SPDX file creator to record license
	// notices or other such related notices found in the file
	Notice string `protobuf:"bytes,6,opt,name=notice,proto3" json:"notice,omitempty"`
	// This field provides a place for the SPDX file creator to record file
	// contributors
	Contributors []string `protobuf:"bytes,7,rep,name=contributors,proto3" json:"contributors,omitempty"`
	// This field provides a place for the SPDX data creator to record, at the
	// file level, acknowledgements that may be needed to be communicated in
	// some contexts
	Attributions []string `protobuf:"bytes,8,rep,name=attributions,proto3" json:"attributions,omitempty"`
}

func (x *FileOccurrence) Reset() {
	*x = FileOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileOccurrence) ProtoMessage() {}

func (x *FileOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileOccurrence.ProtoReflect.Descriptor instead.
func (*FileOccurrence) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{3}
}

func (x *FileOccurrence) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FileOccurrence) GetLicenseConcluded() *License {
	if x != nil {
		return x.LicenseConcluded
	}
	return nil
}

func (x *FileOccurrence) GetFilesLicenseInfo() []string {
	if x != nil {
		return x.FilesLicenseInfo
	}
	return nil
}

func (x *FileOccurrence) GetCopyright() string {
	if x != nil {
		return x.Copyright
	}
	return ""
}

func (x *FileOccurrence) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (x *FileOccurrence) GetNotice() string {
	if x != nil {
		return x.Notice
	}
	return ""
}

func (x *FileOccurrence) GetContributors() []string {
	if x != nil {
		return x.Contributors
	}
	return nil
}

func (x *FileOccurrence) GetAttributions() []string {
	if x != nil {
		return x.Attributions
	}
	return nil
}

// License information: https://spdx.github.io/spdx-spec/3-package-information/#315-declared-license
type License struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Expression: https://spdx.github.io/spdx-spec/appendix-IV-SPDX-license-expressions/
	Expression string `protobuf:"bytes,1,opt,name=expression,proto3" json:"expression,omitempty"`
	// Comments
	Comments string `protobuf:"bytes,2,opt,name=comments,proto3" json:"comments,omitempty"`
}

func (x *License) Reset() {
	*x = License{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *License) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*License) ProtoMessage() {}

func (x *License) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use License.ProtoReflect.Descriptor instead.
func (*License) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{4}
}

func (x *License) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

func (x *License) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

// PackageInfoNote represents an SPDX Package Information
// section: https://spdx.github.io/spdx-spec/3-package-information/
type PackageInfoNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identify the full name of the package as given by the Package Originator
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Identify the version of the package
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Identify the actual distribution source for the package/directory
	// identified in the SPDX file
	Supplier string `protobuf:"bytes,3,opt,name=supplier,proto3" json:"supplier,omitempty"`
	// If the package identified in the SPDX file originated from a different
	// person or organization than identified as Package Supplier, this field
	// identifies from where or whom the package originally came
	Originator string `protobuf:"bytes,4,opt,name=originator,proto3" json:"originator,omitempty"`
	//  This section identifies the download Universal Resource Locator (URL), or
	//  a specific location within a version control system (VCS) for the package
	//  at the time that the SPDX file was created
	DownloadLocation string `protobuf:"bytes,5,opt,name=download_location,json=downloadLocation,proto3" json:"download_location,omitempty"`
	// Indicates whether the file content of this package has been available for
	// or subjected to analysis when creating the SPDX document
	Analyzed bool `protobuf:"varint,6,opt,name=analyzed,proto3" json:"analyzed,omitempty"`
	// This field provides an independently reproducible mechanism identifying
	// specific contents of a package based on the actual files (except the SPDX
	// file itself, if it is included in the package) that make up each package
	// and that correlates to the data in this SPDX file
	VerificationCode string `protobuf:"bytes,7,opt,name=verification_code,json=verificationCode,proto3" json:"verification_code,omitempty"`
	// Provide an independently reproducible mechanism that permits unique
	// identification of a specific package that correlates to the data in this
	// SPDX file
	Checksum string `protobuf:"bytes,8,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// Provide a place for the SPDX file creator to record a web site that serves
	// as the package's home page
	HomePage string `protobuf:"bytes,9,opt,name=home_page,json=homePage,proto3" json:"home_page,omitempty"`
	// Contain the license the SPDX file creator has concluded as governing the
	// This field is to contain a list of all licenses found in the package. The
	// relationship between licenses (i.e., conjunctive, disjunctive) is not
	// specified in this field – it is simply a listing of all licenses found
	FilesLicenseInfo []string `protobuf:"bytes,10,rep,name=files_license_info,json=filesLicenseInfo,proto3" json:"files_license_info,omitempty"`
	// List the licenses that have been declared by the authors of the package
	LicenseDeclared *License `protobuf:"bytes,11,opt,name=license_declared,json=licenseDeclared,proto3" json:"license_declared,omitempty"`
	// Identify the copyright holders of the package, as well as any dates present
	Copyright string `protobuf:"bytes,12,opt,name=copyright,proto3" json:"copyright,omitempty"`
	// A short description of the package
	SummaryDescription string `protobuf:"bytes,13,opt,name=summary_description,json=summaryDescription,proto3" json:"summary_description,omitempty"`
	// A more detailed description of the package
	DetailedDescription string `protobuf:"bytes,14,opt,name=detailed_description,json=detailedDescription,proto3" json:"detailed_description,omitempty"`
	// ExternalRef
	ExternalRefs []*PackageInfoNote_ExternalRef `protobuf:"bytes,15,rep,name=external_refs,json=externalRefs,proto3" json:"external_refs,omitempty"`
	// A place for the SPDX data creator to record, at the package level,
	// acknowledgements that may be needed to be communicated in some contexts
	Attribution string `protobuf:"bytes,16,opt,name=attribution,proto3" json:"attribution,omitempty"`
	// The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
	PackageType string `protobuf:"bytes,17,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
}

func (x *PackageInfoNote) Reset() {
	*x = PackageInfoNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageInfoNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageInfoNote) ProtoMessage() {}

func (x *PackageInfoNote) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageInfoNote.ProtoReflect.Descriptor instead.
func (*PackageInfoNote) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{5}
}

func (x *PackageInfoNote) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *PackageInfoNote) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PackageInfoNote) GetSupplier() string {
	if x != nil {
		return x.Supplier
	}
	return ""
}

func (x *PackageInfoNote) GetOriginator() string {
	if x != nil {
		return x.Originator
	}
	return ""
}

func (x *PackageInfoNote) GetDownloadLocation() string {
	if x != nil {
		return x.DownloadLocation
	}
	return ""
}

func (x *PackageInfoNote) GetAnalyzed() bool {
	if x != nil {
		return x.Analyzed
	}
	return false
}

func (x *PackageInfoNote) GetVerificationCode() string {
	if x != nil {
		return x.VerificationCode
	}
	return ""
}

func (x *PackageInfoNote) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

func (x *PackageInfoNote) GetHomePage() string {
	if x != nil {
		return x.HomePage
	}
	return ""
}

func (x *PackageInfoNote) GetFilesLicenseInfo() []string {
	if x != nil {
		return x.FilesLicenseInfo
	}
	return nil
}

func (x *PackageInfoNote) GetLicenseDeclared() *License {
	if x != nil {
		return x.LicenseDeclared
	}
	return nil
}

func (x *PackageInfoNote) GetCopyright() string {
	if x != nil {
		return x.Copyright
	}
	return ""
}

func (x *PackageInfoNote) GetSummaryDescription() string {
	if x != nil {
		return x.SummaryDescription
	}
	return ""
}

func (x *PackageInfoNote) GetDetailedDescription() string {
	if x != nil {
		return x.DetailedDescription
	}
	return ""
}

func (x *PackageInfoNote) GetExternalRefs() []*PackageInfoNote_ExternalRef {
	if x != nil {
		return x.ExternalRefs
	}
	return nil
}

func (x *PackageInfoNote) GetAttribution() string {
	if x != nil {
		return x.Attribution
	}
	return ""
}

func (x *PackageInfoNote) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

// PackageInfoOccurrence represents an SPDX Package Information
// section: https://spdx.github.io/spdx-spec/3-package-information/
type PackageInfoOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identify any element in an SPDX document which may be referenced
	// by other elements
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Provide the actual file name of the package, or path of the directory being
	// treated as a package
	Filename string `protobuf:"bytes,2,opt,name=filename,proto3" json:"filename,omitempty"`
	// Provide a place for the SPDX file creator to record any relevant background
	// information or additional comments about the origin of the package
	SourceInfo string `protobuf:"bytes,3,opt,name=source_info,json=sourceInfo,proto3" json:"source_info,omitempty"`
	// package or alternative values, if the governing license cannot be
	// determined
	LicenseConcluded *License `protobuf:"bytes,4,opt,name=license_concluded,json=licenseConcluded,proto3" json:"license_concluded,omitempty"`
	// A place for the SPDX file creator to record any general
	// comments about the package being described
	Comment string `protobuf:"bytes,5,opt,name=comment,proto3" json:"comment,omitempty"`
	// The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
	PackageType string `protobuf:"bytes,6,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// Identify the full name of the package as given by the Package Originator
	Title string `protobuf:"bytes,7,opt,name=title,proto3" json:"title,omitempty"`
	// Identify the version of the package
	Version string `protobuf:"bytes,8,opt,name=version,proto3" json:"version,omitempty"`
	// Provide a place for the SPDX file creator to record a web site that serves
	// as the package's home page
	HomePage string `protobuf:"bytes,9,opt,name=home_page,json=homePage,proto3" json:"home_page,omitempty"`
	// A short description of the package
	SummaryDescription string `protobuf:"bytes,10,opt,name=summary_description,json=summaryDescription,proto3" json:"summary_description,omitempty"`
}

func (x *PackageInfoOccurrence) Reset() {
	*x = PackageInfoOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageInfoOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageInfoOccurrence) ProtoMessage() {}

func (x *PackageInfoOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageInfoOccurrence.ProtoReflect.Descriptor instead.
func (*PackageInfoOccurrence) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{6}
}

func (x *PackageInfoOccurrence) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PackageInfoOccurrence) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *PackageInfoOccurrence) GetSourceInfo() string {
	if x != nil {
		return x.SourceInfo
	}
	return ""
}

func (x *PackageInfoOccurrence) GetLicenseConcluded() *License {
	if x != nil {
		return x.LicenseConcluded
	}
	return nil
}

func (x *PackageInfoOccurrence) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (x *PackageInfoOccurrence) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *PackageInfoOccurrence) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *PackageInfoOccurrence) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PackageInfoOccurrence) GetHomePage() string {
	if x != nil {
		return x.HomePage
	}
	return ""
}

func (x *PackageInfoOccurrence) GetSummaryDescription() string {
	if x != nil {
		return x.SummaryDescription
	}
	return ""
}

// RelationshipNote represents an SPDX Relationship
// section:
// https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
type RelationshipNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of relationship between the source and target SPDX elements
	Type RelationshipType `protobuf:"varint,1,opt,name=type,proto3,enum=grafeas.v1beta1.spdx.RelationshipType" json:"type,omitempty"`
}

func (x *RelationshipNote) Reset() {
	*x = RelationshipNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelationshipNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelationshipNote) ProtoMessage() {}

func (x *RelationshipNote) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelationshipNote.ProtoReflect.Descriptor instead.
func (*RelationshipNote) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{7}
}

func (x *RelationshipNote) GetType() RelationshipType {
	if x != nil {
		return x.Type
	}
	return RelationshipType_RELATIONSHIP_TYPE_UNSPECIFIED
}

// RelationshipOccurrence represents an SPDX Relationship
// section:
// https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
type RelationshipOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Also referred to as SPDXRef-A
	// The source SPDX element (file, package, etc)
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Also referred to as SPDXRef-B
	// The target SPDC element (file, package, etc)
	// In cases where there are "known unknowns", the use of the keyword
	// NOASSERTION can be used The keywords NONE can be used to indicate that an
	// SPDX element (package/file/snippet) has no other elements connected by
	// some relationship to it
	Target string `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// The type of relationship between the source and target SPDX elements
	Type RelationshipType `protobuf:"varint,3,opt,name=type,proto3,enum=grafeas.v1beta1.spdx.RelationshipType" json:"type,omitempty"`
	// A place for the SPDX file creator to record any general comments about
	// the relationship
	Comment string `protobuf:"bytes,4,opt,name=comment,proto3" json:"comment,omitempty"`
}

func (x *RelationshipOccurrence) Reset() {
	*x = RelationshipOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelationshipOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelationshipOccurrence) ProtoMessage() {}

func (x *RelationshipOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelationshipOccurrence.ProtoReflect.Descriptor instead.
func (*RelationshipOccurrence) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{8}
}

func (x *RelationshipOccurrence) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *RelationshipOccurrence) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *RelationshipOccurrence) GetType() RelationshipType {
	if x != nil {
		return x.Type
	}
	return RelationshipType_RELATIONSHIP_TYPE_UNSPECIFIED
}

func (x *RelationshipOccurrence) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

// An External Reference allows a Package to reference an external source of
// additional information, metadata, enumerations, asset identifiers, or
// downloadable content believed to be relevant to the Package
type PackageInfoNote_ExternalRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An External Reference allows a Package to reference an external source of
	// additional information, metadata, enumerations, asset identifiers, or
	// downloadable content believed to be relevant to the Package
	Category PackageInfoNote_ExternalRef_Category `protobuf:"varint,1,opt,name=category,proto3,enum=grafeas.v1beta1.spdx.PackageInfoNote_ExternalRef_Category" json:"category,omitempty"`
	// Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The unique string with no spaces necessary to access the package-specific
	// information, metadata, or content within the target location
	Locator string `protobuf:"bytes,3,opt,name=locator,proto3" json:"locator,omitempty"`
	// Human-readable information about the purpose and target of the reference
	Comment string `protobuf:"bytes,4,opt,name=comment,proto3" json:"comment,omitempty"`
}

func (x *PackageInfoNote_ExternalRef) Reset() {
	*x = PackageInfoNote_ExternalRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_spdx_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageInfoNote_ExternalRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageInfoNote_ExternalRef) ProtoMessage() {}

func (x *PackageInfoNote_ExternalRef) ProtoReflect() protoreflect.Message {
	mi := &file_spdx_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageInfoNote_ExternalRef.ProtoReflect.Descriptor instead.
func (*PackageInfoNote_ExternalRef) Descriptor() ([]byte, []int) {
	return file_spdx_proto_rawDescGZIP(), []int{5, 0}
}

func (x *PackageInfoNote_ExternalRef) GetCategory() PackageInfoNote_ExternalRef_Category {
	if x != nil {
		return x.Category
	}
	return PackageInfoNote_ExternalRef_CATEGORY_UNSPECIFIED
}

func (x *PackageInfoNote_ExternalRef) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *PackageInfoNote_ExternalRef) GetLocator() string {
	if x != nil {
		return x.Locator
	}
	return ""
}

func (x *PackageInfoNote_ExternalRef) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

var File_spdx_proto protoreflect.FileDescriptor

var file_spdx_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70,
	0x64, 0x78, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x54, 0x0a, 0x0c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4e, 0x6f, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x70, 0x64, 0x78,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x6c, 0x69, 0x63, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xed, 0x02, 0x0a, 0x12, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x29, 0x0a, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xb3, 0x02, 0x0a, 0x08, 0x46,
	0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x44, 0x0a,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x74, 0x65,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x22,
	0xae, 0x01, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15,
	0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b,
	0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47,
	0x45, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x10, 0x07, 0x12, 0x09, 0x0a,
	0x05, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x4f, 0x43, 0x55,
	0x4d, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x12, 0x08, 0x0a, 0x04, 0x53,
	0x50, 0x44, 0x58, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x0b,
	0x22, 0xb2, 0x02, 0x0a, 0x0e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x4a, 0x0a, 0x11, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x52, 0x10, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x12,
	0x2c, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a,
	0x09, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x12, 0x22, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x73, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x45, 0x0a, 0x07, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xda, 0x07, 0x0a,
	0x0f, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x4e, 0x6f, 0x74, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1a, 0x0a, 0x08, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x2b, 0x0a, 0x11,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12, 0x1b,
	0x0a, 0x09, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x68, 0x6f, 0x6d, 0x65, 0x50, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x48, 0x0a, 0x10, 0x6c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x5f, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x65, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x52, 0x0f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x44, 0x65, 0x63, 0x6c, 0x61,
	0x72, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x14, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x70, 0x64, 0x78, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x4e,
	0x6f, 0x74, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x66, 0x52,
	0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x66, 0x73, 0x12, 0x20, 0x0a,
	0x0b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x1a, 0x94, 0x02, 0x0a, 0x0b, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52,
	0x65, 0x66, 0x12, 0x56, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x66, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x65, 0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x18,
	0x0a, 0x14, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45, 0x43, 0x55,
	0x52, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47,
	0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x50,
	0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x44, 0x10, 0x03, 0x12, 0x09,
	0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x04, 0x22, 0x84, 0x03, 0x0a, 0x15, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x4a, 0x0a, 0x11, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70,
	0x64, 0x78, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x52, 0x10, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x68, 0x6f, 0x6d, 0x65,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x68, 0x6f, 0x6d, 0x65, 0x50, 0x61, 0x67, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x4e, 0x0a, 0x10, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70,
	0x4e, 0x6f, 0x74, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0xa3, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69,
	0x70, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x2a, 0xf0, 0x06, 0x0a, 0x10, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x52,
	0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x44, 0x45, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x53, 0x10, 0x01, 0x12, 0x10, 0x0a,
	0x0c, 0x44, 0x45, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x53, 0x10, 0x03, 0x12, 0x10, 0x0a,
	0x0c, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x10, 0x04, 0x12,
	0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x53, 0x5f, 0x4f, 0x4e, 0x10, 0x05, 0x12,
	0x11, 0x0a, 0x0d, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4f, 0x46,
	0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59,
	0x5f, 0x4d, 0x41, 0x4e, 0x49, 0x46, 0x45, 0x53, 0x54, 0x5f, 0x4f, 0x46, 0x10, 0x07, 0x12, 0x17,
	0x0a, 0x13, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e,
	0x43, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x08, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x56, 0x5f, 0x44,
	0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x09, 0x12, 0x1a,
	0x0a, 0x16, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x44, 0x45, 0x50, 0x45, 0x4e,
	0x44, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x0a, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x52,
	0x4f, 0x56, 0x49, 0x44, 0x45, 0x44, 0x5f, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43,
	0x59, 0x5f, 0x4f, 0x46, 0x10, 0x0b, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x44,
	0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x0c, 0x12, 0x19,
	0x0a, 0x15, 0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44,
	0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x0d, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x58, 0x41,
	0x4d, 0x50, 0x4c, 0x45, 0x5f, 0x4f, 0x46, 0x10, 0x0e, 0x12, 0x0d, 0x0a, 0x09, 0x47, 0x45, 0x4e,
	0x45, 0x52, 0x41, 0x54, 0x45, 0x53, 0x10, 0x0f, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45, 0x4e, 0x45,
	0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x10, 0x10, 0x12, 0x0f, 0x0a, 0x0b,
	0x41, 0x4e, 0x43, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x5f, 0x4f, 0x46, 0x10, 0x11, 0x12, 0x11, 0x0a,
	0x0d, 0x44, 0x45, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x41, 0x4e, 0x54, 0x5f, 0x4f, 0x46, 0x10, 0x12,
	0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x41, 0x52, 0x49, 0x41, 0x4e, 0x54, 0x5f, 0x4f, 0x46, 0x10, 0x13,
	0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x41, 0x52, 0x54, 0x49, 0x46, 0x41, 0x43, 0x54, 0x10, 0x14, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x41, 0x54, 0x43, 0x48, 0x5f, 0x46, 0x4f, 0x52, 0x10, 0x15, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x41,
	0x54, 0x43, 0x48, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x16, 0x12, 0x0b, 0x0a,
	0x07, 0x43, 0x4f, 0x50, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x17, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49,
	0x4c, 0x45, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x18, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x49,
	0x4c, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x19, 0x12, 0x11, 0x0a, 0x0d,
	0x46, 0x49, 0x4c, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x1a, 0x12,
	0x19, 0x0a, 0x15, 0x45, 0x58, 0x50, 0x41, 0x4e, 0x44, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d,
	0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x10, 0x1b, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x59,
	0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x1c, 0x12, 0x0f, 0x0a, 0x0b,
	0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x1d, 0x12, 0x10, 0x0a,
	0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x4f, 0x46, 0x10, 0x1e, 0x12,
	0x10, 0x0a, 0x0c, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x4f, 0x46, 0x10,
	0x1f, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x5f,
	0x4f, 0x46, 0x10, 0x20, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x56, 0x5f, 0x54, 0x4f, 0x4f, 0x4c,
	0x5f, 0x4f, 0x46, 0x10, 0x21, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x4f, 0x46,
	0x10, 0x22, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x5f,
	0x4f, 0x46, 0x10, 0x23, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x46, 0x10, 0x24, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54,
	0x5f, 0x4f, 0x46, 0x10, 0x25, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x45, 0x54, 0x41, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x4f, 0x46, 0x10, 0x26, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47,
	0x45, 0x5f, 0x4f, 0x46, 0x10, 0x27, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4d, 0x45, 0x4e, 0x44, 0x53,
	0x10, 0x28, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x45, 0x52, 0x45, 0x51, 0x55, 0x49, 0x53, 0x49,
	0x54, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x10, 0x29, 0x12, 0x14, 0x0a, 0x10, 0x48, 0x41, 0x53, 0x5f,
	0x50, 0x52, 0x45, 0x52, 0x45, 0x51, 0x55, 0x49, 0x53, 0x49, 0x54, 0x45, 0x10, 0x2a, 0x12, 0x09,
	0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x2b, 0x42, 0x59, 0x0a, 0x17, 0x69, 0x6f, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x73, 0x70, 0x64, 0x78, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xa2, 0x02,
	0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_spdx_proto_rawDescOnce sync.Once
	file_spdx_proto_rawDescData = file_spdx_proto_rawDesc
)

func file_spdx_proto_rawDescGZIP() []byte {
	file_spdx_proto_rawDescOnce.Do(func() {
		file_spdx_proto_rawDescData = protoimpl.X.CompressGZIP(file_spdx_proto_rawDescData)
	})
	return file_spdx_proto_rawDescData
}

var file_spdx_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_spdx_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_spdx_proto_goTypes = []interface{}{
	(RelationshipType)(0),                     // 0: grafeas.v1beta1.spdx.RelationshipType
	(FileNote_FileType)(0),                    // 1: grafeas.v1beta1.spdx.FileNote.FileType
	(PackageInfoNote_ExternalRef_Category)(0), // 2: grafeas.v1beta1.spdx.PackageInfoNote.ExternalRef.Category
	(*DocumentNote)(nil),                      // 3: grafeas.v1beta1.spdx.DocumentNote
	(*DocumentOccurrence)(nil),                // 4: grafeas.v1beta1.spdx.DocumentOccurrence
	(*FileNote)(nil),                          // 5: grafeas.v1beta1.spdx.FileNote
	(*FileOccurrence)(nil),                    // 6: grafeas.v1beta1.spdx.FileOccurrence
	(*License)(nil),                           // 7: grafeas.v1beta1.spdx.License
	(*PackageInfoNote)(nil),                   // 8: grafeas.v1beta1.spdx.PackageInfoNote
	(*PackageInfoOccurrence)(nil),             // 9: grafeas.v1beta1.spdx.PackageInfoOccurrence
	(*RelationshipNote)(nil),                  // 10: grafeas.v1beta1.spdx.RelationshipNote
	(*RelationshipOccurrence)(nil),            // 11: grafeas.v1beta1.spdx.RelationshipOccurrence
	(*PackageInfoNote_ExternalRef)(nil),       // 12: grafeas.v1beta1.spdx.PackageInfoNote.ExternalRef
	(*timestamp.Timestamp)(nil),               // 13: google.protobuf.Timestamp
}
var file_spdx_proto_depIdxs = []int32{
	13, // 0: grafeas.v1beta1.spdx.DocumentOccurrence.create_time:type_name -> google.protobuf.Timestamp
	1,  // 1: grafeas.v1beta1.spdx.FileNote.file_type:type_name -> grafeas.v1beta1.spdx.FileNote.FileType
	7,  // 2: grafeas.v1beta1.spdx.FileOccurrence.license_concluded:type_name -> grafeas.v1beta1.spdx.License
	7,  // 3: grafeas.v1beta1.spdx.PackageInfoNote.license_declared:type_name -> grafeas.v1beta1.spdx.License
	12, // 4: grafeas.v1beta1.spdx.PackageInfoNote.external_refs:type_name -> grafeas.v1beta1.spdx.PackageInfoNote.ExternalRef
	7,  // 5: grafeas.v1beta1.spdx.PackageInfoOccurrence.license_concluded:type_name -> grafeas.v1beta1.spdx.License
	0,  // 6: grafeas.v1beta1.spdx.RelationshipNote.type:type_name -> grafeas.v1beta1.spdx.RelationshipType
	0,  // 7: grafeas.v1beta1.spdx.RelationshipOccurrence.type:type_name -> grafeas.v1beta1.spdx.RelationshipType
	2,  // 8: grafeas.v1beta1.spdx.PackageInfoNote.ExternalRef.category:type_name -> grafeas.v1beta1.spdx.PackageInfoNote.ExternalRef.Category
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_spdx_proto_init() }
func file_spdx_proto_init() {
	if File_spdx_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_spdx_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*License); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageInfoNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageInfoOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelationshipNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelationshipOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_spdx_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageInfoNote_ExternalRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_spdx_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_spdx_proto_goTypes,
		DependencyIndexes: file_spdx_proto_depIdxs,
		EnumInfos:         file_spdx_proto_enumTypes,
		MessageInfos:      file_spdx_proto_msgTypes,
	}.Build()
	File_spdx_proto = out.File
	file_spdx_proto_rawDesc = nil
	file_spdx_proto_goTypes = nil
	file_spdx_proto_depIdxs = nil
}
