/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1alpha1"
	scheme "github.com/tektoncd/triggers/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// EventListenersGetter has a method to return a EventListenerInterface.
// A group's client should implement this interface.
type EventListenersGetter interface {
	EventListeners(namespace string) EventListenerInterface
}

// EventListenerInterface has methods to work with EventListener resources.
type EventListenerInterface interface {
	Create(*v1alpha1.EventListener) (*v1alpha1.EventListener, error)
	Update(*v1alpha1.EventListener) (*v1alpha1.EventListener, error)
	UpdateStatus(*v1alpha1.EventListener) (*v1alpha1.EventListener, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.EventListener, error)
	List(opts v1.ListOptions) (*v1alpha1.EventListenerList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.EventListener, err error)
	EventListenerExpansion
}

// eventListeners implements EventListenerInterface
type eventListeners struct {
	client rest.Interface
	ns     string
}

// newEventListeners returns a EventListeners
func newEventListeners(c *TriggersV1alpha1Client, namespace string) *eventListeners {
	return &eventListeners{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the eventListener, and returns the corresponding eventListener object, and an error if there is any.
func (c *eventListeners) Get(name string, options v1.GetOptions) (result *v1alpha1.EventListener, err error) {
	result = &v1alpha1.EventListener{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("eventlisteners").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of EventListeners that match those selectors.
func (c *eventListeners) List(opts v1.ListOptions) (result *v1alpha1.EventListenerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.EventListenerList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("eventlisteners").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested eventListeners.
func (c *eventListeners) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("eventlisteners").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a eventListener and creates it.  Returns the server's representation of the eventListener, and an error, if there is any.
func (c *eventListeners) Create(eventListener *v1alpha1.EventListener) (result *v1alpha1.EventListener, err error) {
	result = &v1alpha1.EventListener{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("eventlisteners").
		Body(eventListener).
		Do().
		Into(result)
	return
}

// Update takes the representation of a eventListener and updates it. Returns the server's representation of the eventListener, and an error, if there is any.
func (c *eventListeners) Update(eventListener *v1alpha1.EventListener) (result *v1alpha1.EventListener, err error) {
	result = &v1alpha1.EventListener{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("eventlisteners").
		Name(eventListener.Name).
		Body(eventListener).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *eventListeners) UpdateStatus(eventListener *v1alpha1.EventListener) (result *v1alpha1.EventListener, err error) {
	result = &v1alpha1.EventListener{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("eventlisteners").
		Name(eventListener.Name).
		SubResource("status").
		Body(eventListener).
		Do().
		Into(result)
	return
}

// Delete takes name of the eventListener and deletes it. Returns an error if one occurs.
func (c *eventListeners) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("eventlisteners").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *eventListeners) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("eventlisteners").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched eventListener.
func (c *eventListeners) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.EventListener, err error) {
	result = &v1alpha1.EventListener{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("eventlisteners").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
