# Keychain and Windows Credentials Manager

chezmoi includes support for Keychain (on macOS), GNOME Keyring (on Linux), and
Windows Credentials Manager (on Windows) via the
[`zalando/go-keyring`](https://github.com/zalando/go-keyring) library.

Set values with:

```console
$ chezmoi secret keyring set --service=<service> --user=<user>
Value: xxxxxxxx
```

The value can then be used in templates using the `keyring` function which
takes the service and user as arguments.

For example, save a GitHub access token in keyring with:

```console
$ chezmoi secret keyring set --service=github --user=<github-username>
Value: xxxxxxxx
```

and then include it in your `~/.gitconfig` file with:

```
[github]
    user = {{ .github.user | quote }}
    token = {{ keyring "github" .github.user | quote }}
```

You can query the keyring from the command line:

```console
$ chezmoi secret keyring get --service=github --user=<github-username>
```
