// Code generated by github.com/twpayne/chezmoi/internal/generate-assets. DO NOT EDIT.
// +build !noembeddocs

package cmd

func init() {
	assets["docs/CHANGES.md"] = []byte("" +
		"# chezmoi Changes\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Upcoming](#upcoming)\n" +
		"  * [Default diff format changing from `chezmoi` to `git`.](#default-diff-format-changing-from-chezmoi-to-git)\n" +
		"  * [`gpgRecipient` config variable changing to `gpg.recipient`](#gpgrecipient-config-variable-changing-to-gpgrecipient)\n" +
		"\n" +
		"## Upcoming\n" +
		"\n" +
		"### Default diff format changing from `chezmoi` to `git`.\n" +
		"\n" +
		"Currently chezmoi outputs diffs in its own format, containing a mix of unified\n" +
		"diffs and shell commands. This will be replaced with a [git format\n" +
		"diff](https://git-scm.com/docs/diff-format) in version 2.0.0.\n" +
		"\n" +
		"### `gpgRecipient` config variable changing to `gpg.recipient`\n" +
		"\n" +
		"The `gpgRecipient` config variable is changing to `gpg.recipient`. To update,\n" +
		"change your config from:\n" +
		"\n" +
		"    gpgRecipient = \"...\"\n" +
		"\n" +
		"to:\n" +
		"\n" +
		"    [gpg]\n" +
		"      recipient = \"...\"\n" +
		"\n" +
		"Support for the `gpgRecipient` config variable will be removed in version 2.0.0.\n")
	assets["docs/CONTRIBUTING.md"] = []byte("" +
		"# chezmoi Contributing Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Getting started](#getting-started)\n" +
		"* [Developing locally](#developing-locally)\n" +
		"* [Generated code](#generated-code)\n" +
		"* [Contributing changes](#contributing-changes)\n" +
		"* [Managing releases](#managing-releases)\n" +
		"* [Packaging](#packaging)\n" +
		"* [Updating the website](#updating-the-website)\n" +
		"\n" +
		"## Getting started\n" +
		"\n" +
		"chezmoi is written in [Go](https://golang.org) and development happens on\n" +
		"[GitHub](https://github.com). The rest of this document assumes that you've\n" +
		"checked out chezmoi locally.\n" +
		"\n" +
		"## Developing locally\n" +
		"\n" +
		"chezmoi requires Go 1.13 or later and Go modules enabled. Enable Go modules by\n" +
		"setting the environment variable `GO111MODULE=on`.\n" +
		"\n" +
		"chezmoi is a standard Go project, using standard Go tooling, with a few extra\n" +
		"tools. Ensure that these extra tools are installed with:\n" +
		"\n" +
		"    make ensure-tools\n" +
		"\n" +
		"Build chezmoi:\n" +
		"\n" +
		"    go build .\n" +
		"\n" +
		"Run all tests:\n" +
		"\n" +
		"    go test ./...\n" +
		"\n" +
		"Run chezmoi:\n" +
		"\n" +
		"    go run .\n" +
		"\n" +
		"## Generated code\n" +
		"\n" +
		"chezmoi generates help text, shell completions, embedded files, and the website\n" +
		"from a single source of truth. You must run\n" +
		"\n" +
		"    go generate\n" +
		"\n" +
		"if you change includes any of the following:\n" +
		"\n" +
		"* Modify any documentation in the `docs/` directory.\n" +
		"* Modify any files in the `assets/templates/` directory.\n" +
		"* Add or modify a command.\n" +
		"* Add or modify a command's flags.\n" +
		"\n" +
		"chezmoi's continuous integration verifies that all generated files are up to\n" +
		"date. Changes to generated files should be included in the commit that modifies\n" +
		"the source of truth.\n" +
		"\n" +
		"## Contributing changes\n" +
		"\n" +
		"Bug reports, bug fixes, and documentation improvements are always welcome.\n" +
		"Please [open an issue](https://github.com/twpayne/chezmoi/issues/new/choose) or\n" +
		"[create a pull\n" +
		"request](https://help.github.com/en/articles/creating-a-pull-request) with your\n" +
		"report, fix, or improvement.\n" +
		"\n" +
		"If you want to make a more significant change, please first [open an\n" +
		"issue](https://github.com/twpayne/chezmoi/issues/new/choose) to discuss the\n" +
		"change that you want to make. Dave Cheney gives a [good\n" +
		"rationale](https://dave.cheney.net/2019/02/18/talk-then-code) as to why this is\n" +
		"important.\n" +
		"\n" +
		"All changes are made via pull requests. In your pull request, please make sure\n" +
		"that:\n" +
		"\n" +
		"* All existing tests pass.\n" +
		"\n" +
		"* There are appropriate additional tests that demonstrate that your PR works as\n" +
		"  intended.\n" +
		"\n" +
		"* The documentation is updated, if necessary. For new features you should add an\n" +
		"  entry in `docs/HOWTO.md` and a complete description in `docs/REFERENCE.md`.\n" +
		"\n" +
		"* All generated files are up to date. You can ensure this by running `go\n" +
		"  generate` and including any modified files in your commit.\n" +
		"\n" +
		"* The code is correctly formatted, according to\n" +
		"  [`gofumports`](https://mvdan.cc/gofumpt/gofumports). You can ensure this by\n" +
		"  running `make format`.\n" +
		"\n" +
		"* The code passes [`golangci-lint`](https://github.com/golangci/golangci-lint).\n" +
		"  You can ensure this by running `make lint`.\n" +
		"\n" +
		"* The commit messages match chezmoi's convention, specifically that they begin\n" +
		"  with a capitalized verb in the imperative and give a short description of what\n" +
		"  the commit does. Detailed information or justification can be optionally\n" +
		"  included in the body of the commit message.\n" +
		"\n" +
		"* Commits are logically separate, with no merge or \"fixup\" commits.\n" +
		"\n" +
		"* The branch applies cleanly to `master`.\n" +
		"\n" +
		"## Managing releases\n" +
		"\n" +
		"Releases are managed with [`goreleaser`](https://goreleaser.com/).\n" +
		"\n" +
		"To create a new release, push a tag, e.g.:\n" +
		"\n" +
		"    git tag -a v0.1.0 -m \"First release\"\n" +
		"    git push origin v0.1.0\n" +
		"\n" +
		"To build a test release, without publishing, run:\n" +
		"\n" +
		"    make test-release\n" +
		"\n" +
		"## Packaging\n" +
		"\n" +
		"If you're packaging chezmoi for an operating system or distribution:\n" +
		"\n" +
		"* Please set the version number, git commit, and build time in the binary. This\n" +
		"  greatly assists debugging when end users report problems or ask for help. You\n" +
		"  can do this by passing the following flags to the Go linker:\n" +
		"\n" +
		"  ```\n" +
		"  -X main.version=$VERSION\n" +
		"  -X main.commit=$COMMIT\n" +
		"  -X main.date=$DATE\n" +
		"  -X main.builtBy=$BUILT_BY\n" +
		"  ```\n" +
		"\n" +
		"  `$VERSION` should be the chezmoi version, e.g. `1.7.3`. Any `v` prefix is\n" +
		"  optional and will be stripped, so you can pass the git tag in directly.\n" +
		"\n" +
		"  `$COMMIT` should be the full git commit hash at which chezmoi is built, e.g.\n" +
		"  `4d678ce6850c9d81c7ab2fe0d8f20c1547688b91`.\n" +
		"\n" +
		"  `$DATE` should be the date of the build in RFC3339 format, e.g.\n" +
		"  `2019-11-23T18:29:25Z`.\n" +
		"\n" +
		"  `$BULIT_BY` should be a string indicating what mechanism was used to build the\n" +
		"  binary, e.g. `goreleaser`.\n" +
		"\n" +
		"* Please enable cgo, if possible. chezmoi can be built and run without cgo, but\n" +
		"  the `.chezmoi.username` and `.chezmoi.group` template variables may not be set\n" +
		"  correctly on some systems.\n" +
		"\n" +
		"* chezmoi includes a `docs` command which prints its documentation. By default,\n" +
		"  the docs are embedded in the binary. You can disable this behaviour, and have\n" +
		"  chezmoi read its docs from the filesystem by building with the `noembeddocs`\n" +
		"  build tag and setting the directory where chezmoi can find them with the `-X\n" +
		"  github.com/twpayne/chezmoi/cmd.DocDir=$DOCDIR` linker flag. For example:\n" +
		"\n" +
		"  ```\n" +
		"  go build -tags noembeddocs -ldflags \"-X github.com/twpayne/chezmoi/cmd.DocsDir=/usr/share/doc/chezmoi\" .\n" +
		"  ```\n" +
		"\n" +
		"  To remove the `docs` command completely, use the `nodocs` build tag.\n" +
		"\n" +
		"* chezmoi includes an `upgrade` command which attempts to self-upgrade. You can\n" +
		"  remove this command completely by building chezmoi with the `noupgrade` build\n" +
		"  tag.\n" +
		"\n" +
		"* chezmoi includes shell completions in the `completions` directory. Please\n" +
		"  include these in the package and install them in the shell-appropriate\n" +
		"  directory, if possible.\n" +
		"\n" +
		"* If the instructions for installing chezmoi in chezmoi's [install\n" +
		"  guide](https://github.com/twpayne/chezmoi/blob/master/docs/INSTALL.md) are\n" +
		"  absent or incorrect, please open an issue or submit a PR to correct them.\n" +
		"\n" +
		"## Updating the website\n" +
		"\n" +
		"[The website](https://chezmoi.io) is generated with [Hugo](https://gohugo.io/)\n" +
		"and served with [GitHub pages](https://pages.github.com/) from the [`gh-pages`\n" +
		"branch](https://github.com/twpayne/chezmoi/tree/gh-pages) to GitHub.\n" +
		"\n" +
		"Before building the website, you must download the [Hugo Book\n" +
		"Theme](https://github.com/alex-shpak/hugo-book) by running:\n" +
		"\n" +
		"    git submodule update --init\n" +
		"\n" +
		"Test the website locally by running:\n" +
		"\n" +
		"    ( cd chezmoi.io && hugo serve )\n" +
		"\n" +
		"and visit http://localhost:1313/.\n" +
		"\n" +
		"To build the website in a temporary directory, run:\n" +
		"\n" +
		"    ( cd chezmoi.io && make )\n" +
		"\n" +
		"From here you can run\n" +
		"\n" +
		"    git show\n" +
		"\n" +
		"to show changes and\n" +
		"\n" +
		"    git push\n" +
		"\n" +
		"to push them. You can only push changes if you have write permissions to the\n" +
		"chezmoi GitHub repo.\n")
	assets["docs/FAQ.md"] = []byte("" +
		"# chezmoi Frequently Asked Questions\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [How can I quickly check for problems with chezmoi on my machine?](#how-can-i-quickly-check-for-problems-with-chezmoi-on-my-machine)\n" +
		"* [What are the consequences of \"bare\" modifications to the target files? If my `.zshrc` is managed by chezmoi and I edit `~/.zshrc` without using `chezmoi edit`, what happens?](#what-are-the-consequences-of-bare-modifications-to-the-target-files-if-my-zshrc-is-managed-by-chezmoi-and-i-edit-zshrc-without-using-chezmoi-edit-what-happens)\n" +
		"* [How can I tell what dotfiles in my home directory aren't managed by chezmoi? Is there an easy way to have chezmoi manage a subset of them?](#how-can-i-tell-what-dotfiles-in-my-home-directory-arent-managed-by-chezmoi-is-there-an-easy-way-to-have-chezmoi-manage-a-subset-of-them)\n" +
		"* [How can I tell what dotfiles in my home directory are currently managed by chezmoi?](#how-can-i-tell-what-dotfiles-in-my-home-directory-are-currently-managed-by-chezmoi)\n" +
		"* [If there's a mechanism in place for the above, is there also a way to tell chezmoi to ignore specific files or groups of files (e.g. by directory name or by glob)?](#if-theres-a-mechanism-in-place-for-the-above-is-there-also-a-way-to-tell-chezmoi-to-ignore-specific-files-or-groups-of-files-eg-by-directory-name-or-by-glob)\n" +
		"* [If the target already exists, but is \"behind\" the source, can chezmoi be configured to preserve the target version before replacing it with one derived from the source?](#if-the-target-already-exists-but-is-behind-the-source-can-chezmoi-be-configured-to-preserve-the-target-version-before-replacing-it-with-one-derived-from-the-source)\n" +
		"* [Once I've made a change to the source directory, how do I commit it?](#once-ive-made-a-change-to-the-source-directory-how-do-i-commit-it)\n" +
		"* [How do I only run a script when a file has changed?](#how-do-i-only-run-a-script-when-a-file-has-changed)\n" +
		"* [I've made changes to both the destination state and the source state that I want to keep. How can I keep them both?](#ive-made-changes-to-both-the-destination-state-and-the-source-state-that-i-want-to-keep-how-can-i-keep-them-both)\n" +
		"* [Why does chezmoi convert all my template variables to lowercase?](#why-does-chezmoi-convert-all-my-template-variables-to-lowercase)\n" +
		"* [chezmoi makes `~/.ssh/config` group writeable. How do I stop this?](#chezmoi-makes-sshconfig-group-writeable-how-do-i-stop-this)\n" +
		"* [chezmoi's source file naming system cannot handle all possible filenames](#chezmois-source-file-naming-system-cannot-handle-all-possible-filenames)\n" +
		"* [gpg encryption fails. What could be wrong?](#gpg-encryption-fails-what-could-be-wrong)\n" +
		"* [I'm getting errors trying to build chezmoi from source](#im-getting-errors-trying-to-build-chezmoi-from-source)\n" +
		"* [What inspired chezmoi?](#what-inspired-chezmoi)\n" +
		"* [Can I use chezmoi to manage files outside my home directory?](#can-i-use-chezmoi-to-manage-files-outside-my-home-directory)\n" +
		"* [Where does the name \"chezmoi\" come from?](#where-does-the-name-chezmoi-come-from)\n" +
		"* [What other questions have been asked about chezmoi?](#what-other-questions-have-been-asked-about-chezmoi)\n" +
		"* [Where do I ask a question that isn't answered here?](#where-do-i-ask-a-question-that-isnt-answered-here)\n" +
		"* [I like chezmoi. How do I say thanks?](#i-like-chezmoi-how-do-i-say-thanks)\n" +
		"\n" +
		"## How can I quickly check for problems with chezmoi on my machine?\n" +
		"\n" +
		"Run:\n" +
		"\n" +
		"    chezmoi doctor\n" +
		"\n" +
		"Anything `ok` is fine, anything `warning` is only a problem if you want to use\n" +
		"the related feature, and anything `error` indicates a definite problem.\n" +
		"\n" +
		"## What are the consequences of \"bare\" modifications to the target files? If my `.zshrc` is managed by chezmoi and I edit `~/.zshrc` without using `chezmoi edit`, what happens?\n" +
		"\n" +
		"chezmoi will overwrite the file the next time you run `chezmoi apply`. Until you\n" +
		"run `chezmoi apply` your modified `~/.zshrc` will remain in place.\n" +
		"\n" +
		"## How can I tell what dotfiles in my home directory aren't managed by chezmoi? Is there an easy way to have chezmoi manage a subset of them?\n" +
		"\n" +
		"`chezmoi unmanaged` will list everything not managed by chezmoi. You can add\n" +
		"entire directories with `chezmoi add -r`.\n" +
		"\n" +
		"## How can I tell what dotfiles in my home directory are currently managed by chezmoi?\n" +
		"\n" +
		"`chezmoi managed` will list everything managed by chezmoi.\n" +
		"\n" +
		"## If there's a mechanism in place for the above, is there also a way to tell chezmoi to ignore specific files or groups of files (e.g. by directory name or by glob)?\n" +
		"\n" +
		"By default, chezmoi ignores everything that you haven't explicitly `chezmoi\n" +
		"add`'ed. If have files in your source directory that you don't want added to\n" +
		"your destination directory when you run `chezmoi apply` add their names to a\n" +
		"file called `.chezmoiignore` in the source state.\n" +
		"\n" +
		"Patterns are supported, and the you can change what's ignored from machine to\n" +
		"machine. The full usage and syntax is described in the [reference\n" +
		"manual](https://github.com/twpayne/chezmoi/blob/master/docs/REFERENCE.md#chezmoiignore).\n" +
		"\n" +
		"## If the target already exists, but is \"behind\" the source, can chezmoi be configured to preserve the target version before replacing it with one derived from the source?\n" +
		"\n" +
		"Yes. Run `chezmoi add` will update the source state with the target. To see\n" +
		"diffs of what would change, without actually changing anything, use `chezmoi\n" +
		"diff`.\n" +
		"\n" +
		"## Once I've made a change to the source directory, how do I commit it?\n" +
		"\n" +
		"You have several options:\n" +
		"\n" +
		"* `chezmoi cd` opens a shell in the source directory, where you can run your\n" +
		"  usual version control commands, like `git add` and `git commit`.\n" +
		"* `chezmoi git` and `chezmoi hg` run `git` and `hg` respectively in the source\n" +
		"  directory and pass extra arguments to the command. If you're passing any\n" +
		"  flags, you'll need to use `--` to prevent chezmoi from consuming them, for\n" +
		"  example `chezmoi git -- commit -m \"Update dotfiles\"`.\n" +
		"* `chezmoi source` runs your configured version control system in your source\n" +
		"  directory. It works in the same way as the `chezmoi git` and `chezmoi hg`\n" +
		"  commands, but uses `sourceVCS.command`.\n" +
		"\n" +
		"## How do I only run a script when a file has changed?\n" +
		"\n" +
		"A common example of this is that you're using [Homebrew](https://brew.sh/) and\n" +
		"have `.Brewfile` listing all the packages that you want installed and only want\n" +
		"to run `brew bundle --global` when the contents of `.Brewfile` have changed.\n" +
		"\n" +
		"chezmoi has two types of scripts: scripts that run every time, and scripts that\n" +
		"only run when their contents change. chezmoi does not have a mechanism to run a\n" +
		"script when an arbitrary file has changed, but there are some ways to achieve\n" +
		"the desired behavior:\n" +
		"\n" +
		"1. Have the script create `.Brewfile` instead of chezmoi, e.g. in your\n" +
		"   `run_once_install-packages`:\n" +
		"\n" +
		"   ```sh\n" +
		"   #!/bin/sh\n" +
		"\n" +
		"   cat > $HOME/.Brewfile <<EOF\n" +
		"   brew \"imagemagick\"\n" +
		"   brew \"openssl\"\n" +
		"   EOF\n" +
		"\n" +
		"   brew bundle --global\n" +
		"   ```\n" +
		"\n" +
		"2. Don't use `.Brewfile`, and instead install the packages explicitly in\n" +
		"   `run_once_install-packages`:\n" +
		"\n" +
		"   ```sh\n" +
		"   #!/bin/sh\n" +
		"\n" +
		"   brew install imagemagick || true\n" +
		"   brew install openssl || true\n" +
		"   ```\n" +
		"\n" +
		"   The `|| true` is necessary because `brew install` exits with failure if the\n" +
		"   package is already installed.\n" +
		"\n" +
		"3. Use a script that runs every time (not just once) and rely on `brew bundle\n" +
		"   --global` being idempotent.\n" +
		"\n" +
		"4. Use a script that runs every time, records a checksum of `.Brewfile` in\n" +
		"   another file, and only runs `brew bundle --global` if the checksum has\n" +
		"   changed, and updates the recorded checksum after.\n" +
		"\n" +
		"## I've made changes to both the destination state and the source state that I want to keep. How can I keep them both?\n" +
		"\n" +
		"`chezmoi merge` will open a merge tool to resolve differences between the source\n" +
		"state, target state, and destination state. Copy the changes you want to keep in\n" +
		"to the source state.\n" +
		"\n" +
		"## Why does chezmoi convert all my template variables to lowercase?\n" +
		"\n" +
		"This is due to a feature in\n" +
		"[`github.com/spf13/viper`](https://github.com/spf13/viper), the library that\n" +
		"chezmoi uses to read its configuration file. For more information see [this\n" +
		"GitHub issue issue](https://github.com/twpayne/chezmoi/issues/463).\n" +
		"\n" +
		"## chezmoi makes `~/.ssh/config` group writeable. How do I stop this?\n" +
		"\n" +
		"By default, chezmoi uses your system's umask when creating files. On most\n" +
		"systems the default umask is `0o22` but some systems use `0o02`, which means\n" +
		"that files and directories are group writeable by default.\n" +
		"\n" +
		"You can override this for chezmoi by setting the `umask` configuration variable\n" +
		"in your configuration file, for example:\n" +
		"\n" +
		"    umask = 0o22\n" +
		"\n" +
		"Note that this will apply to all files and directories that chezmoi manages and\n" +
		"will ensure that none of them are group writeable. It is not currently possible\n" +
		"to control group writability for individual files or directories. Please [open\n" +
		"an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new?assignees=&labels=enhancement&template=02_feature_request.md&title=)\n" +
		"if you need this.\n" +
		"\n" +
		"## chezmoi's source file naming system cannot handle all possible filenames\n" +
		"\n" +
		"This is correct. Certain target filenames, for example `~/dot_example`, are\n" +
		"incompatible with chezmoi's\n" +
		"[attributes](https://github.com/twpayne/chezmoi/blob/master/docs/REFERENCE.md#source-state-attributes)\n" +
		"used in the source state.\n" +
		"\n" +
		"This is a deliberate, practical compromise. Target state metadata (private,\n" +
		"encrypted, etc.) need to be stored for each file. Using the source state\n" +
		"filename for this means that the contents of the file are untouched, there is no\n" +
		"need to maintain the metadata in a separate file, is independent of the\n" +
		"underlying filesystem and version control system, and unambiguously associates\n" +
		"the metadata with a single file.\n" +
		"\n" +
		"In practice, dotfile filenames are unlikely to conflict with chezmoi's\n" +
		"attributes. If this does cause a genuine problem for you, please [open an\n" +
		"issue on GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"## gpg encryption fails. What could be wrong?\n" +
		"\n" +
		"The `gpg.recipient` key should be ultimately trusted, otherwise encryption will\n" +
		"fail because gpg will prompt for input, which chezmoi does not handle. You can\n" +
		"check the trust level by running:\n" +
		"\n" +
		"    gpg --export-ownertrust\n" +
		"\n" +
		"The trust level for the recipient's key should be `6`. If it is not, you can\n" +
		"change the trust level by running:\n" +
		"\n" +
		"    gpg --edit-key $recipient\n" +
		"\n" +
		"Enter `trust` at the prompt and chose `5 = I trust ultimately`.\n" +
		"\n" +
		"## I'm getting errors trying to build chezmoi from source\n" +
		"\n" +
		"chezmoi requires Go version 1.13 or later and Go modules enabled. You can check\n" +
		"the version of Go with:\n" +
		"\n" +
		"    go version\n" +
		"\n" +
		"Enable Go modules by setting `GO111MODULE=on` when running `go get`:\n" +
		"\n" +
		"    GO111MODULE=on go get -u github.com/twpayne/chezmoi\n" +
		"\n" +
		"For more details on building chezmoi, see the [Contributing\n" +
		"Guide](CONTRIBUTING.md).\n" +
		"\n" +
		"## What inspired chezmoi?\n" +
		"\n" +
		"chezmoi was inspired by [Puppet](https://puppet.com/), but created because\n" +
		"Puppet is a slow overkill for managing your personal configuration files. The\n" +
		"focus of chezmoi will always be personal home directory management. If your\n" +
		"needs grow beyond that, switch to a whole system configuration management tool.\n" +
		"\n" +
		"## Can I use chezmoi to manage files outside my home directory?\n" +
		"\n" +
		"In practice, yes, you can, but this is strongly discouraged beyond using your\n" +
		"system's package manager to install the packages you need.\n" +
		"\n" +
		"chezmoi is designed to operate on your home directory, and is explicitly not a\n" +
		"full system configuration management tool. That said, there are some ways to\n" +
		"have chezmoi manage a few files outside your home directory.\n" +
		"\n" +
		"chezmoi's scripts can execute arbitrary commands, so you can use a `run_` script\n" +
		"that is run every time you run `chezmoi apply`, to, for example:\n" +
		"\n" +
		"* Make the target file outside your home directory a symlink to a file managed\n" +
		"  by chezmoi in your home directory.\n" +
		"* Copy a file managed by chezmoi inside your home directory to the target file.\n" +
		"* Execute a template with `chezmoi execute-template --output=filename template`\n" +
		"  where `filename` is outside the target directory.\n" +
		"\n" +
		"chezmoi executes all scripts as the user executing chezmoi, so you may need to\n" +
		"add extra privilege elevation commands like `sudo` or `PowerShell start -verb\n" +
		"runas -wait` to your script.\n" +
		"\n" +
		"chezmoi, by default, operates on your home directory but this can be overridden\n" +
		"with the `--destination` command line flag or by specifying `destDir` in your\n" +
		"config file, and could even be the root directory (`/` or `C:\\`). This allows\n" +
		"you, in theory, to use chezmoi to manage any file in your filesystem, but this\n" +
		"usage is extremely strongly discouraged.\n" +
		"\n" +
		"If your needs extend beyond modifying a handful of files outside your target\n" +
		"system, then existing configuration management tools like\n" +
		"[Puppet](https://puppet.com/), [Chef](https://www.chef.io/chef/),\n" +
		"[Ansible](https://www.ansible.com/), and [Salt](https://www.saltstack.com/) are\n" +
		"much better suited - and of couse can be called from a chezmoi `run_` script.\n" +
		"Put your Puppet Manifests, Chef Recipes, Ansible Modules, and Salt Modules in a\n" +
		"directory ignored by `.chezmoiignore` so they do not pollute your home\n" +
		"directory. \n" +
		"\n" +
		"## Where does the name \"chezmoi\" come from?\n" +
		"\n" +
		"\"chezmoi\" splits to \"chez moi\" and pronounced /ʃeɪ mwa/ (shay-moi) meaning \"at\n" +
		"my house\" in French. It's seven letters long, which is an appropriate length for\n" +
		"a command that is only run occasionally.\n" +
		"\n" +
		"## What other questions have been asked about chezmoi?\n" +
		"\n" +
		"See the [issues on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues?utf8=%E2%9C%93&q=is%3Aissue+sort%3Aupdated-desc+label%3Asupport).\n" +
		"\n" +
		"## Where do I ask a question that isn't answered here?\n" +
		"\n" +
		"Please [open an issue on GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"## I like chezmoi. How do I say thanks?\n" +
		"\n" +
		"Thank you! chezmoi was written to scratch a personal itch, and I'm very happy\n" +
		"that it's useful to you. Please give [chezmoi a star on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/stargazers), and if you're happy to\n" +
		"share your public dotfile repo then [tag it with\n" +
		"`chezmoi`](https://github.com/topics/chezmoi). [Contributions are very\n" +
		"welcome](https://github.com/twpayne/chezmoi/blob/master/docs/CONTRIBUTING.md)\n" +
		"and every [bug report, support request, and feature\n" +
		"request](https://github.com/twpayne/chezmoi/issues/new/choose) helps make\n" +
		"chezmoi better. Thank you :)\n" +
		"\n")
	assets["docs/HOWTO.md"] = []byte("" +
		"# chezmoi How-To Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Use a hosted repo to manage your dotfiles across multiple machines](#use-a-hosted-repo-to-manage-your-dotfiles-across-multiple-machines)\n" +
		"* [Pull the latest changes from your repo and apply them](#pull-the-latest-changes-from-your-repo-and-apply-them)\n" +
		"* [Pull the latest changes from your repo and see what would change, without actually applying the changes](#pull-the-latest-changes-from-your-repo-and-see-what-would-change-without-actually-applying-the-changes)\n" +
		"* [Automatically commit and push changes to your repo](#automatically-commit-and-push-changes-to-your-repo)\n" +
		"* [Use templates to manage files that vary from machine to machine](#use-templates-to-manage-files-that-vary-from-machine-to-machine)\n" +
		"* [Use completely separate config files on different machines](#use-completely-separate-config-files-on-different-machines)\n" +
		"* [Create a config file on a new machine automatically](#create-a-config-file-on-a-new-machine-automatically)\n" +
		"* [Have chezmoi create a directory, but ignore its contents](#have-chezmoi-create-a-directory-but-ignore-its-contents)\n" +
		"* [Ensure that a target is removed](#ensure-that-a-target-is-removed)\n" +
		"* [Include a subdirectory from another repository, like Oh My Zsh](#include-a-subdirectory-from-another-repository-like-oh-my-zsh)\n" +
		"* [Handle configuration files which are externally modified](#handle-configuration-files-which-are-externally-modified)\n" +
		"* [Keep data private](#keep-data-private)\n" +
		"  * [Use Bitwarden to keep your secrets](#use-bitwarden-to-keep-your-secrets)\n" +
		"  * [Use gopass to keep your secrets](#use-gopass-to-keep-your-secrets)\n" +
		"  * [Use gpg to keep your secrets](#use-gpg-to-keep-your-secrets)\n" +
		"  * [Use KeePassXC to keep your secrets](#use-keepassxc-to-keep-your-secrets)\n" +
		"  * [Use a keyring to keep your secrets](#use-a-keyring-to-keep-your-secrets)\n" +
		"  * [Use LastPass to keep your secrets](#use-lastpass-to-keep-your-secrets)\n" +
		"  * [Use 1Password to keep your secrets](#use-1password-to-keep-your-secrets)\n" +
		"  * [Use pass to keep your secrets](#use-pass-to-keep-your-secrets)\n" +
		"  * [Use Vault to keep your secrets](#use-vault-to-keep-your-secrets)\n" +
		"  * [Use a generic tool to keep your secrets](#use-a-generic-tool-to-keep-your-secrets)\n" +
		"  * [Use templates variables to keep your secrets](#use-templates-variables-to-keep-your-secrets)\n" +
		"* [Use scripts to perform actions](#use-scripts-to-perform-actions)\n" +
		"  * [Understand how scripts work](#understand-how-scripts-work)\n" +
		"  * [Install packages with scripts](#install-packages-with-scripts)\n" +
		"* [Import archives](#import-archives)\n" +
		"* [Export archives](#export-archives)\n" +
		"* [Use a non-git version control system](#use-a-non-git-version-control-system)\n" +
		"* [Customize the `diff` command](#customize-the-diff-command)\n" +
		"* [Use a merge tool other than vimdiff](#use-a-merge-tool-other-than-vimdiff)\n" +
		"* [Migrate from a dotfile manager that uses symlinks](#migrate-from-a-dotfile-manager-that-uses-symlinks)\n" +
		"\n" +
		"## Use a hosted repo to manage your dotfiles across multiple machines\n" +
		"\n" +
		"chezmoi relies on your version control system and hosted repo to share changes\n" +
		"across multiple machines. You should create a repo on the source code repository\n" +
		"of your choice (e.g. [Bitbucket](https://bitbucket.org),\n" +
		"[GitHub](https://github.com/), or [GitLab](https://gitlab.com), many people call\n" +
		"their repo `dotfiles`) and push the repo in the source directory here. For\n" +
		"example:\n" +
		"\n" +
		"    chezmoi cd\n" +
		"    git remote add origin https://github.com/username/dotfiles.git\n" +
		"    git push -u origin master\n" +
		"    exit\n" +
		"\n" +
		"On another machine you can checkout this repo:\n" +
		"\n" +
		"    chezmoi init https://github.com/username/dotfiles.git\n" +
		"\n" +
		"You can then see what would be changed:\n" +
		"\n" +
		"    chezmoi diff\n" +
		"\n" +
		"If you're happy with the changes then apply them:\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"The above commands can be combined into a single init, checkout, and apply:\n" +
		"\n" +
		"    chezmoi init --apply --verbose https://github.com/username/dotfiles.git\n" +
		"\n" +
		"## Pull the latest changes from your repo and apply them\n" +
		"\n" +
		"You can pull the changes from your repo and apply them in a single command:\n" +
		"\n" +
		"    chezmoi update\n" +
		"\n" +
		"This runs `git pull --rebase` in your source directory and then `chezmoi apply`.\n" +
		"\n" +
		"## Pull the latest changes from your repo and see what would change, without actually applying the changes\n" +
		"\n" +
		"Run:\n" +
		"\n" +
		"    chezmoi source pull -- --rebase && chezmoi diff\n" +
		"\n" +
		"This runs `git pull --rebase` in your source directory and `chezmoi\n" +
		"diff` then shows the difference between the target state computed from your\n" +
		"source directory and the actual state.\n" +
		"\n" +
		"If you're happy with the changes, then you can run\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"to apply them.\n" +
		"\n" +
		"## Automatically commit and push changes to your repo\n" +
		"\n" +
		"chezmoi can automatically commit and push changes to your source directory to\n" +
		"your repo. This feature is disabled by default. To enable it, add the following\n" +
		"to your config file:\n" +
		"\n" +
		"    [sourceVCS]\n" +
		"        autoCommit = true\n" +
		"        autoPush = true\n" +
		"\n" +
		"Whenever a change is made to your source directory, chezmoi will commit the\n" +
		"changes with an automatically-generated commit message (if `autoCommit` is true)\n" +
		"and push them to your repo (if `autoPush` is true). `autoPush` implies\n" +
		"`autoCommit`, i.e. if `autoPush` is true then chezmoi will auto-commit your\n" +
		"changes. If you only set `autoCommit` to true then changes will be committed but\n" +
		"not pushed.\n" +
		"\n" +
		"Be careful when using `autoPush`. If your dotfiles repo is public and you\n" +
		"accidentally add a secret in plain text, that secret will be pushed to your\n" +
		"public repo.\n" +
		"\n" +
		"## Use templates to manage files that vary from machine to machine\n" +
		"\n" +
		"The primary goal of chezmoi is to manage configuration files across multiple\n" +
		"machines, for example your personal macOS laptop, your work Ubuntu desktop, and\n" +
		"your work Linux laptop. You will want to keep much configuration the same across\n" +
		"these, but also need machine-specific configurations for email addresses,\n" +
		"credentials, etc. chezmoi achieves this functionality by using\n" +
		"[`text/template`](https://pkg.go.dev/text/template) for the source state where\n" +
		"needed.\n" +
		"\n" +
		"For example, your home `~/.gitconfig` on your personal machine might look like:\n" +
		"\n" +
		"    [user]\n" +
		"      email = \"john@home.org\"\n" +
		"\n" +
		"Whereas at work it might be:\n" +
		"\n" +
		"    [user]\n" +
		"      email = \"john.smith@company.com\"\n" +
		"\n" +
		"To handle this, on each machine create a configuration file called\n" +
		"`~/.config/chezmoi/chezmoi.toml` defining variables that might vary from machine\n" +
		"to machine. For example, for your home machine:\n" +
		"\n" +
		"    [data]\n" +
		"      email = \"john@home.org\"\n" +
		"\n" +
		"Note that all variable names will be converted to lowercase. This is due to a\n" +
		"feature of a library used by chezmoi.\n" +
		"\n" +
		"If you intend to store private data (e.g. access tokens) in\n" +
		"`~/.config/chezmoi/chezmoi.toml`, make sure it has permissions `0600`.\n" +
		"\n" +
		"If you prefer, you can use any format supported by\n" +
		"[Viper](https://github.com/spf13/viper) for your configuration file. This\n" +
		"includes JSON, YAML, and TOML. Variable names must start with a letter and be\n" +
		"followed by zero or more letters or digits.\n" +
		"\n" +
		"Then, add `~/.gitconfig` to chezmoi using the `--autotemplate` flag to turn it\n" +
		"into a template and automatically detect variables from the `data` section\n" +
		"of your `~/.config/chezmoi/chezmoi.toml` file:\n" +
		"\n" +
		"    chezmoi add --autotemplate ~/.gitconfig\n" +
		"\n" +
		"You can then open the template (which will be saved in the file\n" +
		"`~/.local/share/chezmoi/dot_gitconfig.tmpl`):\n" +
		"\n" +
		"    chezmoi edit ~/.gitconfig\n" +
		"\n" +
		"The file should look something like:\n" +
		"\n" +
		"    [user]\n" +
		"      email = \"{{ .email }}\"\n" +
		"\n" +
		"To disable automatic variable detection, use the `--template` or `-T` option to\n" +
		"`chezmoi add` instead of `--autotemplate`.\n" +
		"\n" +
		"Templates are often used to capture machine-specifc differences. For example, in\n" +
		"your `~/.local/share/chezmoi/dot_bashrc.tmpl` you might have:\n" +
		"\n" +
		"    # common config\n" +
		"    export EDITOR=vi\n" +
		"\n" +
		"    # machine-specific configuration\n" +
		"    {{- if eq .chezmoi.hostname \"work-laptop\" }}\n" +
		"    # this will only be included in ~/.bashrc on work-laptop\n" +
		"    {{- end }}\n" +
		"\n" +
		"For a full list of variables, run:\n" +
		"\n" +
		"    chezmoi data\n" +
		"\n" +
		"For more advanced usage, you can use the full power of the\n" +
		"[`text/template`](https://pkg.go.dev/text/template) language. chezmoi includes\n" +
		"all of the text functions from [sprig](http://masterminds.github.io/sprig/) and\n" +
		"its own [functions for interacting with password\n" +
		"managers](https://github.com/twpayne/chezmoi/blob/master/docs/REFERENCE.md#template-functions).\n" +
		"\n" +
		"Templates can be executed directly from the command line, without the need to\n" +
		"create a file on disk, with the `execute-template` command, for example:\n" +
		"\n" +
		"    chezmoi execute-template '{{ .chezmoi.os }}/{{ .chezmoi.arch }}'\n" +
		"\n" +
		"This is useful when developing or debugging templates.\n" +
		"\n" +
		"Some password managers allow you to store complete files. The files can be\n" +
		"retrieved with chezmoi's template functions. For example, if you have a file\n" +
		"stored in 1Password with the UUID `uuid` then you can retrieve it with the\n" +
		"template:\n" +
		"\n" +
		"    {{- onepasswordDocument \"uuid\" -}}\n" +
		"\n" +
		"The `-`s inside the brackets remove any whitespace before or after the template\n" +
		"expression, which is useful if your editor has added any newlines.\n" +
		"\n" +
		"If, after executing the template, the file contents are empty, the target file\n" +
		"will be removed. This can be used to ensure that files are only present on\n" +
		"certain machines. If you want an empty file to be created anyway, you will need\n" +
		"to give it an `empty_` prefix.\n" +
		"\n" +
		"For coarser-grained control of files and entire directories are managed on\n" +
		"different machines, or to exclude certain files completely, you can create\n" +
		"`.chezmoiignore` files in the source directory. These specify a list of patterns\n" +
		"that chezmoi should ignore, and are interpreted as templates. An example\n" +
		"`.chezmoiignore` file might look like:\n" +
		"\n" +
		"    README.md\n" +
		"    {{- if ne .chezmoi.hostname \"work-laptop\" }}\n" +
		"    .work # only manage .work on work-laptop\n" +
		"    {{- end }}\n" +
		"\n" +
		"Patterns can be excluded by prefixing them with a `!`, for example:\n" +
		"\n" +
		"    f*\n" +
		"    !foo\n" +
		"\n" +
		"will ignore all files beginning with an `f` except `foo`.\n" +
		"\n" +
		"## Use completely separate config files on different machines\n" +
		"\n" +
		"chezmoi's templating functionality allows you to change a file's contents based\n" +
		"on any variable. For example, if you want `~/.bashrc` to be different on Linux\n" +
		"and macOS you would create a file in the source state called `dot_bashrc.tmpl`\n" +
		"containing:\n" +
		"\n" +
		"```\n" +
		"{{ if eq .chezmoi.os \"darwin\" -}}\n" +
		"# macOS .bashrc contents\n" +
		"{{ else if eq .chezmoi.os \"linux\" -}}\n" +
		"# Linux .bashrc contents\n" +
		"{{ end -}}\n" +
		"```\n" +
		"\n" +
		"However, if the differences between the two versions are so large that you'd\n" +
		"prefer to use completely separate files in the source state, you can achieve\n" +
		"this using a templated symbolic link. Create the following files:\n" +
		"\n" +
		"`symlink_dot_bashrc.tmpl`:\n" +
		"\n" +
		"```\n" +
		".bashrc_{{ .chezmoi.os }}\n" +
		"```\n" +
		"\n" +
		"`dot_bashrc_darwin`:\n" +
		"\n" +
		"```\n" +
		"# macOS .bashrc contents\n" +
		"```\n" +
		"\n" +
		"`dot_bashrc_linux`:\n" +
		"\n" +
		"```\n" +
		"# Linux .bashrc contents\n" +
		"```\n" +
		"\n" +
		"`.chezmoiignore`\n" +
		"\n" +
		"```\n" +
		"{{ if ne .chezmoi.os \"darwin\" }}\n" +
		".bashrc_darwin\n" +
		"{{ end }}\n" +
		"{{ if ne .chezmoi.os \"linux\" }}\n" +
		".bashrc_linux\n" +
		"{{ end }}\n" +
		"```\n" +
		"\n" +
		"This will make `~/.bashrc` will be a symlink to `.bashrc_darwin` on `darwin` and\n" +
		"to `.bashrc_linux`. The `.chezmoiignore` configuration ensures that only the\n" +
		"OS-specific `.bashrc_os` file will be installed on each OS.\n" +
		"\n" +
		"## Create a config file on a new machine automatically\n" +
		"\n" +
		"`chezmoi init` can also create a config file automatically, if one does not\n" +
		"already exist. If your repo contains a file called `.chezmoi.<format>.tmpl`\n" +
		"where *format* is one of the supported config file formats (e.g. `json`, `toml`,\n" +
		"or `yaml`) then `chezmoi init` will execute that template to generate your\n" +
		"initial config file.\n" +
		"\n" +
		"Specifically, if you have `.chezmoi.toml.tmpl` that looks like this:\n" +
		"\n" +
		"    {{- $email := promptString \"email\" -}}\n" +
		"    [data]\n" +
		"        email = \"{{ $email }}\"\n" +
		"\n" +
		"Then `chezmoi init` will create an initial `chezmoi.toml` using this template.\n" +
		"`promptString` is a special function that prompts the user (you) for a value.\n" +
		"\n" +
		"To test this template, use `chezmoi execute-template` with the `--init` and\n" +
		"`--promptString` flags, for example:\n" +
		"\n" +
		"    chezmoi execute-template --init --promptString email=john@home.org < ~/.local/share/chezmoi/.chezmoi.toml.tmpl\n" +
		"\n" +
		"## Have chezmoi create a directory, but ignore its contents\n" +
		"\n" +
		"If you want chezmoi to create a directory, but ignore its contents, say `~/src`,\n" +
		"first run:\n" +
		"\n" +
		"    mkdir -p $(chezmoi source-path)/src\n" +
		"\n" +
		"This creates the directory in the source state, which means that chezmoi will\n" +
		"create it (if it does not already exist) when you run `chezmoi apply`.\n" +
		"\n" +
		"However, as this is an empty directory it will be ignored by git. So, create a\n" +
		"file in the directory in the source state that will be seen by git (so git does\n" +
		"not ignore the directory) but ignored by chezmoi (so chezmoi does not include it\n" +
		"in the target state):\n" +
		"\n" +
		"    touch $(chezmoi source-path)/src/.keep\n" +
		"\n" +
		"chezmoi automatically creates `.keep` files when you add an empty directory with\n" +
		"`chezmoi add`.\n" +
		"\n" +
		"## Ensure that a target is removed\n" +
		"\n" +
		"Create a file called `.chezmoiremove` in the source directory containing a list\n" +
		"of patterns of files to remove. When you run\n" +
		"\n" +
		"    chezmoi apply --remove\n" +
		"\n" +
		"chezmoi will remove anything in the target directory that matches the pattern.\n" +
		"As this command is potentially dangerous, you should run chezmoi in verbose,\n" +
		"dry-run mode beforehand to see what would be removed:\n" +
		"\n" +
		"    chezmoi apply --remove --dry-run --verbose\n" +
		"\n" +
		"`.chezmoiremove` is interpreted as a template, so you can remove different files\n" +
		"on different machines. Negative matches (patterns prefixed with a `!`) or\n" +
		"targets listed in `.chezmoiignore` will never be removed.\n" +
		"\n" +
		"## Include a subdirectory from another repository, like Oh My Zsh\n" +
		"\n" +
		"To include a subdirectory from another repository, e.g. [Oh My\n" +
		"Zsh](https://github.com/robbyrussell/oh-my-zsh), you cannot use git submodules\n" +
		"because chezmoi uses its own format for the source state and Oh My Zsh is not\n" +
		"distributed in this format. Instead, you can use the `import` command to import\n" +
		"a snapshot from a tarball:\n" +
		"\n" +
		"    curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-zsh/archive/master.tar.gz\n" +
		"    chezmoi import --strip-components 1 --destination ${HOME}/.oh-my-zsh oh-my-zsh-master.tar.gz\n" +
		"\n" +
		"Add `oh-my-zsh-master.tar.gz` to `.chezmoiignore` if you run these commands in\n" +
		"your source directory so that chezmoi doesn't try to copy the tarball anywhere.\n" +
		"\n" +
		"Disable Oh My Zsh auto-updates by setting `DISABLE_AUTO_UPDATE=\"true\"` in\n" +
		"`~/.zshrc`. Auto updates will cause the `~/.oh-my-zsh` directory to drift out of\n" +
		"sync with chezmoi's source state. To update Oh My Zsh, re-run the `curl` and\n" +
		"`chezmoi import` commands above.\n" +
		"\n" +
		"## Handle configuration files which are externally modified\n" +
		"\n" +
		"Some programs modify their configuration files. When you next run `chezmoi\n" +
		"apply`, any modifications made by the program will be lost.\n" +
		"\n" +
		"You can track changes to these files by replacing with a symlink back to a file\n" +
		"in your source directory, which is under version control. Here is a worked\n" +
		"example for VSCode's `settings.json` on Linux:\n" +
		"\n" +
		"Copy the configuration file to your source directory:\n" +
		"\n" +
		"    cp ~/.config/Code/User/settings.json $(chezmoi source-path)\n" +
		"\n" +
		"Tell chezmoi to ignore this file:\n" +
		"\n" +
		"    echo settings.json >> $(chezmoi source-path)/.chezmoiignore\n" +
		"\n" +
		"Tell chezmoi that `~/.config/Code/User/settings.json` should be a symlink to the\n" +
		"file in your source directory:\n" +
		"\n" +
		"    mkdir -p $(chezmoi source-path)/private_dot_config/private_Code/User\n" +
		"    echo -n \"{{ .chezmoi.sourceDir }}/settings.json\" > $(chezmoi source-path)/private_dot_config/private_Code/User/symlink_settings.json.tmpl\n" +
		"\n" +
		"The prefix `private_` is used because the `~/.config` and `~/.config/Code`\n" +
		"directories are private by default.\n" +
		"\n" +
		"Apply the changes:\n" +
		"\n" +
		"    chezmoi apply -v\n" +
		"\n" +
		"Now, when the program modifies its configuration file it will modify the file in\n" +
		"the source state instead.\n" +
		"\n" +
		"## Keep data private\n" +
		"\n" +
		"chezmoi automatically detects when files and directories are private when adding\n" +
		"them by inspecting their permissions. Private files and directories are stored\n" +
		"in `~/.local/share/chezmoi` as regular, public files with permissions `0644` and\n" +
		"the name prefix `private_`. For example:\n" +
		"\n" +
		"    chezmoi add ~/.netrc\n" +
		"\n" +
		"will create `~/.local/share/chezmoi/private_dot_netrc` (assuming `~/.netrc` is\n" +
		"not world- or group- readable, as it should be). This file is still private\n" +
		"because `~/.local/share/chezmoi` is not group- or world- readable or executable.\n" +
		"chezmoi checks that the permissions of `~/.local/share/chezmoi` are `0700` on\n" +
		"every run and will print a warning if they are not.\n" +
		"\n" +
		"It is common that you need to store access tokens in config files, e.g. a\n" +
		"[GitHub access\n" +
		"token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/).\n" +
		"There are several ways to keep these tokens secure, and to prevent them leaving\n" +
		"your machine.\n" +
		"\n" +
		"### Use Bitwarden to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [Bitwarden](https://bitwarden.com/) using the\n" +
		"[Bitwarden CLI](https://github.com/bitwarden/cli) to expose data as a template\n" +
		"function.\n" +
		"\n" +
		"Log in to Bitwarden using:\n" +
		"\n" +
		"    bw login <bitwarden-email>\n" +
		"\n" +
		"Unlock your Bitwarden vault:\n" +
		"\n" +
		"    bw unlock\n" +
		"\n" +
		"Set the `BW_SESSION` environment variable, as instructed.\n" +
		"\n" +
		"The structured data from `bw get` is available as the `bitwarden` template\n" +
		"function in your config files, for example:\n" +
		"\n" +
		"    username = {{ (bitwarden \"item\" \"example.com\").login.username }}\n" +
		"    password = {{ (bitwarden \"item\" \"example.com\").login.password }}\n" +
		"\n" +
		"### Use gopass to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [gopass](https://gopass.pw/) using the gopass CLI.\n" +
		"\n" +
		"The first line of the output of `gopass show <pass-name>` is available as the\n" +
		"`gopass` template function, for example:\n" +
		"\n" +
		"    {{ gopass \"<pass-name>\" }}\n" +
		"\n" +
		"### Use gpg to keep your secrets\n" +
		"\n" +
		"chezmoi supports encrypting files with [gpg](https://www.gnupg.org/). Encrypted\n" +
		"files are stored in the source state and automatically be decrypted when\n" +
		"generating the target state or printing a file's contents with `chezmoi cat`.\n" +
		"`chezmoi edit` will transparently decrypt the file before editing and re-encrypt\n" +
		"it afterwards.\n" +
		"\n" +
		"#### Asymmetric (private/public-key) encryption\n" +
		"\n" +
		"Specify the encryption key to use in your configuration file (`chezmoi.toml`)\n" +
		"with the `gpg.recipient` key:\n" +
		"\n" +
		"    [gpg]\n" +
		"      recipient = \"...\"\n" +
		"\n" +
		"Add files to be encrypted with the `--encrypt` flag, for example:\n" +
		"\n" +
		"    chezmoi add --encrypt ~/.ssh/id_rsa\n" +
		"\n" +
		"chezmoi will encrypt the file with:\n" +
		"\n" +
		"    gpg --armor --recipient ${gpg.recipient} --encrypt\n" +
		"\n" +
		"and store the encrypted file in the source state. The file will automatically be\n" +
		"decrypted when generating the target state.\n" +
		"\n" +
		"#### Symmetric encryption\n" +
		"\n" +
		"Specify symmetric encryption in your configuration file:\n" +
		"\n" +
		"    [gpg]\n" +
		"      symmetric = true\n" +
		"\n" +
		"Add files to be encrypted with the `--encrypt` flag, for example:\n" +
		"\n" +
		"    chezmoi add --encrypt ~/.ssh/id_rsa\n" +
		"\n" +
		"chezmoi will encrypt the file with:\n" +
		"\n" +
		"    gpg --armor --symmetric\n" +
		"\n" +
		"### Use KeePassXC to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [KeePassXC](https://keepassxc.org) using the\n" +
		"KeePassXC CLI (`keepassxc-cli`) to expose data as a template function.\n" +
		"\n" +
		"Provide the path to your KeePassXC database in your configuration file:\n" +
		"\n" +
		"    [keepassxc]\n" +
		"      database = \"/home/user/Passwords.kdbx\"\n" +
		"\n" +
		"The structured data from `keepassxc-cli show $database` is available as the\n" +
		"`keepassxc` template function in your config files, for example:\n" +
		"\n" +
		"    username = {{ (keepassxc \"example.com\").UserName }}\n" +
		"    password = {{ (keepassxc \"example.com\").Password }}\n" +
		"\n" +
		"Additional attributes are available through the `keepassxcAttribute` function.\n" +
		"For example, if you have an entry called `SSH Key` with an additional attribute\n" +
		"called `private-key`, its value is available as:\n" +
		"\n" +
		"    {{ keepassxcAttribute \"SSH Key\" \"private-key\" }}\n" +
		"\n" +
		"### Use a keyring to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for Keychain (on macOS), GNOME Keyring (on Linux), and\n" +
		"Windows Credentials Manager (on Windows) via the\n" +
		"[`zalando/go-keyring`](https://github.com/zalando/go-keyring) library.\n" +
		"\n" +
		"Set passwords with:\n" +
		"\n" +
		"    $ chezmoi keyring set --service=<service> --user=<user>\n" +
		"    Password: xxxxxxxx\n" +
		"\n" +
		"The password can then be used in templates using the `keyring` function which\n" +
		"takes the service and user as arguments.\n" +
		"\n" +
		"For example, save a GitHub access token in keyring with:\n" +
		"\n" +
		"    $ chezmoi keyring set --service=github --user=<github-username>\n" +
		"    Password: xxxxxxxx\n" +
		"\n" +
		"and then include it in your `~/.gitconfig` file with:\n" +
		"\n" +
		"    [github]\n" +
		"      user = \"{{ .github.user }}\"\n" +
		"      token = \"{{ keyring \"github\" .github.user }}\"\n" +
		"\n" +
		"You can query the keyring from the command line:\n" +
		"\n" +
		"    chezmoi keyring get --service=github --user=<github-username>\n" +
		"\n" +
		"### Use LastPass to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [LastPass](https://lastpass.com) using the\n" +
		"[LastPass CLI](https://lastpass.github.io/lastpass-cli/lpass.1.html) to expose\n" +
		"data as a template function.\n" +
		"\n" +
		"Log in to LastPass using:\n" +
		"\n" +
		"    lpass login <lastpass-username>\n" +
		"\n" +
		"Check that `lpass` is working correctly by showing password data:\n" +
		"\n" +
		"    lpass show --json <lastpass-entry-id>\n" +
		"\n" +
		"where `<lastpass-entry-id>` is a [LastPass Entry\n" +
		"Specification](https://lastpass.github.io/lastpass-cli/lpass.1.html#_entry_specification).\n" +
		"\n" +
		"The structured data from `lpass show --json id` is available as the `lastpass`\n" +
		"template function. The value will be an array of objects. You can use the\n" +
		"`index` function and `.Field` syntax of the `text/template` language to extract\n" +
		"the field you want. For example, to extract the `password` field from first the\n" +
		"\"GitHub\" entry, use:\n" +
		"\n" +
		"    githubPassword = \"{{ (index (lastpass \"GitHub\") 0).password }}\"\n" +
		"\n" +
		"chezmoi automatically parses the `note` value of the Lastpass entry as\n" +
		"colon-separated key-value pairs, so, for example, you can extract a private SSH\n" +
		"key like this:\n" +
		"\n" +
		"    {{ (index (lastpass \"SSH\") 0).note.privateKey }}\n" +
		"\n" +
		"Keys in the `note` section written as `CamelCase Words` are converted to\n" +
		"`camelCaseWords`.\n" +
		"\n" +
		"If the `note` value does not contain colon-separated key-value pairs, then you\n" +
		"can use `lastpassRaw` to get its raw value, for example:\n" +
		"\n" +
		"    {{ (index (lastpassRaw \"SSH Private Key\") 0).note }}\n" +
		"\n" +
		"### Use 1Password to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [1Password](https://1password.com/) using the\n" +
		"[1Password CLI](https://support.1password.com/command-line-getting-started/) to\n" +
		"expose data as a template function.\n" +
		"\n" +
		"Log in and get a session using:\n" +
		"\n" +
		"    eval $(op signin <subdomain>.1password.com <email>)\n" +
		"\n" +
		"The output of `op get item <uuid>` is available as the `onepassword` template\n" +
		"function. chezmoi parses the JSON output and returns it as structured data. For\n" +
		"example, if the output of `op get item \"<uuid>\"` is:\n" +
		"\n" +
		"    {\n" +
		"        \"uuid\": \"<uuid>\",\n" +
		"        \"details\": {\n" +
		"            \"password\": \"xxx\"\n" +
		"        }\n" +
		"    }\n" +
		"\n" +
		"Then you can access `details.password` with the syntax:\n" +
		"\n" +
		"    {{ (onepassword \"<uuid>\").details.password }}\n" +
		"\n" +
		"Documents can be retrieved with:\n" +
		"\n" +
		"    {{- onepasswordDocument \"uuid\" -}}\n" +
		"\n" +
		"Note the extra `-` after the opening `{{` and before the closing `}}`. This\n" +
		"instructs the templating language to remove and whitespace before and after the\n" +
		"substitution. This removes any trailing newline added by your editor when saving\n" +
		"the template.\n" +
		"\n" +
		"### Use pass to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [pass](https://www.passwordstore.org/) using the\n" +
		"pass CLI.\n" +
		"\n" +
		"The first line of the output of `pass show <pass-name>` is available as the\n" +
		"`pass` template function, for example:\n" +
		"\n" +
		"    {{ pass \"<pass-name>\" }}\n" +
		"\n" +
		"### Use Vault to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [Vault](https://www.vaultproject.io/) using the\n" +
		"[Vault CLI](https://www.vaultproject.io/docs/commands/) to expose data as a\n" +
		"template function.\n" +
		"\n" +
		"The vault CLI needs to be correctly configured on your machine, e.g. the\n" +
		"`VAULT_ADDR` and `VAULT_TOKEN` environment variables must be set correctly.\n" +
		"Verify that this is the case by running:\n" +
		"\n" +
		"    vault kv get -format=json <key>\n" +
		"\n" +
		"The structured data from `vault kv get -format=json` is available as the `vault`\n" +
		"template function. You can use the `.Field` syntax of the `text/template`\n" +
		"language to extract the data you want. For example:\n" +
		"\n" +
		"    {{ (vault \"<key>\").data.data.password }}\n" +
		"\n" +
		"### Use a generic tool to keep your secrets\n" +
		"\n" +
		"You can use any command line tool that outputs secrets either as a string or in\n" +
		"JSON format. Choose the binary by setting `genericSecret.command` in your\n" +
		"configuration file. You can then invoke this command with the `secret` and\n" +
		"`secretJSON` template functions which return the raw output and JSON-decoded\n" +
		"output respectively. All of the above secret managers can be supported in this\n" +
		"way:\n" +
		"\n" +
		"| Secret Manager  | `genericSecret.command` | Template skeleton                                 |\n" +
		"| --------------- | ----------------------- | ------------------------------------------------- |\n" +
		"| 1Password       | `op`                    | `{{ secretJSON \"get\" \"item\" <id> }}`              |\n" +
		"| Bitwarden       | `bw`                    | `{{ secretJSON \"get\" <id> }}`                     |\n" +
		"| Hashicorp Vault | `vault`                 | `{{ secretJSON \"kv\" \"get\" \"-format=json\" <id> }}` |\n" +
		"| LastPass        | `lpass`                 | `{{ secretJSON \"show\" \"--json\" <id> }}`           |\n" +
		"| KeePassXC       | `keepassxc-cli`         | Not possible (interactive command only)           |\n" +
		"| pass            | `pass`                  | `{{ secret \"show\" <id> }}`                        |\n" +
		"\n" +
		"### Use templates variables to keep your secrets\n" +
		"\n" +
		"Typically, `~/.config/chezmoi/chezmoi.toml` is not checked in to version control\n" +
		"and has permissions 0600. You can store tokens as template values in the `data`\n" +
		"section. For example, if your `~/.config/chezmoi/chezmoi.toml` contains:\n" +
		"\n" +
		"    [data]\n" +
		"      [data.github]\n" +
		"        user = \"<github-username>\"\n" +
		"        token = \"<github-token>\"\n" +
		"\n" +
		"Your `~/.local/share/chezmoi/private_dot_gitconfig.tmpl` can then contain:\n" +
		"\n" +
		"    {{- if (index . \"github\") }}\n" +
		"    [github]\n" +
		"      user = \"{{ .github.user }}\"\n" +
		"      token = \"{{ .github.token }}\"\n" +
		"    {{- end }}\n" +
		"\n" +
		"Any config files containing tokens in plain text should be private (permissions\n" +
		"`0600`).\n" +
		"\n" +
		"## Use scripts to perform actions\n" +
		"\n" +
		"### Understand how scripts work\n" +
		"\n" +
		"chezmoi supports scripts, which are executed when you run `chezmoi apply`. The\n" +
		"scripts can either run every time you run `chezmoi apply`, or only when their\n" +
		"contents have changed.\n" +
		"\n" +
		"In verbose mode, the script's contents will be printed before executing it. In\n" +
		"dry-run mode, the script is not executed.\n" +
		"\n" +
		"Scripts are any file in the source directory with the prefix `run_`, and are\n" +
		"executed in alphabetical order. Scripts that should only be run when their\n" +
		"contents change have the prefix `run_once_`.\n" +
		"\n" +
		"Scripts break chezmoi's declarative approach, and as such should be used\n" +
		"sparingly. Any script should be idempotent, even `run_once_` scripts.\n" +
		"\n" +
		"Scripts must be created manually in the source directory, typically by running\n" +
		"`chezmoi cd` and then creating a file with a `run_` prefix. Scripts are executed\n" +
		"directly using `exec` and must include a shebang line or be executable binaries.\n" +
		"There is no need to set the executable bit on the script.\n" +
		"\n" +
		"Scripts with the suffix `.tmpl` are treated as templates, with the usual\n" +
		"template variables available. If, after executing the template, the result is\n" +
		"only whitespace or an empty string, then the script is not executed. This is\n" +
		"useful for disabling scripts.\n" +
		"\n" +
		"### Install packages with scripts\n" +
		"\n" +
		"Change to the source directory and create a file called\n" +
		"`run_once_install-packages.sh`:\n" +
		"\n" +
		"    chezmoi cd\n" +
		"    $EDITOR run_once_install-packages.sh\n" +
		"\n" +
		"In this file create your package installation script, e.g.\n" +
		"\n" +
		"    #!/bin/sh\n" +
		"    sudo apt install ripgrep\n" +
		"\n" +
		"The next time you run `chezmoi apply` or `chezmoi update` this script will be\n" +
		"run. As it has the `run_once_` prefix, it will not be run again unless its\n" +
		"contents change, for example if you add more packages to be installed.\n" +
		"\n" +
		"This script can also be a template. For example, if you create\n" +
		"`run_once_install-packages.sh.tmpl` with the contents:\n" +
		"\n" +
		"    {{ if eq .chezmoi.os \"linux\" -}}\n" +
		"    #!/bin/sh\n" +
		"    sudo apt install ripgrep\n" +
		"    {{ else if eq .chezmoi.os \"darwin\" -}}\n" +
		"    #!/bin/sh\n" +
		"    brew install ripgrep\n" +
		"    {{ end -}}\n" +
		"\n" +
		"This will install `ripgrep` on both Debian/Ubuntu Linux systems and macOS.\n" +
		"\n" +
		"## Import archives\n" +
		"\n" +
		"It is occasionally useful to import entire archives of configuration into your\n" +
		"source state. The `import` command does this. For example, to import the latest\n" +
		"version\n" +
		"[`github.com/robbyrussell/oh-my-zsh`](https://github.com/robbyrussell/oh-my-zsh)\n" +
		"to `~/.oh-my-zsh` run:\n" +
		"\n" +
		"    curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-zsh/archive/master.tar.gz\n" +
		"    chezmoi import --strip-components 1 --destination ~/.oh-my-zsh oh-my-zsh-master.tar.gz\n" +
		"\n" +
		"Note that this only updates the source state. You will need to run\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"to update your destination directory.\n" +
		"\n" +
		"## Export archives\n" +
		"\n" +
		"chezmoi can create an archive containing the target state. This can be useful\n" +
		"for generating target state on a different machine or for simply inspecting the\n" +
		"target state. A particularly useful command is:\n" +
		"\n" +
		"    chezmoi archive | tar tvf -\n" +
		"\n" +
		"which lists all the targets in the target state.\n" +
		"\n" +
		"## Use a non-git version control system\n" +
		"\n" +
		"By default, chezmoi uses git, but you can use any version control system of your\n" +
		"choice. In your config file, specify the command to use. For example, to use\n" +
		"Mercurial specify:\n" +
		"\n" +
		"    [sourceVCS]\n" +
		"      command = \"hg\"\n" +
		"\n" +
		"The source VCS command is used in the chezmoi commands `init`, `source`, and\n" +
		"`update`, and support for VCSes other than git is limited but easy to add. If\n" +
		"you'd like to see your VCS better supported, please [open an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"## Customize the `diff` command\n" +
		"\n" +
		"By default, chezmoi uses a built-in diff. You can change the format, and/or pipe\n" +
		"the output into a pager of your choice. For example, to use\n" +
		"[`diff-so-fancy`](https://github.com/so-fancy/diff-so-fancy) specify:\n" +
		"\n" +
		"    [diff]\n" +
		"        format = \"git\"\n" +
		"        pager = \"diff-so-fancy\"\n" +
		"\n" +
		"The format can also be set with the `--format` option to the `diff` command, and\n" +
		"the pager can be disabled using `--no-pager`.\n" +
		"\n" +
		"## Use a merge tool other than vimdiff\n" +
		"\n" +
		"By default, chezmoi uses vimdiff, but you can use any merge tool of your choice.\n" +
		"In your config file, specify the command and args to use. For example, to use\n" +
		"neovim's diff mode specify:\n" +
		"\n" +
		"    [merge]\n" +
		"      command = \"nvim\"\n" +
		"      args = \"-d\"\n" +
		"\n" +
		"## Migrate from a dotfile manager that uses symlinks\n" +
		"\n" +
		"Many dotfile managers replace dotfiles with symbolic links to files in a common\n" +
		"directory. If you `chezmoi add` such a symlink, chezmoi will add the symlink,\n" +
		"not the file. To assist with migrating from symlink-based systems, use the\n" +
		"`--follow` / `-f` option to `chezmoi add`, for example:\n" +
		"\n" +
		"    chezmoi add --follow ~/.bashrc\n" +
		"\n" +
		"This will tell `chezmoi add` that the target state of `~/.bashrc` is the target\n" +
		"of the `~/.bashrc` symlink, rather than the symlink itself. When you run\n" +
		"`chezmoi apply`, chezmoi will replace the `~/.bashrc` symlink with the file\n" +
		"contents.\n" +
		"\n")
	assets["docs/INSTALL.md"] = []byte("" +
		"# chezmoi Install Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [One-line binary install](#one-line-binary-install)\n" +
		"* [One-line package install](#one-line-package-install)\n" +
		"* [Pre-built Linux packages](#pre-built-linux-packages)\n" +
		"* [Pre-built binaries](#pre-built-binaries)\n" +
		"* [All pre-built Linux packages and binaries](#all-pre-built-linux-packages-and-binaries)\n" +
		"* [From source](#from-source)\n" +
		"* [Upgrading](#upgrading)\n" +
		"\n" +
		"## One-line binary install\n" +
		"\n" +
		"Install the correct binary for your operating system and architecture in `./bin`\n" +
		"with a single command.\n" +
		"\n" +
		"    curl -sfL https://git.io/chezmoi | sh\n" +
		"\n" +
		"## One-line package install\n" +
		"\n" +
		"Install chezmoi with a single command.\n" +
		"\n" +
		"| OS           | Method     | Command                                                                                     |\n" +
		"| ------------ | ---------- | ------------------------------------------------------------------------------------------- |\n" +
		"| Linux        | snap       | `snap install chezmoi --classic`                                                            |\n" +
		"| Linux        | Linuxbrew  | `brew install twpayne/taps/chezmoi`                                                         |\n" +
		"| Alpine Linux | apk        | `apk add chezmoi`                                                                           |\n" +
		"| Arch Linux   | pacman     | `pacman -S chezmoi`                                                                         |\n" +
		"| NixOS Linux  | nix-env    | `nix-env -i chezmoi`                                                                        |\n" +
		"| macOS        | Homebrew   | `brew install chezmoi`                                                                      |\n" +
		"| Windows      | Scoop      | `scoop bucket add twpayne https://github.com/twpayne/scoop-bucket && scoop install chezmoi` |\n" +
		"\n" +
		"## Pre-built Linux packages\n" +
		"\n" +
		"Download a package for your operating system and architecture and install it\n" +
		"with your package manager.\n" +
		"\n" +
		"| Distribution | Architectures                                             | Package                                                                   |\n" +
		"| ------------ | --------------------------------------------------------- | ------------------------------------------------------------------------- |\n" +
		"| Debian       | `amd64`, `arm64`, `armel`, `i386`, `ppc64`, `ppc64le`     | [`deb`](https://github.com/twpayne/chezmoi/releases/latest)               |\n" +
		"| RedHat       | `aarch64`, `armhfp`, `i686`, `ppc64`, `ppc64le`, `x86_64` | [`rpm`](https://github.com/twpayne/chezmoi/releases/latest)               |\n" +
		"| OpenSUSE     | `aarch64`, `armhfp`, `i686`, `ppc64`, `ppc64le`, `x86_64` | [`rpm`](https://github.com/twpayne/chezmoi/releases/latest)               |\n" +
		"| Ubuntu       | `amd64`, `arm64`, `armel`, `i386`, `ppc64`, `ppc64le`     | [`deb`](https://github.com/twpayne/chezmoi/releases/latest)               |\n" +
		"\n" +
		"## Pre-built binaries\n" +
		"\n" +
		"Download an archive for your operating system containing a pre-built binary,\n" +
		"documentation, and shell completions.\n" +
		"\n" +
		"| OS         | Architectures                                       | Archive                                                        |\n" +
		"| ---------- | --------------------------------------------------- | -------------------------------------------------------------- |\n" +
		"| FreeBSD    | `amd64`, `arm`, `arm64`, `i386`                     | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| Linux      | `amd64`, `arm`, `arm64`, `i386`, `ppc64`, `ppc64le` | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| macOS      | `amd64`                                             | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| OpenBSD    | `amd64`, `arm`, `arm64`, `i386`                     | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| Windows    | `amd64`, `i386`                                     | [`zip`](https://github.com/twpayne/chezmoi/releases/latest)    |\n" +
		"\n" +
		"## All pre-built Linux packages and binaries\n" +
		"\n" +
		"All pre-built binaries and packages can be found on the [chezmoi GitHub releases\n" +
		"page](https://github.com/twpayne/chezmoi/releases/latest).\n" +
		"\n" +
		"## From source\n" +
		"\n" +
		"Download, build, and install chezmoi for your system:\n" +
		"\n" +
		"    cd $(mktemp -d)\n" +
		"    git clone --depth=1 https://github.com/twpayne/chezmoi.git\n" +
		"    cd chezmoi\n" +
		"    go install\n" +
		"\n" +
		"Building chezmoi requires Go 1.13 or later.\n" +
		"\n" +
		"## Upgrading\n" +
		"\n" +
		"If you have installed a pre-built binary of chezmoi, you can upgrade it to the\n" +
		"latest release with:\n" +
		"\n" +
		"    chezmoi upgrade\n" +
		"\n" +
		"This will re-use whichever mechanism you used to install chezmoi to install the\n" +
		"latest release.\n" +
		"\n")
	assets["docs/MEDIA.md"] = []byte("" +
		"# chezmoi in the media\n" +
		"\n" +
		"<!--- toc --->\n" +
		"\n" +
		"| Date       | Version | Format       | Link                                                                                                                      |\n" +
		"| ---------- | ------- | ------------ | ------------------------------------------------------------------------------------------------------------------------- |\n" +
		"| 2020-04-16 | 1.17.19 | Text (FR)    | [Chezmoi, visite guidée](https://blog.wescale.fr/2020/04/16/chezmoi-visite-guidee/)                                       |\n" +
		"| 2020-04-03 | 1.7.17  | Text         | [Fedora Magazine: Take back your dotfiles with Chezmoi](https://fedoramagazine.org/take-back-your-dotfiles-with-chezmoi/) |\n" +
		"| 2020-03-12 | 1.7.16  | Video        | [Manging Dotfiles with ChezMoi](https://www.youtube.com/watch?v=HXx6ugA98Qo)                                              |\n" +
		"| 2019-11-20 | 1.7.2   | Audio/video  | [FLOSS weekly episode 556: chezmoi](https://twit.tv/shows/floss-weekly/episodes/556)                                      |\n" +
		"| 2019-01-10 | 0.0.11  | Text         | [Linux Fu: The kitchen sync](https://hackaday.com/2019/01/10/linux-fu-the-kitchen-sync/)                                  |\n" +
		"\n" +
		"To add your article to this page please either [open an\n" +
		"issue](https://github.com/twpayne/chezmoi/issues/new/choose) or submit a pull\n" +
		"request that modifies this file\n" +
		"([`docs/MEDIA.md`](https://github.com/twpayne/chezmoi/blob/master/docs/MEDIA.md)).\n")
	assets["docs/QUICKSTART.md"] = []byte("" +
		"# chezmoi Quick Start Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Concepts](#concepts)\n" +
		"* [Start using chezmoi on your current machine](#start-using-chezmoi-on-your-current-machine)\n" +
		"* [Using chezmoi across multiple machines](#using-chezmoi-across-multiple-machines)\n" +
		"* [Next steps](#next-steps)\n" +
		"\n" +
		"## Concepts\n" +
		"\n" +
		"chezmoi stores the desired state of your dotfiles in the directory\n" +
		"`~/.local/share/chezmoi`. When you run `chezmoi apply`, chezmoi calculates the\n" +
		"desired contents and permissions for each dotfile and then makes any changes\n" +
		"necessary so that your dotfiles match that state.\n" +
		"\n" +
		"## Start using chezmoi on your current machine\n" +
		"\n" +
		"Initialize chezmoi:\n" +
		"\n" +
		"    chezmoi init\n" +
		"\n" +
		"This will create a new git repository in `~/.local/share/chezmoi` with\n" +
		"permissions `0700` where chezmoi will store the source state.  chezmoi only\n" +
		"modifies files in the working copy. It is your responsibility to commit changes.\n" +
		"\n" +
		"Manage an existing file with chezmoi:\n" +
		"\n" +
		"    chezmoi add ~/.bashrc\n" +
		"\n" +
		"This will copy `~/.bashrc` to `~/.local/share/chezmoi/dot_bashrc`.\n" +
		"\n" +
		"Edit the source state:\n" +
		"\n" +
		"    chezmoi edit ~/.bashrc\n" +
		"\n" +
		"This will open `~/.local/share/chezmoi/dot_bashrc` in your `$EDITOR`. Make some\n" +
		"changes and save them.\n" +
		"\n" +
		"See what changes chezmoi would make:\n" +
		"\n" +
		"    chezmoi diff\n" +
		"\n" +
		"Apply the changes:\n" +
		"\n" +
		"    chezmoi -v apply\n" +
		"\n" +
		"All chezmoi commands accept the `-v` (verbose) flag to print out exactly what\n" +
		"changes they will make to the file system, and the `-n` (dry run) flag to not\n" +
		"make any actual changes. The combination `-n` `-v` is very useful if you want to\n" +
		"see exactly what changes would be made.\n" +
		"\n" +
		"Finally, open a shell in the source directory, commit your changes, and return\n" +
		"to where you were:\n" +
		"\n" +
		"    chezmoi cd\n" +
		"    git add dot_bashrc\n" +
		"    git commit -m \"Add .bashrc\"\n" +
		"    exit\n" +
		"\n" +
		"## Using chezmoi across multiple machines\n" +
		"\n" +
		"Clone the git repo in `~/.local/share/chezmoi` to a hosted Git service, e.g.\n" +
		"[GitHub](https://github.com), [GitLab](https://gitlab.com), or\n" +
		"[BitBucket](https://bitbucket.org). Many people call their dotfiles repo\n" +
		"`dotfiles`. You can then setup chezmoi on a second machine:\n" +
		"\n" +
		"    chezmoi init https://github.com/username/dotfiles.git\n" +
		"\n" +
		"This will check out the repo and any submodules and optionally create a chezmoi\n" +
		"config file for you. It won't make any changes to your home directory until you\n" +
		"run:\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"On any machine, you can pull and apply the latest changes from your repo with:\n" +
		"\n" +
		"    chezmoi update\n" +
		"\n" +
		"## Next steps\n" +
		"\n" +
		"For a full list of commands run:\n" +
		"\n" +
		"    chezmoi help\n" +
		"\n" +
		"chezmoi has much more functionality. Read the [how-to\n" +
		"guide](https://github.com/twpayne/chezmoi/blob/master/docs/HOWTO.md) to explore.\n" +
		"\n")
	assets["docs/REFERENCE.md"] = []byte("" +
		"# chezmoi Reference Manual\n" +
		"\n" +
		"Manage your dotfiles securely across multiple machines.\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Concepts](#concepts)\n" +
		"* [Global command line flags](#global-command-line-flags)\n" +
		"  * [`--color` *value*](#--color-value)\n" +
		"  * [`-c`, `--config` *filename*](#-c---config-filename)\n" +
		"  * [`--debug`](#--debug)\n" +
		"  * [`-D`, `--destination` *directory*](#-d---destination-directory)\n" +
		"  * [`-f`, `--follow`](#-f---follow)\n" +
		"  * [`-n`, `--dry-run`](#-n---dry-run)\n" +
		"  * [`-h`, `--help`](#-h---help)\n" +
		"  * [`-r`. `--remove`](#-r---remove)\n" +
		"  * [`-S`, `--source` *directory*](#-s---source-directory)\n" +
		"  * [`-v`, `--verbose`](#-v---verbose)\n" +
		"  * [`--version`](#--version)\n" +
		"* [Configuration file](#configuration-file)\n" +
		"  * [Configuration variables](#configuration-variables)\n" +
		"* [Source state attributes](#source-state-attributes)\n" +
		"* [Special files and directories](#special-files-and-directories)\n" +
		"  * [`.chezmoi.<format>.tmpl`](#chezmoiformattmpl)\n" +
		"  * [`.chezmoiignore`](#chezmoiignore)\n" +
		"  * [`.chezmoiremove`](#chezmoiremove)\n" +
		"  * [`.chezmoitemplates`](#chezmoitemplates)\n" +
		"  * [`.chezmoiversion`](#chezmoiversion)\n" +
		"* [Commands](#commands)\n" +
		"  * [`add` *targets*](#add-targets)\n" +
		"  * [`apply` [*targets*]](#apply-targets)\n" +
		"  * [`archive`](#archive)\n" +
		"  * [`cat` targets](#cat-targets)\n" +
		"  * [`cd`](#cd)\n" +
		"  * [`chattr` *attributes* *targets*](#chattr-attributes-targets)\n" +
		"  * [`completion` *shell*](#completion-shell)\n" +
		"  * [`data`](#data)\n" +
		"  * [`diff` [*targets*]](#diff-targets)\n" +
		"  * [`docs` [*regexp*]](#docs-regexp)\n" +
		"  * [`doctor`](#doctor)\n" +
		"  * [`dump` [*targets*]](#dump-targets)\n" +
		"  * [`edit` [*targets*]](#edit-targets)\n" +
		"  * [`edit-config`](#edit-config)\n" +
		"  * [`execute-template` [*templates*]](#execute-template-templates)\n" +
		"  * [`forget` *targets*](#forget-targets)\n" +
		"  * [`git` [*arguments*]](#git-arguments)\n" +
		"  * [`help` *command*](#help-command)\n" +
		"  * [`hg` [*arguments*]](#hg-arguments)\n" +
		"  * [`init` [*repo*]](#init-repo)\n" +
		"  * [`import` *filename*](#import-filename)\n" +
		"  * [`manage` *targets*](#manage-targets)\n" +
		"  * [`managed`](#managed)\n" +
		"  * [`merge` *targets*](#merge-targets)\n" +
		"  * [`purge`](#purge)\n" +
		"  * [`remove` *targets*](#remove-targets)\n" +
		"  * [`rm` *targets*](#rm-targets)\n" +
		"  * [`secret`](#secret)\n" +
		"  * [`source` [*args*]](#source-args)\n" +
		"  * [`source-path` [*targets*]](#source-path-targets)\n" +
		"  * [`unmanage` *targets*](#unmanage-targets)\n" +
		"  * [`unmanaged`](#unmanaged)\n" +
		"  * [`update`](#update)\n" +
		"  * [`upgrade`](#upgrade)\n" +
		"  * [`verify` [*targets*]](#verify-targets)\n" +
		"* [Editor configuration](#editor-configuration)\n" +
		"* [Umask configuration](#umask-configuration)\n" +
		"* [Template execution](#template-execution)\n" +
		"* [Template variables](#template-variables)\n" +
		"* [Template functions](#template-functions)\n" +
		"  * [`bitwarden` [*args*]](#bitwarden-args)\n" +
		"  * [`gopass` *gopass-name*](#gopass-gopass-name)\n" +
		"  * [`keepassxc` *entry*](#keepassxc-entry)\n" +
		"  * [`keepassxcAttribute` *entry* *attribute*](#keepassxcattribute-entry-attribute)\n" +
		"  * [`keyring` *service* *user*](#keyring-service-user)\n" +
		"  * [`lastpass` *id*](#lastpass-id)\n" +
		"  * [`lastpassRaw` *id*](#lastpassraw-id)\n" +
		"  * [`onepassword` *uuid*](#onepassword-uuid)\n" +
		"  * [`onepasswordDocument` *uuid*](#onepassworddocument-uuid)\n" +
		"  * [`pass` *pass-name*](#pass-pass-name)\n" +
		"  * [`promptString` *prompt*](#promptstring-prompt)\n" +
		"  * [`secret` [*args*]](#secret-args)\n" +
		"  * [`secretJSON` [*args*]](#secretjson-args)\n" +
		"  * [`vault` *key*](#vault-key)\n" +
		"\n" +
		"## Concepts\n" +
		"\n" +
		"chezmoi evaluates the source state for the current machine and then updates the\n" +
		"destination directory, where:\n" +
		"\n" +
		"* The *source state* declares the desired state of your home directory,\n" +
		"  including templates and machine-specific configuration.\n" +
		"\n" +
		"* The *source directory* is where chezmoi stores the source state, by default\n" +
		"  `~/.local/share/chezmoi`.\n" +
		"\n" +
		"* The *target state* is the source state computed for the current machine.\n" +
		"\n" +
		"* The *destination directory* is the directory that chezmoi manages, by default\n" +
		"  `~`, your home directory.\n" +
		"\n" +
		"* A *target* is a file, directory, or symlink in the destination directory.\n" +
		"\n" +
		"* The *destination state* is the state of all the targets in the destination\n" +
		"  directory.\n" +
		"\n" +
		"* The *config file* contains machine-specific configuration, by default it is\n" +
		"  `~/.config/chezmoi/chezmoi.toml`.\n" +
		"\n" +
		"## Global command line flags\n" +
		"\n" +
		"Command line flags override any values set in the configuration file.\n" +
		"\n" +
		"### `--color` *value*\n" +
		"\n" +
		"Colorize diffs, *value* can be `on`, `off`, `auto`, or any boolean-like value\n" +
		"recognized by\n" +
		"[`strconv.ParseBool`](https://pkg.go.dev/strconv?tab=doc#ParseBool). The default\n" +
		"value is `auto` which will colorize diffs only if the the environment variable\n" +
		"`NO_COLOR` is not set and stdout is a terminal.\n" +
		"\n" +
		"### `-c`, `--config` *filename*\n" +
		"\n" +
		"Read the configuration from *filename*.\n" +
		"\n" +
		"### `--debug`\n" +
		"\n" +
		"Log information helpful for debugging.\n" +
		"\n" +
		"### `-D`, `--destination` *directory*\n" +
		"\n" +
		"Use *directory* as the destination directory.\n" +
		"\n" +
		"### `-f`, `--follow`\n" +
		"\n" +
		"If the last part of a target is a symlink, deal with what the symlink\n" +
		"references, rather than the symlink itself.\n" +
		"\n" +
		"### `-n`, `--dry-run`\n" +
		"\n" +
		"Set dry run mode. In dry run mode, the destination directory is never modified.\n" +
		"This is most useful in combination with the `-v` (verbose) flag to print changes\n" +
		"that would be made without making them.\n" +
		"\n" +
		"### `-h`, `--help`\n" +
		"\n" +
		"Print help.\n" +
		"\n" +
		"### `-r`. `--remove`\n" +
		"\n" +
		"Also remove targets according to `.chezmoiremove`.\n" +
		"\n" +
		"### `-S`, `--source` *directory*\n" +
		"\n" +
		"Use *directory* as the source directory.\n" +
		"\n" +
		"### `-v`, `--verbose`\n" +
		"\n" +
		"Set verbose mode. In verbose mode, chezmoi prints the changes that it is making\n" +
		"as approximate shell commands, and any differences in files between the target\n" +
		"state and the destination set are printed as unified diffs.\n" +
		"\n" +
		"### `--version`\n" +
		"\n" +
		"Print the version of chezmoi, the commit at which it was built, and the build\n" +
		"timestamp.\n" +
		"\n" +
		"## Configuration file\n" +
		"\n" +
		"chezmoi searches for its configuration file according to the [XDG Base Directory\n" +
		"Specification](https://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html)\n" +
		"and supports all formats supported by\n" +
		"[`github.com/spf13/viper`](https://github.com/spf13/viper), namely\n" +
		"[JSON](https://www.json.org/json-en.html),\n" +
		"[TOML](https://github.com/toml-lang/toml), [YAML](https://yaml.org/), macOS\n" +
		"property file format, and [HCL](https://github.com/hashicorp/hcl). The basename\n" +
		"of the config file is `chezmoi`, and the first config file found is used.\n" +
		"\n" +
		"### Configuration variables\n" +
		"\n" +
		"The following configuration variables are available:\n" +
		"\n" +
		"| Variable                | Type     | Default value             | Description                                         |\n" +
		"| ----------------------- | -------- | ------------------------- | --------------------------------------------------- |\n" +
		"| `bitwarden.command`     | string   | `bw`                      | Bitwarden CLI command                               |\n" +
		"| `cd.command`            | string   | *none*                    | Shell to run in `cd` command                        |\n" +
		"| `color`                 | string   | `auto`                    | Colorize diffs                                      |\n" +
		"| `data`                  | any      | *none*                    | Template data                                       |\n" +
		"| `destDir`               | string   | `~`                       | Destination directory                               |\n" +
		"| `diff.format`           | string   | `chezmoi`                 | Diff format, either `chezmoi` or `git`              |\n" +
		"| `diff.pager`            | string   | *none*                    | Pager                                               |\n" +
		"| `dryRun`                | bool     | `false`                   | Dry run mode                                        |\n" +
		"| `follow`                | bool     | `false`                   | Follow symlinks                                     |\n" +
		"| `genericSecret.command` | string   | *none*                    | Generic secret command                              |\n" +
		"| `gopass.command`        | string   | `gopass`                  | gopass CLI command                                  |\n" +
		"| `gpg.command`           | string   | `gpg`                     | GPG CLI command                                     |\n" +
		"| `gpg.recipient`         | string   | *none*                    | GPG recipient                                       |\n" +
		"| `gpg.symmetric`         | bool     | `false`                   | Use symmetric GPG encryption                        |\n" +
		"| `keepassxc.args`        | []string | *none*                    | Extra args to KeePassXC CLI command                 |\n" +
		"| `keepassxc.command`     | string   | `keepassxc-cli`           | KeePassXC CLI command                               |\n" +
		"| `keepassxc.database`    | string   | *none*                    | KeePassXC database                                  |\n" +
		"| `lastpass.command`      | string   | `lpass`                   | Lastpass CLI command                                |\n" +
		"| `merge.args`            | []string | *none*                    | Extra args to 3-way merge command                   |\n" +
		"| `merge.command`         | string   | `vimdiff`                 | 3-way merge command                                 |\n" +
		"| `onepassword.command`   | string   | `op`                      | 1Password CLI command                               |\n" +
		"| `pass.command`          | string   | `pass`                    | Pass CLI command                                    |\n" +
		"| `remove`                | bool     | `false`                   | Remove targets                                      |\n" +
		"| `sourceDir`             | string   | `~/.local/share/chezmoi`  | Source directory                                    |\n" +
		"| `sourceVCS.autoCommit`  | bool     | `false`                   | Commit changes to the source state after any change |\n" +
		"| `sourceVCS.autoPush`    | bool     | `false`                   | Push changes to the source state after any change   |\n" +
		"| `sourceVCS.command`     | string   | `git`                     | Source version control system                       |\n" +
		"| `template.options`      | []string | `[\"missingkey=error\"]`    | Template options                                    |\n" +
		"| `umask`                 | int      | *from system*             | Umask                                               |\n" +
		"| `vault.command`         | string   | `vault`                   | Vault CLI command                                   |\n" +
		"| `verbose`               | bool     | `false`                   | Verbose mode                                        |\n" +
		"\n" +
		"## Source state attributes\n" +
		"\n" +
		"chezmoi stores the source state of files, symbolic links, and directories in\n" +
		"regular files and directories in the source directory (`~/.local/share/chezmoi`\n" +
		"by default). This location can be overridden with the `-S` flag or by giving a\n" +
		"value for `sourceDir` in `~/.config/chezmoi/chezmoi.toml`.  Some state is\n" +
		"encoded in the source names. chezmoi ignores all files and directories in the\n" +
		"source directory that begin with a `.`. The following prefixes and suffixes are\n" +
		"special, and are collectively referred to as \"attributes\":\n" +
		"\n" +
		"| Prefix       | Effect                                                                         |\n" +
		"| ------------ | ------------------------------------------------------------------------------ |\n" +
		"| `encrypted_` | Encrypt the file in the source state.                                          |\n" +
		"| `once_`      | Only run script once.                                                          |\n" +
		"| `private_`   | Remove all group and world permissions from the target file or directory.      |\n" +
		"| `empty_`     | Ensure the file exists, even if is empty. By default, empty files are removed. |\n" +
		"| `exact_`     | Remove anything not managed by chezmoi.                                        |\n" +
		"| `executable_`| Add executable permissions to the target file.                                 |\n" +
		"| `run_`       | Treat the contents as a script to run.                                         |\n" +
		"| `symlink_`   | Create a symlink instead of a regular file.                                    |\n" +
		"| `dot_`       | Rename to use a leading dot, e.g. `dot_foo` becomes `.foo`.                    |\n" +
		"\n" +
		"| Suffix  | Effect                                               |\n" +
		"| ------- | ---------------------------------------------------- |\n" +
		"| `.tmpl` | Treat the contents of the source file as a template. |\n" +
		"\n" +
		"Order of prefixes is important, the order is `run_`, `exact_`, `private_`,\n" +
		"`empty_`, `executable_`, `symlink_`, `once_`, `dot_`.\n" +
		"\n" +
		"Different target types allow different prefixes and suffixes:\n" +
		"\n" +
		"| Target type   | Allowed prefixes                                          | Allowed suffixes |\n" +
		"| ------------- | --------------------------------------------------------- | ---------------- |\n" +
		"| Directory     | `exact_`, `private_`, `dot_`                              | *none*           |\n" +
		"| Regular file  | `encrypted_`, `private_`, `empty_`, `executable_`, `dot_` | `.tmpl`          |\n" +
		"| Script        | `run_`, `once_`                                           | `.tmpl`          |\n" +
		"| Symbolic link | `symlink_`, `dot_`,                                       | `.tmpl`          |\n" +
		"\n" +
		"## Special files and directories\n" +
		"\n" +
		"All files and directories in the source state whose name begins with `.` are\n" +
		"ignored by default, unless they are one of the special files listed here.\n" +
		"\n" +
		"### `.chezmoi.<format>.tmpl`\n" +
		"\n" +
		"If a file called `.chezmoi.<format>.tmpl` exists then `chezmoi init` will use it\n" +
		"to create an initial config file. *format* must be one of the the supported\n" +
		"config file formats.\n" +
		"\n" +
		"#### `.chezmoi.<format>.tmpl` examples\n" +
		"\n" +
		"    {{ $email := promptString \"email\" -}}\n" +
		"    data:\n" +
		"        email: \"{{ $email }}\"\n" +
		"\n" +
		"### `.chezmoiignore`\n" +
		"\n" +
		"If a file called `.chezmoiignore` exists in the source state then it is\n" +
		"interpreted as a set of patterns to ignore. Patterns are matched using\n" +
		"[`doublestar.PathMatch`](https://pkg.go.dev/github.com/bmatcuk/doublestar?tab=doc#PathMatch)\n" +
		"and match against the target path, not the source path.\n" +
		"\n" +
		"Patterns can be excluded by prefixing them with a `!` character. All excludes\n" +
		"take priority over all includes.\n" +
		"\n" +
		"Comments are introduced with the `#` character and run until the end of the\n" +
		"line.\n" +
		"\n" +
		"`.chezmoiignore` is interpreted as a template. This allows different files to be\n" +
		"ignored on different machines.\n" +
		"\n" +
		"`.chezmoiignore` files in subdirectories apply only to that subdirectory.\n" +
		"\n" +
		"#### `.chezmoiignore` examples\n" +
		"\n" +
		"    README.md\n" +
		"\n" +
		"    *.txt   # ignore *.txt in the target directory\n" +
		"    */*.txt # ignore *.txt in subdirectories of the target directory\n" +
		"\n" +
		"    {{- if ne .email \"john.smith@company.com\" }}\n" +
		"    # Ignore .company-directory unless configured with a company email\n" +
		"    .company-directory # note that the pattern is not dot_company-directory\n" +
		"    {{- end }}\n" +
		"\n" +
		"    {{- if ne .email \"john@home.org }}\n" +
		"    .personal-file\n" +
		"    {{- end }}\n" +
		"\n" +
		"### `.chezmoiremove`\n" +
		"\n" +
		"If a file called `.chezmoiremove` exists in the source state then it is\n" +
		"interpreted as a list of targets to remove. `.chezmoiremove` is interpreted as a\n" +
		"template.\n" +
		"\n" +
		"### `.chezmoitemplates`\n" +
		"\n" +
		"If a directory called `.chezmoitemplates` exists, then all files in this\n" +
		"directory are parsed as templates are available as templates with a name equal\n" +
		"to the relative path of the file.\n" +
		"\n" +
		"#### `.chezmoitemplates` examples\n" +
		"\n" +
		"Given:\n" +
		"\n" +
		"    .chezmoitemplates/foo\n" +
		"    {{ if true }}bar{{ end }}\n" +
		"\n" +
		"    dot_config.tmpl\n" +
		"    {{ template \"foo\" }}\n" +
		"\n" +
		"The target state of `.config` will be `bar`.\n" +
		"\n" +
		"### `.chezmoiversion`\n" +
		"\n" +
		"If a file called `.chezmoiversion` exists, then its contents are interpreted as\n" +
		"a semantic version defining the minimum version of chezmoi required to interpret\n" +
		"the source state correctly. chezmoi will refuse to interpret the source state if\n" +
		"the current version is too old.\n" +
		"\n" +
		"**Warning** support for `.chezmoiversion` will be introduced in a future version\n" +
		"(likely 1.5.0). Earlier versions of chezmoi will ignore this file.\n" +
		"\n" +
		"#### `.chezmoiversion` examples\n" +
		"\n" +
		"    1.5.0\n" +
		"\n" +
		"## Commands\n" +
		"\n" +
		"### `add` *targets*\n" +
		"\n" +
		"Add *targets* to the source state. If any target is already in the source state,\n" +
		"then its source state is replaced with its current state in the destination\n" +
		"directory. The `add` command accepts additional flags:\n" +
		"\n" +
		"#### `--autotemplate`\n" +
		"\n" +
		"Automatically generate a template by replacing strings with variable names from\n" +
		"the `data` section of the config file. Longer subsitutions occur before shorter\n" +
		"ones. This implies the `--template` option.\n" +
		"\n" +
		"#### `-e`, `--empty`\n" +
		"\n" +
		"Set the `empty` attribute on added files.\n" +
		"\n" +
		"#### `-f`, `--force`\n" +
		"\n" +
		"Add *targets*, even if doing so would cause a source template to be overwritten.\n" +
		"\n" +
		"#### `-x`, `--exact`\n" +
		"\n" +
		"Set the `exact` attribute on added directories.\n" +
		"\n" +
		"#### `-p`, `--prompt`\n" +
		"\n" +
		"Interactively prompt before adding each file.\n" +
		"\n" +
		"#### `-r`, `--recursive`\n" +
		"\n" +
		"Recursively add all files, directories, and symlinks.\n" +
		"\n" +
		"#### `-T`, `--template`\n" +
		"\n" +
		"Set the `template` attribute on added files and symlinks.\n" +
		"\n" +
		"#### `add` examples\n" +
		"\n" +
		"    chezmoi add ~/.bashrc\n" +
		"    chezmoi add ~/.gitconfig --template\n" +
		"    chezmoi add ~/.vim --recursive\n" +
		"    chezmoi add ~/.oh-my-zsh --exact --recursive\n" +
		"\n" +
		"### `apply` [*targets*]\n" +
		"\n" +
		"Ensure that *targets* are in the target state, updating them if necessary. If no\n" +
		"targets are specified, the state of all targets are ensured.\n" +
		"\n" +
		"#### `apply` examples\n" +
		"\n" +
		"    chezmoi apply\n" +
		"    chezmoi apply --dry-run --verbose\n" +
		"    chezmoi apply ~/.bashrc\n" +
		"\n" +
		"### `archive`\n" +
		"\n" +
		"Write a tar archive of the target state to stdout. This can be piped into `tar`\n" +
		"to inspect the target state.\n" +
		"\n" +
		"#### `archive` examples\n" +
		"\n" +
		"    chezmoi archive | tar tvf -\n" +
		"\n" +
		"### `cat` targets\n" +
		"\n" +
		"Write the target state of *targets*  to stdout. *targets* must be files or\n" +
		"symlinks. For files, the target file contents are written. For symlinks, the\n" +
		"target target is written.\n" +
		"\n" +
		"#### `cat` examples\n" +
		"\n" +
		"    chezmoi cat ~/.bashrc\n" +
		"\n" +
		"### `cd`\n" +
		"\n" +
		"Launch a shell in the source directory. chezmoi will launch the command set by\n" +
		"the `cd.command` confiuration varaible. If this is not set, chezmoi will attempt\n" +
		"to detect your shell and will finally fall back to an OS-specific default.\n" +
		"\n" +
		"#### `cd` examples\n" +
		"\n" +
		"    chezmoi cd\n" +
		"\n" +
		"### `chattr` *attributes* *targets*\n" +
		"\n" +
		"Change the attributes of *targets*. *attributes* specifies which attributes to\n" +
		"modify. Add attributes by specifying them or their abbreviations directly,\n" +
		"optionally prefixed with a plus sign (`+`). Remove attributes by prefixing them\n" +
		"or their attributes with the string `no` or a minus sign (`-`). The available\n" +
		"attributes and their abbreviations are:\n" +
		"\n" +
		"| Attribute    | Abbreviation |\n" +
		"| ------------ | ------------ |\n" +
		"| `empty`      | `e`          |\n" +
		"| `encrypted`  | *none*       |\n" +
		"| `exact`      | *none*       |\n" +
		"| `executable` | `x`          |\n" +
		"| `private`    | `p`          |\n" +
		"| `template`   | `t`          |\n" +
		"\n" +
		"Multiple attributes modifications may be specified by separating them with a\n" +
		"comma (`,`).\n" +
		"\n" +
		"#### `chattr` examples\n" +
		"\n" +
		"    chezmoi chattr template ~/.bashrc\n" +
		"    chezmoi chattr noempty ~/.profile\n" +
		"    chezmoi chattr private,template ~/.netrc\n" +
		"\n" +
		"### `completion` *shell*\n" +
		"\n" +
		"Generate shell completion code for the specified shell (`bash`, `fish`, or\n" +
		"`zsh`).\n" +
		"\n" +
		"#### `--output`, `-o` *filename*\n" +
		"\n" +
		"Write the shell completion code to *filename* instead of stdout.\n" +
		"\n" +
		"#### `completion` examples\n" +
		"\n" +
		"    chezmoi completion bash\n" +
		"    chezmoi completion fish --output ~/.config/fish/completions/chezmoi.fish\n" +
		"\n" +
		"### `data`\n" +
		"\n" +
		"Write the computed template data in JSON format to stdout. The `data` command\n" +
		"accepts additional flags:\n" +
		"\n" +
		"#### `-f`, `--format` *format*\n" +
		"\n" +
		"Print the computed template data in the given format. The accepted formats are\n" +
		"`json` (JSON), `toml` (TOML), and `yaml` (YAML).\n" +
		"\n" +
		"#### `data` examples\n" +
		"\n" +
		"    chezmoi data\n" +
		"    chezmoi data --format=yaml\n" +
		"\n" +
		"### `diff` [*targets*]\n" +
		"\n" +
		"Print the difference between the target state and the destination state for\n" +
		"*targets*. If no targets are specified, print the differences for all targets.\n" +
		"\n" +
		"If a `diff.pager` command is set in the configuration file then the output will\n" +
		"be piped into it.\n" +
		"\n" +
		"#### `-f`, `--format` *format*\n" +
		"\n" +
		"Print the diff in *format*. The format can be set with the `diff.format`\n" +
		"variable in the configuration file. Valid formats are:\n" +
		"\n" +
		"##### `chezmoi`\n" +
		"\n" +
		"A mix of unified diffs and pseudo shell commands, including scripts, equivalent\n" +
		"to `chezmoi apply --dry-run --verbose`.\n" +
		"\n" +
		"##### `git`\n" +
		"\n" +
		"A [git format diff](https://git-scm.com/docs/diff-format), excluding scripts. In\n" +
		"version 2.0.0 of chezmoi, `git` format diffs will become the default and include\n" +
		"scripts and the `chezmoi` format will be removed.\n" +
		"\n" +
		"#### `--no-pager`\n" +
		"\n" +
		"Do not use the pager.\n" +
		"\n" +
		"#### `diff` examples\n" +
		"\n" +
		"    chezmoi diff\n" +
		"    chezmoi diff ~/.bashrc\n" +
		"    chezmoi diff --format=git\n" +
		"\n" +
		"### `docs` [*regexp*]\n" +
		"\n" +
		"Print the documentation page matching the regular expression *regexp*. Matching\n" +
		"is case insensitive. If no pattern is given, print `REFERENCE.md`.\n" +
		"\n" +
		"#### `docs` examples\n" +
		"\n" +
		"    chezmoi docs\n" +
		"    chezmoi docs faq\n" +
		"    chezmoi docs howto\n" +
		"\n" +
		"### `doctor`\n" +
		"\n" +
		"Check for potential problems.\n" +
		"\n" +
		"#### `doctor` examples\n" +
		"\n" +
		"    chezmoi doctor\n" +
		"\n" +
		"### `dump` [*targets*]\n" +
		"\n" +
		"Dump the target state in JSON format. If no targets are specified, then the\n" +
		"entire target state. The `dump` command accepts additional arguments:\n" +
		"\n" +
		"#### `-f`, `--format` *format*\n" +
		"\n" +
		"Print the target state in the given format. The accepted formats are `json`\n" +
		"(JSON) and `yaml` (YAML).\n" +
		"\n" +
		"#### `dump` examples\n" +
		"\n" +
		"    chezmoi dump ~/.bashrc\n" +
		"    chezmoi dump --format=yaml\n" +
		"\n" +
		"### `edit` [*targets*]\n" +
		"\n" +
		"Edit the source state of *targets*, which must be files or symlinks. If no\n" +
		"targets are given the the source directory itself is opened with `$EDITOR`. The\n" +
		"`edit` command accepts additional arguments:\n" +
		"\n" +
		"#### `-a`, `--apply`\n" +
		"\n" +
		"Apply target immediately after editing. Ignored if there are no targets.\n" +
		"\n" +
		"#### `-d`, `--diff`\n" +
		"\n" +
		"Print the difference between the target state and the actual state after\n" +
		"editing.. Ignored if there are no targets.\n" +
		"\n" +
		"#### `-p`, `--prompt`\n" +
		"\n" +
		"Prompt before applying each target.. Ignored if there are no targets.\n" +
		"\n" +
		"#### `edit` examples\n" +
		"\n" +
		"    chezmoi edit ~/.bashrc\n" +
		"    chezmoi edit ~/.bashrc --apply --prompt\n" +
		"    chezmoi edit\n" +
		"\n" +
		"### `edit-config`\n" +
		"\n" +
		"Edit the configuration file.\n" +
		"\n" +
		"#### `edit-config` examples\n" +
		"\n" +
		"    chezmoi edit-config\n" +
		"\n" +
		"### `execute-template` [*templates*]\n" +
		"\n" +
		"Execute *templates*. This is useful for testing templates or for calling chezmoi\n" +
		"from other scripts. *templates* are interpeted as literal templates, with no\n" +
		"whitespace added to the output between arguments. If no templates are specified,\n" +
		"the template is read from stdin.\n" +
		"\n" +
		"#### `--init`, `-i`\n" +
		"\n" +
		"Include simulated functions only available during `chezmoi init`.\n" +
		"\n" +
		"#### '--output', '-o' *filename*\n" +
		"\n" +
		"Write the output to *filename* instead of stdout.\n" +
		"\n" +
		"#### `--promptString`, `-p` *pairs*\n" +
		"\n" +
		"Simulate the `promptString` function with a function that returns values from\n" +
		"*pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs. If\n" +
		"`promptString` is called with a *prompt* that does not match any of *pairs*,\n" +
		"then it returns *prompt* unchanged.\n" +
		"\n" +
		"#### `execute-template` examples\n" +
		"\n" +
		"    chezmoi execute-template '{{ .chezmoi.sourceDir }}'\n" +
		"    chezmoi execute-template '{{ .chezmoi.os }}' / '{{ .chezmoi.arch }}'\n" +
		"    echo '{{ .chezmoi | toJson }}' | chezmoi execute-template\n" +
		"    chezmoi execute-template --init --promptString email=john@home.org < ~/.local/share/chezmoi/.chezmoi.toml.tmpl\n" +
		"\n" +
		"### `forget` *targets*\n" +
		"\n" +
		"Remove *targets* from the source state, i.e. stop managing them.\n" +
		"\n" +
		"#### `forget` examples\n" +
		"\n" +
		"    chezmoi forget ~/.bashrc\n" +
		"\n" +
		"### `git` [*arguments*]\n" +
		"\n" +
		"Run `git` *arguments* in the source directory. Note that flags in *arguments*\n" +
		"must occur after `--` to prevent chezmoi from interpreting them.\n" +
		"\n" +
		"#### `git` examples\n" +
		"\n" +
		"    chezmoi git add .\n" +
		"    chezmoi git add dot_gitconfig\n" +
		"    chezmoi git -- commit -m \"Add .gitconfig\"\n" +
		"\n" +
		"### `help` *command*\n" +
		"\n" +
		"Print the help associated with *command*.\n" +
		"\n" +
		"### `hg` [*arguments*]\n" +
		"\n" +
		"Run `hg` *arguments* in the source directory. Note that flags in *arguments*\n" +
		"must occur after `--` to prevent chezmoi from interpreting them.\n" +
		"\n" +
		"#### `hg` examples\n" +
		"\n" +
		"    chezmoi hg -- pull --rebase --update\n" +
		"\n" +
		"### `init` [*repo*]\n" +
		"\n" +
		"Setup the source directory and update the destination directory to match the\n" +
		"target state. If *repo* is given then it is checked out into the source\n" +
		"directory, otherwise a new repository is initialized in the source directory. If\n" +
		"a file called `.chezmoi.format.tmpl` exists, where `format` is one of the\n" +
		"supported file formats (e.g. `json`, `toml`, or `yaml`) then a new configuration\n" +
		"file is created using that file as a template. Finally, if the `--apply` flag is\n" +
		"passed, `chezmoi apply` is run.\n" +
		"\n" +
		"#### `init` examples\n" +
		"\n" +
		"    chezmoi init https://github.com/user/dotfiles.git\n" +
		"    chezmoi init https://github.com/user/dotfiles.git --apply\n" +
		"\n" +
		"### `import` *filename*\n" +
		"\n" +
		"Import the source state from an archive file in to a directory in the source\n" +
		"state. This is primarily used to make subdirectories of your home directory\n" +
		"exactly match the contents of a downloaded archive. You will generally always\n" +
		"want to set the `--destination`, `--exact`, and `--remove-destination` flags.\n" +
		"\n" +
		"The only supported archive format is `.tar.gz`.\n" +
		"\n" +
		"#### `--destination` *directory*\n" +
		"\n" +
		"Set the destination (in the source state) where the archive will be imported.\n" +
		"\n" +
		"#### `-x`, `--exact`\n" +
		"\n" +
		"Set the `exact` attribute on all imported directories.\n" +
		"\n" +
		"#### `-r`, `--remove-destination`\n" +
		"\n" +
		"Remove destination (in the source state) before importing.\n" +
		"\n" +
		"#### `--strip-components` *n*\n" +
		"\n" +
		"Strip *n* leading components from paths.\n" +
		"\n" +
		"#### `import` examples\n" +
		"\n" +
		"    curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-zsh/archive/master.tar.gz\n" +
		"    chezmoi import --strip-components 1 --destination ~/.oh-my-zsh oh-my-zsh-master.tar.gz\n" +
		"\n" +
		"### `manage` *targets*\n" +
		"\n" +
		"`manage` is an alias for `add` for symmetry with `unmanage`.\n" +
		"\n" +
		"### `managed`\n" +
		"\n" +
		"List all managed entries in the destination directory in alphabetical order.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only list entries of type *types*. *types* is a comma-separated list of types of\n" +
		"entry to include. Valid types are `dirs`, `files`, and `symlinks` which can be\n" +
		"abbreviated to `d`, `f`, and `s` respectively. By default, `manage` will list\n" +
		"entries of all types.\n" +
		"\n" +
		"#### `managed` examples\n" +
		"\n" +
		"    chezmoi managed\n" +
		"    chezmoi managed --include=files\n" +
		"    chezmoi managed --include=files,symlinks\n" +
		"    chezmoi managed -i d\n" +
		"    chezmoi managed -i d,f\n" +
		"\n" +
		"### `merge` *targets*\n" +
		"\n" +
		"Perform a three-way merge between the destination state, the source state, and\n" +
		"the target state. The merge tool is defined by the `merge.command` configuration\n" +
		"variable, and defaults to `vimdiff`. If multiple targets are specified the merge\n" +
		"tool is invoked for each target. If the target state cannot be computed (for\n" +
		"example if source is a template containing errors or an encrypted file that\n" +
		"cannot be decrypted) a two-way merge is performed instead.\n" +
		"\n" +
		"#### `merge` examples\n" +
		"\n" +
		"    chezmoi merge ~/.bashrc\n" +
		"\n" +
		"### `purge`\n" +
		"\n" +
		"Remove chezmoi's configuration, state, and source directory, but leave the\n" +
		"target state intact.\n" +
		"\n" +
		"#### `-f`, `--force`\n" +
		"\n" +
		"Remove without prompting.\n" +
		"\n" +
		"#### `purge` examples\n" +
		"\n" +
		"    chezmoi purge\n" +
		"    chezmoi purge --force\n" +
		"\n" +
		"### `remove` *targets*\n" +
		"\n" +
		"Remove *targets* from both the source state and the destination directory.\n" +
		"\n" +
		"#### `-f`, `--force`\n" +
		"\n" +
		"Remove without prompting.\n" +
		"\n" +
		"### `rm` *targets*\n" +
		"\n" +
		"`rm` is an alias for `remove`.\n" +
		"\n" +
		"### `secret`\n" +
		"\n" +
		"Run a secret manager's CLI, passing any extra arguments to the secret manager's\n" +
		"CLI. This is primarily for verifying chezmoi's integration with your secret\n" +
		"manager. Normally you would use template functions to retrieve secrets. Note\n" +
		"that if you want to pass flags to the secret manager's CLU you will need to\n" +
		"separate them with `--` to prevent chezmoi from interpreting them.\n" +
		"\n" +
		"To get a full list of available commands run:\n" +
		"\n" +
		"    chezmoi secret help\n" +
		"\n" +
		"#### `secret` examples\n" +
		"\n" +
		"    chezmoi secret bitwarden list items\n" +
		"    chezmoi secret keyring set --service service --user user\n" +
		"    chezmoi secret keyring get --service service --user user\n" +
		"    chezmoi secret lastpass ls\n" +
		"    chezmoi secret lastpass -- show --format=json id\n" +
		"    chezmoi secret onepassword list items\n" +
		"    chezmoi secret onepassword get item id\n" +
		"    chezmoi secret pass show id\n" +
		"    chezmoi secret vault -- kv get -format=json id\n" +
		"\n" +
		"### `source` [*args*]\n" +
		"\n" +
		"Execute the source version control system in the source directory with *args*.\n" +
		"Note that any flags for the source version control system must be sepeated with\n" +
		"a `--` to stop chezmoi from reading them.\n" +
		"\n" +
		"#### `source` examples\n" +
		"\n" +
		"    chezmoi source init\n" +
		"    chezmoi source add .\n" +
		"    chezmoi source commit -- -m \"Initial commit\"\n" +
		"\n" +
		"### `source-path` [*targets*]\n" +
		"\n" +
		"Print the path to each target's source state. If no targets are specified then\n" +
		"print the source directory.\n" +
		"\n" +
		"#### `source-path` examples\n" +
		"\n" +
		"    chezmoi source-path\n" +
		"    chezmoi source-path ~/.bashrc\n" +
		"\n" +
		"### `unmanage` *targets*\n" +
		"\n" +
		"`unmanage` is an alias for `forget` for symmetry with `manage`.\n" +
		"\n" +
		"### `unmanaged`\n" +
		"\n" +
		"List all unmanaged files in the destination directory.\n" +
		"\n" +
		"#### `unmanaged` examples\n" +
		"\n" +
		"    chezmoi unmanaged\n" +
		"\n" +
		"### `update`\n" +
		"\n" +
		"Pull changes from the source VCS and apply any changes.\n" +
		"\n" +
		"#### `update` examples\n" +
		"\n" +
		"    chezmoi update\n" +
		"\n" +
		"### `upgrade`\n" +
		"\n" +
		"Upgrade chezmoi by downloading and installing the latest released version. This\n" +
		"will call the GitHub API to determine if there is a new version of chezmoi\n" +
		"available, and if so, download and attempt to install it in the same way as\n" +
		"chezmoi was previously installed.\n" +
		"\n" +
		"If chezmoi was installed with a package manager (`dpkg` or `rpm`) then `upgrade`\n" +
		"will download a new package and install it, using `sudo` if it is installed.\n" +
		"Otherwise, chezmoi will download the latest executable and replace the existing\n" +
		"executable with the new version.\n" +
		"\n" +
		"If the `CHEZMOI_GITHUB_API_TOKEN` environment variable is set, then its value\n" +
		"will be used to authenticate requests to the GitHub API, otherwise\n" +
		"unauthenticated requests are used which are subject to stricter [rate\n" +
		"limiting](https://developer.github.com/v3/#rate-limiting). Unauthenticated\n" +
		"requests should be sufficient for most cases.\n" +
		"\n" +
		"#### `upgrade` examples\n" +
		"\n" +
		"    chezmoi upgrade\n" +
		"\n" +
		"### `verify` [*targets*]\n" +
		"\n" +
		"Verify that all *targets* match their target state. chezmoi exits with code 0\n" +
		"(success) if all targets match their target state, or 1 (failure) otherwise. If\n" +
		"no targets are specified then all targets are checked.\n" +
		"\n" +
		"#### `verify` examples\n" +
		"\n" +
		"    chezmoi verify\n" +
		"    chezmoi verify ~/.bashrc\n" +
		"\n" +
		"## Editor configuration\n" +
		"\n" +
		"The `edit` and `edit-config` commands use the editor specified by the `VISUAL`\n" +
		"environment variable, the `EDITOR` environment variable, or `vi`, whichever is\n" +
		"specified first.\n" +
		"\n" +
		"## Umask configuration\n" +
		"\n" +
		"By default, chezmoi uses your current umask as set by your operating system and\n" +
		"shell. chezmoi only stores crude permissions in its source state, namely in the\n" +
		"`executable`  and `private` attributes, corresponding to the umasks of `0o111`\n" +
		"and `0o077` respectively.\n" +
		"\n" +
		"For machine-specific control of umask, set the `umask` configuration variable in\n" +
		"chezmoi's configuration file, for example:\n" +
		"\n" +
		"    umask = 0o22\n" +
		"\n" +
		"## Template execution\n" +
		"\n" +
		"chezmoi executes templates using\n" +
		"[`text/template`](https://pkg.go.dev/text/template). The result is treated\n" +
		"differently depending on whether the target is a file or a symlink.\n" +
		"\n" +
		"If target is a file, then:\n" +
		"\n" +
		"* If the result is an empty string, then the file is removed.\n" +
		"* Otherwise, the target file contents are result.\n" +
		"\n" +
		"If the target is a symlink, then:\n" +
		"\n" +
		"* Leading and trailing whitespace are stripped from the result.\n" +
		"* If the result is an empty string, then the symlink is removed.\n" +
		"* Otherwise, the target symlink target is the result.\n" +
		"\n" +
		"chezmoi executes templates using `text/template`'s `missingkey=error` option,\n" +
		"which means that misspelled or missing keys will raise an error. This can be\n" +
		"overridden by setting a list of options in the configuration file, for example:\n" +
		"\n" +
		"    [template]\n" +
		"      options = [\"missingkey=zero\"]\n" +
		"\n" +
		"For a full list of options, see\n" +
		"[`Template.Option`](https://pkg.go.dev/text/template?tab=doc#Template.Option).\n" +
		"\n" +
		"## Template variables\n" +
		"\n" +
		"chezmoi provides the following automatically populated variables:\n" +
		"\n" +
		"| Variable                | Value                                                                                                                           |\n" +
		"| ----------------------- | ------------------------------------------------------------------------------------------------------------------------------- |\n" +
		"| `.chezmoi.arch`         | Architecture, e.g. `amd64`, `arm`, etc. as returned by [runtime.GOARCH](https://pkg.go.dev/runtime?tab=doc#pkg-constants).      |\n" +
		"| `.chezmoi.fullHostname` | The full hostname of the machine chezmoi is running on.                                                                         |\n" +
		"| `.chezmoi.group`        | The group of the user running chezmoi.                                                                                          |\n" +
		"| `.chezmoi.homedir`      | The home directory of the user running chezmoi.                                                                                 |\n" +
		"| `.chezmoi.hostname`     | The hostname of the machine chezmoi is running on, up to the first `.`.                                                         |\n" +
		"| `.chezmoi.kernel`       | Contains information from `/proc/sys/kernel`. Linux only, useful for detecting specific kernels (i.e. Microsoft's WSL kernel).  |\n" +
		"| `.chezmoi.os`           | Operating system, e.g. `darwin`, `linux`, etc. as returned by [runtime.GOOS](https://pkg.go.dev/runtime?tab=doc#pkg-constants). |\n" +
		"| `.chezmoi.osRelease`    | The information from `/etc/os-release`, Linux only, run `chezmoi data` to see its output.                                       |\n" +
		"| `.chezmoi.sourceDir`    | The source directory.                                                                                                           |\n" +
		"| `.chezmoi.username`     | The username of the user running chezmoi.                                                                                       |\n" +
		"\n" +
		"Additional variables can be defined in the config file in the `data` section.\n" +
		"Variable names must consist of a letter and be followed by zero or more letters\n" +
		"and/or digits.\n" +
		"\n" +
		"## Template functions\n" +
		"\n" +
		"All standard [`text/template`](https://pkg.go.dev/text/template) and [text\n" +
		"template functions from `sprig`](http://masterminds.github.io/sprig/) are\n" +
		"included. chezmoi provides some additional functions.\n" +
		"\n" +
		"### `bitwarden` [*args*]\n" +
		"\n" +
		"`bitwarden` returns structured data retrieved from\n" +
		"[Bitwarden](https://bitwarden.com) using the [Bitwarden\n" +
		"CLI](https://github.com/bitwarden/cli) (`bw`). *args* are passed to `bw`\n" +
		"unchanged and the output from `bw` is parsed as JSON. The output from `bw` is\n" +
		"cached so calling `bitwarden` multiple times with the same arguments will only\n" +
		"invoke `bw` once.\n" +
		"\n" +
		"#### `bitwarden` examples\n" +
		"\n" +
		"    username = {{ (bitwarden \"item\" \"example.com\").login.username }}\n" +
		"    password = {{ (bitwarden \"item\" \"example.com\").login.password }}\n" +
		"\n" +
		"### `gopass` *gopass-name*\n" +
		"\n" +
		"`gopass` returns passwords stored in [gopass](https://www.gopass.pw/) using the\n" +
		"gopass CLI (`gopass`). *gopass-name* is passed to `gopass show <gopass-name>`\n" +
		"and first line of the output of `gopass` is returned with the trailing newline\n" +
		"stripped. The output from `gopass` is cached so calling `gopass` multiple times\n" +
		"with the same *gopass-name* will only invoke `gopass` once.\n" +
		"\n" +
		"#### `gopass` examples\n" +
		"\n" +
		"    {{ gopass \"<pass-name>\" }}\n" +
		"\n" +
		"### `keepassxc` *entry*\n" +
		"\n" +
		"`keepassxc` returns structured data retrieved from a\n" +
		"[KeePassXC](https://keepassxc.org/) database using the KeePassXC CLI\n" +
		"(`keepassxc-cli`). The database is configured by setting `keepassxc.database` in\n" +
		"the configuration file. *database* and *entry* are passed to `keepassxc-cli\n" +
		"show`. You will be prompted for the database password the first time\n" +
		"`keepassxc-cli` is run, and the password is cached, in plain text, in memory\n" +
		"until chezmoi terminates. The output from `keepassxc-cli` is parsed into\n" +
		"key-value pairs and cached so calling `keepassxc` multiple times with the same\n" +
		"*entry* will only invoke `keepassxc-cli` once.\n" +
		"\n" +
		"#### `keepassxc` examples\n" +
		"\n" +
		"    username = {{ (keepassxc \"example.com\").UserName }}\n" +
		"    password = {{ (keepassxc \"example.com\").Password }}\n" +
		"\n" +
		"### `keepassxcAttribute` *entry* *attribute*\n" +
		"\n" +
		"`keepassxcAttribute` returns the attribute *attribute* of *entry* using\n" +
		"`keepassxc-cli`, with any leading or trailing whitespace removed. It behaves\n" +
		"identically to the `keepassxc` function in terms of configuration, password\n" +
		"prompting, password storage, and result caching.\n" +
		"\n" +
		"#### `keepassxcAttribute` examples\n" +
		"\n" +
		"    {{ keepassxcAttribute \"SSH Key\" \"private-key\" }}\n" +
		"\n" +
		"### `keyring` *service* *user*\n" +
		"\n" +
		"`keyring` retrieves the password associated with *service* and *user* from the\n" +
		"user's keyring.\n" +
		"\n" +
		"| OS    | Keyring       |\n" +
		"| ----- | ------------- |\n" +
		"| macOS | Keychain      |\n" +
		"| Linux | GNOME Keyring |\n" +
		"\n" +
		"#### `keyring` examples\n" +
		"\n" +
		"    [github]\n" +
		"      user = \"{{ .github.user }}\"\n" +
		"      token = \"{{ keyring \"github\" .github.user }}\"\n" +
		"\n" +
		"### `lastpass` *id*\n" +
		"\n" +
		"`lastpass` returns structured data from [LastPass](https://lastpass.com) using\n" +
		"the [LastPass CLI](https://lastpass.github.io/lastpass-cli/lpass.1.html)\n" +
		"(`lpass`). *id* is passed to `lpass show --json <id>` and the output from\n" +
		"`lpass` is parsed as JSON. In addition, the `note` field, if present, is further\n" +
		"parsed as colon-separated key-value pairs. The structured data is an array so\n" +
		"typically the `index` function is used to extract the first item. The output\n" +
		"from `lastpass` is cached so calling `lastpass` multiple times with the same\n" +
		"*id* will only invoke `lpass` once.\n" +
		"\n" +
		"#### `lastpass` examples\n" +
		"\n" +
		"    githubPassword = \"{{ (index (lastpass \"GitHub\") 0).password }}\"\n" +
		"    {{ (index (lastpass \"SSH\") 0).note.privateKey }}\n" +
		"\n" +
		"### `lastpassRaw` *id*\n" +
		"\n" +
		"`lastpassRaw` returns structured data from [LastPass](https://lastpass.com)\n" +
		"using the [LastPass CLI](https://lastpass.github.io/lastpass-cli/lpass.1.html)\n" +
		"(`lpass`). It behaves identically to the `lastpass` function, except that no\n" +
		"further parsing is done on the `note` field.\n" +
		"\n" +
		"#### `lastpassRaw` examples\n" +
		"\n" +
		"    {{ (index (lastpassRaw \"SSH Private Key\") 0).note }}\n" +
		"\n" +
		"### `onepassword` *uuid*\n" +
		"\n" +
		"`onepassword` returns structured data from [1Password](https://1password.com/)\n" +
		"using the [1Password\n" +
		"CLI](https://support.1password.com/command-line-getting-started/) (`op`). *uuid*\n" +
		"is passed to `op get item <uuid>` and the output from `op` is parsed as JSON.\n" +
		"The output from `op` is cached so calling `onepassword` multiple times with the\n" +
		"same *uuid* will only invoke `op` once.\n" +
		"\n" +
		"#### `onepassword` examples\n" +
		"\n" +
		"    {{ (onepassword \"<uuid>\").details.password }}\n" +
		"\n" +
		"### `onepasswordDocument` *uuid*\n" +
		"\n" +
		"`onepassword` returns a document from [1Password](https://1password.com/)\n" +
		"using the [1Password\n" +
		"CLI](https://support.1password.com/command-line-getting-started/) (`op`). *uuid*\n" +
		"is passed to `op get document <uuid>` and the output from `op` is returned.\n" +
		"The output from `op` is cached so calling `onepasswordDocument` multiple times with the\n" +
		"same *uuid* will only invoke `op` once.\n" +
		"\n" +
		"#### `onepasswordDocument` examples\n" +
		"\n" +
		"    {{- onepasswordDocument \"<uuid>\" -}}\n" +
		"\n" +
		"### `pass` *pass-name*\n" +
		"\n" +
		"`pass` returns passwords stored in [pass](https://www.passwordstore.org/) using\n" +
		"the pass CLI (`pass`). *pass-name* is passed to `pass show <pass-name>` and\n" +
		"first line of the output of `pass` is returned with the trailing newline\n" +
		"stripped. The output from `pass` is cached so calling `pass` multiple times with\n" +
		"the same *pass-name* will only invoke `pass` once.\n" +
		"\n" +
		"#### `pass` examples\n" +
		"\n" +
		"    {{ pass \"<pass-name>\" }}\n" +
		"\n" +
		"### `promptString` *prompt*\n" +
		"\n" +
		"`promptString` takes a single argument is a string prompted to the user, and the\n" +
		"return value is the user's response to that prompt with all leading and trailing\n" +
		"space stripped. It is only available when generating the initial config file.\n" +
		"\n" +
		"#### `promptString` examples\n" +
		"\n" +
		"    {{ $email := promptString \"email\" -}}\n" +
		"    [data]\n" +
		"        email = \"{{ $email }}\"\n" +
		"\n" +
		"### `secret` [*args*]\n" +
		"\n" +
		"`secret` returns the output of the generic secret command defined by the\n" +
		"`genericSecret.command` configuration variable with *args* with leading and\n" +
		"trailing whitespace removed. The output is cached so multiple calls to `secret`\n" +
		"with the same *args* will only invoke the generic secret command once.\n" +
		"\n" +
		"### `secretJSON` [*args*]\n" +
		"\n" +
		"`secretJSON` returns structured data from the generic secret command defined by\n" +
		"the `genericSecret.command` configuration variable with *args*. The output is\n" +
		"parsed as JSON. The output is cached so multiple calls to `secret` with the same\n" +
		"*args* will only invoke the generic secret command once.\n" +
		"\n" +
		"### `vault` *key*\n" +
		"\n" +
		"`vault` returns structured data from [Vault](https://www.vaultproject.io/) using\n" +
		"the [Vault CLI](https://www.vaultproject.io/docs/commands/) (`vault`). *key* is\n" +
		"passed to `vault kv get -format=json <key>` and the output from `vault` is\n" +
		"parsed as JSON. The output from `vault` is cached so calling `vault` multiple\n" +
		"times with the same *key* will only invoke `vault` once.\n" +
		"\n" +
		"#### `vault` examples\n" +
		"\n" +
		"    {{ (vault \"<key>\").data.data.password }}\n")
}
