// Code generated by capnpc-go. DO NOT EDIT.

package aircraftlib

import (
	context "golang.org/x/net/context"
	math "math"
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
	server "zombiezen.com/go/capnproto2/server"
)

// Constants defined in aircraft.capnp.
const (
	ConstEnum = Airport_jfk
)

// Constants defined in aircraft.capnp.
var (
	ConstDate = Zdate{Struct: capnp.MustUnmarshalRootPtr(x_832bcc6686a26d56[0:24]).Struct()}
	ConstList = Zdate_List{List: capnp.MustUnmarshalRootPtr(x_832bcc6686a26d56[24:64]).List()}
)

func init() {
	// Set traversal limit for constants as Uint64Max since they're safe from amplification attacks.
	ConstDate.Segment().Message().ReadLimiter().Reset((1 << 64) - 1)
	ConstList.Segment().Message().ReadLimiter().Reset((1 << 64) - 1)
}

type Zdate struct{ capnp.Struct }

// Zdate_TypeID is the unique identifier for the type Zdate.
const Zdate_TypeID = 0xde50aebbad57549d

func NewZdate(s *capnp.Segment) (Zdate, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Zdate{st}, err
}

func NewRootZdate(s *capnp.Segment) (Zdate, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Zdate{st}, err
}

func ReadRootZdate(msg *capnp.Message) (Zdate, error) {
	root, err := msg.RootPtr()
	return Zdate{root.Struct()}, err
}

func (s Zdate) String() string {
	str, _ := text.Marshal(0xde50aebbad57549d, s.Struct)
	return str
}

func (s Zdate) Year() int16 {
	return int16(s.Struct.Uint16(0))
}

func (s Zdate) SetYear(v int16) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s Zdate) Month() uint8 {
	return s.Struct.Uint8(2)
}

func (s Zdate) SetMonth(v uint8) {
	s.Struct.SetUint8(2, v)
}

func (s Zdate) Day() uint8 {
	return s.Struct.Uint8(3)
}

func (s Zdate) SetDay(v uint8) {
	s.Struct.SetUint8(3, v)
}

// Zdate_List is a list of Zdate.
type Zdate_List struct{ capnp.List }

// NewZdate creates a new list of Zdate.
func NewZdate_List(s *capnp.Segment, sz int32) (Zdate_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return Zdate_List{l}, err
}

func (s Zdate_List) At(i int) Zdate { return Zdate{s.List.Struct(i)} }

func (s Zdate_List) Set(i int, v Zdate) error { return s.List.SetStruct(i, v.Struct) }

func (s Zdate_List) String() string {
	str, _ := text.MarshalList(0xde50aebbad57549d, s.List)
	return str
}

// Zdate_Promise is a wrapper for a Zdate promised by a client call.
type Zdate_Promise struct{ *capnp.Pipeline }

func (p Zdate_Promise) Struct() (Zdate, error) {
	s, err := p.Pipeline.Struct()
	return Zdate{s}, err
}

type Zdata struct{ capnp.Struct }

// Zdata_TypeID is the unique identifier for the type Zdata.
const Zdata_TypeID = 0xc7da65f9a2f20ba2

func NewZdata(s *capnp.Segment) (Zdata, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Zdata{st}, err
}

func NewRootZdata(s *capnp.Segment) (Zdata, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Zdata{st}, err
}

func ReadRootZdata(msg *capnp.Message) (Zdata, error) {
	root, err := msg.RootPtr()
	return Zdata{root.Struct()}, err
}

func (s Zdata) String() string {
	str, _ := text.Marshal(0xc7da65f9a2f20ba2, s.Struct)
	return str
}

func (s Zdata) Data() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s Zdata) HasData() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Zdata) SetData(v []byte) error {
	return s.Struct.SetData(0, v)
}

// Zdata_List is a list of Zdata.
type Zdata_List struct{ capnp.List }

// NewZdata creates a new list of Zdata.
func NewZdata_List(s *capnp.Segment, sz int32) (Zdata_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Zdata_List{l}, err
}

func (s Zdata_List) At(i int) Zdata { return Zdata{s.List.Struct(i)} }

func (s Zdata_List) Set(i int, v Zdata) error { return s.List.SetStruct(i, v.Struct) }

func (s Zdata_List) String() string {
	str, _ := text.MarshalList(0xc7da65f9a2f20ba2, s.List)
	return str
}

// Zdata_Promise is a wrapper for a Zdata promised by a client call.
type Zdata_Promise struct{ *capnp.Pipeline }

func (p Zdata_Promise) Struct() (Zdata, error) {
	s, err := p.Pipeline.Struct()
	return Zdata{s}, err
}

type Airport uint16

// Airport_TypeID is the unique identifier for the type Airport.
const Airport_TypeID = 0xe55d85fc1bf82f21

// Values of Airport.
const (
	Airport_none Airport = 0
	Airport_jfk  Airport = 1
	Airport_lax  Airport = 2
	Airport_sfo  Airport = 3
	Airport_luv  Airport = 4
	Airport_dfw  Airport = 5
	Airport_test Airport = 6
)

// String returns the enum's constant name.
func (c Airport) String() string {
	switch c {
	case Airport_none:
		return "none"
	case Airport_jfk:
		return "jfk"
	case Airport_lax:
		return "lax"
	case Airport_sfo:
		return "sfo"
	case Airport_luv:
		return "luv"
	case Airport_dfw:
		return "dfw"
	case Airport_test:
		return "test"

	default:
		return ""
	}
}

// AirportFromString returns the enum value with a name,
// or the zero value if there's no such value.
func AirportFromString(c string) Airport {
	switch c {
	case "none":
		return Airport_none
	case "jfk":
		return Airport_jfk
	case "lax":
		return Airport_lax
	case "sfo":
		return Airport_sfo
	case "luv":
		return Airport_luv
	case "dfw":
		return Airport_dfw
	case "test":
		return Airport_test

	default:
		return 0
	}
}

type Airport_List struct{ capnp.List }

func NewAirport_List(s *capnp.Segment, sz int32) (Airport_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return Airport_List{l.List}, err
}

func (l Airport_List) At(i int) Airport {
	ul := capnp.UInt16List{List: l.List}
	return Airport(ul.At(i))
}

func (l Airport_List) Set(i int, v Airport) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type PlaneBase struct{ capnp.Struct }

// PlaneBase_TypeID is the unique identifier for the type PlaneBase.
const PlaneBase_TypeID = 0xd8bccf6e60a73791

func NewPlaneBase(s *capnp.Segment) (PlaneBase, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 32, PointerCount: 2})
	return PlaneBase{st}, err
}

func NewRootPlaneBase(s *capnp.Segment) (PlaneBase, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 32, PointerCount: 2})
	return PlaneBase{st}, err
}

func ReadRootPlaneBase(msg *capnp.Message) (PlaneBase, error) {
	root, err := msg.RootPtr()
	return PlaneBase{root.Struct()}, err
}

func (s PlaneBase) String() string {
	str, _ := text.Marshal(0xd8bccf6e60a73791, s.Struct)
	return str
}

func (s PlaneBase) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s PlaneBase) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s PlaneBase) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s PlaneBase) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s PlaneBase) Homes() (Airport_List, error) {
	p, err := s.Struct.Ptr(1)
	return Airport_List{List: p.List()}, err
}

func (s PlaneBase) HasHomes() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s PlaneBase) SetHomes(v Airport_List) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewHomes sets the homes field to a newly
// allocated Airport_List, preferring placement in s's segment.
func (s PlaneBase) NewHomes(n int32) (Airport_List, error) {
	l, err := NewAirport_List(s.Struct.Segment(), n)
	if err != nil {
		return Airport_List{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s PlaneBase) Rating() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s PlaneBase) SetRating(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s PlaneBase) CanFly() bool {
	return s.Struct.Bit(64)
}

func (s PlaneBase) SetCanFly(v bool) {
	s.Struct.SetBit(64, v)
}

func (s PlaneBase) Capacity() int64 {
	return int64(s.Struct.Uint64(16))
}

func (s PlaneBase) SetCapacity(v int64) {
	s.Struct.SetUint64(16, uint64(v))
}

func (s PlaneBase) MaxSpeed() float64 {
	return math.Float64frombits(s.Struct.Uint64(24))
}

func (s PlaneBase) SetMaxSpeed(v float64) {
	s.Struct.SetUint64(24, math.Float64bits(v))
}

// PlaneBase_List is a list of PlaneBase.
type PlaneBase_List struct{ capnp.List }

// NewPlaneBase creates a new list of PlaneBase.
func NewPlaneBase_List(s *capnp.Segment, sz int32) (PlaneBase_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 32, PointerCount: 2}, sz)
	return PlaneBase_List{l}, err
}

func (s PlaneBase_List) At(i int) PlaneBase { return PlaneBase{s.List.Struct(i)} }

func (s PlaneBase_List) Set(i int, v PlaneBase) error { return s.List.SetStruct(i, v.Struct) }

func (s PlaneBase_List) String() string {
	str, _ := text.MarshalList(0xd8bccf6e60a73791, s.List)
	return str
}

// PlaneBase_Promise is a wrapper for a PlaneBase promised by a client call.
type PlaneBase_Promise struct{ *capnp.Pipeline }

func (p PlaneBase_Promise) Struct() (PlaneBase, error) {
	s, err := p.Pipeline.Struct()
	return PlaneBase{s}, err
}

type B737 struct{ capnp.Struct }

// B737_TypeID is the unique identifier for the type B737.
const B737_TypeID = 0xccb3b2e3603826e0

func NewB737(s *capnp.Segment) (B737, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return B737{st}, err
}

func NewRootB737(s *capnp.Segment) (B737, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return B737{st}, err
}

func ReadRootB737(msg *capnp.Message) (B737, error) {
	root, err := msg.RootPtr()
	return B737{root.Struct()}, err
}

func (s B737) String() string {
	str, _ := text.Marshal(0xccb3b2e3603826e0, s.Struct)
	return str
}

func (s B737) Base() (PlaneBase, error) {
	p, err := s.Struct.Ptr(0)
	return PlaneBase{Struct: p.Struct()}, err
}

func (s B737) HasBase() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s B737) SetBase(v PlaneBase) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewBase sets the base field to a newly
// allocated PlaneBase struct, preferring placement in s's segment.
func (s B737) NewBase() (PlaneBase, error) {
	ss, err := NewPlaneBase(s.Struct.Segment())
	if err != nil {
		return PlaneBase{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// B737_List is a list of B737.
type B737_List struct{ capnp.List }

// NewB737 creates a new list of B737.
func NewB737_List(s *capnp.Segment, sz int32) (B737_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return B737_List{l}, err
}

func (s B737_List) At(i int) B737 { return B737{s.List.Struct(i)} }

func (s B737_List) Set(i int, v B737) error { return s.List.SetStruct(i, v.Struct) }

func (s B737_List) String() string {
	str, _ := text.MarshalList(0xccb3b2e3603826e0, s.List)
	return str
}

// B737_Promise is a wrapper for a B737 promised by a client call.
type B737_Promise struct{ *capnp.Pipeline }

func (p B737_Promise) Struct() (B737, error) {
	s, err := p.Pipeline.Struct()
	return B737{s}, err
}

func (p B737_Promise) Base() PlaneBase_Promise {
	return PlaneBase_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type A320 struct{ capnp.Struct }

// A320_TypeID is the unique identifier for the type A320.
const A320_TypeID = 0xd98c608877d9cb8d

func NewA320(s *capnp.Segment) (A320, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return A320{st}, err
}

func NewRootA320(s *capnp.Segment) (A320, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return A320{st}, err
}

func ReadRootA320(msg *capnp.Message) (A320, error) {
	root, err := msg.RootPtr()
	return A320{root.Struct()}, err
}

func (s A320) String() string {
	str, _ := text.Marshal(0xd98c608877d9cb8d, s.Struct)
	return str
}

func (s A320) Base() (PlaneBase, error) {
	p, err := s.Struct.Ptr(0)
	return PlaneBase{Struct: p.Struct()}, err
}

func (s A320) HasBase() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s A320) SetBase(v PlaneBase) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewBase sets the base field to a newly
// allocated PlaneBase struct, preferring placement in s's segment.
func (s A320) NewBase() (PlaneBase, error) {
	ss, err := NewPlaneBase(s.Struct.Segment())
	if err != nil {
		return PlaneBase{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// A320_List is a list of A320.
type A320_List struct{ capnp.List }

// NewA320 creates a new list of A320.
func NewA320_List(s *capnp.Segment, sz int32) (A320_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return A320_List{l}, err
}

func (s A320_List) At(i int) A320 { return A320{s.List.Struct(i)} }

func (s A320_List) Set(i int, v A320) error { return s.List.SetStruct(i, v.Struct) }

func (s A320_List) String() string {
	str, _ := text.MarshalList(0xd98c608877d9cb8d, s.List)
	return str
}

// A320_Promise is a wrapper for a A320 promised by a client call.
type A320_Promise struct{ *capnp.Pipeline }

func (p A320_Promise) Struct() (A320, error) {
	s, err := p.Pipeline.Struct()
	return A320{s}, err
}

func (p A320_Promise) Base() PlaneBase_Promise {
	return PlaneBase_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type F16 struct{ capnp.Struct }

// F16_TypeID is the unique identifier for the type F16.
const F16_TypeID = 0xe1c9eac512335361

func NewF16(s *capnp.Segment) (F16, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return F16{st}, err
}

func NewRootF16(s *capnp.Segment) (F16, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return F16{st}, err
}

func ReadRootF16(msg *capnp.Message) (F16, error) {
	root, err := msg.RootPtr()
	return F16{root.Struct()}, err
}

func (s F16) String() string {
	str, _ := text.Marshal(0xe1c9eac512335361, s.Struct)
	return str
}

func (s F16) Base() (PlaneBase, error) {
	p, err := s.Struct.Ptr(0)
	return PlaneBase{Struct: p.Struct()}, err
}

func (s F16) HasBase() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s F16) SetBase(v PlaneBase) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewBase sets the base field to a newly
// allocated PlaneBase struct, preferring placement in s's segment.
func (s F16) NewBase() (PlaneBase, error) {
	ss, err := NewPlaneBase(s.Struct.Segment())
	if err != nil {
		return PlaneBase{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// F16_List is a list of F16.
type F16_List struct{ capnp.List }

// NewF16 creates a new list of F16.
func NewF16_List(s *capnp.Segment, sz int32) (F16_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return F16_List{l}, err
}

func (s F16_List) At(i int) F16 { return F16{s.List.Struct(i)} }

func (s F16_List) Set(i int, v F16) error { return s.List.SetStruct(i, v.Struct) }

func (s F16_List) String() string {
	str, _ := text.MarshalList(0xe1c9eac512335361, s.List)
	return str
}

// F16_Promise is a wrapper for a F16 promised by a client call.
type F16_Promise struct{ *capnp.Pipeline }

func (p F16_Promise) Struct() (F16, error) {
	s, err := p.Pipeline.Struct()
	return F16{s}, err
}

func (p F16_Promise) Base() PlaneBase_Promise {
	return PlaneBase_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Regression struct{ capnp.Struct }

// Regression_TypeID is the unique identifier for the type Regression.
const Regression_TypeID = 0xb1f0385d845e367f

func NewRegression(s *capnp.Segment) (Regression, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Regression{st}, err
}

func NewRootRegression(s *capnp.Segment) (Regression, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Regression{st}, err
}

func ReadRootRegression(msg *capnp.Message) (Regression, error) {
	root, err := msg.RootPtr()
	return Regression{root.Struct()}, err
}

func (s Regression) String() string {
	str, _ := text.Marshal(0xb1f0385d845e367f, s.Struct)
	return str
}

func (s Regression) Base() (PlaneBase, error) {
	p, err := s.Struct.Ptr(0)
	return PlaneBase{Struct: p.Struct()}, err
}

func (s Regression) HasBase() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Regression) SetBase(v PlaneBase) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewBase sets the base field to a newly
// allocated PlaneBase struct, preferring placement in s's segment.
func (s Regression) NewBase() (PlaneBase, error) {
	ss, err := NewPlaneBase(s.Struct.Segment())
	if err != nil {
		return PlaneBase{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Regression) B0() float64 {
	return math.Float64frombits(s.Struct.Uint64(0))
}

func (s Regression) SetB0(v float64) {
	s.Struct.SetUint64(0, math.Float64bits(v))
}

func (s Regression) Beta() (capnp.Float64List, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.Float64List{List: p.List()}, err
}

func (s Regression) HasBeta() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Regression) SetBeta(v capnp.Float64List) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewBeta sets the beta field to a newly
// allocated capnp.Float64List, preferring placement in s's segment.
func (s Regression) NewBeta(n int32) (capnp.Float64List, error) {
	l, err := capnp.NewFloat64List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Float64List{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s Regression) Planes() (Aircraft_List, error) {
	p, err := s.Struct.Ptr(2)
	return Aircraft_List{List: p.List()}, err
}

func (s Regression) HasPlanes() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Regression) SetPlanes(v Aircraft_List) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewPlanes sets the planes field to a newly
// allocated Aircraft_List, preferring placement in s's segment.
func (s Regression) NewPlanes(n int32) (Aircraft_List, error) {
	l, err := NewAircraft_List(s.Struct.Segment(), n)
	if err != nil {
		return Aircraft_List{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s Regression) Ymu() float64 {
	return math.Float64frombits(s.Struct.Uint64(8))
}

func (s Regression) SetYmu(v float64) {
	s.Struct.SetUint64(8, math.Float64bits(v))
}

func (s Regression) Ysd() float64 {
	return math.Float64frombits(s.Struct.Uint64(16))
}

func (s Regression) SetYsd(v float64) {
	s.Struct.SetUint64(16, math.Float64bits(v))
}

// Regression_List is a list of Regression.
type Regression_List struct{ capnp.List }

// NewRegression creates a new list of Regression.
func NewRegression_List(s *capnp.Segment, sz int32) (Regression_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return Regression_List{l}, err
}

func (s Regression_List) At(i int) Regression { return Regression{s.List.Struct(i)} }

func (s Regression_List) Set(i int, v Regression) error { return s.List.SetStruct(i, v.Struct) }

func (s Regression_List) String() string {
	str, _ := text.MarshalList(0xb1f0385d845e367f, s.List)
	return str
}

// Regression_Promise is a wrapper for a Regression promised by a client call.
type Regression_Promise struct{ *capnp.Pipeline }

func (p Regression_Promise) Struct() (Regression, error) {
	s, err := p.Pipeline.Struct()
	return Regression{s}, err
}

func (p Regression_Promise) Base() PlaneBase_Promise {
	return PlaneBase_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Aircraft struct{ capnp.Struct }
type Aircraft_Which uint16

const (
	Aircraft_Which_void Aircraft_Which = 0
	Aircraft_Which_b737 Aircraft_Which = 1
	Aircraft_Which_a320 Aircraft_Which = 2
	Aircraft_Which_f16  Aircraft_Which = 3
)

func (w Aircraft_Which) String() string {
	const s = "voidb737a320f16"
	switch w {
	case Aircraft_Which_void:
		return s[0:4]
	case Aircraft_Which_b737:
		return s[4:8]
	case Aircraft_Which_a320:
		return s[8:12]
	case Aircraft_Which_f16:
		return s[12:15]

	}
	return "Aircraft_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Aircraft_TypeID is the unique identifier for the type Aircraft.
const Aircraft_TypeID = 0xe54e10aede55c7b1

func NewAircraft(s *capnp.Segment) (Aircraft, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Aircraft{st}, err
}

func NewRootAircraft(s *capnp.Segment) (Aircraft, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Aircraft{st}, err
}

func ReadRootAircraft(msg *capnp.Message) (Aircraft, error) {
	root, err := msg.RootPtr()
	return Aircraft{root.Struct()}, err
}

func (s Aircraft) String() string {
	str, _ := text.Marshal(0xe54e10aede55c7b1, s.Struct)
	return str
}

func (s Aircraft) Which() Aircraft_Which {
	return Aircraft_Which(s.Struct.Uint16(0))
}
func (s Aircraft) SetVoid() {
	s.Struct.SetUint16(0, 0)

}

func (s Aircraft) B737() (B737, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != b737")
	}
	p, err := s.Struct.Ptr(0)
	return B737{Struct: p.Struct()}, err
}

func (s Aircraft) HasB737() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Aircraft) SetB737(v B737) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewB737 sets the b737 field to a newly
// allocated B737 struct, preferring placement in s's segment.
func (s Aircraft) NewB737() (B737, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewB737(s.Struct.Segment())
	if err != nil {
		return B737{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Aircraft) A320() (A320, error) {
	if s.Struct.Uint16(0) != 2 {
		panic("Which() != a320")
	}
	p, err := s.Struct.Ptr(0)
	return A320{Struct: p.Struct()}, err
}

func (s Aircraft) HasA320() bool {
	if s.Struct.Uint16(0) != 2 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Aircraft) SetA320(v A320) error {
	s.Struct.SetUint16(0, 2)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewA320 sets the a320 field to a newly
// allocated A320 struct, preferring placement in s's segment.
func (s Aircraft) NewA320() (A320, error) {
	s.Struct.SetUint16(0, 2)
	ss, err := NewA320(s.Struct.Segment())
	if err != nil {
		return A320{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Aircraft) F16() (F16, error) {
	if s.Struct.Uint16(0) != 3 {
		panic("Which() != f16")
	}
	p, err := s.Struct.Ptr(0)
	return F16{Struct: p.Struct()}, err
}

func (s Aircraft) HasF16() bool {
	if s.Struct.Uint16(0) != 3 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Aircraft) SetF16(v F16) error {
	s.Struct.SetUint16(0, 3)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewF16 sets the f16 field to a newly
// allocated F16 struct, preferring placement in s's segment.
func (s Aircraft) NewF16() (F16, error) {
	s.Struct.SetUint16(0, 3)
	ss, err := NewF16(s.Struct.Segment())
	if err != nil {
		return F16{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Aircraft_List is a list of Aircraft.
type Aircraft_List struct{ capnp.List }

// NewAircraft creates a new list of Aircraft.
func NewAircraft_List(s *capnp.Segment, sz int32) (Aircraft_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return Aircraft_List{l}, err
}

func (s Aircraft_List) At(i int) Aircraft { return Aircraft{s.List.Struct(i)} }

func (s Aircraft_List) Set(i int, v Aircraft) error { return s.List.SetStruct(i, v.Struct) }

func (s Aircraft_List) String() string {
	str, _ := text.MarshalList(0xe54e10aede55c7b1, s.List)
	return str
}

// Aircraft_Promise is a wrapper for a Aircraft promised by a client call.
type Aircraft_Promise struct{ *capnp.Pipeline }

func (p Aircraft_Promise) Struct() (Aircraft, error) {
	s, err := p.Pipeline.Struct()
	return Aircraft{s}, err
}

func (p Aircraft_Promise) B737() B737_Promise {
	return B737_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Aircraft_Promise) A320() A320_Promise {
	return A320_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Aircraft_Promise) F16() F16_Promise {
	return F16_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Z struct{ capnp.Struct }
type Z_grp Z
type Z_Which uint16

const (
	Z_Which_void        Z_Which = 0
	Z_Which_zz          Z_Which = 1
	Z_Which_f64         Z_Which = 2
	Z_Which_f32         Z_Which = 3
	Z_Which_i64         Z_Which = 4
	Z_Which_i32         Z_Which = 5
	Z_Which_i16         Z_Which = 6
	Z_Which_i8          Z_Which = 7
	Z_Which_u64         Z_Which = 8
	Z_Which_u32         Z_Which = 9
	Z_Which_u16         Z_Which = 10
	Z_Which_u8          Z_Which = 11
	Z_Which_bool        Z_Which = 12
	Z_Which_text        Z_Which = 13
	Z_Which_blob        Z_Which = 14
	Z_Which_f64vec      Z_Which = 15
	Z_Which_f32vec      Z_Which = 16
	Z_Which_i64vec      Z_Which = 17
	Z_Which_i32vec      Z_Which = 18
	Z_Which_i16vec      Z_Which = 19
	Z_Which_i8vec       Z_Which = 20
	Z_Which_u64vec      Z_Which = 21
	Z_Which_u32vec      Z_Which = 22
	Z_Which_u16vec      Z_Which = 23
	Z_Which_u8vec       Z_Which = 24
	Z_Which_boolvec     Z_Which = 39
	Z_Which_datavec     Z_Which = 40
	Z_Which_textvec     Z_Which = 41
	Z_Which_zvec        Z_Which = 25
	Z_Which_zvecvec     Z_Which = 26
	Z_Which_zdate       Z_Which = 27
	Z_Which_zdata       Z_Which = 28
	Z_Which_aircraftvec Z_Which = 29
	Z_Which_aircraft    Z_Which = 30
	Z_Which_regression  Z_Which = 31
	Z_Which_planebase   Z_Which = 32
	Z_Which_airport     Z_Which = 33
	Z_Which_b737        Z_Which = 34
	Z_Which_a320        Z_Which = 35
	Z_Which_f16         Z_Which = 36
	Z_Which_zdatevec    Z_Which = 37
	Z_Which_zdatavec    Z_Which = 38
	Z_Which_grp         Z_Which = 42
	Z_Which_echo        Z_Which = 43
	Z_Which_echoBases   Z_Which = 44
)

func (w Z_Which) String() string {
	const s = "voidzzf64f32i64i32i16i8u64u32u16u8booltextblobf64vecf32veci64veci32veci16veci8vecu64vecu32vecu16vecu8vecboolvecdatavectextveczveczvecveczdatezdataaircraftvecaircraftregressionplanebaseairportb737a320f16zdateveczdatavecgrpechoechoBases"
	switch w {
	case Z_Which_void:
		return s[0:4]
	case Z_Which_zz:
		return s[4:6]
	case Z_Which_f64:
		return s[6:9]
	case Z_Which_f32:
		return s[9:12]
	case Z_Which_i64:
		return s[12:15]
	case Z_Which_i32:
		return s[15:18]
	case Z_Which_i16:
		return s[18:21]
	case Z_Which_i8:
		return s[21:23]
	case Z_Which_u64:
		return s[23:26]
	case Z_Which_u32:
		return s[26:29]
	case Z_Which_u16:
		return s[29:32]
	case Z_Which_u8:
		return s[32:34]
	case Z_Which_bool:
		return s[34:38]
	case Z_Which_text:
		return s[38:42]
	case Z_Which_blob:
		return s[42:46]
	case Z_Which_f64vec:
		return s[46:52]
	case Z_Which_f32vec:
		return s[52:58]
	case Z_Which_i64vec:
		return s[58:64]
	case Z_Which_i32vec:
		return s[64:70]
	case Z_Which_i16vec:
		return s[70:76]
	case Z_Which_i8vec:
		return s[76:81]
	case Z_Which_u64vec:
		return s[81:87]
	case Z_Which_u32vec:
		return s[87:93]
	case Z_Which_u16vec:
		return s[93:99]
	case Z_Which_u8vec:
		return s[99:104]
	case Z_Which_boolvec:
		return s[104:111]
	case Z_Which_datavec:
		return s[111:118]
	case Z_Which_textvec:
		return s[118:125]
	case Z_Which_zvec:
		return s[125:129]
	case Z_Which_zvecvec:
		return s[129:136]
	case Z_Which_zdate:
		return s[136:141]
	case Z_Which_zdata:
		return s[141:146]
	case Z_Which_aircraftvec:
		return s[146:157]
	case Z_Which_aircraft:
		return s[157:165]
	case Z_Which_regression:
		return s[165:175]
	case Z_Which_planebase:
		return s[175:184]
	case Z_Which_airport:
		return s[184:191]
	case Z_Which_b737:
		return s[191:195]
	case Z_Which_a320:
		return s[195:199]
	case Z_Which_f16:
		return s[199:202]
	case Z_Which_zdatevec:
		return s[202:210]
	case Z_Which_zdatavec:
		return s[210:218]
	case Z_Which_grp:
		return s[218:221]
	case Z_Which_echo:
		return s[221:225]
	case Z_Which_echoBases:
		return s[225:234]

	}
	return "Z_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Z_TypeID is the unique identifier for the type Z.
const Z_TypeID = 0xea26e9973bd6a0d9

func NewZ(s *capnp.Segment) (Z, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 1})
	return Z{st}, err
}

func NewRootZ(s *capnp.Segment) (Z, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 1})
	return Z{st}, err
}

func ReadRootZ(msg *capnp.Message) (Z, error) {
	root, err := msg.RootPtr()
	return Z{root.Struct()}, err
}

func (s Z) String() string {
	str, _ := text.Marshal(0xea26e9973bd6a0d9, s.Struct)
	return str
}

func (s Z) Which() Z_Which {
	return Z_Which(s.Struct.Uint16(0))
}
func (s Z) SetVoid() {
	s.Struct.SetUint16(0, 0)

}

func (s Z) Zz() (Z, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != zz")
	}
	p, err := s.Struct.Ptr(0)
	return Z{Struct: p.Struct()}, err
}

func (s Z) HasZz() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZz(v Z) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewZz sets the zz field to a newly
// allocated Z struct, preferring placement in s's segment.
func (s Z) NewZz() (Z, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewZ(s.Struct.Segment())
	if err != nil {
		return Z{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) F64() float64 {
	if s.Struct.Uint16(0) != 2 {
		panic("Which() != f64")
	}
	return math.Float64frombits(s.Struct.Uint64(8))
}

func (s Z) SetF64(v float64) {
	s.Struct.SetUint16(0, 2)
	s.Struct.SetUint64(8, math.Float64bits(v))
}

func (s Z) F32() float32 {
	if s.Struct.Uint16(0) != 3 {
		panic("Which() != f32")
	}
	return math.Float32frombits(s.Struct.Uint32(8))
}

func (s Z) SetF32(v float32) {
	s.Struct.SetUint16(0, 3)
	s.Struct.SetUint32(8, math.Float32bits(v))
}

func (s Z) I64() int64 {
	if s.Struct.Uint16(0) != 4 {
		panic("Which() != i64")
	}
	return int64(s.Struct.Uint64(8))
}

func (s Z) SetI64(v int64) {
	s.Struct.SetUint16(0, 4)
	s.Struct.SetUint64(8, uint64(v))
}

func (s Z) I32() int32 {
	if s.Struct.Uint16(0) != 5 {
		panic("Which() != i32")
	}
	return int32(s.Struct.Uint32(8))
}

func (s Z) SetI32(v int32) {
	s.Struct.SetUint16(0, 5)
	s.Struct.SetUint32(8, uint32(v))
}

func (s Z) I16() int16 {
	if s.Struct.Uint16(0) != 6 {
		panic("Which() != i16")
	}
	return int16(s.Struct.Uint16(8))
}

func (s Z) SetI16(v int16) {
	s.Struct.SetUint16(0, 6)
	s.Struct.SetUint16(8, uint16(v))
}

func (s Z) I8() int8 {
	if s.Struct.Uint16(0) != 7 {
		panic("Which() != i8")
	}
	return int8(s.Struct.Uint8(8))
}

func (s Z) SetI8(v int8) {
	s.Struct.SetUint16(0, 7)
	s.Struct.SetUint8(8, uint8(v))
}

func (s Z) U64() uint64 {
	if s.Struct.Uint16(0) != 8 {
		panic("Which() != u64")
	}
	return s.Struct.Uint64(8)
}

func (s Z) SetU64(v uint64) {
	s.Struct.SetUint16(0, 8)
	s.Struct.SetUint64(8, v)
}

func (s Z) U32() uint32 {
	if s.Struct.Uint16(0) != 9 {
		panic("Which() != u32")
	}
	return s.Struct.Uint32(8)
}

func (s Z) SetU32(v uint32) {
	s.Struct.SetUint16(0, 9)
	s.Struct.SetUint32(8, v)
}

func (s Z) U16() uint16 {
	if s.Struct.Uint16(0) != 10 {
		panic("Which() != u16")
	}
	return s.Struct.Uint16(8)
}

func (s Z) SetU16(v uint16) {
	s.Struct.SetUint16(0, 10)
	s.Struct.SetUint16(8, v)
}

func (s Z) U8() uint8 {
	if s.Struct.Uint16(0) != 11 {
		panic("Which() != u8")
	}
	return s.Struct.Uint8(8)
}

func (s Z) SetU8(v uint8) {
	s.Struct.SetUint16(0, 11)
	s.Struct.SetUint8(8, v)
}

func (s Z) Bool() bool {
	if s.Struct.Uint16(0) != 12 {
		panic("Which() != bool")
	}
	return s.Struct.Bit(64)
}

func (s Z) SetBool(v bool) {
	s.Struct.SetUint16(0, 12)
	s.Struct.SetBit(64, v)
}

func (s Z) Text() (string, error) {
	if s.Struct.Uint16(0) != 13 {
		panic("Which() != text")
	}
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Z) HasText() bool {
	if s.Struct.Uint16(0) != 13 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) TextBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Z) SetText(v string) error {
	s.Struct.SetUint16(0, 13)
	return s.Struct.SetText(0, v)
}

func (s Z) Blob() ([]byte, error) {
	if s.Struct.Uint16(0) != 14 {
		panic("Which() != blob")
	}
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s Z) HasBlob() bool {
	if s.Struct.Uint16(0) != 14 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetBlob(v []byte) error {
	s.Struct.SetUint16(0, 14)
	return s.Struct.SetData(0, v)
}

func (s Z) F64vec() (capnp.Float64List, error) {
	if s.Struct.Uint16(0) != 15 {
		panic("Which() != f64vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.Float64List{List: p.List()}, err
}

func (s Z) HasF64vec() bool {
	if s.Struct.Uint16(0) != 15 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetF64vec(v capnp.Float64List) error {
	s.Struct.SetUint16(0, 15)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewF64vec sets the f64vec field to a newly
// allocated capnp.Float64List, preferring placement in s's segment.
func (s Z) NewF64vec(n int32) (capnp.Float64List, error) {
	s.Struct.SetUint16(0, 15)
	l, err := capnp.NewFloat64List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Float64List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) F32vec() (capnp.Float32List, error) {
	if s.Struct.Uint16(0) != 16 {
		panic("Which() != f32vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.Float32List{List: p.List()}, err
}

func (s Z) HasF32vec() bool {
	if s.Struct.Uint16(0) != 16 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetF32vec(v capnp.Float32List) error {
	s.Struct.SetUint16(0, 16)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewF32vec sets the f32vec field to a newly
// allocated capnp.Float32List, preferring placement in s's segment.
func (s Z) NewF32vec(n int32) (capnp.Float32List, error) {
	s.Struct.SetUint16(0, 16)
	l, err := capnp.NewFloat32List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Float32List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) I64vec() (capnp.Int64List, error) {
	if s.Struct.Uint16(0) != 17 {
		panic("Which() != i64vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.Int64List{List: p.List()}, err
}

func (s Z) HasI64vec() bool {
	if s.Struct.Uint16(0) != 17 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetI64vec(v capnp.Int64List) error {
	s.Struct.SetUint16(0, 17)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewI64vec sets the i64vec field to a newly
// allocated capnp.Int64List, preferring placement in s's segment.
func (s Z) NewI64vec(n int32) (capnp.Int64List, error) {
	s.Struct.SetUint16(0, 17)
	l, err := capnp.NewInt64List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Int64List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) I32vec() (capnp.Int32List, error) {
	if s.Struct.Uint16(0) != 18 {
		panic("Which() != i32vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.Int32List{List: p.List()}, err
}

func (s Z) HasI32vec() bool {
	if s.Struct.Uint16(0) != 18 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetI32vec(v capnp.Int32List) error {
	s.Struct.SetUint16(0, 18)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewI32vec sets the i32vec field to a newly
// allocated capnp.Int32List, preferring placement in s's segment.
func (s Z) NewI32vec(n int32) (capnp.Int32List, error) {
	s.Struct.SetUint16(0, 18)
	l, err := capnp.NewInt32List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Int32List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) I16vec() (capnp.Int16List, error) {
	if s.Struct.Uint16(0) != 19 {
		panic("Which() != i16vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.Int16List{List: p.List()}, err
}

func (s Z) HasI16vec() bool {
	if s.Struct.Uint16(0) != 19 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetI16vec(v capnp.Int16List) error {
	s.Struct.SetUint16(0, 19)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewI16vec sets the i16vec field to a newly
// allocated capnp.Int16List, preferring placement in s's segment.
func (s Z) NewI16vec(n int32) (capnp.Int16List, error) {
	s.Struct.SetUint16(0, 19)
	l, err := capnp.NewInt16List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Int16List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) I8vec() (capnp.Int8List, error) {
	if s.Struct.Uint16(0) != 20 {
		panic("Which() != i8vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.Int8List{List: p.List()}, err
}

func (s Z) HasI8vec() bool {
	if s.Struct.Uint16(0) != 20 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetI8vec(v capnp.Int8List) error {
	s.Struct.SetUint16(0, 20)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewI8vec sets the i8vec field to a newly
// allocated capnp.Int8List, preferring placement in s's segment.
func (s Z) NewI8vec(n int32) (capnp.Int8List, error) {
	s.Struct.SetUint16(0, 20)
	l, err := capnp.NewInt8List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Int8List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) U64vec() (capnp.UInt64List, error) {
	if s.Struct.Uint16(0) != 21 {
		panic("Which() != u64vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.UInt64List{List: p.List()}, err
}

func (s Z) HasU64vec() bool {
	if s.Struct.Uint16(0) != 21 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetU64vec(v capnp.UInt64List) error {
	s.Struct.SetUint16(0, 21)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewU64vec sets the u64vec field to a newly
// allocated capnp.UInt64List, preferring placement in s's segment.
func (s Z) NewU64vec(n int32) (capnp.UInt64List, error) {
	s.Struct.SetUint16(0, 21)
	l, err := capnp.NewUInt64List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.UInt64List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) U32vec() (capnp.UInt32List, error) {
	if s.Struct.Uint16(0) != 22 {
		panic("Which() != u32vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.UInt32List{List: p.List()}, err
}

func (s Z) HasU32vec() bool {
	if s.Struct.Uint16(0) != 22 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetU32vec(v capnp.UInt32List) error {
	s.Struct.SetUint16(0, 22)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewU32vec sets the u32vec field to a newly
// allocated capnp.UInt32List, preferring placement in s's segment.
func (s Z) NewU32vec(n int32) (capnp.UInt32List, error) {
	s.Struct.SetUint16(0, 22)
	l, err := capnp.NewUInt32List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.UInt32List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) U16vec() (capnp.UInt16List, error) {
	if s.Struct.Uint16(0) != 23 {
		panic("Which() != u16vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.UInt16List{List: p.List()}, err
}

func (s Z) HasU16vec() bool {
	if s.Struct.Uint16(0) != 23 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetU16vec(v capnp.UInt16List) error {
	s.Struct.SetUint16(0, 23)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewU16vec sets the u16vec field to a newly
// allocated capnp.UInt16List, preferring placement in s's segment.
func (s Z) NewU16vec(n int32) (capnp.UInt16List, error) {
	s.Struct.SetUint16(0, 23)
	l, err := capnp.NewUInt16List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.UInt16List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) U8vec() (capnp.UInt8List, error) {
	if s.Struct.Uint16(0) != 24 {
		panic("Which() != u8vec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.UInt8List{List: p.List()}, err
}

func (s Z) HasU8vec() bool {
	if s.Struct.Uint16(0) != 24 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetU8vec(v capnp.UInt8List) error {
	s.Struct.SetUint16(0, 24)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewU8vec sets the u8vec field to a newly
// allocated capnp.UInt8List, preferring placement in s's segment.
func (s Z) NewU8vec(n int32) (capnp.UInt8List, error) {
	s.Struct.SetUint16(0, 24)
	l, err := capnp.NewUInt8List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.UInt8List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Boolvec() (capnp.BitList, error) {
	if s.Struct.Uint16(0) != 39 {
		panic("Which() != boolvec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.BitList{List: p.List()}, err
}

func (s Z) HasBoolvec() bool {
	if s.Struct.Uint16(0) != 39 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetBoolvec(v capnp.BitList) error {
	s.Struct.SetUint16(0, 39)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewBoolvec sets the boolvec field to a newly
// allocated capnp.BitList, preferring placement in s's segment.
func (s Z) NewBoolvec(n int32) (capnp.BitList, error) {
	s.Struct.SetUint16(0, 39)
	l, err := capnp.NewBitList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.BitList{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Datavec() (capnp.DataList, error) {
	if s.Struct.Uint16(0) != 40 {
		panic("Which() != datavec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.DataList{List: p.List()}, err
}

func (s Z) HasDatavec() bool {
	if s.Struct.Uint16(0) != 40 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetDatavec(v capnp.DataList) error {
	s.Struct.SetUint16(0, 40)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewDatavec sets the datavec field to a newly
// allocated capnp.DataList, preferring placement in s's segment.
func (s Z) NewDatavec(n int32) (capnp.DataList, error) {
	s.Struct.SetUint16(0, 40)
	l, err := capnp.NewDataList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.DataList{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Textvec() (capnp.TextList, error) {
	if s.Struct.Uint16(0) != 41 {
		panic("Which() != textvec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.TextList{List: p.List()}, err
}

func (s Z) HasTextvec() bool {
	if s.Struct.Uint16(0) != 41 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetTextvec(v capnp.TextList) error {
	s.Struct.SetUint16(0, 41)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewTextvec sets the textvec field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Z) NewTextvec(n int32) (capnp.TextList, error) {
	s.Struct.SetUint16(0, 41)
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Zvec() (Z_List, error) {
	if s.Struct.Uint16(0) != 25 {
		panic("Which() != zvec")
	}
	p, err := s.Struct.Ptr(0)
	return Z_List{List: p.List()}, err
}

func (s Z) HasZvec() bool {
	if s.Struct.Uint16(0) != 25 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZvec(v Z_List) error {
	s.Struct.SetUint16(0, 25)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewZvec sets the zvec field to a newly
// allocated Z_List, preferring placement in s's segment.
func (s Z) NewZvec(n int32) (Z_List, error) {
	s.Struct.SetUint16(0, 25)
	l, err := NewZ_List(s.Struct.Segment(), n)
	if err != nil {
		return Z_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Zvecvec() (capnp.PointerList, error) {
	if s.Struct.Uint16(0) != 26 {
		panic("Which() != zvecvec")
	}
	p, err := s.Struct.Ptr(0)
	return capnp.PointerList{List: p.List()}, err
}

func (s Z) HasZvecvec() bool {
	if s.Struct.Uint16(0) != 26 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZvecvec(v capnp.PointerList) error {
	s.Struct.SetUint16(0, 26)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewZvecvec sets the zvecvec field to a newly
// allocated capnp.PointerList, preferring placement in s's segment.
func (s Z) NewZvecvec(n int32) (capnp.PointerList, error) {
	s.Struct.SetUint16(0, 26)
	l, err := capnp.NewPointerList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.PointerList{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Zdate() (Zdate, error) {
	if s.Struct.Uint16(0) != 27 {
		panic("Which() != zdate")
	}
	p, err := s.Struct.Ptr(0)
	return Zdate{Struct: p.Struct()}, err
}

func (s Z) HasZdate() bool {
	if s.Struct.Uint16(0) != 27 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZdate(v Zdate) error {
	s.Struct.SetUint16(0, 27)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewZdate sets the zdate field to a newly
// allocated Zdate struct, preferring placement in s's segment.
func (s Z) NewZdate() (Zdate, error) {
	s.Struct.SetUint16(0, 27)
	ss, err := NewZdate(s.Struct.Segment())
	if err != nil {
		return Zdate{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) Zdata() (Zdata, error) {
	if s.Struct.Uint16(0) != 28 {
		panic("Which() != zdata")
	}
	p, err := s.Struct.Ptr(0)
	return Zdata{Struct: p.Struct()}, err
}

func (s Z) HasZdata() bool {
	if s.Struct.Uint16(0) != 28 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZdata(v Zdata) error {
	s.Struct.SetUint16(0, 28)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewZdata sets the zdata field to a newly
// allocated Zdata struct, preferring placement in s's segment.
func (s Z) NewZdata() (Zdata, error) {
	s.Struct.SetUint16(0, 28)
	ss, err := NewZdata(s.Struct.Segment())
	if err != nil {
		return Zdata{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) Aircraftvec() (Aircraft_List, error) {
	if s.Struct.Uint16(0) != 29 {
		panic("Which() != aircraftvec")
	}
	p, err := s.Struct.Ptr(0)
	return Aircraft_List{List: p.List()}, err
}

func (s Z) HasAircraftvec() bool {
	if s.Struct.Uint16(0) != 29 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetAircraftvec(v Aircraft_List) error {
	s.Struct.SetUint16(0, 29)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewAircraftvec sets the aircraftvec field to a newly
// allocated Aircraft_List, preferring placement in s's segment.
func (s Z) NewAircraftvec(n int32) (Aircraft_List, error) {
	s.Struct.SetUint16(0, 29)
	l, err := NewAircraft_List(s.Struct.Segment(), n)
	if err != nil {
		return Aircraft_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Aircraft() (Aircraft, error) {
	if s.Struct.Uint16(0) != 30 {
		panic("Which() != aircraft")
	}
	p, err := s.Struct.Ptr(0)
	return Aircraft{Struct: p.Struct()}, err
}

func (s Z) HasAircraft() bool {
	if s.Struct.Uint16(0) != 30 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetAircraft(v Aircraft) error {
	s.Struct.SetUint16(0, 30)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAircraft sets the aircraft field to a newly
// allocated Aircraft struct, preferring placement in s's segment.
func (s Z) NewAircraft() (Aircraft, error) {
	s.Struct.SetUint16(0, 30)
	ss, err := NewAircraft(s.Struct.Segment())
	if err != nil {
		return Aircraft{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) Regression() (Regression, error) {
	if s.Struct.Uint16(0) != 31 {
		panic("Which() != regression")
	}
	p, err := s.Struct.Ptr(0)
	return Regression{Struct: p.Struct()}, err
}

func (s Z) HasRegression() bool {
	if s.Struct.Uint16(0) != 31 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetRegression(v Regression) error {
	s.Struct.SetUint16(0, 31)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewRegression sets the regression field to a newly
// allocated Regression struct, preferring placement in s's segment.
func (s Z) NewRegression() (Regression, error) {
	s.Struct.SetUint16(0, 31)
	ss, err := NewRegression(s.Struct.Segment())
	if err != nil {
		return Regression{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) Planebase() (PlaneBase, error) {
	if s.Struct.Uint16(0) != 32 {
		panic("Which() != planebase")
	}
	p, err := s.Struct.Ptr(0)
	return PlaneBase{Struct: p.Struct()}, err
}

func (s Z) HasPlanebase() bool {
	if s.Struct.Uint16(0) != 32 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetPlanebase(v PlaneBase) error {
	s.Struct.SetUint16(0, 32)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewPlanebase sets the planebase field to a newly
// allocated PlaneBase struct, preferring placement in s's segment.
func (s Z) NewPlanebase() (PlaneBase, error) {
	s.Struct.SetUint16(0, 32)
	ss, err := NewPlaneBase(s.Struct.Segment())
	if err != nil {
		return PlaneBase{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) Airport() Airport {
	if s.Struct.Uint16(0) != 33 {
		panic("Which() != airport")
	}
	return Airport(s.Struct.Uint16(8))
}

func (s Z) SetAirport(v Airport) {
	s.Struct.SetUint16(0, 33)
	s.Struct.SetUint16(8, uint16(v))
}

func (s Z) B737() (B737, error) {
	if s.Struct.Uint16(0) != 34 {
		panic("Which() != b737")
	}
	p, err := s.Struct.Ptr(0)
	return B737{Struct: p.Struct()}, err
}

func (s Z) HasB737() bool {
	if s.Struct.Uint16(0) != 34 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetB737(v B737) error {
	s.Struct.SetUint16(0, 34)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewB737 sets the b737 field to a newly
// allocated B737 struct, preferring placement in s's segment.
func (s Z) NewB737() (B737, error) {
	s.Struct.SetUint16(0, 34)
	ss, err := NewB737(s.Struct.Segment())
	if err != nil {
		return B737{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) A320() (A320, error) {
	if s.Struct.Uint16(0) != 35 {
		panic("Which() != a320")
	}
	p, err := s.Struct.Ptr(0)
	return A320{Struct: p.Struct()}, err
}

func (s Z) HasA320() bool {
	if s.Struct.Uint16(0) != 35 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetA320(v A320) error {
	s.Struct.SetUint16(0, 35)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewA320 sets the a320 field to a newly
// allocated A320 struct, preferring placement in s's segment.
func (s Z) NewA320() (A320, error) {
	s.Struct.SetUint16(0, 35)
	ss, err := NewA320(s.Struct.Segment())
	if err != nil {
		return A320{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) F16() (F16, error) {
	if s.Struct.Uint16(0) != 36 {
		panic("Which() != f16")
	}
	p, err := s.Struct.Ptr(0)
	return F16{Struct: p.Struct()}, err
}

func (s Z) HasF16() bool {
	if s.Struct.Uint16(0) != 36 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetF16(v F16) error {
	s.Struct.SetUint16(0, 36)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewF16 sets the f16 field to a newly
// allocated F16 struct, preferring placement in s's segment.
func (s Z) NewF16() (F16, error) {
	s.Struct.SetUint16(0, 36)
	ss, err := NewF16(s.Struct.Segment())
	if err != nil {
		return F16{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s Z) Zdatevec() (Zdate_List, error) {
	if s.Struct.Uint16(0) != 37 {
		panic("Which() != zdatevec")
	}
	p, err := s.Struct.Ptr(0)
	return Zdate_List{List: p.List()}, err
}

func (s Z) HasZdatevec() bool {
	if s.Struct.Uint16(0) != 37 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZdatevec(v Zdate_List) error {
	s.Struct.SetUint16(0, 37)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewZdatevec sets the zdatevec field to a newly
// allocated Zdate_List, preferring placement in s's segment.
func (s Z) NewZdatevec(n int32) (Zdate_List, error) {
	s.Struct.SetUint16(0, 37)
	l, err := NewZdate_List(s.Struct.Segment(), n)
	if err != nil {
		return Zdate_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Zdatavec() (Zdata_List, error) {
	if s.Struct.Uint16(0) != 38 {
		panic("Which() != zdatavec")
	}
	p, err := s.Struct.Ptr(0)
	return Zdata_List{List: p.List()}, err
}

func (s Z) HasZdatavec() bool {
	if s.Struct.Uint16(0) != 38 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetZdatavec(v Zdata_List) error {
	s.Struct.SetUint16(0, 38)
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewZdatavec sets the zdatavec field to a newly
// allocated Zdata_List, preferring placement in s's segment.
func (s Z) NewZdatavec(n int32) (Zdata_List, error) {
	s.Struct.SetUint16(0, 38)
	l, err := NewZdata_List(s.Struct.Segment(), n)
	if err != nil {
		return Zdata_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

func (s Z) Grp() Z_grp { return Z_grp(s) }

func (s Z) SetGrp() {
	s.Struct.SetUint16(0, 42)
}

func (s Z_grp) First() uint64 {
	return s.Struct.Uint64(8)
}

func (s Z_grp) SetFirst(v uint64) {
	s.Struct.SetUint64(8, v)
}

func (s Z_grp) Second() uint64 {
	return s.Struct.Uint64(16)
}

func (s Z_grp) SetSecond(v uint64) {
	s.Struct.SetUint64(16, v)
}

func (s Z) Echo() Echo {
	if s.Struct.Uint16(0) != 43 {
		panic("Which() != echo")
	}
	p, _ := s.Struct.Ptr(0)
	return Echo{Client: p.Interface().Client()}
}

func (s Z) HasEcho() bool {
	if s.Struct.Uint16(0) != 43 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetEcho(v Echo) error {
	s.Struct.SetUint16(0, 43)
	if v.Client == nil {
		return s.Struct.SetPtr(0, capnp.Ptr{})
	}
	seg := s.Segment()
	in := capnp.NewInterface(seg, seg.Message().AddCap(v.Client))
	return s.Struct.SetPtr(0, in.ToPtr())
}

func (s Z) EchoBases() (EchoBases, error) {
	if s.Struct.Uint16(0) != 44 {
		panic("Which() != echoBases")
	}
	p, err := s.Struct.Ptr(0)
	return EchoBases{Struct: p.Struct()}, err
}

func (s Z) HasEchoBases() bool {
	if s.Struct.Uint16(0) != 44 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Z) SetEchoBases(v EchoBases) error {
	s.Struct.SetUint16(0, 44)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewEchoBases sets the echoBases field to a newly
// allocated EchoBases struct, preferring placement in s's segment.
func (s Z) NewEchoBases() (EchoBases, error) {
	s.Struct.SetUint16(0, 44)
	ss, err := NewEchoBases(s.Struct.Segment())
	if err != nil {
		return EchoBases{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Z_List is a list of Z.
type Z_List struct{ capnp.List }

// NewZ creates a new list of Z.
func NewZ_List(s *capnp.Segment, sz int32) (Z_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 1}, sz)
	return Z_List{l}, err
}

func (s Z_List) At(i int) Z { return Z{s.List.Struct(i)} }

func (s Z_List) Set(i int, v Z) error { return s.List.SetStruct(i, v.Struct) }

func (s Z_List) String() string {
	str, _ := text.MarshalList(0xea26e9973bd6a0d9, s.List)
	return str
}

// Z_Promise is a wrapper for a Z promised by a client call.
type Z_Promise struct{ *capnp.Pipeline }

func (p Z_Promise) Struct() (Z, error) {
	s, err := p.Pipeline.Struct()
	return Z{s}, err
}

func (p Z_Promise) Zz() Z_Promise {
	return Z_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) Zdate() Zdate_Promise {
	return Zdate_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) Zdata() Zdata_Promise {
	return Zdata_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) Aircraft() Aircraft_Promise {
	return Aircraft_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) Regression() Regression_Promise {
	return Regression_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) Planebase() PlaneBase_Promise {
	return PlaneBase_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) B737() B737_Promise {
	return B737_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) A320() A320_Promise {
	return A320_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) F16() F16_Promise {
	return F16_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p Z_Promise) Grp() Z_grp_Promise { return Z_grp_Promise{p.Pipeline} }

// Z_grp_Promise is a wrapper for a Z_grp promised by a client call.
type Z_grp_Promise struct{ *capnp.Pipeline }

func (p Z_grp_Promise) Struct() (Z_grp, error) {
	s, err := p.Pipeline.Struct()
	return Z_grp{s}, err
}

func (p Z_Promise) Echo() Echo {
	return Echo{Client: p.Pipeline.GetPipeline(0).Client()}
}

func (p Z_Promise) EchoBases() EchoBases_Promise {
	return EchoBases_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Counter struct{ capnp.Struct }

// Counter_TypeID is the unique identifier for the type Counter.
const Counter_TypeID = 0x8748bc095e10cb5d

func NewCounter(s *capnp.Segment) (Counter, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return Counter{st}, err
}

func NewRootCounter(s *capnp.Segment) (Counter, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return Counter{st}, err
}

func ReadRootCounter(msg *capnp.Message) (Counter, error) {
	root, err := msg.RootPtr()
	return Counter{root.Struct()}, err
}

func (s Counter) String() string {
	str, _ := text.Marshal(0x8748bc095e10cb5d, s.Struct)
	return str
}

func (s Counter) Size() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s Counter) SetSize(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s Counter) Words() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Counter) HasWords() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Counter) WordsBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Counter) SetWords(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Counter) Wordlist() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s Counter) HasWordlist() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Counter) SetWordlist(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewWordlist sets the wordlist field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Counter) NewWordlist(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s Counter) Bitlist() (capnp.BitList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.BitList{List: p.List()}, err
}

func (s Counter) HasBitlist() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Counter) SetBitlist(v capnp.BitList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewBitlist sets the bitlist field to a newly
// allocated capnp.BitList, preferring placement in s's segment.
func (s Counter) NewBitlist(n int32) (capnp.BitList, error) {
	l, err := capnp.NewBitList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.BitList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

// Counter_List is a list of Counter.
type Counter_List struct{ capnp.List }

// NewCounter creates a new list of Counter.
func NewCounter_List(s *capnp.Segment, sz int32) (Counter_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return Counter_List{l}, err
}

func (s Counter_List) At(i int) Counter { return Counter{s.List.Struct(i)} }

func (s Counter_List) Set(i int, v Counter) error { return s.List.SetStruct(i, v.Struct) }

func (s Counter_List) String() string {
	str, _ := text.MarshalList(0x8748bc095e10cb5d, s.List)
	return str
}

// Counter_Promise is a wrapper for a Counter promised by a client call.
type Counter_Promise struct{ *capnp.Pipeline }

func (p Counter_Promise) Struct() (Counter, error) {
	s, err := p.Pipeline.Struct()
	return Counter{s}, err
}

type Bag struct{ capnp.Struct }

// Bag_TypeID is the unique identifier for the type Bag.
const Bag_TypeID = 0xd636fba4f188dabe

func NewBag(s *capnp.Segment) (Bag, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Bag{st}, err
}

func NewRootBag(s *capnp.Segment) (Bag, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Bag{st}, err
}

func ReadRootBag(msg *capnp.Message) (Bag, error) {
	root, err := msg.RootPtr()
	return Bag{root.Struct()}, err
}

func (s Bag) String() string {
	str, _ := text.Marshal(0xd636fba4f188dabe, s.Struct)
	return str
}

func (s Bag) Counter() (Counter, error) {
	p, err := s.Struct.Ptr(0)
	return Counter{Struct: p.Struct()}, err
}

func (s Bag) HasCounter() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Bag) SetCounter(v Counter) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewCounter sets the counter field to a newly
// allocated Counter struct, preferring placement in s's segment.
func (s Bag) NewCounter() (Counter, error) {
	ss, err := NewCounter(s.Struct.Segment())
	if err != nil {
		return Counter{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Bag_List is a list of Bag.
type Bag_List struct{ capnp.List }

// NewBag creates a new list of Bag.
func NewBag_List(s *capnp.Segment, sz int32) (Bag_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Bag_List{l}, err
}

func (s Bag_List) At(i int) Bag { return Bag{s.List.Struct(i)} }

func (s Bag_List) Set(i int, v Bag) error { return s.List.SetStruct(i, v.Struct) }

func (s Bag_List) String() string {
	str, _ := text.MarshalList(0xd636fba4f188dabe, s.List)
	return str
}

// Bag_Promise is a wrapper for a Bag promised by a client call.
type Bag_Promise struct{ *capnp.Pipeline }

func (p Bag_Promise) Struct() (Bag, error) {
	s, err := p.Pipeline.Struct()
	return Bag{s}, err
}

func (p Bag_Promise) Counter() Counter_Promise {
	return Counter_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Zserver struct{ capnp.Struct }

// Zserver_TypeID is the unique identifier for the type Zserver.
const Zserver_TypeID = 0xcc4411e60ba9c498

func NewZserver(s *capnp.Segment) (Zserver, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Zserver{st}, err
}

func NewRootZserver(s *capnp.Segment) (Zserver, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Zserver{st}, err
}

func ReadRootZserver(msg *capnp.Message) (Zserver, error) {
	root, err := msg.RootPtr()
	return Zserver{root.Struct()}, err
}

func (s Zserver) String() string {
	str, _ := text.Marshal(0xcc4411e60ba9c498, s.Struct)
	return str
}

func (s Zserver) Waitingjobs() (Zjob_List, error) {
	p, err := s.Struct.Ptr(0)
	return Zjob_List{List: p.List()}, err
}

func (s Zserver) HasWaitingjobs() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Zserver) SetWaitingjobs(v Zjob_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewWaitingjobs sets the waitingjobs field to a newly
// allocated Zjob_List, preferring placement in s's segment.
func (s Zserver) NewWaitingjobs(n int32) (Zjob_List, error) {
	l, err := NewZjob_List(s.Struct.Segment(), n)
	if err != nil {
		return Zjob_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// Zserver_List is a list of Zserver.
type Zserver_List struct{ capnp.List }

// NewZserver creates a new list of Zserver.
func NewZserver_List(s *capnp.Segment, sz int32) (Zserver_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Zserver_List{l}, err
}

func (s Zserver_List) At(i int) Zserver { return Zserver{s.List.Struct(i)} }

func (s Zserver_List) Set(i int, v Zserver) error { return s.List.SetStruct(i, v.Struct) }

func (s Zserver_List) String() string {
	str, _ := text.MarshalList(0xcc4411e60ba9c498, s.List)
	return str
}

// Zserver_Promise is a wrapper for a Zserver promised by a client call.
type Zserver_Promise struct{ *capnp.Pipeline }

func (p Zserver_Promise) Struct() (Zserver, error) {
	s, err := p.Pipeline.Struct()
	return Zserver{s}, err
}

type Zjob struct{ capnp.Struct }

// Zjob_TypeID is the unique identifier for the type Zjob.
const Zjob_TypeID = 0xddd1416669fb7613

func NewZjob(s *capnp.Segment) (Zjob, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Zjob{st}, err
}

func NewRootZjob(s *capnp.Segment) (Zjob, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Zjob{st}, err
}

func ReadRootZjob(msg *capnp.Message) (Zjob, error) {
	root, err := msg.RootPtr()
	return Zjob{root.Struct()}, err
}

func (s Zjob) String() string {
	str, _ := text.Marshal(0xddd1416669fb7613, s.Struct)
	return str
}

func (s Zjob) Cmd() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Zjob) HasCmd() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Zjob) CmdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Zjob) SetCmd(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Zjob) Args() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s Zjob) HasArgs() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Zjob) SetArgs(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewArgs sets the args field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Zjob) NewArgs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

// Zjob_List is a list of Zjob.
type Zjob_List struct{ capnp.List }

// NewZjob creates a new list of Zjob.
func NewZjob_List(s *capnp.Segment, sz int32) (Zjob_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return Zjob_List{l}, err
}

func (s Zjob_List) At(i int) Zjob { return Zjob{s.List.Struct(i)} }

func (s Zjob_List) Set(i int, v Zjob) error { return s.List.SetStruct(i, v.Struct) }

func (s Zjob_List) String() string {
	str, _ := text.MarshalList(0xddd1416669fb7613, s.List)
	return str
}

// Zjob_Promise is a wrapper for a Zjob promised by a client call.
type Zjob_Promise struct{ *capnp.Pipeline }

func (p Zjob_Promise) Struct() (Zjob, error) {
	s, err := p.Pipeline.Struct()
	return Zjob{s}, err
}

type VerEmpty struct{ capnp.Struct }

// VerEmpty_TypeID is the unique identifier for the type VerEmpty.
const VerEmpty_TypeID = 0x93c99951eacc72ff

func NewVerEmpty(s *capnp.Segment) (VerEmpty, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return VerEmpty{st}, err
}

func NewRootVerEmpty(s *capnp.Segment) (VerEmpty, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return VerEmpty{st}, err
}

func ReadRootVerEmpty(msg *capnp.Message) (VerEmpty, error) {
	root, err := msg.RootPtr()
	return VerEmpty{root.Struct()}, err
}

func (s VerEmpty) String() string {
	str, _ := text.Marshal(0x93c99951eacc72ff, s.Struct)
	return str
}

// VerEmpty_List is a list of VerEmpty.
type VerEmpty_List struct{ capnp.List }

// NewVerEmpty creates a new list of VerEmpty.
func NewVerEmpty_List(s *capnp.Segment, sz int32) (VerEmpty_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return VerEmpty_List{l}, err
}

func (s VerEmpty_List) At(i int) VerEmpty { return VerEmpty{s.List.Struct(i)} }

func (s VerEmpty_List) Set(i int, v VerEmpty) error { return s.List.SetStruct(i, v.Struct) }

func (s VerEmpty_List) String() string {
	str, _ := text.MarshalList(0x93c99951eacc72ff, s.List)
	return str
}

// VerEmpty_Promise is a wrapper for a VerEmpty promised by a client call.
type VerEmpty_Promise struct{ *capnp.Pipeline }

func (p VerEmpty_Promise) Struct() (VerEmpty, error) {
	s, err := p.Pipeline.Struct()
	return VerEmpty{s}, err
}

type VerOneData struct{ capnp.Struct }

// VerOneData_TypeID is the unique identifier for the type VerOneData.
const VerOneData_TypeID = 0xfca3742893be4cde

func NewVerOneData(s *capnp.Segment) (VerOneData, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return VerOneData{st}, err
}

func NewRootVerOneData(s *capnp.Segment) (VerOneData, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return VerOneData{st}, err
}

func ReadRootVerOneData(msg *capnp.Message) (VerOneData, error) {
	root, err := msg.RootPtr()
	return VerOneData{root.Struct()}, err
}

func (s VerOneData) String() string {
	str, _ := text.Marshal(0xfca3742893be4cde, s.Struct)
	return str
}

func (s VerOneData) Val() int16 {
	return int16(s.Struct.Uint16(0))
}

func (s VerOneData) SetVal(v int16) {
	s.Struct.SetUint16(0, uint16(v))
}

// VerOneData_List is a list of VerOneData.
type VerOneData_List struct{ capnp.List }

// NewVerOneData creates a new list of VerOneData.
func NewVerOneData_List(s *capnp.Segment, sz int32) (VerOneData_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return VerOneData_List{l}, err
}

func (s VerOneData_List) At(i int) VerOneData { return VerOneData{s.List.Struct(i)} }

func (s VerOneData_List) Set(i int, v VerOneData) error { return s.List.SetStruct(i, v.Struct) }

func (s VerOneData_List) String() string {
	str, _ := text.MarshalList(0xfca3742893be4cde, s.List)
	return str
}

// VerOneData_Promise is a wrapper for a VerOneData promised by a client call.
type VerOneData_Promise struct{ *capnp.Pipeline }

func (p VerOneData_Promise) Struct() (VerOneData, error) {
	s, err := p.Pipeline.Struct()
	return VerOneData{s}, err
}

type VerTwoData struct{ capnp.Struct }

// VerTwoData_TypeID is the unique identifier for the type VerTwoData.
const VerTwoData_TypeID = 0xf705dc45c94766fd

func NewVerTwoData(s *capnp.Segment) (VerTwoData, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 0})
	return VerTwoData{st}, err
}

func NewRootVerTwoData(s *capnp.Segment) (VerTwoData, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 0})
	return VerTwoData{st}, err
}

func ReadRootVerTwoData(msg *capnp.Message) (VerTwoData, error) {
	root, err := msg.RootPtr()
	return VerTwoData{root.Struct()}, err
}

func (s VerTwoData) String() string {
	str, _ := text.Marshal(0xf705dc45c94766fd, s.Struct)
	return str
}

func (s VerTwoData) Val() int16 {
	return int16(s.Struct.Uint16(0))
}

func (s VerTwoData) SetVal(v int16) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s VerTwoData) Duo() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s VerTwoData) SetDuo(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

// VerTwoData_List is a list of VerTwoData.
type VerTwoData_List struct{ capnp.List }

// NewVerTwoData creates a new list of VerTwoData.
func NewVerTwoData_List(s *capnp.Segment, sz int32) (VerTwoData_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 0}, sz)
	return VerTwoData_List{l}, err
}

func (s VerTwoData_List) At(i int) VerTwoData { return VerTwoData{s.List.Struct(i)} }

func (s VerTwoData_List) Set(i int, v VerTwoData) error { return s.List.SetStruct(i, v.Struct) }

func (s VerTwoData_List) String() string {
	str, _ := text.MarshalList(0xf705dc45c94766fd, s.List)
	return str
}

// VerTwoData_Promise is a wrapper for a VerTwoData promised by a client call.
type VerTwoData_Promise struct{ *capnp.Pipeline }

func (p VerTwoData_Promise) Struct() (VerTwoData, error) {
	s, err := p.Pipeline.Struct()
	return VerTwoData{s}, err
}

type VerOnePtr struct{ capnp.Struct }

// VerOnePtr_TypeID is the unique identifier for the type VerOnePtr.
const VerOnePtr_TypeID = 0x94bf7df83408218d

func NewVerOnePtr(s *capnp.Segment) (VerOnePtr, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return VerOnePtr{st}, err
}

func NewRootVerOnePtr(s *capnp.Segment) (VerOnePtr, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return VerOnePtr{st}, err
}

func ReadRootVerOnePtr(msg *capnp.Message) (VerOnePtr, error) {
	root, err := msg.RootPtr()
	return VerOnePtr{root.Struct()}, err
}

func (s VerOnePtr) String() string {
	str, _ := text.Marshal(0x94bf7df83408218d, s.Struct)
	return str
}

func (s VerOnePtr) Ptr() (VerOneData, error) {
	p, err := s.Struct.Ptr(0)
	return VerOneData{Struct: p.Struct()}, err
}

func (s VerOnePtr) HasPtr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s VerOnePtr) SetPtr(v VerOneData) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewPtr sets the ptr field to a newly
// allocated VerOneData struct, preferring placement in s's segment.
func (s VerOnePtr) NewPtr() (VerOneData, error) {
	ss, err := NewVerOneData(s.Struct.Segment())
	if err != nil {
		return VerOneData{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// VerOnePtr_List is a list of VerOnePtr.
type VerOnePtr_List struct{ capnp.List }

// NewVerOnePtr creates a new list of VerOnePtr.
func NewVerOnePtr_List(s *capnp.Segment, sz int32) (VerOnePtr_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return VerOnePtr_List{l}, err
}

func (s VerOnePtr_List) At(i int) VerOnePtr { return VerOnePtr{s.List.Struct(i)} }

func (s VerOnePtr_List) Set(i int, v VerOnePtr) error { return s.List.SetStruct(i, v.Struct) }

func (s VerOnePtr_List) String() string {
	str, _ := text.MarshalList(0x94bf7df83408218d, s.List)
	return str
}

// VerOnePtr_Promise is a wrapper for a VerOnePtr promised by a client call.
type VerOnePtr_Promise struct{ *capnp.Pipeline }

func (p VerOnePtr_Promise) Struct() (VerOnePtr, error) {
	s, err := p.Pipeline.Struct()
	return VerOnePtr{s}, err
}

func (p VerOnePtr_Promise) Ptr() VerOneData_Promise {
	return VerOneData_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type VerTwoPtr struct{ capnp.Struct }

// VerTwoPtr_TypeID is the unique identifier for the type VerTwoPtr.
const VerTwoPtr_TypeID = 0xc95babe3bd394d2d

func NewVerTwoPtr(s *capnp.Segment) (VerTwoPtr, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return VerTwoPtr{st}, err
}

func NewRootVerTwoPtr(s *capnp.Segment) (VerTwoPtr, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return VerTwoPtr{st}, err
}

func ReadRootVerTwoPtr(msg *capnp.Message) (VerTwoPtr, error) {
	root, err := msg.RootPtr()
	return VerTwoPtr{root.Struct()}, err
}

func (s VerTwoPtr) String() string {
	str, _ := text.Marshal(0xc95babe3bd394d2d, s.Struct)
	return str
}

func (s VerTwoPtr) Ptr1() (VerOneData, error) {
	p, err := s.Struct.Ptr(0)
	return VerOneData{Struct: p.Struct()}, err
}

func (s VerTwoPtr) HasPtr1() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s VerTwoPtr) SetPtr1(v VerOneData) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewPtr1 sets the ptr1 field to a newly
// allocated VerOneData struct, preferring placement in s's segment.
func (s VerTwoPtr) NewPtr1() (VerOneData, error) {
	ss, err := NewVerOneData(s.Struct.Segment())
	if err != nil {
		return VerOneData{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s VerTwoPtr) Ptr2() (VerOneData, error) {
	p, err := s.Struct.Ptr(1)
	return VerOneData{Struct: p.Struct()}, err
}

func (s VerTwoPtr) HasPtr2() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s VerTwoPtr) SetPtr2(v VerOneData) error {
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewPtr2 sets the ptr2 field to a newly
// allocated VerOneData struct, preferring placement in s's segment.
func (s VerTwoPtr) NewPtr2() (VerOneData, error) {
	ss, err := NewVerOneData(s.Struct.Segment())
	if err != nil {
		return VerOneData{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

// VerTwoPtr_List is a list of VerTwoPtr.
type VerTwoPtr_List struct{ capnp.List }

// NewVerTwoPtr creates a new list of VerTwoPtr.
func NewVerTwoPtr_List(s *capnp.Segment, sz int32) (VerTwoPtr_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return VerTwoPtr_List{l}, err
}

func (s VerTwoPtr_List) At(i int) VerTwoPtr { return VerTwoPtr{s.List.Struct(i)} }

func (s VerTwoPtr_List) Set(i int, v VerTwoPtr) error { return s.List.SetStruct(i, v.Struct) }

func (s VerTwoPtr_List) String() string {
	str, _ := text.MarshalList(0xc95babe3bd394d2d, s.List)
	return str
}

// VerTwoPtr_Promise is a wrapper for a VerTwoPtr promised by a client call.
type VerTwoPtr_Promise struct{ *capnp.Pipeline }

func (p VerTwoPtr_Promise) Struct() (VerTwoPtr, error) {
	s, err := p.Pipeline.Struct()
	return VerTwoPtr{s}, err
}

func (p VerTwoPtr_Promise) Ptr1() VerOneData_Promise {
	return VerOneData_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p VerTwoPtr_Promise) Ptr2() VerOneData_Promise {
	return VerOneData_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

type VerTwoDataTwoPtr struct{ capnp.Struct }

// VerTwoDataTwoPtr_TypeID is the unique identifier for the type VerTwoDataTwoPtr.
const VerTwoDataTwoPtr_TypeID = 0xb61ee2ecff34ca73

func NewVerTwoDataTwoPtr(s *capnp.Segment) (VerTwoDataTwoPtr, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return VerTwoDataTwoPtr{st}, err
}

func NewRootVerTwoDataTwoPtr(s *capnp.Segment) (VerTwoDataTwoPtr, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return VerTwoDataTwoPtr{st}, err
}

func ReadRootVerTwoDataTwoPtr(msg *capnp.Message) (VerTwoDataTwoPtr, error) {
	root, err := msg.RootPtr()
	return VerTwoDataTwoPtr{root.Struct()}, err
}

func (s VerTwoDataTwoPtr) String() string {
	str, _ := text.Marshal(0xb61ee2ecff34ca73, s.Struct)
	return str
}

func (s VerTwoDataTwoPtr) Val() int16 {
	return int16(s.Struct.Uint16(0))
}

func (s VerTwoDataTwoPtr) SetVal(v int16) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s VerTwoDataTwoPtr) Duo() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s VerTwoDataTwoPtr) SetDuo(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

func (s VerTwoDataTwoPtr) Ptr1() (VerOneData, error) {
	p, err := s.Struct.Ptr(0)
	return VerOneData{Struct: p.Struct()}, err
}

func (s VerTwoDataTwoPtr) HasPtr1() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s VerTwoDataTwoPtr) SetPtr1(v VerOneData) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewPtr1 sets the ptr1 field to a newly
// allocated VerOneData struct, preferring placement in s's segment.
func (s VerTwoDataTwoPtr) NewPtr1() (VerOneData, error) {
	ss, err := NewVerOneData(s.Struct.Segment())
	if err != nil {
		return VerOneData{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s VerTwoDataTwoPtr) Ptr2() (VerOneData, error) {
	p, err := s.Struct.Ptr(1)
	return VerOneData{Struct: p.Struct()}, err
}

func (s VerTwoDataTwoPtr) HasPtr2() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s VerTwoDataTwoPtr) SetPtr2(v VerOneData) error {
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewPtr2 sets the ptr2 field to a newly
// allocated VerOneData struct, preferring placement in s's segment.
func (s VerTwoDataTwoPtr) NewPtr2() (VerOneData, error) {
	ss, err := NewVerOneData(s.Struct.Segment())
	if err != nil {
		return VerOneData{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

// VerTwoDataTwoPtr_List is a list of VerTwoDataTwoPtr.
type VerTwoDataTwoPtr_List struct{ capnp.List }

// NewVerTwoDataTwoPtr creates a new list of VerTwoDataTwoPtr.
func NewVerTwoDataTwoPtr_List(s *capnp.Segment, sz int32) (VerTwoDataTwoPtr_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return VerTwoDataTwoPtr_List{l}, err
}

func (s VerTwoDataTwoPtr_List) At(i int) VerTwoDataTwoPtr { return VerTwoDataTwoPtr{s.List.Struct(i)} }

func (s VerTwoDataTwoPtr_List) Set(i int, v VerTwoDataTwoPtr) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s VerTwoDataTwoPtr_List) String() string {
	str, _ := text.MarshalList(0xb61ee2ecff34ca73, s.List)
	return str
}

// VerTwoDataTwoPtr_Promise is a wrapper for a VerTwoDataTwoPtr promised by a client call.
type VerTwoDataTwoPtr_Promise struct{ *capnp.Pipeline }

func (p VerTwoDataTwoPtr_Promise) Struct() (VerTwoDataTwoPtr, error) {
	s, err := p.Pipeline.Struct()
	return VerTwoDataTwoPtr{s}, err
}

func (p VerTwoDataTwoPtr_Promise) Ptr1() VerOneData_Promise {
	return VerOneData_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p VerTwoDataTwoPtr_Promise) Ptr2() VerOneData_Promise {
	return VerOneData_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

type HoldsVerEmptyList struct{ capnp.Struct }

// HoldsVerEmptyList_TypeID is the unique identifier for the type HoldsVerEmptyList.
const HoldsVerEmptyList_TypeID = 0xde9ed43cfaa83093

func NewHoldsVerEmptyList(s *capnp.Segment) (HoldsVerEmptyList, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerEmptyList{st}, err
}

func NewRootHoldsVerEmptyList(s *capnp.Segment) (HoldsVerEmptyList, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerEmptyList{st}, err
}

func ReadRootHoldsVerEmptyList(msg *capnp.Message) (HoldsVerEmptyList, error) {
	root, err := msg.RootPtr()
	return HoldsVerEmptyList{root.Struct()}, err
}

func (s HoldsVerEmptyList) String() string {
	str, _ := text.Marshal(0xde9ed43cfaa83093, s.Struct)
	return str
}

func (s HoldsVerEmptyList) Mylist() (VerEmpty_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerEmpty_List{List: p.List()}, err
}

func (s HoldsVerEmptyList) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerEmptyList) SetMylist(v VerEmpty_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerEmpty_List, preferring placement in s's segment.
func (s HoldsVerEmptyList) NewMylist(n int32) (VerEmpty_List, error) {
	l, err := NewVerEmpty_List(s.Struct.Segment(), n)
	if err != nil {
		return VerEmpty_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerEmptyList_List is a list of HoldsVerEmptyList.
type HoldsVerEmptyList_List struct{ capnp.List }

// NewHoldsVerEmptyList creates a new list of HoldsVerEmptyList.
func NewHoldsVerEmptyList_List(s *capnp.Segment, sz int32) (HoldsVerEmptyList_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerEmptyList_List{l}, err
}

func (s HoldsVerEmptyList_List) At(i int) HoldsVerEmptyList {
	return HoldsVerEmptyList{s.List.Struct(i)}
}

func (s HoldsVerEmptyList_List) Set(i int, v HoldsVerEmptyList) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerEmptyList_List) String() string {
	str, _ := text.MarshalList(0xde9ed43cfaa83093, s.List)
	return str
}

// HoldsVerEmptyList_Promise is a wrapper for a HoldsVerEmptyList promised by a client call.
type HoldsVerEmptyList_Promise struct{ *capnp.Pipeline }

func (p HoldsVerEmptyList_Promise) Struct() (HoldsVerEmptyList, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerEmptyList{s}, err
}

type HoldsVerOneDataList struct{ capnp.Struct }

// HoldsVerOneDataList_TypeID is the unique identifier for the type HoldsVerOneDataList.
const HoldsVerOneDataList_TypeID = 0xabd055422a4d7df1

func NewHoldsVerOneDataList(s *capnp.Segment) (HoldsVerOneDataList, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerOneDataList{st}, err
}

func NewRootHoldsVerOneDataList(s *capnp.Segment) (HoldsVerOneDataList, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerOneDataList{st}, err
}

func ReadRootHoldsVerOneDataList(msg *capnp.Message) (HoldsVerOneDataList, error) {
	root, err := msg.RootPtr()
	return HoldsVerOneDataList{root.Struct()}, err
}

func (s HoldsVerOneDataList) String() string {
	str, _ := text.Marshal(0xabd055422a4d7df1, s.Struct)
	return str
}

func (s HoldsVerOneDataList) Mylist() (VerOneData_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerOneData_List{List: p.List()}, err
}

func (s HoldsVerOneDataList) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerOneDataList) SetMylist(v VerOneData_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerOneData_List, preferring placement in s's segment.
func (s HoldsVerOneDataList) NewMylist(n int32) (VerOneData_List, error) {
	l, err := NewVerOneData_List(s.Struct.Segment(), n)
	if err != nil {
		return VerOneData_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerOneDataList_List is a list of HoldsVerOneDataList.
type HoldsVerOneDataList_List struct{ capnp.List }

// NewHoldsVerOneDataList creates a new list of HoldsVerOneDataList.
func NewHoldsVerOneDataList_List(s *capnp.Segment, sz int32) (HoldsVerOneDataList_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerOneDataList_List{l}, err
}

func (s HoldsVerOneDataList_List) At(i int) HoldsVerOneDataList {
	return HoldsVerOneDataList{s.List.Struct(i)}
}

func (s HoldsVerOneDataList_List) Set(i int, v HoldsVerOneDataList) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerOneDataList_List) String() string {
	str, _ := text.MarshalList(0xabd055422a4d7df1, s.List)
	return str
}

// HoldsVerOneDataList_Promise is a wrapper for a HoldsVerOneDataList promised by a client call.
type HoldsVerOneDataList_Promise struct{ *capnp.Pipeline }

func (p HoldsVerOneDataList_Promise) Struct() (HoldsVerOneDataList, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerOneDataList{s}, err
}

type HoldsVerTwoDataList struct{ capnp.Struct }

// HoldsVerTwoDataList_TypeID is the unique identifier for the type HoldsVerTwoDataList.
const HoldsVerTwoDataList_TypeID = 0xcbdc765fd5dff7ba

func NewHoldsVerTwoDataList(s *capnp.Segment) (HoldsVerTwoDataList, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoDataList{st}, err
}

func NewRootHoldsVerTwoDataList(s *capnp.Segment) (HoldsVerTwoDataList, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoDataList{st}, err
}

func ReadRootHoldsVerTwoDataList(msg *capnp.Message) (HoldsVerTwoDataList, error) {
	root, err := msg.RootPtr()
	return HoldsVerTwoDataList{root.Struct()}, err
}

func (s HoldsVerTwoDataList) String() string {
	str, _ := text.Marshal(0xcbdc765fd5dff7ba, s.Struct)
	return str
}

func (s HoldsVerTwoDataList) Mylist() (VerTwoData_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoData_List{List: p.List()}, err
}

func (s HoldsVerTwoDataList) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerTwoDataList) SetMylist(v VerTwoData_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerTwoData_List, preferring placement in s's segment.
func (s HoldsVerTwoDataList) NewMylist(n int32) (VerTwoData_List, error) {
	l, err := NewVerTwoData_List(s.Struct.Segment(), n)
	if err != nil {
		return VerTwoData_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerTwoDataList_List is a list of HoldsVerTwoDataList.
type HoldsVerTwoDataList_List struct{ capnp.List }

// NewHoldsVerTwoDataList creates a new list of HoldsVerTwoDataList.
func NewHoldsVerTwoDataList_List(s *capnp.Segment, sz int32) (HoldsVerTwoDataList_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerTwoDataList_List{l}, err
}

func (s HoldsVerTwoDataList_List) At(i int) HoldsVerTwoDataList {
	return HoldsVerTwoDataList{s.List.Struct(i)}
}

func (s HoldsVerTwoDataList_List) Set(i int, v HoldsVerTwoDataList) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerTwoDataList_List) String() string {
	str, _ := text.MarshalList(0xcbdc765fd5dff7ba, s.List)
	return str
}

// HoldsVerTwoDataList_Promise is a wrapper for a HoldsVerTwoDataList promised by a client call.
type HoldsVerTwoDataList_Promise struct{ *capnp.Pipeline }

func (p HoldsVerTwoDataList_Promise) Struct() (HoldsVerTwoDataList, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerTwoDataList{s}, err
}

type HoldsVerOnePtrList struct{ capnp.Struct }

// HoldsVerOnePtrList_TypeID is the unique identifier for the type HoldsVerOnePtrList.
const HoldsVerOnePtrList_TypeID = 0xe508a29c83a059f8

func NewHoldsVerOnePtrList(s *capnp.Segment) (HoldsVerOnePtrList, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerOnePtrList{st}, err
}

func NewRootHoldsVerOnePtrList(s *capnp.Segment) (HoldsVerOnePtrList, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerOnePtrList{st}, err
}

func ReadRootHoldsVerOnePtrList(msg *capnp.Message) (HoldsVerOnePtrList, error) {
	root, err := msg.RootPtr()
	return HoldsVerOnePtrList{root.Struct()}, err
}

func (s HoldsVerOnePtrList) String() string {
	str, _ := text.Marshal(0xe508a29c83a059f8, s.Struct)
	return str
}

func (s HoldsVerOnePtrList) Mylist() (VerOnePtr_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerOnePtr_List{List: p.List()}, err
}

func (s HoldsVerOnePtrList) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerOnePtrList) SetMylist(v VerOnePtr_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerOnePtr_List, preferring placement in s's segment.
func (s HoldsVerOnePtrList) NewMylist(n int32) (VerOnePtr_List, error) {
	l, err := NewVerOnePtr_List(s.Struct.Segment(), n)
	if err != nil {
		return VerOnePtr_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerOnePtrList_List is a list of HoldsVerOnePtrList.
type HoldsVerOnePtrList_List struct{ capnp.List }

// NewHoldsVerOnePtrList creates a new list of HoldsVerOnePtrList.
func NewHoldsVerOnePtrList_List(s *capnp.Segment, sz int32) (HoldsVerOnePtrList_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerOnePtrList_List{l}, err
}

func (s HoldsVerOnePtrList_List) At(i int) HoldsVerOnePtrList {
	return HoldsVerOnePtrList{s.List.Struct(i)}
}

func (s HoldsVerOnePtrList_List) Set(i int, v HoldsVerOnePtrList) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerOnePtrList_List) String() string {
	str, _ := text.MarshalList(0xe508a29c83a059f8, s.List)
	return str
}

// HoldsVerOnePtrList_Promise is a wrapper for a HoldsVerOnePtrList promised by a client call.
type HoldsVerOnePtrList_Promise struct{ *capnp.Pipeline }

func (p HoldsVerOnePtrList_Promise) Struct() (HoldsVerOnePtrList, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerOnePtrList{s}, err
}

type HoldsVerTwoPtrList struct{ capnp.Struct }

// HoldsVerTwoPtrList_TypeID is the unique identifier for the type HoldsVerTwoPtrList.
const HoldsVerTwoPtrList_TypeID = 0xcf9beaca1cc180c8

func NewHoldsVerTwoPtrList(s *capnp.Segment) (HoldsVerTwoPtrList, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoPtrList{st}, err
}

func NewRootHoldsVerTwoPtrList(s *capnp.Segment) (HoldsVerTwoPtrList, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoPtrList{st}, err
}

func ReadRootHoldsVerTwoPtrList(msg *capnp.Message) (HoldsVerTwoPtrList, error) {
	root, err := msg.RootPtr()
	return HoldsVerTwoPtrList{root.Struct()}, err
}

func (s HoldsVerTwoPtrList) String() string {
	str, _ := text.Marshal(0xcf9beaca1cc180c8, s.Struct)
	return str
}

func (s HoldsVerTwoPtrList) Mylist() (VerTwoPtr_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoPtr_List{List: p.List()}, err
}

func (s HoldsVerTwoPtrList) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerTwoPtrList) SetMylist(v VerTwoPtr_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerTwoPtr_List, preferring placement in s's segment.
func (s HoldsVerTwoPtrList) NewMylist(n int32) (VerTwoPtr_List, error) {
	l, err := NewVerTwoPtr_List(s.Struct.Segment(), n)
	if err != nil {
		return VerTwoPtr_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerTwoPtrList_List is a list of HoldsVerTwoPtrList.
type HoldsVerTwoPtrList_List struct{ capnp.List }

// NewHoldsVerTwoPtrList creates a new list of HoldsVerTwoPtrList.
func NewHoldsVerTwoPtrList_List(s *capnp.Segment, sz int32) (HoldsVerTwoPtrList_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerTwoPtrList_List{l}, err
}

func (s HoldsVerTwoPtrList_List) At(i int) HoldsVerTwoPtrList {
	return HoldsVerTwoPtrList{s.List.Struct(i)}
}

func (s HoldsVerTwoPtrList_List) Set(i int, v HoldsVerTwoPtrList) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerTwoPtrList_List) String() string {
	str, _ := text.MarshalList(0xcf9beaca1cc180c8, s.List)
	return str
}

// HoldsVerTwoPtrList_Promise is a wrapper for a HoldsVerTwoPtrList promised by a client call.
type HoldsVerTwoPtrList_Promise struct{ *capnp.Pipeline }

func (p HoldsVerTwoPtrList_Promise) Struct() (HoldsVerTwoPtrList, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerTwoPtrList{s}, err
}

type HoldsVerTwoTwoList struct{ capnp.Struct }

// HoldsVerTwoTwoList_TypeID is the unique identifier for the type HoldsVerTwoTwoList.
const HoldsVerTwoTwoList_TypeID = 0x95befe3f14606e6b

func NewHoldsVerTwoTwoList(s *capnp.Segment) (HoldsVerTwoTwoList, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoTwoList{st}, err
}

func NewRootHoldsVerTwoTwoList(s *capnp.Segment) (HoldsVerTwoTwoList, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoTwoList{st}, err
}

func ReadRootHoldsVerTwoTwoList(msg *capnp.Message) (HoldsVerTwoTwoList, error) {
	root, err := msg.RootPtr()
	return HoldsVerTwoTwoList{root.Struct()}, err
}

func (s HoldsVerTwoTwoList) String() string {
	str, _ := text.Marshal(0x95befe3f14606e6b, s.Struct)
	return str
}

func (s HoldsVerTwoTwoList) Mylist() (VerTwoDataTwoPtr_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoDataTwoPtr_List{List: p.List()}, err
}

func (s HoldsVerTwoTwoList) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerTwoTwoList) SetMylist(v VerTwoDataTwoPtr_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerTwoDataTwoPtr_List, preferring placement in s's segment.
func (s HoldsVerTwoTwoList) NewMylist(n int32) (VerTwoDataTwoPtr_List, error) {
	l, err := NewVerTwoDataTwoPtr_List(s.Struct.Segment(), n)
	if err != nil {
		return VerTwoDataTwoPtr_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerTwoTwoList_List is a list of HoldsVerTwoTwoList.
type HoldsVerTwoTwoList_List struct{ capnp.List }

// NewHoldsVerTwoTwoList creates a new list of HoldsVerTwoTwoList.
func NewHoldsVerTwoTwoList_List(s *capnp.Segment, sz int32) (HoldsVerTwoTwoList_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerTwoTwoList_List{l}, err
}

func (s HoldsVerTwoTwoList_List) At(i int) HoldsVerTwoTwoList {
	return HoldsVerTwoTwoList{s.List.Struct(i)}
}

func (s HoldsVerTwoTwoList_List) Set(i int, v HoldsVerTwoTwoList) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerTwoTwoList_List) String() string {
	str, _ := text.MarshalList(0x95befe3f14606e6b, s.List)
	return str
}

// HoldsVerTwoTwoList_Promise is a wrapper for a HoldsVerTwoTwoList promised by a client call.
type HoldsVerTwoTwoList_Promise struct{ *capnp.Pipeline }

func (p HoldsVerTwoTwoList_Promise) Struct() (HoldsVerTwoTwoList, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerTwoTwoList{s}, err
}

type HoldsVerTwoTwoPlus struct{ capnp.Struct }

// HoldsVerTwoTwoPlus_TypeID is the unique identifier for the type HoldsVerTwoTwoPlus.
const HoldsVerTwoTwoPlus_TypeID = 0x87c33f2330feb3d8

func NewHoldsVerTwoTwoPlus(s *capnp.Segment) (HoldsVerTwoTwoPlus, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoTwoPlus{st}, err
}

func NewRootHoldsVerTwoTwoPlus(s *capnp.Segment) (HoldsVerTwoTwoPlus, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return HoldsVerTwoTwoPlus{st}, err
}

func ReadRootHoldsVerTwoTwoPlus(msg *capnp.Message) (HoldsVerTwoTwoPlus, error) {
	root, err := msg.RootPtr()
	return HoldsVerTwoTwoPlus{root.Struct()}, err
}

func (s HoldsVerTwoTwoPlus) String() string {
	str, _ := text.Marshal(0x87c33f2330feb3d8, s.Struct)
	return str
}

func (s HoldsVerTwoTwoPlus) Mylist() (VerTwoTwoPlus_List, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoTwoPlus_List{List: p.List()}, err
}

func (s HoldsVerTwoTwoPlus) HasMylist() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsVerTwoTwoPlus) SetMylist(v VerTwoTwoPlus_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewMylist sets the mylist field to a newly
// allocated VerTwoTwoPlus_List, preferring placement in s's segment.
func (s HoldsVerTwoTwoPlus) NewMylist(n int32) (VerTwoTwoPlus_List, error) {
	l, err := NewVerTwoTwoPlus_List(s.Struct.Segment(), n)
	if err != nil {
		return VerTwoTwoPlus_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// HoldsVerTwoTwoPlus_List is a list of HoldsVerTwoTwoPlus.
type HoldsVerTwoTwoPlus_List struct{ capnp.List }

// NewHoldsVerTwoTwoPlus creates a new list of HoldsVerTwoTwoPlus.
func NewHoldsVerTwoTwoPlus_List(s *capnp.Segment, sz int32) (HoldsVerTwoTwoPlus_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return HoldsVerTwoTwoPlus_List{l}, err
}

func (s HoldsVerTwoTwoPlus_List) At(i int) HoldsVerTwoTwoPlus {
	return HoldsVerTwoTwoPlus{s.List.Struct(i)}
}

func (s HoldsVerTwoTwoPlus_List) Set(i int, v HoldsVerTwoTwoPlus) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s HoldsVerTwoTwoPlus_List) String() string {
	str, _ := text.MarshalList(0x87c33f2330feb3d8, s.List)
	return str
}

// HoldsVerTwoTwoPlus_Promise is a wrapper for a HoldsVerTwoTwoPlus promised by a client call.
type HoldsVerTwoTwoPlus_Promise struct{ *capnp.Pipeline }

func (p HoldsVerTwoTwoPlus_Promise) Struct() (HoldsVerTwoTwoPlus, error) {
	s, err := p.Pipeline.Struct()
	return HoldsVerTwoTwoPlus{s}, err
}

type VerTwoTwoPlus struct{ capnp.Struct }

// VerTwoTwoPlus_TypeID is the unique identifier for the type VerTwoTwoPlus.
const VerTwoTwoPlus_TypeID = 0xce44aee2d9e25049

func NewVerTwoTwoPlus(s *capnp.Segment) (VerTwoTwoPlus, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return VerTwoTwoPlus{st}, err
}

func NewRootVerTwoTwoPlus(s *capnp.Segment) (VerTwoTwoPlus, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return VerTwoTwoPlus{st}, err
}

func ReadRootVerTwoTwoPlus(msg *capnp.Message) (VerTwoTwoPlus, error) {
	root, err := msg.RootPtr()
	return VerTwoTwoPlus{root.Struct()}, err
}

func (s VerTwoTwoPlus) String() string {
	str, _ := text.Marshal(0xce44aee2d9e25049, s.Struct)
	return str
}

func (s VerTwoTwoPlus) Val() int16 {
	return int16(s.Struct.Uint16(0))
}

func (s VerTwoTwoPlus) SetVal(v int16) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s VerTwoTwoPlus) Duo() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s VerTwoTwoPlus) SetDuo(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

func (s VerTwoTwoPlus) Ptr1() (VerTwoDataTwoPtr, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoDataTwoPtr{Struct: p.Struct()}, err
}

func (s VerTwoTwoPlus) HasPtr1() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s VerTwoTwoPlus) SetPtr1(v VerTwoDataTwoPtr) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewPtr1 sets the ptr1 field to a newly
// allocated VerTwoDataTwoPtr struct, preferring placement in s's segment.
func (s VerTwoTwoPlus) NewPtr1() (VerTwoDataTwoPtr, error) {
	ss, err := NewVerTwoDataTwoPtr(s.Struct.Segment())
	if err != nil {
		return VerTwoDataTwoPtr{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s VerTwoTwoPlus) Ptr2() (VerTwoDataTwoPtr, error) {
	p, err := s.Struct.Ptr(1)
	return VerTwoDataTwoPtr{Struct: p.Struct()}, err
}

func (s VerTwoTwoPlus) HasPtr2() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s VerTwoTwoPlus) SetPtr2(v VerTwoDataTwoPtr) error {
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewPtr2 sets the ptr2 field to a newly
// allocated VerTwoDataTwoPtr struct, preferring placement in s's segment.
func (s VerTwoTwoPlus) NewPtr2() (VerTwoDataTwoPtr, error) {
	ss, err := NewVerTwoDataTwoPtr(s.Struct.Segment())
	if err != nil {
		return VerTwoDataTwoPtr{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

func (s VerTwoTwoPlus) Tre() int64 {
	return int64(s.Struct.Uint64(16))
}

func (s VerTwoTwoPlus) SetTre(v int64) {
	s.Struct.SetUint64(16, uint64(v))
}

func (s VerTwoTwoPlus) Lst3() (capnp.Int64List, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.Int64List{List: p.List()}, err
}

func (s VerTwoTwoPlus) HasLst3() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s VerTwoTwoPlus) SetLst3(v capnp.Int64List) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLst3 sets the lst3 field to a newly
// allocated capnp.Int64List, preferring placement in s's segment.
func (s VerTwoTwoPlus) NewLst3(n int32) (capnp.Int64List, error) {
	l, err := capnp.NewInt64List(s.Struct.Segment(), n)
	if err != nil {
		return capnp.Int64List{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

// VerTwoTwoPlus_List is a list of VerTwoTwoPlus.
type VerTwoTwoPlus_List struct{ capnp.List }

// NewVerTwoTwoPlus creates a new list of VerTwoTwoPlus.
func NewVerTwoTwoPlus_List(s *capnp.Segment, sz int32) (VerTwoTwoPlus_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return VerTwoTwoPlus_List{l}, err
}

func (s VerTwoTwoPlus_List) At(i int) VerTwoTwoPlus { return VerTwoTwoPlus{s.List.Struct(i)} }

func (s VerTwoTwoPlus_List) Set(i int, v VerTwoTwoPlus) error { return s.List.SetStruct(i, v.Struct) }

func (s VerTwoTwoPlus_List) String() string {
	str, _ := text.MarshalList(0xce44aee2d9e25049, s.List)
	return str
}

// VerTwoTwoPlus_Promise is a wrapper for a VerTwoTwoPlus promised by a client call.
type VerTwoTwoPlus_Promise struct{ *capnp.Pipeline }

func (p VerTwoTwoPlus_Promise) Struct() (VerTwoTwoPlus, error) {
	s, err := p.Pipeline.Struct()
	return VerTwoTwoPlus{s}, err
}

func (p VerTwoTwoPlus_Promise) Ptr1() VerTwoDataTwoPtr_Promise {
	return VerTwoDataTwoPtr_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p VerTwoTwoPlus_Promise) Ptr2() VerTwoDataTwoPtr_Promise {
	return VerTwoDataTwoPtr_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

type HoldsText struct{ capnp.Struct }

// HoldsText_TypeID is the unique identifier for the type HoldsText.
const HoldsText_TypeID = 0xe5817f849ff906dc

func NewHoldsText(s *capnp.Segment) (HoldsText, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return HoldsText{st}, err
}

func NewRootHoldsText(s *capnp.Segment) (HoldsText, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return HoldsText{st}, err
}

func ReadRootHoldsText(msg *capnp.Message) (HoldsText, error) {
	root, err := msg.RootPtr()
	return HoldsText{root.Struct()}, err
}

func (s HoldsText) String() string {
	str, _ := text.Marshal(0xe5817f849ff906dc, s.Struct)
	return str
}

func (s HoldsText) Txt() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s HoldsText) HasTxt() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s HoldsText) TxtBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s HoldsText) SetTxt(v string) error {
	return s.Struct.SetText(0, v)
}

func (s HoldsText) Lst() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s HoldsText) HasLst() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s HoldsText) SetLst(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewLst sets the lst field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s HoldsText) NewLst(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s HoldsText) Lstlst() (capnp.PointerList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.PointerList{List: p.List()}, err
}

func (s HoldsText) HasLstlst() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s HoldsText) SetLstlst(v capnp.PointerList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLstlst sets the lstlst field to a newly
// allocated capnp.PointerList, preferring placement in s's segment.
func (s HoldsText) NewLstlst(n int32) (capnp.PointerList, error) {
	l, err := capnp.NewPointerList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.PointerList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

// HoldsText_List is a list of HoldsText.
type HoldsText_List struct{ capnp.List }

// NewHoldsText creates a new list of HoldsText.
func NewHoldsText_List(s *capnp.Segment, sz int32) (HoldsText_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return HoldsText_List{l}, err
}

func (s HoldsText_List) At(i int) HoldsText { return HoldsText{s.List.Struct(i)} }

func (s HoldsText_List) Set(i int, v HoldsText) error { return s.List.SetStruct(i, v.Struct) }

func (s HoldsText_List) String() string {
	str, _ := text.MarshalList(0xe5817f849ff906dc, s.List)
	return str
}

// HoldsText_Promise is a wrapper for a HoldsText promised by a client call.
type HoldsText_Promise struct{ *capnp.Pipeline }

func (p HoldsText_Promise) Struct() (HoldsText, error) {
	s, err := p.Pipeline.Struct()
	return HoldsText{s}, err
}

type WrapEmpty struct{ capnp.Struct }

// WrapEmpty_TypeID is the unique identifier for the type WrapEmpty.
const WrapEmpty_TypeID = 0x9ab599979b02ac59

func NewWrapEmpty(s *capnp.Segment) (WrapEmpty, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return WrapEmpty{st}, err
}

func NewRootWrapEmpty(s *capnp.Segment) (WrapEmpty, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return WrapEmpty{st}, err
}

func ReadRootWrapEmpty(msg *capnp.Message) (WrapEmpty, error) {
	root, err := msg.RootPtr()
	return WrapEmpty{root.Struct()}, err
}

func (s WrapEmpty) String() string {
	str, _ := text.Marshal(0x9ab599979b02ac59, s.Struct)
	return str
}

func (s WrapEmpty) MightNotBeReallyEmpty() (VerEmpty, error) {
	p, err := s.Struct.Ptr(0)
	return VerEmpty{Struct: p.Struct()}, err
}

func (s WrapEmpty) HasMightNotBeReallyEmpty() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s WrapEmpty) SetMightNotBeReallyEmpty(v VerEmpty) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewMightNotBeReallyEmpty sets the mightNotBeReallyEmpty field to a newly
// allocated VerEmpty struct, preferring placement in s's segment.
func (s WrapEmpty) NewMightNotBeReallyEmpty() (VerEmpty, error) {
	ss, err := NewVerEmpty(s.Struct.Segment())
	if err != nil {
		return VerEmpty{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// WrapEmpty_List is a list of WrapEmpty.
type WrapEmpty_List struct{ capnp.List }

// NewWrapEmpty creates a new list of WrapEmpty.
func NewWrapEmpty_List(s *capnp.Segment, sz int32) (WrapEmpty_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return WrapEmpty_List{l}, err
}

func (s WrapEmpty_List) At(i int) WrapEmpty { return WrapEmpty{s.List.Struct(i)} }

func (s WrapEmpty_List) Set(i int, v WrapEmpty) error { return s.List.SetStruct(i, v.Struct) }

func (s WrapEmpty_List) String() string {
	str, _ := text.MarshalList(0x9ab599979b02ac59, s.List)
	return str
}

// WrapEmpty_Promise is a wrapper for a WrapEmpty promised by a client call.
type WrapEmpty_Promise struct{ *capnp.Pipeline }

func (p WrapEmpty_Promise) Struct() (WrapEmpty, error) {
	s, err := p.Pipeline.Struct()
	return WrapEmpty{s}, err
}

func (p WrapEmpty_Promise) MightNotBeReallyEmpty() VerEmpty_Promise {
	return VerEmpty_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Wrap2x2 struct{ capnp.Struct }

// Wrap2x2_TypeID is the unique identifier for the type Wrap2x2.
const Wrap2x2_TypeID = 0xe1a2d1d51107bead

func NewWrap2x2(s *capnp.Segment) (Wrap2x2, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Wrap2x2{st}, err
}

func NewRootWrap2x2(s *capnp.Segment) (Wrap2x2, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Wrap2x2{st}, err
}

func ReadRootWrap2x2(msg *capnp.Message) (Wrap2x2, error) {
	root, err := msg.RootPtr()
	return Wrap2x2{root.Struct()}, err
}

func (s Wrap2x2) String() string {
	str, _ := text.Marshal(0xe1a2d1d51107bead, s.Struct)
	return str
}

func (s Wrap2x2) MightNotBeReallyEmpty() (VerTwoDataTwoPtr, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoDataTwoPtr{Struct: p.Struct()}, err
}

func (s Wrap2x2) HasMightNotBeReallyEmpty() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Wrap2x2) SetMightNotBeReallyEmpty(v VerTwoDataTwoPtr) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewMightNotBeReallyEmpty sets the mightNotBeReallyEmpty field to a newly
// allocated VerTwoDataTwoPtr struct, preferring placement in s's segment.
func (s Wrap2x2) NewMightNotBeReallyEmpty() (VerTwoDataTwoPtr, error) {
	ss, err := NewVerTwoDataTwoPtr(s.Struct.Segment())
	if err != nil {
		return VerTwoDataTwoPtr{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Wrap2x2_List is a list of Wrap2x2.
type Wrap2x2_List struct{ capnp.List }

// NewWrap2x2 creates a new list of Wrap2x2.
func NewWrap2x2_List(s *capnp.Segment, sz int32) (Wrap2x2_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Wrap2x2_List{l}, err
}

func (s Wrap2x2_List) At(i int) Wrap2x2 { return Wrap2x2{s.List.Struct(i)} }

func (s Wrap2x2_List) Set(i int, v Wrap2x2) error { return s.List.SetStruct(i, v.Struct) }

func (s Wrap2x2_List) String() string {
	str, _ := text.MarshalList(0xe1a2d1d51107bead, s.List)
	return str
}

// Wrap2x2_Promise is a wrapper for a Wrap2x2 promised by a client call.
type Wrap2x2_Promise struct{ *capnp.Pipeline }

func (p Wrap2x2_Promise) Struct() (Wrap2x2, error) {
	s, err := p.Pipeline.Struct()
	return Wrap2x2{s}, err
}

func (p Wrap2x2_Promise) MightNotBeReallyEmpty() VerTwoDataTwoPtr_Promise {
	return VerTwoDataTwoPtr_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type Wrap2x2plus struct{ capnp.Struct }

// Wrap2x2plus_TypeID is the unique identifier for the type Wrap2x2plus.
const Wrap2x2plus_TypeID = 0xe684eb3aef1a6859

func NewWrap2x2plus(s *capnp.Segment) (Wrap2x2plus, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Wrap2x2plus{st}, err
}

func NewRootWrap2x2plus(s *capnp.Segment) (Wrap2x2plus, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Wrap2x2plus{st}, err
}

func ReadRootWrap2x2plus(msg *capnp.Message) (Wrap2x2plus, error) {
	root, err := msg.RootPtr()
	return Wrap2x2plus{root.Struct()}, err
}

func (s Wrap2x2plus) String() string {
	str, _ := text.Marshal(0xe684eb3aef1a6859, s.Struct)
	return str
}

func (s Wrap2x2plus) MightNotBeReallyEmpty() (VerTwoTwoPlus, error) {
	p, err := s.Struct.Ptr(0)
	return VerTwoTwoPlus{Struct: p.Struct()}, err
}

func (s Wrap2x2plus) HasMightNotBeReallyEmpty() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Wrap2x2plus) SetMightNotBeReallyEmpty(v VerTwoTwoPlus) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewMightNotBeReallyEmpty sets the mightNotBeReallyEmpty field to a newly
// allocated VerTwoTwoPlus struct, preferring placement in s's segment.
func (s Wrap2x2plus) NewMightNotBeReallyEmpty() (VerTwoTwoPlus, error) {
	ss, err := NewVerTwoTwoPlus(s.Struct.Segment())
	if err != nil {
		return VerTwoTwoPlus{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Wrap2x2plus_List is a list of Wrap2x2plus.
type Wrap2x2plus_List struct{ capnp.List }

// NewWrap2x2plus creates a new list of Wrap2x2plus.
func NewWrap2x2plus_List(s *capnp.Segment, sz int32) (Wrap2x2plus_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Wrap2x2plus_List{l}, err
}

func (s Wrap2x2plus_List) At(i int) Wrap2x2plus { return Wrap2x2plus{s.List.Struct(i)} }

func (s Wrap2x2plus_List) Set(i int, v Wrap2x2plus) error { return s.List.SetStruct(i, v.Struct) }

func (s Wrap2x2plus_List) String() string {
	str, _ := text.MarshalList(0xe684eb3aef1a6859, s.List)
	return str
}

// Wrap2x2plus_Promise is a wrapper for a Wrap2x2plus promised by a client call.
type Wrap2x2plus_Promise struct{ *capnp.Pipeline }

func (p Wrap2x2plus_Promise) Struct() (Wrap2x2plus, error) {
	s, err := p.Pipeline.Struct()
	return Wrap2x2plus{s}, err
}

func (p Wrap2x2plus_Promise) MightNotBeReallyEmpty() VerTwoTwoPlus_Promise {
	return VerTwoTwoPlus_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type VoidUnion struct{ capnp.Struct }
type VoidUnion_Which uint16

const (
	VoidUnion_Which_a VoidUnion_Which = 0
	VoidUnion_Which_b VoidUnion_Which = 1
)

func (w VoidUnion_Which) String() string {
	const s = "ab"
	switch w {
	case VoidUnion_Which_a:
		return s[0:1]
	case VoidUnion_Which_b:
		return s[1:2]

	}
	return "VoidUnion_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// VoidUnion_TypeID is the unique identifier for the type VoidUnion.
const VoidUnion_TypeID = 0x8821cdb23640783a

func NewVoidUnion(s *capnp.Segment) (VoidUnion, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return VoidUnion{st}, err
}

func NewRootVoidUnion(s *capnp.Segment) (VoidUnion, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return VoidUnion{st}, err
}

func ReadRootVoidUnion(msg *capnp.Message) (VoidUnion, error) {
	root, err := msg.RootPtr()
	return VoidUnion{root.Struct()}, err
}

func (s VoidUnion) String() string {
	str, _ := text.Marshal(0x8821cdb23640783a, s.Struct)
	return str
}

func (s VoidUnion) Which() VoidUnion_Which {
	return VoidUnion_Which(s.Struct.Uint16(0))
}
func (s VoidUnion) SetA() {
	s.Struct.SetUint16(0, 0)

}

func (s VoidUnion) SetB() {
	s.Struct.SetUint16(0, 1)

}

// VoidUnion_List is a list of VoidUnion.
type VoidUnion_List struct{ capnp.List }

// NewVoidUnion creates a new list of VoidUnion.
func NewVoidUnion_List(s *capnp.Segment, sz int32) (VoidUnion_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return VoidUnion_List{l}, err
}

func (s VoidUnion_List) At(i int) VoidUnion { return VoidUnion{s.List.Struct(i)} }

func (s VoidUnion_List) Set(i int, v VoidUnion) error { return s.List.SetStruct(i, v.Struct) }

func (s VoidUnion_List) String() string {
	str, _ := text.MarshalList(0x8821cdb23640783a, s.List)
	return str
}

// VoidUnion_Promise is a wrapper for a VoidUnion promised by a client call.
type VoidUnion_Promise struct{ *capnp.Pipeline }

func (p VoidUnion_Promise) Struct() (VoidUnion, error) {
	s, err := p.Pipeline.Struct()
	return VoidUnion{s}, err
}

type Nester1Capn struct{ capnp.Struct }

// Nester1Capn_TypeID is the unique identifier for the type Nester1Capn.
const Nester1Capn_TypeID = 0xf14fad09425d081c

func NewNester1Capn(s *capnp.Segment) (Nester1Capn, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Nester1Capn{st}, err
}

func NewRootNester1Capn(s *capnp.Segment) (Nester1Capn, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Nester1Capn{st}, err
}

func ReadRootNester1Capn(msg *capnp.Message) (Nester1Capn, error) {
	root, err := msg.RootPtr()
	return Nester1Capn{root.Struct()}, err
}

func (s Nester1Capn) String() string {
	str, _ := text.Marshal(0xf14fad09425d081c, s.Struct)
	return str
}

func (s Nester1Capn) Strs() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(0)
	return capnp.TextList{List: p.List()}, err
}

func (s Nester1Capn) HasStrs() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Nester1Capn) SetStrs(v capnp.TextList) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewStrs sets the strs field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Nester1Capn) NewStrs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// Nester1Capn_List is a list of Nester1Capn.
type Nester1Capn_List struct{ capnp.List }

// NewNester1Capn creates a new list of Nester1Capn.
func NewNester1Capn_List(s *capnp.Segment, sz int32) (Nester1Capn_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Nester1Capn_List{l}, err
}

func (s Nester1Capn_List) At(i int) Nester1Capn { return Nester1Capn{s.List.Struct(i)} }

func (s Nester1Capn_List) Set(i int, v Nester1Capn) error { return s.List.SetStruct(i, v.Struct) }

func (s Nester1Capn_List) String() string {
	str, _ := text.MarshalList(0xf14fad09425d081c, s.List)
	return str
}

// Nester1Capn_Promise is a wrapper for a Nester1Capn promised by a client call.
type Nester1Capn_Promise struct{ *capnp.Pipeline }

func (p Nester1Capn_Promise) Struct() (Nester1Capn, error) {
	s, err := p.Pipeline.Struct()
	return Nester1Capn{s}, err
}

type RWTestCapn struct{ capnp.Struct }

// RWTestCapn_TypeID is the unique identifier for the type RWTestCapn.
const RWTestCapn_TypeID = 0xf7ff4414476c186a

func NewRWTestCapn(s *capnp.Segment) (RWTestCapn, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RWTestCapn{st}, err
}

func NewRootRWTestCapn(s *capnp.Segment) (RWTestCapn, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RWTestCapn{st}, err
}

func ReadRootRWTestCapn(msg *capnp.Message) (RWTestCapn, error) {
	root, err := msg.RootPtr()
	return RWTestCapn{root.Struct()}, err
}

func (s RWTestCapn) String() string {
	str, _ := text.Marshal(0xf7ff4414476c186a, s.Struct)
	return str
}

func (s RWTestCapn) NestMatrix() (capnp.PointerList, error) {
	p, err := s.Struct.Ptr(0)
	return capnp.PointerList{List: p.List()}, err
}

func (s RWTestCapn) HasNestMatrix() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RWTestCapn) SetNestMatrix(v capnp.PointerList) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewNestMatrix sets the nestMatrix field to a newly
// allocated capnp.PointerList, preferring placement in s's segment.
func (s RWTestCapn) NewNestMatrix(n int32) (capnp.PointerList, error) {
	l, err := capnp.NewPointerList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.PointerList{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// RWTestCapn_List is a list of RWTestCapn.
type RWTestCapn_List struct{ capnp.List }

// NewRWTestCapn creates a new list of RWTestCapn.
func NewRWTestCapn_List(s *capnp.Segment, sz int32) (RWTestCapn_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RWTestCapn_List{l}, err
}

func (s RWTestCapn_List) At(i int) RWTestCapn { return RWTestCapn{s.List.Struct(i)} }

func (s RWTestCapn_List) Set(i int, v RWTestCapn) error { return s.List.SetStruct(i, v.Struct) }

func (s RWTestCapn_List) String() string {
	str, _ := text.MarshalList(0xf7ff4414476c186a, s.List)
	return str
}

// RWTestCapn_Promise is a wrapper for a RWTestCapn promised by a client call.
type RWTestCapn_Promise struct{ *capnp.Pipeline }

func (p RWTestCapn_Promise) Struct() (RWTestCapn, error) {
	s, err := p.Pipeline.Struct()
	return RWTestCapn{s}, err
}

type ListStructCapn struct{ capnp.Struct }

// ListStructCapn_TypeID is the unique identifier for the type ListStructCapn.
const ListStructCapn_TypeID = 0xb1ac056ed7647011

func NewListStructCapn(s *capnp.Segment) (ListStructCapn, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ListStructCapn{st}, err
}

func NewRootListStructCapn(s *capnp.Segment) (ListStructCapn, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ListStructCapn{st}, err
}

func ReadRootListStructCapn(msg *capnp.Message) (ListStructCapn, error) {
	root, err := msg.RootPtr()
	return ListStructCapn{root.Struct()}, err
}

func (s ListStructCapn) String() string {
	str, _ := text.Marshal(0xb1ac056ed7647011, s.Struct)
	return str
}

func (s ListStructCapn) Vec() (Nester1Capn_List, error) {
	p, err := s.Struct.Ptr(0)
	return Nester1Capn_List{List: p.List()}, err
}

func (s ListStructCapn) HasVec() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ListStructCapn) SetVec(v Nester1Capn_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewVec sets the vec field to a newly
// allocated Nester1Capn_List, preferring placement in s's segment.
func (s ListStructCapn) NewVec(n int32) (Nester1Capn_List, error) {
	l, err := NewNester1Capn_List(s.Struct.Segment(), n)
	if err != nil {
		return Nester1Capn_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// ListStructCapn_List is a list of ListStructCapn.
type ListStructCapn_List struct{ capnp.List }

// NewListStructCapn creates a new list of ListStructCapn.
func NewListStructCapn_List(s *capnp.Segment, sz int32) (ListStructCapn_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ListStructCapn_List{l}, err
}

func (s ListStructCapn_List) At(i int) ListStructCapn { return ListStructCapn{s.List.Struct(i)} }

func (s ListStructCapn_List) Set(i int, v ListStructCapn) error { return s.List.SetStruct(i, v.Struct) }

func (s ListStructCapn_List) String() string {
	str, _ := text.MarshalList(0xb1ac056ed7647011, s.List)
	return str
}

// ListStructCapn_Promise is a wrapper for a ListStructCapn promised by a client call.
type ListStructCapn_Promise struct{ *capnp.Pipeline }

func (p ListStructCapn_Promise) Struct() (ListStructCapn, error) {
	s, err := p.Pipeline.Struct()
	return ListStructCapn{s}, err
}

type Echo struct{ Client capnp.Client }

// Echo_TypeID is the unique identifier for the type Echo.
const Echo_TypeID = 0x8e5322c1e9282534

func (c Echo) Echo(ctx context.Context, params func(Echo_echo_Params) error, opts ...capnp.CallOption) Echo_echo_Results_Promise {
	if c.Client == nil {
		return Echo_echo_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x8e5322c1e9282534,
			MethodID:      0,
			InterfaceName: "aircraft.capnp:Echo",
			MethodName:    "echo",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error { return params(Echo_echo_Params{Struct: s}) }
	}
	return Echo_echo_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type Echo_Server interface {
	Echo(Echo_echo) error
}

func Echo_ServerToClient(s Echo_Server) Echo {
	c, _ := s.(server.Closer)
	return Echo{Client: server.New(Echo_Methods(nil, s), c)}
}

func Echo_Methods(methods []server.Method, s Echo_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 1)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x8e5322c1e9282534,
			MethodID:      0,
			InterfaceName: "aircraft.capnp:Echo",
			MethodName:    "echo",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := Echo_echo{c, opts, Echo_echo_Params{Struct: p}, Echo_echo_Results{Struct: r}}
			return s.Echo(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	return methods
}

// Echo_echo holds the arguments for a server call to Echo.echo.
type Echo_echo struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  Echo_echo_Params
	Results Echo_echo_Results
}

type Echo_echo_Params struct{ capnp.Struct }

// Echo_echo_Params_TypeID is the unique identifier for the type Echo_echo_Params.
const Echo_echo_Params_TypeID = 0x8a165fb4d71bf3a2

func NewEcho_echo_Params(s *capnp.Segment) (Echo_echo_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Echo_echo_Params{st}, err
}

func NewRootEcho_echo_Params(s *capnp.Segment) (Echo_echo_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Echo_echo_Params{st}, err
}

func ReadRootEcho_echo_Params(msg *capnp.Message) (Echo_echo_Params, error) {
	root, err := msg.RootPtr()
	return Echo_echo_Params{root.Struct()}, err
}

func (s Echo_echo_Params) String() string {
	str, _ := text.Marshal(0x8a165fb4d71bf3a2, s.Struct)
	return str
}

func (s Echo_echo_Params) In() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Echo_echo_Params) HasIn() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Echo_echo_Params) InBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Echo_echo_Params) SetIn(v string) error {
	return s.Struct.SetText(0, v)
}

// Echo_echo_Params_List is a list of Echo_echo_Params.
type Echo_echo_Params_List struct{ capnp.List }

// NewEcho_echo_Params creates a new list of Echo_echo_Params.
func NewEcho_echo_Params_List(s *capnp.Segment, sz int32) (Echo_echo_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Echo_echo_Params_List{l}, err
}

func (s Echo_echo_Params_List) At(i int) Echo_echo_Params { return Echo_echo_Params{s.List.Struct(i)} }

func (s Echo_echo_Params_List) Set(i int, v Echo_echo_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s Echo_echo_Params_List) String() string {
	str, _ := text.MarshalList(0x8a165fb4d71bf3a2, s.List)
	return str
}

// Echo_echo_Params_Promise is a wrapper for a Echo_echo_Params promised by a client call.
type Echo_echo_Params_Promise struct{ *capnp.Pipeline }

func (p Echo_echo_Params_Promise) Struct() (Echo_echo_Params, error) {
	s, err := p.Pipeline.Struct()
	return Echo_echo_Params{s}, err
}

type Echo_echo_Results struct{ capnp.Struct }

// Echo_echo_Results_TypeID is the unique identifier for the type Echo_echo_Results.
const Echo_echo_Results_TypeID = 0x9b37d729b9dd7b9d

func NewEcho_echo_Results(s *capnp.Segment) (Echo_echo_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Echo_echo_Results{st}, err
}

func NewRootEcho_echo_Results(s *capnp.Segment) (Echo_echo_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Echo_echo_Results{st}, err
}

func ReadRootEcho_echo_Results(msg *capnp.Message) (Echo_echo_Results, error) {
	root, err := msg.RootPtr()
	return Echo_echo_Results{root.Struct()}, err
}

func (s Echo_echo_Results) String() string {
	str, _ := text.Marshal(0x9b37d729b9dd7b9d, s.Struct)
	return str
}

func (s Echo_echo_Results) Out() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Echo_echo_Results) HasOut() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Echo_echo_Results) OutBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Echo_echo_Results) SetOut(v string) error {
	return s.Struct.SetText(0, v)
}

// Echo_echo_Results_List is a list of Echo_echo_Results.
type Echo_echo_Results_List struct{ capnp.List }

// NewEcho_echo_Results creates a new list of Echo_echo_Results.
func NewEcho_echo_Results_List(s *capnp.Segment, sz int32) (Echo_echo_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Echo_echo_Results_List{l}, err
}

func (s Echo_echo_Results_List) At(i int) Echo_echo_Results {
	return Echo_echo_Results{s.List.Struct(i)}
}

func (s Echo_echo_Results_List) Set(i int, v Echo_echo_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s Echo_echo_Results_List) String() string {
	str, _ := text.MarshalList(0x9b37d729b9dd7b9d, s.List)
	return str
}

// Echo_echo_Results_Promise is a wrapper for a Echo_echo_Results promised by a client call.
type Echo_echo_Results_Promise struct{ *capnp.Pipeline }

func (p Echo_echo_Results_Promise) Struct() (Echo_echo_Results, error) {
	s, err := p.Pipeline.Struct()
	return Echo_echo_Results{s}, err
}

type Hoth struct{ capnp.Struct }

// Hoth_TypeID is the unique identifier for the type Hoth.
const Hoth_TypeID = 0xad87da456fb0ebb9

func NewHoth(s *capnp.Segment) (Hoth, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Hoth{st}, err
}

func NewRootHoth(s *capnp.Segment) (Hoth, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Hoth{st}, err
}

func ReadRootHoth(msg *capnp.Message) (Hoth, error) {
	root, err := msg.RootPtr()
	return Hoth{root.Struct()}, err
}

func (s Hoth) String() string {
	str, _ := text.Marshal(0xad87da456fb0ebb9, s.Struct)
	return str
}

func (s Hoth) Base() (EchoBase, error) {
	p, err := s.Struct.Ptr(0)
	return EchoBase{Struct: p.Struct()}, err
}

func (s Hoth) HasBase() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Hoth) SetBase(v EchoBase) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewBase sets the base field to a newly
// allocated EchoBase struct, preferring placement in s's segment.
func (s Hoth) NewBase() (EchoBase, error) {
	ss, err := NewEchoBase(s.Struct.Segment())
	if err != nil {
		return EchoBase{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Hoth_List is a list of Hoth.
type Hoth_List struct{ capnp.List }

// NewHoth creates a new list of Hoth.
func NewHoth_List(s *capnp.Segment, sz int32) (Hoth_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Hoth_List{l}, err
}

func (s Hoth_List) At(i int) Hoth { return Hoth{s.List.Struct(i)} }

func (s Hoth_List) Set(i int, v Hoth) error { return s.List.SetStruct(i, v.Struct) }

func (s Hoth_List) String() string {
	str, _ := text.MarshalList(0xad87da456fb0ebb9, s.List)
	return str
}

// Hoth_Promise is a wrapper for a Hoth promised by a client call.
type Hoth_Promise struct{ *capnp.Pipeline }

func (p Hoth_Promise) Struct() (Hoth, error) {
	s, err := p.Pipeline.Struct()
	return Hoth{s}, err
}

func (p Hoth_Promise) Base() EchoBase_Promise {
	return EchoBase_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type EchoBase struct{ capnp.Struct }

// EchoBase_TypeID is the unique identifier for the type EchoBase.
const EchoBase_TypeID = 0xa8bf13fef2674866

func NewEchoBase(s *capnp.Segment) (EchoBase, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return EchoBase{st}, err
}

func NewRootEchoBase(s *capnp.Segment) (EchoBase, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return EchoBase{st}, err
}

func ReadRootEchoBase(msg *capnp.Message) (EchoBase, error) {
	root, err := msg.RootPtr()
	return EchoBase{root.Struct()}, err
}

func (s EchoBase) String() string {
	str, _ := text.Marshal(0xa8bf13fef2674866, s.Struct)
	return str
}

func (s EchoBase) Echo() Echo {
	p, _ := s.Struct.Ptr(0)
	return Echo{Client: p.Interface().Client()}
}

func (s EchoBase) HasEcho() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s EchoBase) SetEcho(v Echo) error {
	if v.Client == nil {
		return s.Struct.SetPtr(0, capnp.Ptr{})
	}
	seg := s.Segment()
	in := capnp.NewInterface(seg, seg.Message().AddCap(v.Client))
	return s.Struct.SetPtr(0, in.ToPtr())
}

// EchoBase_List is a list of EchoBase.
type EchoBase_List struct{ capnp.List }

// NewEchoBase creates a new list of EchoBase.
func NewEchoBase_List(s *capnp.Segment, sz int32) (EchoBase_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return EchoBase_List{l}, err
}

func (s EchoBase_List) At(i int) EchoBase { return EchoBase{s.List.Struct(i)} }

func (s EchoBase_List) Set(i int, v EchoBase) error { return s.List.SetStruct(i, v.Struct) }

func (s EchoBase_List) String() string {
	str, _ := text.MarshalList(0xa8bf13fef2674866, s.List)
	return str
}

// EchoBase_Promise is a wrapper for a EchoBase promised by a client call.
type EchoBase_Promise struct{ *capnp.Pipeline }

func (p EchoBase_Promise) Struct() (EchoBase, error) {
	s, err := p.Pipeline.Struct()
	return EchoBase{s}, err
}

func (p EchoBase_Promise) Echo() Echo {
	return Echo{Client: p.Pipeline.GetPipeline(0).Client()}
}

type EchoBases struct{ capnp.Struct }

// EchoBases_TypeID is the unique identifier for the type EchoBases.
const EchoBases_TypeID = 0xc02e9d191c6ac0bc

func NewEchoBases(s *capnp.Segment) (EchoBases, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return EchoBases{st}, err
}

func NewRootEchoBases(s *capnp.Segment) (EchoBases, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return EchoBases{st}, err
}

func ReadRootEchoBases(msg *capnp.Message) (EchoBases, error) {
	root, err := msg.RootPtr()
	return EchoBases{root.Struct()}, err
}

func (s EchoBases) String() string {
	str, _ := text.Marshal(0xc02e9d191c6ac0bc, s.Struct)
	return str
}

func (s EchoBases) Bases() (EchoBase_List, error) {
	p, err := s.Struct.Ptr(0)
	return EchoBase_List{List: p.List()}, err
}

func (s EchoBases) HasBases() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s EchoBases) SetBases(v EchoBase_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewBases sets the bases field to a newly
// allocated EchoBase_List, preferring placement in s's segment.
func (s EchoBases) NewBases(n int32) (EchoBase_List, error) {
	l, err := NewEchoBase_List(s.Struct.Segment(), n)
	if err != nil {
		return EchoBase_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// EchoBases_List is a list of EchoBases.
type EchoBases_List struct{ capnp.List }

// NewEchoBases creates a new list of EchoBases.
func NewEchoBases_List(s *capnp.Segment, sz int32) (EchoBases_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return EchoBases_List{l}, err
}

func (s EchoBases_List) At(i int) EchoBases { return EchoBases{s.List.Struct(i)} }

func (s EchoBases_List) Set(i int, v EchoBases) error { return s.List.SetStruct(i, v.Struct) }

func (s EchoBases_List) String() string {
	str, _ := text.MarshalList(0xc02e9d191c6ac0bc, s.List)
	return str
}

// EchoBases_Promise is a wrapper for a EchoBases promised by a client call.
type EchoBases_Promise struct{ *capnp.Pipeline }

func (p EchoBases_Promise) Struct() (EchoBases, error) {
	s, err := p.Pipeline.Struct()
	return EchoBases{s}, err
}

type StackingRoot struct{ capnp.Struct }

// StackingRoot_TypeID is the unique identifier for the type StackingRoot.
const StackingRoot_TypeID = 0x8fae7b41c61fc890

func NewStackingRoot(s *capnp.Segment) (StackingRoot, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return StackingRoot{st}, err
}

func NewRootStackingRoot(s *capnp.Segment) (StackingRoot, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return StackingRoot{st}, err
}

func ReadRootStackingRoot(msg *capnp.Message) (StackingRoot, error) {
	root, err := msg.RootPtr()
	return StackingRoot{root.Struct()}, err
}

func (s StackingRoot) String() string {
	str, _ := text.Marshal(0x8fae7b41c61fc890, s.Struct)
	return str
}

func (s StackingRoot) A() (StackingA, error) {
	p, err := s.Struct.Ptr(1)
	return StackingA{Struct: p.Struct()}, err
}

func (s StackingRoot) HasA() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s StackingRoot) SetA(v StackingA) error {
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewA sets the a field to a newly
// allocated StackingA struct, preferring placement in s's segment.
func (s StackingRoot) NewA() (StackingA, error) {
	ss, err := NewStackingA(s.Struct.Segment())
	if err != nil {
		return StackingA{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

func (s StackingRoot) AWithDefault() (StackingA, error) {
	p, err := s.Struct.Ptr(0)
	if err != nil {
		return StackingA{}, err
	}
	ss, err := p.StructDefault(x_832bcc6686a26d56[64:96])
	return StackingA{Struct: ss}, err
}

func (s StackingRoot) HasAWithDefault() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s StackingRoot) SetAWithDefault(v StackingA) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAWithDefault sets the aWithDefault field to a newly
// allocated StackingA struct, preferring placement in s's segment.
func (s StackingRoot) NewAWithDefault() (StackingA, error) {
	ss, err := NewStackingA(s.Struct.Segment())
	if err != nil {
		return StackingA{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// StackingRoot_List is a list of StackingRoot.
type StackingRoot_List struct{ capnp.List }

// NewStackingRoot creates a new list of StackingRoot.
func NewStackingRoot_List(s *capnp.Segment, sz int32) (StackingRoot_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return StackingRoot_List{l}, err
}

func (s StackingRoot_List) At(i int) StackingRoot { return StackingRoot{s.List.Struct(i)} }

func (s StackingRoot_List) Set(i int, v StackingRoot) error { return s.List.SetStruct(i, v.Struct) }

func (s StackingRoot_List) String() string {
	str, _ := text.MarshalList(0x8fae7b41c61fc890, s.List)
	return str
}

// StackingRoot_Promise is a wrapper for a StackingRoot promised by a client call.
type StackingRoot_Promise struct{ *capnp.Pipeline }

func (p StackingRoot_Promise) Struct() (StackingRoot, error) {
	s, err := p.Pipeline.Struct()
	return StackingRoot{s}, err
}

func (p StackingRoot_Promise) A() StackingA_Promise {
	return StackingA_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

func (p StackingRoot_Promise) AWithDefault() StackingA_Promise {
	return StackingA_Promise{Pipeline: p.Pipeline.GetPipelineDefault(0, x_832bcc6686a26d56[96:128])}
}

type StackingA struct{ capnp.Struct }

// StackingA_TypeID is the unique identifier for the type StackingA.
const StackingA_TypeID = 0x9d3032ff86043b75

func NewStackingA(s *capnp.Segment) (StackingA, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return StackingA{st}, err
}

func NewRootStackingA(s *capnp.Segment) (StackingA, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return StackingA{st}, err
}

func ReadRootStackingA(msg *capnp.Message) (StackingA, error) {
	root, err := msg.RootPtr()
	return StackingA{root.Struct()}, err
}

func (s StackingA) String() string {
	str, _ := text.Marshal(0x9d3032ff86043b75, s.Struct)
	return str
}

func (s StackingA) Num() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s StackingA) SetNum(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

func (s StackingA) B() (StackingB, error) {
	p, err := s.Struct.Ptr(0)
	return StackingB{Struct: p.Struct()}, err
}

func (s StackingA) HasB() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s StackingA) SetB(v StackingB) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewB sets the b field to a newly
// allocated StackingB struct, preferring placement in s's segment.
func (s StackingA) NewB() (StackingB, error) {
	ss, err := NewStackingB(s.Struct.Segment())
	if err != nil {
		return StackingB{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// StackingA_List is a list of StackingA.
type StackingA_List struct{ capnp.List }

// NewStackingA creates a new list of StackingA.
func NewStackingA_List(s *capnp.Segment, sz int32) (StackingA_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return StackingA_List{l}, err
}

func (s StackingA_List) At(i int) StackingA { return StackingA{s.List.Struct(i)} }

func (s StackingA_List) Set(i int, v StackingA) error { return s.List.SetStruct(i, v.Struct) }

func (s StackingA_List) String() string {
	str, _ := text.MarshalList(0x9d3032ff86043b75, s.List)
	return str
}

// StackingA_Promise is a wrapper for a StackingA promised by a client call.
type StackingA_Promise struct{ *capnp.Pipeline }

func (p StackingA_Promise) Struct() (StackingA, error) {
	s, err := p.Pipeline.Struct()
	return StackingA{s}, err
}

func (p StackingA_Promise) B() StackingB_Promise {
	return StackingB_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type StackingB struct{ capnp.Struct }

// StackingB_TypeID is the unique identifier for the type StackingB.
const StackingB_TypeID = 0x85257b30d6edf8c5

func NewStackingB(s *capnp.Segment) (StackingB, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return StackingB{st}, err
}

func NewRootStackingB(s *capnp.Segment) (StackingB, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return StackingB{st}, err
}

func ReadRootStackingB(msg *capnp.Message) (StackingB, error) {
	root, err := msg.RootPtr()
	return StackingB{root.Struct()}, err
}

func (s StackingB) String() string {
	str, _ := text.Marshal(0x85257b30d6edf8c5, s.Struct)
	return str
}

func (s StackingB) Num() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s StackingB) SetNum(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

// StackingB_List is a list of StackingB.
type StackingB_List struct{ capnp.List }

// NewStackingB creates a new list of StackingB.
func NewStackingB_List(s *capnp.Segment, sz int32) (StackingB_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return StackingB_List{l}, err
}

func (s StackingB_List) At(i int) StackingB { return StackingB{s.List.Struct(i)} }

func (s StackingB_List) Set(i int, v StackingB) error { return s.List.SetStruct(i, v.Struct) }

func (s StackingB_List) String() string {
	str, _ := text.MarshalList(0x85257b30d6edf8c5, s.List)
	return str
}

// StackingB_Promise is a wrapper for a StackingB promised by a client call.
type StackingB_Promise struct{ *capnp.Pipeline }

func (p StackingB_Promise) Struct() (StackingB, error) {
	s, err := p.Pipeline.Struct()
	return StackingB{s}, err
}

type CallSequence struct{ Client capnp.Client }

// CallSequence_TypeID is the unique identifier for the type CallSequence.
const CallSequence_TypeID = 0xabaedf5f7817c820

func (c CallSequence) GetNumber(ctx context.Context, params func(CallSequence_getNumber_Params) error, opts ...capnp.CallOption) CallSequence_getNumber_Results_Promise {
	if c.Client == nil {
		return CallSequence_getNumber_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xabaedf5f7817c820,
			MethodID:      0,
			InterfaceName: "aircraft.capnp:CallSequence",
			MethodName:    "getNumber",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(CallSequence_getNumber_Params{Struct: s}) }
	}
	return CallSequence_getNumber_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type CallSequence_Server interface {
	GetNumber(CallSequence_getNumber) error
}

func CallSequence_ServerToClient(s CallSequence_Server) CallSequence {
	c, _ := s.(server.Closer)
	return CallSequence{Client: server.New(CallSequence_Methods(nil, s), c)}
}

func CallSequence_Methods(methods []server.Method, s CallSequence_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 1)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xabaedf5f7817c820,
			MethodID:      0,
			InterfaceName: "aircraft.capnp:CallSequence",
			MethodName:    "getNumber",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := CallSequence_getNumber{c, opts, CallSequence_getNumber_Params{Struct: p}, CallSequence_getNumber_Results{Struct: r}}
			return s.GetNumber(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 8, PointerCount: 0},
	})

	return methods
}

// CallSequence_getNumber holds the arguments for a server call to CallSequence.getNumber.
type CallSequence_getNumber struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  CallSequence_getNumber_Params
	Results CallSequence_getNumber_Results
}

type CallSequence_getNumber_Params struct{ capnp.Struct }

// CallSequence_getNumber_Params_TypeID is the unique identifier for the type CallSequence_getNumber_Params.
const CallSequence_getNumber_Params_TypeID = 0xf58782f48a121998

func NewCallSequence_getNumber_Params(s *capnp.Segment) (CallSequence_getNumber_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return CallSequence_getNumber_Params{st}, err
}

func NewRootCallSequence_getNumber_Params(s *capnp.Segment) (CallSequence_getNumber_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return CallSequence_getNumber_Params{st}, err
}

func ReadRootCallSequence_getNumber_Params(msg *capnp.Message) (CallSequence_getNumber_Params, error) {
	root, err := msg.RootPtr()
	return CallSequence_getNumber_Params{root.Struct()}, err
}

func (s CallSequence_getNumber_Params) String() string {
	str, _ := text.Marshal(0xf58782f48a121998, s.Struct)
	return str
}

// CallSequence_getNumber_Params_List is a list of CallSequence_getNumber_Params.
type CallSequence_getNumber_Params_List struct{ capnp.List }

// NewCallSequence_getNumber_Params creates a new list of CallSequence_getNumber_Params.
func NewCallSequence_getNumber_Params_List(s *capnp.Segment, sz int32) (CallSequence_getNumber_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return CallSequence_getNumber_Params_List{l}, err
}

func (s CallSequence_getNumber_Params_List) At(i int) CallSequence_getNumber_Params {
	return CallSequence_getNumber_Params{s.List.Struct(i)}
}

func (s CallSequence_getNumber_Params_List) Set(i int, v CallSequence_getNumber_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s CallSequence_getNumber_Params_List) String() string {
	str, _ := text.MarshalList(0xf58782f48a121998, s.List)
	return str
}

// CallSequence_getNumber_Params_Promise is a wrapper for a CallSequence_getNumber_Params promised by a client call.
type CallSequence_getNumber_Params_Promise struct{ *capnp.Pipeline }

func (p CallSequence_getNumber_Params_Promise) Struct() (CallSequence_getNumber_Params, error) {
	s, err := p.Pipeline.Struct()
	return CallSequence_getNumber_Params{s}, err
}

type CallSequence_getNumber_Results struct{ capnp.Struct }

// CallSequence_getNumber_Results_TypeID is the unique identifier for the type CallSequence_getNumber_Results.
const CallSequence_getNumber_Results_TypeID = 0xa465f9502fd11e97

func NewCallSequence_getNumber_Results(s *capnp.Segment) (CallSequence_getNumber_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return CallSequence_getNumber_Results{st}, err
}

func NewRootCallSequence_getNumber_Results(s *capnp.Segment) (CallSequence_getNumber_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return CallSequence_getNumber_Results{st}, err
}

func ReadRootCallSequence_getNumber_Results(msg *capnp.Message) (CallSequence_getNumber_Results, error) {
	root, err := msg.RootPtr()
	return CallSequence_getNumber_Results{root.Struct()}, err
}

func (s CallSequence_getNumber_Results) String() string {
	str, _ := text.Marshal(0xa465f9502fd11e97, s.Struct)
	return str
}

func (s CallSequence_getNumber_Results) N() uint32 {
	return s.Struct.Uint32(0)
}

func (s CallSequence_getNumber_Results) SetN(v uint32) {
	s.Struct.SetUint32(0, v)
}

// CallSequence_getNumber_Results_List is a list of CallSequence_getNumber_Results.
type CallSequence_getNumber_Results_List struct{ capnp.List }

// NewCallSequence_getNumber_Results creates a new list of CallSequence_getNumber_Results.
func NewCallSequence_getNumber_Results_List(s *capnp.Segment, sz int32) (CallSequence_getNumber_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return CallSequence_getNumber_Results_List{l}, err
}

func (s CallSequence_getNumber_Results_List) At(i int) CallSequence_getNumber_Results {
	return CallSequence_getNumber_Results{s.List.Struct(i)}
}

func (s CallSequence_getNumber_Results_List) Set(i int, v CallSequence_getNumber_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s CallSequence_getNumber_Results_List) String() string {
	str, _ := text.MarshalList(0xa465f9502fd11e97, s.List)
	return str
}

// CallSequence_getNumber_Results_Promise is a wrapper for a CallSequence_getNumber_Results promised by a client call.
type CallSequence_getNumber_Results_Promise struct{ *capnp.Pipeline }

func (p CallSequence_getNumber_Results_Promise) Struct() (CallSequence_getNumber_Results, error) {
	s, err := p.Pipeline.Struct()
	return CallSequence_getNumber_Results{s}, err
}

type Defaults struct{ capnp.Struct }

// Defaults_TypeID is the unique identifier for the type Defaults.
const Defaults_TypeID = 0x97e38948c61f878d

func NewDefaults(s *capnp.Segment) (Defaults, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return Defaults{st}, err
}

func NewRootDefaults(s *capnp.Segment) (Defaults, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return Defaults{st}, err
}

func ReadRootDefaults(msg *capnp.Message) (Defaults, error) {
	root, err := msg.RootPtr()
	return Defaults{root.Struct()}, err
}

func (s Defaults) String() string {
	str, _ := text.Marshal(0x97e38948c61f878d, s.Struct)
	return str
}

func (s Defaults) Text() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextDefault("foo"), err
}

func (s Defaults) HasText() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Defaults) TextBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytesDefault("foo"), err
}

func (s Defaults) SetText(v string) error {
	return s.Struct.SetNewText(0, v)
}

func (s Defaults) Data() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.DataDefault([]byte{0x62, 0x61, 0x72})), err
}

func (s Defaults) HasData() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Defaults) SetData(v []byte) error {
	if v == nil {
		v = []byte{}
	}
	return s.Struct.SetData(1, v)
}

func (s Defaults) Float() float32 {
	return math.Float32frombits(s.Struct.Uint32(0) ^ 0x4048f5c3)
}

func (s Defaults) SetFloat(v float32) {
	s.Struct.SetUint32(0, math.Float32bits(v)^0x4048f5c3)
}

func (s Defaults) Int() int32 {
	return int32(s.Struct.Uint32(4) ^ 4294967173)
}

func (s Defaults) SetInt(v int32) {
	s.Struct.SetUint32(4, uint32(v)^4294967173)
}

func (s Defaults) Uint() uint32 {
	return s.Struct.Uint32(8) ^ 42
}

func (s Defaults) SetUint(v uint32) {
	s.Struct.SetUint32(8, v^42)
}

// Defaults_List is a list of Defaults.
type Defaults_List struct{ capnp.List }

// NewDefaults creates a new list of Defaults.
func NewDefaults_List(s *capnp.Segment, sz int32) (Defaults_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return Defaults_List{l}, err
}

func (s Defaults_List) At(i int) Defaults { return Defaults{s.List.Struct(i)} }

func (s Defaults_List) Set(i int, v Defaults) error { return s.List.SetStruct(i, v.Struct) }

func (s Defaults_List) String() string {
	str, _ := text.MarshalList(0x97e38948c61f878d, s.List)
	return str
}

// Defaults_Promise is a wrapper for a Defaults promised by a client call.
type Defaults_Promise struct{ *capnp.Pipeline }

func (p Defaults_Promise) Struct() (Defaults, error) {
	s, err := p.Pipeline.Struct()
	return Defaults{s}, err
}

type BenchmarkA struct{ capnp.Struct }

// BenchmarkA_TypeID is the unique identifier for the type BenchmarkA.
const BenchmarkA_TypeID = 0xde2a1a960863c11c

func NewBenchmarkA(s *capnp.Segment) (BenchmarkA, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 2})
	return BenchmarkA{st}, err
}

func NewRootBenchmarkA(s *capnp.Segment) (BenchmarkA, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 2})
	return BenchmarkA{st}, err
}

func ReadRootBenchmarkA(msg *capnp.Message) (BenchmarkA, error) {
	root, err := msg.RootPtr()
	return BenchmarkA{root.Struct()}, err
}

func (s BenchmarkA) String() string {
	str, _ := text.Marshal(0xde2a1a960863c11c, s.Struct)
	return str
}

func (s BenchmarkA) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s BenchmarkA) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s BenchmarkA) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s BenchmarkA) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s BenchmarkA) BirthDay() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s BenchmarkA) SetBirthDay(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s BenchmarkA) Phone() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s BenchmarkA) HasPhone() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s BenchmarkA) PhoneBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s BenchmarkA) SetPhone(v string) error {
	return s.Struct.SetText(1, v)
}

func (s BenchmarkA) Siblings() int32 {
	return int32(s.Struct.Uint32(8))
}

func (s BenchmarkA) SetSiblings(v int32) {
	s.Struct.SetUint32(8, uint32(v))
}

func (s BenchmarkA) Spouse() bool {
	return s.Struct.Bit(96)
}

func (s BenchmarkA) SetSpouse(v bool) {
	s.Struct.SetBit(96, v)
}

func (s BenchmarkA) Money() float64 {
	return math.Float64frombits(s.Struct.Uint64(16))
}

func (s BenchmarkA) SetMoney(v float64) {
	s.Struct.SetUint64(16, math.Float64bits(v))
}

// BenchmarkA_List is a list of BenchmarkA.
type BenchmarkA_List struct{ capnp.List }

// NewBenchmarkA creates a new list of BenchmarkA.
func NewBenchmarkA_List(s *capnp.Segment, sz int32) (BenchmarkA_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 2}, sz)
	return BenchmarkA_List{l}, err
}

func (s BenchmarkA_List) At(i int) BenchmarkA { return BenchmarkA{s.List.Struct(i)} }

func (s BenchmarkA_List) Set(i int, v BenchmarkA) error { return s.List.SetStruct(i, v.Struct) }

func (s BenchmarkA_List) String() string {
	str, _ := text.MarshalList(0xde2a1a960863c11c, s.List)
	return str
}

// BenchmarkA_Promise is a wrapper for a BenchmarkA promised by a client call.
type BenchmarkA_Promise struct{ *capnp.Pipeline }

func (p BenchmarkA_Promise) Struct() (BenchmarkA, error) {
	s, err := p.Pipeline.Struct()
	return BenchmarkA{s}, err
}

type AllocBenchmark struct{ capnp.Struct }

// AllocBenchmark_TypeID is the unique identifier for the type AllocBenchmark.
const AllocBenchmark_TypeID = 0xecea3e9ebcbe5655

func NewAllocBenchmark(s *capnp.Segment) (AllocBenchmark, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return AllocBenchmark{st}, err
}

func NewRootAllocBenchmark(s *capnp.Segment) (AllocBenchmark, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return AllocBenchmark{st}, err
}

func ReadRootAllocBenchmark(msg *capnp.Message) (AllocBenchmark, error) {
	root, err := msg.RootPtr()
	return AllocBenchmark{root.Struct()}, err
}

func (s AllocBenchmark) String() string {
	str, _ := text.Marshal(0xecea3e9ebcbe5655, s.Struct)
	return str
}

func (s AllocBenchmark) Fields() (AllocBenchmark_Field_List, error) {
	p, err := s.Struct.Ptr(0)
	return AllocBenchmark_Field_List{List: p.List()}, err
}

func (s AllocBenchmark) HasFields() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AllocBenchmark) SetFields(v AllocBenchmark_Field_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewFields sets the fields field to a newly
// allocated AllocBenchmark_Field_List, preferring placement in s's segment.
func (s AllocBenchmark) NewFields(n int32) (AllocBenchmark_Field_List, error) {
	l, err := NewAllocBenchmark_Field_List(s.Struct.Segment(), n)
	if err != nil {
		return AllocBenchmark_Field_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// AllocBenchmark_List is a list of AllocBenchmark.
type AllocBenchmark_List struct{ capnp.List }

// NewAllocBenchmark creates a new list of AllocBenchmark.
func NewAllocBenchmark_List(s *capnp.Segment, sz int32) (AllocBenchmark_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return AllocBenchmark_List{l}, err
}

func (s AllocBenchmark_List) At(i int) AllocBenchmark { return AllocBenchmark{s.List.Struct(i)} }

func (s AllocBenchmark_List) Set(i int, v AllocBenchmark) error { return s.List.SetStruct(i, v.Struct) }

func (s AllocBenchmark_List) String() string {
	str, _ := text.MarshalList(0xecea3e9ebcbe5655, s.List)
	return str
}

// AllocBenchmark_Promise is a wrapper for a AllocBenchmark promised by a client call.
type AllocBenchmark_Promise struct{ *capnp.Pipeline }

func (p AllocBenchmark_Promise) Struct() (AllocBenchmark, error) {
	s, err := p.Pipeline.Struct()
	return AllocBenchmark{s}, err
}

type AllocBenchmark_Field struct{ capnp.Struct }

// AllocBenchmark_Field_TypeID is the unique identifier for the type AllocBenchmark_Field.
const AllocBenchmark_Field_TypeID = 0xb8fb64b8ed846ae6

func NewAllocBenchmark_Field(s *capnp.Segment) (AllocBenchmark_Field, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return AllocBenchmark_Field{st}, err
}

func NewRootAllocBenchmark_Field(s *capnp.Segment) (AllocBenchmark_Field, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return AllocBenchmark_Field{st}, err
}

func ReadRootAllocBenchmark_Field(msg *capnp.Message) (AllocBenchmark_Field, error) {
	root, err := msg.RootPtr()
	return AllocBenchmark_Field{root.Struct()}, err
}

func (s AllocBenchmark_Field) String() string {
	str, _ := text.Marshal(0xb8fb64b8ed846ae6, s.Struct)
	return str
}

func (s AllocBenchmark_Field) StringValue() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s AllocBenchmark_Field) HasStringValue() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AllocBenchmark_Field) StringValueBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s AllocBenchmark_Field) SetStringValue(v string) error {
	return s.Struct.SetText(0, v)
}

// AllocBenchmark_Field_List is a list of AllocBenchmark_Field.
type AllocBenchmark_Field_List struct{ capnp.List }

// NewAllocBenchmark_Field creates a new list of AllocBenchmark_Field.
func NewAllocBenchmark_Field_List(s *capnp.Segment, sz int32) (AllocBenchmark_Field_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return AllocBenchmark_Field_List{l}, err
}

func (s AllocBenchmark_Field_List) At(i int) AllocBenchmark_Field {
	return AllocBenchmark_Field{s.List.Struct(i)}
}

func (s AllocBenchmark_Field_List) Set(i int, v AllocBenchmark_Field) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s AllocBenchmark_Field_List) String() string {
	str, _ := text.MarshalList(0xb8fb64b8ed846ae6, s.List)
	return str
}

// AllocBenchmark_Field_Promise is a wrapper for a AllocBenchmark_Field promised by a client call.
type AllocBenchmark_Field_Promise struct{ *capnp.Pipeline }

func (p AllocBenchmark_Field_Promise) Struct() (AllocBenchmark_Field, error) {
	s, err := p.Pipeline.Struct()
	return AllocBenchmark_Field{s}, err
}

const schema_832bcc6686a26d56 = "x\xda\xacZ}t\x14U\x96\xbf\xb7\xaa\xbb+$\x9d" +
	"tW^eBB0\x12A\x9380!\xc1\x80\x8c" +
	"n\x08&\x0a\x1e\xd04\x0d\"\xee0RI*Ic" +
	"\xa7;\xd3]\x0d\x89\x0e\x07\xdd\x91\xf1\xe3\xc8\x8e\x1ea" +
	"\x14\x95Y\xcc\xc2\x0e\xa8\xb8\xe2\xc0\xae\xb2\x0c#\x8e:" +
	"\x10eG\\\xf1\x83\x05\x14\x14\x15\x94\x1dqd\x85\x11" +
	"\xac=\xf7uWW\xa5S-\xca\xd9\x7fH\xf1~\xb7" +
	"\xee\xbb\xef~\xbf[]s\xd8;E\x18\xef\xfe\xad\x02" +
	"\x10\xf8\xdc\xed1^>u\xfc\xad\x9a\xdb\xc6,\x83\x80" +
	"\x0f\xd1\xb8\xa1\xbb\xff\x97\x1d\xaf]\xfa\x0bpI\x00\xec" +
	"\xf2\xdc\x01\xd6\x9cKO\x8d\xb9\x0d\x80\xc6\xfcW\xfd?" +
	"\x1d\xb6m\xda]\x19\xb4n\x91H\xd4\xdc\xad,\xc4\x89" +
	"\xb5\xdc\x8f\x01\x8dw~\xf7M\xcdE\x0d\x7f\xbc\x0bd" +
	"\x9f\x9d\x16%\x80\xba\xf9y\x85\xc8\xba\xf3\x888\x94G" +
	"\x9c'\xf7N\xa9\x7fv\xf7\xa8\xbb387I\x02\x00" +
	"[\x957\xc0\xd6q\xe2\xc7\xf3\x16\x03\x1a\xfd\x7f\x1d\xf1" +
	"\xf6\xe6\x9b\x7fp/\xc8\x0aB\x8a\xe3\xd9<\x01\x01\x19" +
	"z\x89\xdb\x841\x95GwT\x04\xff\x11d\x9fh1" +
	"\x03d\xa3\xbc\xfd\xac\xcaK\x9c\xc6x\xafa3\xe9\xc9" +
	"\xb8\x7fg\xf9+\x8d\xb7=\xfd\xab\x0c9\x05\xa2\xba\xcc" +
	"{\x985r\xfa+\xbd\xb4\xb3\x11{\xedX`\xd5\xae" +
	"\x07\x07\xd3r]\xad\xf3\xbe\xc86z%\x10\x0d\xef\x9b" +
	"\xbf~\xa9\xf0\xc9\x9a\x15 \xfb\\\x83v\xbf\xc7;\xc0" +
	"V\x12\xb7\xe0\xfd^\x11\x83Oy\x05\x040\x96\x8f\xca" +
	"\x99pj\xc9\x1fV8\xe8\x89m\xf0\x0e\xb0-|\xff" +
	"M\xfc`\xb7D\x16(\x0d\xdfl_\xe9\xa4\xd3=\xde" +
	"Bd\x878\xf1\x01N\xbc\xfc\xae\xf2W\xa6\xdd\xf3\xc1" +
	"C\xa4S!\xf3d\xf9\xf9/\xb2\xa2|zO\xce/" +
	"G@c\xdeS\xc2\xa3\x0f\xad\xda\xf2\x88\x93\x18U\x05" +
	"\x03\xec\xb2\x02z\x1a_@\x9cW\xdfv\xe0\xf9\xaa\xb7" +
	"'>j7\xc0\xbc\x82\\2\x80\xca\x09v\xce9\xec" +
	"\xdez\xc9\xaf\x1e\x1d\xa2\x82;\x0a\x06\xd8r\xe2\x14\xbc" +
	"\xbb@\xc4\xe0\x8a\x02\xae\x82\xc4\x8f]\xbf4jkV" +
	"g\xfa\x15\xdf|Y\xc1\x00{\x80o\xbe\xbc\x80l\xf0" +
	"\xd0\x05{~\xd4rZ[\x0b\x812D\xe0\xca\xaf;" +
	"Z\x10\xa3\xcdO\xf2\xcd;\xa6u~\xf1\x0d\xfb\xc3z" +
	"\xa7\x93\x14\xf9^d#}\xf4T\xe2#\xda\x0bw\x16" +
	"\xf7\xde\xfc\xde\xd3O\x0e\xf1\x94\xcb}\x87Y3'l" +
	"\xf4]\xc3\xba\xe9\xc98\xb1df\xf5\xd49\xaf?\xe9" +
	"\xa4\xfd9\xbeRd\x1a\x7fA\xe5\x9c\x9f\xff\xf4\x99h" +
	"\xf3\xbe\xbb6:I\xf1\x80\xaf\x9f\xad\xe2\xb4+9\xad" +
	"\xdc\xd3\xfev\xc4\xfd\xd4&'\xda-\xbe/\xd8\x0eN" +
	"\xfb{N\xbb\xb4\xfe\xa7w\xce\x9f\xf4\xf9&\xd2\x95\x98" +
	"\x19\x83\xc7}o\xb0\xd3D\\w\xd27\x97\xac\x1a\x1f" +
	"\x98`|v\xf8\x82\x7fs\xf2\x81:U\x16\x90u\xcb" +
	"<\x0ae\x0a\xd9\xb5\xff\xb2u\xcc+\xdd\x97\xfe;\x04" +
	"d\x14\x8dw\xd7\xbc\xf5\xe3\x87\x8e^|\x0c\x8aPB" +
	"\x0a\x81\xc2'\x00\xd9\x95\x85d\x84\x8f\x16\xdey\xfc\xb9" +
	"\xf6\xaf\x9f\x03\xf9\x024\xe6\xdc\xb0}\xdbo\xfe\xee\xd8" +
	"g)U\xac*\xac@\xb6\xa1\x90\x07E!\x89\xbc\xed" +
	"\x85\x85e%\xab\xc7\xbd\xe0t\xbc]\x85\x03l/\xa7" +
	"\xdd\xc3i\xfb\xf3\xbe\xe8?\xad\xed\xfb\x93\x13-\xb2'" +
	"\xd80FOnF\xb4cg^\xfe\xfb\x0f\x9e\xfc\xfb" +
	"]N\x91;\x86\x0d\xb0\xf1\x9cv,#\x81\xb7~\xf5" +
	"\xde\xde\x9b\x17\xed\x7f\xd5\xc9v\xf7\xb0Rd\xab8\xf1" +
	"J\xce\xf8\xe1\x976\xe4}$7\xbd\xe6$\xc4\xcbl" +
	"+\xdb\xcdiwq\xda\xf7/\x9e\xb4\xe0\x83g\x7f\xe7" +
	"H{\x96\xf53\xb7\xc2EW\x88vz\xcb\xe1w\x0f" +
	"?\xdd\xf4\x9f\x8e\xb6\x1b\xa5\x1ccc\x89\xb8\xaeJ\xe1" +
	"\xb6\xdby\xfb\x8e\xb2\x81c\x8f\xfe\xd9I\xe4eE\x85" +
	"\xc8V\x16qg*\"\xd6\xdb\xf7\xdd}b\xed\xd7\xf5" +
	"o9\x89\xb1\xa3\xe8\x11\xb6\x8b\xd3\xbe\xcci\x1f\x98\xf8" +
	"\xdb\x05\x91?o{\x87\xc4pe*\xeeH\xd1\x00;" +
	"A\xc4u\xc7\x8b\xb8\x18\xcb_}w\xf1\xdd\x0b\xee{" +
	"\xd7\x89s\xa0\xb8\x9f\xcd+\xa6\xa79\xc5\xc4\x99-\xfa" +
	":\xd4\xd1\xb8\xe7\x80\x93E\x12\xc5\xfdl\x09\xa7\xed+" +
	"&\x8b\x94\xedh\xcb\xf9ui\xf5\xc1Le$\xa5(" +
	"~\x83\x9d(\xe6R\x14s)V\xcf\x9e\xbb\xf1?\x9e" +
	"n9\xe8T\xa6\x1aK\x9e`\xd3K\xe8\xa9\xb9\xe4_" +
	"\x01\x8d\x07k\xd6\xff\xed\x8a7\x7fs\xd0Iq\x07J" +
	"r\x91\x1d\xe7\xc4GKH\xe4\x8d\xdb%y\xef\x9e\xfe" +
	"CN\xc7+)\xdd\xcaF\x95\xd2\xd3\xc8R\xa2U\x83" +
	"u\x85/\x1f\xdb\xe5H\xdb\\\xfa\x08\x9b\xc9i\xa7s" +
	"\xdaS\xf3\xd6\xfc\xe2\xb1\xfe\x9c#NB\x84J\x0b\x91" +
	"\xf5q\xe2\x04'\xde\xf4\xa79\x07\x9f\xf6_w$\xe3" +
	"t\xcd(\xb9(\x8aJ_d\x1b9\xf5\x86R\x0a\xd3" +
	"Q?:5\xe2\xcc\xb2\xf9\xc4Z\x18\x94\xb4\x96\x8c\xd8" +
	"\xca\x96\x8d \xc2;F\x90\"\xf6{N\xff\xd3\x9dK" +
	"\xef\xc8\x94\x81\xbb\xdb\xde\x11\x03\xec\x10\xa7=\xc0i\xe7" +
	"u\x95\xfee\xf2\xa7w~\xe4t\xb6ue\xfb\xd8\xa6" +
	"2z\xdaX\xc6\xcb\xd0\xde\xedk7\x96\xfe\xec\xe3!" +
	"\xe9}o\xd9\x00;D\x84\xc1\xfde\"\x06?)\xe3" +
	"\xe9=\x9dH\x06[\xba\x19\xa5\xb1\xb4}\xd9\xbd\xec\x08" +
	"\xbdSw\xa8\xec\xbda`K'\x0e\x92\xdcQ\xf9\x05" +
	"[^YL\x91ZI\x92\x94\xe5\xcc\x9f:l\xe3\xf5" +
	"'\x1c#\xb5r\x1f\xdbSIO\xbb9\xed\xc3%\x85" +
	"\xf7~\xf9\x0fw\x9d\x04\xb9\xcc\xac\x1bg+\x17\"\xb8" +
	"\x8c\xb3\x1d\xd7\xecj\xde\xef\xfe*#Kr\xe7:Z" +
	"\xf9\x06;\xc9\xb9\x9c\xa8$\xb7]8<|\x8d\xd2d" +
	"|\xe5\xb4\xe3\xcc\xaa7\xd8\xbc*\x1e\x0eU\xb4\xe3\xc1" +
	"\x19\xdb\x1f\xac\xd4\xff\xf9\x8c\x93\xd3\xae\xaaz\x83\xad\xe3" +
	"\xb4\x8fW5\xc0XC\x0d\xc5\xdabj\x87.\x8ck" +
	"S{\"=\x93\x83\xba\xdavK(\xd29\x15\xa0\x05" +
	"1\xe0\x12]\x00.\x04\x90\xf3+\x00\x029\"\x06\x14" +
	"\x01\xa5H\xa2\x1b] \xa0\x8b\xbc3\xc5\x01S\x1c\xae" +
	"j\x88&\"\xba\x16\xa3\xd7\xfd\xe9\xd7\xd5j\x80\xc0O" +
	"D\x0ct\x09\x88\xa8P\x09\x95\xb5Z\x80\xc0\x02\x11\x03" +
	"a\x01e\x01\x15\x14\x00\xe4\xd0\xb5\x00\x81.\x11\x03w" +
	"\x0a(\x8b\x82\x82\"\x80|\xc7T\x80\xc0\xcfE\x0c<" +
	",\xa0/\x1e\xbaUC7\x08\xe8\x06,_\x1c\x8d\xb5" +
	"\xc7\xd1\x0b\x02z\x01\x0d\xfa_8\x14\xd7\x01\x00\x0b\x00" +
	"[D\xe4P\x01\xe0\xd2\xd6\x90N\x88\xb9\x8c\xc9\xe5\xb4" +
	"\xf4bJ\xfai\xd1p{\xfc\x06-6{qt\xf6" +
	"\xe2hK8\x81\xf1\x0c=LN\xe9a\xb4\x80\x0d\xdd" +
	"}v\x9e~+\xd3\x02\x0e\xe2nj\xf7\x86h\xa8}" +
	"N$\x14\x8d$\xb5\x9b#\xba\xbc\x86\xc1\xd9V\x15\x02" +
	"\x04F\x8b\x18\xa8\x110\x1f\xbf1\x92\x1a\x1aK\xab\x95" +
	"\"\x06&\x08\x88*x\xb0\x15<CDnn\xeb\x8a" +
	"\x8e\xd3\xda\xba\xa2\xa3[\xd4\x98\xda\x1d\x07\xbb\xb4\xa5\x96" +
	"\xd5\xc4P$\xad\xa8L\xa35Km]\xd1\xe4A\xdd" +
	"\x00\xe9V\x17\xcd\x96K\x96\xabA\x90\xdd\x92\x8f\xf6\x99" +
	"\x82-\x88Y=g\x96\x14\x8d\xea\xa9\xd3!\xba\x10Q" +
	"\xaeZh\x1d\xc3\x9f2\xfe\xe5t\xb4\x09\"\x06\xa6\x08" +
	"h\xa8sCzW\x93\xd6\x01>5\x11\xd6\xd1o\xb5" +
	"f\x80\xe8\xe7\xca\xc2j\x00T\x87@\x0e:\xd6b\xcd" +
	"\xdd=z\x1f8\x09\xd9\x16\x8d\xc4\xf5\x19\xdcC\x88g" +
	"\xdap\xe9<\xcf\x0d\x072\x16\xcb9\xe8{O\xca\x19" +
	"A\xff\x949mr}Dk\xd1c\xdf\x1a&=z" +
	"\x0c\xfdV8f\x08\xec\xecr3Bq\xd4\xbf\x87\xcb" +
	"\xa5[\xad,.\xd7\xa4u\x90N\xe3\\N%\xc9\x13" +
	"Q^B\xf1\xd8\x9b\x0a3\x1e\x90\x88\xf22Z\xbc]" +
	"\xc4\xc0}\x02\xa2\xa0\xa0\x80(/\xa7 \xbd[\xc4\xc0" +
	"\x0a\x8aGTPD\x94\x1f\xa0S\xde\x97\x8cG\xd9%" +
	"(dfy%\xbd}\xbf\x88\x81\xc7\x04\xf4\xe9Z\xaf" +
	"\x9e\xf26\x90\xb1B\xea\x88F}\xed\xaa\xaeb>\x08" +
	"\x98Ok\xa5R\xab\x1a+\xef\x08GU\x1dsA8" +
	"\x91\xfb\xc7\x93\xd3\xa6\x00J\xa1\x88N\xb9\xe5\x84k\x99" +
	"a\x18\x80\xbe\x04-\xe4\x80 \xe7T;\x1conL" +
	"\xedI\x9a;\xd3\x10\xcf\x02\x04\xfc\"\x06\xca\x044\xba" +
	"C\x9d]\xfauQ\x1d\xa7j\xb345\x1c\xee+\xe7" +
	"\xef\xa0\xdf\xbaZe1\x8e\x15\\\xb3\xb48\xd7#d" +
	"\xb3v4\xa1\x0f\x89\xafA~\xd7\x1cIt'\xfd\xce" +
	"g\x15S@\xb7\x0f!{85\xa6SEj\xcf\xaa" +
	"\x0a+S\x98\x99\xd4\x9e'\xec\xc9\x19[\xd1o]\xb5" +
	"3\x8e\xe82\x13\xb6\x1a\x0e\x07\xb5\x9f%\xb4H\x9b6" +
	"\xaeS\xd3\xafKt\xb7j\xb1\xd1\xb3\xb4r~`\xfb" +
	"q\x0b\xad\xe3b\x84\x8c\x829\x0e\xa2\x93\xce\xa6\xaaq" +
	"-\xd3\"\xd5\xd6\xdb<\x8f\xa0l]\x99\x01Qv`" +
	"\x95\x96M\x8a\xb4iV~2k*\x9a\xb72Y\x9e" +
	"\x05\x82<L2L\xf9\x01c\x83\xd3Tf\xb4]\x1f" +
	"\xd1\x9aT]\x9d\x11\x12\xe3\xdf'\xdc\xec\xc1\\\xe0\x90" +
	"H\xa7IQ\xbd\xeb[\xce\xdd\xaa\xc65\xf4[\x97\xc5" +
	",I\x8cRTP\x8f%\xda\xca\xf5\xab\xd4\x9eH\x96" +
	"\x1c3Z@i\x91\xd6fI\x97\xeeK\xb2$\x83Y" +
	"ZgL\x8b\xc7CQ\xe4,\x87\xa7Y\xae\"\x19W" +
	"\x88\x18Xc9\xd5j\xaa\x1d\x0f\x8b\x18Xk+\xcf" +
	"\x8f\x13\xe1c\"\x06\x9e\xb3\x95\xe7-\xa4\xb1gD\x0c" +
	"\xbcF\xe9\x00\x15t\x01\xc8\xbbH\xca\x97D\x0c\xbc." +
	"\xa0\xec\x16\x14t\x03\xc8\xbbiq\xa7\x88\x817-]" +
	"\xa4\xef\x05I]\x88\xad5\x98\x07\x02\xe6\x01\xfaZ5" +
	"]5O\x97\x97\xac\xd8\x0d=a5\xa2\xc5\xad3\xa7" +
	"\x9b\xd8\xe4\x99\xa5\xbe\xee\x84\xf9\xbe\xd4\x17o7\x9f\x87" +
	"8B2\xe3\x92\x0fP\xa1\xd7c\x90\xd1\xb0TX\x0d" +
	"\x8b\x9c\xeeX*\xac\x8e\x85'HjXH#\xed\"" +
	"\x06z\xcc\x04\x09 wW\xa7\xba\x18\x9dL\xa4\x86Q" +
	"\x04\x01E@\xa9=\x115{\x17_\x8f\x1e\x1b?\xb4" +
	">\xd0r\xed\xb7\x94\x0d\xd3\xd3n\xf2\x8d\xeb\x8c\xf5P" +
	"b\xa0\x92ZM\x99\xa1\xd6\xca\x0c2\x89w)\xa5\x86" +
	"\xc9Vj(\xef\x08\xc5\xe2:\x0e\x03\x01\x87\x016\xc4" +
	"\xb5\xb6h\xa4\xdd\xfc\xef\x10\x055\x86\xc3\xd1\xb6\xa9Z" +
	"\xa4\xad\xab[\x8d\xdd2\xee\xea\x90\xa4\x85\xdb3<\xb1" +
	"\x15 \xe0\x1510\\@#\xae\xc7B\x91\xce\x1bT" +
	"\x90\xc2\x09-k&4\x93C|H\xc2\xae\xb5\xbc\xba" +
	"\x9c\\\xc3fc{\xb8\x148\xea\x82j\xcb\xb7\x84\x9d" +
	"\xad\xf48v\x0c)\x17\xc8L\xb5\xd5v\x85\x9a\xb9\xb6" +
	"\xdaR\xe8y\x9a\xd0\xa1\xf2\x9fO.J\xdf\x1f\xb2i" +
	"\xa5!\xae\xc5\x16%;q\x07\x9bU\x0ah,VC" +
	"z(\xd2\xb9\x10\xa4h\xabM\xdf\xe9\x0bu\x16\xceS" +
	"\xa5\x89u\x13\xcf\x9d\xe52\";\x8b\xe2g/\x8e\xfa" +
	"Z\xc2\x89xFF\xaa\xb02RZ\xf7\xab+\xac\x94" +
	"d\xc6_:#\xad\xb7\xc5\xdf:Z\\#b\xe0)" +
	"\xb3A\x01\x907\xd0\xdbkE\x0c<c\xcbH\x1b\x89" +
	"r\xbd\x88\x81\x97\xce\x1d\xa9\xf6^\xcbf\xe6\x8ceI" +
	"\x8f\xa5\xef'\xbep\\\xaf3\xf5\xea>\xf7\x9d\xa3E" +
	"\x8f}\xdf\x060=\x8e\xcaf+Q\xed\xcc`7\xd5" +
	"2\xd5\xd2\xb6\xe4m\x0d\xfd\xd6\x98=\x8b\xb5Z(\xf1" +
	"\xf2\xba\x0e\xd9\x8b\x87e\xaa\xda\x94\xa96[\xa6\xdaD" +
	"\xe7x\xca,\x1eS2\x8a\xc76\x9b\xa9\x9e\xa7[\xe0" +
	"sI\xab\xc8n1i\xaa\x1d\xb4\xf8B\xb2\xcc\xf8\"" +
	"jw:\xc9\x94wE\xbb\xadt1\xa8\xb9\xe2%#" +
	"\xa6\x92\x93\x9b6ihS#W\x87\xfb\xf8\x15\x90:" +
	"\xaf6\xb5Gm\x0bQ\x07\x09&\x89\xd1\xad\xf6\x06{" +
	"4\xad\x9d\xd62\x0b\x88\xa9\xd8F\xa9\xae\xb6\xe6\xfc\x83" +
	" \x1d\xa5\xd2\xc2hk\xf6\x16oh\xdei\x12Pj" +
	"\xebn7\x0f\xefSc\x9d\xf1\x8c\xdb\xee\x10\xdb\xa5\xd3" +
	"86~\x87\xc2\x7f\xad-\xa2\xcc\xc2\xbf\xae\xd6\x16Q" +
	"f\xe1\xdfpm*x6\x93\xed\x16$m7\xc8\xca" +
	"f\x98m\xa9\xb5\xac<\xc8vFk(\xa6w5\xa9" +
	"v\xf5\x97\xf7tE#\x16E<\xd4\x1a\x0eE:\xe3" +
	"D\x91jl\x1b\xe2=\xd1D\\3mX\xde\x1d\x8d" +
	"h}Y-\xc5\xcb\x03o\x1f\xbd\xe9\x837\xd3\xc1\xa7" +
	"\x88\x18\x98\x91*\x96\xb48\x9d\xa4l\x121\xd0B'" +
	"\x17\x93'\x9fI\xd6\x98&b`\xb6\x80\xbe>M\x8d" +
	"\x99)\x82v\xd5\xbb\xd0\x03\x02z(a\xa8}\xe6s" +
	"\xd6\x10\xe7\xd7\x8e\xf4\xfd\xf3\xbb\x86\xb8\xfd\x92\xe2\x14\xe2" +
	"s\x1bbjOmo\xedy\xdd\x802\xb2\xd7\x10\xe6" +
	"W\x8b\xe3\xeb\xcf\xdf\xcb\x1d\xda\xee\xf3\xc8q\xe9\x8fU" +
	"Y\xfa\xda\xc6\xd4\xff\xcd\x1e\xce\x9c\xaa\xd8\xa7N\xd6T" +
	"E\xab\xb6\xba\xb8|\xe1\xac1\xb4\x8f\xcb\x17\xcf\x18\xa9" +
	"F\xae\xc2j\xe4|\x8b\xa2\xa1v\xf0\xf8Z'\xd6M" +
	"D\xbf5\x82OU\x03\xb5\xae\xb6\x86d5\x07\xd7\xa9" +
	"j\xd01\xbe\x1e\xfd\xd6\x0c7\x8b\x96\x1b\x1bB\xb1\x9e" +
	"h\x8c+\xa5,\xe9v\xd5\xfcR\xd4\\\x01\x80\x82|" +
	"%\xfd\x11\xe5\xcb\xe8\x8fK\x1eK\x7f\xdc\xf2\x18\xfa\xe3" +
	"\x91GV\x03\xf8\"\xd1\x88&-\xec\xb8E\x0a\xab\xbd" +
	"R\xbc#*\x85\x13\x8b\xa4\xf6\x8e\xc5>]\x8b\xebC" +
	"\x14\xc6\xcd1[\xebM\xf9\xa1-,*\xeca\x91J" +
	"\x08\xd3+Ra\xb1\x80\xc2\"\x95\xcc\xe7\x93\xc1nL" +
	"N\x10$=}\xdbG)lY.\x95\x8e\x1a\xc2q" +
	"\xdd\xb6z\x8e\\57\xe9\xcc=a1\x11?/\x8f" +
	"\xb6O\xe1\xfc\xd9.\xe3M\xaa\x9e,d\x19\xd3\x1f?" +
	"\x80?9\xf9\x19\x9aF\x92\xca\xda\x9c\xf6/v\xc0U" +
	"\x0d\x10|\xc7%b\xf0C\x97\xcd\xc5\xd8!W)@" +
	"p?\x01\x9f\xb8\x04\x1c)\x9c5\x92y\x94\x1dqU" +
	"\x00\x04\xdf'\xe43B\xc43F2\x99\xb2\xa3\x1c\xf9" +
	"\x90\x90\xcf\x09q}m$\xafR\xec8G>!\xe4" +
	"KB\xdc\x7f3\x92i\x95\x9d\xe0\xc8g\x84\x9c\"\xc4" +
	"s\xdap)\xe8\x01`'9\xf29!g\x08\x91N" +
	"\x199\x0a\x1f\x17\x9f\xe6\xb2}\xe9\x12q\x96[\xc0\x91" +
	"9_\xd169\x00\xec,\x7f\xe5\x14\xbd\xe2\"d\xd8" +
	"\xff\xd26\xc3\x00\x18\xba\x099CH\x0e!\xb9'i" +
	"\x9b\\\x00\xe6&d\x96[\xc4\xa0\x97\x80\xbc/i\x97" +
	"<\x006\xccM\xbb\xb8\x08\xf1\x13\xe2\xfd\xab1EA" +
	"/\x00\xcbw\x93\xd2r\x08Q\xdc\x02\xe6\xe7\x7fa(" +
	"\x98\x0f\xc0d\x0ex\x09\x18N@\xc1\x09C\xc1\x02\x00" +
	"V\xc4\x01?\x01e\x04\xf8>7\x14\xf4\x01\xb0\x12\xf7" +
	"d\x80\xa0B@\x0d\x01\xfe\xbf\x18\x0aY\x90\x8d\xe5@" +
	"%\x01M\x04\xc8\xffc((\x03\xb0F\x0e\\A\xc0" +
	"\x8d\x04\x14\x1e7\x14,\x04`s8\xd0B@\x98\x00" +
	"\xf6\x99\xa1 \x03`!\x0e\xb4\x13p;\x01\xca\xa7\x86" +
	"\x82\x0a\x00[\xe2\xae\x05\x08\xf6\x12\xb0\x82\x80\xa2c\x86" +
	"\x82E\x00\xec\x01\xfe\xc6}\x04\xac'\xe0\x07G\x0d\x05" +
	"\x7f\x00\xc0\xd6q`\x0d\x01\xdb\x08(\xfe\xc4P\xb0\x18" +
	"\x80=\xcf\x81\xcd\x04\xbcN\xc0\xf0\x8f\x0d\x05\x87\x03\xb0" +
	"\xdd|\x8f\x9d\x04|H@\xd9G\x86\x82%\xe4`\\" +
	"%\xfb\x098E\xc0\xc8#\x86\x82\xa5dw\xf7T\xb2" +
	";\xd7\x95G\xc0\xfc\x0b>4\x14\x1cA\xba\xf2\x10+" +
	"\xc5#b\xf0B\x02\xca?0\x14,\x03`#90" +
	"\x9c\x80\xd1\x04\\x\xd8Pp$\x00\x1b\xe5i\x05\x08" +
	"^H\xc0\x15\x04\x8c:d(x\x01\x00\xbb\xdcs-" +
	"@p\x12\x01M\x04T\xbco(XN\xda\xf5\xdc\x04" +
	"\x10\x9cB\xc0\x0c\x02.z\xcfP\xf0B\x006\xdd3" +
	"\x0b 8\x8d\x80\xd9\x1e\x01G\x8e>H\x0e4\x0a\x80" +
	"\x05<$\xef\x0cBn\xa4W\xc6\x1c0\x14\xac \x83" +
	"x\xe8\x84-\x04\xfc\x84\x80\x8b\xf7\x1b\x0a^\x04\xc0\xe6" +
	"q`6\x01\x0b\x08\xb8\xe4\xbf\x0d\x05G\x03\xb0\xf9\x1e" +
	"\xf2\xd2\x1b\x09h'\xa0r\x9f\xa1\xe0\x18\x00\xa6ry" +
	"\x17\x10\xf0s\x02\xaa\xde5\x14\xbc\x18\x80\xf5q\xa0\x97" +
	"\x80\x15\x04\x94\xbcc(x\x09\x99\x90Ku\x1f\x01\xeb" +
	"\x09(}\xdbP\xb0\x92L\xc8\x815\x04l#`\xc4" +
	"[\x86\x82UdB\x0el&\xe0u\x02\xaa\xf7\x1ah" +
	"\xfb\xb4\xcdv{*@\xc8\xbf\xf4MC\xc1\x1f\x02\xb0" +
	"-\xfc\x10\xcf\xa4\xf9\xfc\xf0\xbf\x0c\x05\xc7r>\xa4\xa9" +
	"\xe7\x08x\xc9\x93\xae9\xe2\xad\xb7\xa2\xdf\xfa\xa2e\x96" +
	"\x96\xfa\x09\xe9QGG]-\xe6\x82\x80\xb9\x80R\xa8" +
	"~\x82\xd9JI\xa1\xbaZ\xb3i\x92B\xe3\xeb\xcd\xde" +
	"E\x0cMB\x01\x04\x14\x00\xa5D\xfd\x04s\x08 %" +
	"\xeaj\xcd\xb9\x9e\x94\x18_\x8f\x12\x08(\x01\x8a\x89I" +
	"fo\xe3k\x8dF\xc3f\xe3e\x9f\xf3\xa2\xaf5\x1c" +
	"m5o\xd9\x0d\x1d\xf5\x13l\xb3)sz\xd3QW" +
	"k[\xcdM\xad\x86\x06\xd1\xba\xcd\xd5A\xb4.su" +
	"|\xbdmUL\xae\x96\x87&\xd9\x16\x85\x14ib\x10" +
	"\xdba\xe6\xea \xb69\xe6\xea \xb6R\x8am\xc2\xce" +
	"\xd6\x93\\\xf4\xdd:h\xe6f7J\x01\xe0RBm" +
	"\x04\xd9\xe8\xcao\xa5\x9etH\xf1I\xae\xab\xe8\xb7~" +
	"\x92\x90Q\xc5`\xf0\xc8/c\xfce\x91\x01d\xa0\xc4" +
	"$\x96\x1a\x00\x82\x18\x8d\xa0\xdf\xfaUG\x0a\xe6\xb3\xb5" +
	"V5\x0e\xe8\xd0\xd3-U\x93-J\xc6\x05\xcbG\x86" +
	"\xff\x7f\xe8\x88\xb8>\x16im\xb6ow\x99\xdfe\x92" +
	"Dj&\x91]S\xfcS_4\x1a\xb6\xe9(\xf5\xa9" +
	"oi\xeaUs9?\xb5L\x1el[Nu%R" +
	"g\xac'\xdb\x90Z3\xe7\xdb\x18G\xbf\xf53\x93," +
	"\xddFz\x8cV\xce/`\x01\x17\xda\x7f\xc7\x82\xb5\xe5" +
	"W\x87\xb4p{\xb6N\xb8\x83@\xdbd&\xfdf\x96" +
	"N\xf8:-\xaek\xb1\xf1W\xa9\xe2\x90\xa9q\xb5\xc5" +
	"\xd6\x17\xd7cY\xef\x8c\xe7\xf8.\xd0\xa2\xfabjw" +
	"<\xcb0\xa7I\xd5Q\xfd.\xb7\xd9\x0a\xdb\x17\x8b," +
	"c\x97\xa1\xe3\xeb\xb9\xb3\xb5\xb8~\x95\xda\x83\x99g\xbb" +
	")5\xd3\x9a$\xa0\x11\xd1\xe2\xfaLU\x8f\x81\x18\xea" +
	"\x1d\x12\x85\xe7\x9a\x90\xa7\xbf\x0c\xa0\xfa-\x1f\xf6l\x02" +
	"\xff_\x00\x00\x00\xff\xff\xf3\xa2\xdd\xc1"

func init() {
	schemas.Register(schema_832bcc6686a26d56,
		0x85257b30d6edf8c5,
		0x8748bc095e10cb5d,
		0x87c33f2330feb3d8,
		0x8821cdb23640783a,
		0x8a165fb4d71bf3a2,
		0x8e5322c1e9282534,
		0x8fae7b41c61fc890,
		0x93c99951eacc72ff,
		0x9430ab12c496d40c,
		0x94bf7df83408218d,
		0x95befe3f14606e6b,
		0x97e38948c61f878d,
		0x9ab599979b02ac59,
		0x9b37d729b9dd7b9d,
		0x9b8f27ba05e255c8,
		0x9d3032ff86043b75,
		0xa465f9502fd11e97,
		0xa8bf13fef2674866,
		0xabaedf5f7817c820,
		0xabd055422a4d7df1,
		0xad87da456fb0ebb9,
		0xb1ac056ed7647011,
		0xb1f0385d845e367f,
		0xb61ee2ecff34ca73,
		0xb72b6dc625baa6a4,
		0xb8fb64b8ed846ae6,
		0xc02e9d191c6ac0bc,
		0xc7da65f9a2f20ba2,
		0xc95babe3bd394d2d,
		0xcbdc765fd5dff7ba,
		0xcc4411e60ba9c498,
		0xccb3b2e3603826e0,
		0xce44aee2d9e25049,
		0xcf9beaca1cc180c8,
		0xd636fba4f188dabe,
		0xd8bccf6e60a73791,
		0xd98c608877d9cb8d,
		0xddd1416669fb7613,
		0xde2a1a960863c11c,
		0xde50aebbad57549d,
		0xde9ed43cfaa83093,
		0xe1a2d1d51107bead,
		0xe1c9eac512335361,
		0xe508a29c83a059f8,
		0xe54e10aede55c7b1,
		0xe55d85fc1bf82f21,
		0xe5817f849ff906dc,
		0xe684eb3aef1a6859,
		0xe7711aada4bed56b,
		0xea26e9973bd6a0d9,
		0xecea3e9ebcbe5655,
		0xf14fad09425d081c,
		0xf58782f48a121998,
		0xf705dc45c94766fd,
		0xf7ff4414476c186a,
		0xfca3742893be4cde)
}

var x_832bcc6686a26d56 = []byte{
	0, 0, 0, 0, 2, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 0, 0,
	223, 7, 8, 27, 0, 0, 0, 0,
	0, 0, 0, 0, 4, 0, 0, 0,
	1, 0, 0, 0, 23, 0, 0, 0,
	8, 0, 0, 0, 1, 0, 0, 0,
	223, 7, 8, 27, 0, 0, 0, 0,
	223, 7, 8, 28, 0, 0, 0, 0,
	0, 0, 0, 0, 3, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 1, 0,
	42, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 3, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 1, 0,
	42, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
}
