// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/repository.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Visibility int32

const (
	Visibility_VISIBILITY_UNSPECIFIED Visibility = 0
	Visibility_VISIBILITY_PUBLIC      Visibility = 1
	Visibility_VISIBILITY_PRIVATE     Visibility = 2
)

// Enum value maps for Visibility.
var (
	Visibility_name = map[int32]string{
		0: "VISIBILITY_UNSPECIFIED",
		1: "VISIBILITY_PUBLIC",
		2: "VISIBILITY_PRIVATE",
	}
	Visibility_value = map[string]int32{
		"VISIBILITY_UNSPECIFIED": 0,
		"VISIBILITY_PUBLIC":      1,
		"VISIBILITY_PRIVATE":     2,
	}
)

func (x Visibility) Enum() *Visibility {
	p := new(Visibility)
	*p = x
	return p
}

func (x Visibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Visibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes[0].Descriptor()
}

func (Visibility) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes[0]
}

func (x Visibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Repository struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                 string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime         *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime         *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Name               string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_Owner              isRepository_Owner     `protobuf_oneof:"owner"`
	xxx_hidden_Visibility         Visibility             `protobuf:"varint,7,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_Deprecated         bool                   `protobuf:"varint,8,opt,name=deprecated,proto3"`
	xxx_hidden_DeprecationMessage string                 `protobuf:"bytes,9,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	xxx_hidden_OwnerName          string                 `protobuf:"bytes,10,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Description        string                 `protobuf:"bytes,11,opt,name=description,proto3"`
	xxx_hidden_Url                string                 `protobuf:"bytes,12,opt,name=url,proto3"`
	xxx_hidden_DefaultBranch      string                 `protobuf:"bytes,13,opt,name=default_branch,json=defaultBranch,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *Repository) Reset() {
	*x = Repository{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository) ProtoMessage() {}

func (x *Repository) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Repository) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Repository) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Repository) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *Repository) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Repository) GetUserId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Owner.(*repository_UserId); ok {
			return x.UserId
		}
	}
	return ""
}

func (x *Repository) GetOrganizationId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Owner.(*repository_OrganizationId); ok {
			return x.OrganizationId
		}
	}
	return ""
}

func (x *Repository) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *Repository) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *Repository) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *Repository) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *Repository) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *Repository) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *Repository) GetDefaultBranch() string {
	if x != nil {
		return x.xxx_hidden_DefaultBranch
	}
	return ""
}

func (x *Repository) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Repository) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Repository) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *Repository) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Repository) SetUserId(v string) {
	x.xxx_hidden_Owner = &repository_UserId{v}
}

func (x *Repository) SetOrganizationId(v string) {
	x.xxx_hidden_Owner = &repository_OrganizationId{v}
}

func (x *Repository) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *Repository) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *Repository) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

func (x *Repository) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *Repository) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *Repository) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *Repository) SetDefaultBranch(v string) {
	x.xxx_hidden_DefaultBranch = v
}

func (x *Repository) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Repository) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *Repository) HasOwner() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Owner != nil
}

func (x *Repository) HasUserId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Owner.(*repository_UserId)
	return ok
}

func (x *Repository) HasOrganizationId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Owner.(*repository_OrganizationId)
	return ok
}

func (x *Repository) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Repository) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

func (x *Repository) ClearOwner() {
	x.xxx_hidden_Owner = nil
}

func (x *Repository) ClearUserId() {
	if _, ok := x.xxx_hidden_Owner.(*repository_UserId); ok {
		x.xxx_hidden_Owner = nil
	}
}

func (x *Repository) ClearOrganizationId() {
	if _, ok := x.xxx_hidden_Owner.(*repository_OrganizationId); ok {
		x.xxx_hidden_Owner = nil
	}
}

const Repository_Owner_not_set_case case_Repository_Owner = 0
const Repository_UserId_case case_Repository_Owner = 5
const Repository_OrganizationId_case case_Repository_Owner = 6

func (x *Repository) WhichOwner() case_Repository_Owner {
	if x == nil {
		return Repository_Owner_not_set_case
	}
	switch x.xxx_hidden_Owner.(type) {
	case *repository_UserId:
		return Repository_UserId_case
	case *repository_OrganizationId:
		return Repository_OrganizationId_case
	default:
		return Repository_Owner_not_set_case
	}
}

type Repository_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique, immutable
	Id string
	// immutable
	CreateTime *timestamppb.Timestamp
	// mutable
	UpdateTime *timestamppb.Timestamp
	// unique, mutable
	Name string
	// Fields of oneof xxx_hidden_Owner:
	// foreign key, mutable
	UserId *string
	// foreign key, mutable
	OrganizationId *string
	// -- end of xxx_hidden_Owner
	Visibility Visibility
	// deprecated means this repository is deprecated.
	Deprecated bool
	// deprecation_message is the message shown if the repository is deprecated.
	DeprecationMessage string
	// owner_name is the name of the owner of the repository,
	// either a username or organization name.
	OwnerName string
	// description is the user configurable description of the repository.
	Description string
	// url is the user configurable URL in the description of the repository,
	// always included the scheme and will not have a #fragment suffix.
	Url string
	// default_branch in a BSR repository. It is used when syncing a git repository, to make sure both
	// default branches (BSR and Git) are in sync. By default, every BSR repository is created with a
	// "main" default branch.
	DefaultBranch string
}

func (b0 Repository_builder) Build() *Repository {
	m0 := &Repository{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Name = b.Name
	if b.UserId != nil {
		x.xxx_hidden_Owner = &repository_UserId{*b.UserId}
	}
	if b.OrganizationId != nil {
		x.xxx_hidden_Owner = &repository_OrganizationId{*b.OrganizationId}
	}
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_DefaultBranch = b.DefaultBranch
	return m0
}

type case_Repository_Owner protoreflect.FieldNumber

func (x case_Repository_Owner) String() string {
	md := file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isRepository_Owner interface {
	isRepository_Owner()
}

type repository_UserId struct {
	// foreign key, mutable
	UserId string `protobuf:"bytes,5,opt,name=user_id,json=userId,proto3,oneof"`
}

type repository_OrganizationId struct {
	// foreign key, mutable
	OrganizationId string `protobuf:"bytes,6,opt,name=organization_id,json=organizationId,proto3,oneof"`
}

func (*repository_UserId) isRepository_Owner() {}

func (*repository_OrganizationId) isRepository_Owner() {}

type RepositoryCounts struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TagsCount   uint32                 `protobuf:"varint,1,opt,name=tags_count,json=tagsCount,proto3"`
	xxx_hidden_DraftsCount uint32                 `protobuf:"varint,3,opt,name=drafts_count,json=draftsCount,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *RepositoryCounts) Reset() {
	*x = RepositoryCounts{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryCounts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryCounts) ProtoMessage() {}

func (x *RepositoryCounts) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryCounts) GetTagsCount() uint32 {
	if x != nil {
		return x.xxx_hidden_TagsCount
	}
	return 0
}

func (x *RepositoryCounts) GetDraftsCount() uint32 {
	if x != nil {
		return x.xxx_hidden_DraftsCount
	}
	return 0
}

func (x *RepositoryCounts) SetTagsCount(v uint32) {
	x.xxx_hidden_TagsCount = v
}

func (x *RepositoryCounts) SetDraftsCount(v uint32) {
	x.xxx_hidden_DraftsCount = v
}

type RepositoryCounts_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	TagsCount   uint32
	DraftsCount uint32
}

func (b0 RepositoryCounts_builder) Build() *RepositoryCounts {
	m0 := &RepositoryCounts{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TagsCount = b.TagsCount
	x.xxx_hidden_DraftsCount = b.DraftsCount
	return m0
}

type RepositoryContributor struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User         *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,2,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_ExplicitRole RepositoryRole         `protobuf:"varint,3,opt,name=explicit_role,json=explicitRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_ImplicitRole RepositoryRole         `protobuf:"varint,4,opt,name=implicit_role,json=implicitRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *RepositoryContributor) Reset() {
	*x = RepositoryContributor{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryContributor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryContributor) ProtoMessage() {}

func (x *RepositoryContributor) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryContributor) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *RepositoryContributor) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *RepositoryContributor) GetExplicitRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ExplicitRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *RepositoryContributor) GetImplicitRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ImplicitRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *RepositoryContributor) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *RepositoryContributor) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *RepositoryContributor) SetExplicitRole(v RepositoryRole) {
	x.xxx_hidden_ExplicitRole = v
}

func (x *RepositoryContributor) SetImplicitRole(v RepositoryRole) {
	x.xxx_hidden_ImplicitRole = v
}

func (x *RepositoryContributor) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *RepositoryContributor) ClearUser() {
	x.xxx_hidden_User = nil
}

type RepositoryContributor_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
	// The ID of the for which the role belongs to.
	RepositoryId string
	// The role that the user has been explicitly assigned against the repository.
	ExplicitRole RepositoryRole
	// Optionally defines the role that the user has implicitly against the repository through the owning organization.
	// If the repository does not belong to an organization or the user is not part of the owning organization, this is unset.
	ImplicitRole RepositoryRole
}

func (b0 RepositoryContributor_builder) Build() *RepositoryContributor {
	m0 := &RepositoryContributor{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_ExplicitRole = b.ExplicitRole
	x.xxx_hidden_ImplicitRole = b.ImplicitRole
	return m0
}

type RepositoryMetadata struct {
	state                              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                      string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name                    string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_OwnerName               string                 `protobuf:"bytes,3,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OwnerVerificationStatus VerificationStatus     `protobuf:"varint,4,opt,name=owner_verification_status,json=ownerVerificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	xxx_hidden_LatestCommitTime        *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=latest_commit_time,json=latestCommitTime,proto3"`
	xxx_hidden_LatestSpdxLicenseId     string                 `protobuf:"bytes,6,opt,name=latest_spdx_license_id,json=latestSpdxLicenseId,proto3"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *RepositoryMetadata) Reset() {
	*x = RepositoryMetadata{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryMetadata) ProtoMessage() {}

func (x *RepositoryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryMetadata) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RepositoryMetadata) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *RepositoryMetadata) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *RepositoryMetadata) GetOwnerVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_OwnerVerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *RepositoryMetadata) GetLatestCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_LatestCommitTime
	}
	return nil
}

func (x *RepositoryMetadata) GetLatestSpdxLicenseId() string {
	if x != nil {
		return x.xxx_hidden_LatestSpdxLicenseId
	}
	return ""
}

func (x *RepositoryMetadata) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RepositoryMetadata) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *RepositoryMetadata) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *RepositoryMetadata) SetOwnerVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_OwnerVerificationStatus = v
}

func (x *RepositoryMetadata) SetLatestCommitTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_LatestCommitTime = v
}

func (x *RepositoryMetadata) SetLatestSpdxLicenseId(v string) {
	x.xxx_hidden_LatestSpdxLicenseId = v
}

func (x *RepositoryMetadata) HasLatestCommitTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LatestCommitTime != nil
}

func (x *RepositoryMetadata) ClearLatestCommitTime() {
	x.xxx_hidden_LatestCommitTime = nil
}

type RepositoryMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository.
	Id string
	// The name of the repository.
	Name string
	// The owner name of the repository.
	OwnerName string
	// The verification status of the owner of the repository.
	OwnerVerificationStatus VerificationStatus
	// The commit time of the latest main commit in the repository.
	LatestCommitTime *timestamppb.Timestamp
	// The SPDX license ID of the latest main commit in the repository.
	LatestSpdxLicenseId string
}

func (b0 RepositoryMetadata_builder) Build() *RepositoryMetadata {
	m0 := &RepositoryMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OwnerVerificationStatus = b.OwnerVerificationStatus
	x.xxx_hidden_LatestCommitTime = b.LatestCommitTime
	x.xxx_hidden_LatestSpdxLicenseId = b.LatestSpdxLicenseId
	return m0
}

type GetRepositoriesByFullNameRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullNames []string               `protobuf:"bytes,1,rep,name=full_names,json=fullNames,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetRepositoriesByFullNameRequest) Reset() {
	*x = GetRepositoriesByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesByFullNameRequest) ProtoMessage() {}

func (x *GetRepositoriesByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesByFullNameRequest) GetFullNames() []string {
	if x != nil {
		return x.xxx_hidden_FullNames
	}
	return nil
}

func (x *GetRepositoriesByFullNameRequest) SetFullNames(v []string) {
	x.xxx_hidden_FullNames = v
}

type GetRepositoriesByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// minimum length is 1
	// maximum length is 250
	FullNames []string
}

func (b0 GetRepositoriesByFullNameRequest_builder) Build() *GetRepositoriesByFullNameRequest {
	m0 := &GetRepositoriesByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullNames = b.FullNames
	return m0
}

type GetRepositoriesByFullNameResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositoriesByFullNameResponse) Reset() {
	*x = GetRepositoriesByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesByFullNameResponse) ProtoMessage() {}

func (x *GetRepositoriesByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesByFullNameResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *GetRepositoriesByFullNameResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

type GetRepositoriesByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
}

func (b0 GetRepositoriesByFullNameResponse_builder) Build() *GetRepositoriesByFullNameResponse {
	m0 := &GetRepositoriesByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	return m0
}

type GetRepositoryRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRepositoryRequest) Reset() {
	*x = GetRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryRequest) ProtoMessage() {}

func (x *GetRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *GetRepositoryRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type GetRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 GetRepositoryRequest_builder) Build() *GetRepositoryRequest {
	m0 := &GetRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type GetRepositoryResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	xxx_hidden_Counts     *RepositoryCounts      `protobuf:"bytes,2,opt,name=counts,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetRepositoryResponse) Reset() {
	*x = GetRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryResponse) ProtoMessage() {}

func (x *GetRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *GetRepositoryResponse) GetCounts() *RepositoryCounts {
	if x != nil {
		return x.xxx_hidden_Counts
	}
	return nil
}

func (x *GetRepositoryResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *GetRepositoryResponse) SetCounts(v *RepositoryCounts) {
	x.xxx_hidden_Counts = v
}

func (x *GetRepositoryResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *GetRepositoryResponse) HasCounts() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Counts != nil
}

func (x *GetRepositoryResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

func (x *GetRepositoryResponse) ClearCounts() {
	x.xxx_hidden_Counts = nil
}

type GetRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
	Counts     *RepositoryCounts
}

func (b0 GetRepositoryResponse_builder) Build() *GetRepositoryResponse {
	m0 := &GetRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Counts = b.Counts
	return m0
}

type GetRepositoryByFullNameRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullName string                 `protobuf:"bytes,1,opt,name=full_name,json=fullName,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetRepositoryByFullNameRequest) Reset() {
	*x = GetRepositoryByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryByFullNameRequest) ProtoMessage() {}

func (x *GetRepositoryByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryByFullNameRequest) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *GetRepositoryByFullNameRequest) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

type GetRepositoryByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	FullName string
}

func (b0 GetRepositoryByFullNameRequest_builder) Build() *GetRepositoryByFullNameRequest {
	m0 := &GetRepositoryByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullName = b.FullName
	return m0
}

type GetRepositoryByFullNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	xxx_hidden_Counts     *RepositoryCounts      `protobuf:"bytes,2,opt,name=counts,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetRepositoryByFullNameResponse) Reset() {
	*x = GetRepositoryByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryByFullNameResponse) ProtoMessage() {}

func (x *GetRepositoryByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryByFullNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *GetRepositoryByFullNameResponse) GetCounts() *RepositoryCounts {
	if x != nil {
		return x.xxx_hidden_Counts
	}
	return nil
}

func (x *GetRepositoryByFullNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *GetRepositoryByFullNameResponse) SetCounts(v *RepositoryCounts) {
	x.xxx_hidden_Counts = v
}

func (x *GetRepositoryByFullNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *GetRepositoryByFullNameResponse) HasCounts() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Counts != nil
}

func (x *GetRepositoryByFullNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

func (x *GetRepositoryByFullNameResponse) ClearCounts() {
	x.xxx_hidden_Counts = nil
}

type GetRepositoryByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
	Counts     *RepositoryCounts
}

func (b0 GetRepositoryByFullNameResponse_builder) Build() *GetRepositoryByFullNameResponse {
	m0 := &GetRepositoryByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Counts = b.Counts
	return m0
}

type ListRepositoriesRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListRepositoriesRequest) Reset() {
	*x = ListRepositoriesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesRequest) ProtoMessage() {}

func (x *ListRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoriesRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoriesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoriesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoriesRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoriesRequest_builder) Build() *ListRepositoriesRequest {
	m0 := &ListRepositoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoriesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListRepositoriesResponse) Reset() {
	*x = ListRepositoriesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesResponse) ProtoMessage() {}

func (x *ListRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoriesResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListRepositoriesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoriesResponse_builder) Build() *ListRepositoriesResponse {
	m0 := &ListRepositoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListUserRepositoriesRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId    string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListUserRepositoriesRequest) Reset() {
	*x = ListUserRepositoriesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUserRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserRepositoriesRequest) ProtoMessage() {}

func (x *ListUserRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUserRepositoriesRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *ListUserRepositoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListUserRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListUserRepositoriesRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListUserRepositoriesRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *ListUserRepositoriesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListUserRepositoriesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListUserRepositoriesRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListUserRepositoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the user whose repositories should be listed.
	UserId   string
	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListUserRepositoriesRequest_builder) Build() *ListUserRepositoriesRequest {
	m0 := &ListUserRepositoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListUserRepositoriesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListUserRepositoriesResponse) Reset() {
	*x = ListUserRepositoriesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUserRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserRepositoriesResponse) ProtoMessage() {}

func (x *ListUserRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUserRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListUserRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListUserRepositoriesResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListUserRepositoriesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListUserRepositoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListUserRepositoriesResponse_builder) Build() *ListUserRepositoriesResponse {
	m0 := &ListUserRepositoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListRepositoriesUserCanAccessRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListRepositoriesUserCanAccessRequest) Reset() {
	*x = ListRepositoriesUserCanAccessRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesUserCanAccessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesUserCanAccessRequest) ProtoMessage() {}

func (x *ListRepositoriesUserCanAccessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesUserCanAccessRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoriesUserCanAccessRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoriesUserCanAccessRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoriesUserCanAccessRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoriesUserCanAccessRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoriesUserCanAccessRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoriesUserCanAccessRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoriesUserCanAccessRequest_builder) Build() *ListRepositoriesUserCanAccessRequest {
	m0 := &ListRepositoriesUserCanAccessRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoriesUserCanAccessResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListRepositoriesUserCanAccessResponse) Reset() {
	*x = ListRepositoriesUserCanAccessResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesUserCanAccessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesUserCanAccessResponse) ProtoMessage() {}

func (x *ListRepositoriesUserCanAccessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesUserCanAccessResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListRepositoriesUserCanAccessResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoriesUserCanAccessResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListRepositoriesUserCanAccessResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoriesUserCanAccessResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoriesUserCanAccessResponse_builder) Build() *ListRepositoriesUserCanAccessResponse {
	m0 := &ListRepositoriesUserCanAccessResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListOrganizationRepositoriesRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_PageSize       uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken      string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse        bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ListOrganizationRepositoriesRequest) Reset() {
	*x = ListOrganizationRepositoriesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationRepositoriesRequest) ProtoMessage() {}

func (x *ListOrganizationRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationRepositoriesRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *ListOrganizationRepositoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListOrganizationRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListOrganizationRepositoriesRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListOrganizationRepositoriesRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *ListOrganizationRepositoriesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListOrganizationRepositoriesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListOrganizationRepositoriesRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListOrganizationRepositoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization whose repositories should be listed.
	OrganizationId string
	PageSize       uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListOrganizationRepositoriesRequest_builder) Build() *ListOrganizationRepositoriesRequest {
	m0 := &ListOrganizationRepositoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListOrganizationRepositoriesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListOrganizationRepositoriesResponse) Reset() {
	*x = ListOrganizationRepositoriesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationRepositoriesResponse) ProtoMessage() {}

func (x *ListOrganizationRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListOrganizationRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListOrganizationRepositoriesResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListOrganizationRepositoriesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListOrganizationRepositoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListOrganizationRepositoriesResponse_builder) Build() *ListOrganizationRepositoriesResponse {
	m0 := &ListOrganizationRepositoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type CreateRepositoryByFullNameRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullName   string                 `protobuf:"bytes,1,opt,name=full_name,json=fullName,proto3"`
	xxx_hidden_Visibility Visibility             `protobuf:"varint,2,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CreateRepositoryByFullNameRequest) Reset() {
	*x = CreateRepositoryByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRepositoryByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryByFullNameRequest) ProtoMessage() {}

func (x *CreateRepositoryByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateRepositoryByFullNameRequest) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *CreateRepositoryByFullNameRequest) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *CreateRepositoryByFullNameRequest) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

func (x *CreateRepositoryByFullNameRequest) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

type CreateRepositoryByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Must be unique across repositories.
	FullName   string
	Visibility Visibility
}

func (b0 CreateRepositoryByFullNameRequest_builder) Build() *CreateRepositoryByFullNameRequest {
	m0 := &CreateRepositoryByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullName = b.FullName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type CreateRepositoryByFullNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CreateRepositoryByFullNameResponse) Reset() {
	*x = CreateRepositoryByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRepositoryByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryByFullNameResponse) ProtoMessage() {}

func (x *CreateRepositoryByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateRepositoryByFullNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *CreateRepositoryByFullNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *CreateRepositoryByFullNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *CreateRepositoryByFullNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type CreateRepositoryByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
}

func (b0 CreateRepositoryByFullNameResponse_builder) Build() *CreateRepositoryByFullNameResponse {
	m0 := &CreateRepositoryByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	return m0
}

type DeleteRepositoryRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryRequest) Reset() {
	*x = DeleteRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryRequest) ProtoMessage() {}

func (x *DeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteRepositoryRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *DeleteRepositoryRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type DeleteRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 DeleteRepositoryRequest_builder) Build() *DeleteRepositoryRequest {
	m0 := &DeleteRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type DeleteRepositoryResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryResponse) Reset() {
	*x = DeleteRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryResponse) ProtoMessage() {}

func (x *DeleteRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteRepositoryResponse_builder) Build() *DeleteRepositoryResponse {
	m0 := &DeleteRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeleteRepositoryByFullNameRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullName string                 `protobuf:"bytes,1,opt,name=full_name,json=fullName,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DeleteRepositoryByFullNameRequest) Reset() {
	*x = DeleteRepositoryByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryByFullNameRequest) ProtoMessage() {}

func (x *DeleteRepositoryByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteRepositoryByFullNameRequest) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *DeleteRepositoryByFullNameRequest) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

type DeleteRepositoryByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	FullName string
}

func (b0 DeleteRepositoryByFullNameRequest_builder) Build() *DeleteRepositoryByFullNameRequest {
	m0 := &DeleteRepositoryByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullName = b.FullName
	return m0
}

type DeleteRepositoryByFullNameResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryByFullNameResponse) Reset() {
	*x = DeleteRepositoryByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryByFullNameResponse) ProtoMessage() {}

func (x *DeleteRepositoryByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteRepositoryByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteRepositoryByFullNameResponse_builder) Build() *DeleteRepositoryByFullNameResponse {
	m0 := &DeleteRepositoryByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeprecateRepositoryByNameRequest struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName          string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName     string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_DeprecationMessage string                 `protobuf:"bytes,3,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *DeprecateRepositoryByNameRequest) Reset() {
	*x = DeprecateRepositoryByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeprecateRepositoryByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeprecateRepositoryByNameRequest) ProtoMessage() {}

func (x *DeprecateRepositoryByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeprecateRepositoryByNameRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *DeprecateRepositoryByNameRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *DeprecateRepositoryByNameRequest) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *DeprecateRepositoryByNameRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *DeprecateRepositoryByNameRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *DeprecateRepositoryByNameRequest) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

type DeprecateRepositoryByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OwnerName      string
	RepositoryName string
	// A message shown along with the deprecation warning for this repository.
	// It must be a utf8 encoded string containing 256 or fewer characters.
	DeprecationMessage string
}

func (b0 DeprecateRepositoryByNameRequest_builder) Build() *DeprecateRepositoryByNameRequest {
	m0 := &DeprecateRepositoryByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	return m0
}

type DeprecateRepositoryByNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DeprecateRepositoryByNameResponse) Reset() {
	*x = DeprecateRepositoryByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeprecateRepositoryByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeprecateRepositoryByNameResponse) ProtoMessage() {}

func (x *DeprecateRepositoryByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeprecateRepositoryByNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *DeprecateRepositoryByNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *DeprecateRepositoryByNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *DeprecateRepositoryByNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type DeprecateRepositoryByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
}

func (b0 DeprecateRepositoryByNameResponse_builder) Build() *DeprecateRepositoryByNameResponse {
	m0 := &DeprecateRepositoryByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	return m0
}

type UndeprecateRepositoryByNameRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UndeprecateRepositoryByNameRequest) Reset() {
	*x = UndeprecateRepositoryByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeprecateRepositoryByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeprecateRepositoryByNameRequest) ProtoMessage() {}

func (x *UndeprecateRepositoryByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UndeprecateRepositoryByNameRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *UndeprecateRepositoryByNameRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *UndeprecateRepositoryByNameRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *UndeprecateRepositoryByNameRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

type UndeprecateRepositoryByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OwnerName      string
	RepositoryName string
}

func (b0 UndeprecateRepositoryByNameRequest_builder) Build() *UndeprecateRepositoryByNameRequest {
	m0 := &UndeprecateRepositoryByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	return m0
}

type UndeprecateRepositoryByNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UndeprecateRepositoryByNameResponse) Reset() {
	*x = UndeprecateRepositoryByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeprecateRepositoryByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeprecateRepositoryByNameResponse) ProtoMessage() {}

func (x *UndeprecateRepositoryByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UndeprecateRepositoryByNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *UndeprecateRepositoryByNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *UndeprecateRepositoryByNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *UndeprecateRepositoryByNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type UndeprecateRepositoryByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
}

func (b0 UndeprecateRepositoryByNameResponse_builder) Build() *UndeprecateRepositoryByNameResponse {
	m0 := &UndeprecateRepositoryByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	return m0
}

type SetRepositoryContributorRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_UserId         string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_RepositoryRole RepositoryRole         `protobuf:"varint,3,opt,name=repository_role,json=repositoryRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SetRepositoryContributorRequest) Reset() {
	*x = SetRepositoryContributorRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetRepositoryContributorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRepositoryContributorRequest) ProtoMessage() {}

func (x *SetRepositoryContributorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SetRepositoryContributorRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *SetRepositoryContributorRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *SetRepositoryContributorRequest) GetRepositoryRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RepositoryRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *SetRepositoryContributorRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *SetRepositoryContributorRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *SetRepositoryContributorRequest) SetRepositoryRole(v RepositoryRole) {
	x.xxx_hidden_RepositoryRole = v
}

type SetRepositoryContributorRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which the user's role will be set.
	RepositoryId string
	// The ID of the user whose role will be set.
	UserId string
	// The role to assign to the user.
	// Setting UNSPECIFIED means removing the user's role.
	RepositoryRole RepositoryRole
}

func (b0 SetRepositoryContributorRequest_builder) Build() *SetRepositoryContributorRequest {
	m0 := &SetRepositoryContributorRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_RepositoryRole = b.RepositoryRole
	return m0
}

type SetRepositoryContributorResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetRepositoryContributorResponse) Reset() {
	*x = SetRepositoryContributorResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetRepositoryContributorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRepositoryContributorResponse) ProtoMessage() {}

func (x *SetRepositoryContributorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type SetRepositoryContributorResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 SetRepositoryContributorResponse_builder) Build() *SetRepositoryContributorResponse {
	m0 := &SetRepositoryContributorResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type ListRepositoryContributorsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_PageSize     uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken    string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse      bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListRepositoryContributorsRequest) Reset() {
	*x = ListRepositoryContributorsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryContributorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryContributorsRequest) ProtoMessage() {}

func (x *ListRepositoryContributorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryContributorsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListRepositoryContributorsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryContributorsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryContributorsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryContributorsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListRepositoryContributorsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryContributorsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryContributorsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryContributorsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryId string
	PageSize     uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoryContributorsRequest_builder) Build() *ListRepositoryContributorsRequest {
	m0 := &ListRepositoryContributorsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryContributorsResponse struct {
	state                    protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_Users         *[]*RepositoryContributor `protobuf:"bytes,1,rep,name=users,proto3"`
	xxx_hidden_NextPageToken string                    `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListRepositoryContributorsResponse) Reset() {
	*x = ListRepositoryContributorsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryContributorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryContributorsResponse) ProtoMessage() {}

func (x *ListRepositoryContributorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryContributorsResponse) GetUsers() []*RepositoryContributor {
	if x != nil {
		if x.xxx_hidden_Users != nil {
			return *x.xxx_hidden_Users
		}
	}
	return nil
}

func (x *ListRepositoryContributorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryContributorsResponse) SetUsers(v []*RepositoryContributor) {
	x.xxx_hidden_Users = &v
}

func (x *ListRepositoryContributorsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryContributorsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Users []*RepositoryContributor
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoryContributorsResponse_builder) Build() *ListRepositoryContributorsResponse {
	m0 := &ListRepositoryContributorsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Users = &b.Users
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type GetRepositoryContributorRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_UserId       string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositoryContributorRequest) Reset() {
	*x = GetRepositoryContributorRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryContributorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryContributorRequest) ProtoMessage() {}

func (x *GetRepositoryContributorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryContributorRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *GetRepositoryContributorRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *GetRepositoryContributorRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *GetRepositoryContributorRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

type GetRepositoryContributorRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to get the contributor information.
	RepositoryId string
	// The ID of the user for which to get the contributor information.
	UserId string
}

func (b0 GetRepositoryContributorRequest_builder) Build() *GetRepositoryContributorRequest {
	m0 := &GetRepositoryContributorRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_UserId = b.UserId
	return m0
}

type GetRepositoryContributorResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User *RepositoryContributor `protobuf:"bytes,1,opt,name=user,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetRepositoryContributorResponse) Reset() {
	*x = GetRepositoryContributorResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryContributorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryContributorResponse) ProtoMessage() {}

func (x *GetRepositoryContributorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryContributorResponse) GetUser() *RepositoryContributor {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *GetRepositoryContributorResponse) SetUser(v *RepositoryContributor) {
	x.xxx_hidden_User = v
}

func (x *GetRepositoryContributorResponse) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *GetRepositoryContributorResponse) ClearUser() {
	x.xxx_hidden_User = nil
}

type GetRepositoryContributorResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The contributor information of the user in the repository.
	User *RepositoryContributor
}

func (b0 GetRepositoryContributorResponse_builder) Build() *GetRepositoryContributorResponse {
	m0 := &GetRepositoryContributorResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	return m0
}

type GetRepositorySettingsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositorySettingsRequest) Reset() {
	*x = GetRepositorySettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositorySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositorySettingsRequest) ProtoMessage() {}

func (x *GetRepositorySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositorySettingsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *GetRepositorySettingsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type GetRepositorySettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to get the settings.
	RepositoryId string
}

func (b0 GetRepositorySettingsRequest_builder) Build() *GetRepositorySettingsRequest {
	m0 := &GetRepositorySettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type GetRepositorySettingsResponse struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ContributorsCount uint32                 `protobuf:"varint,1,opt,name=contributors_count,json=contributorsCount,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *GetRepositorySettingsResponse) Reset() {
	*x = GetRepositorySettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositorySettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositorySettingsResponse) ProtoMessage() {}

func (x *GetRepositorySettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositorySettingsResponse) GetContributorsCount() uint32 {
	if x != nil {
		return x.xxx_hidden_ContributorsCount
	}
	return 0
}

func (x *GetRepositorySettingsResponse) SetContributorsCount(v uint32) {
	x.xxx_hidden_ContributorsCount = v
}

type GetRepositorySettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The number of outside contributors in the repository,
	// excluding owning-organization's members that have an explicit role.
	ContributorsCount uint32
}

func (b0 GetRepositorySettingsResponse_builder) Build() *GetRepositorySettingsResponse {
	m0 := &GetRepositorySettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ContributorsCount = b.ContributorsCount
	return m0
}

type UpdateRepositorySettingsByNameRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Visibility     Visibility             `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_Description    *string                `protobuf:"bytes,4,opt,name=description,proto3,oneof"`
	xxx_hidden_Url            *string                `protobuf:"bytes,5,opt,name=url,proto3,oneof"`
	xxx_hidden_DefaultBranch  *string                `protobuf:"bytes,6,opt,name=default_branch,json=defaultBranch,proto3,oneof"`
	XXX_raceDetectHookData    protoimpl.RaceDetectHookData
	XXX_presence              [1]uint32
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UpdateRepositorySettingsByNameRequest) Reset() {
	*x = UpdateRepositorySettingsByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositorySettingsByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositorySettingsByNameRequest) ProtoMessage() {}

func (x *UpdateRepositorySettingsByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateRepositorySettingsByNameRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *UpdateRepositorySettingsByNameRequest) GetDescription() string {
	if x != nil {
		if x.xxx_hidden_Description != nil {
			return *x.xxx_hidden_Description
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetUrl() string {
	if x != nil {
		if x.xxx_hidden_Url != nil {
			return *x.xxx_hidden_Url
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetDefaultBranch() string {
	if x != nil {
		if x.xxx_hidden_DefaultBranch != nil {
			return *x.xxx_hidden_DefaultBranch
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *UpdateRepositorySettingsByNameRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *UpdateRepositorySettingsByNameRequest) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *UpdateRepositorySettingsByNameRequest) SetDescription(v string) {
	x.xxx_hidden_Description = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 3, 6)
}

func (x *UpdateRepositorySettingsByNameRequest) SetUrl(v string) {
	x.xxx_hidden_Url = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 4, 6)
}

func (x *UpdateRepositorySettingsByNameRequest) SetDefaultBranch(v string) {
	x.xxx_hidden_DefaultBranch = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 5, 6)
}

func (x *UpdateRepositorySettingsByNameRequest) HasDescription() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 3)
}

func (x *UpdateRepositorySettingsByNameRequest) HasUrl() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 4)
}

func (x *UpdateRepositorySettingsByNameRequest) HasDefaultBranch() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 5)
}

func (x *UpdateRepositorySettingsByNameRequest) ClearDescription() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 3)
	x.xxx_hidden_Description = nil
}

func (x *UpdateRepositorySettingsByNameRequest) ClearUrl() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 4)
	x.xxx_hidden_Url = nil
}

func (x *UpdateRepositorySettingsByNameRequest) ClearDefaultBranch() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 5)
	x.xxx_hidden_DefaultBranch = nil
}

type UpdateRepositorySettingsByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OwnerName      string
	RepositoryName string
	// optional, update to visibility will only be made if this is specified.
	Visibility Visibility
	// optional, update to description will only be made when this is present
	Description *string
	// optional, update to url will only be made when this is present
	Url *string
	// optional, update to default_branch will only be made when this is present
	DefaultBranch *string
}

func (b0 UpdateRepositorySettingsByNameRequest_builder) Build() *UpdateRepositorySettingsByNameRequest {
	m0 := &UpdateRepositorySettingsByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Visibility = b.Visibility
	if b.Description != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 3, 6)
		x.xxx_hidden_Description = b.Description
	}
	if b.Url != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 4, 6)
		x.xxx_hidden_Url = b.Url
	}
	if b.DefaultBranch != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 5, 6)
		x.xxx_hidden_DefaultBranch = b.DefaultBranch
	}
	return m0
}

type UpdateRepositorySettingsByNameResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRepositorySettingsByNameResponse) Reset() {
	*x = UpdateRepositorySettingsByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositorySettingsByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositorySettingsByNameResponse) ProtoMessage() {}

func (x *UpdateRepositorySettingsByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateRepositorySettingsByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateRepositorySettingsByNameResponse_builder) Build() *UpdateRepositorySettingsByNameResponse {
	m0 := &UpdateRepositorySettingsByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetRepositoriesMetadataRequest struct {
	state          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Ids []string               `protobuf:"bytes,1,rep,name=ids,proto3"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetRepositoriesMetadataRequest) Reset() {
	*x = GetRepositoriesMetadataRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesMetadataRequest) ProtoMessage() {}

func (x *GetRepositoriesMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesMetadataRequest) GetIds() []string {
	if x != nil {
		return x.xxx_hidden_Ids
	}
	return nil
}

func (x *GetRepositoriesMetadataRequest) SetIds(v []string) {
	x.xxx_hidden_Ids = v
}

type GetRepositoriesMetadataRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of repository IDs to request the metadata.
	Ids []string
}

func (b0 GetRepositoriesMetadataRequest_builder) Build() *GetRepositoriesMetadataRequest {
	m0 := &GetRepositoriesMetadataRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Ids = b.Ids
	return m0
}

type GetRepositoriesMetadataResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Metadata *[]*RepositoryMetadata `protobuf:"bytes,1,rep,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetRepositoriesMetadataResponse) Reset() {
	*x = GetRepositoriesMetadataResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesMetadataResponse) ProtoMessage() {}

func (x *GetRepositoriesMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesMetadataResponse) GetMetadata() []*RepositoryMetadata {
	if x != nil {
		if x.xxx_hidden_Metadata != nil {
			return *x.xxx_hidden_Metadata
		}
	}
	return nil
}

func (x *GetRepositoriesMetadataResponse) SetMetadata(v []*RepositoryMetadata) {
	x.xxx_hidden_Metadata = &v
}

type GetRepositoriesMetadataResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Metadata []*RepositoryMetadata
}

func (b0 GetRepositoriesMetadataResponse_builder) Build() *GetRepositoriesMetadataResponse {
	m0 := &GetRepositoriesMetadataResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Metadata = &b.Metadata
	return m0
}

type GetRepositoryDependencyDOTStringRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetRepositoryDependencyDOTStringRequest) Reset() {
	*x = GetRepositoryDependencyDOTStringRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryDependencyDOTStringRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryDependencyDOTStringRequest) ProtoMessage() {}

func (x *GetRepositoryDependencyDOTStringRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryDependencyDOTStringRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetRepositoryDependencyDOTStringRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetRepositoryDependencyDOTStringRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type GetRepositoryDependencyDOTStringRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the BSR repository.
	Owner string
	// The name of the BSR repository.
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
}

func (b0 GetRepositoryDependencyDOTStringRequest_builder) Build() *GetRepositoryDependencyDOTStringRequest {
	m0 := &GetRepositoryDependencyDOTStringRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	return m0
}

type GetRepositoryDependencyDOTStringResponse struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_DotString string                 `protobuf:"bytes,1,opt,name=dot_string,json=dotString,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetRepositoryDependencyDOTStringResponse) Reset() {
	*x = GetRepositoryDependencyDOTStringResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryDependencyDOTStringResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryDependencyDOTStringResponse) ProtoMessage() {}

func (x *GetRepositoryDependencyDOTStringResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryDependencyDOTStringResponse) GetDotString() string {
	if x != nil {
		return x.xxx_hidden_DotString
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringResponse) SetDotString(v string) {
	x.xxx_hidden_DotString = v
}

type GetRepositoryDependencyDOTStringResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The string DOT representation of the dependency graph for the repository.
	//
	// DOT language reference: https://graphviz.org/doc/info/lang.html
	DotString string
}

func (b0 GetRepositoryDependencyDOTStringResponse_builder) Build() *GetRepositoryDependencyDOTStringResponse {
	m0 := &GetRepositoryDependencyDOTStringResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_DotString = b.DotString
	return m0
}

var File_buf_alpha_registry_v1alpha1_repository_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_repository_proto_rawDesc = string([]byte{
	0x0a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x26, 0x62, 0x75, 0x66,
	0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x62, 0x75, 0x66,
	0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x04, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0f, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x2f, 0x0a, 0x13, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x42, 0x07, 0x0a, 0x05, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x22, 0x68, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x67, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x74, 0x61, 0x67,
	0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x64, 0x72,
	0x61, 0x66, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x52,
	0x0c, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x97, 0x02,
	0x0a, 0x15, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x12, 0x35, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f,
	0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69,
	0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69,
	0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0c, 0x69, 0x6d, 0x70, 0x6c, 0x69,
	0x63, 0x69, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0xc3, 0x02, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x6b, 0x0a, 0x19, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x17, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x48,
	0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x53, 0x70, 0x64, 0x78, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x22, 0x41, 0x0a,
	0x20, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x22, 0x70, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x22, 0x26, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0xa7, 0x01, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x45, 0x0a,
	0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x06, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x22, 0x3d, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x45, 0x0a, 0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52,
	0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x22, 0x6f, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x1c, 0x4c, 0x69,
	0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x7c, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x9c, 0x01,
	0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a,
	0x23, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76,
	0x65, 0x72, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65,
	0x72, 0x73, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x89, 0x01, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x6d, 0x0a,
	0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x29, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x40, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x24, 0x0a, 0x22, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x20,
	0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x6c, 0x0a, 0x21, 0x44, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x6c, 0x0a, 0x22, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x23, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0xb5, 0x01, 0x0a, 0x1f, 0x53, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x17,
	0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0e, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0x22, 0x0a,
	0x20, 0x53, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x9e, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65,
	0x72, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72,
	0x73, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x75, 0x73, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x05, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f, 0x0a, 0x1f, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x22, 0x6a, 0x0a, 0x20,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x46, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x6f, 0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x22, 0x43, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x4e, 0x0a,
	0x1d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xcd, 0x02,
	0x0a, 0x25, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02,
	0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x88,
	0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x22, 0x28, 0x0a,
	0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x69, 0x64, 0x73, 0x22, 0x6e, 0x0a, 0x1f, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x7d, 0x0a, 0x27, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x44, 0x4f, 0x54, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x49, 0x0a, 0x28, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x44, 0x4f, 0x54, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x6f, 0x74, 0x5f, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x6f, 0x74, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x2a, 0x57, 0x0a, 0x0a, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x16, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x15, 0x0a, 0x11, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x55,
	0x42, 0x4c, 0x49, 0x43, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49,
	0x4c, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x02, 0x32, 0xc5,
	0x17, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02,
	0x01, 0x12, 0x99, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x84, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0x90, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x38, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xab, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xa8, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x40, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01,
	0x12, 0xa2, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79,
	0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79,
	0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x84, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0xa2, 0x01, 0x0a,
	0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02,
	0x02, 0x12, 0x9a, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa0,
	0x01, 0x0a, 0x1b, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3f,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x6e, 0x64,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x40, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x6e,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x9f, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x42, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x42, 0x79, 0x46,
	0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x42, 0x79, 0x46, 0x75,
	0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03,
	0x90, 0x02, 0x01, 0x12, 0x97, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x12, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa2, 0x01,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x3e, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x01, 0x12, 0x9c, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x12,
	0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02,
	0x01, 0x12, 0x93, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xa9, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x99, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0xb4, 0x01, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x44, 0x4f, 0x54, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x12, 0x44, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x44, 0x4f, 0x54, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79,
	0x44, 0x4f, 0x54, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x9c, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0f, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67,
	0x65, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02,
	0x1b, 0x42, 0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42,
	0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66,
	0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68,
	0x61, 0x3a, 0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes = make([]protoimpl.MessageInfo, 42)
var file_buf_alpha_registry_v1alpha1_repository_proto_goTypes = []any{
	(Visibility)(0),                                  // 0: buf.alpha.registry.v1alpha1.Visibility
	(*Repository)(nil),                               // 1: buf.alpha.registry.v1alpha1.Repository
	(*RepositoryCounts)(nil),                         // 2: buf.alpha.registry.v1alpha1.RepositoryCounts
	(*RepositoryContributor)(nil),                    // 3: buf.alpha.registry.v1alpha1.RepositoryContributor
	(*RepositoryMetadata)(nil),                       // 4: buf.alpha.registry.v1alpha1.RepositoryMetadata
	(*GetRepositoriesByFullNameRequest)(nil),         // 5: buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameRequest
	(*GetRepositoriesByFullNameResponse)(nil),        // 6: buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse
	(*GetRepositoryRequest)(nil),                     // 7: buf.alpha.registry.v1alpha1.GetRepositoryRequest
	(*GetRepositoryResponse)(nil),                    // 8: buf.alpha.registry.v1alpha1.GetRepositoryResponse
	(*GetRepositoryByFullNameRequest)(nil),           // 9: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameRequest
	(*GetRepositoryByFullNameResponse)(nil),          // 10: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse
	(*ListRepositoriesRequest)(nil),                  // 11: buf.alpha.registry.v1alpha1.ListRepositoriesRequest
	(*ListRepositoriesResponse)(nil),                 // 12: buf.alpha.registry.v1alpha1.ListRepositoriesResponse
	(*ListUserRepositoriesRequest)(nil),              // 13: buf.alpha.registry.v1alpha1.ListUserRepositoriesRequest
	(*ListUserRepositoriesResponse)(nil),             // 14: buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse
	(*ListRepositoriesUserCanAccessRequest)(nil),     // 15: buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessRequest
	(*ListRepositoriesUserCanAccessResponse)(nil),    // 16: buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse
	(*ListOrganizationRepositoriesRequest)(nil),      // 17: buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesRequest
	(*ListOrganizationRepositoriesResponse)(nil),     // 18: buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse
	(*CreateRepositoryByFullNameRequest)(nil),        // 19: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest
	(*CreateRepositoryByFullNameResponse)(nil),       // 20: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse
	(*DeleteRepositoryRequest)(nil),                  // 21: buf.alpha.registry.v1alpha1.DeleteRepositoryRequest
	(*DeleteRepositoryResponse)(nil),                 // 22: buf.alpha.registry.v1alpha1.DeleteRepositoryResponse
	(*DeleteRepositoryByFullNameRequest)(nil),        // 23: buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameRequest
	(*DeleteRepositoryByFullNameResponse)(nil),       // 24: buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameResponse
	(*DeprecateRepositoryByNameRequest)(nil),         // 25: buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameRequest
	(*DeprecateRepositoryByNameResponse)(nil),        // 26: buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse
	(*UndeprecateRepositoryByNameRequest)(nil),       // 27: buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameRequest
	(*UndeprecateRepositoryByNameResponse)(nil),      // 28: buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse
	(*SetRepositoryContributorRequest)(nil),          // 29: buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest
	(*SetRepositoryContributorResponse)(nil),         // 30: buf.alpha.registry.v1alpha1.SetRepositoryContributorResponse
	(*ListRepositoryContributorsRequest)(nil),        // 31: buf.alpha.registry.v1alpha1.ListRepositoryContributorsRequest
	(*ListRepositoryContributorsResponse)(nil),       // 32: buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse
	(*GetRepositoryContributorRequest)(nil),          // 33: buf.alpha.registry.v1alpha1.GetRepositoryContributorRequest
	(*GetRepositoryContributorResponse)(nil),         // 34: buf.alpha.registry.v1alpha1.GetRepositoryContributorResponse
	(*GetRepositorySettingsRequest)(nil),             // 35: buf.alpha.registry.v1alpha1.GetRepositorySettingsRequest
	(*GetRepositorySettingsResponse)(nil),            // 36: buf.alpha.registry.v1alpha1.GetRepositorySettingsResponse
	(*UpdateRepositorySettingsByNameRequest)(nil),    // 37: buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest
	(*UpdateRepositorySettingsByNameResponse)(nil),   // 38: buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameResponse
	(*GetRepositoriesMetadataRequest)(nil),           // 39: buf.alpha.registry.v1alpha1.GetRepositoriesMetadataRequest
	(*GetRepositoriesMetadataResponse)(nil),          // 40: buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse
	(*GetRepositoryDependencyDOTStringRequest)(nil),  // 41: buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringRequest
	(*GetRepositoryDependencyDOTStringResponse)(nil), // 42: buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringResponse
	(*timestamppb.Timestamp)(nil),                    // 43: google.protobuf.Timestamp
	(*User)(nil),                                     // 44: buf.alpha.registry.v1alpha1.User
	(RepositoryRole)(0),                              // 45: buf.alpha.registry.v1alpha1.RepositoryRole
	(VerificationStatus)(0),                          // 46: buf.alpha.registry.v1alpha1.VerificationStatus
}
var file_buf_alpha_registry_v1alpha1_repository_proto_depIdxs = []int32{
	43, // 0: buf.alpha.registry.v1alpha1.Repository.create_time:type_name -> google.protobuf.Timestamp
	43, // 1: buf.alpha.registry.v1alpha1.Repository.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: buf.alpha.registry.v1alpha1.Repository.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	44, // 3: buf.alpha.registry.v1alpha1.RepositoryContributor.user:type_name -> buf.alpha.registry.v1alpha1.User
	45, // 4: buf.alpha.registry.v1alpha1.RepositoryContributor.explicit_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	45, // 5: buf.alpha.registry.v1alpha1.RepositoryContributor.implicit_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	46, // 6: buf.alpha.registry.v1alpha1.RepositoryMetadata.owner_verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	43, // 7: buf.alpha.registry.v1alpha1.RepositoryMetadata.latest_commit_time:type_name -> google.protobuf.Timestamp
	1,  // 8: buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 9: buf.alpha.registry.v1alpha1.GetRepositoryResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	2,  // 10: buf.alpha.registry.v1alpha1.GetRepositoryResponse.counts:type_name -> buf.alpha.registry.v1alpha1.RepositoryCounts
	1,  // 11: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	2,  // 12: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse.counts:type_name -> buf.alpha.registry.v1alpha1.RepositoryCounts
	1,  // 13: buf.alpha.registry.v1alpha1.ListRepositoriesResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 14: buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 15: buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 16: buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	0,  // 17: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	1,  // 18: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 19: buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 20: buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	45, // 21: buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest.repository_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	3,  // 22: buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse.users:type_name -> buf.alpha.registry.v1alpha1.RepositoryContributor
	3,  // 23: buf.alpha.registry.v1alpha1.GetRepositoryContributorResponse.user:type_name -> buf.alpha.registry.v1alpha1.RepositoryContributor
	0,  // 24: buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	4,  // 25: buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse.metadata:type_name -> buf.alpha.registry.v1alpha1.RepositoryMetadata
	7,  // 26: buf.alpha.registry.v1alpha1.RepositoryService.GetRepository:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryRequest
	9,  // 27: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryByFullName:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryByFullNameRequest
	11, // 28: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositories:input_type -> buf.alpha.registry.v1alpha1.ListRepositoriesRequest
	13, // 29: buf.alpha.registry.v1alpha1.RepositoryService.ListUserRepositories:input_type -> buf.alpha.registry.v1alpha1.ListUserRepositoriesRequest
	15, // 30: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoriesUserCanAccess:input_type -> buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessRequest
	17, // 31: buf.alpha.registry.v1alpha1.RepositoryService.ListOrganizationRepositories:input_type -> buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesRequest
	19, // 32: buf.alpha.registry.v1alpha1.RepositoryService.CreateRepositoryByFullName:input_type -> buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest
	21, // 33: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepository:input_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryRequest
	23, // 34: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepositoryByFullName:input_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameRequest
	25, // 35: buf.alpha.registry.v1alpha1.RepositoryService.DeprecateRepositoryByName:input_type -> buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameRequest
	27, // 36: buf.alpha.registry.v1alpha1.RepositoryService.UndeprecateRepositoryByName:input_type -> buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameRequest
	5,  // 37: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesByFullName:input_type -> buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameRequest
	29, // 38: buf.alpha.registry.v1alpha1.RepositoryService.SetRepositoryContributor:input_type -> buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest
	31, // 39: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoryContributors:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryContributorsRequest
	33, // 40: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryContributor:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryContributorRequest
	35, // 41: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositorySettings:input_type -> buf.alpha.registry.v1alpha1.GetRepositorySettingsRequest
	37, // 42: buf.alpha.registry.v1alpha1.RepositoryService.UpdateRepositorySettingsByName:input_type -> buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest
	39, // 43: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesMetadata:input_type -> buf.alpha.registry.v1alpha1.GetRepositoriesMetadataRequest
	41, // 44: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryDependencyDOTString:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringRequest
	8,  // 45: buf.alpha.registry.v1alpha1.RepositoryService.GetRepository:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryResponse
	10, // 46: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryByFullName:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse
	12, // 47: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositories:output_type -> buf.alpha.registry.v1alpha1.ListRepositoriesResponse
	14, // 48: buf.alpha.registry.v1alpha1.RepositoryService.ListUserRepositories:output_type -> buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse
	16, // 49: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoriesUserCanAccess:output_type -> buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse
	18, // 50: buf.alpha.registry.v1alpha1.RepositoryService.ListOrganizationRepositories:output_type -> buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse
	20, // 51: buf.alpha.registry.v1alpha1.RepositoryService.CreateRepositoryByFullName:output_type -> buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse
	22, // 52: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepository:output_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryResponse
	24, // 53: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepositoryByFullName:output_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameResponse
	26, // 54: buf.alpha.registry.v1alpha1.RepositoryService.DeprecateRepositoryByName:output_type -> buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse
	28, // 55: buf.alpha.registry.v1alpha1.RepositoryService.UndeprecateRepositoryByName:output_type -> buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse
	6,  // 56: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesByFullName:output_type -> buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse
	30, // 57: buf.alpha.registry.v1alpha1.RepositoryService.SetRepositoryContributor:output_type -> buf.alpha.registry.v1alpha1.SetRepositoryContributorResponse
	32, // 58: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoryContributors:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse
	34, // 59: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryContributor:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryContributorResponse
	36, // 60: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositorySettings:output_type -> buf.alpha.registry.v1alpha1.GetRepositorySettingsResponse
	38, // 61: buf.alpha.registry.v1alpha1.RepositoryService.UpdateRepositorySettingsByName:output_type -> buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameResponse
	40, // 62: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesMetadata:output_type -> buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse
	42, // 63: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryDependencyDOTString:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringResponse
	45, // [45:64] is the sub-list for method output_type
	26, // [26:45] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_repository_proto_init() }
func file_buf_alpha_registry_v1alpha1_repository_proto_init() {
	if File_buf_alpha_registry_v1alpha1_repository_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	file_buf_alpha_registry_v1alpha1_user_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0].OneofWrappers = []any{
		(*repository_UserId)(nil),
		(*repository_OrganizationId)(nil),
	}
	file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[36].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_repository_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_repository_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   42,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_repository_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_repository_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_repository_proto = out.File
	file_buf_alpha_registry_v1alpha1_repository_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_repository_proto_depIdxs = nil
}
