// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: buf/alpha/audit/v1alpha1/event.proto

package auditv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ActorType is the type of actor that caused the audited event.
type ActorType int32

const (
	ActorType_ACTOR_TYPE_UNSPECIFIED ActorType = 0
	ActorType_ACTOR_TYPE_USER        ActorType = 1
	ActorType_ACTOR_TYPE_SYSTEM      ActorType = 2
)

// Enum value maps for ActorType.
var (
	ActorType_name = map[int32]string{
		0: "ACTOR_TYPE_UNSPECIFIED",
		1: "ACTOR_TYPE_USER",
		2: "ACTOR_TYPE_SYSTEM",
	}
	ActorType_value = map[string]int32{
		"ACTOR_TYPE_UNSPECIFIED": 0,
		"ACTOR_TYPE_USER":        1,
		"ACTOR_TYPE_SYSTEM":      2,
	}
)

func (x ActorType) Enum() *ActorType {
	p := new(ActorType)
	*p = x
	return p
}

func (x ActorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActorType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[0].Descriptor()
}

func (ActorType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[0]
}

func (x ActorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// ResourceType is the type of the resource that was affected by the audited
// event.
type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_UNSPECIFIED                ResourceType = 0
	ResourceType_RESOURCE_TYPE_USER                       ResourceType = 1
	ResourceType_RESOURCE_TYPE_ORGANIZATION               ResourceType = 2
	ResourceType_RESOURCE_TYPE_ORGANIZATION_MEMBER        ResourceType = 3
	ResourceType_RESOURCE_TYPE_ORGANIZATION_IDP_GROUP     ResourceType = 9
	ResourceType_RESOURCE_TYPE_REPOSITORY                 ResourceType = 4
	ResourceType_RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR     ResourceType = 5
	ResourceType_RESOURCE_TYPE_REPOSITORY_COMMIT          ResourceType = 6
	ResourceType_RESOURCE_TYPE_PLUGIN                     ResourceType = 7
	ResourceType_RESOURCE_TYPE_PLUGIN_COMMIT              ResourceType = 15
	ResourceType_RESOURCE_TYPE_CURATED_PLUGIN             ResourceType = 8
	ResourceType_RESOURCE_TYPE_TOKEN                      ResourceType = 10
	ResourceType_RESOURCE_TYPE_SCIM_TOKEN                 ResourceType = 11
	ResourceType_RESOURCE_TYPE_REPOSITORY_LABEL           ResourceType = 12
	ResourceType_RESOURCE_TYPE_SERVER                     ResourceType = 13
	ResourceType_RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT ResourceType = 14
	ResourceType_RESOURCE_TYPE_PLUGIN_LABEL               ResourceType = 16
)

// Enum value maps for ResourceType.
var (
	ResourceType_name = map[int32]string{
		0:  "RESOURCE_TYPE_UNSPECIFIED",
		1:  "RESOURCE_TYPE_USER",
		2:  "RESOURCE_TYPE_ORGANIZATION",
		3:  "RESOURCE_TYPE_ORGANIZATION_MEMBER",
		9:  "RESOURCE_TYPE_ORGANIZATION_IDP_GROUP",
		4:  "RESOURCE_TYPE_REPOSITORY",
		5:  "RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR",
		6:  "RESOURCE_TYPE_REPOSITORY_COMMIT",
		7:  "RESOURCE_TYPE_PLUGIN",
		15: "RESOURCE_TYPE_PLUGIN_COMMIT",
		8:  "RESOURCE_TYPE_CURATED_PLUGIN",
		10: "RESOURCE_TYPE_TOKEN",
		11: "RESOURCE_TYPE_SCIM_TOKEN",
		12: "RESOURCE_TYPE_REPOSITORY_LABEL",
		13: "RESOURCE_TYPE_SERVER",
		14: "RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT",
		16: "RESOURCE_TYPE_PLUGIN_LABEL",
	}
	ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED":                0,
		"RESOURCE_TYPE_USER":                       1,
		"RESOURCE_TYPE_ORGANIZATION":               2,
		"RESOURCE_TYPE_ORGANIZATION_MEMBER":        3,
		"RESOURCE_TYPE_ORGANIZATION_IDP_GROUP":     9,
		"RESOURCE_TYPE_REPOSITORY":                 4,
		"RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR":     5,
		"RESOURCE_TYPE_REPOSITORY_COMMIT":          6,
		"RESOURCE_TYPE_PLUGIN":                     7,
		"RESOURCE_TYPE_PLUGIN_COMMIT":              15,
		"RESOURCE_TYPE_CURATED_PLUGIN":             8,
		"RESOURCE_TYPE_TOKEN":                      10,
		"RESOURCE_TYPE_SCIM_TOKEN":                 11,
		"RESOURCE_TYPE_REPOSITORY_LABEL":           12,
		"RESOURCE_TYPE_SERVER":                     13,
		"RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT": 14,
		"RESOURCE_TYPE_PLUGIN_LABEL":               16,
	}
)

func (x ResourceType) Enum() *ResourceType {
	p := new(ResourceType)
	*p = x
	return p
}

func (x ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[1].Descriptor()
}

func (ResourceType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[1]
}

func (x ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// EventType is the type of audited event.
type EventType int32

const (
	EventType_EVENT_TYPE_UNSPECIFIED                           EventType = 0
	EventType_EVENT_TYPE_ORGANIZATION_CREATED                  EventType = 1
	EventType_EVENT_TYPE_ORGANIZATION_DELETED                  EventType = 2
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ADDED             EventType = 3
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED      EventType = 4
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED           EventType = 5
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED          EventType = 21
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED        EventType = 22
	EventType_EVENT_TYPE_REPOSITORY_CREATED                    EventType = 6
	EventType_EVENT_TYPE_REPOSITORY_DEPRECATED                 EventType = 48
	EventType_EVENT_TYPE_REPOSITORY_UNDEPRECATED               EventType = 49
	EventType_EVENT_TYPE_REPOSITORY_DELETED                    EventType = 7
	EventType_EVENT_TYPE_REPOSITORY_COMMIT_PUSHED              EventType = 8
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED          EventType = 9
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED   EventType = 10
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED        EventType = 11
	EventType_EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED         EventType = 12
	EventType_EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED EventType = 40
	EventType_EVENT_TYPE_PLUGIN_CREATED                        EventType = 13
	EventType_EVENT_TYPE_PLUGIN_DELETED                        EventType = 14
	EventType_EVENT_TYPE_PLUGIN_COMMIT_PUSHED                  EventType = 43
	EventType_EVENT_TYPE_CURATED_PLUGIN_CREATED                EventType = 20
	EventType_EVENT_TYPE_CURATED_PLUGIN_DELETED                EventType = 31
	EventType_EVENT_TYPE_USER_CREATED                          EventType = 15
	EventType_EVENT_TYPE_USER_DELETED                          EventType = 16
	EventType_EVENT_TYPE_USER_DEACTIVATED                      EventType = 17
	EventType_EVENT_TYPE_USER_LOGGED_IN                        EventType = 18
	EventType_EVENT_TYPE_USER_LOGGED_OUT                       EventType = 19
	EventType_EVENT_TYPE_TOKEN_CREATED                         EventType = 23
	EventType_EVENT_TYPE_TOKEN_DELETED                         EventType = 24
	EventType_EVENT_TYPE_USER_REACTIVATED                      EventType = 25
	EventType_EVENT_TYPE_SCIM_TOKEN_CREATED                    EventType = 26
	EventType_EVENT_TYPE_SCIM_TOKEN_DELETED                    EventType = 27
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_REPOSITORY_COMMIT_DELETED              EventType = 28
	EventType_EVENT_TYPE_REPOSITORY_LABEL_CREATED               EventType = 29
	EventType_EVENT_TYPE_REPOSITORY_LABEL_MOVED                 EventType = 30
	EventType_EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED              EventType = 38
	EventType_EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED            EventType = 39
	EventType_EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED  EventType = 32
	EventType_EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED EventType = 33
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED   EventType = 34
	EventType_EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED    EventType = 35
	EventType_EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED   EventType = 36
	EventType_EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP       EventType = 37
	EventType_EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED EventType = 41
	EventType_EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED   EventType = 42
	EventType_EVENT_TYPE_PLUGIN_LABEL_CREATED                EventType = 44
	EventType_EVENT_TYPE_PLUGIN_LABEL_MOVED                  EventType = 45
	EventType_EVENT_TYPE_PLUGIN_LABEL_ARCHIVED               EventType = 46
	EventType_EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED             EventType = 47
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0:  "EVENT_TYPE_UNSPECIFIED",
		1:  "EVENT_TYPE_ORGANIZATION_CREATED",
		2:  "EVENT_TYPE_ORGANIZATION_DELETED",
		3:  "EVENT_TYPE_ORGANIZATION_MEMBER_ADDED",
		4:  "EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED",
		5:  "EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED",
		21: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED",
		22: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED",
		6:  "EVENT_TYPE_REPOSITORY_CREATED",
		48: "EVENT_TYPE_REPOSITORY_DEPRECATED",
		49: "EVENT_TYPE_REPOSITORY_UNDEPRECATED",
		7:  "EVENT_TYPE_REPOSITORY_DELETED",
		8:  "EVENT_TYPE_REPOSITORY_COMMIT_PUSHED",
		9:  "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED",
		10: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED",
		11: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED",
		12: "EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED",
		40: "EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED",
		13: "EVENT_TYPE_PLUGIN_CREATED",
		14: "EVENT_TYPE_PLUGIN_DELETED",
		43: "EVENT_TYPE_PLUGIN_COMMIT_PUSHED",
		20: "EVENT_TYPE_CURATED_PLUGIN_CREATED",
		31: "EVENT_TYPE_CURATED_PLUGIN_DELETED",
		15: "EVENT_TYPE_USER_CREATED",
		16: "EVENT_TYPE_USER_DELETED",
		17: "EVENT_TYPE_USER_DEACTIVATED",
		18: "EVENT_TYPE_USER_LOGGED_IN",
		19: "EVENT_TYPE_USER_LOGGED_OUT",
		23: "EVENT_TYPE_TOKEN_CREATED",
		24: "EVENT_TYPE_TOKEN_DELETED",
		25: "EVENT_TYPE_USER_REACTIVATED",
		26: "EVENT_TYPE_SCIM_TOKEN_CREATED",
		27: "EVENT_TYPE_SCIM_TOKEN_DELETED",
		28: "EVENT_TYPE_REPOSITORY_COMMIT_DELETED",
		29: "EVENT_TYPE_REPOSITORY_LABEL_CREATED",
		30: "EVENT_TYPE_REPOSITORY_LABEL_MOVED",
		38: "EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED",
		39: "EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED",
		32: "EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED",
		33: "EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED",
		34: "EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED",
		35: "EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED",
		36: "EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED",
		37: "EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP",
		41: "EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED",
		42: "EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED",
		44: "EVENT_TYPE_PLUGIN_LABEL_CREATED",
		45: "EVENT_TYPE_PLUGIN_LABEL_MOVED",
		46: "EVENT_TYPE_PLUGIN_LABEL_ARCHIVED",
		47: "EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED",
	}
	EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":                            0,
		"EVENT_TYPE_ORGANIZATION_CREATED":                   1,
		"EVENT_TYPE_ORGANIZATION_DELETED":                   2,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ADDED":              3,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED":       4,
		"EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED":            5,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED":           21,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED":         22,
		"EVENT_TYPE_REPOSITORY_CREATED":                     6,
		"EVENT_TYPE_REPOSITORY_DEPRECATED":                  48,
		"EVENT_TYPE_REPOSITORY_UNDEPRECATED":                49,
		"EVENT_TYPE_REPOSITORY_DELETED":                     7,
		"EVENT_TYPE_REPOSITORY_COMMIT_PUSHED":               8,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED":           9,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED":    10,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED":         11,
		"EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED":          12,
		"EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED":  40,
		"EVENT_TYPE_PLUGIN_CREATED":                         13,
		"EVENT_TYPE_PLUGIN_DELETED":                         14,
		"EVENT_TYPE_PLUGIN_COMMIT_PUSHED":                   43,
		"EVENT_TYPE_CURATED_PLUGIN_CREATED":                 20,
		"EVENT_TYPE_CURATED_PLUGIN_DELETED":                 31,
		"EVENT_TYPE_USER_CREATED":                           15,
		"EVENT_TYPE_USER_DELETED":                           16,
		"EVENT_TYPE_USER_DEACTIVATED":                       17,
		"EVENT_TYPE_USER_LOGGED_IN":                         18,
		"EVENT_TYPE_USER_LOGGED_OUT":                        19,
		"EVENT_TYPE_TOKEN_CREATED":                          23,
		"EVENT_TYPE_TOKEN_DELETED":                          24,
		"EVENT_TYPE_USER_REACTIVATED":                       25,
		"EVENT_TYPE_SCIM_TOKEN_CREATED":                     26,
		"EVENT_TYPE_SCIM_TOKEN_DELETED":                     27,
		"EVENT_TYPE_REPOSITORY_COMMIT_DELETED":              28,
		"EVENT_TYPE_REPOSITORY_LABEL_CREATED":               29,
		"EVENT_TYPE_REPOSITORY_LABEL_MOVED":                 30,
		"EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED":              38,
		"EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED":            39,
		"EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED":  32,
		"EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED": 33,
		"EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED":      34,
		"EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED":       35,
		"EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED":      36,
		"EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP":          37,
		"EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED":    41,
		"EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED":      42,
		"EVENT_TYPE_PLUGIN_LABEL_CREATED":                   44,
		"EVENT_TYPE_PLUGIN_LABEL_MOVED":                     45,
		"EVENT_TYPE_PLUGIN_LABEL_ARCHIVED":                  46,
		"EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED":                47,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[2].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[2]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Actor is the actor who caused the audited event.
type Actor struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type ActorType              `protobuf:"varint,1,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.ActorType"`
	xxx_hidden_Id   string                 `protobuf:"bytes,2,opt,name=id,proto3"`
	xxx_hidden_Name string                 `protobuf:"bytes,3,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Actor) Reset() {
	*x = Actor{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Actor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Actor) ProtoMessage() {}

func (x *Actor) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Actor) GetType() ActorType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return ActorType_ACTOR_TYPE_UNSPECIFIED
}

func (x *Actor) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Actor) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Actor) SetType(v ActorType) {
	x.xxx_hidden_Type = v
}

func (x *Actor) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Actor) SetName(v string) {
	x.xxx_hidden_Name = v
}

type Actor_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Type of actor who caused the audited event.
	Type ActorType
	// Id of the actor who caused the audited event.
	Id string
	// Name of the actor who caused the audited event.
	Name string
}

func (b0 Actor_builder) Build() *Actor {
	m0 := &Actor{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	return m0
}

// Resource is the affected resource by the audited event.
type Resource struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type ResourceType           `protobuf:"varint,1,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.ResourceType"`
	xxx_hidden_Id   string                 `protobuf:"bytes,2,opt,name=id,proto3"`
	xxx_hidden_Name string                 `protobuf:"bytes,3,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Resource) GetType() ResourceType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return ResourceType_RESOURCE_TYPE_UNSPECIFIED
}

func (x *Resource) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Resource) SetType(v ResourceType) {
	x.xxx_hidden_Type = v
}

func (x *Resource) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Resource) SetName(v string) {
	x.xxx_hidden_Name = v
}

type Resource_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Type of resource that was affected by the audited event.
	Type ResourceType
	// Id of the affected resource by the audited event.
	Id string
	// Name of the affected resource by the audited event.
	Name string
}

func (b0 Resource_builder) Build() *Resource {
	m0 := &Resource{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	return m0
}

// EventMetadata provides additional details about the audited event.
type EventMetadata struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserAgent string                 `protobuf:"bytes,1,opt,name=user_agent,json=userAgent,proto3"`
	xxx_hidden_Ip        string                 `protobuf:"bytes,2,opt,name=ip,proto3"`
	xxx_hidden_TraceId   string                 `protobuf:"bytes,3,opt,name=trace_id,json=traceId,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *EventMetadata) Reset() {
	*x = EventMetadata{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventMetadata) ProtoMessage() {}

func (x *EventMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EventMetadata) GetUserAgent() string {
	if x != nil {
		return x.xxx_hidden_UserAgent
	}
	return ""
}

func (x *EventMetadata) GetIp() string {
	if x != nil {
		return x.xxx_hidden_Ip
	}
	return ""
}

func (x *EventMetadata) GetTraceId() string {
	if x != nil {
		return x.xxx_hidden_TraceId
	}
	return ""
}

func (x *EventMetadata) SetUserAgent(v string) {
	x.xxx_hidden_UserAgent = v
}

func (x *EventMetadata) SetIp(v string) {
	x.xxx_hidden_Ip = v
}

func (x *EventMetadata) SetTraceId(v string) {
	x.xxx_hidden_TraceId = v
}

type EventMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// UserAgent is the User-Agent header associated with the request that triggered the audited event, if any.
	UserAgent string
	// IP is the IP address associated with the request that triggered the audited event, if any.
	Ip string
	// TraceID is the ID of the trace associated with the audited event, if any.
	TraceId string
}

func (b0 EventMetadata_builder) Build() *EventMetadata {
	m0 := &EventMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserAgent = b.UserAgent
	x.xxx_hidden_Ip = b.Ip
	x.xxx_hidden_TraceId = b.TraceId
	return m0
}

// Event is an audited action that happened in the BSR, with the information of
// what happened, when it happened, who did it, which resource was affected, and
// more contextual information on the event.
type Event struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_EventId   string                 `protobuf:"bytes,1,opt,name=event_id,json=eventId,proto3"`
	xxx_hidden_Type      EventType              `protobuf:"varint,2,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.EventType"`
	xxx_hidden_Actor     *Actor                 `protobuf:"bytes,3,opt,name=actor,proto3"`
	xxx_hidden_Resource  *Resource              `protobuf:"bytes,4,opt,name=resource,proto3"`
	xxx_hidden_EventTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=event_time,json=eventTime,proto3"`
	xxx_hidden_Metadata  *EventMetadata         `protobuf:"bytes,6,opt,name=metadata,proto3"`
	xxx_hidden_Payload   isEvent_Payload        `protobuf_oneof:"payload"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Event) GetEventId() string {
	if x != nil {
		return x.xxx_hidden_EventId
	}
	return ""
}

func (x *Event) GetType() EventType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return EventType_EVENT_TYPE_UNSPECIFIED
}

func (x *Event) GetActor() *Actor {
	if x != nil {
		return x.xxx_hidden_Actor
	}
	return nil
}

func (x *Event) GetResource() *Resource {
	if x != nil {
		return x.xxx_hidden_Resource
	}
	return nil
}

func (x *Event) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_EventTime
	}
	return nil
}

func (x *Event) GetMetadata() *EventMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *Event) GetOrganizationCreated() *PayloadOrganizationCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationCreated); ok {
			return x.OrganizationCreated
		}
	}
	return nil
}

func (x *Event) GetOrganizationDeleted() *PayloadOrganizationDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationDeleted); ok {
			return x.OrganizationDeleted
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberAdded() *PayloadOrganizationMemberAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberAdded); ok {
			return x.OrganizationMemberAdded
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberRoleChanged() *PayloadOrganizationMemberRoleChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRoleChanged); ok {
			return x.OrganizationMemberRoleChanged
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberRemoved() *PayloadOrganizationMemberRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRemoved); ok {
			return x.OrganizationMemberRemoved
		}
	}
	return nil
}

func (x *Event) GetRepositoryCreated() *PayloadRepositoryCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryCreated); ok {
			return x.RepositoryCreated
		}
	}
	return nil
}

func (x *Event) GetRepositoryDeprecated() *PayloadRepositoryDeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDeprecated); ok {
			return x.RepositoryDeprecated
		}
	}
	return nil
}

func (x *Event) GetRepositoryUndeprecated() *PayloadRepositoryUndeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryUndeprecated); ok {
			return x.RepositoryUndeprecated
		}
	}
	return nil
}

func (x *Event) GetRepositoryDeleted() *PayloadRepositoryDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDeleted); ok {
			return x.RepositoryDeleted
		}
	}
	return nil
}

func (x *Event) GetRepositoryCommitPushed() *PayloadRepositoryCommitPushed {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitPushed); ok {
			return x.RepositoryCommitPushed
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorAdded() *PayloadRepositoryContributorAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorAdded); ok {
			return x.RepositoryContributorAdded
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorRoleChanged() *PayloadRepositoryContributorRoleChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRoleChanged); ok {
			return x.RepositoryContributorRoleChanged
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorRemoved() *PayloadRepositoryContributorRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRemoved); ok {
			return x.RepositoryContributorRemoved
		}
	}
	return nil
}

func (x *Event) GetRepositoryVisibilityChanged() *PayloadRepositoryVisibilityChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryVisibilityChanged); ok {
			return x.RepositoryVisibilityChanged
		}
	}
	return nil
}

func (x *Event) GetRepositoryDefaultLabelNameChanged() *PayloadRepositoryDefaultLabelNameChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultLabelNameChanged); ok {
			return x.RepositoryDefaultLabelNameChanged
		}
	}
	return nil
}

func (x *Event) GetPluginCreated() *PayloadPluginCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginCreated); ok {
			return x.PluginCreated
		}
	}
	return nil
}

func (x *Event) GetPluginDeleted() *PayloadPluginDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginDeleted); ok {
			return x.PluginDeleted
		}
	}
	return nil
}

func (x *Event) GetPluginCommitPushed() *PayloadPluginCommitPushed {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginCommitPushed); ok {
			return x.PluginCommitPushed
		}
	}
	return nil
}

func (x *Event) GetUserCreated() *PayloadUserCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserCreated); ok {
			return x.UserCreated
		}
	}
	return nil
}

func (x *Event) GetUserDeactivated() *PayloadUserDeactivated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserDeactivated); ok {
			return x.UserDeactivated
		}
	}
	return nil
}

func (x *Event) GetUserDeleted() *PayloadUserDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserDeleted); ok {
			return x.UserDeleted
		}
	}
	return nil
}

func (x *Event) GetUserLoggedIn() *PayloadUserLoggedIn {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserLoggedIn); ok {
			return x.UserLoggedIn
		}
	}
	return nil
}

func (x *Event) GetUserLoggedOut() *PayloadUserLoggedOut {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserLoggedOut); ok {
			return x.UserLoggedOut
		}
	}
	return nil
}

func (x *Event) GetCuratedPluginCreated() *PayloadCuratedPluginCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_CuratedPluginCreated); ok {
			return x.CuratedPluginCreated
		}
	}
	return nil
}

func (x *Event) GetIdpGroupAdded() *PayloadOrganizationIDPGroupAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_IdpGroupAdded); ok {
			return x.IdpGroupAdded
		}
	}
	return nil
}

func (x *Event) GetIdpGroupRemoved() *PayloadOrganizationIDPGroupRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_IdpGroupRemoved); ok {
			return x.IdpGroupRemoved
		}
	}
	return nil
}

func (x *Event) GetTokenCreated() *PayloadTokenCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_TokenCreated); ok {
			return x.TokenCreated
		}
	}
	return nil
}

func (x *Event) GetTokenDeleted() *PayloadTokenDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_TokenDeleted); ok {
			return x.TokenDeleted
		}
	}
	return nil
}

func (x *Event) GetUserReactivated() *PayloadUserReactivated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserReactivated); ok {
			return x.UserReactivated
		}
	}
	return nil
}

func (x *Event) GetScimTokenCreated() *PayloadSCIMTokenCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_ScimTokenCreated); ok {
			return x.ScimTokenCreated
		}
	}
	return nil
}

func (x *Event) GetScimTokenDeleted() *PayloadSCIMTokenDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_ScimTokenDeleted); ok {
			return x.ScimTokenDeleted
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) GetRepositoryCommitDeleted() *PayloadRepositoryCommitDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitDeleted); ok {
			return x.RepositoryCommitDeleted
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelCreated() *PayloadRepositoryLabelCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelCreated); ok {
			return x.RepositoryLabelCreated
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelMoved() *PayloadRepositoryLabelMoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelMoved); ok {
			return x.RepositoryLabelMoved
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelArchived() *PayloadRepositoryLabelArchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelArchived); ok {
			return x.RepositoryLabelArchived
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelUnarchived() *PayloadRepositoryLabelUnarchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelUnarchived); ok {
			return x.RepositoryLabelUnarchived
		}
	}
	return nil
}

func (x *Event) GetCuratedPluginDeleted() *PayloadCuratedPluginDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_CuratedPluginDeleted); ok {
			return x.CuratedPluginDeleted
		}
	}
	return nil
}

func (x *Event) GetPayloadServerBreakingChangePolicyEnabled() *PayloadServerBreakingChangePolicyEnabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyEnabled); ok {
			return x.PayloadServerBreakingChangePolicyEnabled
		}
	}
	return nil
}

func (x *Event) GetPayloadServerBreakingChangePolicyDisabled() *PayloadServerBreakingChangePolicyDisabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyDisabled); ok {
			return x.PayloadServerBreakingChangePolicyDisabled
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) GetRepositoryDefaultBranchChanged() *PayloadRepositoryDefaultBranchChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultBranchChanged); ok {
			return x.RepositoryDefaultBranchChanged
		}
	}
	return nil
}

func (x *Event) GetPayloadServerUniquenessPolicyEnabled() *PayloadServerUniquenessPolicyEnabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyEnabled); ok {
			return x.PayloadServerUniquenessPolicyEnabled
		}
	}
	return nil
}

func (x *Event) GetPayloadServerUniquenessPolicyDisabled() *PayloadServerUniquenessPolicyDisabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyDisabled); ok {
			return x.PayloadServerUniquenessPolicyDisabled
		}
	}
	return nil
}

func (x *Event) GetUserAutoMergedFromNewIdp() *PayloadUserAutoMergedFromNewIdP {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserAutoMergedFromNewIdp); ok {
			return x.UserAutoMergedFromNewIdp
		}
	}
	return nil
}

func (x *Event) GetDeviceAuthorizationGrantApproved() *PayloadDeviceAuthorizationGrantApproved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantApproved); ok {
			return x.DeviceAuthorizationGrantApproved
		}
	}
	return nil
}

func (x *Event) GetDeviceAuthorizationGrantDenied() *PayloadDeviceAuthorizationGrantDenied {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantDenied); ok {
			return x.DeviceAuthorizationGrantDenied
		}
	}
	return nil
}

func (x *Event) GetPluginLabelCreated() *PayloadPluginLabelCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelCreated); ok {
			return x.PluginLabelCreated
		}
	}
	return nil
}

func (x *Event) GetPluginLabelMoved() *PayloadPluginLabelMoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelMoved); ok {
			return x.PluginLabelMoved
		}
	}
	return nil
}

func (x *Event) GetPluginLabelArchived() *PayloadPluginLabelArchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelArchived); ok {
			return x.PluginLabelArchived
		}
	}
	return nil
}

func (x *Event) GetPluginLabelUnarchived() *PayloadPluginLabelUnarchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelUnarchived); ok {
			return x.PluginLabelUnarchived
		}
	}
	return nil
}

func (x *Event) SetEventId(v string) {
	x.xxx_hidden_EventId = v
}

func (x *Event) SetType(v EventType) {
	x.xxx_hidden_Type = v
}

func (x *Event) SetActor(v *Actor) {
	x.xxx_hidden_Actor = v
}

func (x *Event) SetResource(v *Resource) {
	x.xxx_hidden_Resource = v
}

func (x *Event) SetEventTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_EventTime = v
}

func (x *Event) SetMetadata(v *EventMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *Event) SetOrganizationCreated(v *PayloadOrganizationCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationCreated{v}
}

func (x *Event) SetOrganizationDeleted(v *PayloadOrganizationDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationDeleted{v}
}

func (x *Event) SetOrganizationMemberAdded(v *PayloadOrganizationMemberAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberAdded{v}
}

func (x *Event) SetOrganizationMemberRoleChanged(v *PayloadOrganizationMemberRoleChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberRoleChanged{v}
}

func (x *Event) SetOrganizationMemberRemoved(v *PayloadOrganizationMemberRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberRemoved{v}
}

func (x *Event) SetRepositoryCreated(v *PayloadRepositoryCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryCreated{v}
}

func (x *Event) SetRepositoryDeprecated(v *PayloadRepositoryDeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDeprecated{v}
}

func (x *Event) SetRepositoryUndeprecated(v *PayloadRepositoryUndeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryUndeprecated{v}
}

func (x *Event) SetRepositoryDeleted(v *PayloadRepositoryDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDeleted{v}
}

func (x *Event) SetRepositoryCommitPushed(v *PayloadRepositoryCommitPushed) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryCommitPushed{v}
}

func (x *Event) SetRepositoryContributorAdded(v *PayloadRepositoryContributorAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorAdded{v}
}

func (x *Event) SetRepositoryContributorRoleChanged(v *PayloadRepositoryContributorRoleChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorRoleChanged{v}
}

func (x *Event) SetRepositoryContributorRemoved(v *PayloadRepositoryContributorRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorRemoved{v}
}

func (x *Event) SetRepositoryVisibilityChanged(v *PayloadRepositoryVisibilityChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryVisibilityChanged{v}
}

func (x *Event) SetRepositoryDefaultLabelNameChanged(v *PayloadRepositoryDefaultLabelNameChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDefaultLabelNameChanged{v}
}

func (x *Event) SetPluginCreated(v *PayloadPluginCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginCreated{v}
}

func (x *Event) SetPluginDeleted(v *PayloadPluginDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginDeleted{v}
}

func (x *Event) SetPluginCommitPushed(v *PayloadPluginCommitPushed) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginCommitPushed{v}
}

func (x *Event) SetUserCreated(v *PayloadUserCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserCreated{v}
}

func (x *Event) SetUserDeactivated(v *PayloadUserDeactivated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserDeactivated{v}
}

func (x *Event) SetUserDeleted(v *PayloadUserDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserDeleted{v}
}

func (x *Event) SetUserLoggedIn(v *PayloadUserLoggedIn) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserLoggedIn{v}
}

func (x *Event) SetUserLoggedOut(v *PayloadUserLoggedOut) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserLoggedOut{v}
}

func (x *Event) SetCuratedPluginCreated(v *PayloadCuratedPluginCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_CuratedPluginCreated{v}
}

func (x *Event) SetIdpGroupAdded(v *PayloadOrganizationIDPGroupAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_IdpGroupAdded{v}
}

func (x *Event) SetIdpGroupRemoved(v *PayloadOrganizationIDPGroupRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_IdpGroupRemoved{v}
}

func (x *Event) SetTokenCreated(v *PayloadTokenCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_TokenCreated{v}
}

func (x *Event) SetTokenDeleted(v *PayloadTokenDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_TokenDeleted{v}
}

func (x *Event) SetUserReactivated(v *PayloadUserReactivated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserReactivated{v}
}

func (x *Event) SetScimTokenCreated(v *PayloadSCIMTokenCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_ScimTokenCreated{v}
}

func (x *Event) SetScimTokenDeleted(v *PayloadSCIMTokenDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_ScimTokenDeleted{v}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) SetRepositoryCommitDeleted(v *PayloadRepositoryCommitDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryCommitDeleted{v}
}

func (x *Event) SetRepositoryLabelCreated(v *PayloadRepositoryLabelCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelCreated{v}
}

func (x *Event) SetRepositoryLabelMoved(v *PayloadRepositoryLabelMoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelMoved{v}
}

func (x *Event) SetRepositoryLabelArchived(v *PayloadRepositoryLabelArchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelArchived{v}
}

func (x *Event) SetRepositoryLabelUnarchived(v *PayloadRepositoryLabelUnarchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelUnarchived{v}
}

func (x *Event) SetCuratedPluginDeleted(v *PayloadCuratedPluginDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_CuratedPluginDeleted{v}
}

func (x *Event) SetPayloadServerBreakingChangePolicyEnabled(v *PayloadServerBreakingChangePolicyEnabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyEnabled{v}
}

func (x *Event) SetPayloadServerBreakingChangePolicyDisabled(v *PayloadServerBreakingChangePolicyDisabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyDisabled{v}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) SetRepositoryDefaultBranchChanged(v *PayloadRepositoryDefaultBranchChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDefaultBranchChanged{v}
}

func (x *Event) SetPayloadServerUniquenessPolicyEnabled(v *PayloadServerUniquenessPolicyEnabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyEnabled{v}
}

func (x *Event) SetPayloadServerUniquenessPolicyDisabled(v *PayloadServerUniquenessPolicyDisabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyDisabled{v}
}

func (x *Event) SetUserAutoMergedFromNewIdp(v *PayloadUserAutoMergedFromNewIdP) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserAutoMergedFromNewIdp{v}
}

func (x *Event) SetDeviceAuthorizationGrantApproved(v *PayloadDeviceAuthorizationGrantApproved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantApproved{v}
}

func (x *Event) SetDeviceAuthorizationGrantDenied(v *PayloadDeviceAuthorizationGrantDenied) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantDenied{v}
}

func (x *Event) SetPluginLabelCreated(v *PayloadPluginLabelCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelCreated{v}
}

func (x *Event) SetPluginLabelMoved(v *PayloadPluginLabelMoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelMoved{v}
}

func (x *Event) SetPluginLabelArchived(v *PayloadPluginLabelArchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelArchived{v}
}

func (x *Event) SetPluginLabelUnarchived(v *PayloadPluginLabelUnarchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelUnarchived{v}
}

func (x *Event) HasActor() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Actor != nil
}

func (x *Event) HasResource() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Resource != nil
}

func (x *Event) HasEventTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_EventTime != nil
}

func (x *Event) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *Event) HasPayload() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Payload != nil
}

func (x *Event) HasOrganizationCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationCreated)
	return ok
}

func (x *Event) HasOrganizationDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationDeleted)
	return ok
}

func (x *Event) HasOrganizationMemberAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberAdded)
	return ok
}

func (x *Event) HasOrganizationMemberRoleChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRoleChanged)
	return ok
}

func (x *Event) HasOrganizationMemberRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRemoved)
	return ok
}

func (x *Event) HasRepositoryCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryCreated)
	return ok
}

func (x *Event) HasRepositoryDeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDeprecated)
	return ok
}

func (x *Event) HasRepositoryUndeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryUndeprecated)
	return ok
}

func (x *Event) HasRepositoryDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDeleted)
	return ok
}

func (x *Event) HasRepositoryCommitPushed() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitPushed)
	return ok
}

func (x *Event) HasRepositoryContributorAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorAdded)
	return ok
}

func (x *Event) HasRepositoryContributorRoleChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRoleChanged)
	return ok
}

func (x *Event) HasRepositoryContributorRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRemoved)
	return ok
}

func (x *Event) HasRepositoryVisibilityChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryVisibilityChanged)
	return ok
}

func (x *Event) HasRepositoryDefaultLabelNameChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultLabelNameChanged)
	return ok
}

func (x *Event) HasPluginCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginCreated)
	return ok
}

func (x *Event) HasPluginDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginDeleted)
	return ok
}

func (x *Event) HasPluginCommitPushed() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginCommitPushed)
	return ok
}

func (x *Event) HasUserCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserCreated)
	return ok
}

func (x *Event) HasUserDeactivated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserDeactivated)
	return ok
}

func (x *Event) HasUserDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserDeleted)
	return ok
}

func (x *Event) HasUserLoggedIn() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserLoggedIn)
	return ok
}

func (x *Event) HasUserLoggedOut() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserLoggedOut)
	return ok
}

func (x *Event) HasCuratedPluginCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_CuratedPluginCreated)
	return ok
}

func (x *Event) HasIdpGroupAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_IdpGroupAdded)
	return ok
}

func (x *Event) HasIdpGroupRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_IdpGroupRemoved)
	return ok
}

func (x *Event) HasTokenCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_TokenCreated)
	return ok
}

func (x *Event) HasTokenDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_TokenDeleted)
	return ok
}

func (x *Event) HasUserReactivated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserReactivated)
	return ok
}

func (x *Event) HasScimTokenCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_ScimTokenCreated)
	return ok
}

func (x *Event) HasScimTokenDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_ScimTokenDeleted)
	return ok
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) HasRepositoryCommitDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitDeleted)
	return ok
}

func (x *Event) HasRepositoryLabelCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelCreated)
	return ok
}

func (x *Event) HasRepositoryLabelMoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelMoved)
	return ok
}

func (x *Event) HasRepositoryLabelArchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelArchived)
	return ok
}

func (x *Event) HasRepositoryLabelUnarchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelUnarchived)
	return ok
}

func (x *Event) HasCuratedPluginDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_CuratedPluginDeleted)
	return ok
}

func (x *Event) HasPayloadServerBreakingChangePolicyEnabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyEnabled)
	return ok
}

func (x *Event) HasPayloadServerBreakingChangePolicyDisabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyDisabled)
	return ok
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) HasRepositoryDefaultBranchChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultBranchChanged)
	return ok
}

func (x *Event) HasPayloadServerUniquenessPolicyEnabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyEnabled)
	return ok
}

func (x *Event) HasPayloadServerUniquenessPolicyDisabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyDisabled)
	return ok
}

func (x *Event) HasUserAutoMergedFromNewIdp() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserAutoMergedFromNewIdp)
	return ok
}

func (x *Event) HasDeviceAuthorizationGrantApproved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantApproved)
	return ok
}

func (x *Event) HasDeviceAuthorizationGrantDenied() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantDenied)
	return ok
}

func (x *Event) HasPluginLabelCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelCreated)
	return ok
}

func (x *Event) HasPluginLabelMoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelMoved)
	return ok
}

func (x *Event) HasPluginLabelArchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelArchived)
	return ok
}

func (x *Event) HasPluginLabelUnarchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelUnarchived)
	return ok
}

func (x *Event) ClearActor() {
	x.xxx_hidden_Actor = nil
}

func (x *Event) ClearResource() {
	x.xxx_hidden_Resource = nil
}

func (x *Event) ClearEventTime() {
	x.xxx_hidden_EventTime = nil
}

func (x *Event) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

func (x *Event) ClearPayload() {
	x.xxx_hidden_Payload = nil
}

func (x *Event) ClearOrganizationCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberRoleChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRoleChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryDeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryUndeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryUndeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryCommitPushed() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitPushed); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorRoleChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRoleChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryVisibilityChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryVisibilityChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryDefaultLabelNameChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultLabelNameChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginCommitPushed() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginCommitPushed); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserDeactivated() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserDeactivated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserLoggedIn() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserLoggedIn); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserLoggedOut() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserLoggedOut); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearCuratedPluginCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_CuratedPluginCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearIdpGroupAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_IdpGroupAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearIdpGroupRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_IdpGroupRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearTokenCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_TokenCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearTokenDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_TokenDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserReactivated() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserReactivated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearScimTokenCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_ScimTokenCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearScimTokenDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_ScimTokenDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) ClearRepositoryCommitDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelMoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelMoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelArchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelArchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelUnarchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelUnarchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearCuratedPluginDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_CuratedPluginDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerBreakingChangePolicyEnabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyEnabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerBreakingChangePolicyDisabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyDisabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) ClearRepositoryDefaultBranchChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultBranchChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerUniquenessPolicyEnabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyEnabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerUniquenessPolicyDisabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyDisabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserAutoMergedFromNewIdp() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserAutoMergedFromNewIdp); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearDeviceAuthorizationGrantApproved() {
	if _, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantApproved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearDeviceAuthorizationGrantDenied() {
	if _, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantDenied); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelMoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelMoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelArchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelArchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelUnarchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelUnarchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

const Event_Payload_not_set_case case_Event_Payload = 0
const Event_OrganizationCreated_case case_Event_Payload = 7
const Event_OrganizationDeleted_case case_Event_Payload = 8
const Event_OrganizationMemberAdded_case case_Event_Payload = 9
const Event_OrganizationMemberRoleChanged_case case_Event_Payload = 10
const Event_OrganizationMemberRemoved_case case_Event_Payload = 11
const Event_RepositoryCreated_case case_Event_Payload = 12
const Event_RepositoryDeprecated_case case_Event_Payload = 54
const Event_RepositoryUndeprecated_case case_Event_Payload = 55
const Event_RepositoryDeleted_case case_Event_Payload = 13
const Event_RepositoryCommitPushed_case case_Event_Payload = 14
const Event_RepositoryContributorAdded_case case_Event_Payload = 15
const Event_RepositoryContributorRoleChanged_case case_Event_Payload = 16
const Event_RepositoryContributorRemoved_case case_Event_Payload = 17
const Event_RepositoryVisibilityChanged_case case_Event_Payload = 18
const Event_RepositoryDefaultLabelNameChanged_case case_Event_Payload = 46
const Event_PluginCreated_case case_Event_Payload = 19
const Event_PluginDeleted_case case_Event_Payload = 20
const Event_PluginCommitPushed_case case_Event_Payload = 49
const Event_UserCreated_case case_Event_Payload = 21
const Event_UserDeactivated_case case_Event_Payload = 22
const Event_UserDeleted_case case_Event_Payload = 23
const Event_UserLoggedIn_case case_Event_Payload = 24
const Event_UserLoggedOut_case case_Event_Payload = 25
const Event_CuratedPluginCreated_case case_Event_Payload = 26
const Event_IdpGroupAdded_case case_Event_Payload = 27
const Event_IdpGroupRemoved_case case_Event_Payload = 28
const Event_TokenCreated_case case_Event_Payload = 29
const Event_TokenDeleted_case case_Event_Payload = 30
const Event_UserReactivated_case case_Event_Payload = 31
const Event_ScimTokenCreated_case case_Event_Payload = 32
const Event_ScimTokenDeleted_case case_Event_Payload = 33
const Event_RepositoryCommitDeleted_case case_Event_Payload = 34
const Event_RepositoryLabelCreated_case case_Event_Payload = 35
const Event_RepositoryLabelMoved_case case_Event_Payload = 36
const Event_RepositoryLabelArchived_case case_Event_Payload = 44
const Event_RepositoryLabelUnarchived_case case_Event_Payload = 45
const Event_CuratedPluginDeleted_case case_Event_Payload = 37
const Event_PayloadServerBreakingChangePolicyEnabled_case case_Event_Payload = 38
const Event_PayloadServerBreakingChangePolicyDisabled_case case_Event_Payload = 39
const Event_RepositoryDefaultBranchChanged_case case_Event_Payload = 40
const Event_PayloadServerUniquenessPolicyEnabled_case case_Event_Payload = 41
const Event_PayloadServerUniquenessPolicyDisabled_case case_Event_Payload = 42
const Event_UserAutoMergedFromNewIdp_case case_Event_Payload = 43
const Event_DeviceAuthorizationGrantApproved_case case_Event_Payload = 47
const Event_DeviceAuthorizationGrantDenied_case case_Event_Payload = 48
const Event_PluginLabelCreated_case case_Event_Payload = 50
const Event_PluginLabelMoved_case case_Event_Payload = 51
const Event_PluginLabelArchived_case case_Event_Payload = 52
const Event_PluginLabelUnarchived_case case_Event_Payload = 53

func (x *Event) WhichPayload() case_Event_Payload {
	if x == nil {
		return Event_Payload_not_set_case
	}
	switch x.xxx_hidden_Payload.(type) {
	case *event_OrganizationCreated:
		return Event_OrganizationCreated_case
	case *event_OrganizationDeleted:
		return Event_OrganizationDeleted_case
	case *event_OrganizationMemberAdded:
		return Event_OrganizationMemberAdded_case
	case *event_OrganizationMemberRoleChanged:
		return Event_OrganizationMemberRoleChanged_case
	case *event_OrganizationMemberRemoved:
		return Event_OrganizationMemberRemoved_case
	case *event_RepositoryCreated:
		return Event_RepositoryCreated_case
	case *event_RepositoryDeprecated:
		return Event_RepositoryDeprecated_case
	case *event_RepositoryUndeprecated:
		return Event_RepositoryUndeprecated_case
	case *event_RepositoryDeleted:
		return Event_RepositoryDeleted_case
	case *event_RepositoryCommitPushed:
		return Event_RepositoryCommitPushed_case
	case *event_RepositoryContributorAdded:
		return Event_RepositoryContributorAdded_case
	case *event_RepositoryContributorRoleChanged:
		return Event_RepositoryContributorRoleChanged_case
	case *event_RepositoryContributorRemoved:
		return Event_RepositoryContributorRemoved_case
	case *event_RepositoryVisibilityChanged:
		return Event_RepositoryVisibilityChanged_case
	case *event_RepositoryDefaultLabelNameChanged:
		return Event_RepositoryDefaultLabelNameChanged_case
	case *event_PluginCreated:
		return Event_PluginCreated_case
	case *event_PluginDeleted:
		return Event_PluginDeleted_case
	case *event_PluginCommitPushed:
		return Event_PluginCommitPushed_case
	case *event_UserCreated:
		return Event_UserCreated_case
	case *event_UserDeactivated:
		return Event_UserDeactivated_case
	case *event_UserDeleted:
		return Event_UserDeleted_case
	case *event_UserLoggedIn:
		return Event_UserLoggedIn_case
	case *event_UserLoggedOut:
		return Event_UserLoggedOut_case
	case *event_CuratedPluginCreated:
		return Event_CuratedPluginCreated_case
	case *event_IdpGroupAdded:
		return Event_IdpGroupAdded_case
	case *event_IdpGroupRemoved:
		return Event_IdpGroupRemoved_case
	case *event_TokenCreated:
		return Event_TokenCreated_case
	case *event_TokenDeleted:
		return Event_TokenDeleted_case
	case *event_UserReactivated:
		return Event_UserReactivated_case
	case *event_ScimTokenCreated:
		return Event_ScimTokenCreated_case
	case *event_ScimTokenDeleted:
		return Event_ScimTokenDeleted_case
	case *event_RepositoryCommitDeleted:
		return Event_RepositoryCommitDeleted_case
	case *event_RepositoryLabelCreated:
		return Event_RepositoryLabelCreated_case
	case *event_RepositoryLabelMoved:
		return Event_RepositoryLabelMoved_case
	case *event_RepositoryLabelArchived:
		return Event_RepositoryLabelArchived_case
	case *event_RepositoryLabelUnarchived:
		return Event_RepositoryLabelUnarchived_case
	case *event_CuratedPluginDeleted:
		return Event_CuratedPluginDeleted_case
	case *event_PayloadServerBreakingChangePolicyEnabled:
		return Event_PayloadServerBreakingChangePolicyEnabled_case
	case *event_PayloadServerBreakingChangePolicyDisabled:
		return Event_PayloadServerBreakingChangePolicyDisabled_case
	case *event_RepositoryDefaultBranchChanged:
		return Event_RepositoryDefaultBranchChanged_case
	case *event_PayloadServerUniquenessPolicyEnabled:
		return Event_PayloadServerUniquenessPolicyEnabled_case
	case *event_PayloadServerUniquenessPolicyDisabled:
		return Event_PayloadServerUniquenessPolicyDisabled_case
	case *event_UserAutoMergedFromNewIdp:
		return Event_UserAutoMergedFromNewIdp_case
	case *event_DeviceAuthorizationGrantApproved:
		return Event_DeviceAuthorizationGrantApproved_case
	case *event_DeviceAuthorizationGrantDenied:
		return Event_DeviceAuthorizationGrantDenied_case
	case *event_PluginLabelCreated:
		return Event_PluginLabelCreated_case
	case *event_PluginLabelMoved:
		return Event_PluginLabelMoved_case
	case *event_PluginLabelArchived:
		return Event_PluginLabelArchived_case
	case *event_PluginLabelUnarchived:
		return Event_PluginLabelUnarchived_case
	default:
		return Event_Payload_not_set_case
	}
}

type Event_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Unique id of the audited event.
	EventId string
	// Type of the audited event. It specifies "what" happened.
	Type EventType
	// Actor of the audited event. It specifies "who" did it.
	Actor *Actor
	// Resource of the audited event. It specifies "which resource" was affected.
	Resource *Resource
	// Time of the audited event. It specifies "when" it happened.
	EventTime *timestamppb.Timestamp
	// Metadata about the audited event. It specifies any additional details about the audited event.
	Metadata *EventMetadata
	// Payload of the audited event. It specifies additional context on the event.

	// Fields of oneof xxx_hidden_Payload:
	OrganizationCreated               *PayloadOrganizationCreated
	OrganizationDeleted               *PayloadOrganizationDeleted
	OrganizationMemberAdded           *PayloadOrganizationMemberAdded
	OrganizationMemberRoleChanged     *PayloadOrganizationMemberRoleChanged
	OrganizationMemberRemoved         *PayloadOrganizationMemberRemoved
	RepositoryCreated                 *PayloadRepositoryCreated
	RepositoryDeprecated              *PayloadRepositoryDeprecated
	RepositoryUndeprecated            *PayloadRepositoryUndeprecated
	RepositoryDeleted                 *PayloadRepositoryDeleted
	RepositoryCommitPushed            *PayloadRepositoryCommitPushed
	RepositoryContributorAdded        *PayloadRepositoryContributorAdded
	RepositoryContributorRoleChanged  *PayloadRepositoryContributorRoleChanged
	RepositoryContributorRemoved      *PayloadRepositoryContributorRemoved
	RepositoryVisibilityChanged       *PayloadRepositoryVisibilityChanged
	RepositoryDefaultLabelNameChanged *PayloadRepositoryDefaultLabelNameChanged
	PluginCreated                     *PayloadPluginCreated
	PluginDeleted                     *PayloadPluginDeleted
	PluginCommitPushed                *PayloadPluginCommitPushed
	UserCreated                       *PayloadUserCreated
	UserDeactivated                   *PayloadUserDeactivated
	UserDeleted                       *PayloadUserDeleted
	UserLoggedIn                      *PayloadUserLoggedIn
	UserLoggedOut                     *PayloadUserLoggedOut
	CuratedPluginCreated              *PayloadCuratedPluginCreated
	IdpGroupAdded                     *PayloadOrganizationIDPGroupAdded
	IdpGroupRemoved                   *PayloadOrganizationIDPGroupRemoved
	TokenCreated                      *PayloadTokenCreated
	TokenDeleted                      *PayloadTokenDeleted
	UserReactivated                   *PayloadUserReactivated
	ScimTokenCreated                  *PayloadSCIMTokenCreated
	ScimTokenDeleted                  *PayloadSCIMTokenDeleted
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryCommitDeleted                   *PayloadRepositoryCommitDeleted
	RepositoryLabelCreated                    *PayloadRepositoryLabelCreated
	RepositoryLabelMoved                      *PayloadRepositoryLabelMoved
	RepositoryLabelArchived                   *PayloadRepositoryLabelArchived
	RepositoryLabelUnarchived                 *PayloadRepositoryLabelUnarchived
	CuratedPluginDeleted                      *PayloadCuratedPluginDeleted
	PayloadServerBreakingChangePolicyEnabled  *PayloadServerBreakingChangePolicyEnabled
	PayloadServerBreakingChangePolicyDisabled *PayloadServerBreakingChangePolicyDisabled
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryDefaultBranchChanged        *PayloadRepositoryDefaultBranchChanged
	PayloadServerUniquenessPolicyEnabled  *PayloadServerUniquenessPolicyEnabled
	PayloadServerUniquenessPolicyDisabled *PayloadServerUniquenessPolicyDisabled
	UserAutoMergedFromNewIdp              *PayloadUserAutoMergedFromNewIdP
	DeviceAuthorizationGrantApproved      *PayloadDeviceAuthorizationGrantApproved
	DeviceAuthorizationGrantDenied        *PayloadDeviceAuthorizationGrantDenied
	PluginLabelCreated                    *PayloadPluginLabelCreated
	PluginLabelMoved                      *PayloadPluginLabelMoved
	PluginLabelArchived                   *PayloadPluginLabelArchived
	PluginLabelUnarchived                 *PayloadPluginLabelUnarchived
	// -- end of xxx_hidden_Payload
}

func (b0 Event_builder) Build() *Event {
	m0 := &Event{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_EventId = b.EventId
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Actor = b.Actor
	x.xxx_hidden_Resource = b.Resource
	x.xxx_hidden_EventTime = b.EventTime
	x.xxx_hidden_Metadata = b.Metadata
	if b.OrganizationCreated != nil {
		x.xxx_hidden_Payload = &event_OrganizationCreated{b.OrganizationCreated}
	}
	if b.OrganizationDeleted != nil {
		x.xxx_hidden_Payload = &event_OrganizationDeleted{b.OrganizationDeleted}
	}
	if b.OrganizationMemberAdded != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberAdded{b.OrganizationMemberAdded}
	}
	if b.OrganizationMemberRoleChanged != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberRoleChanged{b.OrganizationMemberRoleChanged}
	}
	if b.OrganizationMemberRemoved != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberRemoved{b.OrganizationMemberRemoved}
	}
	if b.RepositoryCreated != nil {
		x.xxx_hidden_Payload = &event_RepositoryCreated{b.RepositoryCreated}
	}
	if b.RepositoryDeprecated != nil {
		x.xxx_hidden_Payload = &event_RepositoryDeprecated{b.RepositoryDeprecated}
	}
	if b.RepositoryUndeprecated != nil {
		x.xxx_hidden_Payload = &event_RepositoryUndeprecated{b.RepositoryUndeprecated}
	}
	if b.RepositoryDeleted != nil {
		x.xxx_hidden_Payload = &event_RepositoryDeleted{b.RepositoryDeleted}
	}
	if b.RepositoryCommitPushed != nil {
		x.xxx_hidden_Payload = &event_RepositoryCommitPushed{b.RepositoryCommitPushed}
	}
	if b.RepositoryContributorAdded != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorAdded{b.RepositoryContributorAdded}
	}
	if b.RepositoryContributorRoleChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorRoleChanged{b.RepositoryContributorRoleChanged}
	}
	if b.RepositoryContributorRemoved != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorRemoved{b.RepositoryContributorRemoved}
	}
	if b.RepositoryVisibilityChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryVisibilityChanged{b.RepositoryVisibilityChanged}
	}
	if b.RepositoryDefaultLabelNameChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryDefaultLabelNameChanged{b.RepositoryDefaultLabelNameChanged}
	}
	if b.PluginCreated != nil {
		x.xxx_hidden_Payload = &event_PluginCreated{b.PluginCreated}
	}
	if b.PluginDeleted != nil {
		x.xxx_hidden_Payload = &event_PluginDeleted{b.PluginDeleted}
	}
	if b.PluginCommitPushed != nil {
		x.xxx_hidden_Payload = &event_PluginCommitPushed{b.PluginCommitPushed}
	}
	if b.UserCreated != nil {
		x.xxx_hidden_Payload = &event_UserCreated{b.UserCreated}
	}
	if b.UserDeactivated != nil {
		x.xxx_hidden_Payload = &event_UserDeactivated{b.UserDeactivated}
	}
	if b.UserDeleted != nil {
		x.xxx_hidden_Payload = &event_UserDeleted{b.UserDeleted}
	}
	if b.UserLoggedIn != nil {
		x.xxx_hidden_Payload = &event_UserLoggedIn{b.UserLoggedIn}
	}
	if b.UserLoggedOut != nil {
		x.xxx_hidden_Payload = &event_UserLoggedOut{b.UserLoggedOut}
	}
	if b.CuratedPluginCreated != nil {
		x.xxx_hidden_Payload = &event_CuratedPluginCreated{b.CuratedPluginCreated}
	}
	if b.IdpGroupAdded != nil {
		x.xxx_hidden_Payload = &event_IdpGroupAdded{b.IdpGroupAdded}
	}
	if b.IdpGroupRemoved != nil {
		x.xxx_hidden_Payload = &event_IdpGroupRemoved{b.IdpGroupRemoved}
	}
	if b.TokenCreated != nil {
		x.xxx_hidden_Payload = &event_TokenCreated{b.TokenCreated}
	}
	if b.TokenDeleted != nil {
		x.xxx_hidden_Payload = &event_TokenDeleted{b.TokenDeleted}
	}
	if b.UserReactivated != nil {
		x.xxx_hidden_Payload = &event_UserReactivated{b.UserReactivated}
	}
	if b.ScimTokenCreated != nil {
		x.xxx_hidden_Payload = &event_ScimTokenCreated{b.ScimTokenCreated}
	}
	if b.ScimTokenDeleted != nil {
		x.xxx_hidden_Payload = &event_ScimTokenDeleted{b.ScimTokenDeleted}
	}
	if b.RepositoryCommitDeleted != nil {
		x.xxx_hidden_Payload = &event_RepositoryCommitDeleted{b.RepositoryCommitDeleted}
	}
	if b.RepositoryLabelCreated != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelCreated{b.RepositoryLabelCreated}
	}
	if b.RepositoryLabelMoved != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelMoved{b.RepositoryLabelMoved}
	}
	if b.RepositoryLabelArchived != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelArchived{b.RepositoryLabelArchived}
	}
	if b.RepositoryLabelUnarchived != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelUnarchived{b.RepositoryLabelUnarchived}
	}
	if b.CuratedPluginDeleted != nil {
		x.xxx_hidden_Payload = &event_CuratedPluginDeleted{b.CuratedPluginDeleted}
	}
	if b.PayloadServerBreakingChangePolicyEnabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyEnabled{b.PayloadServerBreakingChangePolicyEnabled}
	}
	if b.PayloadServerBreakingChangePolicyDisabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyDisabled{b.PayloadServerBreakingChangePolicyDisabled}
	}
	if b.RepositoryDefaultBranchChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryDefaultBranchChanged{b.RepositoryDefaultBranchChanged}
	}
	if b.PayloadServerUniquenessPolicyEnabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyEnabled{b.PayloadServerUniquenessPolicyEnabled}
	}
	if b.PayloadServerUniquenessPolicyDisabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyDisabled{b.PayloadServerUniquenessPolicyDisabled}
	}
	if b.UserAutoMergedFromNewIdp != nil {
		x.xxx_hidden_Payload = &event_UserAutoMergedFromNewIdp{b.UserAutoMergedFromNewIdp}
	}
	if b.DeviceAuthorizationGrantApproved != nil {
		x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantApproved{b.DeviceAuthorizationGrantApproved}
	}
	if b.DeviceAuthorizationGrantDenied != nil {
		x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantDenied{b.DeviceAuthorizationGrantDenied}
	}
	if b.PluginLabelCreated != nil {
		x.xxx_hidden_Payload = &event_PluginLabelCreated{b.PluginLabelCreated}
	}
	if b.PluginLabelMoved != nil {
		x.xxx_hidden_Payload = &event_PluginLabelMoved{b.PluginLabelMoved}
	}
	if b.PluginLabelArchived != nil {
		x.xxx_hidden_Payload = &event_PluginLabelArchived{b.PluginLabelArchived}
	}
	if b.PluginLabelUnarchived != nil {
		x.xxx_hidden_Payload = &event_PluginLabelUnarchived{b.PluginLabelUnarchived}
	}
	return m0
}

type case_Event_Payload protoreflect.FieldNumber

func (x case_Event_Payload) String() string {
	md := file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isEvent_Payload interface {
	isEvent_Payload()
}

type event_OrganizationCreated struct {
	OrganizationCreated *PayloadOrganizationCreated `protobuf:"bytes,7,opt,name=organization_created,json=organizationCreated,proto3,oneof"`
}

type event_OrganizationDeleted struct {
	OrganizationDeleted *PayloadOrganizationDeleted `protobuf:"bytes,8,opt,name=organization_deleted,json=organizationDeleted,proto3,oneof"`
}

type event_OrganizationMemberAdded struct {
	OrganizationMemberAdded *PayloadOrganizationMemberAdded `protobuf:"bytes,9,opt,name=organization_member_added,json=organizationMemberAdded,proto3,oneof"`
}

type event_OrganizationMemberRoleChanged struct {
	OrganizationMemberRoleChanged *PayloadOrganizationMemberRoleChanged `protobuf:"bytes,10,opt,name=organization_member_role_changed,json=organizationMemberRoleChanged,proto3,oneof"`
}

type event_OrganizationMemberRemoved struct {
	OrganizationMemberRemoved *PayloadOrganizationMemberRemoved `protobuf:"bytes,11,opt,name=organization_member_removed,json=organizationMemberRemoved,proto3,oneof"`
}

type event_RepositoryCreated struct {
	RepositoryCreated *PayloadRepositoryCreated `protobuf:"bytes,12,opt,name=repository_created,json=repositoryCreated,proto3,oneof"`
}

type event_RepositoryDeprecated struct {
	RepositoryDeprecated *PayloadRepositoryDeprecated `protobuf:"bytes,54,opt,name=repository_deprecated,json=repositoryDeprecated,proto3,oneof"`
}

type event_RepositoryUndeprecated struct {
	RepositoryUndeprecated *PayloadRepositoryUndeprecated `protobuf:"bytes,55,opt,name=repository_undeprecated,json=repositoryUndeprecated,proto3,oneof"`
}

type event_RepositoryDeleted struct {
	RepositoryDeleted *PayloadRepositoryDeleted `protobuf:"bytes,13,opt,name=repository_deleted,json=repositoryDeleted,proto3,oneof"`
}

type event_RepositoryCommitPushed struct {
	RepositoryCommitPushed *PayloadRepositoryCommitPushed `protobuf:"bytes,14,opt,name=repository_commit_pushed,json=repositoryCommitPushed,proto3,oneof"`
}

type event_RepositoryContributorAdded struct {
	RepositoryContributorAdded *PayloadRepositoryContributorAdded `protobuf:"bytes,15,opt,name=repository_contributor_added,json=repositoryContributorAdded,proto3,oneof"`
}

type event_RepositoryContributorRoleChanged struct {
	RepositoryContributorRoleChanged *PayloadRepositoryContributorRoleChanged `protobuf:"bytes,16,opt,name=repository_contributor_role_changed,json=repositoryContributorRoleChanged,proto3,oneof"`
}

type event_RepositoryContributorRemoved struct {
	RepositoryContributorRemoved *PayloadRepositoryContributorRemoved `protobuf:"bytes,17,opt,name=repository_contributor_removed,json=repositoryContributorRemoved,proto3,oneof"`
}

type event_RepositoryVisibilityChanged struct {
	RepositoryVisibilityChanged *PayloadRepositoryVisibilityChanged `protobuf:"bytes,18,opt,name=repository_visibility_changed,json=repositoryVisibilityChanged,proto3,oneof"`
}

type event_RepositoryDefaultLabelNameChanged struct {
	RepositoryDefaultLabelNameChanged *PayloadRepositoryDefaultLabelNameChanged `protobuf:"bytes,46,opt,name=repository_default_label_name_changed,json=repositoryDefaultLabelNameChanged,proto3,oneof"`
}

type event_PluginCreated struct {
	PluginCreated *PayloadPluginCreated `protobuf:"bytes,19,opt,name=plugin_created,json=pluginCreated,proto3,oneof"`
}

type event_PluginDeleted struct {
	PluginDeleted *PayloadPluginDeleted `protobuf:"bytes,20,opt,name=plugin_deleted,json=pluginDeleted,proto3,oneof"`
}

type event_PluginCommitPushed struct {
	PluginCommitPushed *PayloadPluginCommitPushed `protobuf:"bytes,49,opt,name=plugin_commit_pushed,json=pluginCommitPushed,proto3,oneof"`
}

type event_UserCreated struct {
	UserCreated *PayloadUserCreated `protobuf:"bytes,21,opt,name=user_created,json=userCreated,proto3,oneof"`
}

type event_UserDeactivated struct {
	UserDeactivated *PayloadUserDeactivated `protobuf:"bytes,22,opt,name=user_deactivated,json=userDeactivated,proto3,oneof"`
}

type event_UserDeleted struct {
	UserDeleted *PayloadUserDeleted `protobuf:"bytes,23,opt,name=user_deleted,json=userDeleted,proto3,oneof"`
}

type event_UserLoggedIn struct {
	UserLoggedIn *PayloadUserLoggedIn `protobuf:"bytes,24,opt,name=user_logged_in,json=userLoggedIn,proto3,oneof"`
}

type event_UserLoggedOut struct {
	UserLoggedOut *PayloadUserLoggedOut `protobuf:"bytes,25,opt,name=user_logged_out,json=userLoggedOut,proto3,oneof"`
}

type event_CuratedPluginCreated struct {
	CuratedPluginCreated *PayloadCuratedPluginCreated `protobuf:"bytes,26,opt,name=curated_plugin_created,json=curatedPluginCreated,proto3,oneof"`
}

type event_IdpGroupAdded struct {
	IdpGroupAdded *PayloadOrganizationIDPGroupAdded `protobuf:"bytes,27,opt,name=idp_group_added,json=idpGroupAdded,proto3,oneof"`
}

type event_IdpGroupRemoved struct {
	IdpGroupRemoved *PayloadOrganizationIDPGroupRemoved `protobuf:"bytes,28,opt,name=idp_group_removed,json=idpGroupRemoved,proto3,oneof"`
}

type event_TokenCreated struct {
	TokenCreated *PayloadTokenCreated `protobuf:"bytes,29,opt,name=token_created,json=tokenCreated,proto3,oneof"`
}

type event_TokenDeleted struct {
	TokenDeleted *PayloadTokenDeleted `protobuf:"bytes,30,opt,name=token_deleted,json=tokenDeleted,proto3,oneof"`
}

type event_UserReactivated struct {
	UserReactivated *PayloadUserReactivated `protobuf:"bytes,31,opt,name=user_reactivated,json=userReactivated,proto3,oneof"`
}

type event_ScimTokenCreated struct {
	ScimTokenCreated *PayloadSCIMTokenCreated `protobuf:"bytes,32,opt,name=scim_token_created,json=scimTokenCreated,proto3,oneof"`
}

type event_ScimTokenDeleted struct {
	ScimTokenDeleted *PayloadSCIMTokenDeleted `protobuf:"bytes,33,opt,name=scim_token_deleted,json=scimTokenDeleted,proto3,oneof"`
}

type event_RepositoryCommitDeleted struct {
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryCommitDeleted *PayloadRepositoryCommitDeleted `protobuf:"bytes,34,opt,name=repository_commit_deleted,json=repositoryCommitDeleted,proto3,oneof"`
}

type event_RepositoryLabelCreated struct {
	RepositoryLabelCreated *PayloadRepositoryLabelCreated `protobuf:"bytes,35,opt,name=repository_label_created,json=repositoryLabelCreated,proto3,oneof"`
}

type event_RepositoryLabelMoved struct {
	RepositoryLabelMoved *PayloadRepositoryLabelMoved `protobuf:"bytes,36,opt,name=repository_label_moved,json=repositoryLabelMoved,proto3,oneof"`
}

type event_RepositoryLabelArchived struct {
	RepositoryLabelArchived *PayloadRepositoryLabelArchived `protobuf:"bytes,44,opt,name=repository_label_archived,json=repositoryLabelArchived,proto3,oneof"`
}

type event_RepositoryLabelUnarchived struct {
	RepositoryLabelUnarchived *PayloadRepositoryLabelUnarchived `protobuf:"bytes,45,opt,name=repository_label_unarchived,json=repositoryLabelUnarchived,proto3,oneof"`
}

type event_CuratedPluginDeleted struct {
	CuratedPluginDeleted *PayloadCuratedPluginDeleted `protobuf:"bytes,37,opt,name=curated_plugin_deleted,json=curatedPluginDeleted,proto3,oneof"`
}

type event_PayloadServerBreakingChangePolicyEnabled struct {
	PayloadServerBreakingChangePolicyEnabled *PayloadServerBreakingChangePolicyEnabled `protobuf:"bytes,38,opt,name=payload_server_breaking_change_policy_enabled,json=payloadServerBreakingChangePolicyEnabled,proto3,oneof"`
}

type event_PayloadServerBreakingChangePolicyDisabled struct {
	PayloadServerBreakingChangePolicyDisabled *PayloadServerBreakingChangePolicyDisabled `protobuf:"bytes,39,opt,name=payload_server_breaking_change_policy_disabled,json=payloadServerBreakingChangePolicyDisabled,proto3,oneof"`
}

type event_RepositoryDefaultBranchChanged struct {
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryDefaultBranchChanged *PayloadRepositoryDefaultBranchChanged `protobuf:"bytes,40,opt,name=repository_default_branch_changed,json=repositoryDefaultBranchChanged,proto3,oneof"`
}

type event_PayloadServerUniquenessPolicyEnabled struct {
	PayloadServerUniquenessPolicyEnabled *PayloadServerUniquenessPolicyEnabled `protobuf:"bytes,41,opt,name=payload_server_uniqueness_policy_enabled,json=payloadServerUniquenessPolicyEnabled,proto3,oneof"`
}

type event_PayloadServerUniquenessPolicyDisabled struct {
	PayloadServerUniquenessPolicyDisabled *PayloadServerUniquenessPolicyDisabled `protobuf:"bytes,42,opt,name=payload_server_uniqueness_policy_disabled,json=payloadServerUniquenessPolicyDisabled,proto3,oneof"`
}

type event_UserAutoMergedFromNewIdp struct {
	UserAutoMergedFromNewIdp *PayloadUserAutoMergedFromNewIdP `protobuf:"bytes,43,opt,name=user_auto_merged_from_new_idp,json=userAutoMergedFromNewIdp,proto3,oneof"`
}

type event_DeviceAuthorizationGrantApproved struct {
	DeviceAuthorizationGrantApproved *PayloadDeviceAuthorizationGrantApproved `protobuf:"bytes,47,opt,name=device_authorization_grant_approved,json=deviceAuthorizationGrantApproved,proto3,oneof"`
}

type event_DeviceAuthorizationGrantDenied struct {
	DeviceAuthorizationGrantDenied *PayloadDeviceAuthorizationGrantDenied `protobuf:"bytes,48,opt,name=device_authorization_grant_denied,json=deviceAuthorizationGrantDenied,proto3,oneof"`
}

type event_PluginLabelCreated struct {
	PluginLabelCreated *PayloadPluginLabelCreated `protobuf:"bytes,50,opt,name=plugin_label_created,json=pluginLabelCreated,proto3,oneof"`
}

type event_PluginLabelMoved struct {
	PluginLabelMoved *PayloadPluginLabelMoved `protobuf:"bytes,51,opt,name=plugin_label_moved,json=pluginLabelMoved,proto3,oneof"`
}

type event_PluginLabelArchived struct {
	PluginLabelArchived *PayloadPluginLabelArchived `protobuf:"bytes,52,opt,name=plugin_label_archived,json=pluginLabelArchived,proto3,oneof"`
}

type event_PluginLabelUnarchived struct {
	PluginLabelUnarchived *PayloadPluginLabelUnarchived `protobuf:"bytes,53,opt,name=plugin_label_unarchived,json=pluginLabelUnarchived,proto3,oneof"`
}

func (*event_OrganizationCreated) isEvent_Payload() {}

func (*event_OrganizationDeleted) isEvent_Payload() {}

func (*event_OrganizationMemberAdded) isEvent_Payload() {}

func (*event_OrganizationMemberRoleChanged) isEvent_Payload() {}

func (*event_OrganizationMemberRemoved) isEvent_Payload() {}

func (*event_RepositoryCreated) isEvent_Payload() {}

func (*event_RepositoryDeprecated) isEvent_Payload() {}

func (*event_RepositoryUndeprecated) isEvent_Payload() {}

func (*event_RepositoryDeleted) isEvent_Payload() {}

func (*event_RepositoryCommitPushed) isEvent_Payload() {}

func (*event_RepositoryContributorAdded) isEvent_Payload() {}

func (*event_RepositoryContributorRoleChanged) isEvent_Payload() {}

func (*event_RepositoryContributorRemoved) isEvent_Payload() {}

func (*event_RepositoryVisibilityChanged) isEvent_Payload() {}

func (*event_RepositoryDefaultLabelNameChanged) isEvent_Payload() {}

func (*event_PluginCreated) isEvent_Payload() {}

func (*event_PluginDeleted) isEvent_Payload() {}

func (*event_PluginCommitPushed) isEvent_Payload() {}

func (*event_UserCreated) isEvent_Payload() {}

func (*event_UserDeactivated) isEvent_Payload() {}

func (*event_UserDeleted) isEvent_Payload() {}

func (*event_UserLoggedIn) isEvent_Payload() {}

func (*event_UserLoggedOut) isEvent_Payload() {}

func (*event_CuratedPluginCreated) isEvent_Payload() {}

func (*event_IdpGroupAdded) isEvent_Payload() {}

func (*event_IdpGroupRemoved) isEvent_Payload() {}

func (*event_TokenCreated) isEvent_Payload() {}

func (*event_TokenDeleted) isEvent_Payload() {}

func (*event_UserReactivated) isEvent_Payload() {}

func (*event_ScimTokenCreated) isEvent_Payload() {}

func (*event_ScimTokenDeleted) isEvent_Payload() {}

func (*event_RepositoryCommitDeleted) isEvent_Payload() {}

func (*event_RepositoryLabelCreated) isEvent_Payload() {}

func (*event_RepositoryLabelMoved) isEvent_Payload() {}

func (*event_RepositoryLabelArchived) isEvent_Payload() {}

func (*event_RepositoryLabelUnarchived) isEvent_Payload() {}

func (*event_CuratedPluginDeleted) isEvent_Payload() {}

func (*event_PayloadServerBreakingChangePolicyEnabled) isEvent_Payload() {}

func (*event_PayloadServerBreakingChangePolicyDisabled) isEvent_Payload() {}

func (*event_RepositoryDefaultBranchChanged) isEvent_Payload() {}

func (*event_PayloadServerUniquenessPolicyEnabled) isEvent_Payload() {}

func (*event_PayloadServerUniquenessPolicyDisabled) isEvent_Payload() {}

func (*event_UserAutoMergedFromNewIdp) isEvent_Payload() {}

func (*event_DeviceAuthorizationGrantApproved) isEvent_Payload() {}

func (*event_DeviceAuthorizationGrantDenied) isEvent_Payload() {}

func (*event_PluginLabelCreated) isEvent_Payload() {}

func (*event_PluginLabelMoved) isEvent_Payload() {}

func (*event_PluginLabelArchived) isEvent_Payload() {}

func (*event_PluginLabelUnarchived) isEvent_Payload() {}

type PayloadOrganizationCreated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadOrganizationCreated) Reset() {
	*x = PayloadOrganizationCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationCreated) ProtoMessage() {}

func (x *PayloadOrganizationCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadOrganizationCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadOrganizationCreated_builder) Build() *PayloadOrganizationCreated {
	m0 := &PayloadOrganizationCreated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadOrganizationDeleted struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadOrganizationDeleted) Reset() {
	*x = PayloadOrganizationDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationDeleted) ProtoMessage() {}

func (x *PayloadOrganizationDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadOrganizationDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadOrganizationDeleted_builder) Build() *PayloadOrganizationDeleted {
	m0 := &PayloadOrganizationDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadOrganizationMemberAdded struct {
	state                       protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                          `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                          `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_MemberRole       v1alpha1.OrganizationRole       `protobuf:"varint,3,opt,name=member_role,json=memberRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_MemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,4,opt,name=member_role_source,json=memberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberAdded) Reset() {
	*x = PayloadOrganizationMemberAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberAdded) ProtoMessage() {}

func (x *PayloadOrganizationMemberAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberAdded) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberAdded) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberAdded) GetMemberRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_MemberRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberAdded) GetMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_MemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberAdded) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberAdded) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberAdded) SetMemberRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_MemberRole = v
}

func (x *PayloadOrganizationMemberAdded) SetMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_MemberRoleSource = v
}

type PayloadOrganizationMemberAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the new member.
	OrganizationId string
	// organization_name is the name of the organization with the new member.
	OrganizationName string
	// member_role is the role granted to the member added to the organization.
	MemberRole v1alpha1.OrganizationRole
	// member_role_source is the source of the role granted to the member.
	MemberRoleSource v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberAdded_builder) Build() *PayloadOrganizationMemberAdded {
	m0 := &PayloadOrganizationMemberAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_MemberRole = b.MemberRole
	x.xxx_hidden_MemberRoleSource = b.MemberRoleSource
	return m0
}

type PayloadOrganizationMemberRoleChanged struct {
	state                          protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId      string                          `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName    string                          `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_OldRole             v1alpha1.OrganizationRole       `protobuf:"varint,3,opt,name=old_role,json=oldRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_NewRole             v1alpha1.OrganizationRole       `protobuf:"varint,4,opt,name=new_role,json=newRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_OldMemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,5,opt,name=old_member_role_source,json=oldMemberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	xxx_hidden_NewMemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,6,opt,name=new_member_role_source,json=newMemberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberRoleChanged) Reset() {
	*x = PayloadOrganizationMemberRoleChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRoleChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRoleChanged) ProtoMessage() {}

func (x *PayloadOrganizationMemberRoleChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberRoleChanged) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRoleChanged) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRoleChanged) GetOldRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OldRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetNewRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_NewRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetOldMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_OldMemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetNewMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_NewMemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRoleChanged) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetOldRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_OldRole = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetNewRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_NewRole = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetOldMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_OldMemberRoleSource = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetNewMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_NewMemberRoleSource = v
}

type PayloadOrganizationMemberRoleChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization within which the role was changed.
	OrganizationId string
	// organization_name is the name of the organization within which the role was changed.
	OrganizationName string
	// old_role is the old role of the member whose role was changed.
	OldRole v1alpha1.OrganizationRole
	// new_role is the new role of the member whose role was changed.
	NewRole v1alpha1.OrganizationRole
	// old_member_role_source is the old source of the role granted to the member.
	OldMemberRoleSource v1alpha1.OrganizationRoleSource
	// new_member_role_source is the new source of the role granted to the member.
	NewMemberRoleSource v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberRoleChanged_builder) Build() *PayloadOrganizationMemberRoleChanged {
	m0 := &PayloadOrganizationMemberRoleChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_OldRole = b.OldRole
	x.xxx_hidden_NewRole = b.NewRole
	x.xxx_hidden_OldMemberRoleSource = b.OldMemberRoleSource
	x.xxx_hidden_NewMemberRoleSource = b.NewMemberRoleSource
	return m0
}

type PayloadOrganizationMemberRemoved struct {
	state                       protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                          `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                          `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_MemberRole       v1alpha1.OrganizationRole       `protobuf:"varint,3,opt,name=member_role,json=memberRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_MemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,4,opt,name=member_role_source,json=memberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberRemoved) Reset() {
	*x = PayloadOrganizationMemberRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRemoved) ProtoMessage() {}

func (x *PayloadOrganizationMemberRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberRemoved) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRemoved) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRemoved) GetMemberRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_MemberRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRemoved) GetMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_MemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRemoved) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberRemoved) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberRemoved) SetMemberRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_MemberRole = v
}

func (x *PayloadOrganizationMemberRemoved) SetMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_MemberRoleSource = v
}

type PayloadOrganizationMemberRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization that the member was removed from.
	OrganizationId string
	// organization_name is the name of the organization that the member was removed from.
	OrganizationName string
	// member_role is the role that the member had when removed from the organization.
	MemberRole v1alpha1.OrganizationRole
	// member_role_source is the source of the role granted to the member.
	MemberRoleSource v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberRemoved_builder) Build() *PayloadOrganizationMemberRemoved {
	m0 := &PayloadOrganizationMemberRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_MemberRole = b.MemberRole
	x.xxx_hidden_MemberRoleSource = b.MemberRoleSource
	return m0
}

type PayloadOrganizationIDPGroupAdded struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                 `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationIDPGroupAdded) Reset() {
	*x = PayloadOrganizationIDPGroupAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupAdded) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationIDPGroupAdded) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupAdded) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupAdded) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationIDPGroupAdded) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

type PayloadOrganizationIDPGroupAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the new IDP group.
	OrganizationId string
	// organization_name is the name of the organization with the new IDP group.
	OrganizationName string
}

func (b0 PayloadOrganizationIDPGroupAdded_builder) Build() *PayloadOrganizationIDPGroupAdded {
	m0 := &PayloadOrganizationIDPGroupAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	return m0
}

type PayloadOrganizationIDPGroupRemoved struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                 `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationIDPGroupRemoved) Reset() {
	*x = PayloadOrganizationIDPGroupRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupRemoved) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationIDPGroupRemoved) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupRemoved) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupRemoved) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationIDPGroupRemoved) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

type PayloadOrganizationIDPGroupRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the removed IDP group.
	OrganizationId string
	// organization_name is the name of the organization with the removed IDP group.
	OrganizationName string
}

func (b0 PayloadOrganizationIDPGroupRemoved_builder) Build() *PayloadOrganizationIDPGroupRemoved {
	m0 := &PayloadOrganizationIDPGroupRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	return m0
}

type PayloadRepositoryCreated struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId          string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName        string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility       v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_DefaultLabelName string                 `protobuf:"bytes,4,opt,name=default_label_name,json=defaultLabelName,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadRepositoryCreated) Reset() {
	*x = PayloadRepositoryCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCreated) ProtoMessage() {}

func (x *PayloadRepositoryCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCreated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryCreated) GetDefaultLabelName() string {
	if x != nil {
		return x.xxx_hidden_DefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryCreated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *PayloadRepositoryCreated) SetDefaultLabelName(v string) {
	x.xxx_hidden_DefaultLabelName = v
}

type PayloadRepositoryCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
	// default_label_name is the name of the default label for the repository.
	// If empty, the repository was created with the default label name of 'main'.
	DefaultLabelName string
}

func (b0 PayloadRepositoryCreated_builder) Build() *PayloadRepositoryCreated {
	m0 := &PayloadRepositoryCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_DefaultLabelName = b.DefaultLabelName
	return m0
}

type PayloadRepositoryDeleted struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadRepositoryDeleted) Reset() {
	*x = PayloadRepositoryDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDeleted) ProtoMessage() {}

func (x *PayloadRepositoryDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDeleted) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDeleted) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadRepositoryDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadRepositoryDeleted_builder) Build() *PayloadRepositoryDeleted {
	m0 := &PayloadRepositoryDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadRepositoryDeprecated struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId            string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName          string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility         v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_DeprecationMessage string                 `protobuf:"bytes,4,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *PayloadRepositoryDeprecated) Reset() {
	*x = PayloadRepositoryDeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDeprecated) ProtoMessage() {}

func (x *PayloadRepositoryDeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryDeprecated) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *PayloadRepositoryDeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *PayloadRepositoryDeprecated) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

type PayloadRepositoryDeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
	// deprecation_message is the deprecation message set by the deprecation actor.
	DeprecationMessage string
}

func (b0 PayloadRepositoryDeprecated_builder) Build() *PayloadRepositoryDeprecated {
	m0 := &PayloadRepositoryDeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	return m0
}

type PayloadRepositoryUndeprecated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadRepositoryUndeprecated) Reset() {
	*x = PayloadRepositoryUndeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryUndeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryUndeprecated) ProtoMessage() {}

func (x *PayloadRepositoryUndeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryUndeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryUndeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryUndeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryUndeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryUndeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryUndeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadRepositoryUndeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadRepositoryUndeprecated_builder) Build() *PayloadRepositoryUndeprecated {
	m0 := &PayloadRepositoryUndeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadRepositoryCommitPushed struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Tags           []string               `protobuf:"bytes,5,rep,name=tags,proto3"`
	xxx_hidden_DraftName      string                 `protobuf:"bytes,6,opt,name=draft_name,json=draftName,proto3"`
	xxx_hidden_ManifestDigest string                 `protobuf:"bytes,7,opt,name=manifest_digest,json=manifestDigest,proto3"`
	xxx_hidden_B5Digest       string                 `protobuf:"bytes,8,opt,name=b5_digest,json=b5Digest,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryCommitPushed) Reset() {
	*x = PayloadRepositoryCommitPushed{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCommitPushed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCommitPushed) ProtoMessage() {}

func (x *PayloadRepositoryCommitPushed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryCommitPushed) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetTags() []string {
	if x != nil {
		return x.xxx_hidden_Tags
	}
	return nil
}

func (x *PayloadRepositoryCommitPushed) GetDraftName() string {
	if x != nil {
		return x.xxx_hidden_DraftName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetManifestDigest() string {
	if x != nil {
		return x.xxx_hidden_ManifestDigest
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetB5Digest() string {
	if x != nil {
		return x.xxx_hidden_B5Digest
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryCommitPushed) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryCommitPushed) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryCommitPushed) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryCommitPushed) SetTags(v []string) {
	x.xxx_hidden_Tags = v
}

func (x *PayloadRepositoryCommitPushed) SetDraftName(v string) {
	x.xxx_hidden_DraftName = v
}

func (x *PayloadRepositoryCommitPushed) SetManifestDigest(v string) {
	x.xxx_hidden_ManifestDigest = v
}

func (x *PayloadRepositoryCommitPushed) SetB5Digest(v string) {
	x.xxx_hidden_B5Digest = v
}

type PayloadRepositoryCommitPushed_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository within which the commit was created.
	RepositoryId string
	// repository_name is the name of the repository within which the commit was created.
	RepositoryName string
	// tags are the tags included in the push. Optional.
	Tags []string
	// draft_name is the name of the draft. Optional.
	DraftName string
	// manifest_digest is the module's manifest digest.
	ManifestDigest string
	// b5_digest is the module's b5 digest.
	B5Digest string
}

func (b0 PayloadRepositoryCommitPushed_builder) Build() *PayloadRepositoryCommitPushed {
	m0 := &PayloadRepositoryCommitPushed{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Tags = b.Tags
	x.xxx_hidden_DraftName = b.DraftName
	x.xxx_hidden_ManifestDigest = b.ManifestDigest
	x.xxx_hidden_B5Digest = b.B5Digest
	return m0
}

type PayloadRepositoryContributorAdded struct {
	state                      protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OwnerId         string                  `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName       string                  `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId    string                  `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName  string                  `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ContributorRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=contributor_role,json=contributorRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorAdded) Reset() {
	*x = PayloadRepositoryContributorAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorAdded) ProtoMessage() {}

func (x *PayloadRepositoryContributorAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorAdded) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetContributorRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ContributorRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorAdded) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorAdded) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorAdded) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorAdded) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorAdded) SetContributorRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_ContributorRole = v
}

type PayloadRepositoryContributorAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository with the new contributor.
	RepositoryId string
	// repository_name is the name of the repository with the new contributor.
	RepositoryName string
	// contributor_role is the role granted to the contributor added to the repository.
	ContributorRole v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryContributorAdded_builder) Build() *PayloadRepositoryContributorAdded {
	m0 := &PayloadRepositoryContributorAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ContributorRole = b.ContributorRole
	return m0
}

type PayloadRepositoryContributorRoleChanged struct {
	state                     protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                  `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                  `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                  `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                  `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_OldRole        v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=old_role,json=oldRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_NewRole        v1alpha1.RepositoryRole `protobuf:"varint,6,opt,name=new_role,json=newRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorRoleChanged) Reset() {
	*x = PayloadRepositoryContributorRoleChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRoleChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRoleChanged) ProtoMessage() {}

func (x *PayloadRepositoryContributorRoleChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorRoleChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetOldRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_OldRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRoleChanged) GetNewRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_NewRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRoleChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetOldRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_OldRole = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetNewRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_NewRole = v
}

type PayloadRepositoryContributorRoleChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository within which the role was changed.
	RepositoryId string
	// repository_name is the name of the repository within which the role was changed.
	RepositoryName string
	// old_role is the old role of the contributor whose role was changed.
	OldRole v1alpha1.RepositoryRole
	// new_role is the new role of the contributor whose role was changed.
	NewRole v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryContributorRoleChanged_builder) Build() *PayloadRepositoryContributorRoleChanged {
	m0 := &PayloadRepositoryContributorRoleChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_OldRole = b.OldRole
	x.xxx_hidden_NewRole = b.NewRole
	return m0
}

type PayloadRepositoryContributorRemoved struct {
	state                      protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OwnerId         string                  `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName       string                  `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId    string                  `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName  string                  `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ContributorRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=contributor_role,json=contributorRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorRemoved) Reset() {
	*x = PayloadRepositoryContributorRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRemoved) ProtoMessage() {}

func (x *PayloadRepositoryContributorRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorRemoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetContributorRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ContributorRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRemoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorRemoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorRemoved) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorRemoved) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorRemoved) SetContributorRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_ContributorRole = v
}

type PayloadRepositoryContributorRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository that the contributor was removed from.
	RepositoryId string
	// repository_name is the name of the repository that the contributor was removed from.
	RepositoryName string
	// contributor_role is the role that the contributor had when removed from the repository.
	ContributorRole v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryContributorRemoved_builder) Build() *PayloadRepositoryContributorRemoved {
	m0 := &PayloadRepositoryContributorRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ContributorRole = b.ContributorRole
	return m0
}

type PayloadRepositoryVisibilityChanged struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId       string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName     string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldVisibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=old_visibility,json=oldVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_NewVisibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=new_visibility,json=newVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *PayloadRepositoryVisibilityChanged) Reset() {
	*x = PayloadRepositoryVisibilityChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryVisibilityChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryVisibilityChanged) ProtoMessage() {}

func (x *PayloadRepositoryVisibilityChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryVisibilityChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryVisibilityChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryVisibilityChanged) GetOldVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_OldVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryVisibilityChanged) GetNewVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_NewVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryVisibilityChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryVisibilityChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryVisibilityChanged) SetOldVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_OldVisibility = v
}

func (x *PayloadRepositoryVisibilityChanged) SetNewVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_NewVisibility = v
}

type PayloadRepositoryVisibilityChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// old_visibility is the old visibility of the repository.
	OldVisibility v1alpha1.Visibility
	// new_visibility is the new visibility of the repository.
	NewVisibility v1alpha1.Visibility
}

func (b0 PayloadRepositoryVisibilityChanged_builder) Build() *PayloadRepositoryVisibilityChanged {
	m0 := &PayloadRepositoryVisibilityChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldVisibility = b.OldVisibility
	x.xxx_hidden_NewVisibility = b.NewVisibility
	return m0
}

type PayloadRepositoryDefaultLabelNameChanged struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId             string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName           string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldDefaultLabelName string                 `protobuf:"bytes,3,opt,name=old_default_label_name,json=oldDefaultLabelName,proto3"`
	xxx_hidden_NewDefaultLabelName string                 `protobuf:"bytes,4,opt,name=new_default_label_name,json=newDefaultLabelName,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadRepositoryDefaultLabelNameChanged) Reset() {
	*x = PayloadRepositoryDefaultLabelNameChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDefaultLabelNameChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDefaultLabelNameChanged) ProtoMessage() {}

func (x *PayloadRepositoryDefaultLabelNameChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOldDefaultLabelName() string {
	if x != nil {
		return x.xxx_hidden_OldDefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetNewDefaultLabelName() string {
	if x != nil {
		return x.xxx_hidden_NewDefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetOldDefaultLabelName(v string) {
	x.xxx_hidden_OldDefaultLabelName = v
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetNewDefaultLabelName(v string) {
	x.xxx_hidden_NewDefaultLabelName = v
}

type PayloadRepositoryDefaultLabelNameChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// old_default_label_name is the old default label name of the repository.
	OldDefaultLabelName string
	// new_default_label_name is the new default label name of the repository.
	NewDefaultLabelName string
}

func (b0 PayloadRepositoryDefaultLabelNameChanged_builder) Build() *PayloadRepositoryDefaultLabelNameChanged {
	m0 := &PayloadRepositoryDefaultLabelNameChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldDefaultLabelName = b.OldDefaultLabelName
	x.xxx_hidden_NewDefaultLabelName = b.NewDefaultLabelName
	return m0
}

// PayloadRepositoryDefaultBranchChanged is deprecated.
//
// Use PayloadRepositoryDefaultLabelNameChanged instead.
//
// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryDefaultBranchChanged struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId          string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName        string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldDefaultBranch string                 `protobuf:"bytes,3,opt,name=old_default_branch,json=oldDefaultBranch,proto3"`
	xxx_hidden_NewDefaultBranch string                 `protobuf:"bytes,4,opt,name=new_default_branch,json=newDefaultBranch,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadRepositoryDefaultBranchChanged) Reset() {
	*x = PayloadRepositoryDefaultBranchChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDefaultBranchChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDefaultBranchChanged) ProtoMessage() {}

func (x *PayloadRepositoryDefaultBranchChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOldDefaultBranch() string {
	if x != nil {
		return x.xxx_hidden_OldDefaultBranch
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetNewDefaultBranch() string {
	if x != nil {
		return x.xxx_hidden_NewDefaultBranch
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDefaultBranchChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDefaultBranchChanged) SetOldDefaultBranch(v string) {
	x.xxx_hidden_OldDefaultBranch = v
}

func (x *PayloadRepositoryDefaultBranchChanged) SetNewDefaultBranch(v string) {
	x.xxx_hidden_NewDefaultBranch = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryDefaultBranchChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// old_default_branch is the old default branch of the repository.
	OldDefaultBranch string
	// new_default_branch is the new default branch of the repository.
	NewDefaultBranch string
}

func (b0 PayloadRepositoryDefaultBranchChanged_builder) Build() *PayloadRepositoryDefaultBranchChanged {
	m0 := &PayloadRepositoryDefaultBranchChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldDefaultBranch = b.OldDefaultBranch
	x.xxx_hidden_NewDefaultBranch = b.NewDefaultBranch
	return m0
}

type PayloadPluginCreated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginCreated) Reset() {
	*x = PayloadPluginCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginCreated) ProtoMessage() {}

func (x *PayloadPluginCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginCreated) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginCreated) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

type PayloadPluginCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
}

func (b0 PayloadPluginCreated_builder) Build() *PayloadPluginCreated {
	m0 := &PayloadPluginCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	return m0
}

type PayloadPluginDeleted struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginDeleted) Reset() {
	*x = PayloadPluginDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginDeleted) ProtoMessage() {}

func (x *PayloadPluginDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginDeleted) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginDeleted) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

type PayloadPluginDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the check plugin.
	OwnerId string
	// owner_name is the name of the owner of the check plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
}

func (b0 PayloadPluginDeleted_builder) Build() *PayloadPluginDeleted {
	m0 := &PayloadPluginDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	return m0
}

type PayloadPluginCommitPushed struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	xxx_hidden_P1Digest   string                 `protobuf:"bytes,5,opt,name=p1_digest,json=p1Digest,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginCommitPushed) Reset() {
	*x = PayloadPluginCommitPushed{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginCommitPushed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginCommitPushed) ProtoMessage() {}

func (x *PayloadPluginCommitPushed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginCommitPushed) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetP1Digest() string {
	if x != nil {
		return x.xxx_hidden_P1Digest
	}
	return ""
}

func (x *PayloadPluginCommitPushed) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginCommitPushed) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginCommitPushed) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginCommitPushed) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

func (x *PayloadPluginCommitPushed) SetP1Digest(v string) {
	x.xxx_hidden_P1Digest = v
}

type PayloadPluginCommitPushed_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
	// plugin_id is the id of the plugin.
	PluginId string
	// plugin_name is the name of the plugin.
	PluginName string
	// p1_digest is the p1 digest of the pushed plugin commit.
	P1Digest string
}

func (b0 PayloadPluginCommitPushed_builder) Build() *PayloadPluginCommitPushed {
	m0 := &PayloadPluginCommitPushed{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	x.xxx_hidden_P1Digest = b.P1Digest
	return m0
}

type PayloadUserCreated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserCreated) Reset() {
	*x = PayloadUserCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserCreated) ProtoMessage() {}

func (x *PayloadUserCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserCreated_builder) Build() *PayloadUserCreated {
	m0 := &PayloadUserCreated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserReactivated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserReactivated) Reset() {
	*x = PayloadUserReactivated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserReactivated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserReactivated) ProtoMessage() {}

func (x *PayloadUserReactivated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserReactivated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserReactivated_builder) Build() *PayloadUserReactivated {
	m0 := &PayloadUserReactivated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserDeactivated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserDeactivated) Reset() {
	*x = PayloadUserDeactivated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserDeactivated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserDeactivated) ProtoMessage() {}

func (x *PayloadUserDeactivated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserDeactivated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserDeactivated_builder) Build() *PayloadUserDeactivated {
	m0 := &PayloadUserDeactivated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserDeleted struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserDeleted) Reset() {
	*x = PayloadUserDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserDeleted) ProtoMessage() {}

func (x *PayloadUserDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserDeleted_builder) Build() *PayloadUserDeleted {
	m0 := &PayloadUserDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserLoggedIn struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserLoggedIn) Reset() {
	*x = PayloadUserLoggedIn{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserLoggedIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserLoggedIn) ProtoMessage() {}

func (x *PayloadUserLoggedIn) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserLoggedIn_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserLoggedIn_builder) Build() *PayloadUserLoggedIn {
	m0 := &PayloadUserLoggedIn{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserLoggedOut struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserLoggedOut) Reset() {
	*x = PayloadUserLoggedOut{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserLoggedOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserLoggedOut) ProtoMessage() {}

func (x *PayloadUserLoggedOut) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserLoggedOut_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserLoggedOut_builder) Build() *PayloadUserLoggedOut {
	m0 := &PayloadUserLoggedOut{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// PayloadUserAutoMergedFromNewIdP is the payload for the audit event
// EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP. It has no additional information
// to be included, since the new user is automatically merged to an existing user
// without the new user being created.
type PayloadUserAutoMergedFromNewIdP struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserAutoMergedFromNewIdP) Reset() {
	*x = PayloadUserAutoMergedFromNewIdP{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserAutoMergedFromNewIdP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserAutoMergedFromNewIdP) ProtoMessage() {}

func (x *PayloadUserAutoMergedFromNewIdP) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserAutoMergedFromNewIdP_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserAutoMergedFromNewIdP_builder) Build() *PayloadUserAutoMergedFromNewIdP {
	m0 := &PayloadUserAutoMergedFromNewIdP{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadCuratedPluginCreated struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId   string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *PayloadCuratedPluginCreated) Reset() {
	*x = PayloadCuratedPluginCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadCuratedPluginCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadCuratedPluginCreated) ProtoMessage() {}

func (x *PayloadCuratedPluginCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadCuratedPluginCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadCuratedPluginCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadCuratedPluginCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadCuratedPluginCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

type PayloadCuratedPluginCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
}

func (b0 PayloadCuratedPluginCreated_builder) Build() *PayloadCuratedPluginCreated {
	m0 := &PayloadCuratedPluginCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	return m0
}

type PayloadCuratedPluginDeleted struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId   string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *PayloadCuratedPluginDeleted) Reset() {
	*x = PayloadCuratedPluginDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadCuratedPluginDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadCuratedPluginDeleted) ProtoMessage() {}

func (x *PayloadCuratedPluginDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadCuratedPluginDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadCuratedPluginDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadCuratedPluginDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadCuratedPluginDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

type PayloadCuratedPluginDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
}

func (b0 PayloadCuratedPluginDeleted_builder) Build() *PayloadCuratedPluginDeleted {
	m0 := &PayloadCuratedPluginDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	return m0
}

type PayloadTokenCreated struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId         string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_TokenExpiryTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=token_expiry_time,json=tokenExpiryTime,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadTokenCreated) Reset() {
	*x = PayloadTokenCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadTokenCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadTokenCreated) ProtoMessage() {}

func (x *PayloadTokenCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadTokenCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadTokenCreated) GetTokenExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_TokenExpiryTime
	}
	return nil
}

func (x *PayloadTokenCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadTokenCreated) SetTokenExpiryTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_TokenExpiryTime = v
}

func (x *PayloadTokenCreated) HasTokenExpiryTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_TokenExpiryTime != nil
}

func (x *PayloadTokenCreated) ClearTokenExpiryTime() {
	x.xxx_hidden_TokenExpiryTime = nil
}

type PayloadTokenCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the token.
	OwnerId string
	// token_expiry_time is the expiry time of the token.
	TokenExpiryTime *timestamppb.Timestamp
}

func (b0 PayloadTokenCreated_builder) Build() *PayloadTokenCreated {
	m0 := &PayloadTokenCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_TokenExpiryTime = b.TokenExpiryTime
	return m0
}

type PayloadTokenDeleted struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PayloadTokenDeleted) Reset() {
	*x = PayloadTokenDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadTokenDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadTokenDeleted) ProtoMessage() {}

func (x *PayloadTokenDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadTokenDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadTokenDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

type PayloadTokenDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the token.
	OwnerId string
}

func (b0 PayloadTokenDeleted_builder) Build() *PayloadTokenDeleted {
	m0 := &PayloadTokenDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	return m0
}

type PayloadSCIMTokenCreated struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TokenExpiryTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=token_expiry_time,json=tokenExpiryTime,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadSCIMTokenCreated) Reset() {
	*x = PayloadSCIMTokenCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSCIMTokenCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSCIMTokenCreated) ProtoMessage() {}

func (x *PayloadSCIMTokenCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadSCIMTokenCreated) GetTokenExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_TokenExpiryTime
	}
	return nil
}

func (x *PayloadSCIMTokenCreated) SetTokenExpiryTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_TokenExpiryTime = v
}

func (x *PayloadSCIMTokenCreated) HasTokenExpiryTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_TokenExpiryTime != nil
}

func (x *PayloadSCIMTokenCreated) ClearTokenExpiryTime() {
	x.xxx_hidden_TokenExpiryTime = nil
}

type PayloadSCIMTokenCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// token_expiry_time is the expiry time of the token.
	TokenExpiryTime *timestamppb.Timestamp
}

func (b0 PayloadSCIMTokenCreated_builder) Build() *PayloadSCIMTokenCreated {
	m0 := &PayloadSCIMTokenCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TokenExpiryTime = b.TokenExpiryTime
	return m0
}

type PayloadSCIMTokenDeleted struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadSCIMTokenDeleted) Reset() {
	*x = PayloadSCIMTokenDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSCIMTokenDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSCIMTokenDeleted) ProtoMessage() {}

func (x *PayloadSCIMTokenDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadSCIMTokenDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadSCIMTokenDeleted_builder) Build() *PayloadSCIMTokenDeleted {
	m0 := &PayloadSCIMTokenDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// PayloadRepositoryCommitDeleted is deprecated.
//
// Individual repository commits cannot be deleted.
//
// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryCommitDeleted struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_DraftName      string                 `protobuf:"bytes,5,opt,name=draft_name,json=draftName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryCommitDeleted) Reset() {
	*x = PayloadRepositoryCommitDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCommitDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCommitDeleted) ProtoMessage() {}

func (x *PayloadRepositoryCommitDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryCommitDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetDraftName() string {
	if x != nil {
		return x.xxx_hidden_DraftName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryCommitDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryCommitDeleted) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryCommitDeleted) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryCommitDeleted) SetDraftName(v string) {
	x.xxx_hidden_DraftName = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryCommitDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository from which the commit will be deleted.
	OwnerId string
	// owner_name is the name of the owner of the repository from which the commit will be deleted.
	OwnerName string
	// repository_id is the id of the repository from which the commit will be deleted.
	RepositoryId string
	// repository_name is the name of the repository from which the commit will be deleted.
	RepositoryName string
	// draft_name is the name of the draft. Optional.
	DraftName string
}

func (b0 PayloadRepositoryCommitDeleted_builder) Build() *PayloadRepositoryCommitDeleted {
	m0 := &PayloadRepositoryCommitDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_DraftName = b.DraftName
	return m0
}

type PayloadRepositoryLabelCreated struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_LabelNamespace string                 `protobuf:"bytes,5,opt,name=label_namespace,json=labelNamespace,proto3"`
	xxx_hidden_CommitId       string                 `protobuf:"bytes,6,opt,name=commit_id,json=commitId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelCreated) Reset() {
	*x = PayloadRepositoryLabelCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelCreated) ProtoMessage() {}

func (x *PayloadRepositoryLabelCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelCreated) GetLabelNamespace() string {
	if x != nil {
		return x.xxx_hidden_LabelNamespace
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetCommitId() string {
	if x != nil {
		return x.xxx_hidden_CommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelCreated) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelCreated) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelCreated) SetLabelNamespace(v string) {
	x.xxx_hidden_LabelNamespace = v
}

func (x *PayloadRepositoryLabelCreated) SetCommitId(v string) {
	x.xxx_hidden_CommitId = v
}

type PayloadRepositoryLabelCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was created.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was created.
	OwnerName string
	// repository_id is the id of the repository on which the label was created.
	RepositoryId string
	// repository_name is the name of the repository from which the label was created.
	RepositoryName string
	// label_namespace is the namespace of the label that was created.
	//
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	LabelNamespace string
	// commit_id is the id of the commit on which the label was created.
	CommitId string
}

func (b0 PayloadRepositoryLabelCreated_builder) Build() *PayloadRepositoryLabelCreated {
	m0 := &PayloadRepositoryLabelCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_LabelNamespace = b.LabelNamespace
	x.xxx_hidden_CommitId = b.CommitId
	return m0
}

type PayloadRepositoryLabelMoved struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_LabelNamespace string                 `protobuf:"bytes,5,opt,name=label_namespace,json=labelNamespace,proto3"`
	xxx_hidden_ToCommitId     string                 `protobuf:"bytes,6,opt,name=to_commit_id,json=toCommitId,proto3"`
	xxx_hidden_FromCommitId   string                 `protobuf:"bytes,7,opt,name=from_commit_id,json=fromCommitId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelMoved) Reset() {
	*x = PayloadRepositoryLabelMoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelMoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelMoved) ProtoMessage() {}

func (x *PayloadRepositoryLabelMoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelMoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelMoved) GetLabelNamespace() string {
	if x != nil {
		return x.xxx_hidden_LabelNamespace
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetToCommitId() string {
	if x != nil {
		return x.xxx_hidden_ToCommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetFromCommitId() string {
	if x != nil {
		return x.xxx_hidden_FromCommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelMoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelMoved) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelMoved) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelMoved) SetLabelNamespace(v string) {
	x.xxx_hidden_LabelNamespace = v
}

func (x *PayloadRepositoryLabelMoved) SetToCommitId(v string) {
	x.xxx_hidden_ToCommitId = v
}

func (x *PayloadRepositoryLabelMoved) SetFromCommitId(v string) {
	x.xxx_hidden_FromCommitId = v
}

type PayloadRepositoryLabelMoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was moved.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was moved.
	OwnerName string
	// repository_id is the id of the repository on which the label was moved.
	RepositoryId string
	// repository_name is the name of the repository from which the label was moved.
	RepositoryName string
	// label_namespace is the namespace of the label that was moved.
	//
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	LabelNamespace string
	// to_commit_id is the id of the commit on which the label was moved to.
	ToCommitId string
	// from_commit_id is the id of the commit on which the label was moved from.
	FromCommitId string
}

func (b0 PayloadRepositoryLabelMoved_builder) Build() *PayloadRepositoryLabelMoved {
	m0 := &PayloadRepositoryLabelMoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_LabelNamespace = b.LabelNamespace
	x.xxx_hidden_ToCommitId = b.ToCommitId
	x.xxx_hidden_FromCommitId = b.FromCommitId
	return m0
}

type PayloadRepositoryLabelArchived struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelArchived) Reset() {
	*x = PayloadRepositoryLabelArchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelArchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelArchived) ProtoMessage() {}

func (x *PayloadRepositoryLabelArchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelArchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelArchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelArchived) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelArchived) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

type PayloadRepositoryLabelArchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was archived.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was archived.
	OwnerName string
	// repository_id is the id of the repository on which the label was archived.
	RepositoryId string
	// repository_name is the name of the repository from which the label was archived.
	RepositoryName string
}

func (b0 PayloadRepositoryLabelArchived_builder) Build() *PayloadRepositoryLabelArchived {
	m0 := &PayloadRepositoryLabelArchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	return m0
}

type PayloadRepositoryLabelUnarchived struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelUnarchived) Reset() {
	*x = PayloadRepositoryLabelUnarchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelUnarchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelUnarchived) ProtoMessage() {}

func (x *PayloadRepositoryLabelUnarchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelUnarchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelUnarchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelUnarchived) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelUnarchived) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

type PayloadRepositoryLabelUnarchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was unarchived.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was unarchived.
	OwnerName string
	// repository_id is the id of the repository on which the label was unarchived.
	RepositoryId string
	// repository_name is the name of the repository from which the label was unarchived.
	RepositoryName string
}

func (b0 PayloadRepositoryLabelUnarchived_builder) Build() *PayloadRepositoryLabelUnarchived {
	m0 := &PayloadRepositoryLabelUnarchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	return m0
}

type PayloadServerBreakingChangePolicyEnabled struct {
	state                             protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Category               v1alpha1.BreakingChangeCategory `protobuf:"varint,1,opt,name=category,proto3,enum=buf.alpha.registry.v1alpha1.BreakingChangeCategory"`
	xxx_hidden_IgnoreUnstablePackages bool                            `protobuf:"varint,2,opt,name=ignore_unstable_packages,json=ignoreUnstablePackages,proto3,oneof"`
	XXX_raceDetectHookData            protoimpl.RaceDetectHookData
	XXX_presence                      [1]uint32
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *PayloadServerBreakingChangePolicyEnabled) Reset() {
	*x = PayloadServerBreakingChangePolicyEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerBreakingChangePolicyEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerBreakingChangePolicyEnabled) ProtoMessage() {}

func (x *PayloadServerBreakingChangePolicyEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadServerBreakingChangePolicyEnabled) GetCategory() v1alpha1.BreakingChangeCategory {
	if x != nil {
		return x.xxx_hidden_Category
	}
	return v1alpha1.BreakingChangeCategory(0)
}

func (x *PayloadServerBreakingChangePolicyEnabled) GetIgnoreUnstablePackages() bool {
	if x != nil {
		return x.xxx_hidden_IgnoreUnstablePackages
	}
	return false
}

func (x *PayloadServerBreakingChangePolicyEnabled) SetCategory(v v1alpha1.BreakingChangeCategory) {
	x.xxx_hidden_Category = v
}

func (x *PayloadServerBreakingChangePolicyEnabled) SetIgnoreUnstablePackages(v bool) {
	x.xxx_hidden_IgnoreUnstablePackages = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 1, 2)
}

func (x *PayloadServerBreakingChangePolicyEnabled) HasIgnoreUnstablePackages() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 1)
}

func (x *PayloadServerBreakingChangePolicyEnabled) ClearIgnoreUnstablePackages() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 1)
	x.xxx_hidden_IgnoreUnstablePackages = false
}

type PayloadServerBreakingChangePolicyEnabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// category is the category of breaking changes.
	Category v1alpha1.BreakingChangeCategory
	// ignore_unstable_packages tracks breaking change enforcement for unstable packages.
	IgnoreUnstablePackages *bool
}

func (b0 PayloadServerBreakingChangePolicyEnabled_builder) Build() *PayloadServerBreakingChangePolicyEnabled {
	m0 := &PayloadServerBreakingChangePolicyEnabled{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Category = b.Category
	if b.IgnoreUnstablePackages != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 1, 2)
		x.xxx_hidden_IgnoreUnstablePackages = *b.IgnoreUnstablePackages
	}
	return m0
}

type PayloadServerBreakingChangePolicyDisabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerBreakingChangePolicyDisabled) Reset() {
	*x = PayloadServerBreakingChangePolicyDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerBreakingChangePolicyDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerBreakingChangePolicyDisabled) ProtoMessage() {}

func (x *PayloadServerBreakingChangePolicyDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerBreakingChangePolicyDisabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerBreakingChangePolicyDisabled_builder) Build() *PayloadServerBreakingChangePolicyDisabled {
	m0 := &PayloadServerBreakingChangePolicyDisabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadServerUniquenessPolicyEnabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerUniquenessPolicyEnabled) Reset() {
	*x = PayloadServerUniquenessPolicyEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerUniquenessPolicyEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerUniquenessPolicyEnabled) ProtoMessage() {}

func (x *PayloadServerUniquenessPolicyEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerUniquenessPolicyEnabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerUniquenessPolicyEnabled_builder) Build() *PayloadServerUniquenessPolicyEnabled {
	m0 := &PayloadServerUniquenessPolicyEnabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadServerUniquenessPolicyDisabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerUniquenessPolicyDisabled) Reset() {
	*x = PayloadServerUniquenessPolicyDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerUniquenessPolicyDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerUniquenessPolicyDisabled) ProtoMessage() {}

func (x *PayloadServerUniquenessPolicyDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerUniquenessPolicyDisabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerUniquenessPolicyDisabled_builder) Build() *PayloadServerUniquenessPolicyDisabled {
	m0 := &PayloadServerUniquenessPolicyDisabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadDeviceAuthorizationGrantApproved struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ClientId string                 `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PayloadDeviceAuthorizationGrantApproved) Reset() {
	*x = PayloadDeviceAuthorizationGrantApproved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadDeviceAuthorizationGrantApproved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadDeviceAuthorizationGrantApproved) ProtoMessage() {}

func (x *PayloadDeviceAuthorizationGrantApproved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadDeviceAuthorizationGrantApproved) GetClientId() string {
	if x != nil {
		return x.xxx_hidden_ClientId
	}
	return ""
}

func (x *PayloadDeviceAuthorizationGrantApproved) SetClientId(v string) {
	x.xxx_hidden_ClientId = v
}

type PayloadDeviceAuthorizationGrantApproved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// client_id is the id of the registered oauth2 client of the grant.
	ClientId string
}

func (b0 PayloadDeviceAuthorizationGrantApproved_builder) Build() *PayloadDeviceAuthorizationGrantApproved {
	m0 := &PayloadDeviceAuthorizationGrantApproved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ClientId = b.ClientId
	return m0
}

type PayloadDeviceAuthorizationGrantDenied struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ClientId string                 `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PayloadDeviceAuthorizationGrantDenied) Reset() {
	*x = PayloadDeviceAuthorizationGrantDenied{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadDeviceAuthorizationGrantDenied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadDeviceAuthorizationGrantDenied) ProtoMessage() {}

func (x *PayloadDeviceAuthorizationGrantDenied) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadDeviceAuthorizationGrantDenied) GetClientId() string {
	if x != nil {
		return x.xxx_hidden_ClientId
	}
	return ""
}

func (x *PayloadDeviceAuthorizationGrantDenied) SetClientId(v string) {
	x.xxx_hidden_ClientId = v
}

type PayloadDeviceAuthorizationGrantDenied_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// client_id is the id of the registered oauth2 client of the grant.
	ClientId string
}

func (b0 PayloadDeviceAuthorizationGrantDenied_builder) Build() *PayloadDeviceAuthorizationGrantDenied {
	m0 := &PayloadDeviceAuthorizationGrantDenied{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ClientId = b.ClientId
	return m0
}

type PayloadPluginLabelCreated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	xxx_hidden_CommitId   string                 `protobuf:"bytes,6,opt,name=commit_id,json=commitId,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginLabelCreated) Reset() {
	*x = PayloadPluginLabelCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelCreated) ProtoMessage() {}

func (x *PayloadPluginLabelCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetCommitId() string {
	if x != nil {
		return x.xxx_hidden_CommitId
	}
	return ""
}

func (x *PayloadPluginLabelCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelCreated) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelCreated) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

func (x *PayloadPluginLabelCreated) SetCommitId(v string) {
	x.xxx_hidden_CommitId = v
}

type PayloadPluginLabelCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was created.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was created.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was created.
	PluginId string
	// plugin_name is the name of the plugin from which the label was created.
	PluginName string
	// commit_id is the id of the commit on which the label was created.
	CommitId string
}

func (b0 PayloadPluginLabelCreated_builder) Build() *PayloadPluginLabelCreated {
	m0 := &PayloadPluginLabelCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	x.xxx_hidden_CommitId = b.CommitId
	return m0
}

type PayloadPluginLabelMoved struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId      string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName    string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId     string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName   string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	xxx_hidden_ToCommitId   string                 `protobuf:"bytes,6,opt,name=to_commit_id,json=toCommitId,proto3"`
	xxx_hidden_FromCommitId string                 `protobuf:"bytes,7,opt,name=from_commit_id,json=fromCommitId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *PayloadPluginLabelMoved) Reset() {
	*x = PayloadPluginLabelMoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelMoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelMoved) ProtoMessage() {}

func (x *PayloadPluginLabelMoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelMoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetToCommitId() string {
	if x != nil {
		return x.xxx_hidden_ToCommitId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetFromCommitId() string {
	if x != nil {
		return x.xxx_hidden_FromCommitId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelMoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelMoved) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelMoved) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

func (x *PayloadPluginLabelMoved) SetToCommitId(v string) {
	x.xxx_hidden_ToCommitId = v
}

func (x *PayloadPluginLabelMoved) SetFromCommitId(v string) {
	x.xxx_hidden_FromCommitId = v
}

type PayloadPluginLabelMoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was moved.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was moved.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was moved.
	PluginId string
	// plugin_name is the name of the plugin from which the label was moved.
	PluginName string
	// to_commit_id is the id of the commit on which the label was moved to.
	ToCommitId string
	// from_commit_id is the id of the commit on which the label was moved from.
	FromCommitId string
}

func (b0 PayloadPluginLabelMoved_builder) Build() *PayloadPluginLabelMoved {
	m0 := &PayloadPluginLabelMoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	x.xxx_hidden_ToCommitId = b.ToCommitId
	x.xxx_hidden_FromCommitId = b.FromCommitId
	return m0
}

type PayloadPluginLabelArchived struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginLabelArchived) Reset() {
	*x = PayloadPluginLabelArchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelArchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelArchived) ProtoMessage() {}

func (x *PayloadPluginLabelArchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelArchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelArchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelArchived) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelArchived) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelArchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelArchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelArchived) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelArchived) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadPluginLabelArchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was archived.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was archived.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was archived.
	PluginId string
	// plugin_name is the name of the plugin from which the label was archived.
	PluginName string
}

func (b0 PayloadPluginLabelArchived_builder) Build() *PayloadPluginLabelArchived {
	m0 := &PayloadPluginLabelArchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

type PayloadPluginLabelUnarchived struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginLabelUnarchived) Reset() {
	*x = PayloadPluginLabelUnarchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelUnarchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelUnarchived) ProtoMessage() {}

func (x *PayloadPluginLabelUnarchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelUnarchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelUnarchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelUnarchived) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelUnarchived) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadPluginLabelUnarchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was unarchived.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was unarchived.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was unarchived.
	PluginId string
	// plugin_name is the name of the plugin from which the label was unarchived.
	PluginName string
}

func (b0 PayloadPluginLabelUnarchived_builder) Build() *PayloadPluginLabelUnarchived {
	m0 := &PayloadPluginLabelUnarchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

var File_buf_alpha_audit_v1alpha1_event_proto protoreflect.FileDescriptor

var file_buf_alpha_audit_v1alpha1_event_proto_rawDesc = string([]byte{
	0x0a, 0x24, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x1a, 0x27, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x64, 0x0a, 0x05, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x37, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x59, 0x0a, 0x0d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0xa5, 0x2f,
	0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x37, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x05, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x3e, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x69, 0x0a, 0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x69, 0x0a,
	0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x76, 0x0a, 0x19, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f,
	0x61, 0x64, 0x64, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x41, 0x64, 0x64, 0x65, 0x64, 0x48, 0x00, 0x52, 0x17, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64,
	0x12, 0x89, 0x01, 0x0a, 0x20, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52, 0x1d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x7c, 0x0a, 0x1b,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x19, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x63, 0x0a, 0x12, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x6c, 0x0a, 0x15, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x72, 0x0a,
	0x17, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x75, 0x6e, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x63, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x75, 0x73, 0x68,
	0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65, 0x64, 0x12, 0x7f, 0x0a, 0x1c, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x1a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64, 0x12, 0x92, 0x01, 0x0a,
	0x23, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x20, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x64, 0x12, 0x85, 0x01, 0x0a, 0x1e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x1c, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x1b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x96,
	0x01, 0x0a, 0x25, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x64, 0x48, 0x00, 0x52, 0x21, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x0e, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x0d, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x12, 0x57, 0x0a, 0x0e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x67, 0x0a, 0x14, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x75, 0x73, 0x68, 0x65,
	0x64, 0x18, 0x31, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65, 0x64, 0x48, 0x00, 0x52, 0x12,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68,
	0x65, 0x64, 0x12, 0x51, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x44, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x51, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x48, 0x00,
	0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x12, 0x58,
	0x0a, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x6f, 0x75,
	0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f,
	0x67, 0x67, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x72, 0x4c,
	0x6f, 0x67, 0x67, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x12, 0x6d, 0x0a, 0x16, 0x63, 0x75, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x75, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x14, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x64, 0x0a, 0x0f, 0x69, 0x64, 0x70, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x65, 0x64, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x50, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x64, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0d,
	0x69, 0x64, 0x70, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x64, 0x65, 0x64, 0x12, 0x6a, 0x0a,
	0x11, 0x69, 0x64, 0x70, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x64, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x50, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x64, 0x70, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x0d, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x54, 0x0a, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x12, 0x73, 0x63, 0x69, 0x6d, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x10, 0x73, 0x63, 0x69, 0x6d, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x12, 0x73, 0x63, 0x69, 0x6d, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x21, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x10, 0x73, 0x63, 0x69, 0x6d, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x7a, 0x0a, 0x19, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x17, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x6d, 0x0a, 0x16, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76,
	0x65, 0x64, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x76, 0x0a, 0x19, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x17, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x64, 0x12, 0x7c, 0x0a, 0x1b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x75, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x64, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x19, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64,
	0x12, 0x6d, 0x0a, 0x16, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x14, 0x63, 0x75, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12,
	0xa5, 0x01, 0x0a, 0x2d, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x28, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0xa8, 0x01, 0x0a, 0x2e, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x29, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x90, 0x01, 0x0a, 0x21, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x42,
	0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x1e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x98, 0x01, 0x0a, 0x28, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x24, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x9b, 0x01, 0x0a, 0x29, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x2a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69,
	0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x25, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x7c,
	0x0a, 0x1d, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x6d, 0x65, 0x72, 0x67,
	0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x70, 0x18,
	0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f,
	0x4d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x4e, 0x65, 0x77, 0x49, 0x64, 0x50,
	0x48, 0x00, 0x52, 0x18, 0x75, 0x73, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x4e, 0x65, 0x77, 0x49, 0x64, 0x70, 0x12, 0x92, 0x01, 0x0a,
	0x23, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x20, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x64, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x1e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64,
	0x12, 0x67, 0x0a, 0x14, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x12, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x12, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18,
	0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x10, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x6a, 0x0a, 0x15,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x13, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x70, 0x0a, 0x17, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x75, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x64, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x15, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x22, 0xa9, 0x02, 0x0a, 0x1e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x41,
	0x64, 0x64, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a,
	0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0a,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x12, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe4, 0x03,
	0x0a, 0x24, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x08,
	0x6f, 0x6c, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6f,
	0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x52, 0x6f, 0x6c, 0x65,
	0x12, 0x68, 0x0a, 0x16, 0x6f, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72,
	0x6f, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x13, 0x6f, 0x6c, 0x64, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x68, 0x0a, 0x16, 0x6e, 0x65,
	0x77, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x13, 0x6e, 0x65, 0x77, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0xab, 0x02, 0x0a, 0x20, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x12,
	0x61, 0x0a, 0x12, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x10, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x78, 0x0a, 0x20, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x50, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x41, 0x64, 0x64, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x22,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x50, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x18, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x18, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a,
	0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xd1, 0x01, 0x0a, 0x1b, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x1d, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x55, 0x6e, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22,
	0xa0, 0x02, 0x0a, 0x1d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65,
	0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x64, 0x72, 0x61, 0x66, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x35, 0x5f, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x35, 0x44, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x22, 0x83, 0x02, 0x0a, 0x21, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x56, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f,
	0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0xc1, 0x02, 0x0a, 0x27, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x08,
	0x6f, 0x6c, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6f, 0x6c, 0x64,
	0x52, 0x6f, 0x6c, 0x65, 0x12, 0x46, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0x85, 0x02, 0x0a,
	0x23, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x52, 0x6f, 0x6c, 0x65, 0x22, 0xfe, 0x01, 0x0a, 0x22, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x6f, 0x6c, 0x64, 0x56, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x4e, 0x0a, 0x0e, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x6e, 0x65, 0x77, 0x56, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xce, 0x01, 0x0a, 0x28, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x16,
	0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6f, 0x6c,
	0x64, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x33, 0x0a, 0x16, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x13, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x25, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x6c,
	0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x6c, 0x64, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x71, 0x0a, 0x14, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x71, 0x0a,
	0x14, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x22, 0xb0, 0x01, 0x0a, 0x19, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65, 0x64, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x31, 0x5f, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x31, 0x44, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x22, 0x14, 0x0a, 0x12, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x44, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x22, 0x14, 0x0a,
	0x12, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x22, 0x15, 0x0a, 0x13, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x22, 0x16, 0x0a, 0x14, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4f,
	0x75, 0x74, 0x22, 0x21, 0x0a, 0x1f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x4e,
	0x65, 0x77, 0x49, 0x64, 0x50, 0x22, 0x57, 0x0a, 0x1b, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x57,
	0x0a, 0x1b, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x78, 0x0a, 0x13, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x11, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x30, 0x0a, 0x13, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x49, 0x64, 0x22, 0x61, 0x0a, 0x17, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x43,
	0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x46,
	0x0a, 0x11, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x19, 0x0a, 0x17, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x22, 0xcb, 0x01, 0x0a, 0x1e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x64, 0x72, 0x61, 0x66, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22,
	0xf1, 0x01, 0x0a, 0x1d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x49, 0x64, 0x22, 0x9a, 0x02, 0x0a, 0x1b, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f,
	0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x74, 0x6f, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x74, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64,
	0x22, 0xa8, 0x01, 0x0a, 0x1e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x20,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12,
	0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x28, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x18, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x16, 0x69, 0x67, 0x6e, 0x6f,
	0x72, 0x65, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x88, 0x01, 0x01, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x22, 0x2b, 0x0a, 0x29, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0x26, 0x0a, 0x24, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x27, 0x0a, 0x25, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x22, 0x46, 0x0a, 0x27, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x61, 0x6e, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x44, 0x0a, 0x25, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x44, 0x65, 0x6e, 0x69, 0x65,
	0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xb0,
	0x01, 0x0a, 0x19, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49,
	0x64, 0x22, 0xd9, 0x01, 0x0a, 0x17, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x22, 0x94, 0x01,
	0x0a, 0x1a, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x1c, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x2a, 0x53, 0x0a,
	0x09, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x43,
	0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x41,
	0x43, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d,
	0x10, 0x02, 0x2a, 0xc3, 0x04, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41,
	0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41,
	0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x10,
	0x03, 0x12, 0x28, 0x0a, 0x24, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x49, 0x44, 0x50, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50,
	0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x04, 0x12, 0x28, 0x0a, 0x24, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x4f,
	0x52, 0x10, 0x05, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f,
	0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x10, 0x07, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49,
	0x54, 0x10, 0x0f, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55,
	0x47, 0x49, 0x4e, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0a, 0x12, 0x1c,
	0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x43, 0x49, 0x4d, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0b, 0x12, 0x22, 0x0a, 0x1e,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45,
	0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x10, 0x0c,
	0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x0d, 0x12, 0x2c, 0x0a, 0x28, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x56, 0x49,
	0x43, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x10, 0x0e, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x10, 0x10, 0x2a, 0xf7, 0x0f, 0x0a, 0x09, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x28, 0x0a, 0x24,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x41,
	0x44, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x2f, 0x0a, 0x2b, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x04, 0x12, 0x2a, 0x0a, 0x26, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45,
	0x44, 0x10, 0x05, 0x12, 0x2b, 0x0a, 0x27, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49,
	0x44, 0x50, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x15,
	0x12, 0x2d, 0x0a, 0x29, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f,
	0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x44, 0x50, 0x5f,
	0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x16, 0x12,
	0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45,
	0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x24, 0x0a, 0x20, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x50, 0x52,
	0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x30, 0x12, 0x26, 0x0a, 0x22, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52,
	0x59, 0x5f, 0x55, 0x4e, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x31,
	0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52,
	0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x44, 0x10, 0x07, 0x12, 0x27, 0x0a, 0x23, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4d,
	0x4d, 0x49, 0x54, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x45, 0x44, 0x10, 0x08, 0x12, 0x2b, 0x0a, 0x27,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x4f,
	0x52, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x09, 0x12, 0x32, 0x0a, 0x2e, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f,
	0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x4f, 0x52, 0x5f, 0x52,
	0x4f, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x2d, 0x0a,
	0x29, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f,
	0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54,
	0x4f, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x0b, 0x12, 0x2c, 0x0a, 0x28,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59,
	0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x0c, 0x12, 0x34, 0x0a, 0x30, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54,
	0x4f, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x28,
	0x12, 0x1d, 0x0a, 0x19, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x0d, 0x12,
	0x1d, 0x0a, 0x19, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c,
	0x55, 0x47, 0x49, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x0e, 0x12, 0x23,
	0x0a, 0x1f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55,
	0x47, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x45,
	0x44, 0x10, 0x2b, 0x12, 0x25, 0x0a, 0x21, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x14, 0x12, 0x25, 0x0a, 0x21, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44,
	0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x1f, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x1b,
	0x0a, 0x17, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45,
	0x52, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x10, 0x12, 0x1f, 0x0a, 0x1b, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x44,
	0x45, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x45, 0x44, 0x10, 0x11, 0x12, 0x1d, 0x0a, 0x19,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f,
	0x4c, 0x4f, 0x47, 0x47, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x10, 0x12, 0x12, 0x1e, 0x0a, 0x1a, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4c,
	0x4f, 0x47, 0x47, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x13, 0x12, 0x1c, 0x0a, 0x18, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x17, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x18, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x41, 0x54, 0x45, 0x44, 0x10, 0x19, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x49, 0x4d, 0x5f, 0x54, 0x4f, 0x4b, 0x45,
	0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x1a, 0x12, 0x21, 0x0a, 0x1d, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x49, 0x4d, 0x5f, 0x54,
	0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x1b, 0x12, 0x2c,
	0x0a, 0x24, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50,
	0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x5f, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x1c, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x27, 0x0a, 0x23,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x1d, 0x12, 0x25, 0x0a, 0x21, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c,
	0x41, 0x42, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x1e, 0x12, 0x28, 0x0a, 0x24,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x41, 0x52, 0x43, 0x48,
	0x49, 0x56, 0x45, 0x44, 0x10, 0x26, 0x12, 0x2a, 0x0a, 0x26, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f,
	0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x44,
	0x10, 0x27, 0x12, 0x34, 0x0a, 0x30, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47,
	0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x20, 0x12, 0x35, 0x0a, 0x31, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x42, 0x52,
	0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x21, 0x12,
	0x34, 0x0a, 0x2c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45,
	0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54,
	0x5f, 0x42, 0x52, 0x41, 0x4e, 0x43, 0x48, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10,
	0x22, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x2f, 0x0a, 0x2b, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x49, 0x51, 0x55,
	0x45, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x23, 0x12, 0x30, 0x0a, 0x2c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x49, 0x51,
	0x55, 0x45, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x24, 0x12, 0x2c, 0x0a, 0x28, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x4f,
	0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x4e, 0x45, 0x57,
	0x5f, 0x49, 0x44, 0x50, 0x10, 0x25, 0x12, 0x32, 0x0a, 0x2e, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48,
	0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f,
	0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x29, 0x12, 0x30, 0x0a, 0x2c, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x52,
	0x41, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x2a, 0x12, 0x23, 0x0a, 0x1f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x2c, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x56,
	0x45, 0x44, 0x10, 0x2d, 0x12, 0x24, 0x0a, 0x20, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f,
	0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x44, 0x10, 0x2e, 0x12, 0x26, 0x0a, 0x22, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x44,
	0x10, 0x2f, 0x42, 0x82, 0x02, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x42, 0x0a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x53, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75,
	0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f,
	0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x61, 0x75, 0x64, 0x69, 0x74, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x41, 0xaa, 0x02, 0x18, 0x42,
	0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x18, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c,
	0x70, 0x68, 0x61, 0x5c, 0x41, 0x75, 0x64, 0x69, 0x74, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0xe2, 0x02, 0x24, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50,
	0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x3a,
	0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x41, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x3a, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_alpha_audit_v1alpha1_event_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_alpha_audit_v1alpha1_event_proto_msgTypes = make([]protoimpl.MessageInfo, 53)
var file_buf_alpha_audit_v1alpha1_event_proto_goTypes = []any{
	(ActorType)(0),                                    // 0: buf.alpha.audit.v1alpha1.ActorType
	(ResourceType)(0),                                 // 1: buf.alpha.audit.v1alpha1.ResourceType
	(EventType)(0),                                    // 2: buf.alpha.audit.v1alpha1.EventType
	(*Actor)(nil),                                     // 3: buf.alpha.audit.v1alpha1.Actor
	(*Resource)(nil),                                  // 4: buf.alpha.audit.v1alpha1.Resource
	(*EventMetadata)(nil),                             // 5: buf.alpha.audit.v1alpha1.EventMetadata
	(*Event)(nil),                                     // 6: buf.alpha.audit.v1alpha1.Event
	(*PayloadOrganizationCreated)(nil),                // 7: buf.alpha.audit.v1alpha1.PayloadOrganizationCreated
	(*PayloadOrganizationDeleted)(nil),                // 8: buf.alpha.audit.v1alpha1.PayloadOrganizationDeleted
	(*PayloadOrganizationMemberAdded)(nil),            // 9: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded
	(*PayloadOrganizationMemberRoleChanged)(nil),      // 10: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged
	(*PayloadOrganizationMemberRemoved)(nil),          // 11: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved
	(*PayloadOrganizationIDPGroupAdded)(nil),          // 12: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded
	(*PayloadOrganizationIDPGroupRemoved)(nil),        // 13: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved
	(*PayloadRepositoryCreated)(nil),                  // 14: buf.alpha.audit.v1alpha1.PayloadRepositoryCreated
	(*PayloadRepositoryDeleted)(nil),                  // 15: buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted
	(*PayloadRepositoryDeprecated)(nil),               // 16: buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecated
	(*PayloadRepositoryUndeprecated)(nil),             // 17: buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecated
	(*PayloadRepositoryCommitPushed)(nil),             // 18: buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushed
	(*PayloadRepositoryContributorAdded)(nil),         // 19: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded
	(*PayloadRepositoryContributorRoleChanged)(nil),   // 20: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged
	(*PayloadRepositoryContributorRemoved)(nil),       // 21: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved
	(*PayloadRepositoryVisibilityChanged)(nil),        // 22: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged
	(*PayloadRepositoryDefaultLabelNameChanged)(nil),  // 23: buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChanged
	(*PayloadRepositoryDefaultBranchChanged)(nil),     // 24: buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChanged
	(*PayloadPluginCreated)(nil),                      // 25: buf.alpha.audit.v1alpha1.PayloadPluginCreated
	(*PayloadPluginDeleted)(nil),                      // 26: buf.alpha.audit.v1alpha1.PayloadPluginDeleted
	(*PayloadPluginCommitPushed)(nil),                 // 27: buf.alpha.audit.v1alpha1.PayloadPluginCommitPushed
	(*PayloadUserCreated)(nil),                        // 28: buf.alpha.audit.v1alpha1.PayloadUserCreated
	(*PayloadUserReactivated)(nil),                    // 29: buf.alpha.audit.v1alpha1.PayloadUserReactivated
	(*PayloadUserDeactivated)(nil),                    // 30: buf.alpha.audit.v1alpha1.PayloadUserDeactivated
	(*PayloadUserDeleted)(nil),                        // 31: buf.alpha.audit.v1alpha1.PayloadUserDeleted
	(*PayloadUserLoggedIn)(nil),                       // 32: buf.alpha.audit.v1alpha1.PayloadUserLoggedIn
	(*PayloadUserLoggedOut)(nil),                      // 33: buf.alpha.audit.v1alpha1.PayloadUserLoggedOut
	(*PayloadUserAutoMergedFromNewIdP)(nil),           // 34: buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdP
	(*PayloadCuratedPluginCreated)(nil),               // 35: buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreated
	(*PayloadCuratedPluginDeleted)(nil),               // 36: buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeleted
	(*PayloadTokenCreated)(nil),                       // 37: buf.alpha.audit.v1alpha1.PayloadTokenCreated
	(*PayloadTokenDeleted)(nil),                       // 38: buf.alpha.audit.v1alpha1.PayloadTokenDeleted
	(*PayloadSCIMTokenCreated)(nil),                   // 39: buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated
	(*PayloadSCIMTokenDeleted)(nil),                   // 40: buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeleted
	(*PayloadRepositoryCommitDeleted)(nil),            // 41: buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeleted
	(*PayloadRepositoryLabelCreated)(nil),             // 42: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreated
	(*PayloadRepositoryLabelMoved)(nil),               // 43: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMoved
	(*PayloadRepositoryLabelArchived)(nil),            // 44: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchived
	(*PayloadRepositoryLabelUnarchived)(nil),          // 45: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchived
	(*PayloadServerBreakingChangePolicyEnabled)(nil),  // 46: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled
	(*PayloadServerBreakingChangePolicyDisabled)(nil), // 47: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabled
	(*PayloadServerUniquenessPolicyEnabled)(nil),      // 48: buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabled
	(*PayloadServerUniquenessPolicyDisabled)(nil),     // 49: buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabled
	(*PayloadDeviceAuthorizationGrantApproved)(nil),   // 50: buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApproved
	(*PayloadDeviceAuthorizationGrantDenied)(nil),     // 51: buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDenied
	(*PayloadPluginLabelCreated)(nil),                 // 52: buf.alpha.audit.v1alpha1.PayloadPluginLabelCreated
	(*PayloadPluginLabelMoved)(nil),                   // 53: buf.alpha.audit.v1alpha1.PayloadPluginLabelMoved
	(*PayloadPluginLabelArchived)(nil),                // 54: buf.alpha.audit.v1alpha1.PayloadPluginLabelArchived
	(*PayloadPluginLabelUnarchived)(nil),              // 55: buf.alpha.audit.v1alpha1.PayloadPluginLabelUnarchived
	(*timestamppb.Timestamp)(nil),                     // 56: google.protobuf.Timestamp
	(v1alpha1.OrganizationRole)(0),                    // 57: buf.alpha.registry.v1alpha1.OrganizationRole
	(v1alpha1.OrganizationRoleSource)(0),              // 58: buf.alpha.registry.v1alpha1.OrganizationRoleSource
	(v1alpha1.Visibility)(0),                          // 59: buf.alpha.registry.v1alpha1.Visibility
	(v1alpha1.RepositoryRole)(0),                      // 60: buf.alpha.registry.v1alpha1.RepositoryRole
	(v1alpha1.BreakingChangeCategory)(0),              // 61: buf.alpha.registry.v1alpha1.BreakingChangeCategory
}
var file_buf_alpha_audit_v1alpha1_event_proto_depIdxs = []int32{
	0,  // 0: buf.alpha.audit.v1alpha1.Actor.type:type_name -> buf.alpha.audit.v1alpha1.ActorType
	1,  // 1: buf.alpha.audit.v1alpha1.Resource.type:type_name -> buf.alpha.audit.v1alpha1.ResourceType
	2,  // 2: buf.alpha.audit.v1alpha1.Event.type:type_name -> buf.alpha.audit.v1alpha1.EventType
	3,  // 3: buf.alpha.audit.v1alpha1.Event.actor:type_name -> buf.alpha.audit.v1alpha1.Actor
	4,  // 4: buf.alpha.audit.v1alpha1.Event.resource:type_name -> buf.alpha.audit.v1alpha1.Resource
	56, // 5: buf.alpha.audit.v1alpha1.Event.event_time:type_name -> google.protobuf.Timestamp
	5,  // 6: buf.alpha.audit.v1alpha1.Event.metadata:type_name -> buf.alpha.audit.v1alpha1.EventMetadata
	7,  // 7: buf.alpha.audit.v1alpha1.Event.organization_created:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationCreated
	8,  // 8: buf.alpha.audit.v1alpha1.Event.organization_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationDeleted
	9,  // 9: buf.alpha.audit.v1alpha1.Event.organization_member_added:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded
	10, // 10: buf.alpha.audit.v1alpha1.Event.organization_member_role_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged
	11, // 11: buf.alpha.audit.v1alpha1.Event.organization_member_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved
	14, // 12: buf.alpha.audit.v1alpha1.Event.repository_created:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCreated
	16, // 13: buf.alpha.audit.v1alpha1.Event.repository_deprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecated
	17, // 14: buf.alpha.audit.v1alpha1.Event.repository_undeprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecated
	15, // 15: buf.alpha.audit.v1alpha1.Event.repository_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted
	18, // 16: buf.alpha.audit.v1alpha1.Event.repository_commit_pushed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushed
	19, // 17: buf.alpha.audit.v1alpha1.Event.repository_contributor_added:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded
	20, // 18: buf.alpha.audit.v1alpha1.Event.repository_contributor_role_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged
	21, // 19: buf.alpha.audit.v1alpha1.Event.repository_contributor_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved
	22, // 20: buf.alpha.audit.v1alpha1.Event.repository_visibility_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged
	23, // 21: buf.alpha.audit.v1alpha1.Event.repository_default_label_name_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChanged
	25, // 22: buf.alpha.audit.v1alpha1.Event.plugin_created:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginCreated
	26, // 23: buf.alpha.audit.v1alpha1.Event.plugin_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginDeleted
	27, // 24: buf.alpha.audit.v1alpha1.Event.plugin_commit_pushed:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginCommitPushed
	28, // 25: buf.alpha.audit.v1alpha1.Event.user_created:type_name -> buf.alpha.audit.v1alpha1.PayloadUserCreated
	30, // 26: buf.alpha.audit.v1alpha1.Event.user_deactivated:type_name -> buf.alpha.audit.v1alpha1.PayloadUserDeactivated
	31, // 27: buf.alpha.audit.v1alpha1.Event.user_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadUserDeleted
	32, // 28: buf.alpha.audit.v1alpha1.Event.user_logged_in:type_name -> buf.alpha.audit.v1alpha1.PayloadUserLoggedIn
	33, // 29: buf.alpha.audit.v1alpha1.Event.user_logged_out:type_name -> buf.alpha.audit.v1alpha1.PayloadUserLoggedOut
	35, // 30: buf.alpha.audit.v1alpha1.Event.curated_plugin_created:type_name -> buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreated
	12, // 31: buf.alpha.audit.v1alpha1.Event.idp_group_added:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded
	13, // 32: buf.alpha.audit.v1alpha1.Event.idp_group_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved
	37, // 33: buf.alpha.audit.v1alpha1.Event.token_created:type_name -> buf.alpha.audit.v1alpha1.PayloadTokenCreated
	38, // 34: buf.alpha.audit.v1alpha1.Event.token_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadTokenDeleted
	29, // 35: buf.alpha.audit.v1alpha1.Event.user_reactivated:type_name -> buf.alpha.audit.v1alpha1.PayloadUserReactivated
	39, // 36: buf.alpha.audit.v1alpha1.Event.scim_token_created:type_name -> buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated
	40, // 37: buf.alpha.audit.v1alpha1.Event.scim_token_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeleted
	41, // 38: buf.alpha.audit.v1alpha1.Event.repository_commit_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeleted
	42, // 39: buf.alpha.audit.v1alpha1.Event.repository_label_created:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreated
	43, // 40: buf.alpha.audit.v1alpha1.Event.repository_label_moved:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMoved
	44, // 41: buf.alpha.audit.v1alpha1.Event.repository_label_archived:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchived
	45, // 42: buf.alpha.audit.v1alpha1.Event.repository_label_unarchived:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchived
	36, // 43: buf.alpha.audit.v1alpha1.Event.curated_plugin_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeleted
	46, // 44: buf.alpha.audit.v1alpha1.Event.payload_server_breaking_change_policy_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled
	47, // 45: buf.alpha.audit.v1alpha1.Event.payload_server_breaking_change_policy_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabled
	24, // 46: buf.alpha.audit.v1alpha1.Event.repository_default_branch_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChanged
	48, // 47: buf.alpha.audit.v1alpha1.Event.payload_server_uniqueness_policy_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabled
	49, // 48: buf.alpha.audit.v1alpha1.Event.payload_server_uniqueness_policy_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabled
	34, // 49: buf.alpha.audit.v1alpha1.Event.user_auto_merged_from_new_idp:type_name -> buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdP
	50, // 50: buf.alpha.audit.v1alpha1.Event.device_authorization_grant_approved:type_name -> buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApproved
	51, // 51: buf.alpha.audit.v1alpha1.Event.device_authorization_grant_denied:type_name -> buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDenied
	52, // 52: buf.alpha.audit.v1alpha1.Event.plugin_label_created:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelCreated
	53, // 53: buf.alpha.audit.v1alpha1.Event.plugin_label_moved:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelMoved
	54, // 54: buf.alpha.audit.v1alpha1.Event.plugin_label_archived:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelArchived
	55, // 55: buf.alpha.audit.v1alpha1.Event.plugin_label_unarchived:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelUnarchived
	57, // 56: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded.member_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	58, // 57: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded.member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	57, // 58: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.old_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	57, // 59: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.new_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	58, // 60: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.old_member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	58, // 61: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.new_member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	57, // 62: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved.member_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	58, // 63: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved.member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	59, // 64: buf.alpha.audit.v1alpha1.PayloadRepositoryCreated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	59, // 65: buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	59, // 66: buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	59, // 67: buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	60, // 68: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded.contributor_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	60, // 69: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged.old_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	60, // 70: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged.new_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	60, // 71: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved.contributor_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	59, // 72: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged.old_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	59, // 73: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged.new_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	56, // 74: buf.alpha.audit.v1alpha1.PayloadTokenCreated.token_expiry_time:type_name -> google.protobuf.Timestamp
	56, // 75: buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated.token_expiry_time:type_name -> google.protobuf.Timestamp
	61, // 76: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled.category:type_name -> buf.alpha.registry.v1alpha1.BreakingChangeCategory
	77, // [77:77] is the sub-list for method output_type
	77, // [77:77] is the sub-list for method input_type
	77, // [77:77] is the sub-list for extension type_name
	77, // [77:77] is the sub-list for extension extendee
	0,  // [0:77] is the sub-list for field type_name
}

func init() { file_buf_alpha_audit_v1alpha1_event_proto_init() }
func file_buf_alpha_audit_v1alpha1_event_proto_init() {
	if File_buf_alpha_audit_v1alpha1_event_proto != nil {
		return
	}
	file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3].OneofWrappers = []any{
		(*event_OrganizationCreated)(nil),
		(*event_OrganizationDeleted)(nil),
		(*event_OrganizationMemberAdded)(nil),
		(*event_OrganizationMemberRoleChanged)(nil),
		(*event_OrganizationMemberRemoved)(nil),
		(*event_RepositoryCreated)(nil),
		(*event_RepositoryDeprecated)(nil),
		(*event_RepositoryUndeprecated)(nil),
		(*event_RepositoryDeleted)(nil),
		(*event_RepositoryCommitPushed)(nil),
		(*event_RepositoryContributorAdded)(nil),
		(*event_RepositoryContributorRoleChanged)(nil),
		(*event_RepositoryContributorRemoved)(nil),
		(*event_RepositoryVisibilityChanged)(nil),
		(*event_RepositoryDefaultLabelNameChanged)(nil),
		(*event_PluginCreated)(nil),
		(*event_PluginDeleted)(nil),
		(*event_PluginCommitPushed)(nil),
		(*event_UserCreated)(nil),
		(*event_UserDeactivated)(nil),
		(*event_UserDeleted)(nil),
		(*event_UserLoggedIn)(nil),
		(*event_UserLoggedOut)(nil),
		(*event_CuratedPluginCreated)(nil),
		(*event_IdpGroupAdded)(nil),
		(*event_IdpGroupRemoved)(nil),
		(*event_TokenCreated)(nil),
		(*event_TokenDeleted)(nil),
		(*event_UserReactivated)(nil),
		(*event_ScimTokenCreated)(nil),
		(*event_ScimTokenDeleted)(nil),
		(*event_RepositoryCommitDeleted)(nil),
		(*event_RepositoryLabelCreated)(nil),
		(*event_RepositoryLabelMoved)(nil),
		(*event_RepositoryLabelArchived)(nil),
		(*event_RepositoryLabelUnarchived)(nil),
		(*event_CuratedPluginDeleted)(nil),
		(*event_PayloadServerBreakingChangePolicyEnabled)(nil),
		(*event_PayloadServerBreakingChangePolicyDisabled)(nil),
		(*event_RepositoryDefaultBranchChanged)(nil),
		(*event_PayloadServerUniquenessPolicyEnabled)(nil),
		(*event_PayloadServerUniquenessPolicyDisabled)(nil),
		(*event_UserAutoMergedFromNewIdp)(nil),
		(*event_DeviceAuthorizationGrantApproved)(nil),
		(*event_DeviceAuthorizationGrantDenied)(nil),
		(*event_PluginLabelCreated)(nil),
		(*event_PluginLabelMoved)(nil),
		(*event_PluginLabelArchived)(nil),
		(*event_PluginLabelUnarchived)(nil),
	}
	file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_audit_v1alpha1_event_proto_rawDesc), len(file_buf_alpha_audit_v1alpha1_event_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   53,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_alpha_audit_v1alpha1_event_proto_goTypes,
		DependencyIndexes: file_buf_alpha_audit_v1alpha1_event_proto_depIdxs,
		EnumInfos:         file_buf_alpha_audit_v1alpha1_event_proto_enumTypes,
		MessageInfos:      file_buf_alpha_audit_v1alpha1_event_proto_msgTypes,
	}.Build()
	File_buf_alpha_audit_v1alpha1_event_proto = out.File
	file_buf_alpha_audit_v1alpha1_event_proto_goTypes = nil
	file_buf_alpha_audit_v1alpha1_event_proto_depIdxs = nil
}
