// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/cheekybits/genny

package pod

import (
	"context"
	"fmt"

	logutil "github.com/boz/go-logutil"
	"github.com/boz/kcache"
	"github.com/boz/kcache/client"
	"github.com/boz/kcache/filter"
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/client-go/kubernetes"
)

var (
	ErrInvalidType = fmt.Errorf("invalid type")
	adapter        = _adapter{}
)

var _ = appsv1.Deployment{}

type Event interface {
	Type() kcache.EventType
	Resource() *corev1.Pod
}

type CacheReader interface {
	Get(ns string, name string) (*corev1.Pod, error)
	List() ([]*corev1.Pod, error)
}

type CacheController interface {
	Cache() CacheReader
	Ready() <-chan struct{}
}

type Subscription interface {
	CacheController
	Events() <-chan Event
	Close()
	Done() <-chan struct{}
}

type Publisher interface {
	Subscribe() (Subscription, error)
	SubscribeWithFilter(filter.Filter) (FilterSubscription, error)
	SubscribeForFilter() (FilterSubscription, error)
	Clone() (Controller, error)
	CloneWithFilter(filter.Filter) (FilterController, error)
	CloneForFilter() (FilterController, error)
}

type Controller interface {
	CacheController
	Publisher
	Done() <-chan struct{}
	Close()
	Error() error
}

type FilterSubscription interface {
	Subscription
	Refilter(filter.Filter) error
}

type FilterController interface {
	Controller
	Refilter(filter.Filter) error
}

type BaseHandler interface {
	OnCreate(*corev1.Pod)
	OnUpdate(*corev1.Pod)
	OnDelete(*corev1.Pod)
}

type Handler interface {
	BaseHandler
	OnInitialize([]*corev1.Pod)
}

type HandlerBuilder interface {
	OnInitialize(func([]*corev1.Pod)) HandlerBuilder
	OnCreate(func(*corev1.Pod)) HandlerBuilder
	OnUpdate(func(*corev1.Pod)) HandlerBuilder
	OnDelete(func(*corev1.Pod)) HandlerBuilder
	Create() Handler
}

type UnitaryHandler interface {
	BaseHandler
	OnInitialize(*corev1.Pod)
}

type UnitaryHandlerBuilder interface {
	OnInitialize(func(*corev1.Pod)) UnitaryHandlerBuilder
	OnCreate(func(*corev1.Pod)) UnitaryHandlerBuilder
	OnUpdate(func(*corev1.Pod)) UnitaryHandlerBuilder
	OnDelete(func(*corev1.Pod)) UnitaryHandlerBuilder
	Create() UnitaryHandler
}

type _adapter struct{}

func (_adapter) adaptObject(obj metav1.Object) (*corev1.Pod, error) {
	if obj, ok := obj.(*corev1.Pod); ok {
		return obj, nil
	}
	return nil, ErrInvalidType
}

func (a _adapter) adaptList(objs []metav1.Object) ([]*corev1.Pod, error) {
	var ret []*corev1.Pod
	for _, orig := range objs {
		adapted, err := a.adaptObject(orig)
		if err != nil {
			continue
		}
		ret = append(ret, adapted)
	}
	return ret, nil
}

func newCache(parent kcache.CacheReader) CacheReader {
	return &cache{parent}
}

type cache struct {
	parent kcache.CacheReader
}

func (c *cache) Get(ns string, name string) (*corev1.Pod, error) {
	obj, err := c.parent.Get(ns, name)
	switch {
	case err != nil:
		return nil, err
	case obj == nil:
		return nil, nil
	default:
		return adapter.adaptObject(obj)
	}
}

func (c *cache) List() ([]*corev1.Pod, error) {
	objs, err := c.parent.List()
	if err != nil {
		return nil, err
	}
	return adapter.adaptList(objs)
}

type event struct {
	etype    kcache.EventType
	resource *corev1.Pod
}

func wrapEvent(evt kcache.Event) (Event, error) {
	obj, err := adapter.adaptObject(evt.Resource())
	if err != nil {
		return nil, err
	}
	return event{evt.Type(), obj}, nil
}

func (e event) Type() kcache.EventType {
	return e.etype
}

func (e event) Resource() *corev1.Pod {
	return e.resource
}

type subscription struct {
	parent kcache.Subscription
	cache  CacheReader
	outch  chan Event
}

func newSubscription(parent kcache.Subscription) *subscription {
	s := &subscription{
		parent: parent,
		cache:  newCache(parent.Cache()),
		outch:  make(chan Event, kcache.EventBufsiz),
	}
	go s.run()
	return s
}

func (s *subscription) run() {
	defer close(s.outch)
	for pevt := range s.parent.Events() {
		evt, err := wrapEvent(pevt)
		if err != nil {
			continue
		}
		select {
		case s.outch <- evt:
		default:
		}
	}
}

func (s *subscription) Cache() CacheReader {
	return s.cache
}

func (s *subscription) Ready() <-chan struct{} {
	return s.parent.Ready()
}

func (s *subscription) Events() <-chan Event {
	return s.outch
}

func (s *subscription) Close() {
	s.parent.Close()
}

func (s *subscription) Done() <-chan struct{} {
	return s.parent.Done()
}

func NewController(ctx context.Context, log logutil.Log, cs kubernetes.Interface, ns string) (Controller, error) {
	client := NewClient(cs, ns)
	return BuildController(ctx, log, client)
}

func BuildController(ctx context.Context, log logutil.Log, client client.Client) (Controller, error) {
	parent, err := kcache.NewController(ctx, log, client)
	if err != nil {
		return nil, err
	}
	return newController(parent), nil
}

func newController(parent kcache.Controller) *controller {
	return &controller{parent, newCache(parent.Cache())}
}

type controller struct {
	parent kcache.Controller
	cache  CacheReader
}

func (c *controller) Close() {
	c.parent.Close()
}

func (c *controller) Ready() <-chan struct{} {
	return c.parent.Ready()
}

func (c *controller) Done() <-chan struct{} {
	return c.parent.Done()
}

func (c *controller) Error() error {
	return c.parent.Error()
}

func (c *controller) Cache() CacheReader {
	return c.cache
}

func (c *controller) Subscribe() (Subscription, error) {
	parent, err := c.parent.Subscribe()
	if err != nil {
		return nil, err
	}
	return newSubscription(parent), nil
}

func (c *controller) SubscribeWithFilter(f filter.Filter) (FilterSubscription, error) {
	parent, err := c.parent.SubscribeWithFilter(f)
	if err != nil {
		return nil, err
	}
	return newFilterSubscription(parent), nil
}

func (c *controller) SubscribeForFilter() (FilterSubscription, error) {
	parent, err := c.parent.SubscribeForFilter()
	if err != nil {
		return nil, err
	}
	return newFilterSubscription(parent), nil
}

func (c *controller) Clone() (Controller, error) {
	parent, err := c.parent.Clone()
	if err != nil {
		return nil, err
	}
	return newController(parent), nil
}

func (c *controller) CloneWithFilter(f filter.Filter) (FilterController, error) {
	parent, err := c.parent.CloneWithFilter(f)
	if err != nil {
		return nil, err
	}
	return newFilterController(parent), nil
}

func (c *controller) CloneForFilter() (FilterController, error) {
	parent, err := c.parent.CloneForFilter()
	if err != nil {
		return nil, err
	}
	return newFilterController(parent), nil
}

type filterController struct {
	controller
	filterParent kcache.FilterController
}

func newFilterController(parent kcache.FilterController) FilterController {
	return &filterController{
		controller:   controller{parent, newCache(parent.Cache())},
		filterParent: parent,
	}
}

func (c *filterController) Refilter(f filter.Filter) error {
	return c.filterParent.Refilter(f)
}

type filterSubscription struct {
	subscription
	filterParent kcache.FilterSubscription
}

func newFilterSubscription(parent kcache.FilterSubscription) FilterSubscription {
	return &filterSubscription{
		subscription: *newSubscription(parent),
		filterParent: parent,
	}
}

func (s *filterSubscription) Refilter(f filter.Filter) error {
	return s.filterParent.Refilter(f)
}

func NewMonitor(publisher Publisher, handler Handler) (kcache.Monitor, error) {
	phandler := kcache.BuildHandler().
		OnInitialize(func(objs []metav1.Object) {
			aobjs, _ := adapter.adaptList(objs)
			handler.OnInitialize(aobjs)
		}).
		OnCreate(func(obj metav1.Object) {
			aobj, _ := adapter.adaptObject(obj)
			handler.OnCreate(aobj)
		}).
		OnUpdate(func(obj metav1.Object) {
			aobj, _ := adapter.adaptObject(obj)
			handler.OnUpdate(aobj)
		}).
		OnDelete(func(obj metav1.Object) {
			aobj, _ := adapter.adaptObject(obj)
			handler.OnDelete(aobj)
		}).Create()

	switch obj := publisher.(type) {
	case *controller:
		return kcache.NewMonitor(obj.parent, phandler)
	case *filterController:
		return kcache.NewMonitor(obj.parent, phandler)
	default:
		panic(fmt.Sprintf("Invalid publisher type: %T is not a *controller", publisher))
	}
}

func ToUnitary(log logutil.Log, delegate UnitaryHandler) Handler {
	return BuildHandler().
		OnInitialize(func(objs []*corev1.Pod) {
			if count := len(objs); count > 1 {
				log.Warnf("initialized with invalid count: %v", count)
				return
			}
			if count := len(objs); count == 0 {
				log.Debugf("initialized with empty result, ignoring")
				return
			}
			delegate.OnInitialize(objs[0])
		}).
		OnCreate(func(obj *corev1.Pod) {
			delegate.OnCreate(obj)
		}).
		OnUpdate(func(obj *corev1.Pod) {
			delegate.OnUpdate(obj)
		}).
		OnDelete(func(obj *corev1.Pod) {
			delegate.OnDelete(obj)
		}).Create()
}

func BuildHandler() HandlerBuilder {
	return &handlerBuilder{}
}

func BuildUnitaryHandler() UnitaryHandlerBuilder {
	return &unitaryHandlerBuilder{}
}

type baseHandler struct {
	onCreate func(*corev1.Pod)
	onUpdate func(*corev1.Pod)
	onDelete func(*corev1.Pod)
}

type handler struct {
	baseHandler
	onInitialize func([]*corev1.Pod)
}
type handlerBuilder handler

type unitaryHandler struct {
	baseHandler
	onInitialize func(*corev1.Pod)
}
type unitaryHandlerBuilder unitaryHandler

func (hb *handlerBuilder) OnInitialize(fn func([]*corev1.Pod)) HandlerBuilder {
	hb.onInitialize = fn
	return hb
}

func (hb *handlerBuilder) OnCreate(fn func(*corev1.Pod)) HandlerBuilder {
	hb.onCreate = fn
	return hb
}

func (hb *handlerBuilder) OnUpdate(fn func(*corev1.Pod)) HandlerBuilder {
	hb.onUpdate = fn
	return hb
}

func (hb *handlerBuilder) OnDelete(fn func(*corev1.Pod)) HandlerBuilder {
	hb.onDelete = fn
	return hb
}

func (hb *handlerBuilder) Create() Handler {
	return handler(*hb)
}

func (h handler) OnInitialize(objs []*corev1.Pod) {
	if h.onInitialize != nil {
		h.onInitialize(objs)
	}
}

func (hb *unitaryHandlerBuilder) OnInitialize(fn func(*corev1.Pod)) UnitaryHandlerBuilder {
	hb.onInitialize = fn
	return hb
}

func (hb *unitaryHandlerBuilder) OnCreate(fn func(*corev1.Pod)) UnitaryHandlerBuilder {
	hb.onCreate = fn
	return hb
}

func (hb *unitaryHandlerBuilder) OnUpdate(fn func(*corev1.Pod)) UnitaryHandlerBuilder {
	hb.onUpdate = fn
	return hb
}

func (hb *unitaryHandlerBuilder) OnDelete(fn func(*corev1.Pod)) UnitaryHandlerBuilder {
	hb.onDelete = fn
	return hb
}

func (hb *unitaryHandlerBuilder) Create() UnitaryHandler {
	return unitaryHandler(*hb)
}

func (h unitaryHandler) OnInitialize(obj *corev1.Pod) {
	if h.onInitialize != nil {
		h.onInitialize(obj)
	}
}

func (h baseHandler) OnCreate(obj *corev1.Pod) {
	if h.onCreate != nil {
		h.onCreate(obj)
	}
}

func (h baseHandler) OnUpdate(obj *corev1.Pod) {
	if h.onUpdate != nil {
		h.onUpdate(obj)
	}
}

func (h baseHandler) OnDelete(obj *corev1.Pod) {
	if h.onDelete != nil {
		h.onDelete(obj)
	}
}
