/*

Copyright (c) 2021 - Present. Blend Labs, Inc. All rights reserved
Blend Confidential - Restricted

*/

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package v1

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CalculatorClient is the client API for Calculator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CalculatorClient interface {
	Add(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error)
	AddStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_AddStreamClient, error)
	Subtract(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error)
	SubtractStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_SubtractStreamClient, error)
	Multiply(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error)
	MultiplyStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_MultiplyStreamClient, error)
	Divide(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error)
	DivideStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_DivideStreamClient, error)
}

type calculatorClient struct {
	cc grpc.ClientConnInterface
}

func NewCalculatorClient(cc grpc.ClientConnInterface) CalculatorClient {
	return &calculatorClient{cc}
}

func (c *calculatorClient) Add(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error) {
	out := new(Number)
	err := c.cc.Invoke(ctx, "/v1.Calculator/Add", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *calculatorClient) AddStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_AddStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Calculator_serviceDesc.Streams[0], "/v1.Calculator/AddStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &calculatorAddStreamClient{stream}
	return x, nil
}

type Calculator_AddStreamClient interface {
	Send(*Number) error
	CloseAndRecv() (*Number, error)
	grpc.ClientStream
}

type calculatorAddStreamClient struct {
	grpc.ClientStream
}

func (x *calculatorAddStreamClient) Send(m *Number) error {
	return x.ClientStream.SendMsg(m)
}

func (x *calculatorAddStreamClient) CloseAndRecv() (*Number, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Number)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *calculatorClient) Subtract(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error) {
	out := new(Number)
	err := c.cc.Invoke(ctx, "/v1.Calculator/Subtract", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *calculatorClient) SubtractStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_SubtractStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Calculator_serviceDesc.Streams[1], "/v1.Calculator/SubtractStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &calculatorSubtractStreamClient{stream}
	return x, nil
}

type Calculator_SubtractStreamClient interface {
	Send(*Number) error
	CloseAndRecv() (*Number, error)
	grpc.ClientStream
}

type calculatorSubtractStreamClient struct {
	grpc.ClientStream
}

func (x *calculatorSubtractStreamClient) Send(m *Number) error {
	return x.ClientStream.SendMsg(m)
}

func (x *calculatorSubtractStreamClient) CloseAndRecv() (*Number, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Number)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *calculatorClient) Multiply(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error) {
	out := new(Number)
	err := c.cc.Invoke(ctx, "/v1.Calculator/Multiply", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *calculatorClient) MultiplyStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_MultiplyStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Calculator_serviceDesc.Streams[2], "/v1.Calculator/MultiplyStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &calculatorMultiplyStreamClient{stream}
	return x, nil
}

type Calculator_MultiplyStreamClient interface {
	Send(*Number) error
	CloseAndRecv() (*Number, error)
	grpc.ClientStream
}

type calculatorMultiplyStreamClient struct {
	grpc.ClientStream
}

func (x *calculatorMultiplyStreamClient) Send(m *Number) error {
	return x.ClientStream.SendMsg(m)
}

func (x *calculatorMultiplyStreamClient) CloseAndRecv() (*Number, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Number)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *calculatorClient) Divide(ctx context.Context, in *Numbers, opts ...grpc.CallOption) (*Number, error) {
	out := new(Number)
	err := c.cc.Invoke(ctx, "/v1.Calculator/Divide", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *calculatorClient) DivideStream(ctx context.Context, opts ...grpc.CallOption) (Calculator_DivideStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Calculator_serviceDesc.Streams[3], "/v1.Calculator/DivideStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &calculatorDivideStreamClient{stream}
	return x, nil
}

type Calculator_DivideStreamClient interface {
	Send(*Number) error
	CloseAndRecv() (*Number, error)
	grpc.ClientStream
}

type calculatorDivideStreamClient struct {
	grpc.ClientStream
}

func (x *calculatorDivideStreamClient) Send(m *Number) error {
	return x.ClientStream.SendMsg(m)
}

func (x *calculatorDivideStreamClient) CloseAndRecv() (*Number, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Number)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// CalculatorServer is the server API for Calculator service.
// All implementations must embed UnimplementedCalculatorServer
// for forward compatibility
type CalculatorServer interface {
	Add(context.Context, *Numbers) (*Number, error)
	AddStream(Calculator_AddStreamServer) error
	Subtract(context.Context, *Numbers) (*Number, error)
	SubtractStream(Calculator_SubtractStreamServer) error
	Multiply(context.Context, *Numbers) (*Number, error)
	MultiplyStream(Calculator_MultiplyStreamServer) error
	Divide(context.Context, *Numbers) (*Number, error)
	DivideStream(Calculator_DivideStreamServer) error
	mustEmbedUnimplementedCalculatorServer()
}

// UnimplementedCalculatorServer must be embedded to have forward compatible implementations.
type UnimplementedCalculatorServer struct {
}

func (*UnimplementedCalculatorServer) Add(context.Context, *Numbers) (*Number, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Add not implemented")
}
func (*UnimplementedCalculatorServer) AddStream(Calculator_AddStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method AddStream not implemented")
}
func (*UnimplementedCalculatorServer) Subtract(context.Context, *Numbers) (*Number, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Subtract not implemented")
}
func (*UnimplementedCalculatorServer) SubtractStream(Calculator_SubtractStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method SubtractStream not implemented")
}
func (*UnimplementedCalculatorServer) Multiply(context.Context, *Numbers) (*Number, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Multiply not implemented")
}
func (*UnimplementedCalculatorServer) MultiplyStream(Calculator_MultiplyStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method MultiplyStream not implemented")
}
func (*UnimplementedCalculatorServer) Divide(context.Context, *Numbers) (*Number, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Divide not implemented")
}
func (*UnimplementedCalculatorServer) DivideStream(Calculator_DivideStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method DivideStream not implemented")
}
func (*UnimplementedCalculatorServer) mustEmbedUnimplementedCalculatorServer() {}

func RegisterCalculatorServer(s *grpc.Server, srv CalculatorServer) {
	s.RegisterService(&_Calculator_serviceDesc, srv)
}

func _Calculator_Add_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Numbers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CalculatorServer).Add(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.Calculator/Add",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CalculatorServer).Add(ctx, req.(*Numbers))
	}
	return interceptor(ctx, in, info, handler)
}

func _Calculator_AddStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CalculatorServer).AddStream(&calculatorAddStreamServer{stream})
}

type Calculator_AddStreamServer interface {
	SendAndClose(*Number) error
	Recv() (*Number, error)
	grpc.ServerStream
}

type calculatorAddStreamServer struct {
	grpc.ServerStream
}

func (x *calculatorAddStreamServer) SendAndClose(m *Number) error {
	return x.ServerStream.SendMsg(m)
}

func (x *calculatorAddStreamServer) Recv() (*Number, error) {
	m := new(Number)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Calculator_Subtract_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Numbers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CalculatorServer).Subtract(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.Calculator/Subtract",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CalculatorServer).Subtract(ctx, req.(*Numbers))
	}
	return interceptor(ctx, in, info, handler)
}

func _Calculator_SubtractStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CalculatorServer).SubtractStream(&calculatorSubtractStreamServer{stream})
}

type Calculator_SubtractStreamServer interface {
	SendAndClose(*Number) error
	Recv() (*Number, error)
	grpc.ServerStream
}

type calculatorSubtractStreamServer struct {
	grpc.ServerStream
}

func (x *calculatorSubtractStreamServer) SendAndClose(m *Number) error {
	return x.ServerStream.SendMsg(m)
}

func (x *calculatorSubtractStreamServer) Recv() (*Number, error) {
	m := new(Number)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Calculator_Multiply_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Numbers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CalculatorServer).Multiply(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.Calculator/Multiply",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CalculatorServer).Multiply(ctx, req.(*Numbers))
	}
	return interceptor(ctx, in, info, handler)
}

func _Calculator_MultiplyStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CalculatorServer).MultiplyStream(&calculatorMultiplyStreamServer{stream})
}

type Calculator_MultiplyStreamServer interface {
	SendAndClose(*Number) error
	Recv() (*Number, error)
	grpc.ServerStream
}

type calculatorMultiplyStreamServer struct {
	grpc.ServerStream
}

func (x *calculatorMultiplyStreamServer) SendAndClose(m *Number) error {
	return x.ServerStream.SendMsg(m)
}

func (x *calculatorMultiplyStreamServer) Recv() (*Number, error) {
	m := new(Number)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Calculator_Divide_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Numbers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CalculatorServer).Divide(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.Calculator/Divide",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CalculatorServer).Divide(ctx, req.(*Numbers))
	}
	return interceptor(ctx, in, info, handler)
}

func _Calculator_DivideStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CalculatorServer).DivideStream(&calculatorDivideStreamServer{stream})
}

type Calculator_DivideStreamServer interface {
	SendAndClose(*Number) error
	Recv() (*Number, error)
	grpc.ServerStream
}

type calculatorDivideStreamServer struct {
	grpc.ServerStream
}

func (x *calculatorDivideStreamServer) SendAndClose(m *Number) error {
	return x.ServerStream.SendMsg(m)
}

func (x *calculatorDivideStreamServer) Recv() (*Number, error) {
	m := new(Number)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Calculator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.Calculator",
	HandlerType: (*CalculatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Add",
			Handler:    _Calculator_Add_Handler,
		},
		{
			MethodName: "Subtract",
			Handler:    _Calculator_Subtract_Handler,
		},
		{
			MethodName: "Multiply",
			Handler:    _Calculator_Multiply_Handler,
		},
		{
			MethodName: "Divide",
			Handler:    _Calculator_Divide_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AddStream",
			Handler:       _Calculator_AddStream_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "SubtractStream",
			Handler:       _Calculator_SubtractStream_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "MultiplyStream",
			Handler:       _Calculator_MultiplyStream_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "DivideStream",
			Handler:       _Calculator_DivideStream_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "calculator.proto",
}
