/*

Copyright (c) 2022 - Present. Blend Labs, Inc. All rights reserved
Use of this source code is governed by a MIT license that can be found in the LICENSE file.

*/

package codeowners

const (
	// DefaultPath is the default realized codeowners path.
	DefaultPath = "./.github/CODEOWNERS"
	// DefaultGithubURL is the default github url.
	DefaultGithubURL = "https://git.blendlabs.com"
	// DefaultGithubTokenEnvVar standardizes an environment variable
	// to read the github api token from.
	DefaultGithubTokenEnvVar = "GHE_TOKEN"
)

const (
	// OwnersFile is the per path owners file users can create.
	OwnersFile = ".codeowners"

	// OwnersFileHeader is the header that is prefixed to the generated
	// owners file.
	OwnersFileHeader = `# CODEOWNERS automatically generated by 'codeowners'. DO NOT EDIT.
# https://github.com/blog/2392-introducing-code-owners
# https://help.github.com/articles/about-codeowners/
#
# Code owners named in each entry are automatically requested for review
# when someone opens a pull request that modifies code that they own.
#
# Remember, *the last rule to match wins.*
`

	// OwnersGoCommentPrefix is the prefix for owners hints within go files.
	OwnersGoCommentPrefix = "github:codeowner"
	// OwnersFileSourceComment is the owners file comment marking the beginning
	// of a section for a given source.
	OwnersFileSourceComment = "# source: "
	// OwnersFileSourceEndComment is the owners file comment marking the end
	// of a section for a given source.
	OwnersFileSourceEndComment = "# source-end: "
)
