// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package messengertypes

import (
	protocoltypes "berty.tech/weshnet/pkg/protocoltypes"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MessengerServiceClient is the client API for MessengerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MessengerServiceClient interface {
	// InstanceShareableBertyID returns a Berty ID that can be shared as a string, QR code or deep link.
	InstanceShareableBertyID(ctx context.Context, in *InstanceShareableBertyID_Request, opts ...grpc.CallOption) (*InstanceShareableBertyID_Reply, error)
	// ShareableBertyGroup returns a Berty Group that can be shared as a string, QR code or deep link.
	ShareableBertyGroup(ctx context.Context, in *ShareableBertyGroup_Request, opts ...grpc.CallOption) (*ShareableBertyGroup_Reply, error)
	// DevShareInstanceBertyID shares your Berty ID on a dev channel.
	// TODO: remove for public.
	DevShareInstanceBertyID(ctx context.Context, in *DevShareInstanceBertyID_Request, opts ...grpc.CallOption) (*DevShareInstanceBertyID_Reply, error)
	// DevStreamLogs streams logs from the ring-buffer.
	DevStreamLogs(ctx context.Context, in *DevStreamLogs_Request, opts ...grpc.CallOption) (MessengerService_DevStreamLogsClient, error)
	// ParseDeepLink parses a link in the form of berty://xxx or https://berty.tech/id# and returns a structure
	// that can be used to display information.
	// This action is read-only.
	ParseDeepLink(ctx context.Context, in *ParseDeepLink_Request, opts ...grpc.CallOption) (*ParseDeepLink_Reply, error)
	// SendContactRequest takes the payload received from ParseDeepLink and send a contact request using the weshnet.protocol.
	SendContactRequest(ctx context.Context, in *SendContactRequest_Request, opts ...grpc.CallOption) (*SendContactRequest_Reply, error)
	// SystemInfo returns runtime information.
	SystemInfo(ctx context.Context, in *SystemInfo_Request, opts ...grpc.CallOption) (*SystemInfo_Reply, error)
	// Use to test stream.
	EchoTest(ctx context.Context, in *EchoTest_Request, opts ...grpc.CallOption) (MessengerService_EchoTestClient, error)
	// Use to test duplex stream.
	EchoDuplexTest(ctx context.Context, opts ...grpc.CallOption) (MessengerService_EchoDuplexTestClient, error)
	ConversationStream(ctx context.Context, in *ConversationStream_Request, opts ...grpc.CallOption) (MessengerService_ConversationStreamClient, error)
	EventStream(ctx context.Context, in *EventStream_Request, opts ...grpc.CallOption) (MessengerService_EventStreamClient, error)
	ConversationCreate(ctx context.Context, in *ConversationCreate_Request, opts ...grpc.CallOption) (*ConversationCreate_Reply, error)
	ConversationJoin(ctx context.Context, in *ConversationJoin_Request, opts ...grpc.CallOption) (*ConversationJoin_Reply, error)
	AccountGet(ctx context.Context, in *AccountGet_Request, opts ...grpc.CallOption) (*AccountGet_Reply, error)
	AccountUpdate(ctx context.Context, in *AccountUpdate_Request, opts ...grpc.CallOption) (*AccountUpdate_Reply, error)
	AccountPushConfigure(ctx context.Context, in *AccountPushConfigure_Request, opts ...grpc.CallOption) (*AccountPushConfigure_Reply, error)
	ContactRequest(ctx context.Context, in *ContactRequest_Request, opts ...grpc.CallOption) (*ContactRequest_Reply, error)
	ContactAccept(ctx context.Context, in *ContactAccept_Request, opts ...grpc.CallOption) (*ContactAccept_Reply, error)
	Interact(ctx context.Context, in *Interact_Request, opts ...grpc.CallOption) (*Interact_Reply, error)
	ConversationOpen(ctx context.Context, in *ConversationOpen_Request, opts ...grpc.CallOption) (*ConversationOpen_Reply, error)
	ConversationClose(ctx context.Context, in *ConversationClose_Request, opts ...grpc.CallOption) (*ConversationClose_Reply, error)
	ConversationLoad(ctx context.Context, in *ConversationLoad_Request, opts ...grpc.CallOption) (*ConversationLoad_Reply, error)
	ConversationMute(ctx context.Context, in *ConversationMute_Request, opts ...grpc.CallOption) (*ConversationMute_Reply, error)
	// ServicesTokenList Retrieves the list of service server tokens
	ServicesTokenList(ctx context.Context, in *protocoltypes.ServicesTokenList_Request, opts ...grpc.CallOption) (MessengerService_ServicesTokenListClient, error)
	// ReplicationServiceRegisterGroup Asks a replication service to distribute a group contents
	ReplicationServiceRegisterGroup(ctx context.Context, in *ReplicationServiceRegisterGroup_Request, opts ...grpc.CallOption) (*ReplicationServiceRegisterGroup_Reply, error)
	// ReplicationSetAutoEnable Sets whether new groups should be replicated automatically or not
	ReplicationSetAutoEnable(ctx context.Context, in *ReplicationSetAutoEnable_Request, opts ...grpc.CallOption) (*ReplicationSetAutoEnable_Reply, error)
	// BannerQuote returns the quote of the day.
	BannerQuote(ctx context.Context, in *BannerQuote_Request, opts ...grpc.CallOption) (*BannerQuote_Reply, error)
	// InstanceExportData exports instance data
	InstanceExportData(ctx context.Context, in *InstanceExportData_Request, opts ...grpc.CallOption) (MessengerService_InstanceExportDataClient, error)
	// MessageSearch
	MessageSearch(ctx context.Context, in *MessageSearch_Request, opts ...grpc.CallOption) (*MessageSearch_Reply, error)
	// ListMemberDevices Lists devices for a member
	ListMemberDevices(ctx context.Context, in *ListMemberDevices_Request, opts ...grpc.CallOption) (MessengerService_ListMemberDevicesClient, error)
	// TyberHostSearch
	TyberHostSearch(ctx context.Context, in *TyberHostSearch_Request, opts ...grpc.CallOption) (MessengerService_TyberHostSearchClient, error)
	// TyberHostAttach
	TyberHostAttach(ctx context.Context, in *TyberHostAttach_Request, opts ...grpc.CallOption) (*TyberHostAttach_Reply, error)
	// PushSetAutoShare Sets whether new groups should receive our push token automatically or not
	PushSetAutoShare(ctx context.Context, in *PushSetAutoShare_Request, opts ...grpc.CallOption) (*PushSetAutoShare_Reply, error)
	// PushShareTokenForConversation Share a push token for a conversation
	PushShareTokenForConversation(ctx context.Context, in *PushShareTokenForConversation_Request, opts ...grpc.CallOption) (*PushShareTokenForConversation_Reply, error)
	// PushTokenSharedForConversation
	PushTokenSharedForConversation(ctx context.Context, in *PushTokenSharedForConversation_Request, opts ...grpc.CallOption) (MessengerService_PushTokenSharedForConversationClient, error)
	// PushReceive handles a push payload, decrypts it if possible, adds it to the local store
	PushReceive(ctx context.Context, in *PushReceive_Request, opts ...grpc.CallOption) (*PushReceive_Reply, error)
	// DirectoryServiceRegister registers a verified credential on a directory service
	DirectoryServiceRegister(ctx context.Context, in *DirectoryServiceRegister_Request, opts ...grpc.CallOption) (*DirectoryServiceRegister_Reply, error)
	// DirectoryServiceUnregister requests a directory service to remove a verified credential
	DirectoryServiceUnregister(ctx context.Context, in *DirectoryServiceUnregister_Request, opts ...grpc.CallOption) (*DirectoryServiceUnregister_Reply, error)
	// DirectoryServiceQuery queries a directory service for given identifiers
	DirectoryServiceQuery(ctx context.Context, in *DirectoryServiceQuery_Request, opts ...grpc.CallOption) (MessengerService_DirectoryServiceQueryClient, error)
}

type messengerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMessengerServiceClient(cc grpc.ClientConnInterface) MessengerServiceClient {
	return &messengerServiceClient{cc}
}

func (c *messengerServiceClient) InstanceShareableBertyID(ctx context.Context, in *InstanceShareableBertyID_Request, opts ...grpc.CallOption) (*InstanceShareableBertyID_Reply, error) {
	out := new(InstanceShareableBertyID_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/InstanceShareableBertyID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ShareableBertyGroup(ctx context.Context, in *ShareableBertyGroup_Request, opts ...grpc.CallOption) (*ShareableBertyGroup_Reply, error) {
	out := new(ShareableBertyGroup_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ShareableBertyGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) DevShareInstanceBertyID(ctx context.Context, in *DevShareInstanceBertyID_Request, opts ...grpc.CallOption) (*DevShareInstanceBertyID_Reply, error) {
	out := new(DevShareInstanceBertyID_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/DevShareInstanceBertyID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) DevStreamLogs(ctx context.Context, in *DevStreamLogs_Request, opts ...grpc.CallOption) (MessengerService_DevStreamLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[0], "/berty.messenger.v1.MessengerService/DevStreamLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceDevStreamLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_DevStreamLogsClient interface {
	Recv() (*DevStreamLogs_Reply, error)
	grpc.ClientStream
}

type messengerServiceDevStreamLogsClient struct {
	grpc.ClientStream
}

func (x *messengerServiceDevStreamLogsClient) Recv() (*DevStreamLogs_Reply, error) {
	m := new(DevStreamLogs_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) ParseDeepLink(ctx context.Context, in *ParseDeepLink_Request, opts ...grpc.CallOption) (*ParseDeepLink_Reply, error) {
	out := new(ParseDeepLink_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ParseDeepLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) SendContactRequest(ctx context.Context, in *SendContactRequest_Request, opts ...grpc.CallOption) (*SendContactRequest_Reply, error) {
	out := new(SendContactRequest_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/SendContactRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) SystemInfo(ctx context.Context, in *SystemInfo_Request, opts ...grpc.CallOption) (*SystemInfo_Reply, error) {
	out := new(SystemInfo_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/SystemInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) EchoTest(ctx context.Context, in *EchoTest_Request, opts ...grpc.CallOption) (MessengerService_EchoTestClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[1], "/berty.messenger.v1.MessengerService/EchoTest", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceEchoTestClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_EchoTestClient interface {
	Recv() (*EchoTest_Reply, error)
	grpc.ClientStream
}

type messengerServiceEchoTestClient struct {
	grpc.ClientStream
}

func (x *messengerServiceEchoTestClient) Recv() (*EchoTest_Reply, error) {
	m := new(EchoTest_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) EchoDuplexTest(ctx context.Context, opts ...grpc.CallOption) (MessengerService_EchoDuplexTestClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[2], "/berty.messenger.v1.MessengerService/EchoDuplexTest", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceEchoDuplexTestClient{stream}
	return x, nil
}

type MessengerService_EchoDuplexTestClient interface {
	Send(*EchoDuplexTest_Request) error
	Recv() (*EchoDuplexTest_Reply, error)
	grpc.ClientStream
}

type messengerServiceEchoDuplexTestClient struct {
	grpc.ClientStream
}

func (x *messengerServiceEchoDuplexTestClient) Send(m *EchoDuplexTest_Request) error {
	return x.ClientStream.SendMsg(m)
}

func (x *messengerServiceEchoDuplexTestClient) Recv() (*EchoDuplexTest_Reply, error) {
	m := new(EchoDuplexTest_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) ConversationStream(ctx context.Context, in *ConversationStream_Request, opts ...grpc.CallOption) (MessengerService_ConversationStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[3], "/berty.messenger.v1.MessengerService/ConversationStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceConversationStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_ConversationStreamClient interface {
	Recv() (*ConversationStream_Reply, error)
	grpc.ClientStream
}

type messengerServiceConversationStreamClient struct {
	grpc.ClientStream
}

func (x *messengerServiceConversationStreamClient) Recv() (*ConversationStream_Reply, error) {
	m := new(ConversationStream_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) EventStream(ctx context.Context, in *EventStream_Request, opts ...grpc.CallOption) (MessengerService_EventStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[4], "/berty.messenger.v1.MessengerService/EventStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceEventStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_EventStreamClient interface {
	Recv() (*EventStream_Reply, error)
	grpc.ClientStream
}

type messengerServiceEventStreamClient struct {
	grpc.ClientStream
}

func (x *messengerServiceEventStreamClient) Recv() (*EventStream_Reply, error) {
	m := new(EventStream_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) ConversationCreate(ctx context.Context, in *ConversationCreate_Request, opts ...grpc.CallOption) (*ConversationCreate_Reply, error) {
	out := new(ConversationCreate_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ConversationCreate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ConversationJoin(ctx context.Context, in *ConversationJoin_Request, opts ...grpc.CallOption) (*ConversationJoin_Reply, error) {
	out := new(ConversationJoin_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ConversationJoin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) AccountGet(ctx context.Context, in *AccountGet_Request, opts ...grpc.CallOption) (*AccountGet_Reply, error) {
	out := new(AccountGet_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/AccountGet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) AccountUpdate(ctx context.Context, in *AccountUpdate_Request, opts ...grpc.CallOption) (*AccountUpdate_Reply, error) {
	out := new(AccountUpdate_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/AccountUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) AccountPushConfigure(ctx context.Context, in *AccountPushConfigure_Request, opts ...grpc.CallOption) (*AccountPushConfigure_Reply, error) {
	out := new(AccountPushConfigure_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/AccountPushConfigure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ContactRequest(ctx context.Context, in *ContactRequest_Request, opts ...grpc.CallOption) (*ContactRequest_Reply, error) {
	out := new(ContactRequest_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ContactRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ContactAccept(ctx context.Context, in *ContactAccept_Request, opts ...grpc.CallOption) (*ContactAccept_Reply, error) {
	out := new(ContactAccept_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ContactAccept", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) Interact(ctx context.Context, in *Interact_Request, opts ...grpc.CallOption) (*Interact_Reply, error) {
	out := new(Interact_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/Interact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ConversationOpen(ctx context.Context, in *ConversationOpen_Request, opts ...grpc.CallOption) (*ConversationOpen_Reply, error) {
	out := new(ConversationOpen_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ConversationOpen", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ConversationClose(ctx context.Context, in *ConversationClose_Request, opts ...grpc.CallOption) (*ConversationClose_Reply, error) {
	out := new(ConversationClose_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ConversationClose", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ConversationLoad(ctx context.Context, in *ConversationLoad_Request, opts ...grpc.CallOption) (*ConversationLoad_Reply, error) {
	out := new(ConversationLoad_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ConversationLoad", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ConversationMute(ctx context.Context, in *ConversationMute_Request, opts ...grpc.CallOption) (*ConversationMute_Reply, error) {
	out := new(ConversationMute_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ConversationMute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ServicesTokenList(ctx context.Context, in *protocoltypes.ServicesTokenList_Request, opts ...grpc.CallOption) (MessengerService_ServicesTokenListClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[5], "/berty.messenger.v1.MessengerService/ServicesTokenList", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceServicesTokenListClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_ServicesTokenListClient interface {
	Recv() (*protocoltypes.ServicesTokenList_Reply, error)
	grpc.ClientStream
}

type messengerServiceServicesTokenListClient struct {
	grpc.ClientStream
}

func (x *messengerServiceServicesTokenListClient) Recv() (*protocoltypes.ServicesTokenList_Reply, error) {
	m := new(protocoltypes.ServicesTokenList_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) ReplicationServiceRegisterGroup(ctx context.Context, in *ReplicationServiceRegisterGroup_Request, opts ...grpc.CallOption) (*ReplicationServiceRegisterGroup_Reply, error) {
	out := new(ReplicationServiceRegisterGroup_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ReplicationServiceRegisterGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ReplicationSetAutoEnable(ctx context.Context, in *ReplicationSetAutoEnable_Request, opts ...grpc.CallOption) (*ReplicationSetAutoEnable_Reply, error) {
	out := new(ReplicationSetAutoEnable_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/ReplicationSetAutoEnable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) BannerQuote(ctx context.Context, in *BannerQuote_Request, opts ...grpc.CallOption) (*BannerQuote_Reply, error) {
	out := new(BannerQuote_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/BannerQuote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) InstanceExportData(ctx context.Context, in *InstanceExportData_Request, opts ...grpc.CallOption) (MessengerService_InstanceExportDataClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[6], "/berty.messenger.v1.MessengerService/InstanceExportData", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceInstanceExportDataClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_InstanceExportDataClient interface {
	Recv() (*InstanceExportData_Reply, error)
	grpc.ClientStream
}

type messengerServiceInstanceExportDataClient struct {
	grpc.ClientStream
}

func (x *messengerServiceInstanceExportDataClient) Recv() (*InstanceExportData_Reply, error) {
	m := new(InstanceExportData_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) MessageSearch(ctx context.Context, in *MessageSearch_Request, opts ...grpc.CallOption) (*MessageSearch_Reply, error) {
	out := new(MessageSearch_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/MessageSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) ListMemberDevices(ctx context.Context, in *ListMemberDevices_Request, opts ...grpc.CallOption) (MessengerService_ListMemberDevicesClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[7], "/berty.messenger.v1.MessengerService/ListMemberDevices", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceListMemberDevicesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_ListMemberDevicesClient interface {
	Recv() (*ListMemberDevices_Reply, error)
	grpc.ClientStream
}

type messengerServiceListMemberDevicesClient struct {
	grpc.ClientStream
}

func (x *messengerServiceListMemberDevicesClient) Recv() (*ListMemberDevices_Reply, error) {
	m := new(ListMemberDevices_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) TyberHostSearch(ctx context.Context, in *TyberHostSearch_Request, opts ...grpc.CallOption) (MessengerService_TyberHostSearchClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[8], "/berty.messenger.v1.MessengerService/TyberHostSearch", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceTyberHostSearchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_TyberHostSearchClient interface {
	Recv() (*TyberHostSearch_Reply, error)
	grpc.ClientStream
}

type messengerServiceTyberHostSearchClient struct {
	grpc.ClientStream
}

func (x *messengerServiceTyberHostSearchClient) Recv() (*TyberHostSearch_Reply, error) {
	m := new(TyberHostSearch_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) TyberHostAttach(ctx context.Context, in *TyberHostAttach_Request, opts ...grpc.CallOption) (*TyberHostAttach_Reply, error) {
	out := new(TyberHostAttach_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/TyberHostAttach", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) PushSetAutoShare(ctx context.Context, in *PushSetAutoShare_Request, opts ...grpc.CallOption) (*PushSetAutoShare_Reply, error) {
	out := new(PushSetAutoShare_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/PushSetAutoShare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) PushShareTokenForConversation(ctx context.Context, in *PushShareTokenForConversation_Request, opts ...grpc.CallOption) (*PushShareTokenForConversation_Reply, error) {
	out := new(PushShareTokenForConversation_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/PushShareTokenForConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) PushTokenSharedForConversation(ctx context.Context, in *PushTokenSharedForConversation_Request, opts ...grpc.CallOption) (MessengerService_PushTokenSharedForConversationClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[9], "/berty.messenger.v1.MessengerService/PushTokenSharedForConversation", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServicePushTokenSharedForConversationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_PushTokenSharedForConversationClient interface {
	Recv() (*PushTokenSharedForConversation_Reply, error)
	grpc.ClientStream
}

type messengerServicePushTokenSharedForConversationClient struct {
	grpc.ClientStream
}

func (x *messengerServicePushTokenSharedForConversationClient) Recv() (*PushTokenSharedForConversation_Reply, error) {
	m := new(PushTokenSharedForConversation_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messengerServiceClient) PushReceive(ctx context.Context, in *PushReceive_Request, opts ...grpc.CallOption) (*PushReceive_Reply, error) {
	out := new(PushReceive_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/PushReceive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) DirectoryServiceRegister(ctx context.Context, in *DirectoryServiceRegister_Request, opts ...grpc.CallOption) (*DirectoryServiceRegister_Reply, error) {
	out := new(DirectoryServiceRegister_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/DirectoryServiceRegister", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) DirectoryServiceUnregister(ctx context.Context, in *DirectoryServiceUnregister_Request, opts ...grpc.CallOption) (*DirectoryServiceUnregister_Reply, error) {
	out := new(DirectoryServiceUnregister_Reply)
	err := c.cc.Invoke(ctx, "/berty.messenger.v1.MessengerService/DirectoryServiceUnregister", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messengerServiceClient) DirectoryServiceQuery(ctx context.Context, in *DirectoryServiceQuery_Request, opts ...grpc.CallOption) (MessengerService_DirectoryServiceQueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessengerService_ServiceDesc.Streams[10], "/berty.messenger.v1.MessengerService/DirectoryServiceQuery", opts...)
	if err != nil {
		return nil, err
	}
	x := &messengerServiceDirectoryServiceQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessengerService_DirectoryServiceQueryClient interface {
	Recv() (*DirectoryServiceQuery_Reply, error)
	grpc.ClientStream
}

type messengerServiceDirectoryServiceQueryClient struct {
	grpc.ClientStream
}

func (x *messengerServiceDirectoryServiceQueryClient) Recv() (*DirectoryServiceQuery_Reply, error) {
	m := new(DirectoryServiceQuery_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// MessengerServiceServer is the server API for MessengerService service.
// All implementations must embed UnimplementedMessengerServiceServer
// for forward compatibility
type MessengerServiceServer interface {
	// InstanceShareableBertyID returns a Berty ID that can be shared as a string, QR code or deep link.
	InstanceShareableBertyID(context.Context, *InstanceShareableBertyID_Request) (*InstanceShareableBertyID_Reply, error)
	// ShareableBertyGroup returns a Berty Group that can be shared as a string, QR code or deep link.
	ShareableBertyGroup(context.Context, *ShareableBertyGroup_Request) (*ShareableBertyGroup_Reply, error)
	// DevShareInstanceBertyID shares your Berty ID on a dev channel.
	// TODO: remove for public.
	DevShareInstanceBertyID(context.Context, *DevShareInstanceBertyID_Request) (*DevShareInstanceBertyID_Reply, error)
	// DevStreamLogs streams logs from the ring-buffer.
	DevStreamLogs(*DevStreamLogs_Request, MessengerService_DevStreamLogsServer) error
	// ParseDeepLink parses a link in the form of berty://xxx or https://berty.tech/id# and returns a structure
	// that can be used to display information.
	// This action is read-only.
	ParseDeepLink(context.Context, *ParseDeepLink_Request) (*ParseDeepLink_Reply, error)
	// SendContactRequest takes the payload received from ParseDeepLink and send a contact request using the weshnet.protocol.
	SendContactRequest(context.Context, *SendContactRequest_Request) (*SendContactRequest_Reply, error)
	// SystemInfo returns runtime information.
	SystemInfo(context.Context, *SystemInfo_Request) (*SystemInfo_Reply, error)
	// Use to test stream.
	EchoTest(*EchoTest_Request, MessengerService_EchoTestServer) error
	// Use to test duplex stream.
	EchoDuplexTest(MessengerService_EchoDuplexTestServer) error
	ConversationStream(*ConversationStream_Request, MessengerService_ConversationStreamServer) error
	EventStream(*EventStream_Request, MessengerService_EventStreamServer) error
	ConversationCreate(context.Context, *ConversationCreate_Request) (*ConversationCreate_Reply, error)
	ConversationJoin(context.Context, *ConversationJoin_Request) (*ConversationJoin_Reply, error)
	AccountGet(context.Context, *AccountGet_Request) (*AccountGet_Reply, error)
	AccountUpdate(context.Context, *AccountUpdate_Request) (*AccountUpdate_Reply, error)
	AccountPushConfigure(context.Context, *AccountPushConfigure_Request) (*AccountPushConfigure_Reply, error)
	ContactRequest(context.Context, *ContactRequest_Request) (*ContactRequest_Reply, error)
	ContactAccept(context.Context, *ContactAccept_Request) (*ContactAccept_Reply, error)
	Interact(context.Context, *Interact_Request) (*Interact_Reply, error)
	ConversationOpen(context.Context, *ConversationOpen_Request) (*ConversationOpen_Reply, error)
	ConversationClose(context.Context, *ConversationClose_Request) (*ConversationClose_Reply, error)
	ConversationLoad(context.Context, *ConversationLoad_Request) (*ConversationLoad_Reply, error)
	ConversationMute(context.Context, *ConversationMute_Request) (*ConversationMute_Reply, error)
	// ServicesTokenList Retrieves the list of service server tokens
	ServicesTokenList(*protocoltypes.ServicesTokenList_Request, MessengerService_ServicesTokenListServer) error
	// ReplicationServiceRegisterGroup Asks a replication service to distribute a group contents
	ReplicationServiceRegisterGroup(context.Context, *ReplicationServiceRegisterGroup_Request) (*ReplicationServiceRegisterGroup_Reply, error)
	// ReplicationSetAutoEnable Sets whether new groups should be replicated automatically or not
	ReplicationSetAutoEnable(context.Context, *ReplicationSetAutoEnable_Request) (*ReplicationSetAutoEnable_Reply, error)
	// BannerQuote returns the quote of the day.
	BannerQuote(context.Context, *BannerQuote_Request) (*BannerQuote_Reply, error)
	// InstanceExportData exports instance data
	InstanceExportData(*InstanceExportData_Request, MessengerService_InstanceExportDataServer) error
	// MessageSearch
	MessageSearch(context.Context, *MessageSearch_Request) (*MessageSearch_Reply, error)
	// ListMemberDevices Lists devices for a member
	ListMemberDevices(*ListMemberDevices_Request, MessengerService_ListMemberDevicesServer) error
	// TyberHostSearch
	TyberHostSearch(*TyberHostSearch_Request, MessengerService_TyberHostSearchServer) error
	// TyberHostAttach
	TyberHostAttach(context.Context, *TyberHostAttach_Request) (*TyberHostAttach_Reply, error)
	// PushSetAutoShare Sets whether new groups should receive our push token automatically or not
	PushSetAutoShare(context.Context, *PushSetAutoShare_Request) (*PushSetAutoShare_Reply, error)
	// PushShareTokenForConversation Share a push token for a conversation
	PushShareTokenForConversation(context.Context, *PushShareTokenForConversation_Request) (*PushShareTokenForConversation_Reply, error)
	// PushTokenSharedForConversation
	PushTokenSharedForConversation(*PushTokenSharedForConversation_Request, MessengerService_PushTokenSharedForConversationServer) error
	// PushReceive handles a push payload, decrypts it if possible, adds it to the local store
	PushReceive(context.Context, *PushReceive_Request) (*PushReceive_Reply, error)
	// DirectoryServiceRegister registers a verified credential on a directory service
	DirectoryServiceRegister(context.Context, *DirectoryServiceRegister_Request) (*DirectoryServiceRegister_Reply, error)
	// DirectoryServiceUnregister requests a directory service to remove a verified credential
	DirectoryServiceUnregister(context.Context, *DirectoryServiceUnregister_Request) (*DirectoryServiceUnregister_Reply, error)
	// DirectoryServiceQuery queries a directory service for given identifiers
	DirectoryServiceQuery(*DirectoryServiceQuery_Request, MessengerService_DirectoryServiceQueryServer) error
	mustEmbedUnimplementedMessengerServiceServer()
}

// UnimplementedMessengerServiceServer must be embedded to have forward compatible implementations.
type UnimplementedMessengerServiceServer struct {
}

func (UnimplementedMessengerServiceServer) InstanceShareableBertyID(context.Context, *InstanceShareableBertyID_Request) (*InstanceShareableBertyID_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstanceShareableBertyID not implemented")
}
func (UnimplementedMessengerServiceServer) ShareableBertyGroup(context.Context, *ShareableBertyGroup_Request) (*ShareableBertyGroup_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShareableBertyGroup not implemented")
}
func (UnimplementedMessengerServiceServer) DevShareInstanceBertyID(context.Context, *DevShareInstanceBertyID_Request) (*DevShareInstanceBertyID_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DevShareInstanceBertyID not implemented")
}
func (UnimplementedMessengerServiceServer) DevStreamLogs(*DevStreamLogs_Request, MessengerService_DevStreamLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method DevStreamLogs not implemented")
}
func (UnimplementedMessengerServiceServer) ParseDeepLink(context.Context, *ParseDeepLink_Request) (*ParseDeepLink_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ParseDeepLink not implemented")
}
func (UnimplementedMessengerServiceServer) SendContactRequest(context.Context, *SendContactRequest_Request) (*SendContactRequest_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendContactRequest not implemented")
}
func (UnimplementedMessengerServiceServer) SystemInfo(context.Context, *SystemInfo_Request) (*SystemInfo_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SystemInfo not implemented")
}
func (UnimplementedMessengerServiceServer) EchoTest(*EchoTest_Request, MessengerService_EchoTestServer) error {
	return status.Errorf(codes.Unimplemented, "method EchoTest not implemented")
}
func (UnimplementedMessengerServiceServer) EchoDuplexTest(MessengerService_EchoDuplexTestServer) error {
	return status.Errorf(codes.Unimplemented, "method EchoDuplexTest not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationStream(*ConversationStream_Request, MessengerService_ConversationStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method ConversationStream not implemented")
}
func (UnimplementedMessengerServiceServer) EventStream(*EventStream_Request, MessengerService_EventStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method EventStream not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationCreate(context.Context, *ConversationCreate_Request) (*ConversationCreate_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConversationCreate not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationJoin(context.Context, *ConversationJoin_Request) (*ConversationJoin_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConversationJoin not implemented")
}
func (UnimplementedMessengerServiceServer) AccountGet(context.Context, *AccountGet_Request) (*AccountGet_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AccountGet not implemented")
}
func (UnimplementedMessengerServiceServer) AccountUpdate(context.Context, *AccountUpdate_Request) (*AccountUpdate_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AccountUpdate not implemented")
}
func (UnimplementedMessengerServiceServer) AccountPushConfigure(context.Context, *AccountPushConfigure_Request) (*AccountPushConfigure_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AccountPushConfigure not implemented")
}
func (UnimplementedMessengerServiceServer) ContactRequest(context.Context, *ContactRequest_Request) (*ContactRequest_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequest not implemented")
}
func (UnimplementedMessengerServiceServer) ContactAccept(context.Context, *ContactAccept_Request) (*ContactAccept_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactAccept not implemented")
}
func (UnimplementedMessengerServiceServer) Interact(context.Context, *Interact_Request) (*Interact_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Interact not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationOpen(context.Context, *ConversationOpen_Request) (*ConversationOpen_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConversationOpen not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationClose(context.Context, *ConversationClose_Request) (*ConversationClose_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConversationClose not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationLoad(context.Context, *ConversationLoad_Request) (*ConversationLoad_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConversationLoad not implemented")
}
func (UnimplementedMessengerServiceServer) ConversationMute(context.Context, *ConversationMute_Request) (*ConversationMute_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConversationMute not implemented")
}
func (UnimplementedMessengerServiceServer) ServicesTokenList(*protocoltypes.ServicesTokenList_Request, MessengerService_ServicesTokenListServer) error {
	return status.Errorf(codes.Unimplemented, "method ServicesTokenList not implemented")
}
func (UnimplementedMessengerServiceServer) ReplicationServiceRegisterGroup(context.Context, *ReplicationServiceRegisterGroup_Request) (*ReplicationServiceRegisterGroup_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicationServiceRegisterGroup not implemented")
}
func (UnimplementedMessengerServiceServer) ReplicationSetAutoEnable(context.Context, *ReplicationSetAutoEnable_Request) (*ReplicationSetAutoEnable_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicationSetAutoEnable not implemented")
}
func (UnimplementedMessengerServiceServer) BannerQuote(context.Context, *BannerQuote_Request) (*BannerQuote_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BannerQuote not implemented")
}
func (UnimplementedMessengerServiceServer) InstanceExportData(*InstanceExportData_Request, MessengerService_InstanceExportDataServer) error {
	return status.Errorf(codes.Unimplemented, "method InstanceExportData not implemented")
}
func (UnimplementedMessengerServiceServer) MessageSearch(context.Context, *MessageSearch_Request) (*MessageSearch_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MessageSearch not implemented")
}
func (UnimplementedMessengerServiceServer) ListMemberDevices(*ListMemberDevices_Request, MessengerService_ListMemberDevicesServer) error {
	return status.Errorf(codes.Unimplemented, "method ListMemberDevices not implemented")
}
func (UnimplementedMessengerServiceServer) TyberHostSearch(*TyberHostSearch_Request, MessengerService_TyberHostSearchServer) error {
	return status.Errorf(codes.Unimplemented, "method TyberHostSearch not implemented")
}
func (UnimplementedMessengerServiceServer) TyberHostAttach(context.Context, *TyberHostAttach_Request) (*TyberHostAttach_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TyberHostAttach not implemented")
}
func (UnimplementedMessengerServiceServer) PushSetAutoShare(context.Context, *PushSetAutoShare_Request) (*PushSetAutoShare_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushSetAutoShare not implemented")
}
func (UnimplementedMessengerServiceServer) PushShareTokenForConversation(context.Context, *PushShareTokenForConversation_Request) (*PushShareTokenForConversation_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushShareTokenForConversation not implemented")
}
func (UnimplementedMessengerServiceServer) PushTokenSharedForConversation(*PushTokenSharedForConversation_Request, MessengerService_PushTokenSharedForConversationServer) error {
	return status.Errorf(codes.Unimplemented, "method PushTokenSharedForConversation not implemented")
}
func (UnimplementedMessengerServiceServer) PushReceive(context.Context, *PushReceive_Request) (*PushReceive_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushReceive not implemented")
}
func (UnimplementedMessengerServiceServer) DirectoryServiceRegister(context.Context, *DirectoryServiceRegister_Request) (*DirectoryServiceRegister_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DirectoryServiceRegister not implemented")
}
func (UnimplementedMessengerServiceServer) DirectoryServiceUnregister(context.Context, *DirectoryServiceUnregister_Request) (*DirectoryServiceUnregister_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DirectoryServiceUnregister not implemented")
}
func (UnimplementedMessengerServiceServer) DirectoryServiceQuery(*DirectoryServiceQuery_Request, MessengerService_DirectoryServiceQueryServer) error {
	return status.Errorf(codes.Unimplemented, "method DirectoryServiceQuery not implemented")
}
func (UnimplementedMessengerServiceServer) mustEmbedUnimplementedMessengerServiceServer() {}

// UnsafeMessengerServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MessengerServiceServer will
// result in compilation errors.
type UnsafeMessengerServiceServer interface {
	mustEmbedUnimplementedMessengerServiceServer()
}

func RegisterMessengerServiceServer(s grpc.ServiceRegistrar, srv MessengerServiceServer) {
	s.RegisterService(&MessengerService_ServiceDesc, srv)
}

func _MessengerService_InstanceShareableBertyID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstanceShareableBertyID_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).InstanceShareableBertyID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/InstanceShareableBertyID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).InstanceShareableBertyID(ctx, req.(*InstanceShareableBertyID_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ShareableBertyGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShareableBertyGroup_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ShareableBertyGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ShareableBertyGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ShareableBertyGroup(ctx, req.(*ShareableBertyGroup_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_DevShareInstanceBertyID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DevShareInstanceBertyID_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).DevShareInstanceBertyID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/DevShareInstanceBertyID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).DevShareInstanceBertyID(ctx, req.(*DevShareInstanceBertyID_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_DevStreamLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DevStreamLogs_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).DevStreamLogs(m, &messengerServiceDevStreamLogsServer{stream})
}

type MessengerService_DevStreamLogsServer interface {
	Send(*DevStreamLogs_Reply) error
	grpc.ServerStream
}

type messengerServiceDevStreamLogsServer struct {
	grpc.ServerStream
}

func (x *messengerServiceDevStreamLogsServer) Send(m *DevStreamLogs_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_ParseDeepLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ParseDeepLink_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ParseDeepLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ParseDeepLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ParseDeepLink(ctx, req.(*ParseDeepLink_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_SendContactRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendContactRequest_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).SendContactRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/SendContactRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).SendContactRequest(ctx, req.(*SendContactRequest_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_SystemInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SystemInfo_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).SystemInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/SystemInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).SystemInfo(ctx, req.(*SystemInfo_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_EchoTest_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EchoTest_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).EchoTest(m, &messengerServiceEchoTestServer{stream})
}

type MessengerService_EchoTestServer interface {
	Send(*EchoTest_Reply) error
	grpc.ServerStream
}

type messengerServiceEchoTestServer struct {
	grpc.ServerStream
}

func (x *messengerServiceEchoTestServer) Send(m *EchoTest_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_EchoDuplexTest_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MessengerServiceServer).EchoDuplexTest(&messengerServiceEchoDuplexTestServer{stream})
}

type MessengerService_EchoDuplexTestServer interface {
	Send(*EchoDuplexTest_Reply) error
	Recv() (*EchoDuplexTest_Request, error)
	grpc.ServerStream
}

type messengerServiceEchoDuplexTestServer struct {
	grpc.ServerStream
}

func (x *messengerServiceEchoDuplexTestServer) Send(m *EchoDuplexTest_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func (x *messengerServiceEchoDuplexTestServer) Recv() (*EchoDuplexTest_Request, error) {
	m := new(EchoDuplexTest_Request)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _MessengerService_ConversationStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ConversationStream_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).ConversationStream(m, &messengerServiceConversationStreamServer{stream})
}

type MessengerService_ConversationStreamServer interface {
	Send(*ConversationStream_Reply) error
	grpc.ServerStream
}

type messengerServiceConversationStreamServer struct {
	grpc.ServerStream
}

func (x *messengerServiceConversationStreamServer) Send(m *ConversationStream_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_EventStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventStream_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).EventStream(m, &messengerServiceEventStreamServer{stream})
}

type MessengerService_EventStreamServer interface {
	Send(*EventStream_Reply) error
	grpc.ServerStream
}

type messengerServiceEventStreamServer struct {
	grpc.ServerStream
}

func (x *messengerServiceEventStreamServer) Send(m *EventStream_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_ConversationCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConversationCreate_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ConversationCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ConversationCreate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ConversationCreate(ctx, req.(*ConversationCreate_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ConversationJoin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConversationJoin_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ConversationJoin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ConversationJoin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ConversationJoin(ctx, req.(*ConversationJoin_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_AccountGet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountGet_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).AccountGet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/AccountGet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).AccountGet(ctx, req.(*AccountGet_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_AccountUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountUpdate_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).AccountUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/AccountUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).AccountUpdate(ctx, req.(*AccountUpdate_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_AccountPushConfigure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountPushConfigure_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).AccountPushConfigure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/AccountPushConfigure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).AccountPushConfigure(ctx, req.(*AccountPushConfigure_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ContactRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequest_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ContactRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ContactRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ContactRequest(ctx, req.(*ContactRequest_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ContactAccept_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactAccept_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ContactAccept(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ContactAccept",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ContactAccept(ctx, req.(*ContactAccept_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_Interact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Interact_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).Interact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/Interact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).Interact(ctx, req.(*Interact_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ConversationOpen_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConversationOpen_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ConversationOpen(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ConversationOpen",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ConversationOpen(ctx, req.(*ConversationOpen_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ConversationClose_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConversationClose_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ConversationClose(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ConversationClose",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ConversationClose(ctx, req.(*ConversationClose_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ConversationLoad_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConversationLoad_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ConversationLoad(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ConversationLoad",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ConversationLoad(ctx, req.(*ConversationLoad_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ConversationMute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConversationMute_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ConversationMute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ConversationMute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ConversationMute(ctx, req.(*ConversationMute_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ServicesTokenList_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(protocoltypes.ServicesTokenList_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).ServicesTokenList(m, &messengerServiceServicesTokenListServer{stream})
}

type MessengerService_ServicesTokenListServer interface {
	Send(*protocoltypes.ServicesTokenList_Reply) error
	grpc.ServerStream
}

type messengerServiceServicesTokenListServer struct {
	grpc.ServerStream
}

func (x *messengerServiceServicesTokenListServer) Send(m *protocoltypes.ServicesTokenList_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_ReplicationServiceRegisterGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicationServiceRegisterGroup_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ReplicationServiceRegisterGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ReplicationServiceRegisterGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ReplicationServiceRegisterGroup(ctx, req.(*ReplicationServiceRegisterGroup_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ReplicationSetAutoEnable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicationSetAutoEnable_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).ReplicationSetAutoEnable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/ReplicationSetAutoEnable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).ReplicationSetAutoEnable(ctx, req.(*ReplicationSetAutoEnable_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_BannerQuote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BannerQuote_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).BannerQuote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/BannerQuote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).BannerQuote(ctx, req.(*BannerQuote_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_InstanceExportData_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InstanceExportData_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).InstanceExportData(m, &messengerServiceInstanceExportDataServer{stream})
}

type MessengerService_InstanceExportDataServer interface {
	Send(*InstanceExportData_Reply) error
	grpc.ServerStream
}

type messengerServiceInstanceExportDataServer struct {
	grpc.ServerStream
}

func (x *messengerServiceInstanceExportDataServer) Send(m *InstanceExportData_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_MessageSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MessageSearch_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).MessageSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/MessageSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).MessageSearch(ctx, req.(*MessageSearch_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_ListMemberDevices_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListMemberDevices_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).ListMemberDevices(m, &messengerServiceListMemberDevicesServer{stream})
}

type MessengerService_ListMemberDevicesServer interface {
	Send(*ListMemberDevices_Reply) error
	grpc.ServerStream
}

type messengerServiceListMemberDevicesServer struct {
	grpc.ServerStream
}

func (x *messengerServiceListMemberDevicesServer) Send(m *ListMemberDevices_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_TyberHostSearch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TyberHostSearch_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).TyberHostSearch(m, &messengerServiceTyberHostSearchServer{stream})
}

type MessengerService_TyberHostSearchServer interface {
	Send(*TyberHostSearch_Reply) error
	grpc.ServerStream
}

type messengerServiceTyberHostSearchServer struct {
	grpc.ServerStream
}

func (x *messengerServiceTyberHostSearchServer) Send(m *TyberHostSearch_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_TyberHostAttach_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TyberHostAttach_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).TyberHostAttach(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/TyberHostAttach",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).TyberHostAttach(ctx, req.(*TyberHostAttach_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_PushSetAutoShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushSetAutoShare_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).PushSetAutoShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/PushSetAutoShare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).PushSetAutoShare(ctx, req.(*PushSetAutoShare_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_PushShareTokenForConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushShareTokenForConversation_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).PushShareTokenForConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/PushShareTokenForConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).PushShareTokenForConversation(ctx, req.(*PushShareTokenForConversation_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_PushTokenSharedForConversation_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PushTokenSharedForConversation_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).PushTokenSharedForConversation(m, &messengerServicePushTokenSharedForConversationServer{stream})
}

type MessengerService_PushTokenSharedForConversationServer interface {
	Send(*PushTokenSharedForConversation_Reply) error
	grpc.ServerStream
}

type messengerServicePushTokenSharedForConversationServer struct {
	grpc.ServerStream
}

func (x *messengerServicePushTokenSharedForConversationServer) Send(m *PushTokenSharedForConversation_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _MessengerService_PushReceive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushReceive_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).PushReceive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/PushReceive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).PushReceive(ctx, req.(*PushReceive_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_DirectoryServiceRegister_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DirectoryServiceRegister_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).DirectoryServiceRegister(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/DirectoryServiceRegister",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).DirectoryServiceRegister(ctx, req.(*DirectoryServiceRegister_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_DirectoryServiceUnregister_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DirectoryServiceUnregister_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessengerServiceServer).DirectoryServiceUnregister(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.messenger.v1.MessengerService/DirectoryServiceUnregister",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessengerServiceServer).DirectoryServiceUnregister(ctx, req.(*DirectoryServiceUnregister_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessengerService_DirectoryServiceQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DirectoryServiceQuery_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessengerServiceServer).DirectoryServiceQuery(m, &messengerServiceDirectoryServiceQueryServer{stream})
}

type MessengerService_DirectoryServiceQueryServer interface {
	Send(*DirectoryServiceQuery_Reply) error
	grpc.ServerStream
}

type messengerServiceDirectoryServiceQueryServer struct {
	grpc.ServerStream
}

func (x *messengerServiceDirectoryServiceQueryServer) Send(m *DirectoryServiceQuery_Reply) error {
	return x.ServerStream.SendMsg(m)
}

// MessengerService_ServiceDesc is the grpc.ServiceDesc for MessengerService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MessengerService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "berty.messenger.v1.MessengerService",
	HandlerType: (*MessengerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InstanceShareableBertyID",
			Handler:    _MessengerService_InstanceShareableBertyID_Handler,
		},
		{
			MethodName: "ShareableBertyGroup",
			Handler:    _MessengerService_ShareableBertyGroup_Handler,
		},
		{
			MethodName: "DevShareInstanceBertyID",
			Handler:    _MessengerService_DevShareInstanceBertyID_Handler,
		},
		{
			MethodName: "ParseDeepLink",
			Handler:    _MessengerService_ParseDeepLink_Handler,
		},
		{
			MethodName: "SendContactRequest",
			Handler:    _MessengerService_SendContactRequest_Handler,
		},
		{
			MethodName: "SystemInfo",
			Handler:    _MessengerService_SystemInfo_Handler,
		},
		{
			MethodName: "ConversationCreate",
			Handler:    _MessengerService_ConversationCreate_Handler,
		},
		{
			MethodName: "ConversationJoin",
			Handler:    _MessengerService_ConversationJoin_Handler,
		},
		{
			MethodName: "AccountGet",
			Handler:    _MessengerService_AccountGet_Handler,
		},
		{
			MethodName: "AccountUpdate",
			Handler:    _MessengerService_AccountUpdate_Handler,
		},
		{
			MethodName: "AccountPushConfigure",
			Handler:    _MessengerService_AccountPushConfigure_Handler,
		},
		{
			MethodName: "ContactRequest",
			Handler:    _MessengerService_ContactRequest_Handler,
		},
		{
			MethodName: "ContactAccept",
			Handler:    _MessengerService_ContactAccept_Handler,
		},
		{
			MethodName: "Interact",
			Handler:    _MessengerService_Interact_Handler,
		},
		{
			MethodName: "ConversationOpen",
			Handler:    _MessengerService_ConversationOpen_Handler,
		},
		{
			MethodName: "ConversationClose",
			Handler:    _MessengerService_ConversationClose_Handler,
		},
		{
			MethodName: "ConversationLoad",
			Handler:    _MessengerService_ConversationLoad_Handler,
		},
		{
			MethodName: "ConversationMute",
			Handler:    _MessengerService_ConversationMute_Handler,
		},
		{
			MethodName: "ReplicationServiceRegisterGroup",
			Handler:    _MessengerService_ReplicationServiceRegisterGroup_Handler,
		},
		{
			MethodName: "ReplicationSetAutoEnable",
			Handler:    _MessengerService_ReplicationSetAutoEnable_Handler,
		},
		{
			MethodName: "BannerQuote",
			Handler:    _MessengerService_BannerQuote_Handler,
		},
		{
			MethodName: "MessageSearch",
			Handler:    _MessengerService_MessageSearch_Handler,
		},
		{
			MethodName: "TyberHostAttach",
			Handler:    _MessengerService_TyberHostAttach_Handler,
		},
		{
			MethodName: "PushSetAutoShare",
			Handler:    _MessengerService_PushSetAutoShare_Handler,
		},
		{
			MethodName: "PushShareTokenForConversation",
			Handler:    _MessengerService_PushShareTokenForConversation_Handler,
		},
		{
			MethodName: "PushReceive",
			Handler:    _MessengerService_PushReceive_Handler,
		},
		{
			MethodName: "DirectoryServiceRegister",
			Handler:    _MessengerService_DirectoryServiceRegister_Handler,
		},
		{
			MethodName: "DirectoryServiceUnregister",
			Handler:    _MessengerService_DirectoryServiceUnregister_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "DevStreamLogs",
			Handler:       _MessengerService_DevStreamLogs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "EchoTest",
			Handler:       _MessengerService_EchoTest_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "EchoDuplexTest",
			Handler:       _MessengerService_EchoDuplexTest_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ConversationStream",
			Handler:       _MessengerService_ConversationStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "EventStream",
			Handler:       _MessengerService_EventStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ServicesTokenList",
			Handler:       _MessengerService_ServicesTokenList_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "InstanceExportData",
			Handler:       _MessengerService_InstanceExportData_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListMemberDevices",
			Handler:       _MessengerService_ListMemberDevices_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "TyberHostSearch",
			Handler:       _MessengerService_TyberHostSearch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PushTokenSharedForConversation",
			Handler:       _MessengerService_PushTokenSharedForConversation_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DirectoryServiceQuery",
			Handler:       _MessengerService_DirectoryServiceQuery_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "messengertypes/messengertypes.proto",
}
