# Resources

## Whitepapers or Wiki 

### From https://pdfs.semanticscholar.org/
- [A Survey on Distributed Hash Table (DHT): Theory, Platforms, and Applications](https://pdfs.semanticscholar.org/8859/3bf30b9de1497ba22b1136ebc433f648bbc8.pdf)
- [An Internet Indirection Infrastructure - based Workflow Support System](https://pdfs.semanticscholar.org/d53f/b071e4e8fc5567ce489544bd503da112ac0b.pdf)

### From http://www.srhea.net/papers/
- [Fixing embarrassing slowness of OpenDHT in PlanetLab](http://www.srhea.net/papers/opendht-worlds05.pdf)
- [OceanStore: An architecture for Global-Scale Persistent Storage](http://www.srhea.net/papers/asplos00.pdf)
- [OpenDHT: A Public DHT Service](http://www.srhea.net/papers/rhea-thesis.pdf)
- [OpenDHT: A Public DHT Service and its uses](http://www.srhea.net/papers/rhea-thesis.pdf)
- [Spurring Adoption of DHTs with OpenHash, a Public DHT Service](http://www.srhea.net/papers/karp-openhash.pdf)

### From https://pdos.csail.mit.edu/papers/
- [Chord: A Scalable Peer-to-peer Lookup Service for Internet Applications](https://pdos.csail.mit.edu/papers/chord:sigcomm01/chord_sigcomm.pdf)

### From https://github.com/sit/dht/
- [What is chord, what is DHash](https://github.com/sit/dht/wiki/faq)

### From http://www.bittorrent.org/
- [BEP: 5](http://www.bittorrent.org/beps/bep_0005.html)

## Implementations

### Kademlia
#### Bittorrent
- https://github.com/webtorrent/bittorrent-dht
- https://github.com/jech/dht
- https://github.com/nictuku/dht
- https://github.com/mh-cbon/dht
- https://github.com/shiyanhui/dht
- https://github.com/anacrolix/dht

#### OpenDHT
- https://github.com/savoirfairelinux/opendht

#### Libp2p
- https://github.com/libp2p/go-libp2p-kad-dht

### GNUnet
- https://gnunet.org/git/

### Hazelcast
- https://github.com/hazelcast/hazelcast

### CHORD
- https://github.com/sit/dht
- http://sourceforge.net/projects/open-chord/
- https://github.com/roshanpty/CHORD)
- https://github.com/mattwilliamson/chordial)
- https://github.com/armon/go-chord
- https://github.com/r-medina/gmaj
- https://github.com/cbocovic/chord
