package schema

// CloudformationSchema defined a JSON Schema that can be used to validate CloudFormation/SAM templates
var CloudformationSchema = `{
    "$id": "http://json-schema.org/draft-04/schema#",
    "additionalProperties": false,
    "definitions": {
        "AWS::ACMPCA::Certificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiPassthrough": {
                            "$ref": "#/definitions/AWS::ACMPCA::Certificate.ApiPassthrough"
                        },
                        "CertificateAuthorityArn": {
                            "type": "string"
                        },
                        "CertificateSigningRequest": {
                            "type": "string"
                        },
                        "SigningAlgorithm": {
                            "type": "string"
                        },
                        "TemplateArn": {
                            "type": "string"
                        },
                        "Validity": {
                            "$ref": "#/definitions/AWS::ACMPCA::Certificate.Validity"
                        },
                        "ValidityNotBefore": {
                            "$ref": "#/definitions/AWS::ACMPCA::Certificate.Validity"
                        }
                    },
                    "required": [
                        "CertificateAuthorityArn",
                        "CertificateSigningRequest",
                        "SigningAlgorithm",
                        "Validity"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ACMPCA::Certificate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.ApiPassthrough": {
            "additionalProperties": false,
            "properties": {
                "Extensions": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.Extensions"
                },
                "Subject": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.Subject"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.EdiPartyName": {
            "additionalProperties": false,
            "properties": {
                "NameAssigner": {
                    "type": "string"
                },
                "PartyName": {
                    "type": "string"
                }
            },
            "required": [
                "NameAssigner",
                "PartyName"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.ExtendedKeyUsage": {
            "additionalProperties": false,
            "properties": {
                "ExtendedKeyUsageObjectIdentifier": {
                    "type": "string"
                },
                "ExtendedKeyUsageType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.Extensions": {
            "additionalProperties": false,
            "properties": {
                "CertificatePolicies": {
                    "items": {
                        "$ref": "#/definitions/AWS::ACMPCA::Certificate.PolicyInformation"
                    },
                    "type": "array"
                },
                "ExtendedKeyUsage": {
                    "items": {
                        "$ref": "#/definitions/AWS::ACMPCA::Certificate.ExtendedKeyUsage"
                    },
                    "type": "array"
                },
                "KeyUsage": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.KeyUsage"
                },
                "SubjectAlternativeNames": {
                    "items": {
                        "$ref": "#/definitions/AWS::ACMPCA::Certificate.GeneralName"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.GeneralName": {
            "additionalProperties": false,
            "properties": {
                "DirectoryName": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.Subject"
                },
                "DnsName": {
                    "type": "string"
                },
                "EdiPartyName": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.EdiPartyName"
                },
                "IpAddress": {
                    "type": "string"
                },
                "OtherName": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.OtherName"
                },
                "RegisteredId": {
                    "type": "string"
                },
                "Rfc822Name": {
                    "type": "string"
                },
                "UniformResourceIdentifier": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.KeyUsage": {
            "additionalProperties": false,
            "properties": {
                "CRLSign": {
                    "type": "boolean"
                },
                "DataEncipherment": {
                    "type": "boolean"
                },
                "DecipherOnly": {
                    "type": "boolean"
                },
                "DigitalSignature": {
                    "type": "boolean"
                },
                "EncipherOnly": {
                    "type": "boolean"
                },
                "KeyAgreement": {
                    "type": "boolean"
                },
                "KeyCertSign": {
                    "type": "boolean"
                },
                "KeyEncipherment": {
                    "type": "boolean"
                },
                "NonRepudiation": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.OtherName": {
            "additionalProperties": false,
            "properties": {
                "TypeId": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "TypeId",
                "Value"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.PolicyInformation": {
            "additionalProperties": false,
            "properties": {
                "CertPolicyId": {
                    "type": "string"
                },
                "PolicyQualifiers": {
                    "items": {
                        "$ref": "#/definitions/AWS::ACMPCA::Certificate.PolicyQualifierInfo"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CertPolicyId"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.PolicyQualifierInfo": {
            "additionalProperties": false,
            "properties": {
                "PolicyQualifierId": {
                    "type": "string"
                },
                "Qualifier": {
                    "$ref": "#/definitions/AWS::ACMPCA::Certificate.Qualifier"
                }
            },
            "required": [
                "PolicyQualifierId",
                "Qualifier"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.Qualifier": {
            "additionalProperties": false,
            "properties": {
                "CpsUri": {
                    "type": "string"
                }
            },
            "required": [
                "CpsUri"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.Subject": {
            "additionalProperties": false,
            "properties": {
                "CommonName": {
                    "type": "string"
                },
                "Country": {
                    "type": "string"
                },
                "DistinguishedNameQualifier": {
                    "type": "string"
                },
                "GenerationQualifier": {
                    "type": "string"
                },
                "GivenName": {
                    "type": "string"
                },
                "Initials": {
                    "type": "string"
                },
                "Locality": {
                    "type": "string"
                },
                "Organization": {
                    "type": "string"
                },
                "OrganizationalUnit": {
                    "type": "string"
                },
                "Pseudonym": {
                    "type": "string"
                },
                "SerialNumber": {
                    "type": "string"
                },
                "State": {
                    "type": "string"
                },
                "Surname": {
                    "type": "string"
                },
                "Title": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::Certificate.Validity": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "number"
                }
            },
            "required": [
                "Type",
                "Value"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CsrExtensions": {
                            "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.CsrExtensions"
                        },
                        "KeyAlgorithm": {
                            "type": "string"
                        },
                        "KeyStorageSecurityStandard": {
                            "type": "string"
                        },
                        "RevocationConfiguration": {
                            "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.RevocationConfiguration"
                        },
                        "SigningAlgorithm": {
                            "type": "string"
                        },
                        "Subject": {
                            "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.Subject"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "KeyAlgorithm",
                        "SigningAlgorithm",
                        "Subject",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ACMPCA::CertificateAuthority"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.AccessDescription": {
            "additionalProperties": false,
            "properties": {
                "AccessLocation": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.GeneralName"
                },
                "AccessMethod": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.AccessMethod"
                }
            },
            "required": [
                "AccessLocation",
                "AccessMethod"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.AccessMethod": {
            "additionalProperties": false,
            "properties": {
                "AccessMethodType": {
                    "type": "string"
                },
                "CustomObjectIdentifier": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.CrlConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomCname": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "ExpirationInDays": {
                    "type": "number"
                },
                "S3BucketName": {
                    "type": "string"
                },
                "S3ObjectAcl": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.CsrExtensions": {
            "additionalProperties": false,
            "properties": {
                "KeyUsage": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.KeyUsage"
                },
                "SubjectInformationAccess": {
                    "items": {
                        "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.AccessDescription"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.EdiPartyName": {
            "additionalProperties": false,
            "properties": {
                "NameAssigner": {
                    "type": "string"
                },
                "PartyName": {
                    "type": "string"
                }
            },
            "required": [
                "NameAssigner",
                "PartyName"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.GeneralName": {
            "additionalProperties": false,
            "properties": {
                "DirectoryName": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.Subject"
                },
                "DnsName": {
                    "type": "string"
                },
                "EdiPartyName": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.EdiPartyName"
                },
                "IpAddress": {
                    "type": "string"
                },
                "OtherName": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.OtherName"
                },
                "RegisteredId": {
                    "type": "string"
                },
                "Rfc822Name": {
                    "type": "string"
                },
                "UniformResourceIdentifier": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.KeyUsage": {
            "additionalProperties": false,
            "properties": {
                "CRLSign": {
                    "type": "boolean"
                },
                "DataEncipherment": {
                    "type": "boolean"
                },
                "DecipherOnly": {
                    "type": "boolean"
                },
                "DigitalSignature": {
                    "type": "boolean"
                },
                "EncipherOnly": {
                    "type": "boolean"
                },
                "KeyAgreement": {
                    "type": "boolean"
                },
                "KeyCertSign": {
                    "type": "boolean"
                },
                "KeyEncipherment": {
                    "type": "boolean"
                },
                "NonRepudiation": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.OtherName": {
            "additionalProperties": false,
            "properties": {
                "TypeId": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "TypeId",
                "Value"
            ],
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.RevocationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CrlConfiguration": {
                    "$ref": "#/definitions/AWS::ACMPCA::CertificateAuthority.CrlConfiguration"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthority.Subject": {
            "additionalProperties": false,
            "properties": {
                "CommonName": {
                    "type": "string"
                },
                "Country": {
                    "type": "string"
                },
                "DistinguishedNameQualifier": {
                    "type": "string"
                },
                "GenerationQualifier": {
                    "type": "string"
                },
                "GivenName": {
                    "type": "string"
                },
                "Initials": {
                    "type": "string"
                },
                "Locality": {
                    "type": "string"
                },
                "Organization": {
                    "type": "string"
                },
                "OrganizationalUnit": {
                    "type": "string"
                },
                "Pseudonym": {
                    "type": "string"
                },
                "SerialNumber": {
                    "type": "string"
                },
                "State": {
                    "type": "string"
                },
                "Surname": {
                    "type": "string"
                },
                "Title": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ACMPCA::CertificateAuthorityActivation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Certificate": {
                            "type": "string"
                        },
                        "CertificateAuthorityArn": {
                            "type": "string"
                        },
                        "CertificateChain": {
                            "type": "string"
                        },
                        "Status": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Certificate",
                        "CertificateAuthorityArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ACMPCA::CertificateAuthorityActivation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AccessAnalyzer::Analyzer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AnalyzerName": {
                            "type": "string"
                        },
                        "ArchiveRules": {
                            "items": {
                                "$ref": "#/definitions/AWS::AccessAnalyzer::Analyzer.ArchiveRule"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AccessAnalyzer::Analyzer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AccessAnalyzer::Analyzer.ArchiveRule": {
            "additionalProperties": false,
            "properties": {
                "Filter": {
                    "items": {
                        "$ref": "#/definitions/AWS::AccessAnalyzer::Analyzer.Filter"
                    },
                    "type": "array"
                },
                "RuleName": {
                    "type": "string"
                }
            },
            "required": [
                "Filter",
                "RuleName"
            ],
            "type": "object"
        },
        "AWS::AccessAnalyzer::Analyzer.Filter": {
            "additionalProperties": false,
            "properties": {
                "Contains": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Eq": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Exists": {
                    "type": "boolean"
                },
                "Neq": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Property": {
                    "type": "string"
                }
            },
            "required": [
                "Property"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationStrategy": {
                            "type": "string"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "BrokerName": {
                            "type": "string"
                        },
                        "Configuration": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.ConfigurationId"
                        },
                        "DeploymentMode": {
                            "type": "string"
                        },
                        "EncryptionOptions": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.EncryptionOptions"
                        },
                        "EngineType": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "HostInstanceType": {
                            "type": "string"
                        },
                        "LdapServerMetadata": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.LdapServerMetadata"
                        },
                        "Logs": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.LogList"
                        },
                        "MaintenanceWindowStartTime": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.MaintenanceWindow"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "StorageType": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AmazonMQ::Broker.TagsEntry"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "$ref": "#/definitions/AWS::AmazonMQ::Broker.User"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AutoMinorVersionUpgrade",
                        "BrokerName",
                        "DeploymentMode",
                        "EngineType",
                        "EngineVersion",
                        "HostInstanceType",
                        "PubliclyAccessible",
                        "Users"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AmazonMQ::Broker"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.ConfigurationId": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Revision": {
                    "type": "number"
                }
            },
            "required": [
                "Id",
                "Revision"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.EncryptionOptions": {
            "additionalProperties": false,
            "properties": {
                "KmsKeyId": {
                    "type": "string"
                },
                "UseAwsOwnedKey": {
                    "type": "boolean"
                }
            },
            "required": [
                "UseAwsOwnedKey"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.LdapServerMetadata": {
            "additionalProperties": false,
            "properties": {
                "Hosts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RoleBase": {
                    "type": "string"
                },
                "RoleName": {
                    "type": "string"
                },
                "RoleSearchMatching": {
                    "type": "string"
                },
                "RoleSearchSubtree": {
                    "type": "boolean"
                },
                "ServiceAccountPassword": {
                    "type": "string"
                },
                "ServiceAccountUsername": {
                    "type": "string"
                },
                "UserBase": {
                    "type": "string"
                },
                "UserRoleName": {
                    "type": "string"
                },
                "UserSearchMatching": {
                    "type": "string"
                },
                "UserSearchSubtree": {
                    "type": "boolean"
                }
            },
            "required": [
                "Hosts",
                "RoleBase",
                "RoleSearchMatching",
                "ServiceAccountPassword",
                "ServiceAccountUsername",
                "UserBase",
                "UserSearchMatching"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.LogList": {
            "additionalProperties": false,
            "properties": {
                "Audit": {
                    "type": "boolean"
                },
                "General": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.MaintenanceWindow": {
            "additionalProperties": false,
            "properties": {
                "DayOfWeek": {
                    "type": "string"
                },
                "TimeOfDay": {
                    "type": "string"
                },
                "TimeZone": {
                    "type": "string"
                }
            },
            "required": [
                "DayOfWeek",
                "TimeOfDay",
                "TimeZone"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.TagsEntry": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.User": {
            "additionalProperties": false,
            "properties": {
                "ConsoleAccess": {
                    "type": "boolean"
                },
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Configuration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationStrategy": {
                            "type": "string"
                        },
                        "Data": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EngineType": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AmazonMQ::Configuration.TagsEntry"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Data",
                        "EngineType",
                        "EngineVersion",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AmazonMQ::Configuration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Configuration.TagsEntry": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::ConfigurationAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Broker": {
                            "type": "string"
                        },
                        "Configuration": {
                            "$ref": "#/definitions/AWS::AmazonMQ::ConfigurationAssociation.ConfigurationId"
                        }
                    },
                    "required": [
                        "Broker",
                        "Configuration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AmazonMQ::ConfigurationAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::ConfigurationAssociation.ConfigurationId": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Revision": {
                    "type": "number"
                }
            },
            "required": [
                "Id",
                "Revision"
            ],
            "type": "object"
        },
        "AWS::Amplify::App": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessToken": {
                            "type": "string"
                        },
                        "AutoBranchCreationConfig": {
                            "$ref": "#/definitions/AWS::Amplify::App.AutoBranchCreationConfig"
                        },
                        "BasicAuthConfig": {
                            "$ref": "#/definitions/AWS::Amplify::App.BasicAuthConfig"
                        },
                        "BuildSpec": {
                            "type": "string"
                        },
                        "CustomHeaders": {
                            "type": "string"
                        },
                        "CustomRules": {
                            "items": {
                                "$ref": "#/definitions/AWS::Amplify::App.CustomRule"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnableBranchAutoDeletion": {
                            "type": "boolean"
                        },
                        "EnvironmentVariables": {
                            "items": {
                                "$ref": "#/definitions/AWS::Amplify::App.EnvironmentVariable"
                            },
                            "type": "array"
                        },
                        "IAMServiceRole": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OauthToken": {
                            "type": "string"
                        },
                        "Repository": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Amplify::App"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Amplify::App.AutoBranchCreationConfig": {
            "additionalProperties": false,
            "properties": {
                "AutoBranchCreationPatterns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "BasicAuthConfig": {
                    "$ref": "#/definitions/AWS::Amplify::App.BasicAuthConfig"
                },
                "BuildSpec": {
                    "type": "string"
                },
                "EnableAutoBranchCreation": {
                    "type": "boolean"
                },
                "EnableAutoBuild": {
                    "type": "boolean"
                },
                "EnablePerformanceMode": {
                    "type": "boolean"
                },
                "EnablePullRequestPreview": {
                    "type": "boolean"
                },
                "EnvironmentVariables": {
                    "items": {
                        "$ref": "#/definitions/AWS::Amplify::App.EnvironmentVariable"
                    },
                    "type": "array"
                },
                "PullRequestEnvironmentName": {
                    "type": "string"
                },
                "Stage": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Amplify::App.BasicAuthConfig": {
            "additionalProperties": false,
            "properties": {
                "EnableBasicAuth": {
                    "type": "boolean"
                },
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Amplify::App.CustomRule": {
            "additionalProperties": false,
            "properties": {
                "Condition": {
                    "type": "string"
                },
                "Source": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                },
                "Target": {
                    "type": "string"
                }
            },
            "required": [
                "Source",
                "Target"
            ],
            "type": "object"
        },
        "AWS::Amplify::App.EnvironmentVariable": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Amplify::Branch": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AppId": {
                            "type": "string"
                        },
                        "BasicAuthConfig": {
                            "$ref": "#/definitions/AWS::Amplify::Branch.BasicAuthConfig"
                        },
                        "BranchName": {
                            "type": "string"
                        },
                        "BuildSpec": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnableAutoBuild": {
                            "type": "boolean"
                        },
                        "EnablePerformanceMode": {
                            "type": "boolean"
                        },
                        "EnablePullRequestPreview": {
                            "type": "boolean"
                        },
                        "EnvironmentVariables": {
                            "items": {
                                "$ref": "#/definitions/AWS::Amplify::Branch.EnvironmentVariable"
                            },
                            "type": "array"
                        },
                        "PullRequestEnvironmentName": {
                            "type": "string"
                        },
                        "Stage": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AppId",
                        "BranchName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Amplify::Branch"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Amplify::Branch.BasicAuthConfig": {
            "additionalProperties": false,
            "properties": {
                "EnableBasicAuth": {
                    "type": "boolean"
                },
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::Amplify::Branch.EnvironmentVariable": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Amplify::Domain": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AppId": {
                            "type": "string"
                        },
                        "AutoSubDomainCreationPatterns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AutoSubDomainIAMRole": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "EnableAutoSubDomain": {
                            "type": "boolean"
                        },
                        "SubDomainSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::Amplify::Domain.SubDomainSetting"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AppId",
                        "DomainName",
                        "SubDomainSettings"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Amplify::Domain"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Amplify::Domain.SubDomainSetting": {
            "additionalProperties": false,
            "properties": {
                "BranchName": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "BranchName",
                "Prefix"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Account": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudWatchRoleArn": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Account"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::ApiKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CustomerId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "GenerateDistinctId": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "StageKeys": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::ApiKey.StageKey"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Value": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::ApiKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::ApiKey.StageKey": {
            "additionalProperties": false,
            "properties": {
                "RestApiId": {
                    "type": "string"
                },
                "StageName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Authorizer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthType": {
                            "type": "string"
                        },
                        "AuthorizerCredentials": {
                            "type": "string"
                        },
                        "AuthorizerResultTtlInSeconds": {
                            "type": "number"
                        },
                        "AuthorizerUri": {
                            "type": "string"
                        },
                        "IdentitySource": {
                            "type": "string"
                        },
                        "IdentityValidationExpression": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ProviderARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RestApiId",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Authorizer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::BasePathMapping": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BasePath": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "Stage": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::BasePathMapping"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::ClientCertificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::ClientCertificate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Deployment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeploymentCanarySettings": {
                            "$ref": "#/definitions/AWS::ApiGateway::Deployment.DeploymentCanarySettings"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "StageDescription": {
                            "$ref": "#/definitions/AWS::ApiGateway::Deployment.StageDescription"
                        },
                        "StageName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Deployment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.AccessLogSetting": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.CanarySetting": {
            "additionalProperties": false,
            "properties": {
                "PercentTraffic": {
                    "type": "number"
                },
                "StageVariableOverrides": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "UseStageCache": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.DeploymentCanarySettings": {
            "additionalProperties": false,
            "properties": {
                "PercentTraffic": {
                    "type": "number"
                },
                "StageVariableOverrides": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "UseStageCache": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.MethodSetting": {
            "additionalProperties": false,
            "properties": {
                "CacheDataEncrypted": {
                    "type": "boolean"
                },
                "CacheTtlInSeconds": {
                    "type": "number"
                },
                "CachingEnabled": {
                    "type": "boolean"
                },
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "HttpMethod": {
                    "type": "string"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "MetricsEnabled": {
                    "type": "boolean"
                },
                "ResourcePath": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.StageDescription": {
            "additionalProperties": false,
            "properties": {
                "AccessLogSetting": {
                    "$ref": "#/definitions/AWS::ApiGateway::Deployment.AccessLogSetting"
                },
                "CacheClusterEnabled": {
                    "type": "boolean"
                },
                "CacheClusterSize": {
                    "type": "string"
                },
                "CacheDataEncrypted": {
                    "type": "boolean"
                },
                "CacheTtlInSeconds": {
                    "type": "number"
                },
                "CachingEnabled": {
                    "type": "boolean"
                },
                "CanarySetting": {
                    "$ref": "#/definitions/AWS::ApiGateway::Deployment.CanarySetting"
                },
                "ClientCertificateId": {
                    "type": "string"
                },
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DocumentationVersion": {
                    "type": "string"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "MethodSettings": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApiGateway::Deployment.MethodSetting"
                    },
                    "type": "array"
                },
                "MetricsEnabled": {
                    "type": "boolean"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                },
                "TracingEnabled": {
                    "type": "boolean"
                },
                "Variables": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::DocumentationPart": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Location": {
                            "$ref": "#/definitions/AWS::ApiGateway::DocumentationPart.Location"
                        },
                        "Properties": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Location",
                        "Properties",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::DocumentationPart"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::DocumentationPart.Location": {
            "additionalProperties": false,
            "properties": {
                "Method": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::DocumentationVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "DocumentationVersion": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DocumentationVersion",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::DocumentationVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::DomainName": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateArn": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "EndpointConfiguration": {
                            "$ref": "#/definitions/AWS::ApiGateway::DomainName.EndpointConfiguration"
                        },
                        "MutualTlsAuthentication": {
                            "$ref": "#/definitions/AWS::ApiGateway::DomainName.MutualTlsAuthentication"
                        },
                        "RegionalCertificateArn": {
                            "type": "string"
                        },
                        "SecurityPolicy": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::DomainName"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::DomainName.EndpointConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Types": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::DomainName.MutualTlsAuthentication": {
            "additionalProperties": false,
            "properties": {
                "TruststoreUri": {
                    "type": "string"
                },
                "TruststoreVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::GatewayResponse": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ResponseParameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "ResponseTemplates": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "ResponseType": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "StatusCode": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ResponseType",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::GatewayResponse"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Method": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiKeyRequired": {
                            "type": "boolean"
                        },
                        "AuthorizationScopes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AuthorizationType": {
                            "type": "string"
                        },
                        "AuthorizerId": {
                            "type": "string"
                        },
                        "HttpMethod": {
                            "type": "string"
                        },
                        "Integration": {
                            "$ref": "#/definitions/AWS::ApiGateway::Method.Integration"
                        },
                        "MethodResponses": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::Method.MethodResponse"
                            },
                            "type": "array"
                        },
                        "OperationName": {
                            "type": "string"
                        },
                        "RequestModels": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "RequestParameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "boolean"
                                }
                            },
                            "type": "object"
                        },
                        "RequestValidatorId": {
                            "type": "string"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "HttpMethod",
                        "ResourceId",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Method"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Method.Integration": {
            "additionalProperties": false,
            "properties": {
                "CacheKeyParameters": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CacheNamespace": {
                    "type": "string"
                },
                "ConnectionId": {
                    "type": "string"
                },
                "ConnectionType": {
                    "type": "string"
                },
                "ContentHandling": {
                    "type": "string"
                },
                "Credentials": {
                    "type": "string"
                },
                "IntegrationHttpMethod": {
                    "type": "string"
                },
                "IntegrationResponses": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApiGateway::Method.IntegrationResponse"
                    },
                    "type": "array"
                },
                "PassthroughBehavior": {
                    "type": "string"
                },
                "RequestParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "RequestTemplates": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "TimeoutInMillis": {
                    "type": "number"
                },
                "Type": {
                    "type": "string"
                },
                "Uri": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Method.IntegrationResponse": {
            "additionalProperties": false,
            "properties": {
                "ContentHandling": {
                    "type": "string"
                },
                "ResponseParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "ResponseTemplates": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "SelectionPattern": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Method.MethodResponse": {
            "additionalProperties": false,
            "properties": {
                "ResponseModels": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "ResponseParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "boolean"
                        }
                    },
                    "type": "object"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Model": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ContentType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "Schema": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Model"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::RequestValidator": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "ValidateRequestBody": {
                            "type": "boolean"
                        },
                        "ValidateRequestParameters": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::RequestValidator"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Resource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ParentId": {
                            "type": "string"
                        },
                        "PathPart": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ParentId",
                        "PathPart",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Resource"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::RestApi": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiKeySourceType": {
                            "type": "string"
                        },
                        "BinaryMediaTypes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Body": {
                            "type": "object"
                        },
                        "BodyS3Location": {
                            "$ref": "#/definitions/AWS::ApiGateway::RestApi.S3Location"
                        },
                        "CloneFrom": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisableExecuteApiEndpoint": {
                            "type": "boolean"
                        },
                        "EndpointConfiguration": {
                            "$ref": "#/definitions/AWS::ApiGateway::RestApi.EndpointConfiguration"
                        },
                        "FailOnWarnings": {
                            "type": "boolean"
                        },
                        "MinimumCompressionSize": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Parameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Policy": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::RestApi"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::RestApi.EndpointConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Types": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "VpcEndpointIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::RestApi.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "ETag": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Stage": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessLogSetting": {
                            "$ref": "#/definitions/AWS::ApiGateway::Stage.AccessLogSetting"
                        },
                        "CacheClusterEnabled": {
                            "type": "boolean"
                        },
                        "CacheClusterSize": {
                            "type": "string"
                        },
                        "CanarySetting": {
                            "$ref": "#/definitions/AWS::ApiGateway::Stage.CanarySetting"
                        },
                        "ClientCertificateId": {
                            "type": "string"
                        },
                        "DeploymentId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DocumentationVersion": {
                            "type": "string"
                        },
                        "MethodSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::Stage.MethodSetting"
                            },
                            "type": "array"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "StageName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TracingEnabled": {
                            "type": "boolean"
                        },
                        "Variables": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Stage"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Stage.AccessLogSetting": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Stage.CanarySetting": {
            "additionalProperties": false,
            "properties": {
                "DeploymentId": {
                    "type": "string"
                },
                "PercentTraffic": {
                    "type": "number"
                },
                "StageVariableOverrides": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "UseStageCache": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Stage.MethodSetting": {
            "additionalProperties": false,
            "properties": {
                "CacheDataEncrypted": {
                    "type": "boolean"
                },
                "CacheTtlInSeconds": {
                    "type": "number"
                },
                "CachingEnabled": {
                    "type": "boolean"
                },
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "HttpMethod": {
                    "type": "string"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "MetricsEnabled": {
                    "type": "boolean"
                },
                "ResourcePath": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiStages": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.ApiStage"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Quota": {
                            "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.QuotaSettings"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Throttle": {
                            "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.ThrottleSettings"
                        },
                        "UsagePlanName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::UsagePlan"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan.ApiStage": {
            "additionalProperties": false,
            "properties": {
                "ApiId": {
                    "type": "string"
                },
                "Stage": {
                    "type": "string"
                },
                "Throttle": {
                    "additionalProperties": false,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.ThrottleSettings"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan.QuotaSettings": {
            "additionalProperties": false,
            "properties": {
                "Limit": {
                    "type": "number"
                },
                "Offset": {
                    "type": "number"
                },
                "Period": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan.ThrottleSettings": {
            "additionalProperties": false,
            "properties": {
                "BurstLimit": {
                    "type": "number"
                },
                "RateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlanKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "KeyId": {
                            "type": "string"
                        },
                        "KeyType": {
                            "type": "string"
                        },
                        "UsagePlanId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "KeyId",
                        "KeyType",
                        "UsagePlanId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::UsagePlanKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::VpcLink": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "TargetArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "TargetArns"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::VpcLink"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Api": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiKeySelectionExpression": {
                            "type": "string"
                        },
                        "BasePath": {
                            "type": "string"
                        },
                        "Body": {
                            "type": "object"
                        },
                        "BodyS3Location": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Api.BodyS3Location"
                        },
                        "CorsConfiguration": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Api.Cors"
                        },
                        "CredentialsArn": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisableExecuteApiEndpoint": {
                            "type": "boolean"
                        },
                        "DisableSchemaValidation": {
                            "type": "boolean"
                        },
                        "FailOnWarnings": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ProtocolType": {
                            "type": "string"
                        },
                        "RouteKey": {
                            "type": "string"
                        },
                        "RouteSelectionExpression": {
                            "type": "string"
                        },
                        "Tags": {
                            "type": "object"
                        },
                        "Target": {
                            "type": "string"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Api"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Api.BodyS3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Etag": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::Api.Cors": {
            "additionalProperties": false,
            "properties": {
                "AllowCredentials": {
                    "type": "boolean"
                },
                "AllowHeaders": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowOrigins": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExposeHeaders": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxAge": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Integration": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::ApiGatewayManagedOverrides.IntegrationOverrides"
                        },
                        "Route": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::ApiGatewayManagedOverrides.RouteOverrides"
                        },
                        "Stage": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::ApiGatewayManagedOverrides.StageOverrides"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides.AccessLogSettings": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides.IntegrationOverrides": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "IntegrationMethod": {
                    "type": "string"
                },
                "PayloadFormatVersion": {
                    "type": "string"
                },
                "TimeoutInMillis": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides.RouteOverrides": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationScopes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AuthorizationType": {
                    "type": "string"
                },
                "AuthorizerId": {
                    "type": "string"
                },
                "OperationName": {
                    "type": "string"
                },
                "Target": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides.RouteSettings": {
            "additionalProperties": false,
            "properties": {
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "DetailedMetricsEnabled": {
                    "type": "boolean"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiGatewayManagedOverrides.StageOverrides": {
            "additionalProperties": false,
            "properties": {
                "AccessLogSettings": {
                    "$ref": "#/definitions/AWS::ApiGatewayV2::ApiGatewayManagedOverrides.AccessLogSettings"
                },
                "AutoDeploy": {
                    "type": "boolean"
                },
                "DefaultRouteSettings": {
                    "$ref": "#/definitions/AWS::ApiGatewayV2::ApiGatewayManagedOverrides.RouteSettings"
                },
                "Description": {
                    "type": "string"
                },
                "RouteSettings": {
                    "type": "object"
                },
                "StageVariables": {
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::ApiMapping": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ApiMappingKey": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "Stage": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "DomainName",
                        "Stage"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::ApiMapping"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Authorizer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "AuthorizerCredentialsArn": {
                            "type": "string"
                        },
                        "AuthorizerPayloadFormatVersion": {
                            "type": "string"
                        },
                        "AuthorizerResultTtlInSeconds": {
                            "type": "number"
                        },
                        "AuthorizerType": {
                            "type": "string"
                        },
                        "AuthorizerUri": {
                            "type": "string"
                        },
                        "EnableSimpleResponses": {
                            "type": "boolean"
                        },
                        "IdentitySource": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "IdentityValidationExpression": {
                            "type": "string"
                        },
                        "JwtConfiguration": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Authorizer.JWTConfiguration"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "AuthorizerType",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Authorizer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Authorizer.JWTConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Audience": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Issuer": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::Deployment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "StageName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Deployment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::DomainName": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DomainName": {
                            "type": "string"
                        },
                        "DomainNameConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGatewayV2::DomainName.DomainNameConfiguration"
                            },
                            "type": "array"
                        },
                        "MutualTlsAuthentication": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::DomainName.MutualTlsAuthentication"
                        },
                        "Tags": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::DomainName"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::DomainName.DomainNameConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                },
                "CertificateName": {
                    "type": "string"
                },
                "EndpointType": {
                    "type": "string"
                },
                "SecurityPolicy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::DomainName.MutualTlsAuthentication": {
            "additionalProperties": false,
            "properties": {
                "TruststoreUri": {
                    "type": "string"
                },
                "TruststoreVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::Integration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ConnectionId": {
                            "type": "string"
                        },
                        "ConnectionType": {
                            "type": "string"
                        },
                        "ContentHandlingStrategy": {
                            "type": "string"
                        },
                        "CredentialsArn": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IntegrationMethod": {
                            "type": "string"
                        },
                        "IntegrationSubtype": {
                            "type": "string"
                        },
                        "IntegrationType": {
                            "type": "string"
                        },
                        "IntegrationUri": {
                            "type": "string"
                        },
                        "PassthroughBehavior": {
                            "type": "string"
                        },
                        "PayloadFormatVersion": {
                            "type": "string"
                        },
                        "RequestParameters": {
                            "type": "object"
                        },
                        "RequestTemplates": {
                            "type": "object"
                        },
                        "ResponseParameters": {
                            "type": "object"
                        },
                        "TemplateSelectionExpression": {
                            "type": "string"
                        },
                        "TimeoutInMillis": {
                            "type": "number"
                        },
                        "TlsConfig": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Integration.TlsConfig"
                        }
                    },
                    "required": [
                        "ApiId",
                        "IntegrationType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Integration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Integration.ResponseParameter": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "type": "string"
                },
                "Source": {
                    "type": "string"
                }
            },
            "required": [
                "Destination",
                "Source"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Integration.ResponseParameterList": {
            "additionalProperties": false,
            "properties": {
                "ResponseParameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApiGatewayV2::Integration.ResponseParameter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::Integration.TlsConfig": {
            "additionalProperties": false,
            "properties": {
                "ServerNameToVerify": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::IntegrationResponse": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ContentHandlingStrategy": {
                            "type": "string"
                        },
                        "IntegrationId": {
                            "type": "string"
                        },
                        "IntegrationResponseKey": {
                            "type": "string"
                        },
                        "ResponseParameters": {
                            "type": "object"
                        },
                        "ResponseTemplates": {
                            "type": "object"
                        },
                        "TemplateSelectionExpression": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "IntegrationId",
                        "IntegrationResponseKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::IntegrationResponse"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Model": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ContentType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Schema": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "ApiId",
                        "Name",
                        "Schema"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Model"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Route": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ApiKeyRequired": {
                            "type": "boolean"
                        },
                        "AuthorizationScopes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AuthorizationType": {
                            "type": "string"
                        },
                        "AuthorizerId": {
                            "type": "string"
                        },
                        "ModelSelectionExpression": {
                            "type": "string"
                        },
                        "OperationName": {
                            "type": "string"
                        },
                        "RequestModels": {
                            "type": "object"
                        },
                        "RequestParameters": {
                            "type": "object"
                        },
                        "RouteKey": {
                            "type": "string"
                        },
                        "RouteResponseSelectionExpression": {
                            "type": "string"
                        },
                        "Target": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "RouteKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Route"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Route.ParameterConstraints": {
            "additionalProperties": false,
            "properties": {
                "Required": {
                    "type": "boolean"
                }
            },
            "required": [
                "Required"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::RouteResponse": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ModelSelectionExpression": {
                            "type": "string"
                        },
                        "ResponseModels": {
                            "type": "object"
                        },
                        "ResponseParameters": {
                            "type": "object"
                        },
                        "RouteId": {
                            "type": "string"
                        },
                        "RouteResponseKey": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "RouteId",
                        "RouteResponseKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::RouteResponse"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::RouteResponse.ParameterConstraints": {
            "additionalProperties": false,
            "properties": {
                "Required": {
                    "type": "boolean"
                }
            },
            "required": [
                "Required"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Stage": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessLogSettings": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Stage.AccessLogSettings"
                        },
                        "AccessPolicyId": {
                            "type": "string"
                        },
                        "ApiId": {
                            "type": "string"
                        },
                        "AutoDeploy": {
                            "type": "boolean"
                        },
                        "ClientCertificateId": {
                            "type": "string"
                        },
                        "DefaultRouteSettings": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Stage.RouteSettings"
                        },
                        "DeploymentId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "RouteSettings": {
                            "type": "object"
                        },
                        "StageName": {
                            "type": "string"
                        },
                        "StageVariables": {
                            "type": "object"
                        },
                        "Tags": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "ApiId",
                        "StageName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Stage"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Stage.AccessLogSettings": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::Stage.RouteSettings": {
            "additionalProperties": false,
            "properties": {
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "DetailedMetricsEnabled": {
                    "type": "boolean"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::VpcLink": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "Name",
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::VpcLink"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppConfig::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::Application.Tags"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppConfig::Application"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppConfig::Application.Tags": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::ConfigurationProfile": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "LocationUri": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RetrievalRoleArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::ConfigurationProfile.Tags"
                            },
                            "type": "array"
                        },
                        "Validators": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::ConfigurationProfile.Validators"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationId",
                        "LocationUri",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppConfig::ConfigurationProfile"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppConfig::ConfigurationProfile.Tags": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::ConfigurationProfile.Validators": {
            "additionalProperties": false,
            "properties": {
                "Content": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::Deployment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationId": {
                            "type": "string"
                        },
                        "ConfigurationProfileId": {
                            "type": "string"
                        },
                        "ConfigurationVersion": {
                            "type": "string"
                        },
                        "DeploymentStrategyId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnvironmentId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::Deployment.Tags"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationId",
                        "ConfigurationProfileId",
                        "ConfigurationVersion",
                        "DeploymentStrategyId",
                        "EnvironmentId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppConfig::Deployment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppConfig::Deployment.Tags": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::DeploymentStrategy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeploymentDurationInMinutes": {
                            "type": "number"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FinalBakeTimeInMinutes": {
                            "type": "number"
                        },
                        "GrowthFactor": {
                            "type": "number"
                        },
                        "GrowthType": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ReplicateTo": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::DeploymentStrategy.Tags"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DeploymentDurationInMinutes",
                        "GrowthFactor",
                        "Name",
                        "ReplicateTo"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppConfig::DeploymentStrategy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppConfig::DeploymentStrategy.Tags": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::Environment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Monitors": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::Environment.Monitors"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppConfig::Environment.Tags"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationId",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppConfig::Environment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppConfig::Environment.Monitors": {
            "additionalProperties": false,
            "properties": {
                "AlarmArn": {
                    "type": "string"
                },
                "AlarmRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::Environment.Tags": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppConfig::HostedConfigurationVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationId": {
                            "type": "string"
                        },
                        "ConfigurationProfileId": {
                            "type": "string"
                        },
                        "Content": {
                            "type": "string"
                        },
                        "ContentType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "LatestVersionNumber": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "ApplicationId",
                        "ConfigurationProfileId",
                        "Content",
                        "ContentType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppConfig::HostedConfigurationVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionMode": {
                            "type": "string"
                        },
                        "ConnectorProfileConfig": {
                            "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorProfileConfig"
                        },
                        "ConnectorProfileName": {
                            "type": "string"
                        },
                        "ConnectorType": {
                            "type": "string"
                        },
                        "KMSArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConnectionMode",
                        "ConnectorProfileName",
                        "ConnectorType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppFlow::ConnectorProfile"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.AmplitudeConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "ApiKey": {
                    "type": "string"
                },
                "SecretKey": {
                    "type": "string"
                }
            },
            "required": [
                "ApiKey",
                "SecretKey"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ConnectorOAuthRequest": {
            "additionalProperties": false,
            "properties": {
                "AuthCode": {
                    "type": "string"
                },
                "RedirectUri": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ConnectorProfileConfig": {
            "additionalProperties": false,
            "properties": {
                "ConnectorProfileCredentials": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorProfileCredentials"
                },
                "ConnectorProfileProperties": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorProfileProperties"
                }
            },
            "required": [
                "ConnectorProfileCredentials"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "Amplitude": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.AmplitudeConnectorProfileCredentials"
                },
                "Datadog": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.DatadogConnectorProfileCredentials"
                },
                "Dynatrace": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.DynatraceConnectorProfileCredentials"
                },
                "GoogleAnalytics": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.GoogleAnalyticsConnectorProfileCredentials"
                },
                "InforNexus": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.InforNexusConnectorProfileCredentials"
                },
                "Marketo": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.MarketoConnectorProfileCredentials"
                },
                "Redshift": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.RedshiftConnectorProfileCredentials"
                },
                "Salesforce": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SalesforceConnectorProfileCredentials"
                },
                "ServiceNow": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ServiceNowConnectorProfileCredentials"
                },
                "Singular": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SingularConnectorProfileCredentials"
                },
                "Slack": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SlackConnectorProfileCredentials"
                },
                "Snowflake": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SnowflakeConnectorProfileCredentials"
                },
                "Trendmicro": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.TrendmicroConnectorProfileCredentials"
                },
                "Veeva": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.VeevaConnectorProfileCredentials"
                },
                "Zendesk": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ZendeskConnectorProfileCredentials"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "Datadog": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.DatadogConnectorProfileProperties"
                },
                "Dynatrace": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.DynatraceConnectorProfileProperties"
                },
                "InforNexus": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.InforNexusConnectorProfileProperties"
                },
                "Marketo": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.MarketoConnectorProfileProperties"
                },
                "Redshift": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.RedshiftConnectorProfileProperties"
                },
                "Salesforce": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SalesforceConnectorProfileProperties"
                },
                "ServiceNow": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ServiceNowConnectorProfileProperties"
                },
                "Slack": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SlackConnectorProfileProperties"
                },
                "Snowflake": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.SnowflakeConnectorProfileProperties"
                },
                "Veeva": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.VeevaConnectorProfileProperties"
                },
                "Zendesk": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ZendeskConnectorProfileProperties"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.DatadogConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "ApiKey": {
                    "type": "string"
                },
                "ApplicationKey": {
                    "type": "string"
                }
            },
            "required": [
                "ApiKey",
                "ApplicationKey"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.DatadogConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.DynatraceConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "ApiToken": {
                    "type": "string"
                }
            },
            "required": [
                "ApiToken"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.DynatraceConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.GoogleAnalyticsConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccessToken": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "ConnectorOAuthRequest": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorOAuthRequest"
                },
                "RefreshToken": {
                    "type": "string"
                }
            },
            "required": [
                "ClientId",
                "ClientSecret"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.InforNexusConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccessKeyId": {
                    "type": "string"
                },
                "Datakey": {
                    "type": "string"
                },
                "SecretAccessKey": {
                    "type": "string"
                },
                "UserId": {
                    "type": "string"
                }
            },
            "required": [
                "AccessKeyId",
                "Datakey",
                "SecretAccessKey",
                "UserId"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.InforNexusConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.MarketoConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccessToken": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "ConnectorOAuthRequest": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorOAuthRequest"
                }
            },
            "required": [
                "ClientId",
                "ClientSecret"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.MarketoConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.RedshiftConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.RedshiftConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                },
                "DatabaseUrl": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "BucketName",
                "DatabaseUrl",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SalesforceConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccessToken": {
                    "type": "string"
                },
                "ClientCredentialsArn": {
                    "type": "string"
                },
                "ConnectorOAuthRequest": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorOAuthRequest"
                },
                "RefreshToken": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SalesforceConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                },
                "isSandboxEnvironment": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ServiceNowConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ServiceNowConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SingularConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "ApiKey": {
                    "type": "string"
                }
            },
            "required": [
                "ApiKey"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SlackConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccessToken": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "ConnectorOAuthRequest": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorOAuthRequest"
                }
            },
            "required": [
                "ClientId",
                "ClientSecret"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SlackConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SnowflakeConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.SnowflakeConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "AccountName": {
                    "type": "string"
                },
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                },
                "PrivateLinkServiceName": {
                    "type": "string"
                },
                "Region": {
                    "type": "string"
                },
                "Stage": {
                    "type": "string"
                },
                "Warehouse": {
                    "type": "string"
                }
            },
            "required": [
                "BucketName",
                "Stage",
                "Warehouse"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.TrendmicroConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "ApiSecretKey": {
                    "type": "string"
                }
            },
            "required": [
                "ApiSecretKey"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.VeevaConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.VeevaConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ZendeskConnectorProfileCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccessToken": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "ConnectorOAuthRequest": {
                    "$ref": "#/definitions/AWS::AppFlow::ConnectorProfile.ConnectorOAuthRequest"
                }
            },
            "required": [
                "ClientId",
                "ClientSecret"
            ],
            "type": "object"
        },
        "AWS::AppFlow::ConnectorProfile.ZendeskConnectorProfileProperties": {
            "additionalProperties": false,
            "properties": {
                "InstanceUrl": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceUrl"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "DestinationFlowConfigList": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppFlow::Flow.DestinationFlowConfig"
                            },
                            "type": "array"
                        },
                        "FlowName": {
                            "type": "string"
                        },
                        "KMSArn": {
                            "type": "string"
                        },
                        "SourceFlowConfig": {
                            "$ref": "#/definitions/AWS::AppFlow::Flow.SourceFlowConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Tasks": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppFlow::Flow.Task"
                            },
                            "type": "array"
                        },
                        "TriggerConfig": {
                            "$ref": "#/definitions/AWS::AppFlow::Flow.TriggerConfig"
                        }
                    },
                    "required": [
                        "DestinationFlowConfigList",
                        "FlowName",
                        "SourceFlowConfig",
                        "Tasks",
                        "TriggerConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppFlow::Flow"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.AggregationConfig": {
            "additionalProperties": false,
            "properties": {
                "AggregationType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.AmplitudeSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.ConnectorOperator": {
            "additionalProperties": false,
            "properties": {
                "Amplitude": {
                    "type": "string"
                },
                "Datadog": {
                    "type": "string"
                },
                "Dynatrace": {
                    "type": "string"
                },
                "GoogleAnalytics": {
                    "type": "string"
                },
                "InforNexus": {
                    "type": "string"
                },
                "Marketo": {
                    "type": "string"
                },
                "S3": {
                    "type": "string"
                },
                "Salesforce": {
                    "type": "string"
                },
                "ServiceNow": {
                    "type": "string"
                },
                "Singular": {
                    "type": "string"
                },
                "Slack": {
                    "type": "string"
                },
                "Trendmicro": {
                    "type": "string"
                },
                "Veeva": {
                    "type": "string"
                },
                "Zendesk": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.DatadogSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.DestinationConnectorProperties": {
            "additionalProperties": false,
            "properties": {
                "EventBridge": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.EventBridgeDestinationProperties"
                },
                "LookoutMetrics": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.LookoutMetricsDestinationProperties"
                },
                "Redshift": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.RedshiftDestinationProperties"
                },
                "S3": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.S3DestinationProperties"
                },
                "Salesforce": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.SalesforceDestinationProperties"
                },
                "Snowflake": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.SnowflakeDestinationProperties"
                },
                "Upsolver": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.UpsolverDestinationProperties"
                },
                "Zendesk": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ZendeskDestinationProperties"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.DestinationFlowConfig": {
            "additionalProperties": false,
            "properties": {
                "ConnectorProfileName": {
                    "type": "string"
                },
                "ConnectorType": {
                    "type": "string"
                },
                "DestinationConnectorProperties": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.DestinationConnectorProperties"
                }
            },
            "required": [
                "ConnectorType",
                "DestinationConnectorProperties"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.DynatraceSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.ErrorHandlingConfig": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                },
                "FailOnFirstError": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.EventBridgeDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "ErrorHandlingConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ErrorHandlingConfig"
                },
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.GoogleAnalyticsSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.IncrementalPullConfig": {
            "additionalProperties": false,
            "properties": {
                "DatetimeTypeFieldName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.InforNexusSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.LookoutMetricsDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.MarketoSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.PrefixConfig": {
            "additionalProperties": false,
            "properties": {
                "PrefixFormat": {
                    "type": "string"
                },
                "PrefixType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.RedshiftDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketPrefix": {
                    "type": "string"
                },
                "ErrorHandlingConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ErrorHandlingConfig"
                },
                "IntermediateBucketName": {
                    "type": "string"
                },
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "IntermediateBucketName",
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.S3DestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                },
                "S3OutputFormatConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.S3OutputFormatConfig"
                }
            },
            "required": [
                "BucketName"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.S3OutputFormatConfig": {
            "additionalProperties": false,
            "properties": {
                "AggregationConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.AggregationConfig"
                },
                "FileType": {
                    "type": "string"
                },
                "PrefixConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.PrefixConfig"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.S3SourceProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                }
            },
            "required": [
                "BucketName",
                "BucketPrefix"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.SalesforceDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "ErrorHandlingConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ErrorHandlingConfig"
                },
                "IdFieldNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Object": {
                    "type": "string"
                },
                "WriteOperationType": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.SalesforceSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "EnableDynamicFieldUpdate": {
                    "type": "boolean"
                },
                "IncludeDeletedRecords": {
                    "type": "boolean"
                },
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.ScheduledTriggerProperties": {
            "additionalProperties": false,
            "properties": {
                "DataPullMode": {
                    "type": "string"
                },
                "ScheduleEndTime": {
                    "type": "number"
                },
                "ScheduleExpression": {
                    "type": "string"
                },
                "ScheduleStartTime": {
                    "type": "number"
                },
                "TimeZone": {
                    "type": "string"
                }
            },
            "required": [
                "ScheduleExpression"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.ServiceNowSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.SingularSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.SlackSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.SnowflakeDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketPrefix": {
                    "type": "string"
                },
                "ErrorHandlingConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ErrorHandlingConfig"
                },
                "IntermediateBucketName": {
                    "type": "string"
                },
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "IntermediateBucketName",
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.SourceConnectorProperties": {
            "additionalProperties": false,
            "properties": {
                "Amplitude": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.AmplitudeSourceProperties"
                },
                "Datadog": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.DatadogSourceProperties"
                },
                "Dynatrace": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.DynatraceSourceProperties"
                },
                "GoogleAnalytics": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.GoogleAnalyticsSourceProperties"
                },
                "InforNexus": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.InforNexusSourceProperties"
                },
                "Marketo": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.MarketoSourceProperties"
                },
                "S3": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.S3SourceProperties"
                },
                "Salesforce": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.SalesforceSourceProperties"
                },
                "ServiceNow": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ServiceNowSourceProperties"
                },
                "Singular": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.SingularSourceProperties"
                },
                "Slack": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.SlackSourceProperties"
                },
                "Trendmicro": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.TrendmicroSourceProperties"
                },
                "Veeva": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.VeevaSourceProperties"
                },
                "Zendesk": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ZendeskSourceProperties"
                }
            },
            "type": "object"
        },
        "AWS::AppFlow::Flow.SourceFlowConfig": {
            "additionalProperties": false,
            "properties": {
                "ConnectorProfileName": {
                    "type": "string"
                },
                "ConnectorType": {
                    "type": "string"
                },
                "IncrementalPullConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.IncrementalPullConfig"
                },
                "SourceConnectorProperties": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.SourceConnectorProperties"
                }
            },
            "required": [
                "ConnectorType",
                "SourceConnectorProperties"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.Task": {
            "additionalProperties": false,
            "properties": {
                "ConnectorOperator": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ConnectorOperator"
                },
                "DestinationField": {
                    "type": "string"
                },
                "SourceFields": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TaskProperties": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppFlow::Flow.TaskPropertiesObject"
                    },
                    "type": "array"
                },
                "TaskType": {
                    "type": "string"
                }
            },
            "required": [
                "SourceFields",
                "TaskType"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.TaskPropertiesObject": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.TrendmicroSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.TriggerConfig": {
            "additionalProperties": false,
            "properties": {
                "TriggerProperties": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ScheduledTriggerProperties"
                },
                "TriggerType": {
                    "type": "string"
                }
            },
            "required": [
                "TriggerType"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.UpsolverDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                },
                "S3OutputFormatConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.UpsolverS3OutputFormatConfig"
                }
            },
            "required": [
                "BucketName",
                "S3OutputFormatConfig"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.UpsolverS3OutputFormatConfig": {
            "additionalProperties": false,
            "properties": {
                "AggregationConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.AggregationConfig"
                },
                "FileType": {
                    "type": "string"
                },
                "PrefixConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.PrefixConfig"
                }
            },
            "required": [
                "PrefixConfig"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.VeevaSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.ZendeskDestinationProperties": {
            "additionalProperties": false,
            "properties": {
                "ErrorHandlingConfig": {
                    "$ref": "#/definitions/AWS::AppFlow::Flow.ErrorHandlingConfig"
                },
                "IdFieldNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Object": {
                    "type": "string"
                },
                "WriteOperationType": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppFlow::Flow.ZendeskSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::AppIntegrations::EventIntegration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "EventBridgeBus": {
                            "type": "string"
                        },
                        "EventFilter": {
                            "$ref": "#/definitions/AWS::AppIntegrations::EventIntegration.EventFilter"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "EventBridgeBus",
                        "EventFilter",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppIntegrations::EventIntegration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppIntegrations::EventIntegration.EventFilter": {
            "additionalProperties": false,
            "properties": {
                "Source": {
                    "type": "string"
                }
            },
            "required": [
                "Source"
            ],
            "type": "object"
        },
        "AWS::AppIntegrations::EventIntegration.EventIntegrationAssociation": {
            "additionalProperties": false,
            "properties": {
                "ClientAssociationMetadata": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppIntegrations::EventIntegration.Metadata"
                    },
                    "type": "array"
                },
                "ClientId": {
                    "type": "string"
                },
                "EventBridgeRuleName": {
                    "type": "string"
                },
                "EventIntegrationAssociationArn": {
                    "type": "string"
                },
                "EventIntegrationAssociationId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppIntegrations::EventIntegration.Metadata": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GatewayRouteName": {
                            "type": "string"
                        },
                        "MeshName": {
                            "type": "string"
                        },
                        "MeshOwner": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GatewayRouteSpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VirtualGatewayName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MeshName",
                        "Spec",
                        "VirtualGatewayName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::GatewayRoute"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.GatewayRouteSpec": {
            "additionalProperties": false,
            "properties": {
                "GrpcRoute": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GrpcGatewayRoute"
                },
                "Http2Route": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.HttpGatewayRoute"
                },
                "HttpRoute": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.HttpGatewayRoute"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.GatewayRouteTarget": {
            "additionalProperties": false,
            "properties": {
                "VirtualService": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GatewayRouteVirtualService"
                }
            },
            "required": [
                "VirtualService"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.GatewayRouteVirtualService": {
            "additionalProperties": false,
            "properties": {
                "VirtualServiceName": {
                    "type": "string"
                }
            },
            "required": [
                "VirtualServiceName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.GrpcGatewayRoute": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GrpcGatewayRouteAction"
                },
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GrpcGatewayRouteMatch"
                }
            },
            "required": [
                "Action",
                "Match"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.GrpcGatewayRouteAction": {
            "additionalProperties": false,
            "properties": {
                "Target": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GatewayRouteTarget"
                }
            },
            "required": [
                "Target"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.GrpcGatewayRouteMatch": {
            "additionalProperties": false,
            "properties": {
                "ServiceName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.HttpGatewayRoute": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.HttpGatewayRouteAction"
                },
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.HttpGatewayRouteMatch"
                }
            },
            "required": [
                "Action",
                "Match"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.HttpGatewayRouteAction": {
            "additionalProperties": false,
            "properties": {
                "Target": {
                    "$ref": "#/definitions/AWS::AppMesh::GatewayRoute.GatewayRouteTarget"
                }
            },
            "required": [
                "Target"
            ],
            "type": "object"
        },
        "AWS::AppMesh::GatewayRoute.HttpGatewayRouteMatch": {
            "additionalProperties": false,
            "properties": {
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Prefix"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Mesh": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MeshName": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::Mesh.MeshSpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::Mesh"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Mesh.EgressFilter": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Mesh.MeshSpec": {
            "additionalProperties": false,
            "properties": {
                "EgressFilter": {
                    "$ref": "#/definitions/AWS::AppMesh::Mesh.EgressFilter"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MeshName": {
                            "type": "string"
                        },
                        "MeshOwner": {
                            "type": "string"
                        },
                        "RouteName": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::Route.RouteSpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VirtualRouterName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MeshName",
                        "Spec",
                        "VirtualRouterName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::Route"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.Duration": {
            "additionalProperties": false,
            "properties": {
                "Unit": {
                    "type": "string"
                },
                "Value": {
                    "type": "number"
                }
            },
            "required": [
                "Unit",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcRetryPolicy": {
            "additionalProperties": false,
            "properties": {
                "GrpcRetryEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "HttpRetryEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxRetries": {
                    "type": "number"
                },
                "PerRetryTimeout": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                },
                "TcpRetryEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MaxRetries",
                "PerRetryTimeout"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcRoute": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.GrpcRouteAction"
                },
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.GrpcRouteMatch"
                },
                "RetryPolicy": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.GrpcRetryPolicy"
                },
                "Timeout": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.GrpcTimeout"
                }
            },
            "required": [
                "Action",
                "Match"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcRouteAction": {
            "additionalProperties": false,
            "properties": {
                "WeightedTargets": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::Route.WeightedTarget"
                    },
                    "type": "array"
                }
            },
            "required": [
                "WeightedTargets"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcRouteMatch": {
            "additionalProperties": false,
            "properties": {
                "Metadata": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::Route.GrpcRouteMetadata"
                    },
                    "type": "array"
                },
                "MethodName": {
                    "type": "string"
                },
                "ServiceName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcRouteMetadata": {
            "additionalProperties": false,
            "properties": {
                "Invert": {
                    "type": "boolean"
                },
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.GrpcRouteMetadataMatchMethod"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcRouteMetadataMatchMethod": {
            "additionalProperties": false,
            "properties": {
                "Exact": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "Range": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.MatchRange"
                },
                "Regex": {
                    "type": "string"
                },
                "Suffix": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.GrpcTimeout": {
            "additionalProperties": false,
            "properties": {
                "Idle": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                },
                "PerRequest": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.HeaderMatchMethod": {
            "additionalProperties": false,
            "properties": {
                "Exact": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "Range": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.MatchRange"
                },
                "Regex": {
                    "type": "string"
                },
                "Suffix": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.HttpRetryPolicy": {
            "additionalProperties": false,
            "properties": {
                "HttpRetryEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxRetries": {
                    "type": "number"
                },
                "PerRetryTimeout": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                },
                "TcpRetryEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MaxRetries",
                "PerRetryTimeout"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.HttpRoute": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HttpRouteAction"
                },
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HttpRouteMatch"
                },
                "RetryPolicy": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HttpRetryPolicy"
                },
                "Timeout": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HttpTimeout"
                }
            },
            "required": [
                "Action",
                "Match"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.HttpRouteAction": {
            "additionalProperties": false,
            "properties": {
                "WeightedTargets": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::Route.WeightedTarget"
                    },
                    "type": "array"
                }
            },
            "required": [
                "WeightedTargets"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.HttpRouteHeader": {
            "additionalProperties": false,
            "properties": {
                "Invert": {
                    "type": "boolean"
                },
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HeaderMatchMethod"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.HttpRouteMatch": {
            "additionalProperties": false,
            "properties": {
                "Headers": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::Route.HttpRouteHeader"
                    },
                    "type": "array"
                },
                "Method": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "Scheme": {
                    "type": "string"
                }
            },
            "required": [
                "Prefix"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.HttpTimeout": {
            "additionalProperties": false,
            "properties": {
                "Idle": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                },
                "PerRequest": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.MatchRange": {
            "additionalProperties": false,
            "properties": {
                "End": {
                    "type": "number"
                },
                "Start": {
                    "type": "number"
                }
            },
            "required": [
                "End",
                "Start"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.RouteSpec": {
            "additionalProperties": false,
            "properties": {
                "GrpcRoute": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.GrpcRoute"
                },
                "Http2Route": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HttpRoute"
                },
                "HttpRoute": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.HttpRoute"
                },
                "Priority": {
                    "type": "number"
                },
                "TcpRoute": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.TcpRoute"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.TcpRoute": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.TcpRouteAction"
                },
                "Timeout": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.TcpTimeout"
                }
            },
            "required": [
                "Action"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.TcpRouteAction": {
            "additionalProperties": false,
            "properties": {
                "WeightedTargets": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::Route.WeightedTarget"
                    },
                    "type": "array"
                }
            },
            "required": [
                "WeightedTargets"
            ],
            "type": "object"
        },
        "AWS::AppMesh::Route.TcpTimeout": {
            "additionalProperties": false,
            "properties": {
                "Idle": {
                    "$ref": "#/definitions/AWS::AppMesh::Route.Duration"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::Route.WeightedTarget": {
            "additionalProperties": false,
            "properties": {
                "VirtualNode": {
                    "type": "string"
                },
                "Weight": {
                    "type": "number"
                }
            },
            "required": [
                "VirtualNode",
                "Weight"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MeshName": {
                            "type": "string"
                        },
                        "MeshOwner": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewaySpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VirtualGatewayName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MeshName",
                        "Spec"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::VirtualGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.SubjectAlternativeNameMatchers": {
            "additionalProperties": false,
            "properties": {
                "Exact": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.SubjectAlternativeNames": {
            "additionalProperties": false,
            "properties": {
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.SubjectAlternativeNameMatchers"
                }
            },
            "required": [
                "Match"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayAccessLog": {
            "additionalProperties": false,
            "properties": {
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayFileAccessLog"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayBackendDefaults": {
            "additionalProperties": false,
            "properties": {
                "ClientPolicy": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayClientPolicy"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayClientPolicy": {
            "additionalProperties": false,
            "properties": {
                "TLS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayClientPolicyTls"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayClientPolicyTls": {
            "additionalProperties": false,
            "properties": {
                "Certificate": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayClientTlsCertificate"
                },
                "Enforce": {
                    "type": "boolean"
                },
                "Ports": {
                    "items": {
                        "type": "number"
                    },
                    "type": "array"
                },
                "Validation": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContext"
                }
            },
            "required": [
                "Validation"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayClientTlsCertificate": {
            "additionalProperties": false,
            "properties": {
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsFileCertificate"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsSdsCertificate"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "GRPC": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayGrpcConnectionPool"
                },
                "HTTP": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayHttpConnectionPool"
                },
                "HTTP2": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayHttp2ConnectionPool"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayFileAccessLog": {
            "additionalProperties": false,
            "properties": {
                "Path": {
                    "type": "string"
                }
            },
            "required": [
                "Path"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayGrpcConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxRequests": {
                    "type": "number"
                }
            },
            "required": [
                "MaxRequests"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayHealthCheckPolicy": {
            "additionalProperties": false,
            "properties": {
                "HealthyThreshold": {
                    "type": "number"
                },
                "IntervalMillis": {
                    "type": "number"
                },
                "Path": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                },
                "TimeoutMillis": {
                    "type": "number"
                },
                "UnhealthyThreshold": {
                    "type": "number"
                }
            },
            "required": [
                "HealthyThreshold",
                "IntervalMillis",
                "Protocol",
                "TimeoutMillis",
                "UnhealthyThreshold"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayHttp2ConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxRequests": {
                    "type": "number"
                }
            },
            "required": [
                "MaxRequests"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayHttpConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxConnections": {
                    "type": "number"
                },
                "MaxPendingRequests": {
                    "type": "number"
                }
            },
            "required": [
                "MaxConnections"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListener": {
            "additionalProperties": false,
            "properties": {
                "ConnectionPool": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayConnectionPool"
                },
                "HealthCheck": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayHealthCheckPolicy"
                },
                "PortMapping": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayPortMapping"
                },
                "TLS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTls"
                }
            },
            "required": [
                "PortMapping"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTls": {
            "additionalProperties": false,
            "properties": {
                "Certificate": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsCertificate"
                },
                "Mode": {
                    "type": "string"
                },
                "Validation": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsValidationContext"
                }
            },
            "required": [
                "Certificate",
                "Mode"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsAcmCertificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "required": [
                "CertificateArn"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsCertificate": {
            "additionalProperties": false,
            "properties": {
                "ACM": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsAcmCertificate"
                },
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsFileCertificate"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsSdsCertificate"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsFileCertificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateChain": {
                    "type": "string"
                },
                "PrivateKey": {
                    "type": "string"
                }
            },
            "required": [
                "CertificateChain",
                "PrivateKey"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsSdsCertificate": {
            "additionalProperties": false,
            "properties": {
                "SecretName": {
                    "type": "string"
                }
            },
            "required": [
                "SecretName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsValidationContext": {
            "additionalProperties": false,
            "properties": {
                "SubjectAlternativeNames": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.SubjectAlternativeNames"
                },
                "Trust": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsValidationContextTrust"
                }
            },
            "required": [
                "Trust"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayListenerTlsValidationContextTrust": {
            "additionalProperties": false,
            "properties": {
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextFileTrust"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextSdsTrust"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayLogging": {
            "additionalProperties": false,
            "properties": {
                "AccessLog": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayAccessLog"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayPortMapping": {
            "additionalProperties": false,
            "properties": {
                "Port": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                }
            },
            "required": [
                "Port",
                "Protocol"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewaySpec": {
            "additionalProperties": false,
            "properties": {
                "BackendDefaults": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayBackendDefaults"
                },
                "Listeners": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayListener"
                    },
                    "type": "array"
                },
                "Logging": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayLogging"
                }
            },
            "required": [
                "Listeners"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContext": {
            "additionalProperties": false,
            "properties": {
                "SubjectAlternativeNames": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.SubjectAlternativeNames"
                },
                "Trust": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextTrust"
                }
            },
            "required": [
                "Trust"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextAcmTrust": {
            "additionalProperties": false,
            "properties": {
                "CertificateAuthorityArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CertificateAuthorityArns"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextFileTrust": {
            "additionalProperties": false,
            "properties": {
                "CertificateChain": {
                    "type": "string"
                }
            },
            "required": [
                "CertificateChain"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextSdsTrust": {
            "additionalProperties": false,
            "properties": {
                "SecretName": {
                    "type": "string"
                }
            },
            "required": [
                "SecretName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextTrust": {
            "additionalProperties": false,
            "properties": {
                "ACM": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextAcmTrust"
                },
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextFileTrust"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualGateway.VirtualGatewayTlsValidationContextSdsTrust"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MeshName": {
                            "type": "string"
                        },
                        "MeshOwner": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualNodeSpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VirtualNodeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MeshName",
                        "Spec"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::VirtualNode"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.AccessLog": {
            "additionalProperties": false,
            "properties": {
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.FileAccessLog"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.AwsCloudMapInstanceAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.AwsCloudMapServiceDiscovery": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::VirtualNode.AwsCloudMapInstanceAttribute"
                    },
                    "type": "array"
                },
                "NamespaceName": {
                    "type": "string"
                },
                "ServiceName": {
                    "type": "string"
                }
            },
            "required": [
                "NamespaceName",
                "ServiceName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.Backend": {
            "additionalProperties": false,
            "properties": {
                "VirtualService": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualServiceBackend"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.BackendDefaults": {
            "additionalProperties": false,
            "properties": {
                "ClientPolicy": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ClientPolicy"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ClientPolicy": {
            "additionalProperties": false,
            "properties": {
                "TLS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ClientPolicyTls"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ClientPolicyTls": {
            "additionalProperties": false,
            "properties": {
                "Certificate": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ClientTlsCertificate"
                },
                "Enforce": {
                    "type": "boolean"
                },
                "Ports": {
                    "items": {
                        "type": "number"
                    },
                    "type": "array"
                },
                "Validation": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContext"
                }
            },
            "required": [
                "Validation"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ClientTlsCertificate": {
            "additionalProperties": false,
            "properties": {
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsFileCertificate"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsSdsCertificate"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.DnsServiceDiscovery": {
            "additionalProperties": false,
            "properties": {
                "Hostname": {
                    "type": "string"
                }
            },
            "required": [
                "Hostname"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.Duration": {
            "additionalProperties": false,
            "properties": {
                "Unit": {
                    "type": "string"
                },
                "Value": {
                    "type": "number"
                }
            },
            "required": [
                "Unit",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.FileAccessLog": {
            "additionalProperties": false,
            "properties": {
                "Path": {
                    "type": "string"
                }
            },
            "required": [
                "Path"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.GrpcTimeout": {
            "additionalProperties": false,
            "properties": {
                "Idle": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                },
                "PerRequest": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.HealthCheck": {
            "additionalProperties": false,
            "properties": {
                "HealthyThreshold": {
                    "type": "number"
                },
                "IntervalMillis": {
                    "type": "number"
                },
                "Path": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                },
                "TimeoutMillis": {
                    "type": "number"
                },
                "UnhealthyThreshold": {
                    "type": "number"
                }
            },
            "required": [
                "HealthyThreshold",
                "IntervalMillis",
                "Protocol",
                "TimeoutMillis",
                "UnhealthyThreshold"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.HttpTimeout": {
            "additionalProperties": false,
            "properties": {
                "Idle": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                },
                "PerRequest": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.Listener": {
            "additionalProperties": false,
            "properties": {
                "ConnectionPool": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualNodeConnectionPool"
                },
                "HealthCheck": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.HealthCheck"
                },
                "OutlierDetection": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.OutlierDetection"
                },
                "PortMapping": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.PortMapping"
                },
                "TLS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTls"
                },
                "Timeout": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTimeout"
                }
            },
            "required": [
                "PortMapping"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTimeout": {
            "additionalProperties": false,
            "properties": {
                "GRPC": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.GrpcTimeout"
                },
                "HTTP": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.HttpTimeout"
                },
                "HTTP2": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.HttpTimeout"
                },
                "TCP": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TcpTimeout"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTls": {
            "additionalProperties": false,
            "properties": {
                "Certificate": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsCertificate"
                },
                "Mode": {
                    "type": "string"
                },
                "Validation": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsValidationContext"
                }
            },
            "required": [
                "Certificate",
                "Mode"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTlsAcmCertificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "required": [
                "CertificateArn"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTlsCertificate": {
            "additionalProperties": false,
            "properties": {
                "ACM": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsAcmCertificate"
                },
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsFileCertificate"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsSdsCertificate"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTlsFileCertificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateChain": {
                    "type": "string"
                },
                "PrivateKey": {
                    "type": "string"
                }
            },
            "required": [
                "CertificateChain",
                "PrivateKey"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTlsSdsCertificate": {
            "additionalProperties": false,
            "properties": {
                "SecretName": {
                    "type": "string"
                }
            },
            "required": [
                "SecretName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTlsValidationContext": {
            "additionalProperties": false,
            "properties": {
                "SubjectAlternativeNames": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.SubjectAlternativeNames"
                },
                "Trust": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ListenerTlsValidationContextTrust"
                }
            },
            "required": [
                "Trust"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ListenerTlsValidationContextTrust": {
            "additionalProperties": false,
            "properties": {
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContextFileTrust"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContextSdsTrust"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.Logging": {
            "additionalProperties": false,
            "properties": {
                "AccessLog": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.AccessLog"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.OutlierDetection": {
            "additionalProperties": false,
            "properties": {
                "BaseEjectionDuration": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                },
                "Interval": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                },
                "MaxEjectionPercent": {
                    "type": "number"
                },
                "MaxServerErrors": {
                    "type": "number"
                }
            },
            "required": [
                "BaseEjectionDuration",
                "Interval",
                "MaxEjectionPercent",
                "MaxServerErrors"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.PortMapping": {
            "additionalProperties": false,
            "properties": {
                "Port": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                }
            },
            "required": [
                "Port",
                "Protocol"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.ServiceDiscovery": {
            "additionalProperties": false,
            "properties": {
                "AWSCloudMap": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.AwsCloudMapServiceDiscovery"
                },
                "DNS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.DnsServiceDiscovery"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.SubjectAlternativeNameMatchers": {
            "additionalProperties": false,
            "properties": {
                "Exact": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.SubjectAlternativeNames": {
            "additionalProperties": false,
            "properties": {
                "Match": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.SubjectAlternativeNameMatchers"
                }
            },
            "required": [
                "Match"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.TcpTimeout": {
            "additionalProperties": false,
            "properties": {
                "Idle": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Duration"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.TlsValidationContext": {
            "additionalProperties": false,
            "properties": {
                "SubjectAlternativeNames": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.SubjectAlternativeNames"
                },
                "Trust": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContextTrust"
                }
            },
            "required": [
                "Trust"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.TlsValidationContextAcmTrust": {
            "additionalProperties": false,
            "properties": {
                "CertificateAuthorityArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CertificateAuthorityArns"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.TlsValidationContextFileTrust": {
            "additionalProperties": false,
            "properties": {
                "CertificateChain": {
                    "type": "string"
                }
            },
            "required": [
                "CertificateChain"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.TlsValidationContextSdsTrust": {
            "additionalProperties": false,
            "properties": {
                "SecretName": {
                    "type": "string"
                }
            },
            "required": [
                "SecretName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.TlsValidationContextTrust": {
            "additionalProperties": false,
            "properties": {
                "ACM": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContextAcmTrust"
                },
                "File": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContextFileTrust"
                },
                "SDS": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.TlsValidationContextSdsTrust"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualNodeConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "GRPC": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualNodeGrpcConnectionPool"
                },
                "HTTP": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualNodeHttpConnectionPool"
                },
                "HTTP2": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualNodeHttp2ConnectionPool"
                },
                "TCP": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.VirtualNodeTcpConnectionPool"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualNodeGrpcConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxRequests": {
                    "type": "number"
                }
            },
            "required": [
                "MaxRequests"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualNodeHttp2ConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxRequests": {
                    "type": "number"
                }
            },
            "required": [
                "MaxRequests"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualNodeHttpConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxConnections": {
                    "type": "number"
                },
                "MaxPendingRequests": {
                    "type": "number"
                }
            },
            "required": [
                "MaxConnections"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualNodeSpec": {
            "additionalProperties": false,
            "properties": {
                "BackendDefaults": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.BackendDefaults"
                },
                "Backends": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Backend"
                    },
                    "type": "array"
                },
                "Listeners": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Listener"
                    },
                    "type": "array"
                },
                "Logging": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.Logging"
                },
                "ServiceDiscovery": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ServiceDiscovery"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualNodeTcpConnectionPool": {
            "additionalProperties": false,
            "properties": {
                "MaxConnections": {
                    "type": "number"
                }
            },
            "required": [
                "MaxConnections"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualNode.VirtualServiceBackend": {
            "additionalProperties": false,
            "properties": {
                "ClientPolicy": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualNode.ClientPolicy"
                },
                "VirtualServiceName": {
                    "type": "string"
                }
            },
            "required": [
                "VirtualServiceName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualRouter": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MeshName": {
                            "type": "string"
                        },
                        "MeshOwner": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::VirtualRouter.VirtualRouterSpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VirtualRouterName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MeshName",
                        "Spec"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::VirtualRouter"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualRouter.PortMapping": {
            "additionalProperties": false,
            "properties": {
                "Port": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                }
            },
            "required": [
                "Port",
                "Protocol"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualRouter.VirtualRouterListener": {
            "additionalProperties": false,
            "properties": {
                "PortMapping": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualRouter.PortMapping"
                }
            },
            "required": [
                "PortMapping"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualRouter.VirtualRouterSpec": {
            "additionalProperties": false,
            "properties": {
                "Listeners": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppMesh::VirtualRouter.VirtualRouterListener"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Listeners"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualService": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MeshName": {
                            "type": "string"
                        },
                        "MeshOwner": {
                            "type": "string"
                        },
                        "Spec": {
                            "$ref": "#/definitions/AWS::AppMesh::VirtualService.VirtualServiceSpec"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VirtualServiceName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MeshName",
                        "Spec",
                        "VirtualServiceName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppMesh::VirtualService"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualService.VirtualNodeServiceProvider": {
            "additionalProperties": false,
            "properties": {
                "VirtualNodeName": {
                    "type": "string"
                }
            },
            "required": [
                "VirtualNodeName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualService.VirtualRouterServiceProvider": {
            "additionalProperties": false,
            "properties": {
                "VirtualRouterName": {
                    "type": "string"
                }
            },
            "required": [
                "VirtualRouterName"
            ],
            "type": "object"
        },
        "AWS::AppMesh::VirtualService.VirtualServiceProvider": {
            "additionalProperties": false,
            "properties": {
                "VirtualNode": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualService.VirtualNodeServiceProvider"
                },
                "VirtualRouter": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualService.VirtualRouterServiceProvider"
                }
            },
            "type": "object"
        },
        "AWS::AppMesh::VirtualService.VirtualServiceSpec": {
            "additionalProperties": false,
            "properties": {
                "Provider": {
                    "$ref": "#/definitions/AWS::AppMesh::VirtualService.VirtualServiceProvider"
                }
            },
            "type": "object"
        },
        "AWS::AppRunner::Service": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingConfigurationArn": {
                            "type": "string"
                        },
                        "EncryptionConfiguration": {
                            "$ref": "#/definitions/AWS::AppRunner::Service.EncryptionConfiguration"
                        },
                        "HealthCheckConfiguration": {
                            "$ref": "#/definitions/AWS::AppRunner::Service.HealthCheckConfiguration"
                        },
                        "InstanceConfiguration": {
                            "$ref": "#/definitions/AWS::AppRunner::Service.InstanceConfiguration"
                        },
                        "ServiceName": {
                            "type": "string"
                        },
                        "SourceConfiguration": {
                            "$ref": "#/definitions/AWS::AppRunner::Service.SourceConfiguration"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SourceConfiguration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppRunner::Service"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.AuthenticationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AccessRoleArn": {
                    "type": "string"
                },
                "ConnectionArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppRunner::Service.CodeConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CodeConfigurationValues": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.CodeConfigurationValues"
                },
                "ConfigurationSource": {
                    "type": "string"
                }
            },
            "required": [
                "ConfigurationSource"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.CodeConfigurationValues": {
            "additionalProperties": false,
            "properties": {
                "BuildCommand": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                },
                "Runtime": {
                    "type": "string"
                },
                "RuntimeEnvironmentVariables": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppRunner::Service.KeyValuePair"
                    },
                    "type": "array"
                },
                "StartCommand": {
                    "type": "string"
                }
            },
            "required": [
                "Runtime"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.CodeRepository": {
            "additionalProperties": false,
            "properties": {
                "CodeConfiguration": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.CodeConfiguration"
                },
                "RepositoryUrl": {
                    "type": "string"
                },
                "SourceCodeVersion": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.SourceCodeVersion"
                }
            },
            "required": [
                "RepositoryUrl",
                "SourceCodeVersion"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "KmsKey": {
                    "type": "string"
                }
            },
            "required": [
                "KmsKey"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.HealthCheckConfiguration": {
            "additionalProperties": false,
            "properties": {
                "HealthyThreshold": {
                    "type": "number"
                },
                "Interval": {
                    "type": "number"
                },
                "Path": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "Timeout": {
                    "type": "number"
                },
                "UnhealthyThreshold": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AppRunner::Service.ImageConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Port": {
                    "type": "string"
                },
                "RuntimeEnvironmentVariables": {
                    "items": {
                        "$ref": "#/definitions/AWS::AppRunner::Service.KeyValuePair"
                    },
                    "type": "array"
                },
                "StartCommand": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppRunner::Service.ImageRepository": {
            "additionalProperties": false,
            "properties": {
                "ImageConfiguration": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.ImageConfiguration"
                },
                "ImageIdentifier": {
                    "type": "string"
                },
                "ImageRepositoryType": {
                    "type": "string"
                }
            },
            "required": [
                "ImageIdentifier",
                "ImageRepositoryType"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.InstanceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Cpu": {
                    "type": "string"
                },
                "InstanceRoleArn": {
                    "type": "string"
                },
                "Memory": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppRunner::Service.KeyValuePair": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppRunner::Service.SourceCodeVersion": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AppRunner::Service.SourceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationConfiguration": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.AuthenticationConfiguration"
                },
                "AutoDeploymentsEnabled": {
                    "type": "boolean"
                },
                "CodeRepository": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.CodeRepository"
                },
                "ImageRepository": {
                    "$ref": "#/definitions/AWS::AppRunner::Service.ImageRepository"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::DirectoryConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DirectoryName": {
                            "type": "string"
                        },
                        "OrganizationalUnitDistinguishedNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ServiceAccountCredentials": {
                            "$ref": "#/definitions/AWS::AppStream::DirectoryConfig.ServiceAccountCredentials"
                        }
                    },
                    "required": [
                        "DirectoryName",
                        "OrganizationalUnitDistinguishedNames",
                        "ServiceAccountCredentials"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::DirectoryConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::DirectoryConfig.ServiceAccountCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccountName": {
                    "type": "string"
                },
                "AccountPassword": {
                    "type": "string"
                }
            },
            "required": [
                "AccountName",
                "AccountPassword"
            ],
            "type": "object"
        },
        "AWS::AppStream::Fleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeCapacity": {
                            "$ref": "#/definitions/AWS::AppStream::Fleet.ComputeCapacity"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisconnectTimeoutInSeconds": {
                            "type": "number"
                        },
                        "DisplayName": {
                            "type": "string"
                        },
                        "DomainJoinInfo": {
                            "$ref": "#/definitions/AWS::AppStream::Fleet.DomainJoinInfo"
                        },
                        "EnableDefaultInternetAccess": {
                            "type": "boolean"
                        },
                        "FleetType": {
                            "type": "string"
                        },
                        "IamRoleArn": {
                            "type": "string"
                        },
                        "IdleDisconnectTimeoutInSeconds": {
                            "type": "number"
                        },
                        "ImageArn": {
                            "type": "string"
                        },
                        "ImageName": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "MaxUserDurationInSeconds": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "StreamView": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::AppStream::Fleet.VpcConfig"
                        }
                    },
                    "required": [
                        "ComputeCapacity",
                        "InstanceType",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::Fleet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::Fleet.ComputeCapacity": {
            "additionalProperties": false,
            "properties": {
                "DesiredInstances": {
                    "type": "number"
                }
            },
            "required": [
                "DesiredInstances"
            ],
            "type": "object"
        },
        "AWS::AppStream::Fleet.DomainJoinInfo": {
            "additionalProperties": false,
            "properties": {
                "DirectoryName": {
                    "type": "string"
                },
                "OrganizationalUnitDistinguishedName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::Fleet.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessEndpoints": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppStream::ImageBuilder.AccessEndpoint"
                            },
                            "type": "array"
                        },
                        "AppstreamAgentVersion": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisplayName": {
                            "type": "string"
                        },
                        "DomainJoinInfo": {
                            "$ref": "#/definitions/AWS::AppStream::ImageBuilder.DomainJoinInfo"
                        },
                        "EnableDefaultInternetAccess": {
                            "type": "boolean"
                        },
                        "IamRoleArn": {
                            "type": "string"
                        },
                        "ImageArn": {
                            "type": "string"
                        },
                        "ImageName": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::AppStream::ImageBuilder.VpcConfig"
                        }
                    },
                    "required": [
                        "InstanceType",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::ImageBuilder"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder.AccessEndpoint": {
            "additionalProperties": false,
            "properties": {
                "EndpointType": {
                    "type": "string"
                },
                "VpceId": {
                    "type": "string"
                }
            },
            "required": [
                "EndpointType",
                "VpceId"
            ],
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder.DomainJoinInfo": {
            "additionalProperties": false,
            "properties": {
                "DirectoryName": {
                    "type": "string"
                },
                "OrganizationalUnitDistinguishedName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::Stack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessEndpoints": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppStream::Stack.AccessEndpoint"
                            },
                            "type": "array"
                        },
                        "ApplicationSettings": {
                            "$ref": "#/definitions/AWS::AppStream::Stack.ApplicationSettings"
                        },
                        "AttributesToDelete": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DeleteStorageConnectors": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisplayName": {
                            "type": "string"
                        },
                        "EmbedHostDomains": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "FeedbackURL": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RedirectURL": {
                            "type": "string"
                        },
                        "StorageConnectors": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppStream::Stack.StorageConnector"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "UserSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppStream::Stack.UserSetting"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::Stack"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.AccessEndpoint": {
            "additionalProperties": false,
            "properties": {
                "EndpointType": {
                    "type": "string"
                },
                "VpceId": {
                    "type": "string"
                }
            },
            "required": [
                "EndpointType",
                "VpceId"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.ApplicationSettings": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "SettingsGroup": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.StorageConnector": {
            "additionalProperties": false,
            "properties": {
                "ConnectorType": {
                    "type": "string"
                },
                "Domains": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ResourceIdentifier": {
                    "type": "string"
                }
            },
            "required": [
                "ConnectorType"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.UserSetting": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "type": "string"
                },
                "Permission": {
                    "type": "string"
                }
            },
            "required": [
                "Action",
                "Permission"
            ],
            "type": "object"
        },
        "AWS::AppStream::StackFleetAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "FleetName": {
                            "type": "string"
                        },
                        "StackName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FleetName",
                        "StackName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::StackFleetAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::StackUserAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationType": {
                            "type": "string"
                        },
                        "SendEmailNotification": {
                            "type": "boolean"
                        },
                        "StackName": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthenticationType",
                        "StackName",
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::StackUserAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::User": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationType": {
                            "type": "string"
                        },
                        "FirstName": {
                            "type": "string"
                        },
                        "LastName": {
                            "type": "string"
                        },
                        "MessageAction": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthenticationType",
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::User"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::ApiCache": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiCachingBehavior": {
                            "type": "string"
                        },
                        "ApiId": {
                            "type": "string"
                        },
                        "AtRestEncryptionEnabled": {
                            "type": "boolean"
                        },
                        "TransitEncryptionEnabled": {
                            "type": "boolean"
                        },
                        "Ttl": {
                            "type": "number"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiCachingBehavior",
                        "ApiId",
                        "Ttl",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::ApiCache"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::ApiKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ApiKeyId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Expires": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::ApiKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DynamoDBConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.DynamoDBConfig"
                        },
                        "ElasticsearchConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.ElasticsearchConfig"
                        },
                        "HttpConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.HttpConfig"
                        },
                        "LambdaConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.LambdaConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RelationalDatabaseConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.RelationalDatabaseConfig"
                        },
                        "ServiceRoleArn": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "Name",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::DataSource"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.AuthorizationConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationType": {
                    "type": "string"
                },
                "AwsIamConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.AwsIamConfig"
                }
            },
            "required": [
                "AuthorizationType"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.AwsIamConfig": {
            "additionalProperties": false,
            "properties": {
                "SigningRegion": {
                    "type": "string"
                },
                "SigningServiceName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::DataSource.DeltaSyncConfig": {
            "additionalProperties": false,
            "properties": {
                "BaseTableTTL": {
                    "type": "string"
                },
                "DeltaSyncTableName": {
                    "type": "string"
                },
                "DeltaSyncTableTTL": {
                    "type": "string"
                }
            },
            "required": [
                "BaseTableTTL",
                "DeltaSyncTableName",
                "DeltaSyncTableTTL"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.DynamoDBConfig": {
            "additionalProperties": false,
            "properties": {
                "AwsRegion": {
                    "type": "string"
                },
                "DeltaSyncConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.DeltaSyncConfig"
                },
                "TableName": {
                    "type": "string"
                },
                "UseCallerCredentials": {
                    "type": "boolean"
                },
                "Versioned": {
                    "type": "boolean"
                }
            },
            "required": [
                "AwsRegion",
                "TableName"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.ElasticsearchConfig": {
            "additionalProperties": false,
            "properties": {
                "AwsRegion": {
                    "type": "string"
                },
                "Endpoint": {
                    "type": "string"
                }
            },
            "required": [
                "AwsRegion",
                "Endpoint"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.HttpConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.AuthorizationConfig"
                },
                "Endpoint": {
                    "type": "string"
                }
            },
            "required": [
                "Endpoint"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.LambdaConfig": {
            "additionalProperties": false,
            "properties": {
                "LambdaFunctionArn": {
                    "type": "string"
                }
            },
            "required": [
                "LambdaFunctionArn"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.RdsHttpEndpointConfig": {
            "additionalProperties": false,
            "properties": {
                "AwsRegion": {
                    "type": "string"
                },
                "AwsSecretStoreArn": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "DbClusterIdentifier": {
                    "type": "string"
                },
                "Schema": {
                    "type": "string"
                }
            },
            "required": [
                "AwsRegion",
                "AwsSecretStoreArn",
                "DbClusterIdentifier"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.RelationalDatabaseConfig": {
            "additionalProperties": false,
            "properties": {
                "RdsHttpEndpointConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.RdsHttpEndpointConfig"
                },
                "RelationalDatabaseSourceType": {
                    "type": "string"
                }
            },
            "required": [
                "RelationalDatabaseSourceType"
            ],
            "type": "object"
        },
        "AWS::AppSync::FunctionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "DataSourceName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FunctionVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RequestMappingTemplate": {
                            "type": "string"
                        },
                        "RequestMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "ResponseMappingTemplate": {
                            "type": "string"
                        },
                        "ResponseMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "SyncConfig": {
                            "$ref": "#/definitions/AWS::AppSync::FunctionConfiguration.SyncConfig"
                        }
                    },
                    "required": [
                        "ApiId",
                        "DataSourceName",
                        "FunctionVersion",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::FunctionConfiguration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::FunctionConfiguration.LambdaConflictHandlerConfig": {
            "additionalProperties": false,
            "properties": {
                "LambdaConflictHandlerArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::FunctionConfiguration.SyncConfig": {
            "additionalProperties": false,
            "properties": {
                "ConflictDetection": {
                    "type": "string"
                },
                "ConflictHandler": {
                    "type": "string"
                },
                "LambdaConflictHandlerConfig": {
                    "$ref": "#/definitions/AWS::AppSync::FunctionConfiguration.LambdaConflictHandlerConfig"
                }
            },
            "required": [
                "ConflictDetection"
            ],
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalAuthenticationProviders": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders"
                        },
                        "AuthenticationType": {
                            "type": "string"
                        },
                        "LogConfig": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.LogConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OpenIDConnectConfig": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.OpenIDConnectConfig"
                        },
                        "Tags": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.Tags"
                        },
                        "UserPoolConfig": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.UserPoolConfig"
                        },
                        "XrayEnabled": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "AuthenticationType",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::GraphQLApi"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.AdditionalAuthenticationProvider": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationType": {
                    "type": "string"
                },
                "OpenIDConnectConfig": {
                    "$ref": "#/definitions/AWS::AppSync::GraphQLApi.OpenIDConnectConfig"
                },
                "UserPoolConfig": {
                    "$ref": "#/definitions/AWS::AppSync::GraphQLApi.CognitoUserPoolConfig"
                }
            },
            "required": [
                "AuthenticationType"
            ],
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.CognitoUserPoolConfig": {
            "additionalProperties": false,
            "properties": {
                "AppIdClientRegex": {
                    "type": "string"
                },
                "AwsRegion": {
                    "type": "string"
                },
                "UserPoolId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.LogConfig": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLogsRoleArn": {
                    "type": "string"
                },
                "ExcludeVerboseContent": {
                    "type": "boolean"
                },
                "FieldLogLevel": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.OpenIDConnectConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthTTL": {
                    "type": "number"
                },
                "ClientId": {
                    "type": "string"
                },
                "IatTTL": {
                    "type": "number"
                },
                "Issuer": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.Tags": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.UserPoolConfig": {
            "additionalProperties": false,
            "properties": {
                "AppIdClientRegex": {
                    "type": "string"
                },
                "AwsRegion": {
                    "type": "string"
                },
                "DefaultAction": {
                    "type": "string"
                },
                "UserPoolId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLSchema": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Definition": {
                            "type": "string"
                        },
                        "DefinitionS3Location": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::GraphQLSchema"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::Resolver": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "CachingConfig": {
                            "$ref": "#/definitions/AWS::AppSync::Resolver.CachingConfig"
                        },
                        "DataSourceName": {
                            "type": "string"
                        },
                        "FieldName": {
                            "type": "string"
                        },
                        "Kind": {
                            "type": "string"
                        },
                        "PipelineConfig": {
                            "$ref": "#/definitions/AWS::AppSync::Resolver.PipelineConfig"
                        },
                        "RequestMappingTemplate": {
                            "type": "string"
                        },
                        "RequestMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "ResponseMappingTemplate": {
                            "type": "string"
                        },
                        "ResponseMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "SyncConfig": {
                            "$ref": "#/definitions/AWS::AppSync::Resolver.SyncConfig"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "FieldName",
                        "TypeName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::Resolver"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::Resolver.CachingConfig": {
            "additionalProperties": false,
            "properties": {
                "CachingKeys": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Ttl": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::Resolver.LambdaConflictHandlerConfig": {
            "additionalProperties": false,
            "properties": {
                "LambdaConflictHandlerArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::Resolver.PipelineConfig": {
            "additionalProperties": false,
            "properties": {
                "Functions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::Resolver.SyncConfig": {
            "additionalProperties": false,
            "properties": {
                "ConflictDetection": {
                    "type": "string"
                },
                "ConflictHandler": {
                    "type": "string"
                },
                "LambdaConflictHandlerConfig": {
                    "$ref": "#/definitions/AWS::AppSync::Resolver.LambdaConflictHandlerConfig"
                }
            },
            "required": [
                "ConflictDetection"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MaxCapacity": {
                            "type": "number"
                        },
                        "MinCapacity": {
                            "type": "number"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "RoleARN": {
                            "type": "string"
                        },
                        "ScalableDimension": {
                            "type": "string"
                        },
                        "ScheduledActions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalableTarget.ScheduledAction"
                            },
                            "type": "array"
                        },
                        "ServiceNamespace": {
                            "type": "string"
                        },
                        "SuspendedState": {
                            "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState"
                        }
                    },
                    "required": [
                        "MaxCapacity",
                        "MinCapacity",
                        "ResourceId",
                        "RoleARN",
                        "ScalableDimension",
                        "ServiceNamespace"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApplicationAutoScaling::ScalableTarget"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget.ScalableTargetAction": {
            "additionalProperties": false,
            "properties": {
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget.ScheduledAction": {
            "additionalProperties": false,
            "properties": {
                "EndTime": {
                    "type": "string"
                },
                "ScalableTargetAction": {
                    "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalableTarget.ScalableTargetAction"
                },
                "Schedule": {
                    "type": "string"
                },
                "ScheduledActionName": {
                    "type": "string"
                },
                "StartTime": {
                    "type": "string"
                }
            },
            "required": [
                "Schedule",
                "ScheduledActionName"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState": {
            "additionalProperties": false,
            "properties": {
                "DynamicScalingInSuspended": {
                    "type": "boolean"
                },
                "DynamicScalingOutSuspended": {
                    "type": "boolean"
                },
                "ScheduledScalingSuspended": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyName": {
                            "type": "string"
                        },
                        "PolicyType": {
                            "type": "string"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "ScalableDimension": {
                            "type": "string"
                        },
                        "ScalingTargetId": {
                            "type": "string"
                        },
                        "ServiceNamespace": {
                            "type": "string"
                        },
                        "StepScalingPolicyConfiguration": {
                            "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration"
                        },
                        "TargetTrackingScalingPolicyConfiguration": {
                            "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration"
                        }
                    },
                    "required": [
                        "PolicyName",
                        "PolicyType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApplicationAutoScaling::ScalingPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.CustomizedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.PredefinedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.StepAdjustment": {
            "additionalProperties": false,
            "properties": {
                "MetricIntervalLowerBound": {
                    "type": "number"
                },
                "MetricIntervalUpperBound": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdjustmentType": {
                    "type": "string"
                },
                "Cooldown": {
                    "type": "number"
                },
                "MetricAggregationType": {
                    "type": "string"
                },
                "MinAdjustmentMagnitude": {
                    "type": "number"
                },
                "StepAdjustments": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.StepAdjustment"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedMetricSpecification": {
                    "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.CustomizedMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "PredefinedMetricSpecification": {
                    "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.PredefinedMetricSpecification"
                },
                "ScaleInCooldown": {
                    "type": "number"
                },
                "ScaleOutCooldown": {
                    "type": "number"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoConfigurationEnabled": {
                            "type": "boolean"
                        },
                        "CWEMonitorEnabled": {
                            "type": "boolean"
                        },
                        "ComponentMonitoringSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApplicationInsights::Application.ComponentMonitoringSetting"
                            },
                            "type": "array"
                        },
                        "CustomComponents": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApplicationInsights::Application.CustomComponent"
                            },
                            "type": "array"
                        },
                        "LogPatternSets": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApplicationInsights::Application.LogPatternSet"
                            },
                            "type": "array"
                        },
                        "OpsCenterEnabled": {
                            "type": "boolean"
                        },
                        "OpsItemSNSTopicArn": {
                            "type": "string"
                        },
                        "ResourceGroupName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ResourceGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApplicationInsights::Application"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.Alarm": {
            "additionalProperties": false,
            "properties": {
                "AlarmName": {
                    "type": "string"
                },
                "Severity": {
                    "type": "string"
                }
            },
            "required": [
                "AlarmName"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.AlarmMetric": {
            "additionalProperties": false,
            "properties": {
                "AlarmMetricName": {
                    "type": "string"
                }
            },
            "required": [
                "AlarmMetricName"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.ComponentConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ConfigurationDetails": {
                    "$ref": "#/definitions/AWS::ApplicationInsights::Application.ConfigurationDetails"
                },
                "SubComponentTypeConfigurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.SubComponentTypeConfiguration"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.ComponentMonitoringSetting": {
            "additionalProperties": false,
            "properties": {
                "ComponentARN": {
                    "type": "string"
                },
                "ComponentConfigurationMode": {
                    "type": "string"
                },
                "ComponentName": {
                    "type": "string"
                },
                "CustomComponentConfiguration": {
                    "$ref": "#/definitions/AWS::ApplicationInsights::Application.ComponentConfiguration"
                },
                "DefaultOverwriteComponentConfiguration": {
                    "$ref": "#/definitions/AWS::ApplicationInsights::Application.ComponentConfiguration"
                },
                "Tier": {
                    "type": "string"
                }
            },
            "required": [
                "ComponentConfigurationMode",
                "Tier"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.ConfigurationDetails": {
            "additionalProperties": false,
            "properties": {
                "AlarmMetrics": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.AlarmMetric"
                    },
                    "type": "array"
                },
                "Alarms": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.Alarm"
                    },
                    "type": "array"
                },
                "JMXPrometheusExporter": {
                    "$ref": "#/definitions/AWS::ApplicationInsights::Application.JMXPrometheusExporter"
                },
                "Logs": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.Log"
                    },
                    "type": "array"
                },
                "WindowsEvents": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.WindowsEvent"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.CustomComponent": {
            "additionalProperties": false,
            "properties": {
                "ComponentName": {
                    "type": "string"
                },
                "ResourceList": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ComponentName",
                "ResourceList"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.JMXPrometheusExporter": {
            "additionalProperties": false,
            "properties": {
                "HostPort": {
                    "type": "string"
                },
                "JMXURL": {
                    "type": "string"
                },
                "PrometheusPort": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.Log": {
            "additionalProperties": false,
            "properties": {
                "Encoding": {
                    "type": "string"
                },
                "LogGroupName": {
                    "type": "string"
                },
                "LogPath": {
                    "type": "string"
                },
                "LogType": {
                    "type": "string"
                },
                "PatternSet": {
                    "type": "string"
                }
            },
            "required": [
                "LogType"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.LogPattern": {
            "additionalProperties": false,
            "properties": {
                "Pattern": {
                    "type": "string"
                },
                "PatternName": {
                    "type": "string"
                },
                "Rank": {
                    "type": "number"
                }
            },
            "required": [
                "Pattern",
                "PatternName",
                "Rank"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.LogPatternSet": {
            "additionalProperties": false,
            "properties": {
                "LogPatterns": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.LogPattern"
                    },
                    "type": "array"
                },
                "PatternSetName": {
                    "type": "string"
                }
            },
            "required": [
                "LogPatterns",
                "PatternSetName"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.SubComponentConfigurationDetails": {
            "additionalProperties": false,
            "properties": {
                "AlarmMetrics": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.AlarmMetric"
                    },
                    "type": "array"
                },
                "Logs": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.Log"
                    },
                    "type": "array"
                },
                "WindowsEvents": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationInsights::Application.WindowsEvent"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.SubComponentTypeConfiguration": {
            "additionalProperties": false,
            "properties": {
                "SubComponentConfigurationDetails": {
                    "$ref": "#/definitions/AWS::ApplicationInsights::Application.SubComponentConfigurationDetails"
                },
                "SubComponentType": {
                    "type": "string"
                }
            },
            "required": [
                "SubComponentConfigurationDetails",
                "SubComponentType"
            ],
            "type": "object"
        },
        "AWS::ApplicationInsights::Application.WindowsEvent": {
            "additionalProperties": false,
            "properties": {
                "EventLevels": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "EventName": {
                    "type": "string"
                },
                "LogGroupName": {
                    "type": "string"
                },
                "PatternSet": {
                    "type": "string"
                }
            },
            "required": [
                "EventLevels",
                "EventName",
                "LogGroupName"
            ],
            "type": "object"
        },
        "AWS::Athena::DataCatalog": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Parameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Athena::DataCatalog"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Athena::NamedQuery": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Database": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "QueryString": {
                            "type": "string"
                        },
                        "WorkGroup": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Database",
                        "QueryString"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Athena::NamedQuery"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Athena::WorkGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RecursiveDeleteOption": {
                            "type": "boolean"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "WorkGroupConfiguration": {
                            "$ref": "#/definitions/AWS::Athena::WorkGroup.WorkGroupConfiguration"
                        },
                        "WorkGroupConfigurationUpdates": {
                            "$ref": "#/definitions/AWS::Athena::WorkGroup.WorkGroupConfigurationUpdates"
                        }
                    },
                    "required": [
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Athena::WorkGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Athena::WorkGroup.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EncryptionOption": {
                    "type": "string"
                },
                "KmsKey": {
                    "type": "string"
                }
            },
            "required": [
                "EncryptionOption"
            ],
            "type": "object"
        },
        "AWS::Athena::WorkGroup.EngineVersion": {
            "additionalProperties": false,
            "properties": {
                "EffectiveEngineVersion": {
                    "type": "string"
                },
                "SelectedEngineVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Athena::WorkGroup.ResultConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EncryptionConfiguration": {
                    "$ref": "#/definitions/AWS::Athena::WorkGroup.EncryptionConfiguration"
                },
                "OutputLocation": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Athena::WorkGroup.ResultConfigurationUpdates": {
            "additionalProperties": false,
            "properties": {
                "EncryptionConfiguration": {
                    "$ref": "#/definitions/AWS::Athena::WorkGroup.EncryptionConfiguration"
                },
                "OutputLocation": {
                    "type": "string"
                },
                "RemoveEncryptionConfiguration": {
                    "type": "boolean"
                },
                "RemoveOutputLocation": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Athena::WorkGroup.WorkGroupConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BytesScannedCutoffPerQuery": {
                    "type": "number"
                },
                "EnforceWorkGroupConfiguration": {
                    "type": "boolean"
                },
                "EngineVersion": {
                    "$ref": "#/definitions/AWS::Athena::WorkGroup.EngineVersion"
                },
                "PublishCloudWatchMetricsEnabled": {
                    "type": "boolean"
                },
                "RequesterPaysEnabled": {
                    "type": "boolean"
                },
                "ResultConfiguration": {
                    "$ref": "#/definitions/AWS::Athena::WorkGroup.ResultConfiguration"
                }
            },
            "type": "object"
        },
        "AWS::Athena::WorkGroup.WorkGroupConfigurationUpdates": {
            "additionalProperties": false,
            "properties": {
                "BytesScannedCutoffPerQuery": {
                    "type": "number"
                },
                "EnforceWorkGroupConfiguration": {
                    "type": "boolean"
                },
                "EngineVersion": {
                    "$ref": "#/definitions/AWS::Athena::WorkGroup.EngineVersion"
                },
                "PublishCloudWatchMetricsEnabled": {
                    "type": "boolean"
                },
                "RemoveBytesScannedCutoffPerQuery": {
                    "type": "boolean"
                },
                "RequesterPaysEnabled": {
                    "type": "boolean"
                },
                "ResultConfigurationUpdates": {
                    "$ref": "#/definitions/AWS::Athena::WorkGroup.ResultConfigurationUpdates"
                }
            },
            "type": "object"
        },
        "AWS::AuditManager::Assessment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssessmentReportsDestination": {
                            "$ref": "#/definitions/AWS::AuditManager::Assessment.AssessmentReportsDestination"
                        },
                        "AwsAccount": {
                            "$ref": "#/definitions/AWS::AuditManager::Assessment.AWSAccount"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FrameworkId": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Roles": {
                            "items": {
                                "$ref": "#/definitions/AWS::AuditManager::Assessment.Role"
                            },
                            "type": "array"
                        },
                        "Scope": {
                            "$ref": "#/definitions/AWS::AuditManager::Assessment.Scope"
                        },
                        "Status": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AuditManager::Assessment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::AuditManager::Assessment.AWSAccount": {
            "additionalProperties": false,
            "properties": {
                "EmailAddress": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AuditManager::Assessment.AWSService": {
            "additionalProperties": false,
            "properties": {
                "ServiceName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AuditManager::Assessment.AssessmentReportsDestination": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "type": "string"
                },
                "DestinationType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AuditManager::Assessment.Delegation": {
            "additionalProperties": false,
            "properties": {
                "AssessmentId": {
                    "type": "string"
                },
                "AssessmentName": {
                    "type": "string"
                },
                "Comment": {
                    "type": "string"
                },
                "ControlSetId": {
                    "type": "string"
                },
                "CreatedBy": {
                    "type": "string"
                },
                "CreationTime": {
                    "type": "number"
                },
                "Id": {
                    "type": "string"
                },
                "LastUpdated": {
                    "type": "number"
                },
                "RoleArn": {
                    "type": "string"
                },
                "RoleType": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AuditManager::Assessment.Role": {
            "additionalProperties": false,
            "properties": {
                "RoleArn": {
                    "type": "string"
                },
                "RoleType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AuditManager::Assessment.Scope": {
            "additionalProperties": false,
            "properties": {
                "AwsAccounts": {
                    "items": {
                        "$ref": "#/definitions/AWS::AuditManager::Assessment.AWSAccount"
                    },
                    "type": "array"
                },
                "AwsServices": {
                    "items": {
                        "$ref": "#/definitions/AWS::AuditManager::Assessment.AWSService"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "CapacityRebalance": {
                            "type": "boolean"
                        },
                        "Cooldown": {
                            "type": "string"
                        },
                        "DesiredCapacity": {
                            "type": "string"
                        },
                        "HealthCheckGracePeriod": {
                            "type": "number"
                        },
                        "HealthCheckType": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "LaunchConfigurationName": {
                            "type": "string"
                        },
                        "LaunchTemplate": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                        },
                        "LifecycleHookSpecificationList": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification"
                            },
                            "type": "array"
                        },
                        "LoadBalancerNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MaxInstanceLifetime": {
                            "type": "number"
                        },
                        "MaxSize": {
                            "type": "string"
                        },
                        "MetricsCollection": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MetricsCollection"
                            },
                            "type": "array"
                        },
                        "MinSize": {
                            "type": "string"
                        },
                        "MixedInstancesPolicy": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy"
                        },
                        "NewInstancesProtectedFromScaleIn": {
                            "type": "boolean"
                        },
                        "NotificationConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration"
                            },
                            "type": "array"
                        },
                        "PlacementGroup": {
                            "type": "string"
                        },
                        "ServiceLinkedRoleARN": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.TagProperty"
                            },
                            "type": "array"
                        },
                        "TargetGroupARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TerminationPolicies": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VPCZoneIdentifier": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "MaxSize",
                        "MinSize"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::AutoScalingGroup"
                    ],
                    "type": "string"
                },
                "UpdatePolicy": {
                    "type": "object"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.InstancesDistribution": {
            "additionalProperties": false,
            "properties": {
                "OnDemandAllocationStrategy": {
                    "type": "string"
                },
                "OnDemandBaseCapacity": {
                    "type": "number"
                },
                "OnDemandPercentageAboveBaseCapacity": {
                    "type": "number"
                },
                "SpotAllocationStrategy": {
                    "type": "string"
                },
                "SpotInstancePools": {
                    "type": "number"
                },
                "SpotMaxPrice": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplate": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides"
                    },
                    "type": "array"
                }
            },
            "required": [
                "LaunchTemplateSpecification"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides": {
            "additionalProperties": false,
            "properties": {
                "InstanceType": {
                    "type": "string"
                },
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                },
                "WeightedCapacity": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification": {
            "additionalProperties": false,
            "properties": {
                "DefaultResult": {
                    "type": "string"
                },
                "HeartbeatTimeout": {
                    "type": "number"
                },
                "LifecycleHookName": {
                    "type": "string"
                },
                "LifecycleTransition": {
                    "type": "string"
                },
                "NotificationMetadata": {
                    "type": "string"
                },
                "NotificationTargetARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "LifecycleHookName",
                "LifecycleTransition"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MetricsCollection": {
            "additionalProperties": false,
            "properties": {
                "Granularity": {
                    "type": "string"
                },
                "Metrics": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Granularity"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy": {
            "additionalProperties": false,
            "properties": {
                "InstancesDistribution": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.InstancesDistribution"
                },
                "LaunchTemplate": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplate"
                }
            },
            "required": [
                "LaunchTemplate"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "NotificationTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TopicARN": {
                    "type": "string"
                }
            },
            "required": [
                "TopicARN"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.TagProperty": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "PropagateAtLaunch": {
                    "type": "boolean"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "PropagateAtLaunch",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssociatePublicIpAddress": {
                            "type": "boolean"
                        },
                        "BlockDeviceMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping"
                            },
                            "type": "array"
                        },
                        "ClassicLinkVPCId": {
                            "type": "string"
                        },
                        "ClassicLinkVPCSecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "EbsOptimized": {
                            "type": "boolean"
                        },
                        "IamInstanceProfile": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "InstanceMonitoring": {
                            "type": "boolean"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "KernelId": {
                            "type": "string"
                        },
                        "KeyName": {
                            "type": "string"
                        },
                        "LaunchConfigurationName": {
                            "type": "string"
                        },
                        "MetadataOptions": {
                            "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.MetadataOptions"
                        },
                        "PlacementTenancy": {
                            "type": "string"
                        },
                        "RamDiskId": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SpotPrice": {
                            "type": "string"
                        },
                        "UserData": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ImageId",
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::LaunchConfiguration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.BlockDevice": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.BlockDevice"
                },
                "NoDevice": {
                    "type": "boolean"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.MetadataOptions": {
            "additionalProperties": false,
            "properties": {
                "HttpEndpoint": {
                    "type": "string"
                },
                "HttpPutResponseHopLimit": {
                    "type": "number"
                },
                "HttpTokens": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::LifecycleHook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "DefaultResult": {
                            "type": "string"
                        },
                        "HeartbeatTimeout": {
                            "type": "number"
                        },
                        "LifecycleHookName": {
                            "type": "string"
                        },
                        "LifecycleTransition": {
                            "type": "string"
                        },
                        "NotificationMetadata": {
                            "type": "string"
                        },
                        "NotificationTargetARN": {
                            "type": "string"
                        },
                        "RoleARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName",
                        "LifecycleTransition"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::LifecycleHook"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdjustmentType": {
                            "type": "string"
                        },
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "Cooldown": {
                            "type": "string"
                        },
                        "EstimatedInstanceWarmup": {
                            "type": "number"
                        },
                        "MetricAggregationType": {
                            "type": "string"
                        },
                        "MinAdjustmentMagnitude": {
                            "type": "number"
                        },
                        "PolicyType": {
                            "type": "string"
                        },
                        "ScalingAdjustment": {
                            "type": "number"
                        },
                        "StepAdjustments": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.StepAdjustment"
                            },
                            "type": "array"
                        },
                        "TargetTrackingConfiguration": {
                            "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::ScalingPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.StepAdjustment": {
            "additionalProperties": false,
            "properties": {
                "MetricIntervalLowerBound": {
                    "type": "number"
                },
                "MetricIntervalUpperBound": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "PredefinedMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScheduledAction": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "DesiredCapacity": {
                            "type": "number"
                        },
                        "EndTime": {
                            "type": "string"
                        },
                        "MaxSize": {
                            "type": "number"
                        },
                        "MinSize": {
                            "type": "number"
                        },
                        "Recurrence": {
                            "type": "string"
                        },
                        "StartTime": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::ScheduledAction"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::WarmPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "MaxGroupPreparedCapacity": {
                            "type": "number"
                        },
                        "MinSize": {
                            "type": "number"
                        },
                        "PoolState": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::WarmPool"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationSource": {
                            "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.ApplicationSource"
                        },
                        "ScalingInstructions": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.ScalingInstruction"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationSource",
                        "ScalingInstructions"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScalingPlans::ScalingPlan"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.ApplicationSource": {
            "additionalProperties": false,
            "properties": {
                "CloudFormationStackARN": {
                    "type": "string"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.CustomizedLoadMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.CustomizedScalingMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.PredefinedLoadMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedLoadMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedLoadMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.PredefinedScalingMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedScalingMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedScalingMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.ScalingInstruction": {
            "additionalProperties": false,
            "properties": {
                "CustomizedLoadMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.CustomizedLoadMetricSpecification"
                },
                "DisableDynamicScaling": {
                    "type": "boolean"
                },
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                },
                "PredefinedLoadMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.PredefinedLoadMetricSpecification"
                },
                "PredictiveScalingMaxCapacityBehavior": {
                    "type": "string"
                },
                "PredictiveScalingMaxCapacityBuffer": {
                    "type": "number"
                },
                "PredictiveScalingMode": {
                    "type": "string"
                },
                "ResourceId": {
                    "type": "string"
                },
                "ScalableDimension": {
                    "type": "string"
                },
                "ScalingPolicyUpdateBehavior": {
                    "type": "string"
                },
                "ScheduledActionBufferTime": {
                    "type": "number"
                },
                "ServiceNamespace": {
                    "type": "string"
                },
                "TargetTrackingConfigurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.TargetTrackingConfiguration"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MaxCapacity",
                "MinCapacity",
                "ResourceId",
                "ScalableDimension",
                "ServiceNamespace",
                "TargetTrackingConfigurations"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Key"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.TargetTrackingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedScalingMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.CustomizedScalingMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "EstimatedInstanceWarmup": {
                    "type": "number"
                },
                "PredefinedScalingMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.PredefinedScalingMetricSpecification"
                },
                "ScaleInCooldown": {
                    "type": "number"
                },
                "ScaleOutCooldown": {
                    "type": "number"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupPlan": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BackupPlan": {
                            "$ref": "#/definitions/AWS::Backup::BackupPlan.BackupPlanResourceType"
                        },
                        "BackupPlanTags": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        }
                    },
                    "required": [
                        "BackupPlan"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Backup::BackupPlan"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupPlan.AdvancedBackupSettingResourceType": {
            "additionalProperties": false,
            "properties": {
                "BackupOptions": {
                    "type": "object"
                },
                "ResourceType": {
                    "type": "string"
                }
            },
            "required": [
                "BackupOptions",
                "ResourceType"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupPlan.BackupPlanResourceType": {
            "additionalProperties": false,
            "properties": {
                "AdvancedBackupSettings": {
                    "items": {
                        "$ref": "#/definitions/AWS::Backup::BackupPlan.AdvancedBackupSettingResourceType"
                    },
                    "type": "array"
                },
                "BackupPlanName": {
                    "type": "string"
                },
                "BackupPlanRule": {
                    "items": {
                        "$ref": "#/definitions/AWS::Backup::BackupPlan.BackupRuleResourceType"
                    },
                    "type": "array"
                }
            },
            "required": [
                "BackupPlanName",
                "BackupPlanRule"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupPlan.BackupRuleResourceType": {
            "additionalProperties": false,
            "properties": {
                "CompletionWindowMinutes": {
                    "type": "number"
                },
                "CopyActions": {
                    "items": {
                        "$ref": "#/definitions/AWS::Backup::BackupPlan.CopyActionResourceType"
                    },
                    "type": "array"
                },
                "EnableContinuousBackup": {
                    "type": "boolean"
                },
                "Lifecycle": {
                    "$ref": "#/definitions/AWS::Backup::BackupPlan.LifecycleResourceType"
                },
                "RecoveryPointTags": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "RuleName": {
                    "type": "string"
                },
                "ScheduleExpression": {
                    "type": "string"
                },
                "StartWindowMinutes": {
                    "type": "number"
                },
                "TargetBackupVault": {
                    "type": "string"
                }
            },
            "required": [
                "RuleName",
                "TargetBackupVault"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupPlan.CopyActionResourceType": {
            "additionalProperties": false,
            "properties": {
                "DestinationBackupVaultArn": {
                    "type": "string"
                },
                "Lifecycle": {
                    "$ref": "#/definitions/AWS::Backup::BackupPlan.LifecycleResourceType"
                }
            },
            "required": [
                "DestinationBackupVaultArn"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupPlan.LifecycleResourceType": {
            "additionalProperties": false,
            "properties": {
                "DeleteAfterDays": {
                    "type": "number"
                },
                "MoveToColdStorageAfterDays": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Backup::BackupSelection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BackupPlanId": {
                            "type": "string"
                        },
                        "BackupSelection": {
                            "$ref": "#/definitions/AWS::Backup::BackupSelection.BackupSelectionResourceType"
                        }
                    },
                    "required": [
                        "BackupPlanId",
                        "BackupSelection"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Backup::BackupSelection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupSelection.BackupSelectionResourceType": {
            "additionalProperties": false,
            "properties": {
                "IamRoleArn": {
                    "type": "string"
                },
                "ListOfTags": {
                    "items": {
                        "$ref": "#/definitions/AWS::Backup::BackupSelection.ConditionResourceType"
                    },
                    "type": "array"
                },
                "Resources": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SelectionName": {
                    "type": "string"
                }
            },
            "required": [
                "IamRoleArn",
                "SelectionName"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupSelection.ConditionResourceType": {
            "additionalProperties": false,
            "properties": {
                "ConditionKey": {
                    "type": "string"
                },
                "ConditionType": {
                    "type": "string"
                },
                "ConditionValue": {
                    "type": "string"
                }
            },
            "required": [
                "ConditionKey",
                "ConditionType",
                "ConditionValue"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupVault": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessPolicy": {
                            "type": "object"
                        },
                        "BackupVaultName": {
                            "type": "string"
                        },
                        "BackupVaultTags": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "EncryptionKeyArn": {
                            "type": "string"
                        },
                        "Notifications": {
                            "$ref": "#/definitions/AWS::Backup::BackupVault.NotificationObjectType"
                        }
                    },
                    "required": [
                        "BackupVaultName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Backup::BackupVault"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Backup::BackupVault.NotificationObjectType": {
            "additionalProperties": false,
            "properties": {
                "BackupVaultEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SNSTopicArn": {
                    "type": "string"
                }
            },
            "required": [
                "BackupVaultEvents",
                "SNSTopicArn"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeEnvironmentName": {
                            "type": "string"
                        },
                        "ComputeResources": {
                            "$ref": "#/definitions/AWS::Batch::ComputeEnvironment.ComputeResources"
                        },
                        "ServiceRole": {
                            "type": "string"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Tags": {
                            "type": "object"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Batch::ComputeEnvironment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment.ComputeResources": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                },
                "BidPercentage": {
                    "type": "number"
                },
                "DesiredvCpus": {
                    "type": "number"
                },
                "Ec2Configuration": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::ComputeEnvironment.Ec2ConfigurationObject"
                    },
                    "type": "array"
                },
                "Ec2KeyPair": {
                    "type": "string"
                },
                "ImageId": {
                    "type": "string"
                },
                "InstanceRole": {
                    "type": "string"
                },
                "InstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LaunchTemplate": {
                    "$ref": "#/definitions/AWS::Batch::ComputeEnvironment.LaunchTemplateSpecification"
                },
                "MaxvCpus": {
                    "type": "number"
                },
                "MinvCpus": {
                    "type": "number"
                },
                "PlacementGroup": {
                    "type": "string"
                },
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SpotIamFleetRole": {
                    "type": "string"
                },
                "Subnets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Tags": {
                    "type": "object"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "MaxvCpus",
                "Subnets",
                "Type"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment.Ec2ConfigurationObject": {
            "additionalProperties": false,
            "properties": {
                "ImageIdOverride": {
                    "type": "string"
                },
                "ImageType": {
                    "type": "string"
                }
            },
            "required": [
                "ImageType"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ContainerProperties": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.ContainerProperties"
                        },
                        "JobDefinitionName": {
                            "type": "string"
                        },
                        "NodeProperties": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.NodeProperties"
                        },
                        "Parameters": {
                            "type": "object"
                        },
                        "PlatformCapabilities": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PropagateTags": {
                            "type": "boolean"
                        },
                        "RetryStrategy": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.RetryStrategy"
                        },
                        "Tags": {
                            "type": "object"
                        },
                        "Timeout": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.Timeout"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Batch::JobDefinition"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.AuthorizationConfig": {
            "additionalProperties": false,
            "properties": {
                "AccessPointId": {
                    "type": "string"
                },
                "Iam": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.ContainerProperties": {
            "additionalProperties": false,
            "properties": {
                "Command": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Environment": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Environment"
                    },
                    "type": "array"
                },
                "ExecutionRoleArn": {
                    "type": "string"
                },
                "FargatePlatformConfiguration": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.FargatePlatformConfiguration"
                },
                "Image": {
                    "type": "string"
                },
                "InstanceType": {
                    "type": "string"
                },
                "JobRoleArn": {
                    "type": "string"
                },
                "LinuxParameters": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.LinuxParameters"
                },
                "LogConfiguration": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.LogConfiguration"
                },
                "Memory": {
                    "type": "number"
                },
                "MountPoints": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.MountPoints"
                    },
                    "type": "array"
                },
                "NetworkConfiguration": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.NetworkConfiguration"
                },
                "Privileged": {
                    "type": "boolean"
                },
                "ReadonlyRootFilesystem": {
                    "type": "boolean"
                },
                "ResourceRequirements": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.ResourceRequirement"
                    },
                    "type": "array"
                },
                "Secrets": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Secret"
                    },
                    "type": "array"
                },
                "Ulimits": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Ulimit"
                    },
                    "type": "array"
                },
                "User": {
                    "type": "string"
                },
                "Vcpus": {
                    "type": "number"
                },
                "Volumes": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Volumes"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Image"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Device": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "HostPath": {
                    "type": "string"
                },
                "Permissions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.EfsVolumeConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationConfig": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.AuthorizationConfig"
                },
                "FileSystemId": {
                    "type": "string"
                },
                "RootDirectory": {
                    "type": "string"
                },
                "TransitEncryption": {
                    "type": "string"
                },
                "TransitEncryptionPort": {
                    "type": "number"
                }
            },
            "required": [
                "FileSystemId"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Environment": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.EvaluateOnExit": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "type": "string"
                },
                "OnExitCode": {
                    "type": "string"
                },
                "OnReason": {
                    "type": "string"
                },
                "OnStatusReason": {
                    "type": "string"
                }
            },
            "required": [
                "Action"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.FargatePlatformConfiguration": {
            "additionalProperties": false,
            "properties": {
                "PlatformVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.LinuxParameters": {
            "additionalProperties": false,
            "properties": {
                "Devices": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Device"
                    },
                    "type": "array"
                },
                "InitProcessEnabled": {
                    "type": "boolean"
                },
                "MaxSwap": {
                    "type": "number"
                },
                "SharedMemorySize": {
                    "type": "number"
                },
                "Swappiness": {
                    "type": "number"
                },
                "Tmpfs": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Tmpfs"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.LogConfiguration": {
            "additionalProperties": false,
            "properties": {
                "LogDriver": {
                    "type": "string"
                },
                "Options": {
                    "type": "object"
                },
                "SecretOptions": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Secret"
                    },
                    "type": "array"
                }
            },
            "required": [
                "LogDriver"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.MountPoints": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "ReadOnly": {
                    "type": "boolean"
                },
                "SourceVolume": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.NetworkConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AssignPublicIp": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.NodeProperties": {
            "additionalProperties": false,
            "properties": {
                "MainNode": {
                    "type": "number"
                },
                "NodeRangeProperties": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.NodeRangeProperty"
                    },
                    "type": "array"
                },
                "NumNodes": {
                    "type": "number"
                }
            },
            "required": [
                "MainNode",
                "NodeRangeProperties",
                "NumNodes"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.NodeRangeProperty": {
            "additionalProperties": false,
            "properties": {
                "Container": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.ContainerProperties"
                },
                "TargetNodes": {
                    "type": "string"
                }
            },
            "required": [
                "TargetNodes"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.ResourceRequirement": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.RetryStrategy": {
            "additionalProperties": false,
            "properties": {
                "Attempts": {
                    "type": "number"
                },
                "EvaluateOnExit": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.EvaluateOnExit"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Secret": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "ValueFrom": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "ValueFrom"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Timeout": {
            "additionalProperties": false,
            "properties": {
                "AttemptDurationSeconds": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Tmpfs": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "MountOptions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Size": {
                    "type": "number"
                }
            },
            "required": [
                "ContainerPath",
                "Size"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Ulimit": {
            "additionalProperties": false,
            "properties": {
                "HardLimit": {
                    "type": "number"
                },
                "Name": {
                    "type": "string"
                },
                "SoftLimit": {
                    "type": "number"
                }
            },
            "required": [
                "HardLimit",
                "Name",
                "SoftLimit"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Volumes": {
            "additionalProperties": false,
            "properties": {
                "EfsVolumeConfiguration": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.EfsVolumeConfiguration"
                },
                "Host": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.VolumesHost"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.VolumesHost": {
            "additionalProperties": false,
            "properties": {
                "SourcePath": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobQueue": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeEnvironmentOrder": {
                            "items": {
                                "$ref": "#/definitions/AWS::Batch::JobQueue.ComputeEnvironmentOrder"
                            },
                            "type": "array"
                        },
                        "JobQueueName": {
                            "type": "string"
                        },
                        "Priority": {
                            "type": "number"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Tags": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "ComputeEnvironmentOrder",
                        "Priority"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Batch::JobQueue"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Batch::JobQueue.ComputeEnvironmentOrder": {
            "additionalProperties": false,
            "properties": {
                "ComputeEnvironment": {
                    "type": "string"
                },
                "Order": {
                    "type": "number"
                }
            },
            "required": [
                "ComputeEnvironment",
                "Order"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Budget": {
                            "$ref": "#/definitions/AWS::Budgets::Budget.BudgetData"
                        },
                        "NotificationsWithSubscribers": {
                            "items": {
                                "$ref": "#/definitions/AWS::Budgets::Budget.NotificationWithSubscribers"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Budget"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Budgets::Budget"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.BudgetData": {
            "additionalProperties": false,
            "properties": {
                "BudgetLimit": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.Spend"
                },
                "BudgetName": {
                    "type": "string"
                },
                "BudgetType": {
                    "type": "string"
                },
                "CostFilters": {
                    "type": "object"
                },
                "CostTypes": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.CostTypes"
                },
                "PlannedBudgetLimits": {
                    "type": "object"
                },
                "TimePeriod": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.TimePeriod"
                },
                "TimeUnit": {
                    "type": "string"
                }
            },
            "required": [
                "BudgetType",
                "TimeUnit"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.CostTypes": {
            "additionalProperties": false,
            "properties": {
                "IncludeCredit": {
                    "type": "boolean"
                },
                "IncludeDiscount": {
                    "type": "boolean"
                },
                "IncludeOtherSubscription": {
                    "type": "boolean"
                },
                "IncludeRecurring": {
                    "type": "boolean"
                },
                "IncludeRefund": {
                    "type": "boolean"
                },
                "IncludeSubscription": {
                    "type": "boolean"
                },
                "IncludeSupport": {
                    "type": "boolean"
                },
                "IncludeTax": {
                    "type": "boolean"
                },
                "IncludeUpfront": {
                    "type": "boolean"
                },
                "UseAmortized": {
                    "type": "boolean"
                },
                "UseBlended": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Budgets::Budget.Notification": {
            "additionalProperties": false,
            "properties": {
                "ComparisonOperator": {
                    "type": "string"
                },
                "NotificationType": {
                    "type": "string"
                },
                "Threshold": {
                    "type": "number"
                },
                "ThresholdType": {
                    "type": "string"
                }
            },
            "required": [
                "ComparisonOperator",
                "NotificationType",
                "Threshold"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.NotificationWithSubscribers": {
            "additionalProperties": false,
            "properties": {
                "Notification": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.Notification"
                },
                "Subscribers": {
                    "items": {
                        "$ref": "#/definitions/AWS::Budgets::Budget.Subscriber"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Notification",
                "Subscribers"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.Spend": {
            "additionalProperties": false,
            "properties": {
                "Amount": {
                    "type": "number"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Amount",
                "Unit"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.Subscriber": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "SubscriptionType": {
                    "type": "string"
                }
            },
            "required": [
                "Address",
                "SubscriptionType"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.TimePeriod": {
            "additionalProperties": false,
            "properties": {
                "End": {
                    "type": "string"
                },
                "Start": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionThreshold": {
                            "$ref": "#/definitions/AWS::Budgets::BudgetsAction.ActionThreshold"
                        },
                        "ActionType": {
                            "type": "string"
                        },
                        "ApprovalModel": {
                            "type": "string"
                        },
                        "BudgetName": {
                            "type": "string"
                        },
                        "Definition": {
                            "$ref": "#/definitions/AWS::Budgets::BudgetsAction.Definition"
                        },
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "NotificationType": {
                            "type": "string"
                        },
                        "Subscribers": {
                            "items": {
                                "$ref": "#/definitions/AWS::Budgets::BudgetsAction.Subscriber"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ActionThreshold",
                        "ActionType",
                        "BudgetName",
                        "Definition",
                        "ExecutionRoleArn",
                        "NotificationType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Budgets::BudgetsAction"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction.ActionThreshold": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "number"
                }
            },
            "required": [
                "Type",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction.Definition": {
            "additionalProperties": false,
            "properties": {
                "IamActionDefinition": {
                    "$ref": "#/definitions/AWS::Budgets::BudgetsAction.IamActionDefinition"
                },
                "ScpActionDefinition": {
                    "$ref": "#/definitions/AWS::Budgets::BudgetsAction.ScpActionDefinition"
                },
                "SsmActionDefinition": {
                    "$ref": "#/definitions/AWS::Budgets::BudgetsAction.SsmActionDefinition"
                }
            },
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction.IamActionDefinition": {
            "additionalProperties": false,
            "properties": {
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "PolicyArn": {
                    "type": "string"
                },
                "Roles": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Users": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "PolicyArn"
            ],
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction.ScpActionDefinition": {
            "additionalProperties": false,
            "properties": {
                "PolicyId": {
                    "type": "string"
                },
                "TargetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "PolicyId",
                "TargetIds"
            ],
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction.SsmActionDefinition": {
            "additionalProperties": false,
            "properties": {
                "InstanceIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Region": {
                    "type": "string"
                },
                "Subtype": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceIds",
                "Region",
                "Subtype"
            ],
            "type": "object"
        },
        "AWS::Budgets::BudgetsAction.Subscriber": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Address",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CE::AnomalyMonitor": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MonitorDimension": {
                            "type": "string"
                        },
                        "MonitorName": {
                            "type": "string"
                        },
                        "MonitorSpecification": {
                            "type": "string"
                        },
                        "MonitorType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MonitorName",
                        "MonitorType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CE::AnomalyMonitor"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CE::AnomalySubscription": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Frequency": {
                            "type": "string"
                        },
                        "MonitorArnList": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Subscribers": {
                            "items": {
                                "$ref": "#/definitions/AWS::CE::AnomalySubscription.Subscriber"
                            },
                            "type": "array"
                        },
                        "SubscriptionName": {
                            "type": "string"
                        },
                        "Threshold": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Frequency",
                        "MonitorArnList",
                        "Subscribers",
                        "SubscriptionName",
                        "Threshold"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CE::AnomalySubscription"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CE::AnomalySubscription.Subscriber": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Address",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CE::CostCategory": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DefaultValue": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RuleVersion": {
                            "type": "string"
                        },
                        "Rules": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name",
                        "RuleVersion",
                        "Rules"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CE::CostCategory"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CUR::ReportDefinition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalArtifacts": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AdditionalSchemaElements": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "BillingViewArn": {
                            "type": "string"
                        },
                        "Compression": {
                            "type": "string"
                        },
                        "Format": {
                            "type": "string"
                        },
                        "RefreshClosedReports": {
                            "type": "boolean"
                        },
                        "ReportName": {
                            "type": "string"
                        },
                        "ReportVersioning": {
                            "type": "string"
                        },
                        "S3Bucket": {
                            "type": "string"
                        },
                        "S3Prefix": {
                            "type": "string"
                        },
                        "S3Region": {
                            "type": "string"
                        },
                        "TimeUnit": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Compression",
                        "Format",
                        "RefreshClosedReports",
                        "ReportName",
                        "ReportVersioning",
                        "S3Bucket",
                        "S3Prefix",
                        "S3Region",
                        "TimeUnit"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CUR::ReportDefinition"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cassandra::Keyspace": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "KeyspaceName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cassandra::Keyspace"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Cassandra::Table": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BillingMode": {
                            "$ref": "#/definitions/AWS::Cassandra::Table.BillingMode"
                        },
                        "ClusteringKeyColumns": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cassandra::Table.ClusteringKeyColumn"
                            },
                            "type": "array"
                        },
                        "KeyspaceName": {
                            "type": "string"
                        },
                        "PartitionKeyColumns": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cassandra::Table.Column"
                            },
                            "type": "array"
                        },
                        "PointInTimeRecoveryEnabled": {
                            "type": "boolean"
                        },
                        "RegularColumns": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cassandra::Table.Column"
                            },
                            "type": "array"
                        },
                        "TableName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "KeyspaceName",
                        "PartitionKeyColumns"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cassandra::Table"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cassandra::Table.BillingMode": {
            "additionalProperties": false,
            "properties": {
                "Mode": {
                    "type": "string"
                },
                "ProvisionedThroughput": {
                    "$ref": "#/definitions/AWS::Cassandra::Table.ProvisionedThroughput"
                }
            },
            "required": [
                "Mode"
            ],
            "type": "object"
        },
        "AWS::Cassandra::Table.ClusteringKeyColumn": {
            "additionalProperties": false,
            "properties": {
                "Column": {
                    "$ref": "#/definitions/AWS::Cassandra::Table.Column"
                },
                "OrderBy": {
                    "type": "string"
                }
            },
            "required": [
                "Column"
            ],
            "type": "object"
        },
        "AWS::Cassandra::Table.Column": {
            "additionalProperties": false,
            "properties": {
                "ColumnName": {
                    "type": "string"
                },
                "ColumnType": {
                    "type": "string"
                }
            },
            "required": [
                "ColumnName",
                "ColumnType"
            ],
            "type": "object"
        },
        "AWS::Cassandra::Table.ProvisionedThroughput": {
            "additionalProperties": false,
            "properties": {
                "ReadCapacityUnits": {
                    "type": "number"
                },
                "WriteCapacityUnits": {
                    "type": "number"
                }
            },
            "required": [
                "ReadCapacityUnits",
                "WriteCapacityUnits"
            ],
            "type": "object"
        },
        "AWS::CertificateManager::Account": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExpiryEventsConfiguration": {
                            "$ref": "#/definitions/AWS::CertificateManager::Account.ExpiryEventsConfiguration"
                        }
                    },
                    "required": [
                        "ExpiryEventsConfiguration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CertificateManager::Account"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CertificateManager::Account.ExpiryEventsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DaysBeforeExpiry": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::CertificateManager::Certificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateAuthorityArn": {
                            "type": "string"
                        },
                        "CertificateTransparencyLoggingPreference": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "DomainValidationOptions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CertificateManager::Certificate.DomainValidationOption"
                            },
                            "type": "array"
                        },
                        "SubjectAlternativeNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "ValidationMethod": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CertificateManager::Certificate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CertificateManager::Certificate.DomainValidationOption": {
            "additionalProperties": false,
            "properties": {
                "DomainName": {
                    "type": "string"
                },
                "HostedZoneId": {
                    "type": "string"
                },
                "ValidationDomain": {
                    "type": "string"
                }
            },
            "required": [
                "DomainName"
            ],
            "type": "object"
        },
        "AWS::Chatbot::SlackChannelConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConfigurationName": {
                            "type": "string"
                        },
                        "IamRoleArn": {
                            "type": "string"
                        },
                        "LoggingLevel": {
                            "type": "string"
                        },
                        "SlackChannelId": {
                            "type": "string"
                        },
                        "SlackWorkspaceId": {
                            "type": "string"
                        },
                        "SnsTopicArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ConfigurationName",
                        "IamRoleArn",
                        "SlackChannelId",
                        "SlackWorkspaceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Chatbot::SlackChannelConfiguration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cloud9::EnvironmentEC2": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutomaticStopTimeMinutes": {
                            "type": "number"
                        },
                        "ConnectionType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OwnerArn": {
                            "type": "string"
                        },
                        "Repositories": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cloud9::EnvironmentEC2.Repository"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cloud9::EnvironmentEC2"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cloud9::EnvironmentEC2.Repository": {
            "additionalProperties": false,
            "properties": {
                "PathComponent": {
                    "type": "string"
                },
                "RepositoryUrl": {
                    "type": "string"
                }
            },
            "required": [
                "PathComponent",
                "RepositoryUrl"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::CustomResource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ServiceToken": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceToken"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::CustomResource"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::Macro": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "LogGroupName": {
                            "type": "string"
                        },
                        "LogRoleARN": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FunctionName",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Macro"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ModuleDefaultVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Arn": {
                            "type": "string"
                        },
                        "ModuleName": {
                            "type": "string"
                        },
                        "VersionId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ModuleDefaultVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ModuleVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ModuleName": {
                            "type": "string"
                        },
                        "ModulePackage": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ModuleName",
                        "ModulePackage"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ModuleVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ResourceDefaultVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TypeName": {
                            "type": "string"
                        },
                        "TypeVersionArn": {
                            "type": "string"
                        },
                        "VersionId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ResourceDefaultVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ResourceVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "LoggingConfig": {
                            "$ref": "#/definitions/AWS::CloudFormation::ResourceVersion.LoggingConfig"
                        },
                        "SchemaHandlerPackage": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SchemaHandlerPackage",
                        "TypeName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ResourceVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ResourceVersion.LoggingConfig": {
            "additionalProperties": false,
            "properties": {
                "LogGroupName": {
                    "type": "string"
                },
                "LogRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::Stack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "NotificationARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Parameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateURL": {
                            "type": "string"
                        },
                        "TimeoutInMinutes": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "TemplateURL"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Stack"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::StackSet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdministrationRoleARN": {
                            "type": "string"
                        },
                        "AutoDeployment": {
                            "$ref": "#/definitions/AWS::CloudFormation::StackSet.AutoDeployment"
                        },
                        "CallAs": {
                            "type": "string"
                        },
                        "Capabilities": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "ExecutionRoleName": {
                            "type": "string"
                        },
                        "OperationPreferences": {
                            "$ref": "#/definitions/AWS::CloudFormation::StackSet.OperationPreferences"
                        },
                        "Parameters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudFormation::StackSet.Parameter"
                            },
                            "type": "array"
                        },
                        "PermissionModel": {
                            "type": "string"
                        },
                        "StackInstancesGroup": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudFormation::StackSet.StackInstances"
                            },
                            "type": "array"
                        },
                        "StackSetName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateBody": {
                            "type": "string"
                        },
                        "TemplateURL": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PermissionModel",
                        "StackSetName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::StackSet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.AutoDeployment": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "RetainStacksOnAccountRemoval": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.DeploymentTargets": {
            "additionalProperties": false,
            "properties": {
                "Accounts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "OrganizationalUnitIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.OperationPreferences": {
            "additionalProperties": false,
            "properties": {
                "FailureToleranceCount": {
                    "type": "number"
                },
                "FailureTolerancePercentage": {
                    "type": "number"
                },
                "MaxConcurrentCount": {
                    "type": "number"
                },
                "MaxConcurrentPercentage": {
                    "type": "number"
                },
                "RegionConcurrencyType": {
                    "type": "string"
                },
                "RegionOrder": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.Parameter": {
            "additionalProperties": false,
            "properties": {
                "ParameterKey": {
                    "type": "string"
                },
                "ParameterValue": {
                    "type": "string"
                }
            },
            "required": [
                "ParameterKey",
                "ParameterValue"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.StackInstances": {
            "additionalProperties": false,
            "properties": {
                "DeploymentTargets": {
                    "$ref": "#/definitions/AWS::CloudFormation::StackSet.DeploymentTargets"
                },
                "ParameterOverrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFormation::StackSet.Parameter"
                    },
                    "type": "array"
                },
                "Regions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "DeploymentTargets",
                "Regions"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::WaitCondition": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Count": {
                            "type": "number"
                        },
                        "Handle": {
                            "type": "string"
                        },
                        "Timeout": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::WaitCondition"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::WaitConditionHandle": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {},
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::WaitConditionHandle"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CachePolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CachePolicyConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::CachePolicy.CachePolicyConfig"
                        }
                    },
                    "required": [
                        "CachePolicyConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::CachePolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CachePolicy.CachePolicyConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                },
                "DefaultTTL": {
                    "type": "number"
                },
                "MaxTTL": {
                    "type": "number"
                },
                "MinTTL": {
                    "type": "number"
                },
                "Name": {
                    "type": "string"
                },
                "ParametersInCacheKeyAndForwardedToOrigin": {
                    "$ref": "#/definitions/AWS::CloudFront::CachePolicy.ParametersInCacheKeyAndForwardedToOrigin"
                }
            },
            "required": [
                "DefaultTTL",
                "MaxTTL",
                "MinTTL",
                "Name",
                "ParametersInCacheKeyAndForwardedToOrigin"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CachePolicy.CookiesConfig": {
            "additionalProperties": false,
            "properties": {
                "CookieBehavior": {
                    "type": "string"
                },
                "Cookies": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CookieBehavior"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CachePolicy.HeadersConfig": {
            "additionalProperties": false,
            "properties": {
                "HeaderBehavior": {
                    "type": "string"
                },
                "Headers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "HeaderBehavior"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CachePolicy.ParametersInCacheKeyAndForwardedToOrigin": {
            "additionalProperties": false,
            "properties": {
                "CookiesConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::CachePolicy.CookiesConfig"
                },
                "EnableAcceptEncodingBrotli": {
                    "type": "boolean"
                },
                "EnableAcceptEncodingGzip": {
                    "type": "boolean"
                },
                "HeadersConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::CachePolicy.HeadersConfig"
                },
                "QueryStringsConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::CachePolicy.QueryStringsConfig"
                }
            },
            "required": [
                "CookiesConfig",
                "EnableAcceptEncodingGzip",
                "HeadersConfig",
                "QueryStringsConfig"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CachePolicy.QueryStringsConfig": {
            "additionalProperties": false,
            "properties": {
                "QueryStringBehavior": {
                    "type": "string"
                },
                "QueryStrings": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "QueryStringBehavior"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CloudFrontOriginAccessIdentity": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudFrontOriginAccessIdentityConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::CloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfig"
                        }
                    },
                    "required": [
                        "CloudFrontOriginAccessIdentityConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::CloudFrontOriginAccessIdentity"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                }
            },
            "required": [
                "Comment"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DistributionConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::Distribution.DistributionConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DistributionConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::Distribution"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.CacheBehavior": {
            "additionalProperties": false,
            "properties": {
                "AllowedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CachePolicyId": {
                    "type": "string"
                },
                "CachedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Compress": {
                    "type": "boolean"
                },
                "DefaultTTL": {
                    "type": "number"
                },
                "FieldLevelEncryptionId": {
                    "type": "string"
                },
                "ForwardedValues": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.ForwardedValues"
                },
                "FunctionAssociations": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.FunctionAssociation"
                    },
                    "type": "array"
                },
                "LambdaFunctionAssociations": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.LambdaFunctionAssociation"
                    },
                    "type": "array"
                },
                "MaxTTL": {
                    "type": "number"
                },
                "MinTTL": {
                    "type": "number"
                },
                "OriginRequestPolicyId": {
                    "type": "string"
                },
                "PathPattern": {
                    "type": "string"
                },
                "RealtimeLogConfigArn": {
                    "type": "string"
                },
                "SmoothStreaming": {
                    "type": "boolean"
                },
                "TargetOriginId": {
                    "type": "string"
                },
                "TrustedKeyGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TrustedSigners": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ViewerProtocolPolicy": {
                    "type": "string"
                }
            },
            "required": [
                "PathPattern",
                "TargetOriginId",
                "ViewerProtocolPolicy"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Cookies": {
            "additionalProperties": false,
            "properties": {
                "Forward": {
                    "type": "string"
                },
                "WhitelistedNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Forward"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.CustomErrorResponse": {
            "additionalProperties": false,
            "properties": {
                "ErrorCachingMinTTL": {
                    "type": "number"
                },
                "ErrorCode": {
                    "type": "number"
                },
                "ResponseCode": {
                    "type": "number"
                },
                "ResponsePagePath": {
                    "type": "string"
                }
            },
            "required": [
                "ErrorCode"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.CustomOriginConfig": {
            "additionalProperties": false,
            "properties": {
                "HTTPPort": {
                    "type": "number"
                },
                "HTTPSPort": {
                    "type": "number"
                },
                "OriginKeepaliveTimeout": {
                    "type": "number"
                },
                "OriginProtocolPolicy": {
                    "type": "string"
                },
                "OriginReadTimeout": {
                    "type": "number"
                },
                "OriginSSLProtocols": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "OriginProtocolPolicy"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.DefaultCacheBehavior": {
            "additionalProperties": false,
            "properties": {
                "AllowedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CachePolicyId": {
                    "type": "string"
                },
                "CachedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Compress": {
                    "type": "boolean"
                },
                "DefaultTTL": {
                    "type": "number"
                },
                "FieldLevelEncryptionId": {
                    "type": "string"
                },
                "ForwardedValues": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.ForwardedValues"
                },
                "FunctionAssociations": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.FunctionAssociation"
                    },
                    "type": "array"
                },
                "LambdaFunctionAssociations": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.LambdaFunctionAssociation"
                    },
                    "type": "array"
                },
                "MaxTTL": {
                    "type": "number"
                },
                "MinTTL": {
                    "type": "number"
                },
                "OriginRequestPolicyId": {
                    "type": "string"
                },
                "RealtimeLogConfigArn": {
                    "type": "string"
                },
                "SmoothStreaming": {
                    "type": "boolean"
                },
                "TargetOriginId": {
                    "type": "string"
                },
                "TrustedKeyGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TrustedSigners": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ViewerProtocolPolicy": {
                    "type": "string"
                }
            },
            "required": [
                "TargetOriginId",
                "ViewerProtocolPolicy"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.DistributionConfig": {
            "additionalProperties": false,
            "properties": {
                "Aliases": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CNAMEs": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CacheBehaviors": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.CacheBehavior"
                    },
                    "type": "array"
                },
                "Comment": {
                    "type": "string"
                },
                "CustomErrorResponses": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.CustomErrorResponse"
                    },
                    "type": "array"
                },
                "CustomOrigin": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.LegacyCustomOrigin"
                },
                "DefaultCacheBehavior": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.DefaultCacheBehavior"
                },
                "DefaultRootObject": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "HttpVersion": {
                    "type": "string"
                },
                "IPV6Enabled": {
                    "type": "boolean"
                },
                "Logging": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.Logging"
                },
                "OriginGroups": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginGroups"
                },
                "Origins": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.Origin"
                    },
                    "type": "array"
                },
                "PriceClass": {
                    "type": "string"
                },
                "Restrictions": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.Restrictions"
                },
                "S3Origin": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.LegacyS3Origin"
                },
                "ViewerCertificate": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.ViewerCertificate"
                },
                "WebACLId": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.ForwardedValues": {
            "additionalProperties": false,
            "properties": {
                "Cookies": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.Cookies"
                },
                "Headers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "QueryString": {
                    "type": "boolean"
                },
                "QueryStringCacheKeys": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "QueryString"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.FunctionAssociation": {
            "additionalProperties": false,
            "properties": {
                "EventType": {
                    "type": "string"
                },
                "FunctionARN": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Distribution.GeoRestriction": {
            "additionalProperties": false,
            "properties": {
                "Locations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RestrictionType": {
                    "type": "string"
                }
            },
            "required": [
                "RestrictionType"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.LambdaFunctionAssociation": {
            "additionalProperties": false,
            "properties": {
                "EventType": {
                    "type": "string"
                },
                "IncludeBody": {
                    "type": "boolean"
                },
                "LambdaFunctionARN": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Distribution.LegacyCustomOrigin": {
            "additionalProperties": false,
            "properties": {
                "DNSName": {
                    "type": "string"
                },
                "HTTPPort": {
                    "type": "number"
                },
                "HTTPSPort": {
                    "type": "number"
                },
                "OriginProtocolPolicy": {
                    "type": "string"
                },
                "OriginSSLProtocols": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "DNSName",
                "OriginProtocolPolicy",
                "OriginSSLProtocols"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.LegacyS3Origin": {
            "additionalProperties": false,
            "properties": {
                "DNSName": {
                    "type": "string"
                },
                "OriginAccessIdentity": {
                    "type": "string"
                }
            },
            "required": [
                "DNSName"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Logging": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "IncludeCookies": {
                    "type": "boolean"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Origin": {
            "additionalProperties": false,
            "properties": {
                "ConnectionAttempts": {
                    "type": "number"
                },
                "ConnectionTimeout": {
                    "type": "number"
                },
                "CustomOriginConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.CustomOriginConfig"
                },
                "DomainName": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "OriginCustomHeaders": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginCustomHeader"
                    },
                    "type": "array"
                },
                "OriginPath": {
                    "type": "string"
                },
                "OriginShield": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginShield"
                },
                "S3OriginConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.S3OriginConfig"
                }
            },
            "required": [
                "DomainName",
                "Id"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginCustomHeader": {
            "additionalProperties": false,
            "properties": {
                "HeaderName": {
                    "type": "string"
                },
                "HeaderValue": {
                    "type": "string"
                }
            },
            "required": [
                "HeaderName",
                "HeaderValue"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginGroup": {
            "additionalProperties": false,
            "properties": {
                "FailoverCriteria": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginGroupFailoverCriteria"
                },
                "Id": {
                    "type": "string"
                },
                "Members": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginGroupMembers"
                }
            },
            "required": [
                "FailoverCriteria",
                "Id",
                "Members"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginGroupFailoverCriteria": {
            "additionalProperties": false,
            "properties": {
                "StatusCodes": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.StatusCodes"
                }
            },
            "required": [
                "StatusCodes"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginGroupMember": {
            "additionalProperties": false,
            "properties": {
                "OriginId": {
                    "type": "string"
                }
            },
            "required": [
                "OriginId"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginGroupMembers": {
            "additionalProperties": false,
            "properties": {
                "Items": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginGroupMember"
                    },
                    "type": "array"
                },
                "Quantity": {
                    "type": "number"
                }
            },
            "required": [
                "Items",
                "Quantity"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginGroups": {
            "additionalProperties": false,
            "properties": {
                "Items": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginGroup"
                    },
                    "type": "array"
                },
                "Quantity": {
                    "type": "number"
                }
            },
            "required": [
                "Quantity"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginShield": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "OriginShieldRegion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Restrictions": {
            "additionalProperties": false,
            "properties": {
                "GeoRestriction": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.GeoRestriction"
                }
            },
            "required": [
                "GeoRestriction"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.S3OriginConfig": {
            "additionalProperties": false,
            "properties": {
                "OriginAccessIdentity": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Distribution.StatusCodes": {
            "additionalProperties": false,
            "properties": {
                "Items": {
                    "items": {
                        "type": "number"
                    },
                    "type": "array"
                },
                "Quantity": {
                    "type": "number"
                }
            },
            "required": [
                "Items",
                "Quantity"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.ViewerCertificate": {
            "additionalProperties": false,
            "properties": {
                "AcmCertificateArn": {
                    "type": "string"
                },
                "CloudFrontDefaultCertificate": {
                    "type": "boolean"
                },
                "IamCertificateId": {
                    "type": "string"
                },
                "MinimumProtocolVersion": {
                    "type": "string"
                },
                "SslSupportMethod": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Function": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoPublish": {
                            "type": "boolean"
                        },
                        "FunctionCode": {
                            "type": "string"
                        },
                        "FunctionConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::Function.FunctionConfig"
                        },
                        "FunctionMetadata": {
                            "$ref": "#/definitions/AWS::CloudFront::Function.FunctionMetadata"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::Function"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Function.FunctionConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                },
                "Runtime": {
                    "type": "string"
                }
            },
            "required": [
                "Comment",
                "Runtime"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Function.FunctionMetadata": {
            "additionalProperties": false,
            "properties": {
                "FunctionARN": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::KeyGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "KeyGroupConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::KeyGroup.KeyGroupConfig"
                        }
                    },
                    "required": [
                        "KeyGroupConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::KeyGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::KeyGroup.KeyGroupConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                },
                "Items": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Items",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CloudFront::OriginRequestPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "OriginRequestPolicyConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::OriginRequestPolicy.OriginRequestPolicyConfig"
                        }
                    },
                    "required": [
                        "OriginRequestPolicyConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::OriginRequestPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::OriginRequestPolicy.CookiesConfig": {
            "additionalProperties": false,
            "properties": {
                "CookieBehavior": {
                    "type": "string"
                },
                "Cookies": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CookieBehavior"
            ],
            "type": "object"
        },
        "AWS::CloudFront::OriginRequestPolicy.HeadersConfig": {
            "additionalProperties": false,
            "properties": {
                "HeaderBehavior": {
                    "type": "string"
                },
                "Headers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "HeaderBehavior"
            ],
            "type": "object"
        },
        "AWS::CloudFront::OriginRequestPolicy.OriginRequestPolicyConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                },
                "CookiesConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::OriginRequestPolicy.CookiesConfig"
                },
                "HeadersConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::OriginRequestPolicy.HeadersConfig"
                },
                "Name": {
                    "type": "string"
                },
                "QueryStringsConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::OriginRequestPolicy.QueryStringsConfig"
                }
            },
            "required": [
                "CookiesConfig",
                "HeadersConfig",
                "Name",
                "QueryStringsConfig"
            ],
            "type": "object"
        },
        "AWS::CloudFront::OriginRequestPolicy.QueryStringsConfig": {
            "additionalProperties": false,
            "properties": {
                "QueryStringBehavior": {
                    "type": "string"
                },
                "QueryStrings": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "QueryStringBehavior"
            ],
            "type": "object"
        },
        "AWS::CloudFront::PublicKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PublicKeyConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::PublicKey.PublicKeyConfig"
                        }
                    },
                    "required": [
                        "PublicKeyConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::PublicKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::PublicKey.PublicKeyConfig": {
            "additionalProperties": false,
            "properties": {
                "CallerReference": {
                    "type": "string"
                },
                "Comment": {
                    "type": "string"
                },
                "EncodedKey": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "CallerReference",
                "EncodedKey",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CloudFront::RealtimeLogConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "EndPoints": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudFront::RealtimeLogConfig.EndPoint"
                            },
                            "type": "array"
                        },
                        "Fields": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "SamplingRate": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "EndPoints",
                        "Fields",
                        "Name",
                        "SamplingRate"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::RealtimeLogConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::RealtimeLogConfig.EndPoint": {
            "additionalProperties": false,
            "properties": {
                "KinesisStreamConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::RealtimeLogConfig.KinesisStreamConfig"
                },
                "StreamType": {
                    "type": "string"
                }
            },
            "required": [
                "KinesisStreamConfig",
                "StreamType"
            ],
            "type": "object"
        },
        "AWS::CloudFront::RealtimeLogConfig.KinesisStreamConfig": {
            "additionalProperties": false,
            "properties": {
                "RoleArn": {
                    "type": "string"
                },
                "StreamArn": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn",
                "StreamArn"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "StreamingDistributionConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "StreamingDistributionConfig",
                        "Tags"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::StreamingDistribution"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.Logging": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Enabled",
                "Prefix"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.S3Origin": {
            "additionalProperties": false,
            "properties": {
                "DomainName": {
                    "type": "string"
                },
                "OriginAccessIdentity": {
                    "type": "string"
                }
            },
            "required": [
                "DomainName",
                "OriginAccessIdentity"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig": {
            "additionalProperties": false,
            "properties": {
                "Aliases": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Comment": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Logging": {
                    "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.Logging"
                },
                "PriceClass": {
                    "type": "string"
                },
                "S3Origin": {
                    "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.S3Origin"
                },
                "TrustedSigners": {
                    "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.TrustedSigners"
                }
            },
            "required": [
                "Comment",
                "Enabled",
                "S3Origin",
                "TrustedSigners"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.TrustedSigners": {
            "additionalProperties": false,
            "properties": {
                "AwsAccountNumbers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::CloudTrail::Trail": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudWatchLogsLogGroupArn": {
                            "type": "string"
                        },
                        "CloudWatchLogsRoleArn": {
                            "type": "string"
                        },
                        "EnableLogFileValidation": {
                            "type": "boolean"
                        },
                        "EventSelectors": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudTrail::Trail.EventSelector"
                            },
                            "type": "array"
                        },
                        "IncludeGlobalServiceEvents": {
                            "type": "boolean"
                        },
                        "IsLogging": {
                            "type": "boolean"
                        },
                        "IsMultiRegionTrail": {
                            "type": "boolean"
                        },
                        "KMSKeyId": {
                            "type": "string"
                        },
                        "S3BucketName": {
                            "type": "string"
                        },
                        "S3KeyPrefix": {
                            "type": "string"
                        },
                        "SnsTopicName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrailName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "IsLogging",
                        "S3BucketName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudTrail::Trail"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudTrail::Trail.DataResource": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudTrail::Trail.EventSelector": {
            "additionalProperties": false,
            "properties": {
                "DataResources": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudTrail::Trail.DataResource"
                    },
                    "type": "array"
                },
                "IncludeManagementEvents": {
                    "type": "boolean"
                },
                "ReadWriteType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::Alarm": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionsEnabled": {
                            "type": "boolean"
                        },
                        "AlarmActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AlarmDescription": {
                            "type": "string"
                        },
                        "AlarmName": {
                            "type": "string"
                        },
                        "ComparisonOperator": {
                            "type": "string"
                        },
                        "DatapointsToAlarm": {
                            "type": "number"
                        },
                        "Dimensions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::Alarm.Dimension"
                            },
                            "type": "array"
                        },
                        "EvaluateLowSampleCountPercentile": {
                            "type": "string"
                        },
                        "EvaluationPeriods": {
                            "type": "number"
                        },
                        "ExtendedStatistic": {
                            "type": "string"
                        },
                        "InsufficientDataActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MetricName": {
                            "type": "string"
                        },
                        "Metrics": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::Alarm.MetricDataQuery"
                            },
                            "type": "array"
                        },
                        "Namespace": {
                            "type": "string"
                        },
                        "OKActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Period": {
                            "type": "number"
                        },
                        "Statistic": {
                            "type": "string"
                        },
                        "Threshold": {
                            "type": "number"
                        },
                        "ThresholdMetricId": {
                            "type": "string"
                        },
                        "TreatMissingData": {
                            "type": "string"
                        },
                        "Unit": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ComparisonOperator",
                        "EvaluationPeriods"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::Alarm"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.Dimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.Metric": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::Alarm.Dimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.MetricDataQuery": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Label": {
                    "type": "string"
                },
                "MetricStat": {
                    "$ref": "#/definitions/AWS::CloudWatch::Alarm.MetricStat"
                },
                "Period": {
                    "type": "number"
                },
                "ReturnData": {
                    "type": "boolean"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.MetricStat": {
            "additionalProperties": false,
            "properties": {
                "Metric": {
                    "$ref": "#/definitions/AWS::CloudWatch::Alarm.Metric"
                },
                "Period": {
                    "type": "number"
                },
                "Stat": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Metric",
                "Period",
                "Stat"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Configuration": {
                            "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Configuration"
                        },
                        "Dimensions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Dimension"
                            },
                            "type": "array"
                        },
                        "MetricName": {
                            "type": "string"
                        },
                        "Namespace": {
                            "type": "string"
                        },
                        "Stat": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MetricName",
                        "Namespace",
                        "Stat"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::AnomalyDetector"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Configuration": {
            "additionalProperties": false,
            "properties": {
                "ExcludedTimeRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Range"
                    },
                    "type": "array"
                },
                "MetricTimeZone": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Dimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Range": {
            "additionalProperties": false,
            "properties": {
                "EndTime": {
                    "type": "string"
                },
                "StartTime": {
                    "type": "string"
                }
            },
            "required": [
                "EndTime",
                "StartTime"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::CompositeAlarm": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionsEnabled": {
                            "type": "boolean"
                        },
                        "AlarmActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AlarmDescription": {
                            "type": "string"
                        },
                        "AlarmName": {
                            "type": "string"
                        },
                        "AlarmRule": {
                            "type": "string"
                        },
                        "InsufficientDataActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "OKActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AlarmName",
                        "AlarmRule"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::CompositeAlarm"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Dashboard": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DashboardBody": {
                            "type": "string"
                        },
                        "DashboardName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DashboardBody"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::Dashboard"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::InsightRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RuleBody": {
                            "type": "string"
                        },
                        "RuleName": {
                            "type": "string"
                        },
                        "RuleState": {
                            "type": "string"
                        },
                        "Tags": {
                            "$ref": "#/definitions/AWS::CloudWatch::InsightRule.Tags"
                        }
                    },
                    "required": [
                        "RuleBody",
                        "RuleName",
                        "RuleState"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::InsightRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::InsightRule.Tags": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::CloudWatch::MetricStream": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExcludeFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::MetricStream.MetricStreamFilter"
                            },
                            "type": "array"
                        },
                        "FirehoseArn": {
                            "type": "string"
                        },
                        "IncludeFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::MetricStream.MetricStreamFilter"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OutputFormat": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "FirehoseArn",
                        "OutputFormat",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::MetricStream"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::MetricStream.MetricStreamFilter": {
            "additionalProperties": false,
            "properties": {
                "Namespace": {
                    "type": "string"
                }
            },
            "required": [
                "Namespace"
            ],
            "type": "object"
        },
        "AWS::CodeArtifact::Domain": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DomainName": {
                            "type": "string"
                        },
                        "EncryptionKey": {
                            "type": "string"
                        },
                        "PermissionsPolicyDocument": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeArtifact::Domain"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeArtifact::Repository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "DomainOwner": {
                            "type": "string"
                        },
                        "ExternalConnections": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PermissionsPolicyDocument": {
                            "type": "object"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Upstreams": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DomainName",
                        "RepositoryName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeArtifact::Repository"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Artifacts": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.Artifacts"
                        },
                        "BadgeEnabled": {
                            "type": "boolean"
                        },
                        "BuildBatchConfig": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectBuildBatchConfig"
                        },
                        "Cache": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectCache"
                        },
                        "ConcurrentBuildLimit": {
                            "type": "number"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EncryptionKey": {
                            "type": "string"
                        },
                        "Environment": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.Environment"
                        },
                        "FileSystemLocations": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectFileSystemLocation"
                            },
                            "type": "array"
                        },
                        "LogsConfig": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.LogsConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "QueuedTimeoutInMinutes": {
                            "type": "number"
                        },
                        "SecondaryArtifacts": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeBuild::Project.Artifacts"
                            },
                            "type": "array"
                        },
                        "SecondarySourceVersions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectSourceVersion"
                            },
                            "type": "array"
                        },
                        "SecondarySources": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeBuild::Project.Source"
                            },
                            "type": "array"
                        },
                        "ServiceRole": {
                            "type": "string"
                        },
                        "Source": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.Source"
                        },
                        "SourceVersion": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TimeoutInMinutes": {
                            "type": "number"
                        },
                        "Triggers": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectTriggers"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.VpcConfig"
                        }
                    },
                    "required": [
                        "Artifacts",
                        "Environment",
                        "ServiceRole",
                        "Source"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeBuild::Project"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.Artifacts": {
            "additionalProperties": false,
            "properties": {
                "ArtifactIdentifier": {
                    "type": "string"
                },
                "EncryptionDisabled": {
                    "type": "boolean"
                },
                "Location": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "NamespaceType": {
                    "type": "string"
                },
                "OverrideArtifactName": {
                    "type": "boolean"
                },
                "Packaging": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.BatchRestrictions": {
            "additionalProperties": false,
            "properties": {
                "ComputeTypesAllowed": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaximumBuildsAllowed": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.BuildStatusConfig": {
            "additionalProperties": false,
            "properties": {
                "Context": {
                    "type": "string"
                },
                "TargetUrl": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.CloudWatchLogsConfig": {
            "additionalProperties": false,
            "properties": {
                "GroupName": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                },
                "StreamName": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.Environment": {
            "additionalProperties": false,
            "properties": {
                "Certificate": {
                    "type": "string"
                },
                "ComputeType": {
                    "type": "string"
                },
                "EnvironmentVariables": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeBuild::Project.EnvironmentVariable"
                    },
                    "type": "array"
                },
                "Image": {
                    "type": "string"
                },
                "ImagePullCredentialsType": {
                    "type": "string"
                },
                "PrivilegedMode": {
                    "type": "boolean"
                },
                "RegistryCredential": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.RegistryCredential"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "ComputeType",
                "Image",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.EnvironmentVariable": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.FilterGroup": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::CodeBuild::Project.GitSubmodulesConfig": {
            "additionalProperties": false,
            "properties": {
                "FetchSubmodules": {
                    "type": "boolean"
                }
            },
            "required": [
                "FetchSubmodules"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.LogsConfig": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLogs": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.CloudWatchLogsConfig"
                },
                "S3Logs": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.S3LogsConfig"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectBuildBatchConfig": {
            "additionalProperties": false,
            "properties": {
                "CombineArtifacts": {
                    "type": "boolean"
                },
                "Restrictions": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.BatchRestrictions"
                },
                "ServiceRole": {
                    "type": "string"
                },
                "TimeoutInMins": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectCache": {
            "additionalProperties": false,
            "properties": {
                "Location": {
                    "type": "string"
                },
                "Modes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectFileSystemLocation": {
            "additionalProperties": false,
            "properties": {
                "Identifier": {
                    "type": "string"
                },
                "Location": {
                    "type": "string"
                },
                "MountOptions": {
                    "type": "string"
                },
                "MountPoint": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Identifier",
                "Location",
                "MountPoint",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectSourceVersion": {
            "additionalProperties": false,
            "properties": {
                "SourceIdentifier": {
                    "type": "string"
                },
                "SourceVersion": {
                    "type": "string"
                }
            },
            "required": [
                "SourceIdentifier"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectTriggers": {
            "additionalProperties": false,
            "properties": {
                "BuildType": {
                    "type": "string"
                },
                "FilterGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeBuild::Project.FilterGroup"
                    },
                    "type": "array"
                },
                "Webhook": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.RegistryCredential": {
            "additionalProperties": false,
            "properties": {
                "Credential": {
                    "type": "string"
                },
                "CredentialProvider": {
                    "type": "string"
                }
            },
            "required": [
                "Credential",
                "CredentialProvider"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.S3LogsConfig": {
            "additionalProperties": false,
            "properties": {
                "EncryptionDisabled": {
                    "type": "boolean"
                },
                "Location": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.Source": {
            "additionalProperties": false,
            "properties": {
                "Auth": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.SourceAuth"
                },
                "BuildSpec": {
                    "type": "string"
                },
                "BuildStatusConfig": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.BuildStatusConfig"
                },
                "GitCloneDepth": {
                    "type": "number"
                },
                "GitSubmodulesConfig": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.GitSubmodulesConfig"
                },
                "InsecureSsl": {
                    "type": "boolean"
                },
                "Location": {
                    "type": "string"
                },
                "ReportBuildStatus": {
                    "type": "boolean"
                },
                "SourceIdentifier": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.SourceAuth": {
            "additionalProperties": false,
            "properties": {
                "Resource": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Subnets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "VpcId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.WebhookFilter": {
            "additionalProperties": false,
            "properties": {
                "ExcludeMatchedPattern": {
                    "type": "boolean"
                },
                "Pattern": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Pattern",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::ReportGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeleteReports": {
                            "type": "boolean"
                        },
                        "ExportConfig": {
                            "$ref": "#/definitions/AWS::CodeBuild::ReportGroup.ReportExportConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ExportConfig",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeBuild::ReportGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::ReportGroup.ReportExportConfig": {
            "additionalProperties": false,
            "properties": {
                "ExportConfigType": {
                    "type": "string"
                },
                "S3Destination": {
                    "$ref": "#/definitions/AWS::CodeBuild::ReportGroup.S3ReportExportConfig"
                }
            },
            "required": [
                "ExportConfigType"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::ReportGroup.S3ReportExportConfig": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "BucketOwner": {
                    "type": "string"
                },
                "EncryptionDisabled": {
                    "type": "boolean"
                },
                "EncryptionKey": {
                    "type": "string"
                },
                "Packaging": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::SourceCredential": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthType": {
                            "type": "string"
                        },
                        "ServerType": {
                            "type": "string"
                        },
                        "Token": {
                            "type": "string"
                        },
                        "Username": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthType",
                        "ServerType",
                        "Token"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeBuild::SourceCredential"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeCommit::Repository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Code": {
                            "$ref": "#/definitions/AWS::CodeCommit::Repository.Code"
                        },
                        "RepositoryDescription": {
                            "type": "string"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Triggers": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeCommit::Repository.RepositoryTrigger"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "RepositoryName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeCommit::Repository"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeCommit::Repository.Code": {
            "additionalProperties": false,
            "properties": {
                "BranchName": {
                    "type": "string"
                },
                "S3": {
                    "$ref": "#/definitions/AWS::CodeCommit::Repository.S3"
                }
            },
            "required": [
                "S3"
            ],
            "type": "object"
        },
        "AWS::CodeCommit::Repository.RepositoryTrigger": {
            "additionalProperties": false,
            "properties": {
                "Branches": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CustomData": {
                    "type": "string"
                },
                "DestinationArn": {
                    "type": "string"
                },
                "Events": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "DestinationArn",
                "Events",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodeCommit::Repository.S3": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "ObjectVersion": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Key"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "ComputePlatform": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeDeploy::Application"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeploymentConfigName": {
                            "type": "string"
                        },
                        "MinimumHealthyHosts": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentConfig.MinimumHealthyHosts"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeDeploy::DeploymentConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentConfig.MinimumHealthyHosts": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "number"
                }
            },
            "required": [
                "Type",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AlarmConfiguration": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration"
                        },
                        "ApplicationName": {
                            "type": "string"
                        },
                        "AutoRollbackConfiguration": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration"
                        },
                        "AutoScalingGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Deployment": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.Deployment"
                        },
                        "DeploymentConfigName": {
                            "type": "string"
                        },
                        "DeploymentGroupName": {
                            "type": "string"
                        },
                        "DeploymentStyle": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.DeploymentStyle"
                        },
                        "Ec2TagFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagFilter"
                            },
                            "type": "array"
                        },
                        "Ec2TagSet": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagSet"
                        },
                        "LoadBalancerInfo": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo"
                        },
                        "OnPremisesInstanceTagFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TagFilter"
                            },
                            "type": "array"
                        },
                        "OnPremisesTagSet": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet"
                        },
                        "ServiceRoleArn": {
                            "type": "string"
                        },
                        "TriggerConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TriggerConfig"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "ServiceRoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeDeploy::DeploymentGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.Alarm": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Alarms": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.Alarm"
                    },
                    "type": "array"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "IgnorePollAlarmFailure": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "Events": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.Deployment": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "IgnoreApplicationStopFailures": {
                    "type": "boolean"
                },
                "Revision": {
                    "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.RevisionLocation"
                }
            },
            "required": [
                "Revision"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.DeploymentStyle": {
            "additionalProperties": false,
            "properties": {
                "DeploymentOption": {
                    "type": "string"
                },
                "DeploymentType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.EC2TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.EC2TagSet": {
            "additionalProperties": false,
            "properties": {
                "Ec2TagSetList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagSetListObject"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.EC2TagSetListObject": {
            "additionalProperties": false,
            "properties": {
                "Ec2TagGroup": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.ELBInfo": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.GitHubLocation": {
            "additionalProperties": false,
            "properties": {
                "CommitId": {
                    "type": "string"
                },
                "Repository": {
                    "type": "string"
                }
            },
            "required": [
                "CommitId",
                "Repository"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo": {
            "additionalProperties": false,
            "properties": {
                "ElbInfoList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.ELBInfo"
                    },
                    "type": "array"
                },
                "TargetGroupInfoList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TargetGroupInfo"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet": {
            "additionalProperties": false,
            "properties": {
                "OnPremisesTagSetList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSetListObject"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSetListObject": {
            "additionalProperties": false,
            "properties": {
                "OnPremisesTagGroup": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.RevisionLocation": {
            "additionalProperties": false,
            "properties": {
                "GitHubLocation": {
                    "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.GitHubLocation"
                },
                "RevisionType": {
                    "type": "string"
                },
                "S3Location": {
                    "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "BundleType": {
                    "type": "string"
                },
                "ETag": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Key"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.TargetGroupInfo": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.TriggerConfig": {
            "additionalProperties": false,
            "properties": {
                "TriggerEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TriggerName": {
                    "type": "string"
                },
                "TriggerTargetArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeGuruProfiler::ProfilingGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AgentPermissions": {
                            "type": "object"
                        },
                        "AnomalyDetectionNotificationConfiguration": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeGuruProfiler::ProfilingGroup.Channel"
                            },
                            "type": "array"
                        },
                        "ComputePlatform": {
                            "type": "string"
                        },
                        "ProfilingGroupName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ProfilingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeGuruProfiler::ProfilingGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeGuruProfiler::ProfilingGroup.Channel": {
            "additionalProperties": false,
            "properties": {
                "channelId": {
                    "type": "string"
                },
                "channelUri": {
                    "type": "string"
                }
            },
            "required": [
                "channelUri"
            ],
            "type": "object"
        },
        "AWS::CodeGuruReviewer::RepositoryAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionArn": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Owner": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeGuruReviewer::RepositoryAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Category": {
                            "type": "string"
                        },
                        "ConfigurationProperties": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.ConfigurationProperties"
                            },
                            "type": "array"
                        },
                        "InputArtifactDetails": {
                            "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.ArtifactDetails"
                        },
                        "OutputArtifactDetails": {
                            "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.ArtifactDetails"
                        },
                        "Provider": {
                            "type": "string"
                        },
                        "Settings": {
                            "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.Settings"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Category",
                        "InputArtifactDetails",
                        "OutputArtifactDetails",
                        "Provider",
                        "Version"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodePipeline::CustomActionType"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType.ArtifactDetails": {
            "additionalProperties": false,
            "properties": {
                "MaximumCount": {
                    "type": "number"
                },
                "MinimumCount": {
                    "type": "number"
                }
            },
            "required": [
                "MaximumCount",
                "MinimumCount"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType.ConfigurationProperties": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "Key": {
                    "type": "boolean"
                },
                "Name": {
                    "type": "string"
                },
                "Queryable": {
                    "type": "boolean"
                },
                "Required": {
                    "type": "boolean"
                },
                "Secret": {
                    "type": "boolean"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Name",
                "Required",
                "Secret"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType.Settings": {
            "additionalProperties": false,
            "properties": {
                "EntityUrlTemplate": {
                    "type": "string"
                },
                "ExecutionUrlTemplate": {
                    "type": "string"
                },
                "RevisionUrlTemplate": {
                    "type": "string"
                },
                "ThirdPartyConfigurationUrl": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ArtifactStore": {
                            "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ArtifactStore"
                        },
                        "ArtifactStores": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ArtifactStoreMap"
                            },
                            "type": "array"
                        },
                        "DisableInboundStageTransitions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Pipeline.StageTransition"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RestartExecutionOnUpdate": {
                            "type": "boolean"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Stages": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Pipeline.StageDeclaration"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "RoleArn",
                        "Stages"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodePipeline::Pipeline"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ActionDeclaration": {
            "additionalProperties": false,
            "properties": {
                "ActionTypeId": {
                    "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ActionTypeId"
                },
                "Configuration": {
                    "type": "object"
                },
                "InputArtifacts": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.InputArtifact"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "OutputArtifacts": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.OutputArtifact"
                    },
                    "type": "array"
                },
                "Region": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "RunOrder": {
                    "type": "number"
                }
            },
            "required": [
                "ActionTypeId",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ActionTypeId": {
            "additionalProperties": false,
            "properties": {
                "Category": {
                    "type": "string"
                },
                "Owner": {
                    "type": "string"
                },
                "Provider": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Category",
                "Owner",
                "Provider",
                "Version"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ArtifactStore": {
            "additionalProperties": false,
            "properties": {
                "EncryptionKey": {
                    "$ref": "#/definitions/AWS::CodePipeline::Pipeline.EncryptionKey"
                },
                "Location": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Location",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ArtifactStoreMap": {
            "additionalProperties": false,
            "properties": {
                "ArtifactStore": {
                    "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ArtifactStore"
                },
                "Region": {
                    "type": "string"
                }
            },
            "required": [
                "ArtifactStore",
                "Region"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.BlockerDeclaration": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.EncryptionKey": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Id",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.InputArtifact": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.OutputArtifact": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.StageDeclaration": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ActionDeclaration"
                    },
                    "type": "array"
                },
                "Blockers": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.BlockerDeclaration"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Actions",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.StageTransition": {
            "additionalProperties": false,
            "properties": {
                "Reason": {
                    "type": "string"
                },
                "StageName": {
                    "type": "string"
                }
            },
            "required": [
                "Reason",
                "StageName"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Webhook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Authentication": {
                            "type": "string"
                        },
                        "AuthenticationConfiguration": {
                            "$ref": "#/definitions/AWS::CodePipeline::Webhook.WebhookAuthConfiguration"
                        },
                        "Filters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Webhook.WebhookFilterRule"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RegisterWithThirdParty": {
                            "type": "boolean"
                        },
                        "TargetAction": {
                            "type": "string"
                        },
                        "TargetPipeline": {
                            "type": "string"
                        },
                        "TargetPipelineVersion": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Authentication",
                        "AuthenticationConfiguration",
                        "Filters",
                        "TargetAction",
                        "TargetPipeline",
                        "TargetPipelineVersion"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodePipeline::Webhook"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Webhook.WebhookAuthConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AllowedIPRange": {
                    "type": "string"
                },
                "SecretToken": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodePipeline::Webhook.WebhookFilterRule": {
            "additionalProperties": false,
            "properties": {
                "JsonPath": {
                    "type": "string"
                },
                "MatchEquals": {
                    "type": "string"
                }
            },
            "required": [
                "JsonPath"
            ],
            "type": "object"
        },
        "AWS::CodeStar::GitHubRepository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Code": {
                            "$ref": "#/definitions/AWS::CodeStar::GitHubRepository.Code"
                        },
                        "ConnectionArn": {
                            "type": "string"
                        },
                        "EnableIssues": {
                            "type": "boolean"
                        },
                        "IsPrivate": {
                            "type": "boolean"
                        },
                        "RepositoryAccessToken": {
                            "type": "string"
                        },
                        "RepositoryDescription": {
                            "type": "string"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "RepositoryOwner": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RepositoryName",
                        "RepositoryOwner"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeStar::GitHubRepository"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeStar::GitHubRepository.Code": {
            "additionalProperties": false,
            "properties": {
                "S3": {
                    "$ref": "#/definitions/AWS::CodeStar::GitHubRepository.S3"
                }
            },
            "required": [
                "S3"
            ],
            "type": "object"
        },
        "AWS::CodeStar::GitHubRepository.S3": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "ObjectVersion": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Key"
            ],
            "type": "object"
        },
        "AWS::CodeStarConnections::Connection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionName": {
                            "type": "string"
                        },
                        "HostArn": {
                            "type": "string"
                        },
                        "ProviderType": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ConnectionName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeStarConnections::Connection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeStarNotifications::NotificationRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DetailType": {
                            "type": "string"
                        },
                        "EventTypeIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Resource": {
                            "type": "string"
                        },
                        "Status": {
                            "type": "string"
                        },
                        "Tags": {
                            "type": "object"
                        },
                        "Targets": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeStarNotifications::NotificationRule.Target"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DetailType",
                        "EventTypeIds",
                        "Name",
                        "Resource",
                        "Targets"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeStarNotifications::NotificationRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeStarNotifications::NotificationRule.Target": {
            "additionalProperties": false,
            "properties": {
                "TargetAddress": {
                    "type": "string"
                },
                "TargetType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllowClassicFlow": {
                            "type": "boolean"
                        },
                        "AllowUnauthenticatedIdentities": {
                            "type": "boolean"
                        },
                        "CognitoEvents": {
                            "type": "object"
                        },
                        "CognitoIdentityProviders": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::IdentityPool.CognitoIdentityProvider"
                            },
                            "type": "array"
                        },
                        "CognitoStreams": {
                            "$ref": "#/definitions/AWS::Cognito::IdentityPool.CognitoStreams"
                        },
                        "DeveloperProviderName": {
                            "type": "string"
                        },
                        "IdentityPoolName": {
                            "type": "string"
                        },
                        "OpenIdConnectProviderARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PushSync": {
                            "$ref": "#/definitions/AWS::Cognito::IdentityPool.PushSync"
                        },
                        "SamlProviderARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SupportedLoginProviders": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "AllowUnauthenticatedIdentities"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::IdentityPool"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPool.CognitoIdentityProvider": {
            "additionalProperties": false,
            "properties": {
                "ClientId": {
                    "type": "string"
                },
                "ProviderName": {
                    "type": "string"
                },
                "ServerSideTokenCheck": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPool.CognitoStreams": {
            "additionalProperties": false,
            "properties": {
                "RoleArn": {
                    "type": "string"
                },
                "StreamName": {
                    "type": "string"
                },
                "StreamingStatus": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPool.PushSync": {
            "additionalProperties": false,
            "properties": {
                "ApplicationArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "IdentityPoolId": {
                            "type": "string"
                        },
                        "RoleMappings": {
                            "type": "object"
                        },
                        "Roles": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "IdentityPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::IdentityPoolRoleAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment.MappingRule": {
            "additionalProperties": false,
            "properties": {
                "Claim": {
                    "type": "string"
                },
                "MatchType": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Claim",
                "MatchType",
                "RoleARN",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment.RoleMapping": {
            "additionalProperties": false,
            "properties": {
                "AmbiguousRoleResolution": {
                    "type": "string"
                },
                "IdentityProvider": {
                    "type": "string"
                },
                "RulesConfiguration": {
                    "$ref": "#/definitions/AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType": {
            "additionalProperties": false,
            "properties": {
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::Cognito::IdentityPoolRoleAttachment.MappingRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Rules"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccountRecoverySetting": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.AccountRecoverySetting"
                        },
                        "AdminCreateUserConfig": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.AdminCreateUserConfig"
                        },
                        "AliasAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AutoVerifiedAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DeviceConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.DeviceConfiguration"
                        },
                        "EmailConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.EmailConfiguration"
                        },
                        "EmailVerificationMessage": {
                            "type": "string"
                        },
                        "EmailVerificationSubject": {
                            "type": "string"
                        },
                        "EnabledMfas": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "LambdaConfig": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.LambdaConfig"
                        },
                        "MfaConfiguration": {
                            "type": "string"
                        },
                        "Policies": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.Policies"
                        },
                        "Schema": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPool.SchemaAttribute"
                            },
                            "type": "array"
                        },
                        "SmsAuthenticationMessage": {
                            "type": "string"
                        },
                        "SmsConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.SmsConfiguration"
                        },
                        "SmsVerificationMessage": {
                            "type": "string"
                        },
                        "UserPoolAddOns": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.UserPoolAddOns"
                        },
                        "UserPoolName": {
                            "type": "string"
                        },
                        "UserPoolTags": {
                            "type": "object"
                        },
                        "UsernameAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "UsernameConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.UsernameConfiguration"
                        },
                        "VerificationMessageTemplate": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.VerificationMessageTemplate"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPool"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPool.AccountRecoverySetting": {
            "additionalProperties": false,
            "properties": {
                "RecoveryMechanisms": {
                    "items": {
                        "$ref": "#/definitions/AWS::Cognito::UserPool.RecoveryOption"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.AdminCreateUserConfig": {
            "additionalProperties": false,
            "properties": {
                "AllowAdminCreateUserOnly": {
                    "type": "boolean"
                },
                "InviteMessageTemplate": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.InviteMessageTemplate"
                },
                "UnusedAccountValidityDays": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.CustomEmailSender": {
            "additionalProperties": false,
            "properties": {
                "LambdaArn": {
                    "type": "string"
                },
                "LambdaVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.CustomSMSSender": {
            "additionalProperties": false,
            "properties": {
                "LambdaArn": {
                    "type": "string"
                },
                "LambdaVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.DeviceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ChallengeRequiredOnNewDevice": {
                    "type": "boolean"
                },
                "DeviceOnlyRememberedOnUserPrompt": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.EmailConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ConfigurationSet": {
                    "type": "string"
                },
                "EmailSendingAccount": {
                    "type": "string"
                },
                "From": {
                    "type": "string"
                },
                "ReplyToEmailAddress": {
                    "type": "string"
                },
                "SourceArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.InviteMessageTemplate": {
            "additionalProperties": false,
            "properties": {
                "EmailMessage": {
                    "type": "string"
                },
                "EmailSubject": {
                    "type": "string"
                },
                "SMSMessage": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.LambdaConfig": {
            "additionalProperties": false,
            "properties": {
                "CreateAuthChallenge": {
                    "type": "string"
                },
                "CustomEmailSender": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.CustomEmailSender"
                },
                "CustomMessage": {
                    "type": "string"
                },
                "CustomSMSSender": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.CustomSMSSender"
                },
                "DefineAuthChallenge": {
                    "type": "string"
                },
                "KMSKeyID": {
                    "type": "string"
                },
                "PostAuthentication": {
                    "type": "string"
                },
                "PostConfirmation": {
                    "type": "string"
                },
                "PreAuthentication": {
                    "type": "string"
                },
                "PreSignUp": {
                    "type": "string"
                },
                "PreTokenGeneration": {
                    "type": "string"
                },
                "UserMigration": {
                    "type": "string"
                },
                "VerifyAuthChallengeResponse": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.NumberAttributeConstraints": {
            "additionalProperties": false,
            "properties": {
                "MaxValue": {
                    "type": "string"
                },
                "MinValue": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.PasswordPolicy": {
            "additionalProperties": false,
            "properties": {
                "MinimumLength": {
                    "type": "number"
                },
                "RequireLowercase": {
                    "type": "boolean"
                },
                "RequireNumbers": {
                    "type": "boolean"
                },
                "RequireSymbols": {
                    "type": "boolean"
                },
                "RequireUppercase": {
                    "type": "boolean"
                },
                "TemporaryPasswordValidityDays": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.Policies": {
            "additionalProperties": false,
            "properties": {
                "PasswordPolicy": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.PasswordPolicy"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.RecoveryOption": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Priority": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.SchemaAttribute": {
            "additionalProperties": false,
            "properties": {
                "AttributeDataType": {
                    "type": "string"
                },
                "DeveloperOnlyAttribute": {
                    "type": "boolean"
                },
                "Mutable": {
                    "type": "boolean"
                },
                "Name": {
                    "type": "string"
                },
                "NumberAttributeConstraints": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.NumberAttributeConstraints"
                },
                "Required": {
                    "type": "boolean"
                },
                "StringAttributeConstraints": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.StringAttributeConstraints"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.SmsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ExternalId": {
                    "type": "string"
                },
                "SnsCallerArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.StringAttributeConstraints": {
            "additionalProperties": false,
            "properties": {
                "MaxLength": {
                    "type": "string"
                },
                "MinLength": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.UserPoolAddOns": {
            "additionalProperties": false,
            "properties": {
                "AdvancedSecurityMode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.UsernameConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CaseSensitive": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.VerificationMessageTemplate": {
            "additionalProperties": false,
            "properties": {
                "DefaultEmailOption": {
                    "type": "string"
                },
                "EmailMessage": {
                    "type": "string"
                },
                "EmailMessageByLink": {
                    "type": "string"
                },
                "EmailSubject": {
                    "type": "string"
                },
                "EmailSubjectByLink": {
                    "type": "string"
                },
                "SmsMessage": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolClient": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessTokenValidity": {
                            "type": "number"
                        },
                        "AllowedOAuthFlows": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AllowedOAuthFlowsUserPoolClient": {
                            "type": "boolean"
                        },
                        "AllowedOAuthScopes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AnalyticsConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPoolClient.AnalyticsConfiguration"
                        },
                        "CallbackURLs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ClientName": {
                            "type": "string"
                        },
                        "DefaultRedirectURI": {
                            "type": "string"
                        },
                        "ExplicitAuthFlows": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "GenerateSecret": {
                            "type": "boolean"
                        },
                        "IdTokenValidity": {
                            "type": "number"
                        },
                        "LogoutURLs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PreventUserExistenceErrors": {
                            "type": "string"
                        },
                        "ReadAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "RefreshTokenValidity": {
                            "type": "number"
                        },
                        "SupportedIdentityProviders": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TokenValidityUnits": {
                            "$ref": "#/definitions/AWS::Cognito::UserPoolClient.TokenValidityUnits"
                        },
                        "UserPoolId": {
                            "type": "string"
                        },
                        "WriteAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolClient"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolClient.AnalyticsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ApplicationArn": {
                    "type": "string"
                },
                "ApplicationId": {
                    "type": "string"
                },
                "ExternalId": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "UserDataShared": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolClient.TokenValidityUnits": {
            "additionalProperties": false,
            "properties": {
                "AccessToken": {
                    "type": "string"
                },
                "IdToken": {
                    "type": "string"
                },
                "RefreshToken": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolDomain": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CustomDomainConfig": {
                            "$ref": "#/definitions/AWS::Cognito::UserPoolDomain.CustomDomainConfigType"
                        },
                        "Domain": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Domain",
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolDomain"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolDomain.CustomDomainConfigType": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "GroupName": {
                            "type": "string"
                        },
                        "Precedence": {
                            "type": "number"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolIdentityProvider": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AttributeMapping": {
                            "type": "object"
                        },
                        "IdpIdentifiers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ProviderDetails": {
                            "type": "object"
                        },
                        "ProviderName": {
                            "type": "string"
                        },
                        "ProviderType": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ProviderName",
                        "ProviderType",
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolIdentityProvider"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolResourceServer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Identifier": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Scopes": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPoolResourceServer.ResourceServerScopeType"
                            },
                            "type": "array"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Identifier",
                        "Name",
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolResourceServer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolResourceServer.ResourceServerScopeType": {
            "additionalProperties": false,
            "properties": {
                "ScopeDescription": {
                    "type": "string"
                },
                "ScopeName": {
                    "type": "string"
                }
            },
            "required": [
                "ScopeDescription",
                "ScopeName"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccountTakeoverRiskConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationType"
                        },
                        "ClientId": {
                            "type": "string"
                        },
                        "CompromisedCredentialsRiskConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationType"
                        },
                        "RiskExceptionConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfigurationType"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClientId",
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolRiskConfigurationAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType": {
            "additionalProperties": false,
            "properties": {
                "EventAction": {
                    "type": "string"
                },
                "Notify": {
                    "type": "boolean"
                }
            },
            "required": [
                "EventAction",
                "Notify"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionsType": {
            "additionalProperties": false,
            "properties": {
                "HighAction": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType"
                },
                "LowAction": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType"
                },
                "MediumAction": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationType": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionsType"
                },
                "NotifyConfiguration": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyConfigurationType"
                }
            },
            "required": [
                "Actions"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsType": {
            "additionalProperties": false,
            "properties": {
                "EventAction": {
                    "type": "string"
                }
            },
            "required": [
                "EventAction"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationType": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsType"
                },
                "EventFilter": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Actions"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyConfigurationType": {
            "additionalProperties": false,
            "properties": {
                "BlockEmail": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType"
                },
                "From": {
                    "type": "string"
                },
                "MfaEmail": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType"
                },
                "NoActionEmail": {
                    "$ref": "#/definitions/AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType"
                },
                "ReplyTo": {
                    "type": "string"
                },
                "SourceArn": {
                    "type": "string"
                }
            },
            "required": [
                "SourceArn"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType": {
            "additionalProperties": false,
            "properties": {
                "HtmlBody": {
                    "type": "string"
                },
                "Subject": {
                    "type": "string"
                },
                "TextBody": {
                    "type": "string"
                }
            },
            "required": [
                "Subject"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfigurationType": {
            "additionalProperties": false,
            "properties": {
                "BlockedIPRangeList": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SkippedIPRangeList": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolUICustomizationAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CSS": {
                            "type": "string"
                        },
                        "ClientId": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClientId",
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolUICustomizationAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolUser": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClientMetadata": {
                            "type": "object"
                        },
                        "DesiredDeliveryMediums": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ForceAliasCreation": {
                            "type": "boolean"
                        },
                        "MessageAction": {
                            "type": "string"
                        },
                        "UserAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPoolUser.AttributeType"
                            },
                            "type": "array"
                        },
                        "UserPoolId": {
                            "type": "string"
                        },
                        "Username": {
                            "type": "string"
                        },
                        "ValidationData": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPoolUser.AttributeType"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolUser"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolUser.AttributeType": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolUserToGroupAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        },
                        "Username": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupName",
                        "UserPoolId",
                        "Username"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolUserToGroupAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::AggregationAuthorization": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthorizedAccountId": {
                            "type": "string"
                        },
                        "AuthorizedAwsRegion": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AuthorizedAccountId",
                        "AuthorizedAwsRegion"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::AggregationAuthorization"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConfigRuleName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "InputParameters": {
                            "type": "object"
                        },
                        "MaximumExecutionFrequency": {
                            "type": "string"
                        },
                        "Scope": {
                            "$ref": "#/definitions/AWS::Config::ConfigRule.Scope"
                        },
                        "Source": {
                            "$ref": "#/definitions/AWS::Config::ConfigRule.Source"
                        }
                    },
                    "required": [
                        "Source"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConfigRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigRule.Scope": {
            "additionalProperties": false,
            "properties": {
                "ComplianceResourceId": {
                    "type": "string"
                },
                "ComplianceResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TagKey": {
                    "type": "string"
                },
                "TagValue": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Config::ConfigRule.Source": {
            "additionalProperties": false,
            "properties": {
                "Owner": {
                    "type": "string"
                },
                "SourceDetails": {
                    "items": {
                        "$ref": "#/definitions/AWS::Config::ConfigRule.SourceDetail"
                    },
                    "type": "array"
                },
                "SourceIdentifier": {
                    "type": "string"
                }
            },
            "required": [
                "Owner",
                "SourceIdentifier"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigRule.SourceDetail": {
            "additionalProperties": false,
            "properties": {
                "EventSource": {
                    "type": "string"
                },
                "MaximumExecutionFrequency": {
                    "type": "string"
                },
                "MessageType": {
                    "type": "string"
                }
            },
            "required": [
                "EventSource",
                "MessageType"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationAggregator": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccountAggregationSources": {
                            "items": {
                                "$ref": "#/definitions/AWS::Config::ConfigurationAggregator.AccountAggregationSource"
                            },
                            "type": "array"
                        },
                        "ConfigurationAggregatorName": {
                            "type": "string"
                        },
                        "OrganizationAggregationSource": {
                            "$ref": "#/definitions/AWS::Config::ConfigurationAggregator.OrganizationAggregationSource"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConfigurationAggregator"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationAggregator.AccountAggregationSource": {
            "additionalProperties": false,
            "properties": {
                "AccountIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllAwsRegions": {
                    "type": "boolean"
                },
                "AwsRegions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "AccountIds"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationAggregator.OrganizationAggregationSource": {
            "additionalProperties": false,
            "properties": {
                "AllAwsRegions": {
                    "type": "boolean"
                },
                "AwsRegions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationRecorder": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "RecordingGroup": {
                            "$ref": "#/definitions/AWS::Config::ConfigurationRecorder.RecordingGroup"
                        },
                        "RoleARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RoleARN"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConfigurationRecorder"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationRecorder.RecordingGroup": {
            "additionalProperties": false,
            "properties": {
                "AllSupported": {
                    "type": "boolean"
                },
                "IncludeGlobalResourceTypes": {
                    "type": "boolean"
                },
                "ResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Config::ConformancePack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConformancePackInputParameters": {
                            "items": {
                                "$ref": "#/definitions/AWS::Config::ConformancePack.ConformancePackInputParameter"
                            },
                            "type": "array"
                        },
                        "ConformancePackName": {
                            "type": "string"
                        },
                        "DeliveryS3Bucket": {
                            "type": "string"
                        },
                        "DeliveryS3KeyPrefix": {
                            "type": "string"
                        },
                        "TemplateBody": {
                            "type": "string"
                        },
                        "TemplateS3Uri": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConformancePackName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConformancePack"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConformancePack.ConformancePackInputParameter": {
            "additionalProperties": false,
            "properties": {
                "ParameterName": {
                    "type": "string"
                },
                "ParameterValue": {
                    "type": "string"
                }
            },
            "required": [
                "ParameterName",
                "ParameterValue"
            ],
            "type": "object"
        },
        "AWS::Config::DeliveryChannel": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConfigSnapshotDeliveryProperties": {
                            "$ref": "#/definitions/AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "S3BucketName": {
                            "type": "string"
                        },
                        "S3KeyPrefix": {
                            "type": "string"
                        },
                        "S3KmsKeyArn": {
                            "type": "string"
                        },
                        "SnsTopicARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "S3BucketName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::DeliveryChannel"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties": {
            "additionalProperties": false,
            "properties": {
                "DeliveryFrequency": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Config::OrganizationConfigRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExcludedAccounts": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "OrganizationConfigRuleName": {
                            "type": "string"
                        },
                        "OrganizationCustomRuleMetadata": {
                            "$ref": "#/definitions/AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata"
                        },
                        "OrganizationManagedRuleMetadata": {
                            "$ref": "#/definitions/AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata"
                        }
                    },
                    "required": [
                        "OrganizationConfigRuleName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::OrganizationConfigRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "InputParameters": {
                    "type": "string"
                },
                "LambdaFunctionArn": {
                    "type": "string"
                },
                "MaximumExecutionFrequency": {
                    "type": "string"
                },
                "OrganizationConfigRuleTriggerTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ResourceIdScope": {
                    "type": "string"
                },
                "ResourceTypesScope": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TagKeyScope": {
                    "type": "string"
                },
                "TagValueScope": {
                    "type": "string"
                }
            },
            "required": [
                "LambdaFunctionArn",
                "OrganizationConfigRuleTriggerTypes"
            ],
            "type": "object"
        },
        "AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "InputParameters": {
                    "type": "string"
                },
                "MaximumExecutionFrequency": {
                    "type": "string"
                },
                "ResourceIdScope": {
                    "type": "string"
                },
                "ResourceTypesScope": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RuleIdentifier": {
                    "type": "string"
                },
                "TagKeyScope": {
                    "type": "string"
                },
                "TagValueScope": {
                    "type": "string"
                }
            },
            "required": [
                "RuleIdentifier"
            ],
            "type": "object"
        },
        "AWS::Config::OrganizationConformancePack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConformancePackInputParameters": {
                            "items": {
                                "$ref": "#/definitions/AWS::Config::OrganizationConformancePack.ConformancePackInputParameter"
                            },
                            "type": "array"
                        },
                        "DeliveryS3Bucket": {
                            "type": "string"
                        },
                        "DeliveryS3KeyPrefix": {
                            "type": "string"
                        },
                        "ExcludedAccounts": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "OrganizationConformancePackName": {
                            "type": "string"
                        },
                        "TemplateBody": {
                            "type": "string"
                        },
                        "TemplateS3Uri": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "OrganizationConformancePackName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::OrganizationConformancePack"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::OrganizationConformancePack.ConformancePackInputParameter": {
            "additionalProperties": false,
            "properties": {
                "ParameterName": {
                    "type": "string"
                },
                "ParameterValue": {
                    "type": "string"
                }
            },
            "required": [
                "ParameterName",
                "ParameterValue"
            ],
            "type": "object"
        },
        "AWS::Config::RemediationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Automatic": {
                            "type": "boolean"
                        },
                        "ConfigRuleName": {
                            "type": "string"
                        },
                        "ExecutionControls": {
                            "$ref": "#/definitions/AWS::Config::RemediationConfiguration.ExecutionControls"
                        },
                        "MaximumAutomaticAttempts": {
                            "type": "number"
                        },
                        "Parameters": {
                            "type": "object"
                        },
                        "ResourceType": {
                            "type": "string"
                        },
                        "RetryAttemptSeconds": {
                            "type": "number"
                        },
                        "TargetId": {
                            "type": "string"
                        },
                        "TargetType": {
                            "type": "string"
                        },
                        "TargetVersion": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConfigRuleName",
                        "TargetId",
                        "TargetType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::RemediationConfiguration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::RemediationConfiguration.ExecutionControls": {
            "additionalProperties": false,
            "properties": {
                "SsmControls": {
                    "$ref": "#/definitions/AWS::Config::RemediationConfiguration.SsmControls"
                }
            },
            "type": "object"
        },
        "AWS::Config::RemediationConfiguration.RemediationParameterValue": {
            "additionalProperties": false,
            "properties": {
                "ResourceValue": {
                    "$ref": "#/definitions/AWS::Config::RemediationConfiguration.ResourceValue"
                },
                "StaticValue": {
                    "$ref": "#/definitions/AWS::Config::RemediationConfiguration.StaticValue"
                }
            },
            "type": "object"
        },
        "AWS::Config::RemediationConfiguration.ResourceValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Config::RemediationConfiguration.SsmControls": {
            "additionalProperties": false,
            "properties": {
                "ConcurrentExecutionRatePercentage": {
                    "type": "number"
                },
                "ErrorPercentage": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Config::RemediationConfiguration.StaticValue": {
            "additionalProperties": false,
            "properties": {
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Config::StoredQuery": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "QueryDescription": {
                            "type": "string"
                        },
                        "QueryExpression": {
                            "type": "string"
                        },
                        "QueryName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "QueryExpression",
                        "QueryName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::StoredQuery"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Domain": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeadLetterQueueUrl": {
                            "type": "string"
                        },
                        "DefaultEncryptionKey": {
                            "type": "string"
                        },
                        "DefaultExpirationDays": {
                            "type": "number"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CustomerProfiles::Domain"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DomainName": {
                            "type": "string"
                        },
                        "FlowDefinition": {
                            "$ref": "#/definitions/AWS::CustomerProfiles::Integration.FlowDefinition"
                        },
                        "ObjectTypeName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Uri": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName",
                        "ObjectTypeName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CustomerProfiles::Integration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.ConnectorOperator": {
            "additionalProperties": false,
            "properties": {
                "Marketo": {
                    "type": "string"
                },
                "S3": {
                    "type": "string"
                },
                "Salesforce": {
                    "type": "string"
                },
                "ServiceNow": {
                    "type": "string"
                },
                "Zendesk": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.FlowDefinition": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "FlowName": {
                    "type": "string"
                },
                "KmsArn": {
                    "type": "string"
                },
                "SourceFlowConfig": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.SourceFlowConfig"
                },
                "Tasks": {
                    "items": {
                        "$ref": "#/definitions/AWS::CustomerProfiles::Integration.Task"
                    },
                    "type": "array"
                },
                "TriggerConfig": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.TriggerConfig"
                }
            },
            "required": [
                "FlowName",
                "KmsArn",
                "SourceFlowConfig",
                "Tasks",
                "TriggerConfig"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.IncrementalPullConfig": {
            "additionalProperties": false,
            "properties": {
                "DatetimeTypeFieldName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.MarketoSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.S3SourceProperties": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketPrefix": {
                    "type": "string"
                }
            },
            "required": [
                "BucketName"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.SalesforceSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "EnableDynamicFieldUpdate": {
                    "type": "boolean"
                },
                "IncludeDeletedRecords": {
                    "type": "boolean"
                },
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.ScheduledTriggerProperties": {
            "additionalProperties": false,
            "properties": {
                "DataPullMode": {
                    "type": "string"
                },
                "FirstExecutionFrom": {
                    "type": "number"
                },
                "ScheduleEndTime": {
                    "type": "number"
                },
                "ScheduleExpression": {
                    "type": "string"
                },
                "ScheduleOffset": {
                    "type": "number"
                },
                "ScheduleStartTime": {
                    "type": "number"
                },
                "Timezone": {
                    "type": "string"
                }
            },
            "required": [
                "ScheduleExpression"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.ServiceNowSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.SourceConnectorProperties": {
            "additionalProperties": false,
            "properties": {
                "Marketo": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.MarketoSourceProperties"
                },
                "S3": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.S3SourceProperties"
                },
                "Salesforce": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.SalesforceSourceProperties"
                },
                "ServiceNow": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.ServiceNowSourceProperties"
                },
                "Zendesk": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.ZendeskSourceProperties"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.SourceFlowConfig": {
            "additionalProperties": false,
            "properties": {
                "ConnectorProfileName": {
                    "type": "string"
                },
                "ConnectorType": {
                    "type": "string"
                },
                "IncrementalPullConfig": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.IncrementalPullConfig"
                },
                "SourceConnectorProperties": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.SourceConnectorProperties"
                }
            },
            "required": [
                "ConnectorType",
                "SourceConnectorProperties"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.Task": {
            "additionalProperties": false,
            "properties": {
                "ConnectorOperator": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.ConnectorOperator"
                },
                "DestinationField": {
                    "type": "string"
                },
                "SourceFields": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TaskProperties": {
                    "items": {
                        "$ref": "#/definitions/AWS::CustomerProfiles::Integration.TaskPropertiesMap"
                    },
                    "type": "array"
                },
                "TaskType": {
                    "type": "string"
                }
            },
            "required": [
                "SourceFields",
                "TaskType"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.TaskPropertiesMap": {
            "additionalProperties": false,
            "properties": {
                "OperatorPropertyKey": {
                    "type": "string"
                },
                "Property": {
                    "type": "string"
                }
            },
            "required": [
                "OperatorPropertyKey",
                "Property"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.TriggerConfig": {
            "additionalProperties": false,
            "properties": {
                "TriggerProperties": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.TriggerProperties"
                },
                "TriggerType": {
                    "type": "string"
                }
            },
            "required": [
                "TriggerType"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.TriggerProperties": {
            "additionalProperties": false,
            "properties": {
                "Scheduled": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::Integration.ScheduledTriggerProperties"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::Integration.ZendeskSourceProperties": {
            "additionalProperties": false,
            "properties": {
                "Object": {
                    "type": "string"
                }
            },
            "required": [
                "Object"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::ObjectType": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllowProfileCreation": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "EncryptionKey": {
                            "type": "string"
                        },
                        "ExpirationDays": {
                            "type": "number"
                        },
                        "Fields": {
                            "items": {
                                "$ref": "#/definitions/AWS::CustomerProfiles::ObjectType.FieldMap"
                            },
                            "type": "array"
                        },
                        "Keys": {
                            "items": {
                                "$ref": "#/definitions/AWS::CustomerProfiles::ObjectType.KeyMap"
                            },
                            "type": "array"
                        },
                        "ObjectTypeName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CustomerProfiles::ObjectType"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CustomerProfiles::ObjectType.FieldMap": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "ObjectTypeField": {
                    "$ref": "#/definitions/AWS::CustomerProfiles::ObjectType.ObjectTypeField"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::ObjectType.KeyMap": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "ObjectTypeKeyList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CustomerProfiles::ObjectType.ObjectTypeKey"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::ObjectType.ObjectTypeField": {
            "additionalProperties": false,
            "properties": {
                "ContentType": {
                    "type": "string"
                },
                "Source": {
                    "type": "string"
                },
                "Target": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CustomerProfiles::ObjectType.ObjectTypeKey": {
            "additionalProperties": false,
            "properties": {
                "FieldNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "StandardIdentifiers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DAX::Cluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ClusterEndpointEncryptionType": {
                            "type": "string"
                        },
                        "ClusterName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IAMRoleARN": {
                            "type": "string"
                        },
                        "NodeType": {
                            "type": "string"
                        },
                        "NotificationTopicARN": {
                            "type": "string"
                        },
                        "ParameterGroupName": {
                            "type": "string"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "ReplicationFactor": {
                            "type": "number"
                        },
                        "SSESpecification": {
                            "$ref": "#/definitions/AWS::DAX::Cluster.SSESpecification"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetGroupName": {
                            "type": "string"
                        },
                        "Tags": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "IAMRoleARN",
                        "NodeType",
                        "ReplicationFactor"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DAX::Cluster"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DAX::Cluster.SSESpecification": {
            "additionalProperties": false,
            "properties": {
                "SSEEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::DAX::ParameterGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "ParameterGroupName": {
                            "type": "string"
                        },
                        "ParameterNameValues": {
                            "type": "object"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DAX::ParameterGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DAX::SubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "SubnetGroupName": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DAX::SubnetGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "PolicyDetails": {
                            "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.PolicyDetails"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DLM::LifecyclePolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.Action": {
            "additionalProperties": false,
            "properties": {
                "CrossRegionCopy": {
                    "items": {
                        "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.CrossRegionCopyAction"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "CrossRegionCopy",
                "Name"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.CreateRule": {
            "additionalProperties": false,
            "properties": {
                "CronExpression": {
                    "type": "string"
                },
                "Interval": {
                    "type": "number"
                },
                "IntervalUnit": {
                    "type": "string"
                },
                "Location": {
                    "type": "string"
                },
                "Times": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.CrossRegionCopyAction": {
            "additionalProperties": false,
            "properties": {
                "EncryptionConfiguration": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.EncryptionConfiguration"
                },
                "RetainRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.CrossRegionCopyRetainRule"
                },
                "Target": {
                    "type": "string"
                }
            },
            "required": [
                "EncryptionConfiguration",
                "Target"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.CrossRegionCopyRetainRule": {
            "additionalProperties": false,
            "properties": {
                "Interval": {
                    "type": "number"
                },
                "IntervalUnit": {
                    "type": "string"
                }
            },
            "required": [
                "Interval",
                "IntervalUnit"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.CrossRegionCopyRule": {
            "additionalProperties": false,
            "properties": {
                "CmkArn": {
                    "type": "string"
                },
                "CopyTags": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "RetainRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.CrossRegionCopyRetainRule"
                },
                "Target": {
                    "type": "string"
                },
                "TargetRegion": {
                    "type": "string"
                }
            },
            "required": [
                "Encrypted"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CmkArn": {
                    "type": "string"
                },
                "Encrypted": {
                    "type": "boolean"
                }
            },
            "required": [
                "Encrypted"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.EventParameters": {
            "additionalProperties": false,
            "properties": {
                "DescriptionRegex": {
                    "type": "string"
                },
                "EventType": {
                    "type": "string"
                },
                "SnapshotOwner": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "EventType",
                "SnapshotOwner"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.EventSource": {
            "additionalProperties": false,
            "properties": {
                "Parameters": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.EventParameters"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.FastRestoreRule": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZones": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Count": {
                    "type": "number"
                },
                "Interval": {
                    "type": "number"
                },
                "IntervalUnit": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.Parameters": {
            "additionalProperties": false,
            "properties": {
                "ExcludeBootVolume": {
                    "type": "boolean"
                },
                "NoReboot": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.PolicyDetails": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "items": {
                        "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.Action"
                    },
                    "type": "array"
                },
                "EventSource": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.EventSource"
                },
                "Parameters": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.Parameters"
                },
                "PolicyType": {
                    "type": "string"
                },
                "ResourceLocations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Schedules": {
                    "items": {
                        "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.Schedule"
                    },
                    "type": "array"
                },
                "TargetTags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.RetainRule": {
            "additionalProperties": false,
            "properties": {
                "Count": {
                    "type": "number"
                },
                "Interval": {
                    "type": "number"
                },
                "IntervalUnit": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.Schedule": {
            "additionalProperties": false,
            "properties": {
                "CopyTags": {
                    "type": "boolean"
                },
                "CreateRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.CreateRule"
                },
                "CrossRegionCopyRules": {
                    "items": {
                        "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.CrossRegionCopyRule"
                    },
                    "type": "array"
                },
                "FastRestoreRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.FastRestoreRule"
                },
                "Name": {
                    "type": "string"
                },
                "RetainRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.RetainRule"
                },
                "ShareRules": {
                    "items": {
                        "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.ShareRule"
                    },
                    "type": "array"
                },
                "TagsToAdd": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "VariableTags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.ShareRule": {
            "additionalProperties": false,
            "properties": {
                "TargetAccounts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "UnshareInterval": {
                    "type": "number"
                },
                "UnshareIntervalUnit": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Certificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateIdentifier": {
                            "type": "string"
                        },
                        "CertificatePem": {
                            "type": "string"
                        },
                        "CertificateWallet": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::Certificate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DMS::Endpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateArn": {
                            "type": "string"
                        },
                        "DatabaseName": {
                            "type": "string"
                        },
                        "DocDbSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.DocDbSettings"
                        },
                        "DynamoDbSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.DynamoDbSettings"
                        },
                        "ElasticsearchSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.ElasticsearchSettings"
                        },
                        "EndpointIdentifier": {
                            "type": "string"
                        },
                        "EndpointType": {
                            "type": "string"
                        },
                        "EngineName": {
                            "type": "string"
                        },
                        "ExtraConnectionAttributes": {
                            "type": "string"
                        },
                        "IbmDb2Settings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.IbmDb2Settings"
                        },
                        "KafkaSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.KafkaSettings"
                        },
                        "KinesisSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.KinesisSettings"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "MicrosoftSqlServerSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.MicrosoftSqlServerSettings"
                        },
                        "MongoDbSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.MongoDbSettings"
                        },
                        "MySqlSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.MySqlSettings"
                        },
                        "NeptuneSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.NeptuneSettings"
                        },
                        "OracleSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.OracleSettings"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "PostgreSqlSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.PostgreSqlSettings"
                        },
                        "RedshiftSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.RedshiftSettings"
                        },
                        "ResourceIdentifier": {
                            "type": "string"
                        },
                        "S3Settings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.S3Settings"
                        },
                        "ServerName": {
                            "type": "string"
                        },
                        "SslMode": {
                            "type": "string"
                        },
                        "SybaseSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.SybaseSettings"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Username": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "EndpointType",
                        "EngineName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::Endpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::Endpoint.DocDbSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.DynamoDbSettings": {
            "additionalProperties": false,
            "properties": {
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.ElasticsearchSettings": {
            "additionalProperties": false,
            "properties": {
                "EndpointUri": {
                    "type": "string"
                },
                "ErrorRetryDuration": {
                    "type": "number"
                },
                "FullLoadErrorPercentage": {
                    "type": "number"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.IbmDb2Settings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.KafkaSettings": {
            "additionalProperties": false,
            "properties": {
                "Broker": {
                    "type": "string"
                },
                "Topic": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.KinesisSettings": {
            "additionalProperties": false,
            "properties": {
                "MessageFormat": {
                    "type": "string"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                },
                "StreamArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.MicrosoftSqlServerSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.MongoDbSettings": {
            "additionalProperties": false,
            "properties": {
                "AuthMechanism": {
                    "type": "string"
                },
                "AuthSource": {
                    "type": "string"
                },
                "AuthType": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "DocsToInvestigate": {
                    "type": "string"
                },
                "ExtractDocId": {
                    "type": "string"
                },
                "NestingLevel": {
                    "type": "string"
                },
                "Password": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                },
                "ServerName": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.MySqlSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.NeptuneSettings": {
            "additionalProperties": false,
            "properties": {
                "ErrorRetryDuration": {
                    "type": "number"
                },
                "IamAuthEnabled": {
                    "type": "boolean"
                },
                "MaxFileSize": {
                    "type": "number"
                },
                "MaxRetryCount": {
                    "type": "number"
                },
                "S3BucketFolder": {
                    "type": "string"
                },
                "S3BucketName": {
                    "type": "string"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.OracleSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerOracleAsmAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerOracleAsmSecretId": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.PostgreSqlSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.RedshiftSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.S3Settings": {
            "additionalProperties": false,
            "properties": {
                "BucketFolder": {
                    "type": "string"
                },
                "BucketName": {
                    "type": "string"
                },
                "CompressionType": {
                    "type": "string"
                },
                "CsvDelimiter": {
                    "type": "string"
                },
                "CsvRowDelimiter": {
                    "type": "string"
                },
                "ExternalTableDefinition": {
                    "type": "string"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.SybaseSettings": {
            "additionalProperties": false,
            "properties": {
                "SecretsManagerAccessRoleArn": {
                    "type": "string"
                },
                "SecretsManagerSecretId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::EventSubscription": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Enabled": {
                            "type": "boolean"
                        },
                        "EventCategories": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SnsTopicArn": {
                            "type": "string"
                        },
                        "SourceIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SourceType": {
                            "type": "string"
                        },
                        "SubscriptionName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SnsTopicArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::EventSubscription"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::ReplicationInstance": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocatedStorage": {
                            "type": "number"
                        },
                        "AllowMajorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "MultiAZ": {
                            "type": "boolean"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "ReplicationInstanceClass": {
                            "type": "string"
                        },
                        "ReplicationInstanceIdentifier": {
                            "type": "string"
                        },
                        "ReplicationSubnetGroupIdentifier": {
                            "type": "string"
                        },
                        "ResourceIdentifier": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ReplicationInstanceClass"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::ReplicationInstance"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::ReplicationSubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ReplicationSubnetGroupDescription": {
                            "type": "string"
                        },
                        "ReplicationSubnetGroupIdentifier": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ReplicationSubnetGroupDescription",
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::ReplicationSubnetGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::ReplicationTask": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CdcStartPosition": {
                            "type": "string"
                        },
                        "CdcStartTime": {
                            "type": "number"
                        },
                        "CdcStopPosition": {
                            "type": "string"
                        },
                        "MigrationType": {
                            "type": "string"
                        },
                        "ReplicationInstanceArn": {
                            "type": "string"
                        },
                        "ReplicationTaskIdentifier": {
                            "type": "string"
                        },
                        "ReplicationTaskSettings": {
                            "type": "string"
                        },
                        "ResourceIdentifier": {
                            "type": "string"
                        },
                        "SourceEndpointArn": {
                            "type": "string"
                        },
                        "TableMappings": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TargetEndpointArn": {
                            "type": "string"
                        },
                        "TaskData": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MigrationType",
                        "ReplicationInstanceArn",
                        "SourceEndpointArn",
                        "TableMappings",
                        "TargetEndpointArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::ReplicationTask"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Format": {
                            "type": "string"
                        },
                        "FormatOptions": {
                            "$ref": "#/definitions/AWS::DataBrew::Dataset.FormatOptions"
                        },
                        "Input": {
                            "$ref": "#/definitions/AWS::DataBrew::Dataset.Input"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "PathOptions": {
                            "$ref": "#/definitions/AWS::DataBrew::Dataset.PathOptions"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Input",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataBrew::Dataset"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.CsvOptions": {
            "additionalProperties": false,
            "properties": {
                "Delimiter": {
                    "type": "string"
                },
                "HeaderRow": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.DataCatalogInputDefinition": {
            "additionalProperties": false,
            "properties": {
                "CatalogId": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "TableName": {
                    "type": "string"
                },
                "TempDirectory": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.DatabaseInputDefinition": {
            "additionalProperties": false,
            "properties": {
                "DatabaseTableName": {
                    "type": "string"
                },
                "GlueConnectionName": {
                    "type": "string"
                },
                "TempDirectory": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.DatasetParameter": {
            "additionalProperties": false,
            "properties": {
                "CreateColumn": {
                    "type": "boolean"
                },
                "DatetimeOptions": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.DatetimeOptions"
                },
                "Filter": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.FilterExpression"
                },
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Type"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.DatetimeOptions": {
            "additionalProperties": false,
            "properties": {
                "Format": {
                    "type": "string"
                },
                "LocaleCode": {
                    "type": "string"
                },
                "TimezoneOffset": {
                    "type": "string"
                }
            },
            "required": [
                "Format"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.ExcelOptions": {
            "additionalProperties": false,
            "properties": {
                "HeaderRow": {
                    "type": "boolean"
                },
                "SheetIndexes": {
                    "items": {
                        "type": "number"
                    },
                    "type": "array"
                },
                "SheetNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.FilesLimit": {
            "additionalProperties": false,
            "properties": {
                "MaxFiles": {
                    "type": "number"
                },
                "Order": {
                    "type": "string"
                },
                "OrderedBy": {
                    "type": "string"
                }
            },
            "required": [
                "MaxFiles"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.FilterExpression": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "ValuesMap": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataBrew::Dataset.FilterValue"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Expression",
                "ValuesMap"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.FilterValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                },
                "ValueReference": {
                    "type": "string"
                }
            },
            "required": [
                "Value",
                "ValueReference"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.FormatOptions": {
            "additionalProperties": false,
            "properties": {
                "Csv": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.CsvOptions"
                },
                "Excel": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.ExcelOptions"
                },
                "Json": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.JsonOptions"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.Input": {
            "additionalProperties": false,
            "properties": {
                "DataCatalogInputDefinition": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.DataCatalogInputDefinition"
                },
                "DatabaseInputDefinition": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.DatabaseInputDefinition"
                },
                "S3InputDefinition": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.JsonOptions": {
            "additionalProperties": false,
            "properties": {
                "MultiLine": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.PathOptions": {
            "additionalProperties": false,
            "properties": {
                "FilesLimit": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.FilesLimit"
                },
                "LastModifiedDateCondition": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.FilterExpression"
                },
                "Parameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataBrew::Dataset.PathParameter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Dataset.PathParameter": {
            "additionalProperties": false,
            "properties": {
                "DatasetParameter": {
                    "$ref": "#/definitions/AWS::DataBrew::Dataset.DatasetParameter"
                },
                "PathParameterName": {
                    "type": "string"
                }
            },
            "required": [
                "DatasetParameter",
                "PathParameterName"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Dataset.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Job": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DatasetName": {
                            "type": "string"
                        },
                        "EncryptionKeyArn": {
                            "type": "string"
                        },
                        "EncryptionMode": {
                            "type": "string"
                        },
                        "JobSample": {
                            "$ref": "#/definitions/AWS::DataBrew::Job.JobSample"
                        },
                        "LogSubscription": {
                            "type": "string"
                        },
                        "MaxCapacity": {
                            "type": "number"
                        },
                        "MaxRetries": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OutputLocation": {
                            "$ref": "#/definitions/AWS::DataBrew::Job.OutputLocation"
                        },
                        "Outputs": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataBrew::Job.Output"
                            },
                            "type": "array"
                        },
                        "ProjectName": {
                            "type": "string"
                        },
                        "Recipe": {
                            "type": "object"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Timeout": {
                            "type": "number"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name",
                        "RoleArn",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataBrew::Job"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Job.CsvOutputOptions": {
            "additionalProperties": false,
            "properties": {
                "Delimiter": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Job.JobSample": {
            "additionalProperties": false,
            "properties": {
                "Mode": {
                    "type": "string"
                },
                "Size": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Job.Output": {
            "additionalProperties": false,
            "properties": {
                "CompressionFormat": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                },
                "FormatOptions": {
                    "$ref": "#/definitions/AWS::DataBrew::Job.OutputFormatOptions"
                },
                "Location": {
                    "$ref": "#/definitions/AWS::DataBrew::Job.S3Location"
                },
                "Overwrite": {
                    "type": "boolean"
                },
                "PartitionColumns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Location"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Job.OutputFormatOptions": {
            "additionalProperties": false,
            "properties": {
                "Csv": {
                    "$ref": "#/definitions/AWS::DataBrew::Job.CsvOutputOptions"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Job.OutputLocation": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Job.Recipe": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Job.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Project": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DatasetName": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RecipeName": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Sample": {
                            "$ref": "#/definitions/AWS::DataBrew::Project.Sample"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DatasetName",
                        "Name",
                        "RecipeName",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataBrew::Project"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Project.Sample": {
            "additionalProperties": false,
            "properties": {
                "Size": {
                    "type": "number"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Recipe": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Steps": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataBrew::Recipe.RecipeStep"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "Steps"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataBrew::Recipe"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Recipe.Action": {
            "additionalProperties": false,
            "properties": {
                "Operation": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                }
            },
            "required": [
                "Operation"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Recipe.ConditionExpression": {
            "additionalProperties": false,
            "properties": {
                "Condition": {
                    "type": "string"
                },
                "TargetColumn": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Condition",
                "TargetColumn"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Recipe.DataCatalogInputDefinition": {
            "additionalProperties": false,
            "properties": {
                "CatalogId": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "TableName": {
                    "type": "string"
                },
                "TempDirectory": {
                    "$ref": "#/definitions/AWS::DataBrew::Recipe.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Recipe.RecipeParameters": {
            "additionalProperties": false,
            "properties": {
                "AggregateFunction": {
                    "type": "string"
                },
                "Base": {
                    "type": "string"
                },
                "CaseStatement": {
                    "type": "string"
                },
                "CategoryMap": {
                    "type": "string"
                },
                "CharsToRemove": {
                    "type": "string"
                },
                "CollapseConsecutiveWhitespace": {
                    "type": "string"
                },
                "ColumnDataType": {
                    "type": "string"
                },
                "ColumnRange": {
                    "type": "string"
                },
                "Count": {
                    "type": "string"
                },
                "CustomCharacters": {
                    "type": "string"
                },
                "CustomStopWords": {
                    "type": "string"
                },
                "CustomValue": {
                    "type": "string"
                },
                "DatasetsColumns": {
                    "type": "string"
                },
                "DateAddValue": {
                    "type": "string"
                },
                "DateTimeFormat": {
                    "type": "string"
                },
                "DateTimeParameters": {
                    "type": "string"
                },
                "DeleteOtherRows": {
                    "type": "string"
                },
                "Delimiter": {
                    "type": "string"
                },
                "EndPattern": {
                    "type": "string"
                },
                "EndPosition": {
                    "type": "string"
                },
                "EndValue": {
                    "type": "string"
                },
                "ExpandContractions": {
                    "type": "string"
                },
                "Exponent": {
                    "type": "string"
                },
                "FalseString": {
                    "type": "string"
                },
                "GroupByAggFunctionOptions": {
                    "type": "string"
                },
                "GroupByColumns": {
                    "type": "string"
                },
                "HiddenColumns": {
                    "type": "string"
                },
                "IgnoreCase": {
                    "type": "string"
                },
                "IncludeInSplit": {
                    "type": "string"
                },
                "Input": {
                    "type": "object"
                },
                "Interval": {
                    "type": "string"
                },
                "IsText": {
                    "type": "string"
                },
                "JoinKeys": {
                    "type": "string"
                },
                "JoinType": {
                    "type": "string"
                },
                "LeftColumns": {
                    "type": "string"
                },
                "Limit": {
                    "type": "string"
                },
                "LowerBound": {
                    "type": "string"
                },
                "MapType": {
                    "type": "string"
                },
                "ModeType": {
                    "type": "string"
                },
                "MultiLine": {
                    "type": "boolean"
                },
                "NumRows": {
                    "type": "string"
                },
                "NumRowsAfter": {
                    "type": "string"
                },
                "NumRowsBefore": {
                    "type": "string"
                },
                "OrderByColumn": {
                    "type": "string"
                },
                "OrderByColumns": {
                    "type": "string"
                },
                "Other": {
                    "type": "string"
                },
                "Pattern": {
                    "type": "string"
                },
                "PatternOption1": {
                    "type": "string"
                },
                "PatternOption2": {
                    "type": "string"
                },
                "PatternOptions": {
                    "type": "string"
                },
                "Period": {
                    "type": "string"
                },
                "Position": {
                    "type": "string"
                },
                "RemoveAllPunctuation": {
                    "type": "string"
                },
                "RemoveAllQuotes": {
                    "type": "string"
                },
                "RemoveAllWhitespace": {
                    "type": "string"
                },
                "RemoveCustomCharacters": {
                    "type": "string"
                },
                "RemoveCustomValue": {
                    "type": "string"
                },
                "RemoveLeadingAndTrailingPunctuation": {
                    "type": "string"
                },
                "RemoveLeadingAndTrailingQuotes": {
                    "type": "string"
                },
                "RemoveLeadingAndTrailingWhitespace": {
                    "type": "string"
                },
                "RemoveLetters": {
                    "type": "string"
                },
                "RemoveNumbers": {
                    "type": "string"
                },
                "RemoveSourceColumn": {
                    "type": "string"
                },
                "RemoveSpecialCharacters": {
                    "type": "string"
                },
                "RightColumns": {
                    "type": "string"
                },
                "SampleSize": {
                    "type": "string"
                },
                "SampleType": {
                    "type": "string"
                },
                "SecondInput": {
                    "type": "string"
                },
                "SecondaryInputs": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataBrew::Recipe.SecondaryInput"
                    },
                    "type": "array"
                },
                "SheetIndexes": {
                    "items": {
                        "type": "number"
                    },
                    "type": "array"
                },
                "SheetNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SourceColumn": {
                    "type": "string"
                },
                "SourceColumn1": {
                    "type": "string"
                },
                "SourceColumn2": {
                    "type": "string"
                },
                "SourceColumns": {
                    "type": "string"
                },
                "StartColumnIndex": {
                    "type": "string"
                },
                "StartPattern": {
                    "type": "string"
                },
                "StartPosition": {
                    "type": "string"
                },
                "StartValue": {
                    "type": "string"
                },
                "StemmingMode": {
                    "type": "string"
                },
                "StepCount": {
                    "type": "string"
                },
                "StepIndex": {
                    "type": "string"
                },
                "StopWordsMode": {
                    "type": "string"
                },
                "Strategy": {
                    "type": "string"
                },
                "TargetColumn": {
                    "type": "string"
                },
                "TargetColumnNames": {
                    "type": "string"
                },
                "TargetDateFormat": {
                    "type": "string"
                },
                "TargetIndex": {
                    "type": "string"
                },
                "TimeZone": {
                    "type": "string"
                },
                "TokenizerPattern": {
                    "type": "string"
                },
                "TrueString": {
                    "type": "string"
                },
                "UdfLang": {
                    "type": "string"
                },
                "Units": {
                    "type": "string"
                },
                "UnpivotColumn": {
                    "type": "string"
                },
                "UpperBound": {
                    "type": "string"
                },
                "UseNewDataFrame": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                },
                "Value1": {
                    "type": "string"
                },
                "Value2": {
                    "type": "string"
                },
                "ValueColumn": {
                    "type": "string"
                },
                "ViewFrame": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Recipe.RecipeStep": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::DataBrew::Recipe.Action"
                },
                "ConditionExpressions": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataBrew::Recipe.ConditionExpression"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Action"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Recipe.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::DataBrew::Recipe.SecondaryInput": {
            "additionalProperties": false,
            "properties": {
                "DataCatalogInputDefinition": {
                    "$ref": "#/definitions/AWS::DataBrew::Recipe.DataCatalogInputDefinition"
                },
                "S3InputDefinition": {
                    "$ref": "#/definitions/AWS::DataBrew::Recipe.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::DataBrew::Schedule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CronExpression": {
                            "type": "string"
                        },
                        "JobNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "CronExpression",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataBrew::Schedule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Activate": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ParameterObjects": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.ParameterObject"
                            },
                            "type": "array"
                        },
                        "ParameterValues": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.ParameterValue"
                            },
                            "type": "array"
                        },
                        "PipelineObjects": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.PipelineObject"
                            },
                            "type": "array"
                        },
                        "PipelineTags": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.PipelineTag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "ParameterObjects"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataPipeline::Pipeline"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.Field": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "RefValue": {
                    "type": "string"
                },
                "StringValue": {
                    "type": "string"
                }
            },
            "required": [
                "Key"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.ParameterAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "StringValue": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "StringValue"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.ParameterObject": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataPipeline::Pipeline.ParameterAttribute"
                    },
                    "type": "array"
                },
                "Id": {
                    "type": "string"
                }
            },
            "required": [
                "Attributes",
                "Id"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.ParameterValue": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "StringValue": {
                    "type": "string"
                }
            },
            "required": [
                "Id",
                "StringValue"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.PipelineObject": {
            "additionalProperties": false,
            "properties": {
                "Fields": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataPipeline::Pipeline.Field"
                    },
                    "type": "array"
                },
                "Id": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Fields",
                "Id",
                "Name"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.PipelineTag": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::DataSync::Agent": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActivationKey": {
                            "type": "string"
                        },
                        "AgentName": {
                            "type": "string"
                        },
                        "SecurityGroupArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcEndpointId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ActivationKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::Agent"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationEFS": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Ec2Config": {
                            "$ref": "#/definitions/AWS::DataSync::LocationEFS.Ec2Config"
                        },
                        "EfsFilesystemArn": {
                            "type": "string"
                        },
                        "Subdirectory": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Ec2Config",
                        "EfsFilesystemArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::LocationEFS"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationEFS.Ec2Config": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetArn": {
                    "type": "string"
                }
            },
            "required": [
                "SecurityGroupArns",
                "SubnetArn"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationFSxWindows": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Domain": {
                            "type": "string"
                        },
                        "FsxFilesystemArn": {
                            "type": "string"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "SecurityGroupArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Subdirectory": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "User": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FsxFilesystemArn",
                        "Password",
                        "SecurityGroupArns",
                        "User"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::LocationFSxWindows"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationNFS": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MountOptions": {
                            "$ref": "#/definitions/AWS::DataSync::LocationNFS.MountOptions"
                        },
                        "OnPremConfig": {
                            "$ref": "#/definitions/AWS::DataSync::LocationNFS.OnPremConfig"
                        },
                        "ServerHostname": {
                            "type": "string"
                        },
                        "Subdirectory": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "OnPremConfig",
                        "ServerHostname",
                        "Subdirectory"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::LocationNFS"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationNFS.MountOptions": {
            "additionalProperties": false,
            "properties": {
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DataSync::LocationNFS.OnPremConfig": {
            "additionalProperties": false,
            "properties": {
                "AgentArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "AgentArns"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationObjectStorage": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessKey": {
                            "type": "string"
                        },
                        "AgentArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "BucketName": {
                            "type": "string"
                        },
                        "SecretKey": {
                            "type": "string"
                        },
                        "ServerHostname": {
                            "type": "string"
                        },
                        "ServerPort": {
                            "type": "number"
                        },
                        "ServerProtocol": {
                            "type": "string"
                        },
                        "Subdirectory": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AgentArns",
                        "BucketName",
                        "ServerHostname"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::LocationObjectStorage"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationS3": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "S3BucketArn": {
                            "type": "string"
                        },
                        "S3Config": {
                            "$ref": "#/definitions/AWS::DataSync::LocationS3.S3Config"
                        },
                        "S3StorageClass": {
                            "type": "string"
                        },
                        "Subdirectory": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "S3BucketArn",
                        "S3Config"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::LocationS3"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationS3.S3Config": {
            "additionalProperties": false,
            "properties": {
                "BucketAccessRoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "BucketAccessRoleArn"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationSMB": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AgentArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Domain": {
                            "type": "string"
                        },
                        "MountOptions": {
                            "$ref": "#/definitions/AWS::DataSync::LocationSMB.MountOptions"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "ServerHostname": {
                            "type": "string"
                        },
                        "Subdirectory": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "User": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AgentArns",
                        "Password",
                        "ServerHostname",
                        "Subdirectory",
                        "User"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::LocationSMB"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::LocationSMB.MountOptions": {
            "additionalProperties": false,
            "properties": {
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DataSync::Task": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudWatchLogGroupArn": {
                            "type": "string"
                        },
                        "DestinationLocationArn": {
                            "type": "string"
                        },
                        "Excludes": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataSync::Task.FilterRule"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Options": {
                            "$ref": "#/definitions/AWS::DataSync::Task.Options"
                        },
                        "Schedule": {
                            "$ref": "#/definitions/AWS::DataSync::Task.TaskSchedule"
                        },
                        "SourceLocationArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DestinationLocationArn",
                        "SourceLocationArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataSync::Task"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataSync::Task.FilterRule": {
            "additionalProperties": false,
            "properties": {
                "FilterType": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DataSync::Task.Options": {
            "additionalProperties": false,
            "properties": {
                "Atime": {
                    "type": "string"
                },
                "BytesPerSecond": {
                    "type": "number"
                },
                "Gid": {
                    "type": "string"
                },
                "LogLevel": {
                    "type": "string"
                },
                "Mtime": {
                    "type": "string"
                },
                "OverwriteMode": {
                    "type": "string"
                },
                "PosixPermissions": {
                    "type": "string"
                },
                "PreserveDeletedFiles": {
                    "type": "string"
                },
                "PreserveDevices": {
                    "type": "string"
                },
                "TaskQueueing": {
                    "type": "string"
                },
                "TransferMode": {
                    "type": "string"
                },
                "Uid": {
                    "type": "string"
                },
                "VerifyMode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DataSync::Task.TaskSchedule": {
            "additionalProperties": false,
            "properties": {
                "ScheduleExpression": {
                    "type": "string"
                }
            },
            "required": [
                "ScheduleExpression"
            ],
            "type": "object"
        },
        "AWS::Detective::Graph": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Detective::Graph"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Detective::MemberInvitation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DisableEmailNotification": {
                            "type": "boolean"
                        },
                        "GraphArn": {
                            "type": "string"
                        },
                        "MemberEmailAddress": {
                            "type": "string"
                        },
                        "MemberId": {
                            "type": "string"
                        },
                        "Message": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GraphArn",
                        "MemberEmailAddress",
                        "MemberId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Detective::MemberInvitation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DevOpsGuru::NotificationChannel": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Config": {
                            "$ref": "#/definitions/AWS::DevOpsGuru::NotificationChannel.NotificationChannelConfig"
                        }
                    },
                    "required": [
                        "Config"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DevOpsGuru::NotificationChannel"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DevOpsGuru::NotificationChannel.NotificationChannelConfig": {
            "additionalProperties": false,
            "properties": {
                "Sns": {
                    "$ref": "#/definitions/AWS::DevOpsGuru::NotificationChannel.SnsChannelConfig"
                }
            },
            "type": "object"
        },
        "AWS::DevOpsGuru::NotificationChannel.SnsChannelConfig": {
            "additionalProperties": false,
            "properties": {
                "TopicArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DevOpsGuru::ResourceCollection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ResourceCollectionFilter": {
                            "$ref": "#/definitions/AWS::DevOpsGuru::ResourceCollection.ResourceCollectionFilter"
                        }
                    },
                    "required": [
                        "ResourceCollectionFilter"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DevOpsGuru::ResourceCollection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DevOpsGuru::ResourceCollection.CloudFormationCollectionFilter": {
            "additionalProperties": false,
            "properties": {
                "StackNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DevOpsGuru::ResourceCollection.ResourceCollectionFilter": {
            "additionalProperties": false,
            "properties": {
                "CloudFormation": {
                    "$ref": "#/definitions/AWS::DevOpsGuru::ResourceCollection.CloudFormationCollectionFilter"
                }
            },
            "type": "object"
        },
        "AWS::DirectoryService::MicrosoftAD": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CreateAlias": {
                            "type": "boolean"
                        },
                        "Edition": {
                            "type": "string"
                        },
                        "EnableSso": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "ShortName": {
                            "type": "string"
                        },
                        "VpcSettings": {
                            "$ref": "#/definitions/AWS::DirectoryService::MicrosoftAD.VpcSettings"
                        }
                    },
                    "required": [
                        "Name",
                        "Password",
                        "VpcSettings"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DirectoryService::MicrosoftAD"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DirectoryService::MicrosoftAD.VpcSettings": {
            "additionalProperties": false,
            "properties": {
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "VpcId": {
                    "type": "string"
                }
